/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Collections;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;

public class MultipartParser {
    public static final byte HTAB = 9;
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte SP = 32;
    public static final byte DASH = 45;
    private static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    public static final String CONTENT_TRANSFER_ENCODING = "content-transfer-encoding";

    public static ParseState beginParse(PartHandler handler, byte[] boundary, String requestCharset) {
        byte[] boundaryToken = new byte[boundary.length + BOUNDARY_PREFIX.length];
        System.arraycopy(BOUNDARY_PREFIX, 0, boundaryToken, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(boundary, 0, boundaryToken, BOUNDARY_PREFIX.length, boundary.length);
        return new ParseState(handler, requestCharset, boundaryToken);
    }

    public static class ParseState {
        private final PartHandler partHandler;
        private String requestCharset;
        private final byte[] boundary;
        private int state = 0;
        private int subState = Integer.MAX_VALUE;
        private ByteArrayOutputStream currentString = null;
        private String currentHeaderName = null;
        private CaseInsensitiveMap<String> headers;
        private Encoding encodingHandler;

        public ParseState(PartHandler partHandler, String requestCharset, byte[] boundary) {
            this.partHandler = partHandler;
            this.requestCharset = requestCharset;
            this.boundary = boundary;
        }

        public void setCharacterEncoding(String encoding) {
            this.requestCharset = encoding;
        }

        public void parse(ByteBuffer buffer) throws IOException {
            block7: while (buffer.hasRemaining()) {
                switch (this.state) {
                    case 0: {
                        this.preamble(buffer);
                        continue block7;
                    }
                    case 1: {
                        this.headerName(buffer);
                        continue block7;
                    }
                    case 2: {
                        this.headerValue(buffer);
                        continue block7;
                    }
                    case 3: {
                        this.entity(buffer);
                        continue block7;
                    }
                    case -1: {
                        return;
                    }
                }
                throw new IllegalStateException("" + this.state);
            }
        }

        private void preamble(ByteBuffer buffer) {
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (this.subState >= 0) {
                    if (this.subState == Integer.MAX_VALUE) {
                        this.subState = this.boundary[2] == b ? 2 : 0;
                    }
                    if (b == this.boundary[this.subState]) {
                        ++this.subState;
                        if (this.subState != this.boundary.length) continue;
                        this.subState = -1;
                        continue;
                    }
                    if (b == this.boundary[0]) {
                        this.subState = 1;
                        continue;
                    }
                    this.subState = 0;
                    continue;
                }
                if (this.subState == -1) {
                    if (b != 13) continue;
                    this.subState = -2;
                    continue;
                }
                if (this.subState != -2) continue;
                if (b == 10) {
                    this.subState = 0;
                    this.state = 1;
                    this.headers = new CaseInsensitiveMap();
                    return;
                }
                this.subState = -1;
            }
        }

        private void headerName(ByteBuffer buffer) throws MalformedMessageException, UnsupportedEncodingException {
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (b == 58) {
                    if (this.currentString == null || this.subState != 0) {
                        throw new MalformedMessageException();
                    }
                    this.currentHeaderName = new String(this.currentString.toByteArray(), this.requestCharset);
                    this.currentString.reset();
                    this.subState = 0;
                    this.state = 2;
                    return;
                }
                if (b == 13) {
                    if (this.currentString != null) {
                        throw new MalformedMessageException();
                    }
                    this.subState = 1;
                    continue;
                }
                if (b == 10) {
                    if (this.currentString != null || this.subState != 1) {
                        throw new MalformedMessageException();
                    }
                    this.state = 3;
                    this.subState = 0;
                    this.partHandler.beginPart(this.headers);
                    String encoding = (String)this.headers.getFirst((Object)MultipartParser.CONTENT_TRANSFER_ENCODING);
                    this.encodingHandler = encoding == null ? new IdentityEncoding() : (encoding.equalsIgnoreCase("base64") ? new Base64Encoding() : (encoding.equalsIgnoreCase("quoted-printable") ? new QuotedPrintableEncoding() : new IdentityEncoding()));
                    this.headers = null;
                    return;
                }
                if (this.subState != 0) {
                    throw new MalformedMessageException();
                }
                if (this.currentString == null) {
                    this.currentString = new ByteArrayOutputStream();
                }
                this.currentString.write(b);
            }
        }

        private void headerValue(ByteBuffer buffer) throws MalformedMessageException, UnsupportedEncodingException {
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (this.subState == 2) {
                    if (b == 13) {
                        this.headers.put((Object)this.currentHeaderName.trim(), Collections.singletonList(new String(this.currentString.toByteArray(), this.requestCharset).trim()));
                        this.state = 1;
                        this.subState = 1;
                        this.currentString = null;
                        return;
                    }
                    if (b == 32 || b == 9) {
                        this.currentString.write(b);
                        this.subState = 0;
                        continue;
                    }
                    this.headers.put((Object)this.currentHeaderName.trim(), Collections.singletonList(new String(this.currentString.toByteArray(), this.requestCharset).trim()));
                    this.state = 1;
                    this.subState = 0;
                    this.currentString = new ByteArrayOutputStream();
                    this.currentString.write(b);
                    return;
                }
                if (b == 13) {
                    this.subState = 1;
                    continue;
                }
                if (b == 10) {
                    if (this.subState != 1) {
                        throw new MalformedMessageException();
                    }
                    this.subState = 2;
                    continue;
                }
                if (this.subState != 0) {
                    throw new MalformedMessageException();
                }
                this.currentString.write(b);
            }
        }

        private void entity(ByteBuffer buffer) throws IOException {
            int startingSubState = this.subState;
            int pos = buffer.position();
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (this.subState >= 0) {
                    if (b == this.boundary[this.subState]) {
                        ++this.subState;
                        if (this.subState != this.boundary.length) continue;
                        startingSubState = 0;
                        ByteBuffer retBuffer = buffer.duplicate();
                        retBuffer.position(pos);
                        retBuffer.limit(Math.max(buffer.position() - this.boundary.length, 0));
                        this.encodingHandler.handle(this.partHandler, retBuffer);
                        this.partHandler.endPart();
                        this.subState = -1;
                        continue;
                    }
                    if (b == this.boundary[0]) {
                        if (startingSubState > 0) {
                            this.encodingHandler.handle(this.partHandler, ByteBuffer.wrap(this.boundary, 0, startingSubState));
                            startingSubState = 0;
                        }
                        this.subState = 1;
                        continue;
                    }
                    if (startingSubState > 0) {
                        this.encodingHandler.handle(this.partHandler, ByteBuffer.wrap(this.boundary, 0, startingSubState));
                        startingSubState = 0;
                    }
                    this.subState = 0;
                    continue;
                }
                if (this.subState == -1) {
                    if (b == 13) {
                        this.subState = -2;
                        continue;
                    }
                    if (b != 45) continue;
                    this.subState = -3;
                    continue;
                }
                if (this.subState == -2) {
                    if (b == 10) {
                        this.subState = 0;
                        this.state = 1;
                        this.headers = new CaseInsensitiveMap();
                        return;
                    }
                    if (b == 45) {
                        this.subState = -3;
                        continue;
                    }
                    this.subState = -1;
                    continue;
                }
                if (this.subState != -3) continue;
                if (b == 45) {
                    this.state = -1;
                    return;
                }
                this.subState = -1;
            }
            ByteBuffer retBuffer = buffer.duplicate();
            retBuffer.position(pos);
            if (this.subState == 0) {
                this.encodingHandler.handle(this.partHandler, retBuffer);
            } else if (retBuffer.remaining() > this.subState && this.subState > 0) {
                retBuffer.limit(retBuffer.limit() - this.subState);
                this.encodingHandler.handle(this.partHandler, retBuffer);
            }
        }

        public boolean isComplete() {
            return this.state == -1;
        }
    }

    public static interface PartHandler {
        public void beginPart(CaseInsensitiveMap<String> var1);

        public void data(ByteBuffer var1) throws IOException;

        public void endPart();
    }

    public static class MalformedMessageException
    extends RuntimeException {
    }

    private static class QuotedPrintableEncoding
    implements Encoding {
        boolean equalsSeen;
        byte firstCharacter;

        private QuotedPrintableEncoding() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(PartHandler handler, ByteBuffer rawData) throws IOException {
            boolean equalsSeen = this.equalsSeen;
            byte firstCharacter = this.firstCharacter;
            ByteBuffer buf = ByteBuffer.allocate(1024);
            try {
                while (rawData.hasRemaining()) {
                    byte b = rawData.get();
                    if (equalsSeen) {
                        if (firstCharacter == 0) {
                            if (b == 10 || b == 13) {
                                equalsSeen = false;
                                continue;
                            }
                            firstCharacter = b;
                            continue;
                        }
                        int result = Character.digit((char)firstCharacter, 16);
                        result <<= 4;
                        buf.put((byte)(result += Character.digit((char)b, 16)));
                        equalsSeen = false;
                        firstCharacter = 0;
                        continue;
                    }
                    if (b == 61) {
                        equalsSeen = true;
                        continue;
                    }
                    buf.put(b);
                    if (buf.hasRemaining()) continue;
                    buf.flip();
                    handler.data(buf);
                    buf.clear();
                }
                buf.flip();
                handler.data(buf);
            }
            finally {
                this.equalsSeen = equalsSeen;
                this.firstCharacter = firstCharacter;
            }
        }
    }

    private static class Base64Encoding
    implements Encoding {
        private final Base64.Decoder decoder = Base64.getMimeDecoder();

        private Base64Encoding() {
        }

        @Override
        public void handle(PartHandler handler, ByteBuffer rawData) throws IOException {
            try {
                ByteBuffer buf = this.decoder.decode(rawData);
                handler.data(buf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class IdentityEncoding
    implements Encoding {
        private IdentityEncoding() {
        }

        @Override
        public void handle(PartHandler handler, ByteBuffer rawData) throws IOException {
            handler.data(rawData);
            rawData.clear();
        }
    }

    private static interface Encoding {
        public void handle(PartHandler var1, ByteBuffer var2) throws IOException;
    }
}

