/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.dialect.function.json.JsonObjectArgumentsValidator;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionKind;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.JsonNullBehavior;
import org.hibernate.type.spi.TypeConfiguration;

public class JsonObjectFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    protected final boolean colonSyntax;

    public JsonObjectFunction(TypeConfiguration typeConfiguration, boolean colonSyntax) {
        super("json_object", FunctionKind.NORMAL, new JsonObjectArgumentsValidator(), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(String.class, 3001)), null);
        this.colonSyntax = colonSyntax;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        sqlAppender.appendSql("json_object");
        int separator = 40;
        if (sqlAstArguments.isEmpty()) {
            sqlAppender.appendSql((char)separator);
        } else {
            int argumentsCount;
            JsonNullBehavior nullBehavior;
            if ((sqlAstArguments.size() & 1) == 1) {
                nullBehavior = (JsonNullBehavior)sqlAstArguments.get(sqlAstArguments.size() - 1);
                argumentsCount = sqlAstArguments.size() - 1;
            } else {
                nullBehavior = JsonNullBehavior.NULL;
                argumentsCount = sqlAstArguments.size();
            }
            for (int i = 0; i < argumentsCount; i += 2) {
                sqlAppender.appendSql((char)separator);
                SqlAstNode key = sqlAstArguments.get(i);
                SqlAstNode value = sqlAstArguments.get(i + 1);
                key.accept(walker);
                if (this.colonSyntax) {
                    sqlAppender.appendSql(':');
                } else {
                    sqlAppender.appendSql(" value ");
                }
                this.renderValue(sqlAppender, value, walker);
                separator = 44;
            }
            if (nullBehavior == JsonNullBehavior.ABSENT) {
                sqlAppender.appendSql(" absent on null");
            }
        }
        sqlAppender.appendSql(')');
    }

    protected void renderValue(SqlAppender sqlAppender, SqlAstNode value, SqlAstTranslator<?> walker) {
        value.accept(walker);
    }
}

