/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.spi;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.criteria.Nulls;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.hibernate.CacheMode;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.FlushMode;
import org.hibernate.Incubating;
import org.hibernate.Interceptor;
import org.hibernate.Internal;
import org.hibernate.LockOptions;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.annotations.CacheLayout;
import org.hibernate.boot.SchemaAutoTooling;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.cache.spi.TimestampsCacheFactory;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.context.spi.TenantSchemaMapper;
import org.hibernate.internal.BaselineSessionEventsListenerBuilder;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.spi.QueryEngineOptions;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.type.TimeZoneStorageStrategy;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.ObjectJavaType;
import org.hibernate.type.format.FormatMapper;

public interface SessionFactoryOptions
extends QueryEngineOptions {
    @Override
    public String getUuid();

    public StandardServiceRegistry getServiceRegistry();

    public Object getBeanManagerReference();

    public Object getValidatorFactoryReference();

    @Override
    public JpaCompliance getJpaCompliance();

    public boolean isJpaBootstrap();

    @Deprecated(since="7.0", forRemoval=true)
    default public boolean isAllowRefreshDetachedEntity() {
        DeprecationLogger.DEPRECATION_LOGGER.deprecatedRefreshLockDetachedEntity();
        return false;
    }

    @Override
    public String getSessionFactoryName();

    public Boolean isSessionFactoryNameAlsoJndiName();

    public boolean isStatisticsEnabled();

    public Interceptor getInterceptor();

    public Supplier<? extends Interceptor> getStatelessInterceptorImplementorSupplier();

    public StatementInspector getStatementInspector();

    public SessionFactoryObserver[] getSessionFactoryObservers();

    @Deprecated(since="7.0", forRemoval=true)
    public BaselineSessionEventsListenerBuilder getBaselineSessionEventsListenerBuilder();

    default public SessionEventListener[] buildSessionEventListeners() {
        return this.getBaselineSessionEventsListenerBuilder().buildBaseline();
    }

    public boolean isIdentifierRollbackEnabled();

    public boolean isCheckNullability();

    @Internal
    public void setCheckNullability(boolean var1);

    public boolean isInitializeLazyStateOutsideTransactionsEnabled();

    @Deprecated(since="7.0", forRemoval=true)
    public TempTableDdlTransactionHandling getTempTableDdlTransactionHandling();

    @Deprecated(since="7", forRemoval=true)
    public boolean isDelayBatchFetchLoaderCreationsEnabled();

    public int getDefaultBatchFetchSize();

    public Integer getMaximumFetchDepth();

    public boolean isSubselectFetchEnabled();

    public Nulls getDefaultNullPrecedence();

    public boolean isOrderUpdatesEnabled();

    public boolean isOrderInsertsEnabled();

    public boolean isMultiTenancyEnabled();

    public CurrentTenantIdentifierResolver<Object> getCurrentTenantIdentifierResolver();

    public TenantSchemaMapper<Object> getTenantSchemaMapper();

    public boolean isJtaTrackByThread();

    public boolean isNamedQueryStartupCheckingEnabled();

    public boolean isSecondLevelCacheEnabled();

    public boolean isQueryCacheEnabled();

    @Incubating
    public CacheLayout getQueryCacheLayout();

    public TimestampsCacheFactory getTimestampsCacheFactory();

    public String getCacheRegionPrefix();

    public boolean isMinimalPutsEnabled();

    public boolean isStructuredCacheEntriesEnabled();

    public boolean isDirectReferenceCacheEntriesEnabled();

    public boolean isAutoEvictCollectionCache();

    @Deprecated(since="7.0", forRemoval=true)
    public SchemaAutoTooling getSchemaAutoTooling();

    public int getJdbcBatchSize();

    public boolean isScrollableResultSetsEnabled();

    public boolean isGetGeneratedKeysEnabled();

    public Integer getJdbcFetchSize();

    public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode();

    public boolean doesConnectionProviderDisableAutoCommit();

    public boolean isCommentsEnabled();

    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy();

    public EntityNameResolver[] getEntityNameResolvers();

    public EntityNotFoundDelegate getEntityNotFoundDelegate();

    public boolean isFlushBeforeCompletionEnabled();

    public boolean isAutoCloseSessionEnabled();

    public boolean isJtaTransactionAccessEnabled();

    public boolean isPreferUserTransaction();

    public boolean isAllowOutOfTransactionUpdateOperations();

    @Deprecated(since="7.0", forRemoval=true)
    public boolean isReleaseResourcesOnCloseEnabled();

    public TimeZone getJdbcTimeZone();

    default public boolean isCriteriaCopyTreeEnabled() {
        return false;
    }

    default public boolean isCriteriaPlanCacheEnabled() {
        return false;
    }

    default public boolean getNativeJdbcParametersIgnored() {
        return false;
    }

    public boolean isFailOnPaginationOverCollectionFetchEnabled();

    default public String getDefaultCatalog() {
        return null;
    }

    default public String getDefaultSchema() {
        return null;
    }

    default public boolean inClauseParameterPaddingEnabled() {
        return false;
    }

    public int getQueryStatisticsMaxSize();

    public boolean areJPACallbacksEnabled();

    public boolean isUseOfJdbcNamedParametersEnabled();

    default public boolean isCollectionsInDefaultFetchGroupEnabled() {
        return false;
    }

    public boolean isUnownedAssociationTransientCheck();

    @Incubating
    public int getPreferredSqlTypeCodeForBoolean();

    @Incubating
    public int getPreferredSqlTypeCodeForDuration();

    @Incubating
    public int getPreferredSqlTypeCodeForUuid();

    @Incubating
    public int getPreferredSqlTypeCodeForInstant();

    @Incubating
    public int getPreferredSqlTypeCodeForArray();

    @Incubating
    public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy();

    public boolean isPreferJavaTimeJdbcTypesEnabled();

    public boolean isPreferNativeEnumTypesEnabled();

    @Incubating
    public FormatMapper getJsonFormatMapper();

    @Incubating
    public FormatMapper getXmlFormatMapper();

    @Incubating
    public boolean isXmlFormatMapperLegacyFormatEnabled();

    @Incubating
    default public JavaType<Object> getDefaultTenantIdentifierJavaType() {
        return ObjectJavaType.INSTANCE;
    }

    public boolean isPassProcedureParameterNames();

    public boolean isPreferJdbcDatetimeTypesInNativeQueriesEnabled();

    public CacheStoreMode getCacheStoreMode(Map<String, Object> var1);

    public CacheRetrieveMode getCacheRetrieveMode(Map<String, Object> var1);

    public CacheMode getInitialSessionCacheMode();

    public FlushMode getInitialSessionFlushMode();

    public LockOptions getDefaultLockOptions();

    public Map<String, Object> getDefaultSessionProperties();
}

