/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.external;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.array.Arrays2;
import org.wildfly.security.sasl.WildFlySasl;
import org.wildfly.security.sasl.external.ExternalSaslServer;

public final class ExternalSaslServerFactory
implements SaslServerFactory {
    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Object skipCertVerificationProp = props == null ? null : props.get("org.wildfly.security.sasl.skip-certificate-verification");
        String skipCertVerification = skipCertVerificationProp instanceof String ? (String)skipCertVerificationProp : null;
        return mechanism.equals("EXTERNAL") && this.getMechanismNames(props, false).length != 0 ? new ExternalSaslServer(cbh, Boolean.parseBoolean(skipCertVerification)) : null;
    }

    private String[] getMechanismNames(Map<String, ?> props, boolean query) {
        if (props == null) {
            return (String[])Arrays2.of((Object[])new String[]{"EXTERNAL"});
        }
        if ("true".equals(props.get("wildfly.sasl.mechanism-query-all")) && query) {
            return (String[])Arrays2.of((Object[])new String[]{"EXTERNAL"});
        }
        if ("true".equals(props.get("javax.security.sasl.policy.forward")) || "true".equals(props.get("javax.security.sasl.policy.credentials")) || "true".equals(props.get("javax.security.sasl.policy.noanonymous"))) {
            return WildFlySasl.NO_NAMES;
        }
        return (String[])Arrays2.of((Object[])new String[]{"EXTERNAL"});
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return this.getMechanismNames(props, true);
    }
}

