/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.sequence;

import org.hibernate.MappingException;
import org.hibernate.dialect.sequence.SequenceSupport;

public class TiDBSequenceSupport
implements SequenceSupport {
    public static final SequenceSupport INSTANCE = new TiDBSequenceSupport();

    public String getSelectSequenceNextValString(String sequenceName) {
        return "nextval(" + sequenceName + ")";
    }

    public String getSelectSequencePreviousValString(String sequenceName) throws MappingException {
        return "lastval(" + sequenceName + ")";
    }

    public boolean sometimesNeedsStartingValue() {
        return true;
    }

    public String getCreateSequenceString(String sequenceName, int initialValue, int incrementSize) throws MappingException {
        return this.getCreateSequenceString(sequenceName) + " start with " + initialValue + " increment by " + incrementSize + this.startingValue(initialValue, incrementSize);
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }
}

