/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.maven.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import java.io.Serializable;
import java.util.Objects;

@Deprecated(forRemoval=true)
public class ArtifactCoords
implements io.quarkus.maven.dependency.ArtifactCoords,
Serializable {
    protected final String groupId;
    protected final String artifactId;
    protected final String classifier;
    protected final String type;
    protected final String version;
    protected transient ArtifactKey key;

    public static ArtifactCoords fromString(String str) {
        return new ArtifactCoords(ArtifactCoords.split(str, new String[5]));
    }

    public static ArtifactCoords pom(String groupId, String artifactId, String version) {
        return new ArtifactCoords(groupId, artifactId, "", "pom", version);
    }

    protected static String[] split(String str, String[] parts) {
        int versionSep = str.lastIndexOf(58);
        if (versionSep <= 0 || versionSep == str.length() - 1) {
            throw new IllegalArgumentException("One of type, version or separating them ':' is missing from '" + str + "'");
        }
        parts[4] = str.substring(versionSep + 1);
        return GACT.split(str, parts, versionSep);
    }

    protected ArtifactCoords(String[] parts) {
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.classifier = parts[2];
        this.type = parts[3] == null ? "jar" : parts[3];
        this.version = parts[4];
    }

    public ArtifactCoords(ArtifactKey key, String version) {
        this.key = key;
        this.groupId = key.getGroupId();
        this.artifactId = key.getArtifactId();
        this.classifier = key.getClassifier();
        this.type = key.getType();
        this.version = version;
    }

    public ArtifactCoords(String groupId, String artifactId, String version) {
        this(groupId, artifactId, "", "jar", version);
    }

    public ArtifactCoords(String groupId, String artifactId, String type, String version) {
        this(groupId, artifactId, "", type, version);
    }

    public ArtifactCoords(String groupId, String artifactId, String classifier, String type, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier == null ? "" : classifier;
        this.type = type == null ? "jar" : type;
        this.version = version;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ArtifactKey getKey() {
        return this.key == null ? (this.key = new ArtifactKey(this.groupId, this.artifactId, this.classifier, this.type)) : this.key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof io.quarkus.maven.dependency.ArtifactCoords)) {
            return false;
        }
        io.quarkus.maven.dependency.ArtifactCoords that = (io.quarkus.maven.dependency.ArtifactCoords)o;
        return Objects.equals(this.groupId, that.getGroupId()) && Objects.equals(this.artifactId, that.getArtifactId()) && Objects.equals(this.classifier, that.getClassifier()) && Objects.equals(this.type, that.getType()) && Objects.equals(this.version, that.getVersion());
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.classifier, this.type, this.version);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.append(buf);
        return buf.toString();
    }

    protected StringBuilder append(StringBuilder buf) {
        buf.append(this.groupId).append(':').append(this.artifactId).append(':');
        if (this.classifier != null && !this.classifier.isEmpty()) {
            buf.append(this.classifier);
        }
        return buf.append(':').append(this.type).append(':').append(this.version);
    }

    @Override
    public String toCompactCoords() {
        StringBuilder b = new StringBuilder();
        b.append(this.getGroupId()).append(':').append(this.getArtifactId()).append(':');
        if (!this.getClassifier().isEmpty()) {
            b.append(this.getClassifier()).append(':');
        }
        if (!"jar".equals(this.getType())) {
            b.append(this.getType()).append(':');
        }
        b.append(this.getVersion());
        return b.toString();
    }
}

