/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.TokenIntrospectionTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.utils.JsonUtils;

public abstract class AbstractUserRoleMappingMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
UserInfoTokenMapper,
TokenIntrospectionTokenMapper {
    private static final Pattern CLIENT_ID_PATTERN = Pattern.compile(Pattern.quote("${client_id}"));

    public int getPriority() {
        return 40;
    }

    protected static void setClaim(IDToken token, ProtocolMapperModel mappingModel, Set<String> rolesToAdd, String clientId, String prefix) {
        Set<String> realmRoleNames = prefix != null && !prefix.isEmpty() ? rolesToAdd.stream().map(roleName -> prefix + roleName).collect(Collectors.toSet()) : rolesToAdd;
        AbstractUserRoleMappingMapper.mapClaim(token, mappingModel, realmRoleNames, clientId);
    }

    private static void mapClaim(IDToken token, ProtocolMapperModel mappingModel, Object attributeValue, String clientId) {
        List split;
        Matcher matcher;
        if ((attributeValue = OIDCAttributeMapperHelper.mapAttributeValue(mappingModel, attributeValue)) == null) {
            return;
        }
        String protocolClaim = (String)mappingModel.getConfig().get("claim.name");
        if (protocolClaim == null) {
            return;
        }
        if (clientId != null && (matcher = CLIENT_ID_PATTERN.matcher(protocolClaim)).find()) {
            protocolClaim = matcher.replaceAll(Matcher.quoteReplacement(clientId.replace("\\", "\\\\").replace(".", "\\.")));
        }
        if (AbstractUserRoleMappingMapper.checkAccessToken(token, split = JsonUtils.splitClaimPath((String)protocolClaim), attributeValue)) {
            return;
        }
        int length = split.size();
        int i = 0;
        Map jsonObject = token.getOtherClaims();
        for (String component : split) {
            if (++i == length) {
                Object last = jsonObject.get(component);
                if (last instanceof Collection && attributeValue instanceof Collection) {
                    ((Collection)last).addAll((Collection)attributeValue);
                    continue;
                }
                jsonObject.put(component, attributeValue);
                continue;
            }
            HashMap nested = (HashMap)jsonObject.get(component);
            if (nested == null) {
                nested = new HashMap();
                jsonObject.put(component, nested);
            }
            jsonObject = nested;
        }
    }

    private static boolean checkAccessToken(IDToken idToken, List<String> path, Object attributeValue) {
        if (!(idToken instanceof AccessToken)) {
            return false;
        }
        if (!(attributeValue instanceof Collection)) {
            return false;
        }
        Collection roles = (Collection)attributeValue;
        AccessToken token = (AccessToken)idToken;
        AccessToken.Access access = null;
        if (path.size() == 2 && "realm_access".equals(path.get(0)) && "roles".equals(path.get(1))) {
            access = token.getRealmAccess();
            if (access == null) {
                access = new AccessToken.Access();
                token.setRealmAccess(access);
            }
        } else if (path.size() == 3 && "resource_access".equals(path.get(0)) && "roles".equals(path.get(2))) {
            String clientId = path.get(1);
            access = token.addAccess(clientId);
        } else {
            return false;
        }
        for (String role : roles) {
            access.addRole(role);
        }
        return true;
    }
}

