/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.intops.object;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.util.concurrent.BlockingManager;

public class PeekOperation<S>
implements IntermediateOperation<S, Stream<S>, S, Stream<S>> {
    private final Consumer<? super S> consumer;
    private BlockingManager blockingManager;

    public PeekOperation(Consumer<? super S> consumer) {
        this.consumer = consumer;
    }

    @Override
    public Stream<S> perform(Stream<S> stream) {
        return stream.peek(this.consumer);
    }

    public Consumer<? super S> getConsumer() {
        return this.consumer;
    }

    @Override
    public void handleInjection(ComponentRegistry registry) {
        this.blockingManager = registry.getBlockingManager().running();
        if (this.consumer instanceof CacheAware) {
            ((CacheAware)((Object)this.consumer)).injectCache(registry.getCache().running());
        } else {
            registry.wireDependencies(this.consumer);
        }
    }

    @Override
    public Flowable<S> mapFlowable(Flowable<S> input) {
        return input.concatMapSingle(t -> Single.fromCompletionStage(this.blockingManager.supplyBlocking(() -> {
            this.consumer.accept(t);
            return t;
        }, "publisher-peek")));
    }
}

