/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.protostream.builder;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.api.protostream.builder.MessageBuilder;

public final class ProtoBuf {
    private final List<MessageBuilder> messages = new ArrayList<MessageBuilder>();
    private String packageName;

    public static ProtoBuf builder() {
        return new ProtoBuf();
    }

    private ProtoBuf() {
    }

    public ProtoBuf packageName(String packageName) {
        this.packageName = packageName;
        return this;
    }

    public MessageBuilder message(String name) {
        MessageBuilder message = new MessageBuilder(this, name);
        this.messages.add(message);
        return message;
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        builder.append("syntax = \"proto2\";");
        ProtoBuf.blankLine(builder);
        if (this.packageName != null && !this.packageName.isBlank()) {
            builder.append("package ");
            builder.append(this.packageName);
            builder.append(";");
            ProtoBuf.blankLine(builder);
        }
        for (MessageBuilder message : this.messages) {
            message.write(builder);
        }
        return builder.toString();
    }

    static void blankLine(StringBuilder builder) {
        builder.append("\n\n");
    }

    static void tab(StringBuilder builder) {
        builder.append("  ");
    }
}

