/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteObject;
import org.hibernate.sql.ast.tree.cte.CteStatement;

public abstract class AbstractStatement
implements Statement,
CteContainer {
    private final Map<String, CteStatement> cteStatements;
    private final Map<String, CteObject> cteObjects;

    public AbstractStatement(CteContainer cteContainer) {
        if (cteContainer == null) {
            this.cteStatements = new LinkedHashMap<String, CteStatement>();
            this.cteObjects = new LinkedHashMap<String, CteObject>();
        } else {
            this.cteStatements = cteContainer.getCteStatements();
            this.cteObjects = cteContainer.getCteObjects();
        }
    }

    @Override
    public Map<String, CteStatement> getCteStatements() {
        return this.cteStatements;
    }

    @Override
    public CteStatement getCteStatement(String cteLabel) {
        return this.cteStatements.get(cteLabel);
    }

    @Override
    public void addCteStatement(CteStatement cteStatement) {
        if (this.cteStatements.putIfAbsent(cteStatement.getCteTable().getTableExpression(), cteStatement) != null) {
            throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getTableExpression() + " already exists");
        }
    }

    @Override
    public Map<String, CteObject> getCteObjects() {
        return this.cteObjects;
    }

    @Override
    public CteObject getCteObject(String cteObjectName) {
        return this.cteObjects.get(cteObjectName);
    }

    @Override
    public void addCteObject(CteObject cteObject) {
        if (this.cteObjects.putIfAbsent(cteObject.getName(), cteObject) != null) {
            throw new IllegalArgumentException("A CTE object with the name " + cteObject.getName() + " already exists");
        }
    }
}

