/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mlkem;

import java.util.Arrays;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.util.Util;

public class MLKEMPublicKeyParameters
extends MLKEMKeyParameters {
    final byte[] t;
    final byte[] rho;

    static byte[] getEncoded(byte[] t, byte[] rho) {
        return Util.concatenate(t, rho);
    }

    public MLKEMPublicKeyParameters(MLKEMParameters params, byte[] t, byte[] rho) {
        super(false, params);
        this.t = Util.clone(t);
        this.rho = Util.clone(rho);
    }

    public MLKEMPublicKeyParameters(MLKEMParameters params, byte[] encoding) {
        super(false, params);
        this.t = Arrays.copyOfRange(encoding, 0, encoding.length - 32);
        this.rho = Arrays.copyOfRange(encoding, encoding.length - 32, encoding.length);
    }

    public byte[] getEncoded() {
        return MLKEMPublicKeyParameters.getEncoded(this.t, this.rho);
    }

    public byte[] getRho() {
        return Util.clone(this.rho);
    }

    public byte[] getT() {
        return Util.clone(this.t);
    }
}

