/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.definitions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.scripting.definitions.LazyScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012J\u0014\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012J\b\u0010\u0016\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptDefinitionProvider;", "Lorg/jetbrains/kotlin/scripting/definitions/LazyScriptDefinitionProvider;", "<init>", "()V", "definitionsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "definitionsFromSources", "", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "definitions", "defaultDefinition", "currentDefinitions", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "setScriptDefinitions", "", "newDefinitions", "", "setScriptDefinitionsSources", "newSources", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionsSource;", "getDefaultDefinition", "kotlin-scripting-compiler"})
@SourceDebugExtension(value={"SMAP\nCliScriptDefinitionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliScriptDefinitionProvider.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptDefinitionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n3193#2,10:50\n*S KotlinDebug\n*F\n+ 1 CliScriptDefinitionProvider.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptDefinitionProvider\n*L\n29#1:50,10\n*E\n"})
public class CliScriptDefinitionProvider
extends LazyScriptDefinitionProvider {
    @NotNull
    private final ReentrantLock definitionsLock = new ReentrantLock();
    @NotNull
    private final List<Sequence<ScriptDefinition>> definitionsFromSources = new ArrayList();
    @NotNull
    private final List<ScriptDefinition> definitions = new ArrayList();
    @Nullable
    private ScriptDefinition defaultDefinition;

    @NotNull
    protected Sequence<ScriptDefinition> getCurrentDefinitions() {
        Sequence base = SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.definitions), (Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.definitionsFromSources), CliScriptDefinitionProvider::_get_currentDefinitions_$lambda$0));
        return SequencesKt.plus((Sequence)base, (Object)this.getDefaultDefinition());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setScriptDefinitions(@NotNull List<? extends ScriptDefinition> newDefinitions) {
        Intrinsics.checkNotNullParameter(newDefinitions, (String)"newDefinitions");
        Lock lock = this.definitionsLock;
        lock.lock();
        try {
            boolean bl = false;
            this.definitions.clear();
            Iterable $this$partition$iv = newDefinitions;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                ScriptDefinition it = (ScriptDefinition)element$iv;
                boolean bl2 = false;
                if (!it.isDefault()) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List withoutStdDef = (List)pair.component1();
            List stdDef = (List)pair.component2();
            this.definitions.addAll(withoutStdDef);
            this.defaultDefinition = (ScriptDefinition)CollectionsKt.firstOrNull((List)stdDef);
            this.clearCache();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setScriptDefinitionsSources(@NotNull List<? extends ScriptDefinitionsSource> newSources) {
        Intrinsics.checkNotNullParameter(newSources, (String)"newSources");
        Lock lock = this.definitionsLock;
        lock.lock();
        try {
            boolean bl = false;
            this.definitionsFromSources.clear();
            for (ScriptDefinitionsSource scriptDefinitionsSource : newSources) {
                this.definitionsFromSources.add((Sequence<ScriptDefinition>)SequencesKt.constrainOnce((Sequence)scriptDefinitionsSource.getDefinitions()));
            }
            this.clearCache();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        ScriptDefinition scriptDefinition = this.defaultDefinition;
        if (scriptDefinition == null) {
            scriptDefinition = super.getDefaultDefinition();
        }
        return scriptDefinition;
    }

    private static final Sequence _get_currentDefinitions_$lambda$0(Sequence it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

