import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Text } from 'ink';
import { theme } from '../../semantic-colors.js';
import { HalfLinePaddedBox } from '../shared/HalfLinePaddedBox.js';
import { DEFAULT_BACKGROUND_OPACITY } from '../../constants.js';
import { useConfig } from '../../contexts/ConfigContext.js';
export const UserShellMessage = ({ text, width, }) => {
    const config = useConfig();
    const useBackgroundColor = config.getUseBackgroundColor();
    // Remove leading '!' if present, as App.tsx adds it for the processor.
    const commandToDisplay = text.startsWith('!') ? text.substring(1) : text;
    return (_jsx(HalfLinePaddedBox, { backgroundBaseColor: theme.text.secondary, backgroundOpacity: DEFAULT_BACKGROUND_OPACITY, useBackgroundColor: useBackgroundColor, children: _jsxs(Box, { paddingY: 0, marginY: useBackgroundColor ? 0 : 1, paddingX: useBackgroundColor ? 1 : 0, width: width, children: [_jsx(Text, { color: theme.ui.symbol, children: "$ " }), _jsx(Text, { color: theme.text.primary, children: commandToDisplay })] }) }));
};
//# sourceMappingURL=UserShellMessage.js.map