/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Monarch;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public class MonarchActionMessage
extends ObjectMessage {
    public static final String TAG = "monarchAction";
    private static final String ACTION_TAG = "action";
    private static final String MONARCH_TAG = "monarch";
    private static final String RESULT_TAG = "result";
    private static final String TAX_TAG = "tax";

    public MonarchActionMessage(Monarch.MonarchAction action, StringTemplate template, String monarchKey) {
        super(TAG, ACTION_TAG, action.toString(), MONARCH_TAG, monarchKey);
        this.appendChild(template);
    }

    public MonarchActionMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, ACTION_TAG, MONARCH_TAG, TAX_TAG, RESULT_TAG);
        StringTemplate template = null;
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if ("stringTemplate".equals(tag)) {
                if (template == null) {
                    template = xr.readFreeColObject(game, StringTemplate.class);
                } else {
                    this.expected(TAG, tag);
                }
            } else {
                this.expected("stringTemplate", tag);
            }
            xr.expectTag(tag);
        }
        xr.expectTag(TAG);
        this.appendChild(template);
    }

    private Monarch.MonarchAction getAction() {
        return this.getEnumAttribute(ACTION_TAG, Monarch.MonarchAction.class, null);
    }

    private StringTemplate getTemplate() {
        return this.getChild(0, StringTemplate.class);
    }

    private String getMonarchKey() {
        return this.getStringAttribute(MONARCH_TAG);
    }

    private int getTax() {
        return this.getIntegerAttribute(TAX_TAG, -1);
    }

    private Boolean getResult() {
        return this.getBooleanAttribute(RESULT_TAG, null);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        Message.MessagePriority mp = null;
        Monarch.MonarchAction action = this.getAction();
        switch (action) {
            case RAISE_TAX_ACT: 
            case RAISE_TAX_WAR: 
            case MONARCH_MERCENARIES: 
            case HESSIAN_MERCENARIES: {
                mp = Message.MessagePriority.EARLY;
                break;
            }
            case NO_ACTION: 
            case FORCE_TAX: 
            case WAIVE_TAX: 
            case DISPLEASURE: {
                mp = Message.MessagePriority.NORMAL;
                break;
            }
            case LOWER_TAX_OTHER: 
            case LOWER_TAX_WAR: 
            case ADD_TO_REF: 
            case DECLARE_PEACE: 
            case DECLARE_WAR: 
            case SUPPORT_LAND: 
            case SUPPORT_SEA: {
                mp = Message.MessagePriority.LATE;
            }
        }
        if (mp == null) {
            throw new RuntimeException("Missing priority for action: " + action);
        }
        return mp;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        Monarch.MonarchAction action = this.getAction();
        int tax = this.getTax();
        aiPlayer.monarchActionHandler(action, tax);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Monarch.MonarchAction action = this.getAction();
        StringTemplate template = this.getTemplate();
        String key = this.getMonarchKey();
        this.igc(freeColClient).monarchActionHandler(action, template, key);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        return this.igc(freeColServer).monarchAction(serverPlayer, this.getAction(), this.getResult());
    }

    public MonarchActionMessage setTax(int tax) {
        this.setStringAttribute(TAX_TAG, Integer.toString(tax));
        return this;
    }

    public MonarchActionMessage setResult(boolean accept) {
        this.setStringAttribute(RESULT_TAG, Boolean.toString(accept));
        return this;
    }
}

