/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ModifierFormat;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianNationType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.RandomChoice;

public class UnitDetailPanel
extends ColopediaGameObjectTypePanel<UnitType> {
    private static final int MODIFIERS_PER_ROW = 5;

    public UnitDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.UNITS.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        super.addSubTrees(root, this.getId(), new ArrayList<UnitType>(this.getSpecification().getUnitTypeList()));
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        Map<String, Boolean> abilities;
        Player player;
        if (this.getId().equals(id)) {
            return;
        }
        Specification spec = this.getSpecification();
        UnitType type = spec.getUnitType(id);
        panel.setLayout(new MigLayout("wrap 4", "[]20[]40[]20[]"));
        JLabel name = Utility.localizedHeaderLabel(type, Utility.FONTSPEC_SUBTITLE);
        panel.add((Component)name, "span, align center, wrap 40");
        panel.add(Utility.localizedLabel("colopedia.unit.offensivePower"));
        panel.add((Component)new JLabel(Integer.toString((int)type.getOffence())), "right");
        panel.add(Utility.localizedLabel("colopedia.unit.defensivePower"));
        panel.add((Component)new JLabel(Integer.toString((int)type.getDefence())), "right");
        panel.add(Utility.localizedLabel("colopedia.unit.movement"));
        panel.add((Component)new JLabel(String.valueOf(type.getMovement() / 3)), "right");
        if (type.canCarryGoods() || type.canCarryUnits()) {
            panel.add(Utility.localizedLabel("colopedia.unit.capacity"));
            panel.add((Component)new JLabel(Integer.toString(type.getSpace())), "right");
        }
        Europe europe = (player = this.getMyPlayer()) == null ? null : player.getEurope();
        String price = null;
        if (europe != null && europe.getUnitPrice(type) > 0) {
            price = Integer.toString(europe.getUnitPrice(type));
        } else if (type.getPrice() > 0) {
            price = Integer.toString(type.getPrice());
        }
        if (price != null) {
            panel.add(Utility.localizedLabel("colopedia.unit.price"));
            panel.add((Component)new JLabel(price), "right");
        }
        if (type.hasSkill()) {
            List<IndianNationType> nations;
            panel.add(Utility.localizedLabel("colopedia.unit.skill"));
            panel.add((Component)new JLabel(Integer.toString(type.getSkill())), "right");
            List<BuildingType> schools = CollectionUtils.transform(spec.getBuildingTypeList(), bt -> bt.hasAbility("model.ability.teach") && bt.canAdd(type));
            if (!schools.isEmpty()) {
                panel.add((Component)Utility.localizedLabel("colopedia.unit.school"), "newline");
                int count = 0;
                for (BuildingType buildingType : schools) {
                    JButton label = this.getButton(buildingType);
                    if (count > 0 && count % 3 == 0) {
                        panel.add((Component)label, "skip");
                    } else {
                        panel.add(label);
                    }
                    ++count;
                }
            }
            if (!(nations = CollectionUtils.transform(spec.getIndianNationTypes(), nt -> CollectionUtils.any(nt.getSkills(), CollectionUtils.matchKey(type, RandomChoice::getObject)))).isEmpty()) {
                panel.add((Component)Utility.localizedLabel("colopedia.unit.natives"), "newline");
                int count = 0;
                for (IndianNationType nation : nations) {
                    JButton label = this.getButton(nation);
                    if (count > 0 && count % 3 == 0) {
                        panel.add((Component)label, "skip");
                    } else {
                        panel.add(label);
                    }
                    ++count;
                }
            }
        }
        if (!(abilities = type.getRequiredAbilities()).isEmpty()) {
            panel.add((Component)Utility.localizedLabel("colopedia.unit.requirements"), "newline, top");
            JTextPane textPane = Utility.getDefaultTextPane();
            StyledDocument doc = textPane.getStyledDocument();
            CollectionUtils.forEachMapEntry(type.getRequiredAbilities(), e -> this.appendRequiredAbility(doc, (String)e.getKey(), (Boolean)e.getValue()));
            panel.add((Component)textPane, "span, width 60%");
        }
        Function<GoodsType, Stream> goodsMapper = gt -> type.getModifiers(gt.getId());
        List<Modifier> bonusList = CollectionUtils.sort(CollectionUtils.flatten(spec.getGoodsTypeList(), goodsMapper), Modifier.ascendingModifierIndexComparator);
        int n = bonusList.size();
        if (n > 0) {
            Object template = StringTemplate.template("colopedia.unit.productionBonus").addAmount("%number%", n);
            panel.add((Component)Utility.localizedLabel(template), "newline 20, top");
            JPanel productionPanel = new JPanel(new GridLayout(0, 5));
            productionPanel.setOpaque(false);
            for (Modifier productionBonus : bonusList) {
                GoodsType goodsType = spec.getGoodsType(productionBonus.getId());
                String bonus = ModifierFormat.getModifierAsString(productionBonus);
                productionPanel.add(this.getGoodsButton(goodsType, bonus));
            }
            panel.add((Component)productionPanel, "span");
        }
        if (type.needsGoodsToBuild()) {
            panel.add((Component)Utility.localizedLabel("colopedia.unit.goodsRequired"), "newline 20");
            List<AbstractGoods> required = type.getRequiredGoodsList();
            AbstractGoods goods = CollectionUtils.first(required);
            if (required.size() > 1) {
                panel.add((Component)this.getGoodsButton(goods.getType(), goods.getAmount()), "span, split " + required.size());
                for (int index = 1; index < required.size(); ++index) {
                    goods = required.get(index);
                    panel.add(this.getGoodsButton(goods.getType(), goods.getAmount()));
                }
            } else {
                panel.add(this.getGoodsButton(goods.getType(), goods.getAmount()));
            }
        }
        panel.add((Component)Utility.localizedLabel("colopedia.unit.description"), "newline 20");
        panel.add((Component)Utility.localizedTextArea(Messages.descriptionKey(type), 30), "span");
    }
}

