/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.fife.ui.rsyntaxtextarea.DefaultToken;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;

public class WrappedSyntaxView
extends BoxView
implements TabExpander {
    boolean widthChanging;
    int tabBase;
    int tabSize;
    private Segment s = new Segment();
    private Segment drawSeg = new Segment();
    private Rectangle tempRect = new Rectangle();
    private RSyntaxTextArea host;
    private FontMetrics metrics;
    private static final int MIN_WIDTH = 20;

    public WrappedSyntaxView(Element element) {
        super(element, 1);
    }

    protected int calculateBreakPosition(int n, Token token, float f) {
        int n2 = n;
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getContainer();
        float f2 = this.getWidth();
        if (f2 == 2.1474836E9f) {
            f2 = this.getPreferredSpan(0);
        }
        f2 = Math.max(f2, 20.0f);
        for (Token token2 = token; token2 != null && token2.isPaintable(); token2 = token2.getNextToken()) {
            float f3 = token2.getWidth(rSyntaxTextArea, this, f);
            if (f3 > f2) {
                if (n2 == n) {
                    return token2.getOffsetBeforeX(rSyntaxTextArea, this, 0.0f, f2);
                }
                return token2.type == 18 ? n2 + token2.textCount : n2;
            }
            f2 -= f3;
            f += f3;
            n2 += token2.textCount;
        }
        return n2 + 1;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
    }

    protected void drawView(Graphics2D graphics2D, Rectangle rectangle, View view, int n, int n2) {
        float f = rectangle.x;
        LayeredHighlighter layeredHighlighter = (LayeredHighlighter)this.host.getHighlighter();
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        Element element = this.getElement();
        int n3 = view.getStartOffset();
        int n4 = element.getElementIndex(n3);
        int n5 = view.getEndOffset();
        this.setSegment(n3, n5 - 1, rSyntaxDocument, this.drawSeg);
        int n6 = n3 - this.drawSeg.offset;
        Token token = rSyntaxDocument.getTokenListForLine(n4);
        if (token != null && token.type == 0) {
            layeredHighlighter.paintLayeredHighlights(graphics2D, n3, n5, rectangle, this.host, this);
            return;
        }
        while (token != null && token.isPaintable()) {
            int n7 = this.calculateBreakPosition(n3, token, f);
            layeredHighlighter.paintLayeredHighlights(graphics2D, n3, n7, rectangle, this.host, this);
            while (token != null && token.isPaintable() && token.offset + token.textCount - 1 < n7) {
                f = token.paint(graphics2D, f, n2, this.host, this);
                token = token.getNextToken();
            }
            if (token != null && token.isPaintable() && token.offset < n7) {
                int n8 = token.offset;
                DefaultToken defaultToken = new DefaultToken(this.drawSeg, n8 - n6, n7 - 1 - n6, n8, token.type);
                defaultToken.paint(graphics2D, f, n2, this.host, this);
                defaultToken = null;
                token.makeStartAt(n7);
            }
            n3 = n7 == n3 ? n5 : n7;
            f = rectangle.x;
            n2 += n;
        }
    }

    public float getMaximumSpan(int n) {
        this.updateMetrics();
        return super.getMaximumSpan(n);
    }

    public float getMinimumSpan(int n) {
        this.updateMetrics();
        return super.getMinimumSpan(n);
    }

    public float getPreferredSpan(int n) {
        this.updateMetrics();
        return super.getPreferredSpan(n);
    }

    protected int getTabSize() {
        Integer n = (Integer)this.getDocument().getProperty("tabSize");
        int n2 = n != null ? n : 5;
        return n2;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.insertUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            for (int i = 0; i < n; ++i) {
                viewArray[i] = new WrappedLine(element.getElement(i));
            }
            this.replace(0, 0, viewArray);
        }
    }

    public Shape modelToView(int n, Position.Bias bias, int n2, Position.Bias bias2, Shape shape) throws BadLocationException {
        Rectangle rectangle;
        Rectangle rectangle2;
        Shape shape2;
        Shape shape3 = this.modelToView(n, shape, bias);
        if (n2 == this.getEndOffset()) {
            try {
                shape2 = this.modelToView(n2, shape, bias2);
            }
            catch (BadLocationException badLocationException) {
                shape2 = null;
            }
            if (shape2 == null) {
                rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                shape2 = new Rectangle(rectangle2.x + rectangle2.width - 1, rectangle2.y, 1, rectangle2.height);
            }
        } else {
            shape2 = this.modelToView(n2, shape, bias2);
        }
        rectangle2 = shape3.getBounds();
        Rectangle rectangle3 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
        if (rectangle2.y != rectangle.y) {
            Rectangle rectangle4 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            rectangle2.x = rectangle4.x;
            rectangle2.width = rectangle4.width;
        }
        rectangle2.add(rectangle);
        if (n2 > n) {
            rectangle2.width -= rectangle.width;
        }
        return rectangle2;
    }

    public float nextTabStop(float f, int n) {
        if (this.tabSize == 0) {
            return f;
        }
        int n2 = ((int)f - this.tabBase) / this.tabSize;
        return this.tabBase + (n2 + 1) * this.tabSize;
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        this.tabBase = rectangle.x;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.host = (RSyntaxTextArea)this.getContainer();
        int n = this.host.getMaxAscent();
        int n2 = this.host.getLineHeight();
        int n3 = this.getViewCount();
        int n4 = rectangle.x + this.getLeftInset();
        int n5 = rectangle.y + this.getTopInset();
        Rectangle rectangle2 = graphics.getClipBounds();
        for (int i = 0; i < n3; ++i) {
            this.tempRect.x = n4 + this.getOffset(0, i);
            this.tempRect.y = n5 + this.getOffset(1, i);
            this.tempRect.width = this.getSpan(0, i);
            this.tempRect.height = this.getSpan(1, i);
            if (!this.tempRect.intersects(rectangle2)) continue;
            View view = this.getView(i);
            this.drawView(graphics2D, rectangle, view, n2, this.tempRect.y + n);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateChildren(documentEvent, shape);
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = documentEvent.getOffset();
        View view = this.getViewAtPosition(n, rectangle);
        if (view != null) {
            view.removeUpdate(documentEvent, rectangle, viewFactory);
        }
    }

    private void setSegment(int n, int n2, Document document, Segment segment) {
        try {
            document.getText(n, n2 - n, segment);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            System.exit(0);
        }
    }

    public void setSize(float f, float f2) {
        this.updateMetrics();
        if ((int)f != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.widthChanging = true;
        }
        super.setSize(f, f2);
        this.widthChanging = false;
    }

    void updateChildren(DocumentEvent documentEvent, Shape shape) {
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (documentEvent.getType() == DocumentEvent.EventType.CHANGE) {
            this.getContainer().repaint();
        } else if (elementChange != null) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            View[] viewArray = new View[elementArray2.length];
            for (int i = 0; i < elementArray2.length; ++i) {
                viewArray[i] = new WrappedLine(elementArray2[i]);
            }
            this.replace(elementChange.getIndex(), elementArray.length, viewArray);
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    final void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        this.metrics = container.getFontMetrics(font);
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    class WrappedLine
    extends View {
        int nlines;

        WrappedLine(Element element) {
            super(element);
        }

        final int calculateLineCount() {
            int n = 0;
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getContainer();
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n4 = element.getElementIndex(n2);
            Token token = rSyntaxDocument.getTokenListForLine(n4);
            float f = 0.0f;
            int n5 = n2;
            while (n5 < n3) {
                ++n;
                int n6 = WrappedSyntaxView.this.calculateBreakPosition(n5, token, f = RSyntaxUtilities.makeTokenListStartAt(token, n5, WrappedSyntaxView.this, rSyntaxTextArea, f));
                n5 = n6 == n5 ? ++n6 : n6;
            }
            return n;
        }

        public float getPreferredSpan(int n) {
            switch (n) {
                case 0: {
                    float f = WrappedSyntaxView.this.getWidth();
                    if (f == 2.1474836E9f) {
                        return 100.0f;
                    }
                    return f;
                }
                case 1: {
                    if (this.nlines == 0 || WrappedSyntaxView.this.widthChanging) {
                        this.nlines = this.calculateLineCount();
                    }
                    int n2 = this.nlines * ((RSyntaxTextArea)this.getContainer()).getLineHeight();
                    return n2;
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }

        public void paint(Graphics graphics, Shape shape) {
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            Rectangle rectangle = shape.getBounds();
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getContainer();
            rectangle.height = rSyntaxTextArea.getLineHeight();
            rectangle.width = 1;
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            int n4 = bias == Position.Bias.Forward ? n : Math.max(n2, n - 1);
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n5 = element.getElementIndex(n2);
            Token token = rSyntaxDocument.getTokenListForLine(n5);
            float f = rectangle.x;
            while (n2 < n3) {
                f = RSyntaxUtilities.makeTokenListStartAt(token, n2, WrappedSyntaxView.this, rSyntaxTextArea, f);
                int n6 = WrappedSyntaxView.this.calculateBreakPosition(n2, token, f);
                if (n >= n2 && n4 < n6) {
                    rectangle = RSyntaxUtilities.getLineWidthUpTo(rSyntaxTextArea, WrappedSyntaxView.this.s, n2, n, WrappedSyntaxView.this, rectangle, rectangle.x);
                    return rectangle;
                }
                if (n6 == n3 - 1 && n == n3 - 1) {
                    if (n > n2) {
                        rectangle = RSyntaxUtilities.getLineWidthUpTo(rSyntaxTextArea, WrappedSyntaxView.this.s, n2, n, WrappedSyntaxView.this, rectangle, rectangle.x);
                    }
                    return rectangle;
                }
                n2 = n6 == n2 ? n3 : n6;
                rectangle.y += rectangle.height;
            }
            throw new BadLocationException(null, n);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            biasArray[0] = Position.Bias.Forward;
            Rectangle rectangle = (Rectangle)shape;
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
            int n = (int)f;
            int n2 = (int)f2;
            if (n2 < rectangle.y) {
                return this.getStartOffset();
            }
            if (n2 > rectangle.y + rectangle.height) {
                return this.getEndOffset() - 1;
            }
            RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)this.getContainer();
            rectangle.height = rSyntaxTextArea.getLineHeight();
            int n3 = this.getEndOffset();
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n4 = this.getStartOffset();
            int n5 = element.getElementIndex(n4);
            Token token = rSyntaxDocument.getTokenListForLine(n5);
            while (n4 < n3) {
                RSyntaxUtilities.makeTokenListStartAt(token, n4, WrappedSyntaxView.this, rSyntaxTextArea, rectangle.x);
                int n6 = WrappedSyntaxView.this.calculateBreakPosition(n4, token, rectangle.x);
                if (n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
                    if (n < rectangle.x) {
                        return n4;
                    }
                    if (n > rectangle.x + rectangle.width) {
                        return n6 - 1;
                    }
                    int n7 = token.getListOffset(rSyntaxTextArea, WrappedSyntaxView.this, rectangle.x, n);
                    return Math.max(Math.min(n7, n3 - 1), n4);
                }
                n4 = n6 == n4 ? n3 : n6;
                rectangle.y += rectangle.height;
            }
            return this.getEndOffset() - 1;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                WrappedSyntaxView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = (Rectangle)shape;
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            int n = this.calculateLineCount();
            if (this.nlines != n) {
                this.nlines = n;
                WrappedSyntaxView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (shape != null) {
                Container container = this.getContainer();
                Rectangle rectangle = (Rectangle)shape;
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

