START TRANSACTION;
INSERT INTO `role` (`roleid`,`name`,`type`,`readonly`) VALUES ('1','User role','1','0'),
('2','Admin role','2','0'),
('3','Super admin role','3','1'),
('4','Guest role','1','0');
INSERT INTO `ugset` (`ugsetid`,`hash`) VALUES ('1','b21d61561974b06cbeb97a71ca880e92f0fc06d49ac3246280afb88dfa6050a6');
INSERT INTO `users` (`userid`,`username`,`name`,`surname`,`passwd`,`url`,`autologin`,`autologout`,`refresh`,`rows_per_page`,`roleid`) VALUES ('1','Admin','Zabbix','Administrator','$2y$10$92nDno4n0Zm7Ej7Jfsz8WukBfgSS/U0QkIuu8WkJPihXBb2A1UrEK','','1','0','30s','50','3'),
('2','guest','','','$2y$10$89otZrRNmde97rIyzclecuk6LwKAsHN0BcvoOKGjbT.BwMBfm7G06','','0','15m','30s','50','4');
INSERT INTO `hstgrp` (`groupid`,`name`,`flags`,`uuid`,`type`) VALUES ('1','Templates','0','7df96b18c230490a9a0a9e2307226338','1'),
('2','Linux servers','0','dc579cd7a1a34222933f24f52a68bcd8','0'),
('4','Zabbix servers','0','6f6799aa69e844b4b3918f779f2abf08','0'),
('5','Discovered hosts','0','f2481361f99448eea617b7b1d4765566','0'),
('6','Virtual machines','0','137f19e6e2dc4219b33553b812627bc2','0'),
('7','Hypervisors','0','1b837a3c078647049a0c00c61b4d57b5','0'),
('9','Templates/Network devices','0','36bff6c29af64692839d077febfc7079','1'),
('10','Templates/Operating systems','0','846977d1dfed4968bc5f8bdb363285bc','1'),
('11','Templates/Server hardware','0','e960332b3f6c46a1956486d4f3f99fce','1'),
('12','Templates/Applications','0','a571c0d144b14fd4a87a9d9b2aa9fcd6','1'),
('13','Templates/Databases','0','748ad4d098d447d492bb935c907f652f','1'),
('14','Templates/Virtualization','0','02e4df4f20b848e79267641790f241da','1'),
('15','Templates/Telephony','0','1d12408342854fd5a4436dd6d5d1bd4a','1'),
('16','Templates/SAN','0','7c2cb727f85b492d88cd56e17127c64d','1'),
('17','Templates/Video surveillance','0','d37f71c7e3f7469bab645852a69a2018','1'),
('18','Templates/Power','0','3dcd5bbe90534f9e8eb5c2d53756af63','1'),
('19','Applications','0','a571c0d144b14fd4a87a9d9b2aa9fcd6','0'),
('20','Databases','0','748ad4d098d447d492bb935c907f652f','0'),
('21','Templates/Cloud','0','c2c162144c2d4c5491c8801193af4945','1');
INSERT INTO `drules` (`druleid`,`proxyid`,`name`,`iprange`,`delay`,`status`,`concurrency_max`) VALUES ('2',NULL,'Local network','192.168.0.1-254','1h','1','0');
INSERT INTO `dchecks` (`dcheckid`,`druleid`,`type`,`key_`,`snmp_community`,`ports`,`snmpv3_securityname`,`snmpv3_securitylevel`,`snmpv3_authpassphrase`,`snmpv3_privpassphrase`,`uniq`,`snmpv3_authprotocol`,`snmpv3_privprotocol`,`snmpv3_contextname`,`host_source`,`name_source`,`allow_redirect`) VALUES ('2','2','9','system.uname','','10050','','0','','','0','0','0','','1','0','0');
INSERT INTO `media_type` (`mediatypeid`,`type`,`name`,`smtp_server`,`smtp_helo`,`smtp_email`,`exec_path`,`gsm_modem`,`username`,`passwd`,`smtp_port`,`smtp_security`,`smtp_verify_peer`,`smtp_verify_host`,`smtp_authentication`,`maxsessions`,`maxattempts`,`attempt_interval`,`message_format`,`script`,`timeout`,`process_tags`,`show_event_menu`,`event_menu_url`,`event_menu_name`,`description`,`provider`) VALUES ('1','0','Email','mail.example.com','example.com','zabbix@example.com','','','','','25','0','0','0','0','1','3','10s','0','','30s','0','0','','','','0'),
('3','2','SMS','','','','','/dev/ttyS0','','','25','0','0','0','0','1','3','10s','1','','30s','0','0','','','','0'),
('4','0','Email (HTML)','mail.example.com','example.com','zabbix@example.com','','','','','25','0','0','0','0','1','3','10s','1','','30s','0','0','','','','0'),
('34','0','Gmail','smtp.gmail.com','example.com','zabbix@example.com','','','','','587','1','0','0','1','1','3','10s','1','','30s','0','0','','','','1'),
('35','0','Gmail relay','smtp-relay.gmail.com','example.com','zabbix@example.com','','','','','587','1','0','0','0','1','3','10s','1','','30s','0','0','','','','2'),
('36','0','Office365','smtp.office365.com','example.com','zabbix@example.com','','','','','587','1','0','0','1','1','3','10s','1','','30s','0','0','','','','3'),
('37','0','Office365 relay','example-com.mail.protection.outlook.com','example.com','zabbix@example.com','','','','','25','1','0','0','0','1','3','10s','1','','30s','0','0','','','','4'),
('38','4','Brevis.one','','','','','','','','25','0','0','0','0','1','3','10s','1','var BrevisOne = {\r\n    params: [],\r\n\r\n    addParam: function (name, value) {\r\n        BrevisOne.params.push(name + \'=\' + encodeURIComponent(value));\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        BrevisOne.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setPayload: function (params) {\r\n        var parts = params.send_to.split(\':\'),\r\n            defaultValues = {\r\n                ring: \'true\',\r\n                flash: \'true\',\r\n                telauto: \'false\'\r\n            };\r\n\r\n        BrevisOne.addParam(\'username\', params.username);\r\n        BrevisOne.addParam(\'password\', params.password);\r\n        BrevisOne.addParam(\'text\', params.text);\r\n\r\n        if (parts.length > 1) {\r\n            BrevisOne.addParam(\'mode\', parts[0]);\r\n            BrevisOne.addParam(\'to\', parts[1]);\r\n        }\r\n        else {\r\n            BrevisOne.addParam(\'to\', parts[0]);\r\n        }\r\n\r\n        Object.keys(defaultValues)\r\n            .forEach(function (key) {\r\n                if (params[key] && params[key].trim() && params[key].toLowerCase() === defaultValues[key]) {\r\n                    BrevisOne.addParam(key, defaultValues[key]);\r\n                }\r\n            });\r\n    },\r\n\r\n    request: function () {\r\n        var response,\r\n            request = new HttpRequest(),\r\n            data = \'?\' + BrevisOne.params.join(\'&\');\r\n\r\n        request.addHeader(\'Content-Type: multipart/form-data\');\r\n\r\n        if (typeof BrevisOne.HTTPProxy !== \'undefined\' && BrevisOne.HTTPProxy !== \'\') {\r\n            request.setProxy(BrevisOne.HTTPProxy);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ BrevisOne Webhook ] Sending request.\');\r\n\r\n        response = request.post(params.endpoint + data);\r\n\r\n        Zabbix.log(4, \'[ BrevisOne Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response) {\r\n                message += \': \' + response;\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    [\'endpoint\', \'password\', \'username\', \'text\', \'send_to\'].forEach(function (field) {\r\n        if (typeof params !== \'object\' || typeof params[field] === \'undefined\'\r\n                || !params[field].trim()) {\r\n            throw \'Required parameter is not set: "\' + field + \'".\';\r\n        }\r\n    });\r\n\r\n    if (params.send_to === \'{ALERT.SENDTO}\') {\r\n        throw \'Required parameter is not set: "send_to".\';\r\n    }\r\n\r\n    BrevisOne.setProxy(params.HTTPProxy);\r\n    BrevisOne.setPayload(params);\r\n    BrevisOne.request();\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ BrevisOne Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','','0'),
('39','4','Discord','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nvar SEVERITY_COLORS = [\r\n	\'#97AAB3\',\r\n	\'#7499FF\',\r\n	\'#FFC859\',\r\n	\'#FFA059\',\r\n	\'#E97659\',\r\n	\'#E45959\',\r\n	\'#009900\'\r\n],\r\n	serviceLogName = \'Discord Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Discord = CWebhook;\r\n\r\nfunction stringTruncate(str, len) {\r\n	return str.length > len ? str.substring(0, len - 3) + \'...\' : str;\r\n}\r\n\r\nDiscord.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({discord_endpoint: {type: \'string\', url: true}, zabbix_url: {type: \'string\', url: true}, alert_message: {type: \'string\'},\r\n		alert_subject: {type: \'string\'}, event_nseverity: {type: \'integer\', default: 1}, user_agent: {type: \'string\'}}, this.params);\r\n\r\n	this.params.discord_endpoint = this.params.discord_endpoint.replace(\'/api/\', \'/api/v10/\') + \'?wait=True\';\r\n\r\n	if (this.params.event_source === \'3\' && this.params.event_value === \'1\') {\r\n		this.params.event_nseverity = 4;\r\n	}\r\n\r\n	if (this.params.event_value === \'0\') {\r\n		this.params.event_nseverity = 6;\r\n	}\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({event_id: {type: \'integer\'}, trigger_id: {type: \'integer\'}}, this.params);\r\n	}\r\n\r\n	this.data = {\r\n		embeds: [\r\n			{\r\n				color: parseInt(SEVERITY_COLORS[this.params.event_nseverity].replace(\'#\', \'\'), 16),\r\n				url: CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id),\r\n				title: stringTruncate(this.params.alert_subject, 256),\r\n				description: stringTruncate(this.params.alert_message, 4096)\r\n			}\r\n		]\r\n	};\r\n};\r\n\r\nDiscord.prototype.onEvent = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	this.request.addHeaders({"User-Agent": this.params.user_agent});\r\n	const response = this.request.jsonRequest(\'POST\', this.params.discord_endpoint, this.data);\r\n\r\n	if (!response.id) {\r\n		const error_message = CParamValidator.isType(response.message, \'string\') ? response.message : \'Unknown error\';\r\n\r\n		throw error_message + \'. For more details check the Zabbix server log.\';\r\n	}\r\n\r\n	return \'OK\';\r\n};\r\n\r\n\r\ntry {\r\n	var hook = new Discord(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','This media type integrates your Zabbix installation with your Discord server using the Zabbix webhook feature.\r\n\r\nDiscord configuration:\r\n\r\n1. Go to `https://discord.com/app` or open the Discord desktop application. Open your *Server Settings* and head to the *Integrations* tab.  \r\n2. Press the *Create Webhook* button to create a new webhook.\r\n3. Click on the webhook that has been created and edit the details if needed.\r\n4. After setting up your Discord webhook press "Save Changes". Now you can copy Discord webhook URL now by pressing "Copy Webhook URL" or you can view it later.\r\n\r\nZabbix configuration:\r\n\r\n1. Before you can start using Discord webhook, set up the global macro "{$ZABBIX.URL}":\r\n- In the Zabbix web interface, go to "Administration" → "Macros" section in the dropdown menu in the top left corner.\r\n- Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.\r\n- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration you might also need to append "/zabbix" to the end of URL. Good examples: \r\n  - http://zabbix.com\r\n  - https://zabbix.lan/zabbix\r\n  - http://server.zabbix.lan/\r\n  - http://localhost\r\n  - http://127.0.0.1:8080\r\n- Bad examples:\r\n  - zabbix.com\r\n  - http://zabbix/\r\n\r\n2. Create a Zabbix user and add media:\r\n- If you want to create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks). \r\n- In the "Media" tab, add a new media and select "Discord" type from the drop-down list. The "Send to" field must contain the URL of the Discord webhook created before.\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to Discord.\r\n\r\n3. Great! You can now start using this media type in actions and receive alerts!\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/discord','0'),
('40','4','Event-Driven Ansible','','','','','','','','25','0','0','0','0','1','3','10s','1','var Eda = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        var required_params = [\r\n                \'send_to\',\r\n                \'event_source\',\r\n                \'event_value\',\r\n                \'event_date\',\r\n                \'event_time\'],\r\n            integer_fields = [\r\n                \'event_id\',\r\n                \'event_nseverity\',\r\n                \'event_object\',\r\n                \'event_source\',\r\n                \'event_value\',\r\n                \'host_id\',\r\n                \'trigger_id\'];\r\n\r\n        required_params.forEach(function (field) {\r\n            if (typeof params !== \'object\' || typeof params[field] === \'undefined\' || params[field] === \'\') {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        Eda.params = params;\r\n\r\n        integer_fields.forEach(function (key) {\r\n                if (typeof Eda.params[key] !== \'undefined\') {\r\n                    if (isNaN(Eda.params[key])) {\r\n                        throw \'Parameter "\' + key + \'" must be integer. Given value: \' + Eda.params[key];\r\n                    }\r\n                    Eda.params[key] = parseInt(Eda.params[key]);\r\n                }\r\n            });\r\n\r\n        // Check type of event. Possible values: 0 - Trigger\r\n        if (params.event_source != 0) {\r\n            throw (\'Incorrect "event_source" parameter given: \' + params.event_source \r\n                + \'\\nOnly trigger-based events are supported\');\r\n        }\r\n\r\n        // Check trigger update and trigger resolve events\r\n        if (params.event_source == 0 && params.event_value != 1) {\r\n            throw (\'Incorrect "event_value" parameter given: "\' + params.event_value \r\n                + \'".\\nOnly trigger-based events of problem are supported\');\r\n        }\r\n        \r\n        // Check endpoint\r\n        Eda.params.endpoint = (Eda.params.endpoint.startsWith(\'/\'))\r\n                ? Eda.params.endpoint : \'/\' + Eda.params.endpoint;\r\n        // Prepare groups\r\n        Eda.params.host_groups = (typeof Eda.params[\'host_groups\'] !== \'undefined\')\r\n                ? this.prepareHostgroups(Eda.params.host_groups): []\r\n        // Prepare tags\r\n        Eda.params.event_tags = (typeof Eda.params[\'event_tags\'] !== \'undefined\')\r\n                ? this.transformTags(Eda.params.event_tags): {}\r\n        // Prepare timestamp\r\n        Eda.params.event_datetime_timestamp = this.getTimestamp(\r\n            Eda.params.event_date, Eda.params.event_time)\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Eda.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    prepareHostgroups: function (hostgroups) {\r\n        var host_groups = []; \r\n        hostgroups.split(\',\').forEach(function (group) {\r\n            group = group.trim();\r\n            if (group.length > 0) {\r\n                host_groups.push(group);\r\n            }\r\n        });\r\n        return host_groups;\r\n    },\r\n\r\n    getTimestamp: function (date, time) {\r\n        try {\r\n            return Date.parse(date.split(\'.\').join(\'-\') + \'T\' + time + \'.000Z\') / 1000 + new Date().getTimezoneOffset() * 60;\r\n        } catch (_) {}\r\n    \r\n        throw (\'Failed to parse event time.\');\r\n    },\r\n\r\n    transformTags: function (event_tags) {\r\n        var tags = {};\r\n        if (event_tags) {\r\n            try {\r\n                JSON.parse(event_tags).forEach(function (object) {\r\n                    var tag = object[\'tag\'];\r\n                    tags[tag] = tags[tag] || [];\r\n                    tags[tag].push(object[\'value\']);\r\n                });\r\n            } catch (error) {\r\n                throw \'Event tags format is invalid.\';\r\n            }\r\n        }\r\n    \r\n        return tags;\r\n    },\r\n\r\n    sendMessage: function () {\r\n        var response, request = new HttpRequest();\r\n        var url = Eda.params[\'send_to\'] + Eda.params[\'endpoint\'];\r\n        var data = JSON.stringify(Eda.params);\r\n        Zabbix.log(4, \'[ Event-Driven Ansible webhook ] URL: \' + url + \' data: \' + data);\r\n        \r\n        if (typeof Eda.HTTPProxy !== \'undefined\' && Eda.HTTPProxy !== \'\') {\r\n            request.setProxy(Eda.HTTPProxy);\r\n        }\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        response = request.post(url, data);\r\n        \r\n        Zabbix.log(4, \'[ Event-Driven Ansible webhook ] HTTP code: \' + request.getStatus()\r\n            + \' response: \' + response);\r\n\r\n        if (request.getStatus() !== 200) {\r\n            throw \'Request failed with status code \' + request.getStatus() + \': \' + response;\r\n        }\r\n    }\r\n};\r\n\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n    \r\n    Eda.setParams(params);\r\n    Eda.setProxy(params.HTTPProxy);\r\n    Eda.sendMessage();\r\n    return true;\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Event-Driven Ansible webhook ] notification failed: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','','0'),
('41','4','Express.ms','','','','','','','','25','0','0','0','0','1','3','10s','1','var Express = {\r\n    params: [],\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Express.params = params;\r\n\r\n        if (typeof Express.params.url === \'string\' && !Express.params.url.endsWith(\'/\')) {\r\n            Express.params.url += \'/\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Express.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    request: function (query, data) {\r\n        var response,\r\n            url = Express.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Bearer \' + Express.params.token);\r\n\r\n        if (typeof Express.HTTPProxy !== \'undefined\' && Express.HTTPProxy !== \'\') {\r\n            request.setProxy(Express.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Express Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        response = request.post(url, data);\r\n\r\n        Zabbix.log(4, \'[ Express Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ Express Webhook ] Failed to parse response received from Express\');\r\n                response = {};\r\n            }\r\n        }\r\n\r\n        if (response.status !== \'ok\') {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (typeof response.reason !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.reason);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return response.result;\r\n    },\r\n\r\n    postMessage: function (is_problem) {\r\n        var data,\r\n            url,\r\n            result = {tags: {}},\r\n            response;\r\n\r\n        if (is_problem) {\r\n            data = {\r\n                group_chat_id: Express.params.send_to,\r\n                notification: {\r\n                    status: \'ok\',\r\n                    body: Express.params.message\r\n                }\r\n            };\r\n            url = \'api/v4/botx/notifications/direct\';\r\n        }\r\n        else {\r\n            data = {\r\n                reply: {\r\n                    status: \'ok\',\r\n                    body: Express.params.message\r\n                }\r\n            };\r\n            url = \'api/v3/botx/events/reply_event\';\r\n\r\n            try {\r\n                var tags = JSON.parse(Express.params.tags);\r\n            }\r\n            catch (error) {\r\n                throw \'Value of "express_tags" is not JSON. Value: \' + Express.params.tags + \'.\';\r\n            }\r\n\r\n            tags.forEach(function(tag) {\r\n                if (tag.tag === \'__zbx_ex_sync_id_\' + Express.params.send_to) {\r\n                    data.source_sync_id = tag.value;\r\n                }\r\n            });\r\n\r\n            if (!data.source_sync_id) {\r\n                throw \'Cannot update data. sync_id for the provided sender is unknown.\';\r\n            }\r\n        }\r\n\r\n        response = Express.request(url, data);\r\n\r\n        if (is_problem && response.sync_id) {\r\n            result.tags[\'__zbx_ex_sync_id_\' + Express.params.send_to] = response.sync_id;\r\n\r\n            return JSON.stringify(result);\r\n        }\r\n        else {\r\n            return \'OK\';\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        express = {},\r\n        required_params = [\r\n            \'express_url\', \'express_send_to\', \'express_message\', \'express_tags\', \'express_token\',\r\n            \'event_source\', \'event_value\', \'event_update_status\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'express_\')) {\r\n                express[key.substring(8)] = params[key];\r\n            }\r\n\r\n            if (required_params.indexOf(key) !== -1\r\n                    && (params[key].trim() === \'\' || params[key] === \'{ALERT.SENDTO}\')) {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Forcing event_value and event_update_status for non trigger-based events.\r\n    if (params.event_source !== \'0\' ) {\r\n        params.event_value = \'1\';\r\n        params.event_update_status = \'0\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    Express.setParams(express);\r\n    Express.setProxy(params.HTTPProxy);\r\n\r\n    return Express.postMessage(params.event_value === \'1\' && params.event_update_status === \'0\');\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Express Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','0','','','','0'),
('42','4','GitHub','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nvar serviceLogName = \'GitHub Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	GitHub = CWebhook;\r\n\r\nGitHub.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		alert_message: {type: \'string\'},\r\n		alert_subject: {type: \'string\'},\r\n		github_api_version: {type: \'string\'},\r\n		github_repo: {type: \'string\'},\r\n		github_token: {type: \'string\'},\r\n		github_url: {type: \'string\', url: true},\r\n		github_user_agent: {type: \'string\'},\r\n		github_zabbix_event_priority_label_prefix: {type: \'string\', default: \'Zabbix Event Priority: \'},\r\n		github_zabbix_event_source_label_prefix: {type: \'string\', default: \'Zabbix Event Source: \'},\r\n		github_zabbix_event_status_label_prefix: {type: \'string\', default: \'Zabbix Event Status: \'},\r\n		github_zabbix_generic_label: {type: \'string\', default: \'Zabbix GitHub Webhook\'},\r\n		zabbix_url: {type: \'string\', url: true}\r\n	}, this.params);\r\n\r\n	this.request_headers = {\r\n		\'User-Agent\': this.params.github_user_agent,\r\n		\'Accept\': \'application/vnd.github+json\',\r\n		\'X-GitHub-Api-Version\': this.params.github_api_version,\r\n		\'Authorization\': \'Bearer \' + this.params.github_token\r\n	};\r\n\r\n	this.payload_data = {\r\n		title: this.params.alert_subject,\r\n		labels: [\r\n			{\r\n				name: this.params.github_zabbix_generic_label\r\n			}\r\n		]\r\n	};\r\n\r\n	this.result = {tags: {}};\r\n};\r\n\r\nfunction checkResponse(response, received_code, required_code, response_field, error_message) {\r\n	if (received_code != required_code || !CParamValidator.isDefined(response[response_field])) {\r\n		var message = error_message + \' Request failed with status code \' + received_code;\r\n\r\n		if (CParamValidator.isDefined(response.message) && Object.keys(response.message).length > 0) {\r\n			message += \': \' + response.message;\r\n		}\r\n\r\n		throw message + \' Check debug log for more information.\';\r\n	}\r\n}\r\n\r\nGitHub.prototype.createIssue = function () {\r\n	this.payload_data.body = this.params.alert_message + \'\\n\' + CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n\r\n	this.request.addHeaders(this.request_headers);\r\n\r\n	const response = this.request.jsonRequest(\'POST\', this.params.github_url + \'/repos/\' + this.params.github_repo + \'/issues\', this.payload_data);\r\n\r\n	checkResponse(response, this.request.getStatus(), 201, \'number\', \'Cannot create GitHub issue.\');\r\n\r\n	return response;\r\n}\r\n\r\nGitHub.prototype.updateIssue = function () {\r\n	this.request.addHeaders(this.request_headers);\r\n\r\n	const response = this.request.jsonRequest(\'PATCH\', this.params.github_url + \'/repos/\' + this.params.github_repo + \'/issues/\' + this.params.github_issue_number, this.payload_data);\r\n\r\n	checkResponse(response, this.request.getStatus(), 200, \'number\', \'Cannot update GitHub issue.\');\r\n\r\n	return response;\r\n}\r\n\r\nGitHub.prototype.addIssueComment = function () {\r\n	this.payload_data = {\r\n		body: this.params.alert_message\r\n	};\r\n\r\n	this.request.addHeaders(this.request_headers);\r\n\r\n	const response = this.request.jsonRequest(\'POST\', this.params.github_url + \'/repos/\' + this.params.github_repo + \'/issues/\' + this.params.github_issue_number + \'/comments\', this.payload_data);\r\n\r\n	checkResponse(response, this.request.getStatus(), 201, \'id\', \'Cannot add comment for GitHub issue.\');\r\n\r\n	return response;\r\n}\r\n\r\nGitHub.prototype.onProblem = function (alert) {\r\n	if (CParamValidator.isMacroSet(this.params.github_issue_number)) {\r\n		return this.onUpdate(alert);\r\n	}\r\n\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({event_id: {type: \'integer\'}, trigger_id: {type: \'integer\'}}, this.params);\r\n	}\r\n\r\n	this.payload_data.labels.push({name: this.params.github_zabbix_event_source_label_prefix + alert.source});\r\n\r\n	this.payload_data.labels.push({name: this.params.github_zabbix_event_status_label_prefix + \'Problem\'});\r\n\r\n	if (!CParamValidator.isEmpty(this.params.event_severity) && CParamValidator.isMacroSet(this.params.event_severity, \'EVENT.SEVERITY\')) {\r\n		this.payload_data.labels.push({name: this.params.github_zabbix_event_priority_label_prefix + this.params.event_severity});\r\n	}\r\n\r\n	const response = this.createIssue();\r\n\r\n	this.result.tags = {\r\n		__zbx_github_issue_number: response.number,\r\n		__zbx_github_repo: this.params.github_repo,\r\n		__zbx_github_link: response.html_url\r\n	};\r\n\r\n	return this.result;\r\n}\r\n\r\nGitHub.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	if (!CParamValidator.isMacroSet(this.params.github_issue_number)) {\r\n		throw "Failed to update the existing issue: no issue number was received."\r\n	}\r\n\r\n	this.payload_data.labels.push({name: this.params.github_zabbix_event_source_label_prefix + alert.source});\r\n\r\n	if (this.params.event_value === \'0\') {\r\n		this.payload_data.labels.push({name: this.params.github_zabbix_event_status_label_prefix + \'Resolved\'});\r\n	} else {\r\n		this.payload_data.labels.push({name: this.params.github_zabbix_event_status_label_prefix + \'Problem\'});\r\n	}\r\n\r\n	if (!CParamValidator.isEmpty(this.params.event_severity) && CParamValidator.isMacroSet(this.params.event_severity, \'EVENT.SEVERITY\')) {\r\n		this.payload_data.labels.push({name: this.params.github_zabbix_event_priority_label_prefix + this.params.event_severity});\r\n	}\r\n\r\n	this.updateIssue();\r\n\r\n	this.request.clearHeader();\r\n	this.addIssueComment();\r\n\r\n	return this.result;\r\n}\r\n\r\nGitHub.prototype.onResolve = function (alert) {\r\n	return this.onUpdate(alert);\r\n}\r\n\r\nGitHub.prototype.onDiscovery = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	this.payload_data.labels.push({name: this.params.github_zabbix_event_source_label_prefix + alert.source});\r\n\r\n	this.createIssue();\r\n\r\n	return this.result;\r\n}\r\n\r\nGitHub.prototype.onAutoreg = function (alert) {\r\n	return this.onDiscovery(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new GitHub(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_github_link}','Github: Issue {EVENT.TAGS.__zbx_github_issue_number}','This media type integrates your Zabbix installation with GitHub using the Zabbix webhook feature.\r\n\r\nGitHub configuration:\r\n\r\n1. Create an access token.\r\n\r\nOne of the simplest ways to send authenticated requests is to use a personal access token - either a classic or a fine-grained one:\r\nhttps://docs.github.com/en/rest/authentication/authenticating-to-the-rest-api?apiVersion=2022-11-28#authenticating-with-a-personal-access-token\r\n\r\nClassic personal access token\r\n\r\nYou can create a new classic personal access token by following the instructions in the official documentation:\r\nhttps://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-personal-access-token-classic\r\n\r\nThe token user must have a permission to create issues and issue comments in the desired repositories. For webhook to work on private repositories, the "repo" scope must be set in token settings to have full control of private repositories.\r\n\r\nAdditional information about OAuth scopes is available in the official documentation:\r\nhttps://docs.github.com/en/apps/oauth-apps/building-oauth-apps/scopes-for-oauth-apps#available-scopes\r\n\r\nFine-grained personal access token\r\n\r\nAlternatively, you can use a fine-grained personal access token:\r\nhttps://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-fine-grained-personal-access-token\r\n\r\nIn order to use fine-grained tokens to monitor organization-owned repositories, organizations must opt in to fine-grained personal access tokens and set up a personal access token policy:\r\nhttps://docs.github.com/en/organizations/managing-programmatic-access-to-your-organization/setting-a-personal-access-token-policy-for-your-organization\r\n\r\nThe fine-grained token needs to have the following permission set to provide access to the repository issues:\r\n- "Issues" repository permissions (write)\r\n\r\n2. Copy and save the created token somewhere, as it will be shown only once for security reasons.\r\n\r\nZabbix configuration:\r\n\r\n1. Before you can start using Zammad webhook, set up the global macro "{$ZABBIX.URL}":\r\n- In the Zabbix web interface, go to "Administration" → "Macros" section in the dropdown menu in the top left corner.\r\n- Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.\r\n- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration you might also need to append "/zabbix" to the end of URL. Good examples:\r\n  - http://zabbix.com\r\n  - https://zabbix.lan/zabbix\r\n  - http://server.zabbix.lan/\r\n  - http://localhost\r\n  - http://127.0.0.1:8080\r\n- Bad examples:\r\n  - zabbix.com\r\n  - http://zabbix/\r\n\r\n2. Set the "github_token" webhook parameter value to the access token that you created previously.\r\n\r\nYou can also adjust the issue labels created by the webhook in the following parameters:\r\n- github_zabbix_event_priority_label_prefix - the prefix for the issue label that displays the Zabbix event priority in the supported event sources. It is set to "Zabbix Event Priority: " by default.\r\n- github_zabbix_event_source_label_prefix - the prefix for the issue label that displays the Zabbix event source. It is set to "Zabbix Event Source: " by default.\r\n- github_zabbix_event_status_label_prefix - the prefix for the issue label that displays the Zabbix event status. It is set to "Zabbix Event Status: " by default.\r\n- github_zabbix_generic_label - the label that is added to all issues created by the webhook. It is set to "Zabbix GitHub Webhook" by default.\r\n\r\nNote that the webhook will reuse the labels with the same name that already exist in the repository (including the color, so it can changed from the default value for new labels in GitHub, if needed). Also, the labels are replaced when the issue is updated, so any user-added labels will be removed.\r\n\r\n4. Create a Zabbix user and add media:\r\n- If you want to create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).\r\n- In the "Media" tab, add a new media and select "Zammad" type from the drop-down list. In field "Send to" specify the full repo name (owner/project name) e.g. johndoe/example-project.\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to GitHub.\r\n\r\n5. Great! You can now start using this media type in actions and create GitHub issues!\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/github','0'),
('43','4','GLPi','','','','','','','','25','0','0','0','0','1','1','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst serviceLogName = \'GLPi Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	GLPi = CWebhook;\r\n\r\nGLPi.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		alert_message: { type: \'string\' },\r\n		alert_subject: { type: \'string\' },\r\n		zabbix_url: { type: \'string\', url: true },\r\n		glpi_url: { type: \'string\', url: true },\r\n		glpi_user_token: { type: \'string\' }\r\n	}, this.params);\r\n\r\n	this.params.use_app_token = false;\r\n\r\n	if (CParamValidator.isDefined(this.params.glpi_app_token) && !CParamValidator.isEmpty(this.params.glpi_app_token)) {\r\n		this.params.use_app_token = true;\r\n	}\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({ trigger_id: { type: \'integer\' }, event_id: { type: \'integer\' } }, this.params);\r\n		this.params.zabbix_url = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n	}\r\n\r\n	if (params.event_value != \'0\' && CParamValidator.isMacroSet(this.params.glpi_problem_id)) {\r\n		this.params.event_update_status = \'1\';\r\n	}\r\n\r\n	this.data = {\r\n		input: {\r\n			name: this.params.alert_subject,\r\n			urgency: (this.params.event_nseverity = isNaN(Number(this.params.event_nseverity)) ? 2 : this.params.event_nseverity)\r\n		}\r\n	};\r\n\r\n	this.dataFollowup = {\r\n		input: {\r\n			items_id: this.params.glpi_problem_id,\r\n			itemtype: \'Problem\',\r\n			content: this.params.alert_message + \'<br> <a href=\' + this.params.zabbix_url + \'>Link to problem in Zabbix</a>\',\r\n		}\r\n	};\r\n\r\n	this.result = { tags: {} };\r\n}\r\n\r\nGLPi.prototype.getAuthToken = function () {\r\n\r\n	this.request.addHeaders(\'Authorization: user_token \' + this.params.glpi_user_token);\r\n	if (this.params.use_app_token) {\r\n		this.request.addHeaders(\'App-Token: \' + this.params.glpi_app_token);\r\n	}\r\n	var response = this.request.jsonRequest(\'post\', this.params.glpi_url + \'/apirest.php/initSession\');\r\n\r\n	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.description, \'string\')) {\r\n			throw response.description;\r\n		}\r\n		else {\r\n			Logger.log(Logger.INFO, \'Request not successful. Received response: \' + JSON.stringify(response));\r\n			throw \'Unknown INFO. Check debug log for more information.\';\r\n		}\r\n	}\r\n	if (!CParamValidator.isType(response.session_token, \'string\') || CParamValidator.isEmpty(response.session_token)) {\r\n		Logger.log(Logger.INFO, \'Check getting GLPi sessionToken: \' + response.session_token);\r\n		throw \'Required GLPi sessionToken is not received.\';\r\n	}\r\n\r\n	return response.session_token;\r\n}\r\n\r\nGLPi.prototype.sendRequest = function (method, path, data) {\r\n\r\n	this.request.clearHeader();\r\n	this.request.addHeaders(\'Session-Token:\' + this.params.authToken);\r\n	if (this.params.use_app_token) {\r\n		this.request.addHeaders(\'App-Token: \' + this.params.glpi_app_token);\r\n	}\r\n	var response = this.request.jsonRequest(method, this.params.glpi_url + path, data);\r\n\r\n	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.description, \'string\')) {\r\n			throw response.description;\r\n		}\r\n		else {\r\n			Logger.log(Logger.INFO, \'Request not successful. Received response: \' + JSON.stringify(response));\r\n			throw \'Unknown INFO. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	return response;\r\n}\r\n\r\nGLPi.prototype.createProblem = function (status) {\r\n	this.data.input.content = this.params.alert_message + \'<br> <a href=\' + this.params.zabbix_url + \'>Link to problem in Zabbix</a>\';\r\n\r\n	if (CParamValidator.isDefined(status)) {\r\n		this.data.input.status = status;\r\n	}\r\n\r\n	var response = this.sendRequest(\'post\', \'/apirest.php/Problem/\', this.data);\r\n\r\n	if (!CParamValidator.isDefined(response.id)) {\r\n		throw \'Cannot create GPLi problem. Check debug log for more information.\';\r\n	}\r\n\r\n	return response.id\r\n}\r\n\r\nGLPi.prototype.updateProblem = function (status) {\r\n	CParamValidator.validate({ glpi_problem_id: { type: \'string\' } }, this.params);\r\n	this.data.id = this.params.glpi_problem_id;\r\n\r\n	if (CParamValidator.isDefined(status)) {\r\n		this.data.input.status = status;\r\n	}\r\n\r\n	this.sendRequest(\'put\', \'/apirest.php/Problem/\' + this.params.glpi_problem_id, this.data);\r\n	this.sendRequest(\'post\', \'/apirest.php/Problem/\' + this.params.glpi_problem_id + \'/ITILFollowup\', this.dataFollowup);\r\n}\r\n\r\nGLPi.prototype.onProblem = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	const problem_id = this.createProblem(1)\r\n\r\n	this.result.tags.__zbx_glpi_problem_id = problem_id;\r\n	this.result.tags.__zbx_glpi_link = this.params.glpi_url + \'/front/problem.form.php?id=\' + problem_id;\r\n\r\n	return this.result;\r\n}\r\n\r\nGLPi.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.updateProblem();\r\n\r\n	return this.result;\r\n}\r\n\r\nGLPi.prototype.onResolve = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.updateProblem(5);\r\n\r\n	return this.result;\r\n}\r\n\r\nGLPi.prototype.onDiscovery = function () {\r\n	return this.createProblem();\r\n}\r\n\r\nGLPi.prototype.onAutoreg = function () {\r\n	return this.createProblem();\r\n}\r\n\r\ntry {\r\n	var hook = new GLPi(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	hook.params.authToken = hook.getAuthToken();\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_glpi_link}','GLPi: Problem {EVENT.TAGS.__zbx_glpi_problem_id}','This media type integrates your Zabbix installation with your GLPi installation using the Zabbix webhook feature.\r\n\r\nGLPi configuration:\r\n\r\n1. Enable access to the GLPi REST API:\r\n- In the GLPi web interface, go to "Setup" → "General" → "API".\r\n- Set the "Enable Rest API" and "Enable Rest API" options to "Yes" and click the "Save" button.\r\n\r\n2. Add a new API client:\r\n- Click the "Add API client" button.\r\n- Specify the API client name and set the "Active" option to "Yes".\r\n- For security reasons, you may want to restrict the API client to the IP address of Zabbix server and/or create an additional application token (will be generated by default; you can uncheck the "Regenerate" checkbox if you don\'t want to use it).\r\n- Click the "Add" button.\r\n- If you\'ve opted to create an application token, open the settings of the created API client, and then copy and save the generated application token.\r\n\r\n3. Create a new user profile with permissions to create problems and followups (alternatively, you can use an existing profile with sufficient privileges):\r\n- Go to "Administration" → "Profiles" and click the "Add" button on the top of the page.\r\n- Specify the profile name and set the "Profile\'s Interface" option to "Standard Interface", and then click the "Add" button.\r\n- Open the created profile and click the "Assistance" tab.\r\n- Set the "Add followup (requester)" permission for the "Followups" line in the "Followups/Tasks" section.\r\n- Set the "Update", "Create", and "See all" permissions in the "Problems" section.\r\n- Click the "Save" button.\r\n\r\n4. Create a new user:\r\n- Go to "Administration" → "Users" and click the "Add User" button on the top of the page.\r\n- Specify the user login and set the "Profiles" option to the profile that you created in the previous step (or any other existing profile with permissions to create problems and followups).\r\n- Click the "Add" button.\r\n- Open the profile of the created user and check the "Regenerate" checkbox of the "API token" option; click "Save".\r\n- Copy and save the generated user API token.\r\n\r\nZabbix configuration:\r\n\r\n1. Before you can start using the GLPi webhook, set the global macro "{$ZABBIX.URL}":\r\n- In the Zabbix web interface, go to "Administration" → "Macros" in the top-left drop-down menu.\r\n- Set the global macro "{$ZABBIX.URL}" to the URL of the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.\r\n- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration, you might also need to append "/zabbix" to the end of URL. Good examples:\r\n  - http://zabbix.com\r\n  - https://zabbix.lan/zabbix\r\n  - http://server.zabbix.lan/\r\n  - http://localhost\r\n  - http://127.0.0.1:8080\r\n- Bad examples:\r\n  - zabbix.com\r\n  - http://zabbix/\r\n\r\n2. Set the following webhook parameters:\r\n- glpi_app_token - if you\'ve opted to use an application token during the creation of API client, specify it here; otherwise leave it empty\r\n- glpi_url - the frontend URL of your GLPi installation\r\n- glpi_user_token - the user token that was generated during creation of GLPi user\r\n\r\n3. Click the "Enabled" checkbox to enable the media type and click the "Update" button to save the webhook settings.\r\n\r\n4. Create a Zabbix user and add media:\r\n- To create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).\r\n- In the "Media" tab, click "Add" and select the type "GLPi" from the drop-down list. Add any value in the "Send to" field: it is not used in the webhook, but is required.\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to GLPi.\r\n\r\n5. Done! You can now start using this media type in actions and create problem items in GLPi.\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/glpi','0'),
('44','4','iLert','','','','','','','','25','0','0','0','0','1','3','10s','1','try {\r\n    var result = { tags: {} },\r\n        params = JSON.parse(value),\r\n        req = new HttpRequest(),\r\n        resp = \'\';\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.setProxy(params.HTTPProxy);\r\n    }\r\n    var alertSourceKey = params[\'.ILERT.ALERT.SOURCE.KEY\'];\r\n    if (!alertSourceKey || (typeof alertSourceKey === \'string\' && alertSourceKey.trim() === \'\')) {\r\n        throw \'incorrect value for variable "ILERT.ALERT.SOURCE.KEY". The value must be a non-empty string.\';\r\n    }\r\n    delete params[\'.ILERT.ALERT.SOURCE.KEY\'];\r\n    \r\n    var ilertApiBaseURL = "https://api.ilert.com";\r\n    var reqURL = encodeURI(ilertApiBaseURL + "/api/v1/events/zabbix-mt/" + alertSourceKey)\r\n\r\n    var incidentKey = "zabbix-" + params[\'EVENT.ID\'];\r\n    var incidentViewURL = ilertApiBaseURL + "/api/v1/incidents/resolve-ik/" + alertSourceKey + "/" + incidentKey;\r\n\r\n    req.addHeader(\'Accept: application/json\');\r\n    req.addHeader(\'Content-Type: application/json\');\r\n\r\n    Zabbix.log(4, \'[iLert Webhook] Sending request:\' + JSON.stringify(params));\r\n    resp = req.post(reqURL, JSON.stringify(params));\r\n    Zabbix.log(4, \'[iLert Webhook] Receiving response:\' + resp);\r\n\r\n    try {\r\n        resp = JSON.parse(resp);\r\n    }\r\n    catch (error) {\r\n        throw \'incorrect response. iLert returned a non-JSON object.\';\r\n    }\r\n\r\n    if (req.getStatus() == 200) {\r\n        result.tags.__ilert_incident_url = incidentViewURL;\r\n        return JSON.stringify(result);\r\n    }\r\n\r\n    if (req.getStatus() == 400 && typeof resp === \'object\' && typeof resp.code === \'string\') {\r\n        if (resp.code === \'NO_OPEN_INCIDENT_WITH_KEY\') {\r\n          return JSON.stringify(result);\r\n        }\r\n        if (resp.code === \'INCIDENT_ALREADY_ACCEPTED\') {\r\n          result.tags.__ilert_incident_url = incidentViewURL;\r\n          return JSON.stringify(result);\r\n        }\r\n    }\r\n\r\n    if (typeof resp === \'object\' && typeof resp.message === \'string\') {\r\n        throw resp.message;\r\n    }\r\n    else {\r\n        throw \'Unknown error.\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[iLert Webhook] Notification failed : \' + error);\r\n    throw \'iLert notification failed : \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__ilert_incident_url}','iLert incident','Please refer to https://docs.ilert.com/integrations/zabbix/native \r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "iLert". You can also rewrite the incident summary via ".ILERT.INCIDENT.SUMMARY" parameter or leave it empty to use the standard pattern.','0'),
('45','4','iTop','','','','','','','','25','0','0','0','0','1','3','10s','1','var Itop = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        if (params.log !== \'private_log\' && params.log !== \'public_log\') {\r\n            throw \'Incorrect "itop_log" parameter given: \' + params.log + \'\\nMust be "private_log" or "public_log".\';\r\n        }\r\n\r\n        Itop.params = params;\r\n        if (typeof Itop.params.url === \'string\') {\r\n            if (!Itop.params.url.endsWith(\'/\')) {\r\n                Itop.params.url += \'/\';\r\n            }\r\n\r\n            Itop.params.url += \'webservices/rest.php?version=\' + encodeURIComponent(Itop.params.api_version);\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Itop.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setCreatePayload: function () {\r\n        json_data.operation = \'core/create\';\r\n        json_data.fields.org_id = Itop.params.organization_id;\r\n        json_data.fields.title = params.alert_subject;\r\n        json_data.fields.description = params.alert_message.replace(\'<\', \'&lt;\')\r\n            .replace(\'>\', \'&gt;\')\r\n            .replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n    },\r\n\r\n    setUpdatePayload: function () {\r\n        json_data.operation = \'core/update\';\r\n        json_data.key = Itop.params.id;\r\n        json_data.fields.title = params.alert_subject;\r\n        json_data.fields[Itop.params.log] = {\r\n            add_item: {\r\n                message: params.alert_subject + \'\\n\' + params.alert_message,\r\n                format: \'text\'\r\n            }\r\n        };\r\n    },\r\n\r\n    request: function (data) {\r\n        [\'url\', \'user\', \'password\', \'organization_id\', \'class\', \'api_version\', \'id\'].forEach(function (field) {\r\n            if (typeof Itop.params !== \'object\' || typeof Itop.params[field] === \'undefined\'\r\n                    || Itop.params[field] === \'\' ) {\r\n                throw \'Required Itop param is not set: "itop_\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Itop.params.url,\r\n            request = new HttpRequest(),\r\n            object;\r\n\r\n        request.addHeader(\'Content-Type: multipart/form-data\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(Itop.params.user + \':\' + Itop.params.password));\r\n\r\n        if (Itop.HTTPProxy) {\r\n            request.setProxy(Itop.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ iTop Webhook ] Sending request: \' + url + \'&json_data=\' + data);\r\n\r\n        response = request.post(url + \'&json_data=\' + encodeURIComponent(data));\r\n\r\n        Zabbix.log(4, \'[ iTop Webhook ] Received response with status code \' + request.getStatus() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ iTop Webhook ] Failed to parse response received from iTop\');\r\n            throw \'Failed to parse response received from iTop.\\nRequest status code \' +\r\n                    request.getStatus() + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            throw \'Request failed with status code \' + request.getStatus() + \'. Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.code !== \'undefined\' && response.code !== 0) {\r\n            throw \'Request failed with iTop code \' + response.code + \': \' +\r\n                    JSON.stringify(response.message) + \'. Check debug log for more information.\';\r\n        }\r\n        else {\r\n            Object.keys(response.objects)\r\n                .forEach(function (key) {\r\n                    object = response.objects[key];\r\n                });\r\n    \r\n            return {\r\n                status: request.getStatus(),\r\n                response: object.fields\r\n            };\r\n        }\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        json_data = {},\r\n        itop_params = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'summary\', \'event_recovery_value\',\r\n            \'event_source\', \'event_value\', \'action_name\'\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'itop_\')) {\r\n                itop_params[key.substring(5)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    Itop.setParams(itop_params);\r\n    Itop.setProxy(params.HTTPProxy);\r\n\r\n    json_data.operation = \'\';\r\n    json_data.class = Itop.params.class;\r\n    json_data.comment = Itop.params.comment;\r\n    json_data.output_fields = \'id, friendlyname\';\r\n    json_data.fields = {};\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        Itop.setCreatePayload();\r\n        Itop.request(json_data);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n            && (Itop.params.id === \'{EVENT.TAGS.__zbx_itop_id}\' || Itop.params.id === \'*UNKNOWN*\')) {\r\n        Itop.setCreatePayload();\r\n\r\n        var response = Itop.request(json_data);\r\n\r\n        result.tags.__zbx_itop_id = response.response.id;\r\n        result.tags.__zbx_itop_key = response.response.friendlyname;\r\n        result.tags.__zbx_itop_link = params.itop_url + (params.itop_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n                \'pages/UI.php?operation=details&class=\' + encodeURIComponent(Itop.params.class) + \'&id=\' +\r\n                encodeURIComponent(response.response.id);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (Itop.params.id === \'{EVENT.TAGS.__zbx_itop_id}\' || Itop.params.id === \'*UNKNOWN*\') {\r\n            throw \'Incorrect iTop ticket ID given: \' + Itop.params.id;\r\n        }\r\n        Itop.setUpdatePayload();\r\n        Itop.request(json_data);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ iTop Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_itop_link}','iTop: {EVENT.TAGS.__zbx_itop_key}','','0'),
('46','4','Jira','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nvar ZABBIX_SEVERITY_MAP = ["not_classified", "information", "warning", "average", "high", "disaster"];\r\n\r\nvar serviceLogName = \'Jira Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Jira = CWebhook;\r\n\r\nJira.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		jira_url: { type: \'string\', url: true},\r\n		jira_user: { type: \'string\' },\r\n		jira_password: { type: \'string\' },\r\n		jira_issue_type: { type: \'string\' },\r\n		jira_project_key: { type: \'string\' },\r\n		event_source: { type: \'string\' },\r\n		alert_subject: { type: \'string\' },\r\n		alert_message: { type: \'string\' },\r\n		event_nseverity: { type: \'integer\', default: 0 }\r\n	}, this.params);\r\n\r\n	this.priority = this.params.event_source == 3 ? this.params.jira_priority_internal : this.params[\'severity_\' + ZABBIX_SEVERITY_MAP[this.params.event_nseverity]];\r\n	this.params.event_tags_json = parseTags(this.params.event_tags_json, false);\r\n\r\n	if (this.params.event_tags_json.length > 0) {\r\n		this.labels = setLabels(this.params.event_tags_json);\r\n	}\r\n\r\n	parseOptionalFields();\r\n\r\n	this.result = { tags: {} };\r\n}\r\n\r\nfunction escapeMarkup(str) {\r\n	var length = str.length,\r\n		result = \'\',\r\n		markup = [\'{\', \'|\', \'}\', \'~\', \'_\', \'\\\\\', \'[\', \']\', \'^\', \'<\', \'>\', \'?\', \'!\', \'#\', \'+\', \'*\', \'&\'];\r\n\r\n	for (var i = 0; i < length; i++) {\r\n		var char = str[i];\r\n		result += (markup.indexOf(char) !== -1) ? (\'&#\' + str[i].charCodeAt() + \';\') : char;\r\n	}\r\n\r\n	return result;\r\n}\r\n\r\nfunction parseOptionalFields() {\r\n	this.params.customfields = {};\r\n	this.params.components = [];\r\n\r\n	Object.keys(this.params).forEach(function (key) {\r\n		if (key.startsWith(\'customfield_\')) {\r\n			this.params.customfields[key] = this.params[key];\r\n		}\r\n\r\n		if (key.startsWith(\'component_\')) {\r\n			this.params.components.push({"name": this.params[key]})\r\n		}\r\n	});\r\n}\r\n\r\nJira.prototype.addCustomFields = function (data) {\r\n	if (typeof this.params.customfields === \'object\' && Object.keys(this.params.customfields).length) {\r\n		var schemaData = this.sendRequest(\'GET\', \'/rest/api/latest/field\'),\r\n			schema = {};\r\n\r\n		schemaData.forEach(function (item) {\r\n			schema[item.id] = item.schema;\r\n		});\r\n\r\n		Object.keys(this.params.customfields).forEach(function (field) {\r\n			if (typeof schema[field] === \'object\' && schema[field].type) {				\r\n				const type = schema[field].type;\r\n\r\n				if (type === \'number\') {\r\n					data.fields[field] = parseInt(this.params.customfields[field]);\r\n				}\r\n				else if (type === \'string\' && schema[field][\'custom\'].split(\':\')[1] === \'url\') {\r\n					if (this.params.customfields[field] === \'zabbix_url\') {\r\n						data.fields[field] = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n					} else {\r\n						data.fields[field] = this.params.customfields[field];\r\n					}\r\n				}\r\n				else if (type === \'date\') {\r\n					if (this.params.customfields[field].match(/\\d+[.-]\\d+[.-]\\d+/) !== null) {\r\n						data.fields[field] = this.params.customfields[field].replace(/\\./g, \'-\');\r\n					}\r\n				}\r\n				else if (type === \'datetime\') {\r\n					if (this.params.customfields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n						data.fields[field] = this.params.customfields[field].replace(/\\./g, \'-\');\r\n					}\r\n				}\r\n				else if (type === \'option\') {\r\n					data.fields[field] = { \'value\': this.params.customfields[field] };\r\n				}\r\n				else if (type === \'array\') {\r\n					if (schema[field].items === \'option\') {\r\n						const valuesList = this.params.customfields[field].split(\',\');\r\n						data.fields[field] = [];\r\n						valuesList.forEach(function (val) {\r\n							data.fields[field].push({\'value\': val})\r\n						});\r\n					}\r\n					else {\r\n						data.fields[field] = [this.params.customfields[field]];\r\n					}\r\n				}\r\n				else {\r\n					data.fields[field] = this.params.customfields[field];\r\n				}\r\n			}\r\n		});\r\n	}\r\n	else {\r\n		Logger.log(Logger.WARN, \'No customfields found.\');\r\n	}\r\n\r\n	return data;\r\n}\r\n\r\nfunction parseTags(event_tags) {\r\n	try {\r\n		return JSON.parse(event_tags);\r\n	}\r\n	catch (error) {\r\n		if (this.params.event_source == 0 || this.params.event_source > 2) {\r\n			Logger.log(Logger.WARN, \'No event tags were found. Should be an object. Received event tags: "\' + event_tags + \'".\');\r\n		}\r\n		return [];\r\n	}\r\n}\r\n\r\nfunction getTagValue(tags, key, throw_on_fail) {\r\n	for (i in tags) {\r\n		if (tags[i].tag === key) {\r\n			return tags[i].value\r\n		}\r\n	}\r\n\r\n	if (!throw_on_fail) {\r\n		return false;\r\n	} else {\r\n		throw \'Tag "\' + key + \'" is not in the event tag list.\'\r\n	}\r\n};\r\n\r\nfunction setLabels(event_tags_json) {\r\n	var buffer = [];\r\n\r\n	event_tags_json.forEach(function (tag) {\r\n		if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\' && !tag.tag.startsWith(\'__zbx\')) {\r\n			label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n			if (label.length < 256) {\r\n				buffer.push(label);\r\n			}\r\n		}\r\n	});\r\n\r\n	if (buffer.length === 0) {\r\n		Logger.log(Logger.WARN, \'No labels were set.\');\r\n	}\r\n\r\n	return buffer;\r\n}\r\n\r\nJira.prototype.commentIssue = function (issue_key) {\r\n	var data = {\r\n		body: this.params.alert_message,\r\n	};\r\n	this.sendRequest(\'POST\', \'/rest/api/latest/issue/\' + encodeURIComponent(issue_key) + \'/comment\', data);\r\n}\r\n\r\nJira.prototype.sendRequest = function (method, path, data) {\r\n	this.request.clearHeader();\r\n	this.request.addHeaders(\'Authorization: Basic \' + btoa(this.params.jira_user + \':\' + this.params.jira_password));\r\n\r\n	var response = this.request.jsonRequest(method, this.params.jira_url + path, data);\r\n\r\n	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {\r\n		Logger.log(Logger.WARN, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.description, \'string\')) {\r\n			throw response.description;\r\n		}\r\n		else {\r\n			Logger.log(Logger.WARN, \'Request not successful. Received response: \' + JSON.stringify(response));\r\n			throw \'Unknown error. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	return response;\r\n}\r\n\r\nJira.prototype.onProblem = function (alert) {\r\n	if (this.params.event_tags_json.length > 0 && getTagValue(this.params.event_tags_json, \'__zbx_jira_issuekey\', false) !== false) {\r\n		return this.onUpdate(alert, true);\r\n	}\r\n\r\n	var data = {\r\n		fields: {\r\n			project: {\r\n				key: this.params.jira_project_key\r\n			},\r\n			issuetype: {\r\n				name: this.params.jira_issue_type\r\n			},\r\n			summary: this.params.alert_subject,\r\n			description: this.params.alert_message,\r\n			priority: {\r\n				"name": this.priority\r\n			}\r\n		}\r\n	};\r\n\r\n	if (this.labels && this.labels.length > 0) {\r\n		data.fields.labels = this.labels;\r\n	}\r\n\r\n	if (this.params.components && this.params.components.length > 0) {\r\n		data.fields.components = this.params.components;\r\n	}\r\n\r\n	var response = this.sendRequest(\'POST\', \'/rest/api/latest/issue\', this.addCustomFields(data));\r\n	this.result.tags = {\r\n		__zbx_jira_issuekey: response.key,\r\n		__zbx_jira_issuelink: this.params.jira_url + \'/browse/\' + response.key\r\n	}\r\n	return this.result;\r\n}\r\n\r\nJira.prototype.onUpdate = function (alert, dontUpdatePriority) {\r\n	var data = {\r\n		fields: {\r\n			summary: this.params.alert_subject,\r\n			priority: {\r\n				"name": this.priority\r\n			}\r\n		}\r\n	};\r\n\r\n	if (dontUpdatePriority && this.params.event_source != 0) {\r\n		delete data[\'fields\'][\'priority\'];\r\n	}\r\n\r\n	var jira_issue_key = getTagValue(this.params.event_tags_json, \'__zbx_jira_issuekey\', true);\r\n	this.sendRequest(\'PUT\', \'/rest/api/latest/issue/\' + encodeURIComponent(jira_issue_key) + \'?returnIssue=true\', this.addCustomFields(data));\r\n	this.commentIssue(jira_issue_key);\r\n\r\n	return this.result;\r\n}\r\n\r\nJira.prototype.onResolve = function (alert) {\r\n	return this.onUpdate(alert, true);\r\n}\r\n\r\nJira.prototype.onDiscovery = function (alert) {\r\n	this.priority = this.params.jira_priority_discovery;\r\n	return this.onProblem(alert);\r\n}\r\n\r\nJira.prototype.onAutoreg = function (alert) {\r\n	this.priority = this.params.jira_priority_autoregistration;\r\n	return this.onProblem(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new Jira(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_issuelink}','Jira: {EVENT.TAGS.__zbx_jira_issuekey}','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/jira\r\n\r\n1. To make this integration work, you will need the following from Jira:\r\n  * Jira instance URL;\r\n  * Jira project key and issue type that the issues created by Zabbix will use;\r\n  * Jira username and password or API token. API token is strongly recommended and can be obtained at https://id.atlassian.com/manage/api-tokens.\r\n2. In the Zabbix web interface, go to Administration → Macros section. Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend.\r\n3. On this page replace the placeholder \'<...>\' values with the ones from the step #1.\r\n4. In Zabbix, you need to have a Zabbix user and add Media with the Jira media type. Make sure this user has access to all hosts for which you would like problem issues to be created in Jira.','0'),
('47','4','Jira Service Management','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nvar ZABBIX_SEVERITY_MAP = ["not_classified", "information", "warning", "average", "high", "disaster"];\r\n\r\nvar serviceLogName = \'Jira Service Management Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Jira = CWebhook;\r\n\r\nJira.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		jira_url: { type: \'string\', url: true},\r\n		jira_user: { type: \'string\' },\r\n		jira_password: { type: \'string\' },\r\n		jira_request_type_id: { type: \'string\' },\r\n		jira_servicedesk_id: { type: \'string\' },\r\n		issue_comments_public: {type: \'boolean\', default: false},\r\n		event_source: { type: \'string\' },\r\n		alert_subject: { type: \'string\' },\r\n		alert_message: { type: \'string\' },\r\n		event_nseverity: { type: \'integer\', default: 0 }\r\n	}, this.params);\r\n\r\n	this.priority = this.params.event_source == 3 ? this.params.jira_priority_internal : this.params[\'severity_\' + ZABBIX_SEVERITY_MAP[this.params.event_nseverity]];\r\n	this.params.event_tags_json = parseTags(this.params.event_tags_json, false);\r\n\r\n	if (this.params.event_tags_json.length > 0) {\r\n		this.labels = setLabels(this.params.event_tags_json);\r\n	}\r\n\r\n	parseOptionalFields();\r\n\r\n	this.result = { tags: {} };\r\n}\r\n\r\nfunction escapeMarkup(str) {\r\n	var length = str.length,\r\n		result = \'\',\r\n		markup = [\'{\', \'|\', \'}\', \'~\', \'_\', \'\\\\\', \'[\', \']\', \'^\', \'<\', \'>\', \'?\', \'!\', \'#\', \'+\', \'*\', \'&\'];\r\n\r\n	for (var i = 0; i < length; i++) {\r\n		var char = str[i];\r\n		result += (markup.indexOf(char) !== -1) ? (\'&#\' + str[i].charCodeAt() + \';\') : char;\r\n	}\r\n\r\n	return result;\r\n}\r\n\r\nfunction parseOptionalFields() {\r\n	this.params.customfields = {};\r\n	this.params.components = [];\r\n\r\n	Object.keys(this.params).forEach(function (key) {\r\n		if (key.startsWith(\'customfield_\')) {\r\n			this.params.customfields[key] = this.params[key];\r\n		}\r\n\r\n		if (key.startsWith(\'component_\')) {\r\n			this.params.components.push({"name": this.params[key]})\r\n		}\r\n	});\r\n}\r\n\r\nJira.prototype.addCustomFields = function (data, requestFieldValues) {\r\n	if (typeof this.params.customfields === \'object\' && Object.keys(this.params.customfields).length) {\r\n		var schemaData = this.sendRequest(\'GET\', \'/rest/api/latest/field\'),\r\n			schema = {};\r\n\r\n		schemaData.forEach(function (item) {\r\n			schema[item.id] = item.schema;\r\n		});\r\n\r\n		var placeholder = (requestFieldValues ? \'requestFieldValues\' : \'fields\');\r\n\r\n		Object.keys(this.params.customfields).forEach(function (field) {\r\n			if (typeof schema[field] === \'object\' && schema[field].type) {\r\n				const type = schema[field].type;\r\n\r\n				if (type === \'number\') {\r\n					data[placeholder][field] = parseInt(this.params.customfields[field]);\r\n				}\r\n				else if (type === \'string\' && schema[field][\'custom\'].split(\':\')[1] === \'url\') {\r\n					if (this.params.customfields[field] === \'zabbix_url\') {\r\n						data[placeholder][field] = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n					} else {\r\n						data[placeholder][field] = this.params.customfields[field];\r\n					}\r\n				}\r\n				else if (type === \'date\') {\r\n					if (this.params.customfields[field].match(/\\d+[.-]\\d+[.-]\\d+/) !== null) {\r\n						data[placeholder][field] = this.params.customfields[field].replace(/\\./g, \'-\');\r\n					}\r\n				}\r\n				else if (type === \'datetime\') {\r\n					if (this.params.customfields[field].match(/\\d+[.-]\\d+[.-]\\d+T\\d+:\\d+:\\d+/) !== null) {\r\n						data[placeholder][field] = this.params.customfields[field].replace(/\\./g, \'-\');\r\n					}\r\n				}\r\n				else if (type === \'option\') {\r\n					data[placeholder][field] = { \'value\': this.params.customfields[field] };\r\n				}\r\n				else if (type === \'array\') {\r\n					if (schema[field].items === \'option\') {\r\n						const valuesList = this.params.customfields[field].split(\',\');\r\n						data[placeholder][field] = [];\r\n						valuesList.forEach(function (val) {\r\n							data[placeholder][field].push({\'value\': val})\r\n						});\r\n					}\r\n					else {\r\n						data[placeholder][field] = [this.params.customfields[field]];\r\n					}\r\n				}\r\n				else {\r\n					data[placeholder][field] = this.params.customfields[field];\r\n				}\r\n			}\r\n		});\r\n	}\r\n	else {\r\n		Logger.log(Logger.WARN, \'No customfields found.\');\r\n	}\r\n\r\n	return data;\r\n}\r\n\r\nfunction parseTags(event_tags) {\r\n	try {\r\n		return JSON.parse(event_tags);\r\n	}\r\n	catch (error) {\r\n		if (this.params.event_source == 0 || this.params.event_source > 2) {\r\n			Logger.log(Logger.WARN, \'No event tags were found. Should be an object. Received event tags: "\' + event_tags + \'".\');\r\n		}\r\n		return [];\r\n	}\r\n}\r\n\r\nfunction getTagValue(tags, key, throw_on_fail) {\r\n	for (i in tags) {\r\n		if (tags[i].tag === key) {\r\n			return tags[i].value\r\n		}\r\n	}\r\n\r\n	if (!throw_on_fail) {\r\n		return false;\r\n	} else {\r\n		throw \'Tag "\' + key + \'" is not in the event tag list.\'\r\n	}\r\n};\r\n\r\nfunction setLabels(event_tags_json) {\r\n	var buffer = [];\r\n\r\n	event_tags_json.forEach(function (tag) {\r\n		if (typeof tag.tag !== \'undefined\' && typeof tag.value !== \'undefined\' && !tag.tag.startsWith(\'__zbx\')) {\r\n			label = (tag.tag + (tag.value ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n			if (label.length < 256) {\r\n				buffer.push(label);\r\n			}\r\n		}\r\n	});\r\n\r\n	if (buffer.length === 0) {\r\n		Logger.log(Logger.WARN, \'No labels were set.\');\r\n	}\r\n\r\n	return buffer;\r\n}\r\n\r\nJira.prototype.commentIssue = function (issue_key) {\r\n	var data = {\r\n		body: this.params.alert_message,\r\n		public: this.params.issue_comments_public\r\n	};\r\n	this.sendRequest(\'POST\', \'/rest/servicedeskapi/request/\' + encodeURIComponent(issue_key) + \'/comment\', data);\r\n}\r\n\r\nJira.prototype.sendRequest = function (method, path, data) {\r\n	this.request.clearHeader();\r\n	this.request.addHeaders(\'Authorization: Basic \' + btoa(this.params.jira_user + \':\' + this.params.jira_password));\r\n\r\n	var response = this.request.jsonRequest(method, this.params.jira_url + path, data);\r\n\r\n	if ((this.request.getStatus() !== 200 && this.request.getStatus() !== 201)) {\r\n		Logger.log(Logger.WARN, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.description, \'string\')) {\r\n			throw response.description;\r\n		}\r\n		else {\r\n			Logger.log(Logger.WARN, \'Request not successful. Received response: \' + JSON.stringify(response));\r\n			throw \'Unknown error. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	return response;\r\n}\r\n\r\nJira.prototype.onProblem = function (alert) {\r\n	if (this.params.event_tags_json.length > 0 && getTagValue(this.params.event_tags_json, \'__zbx_jira_requestkey\', false) !== false) {\r\n		return this.onUpdate(alert, true);\r\n	}\r\n\r\n	var data = {\r\n		serviceDeskId: this.params.jira_servicedesk_id,\r\n		requestTypeId: this.params.jira_request_type_id,\r\n		requestFieldValues: {\r\n			summary: this.params.alert_subject,\r\n			description: this.params.alert_message,\r\n			priority: {\r\n				"name": this.priority\r\n			}\r\n		}\r\n	};\r\n\r\n	if (this.labels && this.labels.length > 0) {\r\n		data.requestFieldValues.labels = this.labels;\r\n	}\r\n\r\n	if (this.params.components && this.params.components.length > 0) {\r\n		data.requestFieldValues.components = this.params.components;\r\n	}\r\n\r\n	var response = this.sendRequest(\'POST\', \'/rest/servicedeskapi/request\', this.addCustomFields(data, true));\r\n	this.result.tags = {\r\n		__zbx_jira_requestkey: response.issueKey,\r\n		__zbx_jira_requestlink: this.params.jira_url + \'/browse/\' + response.issueKey\r\n	}\r\n	return this.result;\r\n}\r\n\r\nJira.prototype.onUpdate = function (alert, dontUpdatePriority) {\r\n	var data = {\r\n		fields: {\r\n			summary: this.params.alert_subject,\r\n			priority: {\r\n				"name": this.priority\r\n			}\r\n		}\r\n	};\r\n\r\n	if (dontUpdatePriority && this.params.event_source != 0) {\r\n		delete data[\'fields\'][\'priority\'];\r\n	}\r\n\r\n	var jira_issue_key = getTagValue(this.params.event_tags_json, \'__zbx_jira_requestkey\', true);\r\n	this.sendRequest(\'PUT\', \'/rest/api/latest/issue/\' + encodeURIComponent(jira_issue_key) + \'?returnIssue=true\', this.addCustomFields(data));\r\n	this.commentIssue(jira_issue_key);\r\n\r\n	return this.result;\r\n}\r\n\r\nJira.prototype.onResolve = function (alert) {\r\n	return this.onUpdate(alert, true);\r\n}\r\n\r\nJira.prototype.onDiscovery = function (alert) {\r\n	this.priority = this.params.jira_priority_discovery;\r\n	return this.onProblem(alert);\r\n}\r\n\r\nJira.prototype.onAutoreg = function (alert) {\r\n	this.priority = this.params.jira_priority_autoregistration;\r\n	return this.onProblem(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new Jira(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_jira_requestlink}','Jira Service Management: {EVENT.TAGS.__zbx_jira_requestkey}','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/jira_service_management\r\n\r\n1. To make this integration work, you will need the following from Jira:\r\n  * Jira instance URL;\r\n  * Jira service desk id and request type id that the issues created by Zabbix will use;\r\n  * Jira username and password or API token. API token is strongly recommended and can be obtained at https://id.atlassian.com/manage/api-tokens.\r\n2. In the Zabbix web interface, go to Administration → Macros section. Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend.\r\n3. On this page replace the placeholder \'<...>\' values with the ones from the step #1.\r\n4. In Zabbix, you need to have a Zabbix user and add Media with the Jira Service Management media type. Make sure this user has access to all hosts for which you would like problem issues to be created in Jira.','0'),
('48','4','Line','','','','','','','','25','0','0','0','0','1','3','10s','1','function sendMessage(to, messages, params) {\r\n    var response,\r\n        request = new HttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    request.addHeader(\'Content-Type: application/json\');\r\n    request.addHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    response = request.post(\'https://api.line.me/v2/bot/message/push\', JSON.stringify({\r\n        "to": to,\r\n        "messages": messages\r\n    }));\r\n\r\n    if (request.getStatus() !== 200) {\r\n        throw response;\r\n    }\r\n}\r\n\r\nfunction validateParams(params) {\r\n    if (typeof params.bot_token !== \'string\' || params.bot_token.trim() === \'\') {\r\n        throw \'Field "bot_token" cannot be empty\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\') {\r\n        params.event_nseverity = \'0\';\r\n        params.event_severity = \'Not classified\';\r\n        params.event_update_status = \'0\';\r\n    }\r\n\r\n    if (params.event_source === \'1\' || params.event_source === \'2\') {\r\n        params.event_value = \'1\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (isNaN(params.trigger_id) && params.event_source === \'0\') {\r\n        throw \'field "trigger_id" is not a number\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\') {\r\n        throw \'Field "zabbix_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {\r\n        throw \'Field "zabbix_url" must contain a schema\';\r\n    }\r\n}\r\n\r\nfunction getZabbixProblemLink(params) {\r\n    return params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id;    \r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    validateParams(params);\r\n\r\n    severity_emoji = [\r\n        "\\u26AA",\r\n        "\\uD83D\\uDD35",\r\n        "\\uD83D\\uDFE4",\r\n        "\\uD83D\\uDFE1",\r\n        "\\uD83D\\uDFE0",\r\n        "\\uD83D\\uDD34",\r\n    ];\r\n\r\n    // If its a trigger and a recovery operation and not an update operation.\r\n    if (params.event_source === \'0\' && params.event_value === \'0\' && params.event_update_status === \'0\') {\r\n        var line_message = [\r\n            {\r\n                "type": "text",\r\n                "text": \'\\u2705 \' + params.alert_subject + \'\\n\\n\' + params.alert_message + \'\\n\' + params.trigger_description + \'\\n\\n\' + getZabbixProblemLink(params)\r\n            }\r\n        ];\r\n    }\r\n    // If its a trigger and its a problem.\r\n    else if (params.event_source === \'0\' && params.event_value === \'1\') {\r\n        var line_message = [\r\n            {\r\n                "type": "text",\r\n                "text": severity_emoji[params.event_nseverity] + \' \' + params.alert_subject + \'\\n\\n\' + params.alert_message + \'\\n\' + params.trigger_description + \'\\n\\n\' + getZabbixProblemLink(params)\r\n            }\r\n        ];\r\n    }\r\n    // If its a trigger and its an update operation.\r\n    else if (params.event_source === \'0\' && params.event_update_status === \'1\') {\r\n        var line_message = [\r\n            {\r\n                "type": "text",\r\n                "text": \'\\u2733 \' + severity_emoji[params.event_nseverity] + \' \' + params.alert_subject + \'\\n\\n\' + params.alert_message + \'\\n\' + params.trigger_description + \'\\n\\n\' + getZabbixProblemLink(params)\r\n            }\r\n        ];\r\n    }\r\n    else {\r\n        var line_message = [\r\n            {\r\n                "type": "text",\r\n                "text": params.alert_subject + \'\\n\\n\' + params.alert_message + \'\\n\'\r\n            }\r\n        ];\r\n    }\r\n\r\n    sendMessage(params.send_to, line_message, params);\r\n\r\n    return \'OK\';\r\n}\r\ncatch (err) {\r\n    Zabbix.log(4, \'[ Line Webhook ] Line notification failed : \' + err);\r\n    throw \'Line notification failed : \' + err;\r\n}','30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/line\r\n\r\nSet bot_token parameter to your Line bot token.\r\nWhen assigning Line media to the Zabbix user - add the ID of the target recipient. Use a userId, groupId, or roomId value.','0'),
('49','4','ManageEngine ServiceDesk','','','','','','','','25','0','0','0','0','1','3','10s','1','var MEngine = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        MEngine.params = params;\r\n        if (typeof MEngine.params.url === \'string\') {\r\n            if (!MEngine.params.url.endsWith(\'/\')) {\r\n                MEngine.params.url += \'/\';\r\n            }\r\n\r\n            MEngine.params.url += \'api/v3/\';\r\n        }\r\n\r\n        if (MEngine.params.on_premise.toLowerCase() !== \'true\'\r\n                && typeof MEngine.params.on_demand_url_auth === \'string\') {\r\n            if (!MEngine.params.on_demand_url_auth.endsWith(\'/\')) {\r\n                MEngine.params.on_demand_url_auth += \'/\';\r\n            }\r\n\r\n            MEngine.params.on_demand_url_auth += \'oauth/v2/token?\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        MEngine.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    createLink: function (id, url) {\r\n        return url + (url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            ((MEngine.params.on_premise.toLowerCase() === \'true\')\r\n                ? (\'WorkOrder.do?woMode=viewWO&woID=\' + id)\r\n                : (\'app/itdesk/ui/requests/\' + id + \'/details\')\r\n            );\r\n    },\r\n\r\n    refreshAccessToken: function () {\r\n        [\r\n            \'on_demand_url_auth\',\r\n            \'on_demand_refresh_token\',\r\n            \'on_demand_client_id\',\r\n            \'on_demand_client_secret\'\r\n        ].forEach(function (field) {\r\n            if (typeof MEngine.params !== \'object\' || typeof MEngine.params[field] === \'undefined\'\r\n                    || MEngine.params[field].trim() === \'\' ) {\r\n                throw \'Required MEngine param is not set: "sd_\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            request = new HttpRequest(),\r\n            url = MEngine.params.on_demand_url_auth +\r\n                \'refresh_token=\' + encodeURIComponent(MEngine.params.on_demand_refresh_token) +\r\n                \'&grant_type=refresh_token&client_id=\' + encodeURIComponent(MEngine.params.on_demand_client_id) +\r\n                \'&client_secret=\' + encodeURIComponent(MEngine.params.on_demand_client_secret) +\r\n                \'&redirect_uri=https://www.zoho.com&scope=SDPOnDemand.requests.ALL\';\r\n\r\n        if (MEngine.HTTPProxy) {\r\n            request.setProxy(MEngine.HTTPProxy);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Refreshing access token. Request: \' + url);\r\n\r\n        response = request.post(url);\r\n\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Received response with status code \' +\r\n        request.getStatus() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ ManageEngine Webhook ] Failed to parse response received from Zoho Accounts\');\r\n        }\r\n\r\n        if ((request.getStatus() < 200 || request.getStatus() >= 300) && !response.access_token) {\r\n            throw \'Access token refresh failed with HTTP status code \' + request.getStatus() +\r\n                \'. Check debug log for more information.\';\r\n        }\r\n        else {\r\n            MEngine.params.on_demand_auth_token = response.access_token;\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        var response,\r\n            url = MEngine.params.url + query,\r\n            input,\r\n            request = new HttpRequest(),\r\n            message;\r\n\r\n        if (MEngine.params.on_premise.toLowerCase() === \'true\') {\r\n            request.addHeader(\'TECHNICIAN_KEY: \' + MEngine.params.on_premise_auth_token);\r\n        }\r\n        else {\r\n            request.addHeader(\'Authorization: Zoho-oauthtoken \' + MEngine.params.on_demand_auth_token);\r\n            request.addHeader(\'Accept: application/v3+json\');\r\n        }\r\n\r\n        if (MEngine.HTTPProxy) {\r\n            request.setProxy(MEngine.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        input = \'input_data=\' + encodeURIComponent(data);\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Sending request: \' + url + \'?\' + input);\r\n\r\n        switch (method) {\r\n            case \'post\':\r\n                response = request.post(url, input);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, input);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ManageEngine Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ ManageEngine Webhook ] Failed to parse response received from ManageEngine\');\r\n        }\r\n\r\n        if ((request.getStatus() < 200 || request.getStatus() >= 300)\r\n                && typeof response.response_status !== \'object\') {\r\n            throw \'Request failed with HTTP status code \' + request.getStatus() +\r\n                \'. Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.response_status === \'object\' && response.response_status.status === \'failed\') {\r\n            message = \'Request failed with status_code \';\r\n\r\n            if (typeof response.response_status.messages === \'object\'\r\n                    && response.response_status.messages[0]\r\n                    && response.response_status.messages[0].message) {\r\n                message += response.response_status.messages[0].status_code +\r\n                    \'. Message: \' + response.response_status.messages[0].message;\r\n            }\r\n            else {\r\n                message += response.response_status.status_code;\r\n            }\r\n\r\n            message += \'. Check debug log for more information.\';\r\n            throw message;\r\n        }\r\n        else if (response.request) {\r\n            return response.request.id;\r\n        }\r\n    },\r\n\r\n    createPaylaod: function (fields, isNote) {\r\n        var data = {},\r\n            result;\r\n\r\n        if (isNote) {\r\n            data.description = fields[\'field_string:description\'].replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n            result = {request_note: data};\r\n        }\r\n        else {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field].trim() === \'\') {\r\n                        Zabbix.log(4, \'[ ManageEngine Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var prefix = field.split(\':\')[0],\r\n                                root;\r\n\r\n                            if  (prefix.startsWith(\'udf_\') && !data.udf_fields) {\r\n                                data.udf_fields = {};\r\n                                root = data.udf_fields;\r\n                            }\r\n                            else if (prefix.startsWith(\'udf_\')) {\r\n                                root = data.udf_fields;\r\n                            }\r\n                            else {\r\n                                root = data;\r\n                            }\r\n\r\n                            if (prefix.endsWith(\'string\')) {\r\n                                root[field.substring(field.indexOf(\':\') + 1)\r\n                                    .toLowerCase()] = fields[field];\r\n                            }\r\n                            else {\r\n                                root[field.substring(field.indexOf(\':\') + 1)\r\n                                    .toLowerCase()] = {\r\n                                    name: fields[field]\r\n                                };\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.log(4, \'[ ManageEngine Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n            if (data.description) {\r\n                data.description = data.description.replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n            }\r\n\r\n            result = {request: data};\r\n        }\r\n\r\n        return result;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        sd = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'sd_on_premise\', \'field_string:subject\', \'field_string:description\',\r\n            \'event_recovery_value\', \'event_source\', \'event_value\', \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'sd_\')) {\r\n                sd[key.substring(3)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field_\') || key.startsWith(\'udf_field_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (params.event_update_status === \'1\' && (typeof params.sd_request_id === \'undefined\'\r\n            || params.sd_request_id.trim() === \'\'\r\n            || params.sd_request_id === \'{EVENT.TAGS.__zbx_sd_request_id}\'\r\n            || params.sd_request_id === \'*UNKNOWN*\')) {\r\n        throw \'Parameter "sd_request_id" can\\\'t be empty for update operation.\';\r\n    }\r\n\r\n    MEngine.setParams(sd);\r\n    MEngine.setProxy(params.HTTPProxy);\r\n\r\n    if (MEngine.params.on_premise.toLowerCase() !== \'true\') {\r\n        MEngine.refreshAccessToken();\r\n    }\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        fields[\'field_object:priority\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n        || \'Normal\';\r\n\r\n        MEngine.request(\'post\', \'requests\', MEngine.createPaylaod(fields));\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\') {\r\n        fields[\'field_object:priority\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n        || \'Normal\';\r\n\r\n        var id = MEngine.request(\'post\', \'requests\', MEngine.createPaylaod(fields));\r\n\r\n        result.tags.__zbx_sd_request_id = id;\r\n        result.tags.__zbx_sd_request_link = MEngine.createLink(id, params.sd_url);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        if (params.event_update_status === \'1\') {\r\n            MEngine.request(\'post\', \'requests/\' + params.sd_request_id + \'/notes\',\r\n                MEngine.createPaylaod(fields, true)\r\n            );\r\n        }\r\n        delete fields[\'field_string:description\'];\r\n        MEngine.request(\'put\', \'requests/\' + params.sd_request_id, MEngine.createPaylaod(fields));\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ ManageEngine Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_sd_request_link}','ManageEngine: {EVENT.TAGS.__zbx_sd_request_id}','','0'),
('50','4','MantisBT','','','','','','','','25','0','0','0','0','1','1','10s','1','var Mantisbt = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n        Mantisbt.params = params;\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        Mantisbt.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    checkUrlFormat: function (url) {\r\n        if (typeof url === \'string\' && !url.endsWith(\'/\')) {\r\n            url += \'/\';\r\n        }\r\n\r\n        if (url.indexOf(\'http://\') === -1 && url.indexOf(\'https://\') === -1) {\r\n            url = \'https://\' + url;\r\n        }\r\n\r\n        return url;\r\n    },\r\n\r\n    getProblemURL: function (zabbix_url, triggerid, eventid, event_source) {\r\n        var problem_url = zabbix_url;\r\n\r\n        if (event_source === \'0\') {\r\n            problem_url += \'tr_events.php?triggerid=\' + triggerid + \'&eventid=\' + eventid;\r\n        }\r\n\r\n        return problem_url;\r\n    },\r\n\r\n    request: function (method, url, data) {\r\n        [\'token\', \'url\', \'category\'].forEach(function (field) {\r\n            if (typeof Mantisbt.params !== \'object\' || typeof Mantisbt.params[field] === \'undefined\' || Mantisbt.params[field] === \'\') {\r\n                throw \'Required MantisBT param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: \' + Mantisbt.params.token);\r\n\r\n        if (typeof Mantisbt.HTTPProxy !== \'undefined\' && Mantisbt.HTTPProxy !== \'\') {\r\n            request.setProxy(Mantisbt.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ MantisBT Webhook ] Sending request: \' + url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'patch\':\r\n                response = request.patch(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ MantisBT Webhook ] Received response with status code \' + request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ MantisBT Webhook ] Failed to parse the response received from MantisBT\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (typeof response !== \'object\') {\r\n            throw \'Failed to process the response received from MantisBT. Check debug log for more information.\';\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (typeof response.message !== \'undefined\') {\r\n                message += \': \' + response.message;\r\n            }\r\n\r\n            throw message;\r\n        }\r\n\r\n        return response;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        mantisbt = {},\r\n        url = \'\',\r\n        data = {},\r\n        result = { tags: {} },\r\n        required_params = [\r\n            \'alert_subject\', \'alert_message\', \'event_source\', \'event_value\', \'event_update_action\',\r\n            \'event_update_status\', \'event_recovery_value\', \'event_nseverity\', \'event_tagsjson\',\r\n            \'event_id\', \'trigger_id\', \'zabbix_url\', \'alert_sendto\',\r\n            \'mantisbt_token\', \'mantisbt_url\', \'mantisbt_category\', \'mantisbt_issue_number\', \'mantisbt_use_zabbix_tags\'\r\n        ],\r\n        method,\r\n        severities = [\'none\', \'low\', \'normal\', \'high\', \'urgent\', \'immediate\'];\r\n\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'mantisbt_\')) {\r\n                mantisbt[key.substring(9)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\' && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported for trigger-based actions only.\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\' || params.zabbix_url === \'{$ZABBIX.URL}\') {\r\n        throw \'Field "zabbix_url" cannot be empty.\';\r\n    }\r\n\r\n    // Check for backslash in the end of url and schema.\r\n    mantisbt.url = Mantisbt.checkUrlFormat(mantisbt.url);\r\n    params.zabbix_url = Mantisbt.checkUrlFormat(params.zabbix_url);\r\n\r\n    // In case of resolve event.\r\n    if (params.event_source === \'0\' && params.event_value === \'0\') {\r\n        method = "patch";\r\n        url = mantisbt.url + \'api/rest/issues/\' + mantisbt.issue_number;\r\n        data = {\r\n            summary: params.alert_subject,\r\n            status: {\r\n                name: "resolved"\r\n            }\r\n        };\r\n        if (/commented/.test(params.event_update_action)) {\r\n            data.additional_information = params.event_update_message;\r\n        }\r\n        process_tags = false;\r\n    }\r\n    // In case of update event.\r\n    else if (params.event_source === \'0\' && params.event_update_status === \'1\') {\r\n        method = "patch";\r\n        url = mantisbt.url + \'api/rest/issues/\' + mantisbt.issue_number;\r\n        data = {\r\n            status: {},\r\n            priority: {\r\n                name: severities[parseInt(params.event_nseverity, 10)]\r\n            }\r\n        };\r\n        if (/commented/.test(params.event_update_action)) {\r\n            data.additional_information = params.event_update_message;\r\n        }\r\n        if (/acknowledged/.test(params.event_update_action)) {\r\n            data.status.name = "acknowledged";\r\n        }\r\n        if (/unacknowledged/.test(params.event_update_action)) {\r\n            data.status.name = "new";\r\n        }\r\n        process_tags = false;\r\n    }\r\n    else {\r\n        method = \'post\';\r\n        url = mantisbt.url + \'api/rest/issues\';\r\n\r\n        data = {\r\n            summary: params.alert_subject,\r\n            description: params.alert_message,\r\n            project: { name: params.alert_sendto },\r\n            category: { name: mantisbt.category },\r\n            priority: {\r\n                name: parseInt(params.event_nseverity, 10) ? severities[parseInt(params.event_nseverity, 10)] : "none"\r\n            }\r\n        };\r\n        if (params.event_source === \'0\') {\r\n            problem_url = Mantisbt.getProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source);\r\n            data.description += \'\\n\' + problem_url;\r\n\r\n            if (mantisbt.use_zabbix_tags === "true") {\r\n                var alert_tags = JSON.parse(params.event_tagsjson);\r\n                data.tags = alert_tags.map(function (t) { return { name: t.value ? (t.tag + \': \' + t.value) : t.tag }; });\r\n            }\r\n        }\r\n        process_tags = true;\r\n    }\r\n\r\n    Mantisbt.setParams(mantisbt);\r\n    Mantisbt.setProxy(params.HTTPProxy);\r\n\r\n    var response = Mantisbt.request(method, url, data);\r\n\r\n    if (process_tags) {\r\n        result.tags.__zbx_mantisbt_issue_number = response.issue.id;\r\n        result.tags.__zbx_mantisbt_link = mantisbt.url + \'view.php?id=\' + response.issue.id;\r\n    }\r\n\r\n    Zabbix.log(4, \'[ MantisBT Webhook ] Result: \' + JSON.stringify(result));\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ MantisBT Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_mantisbt_link}','MantisBT: Issue ID {EVENT.TAGS.__zbx_mantisbt_issue_number}','','0'),
('51','4','Mattermost','','','','','','','','25','0','0','0','0','1','1','10s','1','var SEVERITY_COLORS = [\r\n    \'#97AAB3\', \'#7499FF\', \'#FFC859\',\r\n    \'#FFA059\', \'#E97659\', \'#E45959\'\r\n];\r\n\r\nvar RESOLVE_COLOR = \'#009900\';\r\n\r\nvar SEND_MODE_HANDLERS = {\r\n    alarm: handlerAlarm,\r\n    event: handlerEvent\r\n};\r\n\r\nif (!String.prototype.format) {\r\n    String.prototype.format = function() {\r\n        var args = arguments;\r\n\r\n        return this.replace(/{(\\d+)}/g, function(match, number) {\r\n            return number in args\r\n                ? args[number]\r\n                : match\r\n            ;\r\n        });\r\n    };\r\n}\r\n\r\nfunction isEventProblem(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 0\r\n    ;\r\n}\r\n\r\nfunction isEventUpdate(params) {\r\n    return params.event_value == 1\r\n        && params.event_update_status == 1\r\n    ;\r\n}\r\n\r\nfunction isEventResolve(params) {\r\n    return params.event_value == 0;\r\n}\r\n\r\nfunction getPermalink(mattermost_url, team_name, postid) {\r\n    return \'{0}/{1}/pl/{2}\'.format(\r\n        mattermost_url.replace(/\\/+$/, \'\'),\r\n        team_name,\r\n        postid\r\n    );\r\n}\r\n\r\nfunction getChannel(send_to) {\r\n    switch (true) {\r\n        case /.+\\/#.+/.test(send_to):\r\n            return getChannelByName(send_to);\r\n\r\n        case /@.+/.test(send_to):\r\n            return getDirectChannel(send_to);\r\n\r\n        default:\r\n            return getChannelByID(send_to);\r\n    }\r\n}\r\n\r\nfunction getChannelByName(send_to) {\r\n    var team_chan = send_to\r\n        .trim()\r\n        .split(\'/#\');\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.channel_byname.format(team_chan[0], team_chan[1]),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getDirectChannel(send_to) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var teamUser = send_to\r\n            .trim()\r\n            .split(\'/@\'),\r\n        bot = getBotUser(),\r\n        user = getUserByName(teamUser[1]);\r\n\r\n    var resp = JSON.parse(req.post(\r\n        Mattermost.direct_channel,\r\n        JSON.stringify([bot.id, user.id])\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 201) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    resp.team_name = teamUser[0];\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getChannelByID(channelID) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.get_channel.format(channelID),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getBotUser() {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.bot_user,\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getUserByName(userName) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.user_byname.format(userName),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction getTeamByID(teamID) {\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Call {0}({1})\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(arguments)\r\n    ));\r\n\r\n    var resp = JSON.parse(req.get(\r\n        Mattermost.get_team.format(teamID),\r\n        JSON.stringify(fields)\r\n    )\r\n    );\r\n\r\n    Zabbix.log(5, \'[ Mattermost Webhook ] Result {0}: {1}\'.format(\r\n        arguments.callee.name,\r\n        JSON.stringify(resp)\r\n    ));\r\n\r\n    if (req.getStatus() != 200) {\r\n        throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n    }\r\n\r\n    return resp;\r\n}\r\n\r\nfunction createProblemURL(zabbix_url, triggerid, eventid, event_source) {\r\n    var problem_url = \'\';\r\n    if (event_source === \'0\') {\r\n        problem_url = \'{0}/tr_events.php?triggerid={1}&eventid={2}\'\r\n            .format(\r\n                zabbix_url,\r\n                triggerid,\r\n                eventid\r\n            );\r\n    }\r\n    else {\r\n        problem_url = zabbix_url;\r\n    }\r\n\r\n    return problem_url;\r\n}\r\n\r\nfunction getTagValue(event_tags, key) {\r\n    var pattern = new RegExp(\'(\' + key + \':.+)\');\r\n    var tagValue = event_tags\r\n        .split(\',\')\r\n        .filter(function (v) {\r\n            return v.match(pattern);\r\n        })\r\n        .map(function (v) {\r\n            return v.split(\':\')[1];\r\n        })[0]\r\n        || 0;\r\n\r\n    return tagValue;\r\n}\r\n\r\nfunction handlerAlarm(req, params) {\r\n    var channel = getChannel(params.send_to);\r\n    var fields = {\r\n        channel_id: channel.id,\r\n        props: {}\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        var team_name = channel.team_name\r\n            ? channel.team_name\r\n            : getTeamByID(channel.team_id).name;\r\n\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.post(\r\n            Mattermost.post_message,\r\n            JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n        result.tags.__mattermost_post_id = resp.id;\r\n        result.tags.__mattermost_channel_id = channel.id;\r\n        result.tags.__mattermost_channel_name = channel.name;\r\n        result.tags.__mattermost_message_link = getPermalink(\r\n            params.mattermost_url,\r\n            team_name,\r\n            resp.id\r\n        );\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.root_id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n\r\n        if (params.event_source === \'0\') {}\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                true\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(\r\n            Mattermost.post_message, JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.channel_id = getTagValue(params.event_tags, \'mattermost_channel_id\');\r\n        fields.id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var post_id = getTagValue(params.event_tags, \'mattermost_post_id\');\r\n\r\n        resp = JSON.parse(req.put(\r\n            Mattermost.chat_update.format(post_id),\r\n            JSON.stringify(fields)\r\n        )\r\n        );\r\n\r\n        if (req.getStatus() != 200) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n    }\r\n}\r\n\r\nfunction handlerEvent(req, params) {\r\n    var channel = getChannel(params.send_to);\r\n    var fields = {\r\n        channel_id: channel.id,\r\n        props: {}\r\n    };\r\n\r\n    if (isEventProblem(params)) {\r\n        var team_name = channel.team_name\r\n            ? channel.team_name\r\n            : getTeamByID(channel.team_id).name;\r\n\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_date,\r\n                params.event_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        var resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n        result.tags.__mattermost_channel_name = channel.name;\r\n        result.tags.__mattermost_message_link = getPermalink(\r\n            params.mattermost_url,\r\n            team_name,\r\n            resp.id\r\n        );\r\n\r\n    }\r\n    else if (isEventUpdate(params)) {\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                SEVERITY_COLORS[params.event_nseverity] || 0,\r\n                params.event_update_date,\r\n                params.event_update_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source),\r\n                false\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n\r\n    }\r\n    else if (isEventResolve(params)) {\r\n        fields.props.attachments = [\r\n            createMessage(\r\n                RESOLVE_COLOR,\r\n                params.event_recovery_date,\r\n                params.event_recovery_time,\r\n                createProblemURL(params.zabbix_url, params.trigger_id, params.event_id, params.event_source)\r\n            )\r\n        ];\r\n\r\n        resp = JSON.parse(req.post(Mattermost.post_message, JSON.stringify(fields)));\r\n\r\n        if (req.getStatus() != 201) {\r\n            throw \'[{0}] {1}\'.format(resp.status_code, resp.message);\r\n        }\r\n    }\r\n}\r\n\r\nfunction createMessage(\r\n    event_severity_color,\r\n    event_date,\r\n    event_time,\r\n    problem_url,\r\n    isShort\r\n) {\r\n    var message = {\r\n        fallbac: params.alert_subject,\r\n        title: params.alert_subject,\r\n        color: event_severity_color,\r\n        title_link: problem_url,\r\n        footer: problem_url,\r\n\r\n        fields: [\r\n            {\r\n                title: \'Host\',\r\n                value: \'{0} [{1}]\'.format(params.host_name, params.host_ip),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Event time\',\r\n                value: \'{0} {1}\'.format(event_date, event_time),\r\n                short: true\r\n            }\r\n        ],\r\n    };\r\n\r\n    \r\n    if (params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Severity\',\r\n                value: params.event_severity,\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Opdata\',\r\n                value: params.event_opdata,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (!isShort && params.event_source === \'0\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Event tags\',\r\n                value: \'`{0}`\'.format(params.event_tags.replace(/__.+?:(.+?,|.+)/g, \'\') || \'None\'),\r\n                short: true\r\n            },\r\n            {\r\n                title: \'Trigger description\',\r\n                value: params.trigger_description,\r\n                short: true\r\n            }\r\n        );\r\n    }\r\n\r\n    if (params.event_source !== \'0\' || params.event_update_status === \'1\') {\r\n        message.fields.push(\r\n            {\r\n                title: \'Details\',\r\n                value: params.alert_message,\r\n                short: false\r\n            }\r\n        );\r\n    }\r\n\r\n    return message;\r\n}\r\n\r\nfunction validateParams(params) {\r\n    if (typeof params.bot_token !== \'string\' || params.bot_token.trim() === \'\') {\r\n        throw \'Field "bot_token" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.event_id)) {\r\n        throw \'Field "event_id" is not a number\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\') {\r\n        params.event_nseverity = \'0\';\r\n        params.event_severity = \'Not classified\';\r\n        params.event_update_status = \'0\';\r\n        params.send_mode = \'event\';\r\n    }\r\n\r\n    if (params.event_source === \'1\' || params.event_source === \'2\') {\r\n        params.event_value = \'1\';\r\n    }\r\n\r\n    if (params.event_source === \'1\') {\r\n        params.host_name = params.discovery_host_dns;\r\n        params.host_ip = params.discovery_host_ip;\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        throw \'Incorrect "event_nseverity" parameter given: \' + params.event_nseverity + \'\\nMust be 0-5.\';\r\n    }\r\n\r\n    if (typeof params.event_severity !== \'string\' || params.event_severity.trim() === \'\') {\r\n        throw \'Field "event_severity" cannot be empty\';\r\n    }\r\n\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\') {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (typeof params.host_ip !== \'string\' || params.host_ip.trim() === \'\') {\r\n        throw \'Field "host_ip" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.host_name !== \'string\' || params.host_name.trim() === \'\') {\r\n        throw \'Field "host_name" cannot be empty\';\r\n    }\r\n\r\n    if (typeof params.mattermost_url !== \'string\' || params.mattermost_url.trim() === \'\') {\r\n        throw \'Field "mattermost_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.mattermost_url)) {\r\n        throw \'Field "mattermost_url" must contain a schema\';\r\n    }\r\n\r\n    if ([\'alarm\', \'event\'].indexOf(params.send_mode) === -1) {\r\n        throw \'Incorrect "send_mode" parameter given: \' + params.send_mode + \'\\nMust be "alarm" or "event".\';\r\n    }\r\n\r\n    if (typeof params.send_to !== \'string\' || params.send_to.trim() === \'\') {\r\n        throw \'Field "send_to" cannot be empty\';\r\n    }\r\n\r\n    if (isNaN(params.trigger_id) && params.event_source === \'0\') {\r\n        throw \'field "trigger_id" is not a number\';\r\n    }\r\n\r\n    if (typeof params.zabbix_url !== \'string\' || params.zabbix_url.trim() === \'\') {\r\n        throw \'Field "zabbix_url" cannot be empty\';\r\n    }\r\n\r\n    if (!/^(http|https):\\/\\/.+/.test(params.zabbix_url)) {\r\n        throw \'Field "zabbix_url" must contain a schema\';\r\n    }\r\n\r\n}\r\n\r\ntry {\r\n    var params = JSON.parse(value);\r\n\r\n    validateParams(params);\r\n\r\n    var req = new HttpRequest(),\r\n        fields = {},\r\n        result = {tags: {}};\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        req.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    req.addHeader(\'Content-Type: application/json; charset=utf-8\');\r\n    req.addHeader(\'Authorization: Bearer \' + params.bot_token);\r\n\r\n    params.mattermost_url = params.mattermost_url.replace(/\\/+$/, \'\');\r\n    params.zabbix_url = params.zabbix_url.replace(/\\/+$/, \'\');\r\n\r\n    var APIEndpoint = params.mattermost_url + \'/api/v4/\';\r\n\r\n    var Mattermost = {\r\n        post_message: APIEndpoint + \'posts\',\r\n        get_channel: APIEndpoint + \'channels/{0}\',\r\n        get_team: APIEndpoint + \'teams/{0}\',\r\n        chat_update: APIEndpoint + \'posts/{0}\',\r\n        direct_channel: APIEndpoint + \'channels/direct\',\r\n        channel_byname: APIEndpoint + \'teams/name/{0}/channels/name/{1}\',\r\n        user_byname: APIEndpoint + \'users/username/{0}\',\r\n        bot_user: APIEndpoint + \'users/me\'\r\n\r\n    };\r\n\r\n    params.send_mode = params.send_mode.toLowerCase();\r\n    params.send_mode = params.send_mode in SEND_MODE_HANDLERS\r\n        ? params.send_mode\r\n        : \'alarm\';\r\n\r\n    SEND_MODE_HANDLERS[params.send_mode](req, params);\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ Mattermost Webhook ] Mattermost notification failed: \' + error);\r\n    throw \'Mattermost notification failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__mattermost_message_link}','Open in Mattermost: {EVENT.TAGS.__mattermost_channel_name}','','0'),
('52','4','MS Teams','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nvar SEVERITY_COLORS = [\r\n	\'#97AAB3\',\r\n	\'#7499FF\',\r\n	\'#FFC859\',\r\n	\'#FFA059\',\r\n	\'#E97659\',\r\n	\'#E45959\',\r\n	\'#009900\',\r\n	\'#1F1F1F\'\r\n],\r\n	serviceLogName = \'MS Teams Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	MSTeams = CWebhook;\r\n\r\nMSTeams.prototype.addBodyFact = function (name, value) {\r\n	if (!CParamValidator.isDefined(this.data.sections[0].facts)) {\r\n		this.data.sections[0].facts = [];\r\n	}\r\n	this.data.sections[0].facts.push({name: name, value: value});\r\n}\r\n\r\nMSTeams.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({teams_endpoint: {type: \'string\'}, event_source: {type: \'string\'}, alert_subject: {type: \'string\'},\r\n		alert_message: {type: \'string\'}, host_ip: {type: \'string\', default: \'\'}, zabbix_url: {type: \'string\', url: true},\r\n		use_default_message: {type: \'boolean\', default: false}, event_nseverity: {type: \'integer\', default: 7}}, this.params);\r\n	var actionName = \'Zabbix Home\';\r\n	if (!CParamValidator.inArray(this.params.event_source, [\'0\',\'3\',\'4\'])\r\n		|| this.params.alert_message.startsWith("NOTE: Escalation canceled:")) {\r\n		this.params[\'use_default_message\'] = true;\r\n	}\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({event_id: {type: \'integer\'}, trigger_id: {type: \'integer\'}}, this.params);\r\n		actionName = \'Event Info\';\r\n	}\r\n	var actionURL = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n	if (this.params.event_value === \'0\') {\r\n		this.params.event_nseverity = 6;\r\n	}\r\n	this.data = {\r\n		themeColor: SEVERITY_COLORS[this.params.event_nseverity].replace(\'#\', \'\'),\r\n		summary: this.params.alert_subject,\r\n		sections: [{\r\n			markdown: \'false\',\r\n			activityTitle: this.params.alert_subject,\r\n			text: (this.params.event_source === \'0\' && !this.params.use_default_message) ? this.params.trigger_description : this.params.alert_message\r\n		}],\r\n		potentialAction: [{\r\n			\'@type\': \'OpenUri\',\r\n			name: actionName,\r\n			targets: [{\r\n				os: \'default\',\r\n				uri: actionURL\r\n			}]\r\n		}]\r\n	};\r\n};\r\n\r\nMSTeams.prototype.makeUpDefaultMessage = function () {\r\n	if (!this.params.use_default_message) {\r\n		if (!CParamValidator.isEmpty(this.params.host_name) && CParamValidator.isMacroSet(this.params.host_name, \'HOST.NAME\')) {\r\n			this.addBodyFact(\'Host\', this.params.host_name + ((!CParamValidator.isEmpty(this.params.host_ip)) ? \' [\' + this.params.host_ip + \']\' : \'\'));\r\n		}\r\n		if (!CParamValidator.isEmpty(this.params.event_severity) && CParamValidator.isMacroSet(this.params.event_severity, \'EVENT.SEVERITY\')) {\r\n			this.addBodyFact(\'Severity\', this.params.event_severity);\r\n		}\r\n		if (!CParamValidator.isEmpty(this.params.event_opdata) && CParamValidator.isMacroSet(this.params.event_opdata, \'EVENT.OPDATA\')) {\r\n			this.addBodyFact(\'Operational data\', this.params.event_opdata);\r\n		}\r\n		if (!CParamValidator.isEmpty(this.params.event_tags) && CParamValidator.isMacroSet(this.params.event_tags, \'EVENT.TAGS\')) {\r\n			this.addBodyFact(\'Event tags\', this.params.event_tags);\r\n		}\r\n\r\n		Object.keys(this.params).forEach(function (key) {\r\n			if (key.startsWith(\'fact_\') && this.params[key] !== \'\') {\r\n				this.addBodyFact(key.substring(5), this.params[key]);\r\n			}\r\n			else if (key.startsWith(\'openUri_\') && this.params[key] !== \'\' && !this.params[key].startsWith(\'{\')) {\r\n				this.data.potentialAction.push({\r\n					\'@type\': \'OpenUri\',\r\n					name: key.substring(8),\r\n					targets: [{\r\n						os: \'default\',\r\n						uri: this.params[key]\r\n					}]\r\n				});\r\n			}\r\n		});\r\n	}\r\n}\r\n\r\nconst htmlMultiline = function (text) {\r\n	return text.replace(/(?:\\r\\n|\\r|\\n)/g, \'<br>\');\r\n}\r\n\r\nMSTeams.prototype.sendRequest = function () {\r\n	this.request.addHeaders({"Content-Type": "application/json"});\r\n	var response = this.request.plainRequest(\'POST\', this.params.teams_endpoint, JSON.stringify(this.data));\r\n\r\n	if (response !== \'1\') {\r\n		Logger.log(Logger.WARN, \'FAILED with response: \' + response);\r\n		throw response;\r\n	}\r\n	return \'OK\';\r\n};\r\n\r\nMSTeams.prototype.onProblem = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (!this.params.use_default_message) {\r\n		this.addBodyFact(\'Event time\', this.params.event_time + \' \' + this.params.event_date);\r\n		this.makeUpDefaultMessage();\r\n	}\r\n	this.data.sections[0].text = htmlMultiline(this.data.sections[0].text);\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nMSTeams.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (!this.params.use_default_message) {\r\n		this.data.sections[0].text = this.params.event_update_user + \' \' + this.params.event_update_action + \'.\';\r\n		if (this.params.event_update_message) {\r\n			this.data.sections[0].text += \'<br>Message:<br>\' + this.params.event_update_message;\r\n		}\r\n		this.addBodyFact(\'Event update time\', this.params.event_update_time + \' \' + this.params.event_update_date);\r\n		this.makeUpDefaultMessage();\r\n	}\r\n	this.data.sections[0].text = htmlMultiline(this.data.sections[0].text);\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nMSTeams.prototype.onResolve = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (!this.params.use_default_message) {\r\n		this.addBodyFact(\'Recovery time\', this.params.event_recovery_time + \' \' + this.params.event_recovery_date);\r\n		this.makeUpDefaultMessage();\r\n	}\r\n	this.data.sections[0].text = htmlMultiline(this.data.sections[0].text);\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nMSTeams.prototype.onDiscovery = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\nMSTeams.prototype.onAutoreg = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new MSTeams(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/msteams\r\n\r\n1. Add official Zabbix webhook connector from MS Teams apps for the channel, where you want to receive notifications.\r\n2. Create Incoming webhook for your channel.\r\n3. In the Zabbix web interface go to Administration → Macros section. Setup the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. \r\n4. On this page replace placeholder <PLACE WEBHOOK URL HERE> with the incoming webhook URL, created during the webhook setup in MS Teams.\r\n5. To receive Zabbix notifications in MS Teams, you need to create a Zabbix user and add Media with the MS Teams media type. Make sure this user has access to all hosts for which you would like problem notifications to be sent to MS Teams.','0'),
('53','4','MS Teams Workflow','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\n\r\nvar serviceLogName = \'MS Teams Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	MSTeams = CWebhook;\r\n\r\nMSTeams.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		alert_subject: { type: \'string\' }, alert_message: { type: \'string\' },\r\n		zabbix_url: { type: \'string\', url: true }, teams_endpoint: { type: \'string\', url: true }\r\n	}, this.params);\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({ event_id: { type: \'integer\' }, trigger_id: { type: \'integer\' } }, this.params);\r\n	}\r\n\r\n	this.body = {\r\n		type: "message",\r\n		attachments: [\r\n			{\r\n				contentType: "application/vnd.microsoft.card.adaptive",\r\n				contentUrl: null,\r\n				content: {\r\n					$schema: "http://adaptivecards.io/schemas/adaptive-card.json",\r\n					type: "AdaptiveCard",\r\n					version: "1.4",\r\n					body: [\r\n						{\r\n							type: "Container",\r\n							items: [\r\n								{\r\n									type: "TextBlock",\r\n									size: "Medium",\r\n									wrap: "true",\r\n									weight: "Bolder",\r\n									text: this.params.alert_subject\r\n								}\r\n							],\r\n							style: "",\r\n							bleed: true\r\n						}\r\n					],\r\n					actions: [\r\n						{\r\n							type: "Action.OpenUrl",\r\n							title: "Event info",\r\n							url: CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id)\r\n						}\r\n					]\r\n				}\r\n			}\r\n		]\r\n	};\r\n\r\n	this.params.alert_message = this.params.alert_message.split(\'\\n\');\r\n\r\n	for (line in this.params.alert_message) {\r\n		this.body.attachments[0].content.body.push({\r\n			type: "TextBlock",\r\n			wrap: "true",\r\n			text: this.params.alert_message[line]\r\n		});\r\n	}\r\n\r\n};\r\n\r\nMSTeams.prototype.sendRequest = function (color) {\r\n	this.body.attachments[0].content.body[0].style = color;\r\n\r\n	this.request.addHeaders({ "Content-Type": "application/json" });\r\n	var response = this.request.plainRequest(\'POST\', this.params.teams_endpoint, JSON.stringify(this.body));\r\n\r\n	var status = this.request.getStatus();\r\n	if (status < 200 || status >= 300) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + status + \'. Endpoint response: \' + response);\r\n		throw \'HTTP code: \' + status + \'. Endpoint response: \' + response;\r\n	}\r\n\r\n	return \'OK\';\r\n};\r\n\r\nMSTeams.prototype.onProblem = function () {\r\n	return this.sendRequest("attention");\r\n};\r\n\r\nMSTeams.prototype.onResolve = function () {\r\n	return this.sendRequest("good");\r\n};\r\n\r\nMSTeams.prototype.onUpdate = function () {\r\n	return this.sendRequest("emphasis");\r\n};\r\n\r\nMSTeams.prototype.onDiscovery = function () {\r\n	return this.sendRequest("emphasis");\r\n};\r\n\r\nMSTeams.prototype.onAutoreg = function () {\r\n	return this.sendRequest("emphasis");\r\n};\r\n\r\ntry {\r\n	var hook = new MSTeams(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n};','30s','0','0','','','To set up a webhook, please follow these steps:\r\n\r\n- Create a workflow in MS Teams. You can use the "Post a message in a channel when a webhook request is received" template for it.\r\n- Copy the endpoint URL and place it in the teams_endpoint parameter.\r\n- Set up the global macro {$ZABBIX.URL}, which will contain the URL to the Zabbix frontend.\r\n- Create a Zabbix user and add the MS Teams Workflow media to it.\r\n\r\nFor more detailed instructions, please visit https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/.','0'),
('54','4','Opsgenie','','','','','','','','25','0','0','0','0','1','3','10s','1','var method,\r\n    Media = {\r\n    params: {},\r\n    name: \'\',\r\n    labels: [],\r\n    HTTPProxy: \'\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Media.params = params;\r\n        Media.params.api += Media.params.api.endsWith(\'/\') ? \'\' : \'/\';\r\n        Media.params.web += Media.params.web.endsWith(\'/\') ? \'\' : \'/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        if (typeof HTTPProxy !== \'undefined\' && HTTPProxy.trim() !== \'\') {\r\n            Media.HTTPProxy = HTTPProxy;\r\n        }\r\n    },\r\n\r\n    setTags: function(event_tags_json) {\r\n        if (typeof event_tags_json !== \'undefined\' && event_tags_json !== \'\'\r\n                && event_tags_json !== \'{EVENT.TAGSJSON}\') {\r\n\r\n            try {\r\n                var tags = JSON.parse(event_tags_json),\r\n                    label;\r\n\r\n                tags.forEach(function (tag) {\r\n                    if (typeof tag.tag === \'string\') {\r\n                        label = (tag.tag + (typeof tag.value !== \'undefined\'\r\n                                && tag.value !== \'\' ? (\':\' + tag.value) : \'\')).replace(/\\s/g, \'_\');\r\n                        Media.labels.push(label);\r\n                    }\r\n                });\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse "event_tags_json" param\');\r\n            }\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data, allow_404) {\r\n        if (typeof(allow_404) === \'undefined\') {\r\n            allow_404 = false;\r\n        }\r\n\r\n        [\'api\', \'token\'].forEach(function (field) {\r\n            if (typeof Media.params !== \'object\' || typeof Media.params[field] === \'undefined\'\r\n                    || Media.params[field] === \'\') {\r\n                throw \'Required \' + Media.name + \' param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Media.params.api + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: \' + Media.params.token);\r\n        request.setProxy(Media.HTTPProxy);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse response.\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if ((request.getStatus() < 200 || request.getStatus() >= 300)\r\n                && (!allow_404 || request.getStatus() !== 404)) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null) {\r\n                if (typeof response.errors === \'object\' && Object.keys(response.errors).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errors);\r\n                }\r\n                else if (typeof response.errorMessages === \'object\' && Object.keys(response.errorMessages).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errorMessages);\r\n                }\r\n                else if (typeof response.message === \'string\') {\r\n                    message += \': \' + response.message;\r\n                }\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getAlertId: function (requestId) {\r\n        status_counter = params.status_counter || 25; \r\n        do {\r\n            resp = Media.request(\'get\', \'requests/\' + requestId, undefined, true);\r\n        status_counter -= 1;            \r\n        }\r\n        while ( status_counter > 0 && \r\n            ( \r\n            typeof resp.response !== \'object\' || \r\n            typeof resp.response.data === \'undefined\' ||\r\n            resp.response.data.success === false &&\r\n                !resp.response.data.status.includes("There is no open alert") &&\r\n                !resp.response.data.status.includes("Alert is already")\r\n            ) \r\n        );\r\n\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.data === \'undefined\') {\r\n            throw \'Cannot get \' + Media.name + \' issue ID. Check debug log for more information.\';\r\n        }\r\n        else if (resp.response.data.success === false ) {\r\n            throw Media.name + \': Operation status (\' + resp.response.data.status + \')\';\r\n        }\r\n\r\n        return resp;\r\n    }\r\n};\r\n\r\ntry {\r\n    var result = {tags: {}},\r\n        params = JSON.parse(value),\r\n        media = {},\r\n        fields = {},\r\n        resp = {},\r\n        responders = [],\r\n        tags = [],\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\',\r\n            \'opsgenie_api\',\r\n            \'opsgenie_web\',\r\n            \'opsgenie_token\'\r\n        ],\r\n        severities = [\r\n            \'not_classified\',\r\n            \'information\',\r\n            \'warning\',\r\n            \'average\',\r\n            \'high\',\r\n            \'disaster\',\r\n            \'resolved\',\r\n            \'default\'\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n            if (key.startsWith(\'opsgenie_\')) {\r\n                media[key.substring(9)] = params[key];\r\n            }\r\n        });\r\n\r\n    // Possible values of event_source:\r\n    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check event_value for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_update_status only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_id for a numeric value.\r\n    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {\r\n        throw \'Incorrect "event_id" parameter given: \' + params.event_id + \'\\nMust be a positive number.\';\r\n    }\r\n\r\n    if ((params.event_source === \'1\' || params.event_source === \'2\')  && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for Trigger and Internal actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity]];\r\n    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n    Media.name = \'Opsgenie\';\r\n    Media.setParams(media);\r\n    Media.params.token = \'GenieKey \' + Media.params.token;\r\n    Media.setProxy(params.HTTPProxy);\r\n    Media.setTags(params.event_tags_json); // Set Media.labels\r\n\r\n    // Create an issue.\r\n    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).\r\n    // Numeric value of the problem update status. Possible values:\r\n    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)\r\n            || (params.event_source == 3 && params.event_value == 1)\r\n            || params.event_source == 1 || params.event_source == 2) {\r\n        fields.message = params.alert_subject;\r\n        fields.alias = params.event_id;\r\n        fields.description = params.alert_message;\r\n        fields.priority = priority;\r\n        fields.source = \'Zabbix\';\r\n\r\n        if (params.event_source === \'0\') {\r\n            fields.details = {\r\n                \'Zabbix server\': params.zbxurl,\r\n                Problem: params.zbxurl + \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id\r\n            };\r\n        }\r\n        else {\r\n            fields.details = {\'Zabbix server\': params.zbxurl};\r\n        }\r\n\r\n        if (typeof params.opsgenie_teams === \'string\') {\r\n            responders = params.opsgenie_teams.split(\',\');\r\n            fields.responders = responders.map(function(team) {\r\n                return {type: \'team\', name: team.trim()};\r\n            });\r\n        }\r\n\r\n        fields.tags = Media.labels;\r\n        if (typeof params.opsgenie_tags === \'string\') {\r\n            tags = params.opsgenie_tags.split(\',\');\r\n            tags.forEach(function(item) {\r\n                fields.tags.push(item.trim());\r\n            });\r\n        }\r\n\r\n        resp = Media.request(\'post\', \'\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.result === \'undefined\') {\r\n            throw \'Cannot create \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (resp.status === 202) {\r\n            resp = Media.getAlertId(resp.response.requestId);\r\n            if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {\r\n                result.tags.__zbx_ops_issuekey = resp.response.data.alertId;\r\n                result.tags.__zbx_ops_issuelink = Media.params.web + \'alert/detail/\' + resp.response.data.alertId;\r\n            }\r\n        }\r\n        else {\r\n            throw Media.name + \' response code is unexpected. Check debug log for more information.\';\r\n        }\r\n    }\r\n    // Update or close the created issue.\r\n    else {\r\n        fields.user = (params.event_value != 0) ? params.zbxuser : \'\';\r\n        fields.note = params.alert_message;\r\n        if ( [0, 3].indexOf(parseInt(params.event_source)) > -1  && params.event_value == 0 ) {\r\n            // skip sending of close request from update operation(mandatory when both update & recovery operations are defined in action)  \r\n            method = params.event_update_status == 0 ? "close" : "skip";\r\n        }\r\n        else if ( params.event_source == 0 && params.event_value == 1 && params.event_update_status == 1 && params.event_update_action.includes(\'acknowledged\')) {\r\n            method = params.event_update_action.includes(\'unacknowledged\') ? "unacknowledge" : "acknowledge";\r\n        }\r\n        else {\r\n            method = "notes";\r\n        }\r\n\r\n        if (method !== "skip") {\r\n        resp = Media.request(\'post\', params.event_id + \'/\' + method +\'?identifierType=alias\', fields);\r\n\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.result === \'undefined\') {\r\n            throw \'Cannot update \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (resp.status === 202) {\r\n            resp = Media.getAlertId(resp.response.requestId);\r\n        }\r\n        else {\r\n            throw Media.name + \' response code is unexpected. Check debug log for more information.\';\r\n        }\r\n    }\r\n    }\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ \' + Media.name + \' Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_ops_issuelink}','Opsgenie: {EVENT.TAGS.__zbx_ops_issuekey}','Please refer to https://docs.opsgenie.com/docs/alert-api and https://www.zabbix.com/documentation/7.0/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd dedicated user with media type "Opsgenie".\r\nChange the values of the variables opsgenie_api (https://api.opsgenie.com/v2/alerts or https://api.eu.opsgenie.com/v2/alerts),\r\nopsgenie_web (for example, https://myzabbix.app.opsgenie.com), opsgenie_token.','0'),
('55','4','OTRS CE','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst SEVERITIES = ["not_classified", "information", "warning", "average", "high", "disaster"],\r\n	serviceLogName = \' ((OTRS)) CE Webhook \',\r\n	Logger = new CLogger(serviceLogName),\r\n	OTRS = CWebhook;\r\n\r\nOTRS.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({alert_subject: {type: \'string\'}, alert_message: {type: \'string\'},\r\n		event_nseverity: {type: \'integer\', default: -1}, otrs_url: {type: \'string\', url: true}, otrs_auth_user: {type: \'string\'},\r\n		otrs_auth_password: {type: \'string\'}, otrs_customer: {type: \'string\'}, otrs_default_priority_id: {type: \'integer\', min: 1, max: 5},\r\n		otrs_queue: {type: \'string\'}, otrs_ticket_type: {type: \'string\'}, otrs_ticket_state: {type: \'string\'}, otrs_time_unit: {type: \'integer\'},\r\n		otrs_closed_state_id: {type: \'integer\', default: 0}, zabbix_url: {type: \'string\', url: true}}, this.params);\r\n	this.params.entrypoint = \'/nph-genericinterface.pl/Webservice/ZabbixTicketConnector/Ticket\';\r\n\r\n	var priority;\r\n	if (this.params.event_nseverity >= 0 && this.params.event_nseverity < SEVERITIES.length) {\r\n		priority = this.params[\'severity_\' + SEVERITIES[this.params.event_nseverity]];\r\n	}\r\n	this.priority = (CParamValidator.isDefined(priority)) ? priority.trim() : this.params.otrs_default_priority_id;\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({trigger_id: {type: \'integer\'}, event_id: {type: \'integer\'}}, this.params);\r\n		this.params.zabbix_url = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n		this.params.alert_message = this.params.alert_subject + \'\\n\' + this.params.alert_message + \'\\n\' +\r\n			this.params.zabbix_url + \'\\n\';\r\n	}\r\n	if (this.params.event_value != \'0\' && CParamValidator.isMacroSet(this.params.otrs_ticket_id)) {\r\n		this.params.event_update_status = \'1\';\r\n	}\r\n	this.dynamicFields = {}\r\n	Object.keys(this.params).forEach(function (key) {\r\n		if (key.startsWith(\'dynamicfield_\')) {\r\n			this.dynamicFields[key.substring(13)] = this.params[key];\r\n		}\r\n	});\r\n\r\n	this.data = {\r\n		Article: {\r\n			Subject: this.params.alert_subject,\r\n			Body: (CParamValidator.isDefined(this.params.alert_message)) ? this.params.alert_message : \'\',\r\n			TimeUnit: this.params.otrs_time_unit.toString(),\r\n			ContentType: \'text/plain; charset=utf8\'\r\n		}\r\n	};\r\n\r\n	this.result = {tags: {}};\r\n};\r\n\r\nOTRS.prototype.sendRequest = function (method) {\r\n	var url = this.params.otrs_url + this.params.entrypoint +\r\n		\'?UserLogin=\' + encodeURIComponent(this.params.otrs_auth_user) +\r\n		\'&Password=\' + encodeURIComponent(this.params.otrs_auth_password);\r\n\r\n	var response = this.request.jsonRequest(method, url, this.data);\r\n\r\n	if (!CParamValidator.isType(response, \'object\')) {\r\n		Logger.log(Logger.INFO, \'API response ERROR: \' + response);\r\n		throw \'Unknown error. Check debug log for more information.\';\r\n	}\r\n	if (this.request.getStatus() < 200 || this.request.getStatus() >= 300) {\r\n		var message = \'status code \' + this.request.getStatus();\r\n		Logger.log(Logger.INFO, \'API response ERROR with \' + message + \': \' + response);\r\n		throw \'Request failed with \' + message + \'. Check debug log for more information.\';\r\n	}\r\n	if (CParamValidator.isDefined(response.Error) && Object.keys(response.Error).length > 0) {\r\n		Logger.log(Logger.INFO, \'API response ERROR: \' + JSON.stringify(response.Error));\r\n		throw \'Request failed: \' + JSON.stringify(response.Error);\r\n	}\r\n\r\n	return {\r\n		status: this.request.getStatus(),\r\n		response: response\r\n	};\r\n};\r\n\r\nOTRS.prototype.createTicket = function () {\r\n	this.data[\'Ticket\'] = {\r\n		Title: this.params.alert_subject,\r\n		Queue: this.params.otrs_queue,\r\n		Type: this.params.otrs_ticket_type,\r\n		State: this.params.otrs_ticket_state,\r\n		PriorityID: this.priority.toString(),\r\n		CustomerUser: this.params.otrs_customer\r\n	}\r\n\r\n	var result = this.sendRequest(\'post\');\r\n\r\n	if (!CParamValidator.isDefined(result.response.TicketID) || result.status != 200) {\r\n		throw \'Cannot create ((OTRS)) CE ticket. Check debug log for more information.\';\r\n	}\r\n\r\n	return result.response.TicketID;\r\n}\r\n\r\nOTRS.prototype.updateTicket = function () {\r\n	CParamValidator.validate({otrs_ticket_id: {type: \'string\'}, entrypoint: {type: \'string\'}}, this.params);\r\n	this.params.entrypoint += \'/\' + encodeURIComponent(this.params.otrs_ticket_id);\r\n\r\n	var result = this.sendRequest(\'put\');\r\n\r\n	if (!CParamValidator.isDefined(result.response.TicketID) || result.status != 200) {\r\n		throw \'Cannot update ((OTRS)) CE ticket. Check debug log for more information.\';\r\n	}\r\n\r\n	return result.response.TicketID;\r\n}\r\n\r\nOTRS.prototype.onProblem = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (CParamValidator.isDefined(alert.source) && CParamValidator.inArray(alert.source, [\'trigger\', \'service\', \'internal\'])) {\r\n		if (Object.keys(this.dynamicFields).length > 0) {\r\n			this.data.DynamicField = [];\r\n			Object.keys(this.dynamicFields).forEach(function(field) {\r\n				if (field !== undefined) {\r\n					if (this.dynamicFields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/)) {\r\n						this.dynamicFields[field] = this.dynamicFields[field].replace(/\\./g, \'-\');\r\n					}\r\n	\r\n					this.data.DynamicField.push({Name: field, Value: this.dynamicFields[field]});\r\n				}\r\n			});\r\n		}\r\n		const ticket_id = this.createTicket(alert);\r\n		this.result.tags.__zbx_otrs_ticket_id = ticket_id;\r\n		this.result.tags.__zbx_otrs_ticketlink = this.params.otrs_url + \'index.pl?Action=AgentTicketZoom;TicketID=\' + ticket_id;\r\n\r\n		return this.result;\r\n	}\r\n	return this.createTicket();\r\n}\r\n\r\nOTRS.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.updateTicket();\r\n\r\n	return this.result;\r\n}\r\n\r\nOTRS.prototype.onResolve = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (this.params.otrs_closed_state_id > 0) {\r\n		this.data[\'Ticket\'] = {\r\n			StateID: this.params.otrs_closed_state_id\r\n		}\r\n	}\r\n	this.updateTicket();\r\n\r\n	return this.result;\r\n}\r\n\r\nOTRS.prototype.onDiscovery = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\nOTRS.prototype.onAutoreg = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new OTRS(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_otrs_ticketlink}','((OTRS)) CE: ticket #{EVENT.TAGS.__zbx_otrs_ticket_id}','This media type integrates your Zabbix installation with your ((OTRS)) CE installation using the Zabbix webhook feature.\r\n\r\n((OTRS)) CE configuration:\r\n\r\n1. Create a new web service. To do so, navigate to "Admin" → "Web services" and import the "ZabbixTicketConnector.yml" file (it can be found in the official Zabbix repository next to the media type file).\r\n\r\n2. Create a new customer.\r\n\r\n3. Create a new customer user. Select the ID of the customer that you created in the previous step.\r\n\r\n4. Create a new agent. Depending on the ticket queue you want to use for tickets created by the webhook, set the "RW" permission for the group that this ticket queue belongs to. In the example below, if you want to use the "Misc" queue, you must set the "RW" permission for the group "users".\r\n\r\nZabbix configuration:\r\n\r\n1. Before you can start using the ((OTRS)) CE webhook, set the global macro "{$ZABBIX.URL}":\r\n- In the Zabbix web interface, go to "Administration" → "Macros" in the top-left dropdown menu.\r\n- Set the global macro "{$ZABBIX.URL}" to the URL of the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.\r\n- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration, you might also need to append "/zabbix" to the end of URL. Good examples:\r\n  - http://zabbix.com\r\n  - https://zabbix.lan/zabbix\r\n  - http://server.zabbix.lan/\r\n  - http://localhost\r\n  - http://127.0.0.1:8080\r\n- Bad examples:\r\n  - zabbix.com\r\n  - http://zabbix/\r\n\r\n2. Set the following webhook parameters:\r\n- otrs_auth_user - the username of the agent\r\n- otrs_auth_password - the password of the agent\r\n- otrs_customer - the email of the customer user\r\n- otrs_queue - the queue that will be used for tickets created by the webhook\r\n- otrs_url - the frontend URL of your ((OTRS)) CE installation (for example, "https://otrs.example.com/otrs")\r\n\r\n3. If you want to prioritize issues according to the severity values in Zabbix, you can define mapping parameters (create them as additional webhook parameters):\r\n- severity_<name> - the ((OTRS)) CE priority ID (<name> in the parameter name can be one of the following values: "not_classified", "information", "warning", "average", "high", "disaster")\r\n\r\n4. If you have dynamic fields in ((OTRS)) CE and want them to be filled with values from Zabbix, add webhook parameters in the format "dynamicfield_<((OTRS)) CE dynamic field name>", similarly to the previous step. Dynamic fields can only be of the types "text", "textarea", "checkbox", or "date".\r\n\r\n5. If you want the webhook to close tickets related to **resolved** problems in Zabbix, you can change the following parameter value:\r\n- otrs_closed_state_id - ((OTRS)) CE state ID for closed tasks (possible values: 0 - Disable tickets closing, >0 - State ID from the State Management page).\r\n\r\n6. If you use the ticket type feature, you can change the type of the created tickets:\r\n- otrs_ticket_type - ((OTRS)) CE ticket type (set to "Unclassified" by default; present on fresh installations).\r\n\r\n7. Click the "Enabled" checkbox to enable the mediatype and click the "Update" button to save the webhook settings.\r\n\r\n8. Create a Zabbix user and add media:\r\n- To create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).\r\n- In the "Media" tab, click "Add" and select the type "OTRS CE" from the drop-down list. Add any value in the "Send to" field: it is not used in the webhook, but is required.\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to ((OTRS)) CE.\r\n\r\n9. Done! You can now start using this media type in actions and create tickets.\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/otrs_ce','0'),
('56','4','PagerDuty','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nvar severityMapping = [\r\n	\'info\',\r\n	\'info\',\r\n	\'warning\',\r\n	\'warning\',\r\n	\'error\',\r\n	\'critical\'\r\n],\r\n	serviceLogName = \'PagerDuty Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	PagerDuty = CWebhook;\r\n\r\nfunction getDefaultEventData(data, params) {\r\n	data.event_action = \'trigger\';\r\n	data.payload.custom_details = {\r\n		\'Alert message\': params.alert_message\r\n	};\r\n	Object.keys(params).forEach(function (key) {\r\n		if (key.startsWith(\'customdetails_\') && !CParamValidator.isEmpty(params[key])) {\r\n			data.payload.custom_details[key.substring(14)] = params[key];\r\n		}\r\n	});\r\n	data.client = \'Zabbix\';\r\n	data.client_url = params.zabbix_url;\r\n\r\n	return data;\r\n};\r\n\r\nPagerDuty.prototype.onCheckParams = function () {\r\n	this.params.url = \'https://events.pagerduty.com/v2/enqueue\';\r\n	CParamValidator.validate({api_token: {type: \'string\'}, event_id: {type: \'integer\'},\r\n		alert_subject: {type: \'string\'}, host_ip: {type: \'string\', default: \'\'}, zabbix_url: {type: \'string\', url: true},\r\n		event_nseverity: {type: \'integer\', min: 0, max: 5, default: 0}}, this.params);\r\n	if (CParamValidator.inArray(this.params.event_source, [\'0\',\'3\',\'4\'])) {\r\n		CParamValidator.validate({host_name: {type: \'string\', default: \'\'}}, this.params);\r\n		if (this.params.event_source === \'0\') {\r\n			CParamValidator.validate({trigger_id: {type: \'integer\'}, event_update_status: {type: \'string\', array: [\'0\', \'1\']},\r\n				event_ack: {type: \'boolean\'}}, this.params);\r\n		}\r\n		else {\r\n			CParamValidator.validate({alert_message: {type: \'string\'}, event_ack: {type: \'boolean\', default: false}}, this.params);\r\n		}\r\n	}\r\n	this.data = {\r\n		routing_key: this.params.api_token,\r\n		dedup_key: String(this.params.event_id),\r\n		payload: {\r\n			summary: this.params.alert_subject,\r\n			source: (!CParamValidator.isEmpty(this.params.host_name)) ? (this.params.host_name +\r\n				((!CParamValidator.isEmpty(this.params.host_ip)) ? \' : \' + this.params.host_ip : \'\')) : \'Zabbix\',\r\n			severity: severityMapping[this.params.event_nseverity],\r\n		}\r\n	}\r\n}\r\n\r\nPagerDuty.prototype.onProblem = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.data = getDefaultEventData(this.data, this.params);\r\n	if (CParamValidator.isDefined(alert.source) && alert.source === \'Trigger\') {\r\n		this.data.links = [{\r\n			href: CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id),\r\n			text: \'Event link\'\r\n		}];\r\n	}\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nPagerDuty.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	if (this.params.event_ack === true) {\r\n		this.data.event_action = \'acknowledge\';\r\n		return this.sendRequest();\r\n	}\r\n	this.data = getDefaultEventData(this.data, this.params);\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nPagerDuty.prototype.onResolve = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.data = getDefaultEventData(this.data, this.params);\r\n	this.data.event_action = \'resolve\';\r\n	\r\n	return this.sendRequest();\r\n}\r\n\r\nPagerDuty.prototype.onDiscovery = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	this.data = getDefaultEventData(this.data, this.params);\r\n	this.data.payload.source = \'Discovery\';\r\n\r\n	return this.sendRequest();\r\n}\r\n\r\nPagerDuty.prototype.onAutoreg = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\nPagerDuty.prototype.sendRequest = function () {\r\n	var response = this.request.jsonRequest(\'POST\', this.params.url, this.data);\r\n	if (!CParamValidator.isType(response, \'object\')) {\r\n		Logger.log(Logger.INFO, \'API response ERROR: \' + response);\r\n		throw \'Unknown error. Check debug log for more information.\';\r\n	}\r\n	if (this.request.getStatus() != 202) {\r\n		if (CParamValidator.isType(response.errors, \'array\') && CParamValidator.isType(response.errors[0], \'string\')) {\r\n			throw response.errors[0];\r\n		}\r\n		else {\r\n			throw \'Unknown error. HTTP status: \' + this.request.getStatus();\r\n		}\r\n	}\r\n	if (response.status != \'success\') {\r\n		Logger.log(Logger.INFO, \'API response ERROR: \' + response);\r\n		throw \'Unknown error. Check debug log for more information.\';\r\n	}\r\n\r\n	return \'OK\';\r\n};\r\n\r\ntry {\r\n	var hook = new PagerDuty(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','Please refer to https://v2.developer.pagerduty.com/docs/send-an-event-events-api-v2 and https://www.zabbix.com/documentation/7.0/manual/config/notifications/media/webhook#example_scripts.\r\n\r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "PagerDuty" and place the integration key in the user\'s "Send to" parameter to integrate into the service.','0'),
('57','4','Pushover','','','','','','','','25','0','0','0','0','0','3','10s','1','try {\r\n    var params = JSON.parse(value),\r\n        request = new HttpRequest(),\r\n        data,\r\n        response,\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'priority_\' + severities[params.event_nseverity].name] || params.priority_default;\r\n\r\n    if (isNaN(priority) || priority < -2 || priority > 2) {\r\n        throw \'"priority" should be -2..2\';\r\n    }\r\n\r\n    if (params.event_source === \'0\' && isNaN(params.triggerid)) {\r\n        throw \'field "triggerid" is not a number\';\r\n    }\r\n\r\n    if (isNaN(params.eventid)) {\r\n        throw \'field "eventid" is not a number\';\r\n    }\r\n\r\n    if (typeof params.message !== \'string\' || params.message.trim() === \'\') {\r\n        throw \'field "message" cannot be empty\';\r\n    }\r\n\r\n    data = {\r\n        token: params.token,\r\n        user: params.user,\r\n        title: params.title,\r\n        message: params.message,\r\n        url: (params.event_source === \'0\') \r\n            ? params.url + \'/tr_events.php?triggerid=\' + params.triggerid + \'&eventid=\' + params.eventid\r\n            : params.url,\r\n        url_title: params.url_title,\r\n        priority: priority\r\n    };\r\n\r\n    if (priority == 2) {\r\n        if (isNaN(params.retry) || params.retry < 30) {\r\n            throw \'field "retry" should be a number with value of at least 30 if "priority" is set to 2\';\r\n        }\r\n\r\n        if (isNaN(params.expire) || params.expire > 10800) {\r\n            throw \'field "expire" should be a number with value of at most 10800 if "priority" is set to 2\';\r\n        }\r\n\r\n        data.retry = params.retry;\r\n        data.expire = params.expire;\r\n    }\r\n\r\n    data = JSON.stringify(data);\r\n    Zabbix.log(4, \'[ Pushover Webhook ] Sending request: \' + params.endpoint + \'\\n\' + data);\r\n\r\n    request.addHeader(\'Content-Type: application/json\');\r\n    response = request.post(params.endpoint, data);\r\n\r\n    Zabbix.log(4, \'[ Pushover Webhook ] Received response with status code \' + request.getStatus() + \'\\n\' + response);\r\n\r\n    if (response !== null) {\r\n        try {\r\n            response = JSON.parse(response);\r\n        }\r\n        catch (error) {\r\n            Zabbix.log(4, \'[ Pushover Webhook ] Failed to parse response received from Pushover\');\r\n            response = null;\r\n        }\r\n    }\r\n\r\n    if (request.getStatus() != 200 || response === null || typeof response !== \'object\' || response.status !== 1) {\r\n        if (response !== null && typeof response === \'object\' && typeof response.errors === \'object\'\r\n                && typeof response.errors[0] === \'string\') {\r\n            throw response.errors[0];\r\n        }\r\n        else {\r\n            throw \'Unknown error. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ Pushover Webhook ] Pushover notification failed: \' + error);\r\n    throw \'Pushover notification failed: \' + error;\r\n}','30s','0','0','','','Please refer to setup guide here: https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/pushover\r\n\r\nSet token parameter with to your Pushover application key.\r\nWhen assigning Pushover media to the Zabbix user - add user key into send to field.','0'),
('58','4','Redmine','','','','','','','','25','0','0','0','0','1','3','10s','1','var Redmine = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Redmine.params = params;\r\n        if (typeof Redmine.params.url === \'string\') {\r\n            if (!Redmine.params.url.endsWith(\'/\')) {\r\n                Redmine.params.url += \'/\';\r\n            }\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n\r\n            data.issue.custom_fields = [];\r\n            Object.keys(fields)\r\n                .forEach(function (field) {\r\n                    var field_value = fields[field];\r\n\r\n                    if (field_value !== undefined) {\r\n                        data.issue.custom_fields.push({ id: field, value: field_value });\r\n                    }\r\n                });\r\n\r\n        }\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'access_key\'].forEach(function (field) {\r\n            if (typeof Redmine.params !== \'object\' || typeof Redmine.params[field] === \'undefined\'\r\n                || Redmine.params[field] === \'\' ) {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Redmine.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        if (typeof Redmine.HTTPProxy === \'string\' && Redmine.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(Redmine.HTTPProxy);\r\n        }\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'X-Redmine-API-Key: \' + Redmine.params.access_key);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Redmine Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ Redmine Webhook ] Received response with status code \' + request.getStatus() + \': \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ Redmine Webhook ] Failed to parse response received from Redmine\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.errors !== \'undefined\'\r\n                && Object.keys(response.errors).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errors);\r\n            }\r\n            else if (response !== null && typeof response.errorMessages !== \'undefined\'\r\n                && Object.keys(response.errorMessages).length > 0) {\r\n                message += \': \' + JSON.stringify(response.errorMessages);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getProjectID: function(name) {\r\n        var result = Redmine.request(\'get\', \'projects.json\'),\r\n            project_id;\r\n\r\n        if (result.response) {\r\n            var projects = result.response.projects || [];\r\n\r\n            for (var i in projects) {\r\n                if (projects[i].name === name) {\r\n                    project_id = projects[i].id;\r\n                    break;\r\n                }\r\n            }\r\n        }\r\n        else {\r\n            Zabbix.log(4, \'[ Redmine Webhook ] Failed to retrieve project data.\');\r\n        }\r\n\r\n        if (typeof project_id === \'undefined\') {\r\n            throw \'Cannot find project with name: \' + name;\r\n        }\r\n\r\n        return project_id;\r\n    },\r\n\r\n    createIssue: function(subject, description, priority, fields) {\r\n        var project_id = /^\\d+$/.test(Redmine.params.project)\r\n                ? Redmine.params.project\r\n                : Redmine.getProjectID(Redmine.params.project),\r\n            data = {\r\n                issue: {\r\n                    project_id: project_id,\r\n                    tracker_id: Redmine.params.tracker_id,\r\n                    subject: subject,\r\n                    description: description\r\n                }\r\n            },\r\n            result;\r\n\r\n        if (priority) {\r\n            data.issue.priority_id = priority;\r\n        }\r\n\r\n        result = Redmine.request(\'post\', \'issues.json\', Redmine.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\'\r\n            || typeof result.response.issue.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Redmine issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.issue.id;\r\n    },\r\n\r\n    updateIssue: function (note, fields, status) {\r\n        var data = {\r\n            issue: {\r\n                notes: note || \'\'\r\n            }\r\n        };\r\n\r\n        if (status) {\r\n            data.issue.status_id = status;\r\n        }\r\n\r\n        Redmine.request(\'put\', \'issues/\' + Redmine.params.issue_key + \'.json\', Redmine.addCustomFields(data, fields));\r\n    }\r\n\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_redmine = {},\r\n        params_fields = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'tracker_id\', \'project\',\r\n            \'event_source\', \'event_value\',  \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'redmine_\')) {\r\n                params_redmine[key.substring(8)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                params_fields[key.substring(12)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n\r\n    if (typeof params_redmine.close_status_id === \'string\' && params_redmine.close_status_id.trim() !== \'\' && !parseInt(params_redmine.close_status_id, 10)) {\r\n        throw \'Incorrect "redmine_close_status_id" parameter given! Must be an integer.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\'\r\n        && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\'\r\n                && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.redmine_issue_key)) || parseInt(params.redmine_issue_key) < 1 )) {\r\n        throw \'Incorrect "redmine_issue_key" parameter given: \' + params.redmine_issue_key +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    Redmine.setParams(params_redmine);\r\n    Redmine.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\'\r\n        && params.event_value !== \'0\') {\r\n        Redmine.createIssue(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        var issue_id = Redmine.createIssue(params.alert_subject,\r\n            params.alert_subject + \'\\n\' + params.alert_message + \'\\n\' +\r\n            params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') +\r\n            \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\',\r\n            priority,\r\n            params_fields);\r\n\r\n        result.tags.__zbx_redmine_issue_id = issue_id;\r\n        result.tags.__zbx_redmine_issuelink = params.redmine_url +\r\n            (params.redmine_url.endsWith(\'/\') ? \'\' : \'/\') + \'issues/\' + issue_id;\r\n    }\r\n    // Close issue if parameter close_status_id is set and it is a recovery operation\r\n    else if (params.event_value === \'0\' && typeof params_redmine.close_status_id === \'string\' && params_redmine.close_status_id.trim() !== \'\') {\r\n        Redmine.updateIssue(params.alert_subject + \'\\n\' + params.alert_message, params_fields, params_redmine.close_status_id);\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        Redmine.updateIssue(params.alert_subject + \'\\n\' + params.alert_message, params_fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ Redmine Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_redmine_issuelink}','Redmine: issue #{EVENT.TAGS.__zbx_redmine_issue_id}','','0'),
('59','4','Rocket.Chat','','','','','','','','25','0','0','0','0','1','3','10s','1','var RocketChat = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        RocketChat.params = params;\r\n        if (RocketChat.params.url && RocketChat.params.api_url) {\r\n            if (!RocketChat.params.url.endsWith(\'/\')) {\r\n                RocketChat.params.url += \'/\';\r\n            }\r\n            if (!RocketChat.params.api_url.endsWith(\'/\')) {\r\n                RocketChat.params.api_url += \'/\';\r\n            }\r\n            if (RocketChat.params.api_url.startsWith(\'/\')) {\r\n                RocketChat.params.api_url = RocketChat.params.api_url.substring(1);\r\n            }\r\n\r\n            RocketChat.params.url += RocketChat.params.api_url;\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        RocketChat.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addFields: function (fields) {\r\n        var data = [];\r\n\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field] === \'\') {\r\n                        Zabbix.log(4, \'[ RocketChat Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var parts = field.split(\':\'),\r\n                                prefix = parts[0].split(\'_\');\r\n\r\n                            if (typeof prefix[2] === \'undefined\'\r\n                                    || (prefix[2] === \'p\' && params.event_value === \'1\')\r\n                                    || (prefix[2] === \'r\' && params.event_value === \'0\')) {\r\n                                data.push({\r\n                                    title: field.substring(field.indexOf(\':\') + 1),\r\n                                    value: fields[field],\r\n                                    short: prefix[1] === \'short\'\r\n                                });\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.log(4, \'[ RocketChat Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'api_url\', \'user_id\', \'user_token\', \'send_to\'].forEach(function (field) {\r\n            if (typeof RocketChat.params !== \'object\' || typeof RocketChat.params[field] === \'undefined\'\r\n                    || RocketChat.params[field] === \'\' ) {\r\n                throw \'Required parameter is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = RocketChat.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'X-Auth-Token:\' + RocketChat.params.user_token);\r\n        request.addHeader(\'X-User-Id:\' + RocketChat.params.user_id);\r\n\r\n        if (typeof RocketChat.HTTPProxy !== \'undefined\' && RocketChat.HTTPProxy !== \'\') {\r\n            request.setProxy(RocketChat.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ RocketChat Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ RocketChat Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ RocketChat Webhook ] Failed to parse response received from RocketChat\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.message !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.message);\r\n            }\r\n            else if (response !== null && typeof response.error !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    postMessage: function(use_default_message, message, fields) {\r\n        var data = {\r\n            channel: RocketChat.params.send_to,\r\n            attachments: [{\r\n                collapsed: false,\r\n                color: RocketChat.params.color,\r\n                title: params.alert_subject\r\n            }]\r\n        };\r\n\r\n        if (RocketChat.params.title_link) {\r\n            data.attachments[0].title_link = RocketChat.params.title_link;\r\n        }\r\n\r\n        if (use_default_message) {\r\n            data.attachments[0].text = message;\r\n        }\r\n        else {\r\n            data.attachments[0].fields = RocketChat.addFields(fields);\r\n        }\r\n\r\n        var result = RocketChat.request(\'post\', \'chat.postMessage\', data);\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.message._id === \'undefined\') {\r\n            throw \'Cannot send RocketChat message. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            id: result.response.message._id,\r\n            rid: result.response.message.rid,\r\n            channel: result.response.channel\r\n        };\r\n    },\r\n\r\n    sendMessage: function(update, fields) {\r\n\r\n        var data = {\r\n            message: {\r\n                rid: RocketChat.params.room_id,\r\n                tmid: RocketChat.params.msg_id,\r\n                tshow: true\r\n            }\r\n        };\r\n\r\n        if (update.status === \'0\') {\r\n            data.message.attachments = [{\r\n                collapsed: false,\r\n                color: RocketChat.params.color,\r\n                title: params.alert_subject,\r\n                title_link: RocketChat.params.title_link,\r\n                fields: RocketChat.addFields(fields)\r\n            }];\r\n        }\r\n        else {\r\n            data.message.alias = update.user;\r\n            data.message.msg = update.action;\r\n            if (update.message) {\r\n                data.message.attachments = [{\r\n                    color: RocketChat.params.color,\r\n                    text: update.message\r\n                }];\r\n            }\r\n        }\r\n\r\n        RocketChat.request(\'post\', \'chat.sendMessage\', data);\r\n    },\r\n\r\n    getMessageLink: function(rid, id) {\r\n        var room = RocketChat.request(\'get\', \'rooms.info?roomId=\' + encodeURIComponent(rid)),\r\n            link = params.rc_url +\r\n                (params.rc_url.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n        switch (room.response.room.t) {\r\n            case \'c\':\r\n                link += \'channel/\' + room.response.room.name + \'?msg=\' + id;\r\n                break;\r\n\r\n            case \'p\':\r\n                link += \'group/\' + room.response.room.name + \'?msg=\' + id;\r\n                break;\r\n\r\n            case \'d\':\r\n                link += \'direct/\' + rid + \'?msg=\' + id;\r\n                break;\r\n\r\n            default:\r\n                Zabbix.log(4, \'[ RocketChat Webhook ] Can\\\'t get room type. Link to message will not be added.\');\r\n        }\r\n\r\n        return link;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        response,\r\n        fields = {},\r\n        rc = {},\r\n        update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'alert_message\', \'event_source\', \'event_value\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'rc_\')) {\r\n                rc[key.substring(3)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field_\')) {\r\n                fields[key.substring(6)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Forcing parameters for non trigger-based events.\r\n    if (params.event_source !== \'0\') {\r\n        params.use_default_message = \'true\';\r\n        params.event_nseverity = \'0\';\r\n        params.rc_title_link = false;\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    RocketChat.setParams(rc);\r\n    RocketChat.setProxy(params.HTTPProxy);\r\n    RocketChat.params.color = severities[params.event_nseverity].color;\r\n\r\n    // Send default message if use_default_message === true.\r\n    if (params.use_default_message.toLowerCase() === \'true\') {\r\n        response = RocketChat.postMessage(true, params.alert_message);\r\n        result.tags.__zbx_rc_id = response.id;\r\n        result.tags.__zbx_rc_rid = response.rid;\r\n        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);\r\n    }\r\n    // Send message for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\') {\r\n        response = RocketChat.postMessage(false, params.alert_message, fields);\r\n        result.tags.__zbx_rc_id = response.id;\r\n        result.tags.__zbx_rc_rid = response.rid;\r\n        result.tags.__zbx_rc_msg_url = RocketChat.getMessageLink(response.rid, response.id);\r\n    }\r\n    // Send thread message for trigger-based event.\r\n    else {\r\n        RocketChat.sendMessage(update, fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ RocketChat Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_rc_msg_url}','Rocket.Chat','','0'),
('60','4','ServiceNow','','','','','','','','25','0','0','0','0','1','3','10s','1','var ServiceNow = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        ServiceNow.params = params;\r\n        if (typeof ServiceNow.params.url === \'string\') {\r\n            if (!ServiceNow.params.url.endsWith(\'/\')) {\r\n                ServiceNow.params.url += \'/\';\r\n            }\r\n\r\n            ServiceNow.params.url += \'api/now/table/incident\';\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        ServiceNow.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    setFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    data[field] = (fields[field].match(/^\\d{4}\\.\\d{2}\\.\\d{2}$/) !== null)\r\n                        ? fields[field].replace(/\\./g, \'-\')\r\n                        : fields[field];\r\n                });\r\n        }\r\n    },\r\n\r\n    request: function (method, data) {\r\n        [\'url\', \'user\', \'password\'].forEach(function (field) {\r\n            if (typeof ServiceNow.params !== \'object\' || typeof ServiceNow.params[field] === \'undefined\'\r\n                || ServiceNow.params[field] === \'\' ) {\r\n                throw \'Required ServiceNow param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = ServiceNow.params.url,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(ServiceNow.params.user + \':\' + ServiceNow.params.password));\r\n\r\n        if (typeof ServiceNow.HTTPProxy !== \'undefined\' && ServiceNow.HTTPProxy !== \'\') {\r\n            request.setProxy(ServiceNow.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ServiceNow Webhook ] Sending request: \' + url + ((typeof data === \'string\')\r\n            ? (\'\\n\' + data)\r\n            : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ ServiceNow Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ ServiceNow Webhook ] Failed to parse response received from ServiceNow\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.error.message !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error.message);\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n        else if (typeof response.result !== \'object\' || typeof response.result.sys_id === \'undefined\') {\r\n            throw \'Cannot create ServiceNow incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return response.result;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        servicenow = {},\r\n        data = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\', \'alert_message\', \'event_source\', \'event_value\',\r\n            \'event_update_status\', \'event_recovery_value\', \'event_nseverity\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        method = \'post\',\r\n        process_tags = true;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'servicenow_\')) {\r\n                servicenow[key.substring(11)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'u_\')) {\r\n                fields[key] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    data.short_description = params.alert_subject;\r\n    data.description = params.alert_message;\r\n    data.comments = params.alert_message;\r\n\r\n    if (typeof params[\'urgency_for_\' + severities[params.event_nseverity].name] !== \'undefined\') {\r\n        data.urgency = params[\'urgency_for_\' + severities[params.event_nseverity].name];\r\n    }\r\n\r\n    ServiceNow.setParams(servicenow);\r\n    ServiceNow.setProxy(params.HTTPProxy);\r\n    ServiceNow.setFields(data, fields);\r\n\r\n    if (params.event_source === \'0\' && (params.event_value === \'0\' || params.event_update_status === \'1\')) {\r\n        process_tags = false;\r\n        method = \'put\';\r\n        delete data.description;\r\n        delete data.urgency;\r\n        ServiceNow.params.url += \'/\' + params.servicenow_sys_id;\r\n    }\r\n\r\n    var response = ServiceNow.request(method, data);\r\n\r\n    if (process_tags) {\r\n        result.tags.__zbx_servicenow_sys_id = response.sys_id;\r\n        result.tags.__zbx_servicenow_link = params.servicenow_url +\r\n            (params.servicenow_url.endsWith(\'/\') ? \'\' : \'/\') + \'incident.do?sys_id=\' + response.sys_id;\r\n        result.tags.__zbx_servicenow_number = response.number;\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ ServiceNow Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_servicenow_link}','ServiceNow: {EVENT.TAGS.__zbx_servicenow_number}','','0'),
('61','4','SIGNL4','','','','','','','','25','0','0','0','0','1','3','10s','1','// SIGNL4 Webhook\r\ntry {\r\n    var response,\r\n        payload,\r\n        params = JSON.parse(value),\r\n        endpoint = \'https://connect.signl4.com/webhook/\',\r\n        request = new HttpRequest();\r\n\r\n    if (typeof params.HTTPProxy === \'string\' && params.HTTPProxy.trim() !== \'\') {\r\n        request.setProxy(params.HTTPProxy);\r\n    }\r\n\r\n    if (typeof params.teamsecret === \'string\' && params.teamsecret.trim() !== \'\') {\r\n        endpoint += params.teamsecret;\r\n        delete params.teamsecret;\r\n    }\r\n    else {\r\n        throw \'The team secret of your SIGNL4 team cannot be empty.\';\r\n    }\r\n\r\n    if (typeof params.Severity === \'string\' && params.Severity === \'{EVENT.SEVERITY}\') {\r\n        params.Severity = \'Not classified\';\r\n    }\r\n\r\n	if (typeof params.User === \'string\' && params.User === \'{USER.FULLNAME}\') {\r\n        params.User = \'\';\r\n    }\r\n\r\n	if (typeof params.Event_Update_Action === \'string\' && params.Event_Update_Action === \'{EVENT.UPDATE.ACTION}\') {\r\n        params.Event_Update_Action = \'\';\r\n    }\r\n\r\n	// Assemble X-S4-ExternalID for two-way integration\r\n	// Format: "ZabbixEventID: 222 ZabbixURL: https://your-zabbix-server/zabbix/"\r\n	params[\'X-S4-ExternalID\'] = \'ZabbixEventID: \' + params.Event_ID;\r\n	if (typeof params.Zabbix_URL === \'string\' && params.Zabbix_URL.indexOf(\'http\') == 0) {\r\n		// Make sure the URL ends with \'/\'\r\n		if (params.Zabbix_URL.charAt(params.Zabbix_URL.length - 1) != \'/\') {\r\n			params.Zabbix_URL = params.Zabbix_URL + \'/\';\r\n		}\r\n\r\n		params[\'X-S4-ExternalID\'] = params[\'X-S4-ExternalID\'] + \' ZabbixURL: \' +  params.Zabbix_URL;\r\n\r\n		// Add Link parameter\r\n		params[\'Link\'] = params.Zabbix_URL + "tr_events.php?triggerid="+params.Trigger_ID + "&eventid=" + params.Event_ID;\r\n	}\r\n\r\n	// Check if this is a new problem or a recovery\r\n	if (params.Trigger_Status == \'OK\') {\r\n		params[\'X-S4-Status\'] = \'resolved\';\r\n	}\r\n	else {\r\n		params[\'X-S4-Status\'] = \'new\';\r\n		params[\'X-S4-SourceSystem\'] = \'Zabbix\';\r\n	}\r\n\r\n    payload = JSON.stringify(params);\r\n    Zabbix.log(4, \'[ SIGNL4 Webhook ] Sending request: \' + payload);\r\n\r\n    request.addHeader(\'Content-Type: application/json\');\r\n    response = request.post(endpoint, \'payload=\' + payload);\r\n\r\n    Zabbix.log(4, \'[ SIGNL4 Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response\r\n    );\r\n\r\n    if (request.getStatus() !== 201) {\r\n        throw \'Request failed with status code \' + request.getStatus() +\r\n                \'. Check debug log for more information.\';\r\n    }\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(4, \'[ SIGNL4 Webhook ] ERROR: \' + error);\r\n\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','SIGNL4 is a mobile alert notification app for powerful alerting, alert management and mobile assignment of work items. It offers alerting via app push, SMS and voice calls including escalations, tracking, and duty scheduling.\r\n\r\nGet the app at https://www.signl4.com.\r\n\r\nFind out more including an integration video here: https://www.signl4.com/blog/portfolio_item/zabbix-mobile-alert-notification-duty-schedule-escalation/','0'),
('62','4','Slack','','','','','','','','25','0','0','0','0','1','1','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nvar serviceLogName = \'Slack Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Slack = CWebhook;\r\n\r\nSlack.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		alert_subject: { type: \'string\' },\r\n		alert_message: { type: \'string\' },\r\n		bot_token: { type: \'string\' },\r\n		zabbix_url: { type: \'string\', url: true },\r\n		channel: { type: \'string\', macro: \'ALERT.SENDTO\' },\r\n		slack_mode: { type: \'string\', array: [\'alarm\', \'event\'], }\r\n	}, this.params);\r\n\r\n	if (this.params.event_source === \'0\') {\r\n		CParamValidator.validate({\r\n			event_id: { type: \'integer\' },\r\n			trigger_id: { type: \'integer\' }\r\n		}, this.params);\r\n	}\r\n\r\n	if (CParamValidator.inArray(this.params.event_source, [\'0\', \'3\', \'4\'])) {\r\n		CParamValidator.validate({\r\n			event_tags: { type: \'array\', macro: \'EVENT.TAGSJSON\', tags: true, default: {} }\r\n		}, this.params);\r\n	}\r\n\r\n	if (this.params.event_value != \'0\' && CParamValidator.isDefined(this.params.event_tags[\'__channel_id_\' + this.params.channel])) {\r\n		this.params.event_update_status = \'1\';\r\n	}\r\n\r\n	this.severity_colors = [\r\n		\'#97AAB3\',\r\n		\'#7499FF\',\r\n		\'#FFC859\',\r\n		\'#FFA059\',\r\n		\'#E97659\',\r\n		\'#E45959\'\r\n	];\r\n\r\n	this.resolve_color = \'#009900\';\r\n	this.slack_endpoint = \'https://slack.com/api/\';\r\n\r\n	this.problem_url = CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id);\r\n\r\n	this.data = {\r\n		channel: this.params.channel,\r\n		attachments: [\r\n			{\r\n				fallback: this.params.alert_subject,\r\n				title: this.params.alert_subject,\r\n				color: this.severity_colors[this.params.event_nseverity],\r\n				title_link: this.problem_url,\r\n				text: this.params.alert_message,\r\n				actions: [\r\n					{\r\n						type: \'button\',\r\n						text: \'Open in Zabbix\',\r\n						url: this.problem_url\r\n					}\r\n				]\r\n			}\r\n		]\r\n	};\r\n\r\n	this.reply = {\r\n		channel: this.params.channel,\r\n		thread_ts: \'\',\r\n		blocks: [\r\n			{\r\n				type: \'context\',\r\n				elements: [\r\n					{\r\n						type: \'plain_text\',\r\n						text: \'Event update message\'\r\n					}\r\n				]\r\n			},\r\n			{\r\n				type: \'rich_text\',\r\n				elements: [\r\n					{\r\n						type: \'rich_text_section\',\r\n						elements: [\r\n							{\r\n								type: \'text\',\r\n								text: \'\',\r\n								style: {\r\n									italic: true\r\n								}\r\n							}\r\n						]\r\n					}\r\n				]\r\n			}\r\n		]\r\n	};\r\n};\r\n\r\nSlack.prototype.sendRequest = function (route, data, tags) {\r\n	this.request.clearHeader();\r\n	this.request.addHeaders({\r\n		\'Content-Type\': \'application/json; charset=utf-8;\',\r\n		\'Authorization\': \'Bearer \' + this.params.bot_token\r\n	});\r\n\r\n	var response = this.request.jsonRequest(\'POST\', this.slack_endpoint + route, data);\r\n\r\n	if (this.request.getStatus() !== 200 || !CParamValidator.isType(response.ok, \'boolean\') || response.ok !== true) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.error, \'string\')) {\r\n			throw \'Endpoint response:\' + response.error;\r\n		}\r\n		else {\r\n			throw \'Unknown error. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	if (tags) {\r\n		return {\r\n			tags: {\r\n				[\'__message_ts_\' + this.params.channel]: response.ts,\r\n				[\'__channel_id_\' + this.params.channel]: response.channel,\r\n				[\'__message_link_\' + this.params.channel]: this.getPermalink(response.channel, response.ts),\r\n			}\r\n		};\r\n\r\n	}\r\n	else {\r\n		return { tags: {} };\r\n	}\r\n};\r\n\r\nSlack.prototype.getPermalink = function (channel, message_ts) {\r\n	var response = this.request.jsonRequest(\'GET\', this.slack_endpoint + \'chat.getPermalink\' + \'?channel=\' + channel + \'&message_ts=\' + message_ts);\r\n\r\n	if (this.request.getStatus() !== 200 || !CParamValidator.isType(response.ok, \'boolean\') || response.ok !== true) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.error, \'string\')) {\r\n			throw \'Endpoint response:\' + response.error;\r\n		}\r\n		else {\r\n			throw \'Unknown error. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	if (!CParamValidator.isDefined(response.permalink)) {\r\n		throw \'Permalink is missed from the JSON response\';\r\n	}\r\n\r\n	return response.permalink;\r\n};\r\n\r\nSlack.prototype.onProblem = function (properties) {\r\n	Logger.log(Logger.INFO, \'Source: \' + properties.source + \'; Event: \' + properties.event);\r\n\r\n	if (this.params.slack_mode === "alarm") {\r\n		return this.sendRequest(\'chat.postMessage\', this.data, true);\r\n	} else {\r\n		return this.sendRequest(\'chat.postMessage\', this.data, false);\r\n	}\r\n};\r\n\r\nSlack.prototype.onUpdate = function (properties) {\r\n	Logger.log(Logger.INFO, \'Source: \' + properties.source + \'; Event: \' + properties.event);\r\n\r\n	if (this.params.slack_mode === "alarm") {\r\n		this.data.channel = this.params.event_tags[\'__channel_id_\' + this.params.channel];\r\n		this.data.ts = this.params.event_tags[\'__message_ts_\' + this.params.channel];\r\n\r\n		if (CParamValidator.isMacroSet(this.params.event_update_message, \'EVENT.UPDATE.MESSAGE\') && !CParamValidator.isEmpty(this.params.event_update_message)) {\r\n			this.reply.thread_ts = this.data.ts;\r\n			this.reply.blocks[1].elements[0].elements[0].text = this.params.event_update_message;\r\n			this.sendRequest(\'chat.postMessage\', this.reply, false);\r\n		}\r\n\r\n		if (/\\backnowledged/.test(this.params.event_update_action)) {\r\n			this.sendRequest(\'reactions.add\', { channel: this.data.channel, timestamp: this.data.ts, name: \'white_check_mark\' }, false);\r\n		}\r\n\r\n		if (/\\bunacknowledged/.test(this.params.event_update_action)) {\r\n			this.sendRequest(\'reactions.remove\', { channel: this.data.channel, timestamp: this.data.ts, name: \'white_check_mark\' }, false);\r\n		}\r\n\r\n		if (/\\bclosed/.test(this.params.event_update_action)) {\r\n			return { tags: {} };\r\n		}\r\n		else {\r\n			return this.sendRequest(\'chat.update\', this.data, false);\r\n		}\r\n	} else {\r\n		return this.sendRequest(\'chat.postMessage\', this.data, false);\r\n	}\r\n};\r\n\r\nSlack.prototype.onResolve = function (properties) {\r\n	Logger.log(Logger.INFO, \'Source: \' + properties.source + \'; Event: \' + properties.event);\r\n	this.data.attachments[0].color = this.resolve_color;\r\n\r\n	if (this.params.slack_mode === "alarm") {\r\n		this.data.channel = this.params.event_tags[\'__channel_id_\' + this.params.channel];\r\n		this.data.ts = this.params.event_tags[\'__message_ts_\' + this.params.channel];\r\n\r\n		return this.sendRequest(\'chat.update\', this.data, false);\r\n	} else {\r\n		return this.sendRequest(\'chat.postMessage\', this.data, false);\r\n	}\r\n};\r\n\r\nSlack.prototype.onDiscovery = function (properties) {\r\n	return this.onProblem(properties);\r\n};\r\n\r\nSlack.prototype.onAutoreg = function (properties) {\r\n	return this.onProblem(properties);\r\n};\r\n\r\ntry {\r\n	var hook = new Slack(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'Notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','0','','','Preparing slack for a Zabbix media type:\r\n1. On the page Your Apps (https://api.slack.com/apps) press \'Create an App\', select \'From scratch\' and specify its name and workspace.\r\n2. In the \'Add features and functionality\' section, select \'Bots\' and press \'Review Scopes to Add\'.\r\n3. In the \'Scopes\' section, find \'Bot Token Scopes\', press \'Add an OAuth Scope\' and add \'chat:write\', \'im:write\', \'groups:write\' and \'reactions:write\' scopes.\r\n4. In the \'Settings\' section on the left side of the page press \'Install App\' and then \'Install to Workspace\'.\r\n5. Press \'Allow\' and copy \'Bot User OAuth Access Token\', which will be used to set up webhook.\r\n\r\nIn Zabbix:\r\n1. Set global macro {$ZABBIX.URL}\r\n2. Set user media for slack using channel name or member ID\r\n3. Set media param \'bot_token\' to the previously created token\r\n\r\nFor a detailed instructions please read full README file https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/slack/README.md','0'),
('63','4','SolarWinds Service Desk','','','','','','','','25','0','0','0','0','1','3','10s','1','var SolarWinds = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        SolarWinds.params = params;\r\n        SolarWinds.params.endpoint = \'https://api.samanage.com/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        SolarWinds.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof data.incident === \'object\' && typeof fields === \'object\' && Object.keys(fields).length) {\r\n            if (typeof fields.sw_fields === \'object\' && Object.keys(fields.sw_fields).length) {\r\n                Object.keys(fields.sw_fields)\r\n                    .forEach(function(field) {\r\n                        try {\r\n                            data.incident[field] = JSON.parse(fields.sw_fields[field]);\r\n                        }\r\n                        catch (error) {\r\n                            data.incident[field] = fields.sw_fields[field];\r\n                        }\r\n                    });\r\n            }\r\n\r\n            if (typeof fields.sw_customfields === \'object\' && Object.keys(fields.sw_customfields).length) {\r\n                data.incident.custom_fields_values = {custom_fields_value: []};\r\n                Object.keys(fields.sw_customfields)\r\n                    .forEach(function(field) {\r\n                        data.incident.custom_fields_values.custom_fields_value.push({\r\n                            name: field,\r\n                            value: fields.sw_customfields[field]\r\n                        });\r\n                    });\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'token\'].forEach(function (field) {\r\n            if (typeof SolarWinds.params !== \'object\' || typeof SolarWinds.params[field] === \'undefined\'\r\n                || SolarWinds.params[field] === \'\' ) {\r\n                throw \'Required SolarWinds param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = SolarWinds.params.endpoint + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'X-Samanage-Authorization: Bearer \' + SolarWinds.params.token);\r\n        request.addHeader(\'Accept: application/vnd.samanage.v2.1+json\');\r\n\r\n        if (typeof SolarWinds.HTTPProxy !== \'undefined\' && SolarWinds.HTTPProxy !== \'\') {\r\n            request.setProxy(SolarWinds.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SolarWinds SD Webhook ] Sending request: \' + url + ((typeof data === \'string\')\r\n            ? (\'\\n\' + data)\r\n            : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SolarWinds SD Webhook ] Received response with status code \' + request.getStatus() +\r\n            \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ SolarWinds SD Webhook ] Failed to parse response received from SolarWinds\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.error !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n            else if (response !== null && typeof response === \'object\'\r\n                && Object.keys(response).length > 0) {\r\n                Object.keys(response)\r\n                    .forEach(function(field) {\r\n                        message += \'\\n\' + field + \': \' + response[field][0];\r\n                    });\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createIncident: function(name, description, fields) {\r\n        var data = {\r\n            incident: {\r\n                name: name,\r\n                description: description,\r\n                priority: SolarWinds.params.priority\r\n            }\r\n        };\r\n\r\n        var result = SolarWinds.request(\'post\', \'incidents.json\', SolarWinds.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.id === \'undefined\') {\r\n            throw \'Cannot create SolarWinds incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateIncident: function(name, fields, message) {\r\n        var data = {\r\n            incident: {\r\n                name: name,\r\n                priority: SolarWinds.params.priority\r\n            }\r\n        };\r\n\r\n        SolarWinds.request(\r\n            \'put\',\r\n            \'incidents/\' + SolarWinds.params.incident_id + \'.json\',\r\n            SolarWinds.addCustomFields(data, fields));\r\n\r\n        SolarWinds.commenIncident(message);\r\n    },\r\n\r\n    commenIncident: function(message) {\r\n        var data = {\r\n            comment: {\r\n                body: message\r\n            }\r\n        };\r\n\r\n        SolarWinds.request(\'post\', \'incidents/\' + SolarWinds.params.incident_id + \'/comments.json\', data);\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        samanage = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'event_recovery_value\', \'event_source\', \'event_value\', \'priority_default\'],\r\n        severities = [\r\n            {name: \'not_classified\'},\r\n            {name: \'information\'},\r\n            {name: \'warning\'},\r\n            {name: \'average\'},\r\n            {name: \'high\'},\r\n            {name: \'disaster\'},\r\n            {name: \'resolved\'},\r\n            {name: \'default\'}\r\n        ];\r\n\r\n    fields.sw_fields = {};\r\n    fields.sw_customfields = {};\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'samanage_\')) {\r\n                samanage[key.substring(9)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'sw_field_\')) {\r\n                fields.sw_fields[key.substring(9)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'sw_customfield_\')) {\r\n                fields.sw_customfields[key.substring(15)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_recovery_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    samanage.priority = params[\'priority_\' + severities[params.event_nseverity].name] || params.priority_default;\r\n\r\n    SolarWinds.setParams(samanage);\r\n    SolarWinds.setProxy(params.HTTPProxy);\r\n\r\n    // Create incident for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_recovery_value !== \'0\') {\r\n        SolarWinds.createIncident(params.alert_subject, params.alert_message);\r\n    }\r\n    // Create incident for trigger-based events.\r\n    else if (params.event_value === \'1\' && params.event_update_status === \'0\'\r\n            && (samanage.incident_id === \'{EVENT.TAGS.__zbx_solarwinds_inc_id}\' || samanage.incident_id === \'*UNKNOWN*\')) {\r\n        var key = SolarWinds.createIncident(params.alert_subject, params.alert_message, fields);\r\n\r\n\r\n        result.tags.__zbx_solarwinds_inc_id = key;\r\n        result.tags.__zbx_solarwinds_inc_link = params.samanage_url +\r\n            (params.samanage_url.endsWith(\'/\') ? \'\' : \'/\') + \'incidents/\' + key;\r\n    }\r\n    // Update created incident for trigger-based event.\r\n    else {\r\n        if (samanage.incident_id === \'{EVENT.TAGS.__zbx_solarwinds_inc_id}\' || samanage.incident_id === \'\' || samanage.incident_id === \'*UNKNOWN*\') {\r\n            throw \'Incorrect incident key given: \' + samanage.incident_id;\r\n        }\r\n        if (!params.alert_message) {\r\n            throw \'Parameter "alert_message" can\\\'t be empty.\';\r\n        }\r\n        SolarWinds.updateIncident(params.alert_subject, fields, params.alert_message);\r\n    }\r\n\r\n    if (params.event_source === \'0\') {\r\n        return JSON.stringify(result);\r\n    }\r\n    else {\r\n        return \'OK\';\r\n    }\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ SolarWinds SD Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_solarwinds_inc_link}','SolarWinds incident ID: {EVENT.TAGS.__zbx_solarwinds_inc_id}','','0'),
('64','4','SysAid','','','','','','','','25','0','0','0','0','1','3','10s','1','var SysAid = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        var required = [\'url\', \'auth_user\', \'auth_password\', \'category_level_1\', \'category_level_2\',\r\n            \'category_level_3\', \'incident_id\', \'template_id\', \'urgency_id\', \'incident_state\',\r\n            \'default_priority_id\'\r\n        ];\r\n\r\n        required.forEach(function (field) {\r\n            if (typeof params !== \'object\' || typeof params[field] === \'undefined\' || params[field] === \'\') {\r\n                throw \'Required param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        SysAid.params = params;\r\n        if (typeof SysAid.params.url === \'string\' && !SysAid.params.url.endsWith(\'/\')) {\r\n            SysAid.params.url += \'/\';\r\n        }\r\n    },\r\n\r\n    login: function () {\r\n        var result = SysAid.request(\'post\', \'api/v1/login\', {\r\n            user_name: SysAid.params.auth_user,\r\n            password: SysAid.params.auth_password\r\n        });\r\n\r\n        return result.response.user.id;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        var response,\r\n            request = SysAid.req || (SysAid.req = new HttpRequest()),\r\n            url = SysAid.params.url + query;\r\n\r\n        if (typeof SysAid.HTTPProxy !== \'undefined\' && SysAid.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(SysAid.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SysAid Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ SysAid Webhook ] Received response with status code \' + request.getStatus() + \': \' + response);\r\n\r\n        if (request.getStatus() !== 200) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            message += \': \' + response;\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ SysAid Webhook ] Failed to parse response received from SysAid\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (response === null || (typeof response.Error !== \'undefined\' && Object.keys(response.Error).length > 0)) {\r\n            throw \'Request failed: \' + JSON.stringify(response.Error);\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    createIncident: function(subject, message, priority) {\r\n        var result = SysAid.request(\'post\', \'api/v1/sr/?template=\' + encodeURIComponent(SysAid.params.template_id), {\r\n            info: [\r\n                {\r\n                    key: \'problem_type\',\r\n                    value: [\r\n                        SysAid.params.category_level_1,\r\n                        SysAid.params.category_level_2,\r\n                        SysAid.params.category_level_3\r\n                    ].join(\'_\')\r\n                },\r\n                {\r\n                    key: \'title\',\r\n                    value: subject\r\n                },\r\n                {\r\n                    key: \'description\',\r\n                    value: message\r\n                },\r\n                {\r\n                    key: \'status\',\r\n                    value: \'1\'\r\n                },\r\n                {\r\n                    key: \'urgency\',\r\n                    value: SysAid.params.urgency_id\r\n                },\r\n                {\r\n                    key: \'priority\',\r\n                    value: priority || SysAid.params.default_priority_id,\r\n                }\r\n            ]\r\n        });\r\n\r\n        if (result.response.id === \'undefined\') {\r\n            throw \'Cannot create SysAid incident. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.id;\r\n    },\r\n\r\n    updateTicket: function(note) {\r\n        var date = new Date().getTime();\r\n\r\n        SysAid.request(\'put\', \'api/v1/sr/\' + encodeURIComponent(SysAid.params.incident_id), {\r\n            id: SysAid.params.incident_id,\r\n            info: [\r\n                {\r\n                    key: \'update_time\',\r\n                    value: date\r\n                },\r\n                {\r\n                    key: \'notes\',\r\n                    value: [\r\n                        {\r\n                            userName: \'Zabbix\',\r\n                            createDate: date,\r\n                            text: note\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        });\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        params_sysaid = {},\r\n        params_update = {},\r\n        result = {tags: {}},\r\n        required_params = [\'alert_subject\', \'event_source\', \'event_value\',  \'event_update_status\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: null, color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'sysaid_\')) {\r\n                params_sysaid[key.substring(7)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                params_update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    if (params.event_source === \'0\' && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n            || (params.event_value === \'0\' && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n            && (isNaN(parseInt(params.sysaid_incident_id)) || parseInt(params.sysaid_incident_id) < 1 )) {\r\n        throw \'Incorrect "sysaid_incident_id" parameter given: \' + params.sysaid_incident_id + \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name];\r\n    priority = priority && priority.trim() || severities[7].name;\r\n\r\n    SysAid.setParams(params_sysaid);\r\n    SysAid.HTTPProxy = params.HTTPProxy;\r\n    SysAid.login();\r\n\r\n    if (params.event_source !== \'0\' && params.event_value !== \'0\') {\r\n        // Create ticket for non trigger-based events.\r\n        SysAid.createIncident(params.alert_subject, params.alert_message, priority);\r\n    }\r\n    else if (params.event_value === \'1\' && params_update.status === \'0\') {\r\n        // Create ticket for trigger-based events.\r\n        var incident_id = SysAid.createIncident(params.alert_subject, params.alert_subject + \'\\n\' + params.alert_message +\r\n                \'\\n\' + params.zabbix_url + (params.zabbix_url.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' +\r\n                params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\', priority\r\n        );\r\n\r\n        result.tags.__zbx_sysaid_incident_id = incident_id;\r\n        result.tags.__zbx_sysaid_incidentlink = params.sysaid_url +\r\n            (params.sysaid_url.endsWith(\'/\') ? \'\' : \'/\') + \'SREdit.jsp?id=\' + incident_id + \'&fromId=IncidentsList\';\r\n    }\r\n    else {\r\n        // Update created ticket for trigger-based event.\r\n        SysAid.updateTicket(params.alert_subject + \'\\n\' + params.alert_message);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ SysAid Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_sysaid_incidentlink}','SysAid: incident #{EVENT.TAGS.__zbx_sysaid_incident_id}','','0'),
('65','4','Telegram','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nvar serviceLogName = \'Telegram Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Telegram = CWebhook;\r\n\r\nfunction escapeMarkup(str, mode) {\r\n	switch (mode) {\r\n		case \'markdown\':\r\n			return str.replace(/([_*\\[`])/g, \'\\\\$&\');\r\n		case \'markdownv2\':\r\n			return str.replace(/([_*\\[\\]()~`>#+\\-=|{}.!])/g, \'\\\\$&\');\r\n		case \'html\':\r\n			return str.replace(/<(\\s|[^a-z\\/])/g, \'&lt;$1\');\r\n		default:\r\n			return str;\r\n	}\r\n}\r\n\r\nTelegram.prototype.getMessageID = function (chat_id, message_thread_id) {\r\n	const tag_key = \'__telegram_msg_id_\' + chat_id + (message_thread_id ? \'_\' + message_thread_id : \'\');\r\n	if (CParamValidator.isDefined(this.params.event_tags[tag_key])) {\r\n		return this.params.event_tags[tag_key];\r\n	}\r\n	return null;\r\n}\r\n\r\nTelegram.prototype.onCheckParams = function () {\r\n	CParamValidator.validate(\r\n		{\r\n			api_token: {type: \'string\'},\r\n			api_chat_id: {type: \'string\'},\r\n			alert_message: {type: \'string\'}\r\n		},\r\n		this.params\r\n	);\r\n\r\n	if (CParamValidator.inArray(this.params.event_source, [\'0\', \'3\', \'4\'])) {\r\n		CParamValidator.validate({\r\n			event_tags: {type: \'array\', macro: \'EVENT.TAGSJSON\', tags: true, default: {}}\r\n		}, this.params);\r\n	}\r\n\r\n	this.params.url = \'https://api.telegram.org/bot\';\r\n	this.data = {\r\n		disable_web_page_preview: true,\r\n		disable_notification: false\r\n	};\r\n	const match = this.params.api_chat_id.match(/^(-?\\d+|@[a-zA-Z0-9_]+)(?::(\\d+))?$/);\r\n	if (!match) {\r\n		throw \'Invalid format for api_chat_id: "\' + this.params.api_chat_id + \'". Must be a numeric group ID or @GroupName, optionally followed by :message_thread_id.\';\r\n	}\r\n	this.data[\'chat_id\'] = match[1];\r\n	if (CParamValidator.isDefined(match[2])) {\r\n		this.data[\'message_thread_id\'] = match[2];\r\n	}\r\n	this.data[\'text\'] = ((this.params.alert_subject !== \'\') ? this.params.alert_subject + \'\\n\' : \'\') + this.params.alert_message;\r\n	if ([\'markdown\', \'html\', \'markdownv2\'].indexOf(this.params.api_parse_mode.toLowerCase()) !== -1) {\r\n		this.data[\'parse_mode\'] = this.params.api_parse_mode.toLowerCase();\r\n		this.data[\'text\'] = escapeMarkup(this.data[\'text\'], this.data[\'parse_mode\']);\r\n	}\r\n	const reply_to_message_id = this.getMessageID(this.data[\'chat_id\'], this.data[\'message_thread_id\']);\r\n	if (reply_to_message_id !== null) {\r\n		this.data[\'reply_to_message_id\'] = reply_to_message_id;\r\n	}\r\n	this.result = {tags: {}};\r\n};\r\n\r\nTelegram.prototype.onEvent = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n	Logger.log(Logger.INFO, \'URL: \' + this.params.url.replace(this.params.api_token, \'<TOKEN>\'));\r\n	var response = this.request.jsonRequest(\'POST\', this.params.url + this.params.api_token + \'/sendMessage\', this.data);\r\n\r\n	if (this.request.getStatus() !== 200 || !CParamValidator.isType(response.ok, \'boolean\') || response.ok !== true) {\r\n		Logger.log(Logger.INFO, \'HTTP code: \' + this.request.getStatus());\r\n		if (CParamValidator.isType(response.description, \'string\')) {\r\n			throw response.description;\r\n		}\r\n		else {\r\n			throw \'Unknown error. Check debug log for more information.\';\r\n		}\r\n	}\r\n\r\n	if (CParamValidator.isDefined(response.result.message_id) && this.getMessageID(this.data[\'chat_id\'], this.data[\'message_thread_id\']) === null) {\r\n		this.result.tags[\'__telegram_msg_id_\' + this.data[\'chat_id\'] + (this.data[\'message_thread_id\'] ? \'_\' + this.data[\'message_thread_id\'] : \'\')] = response.result.message_id;\r\n	}\r\n\r\n	return this.result;\r\n};\r\n\r\ntry {\r\n	var hook = new Telegram(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','0','','','This media type integrates your Zabbix installation with Telegram using the Zabbix webhook feature.\r\n\r\nTelegram configuration:\r\n\r\n1. Register a new Telegram bot: send "/newbot" to "@BotFather" and follow the instructions. The token provided by "@BotFather" in the final step will be needed for configuring the Zabbix webhook.\r\n\r\n2. Set up personal or group notifications:\r\n\r\n2.1 Personal notifications:\r\n\r\n2.1.1 Retrieve the chat ID of the user the bot should send messages to. The user should send "/getid" to "@myidbot" in the Telegram messenger.\r\n\r\n2.1.2 The user should also send "/start" to the bot created in step 1. If you skip this step, the Telegram bot won\'t be able to send messages to the user (bots cannot initiate conversations with users).\r\n\r\n2.2 Group notifications:\r\n\r\n2.2.1 Retrieve the group ID of the group that the bot should send messages to. Add "@myidbot" and the bot created in step 1 to your group.\r\n\r\n2.2.2 In the group chat, send: "/getgroupid@myidbot".\r\n\r\n2.2.3 If the bot is added to a supergroup and you want the bot to send messages to a specific topic instead of the default "General" channel, right-click any message in that topic and click "Copy Message Link". The copied link will have the following format: "https://t.me/c/<short_group_id>/<topic_id>/<message_id>", for example: "https://t.me/c/1234567890/2/1". In this example, the topic ID is "2".\r\n\r\nNote:\r\n- The group ID is a negative number, for example: "-1234567890".\r\n- The supergroup ID is a negative number prefixed with "-100", for example: "-1001234567890"\r\n- The public group or supergroup ID can also be specified in media type properties as a name prefixed by "@", for example: "@MyGroupName".\r\n\r\n3. Depending on where you want to send notifications, copy and save the bot token, personal chat ID or group ID, and topic ID (if you want to send messages to a specific supergroup topic), as you will need these later to set up the media type in Zabbix.\r\n\r\nZabbix configuration:\r\n\r\n1. Set the following webhook parameters:\r\n- "api_parse_mode" - the formatting mode applied for messages (possible values: "markdown", "html", "markdownv2")\r\n- "api_token" - the token of the bot used to send messages\r\n\r\nLearn more about message formatting options in Telegram Bot API documentation:\r\n- Markdown: https://core.telegram.org/bots/api#markdown-style\r\n- HTML: https://core.telegram.org/bots/api#html-style\r\n- MarkdownV2: https://core.telegram.org/bots/api#markdownv2-style\r\n\r\nNote: Your Telegram-related actions should be separated from other notification types (e.g., SMS); otherwise, if you use Markdown or HTML in the alert subject or body, you may receive plain-text alerts with raw tags.\r\n\r\n2. Click the "Enabled" checkbox to enable the media type and click the "Update" button to save the webhook settings.\r\n\r\n3. Create a Zabbix user and add media:\r\n- To create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to Telegram.\r\n- In the "Media" tab, click "Add" and select the type "Telegram" from the drop-down list.\r\n- In the "Send to" field, specify the Telegram user chat ID or group ID that you retrieved during Telegram setup. To send notifications to a specific topic within a supergroup, specify the topic ID after the semicolon delimiter in the format "<group_id>:<topic_id>", for example: "-1001234567890:2", "@MyGroupName:2".\r\n\r\n4. Done! You can now start using this media type in actions and create tickets.\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/telegram','0'),
('66','4','TOPdesk','','','','','','','','25','0','0','0','0','1','3','10s','1','var Media = {\r\n    params: {},\r\n    name: \'\',\r\n    labels: [],\r\n    HTTPProxy: \'\',\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Media.params = params;\r\n        Media.params.api += Media.params.api.endsWith(\'/\') ? \'\' : \'/\';\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        if (typeof HTTPProxy !== \'undefined\' && HTTPProxy.trim() !== \'\') {\r\n            Media.HTTPProxy = HTTPProxy;\r\n        }\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'api\', \'token\'].forEach(function (field) {\r\n            if (typeof Media.params !== \'object\' || typeof Media.params[field] === \'undefined\'\r\n                    || Media.params[field] === \'\') {\r\n                throw \'Required \' + Media.name + \' param is not set: "\' + field + \'".\';\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Media.params.api + query,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Accept: application/json\');\r\n        request.addHeader(\'Authorization: \' + Media.params.token);\r\n        request.setProxy(Media.HTTPProxy);\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Sending request: \' +\r\n            url + ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Failed to parse response.\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null) {\r\n                if (typeof response.errors === \'object\' && Object.keys(response.errors).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errors);\r\n                }\r\n                else if (typeof response.errorMessages === \'object\' && Object.keys(response.errorMessages).length > 0) {\r\n                    message += \': \' + JSON.stringify(response.errorMessages);\r\n                }\r\n                else if (typeof response.message === \'string\') {\r\n                    message += \': \' + response.message;\r\n                }\r\n            }\r\n\r\n            throw message + \' Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    }\r\n};\r\n\r\ntry {\r\n    var result = {tags: {}},\r\n        params = JSON.parse(value),\r\n        media = {},\r\n        fields = {},\r\n        resp = {},\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\',\r\n            \'topdesk_api\',\r\n            \'topdesk_user\',\r\n            \'topdesk_password\'\r\n        ],\r\n        severities = [\r\n            \'not_classified\',\r\n            \'information\',\r\n            \'warning\',\r\n            \'average\',\r\n            \'high\',\r\n            \'disaster\',\r\n            \'resolved\',\r\n            \'default\'\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter "\' + key + \'" cannot be empty.\';\r\n            }\r\n            if (key.startsWith(\'topdesk_\')) {\r\n                media[key.substring(8)] = params[key];\r\n            }\r\n        });\r\n\r\n    // Possible values of event_source:\r\n    // 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: "\' + params.event_source + \'".\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check event_value for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_update_status only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check event_id for a numeric value.\r\n    if (isNaN(parseInt(params.event_id)) || params.event_id < 1) {\r\n        throw \'Incorrect "event_id" parameter given: \' + params.event_id + \'\\nMust be a positive number.\';\r\n    }\r\n\r\n    if ((params.event_source === \'1\' || params.event_source === \'2\')  && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for Trigger and Internal actions.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity]];\r\n    params.zbxurl = params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\');\r\n\r\n    Media.name = \'TOPdesk\';\r\n    Media.setParams(media);\r\n    Media.params.token = \'Basic \' + btoa(Media.params.user + \':\' + Media.params.password);\r\n    Media.setProxy(params.HTTPProxy);\r\n\r\n    // Create an issue.\r\n    // Numeric value of the event that triggered an action (1 for problem, 0 for recovering).\r\n    // Numeric value of the problem update status. Possible values:\r\n    // 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if ((params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0)\r\n            || (params.event_source == 3 && params.event_value == 1)\r\n            || params.event_source == 1 || params.event_source == 2) {\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Request of the ticket creating.\');\r\n        fields.caller = {dynamicName: \'Zabbix\'};\r\n        fields.briefDescription = params.alert_subject;\r\n        fields.request = params.alert_message.replace(/\\n/g, \'<br>\');\r\n        fields.priority = {name: priority};\r\n        fields.processingStatus = {name: Media.params.status};\r\n        fields.externalNumber = params.event_id;\r\n        fields.request += \'<br>\' + params.zbxurl;\r\n\r\n        if (params.event_source === \'0\') {\r\n            fields.request += \'tr_events.php?triggerid=\' + params.trigger_id + \'&eventid=\' + params.event_id;\r\n        }\r\n\r\n        resp = Media.request(\'post\', \'tas/api/incidents\', fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.id === \'undefined\') {\r\n            throw \'Cannot create \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n\r\n        if (params.event_source == 0 && params.event_value == 1 && params.event_update_status == 0) {\r\n            result.tags.__zbx_tpd_issuekey = resp.response.number;\r\n            result.tags.__zbx_tpd_issuelink = Media.params.api +\r\n                \'tas/secure/incident?action=show&unid=\' + resp.response.id;\r\n        }\r\n    }\r\n    // Update a created issue.\r\n    else {\r\n        if (params.event_source == 3 && params.event_value == 0) {\r\n            throw \'Internal event recovery actions are not supported.\';\r\n        }\r\n\r\n        Zabbix.log(4, \'[ \' + Media.name + \' Webhook ] Request of the ticket updating.\');\r\n        fields.action = params.alert_message.replace(/\\n/g, \'<br>\');\r\n\r\n        resp = Media.request(\'put\', \'tas/api/incidents/number/\' + Media.params.issue_key, fields);\r\n        if (typeof resp.response !== \'object\' || typeof resp.response.id === \'undefined\'\r\n                || resp.response.number !== Media.params.issue_key) {\r\n            throw \'Cannot update \' + Media.name + \' issue. Check debug log for more information.\';\r\n        }\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ \' + Media.name + \' Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_tpd_issuelink}','TOPdesk: {EVENT.TAGS.__zbx_tpd_issuekey}','Please refer to https://developers.topdesk.com/documentation/index.html and https://www.zabbix.com/documentation/7.0/manual/config/notifications/media/webhook#example_scripts.\r\n  \r\nSet global macro {$ZABBIX.URL} with your Zabbix server URL.\r\nAdd a dedicated user with the media type "TOPdesk".\r\nChange the values of the variables topdesk_api (URL), topdesk_password, topdesk_user. The topdesk_status is the default status for creating a new TOPdesk ticket.','0'),
('67','4','VictorOps','','','','','','','','25','0','0','0','0','1','3','10s','1','var VictorOps = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        VictorOps.params = params;\r\n        if (VictorOps.params.endpoint) {\r\n            if (!VictorOps.params.endpoint.endsWith(\'/\')) {\r\n                VictorOps.params.endpoint += \'/\';\r\n            }\r\n\r\n            if (typeof VictorOps.params.routing_key !== \'undefined\'\r\n                    && VictorOps.params.routing_key !== \'{ALERT.SENDTO}\'\r\n                    && VictorOps.params.routing_key !== \'Default\') {\r\n                VictorOps.params.endpoint += VictorOps.params.routing_key;\r\n            }\r\n        }\r\n    },\r\n\r\n    setProxy: function (HTTPProxy) {\r\n        VictorOps.HTTPProxy = HTTPProxy;\r\n    },\r\n\r\n    addFields: function (fields) {\r\n        var data = {};\r\n\r\n        if (typeof fields === \'object\') {\r\n            Object.keys(fields)\r\n                .forEach(function(field) {\r\n                    if (fields[field] === \'\') {\r\n                        Zabbix.log(4, \'[ VictorOps Webhook ] Field "\' + field +\r\n                            \'" can\\\'t be empty. The field ignored.\');\r\n                    }\r\n                    else {\r\n                        try {\r\n                            var parts = field.split(\':\'),\r\n                                prefix = parts[0].split(\'_\');\r\n\r\n                            if (typeof prefix[1] === \'undefined\'\r\n                                    || (prefix[1] === \'p\' && params.event_value === \'1\'\r\n                                        && (params.event_update_status === \'0\'\r\n                                            || params.event_update_status === \'{EVENT.UPDATE.STATUS}\'))\r\n                                    || (prefix[1] === \'r\' && params.event_value === \'0\'\r\n                                        && (params.event_update_status === \'0\'\r\n                                            || params.event_update_status === \'{EVENT.UPDATE.STATUS}\'))\r\n                                    || (prefix[1] === \'u\' && params.event_update_status === \'1\')) {\r\n                                data[field.substring(field.indexOf(\':\') + 1)] = fields[field];\r\n                            }\r\n                        }\r\n                        catch (error) {\r\n                            Zabbix.log(4, \'[ VictorOps Webhook ] Can\\\'t parse field "\' + field +\r\n                                \'". The field ignored.\');\r\n                        }\r\n                    }\r\n                });\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (data) {\r\n        if (typeof VictorOps.params !== \'object\' || typeof VictorOps.params.endpoint === \'undefined\'\r\n                || VictorOps.params.endpoint === \'\' ) {\r\n            throw \'Required parameter is not set: "vops_endpoint".\';\r\n        }\r\n\r\n        var response,\r\n            url = VictorOps.params.endpoint,\r\n            request = new HttpRequest();\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n\r\n        if (typeof VictorOps.HTTPProxy !== \'undefined\' && VictorOps.HTTPProxy !== \'\') {\r\n            request.setProxy(VictorOps.HTTPProxy);\r\n        }\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[ VictorOps Webhook ] Sending request: \' + url +\r\n            ((typeof data === \'string\') ? (\'\\n\' + data) : \'\'));\r\n\r\n        response = request.post(url, data);\r\n\r\n        Zabbix.log(4, \'[ VictorOps Webhook ] Received response with status code \' +\r\n            request.getStatus() + \'\\n\' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[ VictorOps Webhook ] Failed to parse response received from VictorOps\');\r\n                response = null;\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.messages !== \'undefined\') {\r\n                message += \': \' + JSON.stringify(response.messages);\r\n            }\r\n\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return response;\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        vops = {},\r\n        required_params = [\'event_source\', \'event_value\', \'priority_update\'],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ];\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'vops_\')) {\r\n                vops[key.substring(5)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'field\')) {\r\n                fields[key.substring(5)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key] === \'\') {\r\n                throw \'Parameter "\' + key + \'" can\\\'t be empty.\';\r\n            }\r\n        });\r\n\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n            && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    if (params.event_update_status !== \'0\' && params.event_update_status !== \'1\' && params.event_source === \'0\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    if (params.event_update_status === \'1\') {\r\n        fields[\':message_type\'] = params.priority_update;\r\n    }\r\n    else {\r\n        fields[\':message_type\'] = params[\'priority_\' + severities[params.event_nseverity].name]\r\n            || \'INFO\';\r\n    }\r\n\r\n    if (params.event_info && params.event_source === \'0\') {\r\n        fields[\':event_info\'] = params.event_info;\r\n    }\r\n\r\n    VictorOps.setParams(vops);\r\n    VictorOps.setProxy(params.HTTPProxy);\r\n    VictorOps.request(VictorOps.addFields(fields));\r\n\r\n    return \'OK\';\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[ VictorOps Webhook ] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','0','0','','','','0'),
('68','4','Zammad','','','','','','','','25','0','0','0','0','1','3','10s','1','const CLogger = function(serviceName) {\r\n	this.serviceName = serviceName;\r\n	this.INFO = 4\r\n	this.WARN = 3\r\n	this.ERROR = 2\r\n	this.log = function(level, msg) {\r\n		Zabbix.log(level, \'[\' + this.serviceName + \'] \' + msg);\r\n	}\r\n}\r\n\r\nconst CWebhook = function(value) {\r\n	try {\r\n		params = JSON.parse(value);\r\n\r\n		if ([\'0\', \'1\', \'2\', \'3\', \'4\'].indexOf(params.event_source) === -1) {\r\n			throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'.\\nMust be 0-4.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1 && [\'0\', \'1\'].indexOf(params.event_value) === -1) {\r\n			throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0 or 1.\';\r\n		}\r\n\r\n		if ([\'0\', \'3\', \'4\'].indexOf(params.event_source) !== -1) {\r\n			if (params.event_source === \'1\' && [\'0\', \'1\', \'2\', \'3\'].indexOf(params.event_value) === -1) {\r\n				throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'.\\nMust be 0-3.\';\r\n			}\r\n\r\n			if (params.event_source === \'0\' && [\'0\', \'1\'].indexOf(params.event_update_status) === -1) {\r\n				throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'.\\nMust be 0 or 1.\';\r\n			}\r\n\r\n			if (params.event_source === \'4\') {\r\n				if ([\'0\', \'1\', \'2\', \'3\', \'4\', \'5\'].indexOf(params.event_update_nseverity) !== -1 && params.event_update_nseverity != params.event_nseverity) {\r\n					params.event_nseverity = params.event_update_nseverity;\r\n					params.event_severity = params.event_update_severity;\r\n					params.event_update_status = \'1\';\r\n				}\r\n			}\r\n		}\r\n\r\n		this.runCallback = function(name, params) {\r\n			if (typeof this[name] === \'function\') {\r\n				return this[name].apply(this, [params]);\r\n			}\r\n		}\r\n\r\n		this.handleEvent = function(source, event) {\r\n			const alert = { source: source, event: event };\r\n			return [\r\n				this.runCallback(\'on\' + source + event, alert),\r\n				this.runCallback(\'on\' + event, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.handleEventless = function(source) {\r\n			const alert = { source: source, event: null };\r\n			return [\r\n				this.runCallback(\'on\' + source, alert),\r\n				this.runCallback(\'onEvent\', alert)\r\n			];\r\n		}\r\n\r\n		this.run = function() {\r\n			var results = [];\r\n			if (typeof this.httpProxy === \'string\' && this.httpProxy.trim() !== \'\') {\r\n				this.request.setProxy(this.httpProxy);\r\n			}\r\n			const types = { \'0\': \'Trigger\', \'1\': \'Discovery\', \'2\': \'Autoreg\', \'3\': \'Internal\', \'4\': \'Service\' };\r\n\r\n			if ([\'0\', \'3\', \'4\'].indexOf(this.params.event_source) !== -1) {\r\n				var event = (this.params.event_update_status === \'1\')\r\n					? \'Update\'\r\n					: ((this.params.event_value === \'1\') ? \'Problem\' : \'Resolve\');\r\n\r\n				results = this.handleEvent(types[this.params.event_source], event);\r\n			}\r\n			else if (typeof types[this.params.event_source] !== \'undefined\') {\r\n				results = this.handleEventless(types[this.params.event_source]);\r\n			}\r\n			else {\r\n				throw \'Unexpected "event_source": \' + this.params.event_source;\r\n			}\r\n\r\n			for (idx in results) {\r\n				if (typeof results[idx] !== \'undefined\') {\r\n					return JSON.stringify(results[idx]);\r\n				}\r\n			}\r\n		}\r\n		this.httpProxy = params.http_proxy;\r\n		this.params = params;\r\n		this.runCallback(\'onCheckParams\', {});\r\n	} catch (error) {\r\n		throw \'Webhook processing failed: \' + error;\r\n	}\r\n}\r\n\r\nconst CParamValidator = {\r\n\r\n	isType: function(value, type) {\r\n		if (type === \'array\') {\r\n			return Array.isArray(value);\r\n		}\r\n		if (type === \'integer\') {\r\n			return CParamValidator.isInteger(value);\r\n		}\r\n		if (type === \'float\') {\r\n			return CParamValidator.isFloat(value);\r\n		}\r\n\r\n		return (typeof value === type);\r\n	},\r\n\r\n	isInteger: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseInt(value));\r\n	},\r\n\r\n	isFloat: function(value) {\r\n		if (!CParamValidator.ifMatch(value, /^-?\\d+\\.\\d+$/)) {\r\n			return false;\r\n		}\r\n\r\n		return !isNaN(parseFloat(value));\r\n	},\r\n\r\n	isDefined: function(value) {\r\n		return !CParamValidator.isType(value, \'undefined\');\r\n	},\r\n\r\n	isEmpty: function(value) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be checked for emptiness.\';\r\n		}\r\n\r\n		return (value.trim() === \'\');\r\n	},\r\n\r\n	isMacroSet: function(value, macro) {\r\n		if (CParamValidator.isDefined(macro)) {\r\n			return !(CParamValidator.ifMatch(value, \'^\\{\' + macro + \'\\}$\'))\r\n		}\r\n\r\n		return !(CParamValidator.ifMatch(value, \'^\\{[$#]{0,1}[A-Z_\\.]+[\\:]{0,1}["]{0,1}.*["]{0,1}\\}$\') || value === \'*UNKNOWN*\')\r\n	},\r\n\r\n	withinRange: function(value, min, max) {\r\n		if (!CParamValidator.isType(value, \'number\')) {\r\n			throw \'Value "\' + value + \'" must be a number to be checked for range.\';\r\n		}\r\n		if (value < ((CParamValidator.isDefined(min)) ? min : value)\r\n			|| value > ((CParamValidator.isDefined(max)) ? max : value)) {\r\n			return false;\r\n		}\r\n\r\n		return true;\r\n	},\r\n\r\n	inArray: function(value, array) {\r\n		if (!CParamValidator.isType(array, \'array\')) {\r\n			throw \'The array must be an array to check the value for existing in it.\';\r\n		}\r\n\r\n		return (array.indexOf((typeof value === \'string\') ? value.toLowerCase() : value) !== -1);\r\n	},\r\n\r\n	ifMatch: function(value, regex) {\r\n		return (new RegExp(regex)).test(value);\r\n	},\r\n\r\n	match: function(value, regex) {\r\n		if (!CParamValidator.isType(value, \'string\')) {\r\n			throw \'Value "\' + value + \'" must be a string to be matched with the regular expression.\';\r\n		}\r\n\r\n		return value.match(new RegExp(regex));\r\n	},\r\n\r\n	checkURL: function(value) {\r\n		if (CParamValidator.isEmpty(value)) {\r\n			throw \'URL value "\' + value + \'" must be a non-empty string.\';\r\n		}\r\n		if (!CParamValidator.ifMatch(value, \'^(http|https):\\/\\/.+\')) {\r\n			throw \'URL value "\' + value + \'" must contain a schema.\';\r\n		}\r\n\r\n		return value.endsWith(\'/\') ? value.slice(0, -1) : value;\r\n	},\r\n\r\n	check: function(key, rule, params) {\r\n		if (!CParamValidator.isDefined(rule.type)) {\r\n			throw \'Mandatory attribute "type" has not been defined for parameter "\' + key + \'".\';\r\n		}\r\n		if (!CParamValidator.isDefined(params[key])) {\r\n			throw \'Checked parameter "\' + key + \'" was not found in the list of input parameters.\';\r\n		}\r\n		var value = params[key],\r\n			error_message = null;\r\n		switch (rule.type) {\r\n			case \'string\':\r\n				if (!CParamValidator.isType(value, \'string\')) {\r\n					throw \'Value "\' + key + \'" must be a string.\';\r\n				}\r\n				if (CParamValidator.isEmpty(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a non-empty string\';\r\n					break;\r\n				}\r\n				if (CParamValidator.isDefined(rule.len) && value.length < rule.len) {\r\n					error_message = \'Value "\' + key + \'" must be a string with a length > \' + rule.len;\r\n				}\r\n				if (CParamValidator.isDefined(rule.regex) && !CParamValidator.ifMatch(value, rule.regex)) {\r\n					error_message = \'Value "\' + key + \'" must match the regular expression "\' + rule.regex + \'"\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.url) && rule.url === true) {\r\n					value = CParamValidator.checkURL(value);\r\n				}\r\n				break;\r\n			case \'integer\':\r\n				if (!CParamValidator.isInteger(value)) {\r\n					error_message = \'Value "\' + key + \'" must be an integer\';\r\n					break;\r\n				}\r\n				value = parseInt(value);\r\n				break;\r\n			case \'float\':\r\n				if (!CParamValidator.isFloat(value)) {\r\n					error_message = \'Value "\' + key + \'" must be a floating-point number\';\r\n					break;\r\n				}\r\n				value = parseFloat(value);\r\n				break;\r\n			case \'boolean\':\r\n				if (CParamValidator.inArray(value, [\'1\', \'true\', \'yes\', \'on\'])) {\r\n					value = true;\r\n				}\r\n				else if (CParamValidator.inArray(value, [\'0\', \'false\', \'no\', \'off\'])) {\r\n					value = false;\r\n				}\r\n				else {\r\n					error_message = \'Value "\' + key + \'" must be a boolean-like.\';\r\n				}\r\n				break;\r\n			case \'array\':\r\n				try {\r\n					value = JSON.parse(value);\r\n				} catch (error) {\r\n					throw \'Value "\' + key + \'" contains invalid JSON.\';\r\n				}\r\n				if (!CParamValidator.isType(value, \'array\')) {\r\n					error_message = \'Value "\' + key + \'" must be an array.\';\r\n				}\r\n				if (CParamValidator.isDefined(rule.tags) && rule.tags === true) {\r\n					value = value.reduce(function(acc, obj) {\r\n						acc[obj.tag] = obj.value || null;\r\n						return acc;\r\n					}, {});\r\n				}\r\n				break;\r\n			case \'object\':\r\n				value = JSON.parse(value);\r\n				if (!CParamValidator.isType(value, \'object\')) {\r\n					error_message = \'Value "\' + key + \'" must be an object.\';\r\n				}\r\n				break;\r\n			default:\r\n				throw \'Unexpected attribute type "\' + rule.type + \'" for value "\' + key + \'". Available: \' +\r\n				[\'integer\', \'float\', \'string\', \'boolean\', \'array\', \'object\'].join(\', \');\r\n		}\r\n		params[key] = value;\r\n		if (CParamValidator.inArray(rule.type, [\'integer\', \'float\']) && error_message === null && (CParamValidator.isDefined(rule.min)\r\n			|| CParamValidator.isDefined(rule.max)) && !CParamValidator.withinRange(value, rule.min, rule.max)) {\r\n			error_message = \'Value "\' + key + \'" must be a number \' + ((CParamValidator.isDefined(rule.min) && CParamValidator.isDefined(rule.max))\r\n				? (rule.min + \'..\' + rule.max) : ((CParamValidator.isDefined(rule.min)) ? \'>\' + rule.min : \'<\' + rule.max));\r\n		}\r\n		else if (CParamValidator.isDefined(rule.array) && !CParamValidator.inArray(value, rule.array)) {\r\n			error_message = \'Value "\' + key + \'" must be in the array \' + JSON.stringify(rule.array);\r\n		}\r\n		else if (CParamValidator.isDefined(rule.macro) && !CParamValidator.isMacroSet(value.toString(), rule.macro)) {\r\n			error_message = \'The macro \' + ((CParamValidator.isDefined(rule.macro)) ? \'{\' + rule.macro + \'} \' : \' \') + \'is not set\';\r\n		}\r\n		if (error_message !== null) {\r\n			if (CParamValidator.isDefined(rule.default) && CParamValidator.isType(rule.default, rule.type)) {\r\n				params[key] = rule.default;\r\n			}\r\n			else {\r\n				Zabbix.log(4, \'Default value for "\' + key + \'" must be a \' + rule.type + \'. Skipped.\');\r\n				throw \'Incorrect value for variable "\' + key + \'". \' + error_message;\r\n			}\r\n		}\r\n\r\n		return this;\r\n	},\r\n\r\n	validate: function(rules, params) {\r\n		if (!CParamValidator.isType(params, \'object\') || CParamValidator.isType(params, \'array\')) {\r\n			throw \'Incorrect parameters value. The value must be an object.\';\r\n		}\r\n		for (var key in rules) {\r\n			CParamValidator.check(key, rules[key], params);\r\n		}\r\n	}\r\n}\r\n\r\nconst CHttpRequest = function(logger) {\r\n	this.request = new HttpRequest();\r\n	if (typeof logger !== \'object\' || logger === null) {\r\n		this.logger = Zabbix;\r\n	}\r\n	else {\r\n		this.logger = logger;\r\n	}\r\n\r\n	this.clearHeader = function() {\r\n		this.request.clearHeader();\r\n	}\r\n\r\n	this.addHeaders = function(value) {\r\n		var headers = [];\r\n\r\n		if (typeof value === \'object\' && value !== null) {\r\n			if (!Array.isArray(value)) {\r\n				Object.keys(value).forEach(function(key) {\r\n					headers.push(key + \': \' + value[key]);\r\n				});\r\n			}\r\n			else {\r\n				headers = value;\r\n			}\r\n		}\r\n		else if (typeof value === \'string\') {\r\n			value.split(\'\\r\\n\').forEach(function(header) {\r\n				headers.push(header);\r\n			});\r\n		}\r\n\r\n		for (var idx in headers) {\r\n			this.request.addHeader(headers[idx]);\r\n		}\r\n	}\r\n\r\n	this.setProxy = function(proxy) {\r\n		this.request.setProxy(proxy);\r\n	}\r\n\r\n	this.plainRequest = function(method, url, data) {\r\n		var resp = null;\r\n		method = method.toLowerCase();\r\n		this.logger.log(4, \'Sending \' + method + \' request:\' + JSON.stringify(data));\r\n		if ([\'get\', \'post\', \'put\', \'patch\', \'delete\', \'trace\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url, data);\r\n		}\r\n		else if ([\'connect\', \'head\', \'options\'].indexOf(method) !== -1) {\r\n			resp = this.request[method](url);\r\n		}\r\n		else {\r\n			throw \'Unexpected method. Method \' + method + \' is not supported.\';\r\n		}\r\n		this.logger.log(4, \'Response has been received: \' + resp);\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.jsonRequest = function(method, url, data) {\r\n		this.addHeaders(\'Content-Type: application/json\');\r\n		var resp = this.plainRequest(method, url, JSON.stringify(data));\r\n		try {\r\n			resp = JSON.parse(resp);\r\n		}\r\n		catch (error) {\r\n			throw \'Failed to parse response: not well-formed JSON was received\';\r\n		}\r\n\r\n		return resp;\r\n	}\r\n\r\n	this.getStatus = function() {\r\n		return this.request.getStatus();\r\n	}\r\n}\r\n\r\nconst CWebhookHelper = {\r\n\r\n	createProblemURL: function(event_source, zabbix_url, trigger_id, event_id) {\r\n		if (event_source === \'0\') {\r\n			return zabbix_url + \'/tr_events.php?triggerid=\' + trigger_id + \'&eventid=\' + event_id;\r\n		} else if (event_source === \'4\') {\r\n			return zabbix_url + \'/zabbix.php?action=service.list\';\r\n		}\r\n\r\n		return zabbix_url;\r\n	},\r\n\r\n};\r\n\r\nvar ZABBIX_SEVERITY_MAP = ["not_classified", "information", "warning", "average", "high", "disaster"],\r\n	serviceLogName = \'Zammad Webhook\',\r\n	Logger = new CLogger(serviceLogName),\r\n	Zammad = CWebhook;\r\n\r\nZammad.prototype.onCheckParams = function () {\r\n	CParamValidator.validate({\r\n		alert_message: {type: \'string\'},\r\n		alert_subject: {type: \'string\'},\r\n		zammad_url: {type: \'string\', url: true},\r\n		zammad_customer: {type: \'string\'},\r\n		zammad_access_token: {type: \'string\'},\r\n		zammad_group: {type: \'string\'},\r\n		zammad_enable_tags: {type: \'boolean\', default: false},\r\n		event_nseverity: {type: \'integer\', default: -1},\r\n		zabbix_url: {type: \'string\', url: true}\r\n	}, this.params);\r\n\r\n	if (CParamValidator.inArray(this.params.event_source, [\'0\', \'3\', \'4\'])) {\r\n		CParamValidator.validate({\r\n			event_tags: {type: \'array\', macro: \'EVENT.TAGSJSON\', tags: true, default: {}}\r\n		}, this.params);\r\n	}\r\n\r\n	var priority;\r\n\r\n	if (this.params.event_nseverity >= 0 && this.params.event_nseverity < ZABBIX_SEVERITY_MAP.length) {\r\n		priority = this.params[\'severity_\' + ZABBIX_SEVERITY_MAP[this.params.event_nseverity]];\r\n	}\r\n	this.priority = (CParamValidator.isDefined(priority)) ? priority.trim() : null;\r\n\r\n	this.result = {tags: {}};\r\n};\r\n\r\nZammad.prototype.onProblem = function (alert) {\r\n	if (CParamValidator.isDefined(this.params.event_tags[\'__zbx_zammad_ticket_id\'])) {\r\n		return this.onUpdate(alert);\r\n	}\r\n\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	this.request.addHeaders(\'Authorization: Token token=\' + this.params.zammad_access_token);\r\n\r\n	var payload_data = {\r\n		title: this.params.alert_subject,\r\n		group: this.params.zammad_group,\r\n		article: {\r\n			subject: this.params.alert_subject,\r\n			body: this.params.alert_message + \'\\n\' + CWebhookHelper.createProblemURL(this.params.event_source, this.params.zabbix_url, this.params.trigger_id, this.params.event_id),\r\n			type: \'note\',\r\n			internal: false\r\n		},\r\n		customer: this.params.zammad_customer\r\n	};\r\n\r\n	if (this.priority) {\r\n		payload_data.priority_id = this.priority;\r\n	}\r\n\r\n	const response = this.request.jsonRequest(\'POST\', this.params.zammad_url + \'/api/v1/tickets\', payload_data);\r\n\r\n	if (this.request.getStatus() != 201 || !CParamValidator.isDefined(response.id)) {\r\n		var message = \'Cannot create Zammad ticket. Request failed with status code \' + this.request.getStatus();\r\n\r\n		if (CParamValidator.isDefined(response.error) && Object.keys(response.error).length > 0) {\r\n			message += \': \' + response.error;\r\n		}\r\n\r\n		throw message + \' Check debug log for more information.\';\r\n	}\r\n\r\n	this.result.tags = {\r\n		__zbx_zammad_ticket_id: response.id,\r\n		__zbx_zammad_ticketlink: this.params.zammad_url + \'/#ticket/zoom/\' + response.id\r\n	};\r\n\r\n	if (this.params.zammad_enable_tags && Object.keys(this.params.event_tags).length > 0 && CParamValidator.inArray(this.params.event_source, [\'0\', \'3\', \'4\'])) {\r\n		this.request.clearHeader();\r\n		this.request.addHeaders({\r\n			"Content-Type": "application/json",\r\n			"Authorization": "Token token=" + this.params.zammad_access_token\r\n		});\r\n\r\n		payload_data = {\r\n			item: \'\',\r\n			object: \'Ticket\',\r\n			o_id: response.id\r\n		};\r\n\r\n		try {\r\n			for (var tag in this.params.event_tags) {\r\n				payload_data.item = tag;\r\n\r\n				if (this.params.event_tags[tag]) {\r\n					payload_data.item += ": " + this.params.event_tags[tag];\r\n				}\r\n\r\n				this.request.plainRequest(\'POST\', this.params.zammad_url + \'/api/v1/tags/add\', JSON.stringify(payload_data));\r\n\r\n				if (this.request.getStatus() != 201) {\r\n					Logger.log(Logger.INFO, \'Failed to set tag: \' + tag);\r\n				}\r\n			}\r\n		}\r\n		catch (error) {\r\n			Logger.log(Logger.INFO, \'Failed to add ticket tags: \' + error);\r\n		}\r\n	}\r\n\r\n	return this.result;\r\n}\r\n\r\nZammad.prototype.onUpdate = function (alert) {\r\n	Logger.log(Logger.INFO, \'Source: \' + alert.source + \'; Event: \' + alert.event);\r\n\r\n	if (!CParamValidator.isDefined(this.params.event_tags[\'__zbx_zammad_ticket_id\'])) {\r\n		throw "Failed to update the existing ticket: no ticket ID was received."\r\n	}\r\n\r\n\r\n	this.request.addHeaders(\'Authorization: Token token=\' + this.params.zammad_access_token);\r\n\r\n	const payload_data = {\r\n		ticket_id: this.params.event_tags[\'__zbx_zammad_ticket_id\'],\r\n		subject: this.params.alert_subject,\r\n		body: this.params.alert_message,\r\n		type: \'note\',\r\n		internal: false\r\n	};\r\n\r\n	const response = this.request.jsonRequest(\'POST\', this.params.zammad_url + \'/api/v1/ticket_articles\', payload_data);\r\n\r\n	if (this.request.getStatus() != 201 || !CParamValidator.isDefined(response.id)) {\r\n		var message = \'Cannot update Zammad ticket. Request failed with status code \' + this.request.getStatus();\r\n\r\n		if (CParamValidator.isDefined(response.error) && Object.keys(response.error).length > 0) {\r\n			message += \': \' + response.error;\r\n		}\r\n\r\n		throw message + \' Check debug log for more information.\';\r\n	}\r\n\r\n	return this.result;\r\n}\r\n\r\nZammad.prototype.onResolve = function (alert) {\r\n	return this.onUpdate(alert);\r\n}\r\n\r\nZammad.prototype.onDiscovery = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\nZammad.prototype.onAutoreg = function (alert) {\r\n	return this.onProblem(alert);\r\n}\r\n\r\ntry {\r\n	var hook = new Zammad(value);\r\n	hook.request = new CHttpRequest(Logger);\r\n	return hook.run();\r\n}\r\ncatch (error) {\r\n	Logger.log(Logger.WARN, \'notification failed: \' + error);\r\n	throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_zammad_ticketlink}','Zammad: Ticket #{EVENT.TAGS.__zbx_zammad_ticket_id}','This media type integrates your Zabbix installation with your Zammad installation using the Zabbix webhook feature.\r\n\r\nZammad configuration:\r\n\r\n1. Check that API Token Access is enabled in "Settings" → "System" → "API".\r\n2. Open the profile settings of the customer user and create a new Personal User Token.\r\n3. Set the "ticket.agent" permission for the token and press Create.\r\n4. Copy and save the created token somewhere, as it will be shown only once for security reasons.\r\n\r\nZabbix configuration:\r\n\r\n1. Before you can start using Zammad webhook, set up the global macro "{$ZABBIX.URL}":\r\n- In the Zabbix web interface, go to "Administration" → "Macros" section in the dropdown menu in the top left corner.\r\n- Set up the global macro "{$ZABBIX.URL}" which will contain the URL to the Zabbix frontend. The URL should be either an IP address, a fully qualified domain name, or localhost.\r\n- Specifying a protocol is mandatory, whereas the port is optional. Depending on the web server configuration you might also need to append "/zabbix" to the end of URL. Good examples:\r\n  - http://zabbix.com\r\n  - https://zabbix.lan/zabbix\r\n  - http://server.zabbix.lan/\r\n  - http://localhost\r\n  - http://127.0.0.1:8080\r\n- Bad examples:\r\n  - zabbix.com\r\n  - http://zabbix/\r\n\r\n2. Set the following webhook parameters:\r\n- zammad_access_token - the access token that you created during Zammad configuration\r\n- zammad_url - the frontend URL of your Zammad installation\r\n- zammad_customer - the Zammad user email\r\n- zammad_enable_tags - if you want to add the Zabbix event tags to the Zammad tickets that are created, you can set it to one of the following values: "1", "true", "yes", "on" (note, that if the tag support is enabled, each tag is sent via separate HTTP request and created tags will also remain in the Zammad when tickets are closed/deleted)\r\n- zammad_group - if needed, you can change the Zammad user group\r\n\r\n3. If you want to prioritize issues according to the severity values in Zabbix, you can define mapping parameters (create them as additional webhook parameters):\r\n- severity_<name> - the Zammad priority ID (<name> in the parameter name can be one of the following values: "not_classified", "information", "warning", "average", "high", "disaster")\r\n\r\n4. Create a Zabbix user and add media:\r\n- If you want to create a new user, go to the "Users" → "Users" section, click the "Create user" button in the top right corner. In the "User" tab, fill in all required fields (marked with red asterisks).\r\n- In the "Media" tab, add a new media and select "Zammad" type from the drop-down list. Add any value to the "Send to" field: it is required to be filled, but it is not used.\r\n- Make sure this user has access to all hosts for which you would like problem notifications to be sent to Zammad.\r\n\r\n5. Great! You can now start using this media type in actions and create tickets!\r\n\r\nYou can find the latest version of this media and additional information in the official Zabbix repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/media/zammad','0'),
('69','4','Zendesk','','','','','','','','25','0','0','0','0','1','3','10s','1','var Zendesk = {\r\n    params: {},\r\n\r\n    setParams: function (params) {\r\n        if (typeof params !== \'object\') {\r\n            return;\r\n        }\r\n\r\n        Zendesk.params = params;\r\n        if (typeof Zendesk.params.url === \'string\') {\r\n            if (!Zendesk.params.url.endsWith(\'/\')) {\r\n                Zendesk.params.url += \'/\';\r\n            }\r\n            Zendesk.params.url += \'api/v2/\';\r\n        }\r\n    },\r\n\r\n    addCustomFields: function (data, fields) {\r\n        if (typeof fields === \'object\' && Object.keys(fields).length) {\r\n            var schema = Zendesk.getSchema(),\r\n                arr = [],\r\n                i,\r\n                n;\r\n\r\n            if (schema) {\r\n                Object.keys(fields)\r\n                    .forEach(function(field) {\r\n                        for (i = 0, n = schema.ticket_fields.length; i < n; i++) {\r\n                            if (schema.ticket_fields[i].id == field\r\n                                && [\'text\', \'integer\', \'date\'].indexOf(schema.ticket_fields[i].type) !== -1){\r\n\r\n                                switch (schema.ticket_fields[i].type) {\r\n                                    case \'integer\':\r\n                                        fields[field] = parseInt(fields[field]);\r\n                                        break;\r\n                                    case \'date\':\r\n                                        if (fields[field].match(/^\\d{4}[.-]\\d{2}[.-]\\d{2}$/) !== null) {\r\n                                            fields[field] = fields[field].replace(/\\./g, \'-\');\r\n                                        }\r\n                                        else {\r\n                                            fields[field] = \'\';\r\n                                        }\r\n                                        break;\r\n                                }\r\n\r\n                                arr.push({id: field, value: fields[field]});\r\n                                break;\r\n                            }\r\n                        }\r\n                    });\r\n\r\n                if (arr.length) {\r\n                    data.ticket[\'custom_fields\'] = arr;\r\n                }\r\n            }\r\n            else {\r\n                Zabbix.log(4, \'[Zendesk Webhook] Failed to retrieve field schema.\');\r\n            }\r\n        }\r\n\r\n        return data;\r\n    },\r\n\r\n    request: function (method, query, data) {\r\n        [\'url\', \'token\', \'type\'].forEach(function (field) {\r\n            if (typeof Zendesk.params !== \'object\' || typeof Zendesk.params[field] === \'undefined\') {\r\n                throw \'Required Zendesk param is not set: \' + field + \'\\n\' + Zendesk.params[field];\r\n            }\r\n        });\r\n\r\n        var response,\r\n            url = Zendesk.params.url + query,\r\n            request = new HttpRequest();\r\n\r\n        if (typeof Zendesk.HTTPProxy === \'string\' && Zendesk.HTTPProxy.trim() !== \'\') {\r\n            request.setProxy(Zendesk.HTTPProxy);\r\n        }\r\n\r\n        request.addHeader(\'Content-Type: application/json\');\r\n        request.addHeader(\'Authorization: Basic \' + btoa(Zendesk.params.token));\r\n\r\n        if (typeof data !== \'undefined\') {\r\n            data = JSON.stringify(data);\r\n        }\r\n\r\n        Zabbix.log(4, \'[Zendesk Webhook] Sending request: \' + url + ((typeof data === \'string\') ? (\' \' + data) : \'\'));\r\n\r\n        switch (method) {\r\n            case \'get\':\r\n                response = request.get(url, data);\r\n                break;\r\n\r\n            case \'post\':\r\n                response = request.post(url, data);\r\n                break;\r\n\r\n            case \'put\':\r\n                response = request.put(url, data);\r\n                break;\r\n\r\n            default:\r\n                throw \'Unsupported HTTP request method: \' + method;\r\n        }\r\n\r\n        Zabbix.log(4, \'[Zendesk Webhook] Received response with status code \' + request.getStatus() + \'. \' + response);\r\n\r\n        if (response !== null) {\r\n            try {\r\n                response = JSON.parse(response);\r\n            }\r\n            catch (error) {\r\n                Zabbix.log(4, \'[Zendesk Webhook] Failed to parse response received from Zendesk.\');\r\n            }\r\n        }\r\n\r\n        if (request.getStatus() < 200 || request.getStatus() >= 300) {\r\n            var message = \'Request failed with status code \' + request.getStatus();\r\n\r\n            if (response !== null && typeof response.error !== \'undefined\'\r\n                && Object.keys(response.error).length > 0) {\r\n                message += \': \' + JSON.stringify(response.error);\r\n            }\r\n            else if (response !== null && typeof response.description !== \'undefined\'\r\n                && Object.keys(response.description).length > 0) {\r\n                message += \': \' + JSON.stringify(response.description);\r\n            }\r\n            else {\r\n                message += \'. \' + response;\r\n            }\r\n            throw message + \'. Check debug log for more information.\';\r\n        }\r\n\r\n        return {\r\n            status: request.getStatus(),\r\n            response: response\r\n        };\r\n    },\r\n\r\n    getSchema: function() {\r\n        var result = Zendesk.request(\'get\', \'ticket_fields.json\');\r\n\r\n        return result.response;\r\n    },\r\n\r\n    createIssue: function(data, fields) {\r\n        var result = Zendesk.request(\'post\', \'tickets.json\', Zendesk.addCustomFields(data, fields));\r\n\r\n        if (typeof result.response !== \'object\' || typeof result.response.ticket.id === \'undefined\'\r\n            || result.status != 201) {\r\n            throw \'Cannot create Zendesk issue. Check debug log for more information.\';\r\n        }\r\n\r\n        return result.response.ticket.id;\r\n    },\r\n\r\n    updateIssue: function(data, fields) {\r\n        Zendesk.request(\'put\', \'tickets/\' + Zendesk.params.issue_key + \'.json\', Zendesk.addCustomFields(data, fields));\r\n    }\r\n};\r\n\r\ntry {\r\n    var params = JSON.parse(value),\r\n        fields = {},\r\n        zendesk = {},\r\n        update = {},\r\n        data = {},\r\n        result = {tags: {}},\r\n        required_params = [\r\n            \'alert_subject\',\r\n            \'alert_message\',\r\n            \'event_id\',\r\n            \'event_source\',\r\n            \'event_value\',\r\n            \'event_update_status\'\r\n        ],\r\n        severities = [\r\n            {name: \'not_classified\', color: \'#97AAB3\'},\r\n            {name: \'information\', color: \'#7499FF\'},\r\n            {name: \'warning\', color: \'#FFC859\'},\r\n            {name: \'average\', color: \'#FFA059\'},\r\n            {name: \'high\', color: \'#E97659\'},\r\n            {name: \'disaster\', color: \'#E45959\'},\r\n            {name: \'resolved\', color: \'#009900\'},\r\n            {name: \'default\', color: \'#000000\'}\r\n        ],\r\n        priority;\r\n\r\n    Object.keys(params)\r\n        .forEach(function (key) {\r\n            if (key.startsWith(\'zendesk_\')) {\r\n                zendesk[key.substring(8)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'customfield_\')) {\r\n                fields[key.substring(12)] = params[key];\r\n            }\r\n            else if (key.startsWith(\'event_update_\')) {\r\n                update[key.substring(13)] = params[key];\r\n            }\r\n            else if (required_params.indexOf(key) !== -1 && params[key].trim() === \'\') {\r\n                throw \'Parameter \' + key + \' cannot be empty.\';\r\n            }\r\n        });\r\n\r\n    // Possible values: question, incident, problems, task\r\n    if ([\'question\', \'incident\', \'problem\', \'task\'].indexOf(params.zendesk_type) === -1) {\r\n        throw \'Incorrect "zendesk_type" parameter given: \' + params.zendesk_type +\r\n            \'\\nMust be one of question, incident, problem, task.\';\r\n    }\r\n\r\n    // Possible values: 0 - Trigger, 1 - Discovery, 2 - Autoregistration, 3 - Internal.\r\n    if ([0, 1, 2, 3].indexOf(parseInt(params.event_source)) === -1) {\r\n        throw \'Incorrect "event_source" parameter given: \' + params.event_source + \'\\nMust be 0-3.\';\r\n    }\r\n\r\n    // Check {EVENT.VALUE} for trigger-based and internal events.\r\n    // Possible values: 1 for problem, 0 for recovering\r\n    if (params.event_value !== \'0\' && params.event_value !== \'1\'\r\n        && (params.event_source === \'0\' || params.event_source === \'3\')) {\r\n        throw \'Incorrect "event_value" parameter given: \' + params.event_value + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    // Check {EVENT.UPDATE.STATUS} only for trigger-based events.\r\n    // Possible values: 0 - Webhook was called because of problem/recovery event, 1 - Update operation.\r\n    if (params.event_source === \'0\' && params.event_update_status !== \'0\' && params.event_update_status !== \'1\') {\r\n        throw \'Incorrect "event_update_status" parameter given: \' + params.event_update_status + \'\\nMust be 0 or 1.\';\r\n    }\r\n\r\n    if (params.event_source !== \'0\' && params.event_value === \'0\') {\r\n        throw \'Recovery operations are supported only for trigger-based actions.\';\r\n    }\r\n\r\n    // Zendesk_issue_key must be a positive integer if an update action is being performed.\r\n    if (params.event_source === \'0\' && ((params.event_value === \'1\' && params.event_update_status === \'1\')\r\n        || (params.event_value === \'0\' && (params.event_update_status === \'0\' || params.event_update_status === \'1\')))\r\n        && (isNaN(parseInt(params.zendesk_issue_key)) || parseInt(params.zendesk_issue_key) < 1 )) {\r\n        throw \'Incorrect "zendesk_issue_key" parameter given: \' + params.zendesk_issue_key +\r\n            \'\\nMust be positive integer.\';\r\n    }\r\n\r\n    if ([0, 1, 2, 3, 4, 5].indexOf(parseInt(params.event_nseverity)) === -1) {\r\n        params.event_nseverity = \'7\';\r\n    }\r\n\r\n    if (params.event_value === \'0\') {\r\n        params.event_nseverity = \'6\';\r\n    }\r\n\r\n    priority = params[\'severity_\' + severities[params.event_nseverity].name] || severities[7].name;\r\n\r\n    Zendesk.setParams(zendesk);\r\n    Zendesk.HTTPProxy = params.HTTPProxy;\r\n\r\n    // Create issue for non trigger-based events.\r\n    if (params.event_source !== \'0\' && params.event_value !== \'0\') {\r\n        data = {\r\n            ticket: {\r\n                external_id: params.event_id,\r\n                type: Zendesk.params.type,\r\n                status: \'new\',\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.alert_message,\r\n                    public: \'false\'\r\n                },\r\n                priority: priority,\r\n                tags: params.event_tags\r\n            }\r\n        };\r\n\r\n        Zendesk.createIssue(data, fields);\r\n    }\r\n    // Create issue for trigger-based events.\r\n    else if (params.event_value === \'1\' && update.status === \'0\') {\r\n        data = {\r\n            ticket: {\r\n                external_id: params.event_id,\r\n                type: Zendesk.params.type,\r\n                status: \'new\',\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.zbxurl + (params.zbxurl.endsWith(\'/\') ? \'\' : \'/\') + \'tr_events.php?triggerid=\' +\r\n                        params.trigger_id + \'&eventid=\' + params.event_id + \'\\n\' + params.alert_message,\r\n                    public: \'false\'\r\n                },\r\n                priority: priority,\r\n                tags: params.event_tags\r\n            }\r\n        };\r\n        var key = Zendesk.createIssue(data, fields);\r\n\r\n        result.tags.__zbx_zdk_issuekey = key;\r\n        result.tags.__zbx_zdk_issuelink = params.zendesk_url +\r\n            (params.zendesk_url.endsWith(\'/\') ? \'\' : \'/\') + \'agent/tickets/\' + key;\r\n    }\r\n    // Update created issue for trigger-based event.\r\n    else {\r\n        data = {\r\n            ticket: {\r\n                type: Zendesk.params.type,\r\n                subject: params.alert_subject,\r\n                comment: {\r\n                    body: params.alert_message,\r\n                    public: \'false\'\r\n                }\r\n            }\r\n        };\r\n\r\n        Zendesk.updateIssue(data, fields);\r\n    }\r\n\r\n    return JSON.stringify(result);\r\n}\r\ncatch (error) {\r\n    Zabbix.log(3, \'[Zendesk Webhook] ERROR: \' + error);\r\n    throw \'Sending failed: \' + error;\r\n}','30s','1','1','{EVENT.TAGS.__zbx_zdk_issuelink}','Zendesk: {EVENT.TAGS.__zbx_zdk_issuekey}','','0');
INSERT INTO `media_type_param` (`mediatype_paramid`,`mediatypeid`,`name`,`value`,`sortorder`) VALUES ('1','38','endpoint','<PLACE HTTP API URL>','0'),
('2','38','flash','false','0'),
('3','38','password','<PLACE PASSWORD>','0'),
('4','38','ring','false','0'),
('5','38','send_to','{ALERT.SENDTO}','0'),
('6','38','telauto','true','0'),
('7','38','text','{ALERT.MESSAGE}','0'),
('8','38','username','<PLACE USERNAME>','0'),
('9','39','alert_message','{ALERT.MESSAGE}','0'),
('10','39','alert_subject','{ALERT.SUBJECT}','0'),
('11','39','discord_endpoint','{ALERT.SENDTO}','0'),
('12','39','event_id','{EVENT.ID}','0'),
('13','39','event_nseverity','{EVENT.NSEVERITY}','0'),
('14','39','event_severity','{EVENT.SEVERITY}','0'),
('15','39','event_source','{EVENT.SOURCE}','0'),
('16','39','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('17','39','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('18','39','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('19','39','event_value','{EVENT.VALUE}','0'),
('20','39','trigger_id','{TRIGGER.ID}','0'),
('21','39','user_agent','ZabbixServer (zabbix.com, 7.0)','0'),
('22','39','zabbix_url','{$ZABBIX.URL}','0'),
('23','40','acknowledged','{EVENT.ACK.STATUS}','0'),
('24','40','endpoint','/endpoint','0'),
('25','40','event_date','{EVENT.DATE}','0'),
('26','40','event_id','{EVENT.ID}','0'),
('27','40','event_name','{EVENT.NAME}','0'),
('28','40','event_nseverity','{EVENT.NSEVERITY}','0'),
('29','40','event_object','{EVENT.OBJECT}','0'),
('30','40','event_severity','{EVENT.SEVERITY}','0'),
('31','40','event_source','{EVENT.SOURCE}','0'),
('32','40','event_tags','{EVENT.TAGSJSON}','0'),
('33','40','event_time','{EVENT.TIME}','0'),
('34','40','event_value','{EVENT.VALUE}','0'),
('35','40','host_groups','{TRIGGER.HOSTGROUP.NAME}','0'),
('36','40','host_host','{HOST.HOST}','0'),
('37','40','host_id','{HOST.ID}','0'),
('38','40','host_ip','{HOST.IP}','0'),
('39','40','host_port','{HOST.PORT}','0'),
('40','40','HTTPProxy','','0'),
('41','40','monitoring_source','Zabbix sever','0'),
('42','40','operation_data','{EVENT.OPDATA}','0'),
('43','40','send_to','{ALERT.SENDTO}','0'),
('44','40','subject','{ALERT.SUBJECT}','0'),
('45','40','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('46','40','trigger_id','{TRIGGER.ID}','0'),
('47','40','trigger_name','{TRIGGER.NAME}','0'),
('48','41','event_source','{EVENT.SOURCE}','0'),
('49','41','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('50','41','event_value','{EVENT.VALUE}','0'),
('51','41','express_message','{ALERT.MESSAGE}','0'),
('52','41','express_send_to','{ALERT.SENDTO}','0'),
('53','41','express_tags','{EVENT.TAGSJSON}','0'),
('54','41','express_token','<PLACE BOT TOKEN>','0'),
('55','41','express_url','<PLACE INSTANCE URL>','0'),
('56','42','alert_message','{ALERT.MESSAGE}','0'),
('57','42','alert_subject','{ALERT.SUBJECT}','0'),
('58','42','event_id','{EVENT.ID}','0'),
('59','42','event_nseverity','{EVENT.NSEVERITY}','0'),
('60','42','event_severity','{EVENT.SEVERITY}','0'),
('61','42','event_source','{EVENT.SOURCE}','0'),
('62','42','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('63','42','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('64','42','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('65','42','event_value','{EVENT.VALUE}','0'),
('66','42','github_api_version','2022-11-28','0'),
('67','42','github_issue_number','{EVENT.TAGS.__zbx_github_issue_number}','0'),
('68','42','github_repo','{ALERT.SENDTO}','0'),
('69','42','github_token','<PLACE GITHUB TOKEN>','0'),
('70','42','github_url','https://api.github.com','0'),
('71','42','github_user_agent','Zabbix/7.0','0'),
('72','42','github_zabbix_event_priority_label_prefix','Zabbix Event Priority:','0'),
('73','42','github_zabbix_event_source_label_prefix','Zabbix Event Source:','0'),
('74','42','github_zabbix_event_status_label_prefix','Zabbix Event Status:','0'),
('75','42','github_zabbix_generic_label','Zabbix GitHub Webhook','0'),
('76','42','trigger_id','{TRIGGER.ID}','0'),
('77','42','zabbix_url','{$ZABBIX.URL}','0'),
('78','43','alert_message','{ALERT.MESSAGE}','0'),
('79','43','alert_subject','{ALERT.SUBJECT}','0'),
('80','43','event_id','{EVENT.ID}','0'),
('81','43','event_nseverity','{EVENT.NSEVERITY}','0'),
('82','43','event_severity','{EVENT.SEVERITY}','0'),
('83','43','event_source','{EVENT.SOURCE}','0'),
('84','43','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('85','43','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('86','43','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('87','43','event_value','{EVENT.VALUE}','0'),
('88','43','glpi_problem_id','{EVENT.TAGS.__zbx_glpi_problem_id}','0'),
('90','43','glpi_url','<PLACE GLPI URL>','0'),
('91','43','trigger_id','{TRIGGER.ID}','0'),
('92','43','zabbix_url','{$ZABBIX.URL}','0'),
('93','44','.ILERT.ALERT.SOURCE.KEY','{ALERT.SENDTO}','0'),
('94','44','.ILERT.INCIDENT.SUMMARY','','0'),
('95','44','ALERT.MESSAGE','{ALERT.MESSAGE}','0'),
('96','44','ALERT.SUBJECT','{ALERT.SUBJECT}','0'),
('97','44','EVENT.ACK.STATUS','{EVENT.ACK.STATUS}','0'),
('98','44','EVENT.DATE','{EVENT.DATE}','0'),
('99','44','EVENT.ID','{EVENT.ID}','0'),
('100','44','EVENT.NAME','{EVENT.NAME}','0'),
('101','44','EVENT.NSEVERITY','{EVENT.NSEVERITY}','0'),
('102','44','EVENT.OPDATA','{EVENT.OPDATA}','0'),
('103','44','EVENT.RECOVERY.DATE','{EVENT.RECOVERY.DATE}','0'),
('104','44','EVENT.RECOVERY.TIME','{EVENT.RECOVERY.TIME}','0'),
('105','44','EVENT.RECOVERY.VALUE','{EVENT.RECOVERY.VALUE}','0'),
('106','44','EVENT.SEVERITY','{EVENT.SEVERITY}','0'),
('107','44','EVENT.TAGS','{EVENT.TAGS}','0'),
('108','44','EVENT.TIME','{EVENT.TIME}','0'),
('109','44','EVENT.UPDATE.ACTION','{EVENT.UPDATE.ACTION}','0'),
('110','44','EVENT.UPDATE.DATE','{EVENT.UPDATE.DATE}','0'),
('111','44','EVENT.UPDATE.MESSAGE','{EVENT.UPDATE.MESSAGE}','0'),
('112','44','EVENT.UPDATE.STATUS','{EVENT.UPDATE.STATUS}','0'),
('113','44','EVENT.UPDATE.TIME','{EVENT.UPDATE.TIME}','0'),
('114','44','EVENT.VALUE','{EVENT.VALUE}','0'),
('115','44','HOST.HOST','{HOST.HOST}','0'),
('116','44','HOST.IP','{HOST.IP}','0'),
('117','44','HOST.NAME','{HOST.NAME}','0'),
('118','44','ITEM.ID1','{ITEM.ID1}','0'),
('119','44','ITEM.ID2','{ITEM.ID2}','0'),
('120','44','ITEM.ID3','{ITEM.ID3}','0'),
('121','44','ITEM.ID4','{ITEM.ID4}','0'),
('122','44','ITEM.ID5','{ITEM.ID5}','0'),
('123','44','ITEM.NAME1','{ITEM.NAME1}','0'),
('124','44','ITEM.NAME2','{ITEM.NAME2}','0'),
('125','44','ITEM.NAME3','{ITEM.NAME3}','0'),
('126','44','ITEM.NAME4','{ITEM.NAME4}','0'),
('127','44','ITEM.NAME5','{ITEM.NAME5}','0'),
('128','44','TRIGGER.DESCRIPTION','{TRIGGER.DESCRIPTION}','0'),
('129','44','TRIGGER.ID','{TRIGGER.ID}','0'),
('130','44','TRIGGER.NAME','{TRIGGER.NAME}','0'),
('131','44','TRIGGER.SEVERITY','{TRIGGER.SEVERITY}','0'),
('132','44','TRIGGER.STATUS','{TRIGGER.STATUS}','0'),
('133','44','TRIGGER.URL','{TRIGGER.URL}','0'),
('134','44','TRIGGER.VALUE','{TRIGGER.VALUE}','0'),
('135','44','USER.FULLNAME','{USER.FULLNAME}','0'),
('136','44','ZABBIX.URL','{$ZABBIX.URL}','0'),
('137','45','alert_message','{ALERT.MESSAGE}','0'),
('138','45','alert_subject','{ALERT.SUBJECT}','0'),
('139','45','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('140','45','event_source','{EVENT.SOURCE}','0'),
('141','45','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('142','45','event_value','{EVENT.VALUE}','0'),
('143','45','itop_api_version','1.3','0'),
('144','45','itop_class','UserRequest','0'),
('145','45','itop_comment','Created by Zabbix action {ACTION.NAME}','0'),
('146','45','itop_id','{EVENT.TAGS.__zbx_itop_id}','0'),
('147','45','itop_log','private_log','0'),
('148','45','itop_organization_id','<PLACE ORGANIZATION ID>','0'),
('149','45','itop_password','<PLACE PASSWORD OR TOKEN>','0'),
('150','45','itop_url','<PLACE YOUR ITOP URL>','0'),
('151','45','itop_user','<PLACE LOGIN>','0'),
('152','46','alert_message','{ALERT.MESSAGE}','0'),
('153','46','alert_subject','{ALERT.SUBJECT}','0'),
('154','46','event_id','{EVENT.ID}','0'),
('155','46','event_nseverity','{EVENT.NSEVERITY}','0'),
('156','46','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('157','46','event_severity','{EVENT.SEVERITY}','0'),
('158','46','event_source','{EVENT.SOURCE}','0'),
('159','46','event_tags_json','{EVENT.TAGSJSON}','0'),
('160','46','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('161','46','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('162','46','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('163','46','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('164','46','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('165','46','event_update_user','{USER.FULLNAME}','0'),
('166','46','event_value','{EVENT.VALUE}','0'),
('167','46','jira_issue_type','<PLACE ISSUETYPE NAME>','0'),
('168','46','jira_password','<PLACE PASSWORD OR TOKEN>','0'),
('169','46','jira_priority_autoregistration','Low','0'),
('170','46','jira_priority_discovery','Low','0'),
('171','46','jira_priority_internal','Low','0'),
('172','46','jira_project_key','<PLACE PROJECT KEY>','0'),
('173','46','jira_url','<PLACE YOUR JIRA URL>','0'),
('174','46','jira_user','<PLACE LOGIN>','0'),
('175','46','severity_average','Medium','0'),
('176','46','severity_disaster','Highest','0'),
('177','46','severity_high','High','0'),
('178','46','severity_information','Lowest','0'),
('179','46','severity_not_classified','Lowest','0'),
('180','46','severity_warning','Low','0'),
('181','46','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('182','46','trigger_id','{TRIGGER.ID}','0'),
('183','46','zabbix_url','{$ZABBIX.URL}','0'),
('184','47','alert_message','{ALERT.MESSAGE}','0'),
('185','47','alert_subject','{ALERT.SUBJECT}','0'),
('186','47','event_id','{EVENT.ID}','0'),
('187','47','event_nseverity','{EVENT.NSEVERITY}','0'),
('188','47','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('189','47','event_severity','{EVENT.SEVERITY}','0'),
('190','47','event_source','{EVENT.SOURCE}','0'),
('191','47','event_tags_json','{EVENT.TAGSJSON}','0'),
('192','47','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('193','47','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('194','47','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('195','47','event_value','{EVENT.VALUE}','0'),
('196','47','issue_comments_public','false','0'),
('197','47','jira_password','<PLACE PASSWORD OR TOKEN>','0'),
('198','47','jira_priority_autoregistration','Low','0'),
('199','47','jira_priority_discovery','Low','0'),
('200','47','jira_priority_internal','Low','0'),
('201','47','jira_request_type_id','<PLACE REQUEST TYPE ID>','0'),
('202','47','jira_servicedesk_id','<PLACE SERVICEDESK ID>','0'),
('203','47','jira_url','<PLACE YOUR JIRA URL>','0'),
('204','47','jira_user','<PLACE LOGIN>','0'),
('205','47','severity_average','Medium','0'),
('206','47','severity_disaster','Highest','0'),
('207','47','severity_high','High','0'),
('208','47','severity_information','Lowest','0'),
('209','47','severity_not_classified','Lowest','0'),
('210','47','severity_warning','Low','0'),
('211','47','trigger_id','{TRIGGER.ID}','0'),
('212','47','zabbix_url','{$ZABBIX.URL}','0'),
('213','48','alert_message','{ALERT.MESSAGE}','0'),
('214','48','alert_subject','{ALERT.SUBJECT}','0'),
('215','48','bot_token','<PLACE BOT TOKEN>','0'),
('216','48','event_id','{EVENT.ID}','0'),
('217','48','event_nseverity','{EVENT.NSEVERITY}','0'),
('218','48','event_source','{EVENT.SOURCE}','0'),
('219','48','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('220','48','event_value','{EVENT.VALUE}','0'),
('221','48','send_to','{ALERT.SENDTO}','0'),
('222','48','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('223','48','trigger_id','{TRIGGER.ID}','0'),
('224','48','zabbix_url','{$ZABBIX.URL}','0'),
('225','49','event_nseverity','{EVENT.NSEVERITY}','0'),
('226','49','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('227','49','event_source','{EVENT.SOURCE}','0'),
('228','49','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('229','49','event_value','{EVENT.VALUE}','0'),
('230','49','field_ref:requester','<PLACE API USER NAME>','0'),
('231','49','field_string:description','{ALERT.MESSAGE}','0'),
('232','49','field_string:subject','{ALERT.SUBJECT}','0'),
('233','49','priority_average','Normal','0'),
('234','49','priority_default','Normal','0'),
('235','49','priority_disaster','High','0'),
('236','49','priority_high','High','0'),
('237','49','priority_information','Low','0'),
('238','49','priority_not_classified','Low','0'),
('239','49','priority_warning','Medium','0'),
('240','49','sd_on_demand_client_id','<PLACE ON DEMAND CLIENT ID>','0'),
('241','49','sd_on_demand_client_secret','<PLACE ON DEMAND CLIENT SECRET>','0'),
('242','49','sd_on_demand_refresh_token','<PLACE ON DEMAND REFRESH TOKEN>','0'),
('243','49','sd_on_demand_url_auth','<PLACE AUTHENTICATION URL FOR ON DEMAND>','0'),
('244','49','sd_on_premise','true','0'),
('245','49','sd_on_premise_auth_token','<PLACE ON PREMISE TECHNICIAN_KEY>','0'),
('246','49','sd_request_id','{EVENT.TAGS.__zbx_sd_request_id}','0'),
('247','49','sd_url','<PLACE INSTANCE URL>','0'),
('248','49','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('249','50','alert_message','{ALERT.MESSAGE}','0'),
('250','50','alert_sendto','{ALERT.SENDTO}','0'),
('251','50','alert_subject','{ALERT.SUBJECT}','0'),
('252','50','event_id','{EVENT.ID}','0'),
('253','50','event_nseverity','{EVENT.NSEVERITY}','0'),
('254','50','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('255','50','event_source','{EVENT.SOURCE}','0'),
('256','50','event_tagsjson','{EVENT.TAGSJSON}','0'),
('257','50','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('258','50','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('259','50','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('260','50','event_value','{EVENT.VALUE}','0'),
('261','50','mantisbt_category','[All Projects] General','0'),
('262','50','mantisbt_issue_number','{EVENT.TAGS.__zbx_mantisbt_issue_number}','0'),
('263','50','mantisbt_token','<PLACE MANTISBT TOKEN>','0'),
('264','50','mantisbt_url','<PLACE MANTISBT URL>','0'),
('265','50','mantisbt_use_zabbix_tags','true','0'),
('266','50','trigger_id','{TRIGGER.ID}','0'),
('267','50','zabbix_url','{$ZABBIX.URL}','0'),
('268','51','alert_message','{ALERT.MESSAGE}','0'),
('269','51','alert_subject','{ALERT.SUBJECT}','0'),
('270','51','bot_token','<YOUR BOT TOKEN>','0'),
('271','51','discovery_host_dns','{DISCOVERY.DEVICE.DNS}','0'),
('272','51','discovery_host_ip','{DISCOVERY.DEVICE.IPADDRESS}','0'),
('273','51','event_date','{EVENT.DATE}','0'),
('274','51','event_id','{EVENT.ID}','0'),
('275','51','event_nseverity','{EVENT.NSEVERITY}','0'),
('276','51','event_opdata','{EVENT.OPDATA}','0'),
('277','51','event_recovery_date','{EVENT.RECOVERY.DATE}','0'),
('278','51','event_recovery_time','{EVENT.RECOVERY.TIME}','0'),
('279','51','event_severity','{EVENT.SEVERITY}','0'),
('280','51','event_source','{EVENT.SOURCE}','0'),
('281','51','event_tags','{EVENT.TAGS}','0'),
('282','51','event_time','{EVENT.TIME}','0'),
('283','51','event_update_date','{EVENT.UPDATE.DATE}','0'),
('284','51','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('285','51','event_update_time','{EVENT.UPDATE.TIME}','0'),
('286','51','event_value','{EVENT.VALUE}','0'),
('287','51','host_ip','{HOST.IP}','0'),
('288','51','host_name','{HOST.HOST}','0'),
('289','51','mattermost_url','<YOUR MATTERMOST URL>','0'),
('290','51','send_mode','alarm','0'),
('291','51','send_to','{ALERT.SENDTO}','0'),
('292','51','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('293','51','trigger_id','{TRIGGER.ID}','0'),
('294','51','zabbix_url','{$ZABBIX.URL}','0'),
('295','52','alert_message','{ALERT.MESSAGE}','0'),
('296','52','alert_subject','{ALERT.SUBJECT}','0'),
('297','52','event_date','{EVENT.DATE}','0'),
('298','52','event_id','{EVENT.ID}','0'),
('299','52','event_nseverity','{EVENT.NSEVERITY}','0'),
('300','52','event_opdata','{EVENT.OPDATA}','0'),
('301','52','event_recovery_date','{EVENT.RECOVERY.DATE}','0'),
('302','52','event_recovery_time','{EVENT.RECOVERY.TIME}','0'),
('303','52','event_severity','{EVENT.SEVERITY}','0'),
('304','52','event_source','{EVENT.SOURCE}','0'),
('305','52','event_status','{EVENT.STATUS}','0'),
('306','52','event_tags','{EVENT.TAGS}','0'),
('307','52','event_time','{EVENT.TIME}','0'),
('308','52','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('309','52','event_update_date','{EVENT.UPDATE.DATE}','0'),
('310','52','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('311','52','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('312','52','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('313','52','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('314','52','event_update_time','{EVENT.UPDATE.TIME}','0'),
('315','52','event_update_user','{USER.FULLNAME}','0'),
('316','52','event_value','{EVENT.VALUE}','0'),
('317','52','host_ip','{HOST.IP}','0'),
('318','52','host_name','{HOST.NAME}','0'),
('319','52','teams_endpoint','<PLACE WEBHOOK URL HERE>','0'),
('320','52','trigger_description','{TRIGGER.DESCRIPTION}','0'),
('321','52','trigger_id','{TRIGGER.ID}','0'),
('322','52','use_default_message','false','0'),
('323','52','zabbix_url','{$ZABBIX.URL}','0'),
('324','53','alert_message','{ALERT.MESSAGE}','0'),
('325','53','alert_subject','{ALERT.SUBJECT}','0'),
('326','53','event_id','{EVENT.ID}','0'),
('327','53','event_nseverity','{EVENT.NSEVERITY}','0'),
('328','53','event_severity','{EVENT.SEVERITY}','0'),
('329','53','event_source','{EVENT.SOURCE}','0'),
('330','53','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('331','53','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('332','53','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('333','53','event_value','{EVENT.VALUE}','0'),
('334','53','teams_endpoint','<PLACE WEBHOOK URL HERE>','0'),
('335','53','trigger_id','{TRIGGER.ID}','0'),
('336','53','zabbix_url','{$ZABBIX.URL}','0'),
('337','54','alert_message','{ALERT.MESSAGE}','0'),
('338','54','alert_subject','{ALERT.SUBJECT}','0'),
('339','54','event_id','{EVENT.ID}','0'),
('340','54','event_nseverity','{EVENT.NSEVERITY}','0'),
('341','54','event_source','{EVENT.SOURCE}','0'),
('342','54','event_tags_json','{EVENT.TAGSJSON}','0'),
('343','54','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('344','54','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('345','54','event_value','{EVENT.VALUE}','0'),
('346','54','opsgenie_api','<put your opsgenie api>','0'),
('347','54','opsgenie_tags','','0'),
('348','54','opsgenie_teams','','0'),
('349','54','opsgenie_token','<put your token>','0'),
('350','54','opsgenie_web','<put your opsgenie web>','0'),
('351','54','severity_average','P3','0'),
('352','54','severity_default','P5','0'),
('353','54','severity_disaster','P1','0'),
('354','54','severity_high','P2','0'),
('355','54','severity_information','P5','0'),
('356','54','severity_not_classified','P5','0'),
('357','54','severity_warning','P4','0'),
('358','54','status_counter','25','0'),
('359','54','trigger_id','{TRIGGER.ID}','0'),
('360','54','zbxurl','{$ZABBIX.URL}','0'),
('361','54','zbxuser','{USER.FULLNAME}','0'),
('362','55','alert_message','{ALERT.MESSAGE}','0'),
('363','55','alert_subject','{ALERT.SUBJECT}','0'),
('364','55','event_id','{EVENT.ID}','0'),
('365','55','event_nseverity','{EVENT.NSEVERITY}','0'),
('366','55','event_severity','{EVENT.SEVERITY}','0'),
('367','55','event_source','{EVENT.SOURCE}','0'),
('368','55','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('369','55','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('370','55','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('371','55','event_value','{EVENT.VALUE}','0'),
('372','55','otrs_auth_password','<PUT YOUR USER PASSWORD>','0'),
('373','55','otrs_auth_user','<PUT YOUR USER NAME>','0'),
('374','55','otrs_closed_state_id','0','0'),
('375','55','otrs_customer','<PUT YOUR CUSTOMER EMAIL>','0'),
('376','55','otrs_default_priority_id','3','0'),
('377','55','otrs_queue','<PUT YOUR QUEUE NAME>','0'),
('378','55','otrs_ticket_id','{EVENT.TAGS.__zbx_otrs_ticket_id}','0'),
('379','55','otrs_ticket_state','new','0'),
('380','55','otrs_time_unit','0','0'),
('381','55','otrs_url','<PUT YOUR ((OTRS)) CE URL>','0'),
('382','55','trigger_id','{TRIGGER.ID}','0'),
('383','55','zabbix_url','{$ZABBIX.URL}','0'),
('384','56','alert_message','{ALERT.MESSAGE}','0'),
('385','56','alert_subject','{ALERT.SUBJECT}','0'),
('386','56','api_token','{ALERT.SENDTO}','0'),
('387','56','event_ack','{EVENT.ACK.STATUS}','0'),
('388','56','event_id','{EVENT.ID}','0'),
('389','56','event_nseverity','{EVENT.NSEVERITY}','0'),
('390','56','event_severity','{EVENT.SEVERITY}','0'),
('391','56','event_source','{EVENT.SOURCE}','0'),
('392','56','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('393','56','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('394','56','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('395','56','event_value','{EVENT.VALUE}','0'),
('396','56','host_ip','{HOST.IP}','0'),
('397','56','host_name','{HOST.NAME}','0'),
('398','56','trigger_id','{TRIGGER.ID}','0'),
('399','56','zabbix_url','{$ZABBIX.URL}','0'),
('400','57','endpoint','https://api.pushover.net/1/messages.json','0'),
('401','57','eventid','{EVENT.ID}','0'),
('402','57','event_nseverity','{EVENT.NSEVERITY}','0'),
('403','57','event_source','{EVENT.SOURCE}','0'),
('404','57','event_value','{EVENT.VALUE}','0'),
('405','57','expire','1200','0'),
('406','57','message','{ALERT.MESSAGE}','0'),
('407','57','priority_average','0','0'),
('408','57','priority_default','0','0'),
('409','57','priority_disaster','0','0'),
('410','57','priority_high','0','0'),
('411','57','priority_information','0','0'),
('412','57','priority_not_classified','0','0'),
('413','57','priority_warning','0','0'),
('414','57','retry','60','0'),
('415','57','title','{ALERT.SUBJECT}','0'),
('416','57','token','<PUSHOVER TOKEN HERE>','0'),
('417','57','triggerid','{TRIGGER.ID}','0'),
('418','57','url','{$ZABBIX.URL}','0'),
('419','57','url_title','Zabbix','0'),
('420','57','user','{ALERT.SENDTO}','0'),
('421','58','alert_message','{ALERT.MESSAGE}','0'),
('422','58','alert_subject','{ALERT.SUBJECT}','0'),
('423','58','event_id','{EVENT.ID}','0'),
('424','58','event_nseverity','{EVENT.NSEVERITY}','0'),
('425','58','event_source','{EVENT.SOURCE}','0'),
('426','58','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('427','58','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('428','58','event_value','{EVENT.VALUE}','0'),
('429','58','redmine_access_key','<PUT YOUR ACCESS KEY>','0'),
('430','58','redmine_issue_key','{EVENT.TAGS.__zbx_redmine_issue_id}','0'),
('431','58','redmine_project','<PUT YOUR PROJECT ID OR NAME>','0'),
('432','58','redmine_tracker_id','<PUT YOUR TRACKER ID>','0'),
('433','58','redmine_url','<PUT YOUR REDMINE URL>','0'),
('434','58','trigger_id','{TRIGGER.ID}','0'),
('435','58','zabbix_url','{$ZABBIX.URL}','0'),
('436','59','alert_message','{ALERT.MESSAGE}','0'),
('437','59','alert_subject','{ALERT.SUBJECT}','0'),
('438','59','event_nseverity','{EVENT.NSEVERITY}','0'),
('439','59','event_source','{EVENT.SOURCE}','0'),
('440','59','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('441','59','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('442','59','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('443','59','event_update_user','{USER.FULLNAME}','0'),
('444','59','event_value','{EVENT.VALUE}','0'),
('445','59','field_1_full:Host','{HOST.NAME} [{HOST.IP}]','0'),
('446','59','field_2_short:Severity','{EVENT.SEVERITY}','0'),
('447','59','field_3_short:Event time','{EVENT.DATE} {EVENT.TIME}','0'),
('448','59','field_3_short_r:Recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}','0'),
('449','59','field_4_short_r:Event duration','{EVENT.DURATION}','0'),
('450','59','field_5_short:Operational data','{EVENT.OPDATA}','0'),
('451','59','field_999_full_p:Trigger description','{TRIGGER.DESCRIPTION}','0'),
('452','59','rc_api_url','api/v1/','0'),
('453','59','rc_msg_id','{EVENT.TAGS.__zbx_rc_id}','0'),
('454','59','rc_room_id','{EVENT.TAGS.__zbx_rc_rid}','0'),
('455','59','rc_send_to','{ALERT.SENDTO}','0'),
('456','59','rc_title_link','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}','0'),
('457','59','rc_url','<PLACE YOUR INSTANCE URL HERE>','0'),
('458','59','rc_user_id','<PLACE USER ID HERE>','0'),
('459','59','rc_user_token','<PLACE TOKEN HERE>','0'),
('460','59','use_default_message','false','0'),
('461','60','alert_message','{ALERT.MESSAGE}','0'),
('462','60','alert_subject','{ALERT.SUBJECT}','0'),
('463','60','event_nseverity','{EVENT.NSEVERITY}','0'),
('464','60','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('465','60','event_source','{EVENT.SOURCE}','0'),
('466','60','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('467','60','event_value','{EVENT.VALUE}','0'),
('468','60','servicenow_password','<PLACE PASSWORD HERE>','0'),
('469','60','servicenow_sys_id','{EVENT.TAGS.__zbx_servicenow_sys_id}','0'),
('470','60','servicenow_url','{ALERT.SENDTO}','0'),
('471','60','servicenow_user','<PLACE USERNAME HERE>','0'),
('472','60','urgency_for_average','2','0'),
('473','60','urgency_for_disaster','1','0'),
('474','60','urgency_for_high','2','0'),
('475','60','urgency_for_information','3','0'),
('476','60','urgency_for_not_classified','3','0'),
('477','60','urgency_for_warning','3','0'),
('478','61','Event_Ack_Status','{EVENT.ACK.STATUS}','0'),
('479','61','Event_Date_Time','{EVENT.DATE} {EVENT.TIME}','0'),
('480','61','Event_ID','{EVENT.ID}','0'),
('481','61','Event_Update_Action','{EVENT.UPDATE.ACTION}','0'),
('482','61','Event_Update_Status','{EVENT.UPDATE.STATUS}','0'),
('483','61','Hostname','{HOST.NAME}','0'),
('484','61','Host_IP','{HOST.IP}','0'),
('485','61','Message','{ALERT.MESSAGE}','0'),
('486','61','Severity','{EVENT.SEVERITY}','0'),
('487','61','Subject','{ALERT.SUBJECT}','0'),
('488','61','teamsecret','{ALERT.SENDTO}','0'),
('489','61','Trigger_ID','{TRIGGER.ID}','0'),
('490','61','Trigger_Status','{TRIGGER.STATUS}','0'),
('491','61','User','{USER.FULLNAME}','0'),
('492','61','Zabbix_URL','{$ZABBIX.URL}','0'),
('493','62','alert_message','{ALERT.MESSAGE}','0'),
('494','62','alert_subject','{ALERT.SUBJECT}','0'),
('495','62','bot_token','<PLACE YOUR TOKEN>','0'),
('496','62','channel','{ALERT.SENDTO}','0'),
('497','62','event_id','{EVENT.ID}','0'),
('498','62','event_nseverity','{EVENT.NSEVERITY}','0'),
('499','62','event_severity','{EVENT.SEVERITY}','0'),
('500','62','event_source','{EVENT.SOURCE}','0'),
('501','62','event_tags','{EVENT.TAGSJSON}','0'),
('502','62','event_update_action','{EVENT.UPDATE.ACTION}','0'),
('503','62','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('504','62','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('505','62','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('506','62','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('507','62','event_value','{EVENT.VALUE}','0'),
('508','62','slack_mode','alarm','0'),
('509','62','trigger_id','{TRIGGER.ID}','0'),
('510','62','zabbix_url','{$ZABBIX.URL}','0'),
('511','63','alert_message','{ALERT.MESSAGE}','0'),
('512','63','alert_subject','{ALERT.SUBJECT}','0'),
('513','63','event_nseverity','{EVENT.NSEVERITY}','0'),
('514','63','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('515','63','event_source','{EVENT.SOURCE}','0'),
('516','63','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('517','63','event_value','{EVENT.VALUE}','0'),
('518','63','priority_average','Medium','0'),
('519','63','priority_default','Low','0'),
('520','63','priority_disaster','Critical','0'),
('521','63','priority_high','High','0'),
('522','63','samanage_incident_id','{EVENT.TAGS.__zbx_solarwinds_inc_id}','0'),
('523','63','samanage_token','<PUT YOUR TOKEN HERE>','0'),
('524','63','samanage_url','<PUT YOUR INSTANCE URL HERE>','0'),
('525','64','alert_message','{ALERT.MESSAGE}','0'),
('526','64','alert_subject','{ALERT.SUBJECT}','0'),
('527','64','event_id','{EVENT.ID}','0'),
('528','64','event_nseverity','{EVENT.NSEVERITY}','0'),
('529','64','event_source','{EVENT.SOURCE}','0'),
('530','64','event_update_message','{EVENT.UPDATE.MESSAGE}','0'),
('531','64','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('532','64','event_value','{EVENT.VALUE}','0'),
('533','64','sysaid_auth_password','<PUT YOUR USER PASSWORD>','0'),
('534','64','sysaid_auth_user','<PUT YOUR USER NAME>','0'),
('535','64','sysaid_category_level_1','<PUT YOUR CATEGORY>','0'),
('536','64','sysaid_category_level_2','<PUT YOUR SUB-CATEGORY>','0'),
('537','64','sysaid_category_level_3','<PUT YOUR THIRD LEVEL CATEGORY>','0'),
('538','64','sysaid_default_priority_id','1','0'),
('539','64','sysaid_incident_id','{EVENT.TAGS.__zbx_sysaid_incident_id}','0'),
('540','64','sysaid_incident_state','1','0'),
('541','64','sysaid_template_id','<PUT YOUR TEMPLATE ID>','0'),
('542','64','sysaid_urgency_id','<PUT YOUR URGENCY ID>','0'),
('543','64','sysaid_url','<PUT YOUR SYSAID URL>','0'),
('544','64','trigger_id','{TRIGGER.ID}','0'),
('545','64','zabbix_url','{$ZABBIX.URL}','0'),
('546','65','alert_message','{ALERT.MESSAGE}','0'),
('547','65','alert_subject','{ALERT.SUBJECT}','0'),
('548','65','api_chat_id','{ALERT.SENDTO}','0'),
('549','65','api_parse_mode','<PLACE PARSE MODE>','0'),
('550','65','api_token','<PLACE YOUR TOKEN>','0'),
('551','65','event_nseverity','{EVENT.NSEVERITY}','0'),
('552','65','event_severity','{EVENT.SEVERITY}','0'),
('553','65','event_source','{EVENT.SOURCE}','0'),
('554','65','event_tags','{EVENT.TAGSJSON}','0'),
('555','65','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('556','65','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('557','65','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('558','65','event_value','{EVENT.VALUE}','0'),
('559','66','alert_message','{ALERT.MESSAGE}','0'),
('560','66','alert_subject','{ALERT.SUBJECT}','0'),
('561','66','event_id','{EVENT.ID}','0'),
('562','66','event_nseverity','{EVENT.NSEVERITY}','0'),
('563','66','event_source','{EVENT.SOURCE}','0'),
('564','66','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('565','66','event_value','{EVENT.VALUE}','0'),
('566','66','severity_average','P3','0'),
('567','66','severity_default','P5','0'),
('568','66','severity_disaster','P1','0'),
('569','66','severity_high','P2','0'),
('570','66','severity_information','P5','0'),
('571','66','severity_not_classified','P5','0'),
('572','66','severity_warning','P4','0'),
('573','66','topdesk_api','<put your TOPdesk API URL>','0'),
('574','66','topdesk_issue_key','{EVENT.TAGS.__zbx_tpd_issuekey}','0'),
('575','66','topdesk_password','<put your TOPdesk application password>','0'),
('576','66','topdesk_status','<put default status for new tickets>','0'),
('577','66','topdesk_user','<put your TOPdesk username>','0'),
('578','66','trigger_id','{TRIGGER.ID}','0'),
('579','66','zbxurl','{$ZABBIX.URL}','0'),
('580','67','event_info','{$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}','0'),
('581','67','event_nseverity','{EVENT.NSEVERITY}','0'),
('582','67','event_recovery_value','{EVENT.RECOVERY.VALUE}','0'),
('583','67','event_source','{EVENT.SOURCE}','0'),
('584','67','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('585','67','event_value','{EVENT.VALUE}','0'),
('586','67','field:entity_display_name','{ALERT.SUBJECT}','0'),
('587','67','field:entity_id','{EVENT.ID}','0'),
('588','67','field:hostname','{HOST.NAME}','0'),
('589','67','field:monitoring_tool','Zabbix','0'),
('590','67','field:operational_data','{EVENT.OPDATA}','0'),
('591','67','field:severity','{EVENT.SEVERITY}','0'),
('592','67','field:state_message','{ALERT.MESSAGE}','0'),
('593','67','field_p:trigger_description','{TRIGGER.DESCRIPTION}','0'),
('594','67','field_r:event_duration','{EVENT.DURATION}','0'),
('595','67','field_r:recovery time','{EVENT.RECOVERY.DATE} {EVENT.RECOVERY.TIME}','0'),
('596','67','priority_average','WARNING','0'),
('597','67','priority_default','INFO','0'),
('598','67','priority_disaster','CRITICAL','0'),
('599','67','priority_high','WARNING','0'),
('600','67','priority_information','INFO','0'),
('601','67','priority_not_classified','INFO','0'),
('602','67','priority_resolved','OK','0'),
('603','67','priority_update','INFO','0'),
('604','67','priority_warning','INFO','0'),
('605','67','vops_endpoint','<PLACE ENDPOINT URL HERE>','0'),
('606','67','vops_routing_key','{ALERT.SENDTO}','0'),
('607','68','alert_message','{ALERT.MESSAGE}','0'),
('608','68','alert_subject','{ALERT.SUBJECT}','0'),
('609','68','event_id','{EVENT.ID}','0'),
('610','68','event_nseverity','{EVENT.NSEVERITY}','0'),
('611','68','event_severity','{EVENT.SEVERITY}','0'),
('612','68','event_source','{EVENT.SOURCE}','0'),
('613','68','event_tags','{EVENT.TAGSJSON}','0'),
('614','68','event_update_nseverity','{EVENT.UPDATE.NSEVERITY}','0'),
('615','68','event_update_severity','{EVENT.UPDATE.SEVERITY}','0'),
('616','68','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('617','68','event_value','{EVENT.VALUE}','0'),
('618','68','trigger_id','{TRIGGER.ID}','0'),
('619','68','zabbix_url','{$ZABBIX.URL}','0'),
('620','68','zammad_access_token','<PUT YOUR ACCESS TOKEN>','0'),
('621','68','zammad_customer','<PUT YOUR CUSTOMER EMAIL>','0'),
('622','68','zammad_enable_tags','false','0'),
('623','68','zammad_group','Users','0'),
('624','68','zammad_url','<PUT YOUR ZAMMAD URL>','0'),
('625','69','alert_message','{ALERT.MESSAGE}','0'),
('626','69','alert_subject','{ALERT.SUBJECT}','0'),
('627','69','event_id','{EVENT.ID}','0'),
('628','69','event_nseverity','{EVENT.NSEVERITY}','0'),
('629','69','event_source','{EVENT.SOURCE}','0'),
('630','69','event_tags','{EVENT.TAGS}','0'),
('631','69','event_update_status','{EVENT.UPDATE.STATUS}','0'),
('632','69','event_value','{EVENT.VALUE}','0'),
('633','69','severity_average','normal','0'),
('634','69','severity_default','-','0'),
('635','69','severity_disaster','urgent','0'),
('636','69','severity_high','high','0'),
('637','69','severity_information','low','0'),
('638','69','severity_not_classified','low','0'),
('639','69','severity_warning','normal','0'),
('640','69','trigger_id','{TRIGGER.ID}','0'),
('641','69','zbxurl','{$ZABBIX.URL}','0'),
('642','69','zendesk_issue_key','{EVENT.TAGS.__zbx_zdk_issuekey}','0'),
('643','69','zendesk_token','<put your {enduser_email_address}/token:{api_token}>','0'),
('644','69','zendesk_type','incident','0'),
('645','69','zendesk_url','<put your Zendesk URL>','0'),
('646','55','otrs_ticket_type','Unclassified','0'),
('647','43','glpi_app_token','','0'),
('648','43','glpi_user_token','<PLACE GLPI USER TOKEN>','0');
INSERT INTO `media_type_message` (`mediatype_messageid`,`mediatypeid`,`eventsource`,`recovery`,`subject`,`message`) VALUES ('1','1','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('2','1','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('3','1','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('4','1','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('5','1','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('6','3','0','0','','{EVENT.SEVERITY}: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\n{EVENT.DATE} {EVENT.TIME}'),
('7','3','0','1','','Resolved in {EVENT.DURATION}: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\n{EVENT.DATE} {EVENT.TIME}'),
('8','3','0','2','','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem in {EVENT.AGE} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}'),
('9','3','1','0','','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}'),
('10','3','2','0','','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('11','4','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('12','4','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('13','4','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.'),
('14','4','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}'),
('15','4','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}'),
('160','34','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('161','34','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('162','34','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.'),
('163','34','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}'),
('164','34','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}'),
('165','35','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('166','35','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('167','35','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.'),
('168','35','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}'),
('169','35','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}'),
('170','36','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('171','36','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('172','36','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.'),
('173','36','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}'),
('174','36','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}'),
('175','37','0','0','Problem: {EVENT.NAME}','<b>Problem started</b> at {{EVENT.TIME}.htmlencode()} on {{EVENT.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Operational data:</b> {{EVENT.OPDATA}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('176','37','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<b>Problem has been resolved</b> at {{EVENT.RECOVERY.TIME}.htmlencode()} on {{EVENT.RECOVERY.DATE}.htmlencode()}<br><b>Problem name:</b> {{EVENT.NAME}.htmlencode()}<br><b>Problem duration:</b> {{EVENT.DURATION}.htmlencode()}<br><b>Host:</b> {{HOST.NAME}.htmlencode()}<br><b>Severity:</b> {{EVENT.SEVERITY}.htmlencode()}<br><b>Original problem ID:</b> {{EVENT.ID}.htmlencode()}<br>{{TRIGGER.URL}.htmlencode()}'),
('177','37','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','<b>{{USER.FULLNAME}.htmlencode()} {{EVENT.UPDATE.ACTION}.htmlencode()} problem</b> at {{EVENT.UPDATE.DATE}.htmlencode()} {{EVENT.UPDATE.TIME}.htmlencode()}.<br>{{EVENT.UPDATE.MESSAGE}.htmlencode()}<br><br><b>Current problem status:</b> {{EVENT.STATUS}.htmlencode()}<br><b>Age:</b> {{EVENT.AGE}.htmlencode()}<br><b>Acknowledged:</b> {{EVENT.ACK.STATUS}.htmlencode()}.'),
('178','37','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<b>Discovery rule:</b> {{DISCOVERY.RULE.NAME}.htmlencode()}<br><br><b>Device IP:</b> {{DISCOVERY.DEVICE.IPADDRESS}.htmlencode()}<br><b>Device DNS:</b> {{DISCOVERY.DEVICE.DNS}.htmlencode()}<br><b>Device status:</b> {{DISCOVERY.DEVICE.STATUS}.htmlencode()}<br><b>Device uptime:</b> {{DISCOVERY.DEVICE.UPTIME}.htmlencode()}<br><br><b>Device service name:</b> {{DISCOVERY.SERVICE.NAME}.htmlencode()}<br><b>Device service port:</b> {{DISCOVERY.SERVICE.PORT}.htmlencode()}<br><b>Device service status:</b> {{DISCOVERY.SERVICE.STATUS}.htmlencode()}<br><b>Device service uptime:</b> {{DISCOVERY.SERVICE.UPTIME}.htmlencode()}'),
('179','37','2','0','Autoregistration: {HOST.HOST}','<b>Host name:</b> {{HOST.HOST}.htmlencode()}<br><b>Host IP:</b> {{HOST.IP}.htmlencode()}<br><b>Agent port:</b> {{HOST.PORT}.htmlencode()}'),
('180','38','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nStarted at {EVENT.TIME} on {EVENT.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}'),
('181','38','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nResolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}'),
('182','38','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\n\r\n{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}'),
('183','38','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}\r\nDiscovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('184','38','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('185','39','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('186','39','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('187','39','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('188','39','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('189','39','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('190','39','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('191','39','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('192','39','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('193','39','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('194','39','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('195','40','0','0','Event ID: {EVENT.ID}, Host: {HOST.HOST}, Problem: {EVENT.NAME}',''),
('196','41','0','0','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nStarted at {EVENT.TIME} on {EVENT.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}'),
('197','41','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\nResolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nEvent info: {$ZABBIX.URL}/tr_events.php?triggerid={TRIGGER.ID}&eventid={EVENT.ID}'),
('198','41','0','2','[{EVENT.STATUS}] {EVENT.NAME}','[{EVENT.STATUS}] {EVENT.NAME}\r\n\r\n{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}'),
('199','41','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}\r\nDiscovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('200','41','2','0','Autoregistration: {HOST.HOST}','Autoregistration: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('201','42','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('202','42','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('203','42','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('204','42','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('205','42','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('206','42','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('207','42','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('208','42','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('209','42','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('210','42','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('211','43','0','0','Problem: {EVENT.NAME}','<dl><dd><b>Problem started at</b> {EVENT.TIME} <b>on</b> {EVENT.DATE}</b></dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Operational data:</b> {EVENT.OPDATA}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>{TRIGGER.URL}'),
('212','43','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','<dl><dd><b>Problem has been resolved in</b> {EVENT.DURATION} <b>at</b> {EVENT.RECOVERY.TIME} <b>on</b> {EVENT.RECOVERY.DATE}</dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Operational data:</b> {EVENT.OPDATA}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>{TRIGGER.URL}'),
('213','43','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.TIME} on {EVENT.UPDATE.DATE}. <br><br>{EVENT.UPDATE.MESSAGE}<br><br>Current problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.<br><br>'),
('214','43','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','<dl><dd><b>Discovery rule:</b> {DISCOVERY.RULE.NAME}</dd><br><dd><b>Device IP:</b> {DISCOVERY.DEVICE.IPADDRESS}</dd><dd><b>Device DNS:</b> {DISCOVERY.DEVICE.DNS}</dd><br><dd><b>Device status:</b> {DISCOVERY.DEVICE.STATUS}</dd><br><dd><b>Device uptime:</b> {DISCOVERY.DEVICE.UPTIME}</dd><br><dd><b>Device service name:</b> {DISCOVERY.SERVICE.NAME}</dd><dd><b>Device service port:</b> {DISCOVERY.SERVICE.PORT}</dd><dd><b>Device service status:</b> {DISCOVERY.SERVICE.STATUS}</dd><dd><b>Device service uptime:</b> {DISCOVERY.SERVICE.UPTIME}</dd></dl>'),
('215','43','2','0','Autoregistration: {HOST.HOST}','<dl><dd><b>Host name:</b> {HOST.HOST}</dd><dd><b>Host IP:</b> {HOST.IP}</dd><dd><b>Agent port:</b> {HOST.PORT}</dd></dl>'),
('216','43','3','0','[{EVENT.STATUS}] {EVENT.NAME}','<dl><dd><b>Problem started at</b> {EVENT.TIME} <b>on</b> {EVENT.DATE}</b></dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>'),
('217','43','3','1','[{EVENT.STATUS}] {EVENT.NAME}','<dl><dd><b>Problem has been resolved in</b> {EVENT.DURATION} <b>at</b> {EVENT.RECOVERY.TIME} <b>on</b> {EVENT.RECOVERY.DATE}</dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Host:</b> {HOST.NAME}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd></dl>'),
('218','43','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','<dl><dd><b>Service problem started at</b> {EVENT.TIME} <b>on</b> {EVENT.DATE}</dd><dd><b>Service problem name:</b> {EVENT.NAME}</dd><dd><b>Service:</b> {SERVICE.NAME}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd><dd><b>Service description:</b> {SERVICE.DESCRIPTION}</dd><dd><b><br>{SERVICE.ROOTCAUSE}</dd></dl>'),
('219','43','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','<dl><dd><b>Service {SERVICE.NAME} <b>has been resolved at</b> {EVENT.RECOVERY.TIME} <b>on</b> {EVENT.RECOVERY.DATE}</dd><dd><b>Problem name:</b> {EVENT.NAME}</dd><dd><b>Problem duration:</b> {EVENT.DURATION}</dd><dd><b>Severity:</b> {EVENT.SEVERITY}</dd><dd><b>Original problem ID:</b> {EVENT.ID}</dd><dd><b>Service description:</b {SERVICE.DESCRIPTION}</dd></dl>'),
('220','43','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','<dl><dd><b>Changed {SERVICE.NAME} <b>service status to</b> {EVENT.UPDATE.SEVERITY} <b>at</b> {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.</dd><dd><b>Current problem age is</b> {EVENT.AGE}.</dd><dd><b>Service description:</b> {SERVICE.DESCRIPTION}</dd><br>{SERVICE.ROOTCAUSE}</dd></dl>'),
('221','44','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('222','44','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('223','44','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('224','45','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('225','45','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('226','45','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('227','45','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('228','45','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('229','46','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('230','46','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('231','46','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('232','46','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('233','46','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('234','46','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('235','46','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('236','46','4','0','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('237','46','4','1','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('238','46','4','2','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('239','47','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('240','47','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('241','47','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('242','47','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('243','47','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('244','47','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('245','47','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('246','47','4','0','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('247','47','4','1','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('248','47','4','2','[{EVENT.STATUS}] Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('249','48','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}'),
('250','48','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}'),
('251','48','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('252','48','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('253','48','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('254','49','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('255','49','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('256','49','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('257','49','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('258','49','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('259','50','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('260','50','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('261','50','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('262','50','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('263','50','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('264','50','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('265','50','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('266','51','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('267','51','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('268','51','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('269','51','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('270','51','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('271','52','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('272','52','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('273','52','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('274','52','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('275','52','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('276','52','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('277','52','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('278','52','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('279','52','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('280','52','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('281','53','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('282','53','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('283','53','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('284','53','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('285','53','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('286','53','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('287','53','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('288','53','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('289','53','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('290','53','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('291','54','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('292','54','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('293','54','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('294','54','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('295','54','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('296','55','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('297','55','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('298','55','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('299','55','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('300','55','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('301','55','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('302','55','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('303','55','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('304','55','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('305','55','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('306','56','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('307','56','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('308','56','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('309','56','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('310','56','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('311','56','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('312','56','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('313','56','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('314','56','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('315','56','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('316','57','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('317','57','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('318','57','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('319','57','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('320','57','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('321','58','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('322','58','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('323','58','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('324','58','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('325','58','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('326','59','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('327','59','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('328','59','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('329','59','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('330','59','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('331','60','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('332','60','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('333','60','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('334','60','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('335','60','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('336','61','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('337','61','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('338','61','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('339','61','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('340','61','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('341','62','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('342','62','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('343','62','0','2','Updated: {EVENT.NAME}','Problem updated at {EVENT.TIME} on {EVENT.DATE}\r\n{USER.FULLNAME} {EVENT.UPDATE.ACTION}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('344','62','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('345','62','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('346','62','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('347','62','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('348','62','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('349','62','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('350','62','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('351','63','0','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n\r\nTrigger description: {TRIGGER.DESCRIPTION}'),
('352','63','0','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('353','63','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('354','63','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('355','63','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('356','64','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('357','64','0','1','Resolved: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('358','64','0','2','Updated problem: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('359','64','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('360','64','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('361','65','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('362','65','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('363','65','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('364','65','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('365','65','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('366','65','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('367','65','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('368','65','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('369','65','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('370','65','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('371','66','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('372','66','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('373','66','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('374','66','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('375','66','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('376','67','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('377','67','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('378','67','0','2','[{EVENT.STATUS}] {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('379','67','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('380','67','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('381','68','0','0','Problem: {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('382','68','0','1','Resolved in {EVENT.DURATION}: {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('383','68','0','2','Updated problem in {EVENT.AGE}: {EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, age is {EVENT.AGE}, acknowledged: {EVENT.ACK.STATUS}.'),
('384','68','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('385','68','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('386','68','3','0','[{EVENT.STATUS}] {EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('387','68','3','1','[{EVENT.STATUS}] {EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOriginal problem ID: {EVENT.ID}'),
('388','68','4','0','Service "{SERVICE.NAME}" problem: {EVENT.NAME}','Service problem started at {EVENT.TIME} on {EVENT.DATE}\r\nService problem name: {EVENT.NAME}\r\nService: {SERVICE.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('389','68','4','1','Service "{SERVICE.NAME}" resolved in {EVENT.DURATION}: {EVENT.NAME}','Service "{SERVICE.NAME}" has been resolved at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nProblem duration: {EVENT.DURATION}\r\nSeverity: {EVENT.SEVERITY}\r\nOriginal problem ID: {EVENT.ID}\r\nService description: {SERVICE.DESCRIPTION}'),
('390','68','4','2','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} in {EVENT.AGE}','Changed "{SERVICE.NAME}" service status to {EVENT.UPDATE.SEVERITY} at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\nCurrent problem age is {EVENT.AGE}.\r\nService description: {SERVICE.DESCRIPTION}\r\n\r\n{SERVICE.ROOTCAUSE}'),
('391','69','0','0','{EVENT.NAME}','Problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('392','69','0','1','{EVENT.NAME}','Problem has been resolved in {EVENT.DURATION} at {EVENT.RECOVERY.TIME} on {EVENT.RECOVERY.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nSeverity: {EVENT.SEVERITY}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}\r\n{TRIGGER.URL}'),
('393','69','0','2','{EVENT.NAME}','{USER.FULLNAME} {EVENT.UPDATE.ACTION} problem at {EVENT.UPDATE.DATE} {EVENT.UPDATE.TIME}.\r\n{EVENT.UPDATE.MESSAGE}\r\n\r\nCurrent problem status is {EVENT.STATUS}, acknowledged: {EVENT.ACK.STATUS}.'),
('394','69','1','0','Discovery: {DISCOVERY.DEVICE.STATUS} {DISCOVERY.DEVICE.IPADDRESS}','Discovery rule: {DISCOVERY.RULE.NAME}\r\n\r\nDevice IP: {DISCOVERY.DEVICE.IPADDRESS}\r\nDevice DNS: {DISCOVERY.DEVICE.DNS}\r\nDevice status: {DISCOVERY.DEVICE.STATUS}\r\nDevice uptime: {DISCOVERY.DEVICE.UPTIME}\r\n\r\nDevice service name: {DISCOVERY.SERVICE.NAME}\r\nDevice service port: {DISCOVERY.SERVICE.PORT}\r\nDevice service status: {DISCOVERY.SERVICE.STATUS}\r\nDevice service uptime: {DISCOVERY.SERVICE.UPTIME}'),
('395','69','2','0','Autoregistration: {HOST.HOST}','Host name: {HOST.HOST}\r\nHost IP: {HOST.IP}\r\nAgent port: {HOST.PORT}'),
('396','69','3','0','Internal problem: {EVENT.NAME}','Internal problem started at {EVENT.TIME} on {EVENT.DATE}\r\nProblem name: {EVENT.NAME}\r\nHost: {HOST.NAME}\r\nOperational data: {EVENT.OPDATA}\r\nOriginal problem ID: {EVENT.ID}');
INSERT INTO `usrgrp` (`usrgrpid`,`name`,`gui_access`,`users_status`,`debug_mode`,`userdirectoryid`,`mfa_status`,`mfaid`) VALUES ('7','Zabbix administrators','0','0','0',NULL,'0',NULL),
('8','Guests','0','0','0',NULL,'0',NULL),
('9','Disabled','0','1','0',NULL,'0',NULL),
('11','Enabled debug mode','0','0','1',NULL,'0',NULL),
('12','No access to the frontend','3','0','0',NULL,'0',NULL),
('13','Internal','1','0','0',NULL,'0',NULL);
INSERT INTO `users_groups` (`id`,`usrgrpid`,`userid`) VALUES ('2','8','2'),
('3','9','2'),
('4','7','1'),
('5','13','1'),
('6','13','2');
INSERT INTO `ugset_group` (`ugsetid`,`usrgrpid`) VALUES ('1','13'),
('1','8'),
('1','9');
INSERT INTO `user_ugset` (`userid`,`ugsetid`) VALUES ('2','1');
INSERT INTO `scripts` (`scriptid`,`name`,`command`,`host_access`,`usrgrpid`,`groupid`,`description`,`confirmation`,`type`,`execute_on`,`timeout`,`scope`,`port`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`menu_path`,`url`,`new_window`,`manualinput`,`manualinput_prompt`,`manualinput_validator`,`manualinput_validator_type`,`manualinput_default_value`) VALUES ('1','Ping','ping -c 3 {HOST.CONN}; case $? in [01]) true;; *) false;; esac','2',NULL,NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0',''),
('2','Traceroute','/usr/bin/traceroute {HOST.CONN}','2',NULL,NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0',''),
('3','Detect operating system','sudo /usr/bin/nmap -O {HOST.CONN}','2','7',NULL,'','','0','2','30s','2','','0','','','','','','','1','0','','','0','');
INSERT INTO `actions` (`actionid`,`name`,`eventsource`,`evaltype`,`status`,`esc_period`,`formula`,`pause_suppressed`,`notify_if_canceled`,`pause_symptoms`) VALUES ('2','Auto discovery. Linux servers.','1','0','1','0','','1','1','1'),
('3','Report problems to Zabbix administrators','0','0','1','1h','','1','1','1'),
('4','Report not supported items','3','0','1','1h','','1','1','1'),
('5','Report not supported low level discovery rules','3','0','1','1h','','1','1','1'),
('6','Report unknown triggers','3','0','1','1h','','1','1','1');
INSERT INTO `operations` (`operationid`,`actionid`,`operationtype`,`esc_period`,`esc_step_from`,`esc_step_to`,`evaltype`,`recovery`) VALUES ('1','2','6','0','1','1','0','0'),
('2','2','4','0','1','1','0','0'),
('3','3','0','0','1','1','0','0'),
('4','4','0','0','1','1','0','0'),
('5','5','0','0','1','1','0','0'),
('6','6','0','0','1','1','0','0'),
('7','3','11','0','1','1','0','1'),
('8','4','11','0','1','1','0','1'),
('9','5','11','0','1','1','0','1'),
('10','6','11','0','1','1','0','1');
INSERT INTO `opmessage` (`operationid`,`default_msg`,`subject`,`message`,`mediatypeid`) VALUES ('3','1','','',NULL),
('4','1','','',NULL),
('5','1','','',NULL),
('6','1','','',NULL),
('7','1','','',NULL),
('8','1','','',NULL),
('9','1','','',NULL),
('10','1','','',NULL);
INSERT INTO `opmessage_grp` (`opmessage_grpid`,`operationid`,`usrgrpid`) VALUES ('1','3','7'),
('2','4','7'),
('3','5','7'),
('4','6','7');
INSERT INTO `opgroup` (`opgroupid`,`operationid`,`groupid`) VALUES ('1','2','2');
INSERT INTO `conditions` (`conditionid`,`actionid`,`conditiontype`,`operator`,`value`,`value2`) VALUES ('2','2','10','0','0',''),
('3','2','8','0','9',''),
('4','2','12','2','Linux',''),
('6','4','23','0','0',''),
('7','5','23','0','2',''),
('8','6','23','0','4','');
INSERT INTO `config` (`configid`,`work_period`,`alert_usrgrpid`,`discovery_groupid`,`dbversion_status`,`geomaps_tile_provider`,`ldap_userdirectoryid`,`server_status`,`mfaid`,`software_update_check_data`) VALUES ('1','1-5,09:00-18:00','7','5','','OpenStreetMap.Mapnik',NULL,'',NULL,'');
INSERT INTO `graph_theme` (`graphthemeid`,`theme`,`backgroundcolor`,`graphcolor`,`gridcolor`,`maingridcolor`,`gridbordercolor`,`textcolor`,`highlightcolor`,`leftpercentilecolor`,`rightpercentilecolor`,`nonworktimecolor`,`colorpalette`) VALUES ('1','blue-theme','FFFFFF','FFFFFF','CCD5D9','ACBBC2','ACBBC2','1F2C33','E33734','429E47','E33734','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4'),
('2','dark-theme','2B2B2B','2B2B2B','454545','4F4F4F','4F4F4F','F2F2F2','E45959','59DB8F','E45959','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4'),
('3','hc-light','FFFFFF','FFFFFF','555555','000000','333333','000000','333333','000000','000000','EBEBEB','1A7C11,F63100,2774A4,A54F10,FC6EA3,6C59DC,AC8C14,611F27,F230E0,5CCD18,BB2A02,5A2B57,89ABF8,7EC25C,274482,2B5429,8048B4,FD5434,790E1F,87AC4D,E89DF4'),
('4','hc-dark','000000','000000','666666','888888','4F4F4F','FFFFFF','FFFFFF','FFFFFF','FFFFFF','333333','199C0D,F63100,2774A4,F7941D,FC6EA3,6C59DC,C7A72D,BA2A5D,F230E0,5CCD18,BB2A02,AC41A5,89ABF8,7EC25C,3165D5,79A277,AA73DE,FD5434,F21C3E,87AC4D,E89DF4');
INSERT INTO `globalmacro` (`globalmacroid`,`macro`,`value`,`description`,`type`) VALUES ('2','{$SNMP_COMMUNITY}','public','','0');
INSERT INTO `regexps` (`regexpid`,`name`,`test_string`) VALUES ('1','File systems for discovery','ext3'),
('2','Network interfaces for discovery','eth0'),
('3','Storage devices for SNMP discovery','/boot'),
('4','Windows service names for discovery','SysmonLog'),
('5','Windows service startup states for discovery','automatic');
INSERT INTO `expressions` (`expressionid`,`regexpid`,`expression`,`expression_type`,`exp_delimiter`,`case_sensitive`) VALUES ('1','1','^(btrfs|ext2|ext3|ext4|reiser|xfs|ffs|ufs|jfs|jfs2|vxfs|hfs|apfs|refs|ntfs|fat32|zfs)$','3',',','0'),
('3','3','^(Physical memory|Virtual memory|Memory buffers|Cached memory|Swap space)$','4',',','1'),
('5','4','^(MMCSS|gupdate|SysmonLog|clr_optimization_v2.0.50727_32|clr_optimization_v4.0.30319_32)$','4',',','1'),
('6','5','^(automatic|automatic delayed)$','3',',','1'),
('7','2','^Software Loopback Interface','4',',','1'),
('8','2','^(In)?[Ll]oop[Bb]ack[0-9._]*$','4',',','1'),
('9','2','^NULL[0-9.]*$','4',',','1'),
('10','2','^[Ll]o[0-9.]*$','4',',','1'),
('11','2','^[Ss]ystem$','4',',','1'),
('12','2','^Nu[0-9.]*$','4',',','1');
INSERT INTO `config_autoreg_tls` (`autoreg_tlsid`,`tls_psk_identity`,`tls_psk`) VALUES ('1','','');
INSERT INTO `module` (`moduleid`,`id`,`relative_path`,`status`,`config`) VALUES ('1','actionlog','widgets/actionlog','1','[]'),
('2','clock','widgets/clock','1','[]'),
('3','dataover','widgets/dataover','1','[]'),
('4','discovery','widgets/discovery','1','[]'),
('5','favgraphs','widgets/favgraphs','1','[]'),
('6','favmaps','widgets/favmaps','1','[]'),
('7','geomap','widgets/geomap','1','[]'),
('8','graph','widgets/graph','1','[]'),
('9','graphprototype','widgets/graphprototype','1','[]'),
('10','hostavail','widgets/hostavail','1','[]'),
('11','item','widgets/item','1','[]'),
('12','map','widgets/map','1','[]'),
('13','navtree','widgets/navtree','1','[]'),
('14','itemhistory','widgets/itemhistory','1','[]'),
('15','problemhosts','widgets/problemhosts','1','[]'),
('16','problems','widgets/problems','1','[]'),
('17','problemsbysv','widgets/problemsbysv','1','[]'),
('18','slareport','widgets/slareport','1','[]'),
('19','svggraph','widgets/svggraph','1','[]'),
('20','systeminfo','widgets/systeminfo','1','[]'),
('21','tophosts','widgets/tophosts','1','[]'),
('22','trigover','widgets/trigover','1','[]'),
('23','url','widgets/url','1','[]'),
('24','web','widgets/web','1','[]'),
('25','gauge','widgets/gauge','1','[]'),
('26','toptriggers','widgets/toptriggers','1','[]'),
('27','piechart','widgets/piechart','1','[]'),
('28','honeycomb','widgets/honeycomb','1','[]'),
('29','hostnavigator','widgets/hostnavigator','1','[]'),
('30','itemnavigator','widgets/itemnavigator','1','[]');
INSERT INTO `role_rule` (`role_ruleid`,`roleid`,`type`,`name`,`value_int`,`value_str`,`value_moduleid`,`value_serviceid`) VALUES ('1','1','0','ui.default_access','1','',NULL,NULL),
('2','1','0','services.read','1','',NULL,NULL),
('3','1','0','services.write','0','',NULL,NULL),
('4','1','0','modules.default_access','1','',NULL,NULL),
('5','1','0','api.access','1','',NULL,NULL),
('6','1','0','api.mode','0','',NULL,NULL),
('7','1','0','actions.default_access','1','',NULL,NULL),
('8','2','0','ui.default_access','1','',NULL,NULL),
('9','2','0','services.read','1','',NULL,NULL),
('10','2','0','services.write','1','',NULL,NULL),
('11','2','0','modules.default_access','1','',NULL,NULL),
('12','2','0','api.access','1','',NULL,NULL),
('13','2','0','api.mode','0','',NULL,NULL),
('14','2','0','actions.default_access','1','',NULL,NULL),
('15','3','0','ui.default_access','1','',NULL,NULL),
('16','3','0','services.read','1','',NULL,NULL),
('17','3','0','services.write','1','',NULL,NULL),
('18','3','0','modules.default_access','1','',NULL,NULL),
('19','3','0','api.access','1','',NULL,NULL),
('20','3','0','api.mode','0','',NULL,NULL),
('21','3','0','actions.default_access','1','',NULL,NULL),
('22','4','0','ui.default_access','1','',NULL,NULL),
('23','4','0','services.read','1','',NULL,NULL),
('24','4','0','services.write','0','',NULL,NULL),
('25','4','0','modules.default_access','1','',NULL,NULL),
('26','4','0','api.access','0','',NULL,NULL),
('27','4','0','actions.default_access','0','',NULL,NULL);
INSERT INTO `hgset` (`hgsetid`,`hash`) VALUES ('1','e629fa6598d732768f7c726b4b621285f9c3b85303900aa912017db7617d8bdb'),
('2','4ec9599fc203d176a301536c2e091a19bc852759b255bd6818810a42c5fed14a'),
('3','4523540f1504cd17100c4835e85b7eefd49911580f8efff0599a8f283be6b9e3'),
('4','ef8704ac79657fbf2818c74a70a571c131283abd8914eca173cd032929702789'),
('5','6f4b6612125fb3a0daecd2799dfd6c9c299424fd920f9b308110a2c1fbd8f443'),
('6','4b227777d4dd1fc61c6f884f48641d02b4d121d3fd328cb08b5531fcacdabf8a'),
('7','19581e27de7ced00ff1ce50b2047e7a567c76b1cbaebabe5ef03f7c3017bb5b7'),
('8','6b51d431df5d7f141cbececcf79edf3dd861c3b4069f0b11661a3eefacbba918'),
('9','b17ef6d19c7a5b1ee83b907c595526dcb1eb06db8227d650d5dda0a9f4ce8cd9'),
('10','4fc82b26aecb47d2868c4efbe3581732a3e7cbcc6c2efb32062c08170a05eeb8'),
('11','4a44dc15364204a80fe80e9039455cc1608281820fe2b24f1e5233ade6af1dd5'),
('12','3fdba35f04dc8c462986c992bcf875546257113072a909c162f7e470e581e278'),
('13','18825963bca486408507a3ec26cb578a35efbf77182c0f1738502102c18890fa');
INSERT INTO `hosts` (`hostid`,`proxyid`,`host`,`status`,`ipmi_authtype`,`ipmi_privilege`,`ipmi_username`,`ipmi_password`,`name`,`flags`,`templateid`,`description`,`tls_connect`,`tls_accept`,`tls_issuer`,`tls_subject`,`tls_psk_identity`,`tls_psk`,`discover`,`custom_interfaces`,`uuid`,`name_upper`,`vendor_name`,`vendor_version`,`proxy_groupid`,`monitored_by`) VALUES ('10001',NULL,'Linux by Zabbix agent','3','-1','2','','','Linux by Zabbix agent','0',NULL,'This is an official Linux template. It requires Zabbix agent 7.0 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n- The ext4/3/2 filesystem reserves space for privileged usage, typically set at 5% by default.\r\n- BTRFS allocates a default of 10% of the volume for its own needs.\r\n- To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n  - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n- The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f8f7908280354f2abeed07dc788c3747','LINUX BY ZABBIX AGENT','Zabbix','7.0-3',NULL,'0'),
('10047',NULL,'Zabbix server health','3','-1','2','','','Zabbix server health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the local Zabbix server.\r\n\r\nLink this template to the local Zabbix server host.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e2d2b4e4ac28483996cc11fe42823d57','ZABBIX SERVER HEALTH','Zabbix','7.0-6',NULL,'0'),
('10048',NULL,'Zabbix proxy health','3','-1','2','','','Zabbix proxy health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the local Zabbix proxy.\r\n\r\nLink this template to the local Zabbix proxy host.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','dd114bf0fb2f46bc84840f1bb24e2b23','ZABBIX PROXY HEALTH','Zabbix','7.0-4',NULL,'0'),
('10074',NULL,'OpenBSD by Zabbix agent','3','-1','2','','','OpenBSD by Zabbix agent','0',NULL,'This is an Official OpenBSD template. It requires Zabbix agent 7.0 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','760be6e1c2194a5bb7c0df47cc5f71ca','OPENBSD BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10075',NULL,'FreeBSD by Zabbix agent','3','-1','2','','','FreeBSD by Zabbix agent','0',NULL,'This is an official FreeBSD template. It requires Zabbix agent 7.0 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a3dc630729e443139f4e608954fa6e19','FREEBSD BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10076',NULL,'AIX by Zabbix agent','3','-1','2','','','AIX by Zabbix agent','0',NULL,'This is an official AIX template. It requires Zabbix agent 7.0 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7e6bb0931a72459db9514aa924b420bc','AIX BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10077',NULL,'HP-UX by Zabbix agent','3','-1','2','','','HP-UX by Zabbix agent','0',NULL,'This is an official HP-UX template. It requires Zabbix agent 7.0 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b1fd823d262042e08291313f72be9452','HP-UX BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10078',NULL,'Solaris by Zabbix agent','3','-1','2','','','Solaris by Zabbix agent','0',NULL,'This is an official Solaris OS template. It requires Zabbix agent 7.0 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','eaf36c98b91843b7b79bd5184a23d377','SOLARIS BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10079',NULL,'macOS by Zabbix agent','3','-1','2','','','macOS by Zabbix agent','0',NULL,'This is an official macOS template. It requires Zabbix agent 7.0 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f895df5b37494f668cde1a2388d7af8b','MACOS BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10081',NULL,'Windows by Zabbix agent','3','-1','2','','','Windows by Zabbix agent','0',NULL,'This is an official Windows template. It requires Zabbix agent 7.0 or newer.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','13b06904a6bf41cbb795e3193d896340','WINDOWS BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10084',NULL,'Zabbix server','0','-1','2','','','Zabbix server','0',NULL,'','1','1','','','','','0','0','','ZABBIX SERVER','','',NULL,'0'),
('10169',NULL,'Generic Java JMX','3','-1','2','','','Generic Java JMX','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','72aab08f7f27406a8f2c291648e5ba95','GENERIC JAVA JMX','Zabbix','7.0-1',NULL,'0'),
('10171',NULL,'Intel SR1530 IPMI','3','-1','2','','','Intel SR1530 IPMI','0',NULL,'Template for monitoring Intel SR1530 server system.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f01bd64eef4049fabe087cccae590226','INTEL SR1530 IPMI','Zabbix','7.0-1',NULL,'0'),
('10172',NULL,'Intel SR1630 IPMI','3','-1','2','','','Intel SR1630 IPMI','0',NULL,'Template for monitoring Intel SR1630 server system.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2327c665b46e4aa781d41240168c3867','INTEL SR1630 IPMI','Zabbix','7.0-1',NULL,'0'),
('10173',NULL,'VMware','3','-1','2','','','VMware','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nNote: To enable discovery of hardware sensors of VMware Hypervisors, set the macro \'{$VMWARE.HV.SENSOR.DISCOVERY}\' to the value \'true\' on the discovered host level.\r\n\r\nNote: To create custom performance counter see documentation: https://www.zabbix.com/documentation/7.0/manual/vm_monitoring/vmware_keys#footnotes.\r\n\r\nNote: To get all supported counters and generate path for custom performance counter see documentation: https://www.zabbix.com/documentation/7.0/manual/appendix/items/perf_counters.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','56079badd056419383cc26e6a4fcc7e0','VMWARE','Zabbix','7.0-3',NULL,'0'),
('10174',NULL,'VMware Guest','3','-1','2','','','VMware Guest','0',NULL,'Note: To enable trigger for free space for guest VM, set macro \'{$VMWARE.VM.FS.TRIGGER.USED}\' to the value \'1\' on the discovered host level.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7942fb93ae3b47cf9ca0ea4beb0675ce','VMWARE GUEST','Zabbix','7.0-4',NULL,'0'),
('10175',NULL,'VMware Hypervisor','3','-1','2','','','VMware Hypervisor','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nThis template can be used in discovery as well as manually linked to a host. To use this template as manually linked to a host, attach it to the host and set manually the value of \'{$VMWARE.HV.UUID}\' macro.\r\n\r\nNote: To create custom performance counter see documentation: https://www.zabbix.com/documentation/7.0/manual/vm_monitoring/vmware_keys#footnotes.\r\n\r\nNote: To get all supported counters and generate path for custom performance counter see documentation: https://www.zabbix.com/documentation/7.0/manual/appendix/items/perf_counters.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5899b2f0aced4085b5ac25d0461b3425','VMWARE HYPERVISOR','Zabbix','7.0-4',NULL,'0'),
('10207',NULL,'Alcatel Timetra TiMOS by SNMP','3','-1','2','','','Alcatel Timetra TiMOS by SNMP','0',NULL,'Template Net Alcatel Timetra TiMOS\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nTIMETRA-SYSTEM-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nTIMETRA-CHASSIS-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','53044571fb864d87af32473e08c76d0b','ALCATEL TIMETRA TIMOS BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10208',NULL,'Brocade FC by SNMP','3','-1','2','','','Brocade FC by SNMP','0',NULL,'Template Net Brocade FC\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nSW-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: no IF-MIB::ifAlias is available\r\n  Version: v6.3.1c, v7.0.0c,  v7.4.1c\r\n  Device: all\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','de96d02bd5f242bfa31308ae2131d03f','BROCADE FC BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10210',NULL,'Brocade_Foundry Nonstackable by SNMP','3','-1','2','','','Brocade_Foundry Nonstackable by SNMP','0',NULL,'Template Net Brocade Foundry Nonstackable\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6ecfb7083ddf45f183ab4be50cfba37a','BROCADE_FOUNDRY NONSTACKABLE BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10211',NULL,'Brocade_Foundry Stackable by SNMP','3','-1','2','','','Brocade_Foundry Stackable by SNMP','0',NULL,'Template Brocade Foundry Stackable\r\n\r\nMIBs used:\r\nFOUNDRY-SN-AGENT-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nFOUNDRY-SN-STACKING-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Correct fan(returns fan status as \'other(1)\' and temperature (returns 0) for the non-master Switches are not available in SNMP\r\n  Version: Version 08.0.40b and above\r\n  Device: ICX 7750 in stack\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f64ad01567914165a493815e492fb315','BROCADE_FOUNDRY STACKABLE BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10218',NULL,'Cisco IOS by SNMP','3','-1','2','','','Cisco IOS by SNMP','0',NULL,'Template Cisco IOS Software releases 12.2(3.5) or later\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nCISCO-ENVMON-MIB\r\nCISCO-PROCESS-MIB\r\nENTITY-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: no if(in|out)(Errors|Discards) are available for vlan ifType\r\n  Version: IOS for example: 12.1(22)EA11, 15.4(3)M2\r\n  Device: C2911, C7600\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','aa3ce9bd8c1d40a2b0f83f9e642e88ee','CISCO IOS BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10220',NULL,'Cisco IOS prior to 12.0_3_T by SNMP','3','-1','2','','','Cisco IOS prior to 12.0_3_T by SNMP','0',NULL,'Cisco IOS Software releases prior to 12.0(3)T\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nOLD-CISCO-CPU-MIB\r\nCISCO-ENVMON-MIB\r\nCISCO-MEMORY-POOL-MIB\r\nENTITY-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1bb42fbdb9054645a62ff81f14ba3b99','CISCO IOS PRIOR TO 12.0_3_T BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10221',NULL,'Dell Force S-Series by SNMP','3','-1','2','','','Dell Force S-Series by SNMP','0',NULL,'Template Dell Force S-Series\r\n\r\nMIBs used:\r\nF10-S-SERIES-CHASSIS-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e5ec7acc7efc4ac491b6fa552ab077ae','DELL FORCE S-SERIES BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10222',NULL,'D-Link DES 7200 by SNMP','3','-1','2','','','D-Link DES 7200 by SNMP','0',NULL,'Template D-Link DES 7200\r\n\r\nMIBs used:\r\nENTITY-MIBdescription has changed\r\nIF-MIB\r\nMY-PROCESS-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMY-MEMORY-MIB\r\nENTITY-MIB\r\nMY-SYSTEM-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','395184b5d5b048a68e06c91154c56847','D-LINK DES 7200 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10223',NULL,'D-Link DES_DGS Switch by SNMP','3','-1','2','','','D-Link DES_DGS Switch by SNMP','0',NULL,'Template D-Link DES_DGS Switch\r\n\r\nMIBs used:\r\nEQUIPMENT-MIB\r\nIF-MIB\r\nDLINK-AGENT-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: D-Link reports missing PSU as fail(4)\r\n  Version: Firmware: 1.73R008,hardware revision: B1\r\n  Device: DGS-3420-26SC Gigabit Ethernet Switch\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d3176749a5274264938f487cd89d17eb','D-LINK DES_DGS SWITCH BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10224',NULL,'Extreme EXOS by SNMP','3','-1','2','','','Extreme EXOS by SNMP','0',NULL,'Template Extreme EXOS\r\n\r\nMIBs used:\r\nEXTREME-SYSTEM-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nEXTREME-SOFTWARE-MONITOR-MIB\r\nENTITY-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','861dbdece18f4b8f85214a319995eb3e','EXTREME EXOS BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10226',NULL,'Network Generic Device by SNMP','3','-1','2','','','Network Generic Device by SNMP','0',NULL,'Template Net Network Generic Device\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','67332e679035423f85090aa985947c36','NETWORK GENERIC DEVICE BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10227',NULL,'HP Comware HH3C by SNMP','3','-1','2','','','HP Comware HH3C by SNMP','0',NULL,'Template Net HP Comware (HH3C)\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nHH3C-ENTITY-EXT-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: No temperature sensors. All entities of them return 0 for HH3C-ENTITY-EXT-MIB::hh3cEntityExtTemperature\r\n  Version: 1910-48 Switch Software Version 5.20.99, Release 1116 Copyright(c)2010-2016 Hewlett Packard Enterprise Development LP\r\n  Device: HP 1910-48\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','57aeccd43b744942b9555269b79a96ad','HP COMWARE HH3C BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10229',NULL,'Huawei VRP by SNMP','3','-1','2','','','Huawei VRP by SNMP','0',NULL,'Template Net Huawei VRP\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nHUAWEI-ENTITY-EXTENT-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ad4c3dad4b7b492685d1fd3bd3a664f9','HUAWEI VRP BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10230',NULL,'Intel_Qlogic Infiniband by SNMP','3','-1','2','','','Intel_Qlogic Infiniband by SNMP','0',NULL,'Template Net Intel_Qlogic Infiniband\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nICS-CHASSIS-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6f7f2c44e13a46a4b219fbb5db92f3f7','INTEL_QLOGIC INFINIBAND BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10231',NULL,'Juniper by SNMP','3','-1','2','','','Juniper by SNMP','0',NULL,'Template Net Juniper\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nJUNIPER-ALARM-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nJUNIPER-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a326034825984bbd8a3a5885f3939bb3','JUNIPER BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10233',NULL,'Mikrotik by SNMP','3','-1','2','','','Mikrotik by SNMP','0',NULL,'Template Net Mikrotik\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Doesn\'t have ifHighSpeed filled. Fixed in more recent versions\r\n  Version: RouterOS 6.28 or lower\r\n\r\n  Description: Doesn\'t have any temperature sensors\r\n  Version: RouterOS 6.38.5\r\n  Device: Mikrotik 941-2nD, Mikrotik 951G-2HnD\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','815b5a81b29a477695fddbd533ad9c84','MIKROTIK BY SNMP','Zabbix','7.0-5',NULL,'0'),
('10234',NULL,'Netgear Fastpath by SNMP','3','-1','2','','','Netgear Fastpath by SNMP','0',NULL,'Template Net Netgear Fastpath\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nFASTPATH-SWITCHING-MIB\r\nFASTPATH-BOXSERVICES-PRIVATE-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5920713da492452889adabc25e259caa','NETGEAR FASTPATH BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10235',NULL,'QTech QSW by SNMP','3','-1','2','','','QTech QSW by SNMP','0',NULL,'Template Net QTech QSW\r\n\r\nMIBs used:\r\nQTECH-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','21f3e79e1d2e4f5e868d1ef81c94bbfd','QTECH QSW BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10236',NULL,'TP-LINK by SNMP','3','-1','2','','','TP-LINK by SNMP','0',NULL,'Template Net TP-LINK\r\n\r\nMIBs used:\r\nTPLINK-SYSINFO-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nTPLINK-SYSMONITOR-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Default sysLocation, sysName and sysContact is not filled with proper data. Real hostname and location can be found only in private branch (TPLINK-SYSINFO-MIB). Please check whether this problem exists in the latest firmware: https://www.tp-link.com/en/support/download/t2600g-28ts/#Firmware\r\n  Version: 2.0.0 Build 20170628 Rel.55184 (Beta)\r\n  Device: T2600G-28TS 2.0\r\n\r\n  Description: The Serial number of the product (tpSysInfoSerialNum) is missing in HW versions prior to V2_170323\r\n  Version: Prior to version V2_170323\r\n  Device: T2600G-28TS 2.0\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2b9039885edf45b8bdd39f16dd069133','TP-LINK BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10237',NULL,'Ubiquiti AirOS by SNMP','3','-1','2','','','Ubiquiti AirOS by SNMP','0',NULL,'Template Net Ubiquiti AirOS\r\n\r\nMIBs used:\r\nFROGFOOT-RESOURCES-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nIEEE802dot11-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: UBNT unifi reports speed: like IF-MIB::ifSpeed.1 = Gauge32: 4294967295 for all interfaces\r\n  Version: Firmware: BZ.ar7240.v3.7.51.6230.170322.1513\r\n  Device: UBNT UAP-LR\r\n\r\n  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports ifSpeed: as 0 for VLAN and wireless(ath0) interfaces\r\n  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836\r\n  Device: NanoStation M5\r\n\r\n  Description: UBNT AirMax(NanoStation, NanoBridge etc) reports always return ifType: as ethernet(6) even for wifi,vlans and other types\r\n  Version: Firmware: XW.ar934x.v5.6-beta4.22359.140521.1836\r\n  Device: NanoStation M5\r\n\r\n  Description: ifXTable is not provided in IF-MIB. So Interfaces Simple Template is used instead\r\n  Version: all above\r\n  Device: NanoStation, UAP-LR\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6c235d126c1f4895acfe2156b140a886','UBIQUITI AIROS BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10248',NULL,'Linux by SNMP','3','-1','2','','','Linux by SNMP','0',NULL,'This is an official Linux template. It requires an SNMP client.\r\n\r\nMIBs used:\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nUCD-DISKIO-MIB\r\nUCD-SNMP-MIB\r\nIF-MIB\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 * (used / used + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4d3a7adbb6964bd08f2b9d28e0da6496','LINUX BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10249',NULL,'Windows by SNMP','3','-1','2','','','Windows by SNMP','0',NULL,'This is an official Windows template. It requires an SNMP client.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description:\r\n    64-bit I/O is not supported even though `IfxTable` is present.\r\n    Currently, Windows gets its interface status from MIB-2. Since these 64-bit SNMP counters (`ifHCInOctets`, `ifHCOutOctets`, etc.) are defined as an extension to IF-MIB, Microsoft has not implemented it.\r\n  Version: Win2008, Win2012R2.\r\n\r\n  Description: MIB is not supported\r\n  Version: WindowsXP\r\n\r\n  Description: EtherLike MIB is not supported\r\n  Version: any\r\n\r\n  Description:\r\n    HOST-RESOURCES-MIB::hrStorageSize is limited to number 2147483647.\r\n    Storage size is calculated using: `hrStorageSize` and `hrStorageAllocationUnits`.\r\n    Allocation size of 512 bytes, sets the limit of monitored device to 1TB.\r\n  Version: any\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f9a59315c8944853bb91c0a9ec3056d7','WINDOWS BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10250',NULL,'HP Enterprise Switch by SNMP','3','-1','2','','','HP Enterprise Switch by SNMP','0',NULL,'Template Net HP Enterprise Switch\r\n\r\nMIBs used:\r\nNETSWITCH-MIB\r\nHP-ICF-CHASSIS\r\nENTITY-SENSORS-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nSEMI-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\nSTATISTICS-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cce20a5d149a48b7ac7f5383c3510883','HP ENTERPRISE SWITCH BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10251',NULL,'Mellanox by SNMP','3','-1','2','','','Mellanox by SNMP','0',NULL,'The updated template for monitoring the Mellanox network switches over SNMP agent. All items collected in one template without any linked templates.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-SENSORS-MIB\r\nENTITY-STATE-MIB\r\nENTITY-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a60798c651604d93a062bec0f8a89751','MELLANOX BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10253',NULL,'Cisco IOS versions 12.0_3_T-12.2_3.5 by SNMP','3','-1','2','','','Cisco IOS versions 12.0_3_T-12.2_3.5 by SNMP','0',NULL,'Cisco IOS Software releases later to 12.0(3)T and prior to 12.2(3.5)\r\n\r\nMIBs used:\r\nCISCO-MEMORY-POOL-MIB\r\nIF-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nCISCO-ENVMON-MIB\r\nCISCO-PROCESS-MIB\r\nENTITY-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','40c233aaa3424fd29dc378022ff3461d','CISCO IOS VERSIONS 12.0_3_T-12.2_3.5 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10254',NULL,'Arista by SNMP','3','-1','2','','','Arista by SNMP','0',NULL,'Template Net Arista\r\n\r\nMIBs used:\r\nENTITY-SENSORS-MIB\r\nENTITY-STATE-MIB\r\nIF-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nENTITY-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','26674f62500e4e79b9f470bbf962130d','ARISTA BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10255',NULL,'Dell iDRAC by SNMP','3','-1','2','','','Dell iDRAC by SNMP','0',NULL,'Template for Dell servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','43dc5c8a9a0e4786b64e44422c7f32b4','DELL IDRAC BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10256',NULL,'HP iLO by SNMP','3','-1','2','','','HP iLO by SNMP','0',NULL,'Template Server HP iLO\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c2a7ddca051d4b4a9553f339c57e47a9','HP ILO BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10258',NULL,'IBM IMM by SNMP','3','-1','2','','','IBM IMM by SNMP','0',NULL,'Template Server IBM IMM\r\n\r\nMIBs used:\r\nIMM-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Some IMMs (IMM1) do not return disks\r\n  Version: IMM1\r\n  Device: IBM x3250M3\r\n\r\n  Description: Some IMMs (IMM1) do not return fan status: fanHealthStatus\r\n  Version: IMM1\r\n  Device: IBM x3250M3\r\n\r\n  Description: IMM1 servers (M2, M3 generations) sysObjectID is NET-SNMP-MIB::netSnmpAgentOIDs.10\r\n  Version: IMM1\r\n  Device: IMM1 servers (M2,M3 generations)\r\n\r\n  Description: IMM1 servers (M2, M3 generations) only Ambient temperature sensor available\r\n  Version: IMM1\r\n  Device: IMM1 servers (M2,M3 generations)\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c9e1acd3ae4a427ab39724b6bcaf839e','IBM IMM BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10259',NULL,'Supermicro Aten by SNMP','3','-1','2','','','Supermicro Aten by SNMP','0',NULL,'Template Server Supermicro Aten\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nATEN-IPMI-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cf0947cc05d3450b9a6d66b2eb180482','SUPERMICRO ATEN BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10260',NULL,'Apache Tomcat by JMX','3','-1','2','','','Apache Tomcat by JMX','0',NULL,'The template to monitor Apache Tomcat by Zabbix that work without any external scripts.\r\nThe metrics are collected by JMX.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411862-discussion-thread-for-official-zabbix-template-tomcat\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3cc8c9ae7055458c9a803597007f70bd','APACHE TOMCAT BY JMX','Zabbix','7.0-1',NULL,'0'),
('10261',NULL,'Remote Zabbix server health','3','-1','2','','','Remote Zabbix server health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the remote Zabbix server.\r\n\r\nSpecify the address of the remote Zabbix server by changing the {$ZABBIX.SERVER.ADDRESS} and {$ZABBIX.SERVER.PORT} macros. Don\'t forget to adjust the "StatsAllowedIP" parameter in the remote server\'s configuration file to allow the collection of statistics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','79b16cbbe593444eae3de66de0cb566b','REMOTE ZABBIX SERVER HEALTH','Zabbix','7.0-7',NULL,'0'),
('10262',NULL,'Remote Zabbix proxy health','3','-1','2','','','Remote Zabbix proxy health','0',NULL,'This template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy.\r\n\r\nSpecify the address of the remote Zabbix proxy by updating the {$ZABBIX.PROXY.ADDRESS} and {$ZABBIX.PROXY.PORT} macros. Don\'t forget to adjust the "StatsAllowedIP" parameter in the remote proxy\'s configuration file to allow the collection of statistics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','970c2342146549768e6b91a26089bcdf','REMOTE ZABBIX PROXY HEALTH','Zabbix','7.0-5',NULL,'0'),
('10264',NULL,'Apache by Zabbix agent','3','-1','2','','','Apache by Zabbix agent','0',NULL,'Get metrics from mod_status module using HTTP agent.\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a8d91e4f36794e32b73090d5edf3d7ae','APACHE BY ZABBIX AGENT','Zabbix','7.0-1',NULL,'0'),
('10265',NULL,'Apache by HTTP','3','-1','2','','','Apache by HTTP','0',NULL,'This template is designed for the effortless deployment of Apache monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nThe template collects metrics by polling \'mod_status\' with HTTP agent remotely.\r\n\r\nSetup:\r\n\r\n1. See the setup instructions for mod_status:\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nCheck the availability of the module with this command line:\r\nhttpd -M 2>/dev/null | grep status_module\r\n\r\nThis is an example configuration of the Apache web server:\r\n\r\n<Location "/server-status">\r\n  SetHandler server-status\r\n  Require host example.com\r\n</Location>\r\n\r\n2. Set the hostname or IP address of the Apache status page host in the \'{$APACHE.STATUS.HOST}\' macro. You can also change the status page port in the \'{$APACHE.STATUS.PORT}\' macro and status page path in the \'{$APACHE.STATUS.PATH}\' macro if necessary.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','86702e8bc514434e8c914d50c206cb94','APACHE BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10266',NULL,'Nginx by Zabbix agent','3','-1','2','','','Nginx by Zabbix agent','0',NULL,'Get metrics from stub status module using Zabbix agent running on Linux\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','27f6424905884dbb96ab9210d987a56c','NGINX BY ZABBIX AGENT','Zabbix','7.0-1',NULL,'0'),
('10267',NULL,'Nginx by HTTP','3','-1','2','','','Nginx by HTTP','0',NULL,'This template is developed to monitor Nginx by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling the module \'ngx_http_stub_status_module\' with HTTP agent remotely:\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\nActive connections: 291\r\nserver accepts handled requests\r\n16630948 16630948 31070465\r\nReading: 6 Writing: 179 Waiting: 106\r\n\r\nSetup:\r\n\r\n1. See the setup instructions for \'ngx_http_stub_status_module\':\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\nTest the availability of the \'http_stub_status_module\' with \'nginx -V 2>&1 | grep -o with-http_stub_status_module\'.\r\n\r\nExample configuration of Nginx:\r\n\r\nlocation = /basic_status {\r\n    stub_status;\r\n    allow <IP of your Zabbix server/proxy>;\r\n    deny all;\r\n}\r\n\r\n2. Set the hostname or IP address of the Nginx host or Nginx container in the \'{$NGINX.STUB_STATUS.HOST}\' macro. You can also change the status page port in the \'{$NGINX.STUB_STATUS.PORT}\' macro, the status page scheme in the \'{$NGINX.STUB_STATUS.SCHEME}\' macro and the status page path in the \'{$NGINX.STUB_STATUS.PATH}\' macro if necessary.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','13d5bb0a4ae84228bff408aab5be338e','NGINX BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10285',NULL,'Linux by Prom','3','-1','2','','','Linux by Prom','0',NULL,'This template collects Linux metrics from node_exporter 0.18 and above. Support for older node_exporter versions is provided as \'best effort\'.\r\n\r\nSetup:\r\n\r\n1. Set up the node_exporter according to the official documentation:\r\nhttps://prometheus.io/docs/guides/node-exporter/\r\n\r\nUse node_exporter v0.18.0 or above.\r\n\r\n2. Set the hostname or IP address of the node_exporter host in the \'{$NODE_EXPORTER_HOST}\' macro. You can also change the Prometheus endpoint port in the \'{$NODE_EXPORTER_PORT}\' macro if necessary.\r\n\r\nKnown Issues:\r\n\r\n  - Node Exporter 0.16.0 renamed many metrics. CPU utilization for "guest" and "guest_nice" metrics are not supported in this template with Node Exporter < 0.16. Disk IO metrics are not supported. Other metrics provided as best effort. See https://github.com/prometheus/node_exporter/releases/tag/v0.16.0 for details.\r\n    - Version: below 0.16.0\r\n  - Metric node_network_info with label \'device\' cannot be found, so network discovery is not possible.\r\n    - Version: below 0.18\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2506b0ca01884903b547b1e19b76ce6d','LINUX BY PROM','Zabbix','7.0-4',NULL,'0'),
('10300',NULL,'RabbitMQ cluster by Zabbix agent','3','-1','2','','','RabbitMQ cluster by Zabbix agent','0',NULL,'Get cluster metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5fa761bc51e4432a90c6c9eece930c4a','RABBITMQ CLUSTER BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10301',NULL,'RabbitMQ node by Zabbix agent','3','-1','2','','','RabbitMQ node by Zabbix agent','0',NULL,'Get node metrics from RabbitMQ management plugin provided an HTTP-based API using Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d5dc11ae9ab143a89c4be534bbb35188','RABBITMQ NODE BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10302',NULL,'RabbitMQ cluster by HTTP','3','-1','2','','','RabbitMQ cluster by HTTP','0',NULL,'This template is developed to monitor the messaging broker RabbitMQ cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling RabbitMQ management plugin with HTTP agent remotely.\r\n\r\nSetup:\r\n\r\n1. Enable the RabbitMQ management plugin. See the RabbitMQ documentation for the instructions:\r\nhttps://www.rabbitmq.com/management.html\r\n\r\n2. Create a user to monitor the service:\r\n\r\nrabbitmqctl add_user zbx_monitor <PASSWORD>\r\nrabbitmqctl set_permissions  -p / zbx_monitor "" "" ".*"\r\nrabbitmqctl set_user_tags zbx_monitor monitoring\r\n\r\n3. Set the hostname or IP address of the RabbitMQ cluster host in the \'{$RABBITMQ.API.CLUSTER_HOST}\' macro. You can also change the port in the \'{$RABBITMQ.API.PORT}\' macro and the scheme in the \'{$RABBITMQ.API.SCHEME}\' macro if necessary.\r\n\r\n4. Set the user name and password in the macros \'{$RABBITMQ.API.USER}\' and \'{$RABBITMQ.API.PASSWORD}\'.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8c8474148c2a4eaeabe5a9331ea99d77','RABBITMQ CLUSTER BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10303',NULL,'RabbitMQ node by HTTP','3','-1','2','','','RabbitMQ node by HTTP','0',NULL,'This template is developed to monitor the messaging broker RabbitMQ node by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling RabbitMQ management plugin with HTTP agent remotely.\r\n\r\nSetup:\r\n\r\n1. Enable the RabbitMQ management plugin. See the RabbitMQ documentation for the instructions:\r\nhttps://www.rabbitmq.com/management.html\r\n\r\n2. Create a user to monitor the service:\r\n\r\nrabbitmqctl add_user zbx_monitor <PASSWORD>\r\nrabbitmqctl set_permissions  -p / zbx_monitor "" "" ".*"\r\nrabbitmqctl set_user_tags zbx_monitor monitoring\r\n\r\n3. Set the hostname or IP address of the RabbitMQ node host in the \'{$RABBITMQ.API.HOST}\' macro. You can also change the port in the \'{$RABBITMQ.API.PORT}\' macro and the scheme in the \'{$RABBITMQ.API.SCHEME}\' macro if necessary.\r\n\r\n4. Set the user name and password in the macros \'{$RABBITMQ.API.USER}\' and \'{$RABBITMQ.API.PASSWORD}\'.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387226-discussion-thread-for-official-zabbix-template-rabbitmq\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b9514029d03b44de9adf24251778dbf3','RABBITMQ NODE BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10304',NULL,'Cisco UCS by SNMP','3','-1','2','','','Cisco UCS by SNMP','0',NULL,'Template Server Cisco UCS\r\n\r\nMIBs used:\r\nCISCO-UNIFIED-COMPUTING-COMPUTE-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nCISCO-UNIFIED-COMPUTING-PROCESSOR-MIB\r\nCISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB\r\nCISCO-UNIFIED-COMPUTING-STORAGE-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cb66d34564e44b3893442fc74cf6e951','CISCO UCS BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10308',NULL,'HAProxy by Zabbix agent','3','-1','2','','','HAProxy by Zabbix agent','0',NULL,'The template to monitor HAProxy by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling the HAProxy stats page with Zabbix agent.\r\n\r\nNote, that this template doesn\'t support authentication and redirects (limitations of \'web.page.get\').\r\n\r\nSetup:\r\n\r\n1. Set up the HAProxy stats page:\r\nhttps://www.haproxy.com/blog/exploring-the-haproxy-stats-page/\r\n\r\nThe example configuration of HAProxy:\r\n\r\nfrontend stats\r\n    bind *:8404\r\n    stats enable\r\n    stats uri /stats\r\n    stats refresh 10s\r\n\r\n2. Set the hostname or IP address of the HAProxy stats host or container in the \'{$HAPROXY.STATS.HOST}\' macro. You can also change the status page port in the \'{$HAPROXY.STATS.PORT}\' macro, the status page scheme in the \'{$HAPROXY.STATS.SCHEME}\' macro and the status page path in the \'{$HAPROXY.STATS.PATH}\' macro if necessary.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','812073bf8df143bcae2a84b32c3965e5','HAPROXY BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10309',NULL,'HAProxy by HTTP','3','-1','2','','','HAProxy by HTTP','0',NULL,'The template to monitor HAProxy by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by polling the HAProxy stats page with HTTP agent.\r\n\r\nSetup:\r\n\r\n1. Set up the HAProxy stats page:\r\nhttps://www.haproxy.com/blog/exploring-the-haproxy-stats-page/\r\n\r\nIf you want to use authentication, set the username and password in the \'stats auth\' option of the configuration file.\r\n\r\nThe example configuration of HAProxy:\r\n\r\nfrontend stats\r\n    bind *:8404\r\n    stats enable\r\n    stats uri /stats\r\n    stats refresh 10s\r\n    #stats auth Username:Password  # Authentication credentials\r\n\r\n2. Set the hostname or IP address of the HAProxy stats host or container in the \'{$HAPROXY.STATS.HOST}\' macro. You can also change the status page port in the \'{$HAPROXY.STATS.PORT}\' macro, the status page scheme in the \'{$HAPROXY.STATS.SCHEME}\' macro and the status page path in the \'{$HAPROXY.STATS.PATH}\' macro if necessary.\r\n\r\n3. If you have enabled authentication in the HAProxy configuration file in step 1, set the username and password in the `{$HAPROXY.USERNAME}` and `{$HAPROXY.PASSWORD}` macros.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/393527-discussion-thread-for-official-zabbix-template-haproxy\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','948d046cb2894e5c8d07767a518cc1a9','HAPROXY BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10310',NULL,'Redis by Zabbix agent 2','3','-1','2','','','Redis by Zabbix agent 2','0',NULL,'Get Redis metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/389050-discussion-thread-for-official-zabbix-template-redis\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e111446745a1425b862f8727ae63bce4','REDIS BY ZABBIX AGENT 2','Zabbix','7.0-2',NULL,'0'),
('10316',NULL,'MySQL by Zabbix agent','3','-1','2','','','MySQL by Zabbix agent','0',NULL,'Requirements for template operation:\r\n\r\n1. Install Zabbix agent and MySQL client. If necessary, add the path to the \'mysql\' and \'mysqladmin\' utilities to the global environment variable PATH.\r\n\r\n2. Copy the \'template_db_mysql.conf\' file with user parameters into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don\'t forget to restart Zabbix agent.\r\n\r\n3. Create the MySQL user that will be used for monitoring (\'<password>\' at your discretion). For example:\r\n\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information, please see MySQL documentation (https://dev.mysql.com/doc/refman/8.0/en/grant.html).\r\n\r\nNOTE: In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the SLAVE MONITOR privilege to be set for the monitoring user:\r\n\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information, please read the MariaDB documentation (https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/).\r\n\r\n4. Create \'.my.cnf\' configuration file in the home directory of Zabbix agent for Linux distributions (/var/lib/zabbix by default) or \'my.cnf\' in c:\\ for Windows. For example:\r\n\r\n[client]\r\nprotocol=tcp\r\nuser=\'zbx_monitor\'\r\npassword=\'<password>\'\r\n\r\nFor more information, please see MySQL documentation (https://dev.mysql.com/doc/refman/8.0/en/option-files.html).\r\n\r\nNOTE: Linux distributions that use SELinux may require additional steps for access configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f255e3fc32124b55b2a17ef3c961e5f5','MYSQL BY ZABBIX AGENT','Zabbix','7.0-6',NULL,'0'),
('10317',NULL,'MySQL by ODBC','3','-1','2','','','MySQL by ODBC','0',NULL,'Requirements for template operation:\r\n1. Create a MySQL user for monitoring. For example:\r\n\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.\r\n\r\nNOTE: In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the SLAVE MONITOR privilege to be set for the monitoring user:\r\n\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MariaDB documentation https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/.\r\n\r\n2. Set the user name and password in the host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e19c120027e04da69b130e0f6cea29fc','MYSQL BY ODBC','Zabbix','7.0-6',NULL,'0'),
('10318',NULL,'Docker by Zabbix agent 2','3','-1','2','','','Docker by Zabbix agent 2','0',NULL,'Get Docker engine metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/435429-discussion-thread-for-official-zabbix-template-docker\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c5fd214cdd0d4b3b8272e73b022ba5c2','DOCKER BY ZABBIX AGENT 2','Zabbix','7.0-2',NULL,'0'),
('10319',NULL,'Memcached by Zabbix agent 2','3','-1','2','','','Memcached by Zabbix agent 2','0',NULL,'Get Memcached metrics from plugin for the New Zabbix Agent (zabbix-agent2).\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398623-discussion-thread-for-official-zabbix-template-memcached\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','05894ba2c9184d33992bf1bd21c347f6','MEMCACHED BY ZABBIX AGENT 2','Zabbix','7.0-2',NULL,'0'),
('10320',NULL,'MySQL by Zabbix agent 2','3','-1','2','','','MySQL by Zabbix agent 2','0',NULL,'Requirements for template operation:\r\n\r\n1. Create a MySQL user for monitoring. For example:\r\n\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.\r\n\r\nNOTE: In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the SLAVE MONITOR privilege to be set for the monitoring user:\r\n\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MariaDB documentation https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/.\r\n\r\n2. Set in the {$MYSQL.DSN} macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.\r\nExamples: MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock\r\nFor more information about MySQL Unix socket file please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.\r\n\r\n3. If you had set URI in the {$MYSQL.DSN}, please define the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\nLeave macros {$MYSQL.USER} and {$MYSQL.PASSWORD} empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.\r\nFor more information about configuring the Zabbix MySQL plugin please read the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.\r\n\r\nNOTE: In order to use this template for monitoring MySQL version 8.4 and later, Zabbix agent 2 version 7.0.22 and later should be used.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4904f84303c74c5e955b7849730c3155','MYSQL BY ZABBIX AGENT 2','Zabbix','7.0-6',NULL,'0'),
('10321',NULL,'Chassis by IPMI','3','-1','2','','','Chassis by IPMI','0',NULL,'Template for monitoring servers with BMC over IPMI that work without any external scripts.\r\nAll metrics are collected at once, thanks to Zabbix\'s bulk data collection. The template is available starting from Zabbix version 5.0.\r\nIt collects metrics by polling BMC remotely using an IPMI agent.\r\n\r\n\r\nKnown Issues:\r\n\r\n  Description: If the BMC has a sensor with an empty threshold value, we get the LLD error "Cannot create trigger...".\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/398023-discussion-thread-for-official-zabbix-template-ipmi\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','02f35169a5a54a5aad8b3f06e798ab1f','CHASSIS BY IPMI','Zabbix','7.0-1',NULL,'0'),
('10322',NULL,'Elasticsearch Cluster by HTTP','3','-1','2','','','Elasticsearch Cluster by HTTP','0',NULL,'The template to monitor Elasticsearch by Zabbix that work without any external scripts.\r\nIt works with both standalone and cluster instances.\r\nThe metrics are collected in one pass remotely using an HTTP agent.\r\nThey are getting values from REST API \'_cluster/health\', \'_cluster/stats\', \'_nodes/stats\' requests.\r\n\r\nSetup:\r\n\r\n1. Set the hostname or IP address of the Elasticsearch host in the \'{$ELASTICSEARCH.HOST}\' macro.\r\n\r\n2. Set the login and password in the \'{$ELASTICSEARCH.USERNAME}\' and \'{$ELASTICSEARCH.PASSWORD}\' macros.\r\n\r\n3. If you use an atypical location of ES API, don\'t forget to change the macros \'{$ELASTICSEARCH.SCHEME}\',\'{$ELASTICSEARCH.PORT}\'.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/399473-discussion-thread-for-official-zabbix-template-for-elasticsearch\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','52b2664578884d9eba62e47375c99f8e','ELASTICSEARCH CLUSTER BY HTTP','Zabbix','7.0-3',NULL,'0'),
('10323',NULL,'ClickHouse by HTTP','3','-1','2','','','ClickHouse by HTTP','0',NULL,'This template is designed for the effortless deployment of ClickHouse monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nSetup:\r\n\r\n1. Create a user to monitor the service. For example, you could create a file \'/etc/clickhouse-server/users.d/zabbix.xml\' with the following content:\r\n\r\n<yandex>\r\n  <users>\r\n    <zabbix>\r\n      <password>zabbix_pass</password>\r\n      <networks incl="networks" />\r\n      <profile>web</profile>\r\n      <quota>default</quota>\r\n      <allow_databases>\r\n        <database>test</database>\r\n      </allow_databases>\r\n    </zabbix>\r\n  </users>\r\n</yandex>\r\n\r\n2. Set the hostname or IP address of the ClickHouse HTTP endpoint in the \'{$CLICKHOUSE.HOST}\' macro. You can also change the port in the \'{$CLICKHOUSE.PORT}\' macro and scheme in the \'{$CLICKHOUSE.SCHEME}\' macro if necessary.\r\n\r\n3. Set the login and password in the macros \'{$CLICKHOUSE.USER}\' and \'{$CLICKHOUSE.PASSWORD}\'. If you don\'t need an authentication - remove headers from HTTP-Agent type items.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','95f2053c21094ad4968440b562cc7ea2','CLICKHOUSE BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10324',NULL,'Etcd by HTTP','3','-1','2','','','Etcd by HTTP','0',NULL,'This template is designed to monitor \'etcd\' by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template \'Etcd by HTTP\' — collects metrics by help of the HTTP agent from \'/metrics\' endpoint.\r\n\r\nRefer to the vendor documentation:\r\nhttps://etcd.io/docs/v3.5/op-guide/monitoring/#metrics-endpoint\r\n\r\nFor the users of \'etcd version <= 3.4\':\r\n\r\nIn \'etcd v3.5\' some metrics have been deprecated. See more details on \'Upgrade etcd from 3.4 to 3.5\':\r\nhttps://etcd.io/docs/v3.4/upgrades/upgrade_3_5/\r\nPlease upgrade your \'etcd\' instance, or use older \'Etcd by HTTP\' template version.\r\n\r\nSetup:\r\n\r\n1. Make sure that \'etcd\' allows the collection of metrics. You can test it by running:\r\ncurl -L http://localhost:2379/metrics\r\n\r\n2. Check if \'etcd\' is accessible from Zabbix proxy or Zabbix server depending on where you are planning to do the monitoring. To verify it, run:\r\ncurl -L  http://<etcd_node_address>:2379/metrics\r\n\r\n3. Add the template to the \'etcd\' node. Set the hostname or IP address of the \'etcd\' host in the \'{$ETCD.HOST}\' macro. By default, the template uses a client\'s port.\r\nYou can configure metrics endpoint location by adding \'--listen-metrics-urls\' flag.\r\n\r\nFor more details, see the etcd documentation:\r\nhttps://etcd.io/docs/v3.5/op-guide/configuration/#profiling-and-monitoring\r\n\r\nAdditional points to consider:\r\n\r\n- If you have specified a non-standard port for \'etcd\', don\'t forget to change macros: \'{$ETCD.SCHEME}\' and \'{$ETCD.PORT}\'.\r\n- You can set \'{$ETCD.USERNAME}\' and \'{$ETCD.PASSWORD}\' macros in the template to use on a host level if necessary.\r\n- To test availability, run : \'zabbix_get -s etcd-host -k etcd.health\'.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b25b8b517a4743c48037bfa10af3dc3c','ETCD BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10325',NULL,'IIS by Zabbix agent','3','-1','2','','','IIS by Zabbix agent','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c7c7e5dc319b4801982e719beb1c5191','IIS BY ZABBIX AGENT','Zabbix','7.0-3',NULL,'0'),
('10326',NULL,'IIS by Zabbix agent active','3','-1','2','','','IIS by Zabbix agent active','0',NULL,'Get metrics from IIS using Zabbix agent running on Windows.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/401862-discussion-thread-for-official-zabbix-template-internet-information-services\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4677be3e07bf4f3285496f2f4230b928','IIS BY ZABBIX AGENT ACTIVE','Zabbix','7.0-3',NULL,'0'),
('10327',NULL,'MSSQL by ODBC','3','-1','2','','','MSSQL by ODBC','0',NULL,'This template is designed for the effortless deployment of MSSQL monitoring by Zabbix via ODBC and doesn\'t require any external scripts.\r\n\r\nSetup:\r\n\r\n1. Create an MSSQL user for monitoring.\r\n\r\n  View Server State and View Any Definition permissions should be granted to the user.\r\n  Grant this user read permissions to the sysjobschedules, sysjobhistory, and sysjobs tables.\r\n\r\n  For more information, see MSSQL documentation:\r\n  \r\n  - Create a database user: https://docs.microsoft.com/en-us/sql/relational-databases/security/authentication-access/create-a-database-user?view=sql-server-ver16\r\n  \r\n  - GRANT Server Permissions: https://docs.microsoft.com/en-us/sql/t-sql/statements/grant-server-permissions-transact-sql?view=sql-server-ver16\r\n  \r\n  - Configure a User to Create and Manage SQL Server Agent Jobs: https://docs.microsoft.com/en-us/sql/ssms/agent/configure-a-user-to-create-and-manage-sql-server-agent-jobs?view=sql-server-ver16\r\n\r\n2. Set the user name and password in the host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).\r\n\r\n3. Do not forget to install Microsoft ODBC driver on Zabbix server or Zabbix proxy and specify data source name in macro {$MSSQL.DSN}.\r\n  \r\n  See Microsoft documentation for instructions: https://docs.microsoft.com/en-us/sql/connect/odbc/linux-mac/installing-the-microsoft-odbc-driver-for-sql-server?view=sql-server-ver16.\r\n\r\n  Note! Credentials in the odbc.ini do not work for MSSQL.\r\n\r\nThe "Service\'s TCP port state" item uses the {$MSSQL.HOST} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance, change these if necessary. Keep in mind that if dynamic ports are used on the MSSQL server side, this check will not work correctly.\r\n\r\nIf your instance uses a non-default TCP port, set the port in your section of odbc.ini in the line Server = IP or FQDN name, port.\r\n\r\nNote: You can use the context macros {$MSSQL.BACKUP_FULL.USED}, {$MSSQL.BACKUP_LOG.USED}, and {$MSSQL.BACKUP_DIFF.USED} to disable backup age triggers for a certain database. If set to a value other than "1", the trigger expression for the backup age will not fire.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','001a1677f6a949b6bddfdb2926023300','MSSQL BY ODBC','Zabbix','7.0-6',NULL,'0'),
('10328',NULL,'Oracle by ODBC','3','-1','2','','','Oracle by ODBC','0',NULL,'1. Create an Oracle user for monitoring.\r\n\r\n2. Set the hostname or IP address of the Oracle DB instance, user name and password in host macros ({$ORACLE.HOST}, {$ORACLE.USER} and {$ORACLE.PASSWORD}).\r\n  Do not forget to install the Microsoft ODBC driver on the Zabbix server or the Zabbix proxy.\r\n  See Oracle documentation for instructions: https://www.oracle.com/database/technologies/releasenote-odbc-ic.html.\r\n\r\n  Note! Credentials in the odbc.ini do not work for Oracle.\r\n  Note! Be sure that ODBC connects to Oracle with session parameter NLS_NUMERIC_CHARACTERS= \'.,\' It is important for correct display float numbers in Zabbix.\r\nThe "Service\'s TCP port state" item uses {$ORACLE.HOST} and {$ORACLE.PORT} macros to check the availability of the listener.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','00ade9277d7c41e8b57d638b22d54372','ORACLE BY ODBC','Zabbix','7.0-2',NULL,'0'),
('10329',NULL,'PostgreSQL by Zabbix agent 2','3','-1','2','','','PostgreSQL by Zabbix agent 2','0',NULL,'This template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent 2 and uses a loadable plugin to run SQL queries.\r\n\r\nSetup:\r\n\r\n1. Deploy Zabbix agent 2 with the PostgreSQL plugin. Starting with Zabbix versions 6.0.10 / 6.2.4 / 6.4 PostgreSQL metrics are moved to a loadable plugin and require installation of a separate package or compilation of the plugin from sources (https://www.zabbix.com/documentation/7.0/manual/extensions/plugins/build).\r\n\r\n2. Create the PostgreSQL user for monitoring (`<password>` at your discretion) and inherit permissions from the default role `pg_monitor`:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n\r\n3. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).\r\n\r\n4. Set the connection string for the PostgreSQL instance in the `{$PG.CONNSTRING.AGENT2}` macro as URI, such as `<protocol(host:port)>`, or specify the named session - `<sessionname>`.\r\n\r\nNote: if you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, a named session must be used. In that case, the instance URI should be specified in the `Plugins.PostgreSQL.Sessions.*.Uri` parameter in the PostgreSQL plugin configuration files alongside all the encryption parameters (type, certificate/key filepaths if needed etc.).\r\n\r\nYou can check the PostgreSQL plugin documentation (https://git.zabbix.com/projects/AP/repos/postgresql/browse?at=refs%2Fheads%2Frelease%2F7.0) for details about agent plugin parameters and named sessions.\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\nNote that plugin TLS certificate validation relies on checking the Subject Alternative Names (SAN) instead of the Common Name (CN), check the cryptography package documentation (https://pkg.go.dev/crypto/x509) for details.\r\n\r\nFor example, to enable required encryption in transport mode without identity checks you could create the file `/etc/zabbix/zabbix_agent2.d/postgresql_myconn.conf` with the following configuration for the named session `myconn` (replace `<instanceip>` with the address of the PostgreSQL instance):\r\nPlugins.PostgreSQL.Sessions.myconn.Uri=tcp://<instanceip>:5432\r\nPlugins.PostgreSQL.Sessions.myconn.TLSConnect=required\r\n\r\nThen set the `{$PG.CONNSTRING.AGENT2}` macro to `myconn` to use this named session.\r\n\r\n5. Set the password that you specified in step 2 in the macro `{$PG.PASSWORD}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d0ef7d659a8f4beaaabfc4b6134e737a','POSTGRESQL BY ZABBIX AGENT 2','Zabbix','7.0-3',NULL,'0'),
('10330',NULL,'PHP-FPM by Zabbix agent','3','-1','2','','','PHP-FPM by Zabbix agent','0',NULL,'Get PHP-FPM metrics using Zabbix agent running on Linux.\r\n\r\nNote that depending on your OS distribution, the PHP-FPM process name may vary. Please, check the actual name in the line "Name" from /proc/<pid>/status file (https://www.zabbix.com/documentation/7.0/manual/appendix/items/proc_mem_num_notes) and change {$PHP_FPM.PROCESS.NAME.PARAMETER} macro if needed.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1cbda0970410435684135884d0cb7090','PHP-FPM BY ZABBIX AGENT','Zabbix','7.0-1',NULL,'0'),
('10331',NULL,'PHP-FPM by HTTP','3','-1','2','','','PHP-FPM by HTTP','0',NULL,'Get PHP-FPM metrics using the Zabbix HTTP agent.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','49c77ce207f8478da53e761526d6eca5','PHP-FPM BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10333',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','0','1','051a1469d4d045cbbf818fcc843a352e','{#HV.NAME}','','',NULL,'0'),
('10334',NULL,'{#VM.UUID}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','0','1','23b9ae9d6f33414880db1cb107115810','{#VM.NAME}','','',NULL,'0'),
('10335',NULL,'Oracle by Zabbix agent 2','3','-1','2','','','Oracle by Zabbix agent 2','0',NULL,'Get metrics from Oracle Database using Zabbix agent 2.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d670c32f007d438c9dcd32db57d2b691','ORACLE BY ZABBIX AGENT 2','Zabbix','7.0-2',NULL,'0'),
('10336',NULL,'Asterisk by HTTP','3','-1','2','','','Asterisk by HTTP','0',NULL,'The template gets Asterisk metrics from AMI by HTTP agent.\r\nYou should enable the mini-HTTP Server, add the option webenabled=yes in the general section of the manager.conf file and create Asterisk Manager user with system and command write permissions within your Asterisk instance.\r\nDisable the PJSIP driver if you do not use PJSIP or do not have PJSIP endpoints.\r\nPlease, define AMI address in the {$AMI.URL} macro. Also, set the hostname or IP address of the AMI host in the {$AMI.HOST} macro for Zabbix to check Asterisk service status.\r\nThen you can define {$AMI.USERNAME} and {$AMI.SECRET} macros in the template for using on the host level.\r\nIf there are errors, increase the logging to debug level and see the Zabbix server log.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410060-discussion-thread-for-official-zabbix-template-asterisk\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','30cc187a4e994c39b07f53d86b5cc6bc','ASTERISK BY HTTP','Zabbix','7.0-3',NULL,'0'),
('10343',NULL,'Linux by Zabbix agent active','3','-1','2','','','Linux by Zabbix agent active','0',NULL,'This is an official Linux template. It requires Zabbix agent 7.0 or newer.\r\n\r\nNotes on filesystem (FS) discovery:\r\n  - The ext4/3/2 FS reserves space for privileged usage, typically set at 5% by default.\r\n  - BTRFS allocates a default of 10% of the volume for its own needs.\r\n  - To mitigate potential disasters, FS usage triggers are based on the maximum available space.\r\n    - Utilization formula: \'pused = 100 - 100 * (available / total - free + available)\'\r\n  - The FS utilization chart, derived from graph prototypes, reflects FS reserved space as the difference between used and available space from the total volume.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387225-discussion-thread-for-official-zabbix-template-for-linux\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e2307c94f1744af7a8f1f458a67af424','LINUX BY ZABBIX AGENT ACTIVE','Zabbix','7.0-3',NULL,'0'),
('10351',NULL,'Windows by Zabbix agent active','3','-1','2','','','Windows by Zabbix agent active','0',NULL,'This is an official Windows template. It requires Zabbix agent 7.0 or newer.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/387224-discussion-thread-for-official-zabbix-template-for-windows\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5fdd2ca8b8f84962aaea5a218b46ea7d','WINDOWS BY ZABBIX AGENT ACTIVE','Zabbix','7.0-2',NULL,'0'),
('10353',NULL,'Ceph by Zabbix agent 2','3','-1','2','','','Ceph by Zabbix agent 2','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410059-discussion-thread-for-official-zabbix-template-ceph\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','09fb25d089f7467f860895f6e71d3fa2','CEPH BY ZABBIX AGENT 2','Zabbix','7.0-2',NULL,'0'),
('10355',NULL,'Squid by SNMP','3','-1','2','','','Squid by SNMP','0',NULL,'Template for monitoring Squid caching proxy via SNMP\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/409339-discussion-thread-for-official-zabbix-template-squid\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8e5236f799b347a8ae90a979198be85e','SQUID BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10357',NULL,'PostgreSQL by Zabbix agent','3','-1','2','','','PostgreSQL by Zabbix agent','0',NULL,'This template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent and uses user parameters to run SQL queries with the `psql` command-line tool.\r\n\r\nNote:\r\n- The template requires `pg_isready` and `psql` utilities to be installed on the same host with Zabbix agent.\r\n- The template requires files with SQL queries and user parameters that can be found in the Zabbix official repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/db/postgresql?at=refs%2Fheads%2Frelease%2F6.0\r\n\r\nSetup:\r\n\r\n1. Deploy Zabbix agent and create the PostgreSQL user for monitoring (`<password>` at your discretion) with proper access rights to your PostgreSQL instance.\r\n\r\nFor PostgreSQL version 10 and above:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n\r\nFor PostgreSQL version 9.6 and below:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\';\r\nGRANT SELECT ON pg_stat_database TO zbx_monitor;\r\nALTER USER zbx_monitor WITH SUPERUSER;\r\n\r\n2. Copy the `postgresql/` directory to the `zabbix` user home directory - `/var/lib/zabbix/`. The `postgresql/` directory contains the files with SQL queries needed to obtain metrics from PostgreSQL instance.\r\n\r\nIf the home directory of the `zabbix` user doesn\'t exist, create it first:\r\nmkdir -m u=rwx,g=rwx,o= -p /var/lib/zabbix\r\nchown zabbix:zabbix /var/lib/zabbix\r\n\r\n3. Copy the `template_db_postgresql.conf` file, containing user parameters, to the Zabbix agent configuration directory `/etc/zabbix/zabbix_agentd.d/` and restart Zabbix agent service.\r\n\r\nIf you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, you can modify the connection string in user parameters. For example, to enable required encryption in transport mode without identity checks you could append `?sslmode=required` to the end of the connection string for all keys that use `psql`:\r\nUserParameter=pgsql.bgwriter[*], psql -qtAX postgresql://"$3":"$4"@"$1":"$2"/"$5"?sslmode=required -f "/var/lib/zabbix/postgresql/pgsql.bgwriter.sql"\r\n\r\nConsult the PostgreSQL documentation about protection modes (https://www.postgresql.org/docs/current/libpq-ssl.html#LIBPQ-SSL-PROTECTION) and client connection parameters (https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNECT-SSLMODE).\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\n4. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).\r\n\r\n5. Specify the host name or IP address in the `{$PG.HOST}` macro. Adjust the port number with `{$PG.PORT}` macro if needed.\r\n\r\n6. Set the password that you specified in step 1 in the macro `{$PG.PASSWORD}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','399bd1ee587245ecac6f39beaa99886f','POSTGRESQL BY ZABBIX AGENT','Zabbix','7.0-2',NULL,'0'),
('10358',NULL,'Apache ActiveMQ by JMX','3','-1','2','','','Apache ActiveMQ by JMX','0',NULL,'The template to monitor Apache ActiveMQ by Zabbix that work without any external scripts.\r\nThe metrics are collected by JMX.\r\nYou can set macro values and add macros with context for specific brokers or destinations following macro description.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/411049-discussion-thread-for-official-zabbix-template-amq\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c87e0a2e0683483ab7c6f3c380e9f840','APACHE ACTIVEMQ BY JMX','Zabbix','7.0-1',NULL,'0'),
('10359',NULL,'Aranet Cloud','3','-1','2','','','Aranet Cloud','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','af21edc47557400583e537904ea632aa','ARANET CLOUD','Zabbix','7.0-1',NULL,'0'),
('10360',NULL,'Microsoft Exchange Server 2016 by Zabbix agent','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.\r\nThe metrics are collected by Zabbix agent.\r\nRecommended to use it with "OS Windows by Zabbix agent" template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cbf70ed444394566bcf213dd63d4d352','MICROSOFT EXCHANGE SERVER 2016 BY ZABBIX AGENT','Zabbix','7.0-1',NULL,'0'),
('10361',NULL,'Microsoft Exchange Server 2016 by Zabbix agent active','3','-1','2','','','Microsoft Exchange Server 2016 by Zabbix agent active','0',NULL,'The template to monitor Microsoft Exchange Server 2016 by Zabbix that works without any external scripts.\r\nThe metrics are collected by Zabbix agent active.\r\nRecommended to use it with "OS Windows by Zabbix agent active" template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415007-discussion-thread-for-official-zabbix-template-microsoft-exchange\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a0e05ca631034676821b7e0e1ce25488','MICROSOFT EXCHANGE SERVER 2016 BY ZABBIX AGENT ACTIVE','Zabbix','7.0-1',NULL,'0'),
('10362',NULL,'GitLab by HTTP','3','-1','2','','','GitLab by HTTP','0',NULL,'Get GitLab metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nTo access the metrics, the client IP address must be explicitly allowed. See https://docs.gitlab.com/ee/administration/monitoring/ip_whitelist.html.\r\nOr second method, using token variable from http://your.gitlab.address/admin/health_check (fill {$GITLAB.HEALTH.TOKEN} macro with variable path like "?token=your_token").\r\nDon\'t forget change macros {$GITLAB.URL}.\r\nSome metrics may not be collected depending on your Gitlab instance version and configuration. See (Gitlab\'s documentation[)https://docs.gitlab.com/ee/administration/monitoring/prometheus/gitlab_metrics.html] for further information about its metric collection.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f445dac89ff74deabaae9dcb84815998','GITLAB BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10363',NULL,'Hadoop by HTTP','3','-1','2','','','Hadoop by HTTP','0',NULL,'The template gets the Hadoop metrics from cluster\'s hosts (ResourceManager, NodeManagers, NameNode, DataNodes) by HTTP agent. You should define the IP address (or FQDN) and Web-UI port for the ResourceManager in {$HADOOP.RESOURCEMANAGER.HOST} and {$HADOOP.RESOURCEMANAGER.PORT} macros and for the NameNode in {$HADOOP.NAMENODE.HOST} and {$HADOOP.NAMENODE.PORT} macros respectively. Macros can be set in the template or overridden at the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/413459-discussion-thread-for-official-zabbix-template-hadoop\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e129aeba7c814bf189772cf5919b4bbb','HADOOP BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10364',NULL,'Apache Kafka by JMX','3','-1','2','','','Apache Kafka by JMX','0',NULL,'Official JMX Template for Apache Kafka.\r\n  The metrics are collected by JMX.\r\n  You can set {$KAFKA.USER} and {$KAFKA.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2eb43a3c9666467683b9ce09d2bd26d7','APACHE KAFKA BY JMX','Zabbix','7.0-1',NULL,'0'),
('10365',NULL,'HashiCorp Vault by HTTP','3','-1','2','','','HashiCorp Vault by HTTP','0',NULL,'Get HashiCorp Vault metrics from Vault API HTTP Prometheus metrics endpoint.\r\n\r\nSome metrics may not be collected depending on your Vault instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2f82248e411340429d390e8389850401','HASHICORP VAULT BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10366',NULL,'VMware FQDN','3','-1','2','','','VMware FQDN','0',NULL,'You can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nNote: To enable discovery of hardware sensors of VMware Hypervisors, set the macro \'{$VMWARE.HV.SENSOR.DISCOVERY}\' to the value \'true\' on the discovered host level.\r\n\r\nNote: To create custom performance counter see documentation: https://www.zabbix.com/documentation/7.0/manual/vm_monitoring/vmware_keys#footnotes.\r\n\r\nNote: To get all supported counters and generate path for custom performance counter see documentation: https://www.zabbix.com/documentation/7.0/manual/appendix/items/perf_counters.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ca02e82e6c414d0aa7aedc8d78468a49','VMWARE FQDN','Zabbix','7.0-3',NULL,'0'),
('10367',NULL,'{#HV.UUID}','0','-1','2','','','{#HV.NAME}','2',NULL,'','1','1','','','','','0','1','51cf7ea3e6a74f7e8dde628dbc5347a3','{#HV.NAME}','','',NULL,'0'),
('10368',NULL,'{#VM.DNS}','0','-1','2','','','{#VM.NAME}','2',NULL,'','1','1','','','','','0','1','a12e25c500a14fcf99295c207371ca1b','{#VM.NAME}','','',NULL,'0'),
('10369',NULL,'Zookeeper by HTTP','3','-1','2','','','Zookeeper by HTTP','0',NULL,'This template is designed for the effortless deployment of Apache Zookeeper monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nThis template works with standalone and cluster instances. Metrics are collected from each Zookeeper node by requests to AdminServer\r\n\r\nSetup:\r\n\r\n1. Enable the AdminServer and configure the parameters according to the official documentation:\r\nhttps://zookeeper.apache.org/doc/current/zookeeperAdmin.html#sc_adminserver_config\r\n\r\n2. Set the hostname or IP address of the Apache Zookeeper host in the \'{$ZOOKEEPER.HOST}\' macro. You can also change the \'{$ZOOKEEPER.COMMAND_URL}\', \'{$ZOOKEEPER.PORT}\' and \'{$ZOOKEEPER.SCHEME}\' macros if necessary.\r\n\r\nYou can discuss this template or leave feedback on our forum:\r\nhttps://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b606eda347ea4663a33ad4d12a482750','ZOOKEEPER BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10370',NULL,'Apache Cassandra by JMX','3','-1','2','','','Apache Cassandra by JMX','0',NULL,'The template to monitor Apache Cassandra by Zabbix that work without any external scripts.\r\nIt works with both standalone and cluster instances.\r\nThe metrics are collected by JMX.\r\nYou can set {$CASSANDRA.USER} and {$CASSANDRA.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/410057-discussion-thread-for-official-zabbix-template-apache-cassandra\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5c42de26643c4b43b23a11159df021ce','APACHE CASSANDRA BY JMX','Zabbix','7.0-1',NULL,'0'),
('10371',NULL,'Morningstar ProStar MPPT by SNMP','3','-1','2','','','Morningstar ProStar MPPT by SNMP','0',NULL,'MIBs used:\r\nPROSTAR-MPPT\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b84324c2a40a496dbbb379bbf5dde8d5','MORNINGSTAR PROSTAR MPPT BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10372',NULL,'Morningstar ProStar PWM by SNMP','3','-1','2','','','Morningstar ProStar PWM by SNMP','0',NULL,'MIBs used:\r\nPROSTAR-PWM\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','24bed6339f0a492fab86fe757394b937','MORNINGSTAR PROSTAR PWM BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10373',NULL,'Morningstar SunSaver MPPT by SNMP','3','-1','2','','','Morningstar SunSaver MPPT by SNMP','0',NULL,'MIBs used:\r\nSUNSAVER-MPPT\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f1336fd88ab0415a9c02892a71e50032','MORNINGSTAR SUNSAVER MPPT BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10374',NULL,'Morningstar SureSine by SNMP','3','-1','2','','','Morningstar SureSine by SNMP','0',NULL,'MIBs used:\r\nSURESINE\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3bbfe42c78c74f04a2565431fbdd19e2','MORNINGSTAR SURESINE BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10375',NULL,'Morningstar TriStar MPPT 600V by SNMP','3','-1','2','','','Morningstar TriStar MPPT 600V by SNMP','0',NULL,'MIBs used:\r\nTRISTAR-MPPT\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2d20a2fbd540492089fdcafc8feb60e3','MORNINGSTAR TRISTAR MPPT 600V BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10376',NULL,'Morningstar TriStar MPPT by SNMP','3','-1','2','','','Morningstar TriStar MPPT by SNMP','0',NULL,'MIBs used:\r\nTRISTAR-MPPT\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','07b32152c3654e8ead4c1eeae24efa8f','MORNINGSTAR TRISTAR MPPT BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10377',NULL,'Morningstar TriStar PWM by SNMP','3','-1','2','','','Morningstar TriStar PWM by SNMP','0',NULL,'MIBs used:\r\nTRISTAR\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','230fa9f7c1774821bbe6cdcbbba5cbc6','MORNINGSTAR TRISTAR PWM BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10378',NULL,'NetApp FAS3220 by SNMP','3','-1','2','','','NetApp FAS3220 by SNMP','0',NULL,'The template to monitor SAN NetApp FAS3220 cluster by Zabbix SNMP agent.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nNETAPP-MIB\r\nIF-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/416694-discussion-thread-for-official-zabbix-template-netapp-fas3220\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e118ab11c1ec4f9cbe21dfce1441c0f6','NETAPP FAS3220 BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10379',NULL,'Jenkins by HTTP','3','-1','2','','','Jenkins by HTTP','0',NULL,'Get Jenkins metrics by HTTP agent.\r\nMetrics are collected by requests to Metrics API. Install  Metrics plugin and configure access to the Metrics Servlet by issuing API key.\r\nDon\'t forget to change macros {$JENKINS.URL}, {$JENKINS.USER}, {$JENKINS.API.TOKEN}, {$JENKINS.API.KEY}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2ef2f2eb75ee4a0bae839e22aa76e5fc','JENKINS BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10380',NULL,'Hikvision camera by HTTP','3','-1','2','','','Hikvision camera by HTTP','0',NULL,'This template is designed for the effortless deployment of Hikvision cameras monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nSample device overview page:\r\nhttps://www.hikvision.com/en/products/IP-Products/Network-Cameras/\r\n\r\nSetup:\r\n\r\n1. Set the hostname or IP address of the Hikvision ISAPI host in the \'{$HIKVISION_ISAPI_HOST}\' macro.\r\n\r\n2. Set the user name and password in the \'{$PASSWORD}\' and \'{$USER}\' macros.\r\n\r\n3. Change other macros according to your camera configuration if necessary.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3fb4020df2984b0ab64dfd8355ff5c65','HIKVISION CAMERA BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10381',NULL,'Ignite by JMX','3','-1','2','','','Ignite by JMX','0',NULL,'The template to monitor Apache Ignite by Zabbix that work without any external scripts.\r\n  It works with both standalone and cluster instances.\r\n  The metrics are discoverable and collected by JMX.\r\n  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.\r\n  You can set {$IGNITE.USER} and {$IGNITE.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ab05dbb15ff047f192782f617f0627ac','IGNITE BY JMX','Zabbix','7.0-2',NULL,'0'),
('10382',NULL,'Microsoft SharePoint by HTTP','3','-1','2','','','Microsoft SharePoint by HTTP','0',NULL,'Overview:\r\nTemplate receives data via HTTP Agent.\r\nSetup:\r\nCreate a new host.\r\nDefine macros according to your Sharepoint web portal.\r\nIt is recommended to fill in the values of the filter macros to avoid getting redundant data.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8d5fe5b4ebb64255a2429b34c7dd3681','MICROSOFT SHAREPOINT BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10385',NULL,'Huawei OceanStor 5300 V5 by SNMP','3','-1','2','','','Huawei OceanStor 5300 V5 by SNMP','0',NULL,'The template to monitor SAN Huawei OceanStor 5300 V5 by Zabbix SNMP agent.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418855-discussion-thread-for-official-zabbix-template-huawei-oceanstor\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c5564dd58c394b969d5365cc5de3e7f8','HUAWEI OCEANSTOR 5300 V5 BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10386',NULL,'MongoDB node by Zabbix agent 2','3','-1','2','','','MongoDB node by Zabbix agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.\r\n  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.\r\n  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','81aa8c5ab5594f77a2b26fb7f5094048','MONGODB NODE BY ZABBIX AGENT 2','Zabbix','7.0-1',NULL,'0'),
('10387',NULL,'MongoDB cluster by Zabbix agent 2','3','-1','2','','','MongoDB cluster by Zabbix agent 2','0',NULL,'Get MongoDB metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the MongoDB monitoring plugin.\r\n  2. Set the {$MONGODB.CONNSTRING} such as <protocol(host:port)> or named session.\r\n  3. Set the user name and password in host macros ({$MONGODB.USER}, {$MONGODB.PASSWORD}) if you want to override parameters from the Zabbix agent configuration file.\r\n\r\n  All sharded Mongodb nodes (mongod) will be discovered with attached template "MongoDB node".\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420659-discussion-thread-for-official-zabbix-template-db-mongodb\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d38b271797bd41f2ad8c79d83b9d8d9c','MONGODB CLUSTER BY ZABBIX AGENT 2','Zabbix','7.0-1',NULL,'0'),
('10388',NULL,'{#HOSTNAME}','0','-1','2','','','{#HOSTNAME}','2',NULL,'','1','1','','','','','0','0','809db5d8d32a45898e8401f288a42fac','{#HOSTNAME}','','',NULL,'0'),
('10389',NULL,'{#HOSTNAME}','0','-1','2','','','{#HOSTNAME}','2',NULL,'','1','1','','','','','0','0','3fcd3244b1234186bda9a35c8f61c850','{#HOSTNAME}','','',NULL,'0'),
('10390',NULL,'Cisco Catalyst 3750V2-24FS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24FS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24FS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6ff896f545e043cc98de6d98698d41df','CISCO CATALYST 3750V2-24FS BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10391',NULL,'Cisco Catalyst 3750V2-24PS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24PS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24PS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4583f0c3bc894251a6c5e7129cb5b9aa','CISCO CATALYST 3750V2-24PS BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10392',NULL,'Cisco Catalyst 3750V2-24TS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-24TS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-24TS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','30d084c6b7844b7cab6cf820b00bb7b2','CISCO CATALYST 3750V2-24TS BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10393',NULL,'Cisco Catalyst 3750V2-48PS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48PS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48PS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ea096c13a09b4d7a9be0aab1cec95206','CISCO CATALYST 3750V2-48PS BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10394',NULL,'Cisco Catalyst 3750V2-48TS by SNMP','3','-1','2','','','Cisco Catalyst 3750V2-48TS by SNMP','0',NULL,'Template Cisco Catalyst 3750V2-48TS\r\n  \r\n  MIBs used:\r\n  CISCO-MEMORY-POOL-MIB\r\n  IF-MIB\r\n  EtherLike-MIB\r\n  SNMPv2-MIB\r\n  CISCO-PROCESS-MIB\r\n  CISCO-ENVMON-MIB\r\n  ENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f744679600844c07b2b4eedda9bc3d0c','CISCO CATALYST 3750V2-48TS BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10395',NULL,'APC UPS by SNMP','3','-1','2','','','APC UPS by SNMP','0',NULL,'Template Power APC UPS\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3ec55c9966624ef5bc1b50502812d581','APC UPS BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10396',NULL,'NetApp AFF A700 by HTTP','3','-1','2','','','NetApp AFF A700 by HTTP','0',NULL,'The template to monitor SAN NetApp AFF A700 cluster by Zabbix HTTP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','79267c69f54a4e59b4152aba4e8c4bd5','NETAPP AFF A700 BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10397',NULL,'TiDB PD by HTTP','3','-1','2','','','TiDB PD by HTTP','0',NULL,'The template to monitor PD server of TiDB cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\nDon\'t forget to change the macros {$PD.URL}, {$PD.PORT}.\r\n\r\nTemplate `TiDB PD by HTTP` — collects metrics by HTTP agent from PD /metrics endpoint and from monitoring API.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','43596328d4d74a5592906a9e08e3fd96','TIDB PD BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10398',NULL,'TiDB by HTTP','3','-1','2','','','TiDB by HTTP','0',NULL,'The template to monitor TiDB server of TiDB cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\nDon\'t forget to change the macros {$TIDB.URL}, {$TIDB.PORT}.\r\n\r\nTemplate `TiDB by HTTP` — collects metrics by HTTP agent from PD /metrics endpoint and from monitoring API.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ec72ebbe3204d7789429640abcac610','TIDB BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10399',NULL,'TiDB TiKV by HTTP','3','-1','2','','','TiDB TiKV by HTTP','0',NULL,'The template to monitor TiKV server of TiDB cluster by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\nDon\'t forget to change the macros {$TIKV.URL}, {$TIKV.PORT}.\r\n\r\nTemplate `TiDB TiKV by HTTP` — collects metrics by HTTP agent from TiKV /metrics endpoint.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3a0bbbb2ec0a4c58bba3ba3a3d6ce660','TIDB TIKV BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10400',NULL,'APC UPS Galaxy 3500 by SNMP','3','-1','2','','','APC UPS Galaxy 3500 by SNMP','0',NULL,'Template Power APC UPS Galaxy 3500\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5d3971cd973b46e7915d7ae0750bac57','APC UPS GALAXY 3500 BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10401',NULL,'APC Smart-UPS 2200 RM by SNMP','3','-1','2','','','APC Smart-UPS 2200 RM by SNMP','0',NULL,'Template Power APC Smart-UPS 2200 RM\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e8c0b2c40e884f1598d86f3edf020ea7','APC SMART-UPS 2200 RM BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10402',NULL,'APC Smart-UPS 3000 XLM by SNMP','3','-1','2','','','APC Smart-UPS 3000 XLM by SNMP','0',NULL,'Template Power APC Smart-UPS 3000 XLM\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','eafd78764fde4110b9e46ae184f327ba','APC SMART-UPS 3000 XLM BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10403',NULL,'APC Smart-UPS RT 1000 RM XL by SNMP','3','-1','2','','','APC Smart-UPS RT 1000 RM XL by SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 RM XL\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','340ec6917c274ead8fab36925e57f30a','APC SMART-UPS RT 1000 RM XL BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10404',NULL,'APC Smart-UPS RT 1000 XL by SNMP','3','-1','2','','','APC Smart-UPS RT 1000 XL by SNMP','0',NULL,'Template Power APC Smart-UPS RT 1000 XL\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','32d3c78ff44c4c3c9ff5b893ad7f5fc9','APC SMART-UPS RT 1000 XL BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10406',NULL,'APC Smart-UPS SRT 8000 by SNMP','3','-1','2','','','APC Smart-UPS SRT 8000 by SNMP','0',NULL,'Template Power APC Smart-UPS SRT 8000\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b3caafda8c5345cc832ac3be3cefa615','APC SMART-UPS SRT 8000 BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10407',NULL,'APC UPS Symmetra LX by SNMP','3','-1','2','','','APC UPS Symmetra LX by SNMP','0',NULL,'Template Power APC UPS Symmetra LX\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0b9a899ff8f1467c9fdf999d02b9fd77','APC UPS SYMMETRA LX BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10408',NULL,'APC UPS Symmetra RM by SNMP','3','-1','2','','','APC UPS Symmetra RM by SNMP','0',NULL,'Template Power APC UPS Symmetra RM\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1dac0a88c3774315b90622a48031e369','APC UPS SYMMETRA RM BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10409',NULL,'APC UPS Symmetra RX by SNMP','3','-1','2','','','APC UPS Symmetra RX by SNMP','0',NULL,'Template Power APC UPS Symmetra RX\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4ffb0f9103084384a98379ed533865e9','APC UPS SYMMETRA RX BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10410',NULL,'WildFly Domain by JMX','3','-1','2','','','WildFly Domain by JMX','0',NULL,'Official JMX Template for WildFly.\r\nThe metrics are collected by JMX. This template works with Domain Controller.\r\nYou can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4b27e636b6ad4ce68511d344d5604999','WILDFLY DOMAIN BY JMX','Zabbix','7.0-1',NULL,'0'),
('10411',NULL,'WildFly Server by JMX','3','-1','2','','','WildFly Server by JMX','0',NULL,'Official JMX Template for WildFly.\r\nThe metrics are collected by JMX. This template works with standalone and domain instances.\r\nYou can set {$WILDFLY.USER} and {$WILDFLY.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2bf5827343f0420792ad953f290baa05','WILDFLY SERVER BY JMX','Zabbix','7.0-1',NULL,'0'),
('10412',NULL,'APC Smart-UPS SRT 5000 by SNMP','3','-1','2','','','APC Smart-UPS SRT 5000 by SNMP','0',NULL,'Template Power APC Smart-UPS SRT 5000\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nPowerNet-MIB\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/420730-discussion-thread-for-official-zabbix-template-apc-ups\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ec76aeb703747a5affdf435bc12f572','APC SMART-UPS SRT 5000 BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10413',NULL,'Website certificate by Zabbix agent 2','3','-1','2','','','Website certificate by Zabbix agent 2','0',NULL,'The template to monitor TLS/SSL certificate on the website by Zabbix agent 2 that works without any external scripts.\r\n\r\nZabbix agent 2 with the WebCertificate plugin requests certificate using the web.certificate.get key and returns JSON with certificate attributes.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/428309-discussion-thread-for-official-zabbix-template-tls-ssl-certificates-monitoring\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5630ec1b1baf449abe1bc5521f85fe6c','WEBSITE CERTIFICATE BY ZABBIX AGENT 2','Zabbix','7.0-1',NULL,'0'),
('10414',NULL,'Cloudflare by HTTP','3','-1','2','','','Cloudflare by HTTP','0',NULL,'The template to monitor Cloudflare to see your web traffic and DNS metrics.\r\nIt works without any external scripts and uses Script item.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','08ef3d687d754b0aba17e1dcbd77d4bd','CLOUDFLARE BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10415',NULL,'NGINX Plus by HTTP','3','-1','2','','','NGINX Plus by HTTP','0',NULL,'Get Nginx Plus metrics by HTTP agent.\r\nMetrics are collected by requests to Nginx Plus API.\r\nDon\'t forget to change macros {$NGINX.API.ENDPOINT}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cad0f2564694416b60bd8a414948641','NGINX PLUS BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10416',NULL,'Systemd by Zabbix agent 2','3','-1','2','','','Systemd by Zabbix agent 2','0',NULL,'Get systemd units metrics from plugin for the zabbix-agent2.\r\n  1. Setup and configure zabbix-agent2 compiled with the Systemd monitoring plugin.\r\n  2. Set filters with macros if you want to override default filter parameters.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','90ac276995294a6aa88462c032d2ddaf','SYSTEMD BY ZABBIX AGENT 2','Zabbix','7.0-2',NULL,'0'),
('10417',NULL,'GridGain by JMX','3','-1','2','','','GridGain by JMX','0',NULL,'The template to monitor GridGain In-Memory Computing Platform by Zabbix that work without any external scripts.\r\n  It works with both standalone and cluster instances.\r\n  The metrics are discoverable and collected by JMX.\r\n  Current JMX tree hierarchy contains classloader by default. Add the following jvm option `-DIGNITE_MBEAN_APPEND_CLASS_LOADER_ID=false`to will exclude one level with Classloader name.\r\n  You can set {$GRIDGAIN.USER} and {$GRIDGAIN.PASSWORD} macros in the template for using on the host level.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','47d87c39c121429b98a18f641aa443ea','GRIDGAIN BY JMX','Zabbix','7.0-2',NULL,'0'),
('10418',NULL,'Cisco ASAv by SNMP','3','-1','2','','','Cisco ASAv by SNMP','0',NULL,'Template Net Cisco ASAv\r\n\r\nMIBs used:\r\nCISCO-PORT-MIB\r\nCISCO-MEMORY-POOL-MIB\r\nCISCO-REMOTE-ACCESS-MONITOR-MIB\r\nIF-MIB\r\nRFC1213-MIB\r\nCISCO-PROCESS-MIB\r\nENTITY-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','75d009cd4dc84ee7a8fc479fa2fbaeee','CISCO ASAV BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10419',NULL,'F5 Big-IP by SNMP','3','-1','2','','','F5 Big-IP by SNMP','0',NULL,'MIBs used:\r\nRFC1213-MIB\r\nF5-BIGIP-LOCAL-MIB\r\nF5-BIGIP-SYSTEM-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','44c2c2d94a4447c6a924386640e4854a','F5 BIG-IP BY SNMP','Zabbix','7.0-5',NULL,'0'),
('10420',NULL,'ZYXEL AAM1212-51 IES-612 by SNMP','3','-1','2','','','ZYXEL AAM1212-51 IES-612 by SNMP','0',NULL,'ZYXEL AAM1212-51 / IES-612\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IESCOMMON-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL AAM1212-51 / IES-612\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3a71dcdcfe0b4a0e8284d8939d335cce','ZYXEL AAM1212-51 IES-612 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10421',NULL,'ZYXEL ES3500-8PD by SNMP','3','-1','2','','','ZYXEL ES3500-8PD by SNMP','0',NULL,'ZYXEL ES3500-8PD\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-ES3500-8PD-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL ES3500-8PD\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b8a6f34fd5c447b1b9310746a96f4e80','ZYXEL ES3500-8PD BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10422',NULL,'ZYXEL GS-4012F by SNMP','3','-1','2','','','ZYXEL GS-4012F by SNMP','0',NULL,'ZYXEL GS-4012F\r\n\r\nMIBs used:\r\nZYXEL-GS4012F-MIB\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL GS-4012F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','73f123bb9ffe4587a0269c7e8752b2ed','ZYXEL GS-4012F BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10423',NULL,'ZYXEL IES-500x by SNMP','3','-1','2','','','ZYXEL IES-500x by SNMP','0',NULL,'ZYXEL IES-500x\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IES5000-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES-500x\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3db86b0d235e4c7b80f7d6144ca08925','ZYXEL IES-500X BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10424',NULL,'ZYXEL IES-6000 by SNMP','3','-1','2','','','ZYXEL IES-6000 by SNMP','0',NULL,'ZYXEL IES-6000\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IES5000-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES-6000\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3645654baaf04f11927b171bcb048349','ZYXEL IES-6000 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10425',NULL,'ZYXEL IES1248-51 by SNMP','3','-1','2','','','ZYXEL IES1248-51 by SNMP','0',NULL,'ZYXEL IES1248-51\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nADSL-LINE-MIB\r\nZYXEL-IESCOMMON-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL IES1248-51\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8e6d7067cd094e56a52db999b3199edc','ZYXEL IES1248-51 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10426',NULL,'ZYXEL MES-3528 by SNMP','3','-1','2','','','ZYXEL MES-3528 by SNMP','0',NULL,'ZYXEL MES-3528\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-MES3528-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES-3528\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','249de8d8d21e4dda9c3f766ab6201378','ZYXEL MES-3528 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10427',NULL,'ZYXEL MES3500-10 by SNMP','3','-1','2','','','ZYXEL MES3500-10 by SNMP','0',NULL,'ZYXEL MES3500-10\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-MES3500-10-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES3500-10\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','21a95afef0e74fb19691693090403d1d','ZYXEL MES3500-10 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10428',NULL,'ZYXEL MES3500-24 by SNMP','3','-1','2','','','ZYXEL MES3500-24 by SNMP','0',NULL,'ZYXEL MES3500-24\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-MES3500-24-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MES3500-24\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','292970ad91204722b5e5cb3233fc0026','ZYXEL MES3500-24 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10429',NULL,'ZYXEL MGS-3712 by SNMP','3','-1','2','','','ZYXEL MGS-3712 by SNMP','0',NULL,'ZYXEL MGS-3712\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-MGS3712F-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS-3712\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ea7299983f24d0a913606e334f0e526','ZYXEL MGS-3712 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10430',NULL,'ZYXEL MGS-3712F by SNMP','3','-1','2','','','ZYXEL MGS-3712F by SNMP','0',NULL,'ZYXEL MGS-3712F\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-MGS3712F-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS-3712F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','01deb47efa1f4a9092de67fd61820a7d','ZYXEL MGS-3712F BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10431',NULL,'ZYXEL MES3500-24S by SNMP','3','-1','2','','','ZYXEL MES3500-24S by SNMP','0',NULL,'ZYXEL MES3500-24S\r\n\r\nMIBs used:\r\nZYXEL-TRANSCEIVER-MIB\r\nIF-MIB\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-HW-MONITOR-MIB\r\nZYXEL-PORT-MIB\r\nZYXEL-ES-COMMON\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS3520-28\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','89eef2fe23964f44bf9aec6d00e39efd','ZYXEL MES3500-24S BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10432',NULL,'ZYXEL MGS3520-28x by SNMP','3','-1','2','','','ZYXEL MGS3520-28x by SNMP','0',NULL,'ZYXEL MGS3520-28x\r\n\r\nMIBs used:\r\nZYXEL-TRANSCEIVER-MIB\r\nIF-MIB\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-HW-MONITOR-MIB\r\nZYXEL-PORT-MIB\r\nZYXEL-ES-COMMON\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL MGS3520-28\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9cc843a085bb4ee5af0dc4d764a7eee9','ZYXEL MGS3520-28X BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10433',NULL,'ZYXEL XGS-4728F by SNMP','3','-1','2','','','ZYXEL XGS-4728F by SNMP','0',NULL,'ZYXEL XGS-4728F\r\n\r\nMIBs used:\r\nRFC1213-MIB\r\nHOST-RESOURCES-MIB\r\nZYXEL-XGS4728F-MIB\r\nIF-MIB\r\n\r\nKnown Issues:\r\n\r\n  Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.\r\n  Version: all versions firmware\r\n  Device: ZYXEL XGS-4728F\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ab18a5665b7d4bed876881b5c4e8ce51','ZYXEL XGS-4728F BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10434',NULL,'Cisco UCS Manager by SNMP','3','-1','2','','','Cisco UCS Manager by SNMP','0',NULL,'This is a template for Cisco UCS Manager monitoring via Zabbix SNMP Agent that works without any external scripts.\r\n\r\n\r\nMIBs used:\r\nCISCO-UNIFIED-COMPUTING-COMPUTE-MIB\r\nCISCO-UNIFIED-COMPUTING-EQUIPMENT-MIB\r\nIF-MIB\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nCISCO-UNIFIED-COMPUTING-PROCESSOR-MIB\r\nCISCO-UNIFIED-COMPUTING-STORAGE-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d5eb4ce08a334098a85e6e02c534be90','CISCO UCS MANAGER BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10435',NULL,'DELL PowerEdge R720 by HTTP','3','-1','2','','','DELL PowerEdge R720 by HTTP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9643f22821104f809e2486be83e1816e','DELL POWEREDGE R720 BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10436',NULL,'DELL PowerEdge R720 by SNMP','3','-1','2','','','DELL PowerEdge R720 by SNMP','0',NULL,'Template for DELL PowerEdge R720 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fe5b8448661f41b9a6d948fccd7f9045','DELL POWEREDGE R720 BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10437',NULL,'DELL PowerEdge R740 by HTTP','3','-1','2','','','DELL PowerEdge R740 by HTTP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3f707f39c32a4b6e8b214c38a260f6f9','DELL POWEREDGE R740 BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10438',NULL,'DELL PowerEdge R740 by SNMP','3','-1','2','','','DELL PowerEdge R740 by SNMP','0',NULL,'Template for DELL PowerEdge R740 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9fde0e1c36f8453da72f97535d4e74ca','DELL POWEREDGE R740 BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10439',NULL,'DELL PowerEdge R820 by HTTP','3','-1','2','','','DELL PowerEdge R820 by HTTP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1e9fe6b88c7542638c0f5d94484858b2','DELL POWEREDGE R820 BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10440',NULL,'DELL PowerEdge R820 by SNMP','3','-1','2','','','DELL PowerEdge R820 by SNMP','0',NULL,'Template for DELL PowerEdge R820 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d41c5d0fa91545d68cced1b5dabe4bf1','DELL POWEREDGE R820 BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10441',NULL,'DELL PowerEdge R840 by HTTP','3','-1','2','','','DELL PowerEdge R840 by HTTP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','20147f00f92d4240aab0b70cf578c022','DELL POWEREDGE R840 BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10442',NULL,'DELL PowerEdge R840 by SNMP','3','-1','2','','','DELL PowerEdge R840 by SNMP','0',NULL,'Template for DELL PowerEdge R840 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fc834b8da8864678b55557e9a237eac9','DELL POWEREDGE R840 BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10443',NULL,'HPE ProLiant BL460 by SNMP','3','-1','2','','','HPE ProLiant BL460 by SNMP','0',NULL,'Template for HPE ProLiant BL460 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','172ec7e51f1c4a6ba49baffbab3dda97','HPE PROLIANT BL460 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10444',NULL,'HPE ProLiant BL920 by SNMP','3','-1','2','','','HPE ProLiant BL920 by SNMP','0',NULL,'Template for HPE ProLiant BL920 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','586119e5e27e4062a3cce8601ecb8d71','HPE PROLIANT BL920 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10445',NULL,'HPE ProLiant DL360 by SNMP','3','-1','2','','','HPE ProLiant DL360 by SNMP','0',NULL,'Template for HPE ProLiant DL360 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','60cb9ccb922e4fd194a1d9573db10237','HPE PROLIANT DL360 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10446',NULL,'HPE ProLiant DL380 by SNMP','3','-1','2','','','HPE ProLiant DL380 by SNMP','0',NULL,'Template for HPE ProLiant DL380 servers with HP iLO version 4 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCPQHLTH-MIB\r\nSNMPv2-MIB\r\nCPQNIC-MIB\r\nCPQSINFO-MIB\r\nCPQIDA-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','379aaf7e87574debb4f5c3947a22ec68','HPE PROLIANT DL380 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10447',NULL,'Travis CI by HTTP','3','-1','2','','','Travis CI by HTTP','0',NULL,'Template for monitoring Travis CI https://travis-ci.com\r\nYou must set {$TRAVIS.API.TOKEN} and {$TRAVIS.API.URL} macros.\r\n  {$TRAVIS.API.TOKEN} is a Travis API authentication token located in User -> Settings -> API authentication.\r\n  {$TRAVIS.API.URL} could be in 2 different variations:\r\n   - for a private project : api.travis-ci.com\r\n   - for an enterprise projects: api.example.com (where you replace example.com with the domain Travis CI is running on)\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cdbe00a2a3046ee962d28d32567968a','TRAVIS CI BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10448',NULL,'InfluxDB by HTTP','3','-1','2','','','InfluxDB by HTTP','0',NULL,'Get InfluxDB metrics by HTTP agent from Prometheus metrics endpoint.\r\nFor organization discovery template need to use Authorization via API token. See docs: https://docs.influxdata.com/influxdb/v2.0/security/tokens/\r\n\r\nDon\'t forget change macros {$INFLUXDB.URL}, {$INFLUXDB.API.TOKEN}.\r\nSome metrics may not be collected depending on your InfluxDB instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a6fe3640b23544e7ae15d438b38ce1cd','INFLUXDB BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10449',NULL,'MikroTik CCR1009-7G-1C-1SPC by SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-1S+PC by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-1S+PC.\r\n\r\n7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet), 1xSFP+ cage, 9\r\ncores x 1GHz CPU, 2GB RAM, LCD panel, passive cooling desktop enclosure, SmartCard\r\nslot, RouterOS L6, PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d596d6d231bf49c08890aa3ff135ecc6','MIKROTIK CCR1009-7G-1C-1S+PC BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10450',NULL,'MikroTik CCR1009-7G-1C-1S by SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-1S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-1S+.\r\n\r\n1U rackmount, 7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet),\r\n1xSFP+ cage, 9 cores x 1.2GHz CPU, 2GB RAM, LCD panel, Dual Power supplies,\r\nSmartCard slot, RouterOS L6\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a809695fbc784b75adcd4833c86bca8d','MIKROTIK CCR1009-7G-1C-1S+ BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10451',NULL,'MikroTik CCR1009-7G-1C-PC by SNMP','3','-1','2','','','MikroTik CCR1009-7G-1C-PC by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1009-7G-1C-PC.\r\n\r\n7x Gigabit Ethernet, 1x Combo port (SFP or Gigabit Ethernet), 9 cores x 1GHz\r\nCPU, 1GB RAM, passive cooling case, RouterOS L6\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','012e7043ff9849e197c42bf41cdf4d9a','MIKROTIK CCR1009-7G-1C-PC BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10452',NULL,'MikroTik CCR1016-12G by SNMP','3','-1','2','','','MikroTik CCR1016-12G by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1016-12G.\r\n\r\n1U rackmount, 12x Gigabit Ethernet, LCD, 16 cores x 1.2GHz CPU, 2GB RAM, 17.8mpps\r\nfastpath, Up to 12Gbit/s throughput, RouterOS L6, Dual PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5ed19d1f74224588bf5f53ac47003acc','MIKROTIK CCR1016-12G BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10453',NULL,'MikroTik CCR1016-12S-1S by SNMP','3','-1','2','','','MikroTik CCR1016-12S-1S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1016-12S-1S+.\r\n\r\n1U rackmount, 12xSFP cage, 1xSFP+ cage, 16 cores x 1.2GHz CPU, 2GB RAM, LCD\r\npanel, Dual Power supplies, RouterOS L6\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','654910b270d9464f863ed085ba7302ce','MIKROTIK CCR1016-12S-1S+ BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10454',NULL,'MikroTik CCR1036-12G-4S-EM by SNMP','3','-1','2','','','MikroTik CCR1036-12G-4S-EM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-12G-4S-EM.\r\n\r\n1U rackmount, 12x Gigabit Ethernet, 4xSFP cages, LCD, 36 cores x 1.2GHz CPU,\r\n8GB RAM, 24 mpps fastpath, Up to 16Gbit/s throughput, RouterOS L6, Dual PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','930c0e0534a9424fb01f2b6218d8ce59','MIKROTIK CCR1036-12G-4S-EM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10455',NULL,'MikroTik CCR1036-12G-4S by SNMP','3','-1','2','','','MikroTik CCR1036-12G-4S by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-12G-4S.\r\n\r\n1U rackmount, 12x Gigabit Ethernet, 4xSFP cages, LCD, 36 cores x 1.2GHz CPU,\r\n4GB RAM, 24 mpps fastpath, Up to 16Gbit/s throughput, RouterOS L6, Dual PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','82b428ad78d34988b93f3d577f2b6adc','MIKROTIK CCR1036-12G-4S BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10456',NULL,'MikroTik CCR1036-8G-2SEM by SNMP','3','-1','2','','','MikroTik CCR1036-8G-2S+EM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-8G-2S+EM.\r\n\r\n1U rackmount, 8x Gigabit Ethernet, 2xSFP+ cages, LCD, 36 cores x 1.2GHz CPU,\r\n8GB RAM, 41.5mpps fastpath, Up to 28Gbit/s throughput, RouterOS L6, Dual PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7b3ecb24366f4685970df8e1143323f0','MIKROTIK CCR1036-8G-2S+EM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10457',NULL,'MikroTik CCR1036-8G-2S by SNMP','3','-1','2','','','MikroTik CCR1036-8G-2S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1036-8G-2S+.\r\n\r\n1U rackmount, 8x Gigabit Ethernet, 2xSFP+ cages, LCD, 36 cores x 1.2GHz CPU,\r\n4GB RAM, 41.5mpps fastpath, Up to 28Gbit/s throughput, RouterOS L6, Dual PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7f44e67e3f564ec9894c9142d7276553','MIKROTIK CCR1036-8G-2S+ BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10458',NULL,'MikroTik CCR1072-1G-8S by SNMP','3','-1','2','','','MikroTik CCR1072-1G-8S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR1072-1G-8S+.\r\n\r\n1U rackmount, 1x Gigabit Ethernet, 8xSFP+ cages, LCD, 72 cores x 1GHz CPU, 16GB\r\nRAM, up to 120 million packets per second, 80Gbps throughput, RouterOS L6\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e7894db1c4c94e0f8715977e751368b3','MIKROTIK CCR1072-1G-8S+ BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10459',NULL,'MikroTik CCR2004-16G-2S by SNMP','3','-1','2','','','MikroTik CCR2004-16G-2S+ by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR2004-16G-2S+.\r\n\r\nThis powerful and affordable router crushes all previous CCR models in single-core\r\nperformance. 16x Gigabit Ethernet ports, 2x10G SFP+ cages, active cooling and\r\nthe best single-core performance per watt & best overall performance per watt\r\namong all the CCR devices.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ab871d051e304f83950171c5243aa4db','MIKROTIK CCR2004-16G-2S+ BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10460',NULL,'MikroTik CCR2004-1G-12S2XS by SNMP','3','-1','2','','','MikroTik CCR2004-1G-12S+2XS by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik CCR2004-1G-12S+2XS.\r\n\r\nThe Connectivity Router - your best companion when it comes to SFP, SFP+ and\r\nSFP28 management! 1, 10 and 25 Gbps ports in a single device to make your life\r\neasier.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f2efeb94f4bd4ed9ab34a973c0363eb8','MIKROTIK CCR2004-1G-12S+2XS BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10461',NULL,'MikroTik CRS106-1C-5S by SNMP','3','-1','2','','','MikroTik CRS106-1C-5S by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS106-1C-5S.\r\n\r\nSmart Switch, 5x SFP cages, 1x Combo port (SFP or Gigabit Ethernet), 400MHz\r\nCPU, 128MB RAM, desktop case, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','20ea139663264c21bca0dcecf2e95589','MIKROTIK CRS106-1C-5S BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10462',NULL,'MikroTik CRS109-8G-1S-2HnD-IN by SNMP','3','-1','2','','','MikroTik CRS109-8G-1S-2HnD-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS109-8G-1S-2HnD-IN.\r\n\r\n8x Gigabit Smart Switch, 1x SFP cage, LCD, 802.11b/g/n Dual Chain wireless,\r\n600MHz CPU, 128MB RAM, Metal desktop case, RouterOS L5, supports 10-57V, 802.3af/at\r\ncompliant\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fac16383680c4454be48b6db870d975e','MIKROTIK CRS109-8G-1S-2HND-IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10463',NULL,'MikroTik CRS112-8G-4S-IN by SNMP','3','-1','2','','','MikroTik CRS112-8G-4S-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS112-8G-4S-IN.\r\n\r\n8x Gigabit Ethernet Smart Switch, 4x SFP cages, 400MHz CPU, 128MB RAM, desktop\r\ncase, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8d7d49fd0b3f4b1f9046dc0e94457931','MIKROTIK CRS112-8G-4S-IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10464',NULL,'MikroTik CRS112-8P-4S-IN by SNMP','3','-1','2','','','MikroTik CRS112-8P-4S-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS112-8P-4S-IN.\r\n\r\n8x Gigabit Ethernet Smart Switch with PoE-out, 4x SFP cages, 400MHz CPU, 128MB\r\nRAM, desktop case, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','538ec67ce01341a9b281dbd86d86d2a2','MIKROTIK CRS112-8P-4S-IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10465',NULL,'MikroTik CRS125-24G-1S-2HnD-IN by SNMP','3','-1','2','','','MikroTik CRS125-24G-1S-2HnD-IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS125-24G-1S-2HnD-IN.\r\n\r\n24x Gigabit Ethernet layer 3 Smart Switch, 1x SFP cage, LCD, 802.11b/g/n Dual\r\nChain wireless, 600MHz CPU, 128MB RAM, Metal desktop case, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c8db153405704d859ba5ee19f08b46f3','MIKROTIK CRS125-24G-1S-2HND-IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10466',NULL,'MikroTik CRS212-1G-10S-1SIN by SNMP','3','-1','2','','','MikroTik CRS212-1G-10S-1S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS212-1G-10S-1S+IN.\r\n\r\nSmart Switch, 1x Gigabit LAN, 10x SFP cages, 1x SFP+ cage, LCD, 400MHz CPU,\r\n64MB RAM, Metal desktop case, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cdb6ebceb1174bada392dd24889b14d9','MIKROTIK CRS212-1G-10S-1S+IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10467',NULL,'MikroTik CRS305-1G-4SIN by SNMP','3','-1','2','','','MikroTik CRS305-1G-4S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS305-1G-4S+IN.\r\n\r\nFive-port desktop switch with one Gigabit Ethernet port and four SFP+ 10Gbps\r\nports\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','223101f878704022a04c30c3ff066e3f','MIKROTIK CRS305-1G-4S+IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10468',NULL,'MikroTik CRS309-1G-8SIN by SNMP','3','-1','2','','','MikroTik CRS309-1G-8S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS309-1G-8S+IN.\r\n\r\nDesktop switch with one Gigabit Ethernet port and eight SFP+ 10Gbps ports\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','bcc01f2b466345c4bcbe0cea1a7884d1','MIKROTIK CRS309-1G-8S+IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10469',NULL,'MikroTik CRS312-4C8XG-RM by SNMP','3','-1','2','','','MikroTik CRS312-4C+8XG-RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS312-4C+8XG-RM.\r\n\r\nSwitch of the future: the first MikroTik product with 10G RJ45 Ethernet ports\r\nand SFP+\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8da94e2f01ff46e28becf0b08ff09ace','MIKROTIK CRS312-4C+8XG-RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10470',NULL,'MikroTik CRS317-1G-16SRM by SNMP','3','-1','2','','','MikroTik CRS317-1G-16S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS317-1G-16S+RM.\r\n\r\nSmart Switch, 1 x Gigabit LAN, 16 x SFP+ cages, Dual Core 800MHz CPU, 1GB RAM,\r\n1U rackmount passive cooling case, Dual Power Supplies\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f474ff823fe84d689b9e4c6a4f0ce59e','MIKROTIK CRS317-1G-16S+RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10471',NULL,'MikroTik CRS326-24G-2SIN by SNMP','3','-1','2','','','MikroTik CRS326-24G-2S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24G-2S+IN.\r\n\r\n24 Gigabit ports, 2 SFP+ cages and a desktop case – server room power for your\r\nhome!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c5f41fe0f54f470f9e304384838f150a','MIKROTIK CRS326-24G-2S+IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10472',NULL,'MikroTik CRS326-24G-2SRM by SNMP','3','-1','2','','','MikroTik CRS326-24G-2S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24G-2S+RM.\r\n\r\n24 Gigabit port switch with 2 x SFP+ cages in 1U rackmount case, Dual boot (RouterOS\r\nor SwitchOS)\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','bc80883918ac4f879427ca145122b5cb','MIKROTIK CRS326-24G-2S+RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10473',NULL,'MikroTik CRS326-24S2QRM by SNMP','3','-1','2','','','MikroTik CRS326-24S+2Q+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS326-24S+2Q+RM.\r\n\r\nOur fastest switch for the most demanding setups\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e7ed0e0cbd0b439394f6498ea90dc31d','MIKROTIK CRS326-24S+2Q+RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10474',NULL,'MikroTik CRS328-24P-4SRM by SNMP','3','-1','2','','','MikroTik CRS328-24P-4S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS328-24P-4S+RM.\r\n\r\n24 port Gigabit Ethernet router/switch with four 10Gbps SFP+ ports in 1U rackmount\r\ncase, Dual Boot and PoE output, 500W\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','dcf88bca5aaf4123a10eb3daab28a9af','MIKROTIK CRS328-24P-4S+RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10475',NULL,'MikroTik CRS328-4C-20S-4SRM by SNMP','3','-1','2','','','MikroTik CRS328-4C-20S-4S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS328-4C-20S-4S+RM.\r\n\r\nSmart Switch, 20 x SFP cages, 4 x SFP+ cages, 4 x Combo ports (Gigabit Ethernet\r\nor SFP), 800MHz CPU, 512MB RAM, 1U rackmount case, Dual Power Supplies, RouterOS\r\nL5 or SwitchOS (Dual Boot)\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6742f5ed33ca4c19b8e61203770e5fe5','MIKROTIK CRS328-4C-20S-4S+RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10476',NULL,'MikroTik CRS354-48G-4S2QRM by SNMP','3','-1','2','','','MikroTik CRS354-48G-4S+2Q+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS354-48G-4S+2Q+RM.\r\n\r\nBest price and best performance on the market – this 48 port switch will rock\r\nany setup, including 40 Gbps devices!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d1c1ab5db2c34c17ae3541407f8b7faa','MIKROTIK CRS354-48G-4S+2Q+RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10477',NULL,'MikroTik CRS354-48P-4S2QRM by SNMP','3','-1','2','','','MikroTik CRS354-48P-4S+2Q+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CRS354-48P-4S+2Q+RM.\r\n\r\nThe 48 port champion you’ve been waiting for - now with PoE-out!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fa5e5e131eb34bbea1b1f7b2352a853d','MIKROTIK CRS354-48P-4S+2Q+RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10478',NULL,'MikroTik CSS326-24G-2SRM by SNMP','3','-1','2','','','MikroTik CSS326-24G-2S+RM by SNMP','0',NULL,'The template for monitoring Switch MikroTik CSS326-24G-2S+RM.\r\n\r\nSwOS powered 24 port Gigabit Ethernet switch with two SFP+ ports in 1U rackmount\r\ncase\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','75ada0d6fb22416a9e6e5f44c2c3f64a','MIKROTIK CSS326-24G-2S+RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10479',NULL,'MikroTik CSS610-8G-2SIN by SNMP','3','-1','2','','','MikroTik CSS610-8G-2S+IN by SNMP','0',NULL,'The template for monitoring Switch MikroTik CSS610-8G-2S+IN.\r\n\r\nEight 1G Ethernet ports and two SFP+ ports for 10G fiber connectivity. Portable,\r\npowerful and extremely cost-effective - this switch is an instant classic!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8d22b4d1a9c6457fbd6fd959263f91db','MIKROTIK CSS610-8G-2S+IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10480',NULL,'MikroTik FiberBox by SNMP','3','-1','2','','','MikroTik FiberBox by SNMP','0',NULL,'The template for monitoring Switch MikroTik FiberBox.\r\n\r\nAn outdoor switch with five SFP ports\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2bd6f566391d49dab6bee184522ab5fa','MIKROTIK FIBERBOX BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10481',NULL,'MikroTik PowerBox Pro by SNMP','3','-1','2','','','MikroTik PowerBox Pro by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik PowerBox Pro.\r\n\r\nFive Gigabit Ethernet Router with 4xPoE-out ports, SFP cage and outdoor enclosure\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c03e1ab0128a4ae1847bc04a34f5634e','MIKROTIK POWERBOX PRO BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10482',NULL,'MikroTik PowerBox by SNMP','3','-1','2','','','MikroTik PowerBox by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik PowerBox.\r\n\r\n650MHz CPU, 64MB RAM, 5xEthernet with PoE output for four ports, RouterOS L4,\r\noutdoor case, PSU\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0c7b3c03a5854f868b56f3ab63e2d3f7','MIKROTIK POWERBOX BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10483',NULL,'MikroTik RB1100AHx4 Dude Edition by SNMP','3','-1','2','','','MikroTik RB1100AHx4 Dude Edition by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB1100AHx4 Dude Edition.\r\n\r\nPowerful 1U rackmount router with 13x Gigabit Ethernet ports, 60GB M.2 drive\r\nfor Dude database\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fac50638cb77468598c29a6a47520c24','MIKROTIK RB1100AHX4 DUDE EDITION BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10484',NULL,'MikroTik RB1100AHx4 by SNMP','3','-1','2','','','MikroTik RB1100AHx4 by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB1100AHx4.\r\n\r\nPowerful 1U rackmount router with 13x Gigabit Ethernet ports\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3dfd1a55987848e5aa6ffe92c228f63b','MIKROTIK RB1100AHX4 BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10485',NULL,'MikroTik RB2011UiAS-IN by SNMP','3','-1','2','','','MikroTik RB2011UiAS-IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011UiAS-IN.\r\n\r\nDesktop metal case, 5xEthernet, 5xGigabit Ethernet, USB, LCD, PoE out on port\r\n10, 600MHz CPU, 128MB RAM, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cf537f34600403b9de31d3db4eb2a1d','MIKROTIK RB2011UIAS-IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10486',NULL,'MikroTik RB2011UiAS-RM by SNMP','3','-1','2','','','MikroTik RB2011UiAS-RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011UiAS-RM.\r\n\r\n1U rackmount, 5xEthernet, 5xGigabit Ethernet, USB, LCD, PoE out on port 10,\r\n600MHz CPU, 128MB RAM, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','969cf5dca58f47f0b271ccf62ef79c13','MIKROTIK RB2011UIAS-RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10487',NULL,'MikroTik RB2011iL-IN by SNMP','3','-1','2','','','MikroTik RB2011iL-IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iL-IN.\r\n\r\nDesktop metal case, 5xEthernet, 5xGigabit Ethernet, PoE out on port 10, 600MHz\r\nCPU, 64MB RAM, RouterOS L4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','141438a05f904b518c7d3ddfbbabf91f','MIKROTIK RB2011IL-IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10488',NULL,'MikroTik RB2011iL-RM by SNMP','3','-1','2','','','MikroTik RB2011iL-RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iL-RM.\r\n\r\n1U rackmount, 5xEthernet, 5xGigabit Ethernet, PoE out on port 10, 600MHz CPU,\r\n64MB RAM, RouterOS L4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6d9737c72e5540d39e3553b773a587b1','MIKROTIK RB2011IL-RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10489',NULL,'MikroTik RB2011iLS-IN by SNMP','3','-1','2','','','MikroTik RB2011iLS-IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB2011iLS-IN.\r\n\r\nDesktop metal case, 5xEthernet, 5xGigabit Ethernet, SFP cage, PoE out on port\r\n10, 600MHz CPU, 64MB RAM, RouterOS L4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','318fd61c22fa4f1a92a71376814d6c32','MIKROTIK RB2011ILS-IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10490',NULL,'MikroTik RB260GSP by SNMP','3','-1','2','','','MikroTik RB260GSP by SNMP','0',NULL,'The template for monitoring Switch MikroTik RB260GSP.\r\n\r\n5x Gigabit PoE out Ethernet Smart Switch, SFP cage, plastic case, SwOS\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5331ecc3be9f47d6a8eb0732ae141239','MIKROTIK RB260GSP BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10491',NULL,'MikroTik RB260GS by SNMP','3','-1','2','','','MikroTik RB260GS by SNMP','0',NULL,'The template for monitoring Switch MikroTik RB260GS.\r\n\r\n5x Gigabit Ethernet Smart Switch, SFP cage, plastic case, SwOS\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1a74dd95e7244493a1b13b94fe9dd9e8','MIKROTIK RB260GS BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10492',NULL,'MikroTik RB3011UiAS-RM by SNMP','3','-1','2','','','MikroTik RB3011UiAS-RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB3011UiAS-RM.\r\n\r\n1U rackmount, 10xGigabit Ethernet, SFP, USB 3.0, LCD, PoE out on port 10, 2x1.4GHz\r\nCPU, 1GB RAM, RouterOS L5\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','cc762a057f0f467ab571b6d76a9bb278','MIKROTIK RB3011UIAS-RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10493',NULL,'MikroTik RB4011iGSRM by SNMP','3','-1','2','','','MikroTik RB4011iGS+RM by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB4011iGS+RM.\r\n\r\nPowerful 10xGigabit port router with a Quad-core 1.4Ghz CPU, 1GB RAM, SFP+ 10Gbps\r\ncage and desktop case with rack ears\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','780c4a9a657e42fc83f1ab9a535f5184','MIKROTIK RB4011IGS+RM BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10494',NULL,'MikroTik RB5009UGSIN by SNMP','3','-1','2','','','MikroTik RB5009UG+S+IN by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik RB5009UG+S+IN.\r\n\r\nThe ultimate heavy-duty home lab router with USB 3.0, 1G and 2.5G Ethernet and\r\na 10G SFP+ cage. You can mount four of these new routers in a single 1U rackmount\r\nspace! Unprecedented processing power in such a small form factor.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7b6f7a12a6b449ca926e74c894eca354','MIKROTIK RB5009UG+S+IN BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10495',NULL,'MikroTik hEX PoE lite by SNMP','3','-1','2','','','MikroTik hEX PoE lite by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX PoE lite.\r\n\r\n5xEthernet with PoE output for four ports, USB, 650MHz CPU, 64MB RAM, RouterOS\r\nL4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a5ddacdd5ac64b82bf5183769cc03e8c','MIKROTIK HEX POE LITE BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10496',NULL,'MikroTik hEX PoE by SNMP','3','-1','2','','','MikroTik hEX PoE by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX PoE.\r\n\r\n5x Gigabit Ethernet with PoE output for four ports, SFP, USB, 800MHz CPU, 128MB\r\nRAM, RouterOS L4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ff57532daf924030b364e3b75acb74c4','MIKROTIK HEX POE BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10497',NULL,'MikroTik hEX S by SNMP','3','-1','2','','','MikroTik hEX S by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX S.\r\n\r\n5x Gigabit Ethernet, SFP, Dual Core 880MHz CPU, 256MB RAM, USB, microSD, RouterOS\r\nL4, IPsec hardware encryption support and The Dude server package\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7802db8c2f9c4a7eba7b381b8f3fa5c5','MIKROTIK HEX S BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10498',NULL,'MikroTik hEX lite by SNMP','3','-1','2','','','MikroTik hEX lite by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX lite.\r\n\r\n5x Ethernet, Small plastic case, 850MHz CPU, 64MB RAM, Most affordable MPLS\r\nrouter, RouterOS L4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2785d83763c641a7a7937b516665d93a','MIKROTIK HEX LITE BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10499',NULL,'MikroTik hEX by SNMP','3','-1','2','','','MikroTik hEX by SNMP','0',NULL,'The template for monitoring Ethernet router MikroTik hEX.\r\n\r\n5x Gigabit Ethernet, Dual Core 880MHz CPU, 256MB RAM, USB, microSD, RouterOS\r\nL4\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','68c2034014f24115ae9e910962530472','MIKROTIK HEX BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10500',NULL,'MikroTik netPower 15FR by SNMP','3','-1','2','','','MikroTik netPower 15FR by SNMP','0',NULL,'The template for monitoring Switch MikroTik netPower 15FR.\r\n\r\nAn outdoor 18 port switch with 15 reverse PoE ports and SFP. Cut costs, not\r\nspeed - choose GPEN over GPON!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f1928e12f9554599a9adb516f38b6bf6','MIKROTIK NETPOWER 15FR BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10501',NULL,'MikroTik netPower 16P by SNMP','3','-1','2','','','MikroTik netPower 16P by SNMP','0',NULL,'The template for monitoring Switch MikroTik netPower 16P.\r\n\r\nAn outdoor 18 port switch with 16 Gigabit PoE-out ports and 2 SFP+. Power all\r\nyour access points anywhere!\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b126aaf4499d49d7b4fcee0329b7dea7','MIKROTIK NETPOWER 16P BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10502',NULL,'MikroTik netPower Lite 7R by SNMP','3','-1','2','','','MikroTik netPower Lite 7R by SNMP','0',NULL,'The template for monitoring Switch MikroTik netPower Lite 7R.\r\n\r\nAn outdoor reverse PoE switch with Gigabit Ethernet and 10G SFP+ ports.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nMIKROTIK-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1782caa5bf724f66a23e7dbb96ef7ba2','MIKROTIK NETPOWER LITE 7R BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10503',NULL,'VeloCloud SD-WAN by HTTP','3','-1','2','','','VeloCloud SD-WAN by HTTP','0',NULL,'Template for monitoring VeloCloud SD-WAN https://www.arista.com/en/support/velocloud-resources\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e1ca624566424496bff9d90c261ab37b','VELOCLOUD SD-WAN BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10504',NULL,'Kubernetes API server by HTTP','3','-1','2','','','Kubernetes API server by HTTP','0',NULL,'Get Kubernetes API server metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nDon\'t forget change macros {$KUBE.API.SERVER.URL}, {$KUBE.API.TOKEN}.\r\nSome metrics may not be collected depending on your Kubernetes API server instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','85ce114c802e4e28a5f3597e07d07032','KUBERNETES API SERVER BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10505',NULL,'Kubernetes Controller manager by HTTP','3','-1','2','','','Kubernetes Controller manager by HTTP','0',NULL,'Get Kubernetes Controller manager metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nDon\'t forget change macros {$KUBE.API.SERVER.URL}.\r\nSome metrics may not be collected depending on your Kubernetes Controller manager instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2420a8a4fda74fbc81743aed69fafa3b','KUBERNETES CONTROLLER MANAGER BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10506',NULL,'Kubernetes Kubelet by HTTP','3','-1','2','','','Kubernetes Kubelet by HTTP','0',NULL,'Get Kubernetes kubelet metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nDon\'t forget change macros {$KUBE.KUBELET.URL}, {$KUBE.API.TOKEN}.\r\nSome metrics may not be collected depending on your Kubernetes API server instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e785916967c14544b59c3644c3edda3a','KUBERNETES KUBELET BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10507',NULL,'Kubernetes nodes by HTTP','3','-1','2','','','Kubernetes nodes by HTTP','0',NULL,'Get Kubernetes nodes metrics by HTTP.\r\nMetrics are collected by requests to Kubernetes API.\r\n\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f397be2340734d24bc666102fbe184a5','KUBERNETES NODES BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10509',NULL,'Kubernetes Scheduler by HTTP','3','-1','2','','','Kubernetes Scheduler by HTTP','0',NULL,'Get Kubernetes Scheduler metrics by HTTP agent from Prometheus metrics endpoint.\r\n\r\nDon\'t forget change macros {$KUBE.API.SERVER.URL}.\r\nSome metrics may not be collected depending on your Kubernetes Scheduler instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ece96efdf0a045b99ede7978fa9366d6','KUBERNETES SCHEDULER BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10510',NULL,'Kubernetes cluster state by HTTP','3','-1','2','','','Kubernetes cluster state by HTTP','0',NULL,'Get Kubernetes state metrics by HTTP.\r\nMetrics are collected by requests to Kubernetes API.\r\n\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','07695028a2ba4b66a5414797bec791df','KUBERNETES CLUSTER STATE BY HTTP','Zabbix','7.0-3',NULL,'0'),
('10511',NULL,'API {#NAME}','0','-1','2','','','API {#NAME}','2',NULL,'','1','1','','','','','0','1','a67ac5100e6d499088e4c81856f947fc','API {#NAME}','','',NULL,'0'),
('10512',NULL,'Controller manager {#NAME}','0','-1','2','','','Controller manager {#NAME}','2',NULL,'','1','1','','','','','0','1','9d529f3924fc4831a62fb1eec79b64d7','CONTROLLER MANAGER {#NAME}','','',NULL,'0'),
('10513',NULL,'Scheduler {#NAME}','0','-1','2','','','Scheduler {#NAME}','2',NULL,'','1','1','','','','','0','1','46da4b85c58f4c59825e61778a64a58e','SCHEDULER {#NAME}','','',NULL,'0'),
('10514',NULL,'Kubelet {#NAME}','0','-1','2','','','Kubelet {#NAME}','2',NULL,'','1','1','','','','','0','1','c1c4807f378a47dfa59e9bbc8e43f5e2','KUBELET {#NAME}','','',NULL,'0'),
('10515',NULL,'PFSense by SNMP','3','-1','2','','','PFSense by SNMP','0',NULL,'Template for monitoring pfSense by SNMP\r\nSetup:\r\n  1. Enable SNMP daemon at Services in pfSense web interface https://docs.netgate.com/pfsense/en/latest/services/snmp.html\r\n  2. Setup firewall rule to get access from Zabbix proxy or Zabbix server by SNMP https://docs.netgate.com/pfsense/en/latest/firewall/index.html#managing-firewall-rules\r\n  3. Link template to the host\r\n\r\n\r\nMIBs used:\r\nBEGEMOT-PF-MIB\r\nHOST-RESOURCES-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','16f281aeb8904d3db8b66dda94611fcc','PFSENSE BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10516',NULL,'OpenWeatherMap by HTTP','3','-1','2','','','OpenWeatherMap by HTTP','0',NULL,'Get weather metrics from OpenWeatherMap current weather API by HTTP.\r\nIt works without any external scripts and uses the Script item.\r\n\r\nSetup:\r\n  1. Create a host.\r\n\r\n  2. Link the template to the host.\r\n\r\n  3. Customize the values of {$OPENWEATHERMAP.API.TOKEN} and {$LOCATION} macros.  \r\n      OpenWeatherMap API Tokens are available in your OpenWeatherMap account https://home.openweathermap.org/api_keys.  \r\n      Locations can be set by few ways:\r\n        - by geo coordinates (for example: 56.95,24.0833)\r\n        - by location name (for example: Riga)\r\n        - by location ID. Link to the list of city ID: http://bulk.openweathermap.org/sample/city.list.json.gz\r\n        - by zip/post code with a country code (for example: 94040,us)\r\n      A few locations can be added to the macro at the same time by "|" delimiter. \r\n      For example: 43.81821,7.76115|Riga|2643743|94040,us.\r\n      Please note that API requests by city name, zip-codes and city id will be deprecated soon.\r\n      \r\n      Language and units macros can be customized too if necessary.\r\n      List of available languages: https://openweathermap.org/current#multi.\r\n      Available units of measurement are: standard, metric and imperial https://openweathermap.org/current#data.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8098b3c157ab456abd55d3840eef79c1','OPENWEATHERMAP BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10517',NULL,'Proxmox VE by HTTP','3','-1','2','','','Proxmox VE by HTTP','0',NULL,'This template is designed for the effortless deployment of Proxmox VE monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nProxmox VE uses a REST like API. The concept is described in Resource Oriented Architecture (ROA).\r\n\r\nCheck the API documentation for details:\r\nhttps://pve.proxmox.com/pve-docs/api-viewer/index.html\r\n\r\nSetup:\r\n\r\n1. Create an API token for the monitoring user. Important note: for security reasons, it is recommended to create a separate user (Datacenter - Permissions).\r\n\r\nPlease provide the necessary access levels for both the User and the Token:\r\n\r\n* Check: ["perm","/",["Sys.Audit"]]\r\n* Check: ["perm","/storage",["Datastore.Audit"]]\r\n* Check: ["perm","/vms",["VM.Audit"]]\r\n\r\n2. Copy the resulting Token ID and Secret into the host macros \'{$PVE.TOKEN.ID}\' and \'{$PVE.TOKEN.SECRET}\'.\r\n\r\n3. Set the hostname or IP address of the Proxmox VE API host in the \'{$PVE.URL.HOST}\' macro. You can also change the API port in the \'{$PVE.URL.PORT}\' macro if necessary.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4958b76448d74ff1b6d7d6280449beee','PROXMOX VE BY HTTP','Zabbix','7.0-3',NULL,'0'),
('10518',NULL,'TrueNAS CORE by SNMP','3','-1','2','','','TrueNAS CORE by SNMP','0',NULL,'Template for monitoring TrueNAS CORE by SNMP.\r\n\r\nSetup:\r\n1. Import the template into Zabbix.\r\n2. Enable SNMP daemon at Services in TrueNAS CORE web interface: https://www.truenas.com/docs/core/uireference/services/snmpscreen/\r\n3. Link the template to the host.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\nUCD-DISKIO-MIB\r\nUCD-SNMP-MIB\r\nFREENAS-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','28e31ef9402d4c1ba2fbc730a288d2d8','TRUENAS CORE BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10519',NULL,'CockroachDB by HTTP','3','-1','2','','','CockroachDB by HTTP','0',NULL,'The template to monitor CockroachDB nodes by Zabbix that works without any external scripts.\r\nMost of the metrics are collected in one go, thanks to Zabbix bulk data collection.\r\n\r\nThe template collects metrics by HTTP agent from Prometheus endpoint and health endpoints.\r\n\r\nInternal node metrics are collected from Prometheus /_status/vars endpoint.\r\nNode health metrics are collected from /health and /health?ready=1 endpoints.\r\nThe template doesn\'t require usage of session token.\r\n\r\nNote, that some metrics may not be collected depending on your CockroachDB version and configuration.\r\n\r\nSetup:\r\n\r\nSet the hostname or IP address of the CockroachDB node host in the \'{$COCKROACHDB.API.HOST}\' macro. You can also change the port in the \'{$COCKROACHDB.API.PORT}\' macro and the scheme in the \'{$COCKROACHDB.API.SCHEME}\' macro if necessary.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','36116d8675da47b8a678193969d5a787','COCKROACHDB BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10520',NULL,'Envoy Proxy by HTTP','3','-1','2','','','Envoy Proxy by HTTP','0',NULL,'Get Envoy Proxy metrics by HTTP agent from metrics endpoint.\r\nhttps://www.envoyproxy.io/docs/envoy/v1.20.0/operations/stats_overview\r\n\r\nDon\'t forget to change macros {$ENVOY.URL}, {$ENVOY.METRICS.PATH}.\r\nSome metrics may not be collected depending on your Envoy Proxy instance version and configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0368ca599bbb49729587b9c43ac83084','ENVOY PROXY BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10521',NULL,'HashiCorp Consul Node by HTTP','3','-1','2','','','HashiCorp Consul Node by HTTP','0',NULL,'Get HashiCorp Consul Node metrics by HTTP agent from metrics endpoint.\r\n\r\nDon\'t forget to change macros {$CONSUL.NODE.API.URL}, {$CONSUL.TOKEN}.\r\nSome metrics may not be collected depending on your HashiCorp Consul instance version and configuration.\r\nMore information about metrics you can find in official documentation: https://www.consul.io/docs/agent/telemetry\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','884bdbeea93c4be0a11a2c92a5f8adce','HASHICORP CONSUL NODE BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10522',NULL,'HashiCorp Consul Cluster by HTTP','3','-1','2','','','HashiCorp Consul Cluster by HTTP','0',NULL,'Get HashiCorp Consul Cluster services and nodes by HTTP agent from API endpoints.\r\n\r\nDon\'t forget to change macros {$CONSUL.CLUSTER.URL}, {$CONSUL.TOKEN}.\r\nSome metrics may not be collected depending on your HashiCorp Consul instance version and configuration.\r\nMore information about metrics you can find in official documentation: https://www.consul.io/docs/agent/telemetry\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3db29bb6b2b14fa289ba7915264efcdf','HASHICORP CONSUL CLUSTER BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10523',NULL,'Consul {#NODE_NAME}','0','-1','2','','','Consul {#NODE_NAME}','2',NULL,'','1','1','','','','','0','1','20efdd208e1548a7877a970e1600e5ba','CONSUL {#NODE_NAME}','','',NULL,'0'),
('10524',NULL,'HPE MSA 2040 Storage by HTTP','3','-1','2','','','HPE MSA 2040 Storage by HTTP','0',NULL,'The template to monitor HPE MSA 2040 by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n1. Create a user with a monitor role on the storage, for example "zabbix".\r\n2. Link the template to a host.\r\n3. Set the hostname or IP address of the host in the {$HPE.MSA.API.HOST} macro and configure the username and password in the {$HPE.MSA.API.USERNAME} and {$HPE.MSA.API.PASSWORD} macros.\r\n4. Change the {$HPE.MSA.API.SCHEME} and {$HPE.MSA.API.PORT} macros if needed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','be10b1140fce4cc08247260b71bcd037','HPE MSA 2040 STORAGE BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10525',NULL,'HPE MSA 2060 Storage by HTTP','3','-1','2','','','HPE MSA 2060 Storage by HTTP','0',NULL,'The template to monitor HPE MSA 2060 by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n1. Create a user with a monitor role on the storage, for example "zabbix".\r\n2. Link the template to a host.\r\n3. Set the hostname or IP address of the host in the {$HPE.MSA.API.HOST} macro and configure the username and password in the {$HPE.MSA.API.USERNAME} and {$HPE.MSA.API.PASSWORD} macros.\r\n4. Change the {$HPE.MSA.API.SCHEME} and {$HPE.MSA.API.PORT} macros if needed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','10537641cfa3416ab0f1451cdb61d804','HPE MSA 2060 STORAGE BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10526',NULL,'HPE Primera by HTTP','3','-1','2','','','HPE Primera by HTTP','0',NULL,'The template to monitor HPE Primera by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create a user on the storage with a browse role and enable it for all domains, for example "zabbix".\r\n  2. The WSAPI server does not start automatically.\r\n     - Log in to the CLI as Super, Service, or any role granted the wsapi_set right.\r\n     - Start the WSAPI server by command: `startwsapi`.\r\n     - To check WSAPI state use command: `showwsapi`.\r\n  3. Link template to the host.\r\n  4. Set the hostname or IP address of the host in the {$HPE.PRIMERA.API.HOST} macro and configure the username and password in the {$HPE.PRIMERA.API.USERNAME} and {$HPE.PRIMERA.API.PASSWORD} macros.\r\n  5. Change the {$HPE.PRIMERA.API.SCHEME} and {$HPE.PRIMERA.API.PORT} macros if needed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b8750c02b5624c6889979b129735bd56','HPE PRIMERA BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10527',NULL,'AWS EC2 by HTTP','3','-1','2','','','AWS EC2 by HTTP','0',NULL,'Get AWS EC2 and attached AWS EBS volumes metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7af6d68b223a43d4bf8526cc5dc3fe2e','AWS EC2 BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10528',NULL,'OPNsense by SNMP','3','-1','2','','','OPNsense by SNMP','0',NULL,'Template for monitoring OPNsense by SNMP\r\nSetup:\r\n  1. Enable bsnmpd daemon by creating new config file "/etc/rc.conf.d/bsnmpd" with the following content:\r\n  bsnmpd_enable="YES"\r\n  2. Uncomment the following lines in "/etc/snmpd.config" file to enable required SNMP modules:\r\n  begemotSnmpdModulePath."hostres" = "/usr/lib/snmp_hostres.so"\r\n  begemotSnmpdModulePath."pf"     = "/usr/lib/snmp_pf.so"\r\n  3. Start bsnmpd daemon with the following command:\r\n  /etc/rc.d/bsnmpd start\r\n  4. Setup a firewall rule to get access from Zabbix proxy or Zabbix server by SNMP (https://docs.opnsense.org/manual/firewall.html).\r\n  5. Link the template to a host.\r\n\r\n\r\nMIBs used:\r\nBEGEMOT-PF-MIB\r\nHOST-RESOURCES-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0c94915edb4c41bf8c627dddb4f68f5a','OPNSENSE BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10529',NULL,'AWS RDS instance by HTTP','3','-1','2','','','AWS RDS instance by HTTP','0',NULL,'The template gets AWS RDS instance metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c6d9475847f44d9193f8253e5995b8f8','AWS RDS INSTANCE BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10530',NULL,'AWS S3 bucket by HTTP','3','-1','2','','','AWS S3 bucket by HTTP','0',NULL,'The template gets AWS S3 bucket metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a14ab6b4e80643fe8daa9d7288658f79','AWS S3 BUCKET BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10531',NULL,'Azure by HTTP','3','-1','2','','','Azure by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure by HTTP.\r\nIt works without any external scripts and uses the script item.\r\nCurrently the template supports the discovery of virtual machines (VMs), Cosmos DB for MongoDB, storage accounts, Microsoft SQL, MySQL, and PostgreSQL servers.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: `{$AZURE.APP.ID}`, `{$AZURE.PASSWORD}`, `{$AZURE.TENANT.ID}`, and `{$AZURE.SUBSCRIPTION.ID}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fa58228fee8a4e34a7c6503950d1c615','AZURE BY HTTP','Zabbix','7.0-5',NULL,'0'),
('10532',NULL,'Azure Virtual Machine by HTTP','3','-1','2','','','Azure Virtual Machine by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure virtual machines (VMs) by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','820fa4a1565c43e4aac07a691a5bface','AZURE VIRTUAL MACHINE BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10533',NULL,'Azure virtual machine {#NAME}','0','-1','2','','','Azure virtual machine {#NAME}','2',NULL,'','1','1','','','','','0','0','d08c0ee33c924b28bf1fed571da6c7f4','AZURE VIRTUAL MACHINE {#NAME}','','',NULL,'0'),
('10534',NULL,'HPE Synergy by HTTP','3','-1','2','','','HPE Synergy by HTTP','0',NULL,'This template is designed to monitor HPE Synergy by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Link template to the host.\r\n  2. Set the hostname or IP address of the host in the {$HPE.SYNERGY.API.HOST} macro and configure the username and password in the {$HPE.SYNERGY.API.USERNAME} and {$HPE.SYNERGY.API.PASSWORD} macros.\r\n  3. Change the {$HPE.SYNERGY.API.SCHEME} and {$HPE.SYNERGY.API.PORT} macros if needed.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0ffde4421f524bcbac2f47fec87c0f95','HPE SYNERGY BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10535',NULL,'AWS by HTTP','3','-1','2','','','AWS by HTTP','0',NULL,'Get AWS EC2, RDS and S3 instances, AWS ECS clusters, AWS Elastic Load Balancing, Backup vaults. Don\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c60e5929ab474f67bbe67dc6b04e709d','AWS BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10536',NULL,'{#AWS.EC2.INSTANCE.ID}','0','-1','2','','','{#AWS.EC2.INSTANCE.NAME}','2',NULL,'','1','1','','','','','0','1','c4c830c727294b07926c39b00cf19046','{#AWS.EC2.INSTANCE.NAME}','','',NULL,'0'),
('10537',NULL,'{#AWS.RDS.INSTANCE.ID}','0','-1','2','','','{#AWS.RDS.INSTANCE.ID}','2',NULL,'','1','1','','','','','0','1','799663c52a644f78aa3b3c14d4cc7235','{#AWS.RDS.INSTANCE.ID}','','',NULL,'0'),
('10538',NULL,'{#AWS.S3.NAME}','0','-1','2','','','{#AWS.S3.NAME}','2',NULL,'','1','1','','','','','0','1','e45bd9810ea14718b17b875aad3fc544','{#AWS.S3.NAME}','','',NULL,'0'),
('10539',NULL,'Azure MySQL Flexible Server by HTTP','3','-1','2','','','Azure MySQL Flexible Server by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure MySQL flexible servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ec92c7b0b1d14946b6ac61de89357199','AZURE MYSQL FLEXIBLE SERVER BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10540',NULL,'Azure MySQL Single Server by HTTP','3','-1','2','','','Azure MySQL Single Server by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure MySQL single servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c1396bf1e8cf46f6a407e88ddceef0b8','AZURE MYSQL SINGLE SERVER BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10541',NULL,'Azure MySQL server {#NAME}','0','-1','2','','','Azure MySQL server {#NAME}','2',NULL,'','1','1','','','','','0','0','55b87078c14c4561b53e64af5ed77d61','AZURE MYSQL SERVER {#NAME}','','',NULL,'0'),
('10543',NULL,'Azure PostgreSQL Flexible Server by HTTP','3','-1','2','','','Azure PostgreSQL Flexible Server by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure PostgreSQL flexible servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','35ef29f24158444097272d2ea7fa6044','AZURE POSTGRESQL FLEXIBLE SERVER BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10544',NULL,'Azure PostgreSQL Single Server by HTTP','3','-1','2','','','Azure PostgreSQL Single Server by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure PostgreSQL servers by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d023e2cd326c486f908e3e361d1fe157','AZURE POSTGRESQL SINGLE SERVER BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10545',NULL,'Azure PostgreSQL server {#NAME}','0','-1','2','','','Azure PostgreSQL server {#NAME}','2',NULL,'','1','1','','','','','0','0','54f0e0ec288f4feb9a2dc58a8726bd1d','AZURE POSTGRESQL SERVER {#NAME}','','',NULL,'0'),
('10546',NULL,'Cisco Meraki dashboard by HTTP','3','-1','2','','','Cisco Meraki dashboard by HTTP','0',NULL,'Template for monitoring Cisco Meraki dashboard https://meraki.cisco.com/products/meraki-dashboard/\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2fca6b60914b4fa98132b1a7885ab014','CISCO MERAKI DASHBOARD BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10547',NULL,'Cisco Meraki device by HTTP','3','-1','2','','','Cisco Meraki device by HTTP','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2cae7d2eeca04e6fa7419759ac9ad814','CISCO MERAKI DEVICE BY HTTP','Zabbix','7.0-3',NULL,'0'),
('10548',NULL,'Cisco Meraki organization by HTTP','3','-1','2','','','Cisco Meraki organization by HTTP','0',NULL,'Generated by official Zabbix template tool "Templator"','1','1','','','','','0','0','39e2f742d0b24ea489b7f61d27a5df1c','CISCO MERAKI ORGANIZATION BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10549',NULL,'{#SERIAL}','0','-1','2','','','[{#SERIAL}] [{#PRODUCT_TYPE}] {#NAME}','2',NULL,'','1','1','','','','','0','0','86d599f384d94b368508a170911213ec','[{#SERIAL}] [{#PRODUCT_TYPE}] {#NAME}','','',NULL,'0'),
('10550',NULL,'meraki-organization-{#ID}','0','-1','2','','','[{#REGION}] {#NAME}','2',NULL,'','1','1','','','','','0','0','59cd2e995b814d7e9f8411dbc7420c76','[{#REGION}] {#NAME}','','',NULL,'0'),
('10551',NULL,'Cisco Nexus 9000 Series by SNMP','3','-1','2','','','Cisco Nexus 9000 Series by SNMP','0',NULL,'Template Cisco Nexus 9000 Series\r\n  \r\n  MIBs used:\r\n  CISCO-ENHANCED-MEMPOOL-MIB\r\n  CISCO-ENTITY-FRU-CONTROL-MIB\r\n  CISCO-ENTITY-SENSOR-MIB\r\n  CISCO-PROCESS-MIB\r\n  ENTITY-MIB\r\n  EtherLike-MIB\r\n  IF-MIB\r\n  SNMPv2-MIB\r\n  SNMP-FRAMEWORK-MIB\r\n  CISCO-IMAGE-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418396-discussion-thread-for-official-zabbix-templates-for-cisco\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','80fc469750f84061924662a98c33580c','CISCO NEXUS 9000 SERIES BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10552',NULL,'Control-M enterprise manager by HTTP','3','-1','2','','','Control-M enterprise manager by HTTP','0',NULL,'This template is designed to get metrics from the Control-M Enterprise Manager using the Control-M Automation API with HTTP agent.\r\n\r\nThis template monitors active Service Level Agreement (SLA) services, discovers Control-M servers using Low Level Discovery and also creates host prototypes for them in conjunction with the `Control-M server by HTTP` template.\r\n\r\nTo use this template, macros `{$API.TOKEN}` and `{$API.URI.ENDPOINT}` need to be set.\r\n\r\n> See [Zabbix template operation](https://www.zabbix.com/documentation/7.0/manual/config/templates_out_of_the_box/http) for basic instructions.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','24b64f6d22b446dabecc86ee3f199004','CONTROL-M ENTERPRISE MANAGER BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10553',NULL,'Control-M server by HTTP','3','-1','2','','','Control-M server by HTTP','0',NULL,'This template is designed to get metrics from the Control-M server using the Control-M Automation API with HTTP agent.\r\n\r\nThis template monitors server statistics, discovers jobs and agents using Low Level Discovery.\r\n\r\nTo use this template, macros `{$API.TOKEN}`, `{$API.URI.ENDPOINT}`, and `{$SERVER.NAME}` need to be set.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c077d6c381904e94a4df88136588b551','CONTROL-M SERVER BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10554',NULL,'{#SERVER.NAME}','0','-1','2','','','Control-M server [{#SERVER.NAME}]','2',NULL,'','1','1','','','','','0','0','1ade45fcbb9e407ca32542564b12f2b1','CONTROL-M SERVER [{#SERVER.NAME}]','','',NULL,'0'),
('10555',NULL,'Veeam Backup and Replication by HTTP','3','-1','2','','','Veeam Backup and Replication by HTTP','0',NULL,'This template is designed to monitor Veeam Backup and Replication.\r\n\r\nNOTE: The RESTful API may not be available for some editions, see (https://www.veeam.com/licensing-pricing.html) for more details.\r\n\r\nSetup:\r\n  1. Create a user to monitor the service or use an existing read-only account.\r\n  See (https://helpcenter.veeam.com/docs/backup/vbr_rest/reference/vbr-rest-v1-rev2.html?ver=110#tag/Login/operation/CreateToken!path=grant_type&t=request) for more details. \r\n  2. Link the template to a host.\r\n  3. Configure the following macros: {$VEEAM.API.URL}, {$VEEAM.USER}, and {$VEEAM.PASSWORD}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','738085dde4e749d49199e5e6fd4d56ab','VEEAM BACKUP AND REPLICATION BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10556',NULL,'Veeam Backup Enterprise Manager by HTTP','3','-1','2','','','Veeam Backup Enterprise Manager by HTTP','0',NULL,'This template is designed to monitor Veeam Backup Enterprise Manager.\r\n\r\nNOTE: The REST API may not be available for some editions, see (https://www.veeam.com/licensing-pricing.html) for more details.\r\n\r\nSetup:\r\n  1. Create a user to monitor the service, or use an existing read-only account.\r\n     Similarly to the user authentication in the Veeam Backup Enterprise Manager Web UI, \r\n     the client authentication in the REST API dictates which operations a client is allowed to perform when working with the REST API.\r\n     That is, if the client is authenticated using an account that does not have enough permissions to perform some actions, it will not be able to execute them.\r\n     You can also obtain the collected jobs if you are logged in under an account having only `Portal Administrator` role.\r\n  See (https://helpcenter.veeam.com/docs/backup/em_rest/http_authentication.html?ver=110) for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the following macros: {$VEEAM.MANAGER.API.URL}, {$VEEAM.MANAGER.USER}, {$VEEAM.MANAGER.PASSWORD}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2ce384bafd524db5b910d7f55bca1fbb','VEEAM BACKUP ENTERPRISE MANAGER BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10557',NULL,'Azure Microsoft SQL Database by HTTP','3','-1','2','','','Azure Microsoft SQL Database by HTTP','0',NULL,'This template is designed to monitor Microsoft SQL databases by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2d8b9329b5d04cdf85bf17d2d0db2b29','AZURE MICROSOFT SQL DATABASE BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10558',NULL,'Azure Microsoft SQL Serverless Database by HTTP','3','-1','2','','','Azure Microsoft SQL Serverless Database by HTTP','0',NULL,'This template is designed to monitor Microsoft SQL serverless databases by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5175afdf713744d9a81ce53864ccfc1d','AZURE MICROSOFT SQL SERVERLESS DATABASE BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10559',NULL,'Azure Microsoft SQL database {#NAME}','0','-1','2','','','Azure Microsoft SQL database {#NAME}','2',NULL,'','1','1','','','','','0','0','2aaf7dc7e9f04ccf9dd91fcd803fa076','AZURE MICROSOFT SQL DATABASE {#NAME}','','',NULL,'0'),
('10560',NULL,'OS processes by Zabbix agent','3','-1','2','','','OS processes by Zabbix agent','0',NULL,'Get processes metrics using item proc.get by Zabbix agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0f6889282f6048e2b1370e569e578985','OS PROCESSES BY ZABBIX AGENT','Zabbix','7.0-1',NULL,'0'),
('10561',NULL,'Zabbix agent','3','-1','2','','','Zabbix agent','0',NULL,'Use this template for agents reachable from Zabbix server/proxy (passive mode).\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8aa4557f6c3f4aadbc03447fca3af9f6','ZABBIX AGENT','Zabbix','7.0-0',NULL,'0'),
('10562',NULL,'Zabbix agent active','3','-1','2','','','Zabbix agent active','0',NULL,'Use this template instead of \'Zabbix agent\' for agents running in active mode only.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','650bec3f2f364a478b82317396949459','ZABBIX AGENT ACTIVE','Zabbix','7.0-0',NULL,'0'),
('10563',NULL,'Generic by SNMP','3','-1','2','','','Generic by SNMP','0',NULL,'Template Module Generic\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nSNMPv2-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4cb1aabe2b704b5c882963c2ef87d8f6','GENERIC BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10564',NULL,'ICMP Ping','3','-1','2','','','ICMP Ping','0',NULL,'Template Net ICMP Ping\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','37e5eb5606bc4abba66c8b20381a1e8a','ICMP PING','Zabbix','7.0-2',NULL,'0'),
('10565',NULL,'SMART by Zabbix agent 2','3','-1','2','','','SMART by Zabbix agent 2','0',NULL,'The template for monitoring S.M.A.R.T. attributes of physical disk that works without any external scripts. It collects metrics by Zabbix agent 2 version 5.0 and later with Smartmontools version 7.1 and later. Disk discovery LLD rule finds all HDD, SSD, NVMe disks with S.M.A.R.T. enabled. Attribute discovery LLD rule have pre-defined Vendor Specific Attributes for each disk, and will be discovered if attribute is present.\r\n\r\nSetup:\r\n\r\n1. Install Zabbix agent 2 and Smartmontools 7.1 or newer.\r\n\r\n2. Ensure the path to the "smartctl" executable is correctly specified. You can either provide the full path to the executable (e.g., "/usr/sbin/smartctl" on Linux or "C:\\Program Files\\smartctl\\smartctl.exe" on Windows) in the configuration file or ensure that the folder containing the "smartctl" executable is added to the system\'s environment variables ("PATH"). This applies to both Linux and Windows systems.\r\n\r\nExample for Linux:      \r\nPlugins.Smart.Path=/usr/sbin/smartctl\r\n\r\nExample for Windows:\r\nPlugins.Smart.Path="C:\\Program Files\\smartctl\\smartctl.exe"\r\n\r\n3. Grant Zabbix agent 2 super/admin user privileges for the "smartctl" utility (not required for Windows). Example for Linux (add the line that grants execution of the "smartctl" utility without the password):\r\n\r\n- Run the "visudo" command to edit the "sudoers" file:\r\nsudo visudo\r\n\r\n- Add the permission line and save the changes:\r\nzabbix ALL=(ALL) NOPASSWD:/usr/sbin/smartctl\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415662-discussion-thread-for-official-zabbix-smart-disk-monitoring\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7b6c6228b25f4586b42cd1bf37ff8034','SMART BY ZABBIX AGENT 2','Zabbix','7.0-4',NULL,'0'),
('10566',NULL,'SMART by Zabbix agent 2 active','3','-1','2','','','SMART by Zabbix agent 2 active','0',NULL,'The template for monitoring S.M.A.R.T. attributes of physical disk that works without any external scripts. It collects metrics by Zabbix agent 2 version 5.0 and later with Smartmontools version 7.1 and later. Disk discovery LLD rule finds all HDD, SSD, NVMe disks with S.M.A.R.T. enabled. Attribute discovery LLD rule have pre-defined Vendor Specific Attributes for each disk, and will be discovered if attribute is present.\r\n\r\nSetup:\r\n\r\n1. Install Zabbix agent 2 and Smartmontools 7.1 or newer.\r\n\r\n2. Ensure the path to the "smartctl" executable is correctly specified. You can either provide the full path to the executable (e.g., "/usr/sbin/smartctl" on Linux or "C:\\Program Files\\smartctl\\smartctl.exe" on Windows) in the configuration file or ensure that the folder containing the "smartctl" executable is added to the system\'s environment variables ("PATH"). This applies to both Linux and Windows systems.\r\n\r\nExample for Linux:      \r\nPlugins.Smart.Path=/usr/sbin/smartctl\r\n\r\nExample for Windows:\r\nPlugins.Smart.Path="C:\\Program Files\\smartctl\\smartctl.exe"\r\n\r\n3. Grant Zabbix agent 2 super/admin user privileges for the "smartctl" utility (not required for Windows). Example for Linux (add the line that grants execution of the "smartctl" utility without the password):\r\n\r\n- Run the "visudo" command to edit the "sudoers" file:\r\nsudo visudo\r\n\r\n- Add the permission line and save the changes:\r\nzabbix ALL=(ALL) NOPASSWD:/usr/sbin/smartctl\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/415662-discussion-thread-for-official-zabbix-smart-disk-monitoring\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e518b1340ce44d7389d2cc7c304a97b4','SMART BY ZABBIX AGENT 2 ACTIVE','Zabbix','7.0-4',NULL,'0'),
('10567',NULL,'{#NAME}','1','-1','2','','','{#NAME}','2',NULL,'','1','1','','','','','1','1','bfcbf26edd704bdfaa65e244a987839e','{#NAME}','','',NULL,'0'),
('10568',NULL,'Azure Cosmos DB for MongoDB by HTTP','3','-1','2','','','Azure Cosmos DB for MongoDB by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure Cosmos DB for MongoDB by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','29325098807848aa928b4192ad5e020f','AZURE COSMOS DB FOR MONGODB BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10569',NULL,'Azure Cosmos DB {#NAME}','0','-1','2','','','Azure Cosmos DB {#NAME}','2',NULL,'','1','1','','','','','0','0','16eec30e921e4627b3599b4d06e48072','AZURE COSMOS DB {#NAME}','','',NULL,'0'),
('10570',NULL,'GCP by HTTP','3','-1','2','','','GCP by HTTP','0',NULL,'Discover GCP Compute Engine/Cloud SQL Instances and Compute Engine project quota metrics.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4e1e9372a5fe4297936210bc4fc4b1c0','GCP BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10571',NULL,'GCP Cloud SQL MSSQL by HTTP','3','-1','2','','','GCP Cloud SQL MSSQL by HTTP','0',NULL,'Get GCP Cloud SQL MSSQL instances monitoring with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','507d70db18554a4e9ee5e09bb29bc85f','GCP CLOUD SQL MSSQL BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10572',NULL,'GCP Cloud SQL MSSQL Replica by HTTP','3','-1','2','','','GCP Cloud SQL MSSQL Replica by HTTP','0',NULL,'Get GCP Cloud SQL MSSQL monitoring for read-only replicas with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','54f0ffb538d94a9bb8062df3e63c4cb6','GCP CLOUD SQL MSSQL REPLICA BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10573',NULL,'GCP Cloud SQL MySQL by HTTP','3','-1','2','','','GCP Cloud SQL MySQL by HTTP','0',NULL,'Get GCP Cloud SQL MySQL instances monitoring with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','38456af4aedd4b168ec3fa4ad2acb256','GCP CLOUD SQL MYSQL BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10574',NULL,'GCP Cloud SQL MySQL Replica by HTTP','3','-1','2','','','GCP Cloud SQL MySQL Replica by HTTP','0',NULL,'Get GCP Cloud SQL MySQL monitoring for read-only replicas with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','9d7871c093f9489293421396b9fea668','GCP CLOUD SQL MYSQL REPLICA BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10575',NULL,'GCP Cloud SQL PostgreSQL by HTTP','3','-1','2','','','GCP Cloud SQL PostgreSQL by HTTP','0',NULL,'Get GCP Cloud SQL PostgreSQL instances monitoring with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e74c1e12f82e4d9880a368b53f5e65a4','GCP CLOUD SQL POSTGRESQL BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10576',NULL,'GCP Cloud SQL PostgreSQL Replica by HTTP','3','-1','2','','','GCP Cloud SQL PostgreSQL Replica by HTTP','0',NULL,'Get GCP Cloud SQL PostgreSQL  monitoring for read-only replicas with script item usage to perform HTTP requests to Google Cloud Platform Monitoring API.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b43a7c5f1d1d43d28e2eb8f0a9f6f16f','GCP CLOUD SQL POSTGRESQL REPLICA BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10577',NULL,'GCP Compute Engine Instance by HTTP','3','-1','2','','','GCP Compute Engine Instance by HTTP','0',NULL,'Discover GCP Compute Engine instances by HTTP with script item usage.\r\nThis template will be automatically connected to discovered entities with all their required parameters pre-defined.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6d2443db49e54d59a82b9b525f2424ef','GCP COMPUTE ENGINE INSTANCE BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10578',NULL,'{#GCP.PROJECT.ID}-{#CLOUD_SQL.INSTANCE.NAME}','0','-1','2','','','{#CLOUD_SQL.INSTANCE.NAME}','2',NULL,'','1','1','','','','','0','1','edc6ab9314ed410b8a3cf6bfedff51ab','{#CLOUD_SQL.INSTANCE.NAME}','','',NULL,'0'),
('10579',NULL,'{#GCP.PROJECT.ID}-{#CLOUD_SQL.INSTANCE.NAME}','0','-1','2','','','{#CLOUD_SQL.INSTANCE.NAME}','2',NULL,'','1','1','','','','','0','1','8b2556b881b14b86a98f90a447ae9734','{#CLOUD_SQL.INSTANCE.NAME}','','',NULL,'0'),
('10580',NULL,'{#GCP.PROJECT.ID}-{#CLOUD_SQL.INSTANCE.NAME}','0','-1','2','','','{#CLOUD_SQL.INSTANCE.NAME}','2',NULL,'','1','1','','','','','0','1','0fbbc550fda448d39aad6d0710f28b6a','{#CLOUD_SQL.INSTANCE.NAME}','','',NULL,'0'),
('10581',NULL,'{#GCE.INSTANCE.ID}','0','-1','2','','','{#GCE.INSTANCE.NAME}','2',NULL,'','1','1','','','','','0','1','cb22d82a12814afb8ba833c649d575c4','{#GCE.INSTANCE.NAME}','','',NULL,'0'),
('10582',NULL,'AWS Cost Explorer by HTTP','3','-1','2','','','AWS Cost Explorer by HTTP','0',NULL,'The template gets AWS Cost Explorer metrics and uses the script item to make HTTP requests to the Cost Explorer API.\r\nThe Cost Explorer API can access the historical data over up to 12 months and the data for current month.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','dce23cdaef364e139efa580d8a304ffe','AWS COST EXPLORER BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10583',NULL,'AWS ECS Cluster by HTTP','3','-1','2','','','AWS ECS Cluster by HTTP','0',NULL,'The template gets AWS ECS Cluster metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c94105c23220452baed03ba87f09ca12','AWS ECS CLUSTER BY HTTP','Zabbix','7.0-5',NULL,'0'),
('10584',NULL,'AWS ECS Serverless Cluster by HTTP','3','-1','2','','','AWS ECS Serverless Cluster by HTTP','0',NULL,'The template gets AWS ECS Serverless Cluster metrics and uses the script item to make HTTP requests to the CloudWatch API.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5e225ad1c2cc4d0bbf75586e7bf8871b','AWS ECS SERVERLESS CLUSTER BY HTTP','Zabbix','7.0-5',NULL,'0'),
('10585',NULL,'{#AWS.ECS.CLUSTER.NAME}','0','-1','2','','','{#AWS.ECS.CLUSTER.NAME}','2',NULL,'','1','1','','','','','0','0','71072e5a149e45b293946866f8220c07','{#AWS.ECS.CLUSTER.NAME}','','',NULL,'0'),
('10586',NULL,'OpenStack by HTTP','3','-1','2','','','OpenStack by HTTP','0',NULL,'Requests OpenStack API access token and discovers available OpenStack services using OpenStack Identity API by HTTP using script item and creates host prototypes for them.\r\n\r\nTemplate uses OpenStack application credentials for authorization.\r\n\r\nZabbix currently supports OpenStack Nova service.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4e3fb27f028e4c35b8c9fc43b11c07d7','OPENSTACK BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10587',NULL,'OpenStack Nova by HTTP','3','-1','2','','','OpenStack Nova by HTTP','0',NULL,'Discovers and monitors project limits, servers, services, hypervisors, availability zones, hypervisors and tenants with OpenStack Compute API by HTTP using script and HTTP agent items.\r\n\r\nThis template receives token and service URL from parent host, therefore no additional configuration is necessary.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ff637e001b91472d8730eb7f10e65800','OPENSTACK NOVA BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10588',NULL,'OpenStack {#SERVICE_NAME}','0','-1','2','','','OpenStack {#SERVICE_NAME}','2',NULL,'','1','1','','','','','0','0','580d769292ec48379c5b84cd5c72533b','OPENSTACK {#SERVICE_NAME}','','',NULL,'0'),
('10589',NULL,'PostgreSQL by ODBC','3','-1','2','','','PostgreSQL by ODBC','0',NULL,'This template is designed for the effortless deployment of PostgreSQL monitoring by Zabbix via ODBC and doesn\'t require any external scripts.\r\n\r\nSetup:\r\n\r\n1. Create the PostgreSQL user for monitoring (`<password>` at your discretion) and inherit permissions from the default role `pg_monitor`:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n\r\n2. Edit the `pg_hba.conf` configuration file to allow TCP connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).\r\n\r\n3. Install the PostgreSQL ODBC driver.\r\n\r\n4. Set up the connection string with the `{$PG.CONNSTRING.ODBC}` macro. The minimum required parameters are:\r\n- `Driver=` - set the name of the driver which will be used for monitoring (from the `odbcinst.ini` file) or specify the path to the driver file (for example `/usr/lib64/psqlodbcw.so`);\r\n- `Servername=` - set the host name or IP address of the PostgreSQL instance;\r\n- `Port=` - adjust the port number if needed.\r\n\r\nIf you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, you can also specify encryption parameters here.\r\n\r\nIt is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\nFor example, to enable required encryption in transport mode without identity checks, the connection string could look like this (replace `<instanceip>` with the address of the PostgreSQL instance):\r\nServername=<instanceip>;Port=5432;Driver=/usr/lib64/psqlodbcw.so;SSLmode=require\r\n\r\n5. Set the password that you specified in step 1 in the macro `{$PG.PASSWORD}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e0a7c3e725c445228b03116dc6114fe9','POSTGRESQL BY ODBC','Zabbix','7.0-2',NULL,'0'),
('10590',NULL,'Cisco SD-WAN by HTTP','3','-1','2','','','Cisco SD-WAN by HTTP','0',NULL,'Discover Cisco SD-WAN devices by HTTP with script item usage.\r\n\r\nSetup:\r\n1. Put your username and password from Cisco SD-WAN vManage into {$SDWAN.API.USERNAME} and {$SDWAN.API.PASSWORD} macros.\r\n2. Set your Cisco SD-WAN vManage URL as {$SDWAN.API.URL} macro value.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e5cf4e7ac41a470b99e4262d1c5ee104','CISCO SD-WAN BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10591',NULL,'Cisco SD-WAN device by HTTP','3','-1','2','','','Cisco SD-WAN device by HTTP','0',NULL,'Get Cisco SD-WAN devices monitoring with script item usage to perform HTTP requests to Cisco SD-WAN API.\r\nThis template will be automatically connected to discovered entities with all required parameters pre-defined.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e1e25df663204b099f2597caf89a0678','CISCO SD-WAN DEVICE BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10592',NULL,'{#UUID}','0','-1','2','','','[{#TYPE}] {#NAME}','2',NULL,'','1','1','','','','','0','1','8c53a2dded4a47cba1eb3398aff888d7','[{#TYPE}] {#NAME}','','',NULL,'0'),
('10593',NULL,'Mantis BT by HTTP','3','-1','2','','','Mantis BT by HTTP','0',NULL,'Get Mantis BT issues by HTTP.\r\nMetrics are collected by requests to Mantis BT API.\r\nPlease change macros {$MANTIS.URL} and {$MANTIS.TOKEN}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2c96393f8f2945c1a9f03f86adf5eb57','MANTIS BT BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10594',NULL,'HashiCorp Nomad by HTTP','3','-1','2','','','HashiCorp Nomad by HTTP','0',NULL,'Discover HashiCorp Nomad servers and clients automatically.\r\n\r\nDon\'t forget to change macro {$NOMAD.ENDPOINT.API.URL}, {$NOMAD.TOKEN} values.\r\n\r\nYou can discuss this template or leave feedback on our forum: https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f74adf26d9ab44ada318002d31fd2881','HASHICORP NOMAD BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10595',NULL,'HashiCorp Nomad Client by HTTP','3','-1','2','','','HashiCorp Nomad Client by HTTP','0',NULL,'Get HashiCorp Nomad client metrics by HTTP from metrics endpoint.\r\n\r\nMore information about metrics is available in the official documentation: https://developer.hashicorp.com/nomad/docs/operations/metrics-reference.\r\n\r\nYou can discuss this template or leave feedback on our forum: https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','44eac6a1abe34999b85ad6d0e40073fd','HASHICORP NOMAD CLIENT BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10596',NULL,'HashiCorp Nomad Server by HTTP','3','-1','2','','','HashiCorp Nomad Server by HTTP','0',NULL,'Get HashiCorp Nomad server metrics by HTTP from metrics endpoint.\r\n\r\nMore information about metrics is available in the official documentation: https://developer.hashicorp.com/nomad/docs/operations/metrics-reference.\r\n\r\nYou can discuss this template or leave feedback on our forum: https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8598d0e2bd6f4903832ec91b7b300062','HASHICORP NOMAD SERVER BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10597',NULL,'{#CLIENT.ID}','0','-1','2','','','{#CLIENT.NAME}-client','2',NULL,'','1','1','','','','','0','1','8284dcf3055749d3b27720526c665e34','{#CLIENT.NAME}-CLIENT','','',NULL,'0'),
('10598',NULL,'{#SERVER.ID}','0','-1','2','','','{#SERVER.NAME}','2',NULL,'','1','1','','','','','0','1','addb1ce7995f44089a13128052171445','{#SERVER.NAME}','','',NULL,'0'),
('10599',NULL,'Acronis Cyber Protect Cloud by HTTP','3','-1','2','','','Acronis Cyber Protect Cloud by HTTP','0',NULL,'Requests Acronis Cyber Protect Cloud API access token and creates host prototype for MSP.\r\n\r\nTemplate uses HTTP item to query Acronis Cyber Protect Cloud API client for authorization.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d0571c5f2c204b7ab244843040288a35','ACRONIS CYBER PROTECT CLOUD BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10600',NULL,'Acronis Cyber Protect Cloud MSP by HTTP','3','-1','2','','','Acronis Cyber Protect Cloud MSP by HTTP','0',NULL,'Discovers and monitors alerts, clients, devices using HTTP agent items.\r\n\r\nThis template receives API token and datacenter URL from parent host, therefore no additional configuration is necessary.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','bf3107deff3a4aabab1e1c0ee71a3281','ACRONIS CYBER PROTECT CLOUD MSP BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10601',NULL,'Acronis CPC MSP {#SCOPE}','0','-1','2','','','Acronis CPC MSP {#SCOPE}','2',NULL,'','1','1','','','','','0','0','bbdc747270f64876bc701dd87c27dbbe','ACRONIS CPC MSP {#SCOPE}','','',NULL,'0'),
('10602',NULL,'Nextcloud by HTTP','3','-1','2','','','Nextcloud by HTTP','0',NULL,'This template is designed for monitoring Nextcloud by HTTP via Zabbix, and it works without any external scripts.\r\n  Nextcloud is a suite of client-server software for creating and using file hosting services.\r\n  For more information, see the [`official documentation`](https://docs.nextcloud.com/server/latest/developer_manual/client_apis/OCS/ocs-api-overview.html#)\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','34f386276a094e8e9a6e46653fdf05b1','NEXTCLOUD BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10603',NULL,'FortiGate by HTTP','3','-1','2','','','FortiGate by HTTP','0',NULL,'The template for monitoring FortiGate Next Generation Firewall by HTTP.\r\n\r\n1. On the FortiGate GUI, select System > Admin Profiles > Create New.\r\n2. Enter a profile name (ex. zabbix_ro) and enable all the Read permissions. Please note the profile name, it will be used a bit later.\r\n3. Go to System > Administrators > Create New > REST API Admin.\r\n4. Enter the API-user\'s name and select the profile name you created in step 2.\r\n5. The trusted host can be specified to ensure that only Zabbix server can reach the FortiGate.\r\n6. Click OK and an API token will be generated. Make a note of the API token as it\'s only shown once and cannot be retrieved.\r\n7. Put the API token into {$FGATE.API.TOKEN} macro.\r\n8. Set your FortiGate GUI IP/FQDN as {$FGATE.API.FQDN} macro value.\r\n9. If FortiGate GUI uses HTTPS, put "https" value into {$FGATE.SCHEME} macro and "443" into {$FGATE.API.PORT} macro.\r\n10. If FortiGate GUI port differs from the standard one, specify it in {$FGATE.API.PORT} macro.\r\n\r\nNOTE: Starting from template version \'7.0-2\', the API token is used in the request header. For older template versions (where the API token is passed in the URL query parameter), when using FortiGate v7.4.5+, you must enable the following global setting:\r\nhttps://docs.fortinet.com/document/fortigate/7.6.4/administration-guide/940602/using-apis\r\n\r\nFor added security, it is strongly recommended to use the latest template version, which passes the API token in the request header instead of the URL parameter.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e56c9577c225476eb6d8f1c2f5dc90a5','FORTIGATE BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10604',NULL,'FortiGate by SNMP','3','-1','2','','','FortiGate by SNMP','0',NULL,'The template for monitoring FortiGate firewall by SNMP.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nFORTINET-FORTIGATE-MIB\r\nFORTINET-CORE-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1f38deb487fc4a8d965e407ba7c5247f','FORTIGATE BY SNMP','Zabbix','7.0-4',NULL,'0'),
('10605',NULL,'HPE iLO by HTTP','3','-1','2','','','HPE iLO by HTTP','0',NULL,'This template is designed for the effortless deployment of HPE iLO monitoring by Zabbix via iLO RESTful API and doesn\'t require any external scripts.\r\n\r\nSetup:\r\n\r\n1. Create the iLO user for monitoring (for example, `zbx_monitor`). The user will only need to have the `Login` privilege, which can be assigned manually or by assigning the `ReadOnly` role to the user.\r\n2. Set the iLO API endpoint URL in the `{$ILO.URL}` macro in the format `<scheme>://<host>[:port]/` (port is optional).\r\n3. Set the name of the user that you created in step 1 in the `{$ILO.USER}` macro.\r\n4. Set the password of the user that you created in step 1 in the `{$ILO.PASSWORD}` macro.\r\n\r\nFor more details about HPE Redfish services, refer to the official documentation:\r\nhttps://servermanagementportal.ext.hpe.com/docs/redfishservices/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d50f6dcfc3e44244a0fc9fd933607024','HPE ILO BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10606',NULL,'Azure Cost Management by HTTP','3','-1','2','','','Azure Cost Management by HTTP','0',NULL,'This template is designed to monitor Microsoft Cost Management by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c0263df8d8c14d30b24afcf45a6a354f','AZURE COST MANAGEMENT BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10607',NULL,'AWS ELB Application Load Balancer by HTTP','3','-1','2','','','AWS ELB Application Load Balancer by HTTP','0',NULL,'The template is designed to monitor AWS ELB Application Load Balancer by HTTP via Zabbix, and it works without any external scripts.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f59c8b4156ec4386a7c724534ddd384d','AWS ELB APPLICATION LOAD BALANCER BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10608',NULL,'{#AWS.ELB.NAME}','0','-1','2','','','{#AWS.ELB.NAME}','2',NULL,'','1','1','','','','','0','0','2c31bc79209e41978f76315406339769','{#AWS.ELB.NAME}','','',NULL,'0'),
('10609',NULL,'MSSQL by Zabbix agent 2','3','-1','2','','','MSSQL by Zabbix agent 2','0',NULL,'This template is designed for the effortless deployment of MSSQL monitoring by Zabbix via Zabbix agent 2 and uses a loadable plugin to run SQL queries.\r\n\r\nSetup:\r\n\r\n1. Deploy Zabbix agent 2 with the MSSQL plugin. You can use this template starting with version 7.0.0 of Zabbix and 7.0.10 of the MSSQL plugin.\r\n\r\n  For more information, see MSSQL plugin documentation: https://git.zabbix.com/projects/AP/repos/mssql/browse\r\n\r\n  Important! Starting with version 7.0-4 of this template, the MSSQL plugin must be updated to a version equal to or above 7.0.10. (You can check the version of the template in its YAML file under the "vendor" section.)\r\n\r\n  Loadable plugin requires installation of one of the following:\r\n\r\n  - Separate package\r\n  \r\n  - Binary file\r\n  \r\n  - Compilation from sources: https://www.zabbix.com/documentation/7.0/manual/extensions/plugins/build\r\n\r\n2. Create an MSSQL user for monitoring.\r\n\r\n  View Server State and View Any Definition permissions should be granted to the user.\r\n  Grant this user read permissions to the sysjobschedules, sysjobhistory, and sysjobs tables.\r\n\r\n  For more information, see MSSQL documentation:\r\n  \r\n  - Create a database user: https://docs.microsoft.com/en-us/sql/relational-databases/security/authentication-access/create-a-database-user?view=sql-server-ver16\r\n  \r\n  - GRANT Server Permissions: https://docs.microsoft.com/en-us/sql/t-sql/statements/grant-server-permissions-transact-sql?view=sql-server-ver16\r\n  \r\n  - Configure a User to Create and Manage SQL Server Agent Jobs: https://docs.microsoft.com/en-us/sql/ssms/agent/configure-a-user-to-create-and-manage-sql-server-agent-jobs?view=sql-server-ver16\r\n\r\n3. Set the user name and password in the host macros ({$MSSQL.USER} and {$MSSQL.PASSWORD}).\r\n\r\n4. Set the connection string for the MSSQL instance in the {$MSSQL.URI} macro as a URI, such as <protocol://host:port>, or specify the named session - <sessionname>.\r\n\r\nThe "Service\'s TCP port state" item uses the {$MSSQL.HOST} and {$MSSQL.PORT} macros to check the availability of the MSSQL instance, change these if necessary. Keep in mind that if dynamic ports are used on the MSSQL server side, this check will not work correctly.\r\n\r\nNote: You can use the context macros {$MSSQL.BACKUP_FULL.USED}, {$MSSQL.BACKUP_LOG.USED}, and {$MSSQL.BACKUP_DIFF.USED} to disable backup age triggers for a certain database. If set to a value other than "1", the trigger expression for the backup age will not fire.\r\n\r\nNote: Since version 7.0.6, you can also connect to the MSSQL instance using its name. To do this, set the connection string in the {$MSSQL.URI} macro as <protocol://host/instance_name>.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','75fc96367e8d4588ba8314145fc12d35','MSSQL BY ZABBIX AGENT 2','Zabbix','7.0-5',NULL,'0'),
('10610',NULL,'YugabyteDB by HTTP','3','-1','2','','','YugabyteDB by HTTP','0',NULL,'This template is designed for the deployment of YugabyteDB monitoring by Zabbix via HTTP and doesn\'t require any external scripts.\r\n\r\nTo set up the template:\r\n\r\n1. Set your account ID as a value of the {$YUGABYTEDB.ACCOUNT.ID} macro. The account ID is the unique identifier for your customer account in YugabyteDB Managed. You can access the account ID from your profile in the YugabyteDB Managed user interface. To get your account ID, log in to YugabyteDB Managed and click the user profile icon. \r\nSee YugabyteDB documentation for instructions:\r\nhttps://yugabyte.stoplight.io/docs/managed-apis/tvsjh28t5ivmw-getting-started#account-id\r\n\r\n2. Set your project ID as a value of the {$YUGABYTEDB.PROJECT.ID} macro. The project ID is the unique identifier for a YugabyteDB Managed project. You can access the project ID from your profile in the YugabyteDB Managed user interface (along with the account ID). \r\nSee YugabyteDB documentation for instructions:\r\nhttps://yugabyte.stoplight.io/docs/managed-apis/tvsjh28t5ivmw-getting-started#project-id\r\n\r\n3. Generate the API access token and specify it as a value of the {$YUGABYTEDB.ACCESS.TOKEN} macro. \r\nSee YugabyteDB documentation for instructions:\r\nhttps://docs.yugabyte.com/preview/yugabyte-cloud/managed-automation/managed-apikeys/#create-an-api-key\r\n\r\nNOTE: If needed, you can specify a HTTP proxy for the template to use by changing the value of the {$YUGABYTEDB.PROXY} user macro.\r\n\r\nIMPORTANT! The value of the {$YUGABYTEDB.ACCESS.TOKEN} macro is stored as plain (not secret) text by default.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','bc056b1724e748bba50928f8cc605f8e','YUGABYTEDB BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10611',NULL,'YugabyteDB Cluster by HTTP','3','-1','2','','','YugabyteDB Cluster by HTTP','0',NULL,'This template is designed for the deployment of YugabyteDB clusters monitoring by Zabbix via HTTP and doesn\'t require any external scripts. This template will be automatically connected to discovered entities with all required parameters pre-defined.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','f5fff9a83f774f4688692ad58aa35d45','YUGABYTEDB CLUSTER BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10612',NULL,'{#CLUSTER.ID}','0','-1','2','','','YugabyteDB Cluster [{#CLUSTER.NAME}]','2',NULL,'','1','1','','','','','0','0','1a7ec22ad5ad41e0bcb04c01c2c45e4e','YUGABYTEDB CLUSTER [{#CLUSTER.NAME}]','','',NULL,'0'),
('10613',NULL,'Check Point Next Generation Firewall by SNMP','3','-1','2','','','Check Point Next Generation Firewall by SNMP','0',NULL,'The template for monitoring Check Point Quantum Next Generation Firewall Security Gateway by SNMP.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nCHECKPOINT-MIB\r\nUCD-SNMP-MIB\r\nSNMPv2-MIB\r\nIF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3a7ff6eb19bb4a42b5b5b34a7179b30c','CHECK POINT NEXT GENERATION FIREWALL BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10614',NULL,'Oracle Cloud Autonomous Database by HTTP','3','-1','2','','','Oracle Cloud Autonomous Database by HTTP','0',NULL,'This template monitors Oracle Cloud Infrastructure (OCI) autonomous database (serverless) resources.\r\n\r\nThis template is not meant to be used independently, but together with Oracle Cloud by HTTP as a template for\r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','178645e229484bcf9cb030dc1edccebb','ORACLE CLOUD AUTONOMOUS DATABASE BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10615',NULL,'Oracle Cloud Block Volume by HTTP','3','-1','2','','','Oracle Cloud Block Volume by HTTP','0',NULL,'This template monitors Oracle Cloud Infrastructure (OCI) block volume resources.\r\n\r\nThis template is not meant to be used independently, but together with Oracle Cloud by HTTP as a template for\r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8afa1796d280425b99c7ea36900dac24','ORACLE CLOUD BLOCK VOLUME BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10616',NULL,'Oracle Cloud Boot Volume by HTTP','3','-1','2','','','Oracle Cloud Boot Volume by HTTP','0',NULL,'Monitor Oracle Cloud Infrastructure (OCI) boot volume.\r\n\r\nThis template is not meant to be used independently, but instead with Oracle Cloud by HTTP as a template for\r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e5486d98ff414c1391de1bd369a7f9db','ORACLE CLOUD BOOT VOLUME BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10617',NULL,'Oracle Cloud by HTTP','3','-1','2','','','Oracle Cloud by HTTP','0',NULL,'Monitor resources of Oracle Cloud Infrastructure (OCI) services.\r\n\r\nThis template handles discovery of various OCI services.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','057558a26d934b4683d73a7058499d62','ORACLE CLOUD BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10618',NULL,'Oracle Cloud Compute by HTTP','3','-1','2','','','Oracle Cloud Compute by HTTP','0',NULL,'This template monitors Oracle Cloud Infrastructure (OCI) single compute instance resources and discovers attached\r\nvirtual network interface cards (VNICs) and monitors their resources.\r\n\r\nThis template is not meant to be used independently, but together with Oracle Cloud by HTTP as a template for\r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e6b0aada359944d09ee4bd46c1a55587','ORACLE CLOUD COMPUTE BY HTTP','Zabbix','7.0-3',NULL,'0'),
('10619',NULL,'Oracle Cloud Networking by HTTP','3','-1','2','','','Oracle Cloud Networking by HTTP','0',NULL,'This template monitors Oracle Cloud Infrastructure (OCI) single virtual network card availability and discovers\r\nattached subnets and monitors their availability.\r\n\r\nThis template is not meant to be used independently, but together with Oracle Cloud by HTTP as a template for \r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','62d99b55585e41dd89736f5f46074dcb','ORACLE CLOUD NETWORKING BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10620',NULL,'Oracle Cloud Object Storage by HTTP','3','-1','2','','','Oracle Cloud Object Storage by HTTP','0',NULL,'This template monitors Oracle Cloud Infrastructure (OCI) object storage resources.\r\n\r\nThis template is not meant to be used independently, but together with Oracle Cloud by HTTP as a template for\r\nLLD host prototypes.\r\n\r\nRead the template documentation prior to using this template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','e8f89476695848e99ba900a5664d290b','ORACLE CLOUD OBJECT STORAGE BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10621',NULL,'OCI Block Volume - {#ID}','0','-1','2','','','OCI Block Volume - {#ID}','2',NULL,'','1','1','','','','','0','0','5030f7dadd5b40558e07a4545d7346bd','OCI BLOCK VOLUME - {#ID}','','',NULL,'0'),
('10622',NULL,'OCI Boot Volume - {#ID}','0','-1','2','','','OCI Boot Volume - {#ID}','2',NULL,'','1','1','','','','','0','0','914b808a4a014f6e824a3b9c53f1b492','OCI BOOT VOLUME - {#ID}','','',NULL,'0'),
('10623',NULL,'OCI Compute - {#ID}','0','-1','2','','','OCI Compute - {#ID}','2',NULL,'','1','1','','','','','0','0','9337374066e04291b2f94f8ad5470f54','OCI COMPUTE - {#ID}','','',NULL,'0'),
('10624',NULL,'OCI Autonomous DB - {#NAME}','0','-1','2','','','OCI Autonomous DB - {#NAME}','2',NULL,'','1','1','','','','','0','0','88d0076a057c441ab5a531cfcb650e84','OCI AUTONOMOUS DB - {#NAME}','','',NULL,'0'),
('10625',NULL,'OCI Bucket - {#NAME}','0','-1','2','','','OCI Bucket - {#NAME}','2',NULL,'','1','1','','','','','0','0','f71e979727ce42daa80a34da5ffb296f','OCI BUCKET - {#NAME}','','',NULL,'0'),
('10626',NULL,'OCI VCN - {#ID}','0','-1','2','','','OCI VCN - {#ID}','2',NULL,'','1','1','','','','','0','0','5329fee3dbc643ebbb99472c67a0a207','OCI VCN - {#ID}','','',NULL,'0'),
('10627',NULL,'AWS ELB Network Load Balancer by HTTP','3','-1','2','','','AWS ELB Network Load Balancer by HTTP','0',NULL,'The template is designed to monitor AWS ELB Network Load Balancer by HTTP via Zabbix, and it works without any external scripts.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','4c7d0c6e342b40458611bdb6e9dd958f','AWS ELB NETWORK LOAD BALANCER BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10628',NULL,'Website by Browser','3','-1','2','','','Website by Browser','0',NULL,'The template to monitor a website\'s availability and performance on the website by Browser.\r\n\r\nZabbix server uses a web browser to perform navigation and collect performance metrics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','2526dce71d714e31bd545e96370c67b2','WEBSITE BY BROWSER','Zabbix','7.0-1',NULL,'0'),
('10629',NULL,'Jira Data Center by JMX','3','-1','2','','','Jira Data Center by JMX','0',NULL,'This template is used for monitoring Jira Data Center health. It is designed for standalone operation for on-premises Jira installations.\r\n\r\nThis template uses a single data source, JMX, which requires JMX RMI setup of your Jira application and Java Gateway setup on the Zabbix side.\r\nIf you need "Garbage collector" and "Web server" monitoring, add "Generic Java JMX" and "Apache Tomcat by JMX" templates on the same host.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback\r\n\r\nSetup:\r\n  Metrics are collected by JMX.\r\n  0. Deploy the Zabbix Java Gateway component ([instructions](https://www.zabbix.com/documentation/7.0/manual/concepts/java)).\r\n  1. Enable and configure JMX access to Jira Data Center. See documentation for [instructions](https://confluence.atlassian.com/adminjiraserver/live-monitoring-using-the-jmx-interface-939707304.html).\r\n  2. Assign the "Jira Data Center by JMX" template to the host with a JMX interface.\r\n  2. If your Jira installation requires authentication for JMX, set the values in the host macros `{$JMX.USERNAME}` and `{$JMX.PASSWORD}`.\r\n  3. (Optional) Set custom macro values and add macros with context for specific metrics following the macro description.\r\n  4. (Optional) Assign the "Generic Java JMX" template for garbage collector monitoring.\r\n  5. (Optional) Assign the "Apache Tomcat by JMX" template for web server monitoring.\r\n\r\ntested_on:\r\n  - Jira Data Center 9.14.1\r\n  - Jira Data Center 9.12.4\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a7f0c853c6634b1dacaaf43c2a0d9375','JIRA DATA CENTER BY JMX','Zabbix','7.0-2',NULL,'0'),
('10630',NULL,'Azure VM Scale Set by HTTP','3','-1','2','','','Azure VM Scale Set by HTTP','0',NULL,'This template is designed to monitor Microsoft Azure virtual machine scale sets by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d0fd5d346b1740dda9d3a976371789dd','AZURE VM SCALE SET BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10631',NULL,'Azure VM scale set {#NAME}','0','-1','2','','','Azure VM scale set {#NAME}','2',NULL,'','1','1','','','','','0','0','1cbeb513fe3648b6829836800952c9c7','AZURE VM SCALE SET {#NAME}','','',NULL,'0'),
('10632',NULL,'AWS Lambda by HTTP','3','-1','2','','','AWS Lambda by HTTP','0',NULL,'The template is designed to monitor AWS Lambda by HTTP via Zabbix, and it works without any external scripts.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fd36e0a231d343d38a95d1ed789584ca','AWS LAMBDA BY HTTP','Zabbix','7.0-4',NULL,'0'),
('10633',NULL,'{#AWS.LAMBDA.NAME}','0','-1','2','','','{#AWS.LAMBDA.NAME}','2',NULL,'','1','1','','','','','0','0','7b468bda682c402b96fd55210aa85155','{#AWS.LAMBDA.NAME}','','',NULL,'0'),
('10634',NULL,'GitHub repository by HTTP','3','-1','2','','','GitHub repository by HTTP','0',NULL,'This template is designed for the effortless deployment of GitHub repository monitoring by Zabbix via GitHub REST API and doesn\'t require any external scripts.\r\n\r\nFor more details about GitHub REST API, refer to the official documentation:\r\nhttps://docs.github.com/en/rest?apiVersion=2022-11-28\r\n\r\nSetup:\r\n\r\n1. Create an access token for monitoring\r\n\r\nOne of the simplest ways to send authenticated requests is to use a personal access token - either a classic or a fine-grained one:\r\nhttps://docs.github.com/en/rest/authentication/authenticating-to-the-rest-api?apiVersion=2022-11-28#authenticating-with-a-personal-access-token\r\n\r\nClassic personal access token\r\n\r\nYou can create a new classic personal access token by following the instructions in the official documentation:\r\nhttps://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-personal-access-token-classic\r\n\r\nFor public repositories, no additional permission scopes are required. For monitoring to work on private repositories, the "repo" scope must be set to have full control of private repositories.\r\n\r\nAdditional information about OAuth scopes is available in the official documentation:\r\nhttps://docs.github.com/en/apps/oauth-apps/building-oauth-apps/scopes-for-oauth-apps#available-scopes\r\n\r\nNote that authenticated users must have admin access to the repository and the "repo" scope must be set to get information about self-hosted runners:\r\nhttps://docs.github.com/en/rest/actions/self-hosted-runners?apiVersion=2022-11-28#list-self-hosted-runners-for-a-repository\r\n\r\nFine-grained personal access token\r\n\r\nAlternatively, you can use a fine-grained personal access token:\r\nhttps://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens#creating-a-fine-grained-personal-access-token\r\n\r\nIn order to use fine-grained tokens to monitor organization-owned repositories, organizations must opt in to fine-grained personal access tokens and set up a personal access token policy:\r\nhttps://docs.github.com/en/organizations/managing-programmatic-access-to-your-organization/setting-a-personal-access-token-policy-for-your-organization\r\n\r\nThe fine-grained token needs to have the following permissions set to provide access to the repository resources:\r\n- "Actions" repository permissions (read);\r\n- "Administration" repository permissions (read);\r\n- "Contents" repository permissions (read);\r\n- "Issues" repository permissions (read);\r\n- "Metadata" repository permissions (read);\r\n- "Pull requests" repository permissions (read).\r\n\r\n2. Set the access token that you\'ve created in step 1 in the "{$GITHUB.API.TOKEN}" macro\r\n3. Change the API URL in the "{$GITHUB.API.URL}" macro if needed (for self-hosted installations)\r\n4. Set the repository owner name in the "{$GITHUB.REPO.OWNER}" macro\r\n5. Set the repository name in the "{$GITHUB.REPO.NAME}" macro\r\n6. Set the LLD rule filters if needed (you may want to use it to also stay within rate limits as on large repositories, LLD rules may generate a lot of script items)\r\n\r\nNote: Update intervals and timeouts for script items can be changed individually via "{$GITHUB.INTERVAL}" and "{$GITHUB.TIMEOUT}" macros with context. Depending on the repository being monitored, it can be adjusted if needed (if you are exceeding rate limits, you can increase update intervals for some script items to stay within per hour request limits). But be aware that it may also affect the triggers (check whether the item is used in triggers and adjust thresholds and/or evaluation periods if needed).\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','11144543d1144a3693aa0b97a1c20dac','GITHUB REPOSITORY BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10635',NULL,'Microsoft 365 reports by HTTP','3','-1','2','','','Microsoft 365 reports by HTTP','0',NULL,'This template is designed to monitor Microsoft 365 reports by HTTP. It works without any external scripts and uses script items.\r\nThe template uses endpoints in the Microsoft Graph API to gather daily metrics from weekly reports.\r\nThe template is meant to be used as a long-term trend monitoring tool.\r\n\r\nSetup:\r\n  1. Register the app with Microsoft Entra ID.\r\n  2. Configure Microsoft Graph application permissions on the app ID:\r\n    `Reports.Read.All` - required for app usage and activity metrics\r\n    `ServiceHealth.Read.All` - required for service discovery and service status metrics\r\n  3. Request administrator consent.\r\n  4. Configure the macros: `{$MS365.APP.ID}`, `{$MS365.PASSWORD}`, `{$MS365.TENANT.ID}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','03e93dc9a8194a17958544a056d02316','MICROSOFT 365 REPORTS BY HTTP','Zabbix','7.0-3',NULL,'0'),
('10636',NULL,'Huawei OceanStor Dorado by SNMP','3','-1','2','','','Huawei OceanStor Dorado by SNMP','0',NULL,'This template is developed to monitor SAN Huawei OceanStor Dorado via the Zabbix SNMP agent.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/418855-discussion-thread-for-official-zabbix-template-huawei-oceanstor\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','521d864fe8574f19b350f7ddbe259042','HUAWEI OCEANSTOR DORADO BY SNMP','Zabbix','7.0-3',NULL,'0'),
('10637',NULL,'Apache by Zabbix agent active','3','-1','2','','','Apache by Zabbix agent active','0',NULL,'Get metrics from mod_status module using HTTP agent.\r\nhttps://httpd.apache.org/docs/current/mod/mod_status.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384764-discussion-thread-for-official-zabbix-template-apache\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','aa3286a824464020863ead141e8f0afc','APACHE BY ZABBIX AGENT ACTIVE','Zabbix','7.0-1',NULL,'0'),
('10638',NULL,'Website certificate by Zabbix agent 2 active','3','-1','2','','','Website certificate by Zabbix agent 2 active','0',NULL,'The template to monitor TLS/SSL certificate on the website by Zabbix agent 2 that works without any external scripts.\r\n\r\nZabbix agent 2 with the WebCertificate plugin requests certificate using the web.certificate.get key and returns JSON with certificate attributes.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/428309-discussion-thread-for-official-zabbix-template-tls-ssl-certificates-monitoring\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','de38542cf4f24fafab33520677f392c4','WEBSITE CERTIFICATE BY ZABBIX AGENT 2 ACTIVE','Zabbix','7.0-1',NULL,'0'),
('10639',NULL,'Nginx by Zabbix agent active','3','-1','2','','','Nginx by Zabbix agent active','0',NULL,'Get metrics from stub status module using Zabbix agent running on Linux\r\nhttps://nginx.ru/en/docs/http/ngx_http_stub_status_module.html\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384765-discussion-thread-for-official-zabbix-template-nginx\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d2cebb67b4d94a12a072db85e7be6a33','NGINX BY ZABBIX AGENT ACTIVE','Zabbix','7.0-1',NULL,'0'),
('10640',NULL,'Nutanix Cluster Prism Element by HTTP','3','-1','2','','','Nutanix Cluster Prism Element by HTTP','0',NULL,'Prism Element: It is a service already built into the platform for every Nutanix cluster deployed. It provides the ability to fully configure, manage, and monitor Nutanix clusters running any hypervisors, however, It only manages the cluster it is part of.\r\n\r\nThis template is designed for the effortless deployment of Nutanix Cluster Prism Element monitoring and doesn\'t require any external scripts.\r\n\r\nThis template can be used in discovery, as well as manually linked to a host - to do so, attach it to the host and manually set the value of the \'{$NUTANIX.CLUSTER.UUID}\' macro.\r\n\r\nMore details can be found in the official documentation:\r\n  - on retrieving UUIDs: https://www.nutanixbible.com/19b-cli.html\r\n  - on the Nutanix Prism Element REST API: https://www.nutanix.dev/api_reference/apis/prism_v2.html\r\n  - on differences between Nutanix API versions: https://www.nutanix.dev/api-versions/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b6027e374e424481951ca2256099515c','NUTANIX CLUSTER PRISM ELEMENT BY HTTP','Zabbix','7.0-3',NULL,'0'),
('10641',NULL,'Nutanix Host Prism Element by HTTP','3','-1','2','','','Nutanix Host Prism Element by HTTP','0',NULL,'Prism Element: It is a service already built into the platform for every Nutanix cluster deployed. It provides the ability to fully configure, manage, and monitor Nutanix clusters running any hypervisors, however, It only manages the cluster it is part of.\r\n\r\nThis template is designed for the effortless deployment of Nutanix Host Prism Element monitoring and doesn\'t require any external scripts.\r\n\r\nThis template can be used in discovery, as well as manually linked to a host - to do so, attach it to the host and manually set the value of the \'{$NUTANIX.HOST.UUID}\' macro.\r\n\r\nMore details can be found in the official documentation:\r\n  - on retrieving UUIDs: https://www.nutanixbible.com/19b-cli.html\r\n  - on the Nutanix Prism Element REST API: https://www.nutanix.dev/api_reference/apis/prism_v2.html\r\n  - on differences between Nutanix API versions: https://www.nutanix.dev/api-versions/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8ab5387c8887435587cce8383b2fc6c5','NUTANIX HOST PRISM ELEMENT BY HTTP','Zabbix','7.0-3',NULL,'0'),
('10642',NULL,'Nutanix Prism Element by HTTP','3','-1','2','','','Nutanix Prism Element by HTTP','0',NULL,'Prism Element: It is a service already built into the platform for every Nutanix cluster deployed. It provides the ability to fully configure, manage, and monitor Nutanix clusters running any hypervisors, however, it only manages the cluster it is part of.\r\n\r\nThis template is designed for the effortless deployment of Nutanix Prism Element monitoring and doesn\'t require any external scripts.\r\n\r\nThe templates "Nutanix Host Prism Element by HTTP" and "Nutanix Cluster Prism Element by HTTP" can be used in discovery, as well as manually linked to a host.\r\n\r\nMore details can be found in the official documentation:\r\n  - on the Nutanix Prism Element REST API: https://www.nutanix.dev/api_reference/apis/prism_v2.html\r\n  - on the differences between Nutanix API versions: https://www.nutanix.dev/api-versions/\r\n  - on the differences between Nutanix Prism Element REST API and Nutanix Prism Central REST API: https://next.nutanix.com/how-it-works-22/differences-between-prism-element-prism-central-and-prism-pro-37137\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','0bb43a48a33f48ad910441384486edb4','NUTANIX PRISM ELEMENT BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10643',NULL,'{#NUTANIX.CLUSTER.UUID}','0','-1','2','','','{#NUTANIX.CLUSTER.NAME}','2',NULL,'','1','1','','','','','0','0','c1f630a16e304dcda7771895344638c7','{#NUTANIX.CLUSTER.NAME}','','',NULL,'0'),
('10644',NULL,'{#NUTANIX.HOST.UUID}','0','-1','2','','','{#NUTANIX.HOST.NAME}','2',NULL,'','1','1','','','','','0','0','24ccbeb75dc949ccb6c094416618443b','{#NUTANIX.HOST.NAME}','','',NULL,'0'),
('10645',NULL,'PHP-FPM by Zabbix agent active','3','-1','2','','','PHP-FPM by Zabbix agent active','0',NULL,'Get PHP-FPM metrics using Zabbix agent running on Linux.\r\n\r\nNote that depending on your OS distribution, the PHP-FPM process name may vary. Please, check the actual name in the line "Name" from /proc/<pid>/status file (https://www.zabbix.com/documentation/7.0/manual/appendix/items/proc_mem_num_notes) and change {$PHP_FPM.PROCESS.NAME.PARAMETER} macro if needed.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a9e83f950e9f41a78474d523c8376338','PHP-FPM BY ZABBIX AGENT ACTIVE','Zabbix','7.0-1',NULL,'0'),
('10646',NULL,'MySQL by Zabbix agent 2 active','3','-1','2','','','MySQL by Zabbix agent 2 active','0',NULL,'Requirements for template operation:\r\n\r\n1. Create a MySQL user for monitoring. For example:\r\n\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/grant.html.\r\n\r\nNOTE: In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the SLAVE MONITOR privilege to be set for the monitoring user:\r\n\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information please read the MariaDB documentation https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/.\r\n\r\n2. Set in the {$MYSQL.DSN} macro the data source name of the MySQL instance either session name from Zabbix agent 2 configuration file or URI.\r\nExamples: MySQL1, tcp://localhost:3306, tcp://172.16.0.10, unix:/var/run/mysql.sock\r\nFor more information about MySQL Unix socket file please read the MySQL documentation https://dev.mysql.com/doc/refman/8.0/en/problems-with-mysql-sock.html.\r\n\r\n3. If you had set URI in the {$MYSQL.DSN}, please define the user name and password in host macros ({$MYSQL.USER} and {$MYSQL.PASSWORD}).\r\nLeave macros {$MYSQL.USER} and {$MYSQL.PASSWORD} empty if you use a session name. Set the user name and password in the Plugins.Mysql.<...> section of your Zabbix agent 2 configuration file.\r\nFor more information about configuring the Zabbix MySQL plugin please read the documentation https://git.zabbix.com/projects/ZBX/repos/zabbix/browse/src/go/plugins/mysql/README.md.\r\n\r\nNOTE: In order to use this template for monitoring MySQL version 8.4 and later, Zabbix agent 2 version 7.0.22 and later should be used.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','51ffd432b9324ce2b04e1d4dc4122d16','MYSQL BY ZABBIX AGENT 2 ACTIVE','Zabbix','7.0-6',NULL,'0'),
('10647',NULL,'MySQL by Zabbix agent active','3','-1','2','','','MySQL by Zabbix agent active','0',NULL,'Requirements for template operation:\r\n\r\n1. Install Zabbix agent and MySQL client. If necessary, add the path to the \'mysql\' and \'mysqladmin\' utilities to the global environment variable PATH.\r\n\r\n2. Copy the \'template_db_mysql.conf\' file with user parameters into folder with Zabbix agent configuration (/etc/zabbix/zabbix_agentd.d/ by default). Don\'t forget to restart Zabbix agent.\r\n\r\n3. Create the MySQL user that will be used for monitoring (\'<password>\' at your discretion). For example:\r\n\r\nCREATE USER \'zbx_monitor\'@\'%\' IDENTIFIED BY \'<password>\';\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information, please see MySQL documentation (https://dev.mysql.com/doc/refman/8.0/en/grant.html).\r\n\r\nNOTE: In order to collect replication metrics, MariaDB Enterprise Server 10.5.8-5 and above and MariaDB Community Server 10.5.9 and above require the SLAVE MONITOR privilege to be set for the monitoring user:\r\n\r\nGRANT REPLICATION CLIENT,PROCESS,SHOW DATABASES,SHOW VIEW,SLAVE MONITOR ON *.* TO \'zbx_monitor\'@\'%\';\r\n\r\nFor more information, please read the MariaDB documentation (https://mariadb.com/docs/server/ref/mdb/privileges/SLAVE_MONITOR/).\r\n\r\n4. Create \'.my.cnf\' configuration file in the home directory of Zabbix agent for Linux distributions (/var/lib/zabbix by default) or \'my.cnf\' in c:\\ for Windows. For example:\r\n\r\n[client]\r\nprotocol=tcp\r\nuser=\'zbx_monitor\'\r\npassword=\'<password>\'\r\n\r\nFor more information, please see MySQL documentation (https://dev.mysql.com/doc/refman/8.0/en/option-files.html).\r\n\r\nNOTE: Linux distributions that use SELinux may require additional steps for access configuration.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384189-discussion-thread-for-official-zabbix-template-db-mysql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1ae69b01417849b180717f62ad7819d6','MYSQL BY ZABBIX AGENT ACTIVE','Zabbix','7.0-6',NULL,'0'),
('10648',NULL,'PostgreSQL by Zabbix agent 2 active','3','-1','2','','','PostgreSQL by Zabbix agent 2 active','0',NULL,'This template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent 2 and uses a loadable plugin to run SQL queries.\r\n\r\nSetup:\r\n\r\n1. Deploy Zabbix agent 2 with the PostgreSQL plugin. Starting with Zabbix versions 6.0.10 / 6.2.4 / 6.4 PostgreSQL metrics are moved to a loadable plugin and require installation of a separate package or compilation of the plugin from sources (https://www.zabbix.com/documentation/7.0/manual/extensions/plugins/build).\r\n\r\n2. Create the PostgreSQL user for monitoring (`<password>` at your discretion) and inherit permissions from the default role `pg_monitor`:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n\r\n3. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).\r\n\r\n4. Set the connection string for the PostgreSQL instance in the `{$PG.CONNSTRING.AGENT2}` macro as URI, such as `<protocol(host:port)>`, or specify the named session - `<sessionname>`.\r\n\r\nNote: if you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, a named session must be used. In that case, the instance URI should be specified in the `Plugins.PostgreSQL.Sessions.*.Uri` parameter in the PostgreSQL plugin configuration files alongside all the encryption parameters (type, certificate/key filepaths if needed etc.).\r\n\r\nYou can check the PostgreSQL plugin documentation (https://git.zabbix.com/projects/AP/repos/postgresql/browse?at=refs%2Fheads%2Frelease%2F7.0) for details about agent plugin parameters and named sessions.\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\nNote that plugin TLS certificate validation relies on checking the Subject Alternative Names (SAN) instead of the Common Name (CN), check the cryptography package documentation (https://pkg.go.dev/crypto/x509) for details.\r\n\r\nFor example, to enable required encryption in transport mode without identity checks you could create the file `/etc/zabbix/zabbix_agent2.d/postgresql_myconn.conf` with the following configuration for the named session `myconn` (replace `<instanceip>` with the address of the PostgreSQL instance):\r\nPlugins.PostgreSQL.Sessions.myconn.Uri=tcp://<instanceip>:5432\r\nPlugins.PostgreSQL.Sessions.myconn.TLSConnect=required\r\n\r\nThen set the `{$PG.CONNSTRING.AGENT2}` macro to `myconn` to use this named session.\r\n\r\n5. Set the password that you specified in step 2 in the macro `{$PG.PASSWORD}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','21cca24cec1d40cdb0c2999aa6ac3037','POSTGRESQL BY ZABBIX AGENT 2 ACTIVE','Zabbix','7.0-3',NULL,'0'),
('10649',NULL,'PostgreSQL by Zabbix agent active','3','-1','2','','','PostgreSQL by Zabbix agent active','0',NULL,'This template is designed for the deployment of PostgreSQL monitoring by Zabbix via Zabbix agent and uses user parameters to run SQL queries with the `psql` command-line tool.\r\n\r\nNote:\r\n- The template requires `pg_isready` and `psql` utilities to be installed on the same host with Zabbix agent.\r\n- The template requires files with SQL queries and user parameters that can be found in the Zabbix official repository:\r\nhttps://git.zabbix.com/projects/ZBX/repos/zabbix/browse/templates/db/postgresql?at=refs%2Fheads%2Frelease%2F6.0\r\n\r\nSetup:\r\n\r\n1. Deploy Zabbix agent and create the PostgreSQL user for monitoring (`<password>` at your discretion) with proper access rights to your PostgreSQL instance.\r\n\r\nFor PostgreSQL version 10 and above:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\' INHERIT;\r\nGRANT pg_monitor TO zbx_monitor;\r\n\r\nFor PostgreSQL version 9.6 and below:\r\nCREATE USER zbx_monitor WITH PASSWORD \'<PASSWORD>\';\r\nGRANT SELECT ON pg_stat_database TO zbx_monitor;\r\nALTER USER zbx_monitor WITH SUPERUSER;\r\n\r\n2. Copy the `postgresql/` directory to the `zabbix` user home directory - `/var/lib/zabbix/`. The `postgresql/` directory contains the files with SQL queries needed to obtain metrics from PostgreSQL instance.\r\n\r\nIf the home directory of the `zabbix` user doesn\'t exist, create it first:\r\nmkdir -m u=rwx,g=rwx,o= -p /var/lib/zabbix\r\nchown zabbix:zabbix /var/lib/zabbix\r\n\r\n3. Copy the `template_db_postgresql.conf` file, containing user parameters, to the Zabbix agent configuration directory `/etc/zabbix/zabbix_agentd.d/` and restart Zabbix agent service.\r\n\r\nIf you want to use SSL/TLS encryption to protect communications with the remote PostgreSQL instance, you can modify the connection string in user parameters. For example, to enable required encryption in transport mode without identity checks you could append `?sslmode=required` to the end of the connection string for all keys that use `psql`:\r\nUserParameter=pgsql.bgwriter[*], psql -qtAX postgresql://"$3":"$4"@"$1":"$2"/"$5"?sslmode=required -f "/var/lib/zabbix/postgresql/pgsql.bgwriter.sql"\r\n\r\nConsult the PostgreSQL documentation about protection modes (https://www.postgresql.org/docs/current/libpq-ssl.html#LIBPQ-SSL-PROTECTION) and client connection parameters (https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNECT-SSLMODE).\r\n\r\nAlso, it is assumed that you set up the PostgreSQL instance to work in the desired encryption mode. Check the PostgreSQL documentation (https://www.postgresql.org/docs/current/ssl-tcp.html) for details.\r\n\r\n4. Edit the `pg_hba.conf` configuration file to allow connections for the user `zbx_monitor`. You can check the PostgreSQL documentation for examples (https://www.postgresql.org/docs/current/auth-pg-hba-conf.html).\r\n\r\n5. Specify the host name or IP address in the `{$PG.HOST}` macro. Adjust the port number with `{$PG.PORT}` macro if needed.\r\n\r\n6. Set the password that you specified in step 1 in the macro `{$PG.PASSWORD}`.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/384190-%C2%A0discussion-thread-for-official-zabbix-template-db-postgresql\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','7005acc9123e4bc290805a3a16dab9cf','POSTGRESQL BY ZABBIX AGENT ACTIVE','Zabbix','7.0-2',NULL,'0'),
('10650',NULL,'Juniper MX by SNMP','3','-1','2','','','Juniper MX by SNMP','0',NULL,'The template for monitoring Juniper MX Series by SNMP.\r\n\r\nMIBs used:\r\nSNMPv2-MIB\r\nEtherLike-MIB\r\nHOST-RESOURCES-MIB\r\nIF-MIB\r\nOSPF-MIB\r\nJUNIPER-ALARM-MIB\r\nJUNIPER-DOM-MIB\r\nJUNIPER-MIB\r\nBGP4-V2-MIB-JUNIPER\r\nOSPFV3-MIB-JUNIPER\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','fe7eb8b22ce84017b07bcab36e9032dc','JUNIPER MX BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10651',NULL,'Azure SQL Managed Instance by HTTP','3','-1','2','','','Azure SQL Managed Instance by HTTP','0',NULL,'This template is designed to monitor Azure SQL Managed Instance by HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','a93f57ccc68e442da79bf4a20fe46570','AZURE SQL MANAGED INSTANCE BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10652',NULL,'Azure SQL managed instance {#NAME}','0','-1','2','','','Azure SQL managed instance {#NAME}','2',NULL,'','1','1','','','','','0','0','5211d232275145598294fc35bac96075','AZURE SQL MANAGED INSTANCE {#NAME}','','',NULL,'0'),
('10653',NULL,'Palo Alto PA-440 by HTTP','3','-1','2','','','Palo Alto PA-440 by HTTP','0',NULL,'This template is designed for the effortless deployment of Palo Alto PA-440 monitoring by Zabbix via XML API and doesn\'t require any external scripts.\r\n\r\nSetup:\r\n\r\nConfigure a user for monitoring. Note that in order to retrieve the device certificate information, superuser privileges are required. If you opt for a user with limited access (for security reasons), the device certificate expiration metrics will not be discovered.\r\n\r\nSuperuser privileges user (full access to all data):\r\n1. Add a new administrator user. Go to "Device" > "Administrators" and click "Add".\r\n2. Enter the necessary details. Set the "Administrator Type" to "Dynamic" and select the built-in "Superuser" role. Commit the changes.\r\n\r\nLimited privileges user (no access to device certificate data):\r\n1. Create a new Admin Role. Go to "Device" > "Admin Role" and click "Add".\r\n2. Enter the necessary details. Adjust the list of permissions:\r\n- Restrict access to all sections in the "Web UI" tab\r\n- Allow access to the "Configuration" and "Operational Requests" sections in the "XML API" tab\r\n- Check that the access to CLI is set to "None" in the "Command Line" tab\r\n- Restrict access to all sections in the "REST API" tab\r\n3. Add a new administrator user. Go to "Device" > "Administrators" and click "Add".\r\n4. Enter the necessary details. Set the "Administrator Type" to "Role Based" and select the profile that was created in the previous steps. Commit the changes.\r\n\r\nSet the host macros:\r\n1. Set the firewall XML API endpoint URL in the "{$PAN.PA440.API.URL}" macro in the format "<scheme>://<host>[:port]/api" (port is optional).\r\n2. Set the name of the user that you created in the "{$PAN.PA440.USER}" macro.\r\n3. Set the password of the user that you created in the "{$PAN.PA440.PASSWORD}" macro.\r\n\r\nFor more details about PAN-OS API, refer to the official documentation:\r\nhttps://docs.paloaltonetworks.com/pan-os/11-1/pan-os-panorama-api\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','edc752f178f94b9dbaee459ec7bacc66','PALO ALTO PA-440 BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10654',NULL,'DELL PowerEdge R660 by HTTP','3','-1','2','','','DELL PowerEdge R660 by HTTP','0',NULL,'Template for DELL PowerEdge R660 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','185867ae9b4a46b59d53931d3330c770','DELL POWEREDGE R660 BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10655',NULL,'DELL PowerEdge R660 by SNMP','3','-1','2','','','DELL PowerEdge R660 by SNMP','0',NULL,'Template for DELL PowerEdge R660 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3ba7dec7c0034d86ad1c73b4f8ee8994','DELL POWEREDGE R660 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10656',NULL,'DELL PowerEdge R750 by HTTP','3','-1','2','','','DELL PowerEdge R750 by HTTP','0',NULL,'Template for DELL PowerEdge R750 servers with iDRAC 8/9 firmware 4.32 and later and Redfish API enabled.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','42b18986c8b34c2d9c36f9cd00565bd5','DELL POWEREDGE R750 BY HTTP','Zabbix','7.0-2',NULL,'0'),
('10657',NULL,'DELL PowerEdge R750 by SNMP','3','-1','2','','','DELL PowerEdge R750 by SNMP','0',NULL,'Template for DELL PowerEdge R750 servers with iDRAC version 7 and later.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nIDRAC-MIB-SMIv2\r\nSNMPv2-MIB\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/426752-discussion-thread-for-official-zabbix-dell-templates\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','419145c8af7e4b8eb30af8460bbed566','DELL POWEREDGE R750 BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10658',NULL,'Zabbix proxy health by Zabbix agent','3','-1','2','','','Zabbix proxy health by Zabbix agent','0',NULL,'This template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy via the passive Zabbix agent.\r\n\r\nSpecify the address of the remote Zabbix proxy by changing the {$ZABBIX.PROXY.ADDRESS} and {$ZABBIX.PROXY.PORT} macros. Don\'t forget to adjust the "StatsAllowedIP" parameter in the remote proxy\'s configuration file to allow the collection of statistics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','8cd15d3b39654eb7b7423e6b109037b2','ZABBIX PROXY HEALTH BY ZABBIX AGENT','Zabbix','7.0-4',NULL,'0'),
('10659',NULL,'Zabbix proxy health by Zabbix agent active','3','-1','2','','','Zabbix proxy health by Zabbix agent active','0',NULL,'This template is designed to monitor internal Zabbix metrics on the remote Zabbix proxy via the active Zabbix agent.\r\n\r\nSpecify the address of the remote Zabbix proxy by changing the {$ZABBIX.PROXY.ADDRESS} and {$ZABBIX.PROXY.PORT} macros. Don\'t forget to adjust the "StatsAllowedIP" parameter in the remote proxy\'s configuration file to allow the collection of statistics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','02aac022a62c48bba810d07bbaa712cc','ZABBIX PROXY HEALTH BY ZABBIX AGENT ACTIVE','Zabbix','7.0-4',NULL,'0'),
('10660',NULL,'Zabbix server health by Zabbix agent','3','-1','2','','','Zabbix server health by Zabbix agent','0',NULL,'This template is designed to monitor Zabbix server metrics via the passive Zabbix agent.\r\n\r\nSpecify the address of the remote Zabbix server by changing the {$ZABBIX.SERVER.ADDRESS} and {$ZABBIX.SERVER.PORT} macros. Don\'t forget to adjust the "StatsAllowedIP" parameter in the remote server\'s configuration file to allow the collection of statistics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','d31c888d12aa4bf68f280bc242501743','ZABBIX SERVER HEALTH BY ZABBIX AGENT','Zabbix','7.0-6',NULL,'0'),
('10661',NULL,'Zabbix server health by Zabbix agent active','3','-1','2','','','Zabbix server health by Zabbix agent active','0',NULL,'This template is designed to monitor Zabbix server metrics via the active Zabbix agent.\r\n\r\nSpecify the address of the remote Zabbix server by changing the {$ZABBIX.SERVER.ADDRESS} and {$ZABBIX.SERVER.PORT} macros. Don\'t forget to adjust the "StatsAllowedIP" parameter in the remote server\'s configuration file to allow the collection of statistics.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6d6c147c87de4af1b09cf0f55bac50a0','ZABBIX SERVER HEALTH BY ZABBIX AGENT ACTIVE','Zabbix','7.0-6',NULL,'0'),
('10662',NULL,'Azure Microsoft SQL DTU Database by HTTP','3','-1','2','','','Azure Microsoft SQL DTU Database by HTTP','0',NULL,'This template is designed to monitor Microsoft SQL DTU-based databases via HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','c3a9fa0e07be4c1bbe19ae65c3375d17','AZURE MICROSOFT SQL DTU DATABASE BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10663',NULL,'Pure Storage FlashArray v1 by HTTP','3','-1','2','','','Pure Storage FlashArray v1 by HTTP','0',NULL,'Setup:\r\n1. Create a host for the Pure Storage FlashArray device and assign to it the "Pure Storage FlashArray v1 by HTTP" template.\r\n2. Enter your API token from the Purity//FA web interface into the {$PURE.FLASHARRAY.API.TOKEN} macro.\r\n3. Set your Purity//FA web interface URL as the {$PURE.FLASHARRAY.API.URL} macro value.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','ae3ce7156aae4ae79a72742365c884ea','PURE STORAGE FLASHARRAY V1 BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10664',NULL,'Pure Storage FlashArray v2 by HTTP','3','-1','2','','','Pure Storage FlashArray v2 by HTTP','0',NULL,'Setup:\r\n1. Create a host for the Pure Storage FlashArray device and assign to it the "Pure Storage FlashArray v2 by HTTP" template.\r\n2. Enter your API token from the Purity//FA web interface into the {$PURE.FLASHARRAY.API.TOKEN} macro.\r\n3. Set your Purity//FA web interface URL as the {$PURE.FLASHARRAY.API.URL} macro value.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','44990575121d4798b9e10520604c786c','PURE STORAGE FLASHARRAY V2 BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10665',NULL,'Azure Backup Jobs by HTTP','3','-1','2','','','Azure Backup Jobs by HTTP','0',NULL,'This template is designed to monitor Azure Backup Jobs via HTTP.\r\nIt works without any external scripts and uses the script item.\r\n\r\nSetup:\r\n  1. Create an Azure service principal via the Azure command-line interface (Azure CLI) for your subscription.\r\n    `az ad sp create-for-rbac --name zabbix --role reader --scope /subscriptions/<subscription_id>`\r\n    See https://docs.microsoft.com/en-us/cli/azure/create-an-azure-service-principal-azure-cli for more details.\r\n  2. Link the template to a host.\r\n  3. Configure the macros: {$AZURE.APP.ID}, {$AZURE.PASSWORD}, {$AZURE.TENANT.ID}, {$AZURE.SUBSCRIPTION.ID}, and {$AZURE.RESOURCE.ID}.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','3d527f609e344ed8a4ec19762c31c619','AZURE BACKUP JOBS BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10666',NULL,'Azure vault {#NAME}','0','-1','2','','','Azure vault {#NAME}','2',NULL,'','1','1','','','','','0','0','fb057eebe3fb4d2483c8a3e7fe4c7b07','AZURE VAULT {#NAME}','','',NULL,'0'),
('10667',NULL,'Cisco Secure Firewall Threat Defense by HTTP','3','-1','2','','','Cisco Secure Firewall Threat Defense by HTTP','0',NULL,'This template is designed to monitor Cisco Secure Firewall Threat Defense devices using the REST API.\r\nIt provides metrics such as CPU and memory usage, interface statistics, connection tracking, and more.\r\nThe template includes items, triggers, and graphs to help you monitor the performance and health of your Cisco Secure Firewall Threat Defense devices.\r\nIt is based on the Cisco Secure Firewall Threat Defense REST API and requires the API URL, username, and password to be set as macros.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1818cd052f174772a48bfc275d0016dd','CISCO SECURE FIREWALL THREAT DEFENSE BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10668',NULL,'AWS Backup Vault by HTTP','3','-1','2','','','AWS Backup Vault by HTTP','0',NULL,'The template is designed to monitor AWS Backup vaults and jobs by HTTP via Zabbix, and it works without any external scripts.\r\nDon\'t forget to read the README.md for the correct setup of the template.\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback.\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','024cf4f0711c4c39a4e016858efc5e37','AWS BACKUP VAULT BY HTTP','Zabbix','7.0-1',NULL,'0'),
('10669',NULL,'{#AWS.BACKUP_VAULT.NAME}','0','-1','2','','','{#AWS.BACKUP_VAULT.NAME}','2',NULL,'','1','1','','','','','0','0','44f23ddbb22646aea4db43a90646f695','{#AWS.BACKUP_VAULT.NAME}','','',NULL,'0'),
('10670',NULL,'Aruba CX 8300s by SNMP','3','-1','2','','','Aruba CX 8300s by SNMP','0',NULL,'Aruba CX8300s by SNMP\r\n\r\nMIBs used:\r\nARUBAWIRED-FAN-MIB\r\nARUBAWIRED-POWERSUPPLY-MIB\r\nARUBAWIRED-SYSTEMINFO-MIB\r\nARUBAWIRED-TEMPSENSOR-MIB\r\nOSPF-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','5265860748e14dea8ed58b35fd9fe3d1','ARUBA CX 8300S BY SNMP','Zabbix','7.0-1',NULL,'0'),
('10671',NULL,'Ciena 3906 by SNMP','3','-1','2','','','Ciena 3906 by SNMP','0',NULL,'Ciena 3906 by SNMP\r\n\r\nMIBs used:\r\nWWP-LEOS-BLADE-MIB\r\nWWP-LEOS-CHASSIS-MIB\r\nWWP-LEOS-SYSTEM-CONFIG-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b1271833815f46499458a8631d0bda20','CIENA 3906 BY SNMP','Zabbix','7.0-1',NULL,'0'),
('10672',NULL,'Vyatta Virtual Router by SNMP','3','-1','2','','','Vyatta Virtual Router by SNMP','0',NULL,'Template for Vyatta Virtual Router 1908e\r\n\r\nMIBs used:\r\n  * SNMPv2-MIB\r\n  * HOST-RESOURCES-MIB\r\n  * UCD-SNMP-MIB\r\n  * IF-MIB\r\n  * DISMAN-EVENT-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','33c77d08d94242b88703eea0fb6c2d91','VYATTA VIRTUAL ROUTER BY SNMP','Zabbix','7.0-2',NULL,'0'),
('10673',NULL,'Stormshield SNS by SNMP','3','-1','2','','','Stormshield SNS by SNMP','0',NULL,'The template for monitoring SNS firewall by SNMP.\r\n\r\nMIBs used:\r\nHOST-RESOURCES-MIB\r\nUCD-SNMP-MIB\r\nSTORMSHIELD-ASQ-STATS-MIB\r\nSTORMSHIELD-AUTOUPDATE-MIB\r\nSTORMSHIELD-HA-MIB\r\nSTORMSHIELD-PROPERTY-MIB\r\nSTORMSHIELD-HEALTH-MONITOR-MIB\r\nSTORMSHIELD-IF-MIB\r\nSTORMSHIELD-SYSTEM-MONITOR-MIB\r\nSTORMSHIELD-IPSEC-STATS-MIB\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','1945f22f8ba84ce89454d9513979a3c6','STORMSHIELD SNS BY SNMP','Zabbix','7.0-1',NULL,'0'),
('10674',NULL,'Ribbon SBC Edge by HTTP','3','-1','2','','','Ribbon SBC Edge by HTTP','0',NULL,'The Ribbon Session Border Controller Edge (SBC Edge) is a security and interoperability solution for medium-sized businesses and large branch offices.\r\n\r\nThis template is designed for the effortless deployment of Ribbon SBC Edge monitoring and doesn\'t require any external scripts.\r\n\r\nMore details can be found in the official Ribbon documentation:\r\n- REST API Reference: https://publicdoc.rbbn.com/spaces/UXAPIDOC/pages/17400598/Configuration+Resources\r\n- REST API User\'s Guide: https://publicdoc.rbbn.com/spaces/UXAPIDOC/pages/387008766/REST+API+User+s+Guide\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6095f32a1e6f432a8a053e6245891632','RIBBON SBC EDGE BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10675',NULL,'Ribbon SBC SWe CE by HTTP','3','-1','2','','','Ribbon SBC SWe CE by HTTP','0',NULL,'The Ribbon SBC Software Edition (SBC SWe) provides the same feature set as the award-winning SBC 5400 and SBC 7000 appliance, without requiring dedicated hardware.\r\nThis gives enterprises the flexibility to deploy SBC functionality in a variety of environments – in their own data centers, on private cloud infrastructure, or in a public cloud.\r\n\r\nThis template is designed for the effortless deployment of Ribbon SBC SWe Core monitoring and doesn\'t require any external scripts.\r\n\r\nThe template can be used in discovery as well as manually linked to a host. To use this template manually linked to a host, attach it to the host and manually set the value of the `{$RIBBON.CE.NAME}` macro.\r\n\r\nMore details can be found in the official documentation:\r\n  - REST API Reference: https://publicdoc.rbbn.com/spaces/SBXCONFAPIDOC/pages/360972436/RESTCONF+API+Reference+Guide\r\n  - REST API User Guide: https://publicdoc.rbbn.com/spaces/SBXCONFAPIDOC/pages/444760643/RESTCONF+API+User+Guide\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','682ac14a5d294f4790ac8411ab6c33bf','RIBBON SBC SWE CE BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10676',NULL,'Ribbon SBC SWe Core by HTTP','3','-1','2','','','Ribbon SBC SWe Core by HTTP','0',NULL,'The Ribbon SBC Software Edition (SBC SWe) provides the same feature set as the award-winning SBC 5400 and SBC 7000 appliances, without requiring dedicated hardware.\r\nThis gives enterprises the flexibility to deploy SBC functionality in a variety of environments – in their own data centers, on private cloud infrastructure, or in a public cloud.\r\n\r\nThis template is designed for the effortless deployment of Ribbon SBC SWe Core monitoring and doesn\'t require any external scripts.\r\n\r\nMore details can be found in the official documentation:\r\n  - REST API Reference Guide: https://publicdoc.rbbn.com/spaces/SBXCONFAPIDOC/pages/360972436/RESTCONF+API+Reference+Guide\r\n  - REST API User Guide: https://publicdoc.rbbn.com/spaces/SBXCONFAPIDOC/pages/444760643/RESTCONF+API+User+Guide\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','b917e122785c4bd4bd004e69badc93de','RIBBON SBC SWE CORE BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10677',NULL,'{#CE.NAME}','0','-1','2','','','{#CE.NAME}','2',NULL,'','1','1','','','','','0','0','df47e752f85d4c22a519b4f9e6e04ab9','{#CE.NAME}','','',NULL,'0'),
('10678',NULL,'VeloCloud SD-WAN Edge by HTTP','3','-1','2','','','VeloCloud SD-WAN Edge by HTTP','0',NULL,'Template for monitoring VeloCloud SD-WAN Edges https://www.arista.com/en/solutions/sd-wan\r\n\r\nYou can discuss this template or leave feedback on our forum https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/\r\n\r\nGenerated by official Zabbix template tool "Templator"','1','1','','','','','0','0','6fd1bd7226934f498169202ba4e9a482','VELOCLOUD SD-WAN EDGE BY HTTP','Zabbix','7.0-0',NULL,'0'),
('10679',NULL,'{#EDGE.NAME}','0','-1','2','','','{#EDGE.NAME}','2',NULL,'','1','1','','','','','0','0','5896745a4b844f1a826d5dd060bc2b5b','{#EDGE.NAME}','','',NULL,'0');
INSERT INTO `hgset_group` (`hgsetid`,`groupid`) VALUES ('1','15'),
('2','18'),
('3','17'),
('4','12'),
('4','9'),
('5','21'),
('6','4'),
('7','9'),
('8','12'),
('9','16'),
('10','11'),
('11','10'),
('12','13'),
('13','10'),
('13','9');
INSERT INTO `host_hgset` (`hostid`,`hgsetid`) VALUES ('10001','11'),
('10047','8'),
('10048','8'),
('10074','11'),
('10075','11'),
('10076','11'),
('10077','11'),
('10078','11'),
('10079','11'),
('10081','11'),
('10084','6'),
('10169','8'),
('10171','10'),
('10172','10'),
('10173','8'),
('10174','8'),
('10175','8'),
('10207','7'),
('10208','7'),
('10210','7'),
('10211','7'),
('10218','7'),
('10220','7'),
('10221','7'),
('10222','7'),
('10223','7'),
('10224','7'),
('10226','7'),
('10227','7'),
('10229','7'),
('10230','7'),
('10231','7'),
('10233','7'),
('10234','7'),
('10235','7'),
('10236','7'),
('10237','7'),
('10248','11'),
('10249','11'),
('10250','7'),
('10251','7'),
('10253','7'),
('10254','7'),
('10255','10'),
('10256','10'),
('10258','10'),
('10259','10'),
('10260','8'),
('10261','8'),
('10262','8'),
('10264','8'),
('10265','8'),
('10266','8'),
('10267','8'),
('10285','11'),
('10300','8'),
('10301','8'),
('10302','8'),
('10303','8'),
('10304','10'),
('10308','8'),
('10309','8'),
('10310','12'),
('10316','12'),
('10317','12'),
('10318','8'),
('10319','8'),
('10320','12'),
('10321','10'),
('10322','8'),
('10323','12'),
('10324','8'),
('10325','8'),
('10326','8'),
('10327','12'),
('10328','12'),
('10329','12'),
('10330','8'),
('10331','8'),
('10335','12'),
('10336','1'),
('10343','11'),
('10351','11'),
('10353','8'),
('10355','8'),
('10357','12'),
('10358','8'),
('10359','8'),
('10360','8'),
('10361','8'),
('10362','8'),
('10363','8'),
('10364','8'),
('10365','8'),
('10366','8'),
('10369','8'),
('10370','12'),
('10371','7'),
('10372','7'),
('10373','7'),
('10374','7'),
('10375','7'),
('10376','7'),
('10377','7'),
('10378','9'),
('10379','8'),
('10380','3'),
('10381','12'),
('10382','8'),
('10385','9'),
('10386','12'),
('10387','12'),
('10390','7'),
('10391','7'),
('10392','7'),
('10393','7'),
('10394','7'),
('10395','2'),
('10396','9'),
('10397','12'),
('10398','12'),
('10399','12'),
('10400','2'),
('10401','2'),
('10402','2'),
('10403','2'),
('10404','2'),
('10406','2'),
('10407','2'),
('10408','2'),
('10409','2'),
('10410','8'),
('10411','8'),
('10412','2'),
('10413','8'),
('10414','8'),
('10415','8'),
('10416','8'),
('10417','12'),
('10418','7'),
('10419','7'),
('10420','7'),
('10421','7'),
('10422','7'),
('10423','7'),
('10424','7'),
('10425','7'),
('10426','7'),
('10427','7'),
('10428','7'),
('10429','7'),
('10430','7'),
('10431','7'),
('10432','7'),
('10433','7'),
('10434','10'),
('10435','10'),
('10436','10'),
('10437','10'),
('10438','10'),
('10439','10'),
('10440','10'),
('10441','10'),
('10442','10'),
('10443','10'),
('10444','10'),
('10445','10'),
('10446','10'),
('10447','8'),
('10448','8'),
('10449','7'),
('10450','7'),
('10451','7'),
('10452','7'),
('10453','7'),
('10454','7'),
('10455','7'),
('10456','7'),
('10457','7'),
('10458','7'),
('10459','7'),
('10460','7'),
('10461','7'),
('10462','7'),
('10463','7'),
('10464','7'),
('10465','7'),
('10466','7'),
('10467','7'),
('10468','7'),
('10469','7'),
('10470','7'),
('10471','7'),
('10472','7'),
('10473','7'),
('10474','7'),
('10475','7'),
('10476','7'),
('10477','7'),
('10478','7'),
('10479','7'),
('10480','7'),
('10481','7'),
('10482','7'),
('10483','7'),
('10484','7'),
('10485','7'),
('10486','7'),
('10487','7'),
('10488','7'),
('10489','7'),
('10490','7'),
('10491','7'),
('10492','7'),
('10493','7'),
('10494','7'),
('10495','7'),
('10496','7'),
('10497','7'),
('10498','7'),
('10499','7'),
('10500','7'),
('10501','7'),
('10502','7'),
('10503','7'),
('10504','8'),
('10505','8'),
('10506','8'),
('10507','8'),
('10509','8'),
('10510','8'),
('10515','8'),
('10516','8'),
('10517','8'),
('10518','8'),
('10519','12'),
('10520','8'),
('10521','8'),
('10522','8'),
('10524','9'),
('10525','9'),
('10526','9'),
('10527','5'),
('10528','8'),
('10529','5'),
('10530','5'),
('10531','5'),
('10532','5'),
('10534','10'),
('10535','5'),
('10539','5'),
('10540','5'),
('10543','5'),
('10544','5'),
('10546','4'),
('10547','4'),
('10548','4'),
('10551','7'),
('10552','8'),
('10553','8'),
('10555','8'),
('10556','8'),
('10557','5'),
('10558','5'),
('10560','8'),
('10561','8'),
('10562','8'),
('10563','7'),
('10564','7'),
('10565','10'),
('10566','10'),
('10568','5'),
('10570','5'),
('10571','5'),
('10572','5'),
('10573','5'),
('10574','5'),
('10575','5'),
('10576','5'),
('10577','5'),
('10582','5'),
('10583','5'),
('10584','5'),
('10586','5'),
('10587','5'),
('10589','12'),
('10590','4'),
('10591','4'),
('10593','8'),
('10594','8'),
('10595','8'),
('10596','8'),
('10599','8'),
('10600','8'),
('10602','8'),
('10603','7'),
('10604','7'),
('10605','10'),
('10606','5'),
('10607','5'),
('10609','12'),
('10610','12'),
('10611','12'),
('10613','7'),
('10614','5'),
('10615','5'),
('10616','5'),
('10617','5'),
('10618','5'),
('10619','5'),
('10620','5'),
('10627','5'),
('10628','8'),
('10629','8'),
('10630','5'),
('10632','5'),
('10634','8'),
('10635','8'),
('10636','9'),
('10637','8'),
('10638','8'),
('10639','8'),
('10640','8'),
('10641','8'),
('10642','8'),
('10645','8'),
('10646','12'),
('10647','12'),
('10648','12'),
('10649','12'),
('10650','7'),
('10651','5'),
('10653','7'),
('10654','10'),
('10655','10'),
('10656','10'),
('10657','10'),
('10658','8'),
('10659','8'),
('10660','8'),
('10661','8'),
('10662','5'),
('10663','9'),
('10664','9'),
('10665','5'),
('10667','7'),
('10668','5'),
('10670','7'),
('10671','7'),
('10672','7'),
('10673','13'),
('10674','7'),
('10675','7'),
('10676','7'),
('10678','7');
INSERT INTO `group_prototype` (`group_prototypeid`,`hostid`,`name`,`groupid`,`templateid`) VALUES ('2','10333','{#DATACENTER.NAME}',NULL,NULL),
('4','10334','{#CLUSTER.NAME} (vm)',NULL,NULL),
('6','10334','{#HV.NAME}',NULL,NULL),
('17','10367','{#DATACENTER.NAME}',NULL,NULL),
('19','10368','{#CLUSTER.NAME} (vm)',NULL,NULL),
('21','10368','{#HV.NAME}',NULL,NULL),
('35','10388','MongoDB sharded cluster/{#REPLICASET}',NULL,NULL),
('37','10389','MongoDB sharded cluster/{#ID}',NULL,NULL),
('54','10334','{#DATACENTER.NAME}/{#VM.FOLDER} (vm)',NULL,NULL),
('57','10368','{#DATACENTER.NAME}/{#VM.FOLDER} (vm)',NULL,NULL),
('152','10523','Consul cluster/{#NODE_DATACENTER}',NULL,NULL),
('153','10523','','19',NULL),
('155','10511','','19',NULL),
('156','10512','','19',NULL),
('157','10514','','19',NULL),
('158','10513','','19',NULL),
('159','10333','','19',NULL),
('160','10334','','19',NULL),
('161','10367','','19',NULL),
('162','10368','','19',NULL),
('163','10388','','20',NULL),
('164','10389','','20',NULL),
('166','10511','{#CLUSTER_HOSTNAME}: Kubernetes/Components: {#COMPONENT.API}',NULL,NULL),
('167','10512','{#CLUSTER_HOSTNAME}: Kubernetes/Components: {#COMPONENT.CONTROLLER}',NULL,NULL),
('168','10514','{#CLUSTER_HOSTNAME}: Kubernetes/Components: {#COMPONENT}',NULL,NULL),
('169','10513','{#CLUSTER_HOSTNAME}: Kubernetes/Components: {#COMPONENT.SCHEDULER}',NULL,NULL),
('170','10533','','6',NULL),
('171','10536','','6',NULL),
('172','10537','','20',NULL),
('173','10538','','19',NULL),
('175','10541','','20',NULL),
('176','10545','','20',NULL),
('177','10549','','19',NULL),
('178','10550','','19',NULL),
('179','10550','{#REGION}',NULL,NULL),
('180','10554','','19',NULL),
('181','10554','Control-M/{#SERVER.NAME}',NULL,NULL),
('182','10559','','20',NULL),
('183','10567','','19',NULL),
('184','10567','{#CLUSTER_HOSTNAME}: Kubernetes/Nodes/Role: {#ROLES}',NULL,NULL),
('185','10569','','20',NULL),
('186','10578','','20',NULL),
('187','10579','','20',NULL),
('188','10580','','20',NULL),
('189','10581','','6',NULL),
('190','10585','','19',NULL),
('191','10588','','6',NULL),
('192','10592','','19',NULL),
('193','10592','Cisco SD-WAN/{#TYPE}',NULL,NULL),
('194','10597','','19',NULL),
('195','10598','','19',NULL),
('196','10601','','19',NULL),
('197','10608','','19',NULL),
('198','10612','','20',NULL),
('199','10621','','19',NULL),
('200','10622','','19',NULL),
('201','10623','','6',NULL),
('202','10624','','20',NULL),
('203','10625','','19',NULL),
('204','10626','','19',NULL),
('205','10631','','6',NULL),
('206','10633','','19',NULL),
('207','10333','{#CLUSTER.NAME} (hypervisor)',NULL,NULL),
('208','10367','{#CLUSTER.NAME} (hypervisor)',NULL,NULL),
('209','10643','','19',NULL),
('210','10644','','19',NULL),
('211','10652','','20',NULL),
('212','10666','','19',NULL),
('213','10669','','19',NULL),
('214','10677','','19',NULL),
('215','10679','','5',NULL);
INSERT INTO `interface` (`interfaceid`,`hostid`,`main`,`type`,`useip`,`ip`,`dns`,`port`) VALUES ('1','10084','1','1','1','127.0.0.1','','10050'),
('2','10333','1','1','1','{#HV.IP}','','10050'),
('3','10334','1','1','1','{#VM.IP}','','10050'),
('4','10367','1','1','1','{#HV.IP}','','10050'),
('5','10368','1','1','1','{#VM.IP}','','10050'),
('7','10511','1','1','1','{#IP}','','10050'),
('8','10512','1','1','1','{#IP}','','10050'),
('9','10513','1','1','1','{#IP}','','10050'),
('10','10514','1','1','1','{#IP}','','10050'),
('11','10523','1','1','1','{#NODE_ADDRESS}','','10050'),
('12','10536','1','1','1','{#AWS.EC2.INSTANCE.ID}','','10050'),
('13','10537','1','1','1','{#AWS.RDS.INSTANCE.ID}','','10050'),
('14','10538','1','1','1','{#AWS.S3.NAME}','','10050'),
('15','10567','1','1','1','{#IP}','','10050'),
('19','10581','0','1','1','{#GCE.INSTANCE.EXT.IP}','external.ip','10050'),
('20','10581','1','1','1','{#GCE.INSTANCE.IP}','internal.ip','10050'),
('21','10578','0','1','1','{#CLOUD_SQL.INSTANCE.EXT.IP}','external.ip','10050'),
('22','10578','1','1','1','{#CLOUD_SQL.INSTANCE.IP}','internal.ip','10050'),
('23','10579','0','1','1','{#CLOUD_SQL.INSTANCE.EXT.IP}','external.ip','10050'),
('24','10579','1','1','1','{#CLOUD_SQL.INSTANCE.IP}','internal.ip','10050'),
('25','10580','0','1','1','{#CLOUD_SQL.INSTANCE.EXT.IP}','external.ip','10050'),
('26','10580','1','1','1','{#CLOUD_SQL.INSTANCE.IP}','internal.ip','10050'),
('27','10592','0','1','1','{#INT.IP}','internal.ip','10050'),
('28','10592','1','1','1','{#IP}','external.ip','10050'),
('29','10597','1','1','1','{#CLIENT.IP}','','10050'),
('30','10598','1','1','1','{#SERVER.IP}','','10050');
INSERT INTO `valuemap` (`valuemapid`,`hostid`,`name`,`uuid`) VALUES ('13','10264','Service state','452297e814a84b08a72730a7b777e378'),
('14','10265','Service state','a5d1f911fb264bd4bc087ea582626d7f'),
('15','10266','Service state','53c8528c18814f30a45d1540ab9e5c00'),
('16','10267','Service state','5c0883d194e8494498474106c22be2ca'),
('17','10301','Service state','c369d410303349b4973431b6ff8dcb85'),
('18','10303','Service state','aaf7d0b8b306412b8a3272343708518f'),
('19','10308','Service state','4980ec41c6644ecb9d5b52027a381fd8'),
('20','10309','Service state','a8a0c20f1d404a79900064ac5d11a8b2'),
('21','10310','Service state','ae3eec95cd1c440ba6c67ed5d7b7b915'),
('22','10316','Service state','4f2d7ca3c89246c6b691557447230031'),
('23','10317','Service state','622c38d0af2a4b6ea7a640a5d1a22b93'),
('24','10318','Service state','8effc3f81db14540996e2373dde6eca9'),
('25','10319','Service state','acd57d4f29a34286a801ce49cd6553fe'),
('26','10320','Service state','f2e8233fcf0a4dd2b53a82ca48436a88'),
('27','10322','Service state','15d416d869894fdb959ca2cda2c5e37c'),
('28','10323','Service state','94147888c7ad4f5bae864eb2698f0237'),
('29','10324','Service state','1735a8d251b24c3fbab32e766064536b'),
('30','10325','Service state','5f3f78a3470c48b69442d942f21d11d0'),
('31','10326','Service state','41be60c561114627b861677603b92acb'),
('32','10327','Service state','03cde96b90a641598db572a662dc2064'),
('33','10328','Service state','45ad479873b84113a98fa21b21081c65'),
('34','10330','Service state','1caa1e7c41e14c7492ab8112f93ea068'),
('35','10331','Service state','8e8fa515c14c4ac181db791c2c68c518'),
('36','10335','Service state','31c489581d8b4246942c663b88fbaf9f'),
('37','10336','Service state','d6e38832f2d44ec0bf6761e36fd7668f'),
('38','10353','Service state','22fe6d6c74454775994f07fc05d7bafd'),
('39','10355','Service state','1bd791d250e441aeb1c73e499d96e98e'),
('40','10357','Service state','372bc939f3924aafa13c4821b83a9276'),
('41','10363','Service state','6c967c4df18d4c7ebb0fd4be17df292a'),
('42','10365','Service state','547a6b8002d44a8f8f363023c6097b1e'),
('43','10175','Service state','25d04e2838af4fcca9ddd21df6781497'),
('44','10378','Service state','d3b3a064c6e445db8b9179ac79d257bf'),
('46','10325','Windows service state','d65f1af3c1e24a338983c52c5aa07d27'),
('47','10326','Windows service state','6dc834d8e50842d3a7337b0f88540b61'),
('51','10174','VMware VirtualMachinePowerState','78f08f5c5c0047b999a2e8daa96cf8b7'),
('52','10173','VMware status','3c59c22905054d42ac4ee8b72fe5f270'),
('53','10175','VMware status','2b324fd8d7624874a3a81449b62c2cd6'),
('54','10366','VMware status','5e5e3b01ef334bd39441568ebd0c31c0'),
('55','10047','Value cache operating mode','97bbea700550483bbd8405b4dd9d8005'),
('56','10261','Value cache operating mode','5dff563dde3c45d8b6d92525111384c6'),
('57','10251','ENTITY-SENSORS-MIB::EntitySensorStatus','d42214398aea4362b4fc61a090f188e1'),
('58','10254','ENTITY-SENSORS-MIB::EntitySensorStatus','318f3041aea04848a223de86e589c232'),
('64','10285','ifOperStatus','4827063819f14d539f509552c84f5f94'),
('71','10207','TIMETRA-CHASSIS-MIB::TmnxDeviceState','95a194271a584008a81564fd80189c5a'),
('72','10208','SW-MIB::swSensorStatus','73618556ee4b4e8f9ec9acf0893e13ea'),
('73','10208','SW-MIB::swOperStatus','54427fdf694547c598e3662df09a980a'),
('74','10210','FOUNDRY-SN-AGENT-MIB::snChasPwrSupplyOperStatus','fe1c4f9f35a34b6189110fc95e21b086'),
('75','10211','FOUNDRY-SN-AGENT-MIB::snChasPwrSupplyOperStatus','7b767e61825544bb857347f303a1f077'),
('76','10210','FOUNDRY-SN-AGENT-MIB::snChasFanOperStatus','d457efd8cee74f168bd88f4fb2376142'),
('77','10211','FOUNDRY-SN-AGENT-MIB::snChasFanOperStatus','41fadae69fa64af4a21c853fc00f23c0'),
('79','10221','F10-S-SERIES-CHASSIS-MIB::chSysFanTrayOperStatus','b389c759db0448ffbe28d4572fbfb3e9'),
('80','10221','F10-S-SERIES-CHASSIS-MIB::chSysPowerSupplyOperStatus','2532df482bd348ba8202c3eb2b76340b'),
('81','10222','MY-SYSTEM-MIB::mySystemFanIsNormal','5889e276245d411bacd130427ae4a5d4'),
('82','10223','EQUIPMENT-MIB::swFanStatus','e7ab460cf1bf4fca8afc22566257fc3a'),
('83','10223','EQUIPMENT-MIB::swPowerStatus','a46e6b21933f4aa7be17f9f11b1356ee'),
('84','10224','EXTREME-SYSTEM-MIB::extremeFanOperational','b71a1b2d06324275a37a1952f13e29b3'),
('85','10224','EXTREME-SYSTEM-MIB::extremeOverTemperatureAlarm','34c686dbaf8649b3b7dcc243068a739a'),
('86','10224','EXTREME-SYSTEM-MIB::extremePowerSupplyStatus','85bfdbc16637406fb5f1a23a15f16c77'),
('87','10227','HH3C-ENTITY-EXT-MIB::hh3cEntityExtErrorStatus','d7832aa00dd743bb8451cabff4e90e60'),
('88','10250','HP-ICF-CHASSIS::hpicfSensorStatus','3c0731bf0669419fa8ebfdf9f7ec14de'),
('89','10229','HUAWEI-ENTITY-EXTENT-MIB::hwEntityFanState','5d3f20a830b34f668c5f3ece41a039cd'),
('90','10230','ICS-CHASSIS-MIB::icsChassisFanOperStatus','39299506ad14445fa7b7a9e78cc54619'),
('91','10230','ICS-CHASSIS-MIB::icsChassisSensorSlotOperStatus','4c80241c4d5d4b949577e9741710a32b'),
('92','10230','ICS-CHASSIS-MIB::icsChassisPowerSupplyOperStatus','535cb21845474749994bf7c395e39312'),
('93','10231','JUNIPER-ALARM-MIB::jnxRedAlarmState','3aaa451c55cd4e72ab84b65dd8310564'),
('94','10231','JUNIPER-ALARM-MIB::jnxOperatingState','64128e7f2adf44988b0ca3edd76cba61'),
('95','10251','ENTITY-STATE-MIB::EntityOperState','bd1dc90aa54849d0a5ae9bdf368d03a9'),
('96','10254','ENTITY-STATE-MIB::EntityOperState','15ba17df88eb435d9d48145fba8d9029'),
('97','10234','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesPowSupplyItemState','d11e2b2f01c641728d1b7f764fa49f37'),
('98','10234','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesFanItemState','3046d246b1064c749c1c9144442c0fac'),
('99','10234','FASTPATH-BOXSERVICES-PRIVATE-MIB::boxServicesTempSensorState','4da55a4de7284012890e1fd5458f039a'),
('100','10235','QTECH-MIB::sysFanStatus','fe2ada3a06844e138b3c4fed1a8c8d2d'),
('101','10235','QTECH-MIB::sysPowerStatus','439cee4220954720aa34725fdc6c365e'),
('102','10256','CPQSINFO-MIB::status','8374297ea234491b980591a8daa88e1f'),
('103','10256','CPQHLTH-MIB::cpqHeTemperatureLocale','f1e590a8cc744e22b900595851833357'),
('104','10256','CPQIDA-MIB::cpqDaCntlrModel','140a21785b764c95a3f78c8c05ed0844'),
('105','10256','CPQIDA-MIB::cpqDaPhyDrvStatus','68bc7370fb8a43ee9957240e29636562'),
('106','10258','IMM-MIB::systemHealthStat','61bded84be1d419083d8bd8a8bd25152'),
('107','10255','IDRAC-MIB-SMIv2::ObjectStatusEnum','7cf6cc68df264e1f9cb0373b1fbca6a8'),
('108','10255','IDRAC-MIB-SMIv2::StatusProbeEnum','beb79217c0854cc4b83d6c498a92067c'),
('109','10255','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','1125af03f5a24d84866e7ad7c1789fb4'),
('110','10255','IDRAC-MIB-SMIv2::BooleanType','1026b6847bd44fb5885bdfab49042d32'),
('111','10255','IDRAC-MIB-SMIv2::physicalDiskMediaType','8abb91818b39418d9ba1b83cd5078870'),
('112','10255','IDRAC-MIB-SMIv2::batteryState','4709491dc6ea41958de78e939e1b7964'),
('113','10255','IDRAC-MIB-SMIv2::virtualDiskLayout','150fd042191d4417a29df8dc554dae06'),
('114','10255','IDRAC-MIB-SMIv2::virtualDiskOperationalState','79a1e3792c20400bba39073240987448'),
('115','10255','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','d9103bd7f6934230a67ae98607183788'),
('116','10255','IDRAC-MIB-SMIv2::virtualDiskState','41e6acc448194f3aac2612904ce851ad'),
('117','10256','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','54b288da67e1431c9d401cf47a518bcc'),
('118','10256','CPQIDA-MIB::cpqDaAccelStatus','20d96ea63e994ba49244b94a4c24aec3'),
('119','10256','CPQIDA-MIB::cpqDaAccelBattery','7502d61cf7644a2d9cff7462f53569ee'),
('120','10256','CPQIDA-MIB::cpqDaPhyDrvMediaType','8351a024aa4d42d1915b44abe8acc4aa'),
('121','10256','CPQIDA-MIB::cpqDaLogDrvFaultTol','442c9095de9f4aa5bcca659292b2c12b'),
('122','10256','CPQIDA-MIB::cpqDaLogDrvStatus','8db38b47aba64739ae9f078f43b42888'),
('123','10329','PostgreSQL recovery role','9f38c01c325248d4b538c0582432b541'),
('124','10357','PostgreSQL recovery role','2e376ee568d04e7bbe98cbae4181f313'),
('125','10329','PostgreSQL replication status','0fba38eefa4c4073b46d3f8579fda314'),
('126','10357','PostgreSQL replication status','7f553f18ef6544ceaa4b50c4ebf0e583'),
('128','10285','Linux::Interface protocol types','4d912f1ee95942038f306ddefb3a57b3'),
('134','10301','RabbitMQ healthcheck','08ee896f31a1457a8e9b4f6f251700d4'),
('135','10303','RabbitMQ healthcheck','55188bbb2ede4300a6292b373ee36ab7'),
('136','10301','Alarm state','ce579def20ac488dbce1ff69baaa8c50'),
('137','10303','Alarm state','e65c3d3e8ea443a281b37c51ca461c26'),
('138','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentOperability','e1686896f31e483f9add962dbbd90afb'),
('139','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsLsOperState','398aa5bf5eb44a8c8dd96babd98f1bd3'),
('140','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStoragePDriveStatus','9b7c7078039c4e348ab417da71b96f5c'),
('141','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageLunType','7d3e38476c894ae59ecac6640b24f833'),
('142','10304','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentPresence','5055674c42a241e3a2156de1dc1715bf'),
('143','10310','Redis bgwrite status','098c2240a8e947fc9f6f0a677ffcbc0e'),
('144','10310','Redis flag','3b6cd97c65d14e10bdabf5c42d767ad9'),
('145','10310','Redis repl offset','47c80efdf46745f1959eee76f68014e7'),
('146','10310','Redis bgsave time','82f4dc4ef0c9471d82dbe3605f4f31d0'),
('147','10318','Docker flag','c289195aa4dc47ab883fa95c9cb6fd07'),
('148','10322','ES cluster state','d651bdf75d0849d5ab2b0802fab76e22'),
('149','10323','Replicas state','4d926c30529447b3816cec3f1440b47a'),
('150','10324','Etcd healthcheck','f25e21a70baa4e009bdbcb44acb1a22e'),
('151','10324','Etcd leader','7bcaf8a520e24613a96d49e63a91a55b'),
('152','10325','Application pool state','63d1ad6b4cf643da870b14c53da6c52f'),
('153','10326','Application pool state','636c6915a8154b6ea1ea5b00f015c149'),
('154','10327','MSSQL DB state','bac1a10dad134d50add5bc9550e2ebf3'),
('155','10327','MSSQL AG Connected state','bfbb00eb85d747dabeda2954a5d659b7'),
('156','10327','MSSQL AG Join state','47413c135c094cdc8b59f18a9b195a78'),
('157','10327','MSSQL AG Operational state','a570f341d9a8470797aecfebd376b2b8'),
('158','10327','MSSQL AG Recovery health','4ec6a96ff6c64756b2f27e47972fd9f6'),
('159','10327','MSSQL AG Role','596556fba6064efb8155233371eb2950'),
('160','10327','MSSQL AG Synchronization health','2ab0923b3ce14ffc9dd454114f6b15be'),
('161','10327','MSSQL - Yes / No','c66ee50a8b3f4b6788b732bb8a6b514e'),
('162','10327','MSSQL Mirroring State','f1c105c262c5476798a93eaa4c46fbda'),
('163','10327','MSSQL Mirroring Role','09aaa82ccd6a444b80d5d3bb182fbafd'),
('164','10327','MSSQL Safety level','e70421b2c3db4ce1937791bdb432040e'),
('165','10327','MSSQL Witness state','aa9de6e21d08486db04f29e10d11a94c'),
('166','10328','Oracle DB open status','d0912db18fe54941b9345ebf869fd1a6'),
('167','10335','Oracle DB open status','015a0c94ba2644c6aa343d3f792a4072'),
('168','10328','Oracle DB role','df05d594141f42ebb294cf6adca5fd6b'),
('169','10335','Oracle DB role','afade10cda4e453982355342ba9d8d9f'),
('170','10328','Oracle instance status','41e105c52bf045899c3c4a1cb4e16865'),
('171','10335','Oracle instance status','4893318c780f47719e12e839c9a846c2'),
('172','10328','Oracle instance role','97b689d7ddc04bcd9b9f92af6ba783bd'),
('173','10335','Oracle instance role','53d97b73db8449959420e03114d345c3'),
('174','10328','Oracle archiver state','3afaab75342c4be186fb4f595ed62a31'),
('175','10335','Oracle archiver state','f39e64058fef423bb858ba45834a3455'),
('176','10328','Oracle tablespace status','c6633e4ef9a84fa7b843529479a06158'),
('177','10335','Oracle tablespace status','f14ed94cf12740a19e221ddaa4855c54'),
('178','10328','Oracle Archivelog status','79af6c068ba141ba9806f4341edd9266'),
('179','10335','Oracle Archivelog status','5a90da8dd6124159a7f82a7a996f0a53'),
('180','10328','Oracle force log status','f00ca5c45ab84df788820af2642e4784'),
('181','10335','Oracle force log status','1d9f4a44f2f94a799768f147cb712331'),
('182','10328','Oracle log mode','809554f521d645ea8e8850c3b1f41579'),
('183','10335','Oracle log mode','910dd4a87f75434289fa2e345778d18d'),
('184','10353','Ceph cluster status','2a4b2a8c55ba48b2a815e4123c9ea7fa'),
('185','10360','Exchange database copy role','4a0e19e58ade4e8c878a6b87f4021416'),
('186','10361','Exchange database copy role','0797c152a163407aa9490a63f80a8fd1'),
('187','10360','Exchange database state','2d131c4a033c4145a6bd66ec4c0c030a'),
('188','10361','Exchange database state','a4fac47b56e4470c9c6d435d7eb06845'),
('189','10362','GitLab healthcheck','3b40391bb8b6472e9c3fd8e1f001fe04'),
('190','10364','Kafka controller state','cf2440fb69c24371b231cb0a69002333'),
('191','10365','Vault flag','46edbd58c7384b53bb31775244c23343'),
('192','10371','ProStar MPPT charge state','1703c3aeb1b24641821e1c6d2cb4c8b7'),
('193','10371','ProStar MPPT load state','b5403a0805a54b9294f69a1e11a438b1'),
('194','10372','ProStar PWM charge state','f94eb6ad54c44281878c7c018c6209d1'),
('195','10372','ProStar PWM load state','f0be8765c74e4c4788d4ff99a6c5ccd4'),
('196','10373','SunSaver MPPT charge state','b51b9440e801481fbb76f28b4a5431d1'),
('197','10373','SunSaver MPPT load state','f21076ed51104b84ba4d78dd74bd1a5b'),
('198','10374','SureSine load state','1d6f60ea7d414cb8a26ddad70fc352b2'),
('199','10375','TriStar MPPT 600V charge state','8a0dfdf98d254c219905751cccc878d7'),
('200','10376','TriStar MPPT charge state','3c6c60ef422c4788bf0c5b74ffab7ef0'),
('201','10377','TriStar PWM charge state','4985c4742d5844e7bc0aee5aeeacc436'),
('202','10377','TriStar PWM control mode','252c3fb63cc34bb1a36ae6e9cbe5880c'),
('203','10377','TriStar PWM load state','735e1a0d990a4c449e59eeb402f3b40e'),
('204','10378','FAS3220 HA cannot takeover cause','e078162b11ff49f59c3ab6d905f88f2c'),
('205','10378','FAS3220 HA settings','d6993f0258dd4978a85aa5c141f1706e'),
('206','10378','FAS3220 NVRAM battery status','1fe2bf70bd63468584708a9d09eb42a1'),
('207','10378','FAS3220 Port health','ee5e67c90bca4ded84df2d82589bc2fb'),
('208','10378','FAS3220 Port link state','bd6ea858292c414d9bfd435631001ef5'),
('209','10378','FAS3220 Port role','c598c387157d4450b5bf8f68e6e794a4'),
('210','10378','FAS3220 Port speed','6b0fec10a0eb4c70a8982419c6e635b9'),
('211','10378','FAS3220 Port UP by administrator','c50cdd6dbe19482abdb870c12e7c7b8d'),
('212','10379','Computer online','d1b719ea85464279bd473fcdb34008da'),
('213','10379','Computer state','5313fc2399b24216945ed6416a00d55d'),
('214','10379','Jenkins healthcheck','a51dacf033d1423a886ca9dbfdf9b175'),
('215','10379','Service state','b45a6b0148074212bf45d6bb311565c2'),
('216','10380','Login status','4c14241141504a9d852d83965c309f31'),
('217','10256','CPQHLTH-MIB::cpqHeTemperatureCondition','1a03c5602a4a49f8839d820c666434fc'),
('218','10382','HTTP response status code','70add725d6a84f6f9ed0917107dfffc9'),
('219','10385','Huawei storage: Controller role','b5c6d9d67da54531a918c93a9c98cec8'),
('220','10385','Huawei storage: Health status','b7f399070ee0419cac1722f80268ff1a'),
('221','10385','Huawei storage: LUN status','e361f6b8fe92430f86d0e3dc70118ba9'),
('222','10385','Huawei storage: Running status','ae5093d843784258aa32437cde486574'),
('223','10300','RabbitMQ healthcheck','78275d6daacf42b4b97e3d806dfe81fe'),
('224','10302','RabbitMQ healthcheck','3380e05a15774dad92e77c983448698b'),
('225','10386','MongoDB flag','9f921e1503e74204b8f128966f9562bc'),
('226','10386','ReplicaSet node state','a99141555eff42ff8d367f10d9a7c569'),
('227','10386','Service state','b37ba44823e34a13a119f86f3d58a65a'),
('228','10387','MongoDB flag','2014769595e34d4bb18dbcf4d9eaf112'),
('229','10387','Service state','3cedce4712fa4a3eba63ccd7a790ecf6'),
('230','10390','CISCO-ENVMON-MIB::CiscoEnvMonState','673c7626d11b4867aba08e96b0fbd149'),
('231','10390','EtherLike-MIB::dot3StatsDuplexStatus','4c04fea7546044d9a9c64762a9e1ebdd'),
('232','10390','IF-MIB::ifOperStatus','346b197cb4fe42cb9b304ce246e5924f'),
('233','10390','IF-MIB::ifType','94e4f1da1ff24b96bdccf04ec663a1ae'),
('234','10390','Service state','3a72216b3fea4ad482d0e3655e407747'),
('235','10390','zabbix.host.available','868c28a7406c4ab3b48b783a6e7590ba'),
('236','10391','CISCO-ENVMON-MIB::CiscoEnvMonState','cbeb53fa3c2a4b16b7f7ee92265efd8c'),
('237','10391','EtherLike-MIB::dot3StatsDuplexStatus','5ef472cb5f424ef9a7393156204613ba'),
('238','10391','IF-MIB::ifOperStatus','73b7c034142043b689792e1e71dd5872'),
('239','10391','IF-MIB::ifType','635461b9ca404cc1b92c1fab0c6327f6'),
('240','10391','Service state','142fe822cc424a76899551b6f29799d9'),
('241','10391','zabbix.host.available','939c7551b81e40e9b053e624211d0901'),
('242','10392','CISCO-ENVMON-MIB::CiscoEnvMonState','fea34445b6cd4847b420d212f9b0201e'),
('243','10392','EtherLike-MIB::dot3StatsDuplexStatus','867b0e42f8a24a278ee15476aeadfa0b'),
('244','10392','IF-MIB::ifOperStatus','3534f9f22afe4f98a712a86ce755f491'),
('245','10392','IF-MIB::ifType','88b99531b08248e8be1fc0a3210acee1'),
('246','10392','Service state','653ce2314e6f499b84250048df1314f8'),
('247','10392','zabbix.host.available','690c4c1545894d049ac8e26e3de7ec9c'),
('248','10393','CISCO-ENVMON-MIB::CiscoEnvMonState','e47b3ba8fb9c4ecf82701ddf571d55b6'),
('249','10393','EtherLike-MIB::dot3StatsDuplexStatus','412b00b4bfbc48b4906370635c12dcee'),
('250','10393','IF-MIB::ifOperStatus','358db91b44e645df92072f0a1449de2e'),
('251','10393','IF-MIB::ifType','877039dc6b0a467783828f3421887b83'),
('252','10393','Service state','1d4c62bd989748a0b7947b6455405d96'),
('253','10393','zabbix.host.available','ff706c036eac4ef88570e41629e65514'),
('254','10394','CISCO-ENVMON-MIB::CiscoEnvMonState','52875f5c6b1b4bb3987c3baa03860d4d'),
('255','10394','EtherLike-MIB::dot3StatsDuplexStatus','8decf4d7d8744711b5f2ea68b5e73d14'),
('256','10394','IF-MIB::ifOperStatus','e8815fad611e47389c987c88a029cece'),
('257','10394','IF-MIB::ifType','93f29c48ad8b4bc7afe036817d946b18'),
('258','10394','Service state','ee7cb62782d44458abc9f7cca816dca8'),
('259','10394','zabbix.host.available','6273854a740e41718cd1354f227cf4db'),
('260','10251','IF-MIB::ifOperStatus','04fa3aad27e044a094dce939b3d361ec'),
('261','10251','IF-MIB::ifType','afe0ce28ed5d49dd822cc7013356c599'),
('262','10251','Service state','deb16b99706645929e300b0590f013f3'),
('263','10251','zabbix.host.available','a85fe23199cd4d779655f690a706d7c7'),
('264','10395','PowerNet-MIB::uioSensorStatusAlarmStatus','a808aadebf964e0cb6b8724bf1165013'),
('265','10395','PowerNet-MIB::upsAdvBatteryReplaceIndicator','731b036e41d147ba81bfcfb7e99b561b'),
('266','10395','PowerNet-MIB::upsAdvInputLineFailCause','f310a0bceb06404d9daee67ab578e4b8'),
('267','10395','PowerNet-MIB::upsBasicBatteryStatus','795c75c652124ad282bad3dfd50b8e39'),
('269','10395','zabbix.host.available','781c568d935d40f2a43951488cf2e046'),
('270','10327','MSSQL Job Run Status','eefa6e0e6f8b4facbc12004437b7ee8f'),
('271','10397','Service state','bce54cbdf2b8487985f9c7847a4c4918'),
('272','10398','Service state','047f0303f1bc424a959f5d0ceaab77c7'),
('273','10400','PowerNet-MIB::uioSensorStatusAlarmStatus','30a78904cbc94fc58609dc1a11aa48ef'),
('274','10400','PowerNet-MIB::upsAdvBatteryReplaceIndicator','ace379c23ae247f3b92ccffb9eef920c'),
('275','10400','PowerNet-MIB::upsAdvInputLineFailCause','19686fc030ee4c6bb69aacd3b9c735ca'),
('276','10400','PowerNet-MIB::upsBasicBatteryStatus','80593b554d0a431aa89a0c4960f8565c'),
('277','10400','PowerNet-MIB::upsBasicOutputStatus','f41b7d5469e64557ab0cdb81526aeac0'),
('278','10400','zabbix.host.available','edd7578bf71146dd88770a39eec537e0'),
('279','10401','PowerNet-MIB::uioSensorStatusAlarmStatus','6940a4d08173433bb4bc8ff3b44e578c'),
('280','10401','PowerNet-MIB::upsAdvBatteryReplaceIndicator','add26e1622ed4d1fbdb4a9bdbf7facb8'),
('281','10401','PowerNet-MIB::upsAdvInputLineFailCause','2597173167e34be0943fb6c81f2597e5'),
('282','10401','PowerNet-MIB::upsBasicBatteryStatus','7d2a66214d4b4b96890aa9e1c9bcf050'),
('283','10401','PowerNet-MIB::upsBasicOutputStatus','351383a7383a4472a31c09009cf9d1f5'),
('284','10401','zabbix.host.available','3aadc179423b4298b2e8a6e4850466a5'),
('285','10402','PowerNet-MIB::uioSensorStatusAlarmStatus','55fecbd639c44c328b4199569a7305ef'),
('286','10402','PowerNet-MIB::upsAdvBatteryReplaceIndicator','1ce6860b108948bda40d514fd4e3ed69'),
('287','10402','PowerNet-MIB::upsAdvInputLineFailCause','db1fa20d76c8416c83fa0b7fda536fa8'),
('288','10402','PowerNet-MIB::upsBasicBatteryStatus','50b6ae187875406ea8ba1669add70899'),
('289','10402','PowerNet-MIB::upsBasicOutputStatus','9c5fd52c36f6451ea3f502a871e821d7'),
('290','10402','zabbix.host.available','89597d423b454a42aa80fa8f7a20f273'),
('291','10403','PowerNet-MIB::uioSensorStatusAlarmStatus','7cf932d3b9304f2cb151134e9ea3be82'),
('292','10403','PowerNet-MIB::upsAdvBatteryReplaceIndicator','63c5f0e1601947e5a02abd25a07a9af4'),
('293','10403','PowerNet-MIB::upsAdvInputLineFailCause','70d097ce846c45aeb3c8be031c427511'),
('294','10403','PowerNet-MIB::upsBasicBatteryStatus','3424a9229a134b47b8544d611be082fb'),
('295','10403','PowerNet-MIB::upsBasicOutputStatus','05a60d9c47274f5a8f6c92efe8158b8e'),
('296','10403','zabbix.host.available','d4ee88b3cf5d4d95b27be2e7b2f20e3c'),
('297','10404','PowerNet-MIB::uioSensorStatusAlarmStatus','b2af1e2dcb874d43949c383f9b347f36'),
('298','10404','PowerNet-MIB::upsAdvBatteryReplaceIndicator','b06b54b07e6840e5a0c52ba7a6acf86a'),
('299','10404','PowerNet-MIB::upsAdvInputLineFailCause','a62f96735c47467da94b6bcf98cc013d'),
('300','10404','PowerNet-MIB::upsBasicBatteryStatus','ed12e8780c384caba8035fbb1c78e115'),
('301','10404','PowerNet-MIB::upsBasicOutputStatus','ae2ed0c2c99a4ad496f7a35226e3d4f0'),
('302','10404','zabbix.host.available','8cddc4f99ecb4866b1638b82b145ea8b'),
('309','10406','PowerNet-MIB::uioSensorStatusAlarmStatus','864d59cbfcc8431cb334b812bf7ef3a3'),
('310','10406','PowerNet-MIB::upsAdvBatteryReplaceIndicator','cc42cb7a7fb4417fa1c143e214958c1d'),
('311','10406','PowerNet-MIB::upsAdvInputLineFailCause','a3bbd0be8c7c4dc1aa9accb9f22292c9'),
('312','10406','PowerNet-MIB::upsBasicBatteryStatus','f801d4fb07c644e4be1f01e99ba48aa7'),
('313','10406','PowerNet-MIB::upsBasicOutputStatus','28964e9cf2b849fbb2f8d998cecdacda'),
('314','10406','zabbix.host.available','12058346f9e046388767c2939bbed2cf'),
('315','10395','PowerNet-MIB::upsBasicOutputStatus','c536d9dc64724643a9291c9b601b1eac'),
('316','10407','PowerNet-MIB::uioSensorStatusAlarmStatus','aec3362485c242ec928cb8ecfe5e61cf'),
('317','10407','PowerNet-MIB::upsAdvBatteryReplaceIndicator','912d8834176b4fe4a2f6bd12ef3ee3c1'),
('318','10407','PowerNet-MIB::upsAdvInputLineFailCause','e079fa8cc9614245b0fecf4b8f42feca'),
('319','10407','PowerNet-MIB::upsBasicBatteryStatus','24229472978c42739cdbe7aa47e1d34c'),
('320','10407','PowerNet-MIB::upsBasicOutputStatus','8c2c9721615c4408976f7632180ecfe3'),
('321','10407','zabbix.host.available','625f28bd49f14e49a1a7a4da01429906'),
('322','10408','PowerNet-MIB::uioSensorStatusAlarmStatus','8516e97893ed4f2ebe70766d17eeacde'),
('323','10408','PowerNet-MIB::upsAdvBatteryReplaceIndicator','84387eb0a5ef4523ac5d990eb4a6a796'),
('324','10408','PowerNet-MIB::upsAdvInputLineFailCause','58104ecf15d34fe38922f3fe5fa25027'),
('325','10408','PowerNet-MIB::upsBasicBatteryStatus','43715c15fed840fc8e188d062c0ef2da'),
('326','10408','PowerNet-MIB::upsBasicOutputStatus','d9b5340729684dd0a450b6de6b14b590'),
('327','10408','zabbix.host.available','cdf3578a66db4cfda6c36b4bbb295173'),
('328','10409','PowerNet-MIB::uioSensorStatusAlarmStatus','e2877a188bd24918992f8c7878550924'),
('329','10409','PowerNet-MIB::upsAdvBatteryReplaceIndicator','33d83523ceee4f3e916c885ebb33e8b9'),
('330','10409','PowerNet-MIB::upsAdvInputLineFailCause','c50ef9a9476d47e6935a6026bbb24d06'),
('331','10409','PowerNet-MIB::upsBasicBatteryStatus','96a985d8351f48be86c5b00472b48feb'),
('332','10409','PowerNet-MIB::upsBasicOutputStatus','160f7a39770d492c93403097650c1568'),
('333','10409','zabbix.host.available','cc7a368057bc47eeb834dc9363183c59'),
('334','10410','WildFly flag','e23e06cfd0ce4e069b9d996f101f6ee6'),
('335','10411','WildFly flag','4004b5f2501f44a69dc86afce3daa4d1'),
('336','10412','PowerNet-MIB::uioSensorStatusAlarmStatus','41e166e2a5f948488238198920ab4b17'),
('337','10412','PowerNet-MIB::upsAdvBatteryReplaceIndicator','224af0a6a5db48ef9c8861bc61873ea9'),
('338','10412','PowerNet-MIB::upsAdvInputLineFailCause','ded19296204545b9ab463d4fc65f3cfd'),
('339','10412','PowerNet-MIB::upsBasicBatteryStatus','271d8f0594cf451a8aaa98c84850ebf7'),
('340','10412','PowerNet-MIB::upsBasicOutputStatus','171d4d5bf01442e391b04f9e448df5a0'),
('341','10412','zabbix.host.available','8b4f199f5e704cbea67182d4abf9b8de'),
('342','10308','Server mode','bf2e9463450d4f4899abcac85cde0a92'),
('343','10309','Server mode','450c1b2c6d58432b8a5b34dd3b5e8870'),
('344','10416','Unit Active State','fe20979701834a80a823c514d11c19e7'),
('345','10416','Unit File State','e0a5e55e5a074a26935386c5e29a0e36'),
('346','10416','Unit Load State','0309ef57e92a4ea2ae4404a685f0e7b8'),
('347','10418','Cisco ASAv algorithm validate packets','764f7c162b8a45d9b41e795cf2f5f8da'),
('348','10418','Cisco ASAv encryption algorithm','f38e3c5200c941aa831857698eb3ea8b'),
('349','10418','Cisco ASAv port admin status','8395b87d3ff3496aabafdfd1d2e1c4be'),
('350','10418','Cisco ASAv port operational status','e97c331986454b68917c771c3bba9a3d'),
('351','10418','Cisco ASAv session protocol','22e5704487924e4ebca70e2062d40da4'),
('352','10418','Cisco ASAv user authenticate method','8dd72ccb744e4bd989ea739e21da7820'),
('353','10418','Physical class','3c3b7c75af4b4fedb12e30fb74406a23'),
('354','10418','SNMP available','91e8696b05654efca8f03b700ea74b0b'),
('355','10419','Chassis status','849febb31f524e9296afc5ec6ffb2fe3'),
('356','10419','Module provision level','ed7e1317987b433e9aa7168db3824c94'),
('357','10419','Pause state','6e590fa7db7441d5a4b145204ee254bb'),
('358','10419','SNMP available','b615a47192fc48f4b2cedb205c33f7d0'),
('359','10420','SNMP available','2b7c7c3eecb743e8a30ab3adc74ffd06'),
('360','10420','ZYXEL AAM1212-51 / IES-612 port admin status','db7f61bebcac452c8081b2c58d1013d8'),
('361','10420','ZYXEL AAM1212-51 / IES-612 port operational status','6c2a29dac43340399990340fe26a7a72'),
('362','10421','SNMP available','494c8983c4cf453789d2f0bbbe5cbbf3'),
('363','10421','ZYXEL ES3500-8PD operational mode port link up type','7cfe02e1eb224f6abe5216aaec31402c'),
('364','10421','ZYXEL ES3500-8PD operational mode port speed duplex','b568c9f69a1a4dd5951f1121523475c9'),
('365','10421','ZYXEL ES3500-8PD port admin status','4a20dd55c16b4c9082f267c532a4507a'),
('366','10421','ZYXEL ES3500-8PD port operational status','17635045a1ee4b8bba21b7d44634c57f'),
('367','10421','ZYXEL ES3500-8PD SFP status','875833a6ca71431da2b3747c4c1e3008'),
('368','10422','SNMP available','c6ba6086ed584ba0a4dd58ffe8564fbf'),
('369','10422','ZYXEL GS-4012F operational mode port link up type','82cce670bef64a47b326bb8b1a2f6cd8'),
('370','10422','ZYXEL GS-4012F operational mode port speed duplex','d7d38cadffc240f9a01434546659d036'),
('371','10422','ZYXEL GS-4012F port admin status','7456d212b8f44f7da215fc86f39e3956'),
('372','10422','ZYXEL GS-4012F port operational status','afa699db0bfc4cfbb48729932967230e'),
('373','10423','SNMP available','10dd3d9951014a38bc3517df54381a66'),
('374','10423','ZYXEL IES-500x module status','efd6a6086011465ca956b1664f7d6474'),
('375','10423','ZYXEL IES-500x module type','892651d2b1e3431490f2c531a50e2732'),
('376','10423','ZYXEL IES-500x port admin status','9174dafc199e438994256eff4dd87bdd'),
('377','10423','ZYXEL IES-500x port operational status','f64c046f1eca45e09dad683603f4674b'),
('378','10424','SNMP available','5247e9e5efcd4b29b864e336619eafcf'),
('379','10424','ZYXEL IES-6000 module status','0236177f088340ff8ce5adb9361b8df8'),
('380','10424','ZYXEL IES-6000 module type','7ad4e124b8184fb8abc454c70c67e309'),
('381','10424','ZYXEL IES-6000 port admin status','b20f50ac559f45369de16c04f5ccf523'),
('382','10424','ZYXEL IES-6000 port operational status','2f3b061e1d6f46a3b8216b2398fc2896'),
('383','10425','SNMP available','34ea860866f24498927b73f4ce438837'),
('384','10425','ZYXEL IES1248-51 port admin status','b933d3a98256457d906de8f7da377bac'),
('385','10425','ZYXEL IES1248-51 port operational status','e780cc91765849a0ace3d2eb2e4824a0'),
('386','10426','SNMP available','ac3d8b1e51074733a8bce57814528d83'),
('387','10426','ZYXEL MES-3528 operational mode port link up type','042fc0ecdef34baab224062d4f746b96'),
('388','10426','ZYXEL MES-3528 operational mode port speed duplex','cce63413576040fe8df5969886da993d'),
('389','10426','ZYXEL MES-3528 port admin status','6220d70f35404dd6834674510e0ae9ea'),
('390','10426','ZYXEL MES-3528 port operational status','36e992f6794a492e87c3c5a9749e26b3'),
('391','10426','ZYXEL MES-3528 SFP status','da9692b414de47d5bac9cd3287492e0b'),
('392','10427','SNMP available','7ad9362759b542d98a67796dd13fc5d4'),
('393','10427','ZYXEL MES3500-10 operational mode port link up type','064efc8dae8e47ae9c14713c7b31a36c'),
('394','10427','ZYXEL MES3500-10 operational mode port speed duplex','4ad7b4bf94494c93bdcbf36af095d5c3'),
('395','10427','ZYXEL MES3500-10 port admin status','e6a8dc82d4ca4b989daafd66ef1ab2ce'),
('396','10427','ZYXEL MES3500-10 port operational status','a96f6ed4d9e34a0cb79cee8bdbd672f5'),
('397','10427','ZYXEL MES3500-10 SFP status','8e9755ff129740298ab5f5497c6c17a2'),
('398','10428','SNMP available','dbb03955eb7043dda4dea1a9d7e8e043'),
('399','10428','ZYXEL MES3500-24 operational mode port link up type','c0f699295af740e2aabbb06c6718e8f8'),
('400','10428','ZYXEL MES3500-24 operational mode port speed duplex','f94441e46ffe4908a8a57089cbdaeaa7'),
('401','10428','ZYXEL MES3500-24 port admin status','df2213aff9984b3f837f99944f3c9bc0'),
('402','10428','ZYXEL MES3500-24 port operational status','679674c6b9364083a1eb1c9c9be136a2'),
('403','10428','ZYXEL MES3500-24 SFP status','f12de6ba6b4c4556b276f9d5d509ffcf'),
('404','10429','SNMP available','6e923e1e3ed34b8f87357b5fd7407c54'),
('405','10429','ZYXEL MGS-3712 operational mode port link up type','7c5d7efbd17f48619a3f4211a269b38d'),
('406','10429','ZYXEL MGS-3712 operational mode port speed duplex','da42da17340044ea83521107ac4dee04'),
('407','10429','ZYXEL MGS-3712 port admin status','7e107b2d754945dbaf833955fcae7f48'),
('408','10429','ZYXEL MGS-3712 port operational status','ed71a5038bf34198a3a56b0020ad728e'),
('409','10429','ZYXEL MGS-3712 SFP status','b89570749c5d4dcb9378b7951803b8e4'),
('410','10430','SNMP available','bf6cbe819fb94c85becf4364c47ef1c4'),
('411','10430','ZYXEL MGS-3712F operational mode port link up type','2695f35dedcf41e1aade2037e931c57e'),
('412','10430','ZYXEL MGS-3712F operational mode port speed duplex','c2b235ab2e6042568c096fdfb466f7dc'),
('413','10430','ZYXEL MGS-3712F port admin status','d145d8ee5ad2423f906335d30bfef592'),
('414','10430','ZYXEL MGS-3712F port operational status','655823ba854540c78a8078d4e7594bf9'),
('415','10430','ZYXEL MGS-3712F SFP status','bf0d94784c404b209d4c75c8f582a5c6'),
('416','10431','SNMP available','9e4265c1129d482fa12a09e657a7cda3'),
('417','10431','ZYXEL MES3500-24S operational mode port link up type','615d399b1a6045359dfc262b364b4c55'),
('418','10431','ZYXEL MES3500-24S operational mode port speed duplex','4217cd5f5c1f4b438cd4701c023da375'),
('419','10431','ZYXEL MES3500-24S port admin status','7e705fdb791341b8a1c86ee7d85fbfea'),
('420','10431','ZYXEL MES3500-24S port operational status','08e22f2eac034c9db9bba73040cea453'),
('421','10431','ZYXEL MES3500-24S SFP status','161770392cdb4dcd92c3596b5ad6d06a'),
('422','10432','SNMP available','5c5037a96f084a8182a5fb00f49ff285'),
('423','10432','ZYXEL MGS3520-28x operational mode port link up type','2b38ddd0e1a34cfab7dd6af9ebf28aca'),
('424','10432','ZYXEL MGS3520-28x operational mode port speed duplex','f23ebe496cfc4e659a09eff530b81a24'),
('425','10432','ZYXEL MGS3520-28x port admin status','3e0566598e394d80988fb49cd3215922'),
('426','10432','ZYXEL MGS3520-28x port operational status','2ffe41460977466cb09bc241b8d22739'),
('427','10432','ZYXEL MGS3520-28x SFP status','4443c6780c8f4d16a5f1efd5426db02e'),
('428','10433','SNMP available','a7acf3b0ac684d4e80c560bcd3dd2dc6'),
('429','10433','ZYXEL XGS-4728F operational mode port link up type','042ccfb45b0a4ef7bc8842f731dd8c4f'),
('430','10433','ZYXEL XGS-4728F operational mode port speed duplex','d466ff32531d4eaea989c07aa5989d6b'),
('431','10433','ZYXEL XGS-4728F port admin status','250f228ead4b433f987d42014255a617'),
('432','10433','ZYXEL XGS-4728F port operational status','ed13145eeefd44dda083716080725e60'),
('433','10433','ZYXEL XGS-4728F SFP status','49b0a85b7da947ab91e47ed2f2123907'),
('434','10434','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentOperability','8648df22d8be42359900e11ea395a98c'),
('435','10434','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsEquipmentPresence','17dde900e96a47929b0abed0d5006c84'),
('436','10434','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsLsOperState','c4a3603d4d8944ad8a8d2529bc3f1278'),
('437','10434','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageLunType','7d09a2b8df18410ca871ed9e7dbe6aa1'),
('438','10434','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStoragePDriveStatus','70a906bfe3b447a39e5a0f0ba5210ae2'),
('439','10434','CISCO-UNIFIED-COMPUTING-TC-MIB::CucsStorageTechnology','e1407fbe331343d3bda7d7eb122c085a'),
('440','10434','IF-MIB::ifOperStatus','2b0fde08268f4ce7b47aae3827ebdf23'),
('441','10434','IF-MIB::ifType','be402fda36e64dd2ad807925755735c4'),
('442','10434','zabbix.host.available','9ea529bf28a84fae95f1506ca6ca37b8'),
('444','10436','IDRAC-MIB-SMIv2::batteryState','3764082c250540f0b2827412a751f842'),
('445','10436','IDRAC-MIB-SMIv2::BooleanType','ef50d21a037545078e00102504b9b79d'),
('446','10436','IDRAC-MIB-SMIv2::ObjectStatusEnum','faa7d65868044cb08c2681db9615ef83'),
('447','10436','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','c0b777b910e94d338ebfaacc94ca5c54'),
('448','10436','IDRAC-MIB-SMIv2::physicalDiskMediaType','596722d9a0b84c499908e460ba634a87'),
('449','10436','IDRAC-MIB-SMIv2::StatusProbeEnum','bd55f661ad24498a8876816ef9e70506'),
('450','10436','IDRAC-MIB-SMIv2::virtualDiskLayout','487f601e3f35437e800314865895b69b'),
('451','10436','IDRAC-MIB-SMIv2::virtualDiskOperationalState','a02a3f0c0fb24a52887f3feec42ae42a'),
('452','10436','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','e2b543acfe9045ae8950075c1174b836'),
('453','10436','IDRAC-MIB-SMIv2::virtualDiskState','348ab665927b43e2b7e53eac8ab95820'),
('454','10436','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','3bfaa8f277a549f7ae8a1bf0dc49e64f'),
('455','10436','zabbix.host.available','8124caf5004c4dd8985810ac9e6374b6'),
('457','10438','IDRAC-MIB-SMIv2::batteryState','557381876b894611bf213f55946b49a1'),
('458','10438','IDRAC-MIB-SMIv2::BooleanType','39a00987a4e14c0286acd9942db37e03'),
('459','10438','IDRAC-MIB-SMIv2::ObjectStatusEnum','ac53b62fdab246aa807e234ae9982102'),
('460','10438','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','432abc8431e0438696cd1b96d3515a5c'),
('461','10438','IDRAC-MIB-SMIv2::physicalDiskMediaType','8aa7cecdd0944b91b8cdcba75e28d781'),
('462','10438','IDRAC-MIB-SMIv2::StatusProbeEnum','b096a16930734ec28bc0a5a5e7634783'),
('463','10438','IDRAC-MIB-SMIv2::virtualDiskLayout','3fcb8ac498564f068c4b30f3423fbe8c'),
('464','10438','IDRAC-MIB-SMIv2::virtualDiskOperationalState','6850d7335f6c423b87527a1a0252d00f'),
('465','10438','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','076e6a30b90c49e9bcbb8a1adbc0b02d'),
('466','10438','IDRAC-MIB-SMIv2::virtualDiskState','4699f81ffa784d43b8e74aeb258a15cb'),
('467','10438','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','15f75cf464d347308db357fa80e67f0e'),
('468','10438','zabbix.host.available','cf94dd75c6274a2aaff23e3a26eee213'),
('479','10440','IDRAC-MIB-SMIv2::batteryState','1a2c68f0f2384c0da7027981bd4bb5be'),
('480','10440','IDRAC-MIB-SMIv2::BooleanType','045512ecd6b94fbab71dd17abf5b8f4b'),
('481','10440','IDRAC-MIB-SMIv2::ObjectStatusEnum','82b2ff6e115d4d098ae1025547853b4b'),
('482','10440','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','168707d69c984df4837638c72f103749'),
('483','10440','IDRAC-MIB-SMIv2::physicalDiskMediaType','1f138e6846544243a2729b41be9a97aa'),
('484','10440','IDRAC-MIB-SMIv2::StatusProbeEnum','9d25c114ba8046f5b126be9111d95184'),
('485','10440','IDRAC-MIB-SMIv2::virtualDiskLayout','e81dcef10a30448db51b9805ec60b863'),
('486','10440','IDRAC-MIB-SMIv2::virtualDiskOperationalState','e9e9b851915747c4b608934cd1235bc5'),
('487','10440','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','92115895f7b9477983c67012b111afb3'),
('488','10440','IDRAC-MIB-SMIv2::virtualDiskState','7573aa4192534f44863508890606f917'),
('489','10440','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','c6d4cfe5cf8b43808dce81cc1bcc4be3'),
('490','10440','zabbix.host.available','c5660f822c4a4567888e7f98d3bfab13'),
('492','10442','IDRAC-MIB-SMIv2::batteryState','692c968229d64965b3f6c59ca79b4522'),
('493','10442','IDRAC-MIB-SMIv2::BooleanType','1ee27c8f7c9d4f7cbafc8c7567b70c67'),
('494','10442','IDRAC-MIB-SMIv2::ObjectStatusEnum','c238adb07fea463a8cb21f962fcb24d9'),
('495','10442','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','ee4ff377e3984685993e230911e6c13e'),
('496','10442','IDRAC-MIB-SMIv2::physicalDiskMediaType','7409409d584845e39579b478171a600a'),
('497','10442','IDRAC-MIB-SMIv2::StatusProbeEnum','1a301ddb56ba46d38314d5c3129544b4'),
('498','10442','IDRAC-MIB-SMIv2::virtualDiskLayout','f3e45e2d860b48c2a6f2b7a068cac361'),
('499','10442','IDRAC-MIB-SMIv2::virtualDiskOperationalState','6d457df3bf6646b3824ccc7be984587c'),
('500','10442','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','47bf555344fd4fc1a15b372374bc75a7'),
('501','10442','IDRAC-MIB-SMIv2::virtualDiskState','2e035bf66ff144d8ab5e0c681bb246f6'),
('502','10442','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','59eff775037e4e58925d3475ed0b0e34'),
('503','10442','zabbix.host.available','6b1b96e063084c8eb474006a9c691fb5'),
('504','10443','CPQHLTH-MIB::cpqHeTemperatureCondition','1b67de295fef454cb89744b101cf5a19'),
('505','10443','CPQHLTH-MIB::cpqHeTemperatureLocale','07d063dcbb3d4f1a8642bfd93afcd327'),
('506','10443','CPQIDA-MIB::cpqDaAccelBattery','009fd99d3734459285fa037c4a0ca201'),
('507','10443','CPQIDA-MIB::cpqDaAccelStatus','e138320082fc4aa69f3b23dad80272b2'),
('508','10443','CPQIDA-MIB::cpqDaCntlrModel','4891472973f84343ade2c5b61d96fcef'),
('509','10443','CPQIDA-MIB::cpqDaLogDrvFaultTol','a368b7472246477599d6278df8348bc9'),
('510','10443','CPQIDA-MIB::cpqDaLogDrvStatus','aab16842347c4e58b9bbee274dad3c62'),
('511','10443','CPQIDA-MIB::cpqDaPhyDrvMediaType','b3b110016c8c4272b9228161798a9bbd'),
('512','10443','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','5b016d244c6845f7afcc80361aec2af1'),
('513','10443','CPQIDA-MIB::cpqDaPhyDrvStatus','2f4e1eb1f32847b3808372d02f752575'),
('514','10443','CPQNIC-MIB::cpqNicIfPhysAdapterStatus','3fe7ff0237a54f6cae3a1b8ffdabf157'),
('515','10443','CPQSINFO-MIB::status','342d09a1cfe543b9ac1555daee9f2235'),
('516','10443','zabbix.host.available','c57a256a525b46b0a1d0646200de57e2'),
('517','10444','CPQHLTH-MIB::cpqHeTemperatureCondition','1f0d43fc8b334b6da324b6ce4f838f81'),
('518','10444','CPQHLTH-MIB::cpqHeTemperatureLocale','96287ed099c14e09b2e1708487f64d8d'),
('519','10444','CPQIDA-MIB::cpqDaAccelBattery','684758347f0740e08af4986ed148e81f'),
('520','10444','CPQIDA-MIB::cpqDaAccelStatus','ff25d5d2484f40ea99b212e19c48e375'),
('521','10444','CPQIDA-MIB::cpqDaCntlrModel','4dc1441ab9964badbcb73e0dc213fe39'),
('522','10444','CPQIDA-MIB::cpqDaLogDrvFaultTol','3fd86d20618b43f39911746d72c2c242'),
('523','10444','CPQIDA-MIB::cpqDaLogDrvStatus','e72171bf818e4ee1bdf9638cb0494693'),
('524','10444','CPQIDA-MIB::cpqDaPhyDrvMediaType','3d32638b989d4d3e87f727baaef8b051'),
('525','10444','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','137c69d61b394c979d7d25d91bcc2f0b'),
('526','10444','CPQIDA-MIB::cpqDaPhyDrvStatus','9af698a37bd844069eb2235f7f5d4800'),
('527','10444','CPQNIC-MIB::cpqNicIfPhysAdapterStatus','04dcfa6e36ca4a0590475d84186a5d62'),
('528','10444','CPQSINFO-MIB::status','83162a1a3b124ab2ae9b4cf1149486f9'),
('529','10444','zabbix.host.available','63b879b39b084a318547620421164c05'),
('530','10445','CPQHLTH-MIB::cpqHeTemperatureCondition','eb946b7168084341870c9157173b5c1e'),
('531','10445','CPQHLTH-MIB::cpqHeTemperatureLocale','a293ad4b90c14fe188623341b954d852'),
('532','10445','CPQIDA-MIB::cpqDaAccelBattery','ca2a5be5f3cf4fa7a9812d483ba043c5'),
('533','10445','CPQIDA-MIB::cpqDaAccelStatus','f15cd1d7fa7e4e05b46e872daa3a3c83'),
('534','10445','CPQIDA-MIB::cpqDaCntlrModel','abaffb0a2a1f47ec8aa64f6264d29092'),
('535','10445','CPQIDA-MIB::cpqDaLogDrvFaultTol','204396956bfe4ff5808dfa93bb35705c'),
('536','10445','CPQIDA-MIB::cpqDaLogDrvStatus','adb434bee0104007a4c0d053211bc2e7'),
('537','10445','CPQIDA-MIB::cpqDaPhyDrvMediaType','6cc6b46021f74cae83b29a62fc2cd1c0'),
('538','10445','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','02eab0a3c02d440c82b86ddbd4ed1af6'),
('539','10445','CPQIDA-MIB::cpqDaPhyDrvStatus','8ab32bfce9f143da86a458427804a5f4'),
('540','10445','CPQNIC-MIB::cpqNicIfPhysAdapterStatus','d7ae95f8b813415c8d35cfe8debf8f2d'),
('541','10445','CPQSINFO-MIB::status','365afa633545431482f2ec054750da88'),
('542','10445','zabbix.host.available','9665746d6c2a4ad0b85b2f1f7d1cb12d'),
('543','10446','CPQHLTH-MIB::cpqHeTemperatureCondition','5655717fa32f4711b3062b97f1e5895b'),
('544','10446','CPQHLTH-MIB::cpqHeTemperatureLocale','ae1477baf3c046cbb5519346f28c7017'),
('545','10446','CPQIDA-MIB::cpqDaAccelBattery','af8340b5070f47e085eb91eb4580d728'),
('546','10446','CPQIDA-MIB::cpqDaAccelStatus','4c4378c0d1af4a6693f8c03bfaa9ad40'),
('547','10446','CPQIDA-MIB::cpqDaCntlrModel','23a855763fc346ea8a3559399ffa7428'),
('548','10446','CPQIDA-MIB::cpqDaLogDrvFaultTol','87ad87e768bc4d8ab77841e29176c36f'),
('549','10446','CPQIDA-MIB::cpqDaLogDrvStatus','46a2f599d46d438899ea4d8c552f51b4'),
('550','10446','CPQIDA-MIB::cpqDaPhyDrvMediaType','5f6868416f454beba585a0d2e9038117'),
('551','10446','CPQIDA-MIB::cpqDaPhyDrvSmartStatus','f78e361d31d94c479594b9d73257f80a'),
('552','10446','CPQIDA-MIB::cpqDaPhyDrvStatus','0efa6b7ed90f4edebc3282af5dbaf6c4'),
('553','10446','CPQNIC-MIB::cpqNicIfPhysAdapterStatus','1d312bcad99c43b8931fb128f6250afa'),
('554','10446','CPQSINFO-MIB::status','48e68c2789334818b5536be3f8628f66'),
('555','10446','zabbix.host.available','1b63c6eea5fc42a99501408d603c158b'),
('556','10448','InfluxDB healthcheck','d1b4478bdfc44c6db79a4a262f605d92'),
('557','10419','SNMP ltmPoolStatusEnabledState','74bcf04a70da49f89f04a20a9830fe13'),
('558','10419','SNMP ltmVsStatusAvailState','3a8776175b1f4cd7aa62f0182c7e3ed7'),
('559','10419','SNMP sysCmFailoverStatusId','6f96920248994bca92eb8d4394346027'),
('560','10419','SNMP sysCmSyncStatusId','1a42ed91b734453ab29a4c1f1feaca89'),
('565','10047','Cluster node status','cee1681b12ff49b6b7d442a851e870b4'),
('566','10261','Cluster node status','25ab0f5c570b4a7e9d15bd41db79fe25'),
('567','10505','Leader status','fa1732213d27418a88a61c964d93e9d7'),
('568','10507','Node conditions','785b20f8979341c4b470870ec8f50414'),
('569','10507','Pod conditions','f93e30e125de4909b52e7c38bc3f2c97'),
('570','10507','Pod phase','21ff77dde5964dcfb4bb2ae202a5f33c'),
('571','10515','IF-MIB::ifOperStatus','2216d8afb349448394590770ff99e56a'),
('572','10515','IF-MIB::ifType','3165b9b6c79e446f9d1029571518004e'),
('573','10515','Services status','fc5652614ee94cd8b437b3058886e857'),
('575','10515','SNMPv2-TC::TruthValue','f6bb441b7a65446c96c546bd3f3140ee'),
('576','10515','zabbix.host.available','d553e33d8b104a5e89d88500e85fa5fc'),
('578','10207','EtherLike-MIB::dot3StatsDuplexStatus','b31f48e2216f441daa0b05561ac2ab6a'),
('579','10207','IF-MIB::ifOperStatus','0a25bc3fe4dd40f8a08962befa8416d1'),
('580','10207','IF-MIB::ifType','ce3031283a6d458489747bfbf3696ab6'),
('581','10207','Service state','2d7b52f7709c460597a1ff44c1e39a1b'),
('582','10207','zabbix.host.available','03dcc409833146f6a1678df8b1311c40'),
('583','10254','EtherLike-MIB::dot3StatsDuplexStatus','322511c8bbf34b8da79b98e47067db64'),
('584','10254','IF-MIB::ifOperStatus','97fa6952fa0a4a2a965ba1e88eebe706'),
('585','10254','IF-MIB::ifType','629b7642da57472ea36074d43e45ce8e'),
('586','10254','Service state','ab33ce8c3fff400eb49d274d76143a37'),
('587','10254','zabbix.host.available','564ef39203334aff99b78aa8fb3fd2da'),
('588','10208','IF-MIB::ifOperStatus','c8b95f7ce9e44b5ea09273fb6c3c9a28'),
('589','10208','IF-MIB::ifType','db55d484980244b4bf5c60e0908f4e9b'),
('590','10208','Service state','17cb6bdbe4244a8fab16c0cbca5a4a00'),
('591','10208','zabbix.host.available','2fdee7620a3a449f9dd61eb3405e620c'),
('592','10210','IF-MIB::ifOperStatus','1b40ba5987784986bb25aa9dfa2d1e81'),
('593','10210','IF-MIB::ifType','5a55c0fddcc9450eb3e07b76cc73f8ee'),
('594','10210','Service state','ac73622b29f54d21aa6bcbac5a783599'),
('595','10210','zabbix.host.available','f74856688e9444bd93951f0c246ae483'),
('596','10211','IF-MIB::ifOperStatus','82de0c54872847d190ee681690aac69c'),
('597','10211','IF-MIB::ifType','6ba7778a7b454c649d6eb0126edd6a62'),
('598','10211','Service state','534121daa14949a6b5205cb9b7138b04'),
('599','10211','zabbix.host.available','e7bbb30eb3b748c6b6087bc2c353c3a8'),
('600','10220','CISCO-ENVMON-MIB::CiscoEnvMonState','0e5588b6aa714283b436031ff8ebc93a'),
('601','10220','Service state','9fc9d3c2eb254de996d9c4a61ba58671'),
('602','10220','zabbix.host.available','bb13061dd5b542f9b0f5921e75866679'),
('603','10218','CISCO-ENVMON-MIB::CiscoEnvMonState','fb67666002524322b1b9ae9ed1611be5'),
('604','10218','EtherLike-MIB::dot3StatsDuplexStatus','36ad5e7621ff466ca89e641c4410c6a1'),
('605','10218','IF-MIB::ifOperStatus','6c1104306b5447328703076cb76b64a9'),
('606','10218','IF-MIB::ifType','80d8685de68c49d8beb0f96f58baa1ce'),
('607','10218','Service state','521e28cd45a1421d89b1588e5392b50a'),
('608','10218','zabbix.host.available','cc333fe140bc45388e5508237b42e1ad'),
('609','10253','CISCO-ENVMON-MIB::CiscoEnvMonState','d811f4c78e8246f6a3ed1e903ade574d'),
('610','10253','IF-MIB::ifOperStatus','b4d11dd4e18b4958a17b5da31d101e08'),
('611','10253','IF-MIB::ifType','475ca8ba5faf4ddca62bd41be9b3d410'),
('612','10253','Service state','5470fefd50c64782ac60e3a2aa8b3d3c'),
('613','10253','zabbix.host.available','91d7e7e2bd4d48d7aecb9f9b4654185f'),
('614','10221','EtherLike-MIB::dot3StatsDuplexStatus','1962bc26a6064ee6868371f86d44dbeb'),
('615','10221','IF-MIB::ifOperStatus','7f124ca304d9431386bba2edbb9b2560'),
('616','10221','IF-MIB::ifType','9fde4e729aaf43cc993167d7c0bcae23'),
('617','10221','Service state','38ce73f0eb6b4c4a912b61b2014156fb'),
('618','10221','zabbix.host.available','01bced41864644fd842efed7085fda69'),
('619','10222','IF-MIB::ifOperStatus','538fac0622da44f6983715e4ab5174d8'),
('620','10222','IF-MIB::ifType','111695131cb1419e910bec80a4b8e799'),
('621','10222','Service state','613f2da376b04842aad29125788f0b91'),
('622','10222','zabbix.host.available','73baa4be94844904b9a6fc06152a948a'),
('623','10223','EtherLike-MIB::dot3StatsDuplexStatus','a5032b272e4c4208b16ce190833103b0'),
('624','10223','IF-MIB::ifOperStatus','2bdac31f40b04baaa131ebedde8d5077'),
('625','10223','IF-MIB::ifType','d050b91fbb5c406b8b59e4e66d3c783e'),
('626','10223','Service state','1012a8cf8ce34825aae3ffbb36ee1313'),
('627','10223','zabbix.host.available','93ebe10df982453aa98621c1f1d070f9'),
('628','10224','EtherLike-MIB::dot3StatsDuplexStatus','60e2bd909e284621a8a21810623b0e94'),
('629','10224','IF-MIB::ifOperStatus','2fcb120b5eb840ddbad31a7291711b7d'),
('630','10224','IF-MIB::ifType','d09aa2831cca48eb8c9011582c15bea1'),
('631','10224','Service state','3177ca5723c3410daf20723b88019907'),
('632','10224','zabbix.host.available','c6691c15854b472982f8a6636efdbe82'),
('633','10226','EtherLike-MIB::dot3StatsDuplexStatus','df2e3dab72d94efba9a85bfd7d1c3148'),
('634','10226','IF-MIB::ifOperStatus','9b4ab9573d184bf381f80ba4392fedc7'),
('635','10226','IF-MIB::ifType','8f5eaea6553c4053b1d04569bc14bcb7'),
('636','10226','Service state','b146c1413392488884ca17289a55055a'),
('637','10226','zabbix.host.available','77a05f825d144596a08149088121951a'),
('638','10227','EtherLike-MIB::dot3StatsDuplexStatus','ec3b9adaa2ad448db5a613cfb6e02fd3'),
('639','10227','IF-MIB::ifOperStatus','47c29a4e28094f59a3666ab1bc7bbba9'),
('640','10227','IF-MIB::ifType','023e30ad64bc402abf989de29c2b7c5e'),
('641','10227','Service state','814a713abe0740bc93531596474b80b2'),
('642','10227','zabbix.host.available','f6c6d62117c749a482792e753486a2be'),
('643','10250','EtherLike-MIB::dot3StatsDuplexStatus','846197beea984cc783b84822437bbace'),
('644','10250','IF-MIB::ifOperStatus','28a4a6c5a2b84802bfb1e3215ae398a7'),
('645','10250','IF-MIB::ifType','5a230e50a04d4855808dc213db1bb5c5'),
('646','10250','Service state','5a584e3a8795417c86911e6ffc37b0bd'),
('647','10250','zabbix.host.available','b9fe3941224749efa881a61b56c5d888'),
('648','10229','EtherLike-MIB::dot3StatsDuplexStatus','64bf3ebd444c4c4ca472b0846790b107'),
('649','10229','IF-MIB::ifOperStatus','ec040521269743e7a402bbdd1c952ea3'),
('650','10229','IF-MIB::ifType','a46f120c4e16400980806c27eb08de1e'),
('651','10229','Service state','3bde7ef9431d4a9e86d3cb88bb46a38b'),
('652','10229','zabbix.host.available','c2435e2487434b3b888c54cb4b6c0139'),
('653','10230','IF-MIB::ifOperStatus','59e447d9af934975975b38972c8a7fca'),
('654','10230','IF-MIB::ifType','f959de5e694a4e46a35da37ff58af887'),
('655','10230','Service state','9c931d7fbc984fd6b3a44a09fec264e1'),
('656','10230','zabbix.host.available','d6130251df4c41c0b417fcd8d71f3f15'),
('657','10231','EtherLike-MIB::dot3StatsDuplexStatus','69625f8a027542638c3ca9b64522602d'),
('658','10231','IF-MIB::ifOperStatus','79269236a24e4a1d8f40a600ee1c3a65'),
('659','10231','IF-MIB::ifType','f345b4dd14784f7f96902ad7f95d4038'),
('660','10231','Service state','e3bf54eef520492a94ad3d7bd7c3dede'),
('661','10231','zabbix.host.available','022ceae4990140a59b2ceca83a826dd5'),
('662','10449','IF-MIB::ifOperStatus','2c87030228374ab0a2f1051f5fdd1c48'),
('663','10449','IF-MIB::ifType','20bb48090ee04eadb771f56365193646'),
('664','10449','Service state','e7be0480e0904cc6a68cc027961d36f3'),
('665','10449','zabbix.host.available','1cab243abc4747c3ae5bc1e432c8e2f2'),
('666','10450','IF-MIB::ifOperStatus','3a94c6ec55bb4acea2aff228712bc4f2'),
('667','10450','IF-MIB::ifType','0a80c83f5dcc47b095641aa5a0ed3fcf'),
('668','10450','Service state','e785477c09fb4857b2b6ab0065eb30bb'),
('669','10450','zabbix.host.available','845e465060de4e619f5d2fc841730211'),
('670','10451','IF-MIB::ifOperStatus','fc286c3054704db2bc3b0e8b88ff74c0'),
('671','10451','IF-MIB::ifType','1299953fcf1143fb9155f889f39af069'),
('672','10451','Service state','85dc872152ec4c5f8af35558e554abae'),
('673','10451','zabbix.host.available','1f457b001e2e4d6c8ce2c386ea4d7f77'),
('674','10452','IF-MIB::ifOperStatus','22f415a6b99d4266adc34008f74b8273'),
('675','10452','IF-MIB::ifType','6ed02c4fe35042698491af23e9f9bf81'),
('676','10452','Service state','c16dce20ddb24e648936f2c874df7611'),
('677','10452','zabbix.host.available','9556e9053f5f49e2b8f8f4c312a15fc0'),
('678','10453','IF-MIB::ifOperStatus','1fd54fd1f5b245aa92674432cac9455d'),
('679','10453','IF-MIB::ifType','e8025fb20449470da19bf5881ebe3467'),
('680','10453','Service state','f9e0c946ec844715a29819e037a52d46'),
('681','10453','zabbix.host.available','d0c9d2ac973d49f09fd14d04803ccdf6'),
('682','10454','IF-MIB::ifOperStatus','91555b102b4344ecabb9ffba5cefdfd2'),
('683','10454','IF-MIB::ifType','e93fd9e1a289402f9631275a21da92a8'),
('684','10454','Service state','562a1120aa7148b3a3ebd862480574bf'),
('685','10454','zabbix.host.available','eaac357da10f4fa3ad2cf4cb5784c45a'),
('686','10455','IF-MIB::ifOperStatus','584f260e2200488084f41fbe709dd0ab'),
('687','10455','IF-MIB::ifType','12b06f3b345c43e7b9b6f2299b2608bb'),
('688','10455','Service state','8dd8911e238240a3a0455805bb8128af'),
('689','10455','zabbix.host.available','2f9ffba5f4ae4226b8ff39e4bff0b5d1'),
('690','10456','IF-MIB::ifOperStatus','33859113b37a4ed7b36e31ec6d016fd5'),
('691','10456','IF-MIB::ifType','480088441ae34e1d93cd19fa6379e30f'),
('692','10456','Service state','72f64e97a698449cbd0b6b60bc418b2e'),
('693','10456','zabbix.host.available','a52a4ff531194e7090d12246e011e9d0'),
('694','10457','IF-MIB::ifOperStatus','6e4c66c16e274c5f8caa1617020884cc'),
('695','10457','IF-MIB::ifType','ec8ebd0e1ace4fc4b455cd932c5abb6f'),
('696','10457','Service state','33a1f843573446878618a06307d76f8d'),
('697','10457','zabbix.host.available','4e2dde2550564c3baa667b369e03b257'),
('698','10458','IF-MIB::ifOperStatus','766be8ef402c431995ab5c5e70970cf4'),
('699','10458','IF-MIB::ifType','2a9c7cab3ad0446896cc2ef6121d4452'),
('700','10458','Service state','b5de6f35c8c14486b755175e8dee1d41'),
('701','10458','zabbix.host.available','506571817e794083bdf3a7276b60c22d'),
('702','10459','IF-MIB::ifOperStatus','39905ed60f834c78836e3fe8b4cf34fe'),
('703','10459','IF-MIB::ifType','308b4e2991ad4af88564441bc0e23b93'),
('704','10459','Service state','1624693f374e437db131f743864e865b'),
('705','10459','zabbix.host.available','95c329958acd4df1b5e2459725d50115'),
('706','10460','IF-MIB::ifOperStatus','d58e77f172d14ec5ab67d03296c7d38c'),
('707','10460','IF-MIB::ifType','acf4edb812eb4123af1d8560e63221bd'),
('708','10460','Service state','ad346998940e4b4e8e131b26ee4bee23'),
('709','10460','zabbix.host.available','6bd7aa56b18d4545891bfb11b69ddbd4'),
('710','10461','IF-MIB::ifOperStatus','ce35f7985cc545bb821b0d0603ddcdd5'),
('711','10461','IF-MIB::ifType','15e27cbe878e40b69ca4b16a3f6d1e2a'),
('712','10461','Service state','aae875e8761d49fda56524ee5d37f279'),
('713','10461','zabbix.host.available','287ca5d5072f4fa7b96a31a0812e1cc5'),
('714','10462','IF-MIB::ifOperStatus','10ff85e100864e88910e26efd34896d3'),
('715','10462','IF-MIB::ifType','b65a31c66306406a8fe73e6c210c0ba6'),
('716','10462','Service state','d8e4b86f85e549e4a3641b36c3b8c0b2'),
('717','10462','zabbix.host.available','61071e8ff079488dab143843f124fa99'),
('718','10463','IF-MIB::ifOperStatus','554abaed99124d0eb787506c0cb1b56a'),
('719','10463','IF-MIB::ifType','b59e05d6e52a4e3fb7546d7435c0dddd'),
('720','10463','Service state','59c270831db949389b6c8ae00b0ff394'),
('721','10463','zabbix.host.available','c6ee3b849b6942238cf691ecdb90be26'),
('722','10464','IF-MIB::ifOperStatus','844451a575b14c3abccb52db6637c57c'),
('723','10464','IF-MIB::ifType','f258811d525d47d7a491ffca5cf36211'),
('724','10464','Service state','cadc9c4a3e0549a9bd4092539a6e788b'),
('725','10464','zabbix.host.available','85b1c3feb18c4cbeb187dff5c4dd723b'),
('726','10465','IF-MIB::ifOperStatus','88ab84cb938a40a3918f884efd188d15'),
('727','10465','IF-MIB::ifType','6b690add355342aea58455d2e54f9202'),
('728','10465','Service state','b217d2a84c9844a08e6fef80c9dc6297'),
('729','10465','zabbix.host.available','be9bb4ec29c7453aaef08944117fa319'),
('730','10466','IF-MIB::ifOperStatus','9a2a53f5b1ee4cfd8128d6fd3ee94f19'),
('731','10466','IF-MIB::ifType','6efc0b7ffc2e4205b2cbcca15ceba64c'),
('732','10466','Service state','d6a4ac3dba1d494e8a61150fbdd8cacc'),
('733','10466','zabbix.host.available','4fa91d64132a4c2089cba197f734c0e3'),
('734','10467','IF-MIB::ifOperStatus','741d15ef55334ec9b017e355a1ed958b'),
('735','10467','IF-MIB::ifType','9b1f0649653b46c7be262934f376926e'),
('736','10467','Service state','9493572ff58f4e4c86208bb8ac839aa3'),
('737','10467','zabbix.host.available','bb18fe8a5404430e95b6bb00d571e6ed'),
('738','10468','IF-MIB::ifOperStatus','eb2dc24843604c1b8ef9169ce65e570c'),
('739','10468','IF-MIB::ifType','ea9e3359b57840c8b1fa1b1c0cbf55c5'),
('740','10468','Service state','e392411ac64845efaedeec750731caa8'),
('741','10468','zabbix.host.available','9200cc616f934bc5b0df6136c53e0650'),
('742','10469','IF-MIB::ifOperStatus','09f1738eab3c4fc381b22b1d82a8d192'),
('743','10469','IF-MIB::ifType','e56e7aefbc244b1f9a93fb787d7043db'),
('744','10469','Service state','8ca1d63f5ca1449fb4f2dbb94b54835a'),
('745','10469','zabbix.host.available','c5f9837a1d6d42bb9ffae512dd63f0d6'),
('746','10470','IF-MIB::ifOperStatus','898bfaed08a44954897385e63d854c0f'),
('747','10470','IF-MIB::ifType','d441d05e0e24462b817c5b3eae8d9b9d'),
('748','10470','Service state','04f7843b43454cc487e70cd3639b4024'),
('749','10470','zabbix.host.available','84bf465ed8e3421e817ba4648e7707e9'),
('750','10471','IF-MIB::ifOperStatus','a47c7db9e85a42f6807209393d5be773'),
('751','10471','IF-MIB::ifType','79a3153cc7f74b8ab41acec0f722476c'),
('752','10471','Service state','f430b2fa108a4c2c964d4e39c794cfaf'),
('753','10471','zabbix.host.available','5bc4289f35bd41b9a5034da380f78eba'),
('754','10472','IF-MIB::ifOperStatus','8c73c67d22c343c5a37d23afe2fbe98b'),
('755','10472','IF-MIB::ifType','7d7a0f21f1aa40ceb5acd6f1d9815875'),
('756','10472','Service state','c9ed7ee77afb436e8c85baba81aa3971'),
('757','10472','zabbix.host.available','ef6e97ca311d411c8b1d3dc7d87a1fce'),
('758','10473','IF-MIB::ifOperStatus','d9450045bbb64855ae135a53308f3a22'),
('759','10473','IF-MIB::ifType','6a6b6e7caa4d41b4b08781b665219425'),
('760','10473','Service state','03feaa2653754a39a49be179e127cfef'),
('761','10473','zabbix.host.available','26e5c5020edb4553a70bf0647d5e99a7'),
('762','10474','IF-MIB::ifOperStatus','d081693e5965461ab47d1e39712d0730'),
('763','10474','IF-MIB::ifType','4028b1d91dd34224af78d961a8139422'),
('764','10474','Service state','1b36de603f4a489ab58b3a2007664b97'),
('765','10474','zabbix.host.available','827c5e25ce6c499690912ce2f51f2d23'),
('766','10475','IF-MIB::ifOperStatus','42f75b8ccc1642699bc4c681379cdf9a'),
('767','10475','IF-MIB::ifType','eaf1d4babd704133811b0a0bc912d319'),
('768','10475','Service state','057602363ab44b638e1c116e1e4edafd'),
('769','10475','zabbix.host.available','14fa9bc957f644c19e88352fcd00a196'),
('770','10476','IF-MIB::ifOperStatus','328bdd06aa634535895f099b1ae489a2'),
('771','10476','IF-MIB::ifType','1404a90ce0c24bdfb85712fa4ada16f7'),
('772','10476','Service state','92b5d1e8e71948fba8a01231ff5661ae'),
('773','10476','zabbix.host.available','6c09aa1071a04b4381d625bfa862651c'),
('774','10477','IF-MIB::ifOperStatus','a020e149d8cd44b4bc01757e860fea9b'),
('775','10477','IF-MIB::ifType','eb92bcec20754ffda075157e919ff103'),
('776','10477','Service state','ff7e81f30cbc4a8e9bdd4ab9f1b67332'),
('777','10477','zabbix.host.available','51f609663817483cb44991b1057b6fd1'),
('778','10478','IF-MIB::ifOperStatus','03170ad661d94227a3ed44be919bb70b'),
('779','10478','IF-MIB::ifType','154285efa1184f648f415c16c80ed959'),
('780','10478','Service state','e99c8b74b91047ce94ccf9d257da7952'),
('781','10478','zabbix.host.available','4e98aec63e9a447085e18b0c00878c72'),
('782','10479','IF-MIB::ifOperStatus','373f90696d5446dfb8b96ac601ea46bf'),
('783','10479','IF-MIB::ifType','ec31f6a5de23428babb52891633c1cbf'),
('784','10479','Service state','46a72cb8e18e4f6287a01663b70d65b8'),
('785','10479','zabbix.host.available','3ecff0e7f545452eaf0a4ea5c259099d'),
('786','10480','IF-MIB::ifOperStatus','405ab38009ec49348abe0b0c40cf8400'),
('787','10480','IF-MIB::ifType','f8b354a36e1b483a9b62e151e9979e44'),
('788','10480','Service state','d6794baa748e42ecbbb7ff798a7b6dfe'),
('789','10480','zabbix.host.available','80459903b71047d1979a2043fa4a77a9'),
('790','10481','IF-MIB::ifOperStatus','f3c5ab8576b34585a21cc5c12ea2f030'),
('791','10481','IF-MIB::ifType','6f4886e0f3014d9796ba3014a2cf4190'),
('792','10481','Service state','15c511178ebd4ea1b08cf75048915a8d'),
('793','10481','zabbix.host.available','5b9f23af5c684b2f8360032126ac323e'),
('794','10482','IF-MIB::ifOperStatus','1688633d1275445f846db4e63be4ec87'),
('795','10482','IF-MIB::ifType','54cc6fac26fa4e038de096b4e4a27ca9'),
('796','10482','Service state','7b5f3cb781fd49e1bc0a1811fc6bdb3c'),
('797','10482','zabbix.host.available','07adb358b3dc45dd848501bb129c184f'),
('798','10483','IF-MIB::ifOperStatus','6baa15161f3645ec9f7c55454fb5b575'),
('799','10483','IF-MIB::ifType','9fa04834870c42d18cff898de904b7d1'),
('800','10483','Service state','cb3fc2c6a23845979765dc351158e134'),
('801','10483','zabbix.host.available','239cc24f3e7046059da55c621f7f7741'),
('802','10484','IF-MIB::ifOperStatus','7c2123a387904176a8285e3e1405622f'),
('803','10484','IF-MIB::ifType','618992ab84bd450c95e42ce469bbd45f'),
('804','10484','Service state','0cd4de70a85e44d28b6cad58f76dd298'),
('805','10484','zabbix.host.available','ecb1dff8b48f4537ab39a61186db0dd7'),
('806','10485','IF-MIB::ifOperStatus','2cc282d274444241a03ee557db156c73'),
('807','10485','IF-MIB::ifType','4c9d084f51dd4c649b645c71a812220d'),
('808','10485','Service state','3136d5ca9dd543d1a63a6df52bb60249'),
('809','10485','zabbix.host.available','8f791785fd354a10b5c5a005e023d6c8'),
('810','10486','IF-MIB::ifOperStatus','270aa43aec684b4691a231c73aeb3f0f'),
('811','10486','IF-MIB::ifType','4e3a9e65c5734c34b6a73f9f68513e3e'),
('812','10486','Service state','f90f3e32b5b54f0c93aa0e5722810917'),
('813','10486','zabbix.host.available','c3ffbe98192e4639843ab4a3584965ac'),
('814','10487','IF-MIB::ifOperStatus','5ad8c335be4242fab3fe494707553a44'),
('815','10487','IF-MIB::ifType','ab80a859fba74ce085fdfdddbadeda8e'),
('816','10487','Service state','4c5a4ebb20fd4111b444af3db223a21a'),
('817','10487','zabbix.host.available','46e81d323d9745f4af7af06ff9f85d3a'),
('818','10488','IF-MIB::ifOperStatus','77234a3478a44316b69d7cb39b018b47'),
('819','10488','IF-MIB::ifType','42a4cc6793864b5fa8fcfbb158b993cc'),
('820','10488','Service state','09896efced0143bc9f4c9f33db6051a4'),
('821','10488','zabbix.host.available','097987211d8a41c5bb87be4f8b9e4598'),
('822','10489','IF-MIB::ifOperStatus','8ab38f3183414268a97886537f26bb62'),
('823','10489','IF-MIB::ifType','94cc38c8cfd3498ca3e08b2f3a215d7b'),
('824','10489','Service state','ffb74f2e72274c3eadcee61d34faf885'),
('825','10489','zabbix.host.available','680e9b81d3094abc8a37ae0645076fe0'),
('826','10490','IF-MIB::ifOperStatus','e730f38a15e34cb4b52d27710056a28a'),
('827','10490','IF-MIB::ifType','486c1f40eae844d28eb8acfdebf52bb3'),
('828','10490','Service state','cdebb7ffdc0c4191a2b84569e3d8d40c'),
('829','10490','zabbix.host.available','9b957d38b829475a8cbe06991ff90659'),
('830','10491','IF-MIB::ifOperStatus','bba96f7bcedf4277b5411562b17b0216'),
('831','10491','IF-MIB::ifType','e1c29894283b4837b9fb6b1929b2af2e'),
('832','10491','Service state','9c3206fa143949e1a3d6423bc410a2dd'),
('833','10491','zabbix.host.available','85e730aa40d141f488e0d0e5cc51f4cf'),
('834','10492','IF-MIB::ifOperStatus','e6d270e997dc40dcb0b2d69f0eeaad69'),
('835','10492','IF-MIB::ifType','3435384894224f579ceb1d9529532d49'),
('836','10492','Service state','470819e8e6e04c988f1ddaf4ae78362c'),
('837','10492','zabbix.host.available','a57b96fc823f4634901a4da9df6d8f25'),
('838','10493','IF-MIB::ifOperStatus','1a0d7378fe7340b68845b69fb4f93483'),
('839','10493','IF-MIB::ifType','11d4940866204548bc22f75188bcbc23'),
('840','10493','Service state','c9b07b4e497c4723a45effe620dae0e8'),
('841','10493','zabbix.host.available','2a3d5a84618f48d2a98f1ce43b1541f9'),
('842','10494','IF-MIB::ifOperStatus','209d3691ddba4079971e42b4c66bbf7b'),
('843','10494','IF-MIB::ifType','537470b0ce914388bae1f5c9d0b7e650'),
('844','10494','Service state','f4e3f00eee7942b4a923008204a5efae'),
('845','10494','zabbix.host.available','7e6ac491ba67468ca65aaadd506b0653'),
('846','10495','IF-MIB::ifOperStatus','c212726bbd1047f2aa72c2f88b1bd4d8'),
('847','10495','IF-MIB::ifType','1d00e802a2c44775a84e2cff4e9f3e65'),
('848','10495','Service state','47444d3fbb2f414dbb1c6ad7cb77ee13'),
('849','10495','zabbix.host.available','451f6505bd2e43e08ab5f86e0e7ff816'),
('850','10496','IF-MIB::ifOperStatus','15171bce73d64d4db72399fefc7c55f1'),
('851','10496','IF-MIB::ifType','bcd9de0d817246688f7682a1b66ed046'),
('852','10496','Service state','c0bded469f6a4378a7fdcadd7c858b24'),
('853','10496','zabbix.host.available','427da1e5397442f3a00e445928f054ed'),
('854','10497','IF-MIB::ifOperStatus','6ea0ca9342014c71be6d5c38203bcf55'),
('855','10497','IF-MIB::ifType','97906247683e4a488e191c5aba0b1bb3'),
('856','10497','Service state','7a87ed0256064913ac714fe514f3a87b'),
('857','10497','zabbix.host.available','18e987751fe7494bba178a5412592b90'),
('858','10498','IF-MIB::ifOperStatus','76ca35629e874d2f90546a74a4b36ffb'),
('859','10498','IF-MIB::ifType','a6383fcd4ce349eeac45dea55c502ded'),
('860','10498','Service state','7cc0bd53766f455fa18674f6c6d08b47'),
('861','10498','zabbix.host.available','8882c6eab8a7460e81bed27d01992b08'),
('862','10499','IF-MIB::ifOperStatus','e440d3590aee41198de71b1b8d03b4b9'),
('863','10499','IF-MIB::ifType','9f7f414526dd464f813b6c193317729c'),
('864','10499','Service state','b31538483a81433a9136af0e3f210b2c'),
('865','10499','zabbix.host.available','61a780952af848389136a09bbebbec46'),
('866','10500','IF-MIB::ifOperStatus','839bc47f8c5a4c08a124d98a67d1d008'),
('867','10500','IF-MIB::ifType','e5ff01ab289d41c3b0400ddddd560252'),
('868','10500','Service state','60d08c7e151244b6818a208dc71be165'),
('869','10500','zabbix.host.available','4afed47df39742559534158284d405a4'),
('870','10501','IF-MIB::ifOperStatus','f67e80e8803c4aa7bf64347a6ab40336'),
('871','10501','IF-MIB::ifType','bb70b4c197574b659fec20c066393945'),
('872','10501','Service state','828e978dbe3d445d8059c31f8902e403'),
('873','10501','zabbix.host.available','47facf2a4a234c31851d1ec80a803cbe'),
('874','10502','IF-MIB::ifOperStatus','c3ca1fe6814948818bde09a430c55d56'),
('875','10502','IF-MIB::ifType','526dda4a360a4b81b3875c105087b417'),
('876','10502','Service state','325bbbb044504b29957d9a759d7947d0'),
('877','10502','zabbix.host.available','77b701dfe7914b54ad7f361e0ff55f3f'),
('878','10233','IF-MIB::ifOperStatus','b020eb645cff47c0b91891a36652c087'),
('879','10233','IF-MIB::ifType','0ab024c489794d1299d2992ad5b3e1e8'),
('880','10233','Service state','4197110252654153a2eee46de014a4c0'),
('881','10233','zabbix.host.available','f63bc9f2c0d0427b9d1eccae7a1d612d'),
('882','10234','IF-MIB::ifOperStatus','fecd5d9485284373bf7a2675c2b29698'),
('883','10234','IF-MIB::ifType','fc2630e4b471489e86b27cad74869009'),
('884','10234','Service state','5f4a459df3414f51a6304e95e33719cb'),
('885','10234','zabbix.host.available','8f0e780896f9432486996071a231fba3'),
('886','10235','EtherLike-MIB::dot3StatsDuplexStatus','867a4b73b9c74b8991bd9e7fada4266f'),
('887','10235','IF-MIB::ifOperStatus','8be611d8f2c84397b7ded25165d6c63c'),
('888','10235','IF-MIB::ifType','041993f5fd2c4dec97fe4a1ede37cad5'),
('889','10235','Service state','56ec9ee320f545d7a9f0941258f298ac'),
('890','10235','zabbix.host.available','1bc8b4e625ae4328b3919b6379680ddd'),
('891','10236','IF-MIB::ifOperStatus','ca6bcc5f345b46ffaa445d38a90ddcae'),
('892','10236','IF-MIB::ifType','7eaf5db3b1f047bd9a8f5acdfdaf59ad'),
('893','10236','Service state','0d9190336b1d47569f423067889d7a4d'),
('894','10236','zabbix.host.available','090a2707e81e42829504663cf37b8223'),
('895','10237','IF-MIB::ifOperStatus','2fc5bef495074d0e86641cc136e3dcde'),
('896','10237','IF-MIB::ifType','5161926438084643a3e2b08dac97cb4f'),
('897','10237','Service state','d72bcf64fddb4f4faf3bfb039a36e0e4'),
('898','10237','zabbix.host.available','4ceae86ef7e84797a911fd3d257eaa46'),
('899','10076','zabbix.host.available','4a25a6b3d6e4482ab2a748c79cb55524'),
('900','10076','Zabbix agent ping status','f2885fb5e52946f8bce8eb96a60f433a'),
('901','10075','zabbix.host.available','9c02af203e354ac6ac87a742e85f683b'),
('902','10075','Zabbix agent ping status','b82f35541efe4fc1a432c049eba5d082'),
('903','10077','zabbix.host.available','663bea44626447b5a72a71238dfda919'),
('904','10077','Zabbix agent ping status','3f4bc88020d444e1b951aebfa8f3dfb8'),
('905','10001','ifOperStatus','8c048c6cca8248f2860c208e8db0f59e'),
('906','10001','Linux::Interface protocol types','044df261808442a8af9e5cda0acaa6a5'),
('907','10001','zabbix.host.available','5488e5d78d704b78aee60c60414ce0c3'),
('908','10001','Zabbix agent ping status','64faba3a883241a88da8833970ac3ab0'),
('909','10343','ifOperStatus','276914b5aee2435da609d3112ecd359d'),
('910','10343','Linux::Interface protocol types','79afe98a54a648bb981c29e70ba6652c'),
('912','10343','Zabbix agent ping status','e815d397c5e44f1791622fd598bc1131'),
('913','10248','EtherLike-MIB::dot3StatsDuplexStatus','1fe48656fa5e4a23903921a5b0f2aac4'),
('914','10248','IF-MIB::ifOperStatus','1578e9a6c5f24dd1915d981c245b68fa'),
('915','10248','IF-MIB::ifType','4a342bf160284052bc94e123d13f7992'),
('916','10248','Service state','1ccba0a6ed744226ba878957e7d1aa47'),
('917','10248','zabbix.host.available','72e9f56c06b546319580d856fc112dc1'),
('918','10079','zabbix.host.available','0355844b2bee4fb59bddda6175ef4810'),
('919','10079','Zabbix agent ping status','a72caf871acf4776a891a612932fbf2e'),
('920','10074','zabbix.host.available','693c226692c548869e77d3313934ca28'),
('921','10074','Zabbix agent ping status','8dad41742edf49178119c70abea0a0dc'),
('922','10078','zabbix.host.available','2a704279b6e946a99b88bdebd4f99653'),
('923','10078','Zabbix agent ping status','5db838501e354313888d84800658ed6a'),
('924','10081','Win32_NetworkAdapter::AdapterTypeId','9b087b9bfa09434ea0d0b5c32577abcc'),
('925','10081','Win32_NetworkAdapter::NetConnectionStatus','7e549195e83446228db8bf1101bea83d'),
('926','10081','Windows service state','3f685167f97c492598ad445fc938560f'),
('927','10081','zabbix.host.available','c80233756c9d43769f334d632da07b8c'),
('928','10081','Zabbix agent ping status','5d3e53f3090448c7aaf081eb32b28ced'),
('929','10351','Win32_NetworkAdapter::AdapterTypeId','224ca38281f04c83844763251505cdce'),
('930','10351','Win32_NetworkAdapter::NetConnectionStatus','850e339a24de4ef6a0a881dc57bfa3a6'),
('931','10351','Windows service state','e29ffb786c21406aa2338e3d35b484ef'),
('933','10351','Zabbix agent ping status','0b50ea7e6695421da023ece0a23bed10'),
('934','10249','IF-MIB::ifOperStatus','2357d81186e34d5b91db98c2350e0bdf'),
('935','10249','IF-MIB::ifType','b3f64ce647bc4647a692f2e3bafa3760'),
('936','10249','Service state','43b61695bdf347cb8ec9bd23e7cdbc88'),
('937','10249','zabbix.host.available','a979f49c325344e0b6c064b829a21f62'),
('938','10385','Service state','0aa29a4ffa224d56a107a1cfbd6c416a'),
('939','10385','zabbix.host.available','d107957d44424014a251dff95751a41f'),
('940','10378','zabbix.host.available','7ad319d1815e45a1a28a8cd2516fd8eb'),
('941','10304','Service state','b98830da69f9463f949ed2df7ee5dcb3'),
('942','10304','zabbix.host.available','a67fce1a203742eea56849fc38b8af39'),
('944','10255','zabbix.host.available','a8b28aa27f374f58a1ebc85fd3a84887'),
('945','10256','Service state','98d8b8c35272455281f6ae0775691117'),
('946','10256','zabbix.host.available','1d84ec840bfb4ca0a8e98d11008e8423'),
('947','10258','Service state','2fa79738fa194e04bfaeee91a2e4396f'),
('948','10258','zabbix.host.available','c446435a96c24db2845ba0651eb44c94'),
('949','10259','Service state','e6794dc7602149a3b4fdbfeef45f6e8e'),
('950','10259','zabbix.host.available','1fbe26c5dcb3457f98f84a240aa790cd'),
('951','10510','Boolean format','a435f7e23050406ca40cf6f5f872b5a7'),
('952','10516','Wind direction','9a8fdac997914722acfea90f1f9d45e9'),
('953','10517','Cluster quorate','d4bbd08f3a324a57af97a17f819cb3f3'),
('954','10517','HTTP response status code','87034fae192c44dba6c8bb568cd90bbd'),
('955','10517','Node online','99c0bc65efb34d298586320bdcf14209'),
('956','10518','FREENAS-MIB::ZPoolHealthType','1ce70fc8edf2449ea6a0c687f359441a'),
('957','10518','IF-MIB::ifOperStatus','8206c1b8a10840c0908b34c95f8ba4b3'),
('958','10518','IF-MIB::ifType','f5115f963d0043f6b76ebbd27aaba600'),
('959','10518','Service state','8673d9a283674ca2bcd973f5fdff7258'),
('960','10518','zabbix.host.available','0fe93c05f4c94ce8943950210218f6d9'),
('961','10519','Node health','2e7ddaadebce4b1089dcf01a91d01293'),
('962','10519','Node readiness','705e364c9e1b44dbb3fb50a1b27a8cdb'),
('963','10519','Service state','cc5f50f62d4a4895aa64d167f56cb99c'),
('964','10520','Envoy listener manager','2152e7a114f3489eb6ea80b948c0db5c'),
('965','10520','Envoy server live','c05c038099d74d11b6fef057518a1fc9'),
('966','10520','Envoy server state','f467d440b03e4dab8cc4b15f87185eb5'),
('967','10361','zabbix.host.active_agent.available','0407f8e83ce94d9b88db8dab241e44c0'),
('968','10326','zabbix.host.active_agent.available','c63064c6717e4604805491ce54166356'),
('969','10343','zabbix.host.active_agent.available','d4a5821461a243c9bf320ea58be1af23'),
('970','10351','zabbix.host.active_agent.available','131de6a1016e43019d7cac2ce76901d4'),
('971','10521','Consul Autopilot healthy','92638a6d5a9347edb011a8c999a9895e'),
('972','10521','Consul health state','1f966e7c41134551870c82f013f0b2cd'),
('973','10521','Consul Node role','8d8f7d7e37a44fe8ac590147f621cb4c'),
('974','10522','Consul health state','9c120a74ede844e6a410b7e2c2d712bb'),
('976','10524','Controller status','3bb065172c93464c9f5e2e569f523a05'),
('977','10524','Disk group status','78f22a3d82a64372abb3e3eeb08cf03e'),
('978','10524','Disk temperature status','eb92d7812b8e4d2dbe4908fc3d42ade8'),
('979','10524','Disk type','e6478ee0a41b49778f2a3dc130649838'),
('980','10524','Enclosure status','243d29502c1c416c85eb2ccc961a159c'),
('981','10524','Fan status','40916613dcf24dc2beb8634ec67c04bf'),
('982','10524','FRU status','f656acc354ab4593a1c1718668c02001'),
('983','10524','Health','448c57be77694badb75dbdabe9b233df'),
('984','10524','Port type','66a23d01db744677a1878143ccf102c7'),
('985','10524','RAID type','996bbe1c4e2841d6ac35efd9b5236fef'),
('986','10524','Status','6c5d6649be2347ca83258f0ab1a63137'),
('987','10525','Controller status','f7af1259f3c54a5faa040c743d386d1d'),
('988','10525','Disk group status','6bb0dfe12f4249ef9f4b804885c70c60'),
('989','10525','Disk temperature status','de0e7d801a9b42cf80fe4c71c0eed982'),
('990','10525','Disk type','10547e62c7bb4581b347bc523ef03582'),
('991','10525','Enclosure status','37317f19f7d74b8fa61dd1b28e6f4d42'),
('992','10525','Fan status','1acc14c82fba4c3daa207d0ce9b702f2'),
('993','10525','FRU status','284ed898fb7c46ecb8d719646445264c'),
('994','10525','Health','cb8c3d00dfd4456181765b8b350ea4d2'),
('995','10525','Port type','ec101e7d212747779ed56ef9dbf72e2b'),
('996','10525','RAID type','171c9abf20514b0fb78d532bd987881b'),
('997','10525','Status','402b0dacf14a4436b0d3cfe237bf1e86'),
('998','10526','Boolean','79ba0611293541f29f8b43b34e64465d'),
('999','10526','diskState enum','fd9a3483b02f45c6836b9a126b669402'),
('1000','10526','hardwareType enum','7513c4c923884ed4b8e35ee9cdf4f627'),
('1001','10526','portConnType enum','5d243add5b534ebfac8ef95d55c4c8c9'),
('1002','10526','portFailOverState enum','5762248dd10143a3945c989f0fb73b47'),
('1003','10526','portLinkState enum','5a6cdc765c254f17b136c4267fc71349'),
('1004','10526','rcopyStatus enum','eb36574d642d4f9ea51688b4ff971c91'),
('1005','10526','Service state','aaa5a863e8524a7088e64a51f5976c98'),
('1006','10526','State enum','86e4337cbc86423fb9f605a9fb3b25b1'),
('1007','10526','taskStatus enum','5cfd4442b6244399b7aa8b57e9816a4e'),
('1008','10526','taskType enum','9a8e1dbbb8f7497c9492fc941fde7177'),
('1009','10526','Volume compressionState enum','f529111642364bb3a23637adc554e592'),
('1010','10526','Volume deduplicationState enum','716912c7b7d94f8e97fbf911edc9578e'),
('1011','10526','Volume detailed state enum','6a2355e32bf54483b252f1aaf170aa45'),
('1012','10527','Alarm state','50b7fdfdf6de41f4b4b210a07c10cd77'),
('1013','10527','Status check','d59e4f0c6aaa40bcb5f504f6743d9201'),
('1014','10527','Volume attachment state','cf0267337f284182a43db45d823824b7'),
('1015','10527','Volume status','4f31d29791b94e37b065f790609c50b5'),
('1016','10528','IF-MIB::ifOperStatus','b556be6037b449139eab7830cdab494a'),
('1017','10528','IF-MIB::ifType','c9a24f17cf8243feb44825d707132180'),
('1018','10528','Services status','0cb987b54d4243009aeae0454d0c059e'),
('1019','10528','SNMPv2-TC::TruthValue','1e5ba7a78b5843f0a97edc51eaa96778'),
('1020','10528','zabbix.host.available','187ea1eb9cdb4f52bf5a6651820024a9'),
('1021','10529','Alarm state','4ff4cda021a4464ebbebb42b7ee02673'),
('1022','10529','Read replica state','69bbb2cfded14be6ac596408bdd4de37'),
('1023','10530','Alarm state','5f232f40f02246ab843c9aacdcf8d5c5'),
('1024','10532','Azure resource health state','38c8ce1516704ec2a6f1ea9686db56b9'),
('1025','10534','Boolean','20d3a73c6cc84329a5dfafff29de32cc'),
('1026','10534','Device presence','d3641b3e94ad495f8e0c5c49984a5aa1'),
('1027','10534','Enclosure state','082018b109e24116bbd92f0657113165'),
('1028','10534','Health status','05742432aca048ca96684ba52bd058ae'),
('1029','10534','Hypervisor manager state','6cd4b888faa442c19392b959f1605179'),
('1030','10534','Link port state','930add5553ea42668e590c9824d9e8d3'),
('1031','10534','Logical enclosure state','556391b7f9c045c89d28ac52a1082635'),
('1032','10534','Maintenance state','e26c553cffab4766866bf25639fb89da'),
('1033','10534','MGMT port state','c66615691cba4abc9c7adecc29bb346b'),
('1034','10534','Migration state','6feb2826df9244a8b6b7732c98090b63'),
('1035','10534','Partition health','b878a1503ac14781a142f69a587264ed'),
('1036','10534','Partition status','2c6d8b81e7ee4407b17ca06739ac71f1'),
('1037','10534','Physical server power state','7daddccc109d41f8abf1e04ba1fbd358'),
('1038','10534','Power state','fe093138fdd14f7f80fa4498d91d7fa0'),
('1039','10534','Rack state','5a4901bdd6024256afbfebee6827e103'),
('1040','10534','Resource state','ba5903d60953477aafd313d3688c8dd8'),
('1041','10534','Server hardware state','a545b93c790741a29b726f04f03cbc8f'),
('1042','10534','Service state','2d6f2f67dc114502ae699e873130ba23'),
('1043','10534','State reason','647f5a6d2ce54e78af163f8676f3f1e0'),
('1044','10534','Storage volume state','e20d58a33c3b4a8891dda5da8b86cd5a'),
('1045','10047','Compatibility','b985f0f026be4889923f5d16393e5383'),
('1046','10047','Last seen','3b60aa68965f47baba665e354e0e79de'),
('1047','10047','Proxy mode','7c52b5e2d2434edeba089e136a7eb845'),
('1048','10047','Service state','0d2da53a4e404248b9d156b5a7342002'),
('1049','10261','Compatibility','2498ad0b91d742888acccd435ba52962'),
('1050','10261','Last seen','53d1560f612540d98a2983516b4b9f8c'),
('1051','10261','Proxy mode','cdbd6c1bc69b4dcf925a1048a970139b'),
('1052','10261','Service state','7a5e7def958c4f16b9380d4b81f609c9'),
('1053','10539','Azure resource health state','4eec167b4d69441398b96b8e375d6825'),
('1054','10540','Azure resource health state','323a5259fb854724891515767f341540'),
('1055','10543','Azure resource health state','f208cf6141c44659a2c6904ec4cd7ac3'),
('1056','10544','Azure resource health state','61fc206aaae04abda4012e031f0e27ac'),
('1057','10547','Device status','24967dff65a048578eae18b2485907cb'),
('1058','10548','License status','af92df09c58c4c9287fe294b7b90e193'),
('1059','10548','Uplink status','e16992443a614d81a7f4186622709971'),
('1060','10551','CISCO-ENTITY-FRU-CONTROL-MIB::cefcFanTrayOperStatus','aadba98c69b14fbab88e7c37cab158c6'),
('1061','10551','CISCO-ENTITY-FRU-CONTROL-MIB::cefcFRUPowerOperStatus','166e0ff278184ab7b574833bb0dbaec1'),
('1062','10551','CISCO-ENTITY-SENSOR-MIB::entSensorStatus','2c29188a8b70409eb9735be0caab0393'),
('1063','10551','EtherLike-MIB::dot3StatsDuplexStatus','feee58fb80214a779f809b5b5ea098d4'),
('1064','10551','IF-MIB::ifOperStatus','29398bbb22bd4743944d117f17973bcb'),
('1065','10551','IF-MIB::ifType','dc2b653516504e14a19afc2d2d9f6ef1'),
('1066','10551','Service state','e523e2589daf46be96abf630047538cd'),
('1067','10551','zabbix.host.available','7b2dabb391bf41d1ab5084248e77efed'),
('1068','10552','Control-M service status','54213ae65be64878988c9145d8ae86e4'),
('1069','10553','Control-M agent status','55b997715e1e4a4cb5272874b975b43a'),
('1070','10553','Control-M job status','14b119c7f4a940ea91a8df8c4b114eca'),
('1071','10553','Control-M job type','d6b4e3c8d5934bf08aeb19c8a2f52de4'),
('1072','10553','Control-M server status','f0e3072f0cc44236802ea58f13ebb3ae'),
('1073','10553','Control-M true-false','37a4770c51184c5e9a8d1306625babf3'),
('1074','10557','Azure resource health state','6f9c01899d9e45c9a1316ee081718e9e'),
('1075','10558','Azure resource health state','c87b2eaeb88c4932ad63c73fcafa5331'),
('1076','10561','zabbix.host.available','0d5e922550954e6bad89b22f1d9d0c65'),
('1077','10561','Zabbix agent ping status','e5a39fd666b04b70b6eea53e2373b564'),
('1078','10562','zabbix.host.active_agent.available','9f93aabb08794395b1c62cf784fc58c3'),
('1079','10562','Zabbix agent ping status','9bf3eef7e8d8402ca6f826b377ea2db6'),
('1080','10563','Service state','1817725a41454fd3b9ad22feaf889fc5'),
('1081','10563','zabbix.host.available','ced60845a741400390ba002e69e26b0f'),
('1082','10564','Service state','bdb5d65d925542eaa61c302dc40fbfe8'),
('1083','10318','Docker container health state','bec7f850ca6a477fbaa6c409d971259f'),
('1084','10318','Docker date format','2465e37ba23f4a7cb895835d8cf94737'),
('1085','10510','PV and PVC status phases','f5aa4a786972420b859029116aac8a2f'),
('1086','10571','Database availability','d2aa57a09cbb43e8b53b11316193f013'),
('1087','10571','Instance state','1c26d58d111b4689a2e7acd23a38f1ca'),
('1088','10573','Database availability','8aa36f0f6a0b42a3b5e0eabfb700e8db'),
('1089','10573','Instance state','9adad9dad34646d79bcc6c414ddf8afe'),
('1090','10574','Replication state','ea83090a16d94eb3bb643009c784d820'),
('1091','10574','Thread state','b1acfa66a401499cae56777db6c7750b'),
('1092','10575','Database availability','c783556dfa214e73b676ca187648c5df'),
('1093','10575','Instance state','bc3b08ca201d438689678a29e3575823'),
('1094','10576','Replication state','af111e6b9e5a47cd9c3933b8ce35076c'),
('1095','10577','Instance state','d5f19327f8b74b44a40950d9d4f9410f'),
('1096','10577','Integrity validation status','1e17bce361f9486dae764fc195561703'),
('1097','10329','PostgreSQL checksum failure status','cd2d975b0d7e4f8e89afb1033fce4ce2'),
('1098','10583','Alarm state','6b0f40b56f1c49f0beb66ffb85009c15'),
('1099','10583','CPU Reserved','bb1024c6e5a14c05a8a91ea36aff6d99'),
('1100','10584','Alarm state','2de56a6f2b004624976a39e7b58ea193'),
('1101','10584','CPU Reserved','e49859d7e9b1494181dec88a386b4bb2'),
('1102','10587','Availability zone state','b5d0c4e859eb4b2d854f551e3d8aeff5'),
('1103','10587','Compute service disabling reason','1073ca0bea3f46ebbfbcaba628484be8'),
('1104','10587','General state','a497438c723f4be88f452af2e8627613'),
('1105','10587','General status','c8109a75cda24fe1afec8ea68686cdb0'),
('1106','10587','Server status','375a709551d84ba3b0d4f24b6e0bd291'),
('1107','10329','Service state','6619a58602a44e83950d3d4b5180c0e9'),
('1108','10589','PostgreSQL recovery role','6e5062ae5345454f95cb8608b35eddf4'),
('1109','10589','PostgreSQL replication status','75393338fb514612a5f0ba57cec318b3'),
('1110','10589','Service state','f2af00a32d1e471a98b9e4e6148f68f3'),
('1111','10591','Admin status','ac1ad6688715425b8d6d0ac3c7e72b14'),
('1112','10591','Device state','7de6a0190832425a9b05d9740a6495c6'),
('1113','10591','Not used','a8fdd703646d4f3bb5c3ac7b39fd65da'),
('1114','10591','Operational status','a563ee950d954a3086170c5de9cabf71'),
('1115','10591','Reachability status','93bca94da129493ebfd4e7a9f833bdf8'),
('1116','10591','Unknown','fe4450cc25624972b754d834f369e7fc'),
('1117','10591','Validity status','7ab3966394504fb6a55c3247f4754729'),
('1118','10595','Detection state','766a3c43981147bf85e9e157eb69c510'),
('1119','10595','Driver state','c202a63acca7407bb6d61bf631696691'),
('1120','10595','Service state','40e17de6519d44bb80b4566e0569c31b'),
('1121','10596','Autopilot state','9898b464447240919cf8e25016be687f'),
('1122','10596','Cluster role','fe32599dc75c48f6ab0887652ceb728c'),
('1123','10596','Service state','b90612059a164f3fa0c7ab871afa0c59'),
('1124','10600','Alert severity','0c425866d0ce4412a54b66f215df4cde'),
('1125','10600','CyberFit score','4a5652b3706a45faa2b86ae652425692'),
('1126','10600','True false','df45c606a7ef4f49a3101ad135eef1bc'),
('1127','10602','Last activity','19c5ab8f192d42f4bd35a969bef3c9d6'),
('1128','10602','Quota type','18f5c94273b24b88a96bdf9d01b8d63b'),
('1129','10602','User status','3265bb49d935495abbcf8b24fbe8ed91'),
('1130','10603','Firewall policy action','8b0c51b152b04ba690cd13e43a2c90d9'),
('1131','10603','Firewall policy status','2285b34278df448ab2ba2276913c0b77'),
('1132','10603','Interface status','7aa1df8cbdda4d3aa5bad0af95733a06'),
('1133','10603','Interface type','6d6a2211c6e64ecfb00838886750912b'),
('1134','10603','License status','0e225b17b2e543f18fea31366d9b6286'),
('1135','10603','Link state','76ac7f91b2184689b19dc838cde49ade'),
('1136','10603','Service state','176db78d3aa34c92893300d56eda5737'),
('1137','10603','Service status','3b62f79c5a664465897a372e833af713'),
('1138','10604','Interface status','3ba88094988045799337ddb456936f15'),
('1139','10604','Interface type','61e451f29c9943cf81ed2647166d664f'),
('1140','10604','Service state','398df996f3474f2abdd26d52d5c83dd5'),
('1141','10604','Host availability status','01c410206d2c4754bcaa0dbcbeacade1'),
('1142','10548','Boolean format','ec79f04ded684421b644b38500fe8b26'),
('1143','10548','License statuses','ba834580763b481a8800a0323fa61327'),
('1144','10510','Build status phases','a315a447059e49f9bc0c3e2e9964696f'),
('1145','10048','Proxy buffer mode','10388a0c06864ac483377f4ad3a91854'),
('1146','10262','Proxy buffer mode','70f06f62852c428b94f1f2447d58a6c8'),
('1147','10605','Computer system type','724ed4e07ca34bf594719298055a0837'),
('1148','10605','Drive status','dacd46f1412e4ce2adfa0d938ebbc952'),
('1149','10605','Manager type','30627d058a064666b08c0bbdacd75fe3'),
('1150','10605','Media type','aecddd070d53474eaca622da04842d53'),
('1151','10605','RAID level','0aab2ac5ea59435280e84683bc852d32'),
('1152','10605','Redfish health state','267eae89956048769dcf6eb015b921ba'),
('1153','10327','MSSQL Quorum members state','1454643e9cad46f8953f4c054509151c'),
('1154','10327','MSSQL Quorum members type','caa789916da048c691f8eef5a71a856e'),
('1155','10327','MSSQL Quorum state','23c9fede4c9a4a21854b3fc83de459a7'),
('1156','10327','MSSQL Quorum type','fbf296f404ad45d5b02e3c20104b9b9e'),
('1157','10327','MSSQL Recovery model','f59af5b534994dccaebb4afc3266520b'),
('1158','10607','Alarm state','4bb749152d5d452ead36c5a98c3cac16'),
('1159','10609','MSSQL - Yes / No','0d7dbd62613540cc8dd70d2f0ec76db6'),
('1160','10609','MSSQL AG Connected state','1f962ea838d640d5905ae14d66826239'),
('1161','10609','MSSQL AG Join state','034a175b7fba4e4d8e85806c8f801f18'),
('1162','10609','MSSQL AG Operational state','fbbaea2f75f94b7ba0bb2ed2756e2593'),
('1163','10609','MSSQL AG Recovery health','c90a7f77957a40c8bb6c9370ff1f63d1'),
('1164','10609','MSSQL AG Role','b07e0cd2c7fd4411b16305141058c9d7'),
('1165','10609','MSSQL AG Synchronization health','dd1d46bfb14946769dc929ae1947a328'),
('1166','10609','MSSQL DB state','eeca1ed2c3cb4624b045b9ba0007f1a6'),
('1167','10609','MSSQL Job Run Status','bc4b734c0c3e4f508323a8880a9b27db'),
('1168','10609','MSSQL Mirroring Role','09480e835f474f22ba463b7c6b486de1'),
('1169','10609','MSSQL Mirroring State','6fd710f80063456483f47dab9fdab3c3'),
('1170','10609','MSSQL Quorum members state','300744b8bf494bc09cae58f1366e8043'),
('1171','10609','MSSQL Quorum members type','38b1c1c9183f450cb3256fefaa8ae24a'),
('1172','10609','MSSQL Quorum state','047cb848051f4e85a1f45664fd51255b'),
('1173','10609','MSSQL Quorum type','2697dc5e3d5e462aac7951844a9fa76c'),
('1174','10609','MSSQL Recovery model','1002338ba75c49f89ce5c27872818ff3'),
('1175','10609','MSSQL Safety level','8800c652dc154231b40e996b39c7c2dd'),
('1176','10609','MSSQL Witness state','0be116423b4949959053d581cafa096c'),
('1177','10609','Service state','faafc4168c5a4eb09d20ab4168fbbc9e'),
('1178','10611','YugabyteDB Bool status','8bac0bddc0f144aa901cd15d9cfd0825'),
('1179','10611','YugabyteDB Cluster state','7d6fa95c4346489fae2cdefa436bc9b6'),
('1180','10611','YugabyteDB Cluster type','10b748dae0334399a004e0e412682ccb'),
('1181','10611','YugabyteDB Health state','73aa9e520a2d491c883f7e65b6187fd2'),
('1182','10611','YugabyteDB Keyspace type','8d5264a7981d4e39bab56d4241dda9f3'),
('1183','10611','YugabyteDB Node status','63244be33897496d8f9599aca76e34e1'),
('1184','10613','FanSensor Status','6a115abb186b4f9fa22477c858d60c9e'),
('1185','10613','Firewall SIC Trust State','77983c82abc44f418cacaf98c57be31a'),
('1186','10613','Interface Status','863e809ef63b47168e97c3ea34095503'),
('1187','10613','Interface Type','e2ed7260bd594394b85cb5f803c9d47a'),
('1188','10613','PSU Status','24c77b8db1e44ffd8dbb3547c9140326'),
('1189','10613','Service state','9bef9869d1b94f78b4a5388d34f84a47'),
('1190','10613','VPN Link Priority','4e09769502b84240aff18a24b17f57e0'),
('1191','10613','VPN Peer Type','60597b4621df494fa8e69b7eb2806f4a'),
('1192','10613','VPN Probing State','02a3a896c3a14a23bc882657a8e72c0a'),
('1193','10613','VPN Status','673a59778998478e8752726f1d7cf5c2'),
('1194','10613','VPN Tunnel Type','6109e694ded24bb5a6042805e0e5bda5'),
('1195','10613','Zabbix host available','acb530d7d3ef431f98748e928a088ecb'),
('1196','10614','Autonomous database state','e336c0d4e22f4f9f9c42d6de65fed068'),
('1197','10614','Database availability','3b30e8a71ef342e78f9f29243aafd992'),
('1198','10615','Block volume state','780a56fd95474839943cbd2f8be2fc18'),
('1199','10616','Boot volume state','d881a2a2bedc4556a36f3d676ece0456'),
('1200','10618','Compute instance availability','9e238671edca4ed7b58eefacc861a77d'),
('1201','10618','Compute instance state','c336821eced54261afb0d10a0de6601d'),
('1202','10618','Generic Bool','dce0b4413ede4dbca55f89cbc86736b3'),
('1203','10618','VNIC attachment state','8fdcb86d1dde4d2489239dd61fbd8b08'),
('1204','10619','Lifecycle state','abf7b45647ee4a339df92bf06b12f0df'),
('1205','10604','HA load-balancing schedule','a7e08ed8bf9d4372b60dd44157ed8dc3'),
('1206','10604','HA option status','e90736cde03046dd87f6532af522bd03'),
('1207','10604','HA sync status','1ff2500e234e46fdb532de670a5f2aea'),
('1208','10604','HA system mode','65bdbcdc23994f2a8944f5c69a9b061a'),
('1209','10604','Health check state','7099e2e064d34d32b4a6f96a10798124'),
('1210','10604','IP Address type','8aa46ac9d6c44ffe8213c8f09a42eb50'),
('1211','10604','Option state','ba3b57b54fb44466aca78692ba3dda97'),
('1212','10604','Sensor alert status','c41154255ef34d65bc0636bef7fe0bfa'),
('1213','10604','VDOM HA state','a0ba5fd924d8458d9be8e70db252277d'),
('1214','10604','VDOM operation mode','b0decb11dd494681b813bc4bd03a6b1a'),
('1215','10604','VPN status','44e1f0b6062c414a8252fe34bad1987c'),
('1216','10604','Wireless admin status','08690a78109441c78c8f5bafae3cd3a4'),
('1217','10604','Wireless band type','a5a52ea3f94242eba7220554244ce63a'),
('1218','10604','Wireless connection status','40c5ac1ba5034b5490faa930ee7ed331'),
('1220','10627','Alarm state','e0e5308401bd4abfa79ba604c0481d2a'),
('1221','10629','Connection availability','6d06a74d603f4ffd8540c8b87f910c7e'),
('1222','10629','Limit mapping','ae5cd12f5e3f4da7aab84db686771cb1'),
('1223','10629','Mail sender','c5e16a1b701e429e8eff56c598530d60'),
('1224','10630','Azure resource health state','fc7ca60876144ac8b240db81537920a6'),
('1225','10632','Alarm state','a61fdde5c78748339a903f1224524deb'),
('1226','10634','Boolean','21844e435a364b2f92d675f0967e115a'),
('1227','10634','Workflow run conclusion','9175771d066042c49ac1583c0e8689c6'),
('1228','10634','Workflow run status','9b86b16774094f5e9c06286b27f6f440'),
('1229','10635','Services health status','cb431f0185884aabae7d46890926e724'),
('1230','10173','VMware Overall Health VC State','7e24ccef9d754cb4805df5b1f27f4ef4'),
('1231','10174','VMware Consolidation','be14ef9303f040859e6edbb13d9b64c5'),
('1232','10174','VMware Tools status','64586743ecc74b5a8b7b849cd4521f48'),
('1233','10174','VMware Virtual Machine state','68d712e1c43c4e2d84619c9fcb965919'),
('1234','10175','VMware Connection state','66bedf62dffd4402a037a6ef0f93f228'),
('1235','10366','VMware Overall Health VC State','30aec8e3198e4b91b1182514be8a8f6b'),
('1236','10047','Proxy group invalid value','8c23fc3b231b439a8eec4d0d60859c90'),
('1237','10047','Proxy group state','acd6475b06334535be452cd984a11f6b'),
('1238','10636','Huawei storage: Controller role','98ea0c82a56a434ea9cd02ddb31eef6a'),
('1239','10636','Huawei storage: Health status','7ef6825cca084ab9a3250448596fac32'),
('1240','10636','Huawei storage: LUN status','654d5d768ff041c6abc0a438be5698f4'),
('1241','10636','Huawei storage: Running status','e03d03289e84401b8c7e2ba1ddc67ba7'),
('1242','10636','Service state','f8cf9fe95cc54dcba96d4bfe8d8ec34b'),
('1243','10636','zabbix.host.available','da38017b841a4c17adff896fe2cbc9fe'),
('1244','10637','Service state','872ac3dadab34de9a69acd71d68cd7ea'),
('1245','10639','Service state','664f36475a624b6bbf6a23c430baaa9b'),
('1246','10640','Nutanix: Alert severity','86e15b9ab1e04285a8db065fbdf6eedf'),
('1247','10640','Nutanix: Alert state','079d797917c64626af20ce86249c2969'),
('1248','10640','Nutanix: Boolean','10ec1428fba54eeaabc6503361090761'),
('1249','10640','Nutanix: Cluster operation mode','537aaf6158724960a2535913030f0138'),
('1250','10641','Nutanix: Alert severity','c2fbc73721564974adb6251fdb372f70'),
('1251','10641','Nutanix: Alert state','7972e3d351f04d1b9cd4b7a542d8a81f'),
('1252','10641','Nutanix: Boolean','20773014179d419cae5306b0370d405c'),
('1253','10641','Nutanix: Degraded state','6e081d8e0e4e43f7914b311ce2925f82'),
('1254','10641','Nutanix: Disk status','1381c5ba61eb4cb89303b6256f81e036'),
('1255','10641','Nutanix: Host state','513019c2559c48cfbc6c801179c4a7ce'),
('1256','10641','Nutanix: Host type','d934bf8ae17c4ed78a439b92cf2f7bef'),
('1257','10641','Nutanix: Maintenance mode','1ee8073575c842269be02dd94211c22c'),
('1258','10645','Service state','a4bc71640e694328a20fe200c7c5fece'),
('1259','10646','Service state','3592fb0098304d86ab35a6a86aa95ec5'),
('1260','10647','Service state','53bef1cc5ae849e4845ffdd0dd6bcc6a'),
('1261','10648','PostgreSQL checksum failure status','9b9961c136c4426bb6d11c749cbb4cfa'),
('1262','10648','PostgreSQL recovery role','bf1b2c09ce844d9c8b2735901fe77a03'),
('1263','10648','PostgreSQL replication status','ee126cb6f7e14a93ae1e21106ee8732f'),
('1264','10648','Service state','e11dca50f6e4481fa1fda75aeb71cf8c'),
('1265','10649','PostgreSQL recovery role','6337031a50574f65aec828b7dd48beaf'),
('1266','10649','PostgreSQL replication status','0e115837e8c54923ad10a9b7adcda3dd'),
('1267','10649','Service state','5bc68afd88094e0fb14572246050181f'),
('1268','10650','BGP4-V2-MIB-JUNIPER::jnxBgpM2PeerState','3b94e9f3175c4822b93682636e5cf64d'),
('1269','10650','BGP4-V2-MIB-JUNIPER::jnxBgpM2PeerStatus','6a57534ae79048229a3ed10f9f0a52e4'),
('1270','10650','EtherLike-MIB::dot3StatsDuplexStatus','aba24883ea0f4a569748153eb554443a'),
('1271','10650','IF-MIB::ifOperStatus','93ba7232ec5d47db9478d91b6bdfd01b'),
('1272','10650','IF-MIB::ifType','ecb1a90bea804c79aa074876a95397ae'),
('1273','10650','JUNIPER-MIB::jnxOperatingState','71aa874db0c647f2ab6b6f6ed741efa3'),
('1274','10650','JUNIPER-MIB::jnxRedundancyState','0432e6064cae4a22bdd512d0c8900f35'),
('1275','10650','JUNIPER-MIB::jnxRedundancySwitchoverReason','742e0675e0b84ba685b1b06172334215'),
('1276','10650','OSPF-MIB::ospfNbrHelloSuppressed','5d007beac7eb4743ab241d6a1c80847a'),
('1277','10650','OSPF-MIB::ospfNbrState','ed5b11312aaf44e0b888c58743e89f81'),
('1278','10650','Service state','1373262e914a430abe52ec79d2fc138b'),
('1279','10650','zabbix.host.available','bcba269d955b452d87a6f49f7a35ed2a'),
('1280','10651','Azure resource health state','9bb00a69069d4c22a0b75b745da0de73'),
('1281','10651','Azure SQL instance provisioning state','aae2eec109b649d38e80684cdeb9458c'),
('1282','10653','BGP peer status','8f6bef0b83a440ec9e54676840809c47'),
('1283','10653','Boolean','75f5d630b1b74c7c8233b44422bba5eb'),
('1284','10653','HA mode','1ce2f4a43b274e719e9e44d24cb826bd'),
('1285','10653','HA state','3148f488405c4c3a8ca055891550bda1'),
('1286','10654','Network interface status','122afb9826d4493aa319b67025bd5e74'),
('1287','10654','Redfish API availability','2cfad557b52d49f7a56f84323c7b098a'),
('1288','10654','Redfish status health','0b3b101349fa4b4d94983d7fdae83679'),
('1289','10654','Redfish status state','e9e6e46c13fe4bd0a29b65cad929c6bc'),
('1290','10654','Virtual disk RAID status','29051e06a48b444a8ee285cd185ae04f'),
('1291','10654','Virtual disk read policy','ac7f30cf50cb459aaa41103c8fa6df1c'),
('1292','10654','Virtual disk write policy','39e0e7ddc8fd459e90fdb247caee7512'),
('1293','10655','IDRAC-MIB-SMIv2::batteryState','ffad2b2a57364726ba31cfc89f363e2b'),
('1294','10655','IDRAC-MIB-SMIv2::BooleanType','053a4a529ddf4bc7b1971958e4dce5c9'),
('1295','10655','IDRAC-MIB-SMIv2::NetworkDeviceConnectionStatusEnum','2216bf2485f548be90060048eec6547d'),
('1296','10655','IDRAC-MIB-SMIv2::ObjectStatusEnum','58480240826e49b09bf73f682f252148'),
('1297','10655','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','e44bc856e8d449f9a288b614b7d6a143'),
('1298','10655','IDRAC-MIB-SMIv2::physicalDiskMediaType','e17dbbe344994170afa47b3d76b393f8'),
('1299','10655','IDRAC-MIB-SMIv2::ProcessorDeviceStatusReadingFlags','c9543b611d434fba99d4be3614813419'),
('1300','10655','IDRAC-MIB-SMIv2::StatusProbeEnum','d2f5ad57814e4c3ab8f1e7b1fa076557'),
('1301','10655','IDRAC-MIB-SMIv2::virtualDiskLayout','70851c009b4d4f0484f3bb955558c1db'),
('1302','10655','IDRAC-MIB-SMIv2::virtualDiskOperationalState','160204c8609542038d31357ce58424df'),
('1303','10655','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','c1686f5a938f4dac977d55517687358e'),
('1304','10655','IDRAC-MIB-SMIv2::virtualDiskState','1c3e3bcf7ff14f59ac24f9d62f6671af'),
('1305','10655','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','0a940bdd7900425b941e11e486e70c8a'),
('1306','10655','zabbix.host.available','20182c95fb0e494a826a7ae3f932127b'),
('1307','10435','Network interface status','623bbf13357f4b22a4030c813437db18'),
('1308','10435','Redfish API availability','8be2ad02ae4c4836bc21816e89a906ac'),
('1309','10435','Redfish status health','32fa026175444306b08fe3cf6618a98a'),
('1310','10435','Redfish status state','b30ec1c62a124a48ac129e6065d3180d'),
('1311','10435','Virtual disk RAID status','a63d06ed53ac4f3fb07a7e584301f34a'),
('1312','10435','Virtual disk read policy','3e1d1bf56dd841c7bdc9679ff8e24748'),
('1313','10435','Virtual disk write policy','c11a3e902ef248a5a1a77af824b43252'),
('1314','10436','IDRAC-MIB-SMIv2::NetworkDeviceConnectionStatusEnum','d731845914484868bbcb3c3e5b9d7707'),
('1315','10436','IDRAC-MIB-SMIv2::ProcessorDeviceStatusReadingFlags','4b8e905e42a94f8ebb9a9a4b2648ed84'),
('1316','10437','Network interface status','14d13bad8ac34a8987c178a3ab12bcd1'),
('1317','10437','Redfish API availability','c38ce461129d4d338847d86a5e051d09'),
('1318','10437','Redfish status health','8074a7bb6e304adc8945bbeffab84ca6'),
('1319','10437','Redfish status state','417f088da9f34fd9b0f75769a44cc126'),
('1320','10437','Virtual disk RAID status','78b955ca37dd4d3da9230b7263694206'),
('1321','10437','Virtual disk read policy','90bf833092b8409a818439b6a2eb9fbe'),
('1322','10437','Virtual disk write policy','a261537c3f7e4dd3a14ba4bad0c930dd'),
('1323','10438','IDRAC-MIB-SMIv2::NetworkDeviceConnectionStatusEnum','9dbe9b652e7746229cf5ef744a67c566'),
('1324','10438','IDRAC-MIB-SMIv2::ProcessorDeviceStatusReadingFlags','1c683fea74b645ed9f42d8fcd6edf442'),
('1325','10656','Network interface status','56fb82a2303e451b9a585687a0902794'),
('1326','10656','Redfish API availability','c1074235685c4d2096c30a3ab686634e'),
('1327','10656','Redfish status health','a5e2bf8ce89a482aa87ccccbf01cb1cd'),
('1328','10656','Redfish status state','c295caa412b74acb918176f8d4543010'),
('1329','10656','Virtual disk RAID status','d88a53d7143a49dfb37057f9d80ed48a'),
('1330','10656','Virtual disk read policy','46520ef5e9e544c4a4393bd6a2ed4548'),
('1331','10656','Virtual disk write policy','6c17f062dc8e4f7cb2362adcffbe11c5'),
('1332','10657','IDRAC-MIB-SMIv2::batteryState','44ae746465504433b126a6ad47867539'),
('1333','10657','IDRAC-MIB-SMIv2::BooleanType','540df39092da4d0ba419d9225b6855e5'),
('1334','10657','IDRAC-MIB-SMIv2::NetworkDeviceConnectionStatusEnum','bcd3842a7f14414786e7e893bf18033f'),
('1335','10657','IDRAC-MIB-SMIv2::ObjectStatusEnum','0e8b14fc00af4ec1b098b1dad64bbf12'),
('1336','10657','IDRAC-MIB-SMIv2::physicalDiskComponentStatus','7c02091fa34847cb8571066c5f1ccfd3'),
('1337','10657','IDRAC-MIB-SMIv2::physicalDiskMediaType','a0c2ee107bc24efba036b01f8aa16c03'),
('1338','10657','IDRAC-MIB-SMIv2::ProcessorDeviceStatusReadingFlags','b7f4bdede53e44ada2841fb5d39793db'),
('1339','10657','IDRAC-MIB-SMIv2::StatusProbeEnum','1b7e62b02f6d4b9aad5e81de0792037e'),
('1340','10657','IDRAC-MIB-SMIv2::virtualDiskLayout','f3ed0698bf4448ad9927f193aa804365'),
('1341','10657','IDRAC-MIB-SMIv2::virtualDiskOperationalState','5e0085d3c952446a8fb9603b074d720f'),
('1342','10657','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','65fbf402163e494aa59a7dc814a038f9'),
('1343','10657','IDRAC-MIB-SMIv2::virtualDiskState','ce091236ac5c461da03712a39e97676b'),
('1344','10657','IDRAC-MIB-SMIv2::virtualDiskWritePolicy','d30e0073fbab42ecbb1c4ab74ad1f991'),
('1345','10657','zabbix.host.available','f5c3e47da21c4fd8ac4fd2c079ebd28b'),
('1346','10439','Network interface status','a9fd1db9128d4efca329941ff4f4d41b'),
('1347','10439','Redfish API availability','45c31886b41f4592bb87ffe940ce9fd8'),
('1348','10439','Redfish status health','e8d3f0814cad4a2bba79231c1c8c0230'),
('1349','10439','Redfish status state','d18e6f1b160f4ee3851b21cff3309d40'),
('1350','10439','Virtual disk RAID status','82e0dc0cd4714fb1b3894adff630b0d8'),
('1351','10439','Virtual disk read policy','3c9e776333294c79a975b715fab7a35d'),
('1352','10439','Virtual disk write policy','916622b4d50b4304b95888c9fc49149e'),
('1353','10440','IDRAC-MIB-SMIv2::NetworkDeviceConnectionStatusEnum','8a60520959be4ec5aa525f637beb8472'),
('1354','10440','IDRAC-MIB-SMIv2::ProcessorDeviceStatusReadingFlags','7ad96a534bc84f32afd6ae59011db2a0'),
('1355','10441','Network interface status','4cb6f9b8048a4109849a7f12bf0aba1c'),
('1356','10441','Redfish API availability','dfee913787ba42e49a11dae28d1a603f'),
('1357','10441','Redfish status health','5b5774ab04ec4f3eaf1e528ad02e0978'),
('1358','10441','Redfish status state','f73f21dc4f964efeb4f54f8565d4cd58'),
('1359','10441','Virtual disk RAID status','865251146a524335be8ec054d8df15aa'),
('1360','10441','Virtual disk read policy','b37b8981282944348ab2748fb09d55f4'),
('1361','10441','Virtual disk write policy','ccdd0a176df640e09b95837aba7580f1'),
('1362','10442','IDRAC-MIB-SMIv2::NetworkDeviceConnectionStatusEnum','a866da3a7c4e43d086efafb07178f8ec'),
('1363','10442','IDRAC-MIB-SMIv2::ProcessorDeviceStatusReadingFlags','092b816c537e4fe79c7f5826037c5872'),
('1364','10255','IDRAC-MIB-SMIv2::NetworkDeviceConnectionStatusEnum','0f2ef2e7ca5540fbbbdaa3e51acff0e1'),
('1365','10255','IDRAC-MIB-SMIv2::ProcessorDeviceStatusReadingFlags','c2a88e35b99c4c9d8b369a6edce17b3c'),
('1366','10255','IDRAC-MIB-SMIv2::virtualDiskReadPolicy','25c91adad83c46d48a8308b2e6273666'),
('1367','10262','Zabbix proxy check','d9fa93ed96d1497c9049f8f30267e9ed'),
('1368','10048','Zabbix proxy check','f9f6987645b341b68ba5449c9b741459'),
('1369','10658','Proxy buffer mode','22c73bf5429d4e9baf358fe6c177a033'),
('1370','10658','Zabbix proxy check','942633fa91474837afc5ce050cb86cb4'),
('1371','10659','Proxy buffer mode','550df0eb013b4103ad00dc3cc478189d'),
('1372','10659','Zabbix proxy check','c5cae9ab19384c9f85fe31f7e22ab8c7'),
('1373','10261','Zabbix server check','4eaa5f12801d43d9a5cfa2bca736ccc3'),
('1374','10047','Zabbix server check','9b8fe61b528547f49598075e79fb6623'),
('1375','10660','Cluster node status','c9ec732079f64b5d9e8d4b7c628580e3'),
('1376','10660','Compatibility','ee5e7ff1e0e041eca7483ea45213d3a5'),
('1377','10660','Last seen','edc03d2774094cfcb20afbe8476c85fb'),
('1378','10660','Proxy mode','7247343b21ed4fd4823f9148a3245805'),
('1379','10660','Service state','253052f6133b498eb7248bc3d66fa18e'),
('1380','10660','Value cache operating mode','cfe65eb3384047dfaf31a8d4b09c4de1'),
('1381','10660','Zabbix server check','bf89fa6047464f668db6b324abf0cc3e'),
('1382','10661','Cluster node status','f1f6de972fbc4675bee0426bcb15838c'),
('1383','10661','Compatibility','2e74275424ff4939a9f1a02424fcb42e'),
('1384','10661','Last seen','2e9f0571bae14b6485ae5cb79f2cb3b3'),
('1385','10661','Proxy mode','ae285f32e1884d75bd485ad08106ee9c'),
('1386','10661','Service state','2fa179c8f5f2482ca216270b91896e50'),
('1387','10661','Value cache operating mode','a73ec20cb9e9412296b6d604505376da'),
('1388','10661','Zabbix server check','c2fbdc79f9614caf99aa266087a7317d'),
('1389','10662','Azure resource health state','34874b4cf9cb4ce2863a5698ff308126'),
('1390','10663','Certificate Type','df8766d094be4b5aa569a20e9fc1e552'),
('1391','10663','Connection Status','0e3d616a7682487997fcf4e756bd875a'),
('1392','10663','Controller Mode','2f9f5ae3a2f14408b5fa8c0f82d3d5a6'),
('1393','10663','Controller Status','05c72722f9f9460291f50d3663161716'),
('1394','10663','Drive Status','00a977f4cb4d4962aeae7124e63f460e'),
('1395','10663','Hardware Status','788e2982fbd5478da2a4f94e46031439'),
('1396','10663','Pod Status','950c9c6b81e042938ca464a84a57b662'),
('1397','10663','Service Status','fe5ac2914b2f46fbbd0516e3ee0959bc'),
('1398','10664','Boolean','d2c0016639b2413c85a000746ee56109'),
('1399','10664','Certificate Type','a6f5e4bef3114c4cb08eb4c9e449dfa8'),
('1400','10664','Controller Mode','b6aed58a52b742c680173452935c2bca'),
('1401','10664','Controller Status','f315c5769cbd4eb4ac4721751070d247'),
('1402','10664','Drive Status','ed60650d00594c5c9778501ee06fb648'),
('1403','10664','Hardware Status','92c4cbd25c9f45408aa335aac5bec52a'),
('1404','10664','Pod Status','0142212de71f42bc9f7521447d89ff0c'),
('1405','10664','Service Status','59047ec19a5c4229bce4450f134ac5cc'),
('1406','10665','Azure backup job status','f79314c2d4bb458caf510b85f65cae81'),
('1407','10665','Azure resource health state','7bca76cc48c3468ca67b924f59003e4a'),
('1408','10667','Cisco FTD interface status','b141de8aea904aef8eeb955fe7d09bd6'),
('1409','10667','Cisco FTD process status','2a34dceeb32d44e39be2037a85b9dcb7'),
('1410','10565','Smart self-test','82b0797d499544a4832cda04b163109a'),
('1411','10566','Smart self-test','404d3c19ceef4e8e9c14d5e34bbd2a7b'),
('1412','10668','AWS Backup job state','0296c0c525304ea2ad91070346669b42'),
('1413','10668','AWS Backup vault lock status','b5821fcd5f3444198570b8dfb925ce0a'),
('1414','10668','AWS Backup vault state','d591fd3704ff4fc3a7e5ee6b206190ad'),
('1415','10670','Fan status','0d0532eebc294155a25733c1b7fe7ba1'),
('1416','10670','IF-MIB::ifOperStatus','42f606a7537849878b1090e7085add48'),
('1417','10670','IF-MIB::ifType','0c9ae7b0f91c40afbb1fc35a3e33052a'),
('1418','10670','OSPF area auth type','53bf2bc50e8049049d79fd3e23fa0755'),
('1419','10670','OSPF area status','4f6d5cf1f7ac44509c44cfdd3e21b5e8'),
('1420','10670','OSPF interface admin status','ff8918aafeb7439db7197845b4628a19'),
('1421','10670','OSPF interface state','a2002d515c744e278844803dd3d543e8'),
('1422','10670','OSPF interface status','7cb675b0d69441c9950dcb375ec458a2'),
('1423','10670','OSPF interface type','d69261a6f83c4d31a454b01f101a7c2b'),
('1424','10670','OSPF neighbor state','dc9b1a5f62c147849ff0eea9da891b71'),
('1425','10670','OSPF neighbor status','80a6f0a98231480bb649d030f37bf91e'),
('1426','10670','OSPF translator role','977d715501e74110ad6d5ab308f8dfe7'),
('1427','10670','OSPF translator state','71336b06c8814c5087ebbc891995eb38'),
('1428','10670','Power supply state','8fddba3562234525bec7b05dccbea5db'),
('1429','10670','Service state','797ba226aeaa4bdb96bfe404f3e980d1'),
('1430','10670','zabbix.host.available','b7a8836abbc84e42b2c562ccf4d562e7'),
('1431','10671','IF-MIB::ifOperStatus','0148dfb2980a443dbe2646757115ba4a'),
('1432','10671','IF-MIB::ifType','ce6e6488447a415a8c09869bead48038'),
('1433','10671','Service state','8de09e0fdf2845799e387d182da139c7'),
('1434','10671','WWP-LEOS-CHASSIS-MIB::wwpLeosChassisFanModuleStatus','62614cd4421b45bbbe2e2b06679af929'),
('1435','10671','WWP-LEOS-CHASSIS-MIB::wwpLeosChassisPowerSupplyState','37ba73ce2d34442b93cb781eea12b6e0'),
('1436','10671','zabbix.host.available','e8261a3a0c2f4d69b5be9b070abf9ce9'),
('1437','10672','HOST-RESOURCES-MIB::hrDeviceStatus','0af4bd0246d3414a946fdb800a964a43'),
('1438','10672','Host availability','1d9b43546b654370a6f38ed6fe4d4b43'),
('1439','10672','IF-MIB::ifOperStatus','692e46f1836c4e2682a0dc882fec89a0'),
('1440','10672','IF-MIB::ifType','7a288ac5cdbf429b9d568b12b312ad70'),
('1441','10672','Service state','31a78150623d4ce39a0c98a59bfa5c47'),
('1442','10673','Host availability','1ba10b4dfec646359ae363d8c374667c'),
('1443','10673','Service state','30e84601ccc9488c9f1c81dbf02df4b3'),
('1444','10673','STORMSHIELD-AUTOUPDATE-MIB::snsAutoupdateState','afd4fdd6212547a281a842b806f9b520'),
('1445','10673','STORMSHIELD-HA-MIB::snsHALicence','ee09eb3b1fa049b7bcd9ad51a49d39f4'),
('1446','10673','STORMSHIELD-HA-MIB::snsHAStatusForced','2063c82a4fd54f228655d1c42dd249ce'),
('1447','10673','STORMSHIELD-HA-MIB::snsHASyncStatus','1c7e7fe23de34086b5009a995ee4e71f'),
('1448','10673','STORMSHIELD-HA-MIB::snsOnline','0761fc9c63674cf6914d2d0c36df4391'),
('1449','10673','STORMSHIELD-HEALTH-MONITOR-MIB::*','278a31a580424daebcc73cc0f7f75764'),
('1450','10673','STORMSHIELD-SYSTEM-MONITOR-MIB::snsDiskEntryIsRaid','0c3077b6a7ab46f29226e493fbf7f60a'),
('1451','10673','STORMSHIELD-SYSTEM-MONITOR-MIB::snsDiskEntryRaidStatus','72383baf0804476fb75d1451a344554d'),
('1452','10673','STORMSHIELD-SYSTEM-MONITOR-MIB::snsDiskEntrySmartResult','ac297c469fb348d4ab231e43f935f682'),
('1453','10673','STORMSHIELD-SYSTEM-MONITOR-MIB::snsFanStatus','5ae9550fd2cf4c3f8361ca95b82b3c2f'),
('1454','10673','STORMSHIELD-SYSTEM-MONITOR-MIB::snsPowerSupplyPowered','fc9b6cf135884b0d8dcd4b159304751b'),
('1455','10673','STORMSHIELD-SYSTEM-MONITOR-MIB::snsPowerSupplyStatus','5a30cfb4e78742b0bc421abc334b7953'),
('1456','10602','Boolean','b0913f72fb804d5ab9ef0e9ce13dc61a'),
('1457','10674','Ribbon: Alarm Severity','9cd4e329a1154ebe8ca53cee6dc6c94f'),
('1458','10674','Ribbon: ASM Operating System License Type','3d340848400b4dc59da9d48bd3609bae'),
('1459','10674','Ribbon: Bool','b8451f08019b4b04b176acfb836de8ce'),
('1460','10674','Ribbon: Card Location','0d4b6e2459f446f7bc51a43d484c0a88'),
('1461','10674','Ribbon: Config interface state','38b59bdd6f4b4390ae853247ed21897d'),
('1462','10674','Ribbon: Disk type','1030653f7dad40efb62e6af9d8c75b41'),
('1463','10674','Ribbon: Interface speed','f783799e74a9482db3868b8e4713101a'),
('1464','10674','Ribbon: Interface Type','c713bf35021b4acc87c18bf7555d4016'),
('1465','10674','Ribbon: License class','23e45cd16d4c43eea1c3a085904d6d1d'),
('1466','10674','Ribbon: License type','5f1e2b3e1c5e4b2fa6f3e8b1c4d5e6f9'),
('1467','10674','Ribbon: Networking mode','2e08efb9e354424499526bbff51a61e3'),
('1468','10674','Ribbon: Operational status','f16e30cc4010463ebd7daeadca0962ce'),
('1469','10674','Ribbon: Service status','d11c36edb8984267b85dd1d44e338790'),
('1470','10674','Ribbon: SIP Server Type','4f3e2b3e1c5e4b2fa6f3e8b1c4d5e6f8'),
('1471','10674','Ribbon: SIP Signaling status','27fe7c8b631943bc940d51bdd2ae3d85'),
('1472','10674','Ribbon: SIP Signaling Type','83e2c8a2821a4c5da37d2675c64d1596'),
('1473','10674','Ribbon: System status','bd7bb2d61072409ca8fa5273dc7caa7f'),
('1474','10675','Ribbon: Port link state','6925e3c1ff3c43409e744cd05b6a813c'),
('1475','10675','Ribbon: Port negotiated speed','8ea3cb267eb645168aee7d6706a65007'),
('1476','10676','Ribbon: Call engine role','4d1dd88f5c48462fa55ba7bd73476cb7'),
('1477','10676','Ribbon: System HA status','bed1403dbaf0419987856c5c33a061b6'),
('1478','10676','Ribbon: Trunk packet out detect state','1262d32d602344e49fae29f64f6c2eb7'),
('1479','10678','Edge activation state','fb5c3e8c7565458b80e55f16c3e088d7'),
('1480','10678','Edge HA status','017a5a34c8984720ae2032855255fb76'),
('1481','10678','Edge states','1ca0e7345c1b4bfd89da2009cf81a6a8'),
('1482','10678','Link states','4233328ae66d4961ab1709bd9fbaa791'),
('1483','10671','WWP-LEOS-SYSTEM-CONFIG-MIB::CpuLoadState','e4482198eb8645908b11cde87371ea03'),
('1484','10671','WWP-LEOS-SYSTEM-CONFIG-MIB::FilesystemState','190bc7b91c2649d989523cf2fadf8201'),
('1485','10672','BGP peer state','ea6e1f12288943f5890837c8cb38431e');
INSERT INTO `items` (`itemid`,`type`,`snmp_oid`,`hostid`,`name`,`key_`,`delay`,`history`,`trends`,`status`,`value_type`,`trapper_hosts`,`units`,`formula`,`logtimefmt`,`templateid`,`valuemapid`,`params`,`ipmi_sensor`,`authtype`,`username`,`password`,`publickey`,`privatekey`,`flags`,`interfaceid`,`description`,`inventory_link`,`lifetime`,`evaltype`,`jmx_endpoint`,`master_itemid`,`timeout`,`url`,`query_fields`,`posts`,`status_codes`,`follow_redirects`,`post_type`,`http_proxy`,`headers`,`retrieve_mode`,`request_method`,`output_format`,`verify_peer`,`verify_host`,`allow_traps`,`discover`,`uuid`,`lifetime_type`,`enabled_lifetime_type`,`enabled_lifetime`) VALUES ('10061','5','','10047','Number of processed numeric (float) values per second','zabbix[wcache,values,float]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of processed numeric (float) values.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','de63f78f36e74361b6c9993d12d8b7c8','0','2','0'),
('10062','5','','10047','Number of processed character values per second','zabbix[wcache,values,str]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of processed character values.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','b58fdd85cd6a48489d0b983ee8ebe97b','0','2','0'),
('10063','5','','10047','Number of processed log values per second','zabbix[wcache,values,log]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of processed log values.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','dae76dc6c4ce4707be7cf9534efc0233','0','2','0'),
('10064','5','','10047','Number of processed numeric (unsigned) values per second','zabbix[wcache,values,uint]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of processed numeric (unsigned) values.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','47132a8565c943c0abbd4918d6af9339','0','2','0'),
('10065','5','','10047','Number of processed text values per second','zabbix[wcache,values,text]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of processed text values.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','5397d6d4dedc44c29ff25b8fd5611003','0','2','0'),
('10066','5','','10047','Number of processed not supported values per second','zabbix[wcache,values,not supported]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of times the item processing resulted in an item becoming unsupported or remaining in that state.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','c99a99cf7e1e44918736ab860694d3a4','0','2','0'),
('10067','5','','10048','Number of processed numeric (float) values per second','zabbix[wcache,values,float]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of processed numeric (float) values.','0','30d','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','ba5efd0ed21d4ac39e1375788b7198de','0','2','0'),
('10068','5','','10048','Number of processed character values per second','zabbix[wcache,values,str]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of processed character values.','0','30d','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','5f0c3ed0998e499aaa1e4a30726928fc','0','2','0'),
('10069','5','','10048','Number of processed log values per second','zabbix[wcache,values,log]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of processed log values.','0','30d','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','47cdd6ef01734ec1ab15b0ab43d147ca','0','2','0'),
('10070','5','','10048','Number of processed numeric (unsigned) values per second','zabbix[wcache,values,uint]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of processed numeric (unsigned) values.','0','30d','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','8e4b9641b173415c8608ee4863bcd547','0','2','0'),
('10071','5','','10048','Number of processed text values per second','zabbix[wcache,values,text]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of processed text values.','0','30d','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','1c259b08b3ff445f9b2f24a02c07c5db','0','2','0'),
('10072','5','','10048','Number of processed not supported values per second','zabbix[wcache,values,not supported]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe number of times the item processing resulted in an item becoming unsupported or remaining in that state.','0','30d','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','46574db1d70545f6af89e8607d22f5bb','0','2','0'),
('22183','5','','10047','History write cache, % used','zabbix[wcache,history,pused]','1m','31d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache. The percentage of used history buffer.\r\nThe history cache is used to store item values. A high number indicates database performance problems.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','1ae8253bb4da434da3ea6bcb0352115d','0','2','0'),
('22185','5','','10047','Trend write cache, % used','zabbix[wcache,trend,pused]','1m','31d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache. The percentage of used trend buffer.\r\nThe trend cache stores the aggregate of all items that have received data for the current hour.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','5cca0fc9878d4e068467d5a3b8558ed5','0','2','0'),
('22187','5','','10047','Number of processed values per second','zabbix[wcache,values]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache.\r\nThe total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','db364af6bcb24881850f3979933fccb0','0','2','0'),
('22189','5','','10047','Configuration cache, % used','zabbix[rcache,buffer,pused]','1m','31d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The availability statistics of Zabbix configuration cache. The percentage of used data buffer.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','ac2aebc15b084d049538b12e9513c08d','0','2','0'),
('22191','5','','10047','Value cache, % used','zabbix[vcache,buffer,pused]','1m','31d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The availability statistics of Zabbix value cache. The percentage of used data buffer.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','559ca5966e404c948f99cabf7a9077e8','0','2','0'),
('22196','5','','10047','Value cache hits','zabbix[vcache,cache,hits]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The effectiveness statistics of Zabbix value cache. The number of cache hits (history values taken from the cache).','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','69b14487a9744dbb866f2e6ee131d0e5','0','2','0'),
('22199','5','','10047','Value cache misses','zabbix[vcache,cache,misses]','1m','31d','365d','0','0','','!vps','','',NULL,NULL,'','','0','','','','','0',NULL,'The effectiveness statistics of Zabbix value cache. The number of cache misses (history values taken from the database).','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','c78439859fd248cdb15e1eee37be2220','0','2','0'),
('22219','5','','10047','Queue over 10 minutes','zabbix[queue,10m]','1m','31d','365d','0','3','','','','',NULL,NULL,'','','0','','','','','0',NULL,'The number of monitored items in the queue that are delayed by at least 10 minutes.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','2b2f695ed1ef4a7a871c80df9c911e90','0','2','0'),
('22396','5','','10047','History index cache, % used','zabbix[wcache,index,pused]','1m','31d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The statistics and availability of Zabbix write cache. The percentage of used history index buffer.\r\nThe history index cache is used to index values stored in the history cache.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','9fc7faf5455e4e78bdb1406f947bfa08','0','2','0'),
('22399','5','','10047','Utilization of poller data collector processes, in %','zabbix[process,poller,avg,busy]','1m','31d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The average percentage of the time during which the poller processes have been busy for the last minute.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','cbec202e15be49de93dc0c5f58824ae3','0','2','0'),
('22400','5','','10047','Utilization of unreachable poller data collector processes, in %','zabbix[process,unreachable poller,avg,busy]','1m','31d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The average percentage of the time during which the unreachable poller processes have been busy for the last minute.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','4fd24bdb8935435e8617c9607b9c6ca1','0','2','0'),
('22401','5','','10047','Utilization of vmware collector data collector processes, in %','zabbix[process,vmware collector,avg,busy]','1m','31d','365d','0','0','','%','','',NULL,NULL,'','','0','','','','','0',NULL,'The average percentage of the time during which the vmware collector processes have been busy for the last minute.','0','0','0','',NULL,'','','','','200','1','0','','','0','0','0','0','0','0','0','bad00e43cd064a0fb3a4b65b71bea926','