# C2SP Code of Conduct

## Our Pledge

We as members, contributors, maintainers, and stewards pledge to make
participation in our community a harassment-free experience for everyone,
regardless of age, body size, visible or invisible disability, ethnicity, sex
characteristics, gender identity and expression, level of experience, education,
socio-economic status, nationality, personal appearance, race, religion, or
sexual identity and orientation.

We pledge to act and interact in ways that contribute to an open, welcoming,
diverse, inclusive, and healthy community.

## Our Values

- Be friendly and welcoming
  - There's no need to be mean or rude.
- Be patient
  - Remember that people have varying communication styles and that not everyone is
    using their native language. (Meaning and tone can be lost in translation.)
- Be thoughtful
  - Productive communication requires effort. Think about how your words will be
    interpreted.
  - Remember that sometimes it is best to refrain entirely from commenting.
- Be respectful
  - In particular, respect that people have differences of opinion and that
    every design or implementation choice carries a trade-off and numerous
    costs. There is seldom a right answer.
- Be charitable
  - Interpret the arguments of others in good faith, do not seek to disagree.
  - When we do disagree, try to understand why.

In our community we strive to go the extra step to look out for each other.
Don't just aim to be technically unimpeachable, try to be your best self. In
particular, avoid flirting with offensive or sensitive issues, particularly if
they're off-topic; this all too often leads to unnecessary fights, hurt
feelings, and damaged trust; worse, it can drive people away from the community
entirely.

And if someone takes issue with something you said or did, resist the urge to be
defensive. Just stop doing what it was they complained about and apologize. Even
if you feel you were misinterpreted or unfairly accused, chances are good there
was something you could've communicated better—remember that it's your
responsibility to make your fellow contributors comfortable. You will find that
people will be eager to assume good intent and forgive as long as you earn their
trust.

## Our Standards

Examples of behavior that contributes to a positive environment for our
community include:

- Demonstrating empathy and kindness toward other people
- Being respectful of differing opinions, viewpoints, and experiences
- Giving and gracefully accepting constructive feedback
- Accepting responsibility and apologizing to those affected by our mistakes,
  and learning from the experience
- Focusing on what is best not just for us as individuals, but for the
  overall community

Examples of unacceptable behavior include:

- The use of sexualized language or imagery, and sexual attention or
  advances of any kind
- Trolling, insulting or derogatory comments, and personal or political attacks
- Public or private harassment
- Publishing others' private information, such as a physical or email
  address, without their explicit permission
- Other conduct which could reasonably be considered inappropriate in a
  professional setting

## Our Responsibilities

The C2SP stewards are responsible for clarifying and enforcing our standards of
acceptable behavior and will take appropriate and fair corrective action in
response to any behavior that they deem inappropriate, threatening, offensive,
or harmful.

The C2SP stewards have the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, and will communicate reasons for moderation
decisions when appropriate.

## Scope

This Code of Conduct applies within all community spaces, and also applies when
an individual is officially representing the community in public spaces.
Examples of representing our community include using an official e-mail address,
posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of the community
may be further defined and clarified by the C2SP stewards.

This Code of Conduct also applies outside the community spaces when the C2SP
stewards have a reasonable belief that an individual's behavior may have a
negative impact on our community.

## Conflict Resolution

If you see someone violating the code of conduct, you are encouraged to address
the behavior directly with those involved. Many issues can be resolved quickly
and easily, and this gives people more control over the outcome of their
dispute. If you are unable to resolve the matter for any reason, or if the
behavior is threatening or harassing, report it. We are dedicated to providing
an environment where participants feel welcome and safe.

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported to the C2SP stewards responsible for enforcement at
`c2sp-stewards [at] jackgrigg [dot] com`. All C2SP stewards are obligated to
respect the privacy and security of the reporter of any incident.

We will investigate every complaint, but you may not receive a direct response.
We will use our discretion in determining when and how to follow up on reported
incidents, which may range from not taking action to permanent expulsion from
the project and project-sponsored spaces. We will notify the accused of the
report and provide them an opportunity to discuss it before any action is taken.
The identity of the reporter will be omitted from the details of the report
supplied to the accused. In potentially harmful situations, such as ongoing
harassment or threats to anyone’s safety, we may take action without notice.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant v2.0][CCv2.0], the
[Go Community Code of Conduct][GoCCoC], and the [Rust Code of Conduct][RustCoC].

[CCv2.0]: https://www.contributor-covenant.org/version/2/0/code_of_conduct.html
[GoCCoC]: https://golang.org/conduct
[RustCoC]: https://www.rust-lang.org/policies/code-of-conduct
