/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.charts.axis;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.lib.charts.axis.TimeMark;

public class TimeAxisUtils {
    public static final int NTHNG_NEEDED = 0;
    public static final int DAY_NEEDED = 1;
    public static final int MONTH_NEEDED = 2;
    public static final int YEAR_NEEDED = 4;
    public static final int STEP_MSEC = 1;
    public static final int STEP_SEC = 2;
    public static final int STEP_MIN = 4;
    public static final int STEP_HOUR = 8;
    public static final int STEP_DAY = 16;
    public static final int STEP_WEEK = 32;
    public static final int STEP_MONTH = 64;
    public static final int STEP_YEAR = 128;
    public static final String TIME_SEC = TimeAxisUtils.createTimeSec();
    public static final String TIME_MSEC = TimeAxisUtils.createTimeMSec(TIME_SEC);
    public static final String TIME_MIN = TimeAxisUtils.createTimeMin();
    public static final String DATE_YEAR = TimeAxisUtils.createDateYear();
    public static final String DATE_MONTH = TimeAxisUtils.createDateMonth(DATE_YEAR);
    public static final String DATE_WEEKDAY_SHORT = "EEE";
    public static final String DATE_WEEKDAY = "EEEE";
    public static final String DATE_YEARMONTH = "MMMM";
    public static final String DATE_SINGLEYEAR = "yyyy";
    public static final String TIME_DATE_FORMAT = "{0}, {1}";
    private static final String PATTERN_CHARS = "GyMwWDdFEaHkKhmsSzZ";
    private static final Map<String, Format> FORMATS = new HashMap<String, Format>();
    private static final Calendar c1 = Calendar.getInstance();
    private static final Calendar c2 = Calendar.getInstance();
    public static final long[] timeUnitsGrid = new long[]{1L, 2L, 5L, 10L, 20L, 50L, 100L, 250L, 500L, 1000L, 2000L, 5000L, 10000L, 15000L, 30000L, 60000L, 120000L, 300000L, 600000L, 900000L, 1800000L, 3600000L, 0x6DDD00L, 10800000L, 21600000L, 43200000L, 86400000L, 604800000L, 2628000000L, 5256000000L, 7884000000L, 15768000000L, 31536000000L, 63072000000L, 157680000000L, 315360000000L};

    public static long getTimeUnits(double scale, int minDistance) {
        if (Double.isNaN(scale) || scale == Double.POSITIVE_INFINITY || scale <= 0.0) {
            return -1L;
        }
        for (long l : timeUnitsGrid) {
            if (!((double)l * scale >= (double)minDistance)) continue;
            return l;
        }
        return timeUnitsGrid[timeUnitsGrid.length - 1];
    }

    public static int getStepFlag(long step) {
        if (step > 15768000000L) {
            return 128;
        }
        if (step > 1209600000L) {
            return 64;
        }
        if (step > 172800000L) {
            return 32;
        }
        if (step > 43200000L) {
            return 16;
        }
        if (step > 1800000L) {
            return 8;
        }
        if (step > 30000L) {
            return 4;
        }
        if (step > 500L) {
            return 2;
        }
        return 1;
    }

    public static int getRangeFlag(long startTime, long endTime) {
        c1.setTimeInMillis(startTime);
        c2.setTimeInMillis(endTime);
        if (c1.get(1) != c2.get(1)) {
            return 4;
        }
        if (c1.get(2) != c2.get(2)) {
            return 2;
        }
        if (c1.get(6) != c2.get(6)) {
            return 1;
        }
        return 0;
    }

    public static String getFormatString(long step, long startTime, long endTime) {
        int stepFlag = TimeAxisUtils.getStepFlag(step);
        int rangeFlag = TimeAxisUtils.getRangeFlag(startTime, endTime);
        String time = null;
        String date = null;
        if (stepFlag < 16) {
            time = stepFlag > 2 ? TIME_MIN : (stepFlag > 1 ? TIME_SEC : TIME_MSEC);
        }
        if (stepFlag > 8 || rangeFlag != 0) {
            if (stepFlag == 128) {
                date = DATE_SINGLEYEAR;
            } else if (stepFlag == 64 && rangeFlag < 4) {
                date = DATE_YEARMONTH;
            } else if (stepFlag == 16 && rangeFlag < 2) {
                date = DATE_WEEKDAY;
            } else if (rangeFlag == 4) {
                date = DATE_YEAR;
            } else if (rangeFlag == 2 || stepFlag > 16) {
                date = DATE_MONTH;
            } else if (rangeFlag == 1) {
                date = DATE_WEEKDAY_SHORT;
            }
        }
        if (time == null) {
            return date;
        }
        if (date == null) {
            return time;
        }
        return MessageFormat.format(TIME_DATE_FORMAT, time, date);
    }

    public static String formatTime(Long value, String formatString) {
        Format format = FORMATS.get(formatString);
        if (format == null) {
            format = new SimpleDateFormat(formatString);
            FORMATS.put(formatString, format);
        }
        return format.format(value);
    }

    public static String formatTime(TimeMark mark) {
        return TimeAxisUtils.formatTime(mark.getValue(), mark.getFormat());
    }

    private static String createTimeSec() {
        return ((SimpleDateFormat)DateFormat.getTimeInstance(2)).toPattern();
    }

    private static String createTimeMin() {
        return ((SimpleDateFormat)DateFormat.getTimeInstance(3)).toPattern();
    }

    private static String createTimeMSec(String timeSec) {
        return timeSec.replace("ss", "ss.SSS");
    }

    private static String createDateYear() {
        return ((SimpleDateFormat)DateFormat.getDateInstance(2)).toPattern();
    }

    private static String createDateMonth(String dateYear) {
        try {
            String dateDay = dateYear.replace("y", "");
            if (dateDay.isEmpty()) {
                return dateDay;
            }
            String firstLetter = dateDay.substring(0, 1);
            while (!dateDay.isEmpty() && !TimeAxisUtils.isPatternChar(firstLetter)) {
                dateDay = dateDay.substring(1);
                firstLetter = dateDay.substring(0, 1);
            }
            int length = dateDay.length();
            String lastLetter = dateDay.substring(length - 1, length);
            while (length > 0 && !".".equals(lastLetter) && !TimeAxisUtils.isPatternChar(lastLetter)) {
                dateDay = dateDay.substring(0, length-- - 1);
                lastLetter = dateDay.substring(length - 1, length);
            }
            return dateDay;
        }
        catch (Exception e) {
            return "MMM d";
        }
    }

    private static boolean isPatternChar(String s) {
        return PATTERN_CHARS.contains(s);
    }
}

