/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.options.general;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.beaninfo.editors.HtmlBrowser;
import org.netbeans.core.ProxySettings;
import org.netbeans.core.ui.options.general.AdvancedProxyPanel;
import org.netbeans.core.ui.options.general.GeneralOptionsModel;
import org.netbeans.core.ui.options.general.WebBrowsersOptionsModel;
import org.netbeans.core.ui.options.general.WebBrowsersOptionsPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class GeneralOptionsPanel
extends JPanel
implements ActionListener {
    private GeneralOptionsModel model;
    private HtmlBrowser.FactoryEditor editor;
    private AdvancedProxyPanel advancedPanel;
    private boolean valid = true;
    private final Icon PROXY_TEST_OK = ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/options/general/ok_16.png", (boolean)false);
    private final Icon PROXY_TEST_ERROR = ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/options/general/error_16.png", (boolean)false);
    private JButton bMoreProxy;
    private JButton bReloadProxy;
    private JButton bTestConnection;
    private JComboBox cbWebBrowser;
    private JButton editBrowserButton;
    private JLabel errorLabel;
    private JPanel jPanel1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JCheckBox jUsageCheck;
    private JLabel lProxyHost;
    private JLabel lProxyPort;
    private JLabel lUsage;
    private JLabel lWebBrowser;
    private JLabel lWebProxy;
    private JLabel lblLearnMore;
    private JLabel lblTestResult;
    private JLabel lblUsageInfo;
    private JProgressBar pbProxyWaiting;
    private JRadioButton rbHTTPProxy;
    private JRadioButton rbNoProxy;
    private JRadioButton rbUseSystemProxy;
    private JTextField tfProxyHost;
    private JTextField tfProxyPort;

    public GeneralOptionsPanel() {
        this.initComponents();
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = new Color(255, 0, 0);
        }
        this.errorLabel.setForeground(color);
        Image image = ImageUtilities.loadImage((String)"org/netbeans/core/ui/resources/error.gif");
        this.errorLabel.setIcon(new ImageIcon(image));
        this.errorLabel.setVisible(false);
        GeneralOptionsPanel.loc(this.lWebBrowser, "Web_Browser");
        GeneralOptionsPanel.loc(this.lWebProxy, "Web_Proxy");
        GeneralOptionsPanel.loc(this.lProxyHost, "Proxy_Host");
        GeneralOptionsPanel.loc(this.lProxyPort, "Proxy_Port");
        this.cbWebBrowser.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Web_Browser", new String[0]));
        this.cbWebBrowser.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Web_Browser", new String[0]));
        this.tfProxyHost.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Host", new String[0]));
        this.tfProxyHost.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Host", new String[0]));
        this.tfProxyPort.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Port", new String[0]));
        this.tfProxyPort.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Port", new String[0]));
        this.rbNoProxy.addActionListener(this);
        this.rbUseSystemProxy.addActionListener(this);
        this.rbHTTPProxy.addActionListener(this);
        this.cbWebBrowser.addActionListener(this);
        this.tfProxyHost.addActionListener(this);
        this.tfProxyPort.addActionListener(this);
        this.tfProxyPort.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                GeneralOptionsPanel.this.validatePortValue();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                GeneralOptionsPanel.this.validatePortValue();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                GeneralOptionsPanel.this.validatePortValue();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNoProxy);
        buttonGroup.add(this.rbUseSystemProxy);
        buttonGroup.add(this.rbHTTPProxy);
        GeneralOptionsPanel.loc(this.rbNoProxy, "No_Proxy");
        GeneralOptionsPanel.loc(this.rbUseSystemProxy, "Use_System_Proxy_Settings");
        GeneralOptionsPanel.loc(this.rbHTTPProxy, "Use_HTTP_Proxy");
        GeneralOptionsPanel.loc(this.lUsage, "Usage_Statistics");
        this.lUsage.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Usage_Statistics", new String[0]));
        this.lUsage.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Usage_Statistics", new String[0]));
        GeneralOptionsPanel.loc(this.jUsageCheck, "Usage_Check");
        this.jUsageCheck.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Usage_Check", new String[0]));
        this.jUsageCheck.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Usage_Check", new String[0]));
        this.lblUsageInfo.setText(GeneralOptionsPanel.loc("CTL_Usage_Info", new String[0]));
        this.lblUsageInfo.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Usage_Info", new String[0]));
        this.lblUsageInfo.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Usage_Info", new String[0]));
        this.lblLearnMore.setText(GeneralOptionsPanel.loc("CTL_Learn_More", new String[0]));
        this.lblLearnMore.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_Learn_More", new String[0]));
        this.lblLearnMore.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_Learn_More", new String[0]));
        this.pbProxyWaiting.setVisible(false);
        this.rbUseSystemProxy.setToolTipText(this.getUseSystemProxyToolTip());
        if (System.getProperty("nb.show.statistics.ui") == null) {
            this.jSeparator3.setVisible(false);
            this.lUsage.setVisible(false);
            this.jUsageCheck.setVisible(false);
            this.lblUsageInfo.setVisible(false);
            this.lblLearnMore.setVisible(false);
        }
    }

    private void initComponents() {
        this.lWebBrowser = new JLabel();
        this.cbWebBrowser = new JComboBox();
        this.jSeparator2 = new JSeparator();
        this.lWebProxy = new JLabel();
        this.rbNoProxy = new JRadioButton();
        this.rbUseSystemProxy = new JRadioButton();
        this.rbHTTPProxy = new JRadioButton();
        this.lProxyHost = new JLabel();
        this.tfProxyHost = new JTextField();
        this.lProxyPort = new JLabel();
        this.tfProxyPort = new JTextField();
        this.bMoreProxy = new JButton();
        this.editBrowserButton = new JButton();
        this.jSeparator3 = new JSeparator();
        this.errorLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.lblLearnMore = new JLabel();
        this.lblUsageInfo = new JLabel();
        this.jUsageCheck = new JCheckBox();
        this.lUsage = new JLabel();
        this.bReloadProxy = new JButton();
        this.bTestConnection = new JButton();
        this.lblTestResult = new JLabel();
        this.pbProxyWaiting = new JProgressBar();
        this.lWebBrowser.setLabelFor(this.cbWebBrowser);
        Mnemonics.setLocalizedText((JLabel)this.lWebBrowser, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.lWebBrowser.text"));
        Mnemonics.setLocalizedText((JLabel)this.lWebProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_lWebProxy"));
        Mnemonics.setLocalizedText((AbstractButton)this.rbNoProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.rbNoProxy.text"));
        this.rbNoProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.rbUseSystemProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.rbUseSystemProxy.text"));
        this.rbUseSystemProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.rbHTTPProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Use_HTTP_Proxy", (Object[])new Object[0]));
        this.rbHTTPProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lProxyHost.setLabelFor(this.tfProxyHost);
        Mnemonics.setLocalizedText((JLabel)this.lProxyHost, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Proxy_Host", (Object[])new Object[0]));
        this.tfProxyHost.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyHostFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyHostFocusLost(focusEvent);
            }
        });
        this.lProxyPort.setLabelFor(this.tfProxyPort);
        Mnemonics.setLocalizedText((JLabel)this.lProxyPort, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Proxy_Port", (Object[])new Object[0]));
        this.tfProxyPort.setColumns(4);
        this.tfProxyPort.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyPortFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                GeneralOptionsPanel.this.tfProxyPortFocusLost(focusEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bMoreProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_bMoreProxy"));
        this.bMoreProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralOptionsPanel.this.bMoreProxyActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editBrowserButton, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.editBrowserButton.text"));
        this.editBrowserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralOptionsPanel.this.editBrowserButtonActionPerformed(actionEvent);
            }
        });
        this.errorLabel.setHorizontalAlignment(4);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblLearnMore, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"CTL_Learn_More"));
        this.lblLearnMore.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                GeneralOptionsPanel.this.lblLearnMoreMouseEntered(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                GeneralOptionsPanel.this.lblLearnMoreMousePressed(mouseEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.jPanel1.add((Component)this.lblLearnMore, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblUsageInfo, (String)"<html>The usage statistics help us better understand user\nrequirements and prioritize improvements in future releases. We will never\nreverse-engineer the collected data to find specific details about your projects.</html>");
        this.lblUsageInfo.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 15, 5, 0);
        this.jPanel1.add((Component)this.lblUsageInfo, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jUsageCheck, (String)"Help us improve the NetBeans IDE by providing anonymous usage data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 15, 5, 0);
        this.jPanel1.add((Component)this.jUsageCheck, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lUsage, (String)"Usage Statistics:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.lUsage, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bReloadProxy, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.bReloadProxy.text"));
        this.bReloadProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralOptionsPanel.this.bReloadProxyActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bTestConnection, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.bTestConnection.text"));
        this.bTestConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GeneralOptionsPanel.this.bTestConnectionActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblTestResult, (String)NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.lblTestResult.text"));
        this.pbProxyWaiting.setIndeterminate(true);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.lWebBrowser).addGap(18, 18, 18).addComponent(this.cbWebBrowser, 0, 1317, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editBrowserButton)).addComponent(this.jSeparator2, -1, 1495, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.lWebProxy).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(90, 90, 90).addComponent(this.errorLabel, -1, 1313, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.rbHTTPProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lProxyHost).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfProxyHost, -1, 1055, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbNoProxy).addGroup(groupLayout.createSequentialGroup().addComponent(this.rbUseSystemProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bReloadProxy))).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lProxyPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfProxyPort, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bMoreProxy)).addGroup(groupLayout.createSequentialGroup().addComponent(this.bTestConnection).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblTestResult).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pbProxyWaiting, -2, 90, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))).addComponent(this.jSeparator3, -1, 1495, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.jPanel1, -2, 0, Short.MAX_VALUE).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lWebBrowser).addComponent(this.cbWebBrowser, -2, -1, -2).addComponent(this.editBrowserButton)).addGap(18, 18, 18).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.rbNoProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbUseSystemProxy).addComponent(this.bReloadProxy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbHTTPProxy).addComponent(this.lProxyHost).addComponent(this.tfProxyHost, -2, -1, -2).addComponent(this.lProxyPort).addComponent(this.tfProxyPort, -2, -1, -2).addComponent(this.bMoreProxy))).addComponent(this.lWebProxy)).addGap(30, 30, 30).addComponent(this.errorLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblTestResult).addComponent(this.bTestConnection).addComponent(this.pbProxyWaiting, -2, 16, -2)).addGap(11, 11, 11).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.bMoreProxy.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_bMoreProxy.AN"));
        this.bMoreProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"LBL_GeneralOptionsPanel_bMoreProxy.AD"));
        this.editBrowserButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.editBrowserButton.AN"));
        this.editBrowserButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneralOptionsPanel.class, (String)"GeneralOptionsPanel.editBrowserButton.AD"));
    }

    private void editBrowserButtonActionPerformed(ActionEvent actionEvent) {
        final WebBrowsersOptionsModel webBrowsersOptionsModel = new WebBrowsersOptionsModel();
        WebBrowsersOptionsPanel webBrowsersOptionsPanel = new WebBrowsersOptionsPanel(webBrowsersOptionsModel, this.cbWebBrowser.getSelectedItem().toString());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)webBrowsersOptionsPanel, GeneralOptionsPanel.loc("LBL_WebBrowsersPanel_Title", new String[0]), true, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DialogDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    webBrowsersOptionsModel.applyChanges();
                } else {
                    webBrowsersOptionsModel.discardChanges();
                }
            }
        });
        dialogDescriptor.setHelpCtx(new HelpCtx("WebBrowsersManager"));
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (dialogDescriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
            this.updateWebBrowsers();
            int n = this.cbWebBrowser.getItemCount();
            for (int i = 0; i < n; ++i) {
                Object e = this.cbWebBrowser.getItemAt(i);
                if (!e.equals(webBrowsersOptionsModel.getSelectedValue())) continue;
                this.cbWebBrowser.setSelectedItem(e);
                break;
            }
        }
    }

    private void bMoreProxyActionPerformed(ActionEvent actionEvent) {
        assert (this.model != null) : "Model found when AdvancedProxyPanel is created";
        if (this.advancedPanel == null) {
            this.advancedPanel = new AdvancedProxyPanel(this.model);
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.advancedPanel, GeneralOptionsPanel.loc("LBL_AdvancedProxyPanel_Title", new String[0]));
        this.advancedPanel.setDialogDescriptor(dialogDescriptor);
        dialogDescriptor.createNotificationLineSupport();
        this.advancedPanel.update(this.tfProxyHost.getText(), this.tfProxyPort.getText());
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            this.advancedPanel.applyChanges();
            this.tfProxyHost.setText(this.model.getHttpProxyHost());
            this.tfProxyPort.setText(this.model.getHttpProxyPort());
            this.isChanged();
        }
    }

    private void tfProxyPortFocusLost(FocusEvent focusEvent) {
        this.tfProxyPort.select(0, 0);
    }

    private void tfProxyHostFocusLost(FocusEvent focusEvent) {
        this.tfProxyHost.select(0, 0);
    }

    private void tfProxyPortFocusGained(FocusEvent focusEvent) {
        this.tfProxyPort.setCaretPosition(0);
        this.tfProxyPort.selectAll();
    }

    private void tfProxyHostFocusGained(FocusEvent focusEvent) {
        this.tfProxyHost.setCaretPosition(0);
        this.tfProxyHost.selectAll();
    }

    private void lblLearnMoreMouseEntered(MouseEvent mouseEvent) {
        mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void lblLearnMoreMousePressed(MouseEvent mouseEvent) {
        URL uRL = null;
        try {
            uRL = new URL(GeneralOptionsPanel.loc("METRICS_INFO_URL", new String[0]));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
        }
    }

    private void bReloadProxyActionPerformed(ActionEvent actionEvent) {
        ProxySettings.reload();
        this.rbUseSystemProxy.setToolTipText(this.getUseSystemProxyToolTip());
    }

    private void bTestConnectionActionPerformed(ActionEvent actionEvent) {
        String string;
        String string2;
        String string3;
        int n;
        if (this.rbNoProxy.isSelected()) {
            n = 0;
            string3 = null;
            string2 = null;
            string = null;
        } else if (this.rbUseSystemProxy.isSelected()) {
            n = 1;
            string3 = null;
            string2 = null;
            string = null;
        } else {
            n = 2;
            string3 = this.tfProxyHost.getText();
            string2 = this.tfProxyPort.getText();
            string = this.advancedPanel == null ? null : this.advancedPanel.getNonProxyHosts();
        }
        GeneralOptionsModel.testConnection(this, n, string3, string2, string);
    }

    private void validatePortValue() {
        this.clearError();
        boolean bl = this.valid;
        this.valid = this.isPortValid();
        if (!this.valid) {
            this.showError(GeneralOptionsPanel.loc("LBL_GeneralOptionsPanel_PortError", new String[0]));
        }
        if (bl != this.valid) {
            this.firePropertyChange("valid", bl, this.valid);
        }
    }

    private boolean isPortValid() {
        String string = this.tfProxyPort.getText();
        boolean bl = true;
        if (string != null && string.length() > 0) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    private void showError(String string) {
        this.errorLabel.setVisible(true);
        this.errorLabel.setText(string);
        this.bTestConnection.setEnabled(false);
    }

    private void clearError() {
        this.errorLabel.setText("");
        this.errorLabel.setVisible(false);
        this.bTestConnection.setEnabled(true);
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(GeneralOptionsPanel.class, (String)string, (Object[])stringArray);
    }

    private String getUseSystemProxyToolTip() {
        if (this.rbUseSystemProxy.isSelected()) {
            String string;
            String string2 = GeneralOptionsPanel.getProxyPreferences().get("systemProxyHttpHost", "");
            if (GeneralOptionsModel.usePAC()) {
                string = GeneralOptionsPanel.getPacFile();
            } else if (string2 == null || string2.trim().length() == 0) {
                string = GeneralOptionsPanel.loc("GeneralOptionsPanel_rbUseSystemProxy_Direct", new String[0]);
            } else {
                String string3 = GeneralOptionsPanel.getProxyPreferences().get("systemProxyHttpPort", "");
                string = GeneralOptionsPanel.loc("GeneralOptionsPanel_rbUseSystemProxy_Format", string2, string3);
            }
            return string;
        }
        return null;
    }

    private static void loc(Component component, String string) {
        if (!(component instanceof JLabel)) {
            component.getAccessibleContext().setAccessibleName(GeneralOptionsPanel.loc("AN_" + string, new String[0]));
            component.getAccessibleContext().setAccessibleDescription(GeneralOptionsPanel.loc("AD_" + string, new String[0]));
        }
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)GeneralOptionsPanel.loc("CTL_" + string, new String[0]));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)GeneralOptionsPanel.loc("CTL_" + string, new String[0]));
        }
    }

    void update() {
        this.model = new GeneralOptionsModel();
        switch (this.model.getProxyType()) {
            case 0: {
                this.rbNoProxy.setSelected(true);
                this.bReloadProxy.setEnabled(false);
                this.tfProxyHost.setEnabled(false);
                this.tfProxyPort.setEnabled(false);
                this.lProxyHost.setEnabled(false);
                this.lProxyPort.setEnabled(false);
                this.bMoreProxy.setEnabled(false);
                break;
            }
            case 1: {
                this.rbUseSystemProxy.setSelected(true);
                this.bReloadProxy.setEnabled(true);
                this.tfProxyHost.setEnabled(false);
                this.tfProxyPort.setEnabled(false);
                this.lProxyHost.setEnabled(false);
                this.lProxyPort.setEnabled(false);
                this.bMoreProxy.setEnabled(false);
                break;
            }
            case 2: {
                this.rbHTTPProxy.setSelected(true);
                this.bReloadProxy.setEnabled(false);
                this.tfProxyHost.setEnabled(true);
                this.tfProxyPort.setEnabled(true);
                this.lProxyHost.setEnabled(true);
                this.lProxyPort.setEnabled(true);
                this.bMoreProxy.setEnabled(true);
                break;
            }
            case 3: {
                this.rbUseSystemProxy.setSelected(true);
                this.bReloadProxy.setEnabled(true);
                this.tfProxyHost.setEnabled(false);
                this.tfProxyPort.setEnabled(false);
                this.lProxyHost.setEnabled(false);
                this.lProxyPort.setEnabled(false);
                this.bMoreProxy.setEnabled(false);
            }
        }
        this.tfProxyHost.setText(this.model.getHttpProxyHost());
        this.tfProxyPort.setText(this.model.getHttpProxyPort());
        this.rbUseSystemProxy.setToolTipText(this.getUseSystemProxyToolTip());
        this.jUsageCheck.setSelected(this.model.getUsageStatistics());
        this.updateWebBrowsers();
    }

    private void updateWebBrowsers() {
        if (this.editor == null) {
            this.editor = (HtmlBrowser.FactoryEditor)Lookup.getDefault().lookup(HtmlBrowser.FactoryEditor.class);
        }
        this.cbWebBrowser.removeAllItems();
        this.cbWebBrowser.addItem(this.editor.getAsText());
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                final String[] stringArray = GeneralOptionsPanel.this.editor.getTags();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GeneralOptionsPanel.this.cbWebBrowser.removeAllItems();
                        if (stringArray.length > 0) {
                            for (String string : stringArray) {
                                GeneralOptionsPanel.this.cbWebBrowser.addItem(string);
                            }
                            GeneralOptionsPanel.this.cbWebBrowser.setSelectedItem(GeneralOptionsPanel.this.editor.getAsText());
                            GeneralOptionsPanel.this.lWebBrowser.setVisible(true);
                            GeneralOptionsPanel.this.cbWebBrowser.setVisible(true);
                            GeneralOptionsPanel.this.editBrowserButton.setVisible(true);
                            GeneralOptionsPanel.this.jSeparator2.setVisible(true);
                        } else {
                            GeneralOptionsPanel.this.lWebBrowser.setVisible(false);
                            GeneralOptionsPanel.this.cbWebBrowser.setVisible(false);
                            GeneralOptionsPanel.this.editBrowserButton.setVisible(false);
                            GeneralOptionsPanel.this.jSeparator2.setVisible(false);
                        }
                    }
                });
            }
        });
    }

    void applyChanges() {
        if (this.model == null) {
            return;
        }
        if (this.rbNoProxy.isSelected()) {
            this.model.setProxyType(0);
        } else if (this.rbUseSystemProxy.isSelected()) {
            this.model.setProxyType(1);
        } else {
            this.model.setProxyType(2);
        }
        this.model.setHttpProxyHost(this.tfProxyHost.getText());
        this.model.setHttpProxyPort(this.tfProxyPort.getText());
        if (this.model.useProxyAllProtocols()) {
            this.model.setHttpsProxyHost(this.tfProxyHost.getText());
            this.model.setHttpsProxyPort(this.tfProxyPort.getText());
            this.model.setSocksHost(this.tfProxyHost.getText());
            this.model.setSocksPort(this.tfProxyPort.getText());
        }
        if (this.editor == null) {
            this.editor = (HtmlBrowser.FactoryEditor)Lookup.getDefault().lookup(HtmlBrowser.FactoryEditor.class);
        }
        this.editor.setAsText((String)this.cbWebBrowser.getSelectedItem());
        this.model.setUsageStatistics(this.jUsageCheck.isSelected());
    }

    void cancel() {
    }

    boolean dataValid() {
        return this.isPortValid();
    }

    boolean isChanged() {
        if (this.model == null) {
            return false;
        }
        if (this.editor == null) {
            this.editor = (HtmlBrowser.FactoryEditor)Lookup.getDefault().lookup(HtmlBrowser.FactoryEditor.class);
        }
        String string = this.editor.getAsText();
        if (this.cbWebBrowser.isVisible() && string != null && !string.equals((String)this.cbWebBrowser.getSelectedItem())) {
            return true;
        }
        int n = this.model.getProxyType();
        if (this.rbNoProxy.isSelected() && n != 0) {
            return true;
        }
        if (this.rbUseSystemProxy.isSelected() && n != 1) {
            return true;
        }
        if (this.rbHTTPProxy.isSelected() && n != 2) {
            return true;
        }
        if (!this.tfProxyHost.getText().equals(this.model.getHttpProxyHost())) {
            return true;
        }
        if (!this.tfProxyPort.getText().equals(this.model.getHttpProxyPort())) {
            return true;
        }
        return this.jUsageCheck.isSelected() != this.model.getUsageStatistics();
    }

    void updateTestConnectionStatus(final GeneralOptionsModel.TestingStatus testingStatus, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (testingStatus) {
                    case NOT_TESTED: {
                        GeneralOptionsPanel.this.lblTestResult.setText(" ");
                        GeneralOptionsPanel.this.lblTestResult.setIcon(null);
                        GeneralOptionsPanel.this.lblTestResult.setToolTipText("");
                        GeneralOptionsPanel.this.pbProxyWaiting.setVisible(false);
                        break;
                    }
                    case WAITING: {
                        GeneralOptionsPanel.this.lblTestResult.setText(" ");
                        GeneralOptionsPanel.this.lblTestResult.setIcon(null);
                        GeneralOptionsPanel.this.lblTestResult.setToolTipText("");
                        GeneralOptionsPanel.this.pbProxyWaiting.setVisible(true);
                        break;
                    }
                    case OK: {
                        GeneralOptionsPanel.this.lblTestResult.setText(" ");
                        GeneralOptionsPanel.this.lblTestResult.setIcon(GeneralOptionsPanel.this.PROXY_TEST_OK);
                        GeneralOptionsPanel.this.lblTestResult.setToolTipText(GeneralOptionsPanel.loc("GeneralOptionsPanel.proxy.result.ok", new String[0]));
                        GeneralOptionsPanel.this.pbProxyWaiting.setVisible(false);
                        break;
                    }
                    case FAILED: {
                        GeneralOptionsPanel.this.lblTestResult.setText(string);
                        GeneralOptionsPanel.this.lblTestResult.setIcon(GeneralOptionsPanel.this.PROXY_TEST_ERROR);
                        GeneralOptionsPanel.this.lblTestResult.setToolTipText(GeneralOptionsPanel.loc("GeneralOptionsPanel.proxy.result.failed", new String[]{string}));
                        GeneralOptionsPanel.this.pbProxyWaiting.setVisible(false);
                    }
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.bReloadProxy.setEnabled(this.rbUseSystemProxy.isSelected());
        this.tfProxyHost.setEnabled(this.rbHTTPProxy.isSelected());
        this.tfProxyPort.setEnabled(this.rbHTTPProxy.isSelected());
        this.lProxyHost.setEnabled(this.rbHTTPProxy.isSelected());
        this.lProxyPort.setEnabled(this.rbHTTPProxy.isSelected());
        this.bMoreProxy.setEnabled(this.rbHTTPProxy.isSelected());
        if (this.rbHTTPProxy.isSelected()) {
            this.tfProxyHost.requestFocusInWindow();
        }
        this.rbUseSystemProxy.setToolTipText(this.getUseSystemProxyToolTip());
    }

    private static String getPacFile() {
        return GeneralOptionsPanel.getProxyPreferences().get("systemPAC", "");
    }

    private static Preferences getProxyPreferences() {
        return NbPreferences.forModule(ProxySettings.class);
    }
}

