/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen;

import org.jetbrains.annotations.NotNull;

public enum TypeFamily {
    UNKNOWN,
    BOOLEAN,
    INTEGER(true),
    FLOAT(true),
    LONG(true),
    DOUBLE(true),
    OBJECT;

    private final boolean numeric;

    private TypeFamily() {
        this(false);
    }

    private TypeFamily(boolean numeric) {
        this.numeric = numeric;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public boolean isGreater(@NotNull TypeFamily other) {
        return this.ordinal() > other.ordinal();
    }

    public boolean isLesser(@NotNull TypeFamily other) {
        return this.ordinal() < other.ordinal();
    }

    public boolean isLesserOrEqual(@NotNull TypeFamily other) {
        return this.ordinal() <= other.ordinal();
    }
}

