/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class SwitchHeadExprent
extends Exprent {
    private Exprent value;
    private List<List<Exprent>> caseValues = new ArrayList<List<Exprent>>();

    public SwitchHeadExprent(Exprent value, BitSet bytecodeOffsets) {
        super(Exprent.Type.SWITCH_HEAD);
        this.value = value;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public Exprent copy() {
        SwitchHeadExprent swExpr = new SwitchHeadExprent(this.value.copy(), this.bytecode);
        ArrayList<List<Exprent>> lstCaseValues = new ArrayList<List<Exprent>>();
        for (List<Exprent> lst : this.caseValues) {
            lstCaseValues.add(new ArrayList<Exprent>(lst));
        }
        swExpr.setCaseValues(lstCaseValues);
        return swExpr;
    }

    @Override
    public VarType getExprType() {
        return this.value.getExprType();
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        result.addMinTypeExprent(this.value, VarType.VARTYPE_BYTECHAR);
        result.addMaxTypeExprent(this.value, VarType.VARTYPE_INT);
        VarType valType = this.value.getExprType();
        for (List<Exprent> lst : this.caseValues) {
            for (Exprent expr : lst) {
                VarType caseType;
                if (expr == null || (caseType = expr instanceof FunctionExprent && ((FunctionExprent)expr).getLstOperands().size() == 3 ? ((FunctionExprent)expr).getLstOperands().get(1).getExprType() : expr.getExprType()).equals(valType)) continue;
                if (valType == null) {
                    throw new IllegalStateException("Invalid switch case set: " + String.valueOf(this.caseValues) + " for selector of type " + String.valueOf(this.value.getExprType()));
                }
                VarType unboxed = VarType.UNBOXING_TYPES.get(valType);
                if (unboxed != null && unboxed.isSuperset(caseType) || (valType = VarType.getCommonSupertype(caseType, valType)) == null) continue;
                result.addMinTypeExprent(this.value, valType);
            }
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents(List<Exprent> lst) {
        lst.add(this.value);
        return lst;
    }

    @Override
    public TextBuffer toJava(int indent) {
        TextBuffer buf = this.value.toJava(indent).enclose("switch (", ")");
        buf.addStartBytecodeMapping(this.bytecode);
        return buf;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.value) {
            this.value = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwitchHeadExprent)) {
            return false;
        }
        SwitchHeadExprent sw = (SwitchHeadExprent)o;
        return InterpreterUtil.equalObjects(this.value, sw.getValue());
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        if (this.caseValues != null && !this.caseValues.isEmpty()) {
            for (List<Exprent> l : this.caseValues) {
                if (l == null || l.isEmpty()) continue;
                for (Exprent e : l) {
                    if (e == null) continue;
                    e.getBytecodeRange(values);
                }
            }
        }
        SwitchHeadExprent.measureBytecode(values, this.value);
        this.measureBytecode(values);
    }

    public Exprent getValue() {
        return this.value;
    }

    public void setValue(Exprent value) {
        this.value = value;
    }

    public void setCaseValues(List<List<Exprent>> caseValues) {
        this.caseValues = caseValues;
    }
}

