
import Component from '@glimmer/component';
import { eq } from '../../../utils/helpers.js';
import DynamicMultiSelect from './searchable-multi-select.js';
import { HdsDropdownListItemCheckbox, HdsFormTextInputField, HdsDropdownListItemGeneric, HdsDropdownListItemRadio, HdsDropdownListItemTitle } from '@hashicorp/design-system-components/components';
import { precompileTemplate } from '@ember/template-compilation';
import { setComponentTemplate } from '@ember/component';

class FilterControl extends Component {
  isCheckboxChecked = (name, value) => {
    const appliedFilter = this.args.appliedFilters[name];
    const rawValue = appliedFilter?.value?.value;
    if (!rawValue) {
      return false;
    }
    if (Array.isArray(rawValue)) {
      return rawValue.includes(value);
    }
    if (typeof rawValue === 'string') {
      return rawValue === value;
    }
    return false;
  };
  isLookbackChecked = (name, value) => {
    const appliedFilter = this.args.appliedFilters[name];
    if (!appliedFilter) {
      return false;
    } else {
      const appliedValue = `${appliedFilter.operator}${String(appliedFilter.value.value)}`;
      return appliedValue === value;
    }
  };
  getValue = name => {
    return this.args.appliedFilters?.[name]?.value?.value ?? '';
  };
  getOperator = name => {
    return this.args.appliedFilters?.[name]?.operator ?? '';
  };
  static {
    setComponentTemplate(precompileTemplate("\n    <ul class=\"filter-control__wrapper\" data-test-vault-reporting-filter-bar-control={{@filter.name}}>\n      {{#if (eq @filter.type \"lookback\")}}\n        {{#if @filter.label}}\n          <HdsDropdownListItemTitle @text={{@filter.label}} />\n        {{/if}}\n        {{#each @filter.options as |option|}}\n          <HdsDropdownListItemRadio @value={{option.value}} name={{@filter.name}} checked={{this.isLookbackChecked @filter.name option.value}}>{{option.name}}</HdsDropdownListItemRadio>\n        {{/each}}\n      {{else if (eq @filter.type \"text\")}}\n        <HdsDropdownListItemGeneric class=\"filter-bar__filters__text-filter-wrapper\">\n          <HdsFormTextInputField @type=\"text\" name={{@filter.name}} @value={{this.getValue @filter.name}} as |F|>\n            <F.Label>\n              {{@filter.label}}\n            </F.Label>\n          </HdsFormTextInputField>\n        </HdsDropdownListItemGeneric>\n      {{else if (eq @filter.type \"single-select\")}}\n        {{#if @filter.label}}\n          <HdsDropdownListItemTitle @text={{@filter.label}} />\n        {{/if}}\n        {{#each @filter.options as |option|}}\n          <HdsDropdownListItemRadio @value={{option.value}} name={{@filter.name}} checked={{eq (this.getValue @filter.name) option.value}}>{{option.name}}</HdsDropdownListItemRadio>\n        {{/each}}\n      {{else if (eq @filter.type \"multi-select\")}}\n        {{#if @filter.label}}\n          <HdsDropdownListItemTitle @text={{@filter.label}} />\n        {{/if}}\n        {{#each @filter.options as |option|}}\n          <HdsDropdownListItemCheckbox @value={{option.value}} name={{@filter.name}} checked={{this.isCheckboxChecked @filter.name option.value}}>{{option.name}}</HdsDropdownListItemCheckbox>\n\n        {{/each}}\n      {{else if (eq @filter.type \"searchable-multi-select\")}}\n        <SearchableMultiSelect @label={{@filter.label}} @name={{@filter.name}} @appliedFilters={{@appliedFilters}} @onSearch={{@filter.onSearch}} @placeholder={{@filter.placeholder}} />\n      {{else if (eq @filter.type \"boolean\")}}\n        <HdsDropdownListItemCheckbox name={{@filter.name}} checked={{this.getValue @filter.name}}>\n          {{@filter.label}}\n        </HdsDropdownListItemCheckbox>\n      {{/if}}\n    </ul>\n  ", {
      strictMode: true,
      scope: () => ({
        eq,
        HdsDropdownListItemTitle,
        HdsDropdownListItemRadio,
        HdsDropdownListItemGeneric,
        HdsFormTextInputField,
        HdsDropdownListItemCheckbox,
        SearchableMultiSelect: DynamicMultiSelect
      })
    }), this);
  }
}

export { FilterControl as default };
//# sourceMappingURL=filter-control.js.map
