/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
import type { FilterFieldName } from '../components/vault-reporting/filter-bar';
export interface Filter<T = Record<string, unknown>> {
    field: Extract<keyof FilterFieldName<T>, string>;
    operator: '>' | '<' | '=';
    value: {
        type: 'string' | 'date' | 'duration' | 'list' | 'boolean';
        value: string | number | string[] | boolean;
    };
}
type FilterMap = {
    [key: string]: string | number | Date;
};
export declare const flattenFilters: <T = FilterMap>(filters?: Filter[]) => T;
/**
 * Formats an applied filter for display.
 * @param filter The filter to format.
 * @param label An optional label to use instead of the filter's field name.
 * @returns An array of formatted filter tags.
 *
 * Handles different value types:
 * - Boolean: Displays the label if true, nothing if false.
 * - Duration: Converts hours to a human-readable format (e.g., "30 days ago").
 * - String/List: Displays each value with the appropriate operator.
 */
export declare const formatAppliedFilter: (filter: Filter, label?: string) => {
    label: string;
    field: string;
    value: string;
}[];
/**
 * Generates lookback filter options for a given array of days.
 * @param days Array of days to generate lookback options for. Defaults to [-7, -30, -60, -90].
 * @returns Array of lookback filter options with name and value properties.
 *
 * Each option's name is formatted as "X days ago" for negative values and "X days" for positive values.
 * The value is formatted as a duration string in hours (e.g., "<168h" for -7 days).
 */
export declare const getLookbackFilterOptions: (days?: number[]) => {
    name: string;
    value: string;
}[];
declare const filters: {
    flattenFilters: <T = FilterMap>(filters?: Filter[]) => T;
};
export default filters;
