/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
/**
 * Formats a Date object into a human-readable date-time string
 * @param date - The Date object to format
 * @param timeZone - The timezone to use for formatting (defaults to UTC in tests, local timezone otherwise)
 * @returns A formatted string like "Jan 15, 2025, 14:30 UTC"
 */
export declare const formatDateTime: (date: Date, timeZone?: string) => string;
/**
 * Converts a number of days to a gRPC duration string format
 * @param days - The number of days to convert
 * @returns A duration string in hours format (e.g., "72h" for 3 days)
 */
export declare const daysToGrpcDuration: (days: number) => string;
/**
 * Calculates and formats the time remaining until a future date
 * @param futureDate - A Date object or ISO string representing the target date
 * @returns A human-readable string describing time until the date (e.g., "2 days, 5 hours", "Overdue")
 */
export declare const timeUntil: (futureDate: Date | string) => string;
/**
 * Formats a duration string from seconds format to human-readable format
 * @param duration - A duration string in seconds format (e.g., "3600s") or null
 * @returns A human-readable duration string (e.g., "1 hour") or empty string if null/invalid
 */
export declare const formatDuration: (duration: string | null) => string;
declare const dateTimeUtils: {
    formatDateTime: (date: Date, timeZone?: string) => string;
    daysToGrpcDuration: (days: number) => string;
    formatDuration: (duration: string | null) => string;
    timeUntil: (futureDate: Date | string) => string;
};
export default dateTimeUtils;
