/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
import Controller from '@ember/controller';
import type { Filter } from '../../utils/filters';
export default class ReportingInventoryController extends Controller {
    queryParams: string[];
    cluster: string;
    filters: Filter[];
    pagination: {
        page_size: number;
        next_page_token?: string;
        previous_page_token?: string;
    };
    sortingOrderBy: string[];
    visibleColumns: string[];
    handleApplyFilter: (filters: Filter[]) => void;
    resetPagination: () => void;
    handlePageChange: (pagination: {
        next_page_token?: string;
        previous_page_token?: string;
        page_size: number;
    }) => void;
    handleApplySort: (orderBy: string[]) => void;
    handleColumnsChanged: (visibleColumns: string[]) => void;
    getClusterLinkParams: (cluster: string) => {
        filters: never[];
        sortingOrderBy: never[];
        pagination: {
            page_size: number;
        };
        cluster: string;
    };
}
