/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: BUSL-1.1
 */
import Component from '@glimmer/component';
import './dashboard.scss';
import type { UsageDashboardData, NamespaceData, SimpleDatum, getUsageDataFunction, getNamespaceDataFunction } from '../../../types';
import type Owner from '@ember/owner';
import type { IconName } from '@hashicorp/flight-icons/svg';
import type ReportingAnalyticsService from '../../../services/reporting-analytics';
interface CounterBlock {
    title: string;
    tooltipMessage: string;
    data: number;
    icon?: IconName;
    suffix?: string;
    link?: string;
    emptyText?: string;
    emptyLink?: string;
}
export interface SSUViewDashboardSignature {
    Args: {
        onFetchUsageData?: getUsageDataFunction;
        onFetchNamespaceData?: getNamespaceDataFunction;
        isVaultDedicated?: boolean;
    };
    Element: HTMLDivElement;
}
export default class SSUViewDashboard extends Component<SSUViewDashboardSignature> {
    readonly reportingAnalytics: ReportingAnalyticsService;
    data?: UsageDashboardData;
    namespaceData?: NamespaceData;
    lastUpdatedTime: string;
    error?: unknown;
    constructor(owner: Owner, args: SSUViewDashboardSignature['Args']);
    fetchAllData: (namespace?: string) => void;
    handleTrackAnalyticsEvent: (eventName: string, properties?: object, options?: object) => void;
    handleTrackSurveyLink: () => void;
    handleNamespaceChange: (namespace?: string) => void;
    getBarChartData: (map: Record<string, number>, exclude?: string[]) => SimpleDatum[];
    get isVaultDedicated(): boolean;
    get kvSecretsTooltipMessage(): string;
    get counters(): CounterBlock[];
    get namespace(): string;
}
export {};
