import './download-records.scss';
import Component from '@glimmer/component';
import type ReportingAnalyticsService from '../../../services/reporting-analytics';
export interface DownloadRecordsModalSignature {
    Args: {
        onClose?: () => void;
        onDownload: () => Promise<Record<string, unknown>[]>;
        csvFields: {
            key?: string;
            label: string;
        }[];
    };
    Blocks: {
        default: [];
    };
    Element: HTMLElement;
}
export default class DownloadRecordsModal extends Component<DownloadRecordsModalSignature> {
    readonly reportingAnalytics: ReportingAnalyticsService;
    format: string;
    isLoading: boolean;
    hasError: boolean;
    downloadUrl: string;
    hasData: boolean;
    get isContinueShown(): boolean;
    get downloadName(): string;
    get isCSV(): boolean;
    handleFormatChange: (e: Event) => void;
    startDownload: () => Promise<void>;
    onFileDownloaded: () => void;
    createJSONDownloadUrl: (listData: Record<string, unknown>[]) => string;
    /**
     * Converts list of data to a CSV
     * - Each cell is quoted to allow for newlines and commas in the dta
     * - Quotes within are escaped with a double quote
     * https://www.rfc-editor.org/rfc/rfc4180
     * @param {ListData} listData
     */
    createCSVDownloadUrl: (listData: Record<string, unknown>[]) => string;
}
