"use strict"
define("vault/adapters/application",["exports","@ember-data/adapter/error","@ember-data/adapter/rest","@ember/service","@ember/object","rsvp","vault/config/environment"],(function(e,t,n,i,r,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const{APP:o}=a.default,{POLLING_URLS:s,NAMESPACE_ROOT_URLS:u}=o
e.default=n.default.extend({auth:(0,i.service)(),namespaceService:(0,i.service)("namespace"),controlGroup:(0,i.service)(),flashMessages:(0,i.service)(),namespace:"v1/sys",shouldReloadAll:()=>!0,shouldReloadRecord:()=>!0,shouldBackgroundReloadRecord:()=>!1,addHeaders(e,t,n){const i=t.clientToken||this.auth.currentToken,r={}
i&&!t.unauthenticated&&(r["X-Vault-Token"]=i),t.wrapTTL&&(r["X-Vault-Wrap-TTL"]=t.wrapTTL),"PATCH"===n&&(r["Content-Type"]="application/merge-patch+json")
const l=void 0===t.namespace?this.namespaceService.path:t.namespace
l&&!u.some((t=>e.includes(t)))&&(r["X-Vault-Namespace"]=l),t.headers=Object.assign(t.headers||{},r)},_preRequest(e,t,n){this.addHeaders(e,t,n)
return s.some((t=>e.includes(t)))||this.auth.setLastFetch(Date.now()),t.timeout=6e4,t},ajax(e,t,n={}){let i=e,r=t,l=n
const a=this.controlGroup,o=a.tokenForUrl(i)
o&&(i="/v1/sys/wrapping/unwrap",r="POST",l={clientToken:o.token,data:{token:o.token}})
const s=this._preRequest(i,l,t)
return this._super(i,r,s).then(((...e)=>{o&&a.deleteControlGroupToken(o.accessor)
const[t]=e
if(t&&t.warnings&&!l.skipWarnings){const e=this.flashMessages
t.warnings.forEach((t=>{e.info(t)}))}return a.checkForControlGroup(e,t,l.wrapTTL)}))},rawRequest(e,t,n={}){const i=this._preRequest(e,n)
return fetch(e,{method:t||"GET",headers:i.headers||{},body:i.body,signal:i.signal}).then((e=>e.status>=200&&e.status<300?l.default.resolve(e):l.default.reject(e)))},handleResponse(e,n,i,l){const a=this._super(...arguments)
return a instanceof t.default&&((0,r.set)(a,"httpStatus",e),(0,r.set)(a,"path",l.url),i?.data?.error&&!i.errors&&(0,r.set)(a,"errors",[i.data.error])),a}})})),define("vault/adapters/aws-credential",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({createRecord(e,t,n){const i=n.attr("ttl"),r=n.attr("roleArn"),l=n.attr("credentialType")
let a,o="POST"
const s={}
"iam_user"===l?o="GET":(i&&(s.ttl=i),"assumed_role"===l&&r&&(s.role_arn=r),a=s.ttl||s.role_arn?{data:s}:{})
const u=n.attr("role"),c=`/v1/${u.backend}/creds/${u.name}`
return this.ajax(c,o,a).then((i=>{i.id=n.id,i.modelName=t.modelName,e.pushPayload(t.modelName,i)}))}})})),define("vault/adapters/capabilities",["exports","@ember-data/adapter/error","@ember/object","vault/adapters/application","core/utils/sanitize-path"],(function(e,t,n,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends i.default{pathForType(){return"capabilities-self"}_formatPath(e){const{relativeNamespace:t}=this.namespaceService
return t?`${t}/${(0,r.sanitizeStart)(e)}`:e}async findRecord(e,i,l){const a=[this._formatPath(l)]
return this.ajax(this.buildURL(i),"POST",{data:{paths:a},namespace:(0,r.sanitizePath)(this.namespaceService.userRootNamespace)}).catch((e=>{throw e instanceof t.default&&(0,n.set)(e,"policyPath","sys/capabilities-self"),e}))}queryRecord(e,t,n){const{id:i}=n
if(i)return this.findRecord(e,t,i).then((e=>(e.path=i,e)))}query(e,i,l){const a=l?.paths.reduce(((e,t)=>{const n=this._formatPath(t)
return n&&(e[n]=t),e}),{})
return this.ajax(this.buildURL(i),"POST",{data:{paths:Object.keys(a)},namespace:(0,r.sanitizePath)(this.namespaceService.userRootNamespace)}).then((e=>(e&&(e.pathMap=a),e))).catch((e=>{throw e instanceof t.default&&(0,n.set)(e,"policyPath","sys/capabilities-self"),e}))}}e.default=l})),define("vault/adapters/clients/activity",["exports","vault/utils/query-param-string","vault/adapters/application","@ember/debug","date-fns"],(function(e,t,n,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends n.default{formatQueryParams({start_time:e,end_time:t}){const n={}
return e&&(0,r.isValid)((0,r.parseJSON)(e))&&(n.start_time=e),t&&(0,r.isValid)((0,r.parseJSON)(t))&&(n.end_time=t),n}queryRecord(e,t,n){const i=`${this.buildURL()}/internal/counters/activity`,r={data:this.formatQueryParams(n)}
return n?.namespace&&(r.namespace=n.namespace),this.ajax(i,"GET",r).then((e=>{const t=e||{}
return t.id=t.request_id||"no-data",t}))}async exportData(e){const n=`${this.buildURL()}/internal/counters/activity/export${(0,t.default)({format:e?.format||"csv",start_time:e?.start_time??void 0,end_time:e?.end_time??void 0})}`
let i,r
try{const t=e?.namespace?{namespace:e.namespace}:{},l=await this.rawRequest(n,"GET",t)
if(200===l.status)return l.blob()
i="No data to export in provided time range.",r=l.status}catch(l){const{errors:e}=await l.json()
i=e?.join(". "),r=l.status}if(i){const e=new Error(i)
throw e.httpStatus=r,e.path="sys/internal/counters/activity/export",e}}findRecord(e,t,n){"clients/activity"!==n&&(0,i.debug)(`findRecord('clients/activity') should pass 'clients/activity' as the id, you passed: '${n}'`)
const r=`${this.buildURL()}/internal/counters/activity`
return this.ajax(r,"GET",{skipWarnings:!0})}}e.default=l})),define("vault/adapters/clients/config",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({queryRecord(){return this.ajax(this.urlForQuery(),"GET").then((e=>(e.id=e.request_id,e)))},urlForUpdateRecord(){return this.buildURL()+"/internal/counters/config"},urlForQuery(){return this.buildURL()+"/internal/counters/config"}})})),define("vault/adapters/clients/version-history",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{findAll(){return this.ajax(this.buildURL()+"/version-history","GET",{data:{list:!0}}).then((e=>e))}}e.default=n})),define("vault/adapters/cluster",["exports","@ember-data/adapter/error","@ember/service","rsvp","@ember/debug","ember-inflector","vault/adapters/application"],(function(e,t,n,i,r,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=["health","seal-status","tokens","token","seal","unseal","init","capabilities-self","license"]
e.default=a.default.extend({version:(0,n.service)(),namespaceService:(0,n.service)("namespace"),shouldBackgroundReloadRecord:()=>!0,findRecord(e,n,r,l){const a={health:this.health(),sealStatus:this.sealStatus().catch((e=>e))}
return this.version.isEnterprise&&this.namespaceService.inRootNamespace&&(a.replicationStatus=this.replicationStatus().catch((e=>e))),(0,i.hash)(a).then((({health:e,sealStatus:n,replicationStatus:a})=>{let o={id:r,name:l.attr("name")}
return o=Object.assign(o,e),n instanceof t.default==!1&&(o=Object.assign(o,{nodes:[n]})),a&&a instanceof t.default==!1?o=Object.assign(o,a.data):a instanceof t.default&&a?.errors.find((e=>"disabled path"===e))&&(o=Object.assign(o,{replication_redacted:!0})),(0,i.resolve)(o)}))},pathForType:e=>"cluster"===e?"clusters":(0,l.pluralize)(e),health(){return this.ajax(this.urlFor("health"),"GET",{data:{standbycode:200,sealedcode:200,uninitcode:200,drsecondarycode:200,performancestandbycode:200},unauthenticated:!0}).catch((()=>({has_chroot_namespace:!0})))},features(){return this.ajax(`${this.urlFor("license")}/features`,"GET",{unauthenticated:!0})},sealStatus(e=!0){return this.ajax(this.urlFor("seal-status"),"GET",{unauthenticated:e})},seal(){return this.ajax(this.urlFor("seal"),"PUT")},unseal(e){return this.ajax(this.urlFor("unseal"),"PUT",{data:e,unauthenticated:!0})},initCluster(e){return this.ajax(this.urlFor("init"),"PUT",{data:e,unauthenticated:!0})},mfaValidate({mfa_request_id:e,mfa_constraints:t}){const n={data:{mfa_request_id:e,mfa_payload:t.reduce(((e,{selectedMethod:t,passcode:n})=>{let i=[]
return n&&(i="duo"!==t.type||n.includes("passcode=")?[n]:[`passcode=${n}`]),e[t.id]=i,e}),{})}}
return this.ajax("/v1/sys/mfa/validate","POST",n)},urlFor(e){if(!o.includes(e))throw new Error(`Calls to a ${e} endpoint are not currently allowed in the vault cluster adapter`)
return`${this.buildURL()}/${e}`},urlForReplication(e,t,n){let i
return i=t?`${e}/${t}/${n}`:`${n}`,`${this.buildURL()}/replication/${i}`},replicationStatus(){return this.ajax(`${this.buildURL()}/replication/status`,"GET",{unauthenticated:!0})},replicationDrPromote(e,t){const n=t&&t.checkStatus?"GET":"PUT"
return this.ajax(`${this.buildURL()}/replication/dr/secondary/promote`,n,{data:e,unauthenticated:!0})},generateDrOperationToken(e,t){let n="POST",i=`${this.buildURL()}/replication/dr/secondary/generate-operation-token/`
return t?.cancel?(n="DELETE",i+="attempt"):t?.checkStatus?(n="GET",i+="attempt"):i+=e?.pgp_key||e?.attempt?"attempt":"update",this.ajax(i,n,{data:e,unauthenticated:!0})},replicationAction(e,t,n,i){const r="recover"===e||"reindex"===e?this.urlForReplication(t,null,e):this.urlForReplication(t,n,e)
return this.ajax(r,"POST",{data:i})}})})),define("vault/adapters/console",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",pathForType:e=>e})})),define("vault/adapters/control-group-config",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"config/control-group",urlForDeleteRecord(e,t){return this.buildURL(t)},urlForFindRecord(e,t){return this.buildURL(t)},urlForUpdateRecord(e,t){return this.buildURL(t)}})})),define("vault/adapters/control-group",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"control-group",async findRecord(e,t,n){const i=this.buildURL(t.modelName)
return this.ajax(`${i}/request`,"POST",{data:{accessor:n}}).then((e=>(e.id=n,e)))},urlForUpdateRecord(e,t){return`${this.buildURL(t)}/authorize`}})})),define("vault/adapters/database/connection",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",urlFor(e,t,n=""){if("ROTATE"===n)return`${this.buildURL()}/${e}/rotate-root/${t}`
if("RESET"===n)return`${this.buildURL()}/${e}/reset/${t}`
let i=`${this.buildURL()}/${e}/config`
return t&&(i=`${this.buildURL()}/${e}/config/${t}`),i},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,t){const{backend:n,id:i}=t
return this.ajax(this.urlFor(n,i),"GET",this.optionsForQuery(i)).then((e=>(e.backend=n,i&&(e.id=i),e)))},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)},createRecord(e,t,n){const i=e.serializerFor(t.modelName).serialize(n),r=n.attr("name"),l=n.attr("backend")
return this.ajax(this.urlFor(l,r),"POST",{data:i}).then((()=>({data:{id:r,name:r,...i}})))},updateRecord(){return this.createRecord(...arguments)},deleteRecord(e,t,n){const i=n.id,r=n.attr("backend")
return this.ajax(this.urlFor(r,i),"DELETE")},rotateRootCredentials(e,t){return this.ajax(this.urlFor(e,t,"ROTATE"),"POST")},resetConnection(e,t){return this.ajax(this.urlFor(e,t,"RESET"),"POST")}})})),define("vault/adapters/database/credential",["exports","rsvp","vault/adapters/application","vault/lib/control-group-error"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespace:"v1",_staticCreds(e,t){return this.ajax(`${this.buildURL()}/${encodeURIComponent(e)}/static-creds/${encodeURIComponent(t)}`,"GET").then((e=>({...e,roleType:"static"})))},_dynamicCreds(e,t){return this.ajax(`${this.buildURL()}/${encodeURIComponent(e)}/creds/${encodeURIComponent(t)}`,"GET").then((e=>({...e,roleType:"dynamic"})))},fetchByQuery(e,n){const{backend:r,secret:l}=n
return"static"===n.roleType?this._staticCreds(r,l):"dynamic"===n.roleType?this._dynamicCreds(r,l):(0,t.allSettled)([this._staticCreds(r,l),this._dynamicCreds(r,l)]).then((([e,t])=>{if("rejected"===e.state&&"rejected"===t.state){let n=e.reason
if(t.reason instanceof i.default)throw t.reason
throw n?.httpStatus<t.reason?.httpStatus&&(n=t.reason),n}return e.value||t.value}))},queryRecord(e,t,n){return this.fetchByQuery(e,n)},rotateRoleCredentials(e,t){return this.ajax(`${this.buildURL()}/${encodeURIComponent(e)}/rotate-role/${encodeURIComponent(t)}`,"POST")}})})),define("vault/adapters/database/role",["exports","@ember/debug","vault/lib/control-group-error","vault/adapters/application","rsvp","vault/helpers/add-to-array","vault/helpers/remove-from-array"],(function(e,t,n,i,r,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=i.default.extend({namespace:"v1",pathForType(){},urlFor(e,t,n="dynamic"){let i="roles"
"static"===n&&(i="static-roles")
let r=`${this.buildURL()}/${e}/${i}`
return t&&(r=`${this.buildURL()}/${e}/${i}/${t}`),r},staticRoles(e,t){return this.ajax(this.urlFor(e,t,"static"),"GET",this.optionsForQuery(t)).then((n=>t?{...n,type:"static",backend:e,id:t}:n))},dynamicRoles(e,t){return this.ajax(this.urlFor(e,t),"GET",this.optionsForQuery(t)).then((n=>t?{...n,type:"dynamic",backend:e,id:t}:n))},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},queryRecord(e,t,i){const{backend:l,id:a}=i
return"static"===i.type?this.staticRoles(l,a):"dynamic"===i?.type?this.dynamicRoles(l,a):(0,r.allSettled)([this.staticRoles(l,a),this.dynamicRoles(l,a)]).then((([e,t])=>{if("rejected"===e.state&&"rejected"===t.state){let i=e.reason
if(t.reason instanceof n.default)throw t.reason
throw i?.httpStatus<t.reason?.httpStatus&&(i=t.reason),i}const i=e.value?"static":"dynamic",r=e.value||t.value,o={data:{},backend:l,id:a,type:i}
return o.data={...r.data},o}))},query(e,t,n){const{backend:i}=n,l=this.staticRoles(i),a=this.dynamicRoles(i)
return(0,r.allSettled)([l,a]).then((([e,t])=>{const n={backend:i,data:{keys:[]}}
if(e.reason&&t.reason)throw t.reason
let r=[],l=[]
return e.value&&(r=e.value.data.keys),t.value&&(l=t.value.data.keys),n.data={...n.data,keys:[...r,...l],backend:i,staticRoles:r,dynamicRoles:l},n}))},async _updateAllowedRoles(e,{role:t,backend:n,db:i,type:r="add"}){const o=await e.queryRecord("database/connection",{backend:n,id:i}),s=[...o.allowed_roles||[]],u="add"===r?(0,l.addToArray)(s,t):(0,a.removeFromArray)(s,t)
return o.allowed_roles=u,o.save()},async createRecord(e,t,n){const i=e.serializerFor(t.modelName).serialize(n),r=n.attr("type"),l=n.attr("backend"),a=n.attr("name"),o=n.attr("database")
try{await this._updateAllowedRoles(e,{role:a,backend:l,db:o[0]})}catch(s){this.checkError(s)}return this.ajax(this.urlFor(l,a,r),"POST",{data:i}).then((()=>({data:{...i,...a}})))},async deleteRecord(e,t,n){const i=n.attr("type"),r=n.attr("backend"),l=n.attr("name"),a=n.attr("database")
try{await this._updateAllowedRoles(e,{role:l,backend:r,db:a[0],type:"remove"})}catch(o){this.checkError(o)}return this.ajax(this.urlFor(r,l,i),"DELETE")},async updateRecord(e,t,n){const i=e.serializerFor(t.modelName).serialize(n),r=n.attr("type"),l=n.attr("backend"),a=n.attr("name")
let o={}
return o="static"===r?{...i,username:n.attr("username")}:i,this.ajax(this.urlFor(l,a,r),"POST",{data:o}).then((()=>o))},checkError(e){if(403!==e.httpStatus)throw new Error(`Could not update allowed roles for selected database: ${e.errors.join(", ")}`)}})})),define("vault/adapters/generated-item-list",["exports","vault/adapters/application","@ember/service","core/utils/sanitize-path","vault/utils/path-encoding-helpers","@glimmer/tracking","@ember/owner"],(function(e,t,n,i,r,l,a){var o,s,u
function c(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function d(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(o=class extends t.default{constructor(...e){super(...e),c(this,"store",s,this),d(this,"namespace","v1"),c(this,"apiPath",u,this),d(this,"paths",{})}get getPath(){return this.paths.getPath||""}get createPath(){return this.paths.createPath||""}get deletePath(){return this.paths.deletePath||""}getDynamicApiPath(){const e=(0,a.getOwner)(this).lookup("route:vault.cluster.access.method").modelFor("vault.cluster.access.method")
return this.apiPath=e.apiPath,e.apiPath}async fetchByQuery(e,t,n){const{id:i}=t,r={}
n&&(r.list=!0)
const l=n?this.getDynamicApiPath(i):""
return{...await this.ajax(this.urlForItem(i,n,l),"GET",{data:r}),...{id:i,method:i}}}query(e,t,n){return this.fetchByQuery(e,n,!0)}queryRecord(e,t,n){return this.fetchByQuery(e,n)}urlForItem(e,t,n){const l=(0,i.sanitizePath)(this.getPath)
let a
e=(0,r.encodePath)(e)
let o=this.apiPath
return n&&(o=n),a=t?`${this.buildURL()}/${o}${l}/`:`${this.buildURL()}/${o}${l}/${e}`,a}urlForQueryRecord(e,t){return this.urlForItem(e,t)}urlForUpdateRecord(e){const t=this.createPath.slice(1,this.createPath.indexOf("{")-1)
return`${this.buildURL()}/${this.apiPath}${t}/${e}`}urlForCreateRecord(e,t){const n=t.record.mutableId,i=this.createPath.slice(1,this.createPath.indexOf("{")-1)
return`${this.buildURL()}/${this.apiPath}${i}/${n}`}urlForDeleteRecord(e){const t=this.deletePath.slice(1,this.deletePath.indexOf("{")-1)
return`${this.buildURL()}/${this.apiPath}${t}/${e}`}createRecord(e,t,n){return super.createRecord(...arguments).then((e=>(e?.id||n.record.id||(n.record.id=n.record.mutableId,n.id=n.record.id),e)))}},s=p(o.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"apiPath",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),o)})),define("vault/adapters/identity/base",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",pathForType:e=>e,urlForQuery(){return this._super(...arguments)+"?list=true"},query(e,t){return this.ajax(this.buildURL(t.modelName,null,null,"query"),"GET")},buildURL(e,t,n,i,r){return"createRecord"===i?this._super(...arguments):this._super(`${e}/id`,t,n,i,r)}})})),define("vault/adapters/identity/entity-alias",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/identity/entity-merge",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({buildURL(){const[,...e]=arguments
return this._super("identity/entity/merge",...e)},createRecord(e,t,n){return this._super(...arguments).then((()=>({id:n.attr("toEntityId")})))}})})),define("vault/adapters/identity/entity",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({lookup(e,t){const n=`/${this.urlPrefix()}/identity/lookup/entity`
return this.ajax(n,"POST",{data:t}).then((t=>{if(!t)return
const n="identity/entity"
return e.push(e.serializerFor(n).normalizeResponse(e,e.modelFor(n),t,t.data.id,"findRecord")),t}))}})})),define("vault/adapters/identity/group-alias",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/identity/group",["exports","vault/adapters/identity/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({lookup(e,t){const n=`/${this.urlPrefix()}/identity/lookup/group`
return this.ajax(n,"POST",{data:t}).then((t=>{if(!t)return
const n="identity/group"
return e.push(e.serializerFor(n).normalizeResponse(e,e.modelFor(n),t,t.data.id,"findRecord")),t}))}})})),define("vault/adapters/keymgmt/key",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","vault/lib/control-group-error","@ember/service"],(function(e,t,n,i,r){var l,a
function o(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function s(e,t){const n={}
return Object.keys(e).forEach((i=>{t.indexOf(i)>=0&&(n[i]=e[i])})),n}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=(l=class extends t.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="store",r=this,(i=a)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0}),o(this,"namespace","v1")}pathForType(){return"key"}buildURL(e,t,n,i,r){let l=super.buildURL(...arguments)
return n?l=l.replace("key",`${n.attr("backend")}/key`):r&&(l=l.replace("key",`${r.backend}/key`)),l}url(e,t,i){const r=`${this.buildURL()}/${e}/key`
return t?"ROTATE"===i?r+"/"+(0,n.encodePath)(t)+"/rotate":"PROVIDERS"===i?r+"/"+(0,n.encodePath)(t)+"/kms":r+"/"+(0,n.encodePath)(t):r}_updateKey(e,t,n){const i=s(n,["deletion_allowed","min_enabled_version"])
return this.ajax(this.url(e,t),"PUT",{data:i})}_createKey(e,t,n){const i=s(n,["type"])
return this.ajax(this.url(e,t),"POST",{data:i})}async createRecord(e,t,n){const i=e.serializerFor(t.modelName).serialize(n),r=n.attr("name"),l=n.attr("backend")
if(await this._createKey(l,r,i),n.attr("deletionAllowed"))try{await this._updateKey(l,r,i)}catch{throw new Error(`Key ${r} was created, but not all settings were saved`)}return{data:{...i,id:r,backend:l}}}updateRecord(e,t,n){const i=e.serializerFor(t.modelName).serialize(n),r=n.attr("name"),l=n.attr("backend")
return this._updateKey(l,r,i)}distribute(e,t,i,r){return this.ajax(`${this.buildURL()}/${e}/kms/${(0,n.encodePath)(t)}/key/${(0,n.encodePath)(i)}`,"PUT",{data:{...r}})}async getProvider(e,t){try{const n=await this.ajax(this.url(e,t,"PROVIDERS"),"GET",{data:{list:!0}})
return n.data.keys?n.data.keys[0]:null}catch(c){if(404===c.httpStatus)return null
if(403===c.httpStatus)return{permissionsError:!0}
throw c}}getDistribution(e,t,n){const r=`${this.buildURL()}/${e}/kms/${t}/key/${n}`
return this.ajax(r,"GET").then((e=>({...e.data,purposeArray:e.data.purpose.split(",")}))).catch((e=>{if(e instanceof i.default)throw e
return null}))}async queryRecord(e,t,n){const{id:i,backend:r,recordOnly:l=!1}=n,a=await this.ajax(this.url(r,i),"GET")
let o,s
return a.data.id=i,a.data.backend=r,l||(o=await this.getProvider(r,i),o&&!o.permissionsError&&(s=await this.getDistribution(r,o,i))),{...a,provider:o,distribution:s}}async query(e,t,n){const{backend:i,provider:r}=n,l=e.adapterFor("keymgmt/provider"),a=r?l.buildKeysURL(n):this.url(i)
return this.ajax(a,"GET",{data:{list:!0}}).then((e=>(e.backend=i,e)))}async rotateKey(e,t){const n=this.store.peekRecord("keymgmt/key",t),i=await this.ajax(this.url(e,t,"ROTATE"),"PUT")
return await n.reload(),i}removeFromProvider(e){const t=`${this.buildURL()}/${e.backend}/kms/${e.provider}/key/${e.name}`
return this.ajax(t,"DELETE").then((()=>{e.provider=null}))}},u=l.prototype,c="store",d=[r.service],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},m={},Object.keys(p).forEach((function(e){m[e]=p[e]})),m.enumerable=!!m.enumerable,m.configurable=!!m.configurable,("value"in m||m.initializer)&&(m.writable=!0),m=d.slice().reverse().reduce((function(e,t){return t(u,c,e)||e}),m),f&&void 0!==m.initializer&&(m.value=m.initializer?m.initializer.call(f):void 0,m.initializer=void 0),a=void 0===m.initializer?(Object.defineProperty(u,c,m),null):m,l)
var u,c,d,p,f,m})),define("vault/adapters/keymgmt/provider",["exports","vault/adapters/application","rsvp"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends t.default{constructor(...e){super(...e),i(this,"namespace","v1"),i(this,"listPayload",{data:{list:!0}})}pathForType(){return"kms"}buildURL(e,t,n,i,r){let l=super.buildURL(...arguments)
return n?l=l.replace("kms",`${n.attr("backend")}/kms`):r&&(l=l.replace("kms",`${r.backend}/kms`)),l}buildKeysURL(e){return`${this.buildURL("keymgmt/provider",null,null,"query",e)}/${e.provider}/key`}async createRecord(e,{modelName:t},n){const i=e.serializerFor(t).serialize(n),r=this.buildURL(t,n.attr("name"),n,"updateRecord")
return this.ajax(r,"PUT",{data:i}).then((()=>i))}findRecord(e,t,n){return super.findRecord(...arguments).then((e=>(e.data={...e.data,name:n},e)))}async query(e,t,i){const{backend:r}=i,l=this.buildURL(t.modelName,null,null,"query",i)
return this.ajax(l,"GET",this.listPayload).then((async l=>{const a=await(0,n.all)(l.data.keys.map((n=>this.findRecord(e,t,n,this._mockSnapshot(i.backend)))))
return l.data.keys=a.map((e=>e.data)),l.backend=r,l}))}async queryRecord(e,t,n){return this.findRecord(e,t,n.id,this._mockSnapshot(n.backend))}_mockSnapshot(e){return{attr:t=>"backend"===t?e:null}}}e.default=r})),define("vault/adapters/kmip/base",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",pathForType:e=>e.replace("kmip/",""),_url(e,t={},i){const{backend:r,scope:l,role:a}=t,o=this.pathForType(e)
let s
switch(o){case"scope":s=`${(0,n.encodePath)(r)}/scope`
break
case"role":s=`${(0,n.encodePath)(r)}/scope/${(0,n.encodePath)(l)}/role`
break
case"credential":s=`${(0,n.encodePath)(r)}/scope/${(0,n.encodePath)(l)}/role/${(0,n.encodePath)(a)}/credential`}return i&&"credential"===o?`/v1/${s}/lookup?serial_number=${(0,n.encodePath)(i)}`:i?`/v1/${s}/${(0,n.encodePath)(i)}`:`/v1/${s}`},urlForQuery(e,t){return this._url(t,e)+"?list=true"},query(e,t,n){return this.ajax(this.urlForQuery(n,t.modelName),"GET").then((e=>{const{...t}=n
return e._requestQuery=t,e}))},queryRecord(e,t,n){const i=n.id
return delete n.id,this.ajax(this._url(t.modelName,n,i),"GET").then((e=>(e.id=i,e={...e,...n})))},buildURL(e,t,n,i,r){return"createRecord"===i?this._super(...arguments):this._super(`${e}`,t,n,i,r)}})})),define("vault/adapters/kmip/ca",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({urlForFindRecord(e,t,n){const i=this.pathForType(t)
return this.buildURL(e,i,n)}})})),define("vault/adapters/kmip/config",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({_url(e,t,n){const i=this.pathForType(t)
return this.buildURL(e,i,n)},urlForFindRecord(){return this._url(...arguments)},urlForCreateRecord(e,t){const n=t.record.mutableId
return this._url(n,e,t)},urlForUpdateRecord(){return this._url(...arguments)},createRecord(e,t,n){return this._super(...arguments).then((()=>({id:n.record.mutableId})))}})})),define("vault/adapters/kmip/credential",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({createRecord(e,t,n){let i=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope,role:n.record.role})
return i=`${i}/generate`,this.ajax(i,"POST",{data:n.serialize()}).then((e=>(e.data.id=e.data.serial_number,e)))},deleteRecord(e,t,n){let i=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope,role:n.record.role})
return i=`${i}/revoke`,this.ajax(i,"POST",{data:{serial_number:n.id}})}})})),define("vault/adapters/kmip/role",["exports","vault/adapters/kmip/base","@ember/string","@ember/object","vault/utils/model-helpers/kmip-role-fields"],(function(e,t,n,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({createRecord(e,t,n){const i=n.id||n.record.role,r=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope},i),l=this.serialize(n)
return this.ajax(r,"POST",{data:l}).then((()=>({id:i,role:i,backend:n.record.backend,scope:n.record.scope})))},deleteRecord(e,t,n){const i=n.id,r=this._url(t.modelName,{backend:n.record.backend,scope:n.record.scope},i)
return this.ajax(r,"DELETE")},updateRecord(){return this.createRecord(...arguments)},serialize(e){const t=e.serialize(),l=(0,r.nonOperationFields)(e.record.editableFields).map(n.decamelize),a=(0,i.getProperties)(t,l)
for(const n in a)null==a[n]&&delete a[n]
return t.operation_all?{operation_all:!0,...a}:t.operation_none?{operation_none:!0,...a}:(delete t.operation_none,delete t.operation_all,t)}})})),define("vault/adapters/kmip/scope",["exports","vault/adapters/kmip/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({createRecord(e,t,n){const i=n.attr("name")
return this.ajax(this._url(t.modelName,{backend:n.record.backend},i),"POST").then((()=>({id:i,name:i})))},deleteRecord(e,t,n){let i=this._url(t.modelName,{backend:n.record.backend},n.id)
return i=`${i}?force=true`,this.ajax(i,"DELETE")}})})),define("vault/adapters/kubernetes/config",["exports","vault/adapters/secrets-engine-path"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),n(this,"path","config")}checkConfigVars(e){return this.ajax(`${this._getURL(e,"check")}`,"GET")}}e.default=i})),define("vault/adapters/kubernetes/role",["exports","vault/adapters/named-path","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{getURL(e,t){const i=`${this.buildURL()}/${(0,n.encodePath)(e)}/roles`
return t?`${i}/${t}`:i}urlForQuery({backend:e}){return this.getURL(e)}urlForUpdateRecord(e,t,n){return this.getURL(n.attr("backend"),e)}urlForDeleteRecord(e,t,n){return this.getURL(n.attr("backend"),e)}query(e,t,n){const{backend:i}=n
return this.ajax(this.getURL(i),"GET",{data:{list:!0}}).then((e=>e.data.keys.map((e=>({name:e,backend:i})))))}queryRecord(e,t,n){const{backend:i,name:r}=n
return this.ajax(this.getURL(i,r),"GET").then((e=>(e.data.backend=i,e.data.name=r,e.data)))}generateCredentials(e,t){const i=`${this.buildURL()}/${(0,n.encodePath)(e)}/creds/${t.role}`
return delete t.role,this.ajax(i,"POST",{data:t}).then((e=>{const{lease_id:t,lease_duration:n,data:i}=e
return{lease_id:t,lease_duration:n,...i}}))}}e.default=i}))
define("vault/adapters/ldap/config",["exports","vault/adapters/secrets-engine-path"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),n(this,"path","config")}async rotateRoot(e){return this.ajax(this._getURL(e,"rotate-root"),"POST")}}e.default=i})),define("vault/adapters/ldap/library",["exports","vault/adapters/named-path","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i="status",r="check-out",l="check-in"
class a extends t.default{_getURL(e,t){const i=`${this.buildURL()}/${(0,n.encodePath)(e)}/library`
return t?`${i}/${t}`:i}urlForUpdateRecord(e,t,n){const{backend:i,completeLibraryName:r}=n.record
return this._getURL(i,r)}urlForDeleteRecord(e,t,n){const{backend:i,completeLibraryName:r}=n.record
return this._getURL(i,r)}query(e,t,n){const{backend:i,path_to_library:r}=n,l=this._getURL(i,r)
return this.ajax(l,"GET",{data:{list:!0}}).then((e=>e.data.keys.map((e=>({name:e,backend:i,path_to_library:r}))))).catch((e=>{if(404===e.httpStatus)return[]
throw e}))}async queryRecord(e,t,n){const{backend:i,name:r}=n,l=decodeURIComponent(r),a=await this.ajax(this._getURL(i,l),"GET")
if(l.includes("/")){const e=l.lastIndexOf("/"),t=l.substring(0,e+1),n=l.substring(e+1)
return{...a.data,backend:i,name:n,path_to_library:t}}return{...a.data,backend:i,name:l}}async fetchStatus(e,t){const n=`${this._getURL(e,t)}/${i}`,r=await this.ajax(n,"GET"),l=[]
for(const i in r.data){const e={...r.data[i],account:i,library:t}
l.push(e)}return l}async checkOutAccount(e,t,n){const i=`${this._getURL(e,t)}/${r}`
return this.ajax(i,"POST",{data:{ttl:n}}).then((e=>{const{lease_id:t,lease_duration:n,renewable:i}=e,{service_account_name:r,password:l}=e.data
return{account:r,password:l,lease_id:t,lease_duration:n,renewable:i}}))}async checkInAccount(e,t,n){const i=`${this._getURL(e,t)}/${l}`
return this.ajax(i,"POST",{data:{service_account_names:n}}).then((e=>e.data))}}e.default=a})),define("vault/adapters/ldap/role",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","@ember/service","@ember-data/adapter/error","vault/helpers/add-to-array","vault/utils/sort-objects"],(function(e,t,n,i,r,l,a){var o,s
function u(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.ldapRoleID=e.default=void 0
const c=(e,t)=>`type:${e}::name:${t}`
e.ldapRoleID=c
e.default=(o=class extends t.default{constructor(...e){var t,n,i,r
super(...e),u(this,"namespace","v1"),t=this,n="flashMessages",r=this,(i=s)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}_constructRecord({backend:e,name:t,type:n}){return{id:c(n,t),backend:e,name:t,type:n}}_getURL(e,t,i){const r=`${this.buildURL()}/${(0,n.encodePath)(e)}/${t}`
return i?`${r}/${i}`:r}_pathForRoleType(e,t){return"static"===e?t?"static-cred":"static-role":t?"creds":"role"}_createOrUpdate(e,t,n){const{backend:i,name:r,type:l}=n.record,a=n.serialize()
return this.ajax(this._getURL(i,this._pathForRoleType(l),r),"POST",{data:a}).then((()=>({data:this._constructRecord({backend:i,name:r,type:l})})))}createRecord(){return this._createOrUpdate(...arguments)}updateRecord(){return this._createOrUpdate(...arguments)}urlForDeleteRecord(e,t,n){const{backend:i,type:r,completeRoleName:l}=n.record
return this._getURL(i,this._pathForRoleType(r),l)}async query(e,t,n,i,r){const{showPartialError:l,roleAncestry:a}=r.adapterOptions||{},{backend:o}=n
return a?this._querySubdirectory(o,a):this._queryAll(o,l)}async _queryAll(e,t){let n=[]
const i=[]
for(const r of["static","dynamic"]){const t=this._getURL(e,this._pathForRoleType(r))
try{const i=await this.ajax(t,"GET",{data:{list:!0}}).then((t=>t.data.keys.map((t=>this._constructRecord({backend:e,name:t,type:r})))))
n=(0,l.addManyToArray)(n,i)}catch(o){404!==o.httpStatus&&i.push(o)}}if(i.length){const e=i.reduce(((e,t)=>(t.errors.forEach((n=>{e.push(`${t.path}: ${n}`)})),e)),[])
if(2===i.length){const t=new r.default(e)
throw t.message="Error fetching roles:",t}t&&this.flashMessages.info(`Error fetching roles from ${e.join(", ")}`)}return{data:{keys:(0,a.default)(n,"name")}}}async _querySubdirectory(e,t){const{path_to_role:n,type:i}=t,r=`${this._getURL(e,this._pathForRoleType(i))}/${n}`,l=await this.ajax(r,"GET",{data:{list:!0}}).then((t=>t.data.keys.map((t=>({...this._constructRecord({backend:e,name:t,type:i}),path_to_role:n})))))
return{data:{keys:(0,a.default)(l,"name")}}}queryRecord(e,t,n){const{backend:i,name:r,type:l}=n,a=this._getURL(i,this._pathForRoleType(l),r)
return this.ajax(a,"GET").then((e=>({...e.data,...this._constructRecord({backend:i,name:r,type:l})})))}fetchCredentials(e,t,n){const i=this._getURL(e,this._pathForRoleType(t,!0),n)
return this.ajax(i,"GET").then((e=>{if("dynamic"===t){const{lease_id:n,lease_duration:i,renewable:r}=e
return{...e.data,lease_id:n,lease_duration:i,renewable:r,type:t}}return{...e.data,type:t}}))}rotateStaticPassword(e,t){const n=this._getURL(e,"rotate-role",t)
return this.ajax(n,"POST")}},d=o.prototype,p="flashMessages",f=[i.service],m={configurable:!0,enumerable:!0,writable:!0,initializer:null},b={},Object.keys(m).forEach((function(e){b[e]=m[e]})),b.enumerable=!!b.enumerable,b.configurable=!!b.configurable,("value"in b||b.initializer)&&(b.writable=!0),b=f.slice().reverse().reduce((function(e,t){return t(d,p,e)||e}),b),h&&void 0!==b.initializer&&(b.value=b.initializer?b.initializer.call(h):void 0,b.initializer=void 0),s=void 0===b.initializer?(Object.defineProperty(d,p,b),null):b,o)
var d,p,f,m,h,b})),define("vault/adapters/lease",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({revokePrefix(e){let t=this.buildURL()+"/leases/revoke-prefix/"+(0,n.encodePath)(e)
return t=t.replace(/\/$/,""),this.ajax(t,"PUT")},forceRevokePrefix(e){let t=this.buildURL()+"/leases/revoke-force/"+(0,n.encodePath)(e)
return t=t.replace(/\/$/,""),this.ajax(t,"PUT")},renew(e,t){const n=this.buildURL()+"/leases/renew"
return this.ajax(n,"PUT",{data:{lease_id:e,increment:t}})},deleteRecord(e,t,n){const i=n.id
return this.ajax(this.buildURL()+"/leases/revoke","PUT",{data:{lease_id:i}})},queryRecord(e,t,n){const{lease_id:i}=n
return this.ajax(this.buildURL()+"/leases/lookup","PUT",{data:{lease_id:i}})},query(e,t,i){const r=i.prefix||""
return this.ajax(this.buildURL()+"/leases/lookup/"+(0,n.encodePath)(r),"GET",{data:{list:!0}}).then((e=>(r&&(e.prefix=r),e)))}})})),define("vault/adapters/license",["exports","vault/adapters/cluster"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"license/status"})})),define("vault/adapters/mfa-login-enforcement",["exports","vault/adapters/application"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),n(this,"namespace","v1")}pathForType(){return"identity/mfa/login-enforcement"}_saveRecord(e,{modelName:t},n){const i=e.serializerFor(t).serialize(n)
return this.ajax(this.urlForUpdateRecord(n.attr("name"),t,n),"POST",{data:i}).then((()=>i))}createRecord(){return this._saveRecord(...arguments)}updateRecord(){return this._saveRecord(...arguments)}query(e,t,n){const i=this.urlForQuery(n,t.modelName)
return this.ajax(i,"GET",{data:{list:!0}})}}e.default=i})),define("vault/adapters/mfa-method",["exports","vault/adapters/application"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),n(this,"namespace","v1")}pathForType(){return"identity/mfa/method"}createOrUpdate(e,t,n){const i=e.serializerFor(t.modelName).serialize(n),{id:r}=n
return this.ajax(this.buildURL(t.modelName,r,n,"POST"),"POST",{data:i}).then((e=>({data:{...i,id:e?.data?.method_id||r}})))}createRecord(){return this.createOrUpdate(...arguments)}updateRecord(){return this.createOrUpdate(...arguments)}urlForDeleteRecord(e,t,n){return this.buildURL(t,e,n,"POST")}query(e,t,n){const i=this.urlForQuery(n,t.modelName)
return this.ajax(i,"GET",{data:{list:!0}})}buildURL(e,t,n,i){if("POST"===i){const i=`${super.buildURL(e)}/${n.attr("type")}`
return t?`${i}/${t}`:i}return super.buildURL(...arguments)}}e.default=i})),define("vault/adapters/mfa-setup",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{currentTokenGenerate(e){return this.ajax("/v1/identity/mfa/method/totp/generate","POST",{data:e})}adminDestroy(e){return this.ajax("/v1/identity/mfa/method/totp/admin-destroy","POST",{data:e})}}e.default=n})),define("vault/adapters/named-path",["exports","vault/adapters/application","@ember/debug"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends t.default{constructor(...e){super(...e),i(this,"namespace","v1"),i(this,"saveMethod","POST")}_saveRecord(e,{modelName:t},n){const i=e.serializerFor(t).serialize(n),r=e.serializerFor(t).primaryKey
return this.ajax(this.urlForUpdateRecord(n.attr("name"),t,n),this.saveMethod,{data:i}).then((()=>(i[r]=n.attr(r),i)))}createRecord(){const[e,{modelName:t},n]=arguments,i=n.attr("name")
if(null!==e.peekRecord({type:t,id:i}))throw new Error(`A record already exists with the name: ${i}`)
return this._saveRecord(...arguments)}updateRecord(){return this._saveRecord(...arguments)}findRecord(e,t,n){return super.findRecord(...arguments).then((e=>(e.data.name||(e.data.name=n),e)))}async query(e,t,n){const i=this.urlForQuery(n,t.modelName),{paramKey:r,filterFor:l,allowed_client_id:a}=n,o={list:!0,...a&&{allowed_client_id:a}},s=await this.ajax(i,"GET",{data:o})
if(s.data.key_info&&l&&r&&!l.includes("*")){const e=this.filterListResponse(r,l,s.data.key_info)
return{...s,data:e}}return s}filterListResponse(e,t,n){const i=Object.entries(n).filter((n=>{const i=n[1]
return t.includes(i[e])})),r=Object.fromEntries(i)
return{keys:Object.keys(r),key_info:r}}}e.default=r})),define("vault/adapters/namespace",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"namespaces"}urlForFindAll(e,t){return t.adapterOptions&&t.adapterOptions.forUser?`/${this.urlPrefix()}/internal/ui/namespaces`:`/${this.urlPrefix()}/namespaces?list=true`}urlForCreateRecord(e,t){const n=t.attr("path")
return this.buildURL(e,n)}createRecord(e,t,n){const i=n.attr("path")
return super.createRecord(...arguments).then((()=>({id:i})))}findAll(e,t,n,i){return i.adapterOptions&&void 0!==i.adapterOptions.namespace?this.ajax(this.urlForFindAll("namespace",i),"GET",{namespace:i.adapterOptions.namespace}):super.findAll(...arguments)}query(){return this.ajax(`/${this.urlPrefix()}/namespaces?list=true`)}}e.default=n})),define("vault/adapters/node",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/oidc/assignment",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/assignment"}}e.default=n})),define("vault/adapters/oidc/client",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/client"}}e.default=n})),define("vault/adapters/oidc/key",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/key"}rotate(e,t){const n=t?{verification_ttl:t}:{}
return this.ajax(`${this.urlForUpdateRecord(e,"oidc/key")}/rotate`,"POST",{data:n})}}e.default=n})),define("vault/adapters/oidc/provider",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/provider"}}e.default=n})),define("vault/adapters/oidc/scope",["exports","vault/adapters/named-path"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{pathForType(){return"identity/oidc/scope"}}e.default=n})),define("vault/adapters/path-filter-config",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({url(e){return`${this.buildURL()}/replication/performance/primary/paths-filter/${e}`},findRecord(e,t,n){return this.ajax(this.url(n),"GET").then((e=>(e.id=n,e)))},createRecord(e,t,n){return this.ajax(this.url(n.id),"PUT",{data:this.serialize(n)})},updateRecord(){return this.createRecord(...arguments)},deleteRecord(e,t,n){return this.ajax(this.url(n.id),"DELETE")}})})),define("vault/adapters/permissions",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({query(){const e=this.namespaceService.userRootNamespace??this.namespaceService.path
return this.ajax(this.urlForQuery(),"GET",{namespace:e})},urlForQuery(){return this.buildURL()+"/internal/ui/resultant-acl"}})})),define("vault/adapters/pki/action",["exports","@ember/debug","vault/utils/path-encoding-helpers","vault/adapters/application"],(function(e,t,n,i){function r(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends i.default{constructor(...e){super(...e),r(this,"namespace","v1")}urlForCreateRecord(e,t){const{type:i}=t.record,{actionType:r,useIssuer:l,issuerRef:a,mount:o}=t.adapterOptions,s=o||t.record.backend
if(!s||!r)throw new Error("URL for create record is missing required attributes")
const u=`${this.buildURL()}/${(0,n.encodePath)(s)}`
switch(r){case"import":return l?`${u}/issuers/import/bundle`:`${u}/config/ca`
case"generate-root":return l?`${u}/issuers/generate/root/${i}`:`${u}/root/generate/${i}`
case"generate-csr":return l?`${u}/issuers/generate/intermediate/${i}`:`${u}/intermediate/generate/${i}`
case"sign-intermediate":return`${u}/issuer/${(0,n.encodePath)(a)}/sign-intermediate`
case"rotate-root":return`${u}/root/rotate/${i}`}}createRecord(e,t,n){const i=e.serializerFor(t.modelName),r=this.urlForCreateRecord(t.modelName,n),l=i.serialize(n,n.adapterOptions.actionType)
return this.ajax(r,"POST",{data:l}).then((e=>({id:e.request_id,...e})))}}e.default=l})),define("vault/adapters/pki/certificate/base",["exports","vault/utils/path-encoding-helpers","vault/adapters/application"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends n.default{constructor(...e){super(...e),i(this,"namespace","v1")}getURL(e,n){const i=`${this.buildURL()}/${(0,t.encodePath)(e)}`
return n?`${i}/cert/${n}`:`${i}/certs`}fetchByQuery(e){const{backend:t,id:n}=e,i=n?{}:{list:!0}
return this.ajax(this.getURL(t,n),"GET",{data:i}).then((e=>(e.data.backend=t,n&&(e.data.id=n,e.data.serial_number=n),e)))}query(e,t,n){return this.fetchByQuery(n)}queryRecord(e,t,n){return this.fetchByQuery(n)}updateRecord(e,n,i){const{backend:r,serialNumber:l,certificate:a}=i.record,o=l?{serial_number:l}:{certificate:a}
return this.ajax(`${this.buildURL()}/${(0,t.encodePath)(r)}/revoke`,"POST",{data:o}).then((e=>({data:{...this.serialize(i),...e.data}})))}}e.default=r})),define("vault/adapters/pki/certificate/generate",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/certificate/base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends n.default{urlForCreateRecord(e,n){const{role:i,backend:r}=n.record
if(!i||!r)throw new Error("URL for create record is missing required attributes")
return`${this.buildURL()}/${(0,t.encodePath)(r)}/issue/${(0,t.encodePath)(i)}`}}e.default=i})),define("vault/adapters/pki/certificate/sign",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/certificate/base"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends n.default{urlForCreateRecord(e,n){const{role:i,backend:r}=n.record
if(!i||!r)throw new Error("URL for create record is missing required attributes")
return`${this.buildURL()}/${(0,t.encodePath)(r)}/sign/${(0,t.encodePath)(i)}`}}e.default=i})),define("vault/adapters/pki/config/acme",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends n.default{constructor(...e){super(...e),i(this,"namespace","v1")}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/acme`}}e.default=r})),define("vault/adapters/pki/config/base",["exports","vault/adapters/application"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),n(this,"namespace","v1")}findRecord(e,t,n){return this.ajax(this._url(n),"GET").then((e=>e.data))}updateRecord(e,t,n){const i=n.serialize()
return this.ajax(this._url(n.record.id),"POST",{data:i})}}e.default=i})),define("vault/adapters/pki/config/cluster",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends n.default{constructor(...e){super(...e),i(this,"namespace","v1")}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/cluster`}}e.default=r})),define("vault/adapters/pki/config/crl",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends n.default{constructor(...e){super(...e),i(this,"namespace","v1")}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/crl`}}e.default=r})),define("vault/adapters/pki/config/urls",["exports","vault/utils/path-encoding-helpers","vault/adapters/pki/config/base"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends n.default{constructor(...e){super(...e),i(this,"namespace","v1")}_url(e){return`${this.buildURL()}/${(0,t.encodePath)(e)}/config/urls`}}e.default=r})),define("vault/adapters/pki/issuer",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","rsvp","vault/utils/parse-pki-cert"],(function(e,t,n,i,r){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends t.default{constructor(...e){super(...e),l(this,"namespace","v1")}_getBackend(e){const{record:t,adapterOptions:n}=e
return n?.mount||t.backend}optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}}urlForQuery(e,t){const i=`${this.buildURL()}/${(0,n.encodePath)(e)}`
return t?`${i}/issuer/${(0,n.encodePath)(t)}`:`${i}/issuers`}async getIssuerMetadata(e,t,n,i,l){const a=i.data.key_info[l]
try{const i=await this.queryRecord(e,t,{id:l,backend:n.backend}),{data:o}=i,s=await(0,r.verifyCertificates)(o.certificate,o.certificate),u=(0,r.parseCertificate)(o.certificate)
return{...a,...o,isRoot:s,parsedCertificate:{common_name:u.common_name}}}catch(o){return{...a,issuer_id:l}}}updateRecord(e,t,n){const{issuerId:i}=n.record,r=this._getBackend(n),l=this.serialize(n),a=this.urlForQuery(r,i)
return this.ajax(a,"POST",{data:l})}query(e,t,n){const{backend:r,isListView:l}=n,a=this.urlForQuery(r)
return this.ajax(a,"GET",this.optionsForQuery()).then((async r=>{if(l&&r.data.keys.length<=10){const l=await(0,i.all)(r.data.keys.map((i=>this.getIssuerMetadata(e,t,n,r,i)))),a={}
return r.data.keys.forEach((e=>{a[e]=l.find((t=>t.issuer_id===e))})),r.data.key_info=a,r}return r}))}queryRecord(e,t,n){const{backend:i,id:r}=n
return this.ajax(this.urlForQuery(i,r),"GET",this.optionsForQuery(r))}deleteAllIssuers(e){const t=`${this.buildURL()}/${(0,n.encodePath)(e)}/root`
return this.ajax(t,"DELETE")}}e.default=a})),define("vault/adapters/pki/key",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends t.default{constructor(...e){super(...e),i(this,"namespace","v1")}_baseUrl(e,t){const i=`${this.buildURL()}/${(0,n.encodePath)(e)}`
return t?i+"/key/"+(0,n.encodePath)(t):i+"/keys"}createRecord(e,t,n){const{record:i,adapterOptions:r}=n
let l=this._baseUrl(i.backend)
return l=r.import?`${l}/import`:`${l}/generate/${i.type}`,this.ajax(l,"POST",{data:this.serialize(n)}).then((e=>e))}updateRecord(e,t,n){const{record:i}=n,{key_name:r}=this.serialize(n),l=this._baseUrl(i.backend,i.id)
return this.ajax(l,"POST",{data:{key_name:r}})}query(e,t,n){const{backend:i}=n
return this.ajax(this._baseUrl(i),"GET",{data:{list:!0}})}queryRecord(e,t,n){const{backend:i,id:r}=n
return this.ajax(this._baseUrl(i,r),"GET")}deleteRecord(e,t,n){const{id:i,record:r}=n
return this.ajax(this._baseUrl(r.backend,i),"DELETE")}}e.default=r})),define("vault/adapters/pki/role",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends t.default{constructor(...e){super(...e),i(this,"namespace","v1")}_urlForRole(e,t){let i=`${this.buildURL()}/${(0,n.encodePath)(e)}/roles`
return t&&(i=i+"/"+(0,n.encodePath)(t)),i}_optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}}createRecord(e,t,n){const i=n.attr("name"),r=this._urlForRole(n.record.backend,i)
return this.ajax(r,"POST",{data:this.serialize(n)}).then((()=>({id:i,name:i,backend:n.record.backend})))}updateRecord(e,t,n){const{name:i,backend:r}=n.record,l=this.serialize(n),a=this._urlForRole(r,i)
return this.ajax(a,"POST",{data:l})}fetchByQuery(e,t){const{id:n,backend:i}=t
return this.ajax(this._urlForRole(i,n),"GET",this._optionsForQuery(n)).then((e=>({...e,...{id:n,name:n,backend:i}})))}query(e,t,n){return this.fetchByQuery(e,n)}queryRecord(e,t,n){return this.fetchByQuery(e,n)}deleteRecord(e,t,n){const{id:i,record:r}=n
return this.ajax(this._urlForRole(r.backend,i),"DELETE")}}e.default=r}))
define("vault/adapters/pki/sign-intermediate",["exports","vault/utils/path-encoding-helpers","vault/adapters/application"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends n.default{constructor(...e){super(...e),i(this,"namespace","v1")}createRecord(e,n,i){const r=e.serializerFor(n.modelName),{backend:l,issuerRef:a}=i.record,o=`${this.buildURL()}/${(0,t.encodePath)(l)}/issuer/${(0,t.encodePath)(a)}/sign-intermediate`,s=r.serialize(i,n)
return this.ajax(o,"POST",{data:s}).then((e=>({id:e.request_id,...e})))}}e.default=r})),define("vault/adapters/pki/tidy",["exports","vault/adapters/application","core/utils/timestamp","vault/utils/path-encoding-helpers"],(function(e,t,n,i){function r(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),r(this,"namespace","v1")}_baseUrl(e){return`${this.buildURL()}/${(0,i.encodePath)(e)}`}createRecord(e,t,i){const{backend:r}=i.record,{tidyType:l}=i.adapterOptions
if("auto"===l)throw new Error("Auto tidy type models are never new, please use findRecord")
const a=`${r}-${n.default.now().toISOString()}`,o=`${this._baseUrl(r)}/tidy`
return this.ajax(o,"POST",{data:this.serialize(i,l)}).then((e=>(e.id=a,e)))}updateRecord(e,t,n){const i=n.record.id,{tidyType:r}=n.adapterOptions
if("manual"===r)throw new Error("Manual tidy type models are always new, please use createRecord")
const l=`${this._baseUrl(i)}/config/auto-tidy`
return this.ajax(l,"POST",{data:this.serialize(n,r)})}findRecord(e,t,n){return this.ajax(`${this._baseUrl(n)}/config/auto-tidy`,"GET").then((e=>e.data))}cancelTidy(e){const t=`${this._baseUrl(e)}`
return this.ajax(`${t}/tidy-cancel`,"POST")}}e.default=l})),define("vault/adapters/policy",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1/sys",pathForType:e=>e.replace("policy","policies"),createOrUpdate(e,t,n){const i=e.serializerFor("policy").serialize(n),r=n.attr("name")
return this.ajax(this.buildURL(t.modelName,r),"PUT",{data:i}).then((()=>({data:{...this.serialize(n),id:r}})))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments)},query(e,t){return this.ajax(this.buildURL(t.modelName),"GET",{data:{list:!0}})}})})),define("vault/adapters/policy/acl",["exports","vault/adapters/policy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/policy/egp",["exports","vault/adapters/policy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/policy/rgp",["exports","vault/adapters/policy"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend()})),define("vault/adapters/raft-join",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({urlForCreateRecord:()=>"/v1/sys/storage/raft/join"})})),define("vault/adapters/replication-mode",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({getStatusUrl(e){return this.buildURL()+`/replication/${e}/status`},fetchStatus(e){const t=this.getStatusUrl(e)
return this.ajax(t,"GET",{unauthenticated:!0}).then((e=>e.data))}})})),define("vault/adapters/role-aws",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",createOrUpdate(e,t,n,i){const{name:r,backend:l}=n.record,a=e.serializerFor(t.modelName).serialize(n,i),o=this.urlForRole(l,r)
return this.ajax(o,"POST",{data:a}).then((e=>{const t=e||{data:{}}
return t.data.name=r,t.data.backend=r,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:i}=n
return this.ajax(this.urlForRole(n.record.backend,i),"DELETE")},pathForType:()=>"roles",urlForRole(e,t){let i=`${this.buildURL()}/${(0,n.encodePath)(e)}/roles`
return t&&(i=i+"/"+(0,n.encodePath)(t)),i},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,t){const{id:n,backend:i}=t
return this.ajax(this.urlForRole(i,n),"GET",this.optionsForQuery(n)).then((e=>({...e,...{id:n,name:n,backend:i}})))},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)}})})),define("vault/adapters/role-ssh",["exports","rsvp","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespace:"v1",createOrUpdate(e,t,n,i){const{name:r,backend:l}=n.record,a=e.serializerFor(t.modelName).serialize(n,i),o=this.urlForRole(l,r)
return this.ajax(o,"POST",{data:a}).then((e=>{const t=e||{data:{}}
return t.data.name=r,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:i}=n
return this.ajax(this.urlForRole(n.record.backend,i),"DELETE")},pathForType:()=>"roles",urlForRole(e,t){let n=`${this.buildURL()}/${(0,i.encodePath)(e)}/roles`
return t&&(n=n+"/"+(0,i.encodePath)(t)),n},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,n){const{id:i,backend:r}=n
let l=(0,t.resolve)()
const a=this.ajax(this.urlForRole(r,i),"GET",this.optionsForQuery(i))
return i||(l=this.findAllZeroAddress(e,n)),(0,t.allSettled)([a,l]).then((e=>{if(!e[0].value)throw e[0].reason
const t={id:i,name:i,backend:r,data:{}}
return e.forEach((e=>{e.value&&(e.value.data.roles?t.data={...t.data,zero_address_roles:e.value.data.roles}:t.data={...t.data,...e.value.data})})),t}))},findAllZeroAddress(e,t){const{backend:n}=t,r=`/v1/${(0,i.encodePath)(n)}/config/zeroaddress`
return this.ajax(r,"GET")},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)}})})),define("vault/adapters/secret-engine",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","vault/helpers/split-object"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({url(e){const t=`${this.buildURL()}/mounts`
return e?t+"/"+(0,n.encodePath)(e):t},urlForConfig:e=>`/v1/${e}/config`,internalURL(e){let t=`/${this.urlPrefix()}/internal/ui/mounts`
return e&&(t=`${t}/${(0,n.encodePath)(e)}`),t},pathForType:()=>"mounts",async query(e,t,n){let i,r
try{i=await this.ajax(this.internalURL(n.path),"GET"),"kv"===i?.data?.type&&"2"===i?.data?.options?.version&&(r=await this.ajax(this.urlForConfig(n.path),"GET"),i.data={...i.data,...r.data})}catch(l){if(!n.path||!i)throw l}return i},async createRecord(e,t,n){let r=e.serializerFor(t.modelName).serialize(n)
const l=n.attr("path")
if(r.config.id=l,"kv"===r.type&&2===r.options.version){const e=(0,i.splitObject)(r,["max_versions","delete_version_after","cas_required"])
let t;[t,r]=e,r.id||(r.id=l),await this.ajax(this.url(l),"POST",{data:r})
try{await this.ajax(this.urlForConfig(l),"POST",{data:t})}catch(a){}return{data:{...r,path:l+"/",id:l}}}return this.ajax(this.url(l),"POST",{data:r}).then((()=>({data:{...r,path:l+"/",id:l}})))},updateRecord(e,t,i){const{apiPath:r,options:l,adapterMethod:a}=i.adapterOptions
if(a)return this[a](...arguments)
if(r){const a=e.serializerFor(t.modelName).serialize(i),o=(0,n.encodePath)(i.id)
return this.ajax(`/v1/${o}/${r}`,l.isDelete?"DELETE":"POST",{data:a})}},saveZeroAddressConfig(e,t,i){const r=(0,n.encodePath)(i.id),l=e.peekAll("role-ssh").filter((e=>e.zeroAddress)).map((e=>e.id)).join(","),a=`/v1/${r}/config/zeroaddress`,o={roles:l}
return""===l?this.ajax(a,"DELETE"):this.ajax(a,"POST",{data:o})}})})),define("vault/adapters/secret",["exports","@ember/utils","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespace:"v1",createOrUpdate(e,t,n){const i=e.serializerFor(t.modelName).serialize(n),{id:r}=n,l=n.record.path
return this.ajax(this.urlForSecret(n.attr("backend"),l||r),"POST",{data:i}).then((()=>(i.id=l||r,i)))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments)},deleteRecord(e,t,n){const{id:i}=n
return this.ajax(this.urlForSecret(n.attr("backend"),i),"DELETE")},urlForSecret(e,n){let r=`${this.buildURL()}/${(0,i.encodePath)(e)}/`
return(0,t.isEmpty)(n)||(r+=(0,i.encodePath)(n)),r},pathForType:()=>"mounts",optionsForQuery(e,t,n){const i={}
return"query"===t&&(i.list=!0),n?{data:i,wrapTTL:n}:{data:i}},fetchByQuery(e,t){const{id:n,backend:i,wrapTTL:r}=e
return this.ajax(this.urlForSecret(i,n),"GET",this.optionsForQuery(n,t,r)).then((e=>(r||(e.id=n,e.backend=i),e)))},query(e,t,n){return this.fetchByQuery(n,"query")},queryRecord(e,t,n){return this.fetchByQuery(n,"queryRecord")}})})),define("vault/adapters/secrets-engine-path",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends t.default{constructor(...e){super(...e),i(this,"namespace","v1")}_getURL(e,t){return`${this.buildURL()}/${(0,n.encodePath)(e)}/${t||this.path}`}urlForUpdateRecord(e,t,n){return this._getURL(n.attr("backend"))}urlForDeleteRecord(e){return this._getURL(e)}queryRecord(e,t,n){const{backend:i}=n
return this.ajax(this._getURL(i),"GET").then((e=>(e.backend=i,e)))}createRecord(){return this._saveRecord(...arguments)}updateRecord(){return this._saveRecord(...arguments)}_saveRecord(e,{modelName:t},n){const i=e.serializerFor(t).serialize(n),r=e.serializerFor(t).primaryKey,l=this._getURL(n.attr("backend"))
return this.ajax(l,"POST",{data:i}).then((()=>(i[r]=n.attr(r),i)))}}e.default=r})),define("vault/adapters/server",["exports","vault/adapters/application"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const n="/v1/sys/storage/raft/configuration"
e.default=t.default.extend({urlForFindAll:()=>n,urlForQuery:()=>n,urlForDeleteRecord:()=>"/v1/sys/storage/raft/remove-peer",deleteRecord(e,t,n){const i=n.attr("nodeId")
return this.ajax("/v1/sys/storage/raft/remove-peer","POST",{data:{server_id:i}})}})})),define("vault/adapters/ssh-otp-credential",["exports","vault/adapters/ssh"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({url:e=>`/v1/${e.backend}/creds/${e.name}`})})),define("vault/adapters/ssh-sign",["exports","vault/adapters/ssh"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({url:e=>`/v1/${e.backend}/sign/${e.name}`})})),define("vault/adapters/ssh",["exports","@ember/debug","vault/adapters/application"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespace:"v1",url(){},createRecord(e,t,n,i){const r=e.serializerFor(t.modelName).serialize(n,i),l=n.attr("role")
return this.ajax(this.url(l),"POST",{data:r}).then((i=>{i.id=n.id,i.modelName=t.modelName,e.pushPayload(t.modelName,i)}))}})})),define("vault/adapters/sync/association",["exports","vault/adapters/application","@ember/debug","rsvp"],(function(e,t,n,i){function r(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),r(this,"namespace","v1/sys/sync")}buildURL(e,t,n,i,r={}){const{destinationType:l,destinationName:a}=n?n.attributes():r
if(!l||!a)return`${super.buildURL()}/associations`
const{action:o}=n?.adapterOptions||{},s=o?`/${o}`:""
return`${super.buildURL()}/destinations/${l}/${a}/associations${s}`}query(e,{modelName:t},n){const i=this.buildURL(t,null,null,"query",n)
return this.ajax(i,"GET")}queryAll(){const e=`${this.buildURL("sync/association")}`
return this.ajax(e,"GET",{data:{list:!0}}).then((e=>{const{total_associations:t,total_secrets:n}=e.data
return{total_associations:t,total_secrets:n}}))}async fetchByDestinations(e){const t=e.map((({name:e,type:t})=>this.query(this.store,{modelName:"sync/association"},{destinationName:e,destinationType:t}))),n=await(0,i.all)(t),r=this.store.serializerFor("sync/association")
return n.map((e=>r.normalizeFetchByDestinations(e)))}fetchSyncStatus({mount:e,secretName:t}){const n=`${this.buildURL()}/destinations`
return this.ajax(n,"GET",{data:{mount:e,secret_name:t}}).then((e=>{const{associated_destinations:t}=e.data,n=[]
for(const i in t){const e=t[i]
n.push({destinationType:e.type,destinationName:e.name,syncStatus:e.sync_status,updatedAt:e.updated_at})}return n}))}_setOrRemove(e,{modelName:t},n){const i=this.buildURL(t,null,n),r=n.serialize(),l=e.serializerFor("sync/association")
return this.ajax(i,"POST",{data:r}).then((e=>{const t=Object.values(e.data.associated_secrets).find((e=>e.mount===r.mount&&e.secret_name===r.secret_name)),n=t?l.generateId(t):void 0
return{...t,id:n,destinationName:e.data.store_name,destinationType:e.data.store_type}}))}createRecord(){return this._setOrRemove(...arguments)}updateRecord(){return this._setOrRemove(...arguments)}}e.default=l})),define("vault/adapters/sync/destination",["exports","vault/adapters/application","ember-inflector"],(function(e,t,n){function i(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class r extends t.default{constructor(...e){super(...e),i(this,"namespace","v1/sys")}pathForType(e){return"sync/destination"===e?(0,n.pluralize)(e):e}urlForCreateRecord(e,t){const{name:n}=t.attributes()
return`${super.urlForCreateRecord(e,t)}/${n}`}updateRecord(e,{modelName:t},n){const{name:i}=n.attributes()
return this.ajax(`${this.buildURL(t)}/${i}`,"PATCH",{data:n.serialize()})}urlForDeleteRecord(e,t,n){const{name:i,type:r}=n.attributes()
return`${this.buildURL("sync/destinations")}/${r}/${i}?purge=true`}query(e,{modelName:t}){return this.ajax(this.buildURL(t),"GET",{data:{list:!0}})}createRecord(e,t,n){const i=`${n.record.type}:${n.record.name}`
return super.createRecord(...arguments).then((e=>(e.id=i,e)))}async normalizedQuery(){const e=await this.query(this.store,{modelName:"sync/destination"})
return this.store.serializerFor("sync/destination").extractLazyPaginatedData(e)}}e.default=r})),define("vault/adapters/sync/destinations/aws-sm",["exports","vault/adapters/sync/destination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/adapters/sync/destinations/azure-kv",["exports","vault/adapters/sync/destination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/adapters/sync/destinations/gcp-sm",["exports","vault/adapters/sync/destination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/adapters/sync/destinations/gh",["exports","vault/adapters/sync/destination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/adapters/sync/destinations/vercel-project",["exports","vault/adapters/sync/destination"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{}e.default=n})),define("vault/adapters/totp-key",["exports","vault/adapters/application","vault/utils/path-encoding-helpers","@ember/utils"],(function(e,t,n,i){function r(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class l extends t.default{constructor(...e){super(...e),r(this,"namespace","v1")}createRecord(e,t,n){const{name:i,backend:r}=n.record,l=e.serializerFor(t.modelName).serialize(n),a=this.urlForKey(r,i)
return this.ajax(a,"POST",{data:l}).then((e=>{const t=e||{data:{}}
return t.data.id=i,t}))}deleteRecord(e,t,n){const{id:i}=n
return this.ajax(this.urlForKey(n.record.backend,i),"DELETE")}urlForKey(e,t){let r=`${this.buildURL()}/${(0,n.encodePath)(e)}/keys`
return(0,i.isEmpty)(t)||(r=`${r}/${(0,n.encodePath)(t)}`),r}query(e,t,n){const{backend:i}=n
return this.ajax(this.urlForKey(i),"GET",{data:{list:!0}}).then((e=>(e.backend=i,e)))}queryRecord(e,t,n){const{id:i,backend:r}=n
return this.ajax(this.urlForKey(r,i),"GET").then((e=>(e.id=i,e.backend=r,e)))}generateCode(e,t){return this.ajax(`${this.buildURL()}/${(0,n.encodePath)(e)}/code/${t}`,"GET").then((e=>e.data))}}e.default=l})),define("vault/adapters/transform",["exports","rsvp","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=n.default.extend({namespace:"v1",createOrUpdate(e,{modelName:t},n){const{backend:i,name:r,type:l}=n.record,a=e.serializerFor(t).serialize(n),o=this.urlForTransformations(i,r,l)
return this.ajax(o,"POST",{data:a}).then((e=>{const t=e||{}
return t.id=r,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:i}=n
return this.ajax(this.urlForTransformations(n.record.backend,i),"DELETE")},pathForType:()=>"transform",urlForTransformations(e,t,n){const r=`${this.buildURL()}/${(0,i.encodePath)(e)}`,l=n?`${r}/transformations/${n}`:`${r}/transformation`
return t?`${l}/${(0,i.encodePath)(t)}`:l},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e,n){const{id:i,backend:r}=n,l=this.ajax(this.urlForTransformations(r,i),"GET",this.optionsForQuery(i))
return(0,t.allSettled)([l]).then((e=>{if(!e[0].value)throw e[0].reason
const t={id:i,name:i,backend:r,data:{}}
return e.forEach((e=>{if(e.value){let n=e.value.data
n.templates&&(n={...n,template:n.templates},delete n.templates),t.data={...t.data,...n}}})),t}))},query(e,t,n){return this.fetchByQuery(e,n)},queryRecord(e,t,n){return this.fetchByQuery(e,n)}})})),define("vault/adapters/transform/alphabet",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"alphabet"})})),define("vault/adapters/transform/base",["exports","vault/adapters/application","vault/utils/path-encoding-helpers"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",pathForType:e=>e.replace("transform/",""),createOrUpdate(e,t,n){const{backend:i,name:r}=n.record,l=e.serializerFor(t.modelName).serialize(n),a=this.url(i,t.modelName,r)
return this.ajax(a,"POST",{data:l}).then((e=>{const t=e||{data:{}}
return t.data.name=r,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:i}=n
return this.ajax(this.url(n.record.backend,t.modelName,i),"DELETE")},url(e,t,i){const r=this.pathForType(t),l=`/${this.namespace}/${(0,n.encodePath)(e)}/${(0,n.encodePath)(r)}`
return i?`${l}/${(0,n.encodePath)(i)}`:l+"?list=true"},fetchByQuery(e){const{backend:t,modelName:n,id:i}=e
return this.ajax(this.url(t,n,i),"GET").then((e=>({...e,backend:t,id:i,name:i})))},query(e,t,n){return this.fetchByQuery(n)},queryRecord(e,t,n){return this.ajax(this.url(n.backend,t.modelName,n.id),"GET").then((e=>({id:n.id,name:n.id,...e})))}})})),define("vault/adapters/transform/role",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"role"})})),define("vault/adapters/transform/template",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({pathForType:()=>"template"})}))
define("vault/adapters/transform/transformation",["exports","vault/adapters/transform/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({})})),define("vault/adapters/transit-key",["exports","vault/adapters/application","ember-inflector","vault/utils/path-encoding-helpers"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default=t.default.extend({namespace:"v1",createOrUpdate(e,t,n,i){const r=e.serializerFor(t.modelName).serialize(n,i),l=n.attr("name")
let a=this.urlForSecret(n.record.backend,l)
return"update"===i&&(a+="/config"),this.ajax(a,"POST",{data:r}).then((e=>{const t=e||{}
return t.id=l,t}))},createRecord(){return this.createOrUpdate(...arguments)},updateRecord(){return this.createOrUpdate(...arguments,"update")},deleteRecord(e,t,n){const{id:i}=n
return this.ajax(this.urlForSecret(n.record.backend,i),"DELETE")},pathForType(e){let t
switch(e){case"cluster":t="clusters"
break
case"secret-engine":t="secrets"
break
default:t=(0,n.pluralize)(e)}return t},urlForSecret(e,t){let n=`${this.buildURL()}/${(0,i.encodePath)(e)}/keys/`
return t&&(n+=(0,i.encodePath)(t)),n},urlForAction(e,t,n,r){const l=`${this.buildURL()}/${(0,i.encodePath)(t)}/${e}`
if("hash"===e||"random"===e)return l
if("datakey"===e&&r)return`${l}/${r}/${(0,i.encodePath)(n)}`
if("export"===e&&r){const[e,t]=r,a=`${l}/${e}-key/${(0,i.encodePath)(n)}`
return t?`${a}/${t}`:a}return`${l}/${(0,i.encodePath)(n)}`},optionsForQuery(e){const t={}
return e||(t.list=!0),{data:t}},fetchByQuery(e){const{id:t,backend:n}=e
return this.ajax(this.urlForSecret(n,t),"GET",this.optionsForQuery(t)).then((e=>(e.id=t,e.backend=n,e)))},query(e,t,n){return this.fetchByQuery(n)},queryRecord(e,t,n){return this.fetchByQuery(n)},keyAction(e,{backend:t,id:n,payload:i},r={}){const l="export"===e?"GET":"POST",{wrapTTL:a}=r
if("rotate"===e)return this.ajax(this.urlForSecret(t,n)+"/rotate",l)
const{param:o}=i
return delete i.param,this.ajax(this.urlForAction(e,t,n,o),l,{data:i,wrapTTL:a})}})})),define("vault/app",["exports","@ember/application","ember-resolver","ember-load-initializers","vault/config/environment"],(function(e,t,n,i,r){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class a extends t.default{constructor(...e){super(...e),l(this,"modulePrefix",r.default.modulePrefix),l(this,"podModulePrefix",r.default.podModulePrefix),l(this,"Resolver",n.default),l(this,"engines",{"config-ui":{dependencies:{services:["auth","flash-messages","namespace",{"app-router":"router"},"pagination","version","custom-messages","api","capabilities"]}},"open-api-explorer":{dependencies:{services:["auth","flash-messages","namespace",{"app-router":"router"},"version"]}},replication:{dependencies:{services:["auth","capabilities","flash-messages","namespace","replication-mode",{"app-router":"router"},"store","version","-portal"],externalRoutes:{replication:"vault.cluster.replication.index",vault:"vault.cluster"}}},kmip:{dependencies:{services:["auth","download","flash-messages","namespace","path-help",{"app-router":"router"},"store","pagination","version","secret-mount-path"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}},kubernetes:{dependencies:{services:[{"app-router":"router"},"store","secret-mount-path","flash-messages"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}},ldap:{dependencies:{services:[{"app-router":"router"},"store","pagination","secret-mount-path","flash-messages","auth"],externalRoutes:{secrets:"vault.cluster.secrets.backends"}}},kv:{dependencies:{services:["api","capabilities","control-group","download","flash-messages","namespace",{"app-router":"router"},"secret-mount-path","pagination","version"],externalRoutes:{secrets:"vault.cluster.secrets.backends",syncDestination:"vault.cluster.sync.secrets.destinations.destination"}}},pki:{dependencies:{services:["auth","download","flash-messages","namespace","path-help",{"app-router":"router"},"secret-mount-path","store","pagination","version"],externalRoutes:{secrets:"vault.cluster.secrets.backends",externalMountIssuer:"vault.cluster.secrets.backend.pki.issuers.issuer.details",secretsListRootConfiguration:"vault.cluster.secrets.backend.configuration"}}},sync:{dependencies:{services:["flash-messages","flags",{"app-router":"router"},"store","api","capabilities","pagination","version"],externalRoutes:{kvSecretOverview:"vault.cluster.secrets.backend.kv.secret.index",clientCountOverview:"vault.cluster.clients"}}}})}}e.default=a,(0,i.default)(a,r.default.modulePrefix)})),define("vault/breakpoints",["exports"],(function(e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
e.default={mobile:"(max-width: 768px)",tablet:"(min-width: 769px)",desktop:"(min-width: 1088px)"}})),define("vault/component-managers/glimmer",["exports","@glimmer/component/-private/ember-component-manager"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/alert-inline",["exports","core/components/alert-inline"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/alphabet-edit",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","@ember/service","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d
function p(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function f(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m=(0,o.createTemplateFactory)({id:"HW521Zcz",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@breadcrumbs"],[[30,0,["breadcrumbs"]]]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n"],[41,[28,[37,4],[[30,2],"create"],null],[[[1,"        Create Alphabet\\n"]],[]],[[[41,[28,[37,4],[[30,2],"edit"],null],[[[1,"        Edit Alphabet\\n"]],[]],[[[1,"        Alphabet\\n        "],[10,"code"],[12],[1,[30,3,["id"]]],[13],[1,"\\n      "]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[28,[37,4],[[30,2],"show"],null],[[[1,"  "],[8,[39,6],null,null,[["default"],[[[[1,"\\n    "],[8,[39,7],null,null,[["default"],[[[[1,"\\n"],[41,[30,3,["updatePath","canDelete"]],[[[1,"        "],[8,[39,8],[[24,0,"toolbar-button"],[4,[38,9],["click",[30,0,["onDelete"]]],null]],[["@text","@color"],["Delete alphabet","secondary"]],null],[1,"\\n        "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n"]],[]],null],[41,[30,3,["updatePath","canUpdate"]],[[[1,"        "],[8,[39,11],null,[["@secret","@mode","@replace"],[[28,[37,12],[[30,3,["idPrefix"]],[30,3,["id"]]],null],"edit",true]],[["default"],[[[[1,"\\n          Edit alphabet\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,13],[[28,[37,4],[[30,2],"edit"],null],[28,[37,4],[[30,2],"create"],null]],null],[[[1,"  "],[10,"form"],[15,"onsubmit",[30,0,["createOrUpdate"]]],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,15],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n      "],[8,[39,16],null,[["@mode","@noun"],[[30,2],"transform alphabet"]],null],[1,"\\n"],[42,[28,[37,18],[[28,[37,18],[[30,3,["attrs"]]],null]],null],null,[[[41,[28,[37,19],[[28,[37,4],[[30,4,["name"]],"name"],null],[28,[37,4],[[30,2],"edit"],null]],null],[[[1,"          "],[10,"label"],[15,"for",[30,4,["name"]]],[14,0,"is-label"],[12],[1,"\\n            "],[1,[30,4,["options","label"]]],[1,"\\n          "],[13],[1,"\\n"],[41,[30,4,["options","subText"]],[[[1,"            "],[10,2],[14,0,"sub-text"],[12],[1,[30,4,["options","subText"]]],[13],[1,"\\n"]],[]],null],[1,"          "],[10,"input"],[15,1,[30,4,["name"]]],[14,"autocomplete","off"],[14,"spellcheck","false"],[15,2,[28,[37,13],[[28,[37,23],[[30,3],[30,4,["name"]]],null],[30,3,["id"]]],null]],[14,"readonly",""],[14,0,"field input is-readOnly"],[15,4,[30,4,["type"]]],[12],[13],[1,"\\n"]],[]],[[[1,"          "],[8,[39,24],null,[["@attr","@model"],[[30,4],[30,3]]],null],[1,"\\n"]],[]]]],[4]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped-split box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,25],null,null,[["default"],[[[[1,"\\n        "],[8,[39,8],[[24,4,"submit"]],[["@text"],[[52,[28,[37,4],[[30,2],"create"],null],"Create alphabet","Save"]]],null],[1,"\\n"],[41,[28,[37,4],[[30,2],"create"],null],[[[1,"          "],[8,[39,8],null,[["@text","@color","@route","@model","@query"],["Cancel","secondary","vault.cluster.secrets.backend.list-root",[30,3,["backend"]],[28,[37,26],null,[["tab"],["alphabet"]]]]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,8],null,[["@text","@color","@route","@models","@query"],["Cancel","secondary","vault.cluster.secrets.backend.show",[28,[37,27],[[30,3,["backend"]],[28,[37,12],["alphabet/",[30,3,["id"]]],null]],null],[28,[37,26],null,[["tab"],["alphabet"]]]]],null],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[10,0],[14,0,"box is-fullwidth is-sideless is-paddingless is-marginless"],[12],[1,"\\n"],[42,[28,[37,18],[[28,[37,18],[[30,3,["attrs"]]],null]],null],null,[[[41,[28,[37,4],[[30,5,["type"]],"object"],null],[[[1,"        "],[8,[39,28],null,[["@label","@value"],[[28,[37,29],[[28,[37,13],[[30,5,["options","label"]],[28,[37,30],[[28,[37,31],[[30,5,["name"]]],null]],null]],null]],null],[28,[37,32],[[28,[37,23],[[30,3],[30,5,["name"]]],null]],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,5,["type"]],"array"],null],[[[1,"        "],[8,[39,28],null,[["@label","@value","@type","@isLink"],[[28,[37,29],[[28,[37,13],[[30,5,["options","label"]],[28,[37,30],[[28,[37,31],[[30,5,["name"]]],null]],null]],null]],null],[28,[37,23],[[30,3],[30,5,["name"]]],null],[30,5,["type"]],[28,[37,4],[[30,5,["name"]],"transformations"],null]]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,28],null,[["@label","@value"],[[28,[37,29],[[28,[37,13],[[30,5,["options","label"]],[28,[37,30],[[28,[37,31],[[30,5,["name"]]],null]],null]],null]],null],[28,[37,23],[[30,3],[30,5,["name"]]],null]]],null],[1,"\\n      "]],[]]]],[]]]],[5]],null],[1,"  "],[13],[1,"\\n"]],[]]]],["p","@mode","@model","attr","attr"],false,["page-header","page/breadcrumbs","h1","if","eq","code","toolbar","toolbar-actions","hds/button","on","div","toolbar-secret-link","concat","or","form","message-error","namespace-reminder","each","-track-array","and","label","p","input","get","form-field","hds/button-set","hash","array","info-table-row","capitalize","humanize","dasherize","stringify"]]',moduleName:"vault/components/alphabet-edit.hbs",isStrictMode:!1})
let h=e.default=(s=class extends n.default{constructor(...e){super(...e),p(this,"flashMessages",u,this),p(this,"router",c,this),p(this,"errorMessage",d,this)}get breadcrumbs(){const{backend:e}=this.args.model
return[{label:e,route:"vault.cluster.secrets.backend.list-root",model:e,query:{tab:"alphabet"}},{label:"Alphabet"}]}transition(e="show"){this.errorMessage=""
const{backend:t,id:n}=this.args.model
"list"!==e?this.router.transitionTo("vault.cluster.secrets.backend.show",`alphabet/${n}`):this.router.transitionTo("vault.cluster.secrets.backend.list-root",t,{queryParams:{tab:"alphabet"}})}async createOrUpdate(e){if(e.preventDefault(),!this.args.model.hasDirtyAttributes)return this.flashMessages.info("No changes detected."),void this.transition()
try{await this.args.model.save(),this.flashMessages.success("Alphabet saved."),this.transition()}catch(t){this.errorMessage=(0,a.default)(t)}}async onDelete(){try{await this.args.model.destroyRecord(),this.flashMessages.success("Alphabet deleted."),this.transition("list")}catch(e){this.errorMessage=(0,a.default)(e)}}},u=f(s.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(s.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=f(s.prototype,"errorMessage",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f(s.prototype,"createOrUpdate",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"createOrUpdate"),s.prototype),f(s.prototype,"onDelete",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"onDelete"),s.prototype),s);(0,t.setComponentTemplate)(m,h)})),define("vault/components/app-footer",["exports","@ember/component","@ember/service","@glimmer/component","vault/config/environment","@ember/template-factory"],(function(e,t,n,i,r,l){var a,o
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=(0,l.createTemplateFactory)({id:"lyT7vaUW",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-margin-top-auto"]],null,[["default"],[[[[1,"\\n  "],[8,[30,1,["ExtraBefore"]],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["isDevelopment"]],[[[1,"      "],[10,0],[14,0,"env-banner"],[12],[1,"\\n        "],[10,0],[14,0,"level-item notification"],[12],[1,"\\n          "],[8,[39,3],null,[["@name"],["git-branch"]],null],[8,[39,3],null,[["@name"],["pencil-tool"]],null],[1,"\\n          Local development\\n          "],[8,[39,3],null,[["@name"],["pencil-tool"]],null],[8,[39,3],null,[["@name"],["git-branch"]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n  "],[8,[30,1,["Link"]],null,[["@href"],[[28,[37,4],[[30,0,["version","version"]]],null]]],[["default"],[[[[1,"\\n    Vault\\n    "],[1,[30,0,["version","version"]]],[1,"\\n  "]],[]]]]],[1,"\\n"],[41,[30,0,["version","isCommunity"]],[[[1,"    "],[8,[30,1,["Link"]],null,[["@href"],["https://hashicorp.com/products/vault/trial?source=vaultui"]],[["default"],[[[[1,"\\n      Upgrade to Vault Enterprise\\n    "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "],[8,[30,1,["Link"]],null,[["@href"],[[28,[37,5],["/vault"],null]]],[["default"],[[[[1,"\\n    Documentation\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["LegalLinks"]],null,null,null],[1,"\\n  "],[8,[30,1,["ExtraAfter"]],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["isDevelopment"]],[[[1,"      "],[8,[39,6],[[24,"target","_blank"]],[["@text","@isIconOnly","@icon","@color","@route"],["Contributing docs",true,"gift","tertiary","docs"]],null],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"]],[1]]]]]],["AF"],false,["hds/app-footer","if","div","icon","changelog-url-for","doc-link","hds/button"]]',moduleName:"vault/components/app-footer.hbs",isStrictMode:!1})
let u=e.default=(a=class extends i.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="version",r=this,(i=o)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}get isDevelopment(){return"development"===r.default.environment}},c=a.prototype,d="version",p=[n.service],f={configurable:!0,enumerable:!0,writable:!0,initializer:null},h={},Object.keys(f).forEach((function(e){h[e]=f[e]})),h.enumerable=!!h.enumerable,h.configurable=!!h.configurable,("value"in h||h.initializer)&&(h.writable=!0),h=p.slice().reverse().reduce((function(e,t){return t(c,d,e)||e}),h),m&&void 0!==h.initializer&&(h.value=h.initializer?h.initializer.call(m):void 0,h.initializer=void 0),o=void 0===h.initializer?(Object.defineProperty(c,d,h),null):h,a)
var c,d,p,f,m,h;(0,t.setComponentTemplate)(s,u)})),define("vault/components/auth-config-form/config",["exports","@ember/component","@ember/service","@glimmer/component","ember-concurrency","@ember/test-waiters","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p
function f(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function m(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h=(0,o.createTemplateFactory)({id:"fgdiF3R7",block:'[[[1,"\\n"],[11,"form"],[4,[38,1],["submit",[28,[37,2],[[30,0,["saveModel"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,4],null,[["@mode","@noun"],["save","Auth Method"]],null],[1,"\\n    "],[8,[39,5],null,[["@model","@errorMessage"],[[30,1],[30,0,["errorMessage"]]]],null],[1,"\\n    "],[8,[39,6],null,[["@model","@groupName"],[[30,1],"formFieldGroups"]],null],[1,"\\n  "],[13],[1,"\\n\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,7],[[16,"disabled",[30,0,["saveModel","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Save",[52,[30,0,["saveModel","isRunning"]],"loading"]]],null],[1,"\\n  "],[13],[1,"\\n"],[13]],["@form"],false,["form","on","perform","div","namespace-reminder","message-error","form-field-groups","hds/button","if"]]',moduleName:"vault/components/auth-config-form/config.hbs",isStrictMode:!1})
let b=e.default=(s=class extends i.default{constructor(...e){super(...e),f(this,"api",u,this),f(this,"flashMessages",c,this),f(this,"router",d,this),f(this,"errorMessage",p,this)}configMethod(e,t){const{section:n,method:i}=this.args
switch(i.methodType){case"aws":switch(n){case"client":return this.api.auth.awsConfigureClient(e,t)
case"identity-accesslist":return this.api.auth.awsConfigureIdentityAccessListTidyOperation(e,t)
case"roletag-denylist":return this.api.auth.awsConfigureRoleTagDenyListTidyOperation(e,t)
default:throw new Error(`Unsupported AWS section: ${n}`)}case"azure":return this.api.auth.azureConfigureAuth(e,t)
case"github":return this.api.auth.githubConfigure(e,t)
case"gcp":return this.api.auth.googleCloudConfigureAuth(e,t)
case"jwt":case"oidc":return this.api.auth.jwtConfigure(e,t)
case"kubernetes":return this.api.auth.kubernetesConfigureAuth(e,t)
case"ldap":return this.api.auth.ldapConfigureAuth(e,t)
case"okta":return this.api.auth.oktaConfigure(e,t)
case"radius":return this.api.auth.radiusConfigure(e,t)
default:throw new Error(`Configuration of the ${i.methodType} method is not supported by the Vault UI.`)}}*saveModel(e){e.preventDefault(),this.errorMessage=""
try{const{form:e,method:t}=this.args,{data:n}=e.toJSON()
yield this.configMethod(t.path,n),this.router.transitionTo("vault.cluster.access.methods").followRedirects(),this.flashMessages.success("The configuration was saved successfully.")}catch(t){const{message:e}=yield this.api.parseError(t)
this.errorMessage=e}}},u=m(s.prototype,"api",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(s.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(s.prototype,"errorMessage",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),m(s.prototype,"saveModel",[r.task,l.waitFor],Object.getOwnPropertyDescriptor(s.prototype,"saveModel"),s.prototype),s);(0,t.setComponentTemplate)(h,b)})),define("vault/components/auth-config-form/options",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@glimmer/component","@ember/service","ember-concurrency","@ember/test-waiters","@glimmer/tracking","vault/utils/auth-form-helpers","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f,m,h,b
function y(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function g(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function v(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const w=(0,u.createTemplateFactory)({id:"H8dbZuDr",block:'[[[1,"\\n"],[11,"form"],[4,[38,1],["submit",[28,[37,2],[[30,0,["onSubmit"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,4],null,[["@model","@errorMessage"],[[30,1],[30,0,["errorMessage"]]]],null],[1,"\\n    "],[8,[39,5],null,[["@mode","@noun"],["save","Auth Method"]],null],[1,"\\n\\n"],[42,[28,[37,7],[[28,[37,7],[[30,1,["tuneFields"]]],null]],null],null,[[[1,"      "],[8,[39,8],null,[["@attr","@model"],[[30,2],[30,1]]],null],[1,"\\n"],[41,[28,[37,10],[[28,[37,11],[[30,2,["name"]],"config.listing_visibility"],null],[30,0,["directLoginLink"]]],null],[[[1,"        "],[10,0],[14,0,"has-top-margin-negative-s has-bottom-margin-l is-flex-center"],[12],[1,"\\n          "],[8,[39,12],null,[["@tag","@color"],["p","faint"]],[["default"],[[[[1,"UI login link:"]],[]]]]],[1,"\\n          "],[8,[39,13],null,[["@textToCopy"],[[30,0,["directLoginLink"]]]],null],[1,"\\n        "],[13],[1,"\\n"]],[]],null]],[2]],null],[1,"\\n"],[41,[30,0,["supportsUserLockoutConfig"]],[[[1,"      "],[10,"hr"],[14,0,"has-top-margin-xl has-bottom-margin-l has-background-gray-200"],[12],[13],[1,"\\n      "],[8,[39,15],null,[["@tag","@size","@weight"],["h2","400","bold"]],[["default"],[[[[1,"User lockout configuration"]],[]]]]],[1,"\\n      "],[8,[39,12],[[24,0,"has-bottom-margin-m"]],[["@tag","@size","@color"],["p","100","faint"]],[["default"],[[[[1,"\\n        Specifies the user lockout settings for this auth mount.\\n      "]],[]]]]],[1,"\\n"],[42,[28,[37,7],[[28,[37,7],[[30,1,["userLockoutConfigFields"]]],null]],null],null,[[[1,"        "],[8,[39,8],null,[["@attr","@model"],[[30,3],[30,1]]],null],[1,"\\n"]],[3]],null]],[]],null],[1,"  "],[13],[1,"\\n\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,16],[[16,"disabled",[30,0,["onSubmit","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Update options",[52,[30,0,["onSubmit","isRunning"]],"loading"]]],null],[1,"\\n  "],[13],[1,"\\n"],[13]],["@form","field","field"],false,["form","on","perform","div","message-error","namespace-reminder","each","-track-array","form-field","if","and","eq","hds/text/body","hds/copy/snippet","hr","hds/text/display","hds/button"]]',moduleName:"vault/components/auth-config-form/options.hbs",isStrictMode:!1})
let k=e.default=(c=class extends i.default{constructor(...e){super(...e),y(this,"api",d,this),y(this,"flashMessages",p,this),y(this,"router",f,this),y(this,"namespace",m,this),y(this,"version",h,this),y(this,"errorMessage",b,this),g(this,"onSubmit",(0,n.buildTask)((()=>({context:this,generator:(0,a.waitFor)((function*(e){e.preventDefault(),this.errorMessage=null
try{const{form:e}=this.args,{data:{description:t,config:n,user_lockout_config:i}}=e.toJSON(),r={description:t,...n}
Object.keys(i).length&&(r.user_lockout_config=i),"token"===e.normalizedType&&r?.token_type&&delete r.token_type,yield this.api.sys.mountsAuthTuneConfigurationParameters(e.data.path,r),this.router.transitionTo("vault.cluster.access.methods").followRedirects(),this.flashMessages.success("The configuration was saved successfully.")}catch(t){const{message:e}=yield this.api.parseError(t)
this.errorMessage=e}}))})),null,"onSubmit",null))}get directLoginLink(){const e=this.namespace.path,t=e?`namespace=${encodeURIComponent(e)}&`:"",{normalizedType:n,data:i}=this.args.form
return(0,s.supportedTypes)(this.version.isEnterprise).includes(n)?`${window.origin}/ui/vault/auth?${t}with=${encodeURIComponent(i.path)}`:""}get supportsUserLockoutConfig(){return["approle","ldap","userpass"].includes(this.args.form.normalizedType)}},d=v(c.prototype,"api",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=v(c.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=v(c.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=v(c.prototype,"namespace",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=v(c.prototype,"version",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=v(c.prototype,"errorMessage",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),c);(0,t.setComponentTemplate)(w,k)})),define("vault/components/auth-method/configuration",["exports","@ember/component","@glimmer/component","core/helpers/to-label","@ember/object","@ember/template-factory"],(function(e,t,n,i,r,l){function a(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,l.createTemplateFactory)({id:"bvUgQDtP",block:'[[[1,"\\n"],[10,0],[14,0,"box is-fullwidth is-sideless is-paddingless is-marginless"],[12],[1,"\\n"],[41,[30,1,["directLoginLink"]],[[[1,"    "],[8,[39,2],null,[["@alwaysRender","@label"],[true,"UI login link"]],[["default"],[[[[1,"\\n      "],[8,[39,3],null,[["@textToCopy"],[[30,1,["directLoginLink"]]]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null],[42,[28,[37,5],[[28,[37,5],[[30,0,["displayFields"]]],null]],null],null,[[[1,"    "],[8,[39,2],null,[["@alwaysRender","@label","@value","@formatTtl"],[[28,[37,6],[[28,[37,7],[[28,[37,8],[[30,1],[30,2]],null]],null]],null],[28,[30,0,["label"]],[[30,2]],null],[28,[30,0,["value"]],[[30,2]],null],[28,[30,0,["isTtl"]],[[30,2]],null]]],null],[1,"\\n"]],[2]],null],[13]],["@method","field"],false,["div","if","info-table-row","hds/copy/snippet","each","-track-array","not","is-empty-value","get"]]',moduleName:"vault/components/auth-method/configuration.hbs",isStrictMode:!1})
class s extends n.default{constructor(...e){super(...e),a(this,"displayFields",["type","path","description","accessor","local","seal_wrap","config.listing_visibility","config.default_lease_ttl","config.max_lease_ttl","config.token_type","config.audit_non_hmac_request_keys","config.audit_non_hmac_response_keys","config.passthrough_request_headers","config.allowed_response_headers","config.plugin_version"]),a(this,"label",(e=>{const t=e.replace("config.",""),n=(0,i.toLabel)([t])
return{listing_visibility:"Use as preferred UI login method",default_lease_ttl:"Default Lease TTL",max_lease_ttl:"Max Lease TTL",audit_non_hmac_request_keys:"Request keys excluded from HMACing in audit",audit_non_hmac_response_keys:"Response keys excluded from HMACing in audit",passthrough_request_headers:"Allowed passthrough request headers"}[t]||n})),a(this,"value",(e=>{const{method:t}=this.args
return"config.listing_visibility"===e?"unauth"===t.config.listing_visibility:(0,r.get)(t,e)})),a(this,"isTtl",(e=>["config.default_lease_ttl","config.max_lease_ttl"].includes(e)))}}e.default=s,(0,t.setComponentTemplate)(o,s)})),define("vault/components/auth/fields",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,i){function r(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const l=(0,i.createTemplateFactory)({id:"gSIkdHUA",block:'[[[1,"\\n"],[42,[28,[37,1],[[28,[37,1],[[30,1]],null]],null],null,[[[44,[[30,2,["name"]],[30,2,["label"]],[30,2,["helperText"]]],[[[1,"    "],[8,[39,3],[[24,"autocomplete","off"],[16,3,[30,3]],[24,0,"has-bottom-margin-m"]],[["@type","@value"],[[28,[30,0,["setInputType"]],[[30,3]],null],[28,[37,4],[[28,[37,5],[[30,6],[30,3]],null],""],null]]],[["default"],[[[[1,"\\n      "],[8,[30,7,["Label"]],null,null,[["default"],[[[[1,[28,[35,4],[[30,4],[28,[37,6],[[30,3]],null]],null]]],[]]]]],[1,"\\n"],[41,[30,5],[[[1,"        "],[8,[30,7,["HelperText"]],null,null,[["default"],[[[[1,[30,5]]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[7]]]]],[1,"\\n"]],[3,4,5]]]],[2]],null]],["@loginFields","field","name","label","helperText","@formQueryParams","F"],false,["each","-track-array","let","hds/form/text-input/field","or","get","capitalize","if"]]',moduleName:"vault/components/auth/fields.hbs",isStrictMode:!1})
class a extends n.default{constructor(...e){super(...e),r(this,"setInputType",(e=>["token","password"].includes(e)?"password":"text"))}}e.default=a,(0,t.setComponentTemplate)(l,a)})),define("vault/components/auth/form-template",["exports","@ember/component","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object","vault/utils/auth-form-helpers","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p
function f(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function m(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function h(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,o.createTemplateFactory)({id:"BhSZtlMk",block:'[[[1,"\\n"],[41,[30,0,["formComponent"]],[[[44,[[50,[30,0,["formComponent"]],0,null,null]],[[[1,"    "],[8,[30,1],null,[["@authType","@cluster","@formQueryParams","@handleAuthResponse","@loginTransitionIsRunning","@onError"],[[30,0,["selectedAuthMethod"]],[30,2],[30,3],[30,4],[30,5],[30,0,["handleError"]]]],[["namespace","back","authSelectOptions","error","advancedSettings","footer"],[[[[1,"\\n        "],[18,10,null],[1,"\\n      "]],[]],[[[1,"\\n"],[41,[30,0,["showAlternateView"]],[[[1,"          "],[8,[39,6],[[4,[38,7],["click",[30,0,["toggleView"]]],null]],[["@text","@color","@icon"],["Back","tertiary","arrow-left"]],null],[1,"\\n"]],[]],null],[1,"      "]],[]],[[[1,"\\n        "],[10,0],[14,0,"has-bottom-margin-m"],[12],[1,"\\n"],[41,[30,0,["tabData"]],[[[1,"            "],[8,[39,10],null,[["@authTabData","@handleTabClick","@selectedAuthMethod"],[[30,0,["tabData"]],[30,0,["setAuthType"]],[30,0,["selectedAuthMethod"]]]],null],[1,"\\n"]],[]],[[[1,"            "],[8,[39,11],[[24,3,"selectedAuthMethod"],[4,[38,7],["input",[30,0,["setTypeFromDropdown"]]],null]],null,[["default"],[[[[1,"\\n              "],[8,[30,6,["Label"]],[[24,0,"has-top-margin-m"]],null,[["default"],[[[[1,"Method"]],[]]]]],[1,"\\n              "],[8,[30,6,["Options"]],null,null,[["default"],[[[[1,"\\n"],[42,[28,[37,13],[[28,[37,13],[[30,0,["supportedAuthTypes"]]],null]],null],null,[[[1,"                  "],[10,"option"],[15,"selected",[28,[37,15],[[30,0,["selectedAuthMethod"]],[30,7]],null]],[15,2,[30,7]],[12],[1,"\\n                    "],[1,[28,[35,16],[[28,[37,17],[[30,7]],null],"displayName"],null]],[1,"\\n                  "],[13],[1,"\\n"]],[7]],null],[1,"              "]],[]]]]],[1,"\\n            "]],[6]]]]],[1,"\\n"]],[]]],[1,"        "],[13],[1,"\\n      "]],[]],[[[1,"\\n"],[41,[30,0,["errorMessage"]],[[[1,"          "],[8,[39,19],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n"]],[]],null],[1,"      "]],[]],[[[1,"\\n"],[41,[51,[30,0,["hideAdvancedSettings"]]],[[[1,"          "],[8,[39,22],[[24,0,"is-fullwidth"]],[["@text"],["Advanced settings"]],[["default"],[[[[1,"\\n            "],[8,[39,23],[[24,3,"path"]],null,[["default"],[[[[1,"\\n              "],[8,[30,8,["Label"]],[[24,0,"has-top-margin-m"]],null,[["default"],[[[[1,"Mount path"]],[]]]]],[1,"\\n              "],[8,[30,8,["HelperText"]],null,null,[["default"],[[[[1,"\\n                If this authentication method was mounted using a non-default path, input it below. Otherwise Vault will\\n                assume the default path\\n                "],[8,[39,24],[[24,0,"code-in-text"]],null,[["default"],[[[[1,[30,0,["selectedAuthMethod"]]]],[]]]]],[1,"\\n                ."]],[]]]]],[1,"\\n            "]],[8]]]]],[1,"\\n          "]],[]]]]],[1,"\\n"]],[]],null],[1,"      "]],[]],[[[1,"\\n"],[41,[28,[37,26],[[30,9],[28,[37,27],[[30,0,["showAlternateView"]]],null]],null],[[[1,"          "],[8,[39,6],[[4,[38,7],["click",[30,0,["toggleView"]]],null]],[["@color","@icon","@iconPosition","@isInline","@text"],["tertiary","arrow-right","trailing",true,"Sign in with other methods"]],null],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n"]],[1]]]],[]],null]],["AuthFormComponent","@cluster","@formQueryParams","@handleAuthResponse","@loginTransitionIsRunning","F","type","F","@alternateView","&default"],false,["if","let","component",":namespace","yield",":back","hds/button","on",":authSelectOptions","div","auth/tabs","hds/form/select/field","each","-track-array","option","eq","get","engines-display-data",":error","message-error",":advancedSettings","unless","hds/reveal","hds/form/text-input/field","hds/text/code",":footer","and","not"]]',moduleName:"vault/components/auth/form-template.hbs",isStrictMode:!1})
let y=e.default=(s=class extends n.default{constructor(e,t){super(e,t),f(this,"version",u,this),m(this,"supportedAuthTypes",void 0),f(this,"errorMessage",c,this),f(this,"selectedAuthMethod",d,this),f(this,"showAlternateView",p,this)
const{initialAuthType:n,showAlternate:i}=this.args.initialFormState
this.selectedAuthMethod=n,this.showAlternateView=i,this.supportedAuthTypes=(0,a.supportedTypes)(this.version.isEnterprise)}get tabData(){return this.showAlternateView?this.args?.alternateView?.tabData:this.args?.defaultView?.tabData}get formComponent(){const{selectedAuthMethod:e}=this
return`auth/form/${this.supportedAuthTypes.includes(e)?["oidc","jwt"].includes(e)?"oidc-jwt":e:"base"}`}get hideAdvancedSettings(){return"token"===this.selectedAuthMethod||!!this.tabData&&this.args.visibleMountTypes?.includes(this.selectedAuthMethod)}setAuthType(e){this.selectedAuthMethod=e}setTypeFromDropdown(e){this.selectedAuthMethod=e.target.value}toggleView(){this.showAlternateView=!this.showAlternateView
const e=Object.keys(this.tabData||{})[0]||this.args.initialFormState.initialAuthType
this.setAuthType(e)}handleError(e){this.errorMessage=e}},u=h(s.prototype,"version",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=h(s.prototype,"errorMessage",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),d=h(s.prototype,"selectedAuthMethod",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p=h(s.prototype,"showAlternateView",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),h(s.prototype,"setAuthType",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"setAuthType"),s.prototype),h(s.prototype,"setTypeFromDropdown",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"setTypeFromDropdown"),s.prototype),h(s.prototype,"toggleView",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"toggleView"),s.prototype),h(s.prototype,"handleError",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"handleError"),s.prototype),s);(0,t.setComponentTemplate)(b,y)})),define("vault/components/auth/form/base",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@glimmer/component","@ember/object","@ember/service","ember-concurrency","@ember/test-waiters","core/utils/sanitize-path","vault/utils/auth-form-helpers","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c){var d,p,f,m,h
function b(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function y(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function g(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const v=(0,c.createTemplateFactory)({id:"t+nuaf4+",block:'[[[1,"\\n"],[1,"\\n"],[11,"form"],[4,[38,1],["submit",[30,0,["onSubmit"]]],null],[12],[1,"\\n\\n  "],[18,2,null],[1,"\\n\\n  "],[10,0],[14,0,"has-padding-l"],[12],[1,"\\n    "],[18,3,null],[1,"\\n    "],[18,4,null],[1,"\\n    "],[18,5,null],[1,"\\n\\n    "],[8,[39,4],null,[["@loginFields"],[[30,0,["loginFields"]]]],null],[1,"\\n\\n    "],[18,6,null],[1,"\\n\\n    "],[8,[39,5],null,[["@text","@icon"],["Sign in",[52,[28,[37,7],[[30,0,["login","isRunning"]],[30,1]],null],"loading"]]],null],[1,"\\n\\n    "],[18,7,null],[1,"\\n  "],[13],[1,"\\n"],[13]],["@loginTransitionIsRunning","&namespace","&back","&authSelectOptions","&error","&advancedSettings","&footer"],false,["form","on","yield","div","auth/fields","auth/sign-in-button","if","or"]]',moduleName:"vault/components/auth/form/base.hbs",isStrictMode:!1})
let w=e.default=(d=class extends i.default{constructor(...e){super(...e),b(this,"api",p,this),b(this,"flags",f,this),b(this,"version",m,this),b(this,"auth",h,this),y(this,"login",(0,n.buildTask)((()=>({context:this,generator:(0,o.waitFor)((function*(e){try{const t=yield this.loginRequest(e)
this.args.handleAuthResponse(t)}catch(t){this.onError(t)}}))})),null,"login",null)),y(this,"normalizeAuthResponse",((e,{authMountPath:t,displayName:n,token:i,ttl:r})=>this.auth.normalizeAuthData(e,{authMethodType:this.args.authType,authMountPath:t,displayName:n,token:i,ttl:r})))}onSubmit(e){e.preventDefault()
const t=new FormData(e.target),n=this.parseFormData(t)
this.login.unlinked().perform(n)}async onError(e){this.cancelLogin&&this.cancelLogin()
let t=""
if("string"==typeof e)t=e
else{const{message:n}=await this.api.parseError(e,"An error occurred, check the Vault logs.")
t=n}this.args.onError(`Authentication failed: ${t}`)}parseFormData(e){const t={}
for(const n of u.POSSIBLE_FIELDS){const i=e.get(n)
i&&(t[n]="string"==typeof i?i:void 0)}if("token"!==this.args.authType&&(t.path=(0,s.sanitizePath)(e?.get("path"))||this.args.authType),this.version.isEnterprise){let n=(0,s.sanitizePath)(e?.get("namespace"))||""
const i=this.flags.hvdManagedNamespaceRoot
i&&(n=n?`${i}/${n}`:i),t.namespace=n}return t}},p=g(d.prototype,"api",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=g(d.prototype,"flags",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=g(d.prototype,"version",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=g(d.prototype,"auth",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g(d.prototype,"onSubmit",[r.action],Object.getOwnPropertyDescriptor(d.prototype,"onSubmit"),d.prototype),d);(0,t.setComponentTemplate)(v,w)})),define("vault/components/auth/form/github",["exports","vault/components/auth/form/base"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),n(this,"loginFields",[{name:"token",label:"Github token"}])}async loginRequest(e){const{path:t,token:n}=e,{auth:i}=await this.api.auth.githubLogin(t,{token:n}),{org:r,username:l}=i?.metadata||{},a=r&&l?`${r}/${l}`:l||r||""
return this.normalizeAuthResponse(i,{authMountPath:t,displayName:a,token:i.client_token,ttl:i.lease_duration})}}e.default=i})),define("vault/components/auth/form/ldap",["exports","vault/components/auth/form/base"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),n(this,"loginFields",[{name:"username"},{name:"password"}])}async loginRequest(e){const{path:t,username:n,password:i}=e,{auth:r}=await this.api.auth.ldapLogin(n,t,{password:i})
return this.normalizeAuthResponse(r,{authMountPath:t,displayName:r?.metadata?.username,token:r.client_token,ttl:r.lease_duration})}}e.default=i})),define("vault/components/auth/form/oidc-jwt",["exports","@ember/component","ember-concurrency/async-arrow-runtime","vault/components/auth/form/base","ember","@ember/object","@ember/string","vault/utils/auth-form-helpers","ember-concurrency","@ember/service","@glimmer/tracking","core/utils/parse-url","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c,d,p){var f,m,h,b,y
function g(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function v(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function w(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const k=(0,p.createTemplateFactory)({id:"DN/+uTdd",block:'[[[1,"\\n"],[11,"form"],[4,[38,1],[[30,0,["initializeFormData"]]],null],[4,[38,2],[[30,0,["initializeFormData"]],[30,1]],null],[4,[38,3],["input",[30,0,["updateFormData"]]],null],[4,[38,3],["submit",[30,0,["onSubmit"]]],null],[12],[1,"\\n\\n  "],[18,5,null],[1,"\\n\\n  "],[10,0],[14,0,"has-padding-l"],[12],[1,"\\n    "],[18,6,null],[1,"\\n    "],[18,7,null],[1,"\\n    "],[18,8,null],[1,"\\n\\n    "],[8,[39,6],null,[["@loginFields","@formQueryParams"],[[30,0,["loginFields"]],[30,2]]],null],[1,"\\n\\n"],[41,[51,[30,0,["isOIDC"]]],[[[1,"      "],[8,[39,8],[[24,0,"has-bottom-margin-m"],[24,3,"jwt"]],[["@type"],["password"]],[["default"],[[[[1,"\\n        "],[8,[30,3,["Label"]],null,null,[["default"],[[[[1,"JWT Token"]],[]]]]],[1,"\\n      "]],[3]]]]],[1,"\\n"]],[]],null],[1,"\\n    "],[18,9,null],[1,"\\n\\n    "],[8,[39,9],null,[["@icon","@text"],[[52,[28,[37,11],[[30,0,["login","isRunning"]],[30,4]],null],"loading",[30,0,["icon"]]],[29,["Sign in ",[52,[30,0,["isOIDC"]],[30,0,["providerName"]]]]]]],null],[1,"\\n\\n    "],[18,10,null],[1,"\\n  "],[13],[1,"\\n"],[13]],["@authType","@formQueryParams","F","@loginTransitionIsRunning","&namespace","&back","&authSelectOptions","&error","&advancedSettings","&footer"],false,["form","did-insert","did-update","on","yield","div","auth/fields","unless","hds/form/text-input/field","auth/sign-in-button","if","or"]]',moduleName:"vault/components/auth/form/oidc-jwt.hbs",isStrictMode:!1})
let x=e.default=(f=class extends i.default{constructor(...e){super(...e),g(this,"router",m,this),v(this,"loginFields",[{name:"role",helperText:"Vault will use the default role to sign in if this field is left blank."}]),v(this,"_formData",new FormData),g(this,"authUrl",h,this),g(this,"errorMessage",b,this),g(this,"isOIDC",y,this),v(this,"fetchAuthUrl",(0,n.buildTask)((()=>({context:this,generator:function*(e=0){e&&(yield(0,s.timeout)(e))
const{namespace:t="",path:n="",role:i=""}=this.parseFormData(this._formData),r=this.generateRedirectUri(t,n)
this.authUrl=null,this.errorMessage=""
try{const{data:e}=yield this.api.auth.jwtOidcRequestAuthorizationUrl(n,{role:i,redirect_uri:r})
this.authUrl=e.auth_url,this.isOIDC=!0}catch(l){const{status:e,message:t}=yield this.api.parseError(l)
this.errorMessage=400===e?"Invalid role. Please try again.":`Error fetching role: ${t}`,this.isOIDC=!t.includes(o.ERROR_JWT_LOGIN)}}})),null,"fetchAuthUrl","restartable")),v(this,"watchPopup",(0,n.buildTask)((()=>({context:this,generator:function*(e){for(;;){const t=r.default.testing?50:500
if(yield(0,s.timeout)(t),!e||e.closed)return void this.onError(o.ERROR_WINDOW_CLOSED)}}})),null,"watchPopup",null)),v(this,"watchCurrent",(0,n.buildTask)((()=>({context:this,generator:function*(e){yield(0,s.waitForEvent)(window,"beforeunload"),e.close()}})),null,"watchCurrent",null))}get icon(){return"Ping Identity"===this.provider?"ping-identity ":this.provider?(0,a.dasherize)(this.provider.toLowerCase()):""}get providerName(){return`with ${this.provider||"OIDC Provider"}`}get provider(){const{hostname:e}=(0,d.default)(this.authUrl)
if(e){const t=Object.keys(o.DOMAIN_PROVIDER_MAP).find((t=>e.includes(t)))
return t?o.DOMAIN_PROVIDER_MAP[t]:null}return null}initializeFormData(e){this._formData=new FormData(e),this.fetchAuthUrl.perform()}updateFormData(e){const{name:t,value:n}=e.target
"selectedAuthMethod"!==t&&(this._formData?.set(t,n),["path","role"].includes(t)&&this.fetchAuthUrl.perform(500))}generateRedirectUri(e="",t=""){const n=e?{namespace:e}:{}
return`${window.location.origin}${this.router.urlFor("vault.cluster.oidc-callback",{auth_path:t},{queryParams:n})}`}async loginRequest(e){return this.isOIDC?await this.loginOidc():await this.loginJwt(e)}async loginJwt(e){const{path:t,jwt:n,role:i}=e,{auth:r}=await this.api.auth.jwtLogin(t,{jwt:n,role:i})
return this.normalizeAuthResponse(r,{authMountPath:t,token:r.client_token,ttl:r.lease_duration})}async loginOidc(){const e=await this.startOIDCAuth()
if(!e)throw`Failed to open OIDC popup window. ${o.ERROR_POPUP_FAILED}`
try{this.watchPopup.perform(e),this.watchCurrent.perform(e)
const t=await this.prepareForOIDC(),{auth:n,path:i}=await this.exchangeOIDC(t)
return this.normalizeAuthResponse(n,{authMountPath:i,token:n.client_token,ttl:n.lease_duration})}finally{this.closeWindow(e)}}async startOIDCAuth(){if(await this.fetchAuthUrl.perform(),!this.authUrl){throw""===this.authUrl?"Missing auth_url. Please check that allowed_redirect_uris for the role include this mount path.":this.errorMessage||"Unknown OIDC error. Check the Vault logs and try again."}const e=window,t=e.screen.width/2-250,n=e.screen.height/2-300
return e.open(this.authUrl,"vaultOIDCWindow",`width=500,height=600,resizable,scrollbars=yes,top=${n},left=${t}`)}async prepareForOIDC(){const e=window
for(;;){const t=await(0,s.waitForEvent)(e,"message")
if(t.origin===e.origin&&t.isTrusted&&"oidc-callback"===t.data.source)return t.data}}async exchangeOIDC(e){const{path:t,state:n,code:i}=e
if(!t||!n||!i)throw o.ERROR_MISSING_PARAMS
const{auth:r}=await this.api.auth.jwtOidcCallback(t,void 0,i,n)
return{auth:r,path:t}}cancelLogin(){this.login.cancelAll()}closeWindow(e){this.watchPopup.cancelAll(),this.watchCurrent.cancelAll(),e.close()}},m=w(f.prototype,"router",[u.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=w(f.prototype,"authUrl",[c.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b=w(f.prototype,"errorMessage",[c.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y=w(f.prototype,"isOIDC",[c.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!0}}),w(f.prototype,"initializeFormData",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"initializeFormData"),f.prototype),w(f.prototype,"updateFormData",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"updateFormData"),f.prototype),f);(0,t.setComponentTemplate)(k,x)})),define("vault/components/auth/form/okta",["exports","@ember/component","ember-concurrency/async-arrow-runtime","vault/components/auth/form/base","@ember/object","ember-concurrency","@glimmer/tracking","@ember/test-waiters","core/utils/uuid","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f
function m(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function h(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function b(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,u.createTemplateFactory)({id:"qR5BO5FO",block:'[[[1,"\\n"],[41,[30,0,["showNumberChallenge"]],[[[1,"  "],[8,[39,1],null,[["@correctAnswer","@hasError","@onReturnToLogin"],[[30,0,["challengeAnswer"]],[30,0,["oktaVerifyError"]],[30,0,["cancelLogin"]]]],null],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[4,[38,3],["submit",[30,0,["onSubmit"]]],null],[12],[1,"\\n\\n    "],[18,2,null],[1,"\\n\\n    "],[10,0],[14,0,"has-padding-l"],[12],[1,"\\n      "],[18,3,null],[1,"\\n      "],[18,4,null],[1,"\\n      "],[18,5,null],[1,"\\n\\n      "],[8,[39,6],null,[["@loginFields"],[[30,0,["loginFields"]]]],null],[1,"\\n\\n      "],[18,6,null],[1,"\\n\\n      "],[8,[39,7],null,[["@text","@icon"],["Sign in",[52,[28,[37,8],[[30,0,["login","isRunning"]],[30,1]],null],"loading"]]],null],[1,"\\n\\n      "],[18,7,null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["@loginTransitionIsRunning","&namespace","&back","&authSelectOptions","&error","&advancedSettings","&footer"],false,["if","okta-number-challenge","form","on","yield","div","auth/fields","auth/sign-in-button","or"]]',moduleName:"vault/components/auth/form/okta.hbs",isStrictMode:!1})
let g=e.default=(c=class extends i.default{constructor(...e){super(...e),m(this,"challengeAnswer",d,this),m(this,"oktaVerifyError",p,this),m(this,"showNumberChallenge",f,this),h(this,"loginFields",[{name:"username"},{name:"password"}]),h(this,"pollForOktaNumberChallenge",(0,n.buildTask)((()=>({context:this,generator:(0,o.waitFor)((function*(e,t){this.showNumberChallenge=!0
let n=null
for(;null===n;)yield(0,l.timeout)(1e3),n=yield this.requestOktaVerify(e,t)
this.challengeAnswer=n?.toString()??""}))})),null,"pollForOktaNumberChallenge",null))}async loginRequest(e){const{path:t,username:n,password:i}=e
await(0,l.timeout)(1e3)
const r=(0,s.default)()
this.pollForOktaNumberChallenge.perform(r,t)
const{auth:a}=await this.api.auth.oktaLogin(n,t,{nonce:r,password:i})
return this.normalizeAuthResponse(a,{authMountPath:t,displayName:a?.metadata?.username,token:a.client_token,ttl:a.lease_duration})}async requestOktaVerify(e,t){try{const{data:n}=await this.api.auth.oktaVerify(e,t)
return n.correct_answer}catch(n){const{status:e,message:t}=await this.api.parseError(n)
return 404===e?null:void(this.oktaVerifyError=t)}}cancelLogin(){this.challengeAnswer="",this.oktaVerifyError="",this.showNumberChallenge=!1,this.pollForOktaNumberChallenge.cancelAll(),this.login.cancelAll()}},d=b(c.prototype,"challengeAnswer",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p=b(c.prototype,"oktaVerifyError",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f=b(c.prototype,"showNumberChallenge",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),b(c.prototype,"requestOktaVerify",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"requestOktaVerify"),c.prototype),b(c.prototype,"cancelLogin",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"cancelLogin"),c.prototype),c);(0,t.setComponentTemplate)(y,g)})),define("vault/components/auth/form/radius",["exports","vault/components/auth/form/base"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),n(this,"loginFields",[{name:"username"},{name:"password"}])}async loginRequest(e){const{path:t,username:n,password:i}=e,{auth:r}=await this.api.auth.radiusLoginWithUsername(n,t,{password:i})
return this.normalizeAuthResponse(r,{authMountPath:t,displayName:r?.metadata?.username,token:r.client_token,ttl:r.lease_duration})}}e.default=i})),define("vault/components/auth/form/saml",["exports","@ember/component","ember-concurrency/async-arrow-runtime","vault/components/auth/form/base","ember","vault/utils/path-encoding-helpers","@hashicorp/vault-client-typescript","core/utils/sanitize-path","ember-concurrency","core/utils/uuid","vault/utils/auth-form-helpers","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c,d){function p(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,d.createTemplateFactory)({id:"GUu6zG0F",block:'[[[1,"\\n"],[11,"form"],[4,[38,1],["submit",[30,0,["onSubmit"]]],null],[12],[1,"\\n\\n  "],[18,4,null],[1,"\\n\\n  "],[10,0],[14,0,"has-padding-l"],[12],[1,"\\n    "],[18,5,null],[1,"\\n    "],[18,6,null],[1,"\\n    "],[18,7,null],[1,"\\n\\n"],[41,[30,0,["canLoginSaml"]],[[[1,"      "],[8,[39,5],null,[["@loginFields","@formQueryParams"],[[30,0,["loginFields"]],[30,1]]],null],[1,"\\n\\n      "],[18,8,null],[1,"\\n\\n      "],[8,[39,6],null,[["@text","@icon"],["Sign in with SAML provider",[52,[28,[37,7],[[30,0,["login","isRunning"]],[30,2]],null],"loading"]]],null],[1,"\\n\\n"]],[]],[[[1,"      "],[8,[39,8],[[24,0,"has-bottom-margin-m"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n        "],[8,[30,3,["Title"]],null,null,[["default"],[[[[1,"Insecure context detected"]],[]]]]],[1,"\\n        "],[8,[30,3,["Description"]],null,null,[["default"],[[[[1,"\\n          Logging in with a SAML auth method requires a browser in a secure context.\\n        "]],[]]]]],[1,"\\n        "],[8,[30,3,["Description"]],[[24,0,"has-top-margin-xs"]],null,[["default"],[[[[1,"\\n          "],[8,[39,9],null,[["@icon","@text","@href"],["external-link","Read more about secure contexts.","https://developer.mozilla.org/en-US/docs/Web/Security/Secure_Contexts"]],null],[1,"\\n        "]],[]]]]],[1,"\\n      "]],[3]]]]],[1,"\\n"]],[]]],[1,"\\n    "],[18,9,null],[1,"\\n  "],[13],[1,"\\n"],[13]],["@formQueryParams","@loginTransitionIsRunning","A","&namespace","&back","&authSelectOptions","&error","&advancedSettings","&footer"],false,["form","on","yield","div","if","auth/fields","auth/sign-in-button","or","hds/alert","hds/link/standalone"]]',moduleName:"vault/components/auth/form/saml.hbs",isStrictMode:!1})
class m extends i.default{constructor(...e){super(...e),p(this,"loginFields",[{name:"role",helperText:"Vault will use the default role to sign in if this field is left blank."}]),p(this,"watchPopup",(0,n.buildTask)((()=>({context:this,generator:function*(e){for(;;){const t=r.default.testing?50:500
if(yield(0,s.timeout)(t),!e||e.closed)return void this.onError(c.ERROR_WINDOW_CLOSED)}}})),null,"watchPopup",null)),p(this,"watchCurrent",(0,n.buildTask)((()=>({context:this,generator:function*(e){yield(0,s.waitForEvent)(window,"beforeunload"),e?.close()}})),null,"watchCurrent",null))}get canLoginSaml(){return window.isSecureContext}async loginRequest(e){const{namespace:t,path:n,role:i}=e,r=await this.fetchSamlRole({namespace:t,path:n,role:i}),l=await this.startSAMLAuth(r.sso_service_url)
if(!l)throw`Failed to open SAML popup window. ${c.ERROR_POPUP_FAILED}`
try{this.watchPopup.perform(l),this.watchCurrent.perform(l)
const{auth:e}=await this.exchangeSAMLTokenPollID(r,{path:n})
return this.normalizeAuthResponse(e,{authMountPath:n,token:e.client_token,ttl:e.lease_duration})}finally{this.closeWindow(l)}}cancelLogin(){this.login.cancelAll()}async fetchSamlRole({namespace:e="",path:t="",role:n=""}){const i=(0,u.default)(),r=await this.generateClientChallenge(i),l=this.generateAcsUrl(t,e),o=a.SamlWriteSsoServiceUrlRequestClientTypeEnum.BROWSER,{data:s}=await this.api.auth.samlWriteSsoServiceUrl(t,{acs_url:l,client_challenge:r,client_type:o,role:n})
return{...s,client_verifier:i}}async startSAMLAuth(e){const t=window,n=t.screen.width/2-250,i=t.screen.height/2-300
return t.open(e,"vaultSAMLWindow",`width=500,height=600,resizable,scrollbars=yes,top=${i},left=${n}`)}async exchangeSAMLTokenPollID(e,{path:t=""}){const n=r.default.testing?50:1e3,i=r.default.testing?3:180
for(let r=0;r<i;r++){await(0,s.timeout)(n)
try{const{client_verifier:n,token_poll_id:i}=e
return await this.api.auth.samlWriteToken(t,{client_verifier:n,token_poll_id:i})}catch(l){const{message:e,status:t}=await this.api.parseError(l)
if(401===t)continue
throw e}}throw c.ERROR_TIMEOUT}closeWindow(e){this.watchPopup.cancelAll(),this.watchCurrent.cancelAll(),e.close()}async generateClientChallenge(e){const t=(new TextEncoder).encode(e),n=await crypto.subtle.digest("SHA-256",t),i=new Uint8Array(n)
return btoa(String.fromCharCode(...i))}generateAcsUrl(e,t){return`${`${window.location.origin}/v1`}/${t?`${(0,l.encodePath)((0,o.sanitizePath)(t))}/`:""}auth/${(0,l.encodePath)((0,o.sanitizePath)(e))}/callback`}}e.default=m,(0,t.setComponentTemplate)(f,m)})),define("vault/components/auth/form/token",["exports","vault/components/auth/form/base"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),n(this,"loginFields",[{name:"token"}])}async loginRequest(e){const{token:t}=e,{data:n}=await this.api.auth.tokenLookUpSelf(this.api.buildHeaders({token:t}))
return this.normalizeAuthResponse(n,{authMountPath:"",token:n.id,ttl:n.ttl})}}e.default=i})),define("vault/components/auth/form/userpass",["exports","vault/components/auth/form/base"],(function(e,t){function n(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class i extends t.default{constructor(...e){super(...e),n(this,"loginFields",[{name:"username"},{name:"password"}])}async loginRequest(e){const{path:t,username:n,password:i}=e,{auth:r}=await this.api.auth.userpassLogin(n,t,{password:i})
return this.normalizeAuthResponse(r,{authMountPath:t,displayName:r?.metadata?.username,token:r.client_token,ttl:r.lease_duration})}}e.default=i})),define("vault/components/auth/namespace-input",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@glimmer/component","@ember/object","core/utils/sanitize-path","ember-concurrency","@ember/service","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d
function p(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function f(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function m(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h=(0,s.createTemplateFactory)({id:"oQm0warw",block:'[[[1,"\\n"],[10,0],[14,0,"background-neutral-50 has-padding-l"],[12],[1,"\\n"],[41,[30,0,["flags","hvdManagedNamespaceRoot"]],[[[1,"    "],[8,[39,2],[[16,"disabled",[30,1]]],[["@layout"],["vertical"]],[["default"],[[[[1,"\\n      "],[8,[30,2,["Label"]],null,null,[["default"],[[[[1,"Namespace"]],[]]]]],[1,"\\n      "],[8,[30,2,["Control"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,3],[[24,0,"is-fullwidth"]],null,[["default"],[[[[1,"\\n          "],[8,[30,3,["TextInput"]],[[24,"aria-label","Root namespace for H-C-P managed cluster"],[24,0,"one-fourth-width"],[24,3,"hvd-root-namespace"],[24,"readonly",""]],[["@type","@value"],["text",[29,["/",[30,0,["flags","hvdManagedNamespaceRoot"]]]]]],null],[1,"\\n          "],[8,[30,3,["TextInput"]],[[24,"autocomplete","off"],[16,"disabled",[30,1]],[24,3,"namespace"],[24,"placeholder","/ (default)"],[4,[38,4],["input",[30,0,["handleInput"]]],null],[4,[38,5],[[30,0,["maybeRefocus"]]],null]],[["@value"],[[30,0,["namespaceInput"]]]],null],[1,"\\n        "]],[3]]]]],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[2]]]]],[1,"\\n"]],[]],[[[1,"    "],[8,[39,6],[[24,"autocomplete","off"],[16,"disabled",[30,1]],[24,3,"namespace"],[24,"placeholder","/ (root)"],[4,[38,4],["input",[30,0,["handleInput"]]],null],[4,[38,5],[[30,0,["maybeRefocus"]]],null]],[["@value"],[[30,0,["namespaceInput"]]]],[["default"],[[[[1,"\\n      "],[8,[30,4,["Label"]],null,null,[["default"],[[[[1,"Namespace"]],[]]]]],[1,"\\n    "]],[4]]]]],[1,"\\n"]],[]]],[13]],["@disabled","F","SG","F"],false,["div","if","hds/form/field","hds/segmented-group","on","did-insert","hds/form/text-input/field"]]',moduleName:"vault/components/auth/namespace-input.hbs",isStrictMode:!1})
let b=e.default=(u=class extends i.default{constructor(...e){super(...e),p(this,"api",c,this),p(this,"flags",d,this),f(this,"updateNamespace",(0,n.buildTask)((()=>({context:this,generator:function*(e){yield(0,a.timeout)(500),yield this.args.handleNamespaceUpdate(e)}})),null,"updateNamespace","restartable"))}get namespaceInput(){const e=this.args.namespaceQueryParam
if(this.flags.hvdManagedNamespaceRoot){const t=(0,l.getRelativePath)(e,this.flags.hvdManagedNamespaceRoot)
return t?`/${t}`:""}return e}async handleInput(e){const t=e.target.value
this.updateNamespace.perform(t)}maybeRefocus(e){this.args.shouldRefocusNamespaceInput&&e.focus()}},c=m(u.prototype,"api",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(u.prototype,"flags",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m(u.prototype,"handleInput",[r.action],Object.getOwnPropertyDescriptor(u.prototype,"handleInput"),u.prototype),m(u.prototype,"maybeRefocus",[r.action],Object.getOwnPropertyDescriptor(u.prototype,"maybeRefocus"),u.prototype),u);(0,t.setComponentTemplate)(h,b)})),define("vault/components/auth/page",["exports","@ember/component","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u,c,d,p
function f(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function m(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.CSP_ERROR=void 0
const h=(0,a.createTemplateFactory)({id:"G200sdJ+",block:'[[[1,"\\n"],[41,[30,0,["cspError"]],[[[1,"  "],[8,[39,1],null,[["@type","@color"],["page","critical"]],[["default"],[[[[1,"\\n    "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,[30,0,["cspError"]]]],[]]]]],[1,"\\n  "]],[1]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,0,["mfaAuthData"]],[[[1,"  "],[8,[39,2],null,[["@authData","@clusterId","@loginAndTransition","@onCancel"],[[30,0,["mfaAuthData"]],[30,2,["id"]],[30,3],[30,0,["onCancelMfa"]]]],null],[1,"\\n"]],[]],[[[1,"  "],[8,[39,3],null,null,[["header","content","footer"],[[[[1,"\\n"],[41,[30,4],[[[1,"        "],[10,0],[14,0,"box is-shadowless is-flex-v-centered"],[12],[1,"\\n          "],[8,[39,6],[[24,"aria-label","Sign in with Hashicorp Vault"],[24,"role","img"]],null,null],[1,"\\n        "],[13],[1,"\\n"]],[]],[[[1,"        "],[10,0],[14,0,"is-flex-v-centered has-bottom-margin-xxl"],[12],[1,"\\n          "],[10,0],[14,0,"brand-icon-large"],[12],[1,"\\n            "],[8,[39,7],null,[["@name","@size","@stretched"],["vault","24",true]],null],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n        "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n          Sign in to Vault\\n        "],[13],[1,"\\n"]],[]]],[1,"    "]],[]],[[[1,"\\n      "],[8,[39,10],null,[["@alternateView","@cluster","@defaultView","@formQueryParams","@handleAuthResponse","@initialFormState","@loginTransitionIsRunning","@visibleMountTypes"],[[30,0,["formViews","alternateView"]],[30,2],[30,0,["formViews","defaultView"]],[30,0,["formQueryParams"]],[30,0,["onAuthResponse"]],[30,0,["initialFormState"]],[30,3,["isRunning"]],[30,0,["visibleMountTypes"]]]],[["default"],[[[[1,"\\n"],[41,[28,[37,11],["Namespaces"],null],[[[1,"          "],[8,[39,12],null,[["@disabled","@handleNamespaceUpdate","@namespaceQueryParam","@shouldRefocusNamespaceInput"],[[52,[30,4],true,false],[30,5],[30,6],[30,7]]],null],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n    "]],[]],[[[1,"\\n      "],[10,0],[14,0,"has-short-padding"],[12],[1,"\\n        "],[10,2],[14,0,"help has-text-grey-dark"],[12],[1,"\\n"],[41,[30,4],[[[1,"            Once you log in, you will be redirected back to your application. If you require login credentials, contact your\\n            administrator.\\n"]],[]],[[[1,"            Contact your administrator for login credentials.\\n"]],[]]],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]]],["A","@cluster","@loginAndTransition","@oidcProviderQueryParam","@onNamespaceUpdate","@namespaceQueryParam","@shouldRefocusNamespaceInput"],false,["if","hds/alert","mfa/mfa-form","splash-page",":header","div","logo-edition","icon","h1",":content","auth/form-template","has-feature","auth/namespace-input",":footer","p"]]',moduleName:"vault/components/auth/page.hbs",isStrictMode:!1}),b=e.CSP_ERROR="This is a standby Vault node but can't communicate with the active node via request forwarding. Sign in at the active node to use the Vault UI."
var y=function(e){return e.DROPDOWN="dropdown",e.TABS="tabs",e}(y||{})
let g=e.default=(o=(0,i.service)("csp-event"),s=class extends n.default{constructor(...e){super(...e),f(this,"auth",u,this),f(this,"csp",c,this),f(this,"canceledMfaAuth",d,this),f(this,"mfaAuthData",p,this)}get cspError(){const e=this.args.cluster.standby,t=this.csp.connectionViolations.length
return e&&t?b:""}get visibleMountsByType(){const e=this.args.visibleAuthMounts
return e?e.reduce(((e,t)=>{const{methodType:n}=t
return e[n]??=[],e[n].push({...t}),e}),{}):null}get visibleMountTypes(){return Object.keys(this.visibleMountsByType||{})}get formViews(){const{directLinkData:e,loginSettings:t}=this.args
return e?this.directLinkViews:t?this.loginSettingsViews:this.visibleMountsByType?this.visibleMountViews:this.standardDropdownView}get initialAuthType(){const e=this.args.directLinkData?.type,t=Object.keys(this.formViews.defaultView?.tabData||{})[0]
return this.canceledMfaAuth||e||t||this.auth.getAuthType()||"token"}get directLinkViews(){const{directLinkData:e}=this.args
if(e?.path){const t=this.filterVisibleMountsByType([e.type])
return{defaultView:this.constructViews(y.TABS,t),alternateView:this.constructViews(y.DROPDOWN,null)}}return this.visibleMountsByType?this.visibleMountViews:this.standardDropdownView}get standardDropdownView(){return{defaultView:this.constructViews(y.DROPDOWN,null),alternateView:null}}get loginSettingsViews(){const{loginSettings:e}=this.args,t=e?.defaultType,n=e?.backupTypes,i=t?[t]:n
let r
if(i){const e=this.filterVisibleMountsByType(i)
r=this.constructViews(y.TABS,e)}let l=null
if(t&&n){const e=this.filterVisibleMountsByType(n)
l=this.constructViews(y.TABS,e)}return{defaultView:r,alternateView:l}}get visibleMountViews(){return{defaultView:this.constructViews(y.TABS,this.visibleMountsByType),alternateView:this.constructViews(y.DROPDOWN,null)}}get initialFormState(){const{defaultView:e,alternateView:t}=this.formViews,n=e=>Object.keys(e).includes(this.initialAuthType),i=!n(e?.tabData||{}),r=!!t,l=n(t?.tabData||{}),a=i&&(r||l)
return{initialAuthType:this.initialAuthType,showAlternate:a}}get formQueryParams(){return{role:this.args.roleQueryParam}}async onAuthResponse(e){const t="mfaRequirement"in e?e.mfaRequirement:void 0
if(t){const{authMethodType:n,authMountPath:i}=e,r=this.auth.parseMfaResponse(t)
this.mfaAuthData={mfaRequirement:r,authMethodType:n,authMountPath:i}}else{const t=await this.auth.authSuccess(this.args.cluster.id,e)
this.args.loginAndTransition.perform(t)}}onCancelMfa(){this.canceledMfaAuth=this.mfaAuthData?.authMethodType??"",this.mfaAuthData=null}filterVisibleMountsByType(e){const t={}
for(const n of e)t[n]=this.visibleMountsByType?.[n]||null
return t}constructViews(e,t){return{view:e,tabData:t}}},u=m(s.prototype,"auth",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"csp",[o],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(s.prototype,"canceledMfaAuth",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p=m(s.prototype,"mfaAuthData",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m(s.prototype,"onAuthResponse",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"onAuthResponse"),s.prototype),m(s.prototype,"onCancelMfa",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"onCancelMfa"),s.prototype),s);(0,t.setComponentTemplate)(h,g)})),define("vault/components/auth/sign-in-button",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"j7a1FhKQ",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-top-margin-l has-bottom-margin-l"],[24,4,"submit"]],[["@text","@icon","@isFullWidth"],[[30,1],[30,2],true]],null]],["@text","@icon"],false,["hds/button"]]',moduleName:"vault/components/auth/sign-in-button.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/auth/tabs",["exports","@ember/component","@glimmer/component","@ember/object","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l){var a,o
function s(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u=(0,l.createTemplateFactory)({id:"67AK4FFA",block:'[[[1,"\\n"],[8,[39,0],null,[["@onClickTab","@selectedTabIndex"],[[30,0,["onClickTab"]],[30,0,["selectedTabIndex"]]]],[["default"],[[[[1,"\\n"],[42,[28,[37,2],[[30,2]],null],null,[[[1,"    "],[8,[30,1,["Tab"]],null,null,[["default"],[[[[1,[28,[35,3],[[28,[37,4],[[30,4]],null],"displayName"],null]]],[]]]]],[1,"\\n    "],[8,[30,1,["Panel"]],null,null,[["default"],[[[[1,"\\n      "],[10,0],[14,0,"has-top-padding-m"],[12],[1,"\\n"],[41,[28,[37,7],[[30,3],[28,[37,8],[[30,5],[30,4]],null]],null],[[[41,[28,[37,9],[[30,3,["length"]],1],null],[[[1,"            "],[8,[39,10],[[24,3,"path"],[4,[38,11],["change",[30,0,["setMount"]]],null]],null,[["default"],[[[[1,"\\n              "],[8,[30,6,["Label"]],null,null,[["default"],[[[[1,"Mount path"]],[]]]]],[1,"\\n"],[41,[30,0,["mountDescription"]],[[[1,"                "],[8,[30,6,["HelperText"]],null,null,[["default"],[[[[1,[30,0,["mountDescription"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"              "],[8,[30,6,["Options"]],null,null,[["default"],[[[[1,"\\n"],[42,[28,[37,12],[[28,[37,12],[[30,3]],null]],null],null,[[[1,"                  "],[10,"option"],[15,2,[30,7,["path"]]],[15,"selected",[28,[37,8],[[30,7,["path"]],[30,0,["selectedMountPath"]]],null]],[12],[1,[30,7,["path"]]],[13],[1,"\\n"]],[7]],null],[1,"              "]],[]]]]],[1,"\\n            "]],[6]]]]],[1,"\\n"]],[]],[[[44,[[28,[37,3],[[30,3],"0"],null]],[[[41,[30,8,["description"]],[[[1,"                "],[8,[39,15],[[24,0,"white-space-pre-line"]],[["@tag","@color"],["p","faint"]],[["default"],[[[[1,[30,8,["description"]]]],[]]]]],[1,"\\n"]],[]],null],[41,[28,[37,16],[[30,5],"token"],null],[[[1,"                "],[10,"input"],[14,1,"path"],[14,3,"path"],[15,2,[30,8,["path"]]],[14,4,"hidden"],[12],[13],[1,"\\n"]],[]],null]],[8]]]],[]]]],[]],null],[1,"      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n"]],[3,4]],null]],[1]]]]]],["T","@authTabData","mounts","methodType","@selectedAuthMethod","F","mount","mount"],false,["hds/tabs","each","-each-in","get","engines-display-data","div","if","and","eq","gt","hds/form/select/field","on","-track-array","option","let","hds/text/body","not-eq","input"]]',moduleName:"vault/components/auth/tabs.hbs",isStrictMode:!1})
let c=e.default=(a=class extends n.default{constructor(e,t){var n,i,r,l
super(e,t),n=this,i="selectedMountPath",l=this,(r=o)&&Object.defineProperty(n,i,{enumerable:r.enumerable,configurable:r.configurable,writable:r.writable,value:r.initializer?r.initializer.call(l):void 0}),this.setSelectedMountPath()}get mountDescription(){const e=this.args.selectedAuthMethod,t=this.args.authTabData[e],n=t?.find((e=>e.path===this.selectedMountPath))
return n?.description??""}get tabTypes(){return this.args.authTabData?Object.keys(this.args.authTabData):[]}get selectedTabIndex(){const e=this.tabTypes.indexOf(this.args.selectedAuthMethod)
return e<0?0:e}onClickTab(e,t){const n=this.tabTypes[t]
this.args.handleTabClick(n),this.setSelectedMountPath()}setMount(e){this.selectedMountPath=e.target.value}setSelectedMountPath(){const e=this.args.authTabData[this.args.selectedAuthMethod],t=e?.length?e[0]:null
this.selectedMountPath=t?.path??""}},o=s(a.prototype,"selectedMountPath",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),s(a.prototype,"onClickTab",[i.action],Object.getOwnPropertyDescriptor(a.prototype,"onClickTab"),a.prototype),s(a.prototype,"setMount",[i.action],Object.getOwnPropertyDescriptor(a.prototype,"setMount"),a.prototype),a);(0,t.setComponentTemplate)(u,c)})),define("vault/components/autocomplete-input",["exports","core/components/autocomplete-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/b64-toggle",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","@ember/utils","core/utils/b64","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,o.createTemplateFactory)({id:"8r0CpPnB",block:'[[[1,"\\n"],[11,"button"],[24,4,"button"],[16,0,[29,["button b64-toggle ",[52,[30,1],"is-input","is-textarea"]]]],[17,2],[4,[38,2],["click",[30,0,["handleClick"]]],null],[12],[1,"\\n"],[41,[30,0,["isBase64"]],[[[1,"    Decode from base64\\n"]],[]],[[[1,"    Encode to base64\\n"]],[]]],[13]],["@isInput","&attrs"],false,["button","if","on"]]',moduleName:"vault/components/b64-toggle.hbs",isStrictMode:!1}),m="base64",h="utf-8"
let b=e.default=(s=class extends n.default{get valuesMatch(){return!(0,l.isBlank)(this.args.value)&&!(0,l.isBlank)(this._b64Value)&&this.args.value===this._b64Value}get currentEncoding(){return(0,l.isBlank)(this.args.value)?h:this.valuesMatch?m:h}constructor(e,t){super(e,t),d(this,"_value",u,this),d(this,"_b64Value",c,this),this.initialEncoding&&this.initialEncoding===m&&(this._b64Value=this.args.value)}get initialEncoding(){return this.args.initialEncoding||h}get isBase64(){return this.currentEncoding===m}handleClick(){const e=this.args.value,t=this.currentEncoding===h
if(!e)return
const n=t?(0,a.encodeString)(e):(0,a.decodeString)(e)
t&&(this._b64Value=n),this._value=n,this.args.onUpdate&&this.args.onUpdate(n)}},u=p(s.prototype,"_value",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),c=p(s.prototype,"_b64Value",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p(s.prototype,"handleClick",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"handleClick"),s.prototype),s);(0,t.setComponentTemplate)(f,b)})),define("vault/components/basic-dropdown-content",["exports","ember-basic-dropdown/components/basic-dropdown-content"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/basic-dropdown-trigger",["exports","ember-basic-dropdown/components/basic-dropdown-trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/basic-dropdown-wormhole",["exports","ember-basic-dropdown/components/basic-dropdown-wormhole"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/basic-dropdown",["exports","ember-basic-dropdown/components/basic-dropdown"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/calendar-widget",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"V4SqZDjm",block:'[[[1,"\\n"],[8,[39,0],null,[["@class","@horizontalPosition","@verticalPosition"],["popup-menu","auto-right","below"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["Trigger"]],[[16,0,[28,[37,1],["toolbar-link",[52,[30,1,["isOpen"]]," is-active"]],null]]],[["@htmlTag"],["button"]],[["default"],[[[[1,"\\n    "],[1,[28,[35,3],[[30,0,["startDate"]],"MMM yyyy"],null]],[1,"\\n    -\\n    "],[1,[28,[35,3],[[30,0,["endDate"]],"MMM yyyy"],null]],[1,"\\n    "],[8,[39,4],null,[["@direction","@isButton"],["down",true]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["Content"]],null,[["@defaultClass"],[[28,[37,1],["popup-menu-content calendar-content",[52,[30,0,["showCalendar"]]," calendar-open"]],null]]],[["default"],[[[[1,"\\n    "],[10,"nav"],[14,0,"box menu"],[14,"aria-label","calendar date selector navigation"],[12],[1,"\\n      "],[8,[39,6],[[24,0,"calendar-title"]],[["@color"],["faint"]],[["default"],[[[[1,"DATE OPTIONS"]],[]]]]],[1,"\\n"],[1,"      "],[10,"ul"],[14,0,"menu-list"],[12],[1,"\\n        "],[10,"li"],[12],[1,"\\n          "],[11,"button"],[24,0,"link is-no-underline has-text-weight-semibold is-ghost"],[24,3,"currentMonth"],[24,4,"button"],[4,[38,10],["click",[28,[37,11],[[30,0,["handleDateShortcut"]],[30,1,["actions"]]],null]],null],[12],[1,"\\n            Current month\\n          "],[13],[1,"\\n        "],[13],[1,"\\n        "],[10,"li"],[12],[1,"\\n          "],[11,"button"],[24,0,"link is-no-underline has-text-weight-semibold is-ghost"],[24,3,"reset"],[24,4,"button"],[4,[38,10],["click",[28,[37,11],[[30,0,["handleDateShortcut"]],[30,1,["actions"]]],null]],null],[12],[1,"\\n            Current billing period\\n          "],[13],[1,"\\n        "],[13],[1,"\\n        "],[10,"li"],[12],[1,"\\n          "],[11,"button"],[16,0,[28,[37,1],["link is-no-underline has-text-weight-semibold is-ghost",[52,[30,0,["showCalendar"]]," is-active"]],null]],[24,4,"button"],[4,[38,10],["click",[30,0,["toggleShowCalendar"]]],null],[12],[1,"\\n            "],[10,0],[14,0,"level is-mobile"],[12],[1,"\\n              "],[10,1],[14,0,"level-left"],[12],[1,"\\n                Custom end month\\n              "],[13],[1,"\\n              "],[8,[39,4],[[24,0,"has-text-grey-light level-right"]],null,null],[1,"\\n            "],[13],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"],[41,[30,0,["showCalendar"]],[[[1,"      "],[10,0],[14,0,"calendar-widget-container"],[12],[1,"\\n        "],[10,0],[14,0,"select-year"],[12],[1,"\\n"],[41,[30,0,["disablePastYear"]],[[[1,"            "],[8,[39,14],[[24,"aria-label","More information about why previous year is disabled"]],[["@text"],[[28,[37,1],[[28,[37,15],[[30,0,["displayYear"]],1],null]," is unavailable because it is before your start date. Change your start month to a date in ",[28,[37,15],[[30,0,["displayYear"]],1],null]," to see data for this year."],null]]],[["default"],[[[[1,"\\n              "],[8,[39,16],[[24,1,"previous-year"],[16,"disabled",true],[4,[38,10],["click",[30,0,["subYear"]]],null]],[["@color","@text","@icon","@isIconOnly"],["secondary","previous year","chevron-left",true]],null],[1,"\\n            "]],[]]]]],[1,"\\n"]],[]],[[[1,"            "],[8,[39,16],[[24,1,"previous-year"],[4,[38,10],["click",[30,0,["subYear"]]],null]],[["@color","@text","@icon","@isIconOnly"],["secondary","previous year","chevron-left",true]],null],[1,"\\n"]],[]]],[1,"\\n          "],[8,[39,17],null,null,[["default"],[[[[1,"\\n            "],[1,[30,0,["displayYear"]]],[1,"\\n          "]],[]]]]],[1,"\\n\\n"],[41,[30,0,["disableFutureYear"]],[[[1,"            "],[8,[39,14],[[24,"aria-label","More information about why next year is disabled"]],[["@text"],[[28,[37,1],[[28,[37,18],[[30,0,["displayYear"]],1],null]," is unavailable because data is only available up to the current month."],null]]],[["default"],[[[[1,"\\n              "],[8,[39,16],[[24,1,"next-year"],[16,"disabled",true],[4,[38,10],["click",[30,0,["addYear"]]],null]],[["@color","@text","@icon","@isIconOnly"],["secondary","next year","chevron-right",true]],null],[1,"\\n            "]],[]]]]],[1,"\\n"]],[]],[[[1,"            "],[8,[39,16],[[24,1,"next-year"],[4,[38,10],["click",[30,0,["addYear"]]],null]],[["@color","@text","@icon","@isIconOnly"],["secondary","next year","chevron-right",true]],null],[1,"\\n"]],[]]],[1,"        "],[13],[1,"\\n        "],[10,0],[14,0,"calendar-widget-grid calendar-widget"],[12],[1,"\\n"],[42,[28,[37,20],[[28,[37,20],[[30,0,["widgetMonths"]]],null]],null],null,[[[1,"            "],[8,[39,16],[[16,"disabled",[30,2,["readonly"]]],[16,1,[30,2,["index"]]],[4,[38,10],["click",[28,[37,11],[[30,0,["selectMonth"]],[30,2],[30,1,["actions"]]],null]],null]],[["@text","@color","@size"],[[30,2,["name"]],"secondary","small"]],null],[1,"\\n"]],[2]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"]],[1]]]]]],["D","month"],false,["basic-dropdown","concat","if","date-format","chevron","nav","hds/text/body","ul","li","button","on","fn","div","span","hds/tooltip-button","sub","hds/button","hds/text/display","add","each","-track-array"]]',moduleName:"vault/components/calendar-widget.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/certificate-card",["exports","core/components/certificate-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/checkbox-grid",["exports","core/components/checkbox-grid"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/chevron",["exports","core/components/chevron"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/choose-pgp-key-form",["exports","core/components/choose-pgp-key-form"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/clients/charts/vertical-bar-basic",["exports","@ember/component","@glimmer/component","@glimmer/tracking","vault/utils/chart-helpers","core/helpers/format-number","core/utils/date-formatters","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u
function c(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d=(0,o.createTemplateFactory)({id:"yKSMTBYa",block:'[[[1,"\\n"],[10,0],[14,0,"lineal-chart"],[12],[1,"\\n  "],[8,[39,1],null,null,[["default"],[[[[1,"\\n"],[44,[[28,[37,3],null,[["domain","range","padding"],[[30,0,["xDomain"]],[28,[37,4],[0,[30,1]],null],0.1]]],[28,[37,5],null,[["range","domain"],[[28,[37,4],[[30,0,["chartHeight"]],0],null],[30,0,["yDomain"]]]]],[28,[37,5],null,[["range","domain"],[[28,[37,4],[0,[30,0,["chartHeight"]]],null],[30,0,["yDomain"]]]]]],[[[1,"      "],[10,"svg"],[15,"width",[30,1]],[15,"height",[30,0,["chartHeight"]]],[12],[1,"\\n        "],[10,"title"],[12],[1,[30,5]],[13],[1,"\\n\\n"],[41,[28,[37,9],[[30,2,["isValid"]],[30,3,["isValid"]]],null],[[[1,"          "],[8,[39,10],[[24,0,"lineal-axis"]],[["@scale","@tickCount","@tickPadding","@tickSizeInner","@tickFormat","@orientation","@includeDomain"],[[30,3],"4",10,[28,[37,11],["-",[30,1]],null],[30,0,["formatTicksY"]],"left",false]],null],[1,"\\n          "],[8,[39,10],[[16,"transform",[29,["translate(0,",[30,3,["range","min"]],")"]]],[24,0,"lineal-axis"]],[["@scale","@orientation","@includeDomain","@tickSize","@tickPadding"],[[30,2],"bottom",false,"0",10]],null],[1,"\\n"]],[]],null],[1,"        "],[8,[39,12],[[16,"transform",[29,["translate(",[28,[30,0,["barOffset"]],[[30,2,["bandwidth"]]],null],",0)"]]],[24,"fill","transparent"],[24,"stroke","transparent"],[24,0,"lineal-chart-bar"]],[["@data","@x","@y","@height","@width","@xScale","@yScale","@heightScale"],[[30,0,["chartData"]],"x","y","y",[30,0,["barWidth"]],[30,2],[30,3],[30,4]]],null],[1,"\\n"],[41,[28,[37,9],[[30,2,["isValid"]],[30,3,["isValid"]]],null],[[[42,[28,[37,14],[[28,[37,14],[[30,0,["chartData"]]],null]],null],null,[[[1,"            "],[11,"rect"],[24,"role","button"],[16,"aria-label",[29,["Show exact counts for ",[30,6,["legendX"]]]]],[24,"x","0"],[24,"y","0"],[16,"height",[30,0,["chartHeight"]]],[16,"width",[30,2,["bandwidth"]]],[24,"fill","transparent"],[24,"stroke","transparent"],[16,"transform",[29,["translate(",[28,[30,2,["compute"]],[[30,6,["x"]]],null],")"]]],[4,[38,16],["mouseover",[28,[37,17],[[28,[37,18],[[30,0,["activeDatum"]]],null],[30,6]],null]],null],[4,[38,16],["mouseout",[28,[37,17],[[28,[37,18],[[30,0,["activeDatum"]]],null],null],null]],null],[12],[13],[1,"\\n"]],[6]],null]],[]],null],[1,"      "],[13],[1,"\\n"],[41,[30,0,["activeDatum"]],[[[1,"        "],[11,0],[24,0,"chart-tooltip"],[24,"role","status"],[4,[38,19],null,[["--x","--y"],[[28,[30,0,["tooltipX"]],[[28,[30,2,["compute"]],[[30,0,["activeDatum","x"]]],null],[30,2,["bandwidth"]]],null],[28,[30,0,["tooltipY"]],[[28,[30,4,["compute"]],[[30,0,["activeDatum","y"]]],null]],null]]]],[12],[1,"\\n          "],[10,0],[12],[1,"\\n            "],[10,2],[14,0,"bold"],[12],[1,[30,0,["activeDatum","legendX"]]],[13],[1,"\\n            "],[10,2],[12],[1,[30,0,["activeDatum","tooltip"]]],[13],[1,"\\n          "],[13],[1,"\\n          "],[10,0],[14,0,"chart-tooltip-arrow"],[12],[13],[1,"\\n        "],[13],[1,"\\n"]],[]],null]],[2,3,4]]],[1,"  "]],[1]]]]],[1,"\\n"],[13],[1,"\\n"],[41,[30,7],[[[1,"  "],[10,"details"],[12],[1,"\\n    "],[10,"summary"],[12],[1,"Underlying data"],[13],[1,"\\n    "],[8,[39,23],null,[["@caption"],["Underlying data"]],[["head","body"],[[[[1,"\\n        "],[8,[30,8,["Tr"]],null,null,[["default"],[[[[1,"\\n          "],[8,[30,8,["Th"]],null,null,[["default"],[[[[1,"Month"]],[]]]]],[1,"\\n          "],[8,[30,8,["Th"]],null,null,[["default"],[[[[1,[52,[30,9],[28,[37,25],[[30,9]],null]]],[1," Count"]],[]]]]],[1,"\\n        "]],[]]]]],[1,"\\n      "]],[8]],[[[1,"\\n"],[42,[28,[37,14],[[28,[37,14],[[30,0,["chartData"]]],null]],null],null,[[[1,"          "],[8,[30,10,["Tr"]],null,null,[["default"],[[[[1,"\\n            "],[8,[30,10,["Td"]],null,null,[["default"],[[[[1,[30,11,["legendX"]]]],[]]]]],[1,"\\n            "],[8,[30,10,["Td"]],null,null,[["default"],[[[[1,[30,11,["legendY"]]]],[]]]]],[1,"\\n          "]],[]]]]],[1,"\\n"]],[11]],null],[1,"      "]],[10]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],null]],["width","xScale","yScale","hScale","@chartTitle","d","@showTable","H","@dataKey","B","row"],false,["div","lineal/fluid","let","scale-band","array","scale-linear","svg","title","if","and","lineal/axis","concat","lineal/bars","each","-track-array","rect","on","fn","mut","style","p","details","summary","hds/table",":head","humanize",":body"]]',moduleName:"vault/components/clients/charts/vertical-bar-basic.hbs",isStrictMode:!1})
let p=e.default=(s=class extends n.default{constructor(...e){var t,n,i,l
super(...e),c(this,"barWidth",r.BAR_WIDTH),t=this,n="activeDatum",l=this,(i=u)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(l):void 0}),c(this,"barOffset",(e=>(e-this.barWidth)/2)),c(this,"tooltipX",((e,t)=>(e+t/2).toString())),c(this,"tooltipY",(e=>e?`${e}`:"0")),c(this,"formatTicksY",(e=>(0,r.numericalAxisLabel)(e)||e.toString()))}get chartHeight(){return this.args.chartHeight||190}get chartData(){return this.args.data.map((e=>{const t=e.timestamp,n=e[this.args.dataKey]??null
return{x:(0,a.parseAPITimestamp)(t,"M/yy"),y:n,tooltip:null===n?"No data":`${(0,l.formatNumber)([n])} ${this.args.dataKey.replace(/_/g," ")}`,legendX:(0,a.parseAPITimestamp)(t,"MMMM yyyy"),legendY:(n??"No data").toString()}}))}get yDomain(){const e=this.chartData.map((e=>e.y)).flatMap((e=>"number"==typeof e?[e]:[])),t=Math.max(...e)
return[0,t<=4?4:t]}get xDomain(){const e=this.chartData.map((e=>e.x))
return new Set(e)}},f=s.prototype,m="activeDatum",h=[i.tracked],b={configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}},g={},Object.keys(b).forEach((function(e){g[e]=b[e]})),g.enumerable=!!g.enumerable,g.configurable=!!g.configurable,("value"in g||g.initializer)&&(g.writable=!0),g=h.slice().reverse().reduce((function(e,t){return t(f,m,e)||e}),g),y&&void 0!==g.initializer&&(g.value=g.initializer?g.initializer.call(y):void 0,g.initializer=void 0),u=void 0===g.initializer?(Object.defineProperty(f,m,g),null):g,s)
var f,m,h,b,y,g;(0,t.setComponentTemplate)(d,p)})),define("vault/components/clients/charts/vertical-bar-stacked",["exports","@ember/component","@glimmer/component","@glimmer/tracking","vault/utils/chart-helpers","core/helpers/format-number","core/utils/date-formatters","d3-array","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c
function d(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,s.createTemplateFactory)({id:"gUaOvZuh",block:'[[[1,"\\n"],[10,0],[14,0,"lineal-chart"],[12],[1,"\\n  "],[8,[39,1],null,null,[["default"],[[[[1,"\\n"],[44,[[28,[37,3],null,[["domain","range","padding"],[[30,0,["xBounds"]],[28,[37,4],[0,[30,1]],null],0.1]]],[28,[37,5],null,[["range","domain"],[[28,[37,4],[[30,0,["chartHeight"]],0],null],[30,0,["yBounds"]]]]],[28,[37,5],null,[["range","domain"],[[28,[37,4],[0,[30,0,["chartHeight"]]],null],[30,0,["yBounds"]]]]]],[[[1,"      "],[10,"svg"],[15,"width",[30,1]],[15,"height",[30,0,["chartHeight"]]],[12],[1,"\\n        "],[10,"title"],[12],[1,[30,5]],[13],[1,"\\n\\n"],[41,[28,[37,9],[[30,2,["isValid"]],[30,3,["isValid"]]],null],[[[1,"          "],[8,[39,10],[[24,0,"lineal-axis"]],[["@includeDomain","@orientation","@scale","@tickCount","@tickFormat","@tickPadding","@tickSizeInner"],[false,"left",[30,3],"4",[30,0,["formatTicksY"]],10,[28,[37,11],["-",[30,1]],null]]],null],[1,"\\n          "],[8,[39,10],[[24,0,"lineal-axis"],[16,"transform",[29,["translate(0,",[30,3,["range","min"]],")"]]]],[["@includeDomain","@orientation","@scale","@tickFormat","@tickPadding","@tickSize"],[false,"bottom",[30,2],[30,0,["formatTicksX"]],10,"0"]],null],[1,"\\n"]],[]],null],[1,"\\n        "],[8,[39,12],[[16,"transform",[29,["translate(",[28,[30,0,["barOffset"]],[[30,2,["bandwidth"]]],null],",0)"]]]],[["@data","@x","@y","@width","@xScale","@yScale","@color","@colorScale"],[[30,0,["chartData"]],"timestamp","counts",[30,0,["barWidth"]],[30,2],[30,3],"clientType","stacked-bar"]],null],[1,"\\n\\n"],[41,[28,[37,9],[[30,2,["isValid"]],[30,3,["isValid"]]],null],[[[42,[28,[37,14],[[28,[37,14],[[30,0,["aggregatedData"]]],null]],null],null,[[[1,"            "],[11,"rect"],[24,"role","button"],[16,"aria-label",[29,["Show exact counts for ",[30,6,["legendX"]]]]],[24,"x","0"],[24,"y","0"],[16,"height",[30,0,["chartHeight"]]],[16,"width",[30,2,["bandwidth"]]],[24,"fill","transparent"],[24,"stroke","transparent"],[16,"transform",[29,["translate(",[28,[30,2,["compute"]],[[30,6,["x"]]],null],")"]]],[4,[38,16],["mouseover",[28,[37,17],[[28,[37,18],[[30,0,["activeDatum"]]],null],[30,6]],null]],null],[4,[38,16],["mouseout",[28,[37,17],[[28,[37,18],[[30,0,["activeDatum"]]],null],null],null]],null],[12],[13],[1,"\\n"]],[6]],null]],[]],null],[1,"      "],[13],[1,"\\n\\n"],[41,[30,0,["activeDatum"]],[[[1,"        "],[11,0],[24,0,"chart-tooltip"],[24,"role","status"],[4,[38,19],null,[["--x","--y"],[[28,[30,0,["tooltipX"]],[[28,[30,2,["compute"]],[[30,0,["activeDatum","x"]]],null],[30,2,["bandwidth"]]],null],[28,[30,0,["tooltipY"]],[[28,[30,4,["compute"]],[[30,0,["activeDatum","y"]]],null]],null]]]],[12],[1,"\\n          "],[10,0],[12],[1,"\\n            "],[10,2],[14,0,"bold"],[12],[1,[30,0,["activeDatum","legendX"]]],[13],[1,"\\n"],[42,[28,[37,14],[[28,[37,14],[[30,0,["activeDatum","legendY"]]],null]],null],null,[[[1,"              "],[10,2],[12],[1,[30,7]],[13],[1,"\\n"]],[7]],null],[1,"          "],[13],[1,"\\n          "],[10,0],[14,0,"chart-tooltip-arrow"],[12],[13],[1,"\\n        "],[13],[1,"\\n"]],[]],null],[1,"\\n"]],[2,3,4]]],[1,"  "]],[1]]]]],[1,"\\n"],[13],[1,"\\n\\n"],[41,[30,8],[[[1,"  "],[10,"details"],[12],[1,"\\n    "],[10,"summary"],[12],[1,[30,5]],[1," data"],[13],[1,"\\n    "],[8,[39,23],null,[["@caption"],["Underlying data"]],[["head","body"],[[[[1,"\\n        "],[8,[30,9,["Tr"]],null,null,[["default"],[[[[1,"\\n          "],[8,[30,9,["Th"]],null,null,[["default"],[[[[1,"Timestamp"]],[]]]]],[1,"\\n"],[42,[28,[37,14],[[28,[37,14],[[30,0,["dataKeys"]]],null]],null],null,[[[1,"            "],[8,[30,9,["Th"]],null,null,[["default"],[[[[1,[28,[35,25],[[30,10]],null]]],[]]]]],[1,"\\n"]],[10]],null],[1,"        "]],[]]]]],[1,"\\n      "]],[9]],[[[1,"\\n"],[42,[28,[37,14],[[28,[37,14],[[30,12]],null]],null],null,[[[1,"          "],[8,[30,11,["Tr"]],null,null,[["default"],[[[[1,"\\n            "],[8,[30,11,["Td"]],null,null,[["default"],[[[[1,[30,13,["timestamp"]]]],[]]]]],[1,"\\n"],[42,[28,[37,14],[[28,[37,14],[[30,0,["dataKeys"]]],null]],null],null,[[[1,"              "],[8,[30,11,["Td"]],null,null,[["default"],[[[[1,[28,[35,27],[[28,[37,28],[[30,13],[30,14]],null],"-"],null]]],[]]]]],[1,"\\n"]],[14]],null],[1,"          "]],[]]]]],[1,"\\n"]],[13]],null],[1,"      "]],[11]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],null]],["width","xScale","yScale","hScale","@chartTitle","d","stat","@showTable","H","key","B","@data","row","key"],false,["div","lineal/fluid","let","scale-band","array","scale-linear","svg","title","if","and","lineal/axis","concat","lineal/v-bars","each","-track-array","rect","on","fn","mut","style","p","details","summary","hds/table",":head","humanize",":body","or","get"]]',moduleName:"vault/components/clients/charts/vertical-bar-stacked.hbs",isStrictMode:!1})
let f=e.default=(u=class extends n.default{constructor(...e){var t,n,i,l
super(...e),d(this,"barWidth",r.BAR_WIDTH),t=this,n="activeDatum",l=this,(i=c)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(l):void 0}),d(this,"barOffset",(e=>(e-this.barWidth)/2)),d(this,"tooltipX",((e,t)=>(e+t/2).toString())),d(this,"tooltipY",(e=>e?`${e}`:"0")),d(this,"formatTicksX",(e=>(0,a.parseAPITimestamp)(e,"M/yy"))),d(this,"formatTicksY",(e=>(0,r.numericalAxisLabel)(e)||e.toString()))}get chartHeight(){return this.args.chartHeight||190}get dataKeys(){return this.args.chartLegend.map((e=>e.key))}label(e){return this.args.chartLegend.find((t=>t.key===e))?.label}get chartData(){let e=[]
for(const t of this.dataKeys){const n=this.args.data.map((e=>({timestamp:e.timestamp,clientType:t,[t]:e[t]}))),i=(0,o.flatGroup)(n,(e=>e.timestamp),(e=>e[t]),(e=>e.clientType))
e=[...e,...i]}return e.map((([e,t,n])=>({timestamp:e,counts:t,clientType:n})))}get aggregatedData(){return this.args.data.map((e=>{const t=this.dataKeys.map((t=>e[t])).filter((e=>Number.isInteger(e))),n=t.length?t.reduce(((e,t)=>e+t),0):null,i=e.timestamp
return{x:i,y:n??0,legendX:(0,a.parseAPITimestamp)(i,"MMMM yyyy"),legendY:null===n?["No data"]:this.dataKeys.map((t=>`${(0,l.formatNumber)([e[t]])} ${this.label(t)}`))}}))}get yBounds(){const e=this.aggregatedData.map((e=>e.y)).flatMap((e=>"number"==typeof e?[e]:[])),t=Math.max(...e)
return[0,t<=4?4:t]}get xBounds(){const e=this.chartData.map((e=>e.timestamp))
return new Set(e)}},m=u.prototype,h="activeDatum",b=[i.tracked],y={configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}},v={},Object.keys(y).forEach((function(e){v[e]=y[e]})),v.enumerable=!!v.enumerable,v.configurable=!!v.configurable,("value"in v||v.initializer)&&(v.writable=!0),v=b.slice().reverse().reduce((function(e,t){return t(m,h,e)||e}),v),g&&void 0!==v.initializer&&(v.value=v.initializer?v.initializer.call(g):void 0,v.initializer=void 0),c=void 0===v.initializer?(Object.defineProperty(m,h,v),null):v,u)
var m,h,b,y,g,v;(0,t.setComponentTemplate)(p,f)})),define("vault/components/clients/config",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p,f,m,h
function b(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function y(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const g=(0,o.createTemplateFactory)({id:"UCv00GAV",block:'[[[1,"\\n"],[41,[28,[37,1],[[30,1],"edit"],null],[[[1,"  "],[10,"form"],[15,"onsubmit",[28,[37,3],[[30,0],"onSaveChanges"],null]],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,5],null,[["@model","@errorMessage"],[[30,2],[30,0,["error"]]]],null],[1,"\\n"],[42,[28,[37,7],[[28,[37,7],[[30,2,["formFields"]]],null]],null],null,[[[41,[28,[37,1],[[30,3,["name"]],"enabled"],null],[[[41,[51,[30,2,["reportingEnabled"]]],[[[1,"            "],[10,"label"],[14,0,"is-label"],[12],[1,"Usage data collection"],[13],[1,"\\n            "],[10,2],[14,0,"sub-text"],[12],[1,"\\n              Enable or disable client tracking. Keep in mind that disabling tracking will delete the data for the current\\n              month.\\n            "],[13],[1,"\\n            "],[10,0],[14,0,"control is-flex has-bottom-margin-l"],[12],[1,"\\n              "],[11,"input"],[24,1,"enabled"],[24,3,"enabled"],[24,0,"toggle is-success is-small"],[16,"checked",[28,[37,1],[[30,2,["enabled"]],"On"],null]],[24,4,"checkbox"],[4,[38,12],["change",[30,0,["toggleEnabled"]]],null],[12],[13],[1,"\\n              "],[10,"label"],[14,"for","enabled"],[14,0,"has-text-weight-bold is-size-8"],[12],[1,"\\n                Data collection is\\n                "],[1,[28,[35,13],[[30,2,["enabled"]]],null]],[1,"\\n              "],[13],[1,"\\n            "],[13],[1,"\\n"]],[]],null]],[]],[[[1,"          "],[8,[39,14],null,[["@attr","@model","@modelValidations"],[[30,3],[30,2],[30,0,["validations"]]]],null],[1,"\\n"]],[]]]],[3]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped-split box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,15],null,null,[["default"],[[[[1,"\\n        "],[8,[39,16],[[16,"disabled",[30,0,["buttonDisabled"]]],[24,4,"submit"]],[["@text"],["Save"]],null],[1,"\\n        "],[8,[39,16],null,[["@text","@color","@route"],["Cancel","secondary","vault.cluster.clients.config"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n\\n"],[41,[30,0,["modalOpen"]],[[[1,"    "],[8,[39,17],[[24,1,"clients-config-modal"]],[["@color","@onClose"],["warning",[28,[37,18],[[28,[37,19],[[30,0,["modalOpen"]]],null],false],null]]],[["default"],[[[[1,"\\n      "],[8,[30,4,["Header"]],null,[["@icon"],["alert-triangle"]],[["default"],[[[[1,"\\n        "],[1,[30,0,["modalTitle"]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,4,["Body"]],null,null,[["default"],[[[[1,"\\n"],[41,[28,[37,1],[[30,2,["enabled"]],"On"],null],[[[1,"          "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n            Vault will start tracking data starting from today’s date,\\n            "],[1,[28,[35,20],[[28,[37,21],null,null],"MMMM d, yyyy"],null]],[1,". If you’ve previously enabled usage tracking, that historical data will\\n            still be available to you.\\n          "],[13],[1,"\\n"]],[]],[[[1,"          "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n            Turning usage tracking off means that all data for the current month will be deleted. You will still be able to\\n            query previous months.\\n          "],[13],[1,"\\n          "],[10,2],[12],[1,"Are you sure?"],[13],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n      "],[8,[30,4,["Footer"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,15],null,null,[["default"],[[[[1,"\\n          "],[8,[39,16],[[4,[38,12],["click",[28,[37,22],[[30,0,["save"]]],null]],null]],[["@text"],["Continue"]],null],[1,"\\n          "],[8,[39,16],[[4,[38,12],["click",[30,5,["close"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n        "]],[]]]]],[1,"\\n      "]],[5]]]]],[1,"\\n    "]],[4]]]]],[1,"\\n"]],[]],null]],[]],[[[1,"  "],[10,0],[14,0,"tabs-container box is-bottomless is-marginless is-fullwidth is-paddingless"],[12],[1,"\\n"],[42,[28,[37,7],[[28,[37,7],[[30,0,["infoRows"]]],null]],null],null,[[[1,"      "],[8,[39,23],null,[["@label","@helperText","@value"],[[30,6,["label"]],[30,6,["helperText"]],[28,[37,24],[[30,2],[30,6,["valueKey"]]],null]]],null],[1,"\\n"]],[6]],null],[1,"  "],[13],[1,"\\n"]],[]]]],["@mode","@model","attr","M","F","item"],false,["if","eq","form","action","div","message-error","each","-track-array","unless","label","p","input","on","lowercase","form-field","hds/button-set","hds/button","hds/modal","fn","mut","date-format","now","perform","info-table-row","get"]]',moduleName:"vault/components/clients/config.hbs",isStrictMode:!1})
let v=e.default=(s=(0,a.task)((function*(){try{yield this.args.model.save(),this.router.transitionTo("vault.cluster.clients.config")}catch(e){this.error=e.message,this.modalOpen=!1}})).drop(),u=class extends n.default{constructor(...e){super(...e),b(this,"router",c,this),b(this,"mode",d,this),b(this,"modalOpen",p,this),b(this,"validations",f,this),b(this,"error",m,this),b(this,"save",h,this)}get infoRows(){return[{label:"Usage data collection",helperText:"Enable or disable collecting data to track clients.",valueKey:"enabled"},{label:"Retention period",helperText:"The number of months of activity logs to maintain for client tracking.",valueKey:"retentionMonths"}]}get modalTitle(){return`Turn usage tracking ${this.args.model.enabled.toLowerCase()}?`}toggleEnabled(e){this.args.model.enabled=e.target.checked?"On":"Off"}onSaveChanges(e){e.preventDefault()
const{isValid:t,state:n}=this.args.model.validate(),i=this.args.model.changedAttributes()
t?i.enabled?this.modalOpen=!0:this.save.perform():this.validations=n}},c=y(u.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=y(u.prototype,"mode",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"show"}}),p=y(u.prototype,"modalOpen",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),f=y(u.prototype,"validations",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=y(u.prototype,"error",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=y(u.prototype,"save",[s],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y(u.prototype,"toggleEnabled",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"toggleEnabled"),u.prototype),y(u.prototype,"onSaveChanges",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"onSaveChanges"),u.prototype),u);(0,t.setComponentTemplate)(g,v)})),define("vault/components/clients/counts-card",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"0fIAbNF0",block:'[[[1,"\\n"],[1,"\\n"],[8,[39,0],[[24,0,"counts-card-container"],[17,1]],null,[["default"],[[[[1,"\\n  "],[10,0],[14,0,"has-bottom-margin-xl"],[12],[1,"\\n"],[41,[30,2],[[[1,"      "],[8,[39,3],[[24,0,"has-bottom-margin-xs"]],[["@tag","@size"],["h2","300"]],[["default"],[[[[1,[30,2]]],[]]]]],[1,"\\n"]],[]],null],[41,[30,3],[[[1,"      "],[8,[39,4],null,[["@tag","@size","@color"],["p","100","faint"]],[["default"],[[[[1,[30,3]]],[]]]]],[1,"\\n"]],[]],null],[41,[48,[30,7]],[[[1,"      "],[18,7,null],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n\\n"],[41,[48,[30,8]],[[[1,"    "],[18,8,null],[1,"\\n"]],[]],[[[1,"    "],[10,0],[14,0,"chart-flex-row"],[12],[1,"\\n      "],[10,0],[14,0,"item-left"],[12],[1,"\\n"],[41,[48,[30,9]],[[[1,"          "],[18,9,null],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n\\n      "],[10,0],[14,0,"item-right"],[12],[1,"\\n"],[41,[48,[30,10]],[[[1,"          "],[18,10,null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,4],[[[1,"          "],[10,0],[14,0,"legend-container"],[12],[1,"\\n"],[42,[28,[37,8],[[28,[37,8],[[30,4]],null]],null],null,[[[1,"              "],[10,0],[14,0,"legend-item"],[12],[1,"\\n"],[41,[28,[37,9],[[30,5,["key"]],[28,[37,10],["clients","new_clients"],null]],null],[[[1,"                  "],[10,1],[14,0,"dots legend-dot-total"],[12],[13],[1,"\\n"]],[]],[[[1,"                  "],[10,1],[15,0,[29,["dots legend-dot-",[30,6]]]],[12],[13],[1,"\\n"]],[]]],[1,"                "],[8,[39,4],null,[["@tag","@size"],["p","100"]],[["default"],[[[[1,[30,5,["label"]]]],[]]]]],[1,"\\n              "],[13],[1,"\\n"]],[5,6]],null],[1,"          "],[13],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]]]],[]]]]]],["&attrs","@title","@description","@legend","l","idx","&subheader","&table","&dataLeft","&dataRight"],false,["hds/card/container","div","if","hds/text/display","hds/text/body","has-block","yield","each","-track-array","includes","array","span"]]',moduleName:"vault/components/clients/counts-card.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/clients/counts/error",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"SWgGOfGg",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-top-margin-xxl"],[17,1]],null,[["default"],[[[[1,"\\n  "],[8,[30,2,["Header"]],null,[["@title"],[[28,[37,1],[[30,3],[52,[28,[37,3],[[30,4,["httpStatus"]],403],null],"You are not authorized","Error"]],null]]],null],[1,"\\n\\n  "],[8,[30,2,["Body"]],null,null,[["default"],[[[[1,"\\n"],[41,[28,[37,3],[[30,4,["httpStatus"]],403],null],[[[1,"      "],[10,2],[12],[1,"\\n        You must be granted permissions to view this page. Ask your administrator if you think you should have access to the\\n        "],[10,"code"],[12],[1,[30,4,["path"]]],[13],[1,"\\n        endpoint.\\n      "],[13],[1,"\\n"]],[]],[[[1,"      "],[10,"ul"],[12],[1,"\\n"],[41,[30,4,["message"]],[[[1,"          "],[10,"li"],[12],[1,[30,4,["message"]]],[13],[1,"\\n          "],[10,"hr"],[12],[13],[1,"\\n"]],[]],null],[42,[28,[37,10],[[28,[37,10],[[30,4,["errors"]]],null]],null],null,[[[1,"          "],[10,"li"],[12],[1,"\\n            "],[1,[30,5]],[1,"\\n          "],[13],[1,"\\n"]],[5]],null],[1,"      "],[13],[1,"\\n"]],[]]],[1,"  "]],[]]]]],[1,"\\n\\n  "],[8,[30,2,["Footer"]],null,null,[["default"],[[[[1,"\\n"],[41,[48,[30,6]],[[[1,"      "],[18,6,null],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"]],[2]]]]]],["&attrs","A","@title","@error","error","&actions"],false,["hds/application-state","or","if","eq","p","code","ul","li","hr","each","-track-array","has-block","yield"]]',moduleName:"vault/components/clients/counts/error.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/clients/counts/nav-bar",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"StL19jw2",block:'[[[1,"\\n"],[10,"nav"],[14,0,"tabs has-bottom-margin-s"],[14,"aria-label","navigation for managing client counts"],[12],[1,"\\n  "],[10,"ul"],[12],[1,"\\n    "],[10,"li"],[12],[1,"\\n      "],[8,[39,3],null,[["@route"],["vault.cluster.clients.counts.overview"]],[["default"],[[[[1,"\\n        Overview\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n    "],[10,"li"],[12],[1,"\\n      "],[8,[39,3],null,[["@route"],["vault.cluster.clients.counts.client-list"]],[["default"],[[[[1,"\\n        Client list\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],[],false,["nav","ul","li","link-to"]]',moduleName:"vault/components/clients/counts/nav-bar.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/clients/date-range",["exports","@ember/component","@ember/object","@ember/service","@glimmer/component","@glimmer/tracking","core/utils/date-formatters","core/utils/timestamp","date-fns","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f,m
function h(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function b(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function y(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const g=(0,u.createTemplateFactory)({id:"ypw29zc7",block:'[[[1,"\\n"],[11,0],[17,1],[12],[1,"\\n  "],[10,0],[14,0,"is-flex-column align-items-end"],[12],[1,"\\n"],[41,[28,[37,2],[[30,2],[30,0,["version","isEnterprise"]]],null],[[[1,"      "],[8,[39,3],[[24,0,"has-bottom-margin-xs"]],[["@tag","@size"],["p","100"]],[["default"],[[[[1,"\\n        "],[1,[52,[30,0,["flags","isHvdManaged"]],"Change data period","Change billing period"]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[39,4],[[24,0,"has-left-margin-xs"]],null,[["default"],[[[[1,"\\n        "],[8,[30,3,["ToggleButton"]],null,[["@text","@color"],[[28,[30,0,["formatDropdownDate"]],[[30,4]],null],"secondary"]],null],[1,"\\n        "],[8,[30,3,["Description"]],null,[["@text"],["Current period"]],null],[1,"\\n        "],[8,[30,3,["Checkmark"]],[[4,[38,5],["click",[28,[37,6],[[30,0,["updateEnterpriseDateRange"]],"",[30,3,["close"]]],null]],null]],[["@selected"],[[28,[30,0,["isSelected"]],[[30,2]],null]]],[["default"],[[[[1,"\\n          "],[1,[28,[30,0,["formatDropdownDate"]],[[30,2]],null]],[1,"\\n        "]],[]]]]],[1,"\\n"],[41,[30,0,["historicalBillingPeriods","length"]],[[[1,"          "],[8,[30,3,["Separator"]],[[24,0,"has-bottom-margin-xs"]],null,null],[1,"\\n          "],[8,[30,3,["Description"]],null,[["@text"],["Historical periods"]],null],[1,"\\n"],[42,[28,[37,8],[[28,[37,8],[[30,0,["historicalBillingPeriods"]]],null]],null],null,[[[1,"            "],[8,[30,3,["Checkmark"]],[[4,[38,5],["click",[28,[37,6],[[30,0,["updateEnterpriseDateRange"]],[30,5],[30,3,["close"]]],null]],null]],[["@selected"],[[28,[30,0,["isSelected"]],[[30,5]],null]]],[["default"],[[[[1,"\\n              "],[1,[28,[30,0,["formatDropdownDate"]],[[30,5]],null]],[1,"\\n            "]],[]]]]],[1,"\\n"]],[5,6]],null]],[]],null],[1,"      "]],[3]]]]],[1,"\\n"]],[]],[[[41,[28,[37,9],[[28,[37,2],[[30,4],[30,7]],null]],null],[[[1,"      "],[8,[39,10],[[24,0,"has-left-margin-xs"],[4,[38,5],["click",[28,[37,6],[[30,8],true],null]],null]],[["@text","@icon"],["Set date range","edit"]],null],[1,"\\n    "]],[]],null]],[]]],[1,"  "],[13],[1,"\\n\\n"],[41,[30,9],[[[1,"    "],[8,[39,11],null,[["@onClose"],[[30,0,["onClose"]]]],[["default"],[[[[1,"\\n      "],[8,[30,10,["Header"]],null,null,[["default"],[[[[1,"\\n        Edit date range\\n      "]],[]]]]],[1,"\\n      "],[8,[30,10,["Body"]],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["version","isCommunity"]],[[[1,"          "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n            Use custom date ranges to query historic client count data. Query results do not include the current month.\\n          "],[13],[1,"\\n"]],[]],null],[1,"        "],[10,"ul"],[14,0,"has-bottom-margin-s"],[12],[1,"\\n          "],[10,"li"],[12],[1,"\\n            "],[10,"strong"],[12],[1,"Start"],[13],[1,"\\n            sets the month and year (inclusive) for the first month of client counting.\\n          "],[13],[1,"\\n          "],[10,"li"],[12],[1,"\\n            "],[10,"strong"],[12],[1,"End"],[13],[1,"\\n            sets the month and year (inclusive) for the final month of client counting.\\n          "],[13],[1,"\\n        "],[13],[1,"\\n        "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n          We recommend setting\\n          "],[10,"strong"],[12],[1,"Start"],[13],[1,"\\n          to your Vault deploy date to get the most accurate client counts."],[13],[1,"\\n        "],[10,0],[14,0,"clients-date-range-display"],[12],[1,"\\n          "],[10,0],[12],[1,"\\n            "],[8,[39,16],[[16,"max",[52,[30,0,["version","isCommunity"]],[30,0,["previousMonth"]],[28,[37,17],[[30,0,["currentMonth"]],"yyyy-MM"],null]]],[24,1,"start-month"],[24,3,"modalStart"],[4,[38,5],["change",[30,0,["updateDate"]]],null]],[["@type","@value"],["month",[30,0,["modalStart"]]]],[["default"],[[[[1,"\\n              "],[8,[30,11,["Label"]],null,null,[["default"],[[[[1,"Start"]],[]]]]],[1,"\\n            "]],[11]]]]],[1,"\\n          "],[13],[1,"\\n          "],[10,0],[12],[1,"\\n            "],[8,[39,16],[[16,"max",[52,[30,0,["version","isCommunity"]],[30,0,["previousMonth"]],[28,[37,17],[[30,0,["currentMonth"]],"yyyy-MM"],null]]],[24,1,"end-month"],[24,3,"modalEnd"],[4,[38,5],["change",[30,0,["updateDate"]]],null]],[["@type","@value"],["month",[30,0,["modalEnd"]]]],[["default"],[[[[1,"\\n              "],[8,[30,12,["Label"]],null,null,[["default"],[[[[1,"End"]],[]]]]],[1,"\\n            "]],[12]]]]],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n"],[41,[30,0,["validationError"]],[[[1,"          "],[8,[39,18],[[24,0,"has-top-margin-xs"]],null,[["default"],[[[[1,[30,0,["validationError"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n      "],[8,[30,10,["Footer"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,10],[[4,[38,5],["click",[30,0,["handleSave"]]],null]],[["@text"],["Save"]],null],[1,"\\n        "],[8,[39,10],[[4,[38,5],["click",[30,13,["close"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n      "]],[13]]]]],[1,"\\n    "]],[10]]]]],[1,"\\n"]],[]],null],[13]],["&attrs","@billingStartTime","D","@startTimestamp","period","idx","@endTimestamp","@setEditModalVisible","@showEditModal","M","F","F","F"],false,["div","if","and","hds/text/display","hds/dropdown","on","fn","each","-track-array","not","hds/button","hds/modal","p","ul","li","strong","hds/form/text-input/field","date-format","hds/form/error"]]',moduleName:"vault/components/clients/date-range.hbs",isStrictMode:!1})
let v=e.default=(c=class extends r.default{constructor(e,t){super(e,t),h(this,"flags",d,this),h(this,"version",p,this),h(this,"modalStart",f,this),h(this,"modalEnd",m,this),b(this,"currentMonth",o.default.now()),b(this,"previousMonth",(0,s.format)(new Date(this.currentMonth.getUTCFullYear(),this.currentMonth.getUTCMonth()-1,1),"yyyy-MM")),b(this,"formatDropdownDate",(e=>(0,a.parseAPITimestamp)(e,"MMMM yyyy"))),b(this,"isSelected",(e=>{const t=this.formatDropdownDate(this.args.startTimestamp)
return this.formatDropdownDate(e)===t})),this.setTrackedFromArgs()}get historicalBillingPeriods(){const e=this.args.retentionMonths||48,t=Math.floor(e/12),n=[]
for(let i=1;i<=t;i++){const e=(0,a.parseAPITimestamp)(this.args.billingStartTime),t=e.getUTCFullYear()-i
e.setUTCFullYear(t),n.push(e.toISOString())}return n}get validationError(){if(!this.modalStart||!this.modalEnd)return"You must supply both start and end dates."
if(this.modalStart>this.modalEnd)return"Start date must be before end date."
const e=this.modalStart>this.previousMonth||this.modalEnd>this.previousMonth
return this.version.isCommunity&&e?"You cannot select the current month or beyond.":null}onClose(){this.setTrackedFromArgs(),this.args.setEditModalVisible(!1)}updateDate(e){const{name:t,value:n}=e.target
this[t]=n}handleSave(){if(this.validationError)return
const e={start_time:"",end_time:""}
this.modalStart&&(e.start_time=this.formatModalTimestamp(this.modalStart,!1)),this.modalEnd&&(e.end_time=this.formatModalTimestamp(this.modalEnd,!0)),this.args.onChange(e),this.onClose()}updateEnterpriseDateRange(e,t){this.args.onChange({start_time:e,end_time:""}),t()}formatModalTimestamp(e,t){const[n,i]=e.split("-"),r=Number(i)-1,l=Number(n)
return(0,a.buildISOTimestamp)({monthIdx:r,year:l,isEndDate:t})}setTrackedFromArgs(){this.args.startTimestamp&&(this.modalStart=(0,a.parseAPITimestamp)(this.args.startTimestamp,"yyyy-MM")),this.args.endTimestamp&&(this.modalEnd=(0,a.parseAPITimestamp)(this.args.endTimestamp,"yyyy-MM"))}},d=y(c.prototype,"flags",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=y(c.prototype,"version",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=y(c.prototype,"modalStart",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),m=y(c.prototype,"modalEnd",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y(c.prototype,"onClose",[n.action],Object.getOwnPropertyDescriptor(c.prototype,"onClose"),c.prototype),y(c.prototype,"updateDate",[n.action],Object.getOwnPropertyDescriptor(c.prototype,"updateDate"),c.prototype),y(c.prototype,"handleSave",[n.action],Object.getOwnPropertyDescriptor(c.prototype,"handleSave"),c.prototype),y(c.prototype,"updateEnterpriseDateRange",[n.action],Object.getOwnPropertyDescriptor(c.prototype,"updateEnterpriseDateRange"),c.prototype),c);(0,t.setComponentTemplate)(g,v)})),define("vault/components/clients/filter-toolbar",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","@ember/runloop","@ember/string","core/utils/date-formatters","core/utils/client-count-utils","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f,m,h,b,y,g
function v(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function w(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function k(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const x=(0,u.createTemplateFactory)({id:"zlIvd60R",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[39,1],null,null,[["default"],[[[[1,"\\n"],[42,[28,[37,3],[[30,0,["dropdownConfig"]]],null],null,[[[44,[[30,2,["label"]],[30,2,["dropdownItems"]],[30,2,["searchProperty"]]],[[[1,"        "],[8,[30,1,["Dropdown"]],null,[["@onClose"],[[28,[37,5],[[30,0,["handleDropdownClose"]],[30,6]],null]]],[["default"],[[[[1,"\\n          "],[8,[30,7,["ToggleButton"]],null,[["@color","@text"],["secondary",[28,[37,6],[[30,4]],null]]],null],[1,"\\n          "],[8,[30,7,["Header"]],null,null,[["default"],[[[[1,"\\n            "],[8,[39,7],[[24,"placeholder","Search"],[16,1,[30,6]],[24,"autocomplete","off"],[24,4,"search"],[4,[38,9],["input",[30,0,["handleSearch"]]],null]],[["@value"],[[28,[37,8],[[30,0],[30,6]],null]]],null],[1,"\\n          "]],[]]]]],[1,"\\n          "],[8,[30,7,["Separator"]],null,null,null],[1,"\\n"],[44,[[28,[30,0,["searchDropdown"]],[[30,5],[30,6]],null]],[[[42,[28,[37,10],[[28,[37,10],[[30,8]],null]],null],null,[[[1,"              "],[8,[30,7,["Checkmark"]],[[4,[38,9],["click",[28,[37,5],[[30,0,["handleFilterSelect"]],[30,3],[30,9],[30,7,["close"]]],null]],null]],[["@selected"],[[28,[37,11],[[30,9],[28,[37,8],[[30,0],[30,3]],null]],null]]],[["default"],[[[[1,"\\n                "],[1,[52,[28,[37,11],[[30,3],"month"],null],[28,[30,0,["formatTimestamp"]],[[30,9]],null],[30,9]]],[1,"\\n              "]],[]]]]],[1,"\\n"]],[9]],[[[1,"              "],[8,[30,7,["Description"]],[[24,0,"has-top-padding-xs"]],[["@text"],[[28,[30,0,["noItemsMessage"]],[[28,[37,8],[[30,0],[30,6]],null],[28,[37,13],[[30,4]],null]],null]]],null],[1,"\\n"]],[]]]],[8]]],[1,"        "]],[7]]]]],[1,"\\n"]],[4,5,6]]]],[2,3]],null],[1,"  "]],[1]]]]],[1,"\\n"]],[]]]]],[1,"\\n\\n"],[8,[39,14],[[24,0,"has-top-margin-s"]],[["@gap","@align"],["8","center"]],[["default"],[[[[1,"\\n  "],[8,[39,15],null,[["@color"],["faint"]],[["default"],[[[[1,"Filters applied:"]],[]]]]],[1,"\\n"],[41,[30,0,["anyFilters"]],[[[42,[28,[37,3],[[30,0,["filterProps"]]],null],null,[[[41,[30,10],[[[1,"        "],[10,0],[12],[1,"\\n          "],[8,[39,17],null,[["@text","@tooltipPlacement","@onDismiss"],[[52,[28,[37,11],[[30,11],"month"],null],[28,[30,0,["formatTimestamp"]],[[30,10]],null],[30,10]],"bottom",[28,[37,5],[[30,0,["clearFilters"]],[30,11]],null]]],null],[1,"\\n        "],[13],[1,"\\n"]],[]],null]],[10,11]],null],[1,"    "],[8,[39,18],[[4,[38,9],["click",[28,[37,5],[[30,0,["clearFilters"]],""],null]],null]],[["@icon","@text","@color"],["x-circle","Clear filters","tertiary"]],null],[1,"\\n"]],[]],[[[1,"    "],[8,[39,15],null,[["@color"],["faint"]],[["default"],[[[[1,"None"]],[]]]]],[1,"\\n"]],[]]]],[]]]]],[1,"\\n\\n"],[41,[30,0,["filterAlert"]],[[[1,"  "],[8,[39,19],[[24,0,"has-top-padding-xs"]],[["@type"],["compact"]],[["default"],[[[[1,"\\n    "],[8,[30,12,["Description"]],null,null,[["default"],[[[[1,[30,0,["filterAlert"]]]],[]]]]],[1,"\\n  "]],[12]]]]],[1,"\\n"]],[]],null]],["SG","d","filterProperty","label","dropdownItems","searchProperty","D","matchingItems","item","value","filter","A"],false,["hds/button-set","hds/segmented-group","each","-each-in","let","fn","capitalize","hds/form/text-input/base","get","on","-track-array","eq","if","pluralize","hds/layout/flex","hds/text/body","div","hds/tag","hds/button","hds/alert"]]',moduleName:"vault/components/clients/filter-toolbar.hbs",isStrictMode:!1})
let P=e.default=(c=class extends n.default{constructor(e,t){super(e,t),w(this,"filterTypes",Object.values(s.ClientFilters)),v(this,"namespace_path",d,this),v(this,"mount_path",p,this),v(this,"mount_type",f,this),v(this,"month",m,this),v(this,"namespacePathSearch",h,this),v(this,"mountPathSearch",b,this),v(this,"mountTypeSearch",y,this),v(this,"monthSearch",g,this),w(this,"formatTimestamp",(e=>(0,o.parseAPITimestamp)(e,"MMMM yyyy"))),w(this,"searchDropdown",((e,t)=>{const n=this[t]
return n?e.filter((e=>{const i=e=>e?.toLowerCase().includes(n.toLowerCase())
return"monthSearch"===t?i(e)||i(this.formatTimestamp(e)):i(e)})):e})),w(this,"noItemsMessage",((e,t)=>e?`No matching ${t}`:"months"===t&&this.args.isExportData?"Filtering by month is only available for clients initially used after upgrading to version 1.21.":`No ${t} to filter`))
const{namespace_path:n,mount_path:i,mount_type:r,month:l}=this.args.filterQueryParams
this.namespace_path=n||"",this.mount_path=i||"",this.mount_type=r||"",this.month=l||""}get anyFilters(){return Object.values(this.filterProps).some((e=>!!e))}get dropdownItems(){const e=new Set,t=new Set,n=new Set,i=new Set
return this.args.dataset&&this.args.dataset.forEach((r=>{const l=""===r.namespace_path?"root":r.namespace_path
if(l&&e.add(l),r.mount_path&&t.add(r.mount_path),r.mount_type&&n.add(r.mount_type),"client_first_used_time"in r&&r.client_first_used_time){const e=(0,o.parseAPITimestamp)(r.client_first_used_time),t=e.getUTCFullYear(),n=e.getUTCMonth(),l=(0,o.buildISOTimestamp)({year:t,monthIdx:n,isEndDate:!1})
i.add(l)}})),{[s.ClientFilters.NAMESPACE]:[...e],[s.ClientFilters.MOUNT_PATH]:[...t],[s.ClientFilters.MOUNT_TYPE]:[...n],[s.ClientFilters.MONTH]:this.args.dropdownMonths||[...i]}}get dropdownConfig(){return{[s.ClientFilters.NAMESPACE]:{label:"namespace",dropdownItems:this.dropdownItems[s.ClientFilters.NAMESPACE],searchProperty:"namespacePathSearch"},[s.ClientFilters.MOUNT_PATH]:{label:"mount path",dropdownItems:this.dropdownItems[s.ClientFilters.MOUNT_PATH],searchProperty:"mountPathSearch"},[s.ClientFilters.MOUNT_TYPE]:{label:"mount type",dropdownItems:this.dropdownItems[s.ClientFilters.MOUNT_TYPE],searchProperty:"mountTypeSearch"},[s.ClientFilters.MONTH]:{label:"month",dropdownItems:this.dropdownItems[s.ClientFilters.MONTH],searchProperty:"monthSearch"}}}get filterAlert(){return this.filterTypes.flatMap((e=>{const t=this.filterProps[e],n=this.dropdownItems[e].includes(t)
return s.ClientFilters.MONTH===e?[]:!n&&t?[(i=this.dropdownConfig[e].label,r=t,`${(0,a.capitalize)(i)} "${r}" not found in the current data.`)]:[]
var i,r})).join(" ")}get filterProps(){return this.filterTypes.reduce(((e,t)=>(e[t]=this[t],e)),{})}handleFilterSelect(e,t,n){this[e]=t,n()}handleDropdownClose(e){this.updateSearch(e,""),this.applyFilters()}clearFilters(e){e?this[e]="":(this.namespace_path="",this.mount_path="",this.mount_type="",this.month=""),this.applyFilters()}applyFilters(){this.args.onFilter(this.filterProps)}handleSearch(e){const{value:t,id:n}=e.target;(0,l.debounce)(this,this.updateSearch,n,t,50)}updateSearch(e,t){this[e]=t}},d=k(c.prototype,"namespace_path",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=k(c.prototype,"mount_path",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=k(c.prototype,"mount_type",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=k(c.prototype,"month",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=k(c.prototype,"namespacePathSearch",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),b=k(c.prototype,"mountPathSearch",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y=k(c.prototype,"mountTypeSearch",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),g=k(c.prototype,"monthSearch",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),k(c.prototype,"dropdownItems",[i.cached],Object.getOwnPropertyDescriptor(c.prototype,"dropdownItems"),c.prototype),k(c.prototype,"dropdownConfig",[i.cached],Object.getOwnPropertyDescriptor(c.prototype,"dropdownConfig"),c.prototype),k(c.prototype,"filterProps",[i.cached],Object.getOwnPropertyDescriptor(c.prototype,"filterProps"),c.prototype),k(c.prototype,"handleFilterSelect",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"handleFilterSelect"),c.prototype),k(c.prototype,"handleDropdownClose",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"handleDropdownClose"),c.prototype),k(c.prototype,"clearFilters",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"clearFilters"),c.prototype),k(c.prototype,"applyFilters",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"applyFilters"),c.prototype),k(c.prototype,"handleSearch",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"handleSearch"),c.prototype),k(c.prototype,"updateSearch",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"updateSearch"),c.prototype),c);(0,t.setComponentTemplate)(x,P)})),define("vault/components/clients/no-data",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"TtufCJD3",block:'[[[1,"\\n"],[41,[28,[37,1],[[30,1,["reportingEnabled"]],[28,[37,2],[[30,1,["enabled"]],"On"],null]],null],[[[1,"  "],[8,[39,3],[[24,0,"is-shadowless"]],[["@title","@message"],["No data received","Tracking is turned on and Vault is gathering data. It should appear here within 30 minutes."]],null],[1,"\\n"]],[]],[[[41,[30,1],[[[1,"  "],[8,[39,3],[[24,0,"is-shadowless"]],[["@title","@message"],["Data tracking is disabled","Tracking is disabled, and no data is being collected. To turn it on, edit the configuration."]],[["default"],[[[[1,"\\n"],[41,[30,1,["canEdit"]],[[[1,"      "],[8,[39,4],null,[["@icon","@iconPosition","@text","@route"],["chevron-right","trailing","Go to configuration","vault.cluster.clients.config"]],null],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"]],[]],[[[1,"  "],[8,[39,3],[[24,0,"is-shadowless"]],[["@title","@message"],["Activity configuration data is unavailable","Reporting status is unknown and could be enabled or disabled. Check the Vault logs for more information."]],null],[1,"\\n"]],[]]]],[]]]],["@config"],false,["if","or","eq","empty-state","hds/link/standalone"]]',moduleName:"vault/components/clients/no-data.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/clients/page-header",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@ember/object","@ember/service","@ember/test-waiters","@glimmer/component","@glimmer/tracking","core/utils/date-formatters","core/utils/sanitize-path","date-fns","ember-concurrency","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c,d,p){var f,m,h,b,y,g,v,w,k,x,P,_
function T(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function O(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function j(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const z=(0,p.createTemplateFactory)({id:"8kyZLRcp",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-top-padding-l has-bottom-padding-m"]],null,[["default"],[[[[1,"\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"\\n    Client Usage\\n  "]],[]]]]],[1,"\\n\\n"],[41,[30,2],[[[1,"    "],[8,[30,1,["Subtitle"]],null,null,[["default"],[[[[1,"\\n      Dashboard last updated:\\n      "],[1,[28,[35,2],[[30,2],"MMM d yyyy, h:mm:ss aaa"],[["withTimeZone"],[true]]]],[1,"\\n      "],[8,[39,3],[[4,[38,4],["click",[30,0,["refreshRoute"]]],null]],[["@color","@icon","@isIconOnly","@size","@text"],["tertiary","reload",true,"small","Refresh page"]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n"],[41,[28,[37,5],[[30,0,["version","isEnterprise"]],[30,3]],null],[[[1,"      "],[10,2],[14,0,"has-text-weight-semibold"],[12],[1,"\\n        "],[1,[52,[30,0,["flags","isHvdManaged"]],"For data period: ","For billing period: "]],[1,"\\n        "],[10,1],[12],[1,[30,0,["formattedStartDate"]]],[13],[1,"\\n        -\\n        "],[10,1],[12],[1,[30,0,["formattedEndDate"]]],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[41,[28,[37,5],[[30,4],[30,5]],null],[[[1,"      "],[10,0],[14,0,"has-top-padding-m"],[12],[1,"\\n        "],[8,[39,9],null,[["@tag"],["h3"]],[["default"],[[[[1,"Client counting period"]],[]]]]],[1,"\\n        "],[8,[39,10],[[24,"color","faint"]],[["@tag","@size"],["p","100"]],[["default"],[[[[1,"Click \'Edit\' to select a different date range."]],[]]]]],[1,"\\n        "],[8,[39,10],null,[["@tag"],["p"]],[["default"],[[[[1,"\\n          "],[10,1],[12],[1,[30,0,["formattedStartDate"]]],[13],[1,"\\n          -\\n          "],[10,1],[12],[1,[30,0,["formattedEndDate"]]],[13],[1,"\\n          "],[8,[39,3],[[4,[38,4],["click",[28,[37,11],[[28,[37,12],[[30,0,["showEditModal"]]],null],true],null]],null]],[["@size","@text","@isInline","@color","@icon","@iconPosition"],["small","Edit","true","tertiary","edit","trailing"]],null],[1,"\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n    "]],[]],null]],[]]],[1,"  "]],[]]]]],[1,"\\n\\n  "],[8,[30,1,["Actions"]],[[24,0,"align-items-end align-self-end"]],null,[["default"],[[[[1,"\\n"],[41,[30,0,["showExportButton"]],[[[1,"      "],[8,[39,3],[[24,0,"has-font-weight-normal"],[4,[38,4],["click",[28,[37,11],[[28,[37,12],[[30,0,["showExportModal"]]],null],true],null]],null]],[["@text","@color","@icon"],["Export activity data","secondary","download"]],null],[1,"\\n"]],[]],null],[1,"    "],[8,[39,13],[[16,0,[52,[28,[37,5],[[30,0,["version","isCommunity"]],[30,0,["startDate"]],[30,0,["endDate"]]],null],"position-absolute"]]],[["@startTimestamp","@endTimestamp","@billingStartTime","@retentionMonths","@onChange","@showEditModal","@setEditModalVisible"],[[30,4],[30,5],[30,3],[30,6],[30,7],[30,0,["showEditModal"]],[30,0,["setEditModalVisible"]]]],null],[1,"\\n  "]],[]]]]],[1,"\\n\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["showExportModal"]],[[[1,"  "],[8,[39,14],[[24,1,"attribution-csv-download-modal"],[24,0,"has-text-left"]],[["@onClose"],[[30,0,["resetModal"]]]],[["default"],[[[[1,"\\n    "],[8,[30,8,["Header"]],null,[["@icon"],["info"]],[["default"],[[[[1,"\\n      Export activity data\\n    "]],[]]]]],[1,"\\n    "],[8,[30,8,["Body"]],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["exportChartData","isRunning"]],[[[1,"        "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n          Your export request is being processed. This may take some time; please do not navigate away from this page.\\n        "],[13],[1,"\\n        "],[10,2],[14,0,"has-bottom-margin-s has-text-centered"],[12],[1,"\\n          "],[8,[39,15],null,[["@name","@size"],["loading","24"]],null],[1,"\\n        "],[13],[1,"\\n"]],[]],[[[1,"        "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n          This file will include an export of the clients that had activity within the date range below. See the\\n          "],[8,[39,16],null,[["@path"],["/vault/api-docs/system/internal-counters#activity-export"]],[["default"],[[[[1,"activity export documentation"]],[]]]]],[1,"\\n          for more details.\\n        "],[13],[1,"\\n        "],[10,2],[14,0,"has-bottom-margin-s is-subtitle-gray"],[12],[1,"SELECTED DATE "],[1,[52,[30,0,["formattedEndDate"]]," RANGE"]],[13],[1,"\\n        "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n          "],[1,[30,0,["formattedStartDate"]]],[1,"\\n"],[41,[30,0,["showEndDate"]],[[[1,"            "],[1,"-"],[1,"\\n            "],[1,[30,0,["formattedEndDate"]]],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n\\n        "],[8,[39,17],[[24,0,"has-bottom-margin-s"],[4,[38,4],["change",[30,0,["setExportFormat"]]],null]],null,[["default"],[[[[1,"\\n          "],[8,[30,9,["Label"]],null,null,[["default"],[[[[1,"Export format"]],[]]]]],[1,"\\n          "],[8,[30,9,["Options"]],null,null,[["default"],[[[[1,"\\n            "],[10,"option"],[14,2,"csv"],[15,"selected",[28,[37,19],[[30,0,["exportFormat"]],"csv"],null]],[12],[1,"CSV"],[13],[1,"\\n            "],[10,"option"],[14,2,"jsonl"],[15,"selected",[28,[37,19],[[30,0,["exportFormat"]],"jsonl"],null]],[12],[1,"JSON Lines"],[13],[1,"\\n          "]],[]]]]],[1,"\\n        "]],[9]]]]],[1,"\\n"]],[]]],[1,"\\n"],[41,[30,0,["downloadError"]],[[[1,"        "],[8,[39,20],null,[["@type","@color"],["inline","critical"]],[["default"],[[[[1,"\\n          "],[8,[30,10,["Title"]],null,null,[["default"],[[[[1,"CSV export failed"]],[]]]]],[1,"\\n          "],[8,[30,10,["Description"]],null,null,[["default"],[[[[1,[30,0,["downloadError"]]]],[]]]]],[1,"\\n        "]],[10]]]]],[1,"\\n"]],[]],null],[1,"    "]],[]]]]],[1,"\\n    "],[8,[30,8,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,21],null,null,[["default"],[[[[1,"\\n        "],[8,[39,3],[[4,[38,4],["click",[28,[37,22],[[30,0,["exportChartData"]],[30,0,["formattedCsvFileName"]]],null]],null]],[["@text"],["Export"]],null],[1,"\\n        "],[8,[39,3],[[4,[38,4],["click",[30,11,["close"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n      "]],[]]]]],[1,"\\n"],[41,[30,12],[[[1,"        "],[8,[39,20],[[24,0,"has-top-padding-m"]],[["@type","@color"],["compact","warning"]],[["default"],[[[[1,"\\n          "],[8,[30,13,["Description"]],null,null,[["default"],[[[[1,"\\n            "],[10,"strong"],[12],[1,"Data contains "],[1,[28,[35,24],[[30,12,["length"]],"upgrade"],null]],[1,":"],[13],[1,"\\n          "]],[]]]]],[1,"\\n          "],[8,[30,13,["Description"]],null,null,[["default"],[[[[1,"\\n            "],[10,"ul"],[14,0,"bullet"],[12],[1,"\\n"],[42,[28,[37,27],[[28,[37,27],[[30,12]],null]],null],null,[[[1,"                "],[10,"li"],[12],[1,"\\n                  "],[1,[30,14,["version"]]],[1,"\\n                  "],[1,[28,[30,0,["parseAPITimestamp"]],[[30,14,["timestampInstalled"]],"(MMM d, yyyy)"],null]],[1,"\\n                "],[13],[1,"\\n"]],[14]],null],[1,"            "],[13],[1,"\\n          "]],[]]]]],[1,"\\n          "],[8,[30,13,["Description"]],null,null,[["default"],[[[[1,"\\n            Visit our\\n            "],[8,[39,29],null,[["@isHrefExternal","@href"],[true,[28,[37,16],["/vault/docs/concepts/client-count/faq#q-which-vault-version-reflects-the-most-accurate-client-counts"],null]]],[["default"],[[[[1,"\\n              Client count FAQ\\n            "]],[]]]]],[1,"\\n            for more information.\\n          "]],[]]]]],[1,"\\n        "]],[13]]]]],[1,"\\n"]],[]],null],[1,"    "]],[11]]]]],[1,"\\n  "]],[8]]]]],[1,"\\n"]],[]],null]],["PH","@activityTimestamp","@billingStartTime","@startTimestamp","@endTimestamp","@retentionMonths","@onChange","M","F","A","F","@upgradesDuringActivity","A","upgrade"],false,["hds/page-header","if","date-format","hds/button","on","and","p","span","div","hds/text/display","hds/text/body","fn","mut","clients/date-range","hds/modal","icon","doc-link","hds/form/select/field","option","eq","hds/alert","hds/button-set","perform","strong","pluralize","ul","each","-track-array","li","hds/link/inline"]]',moduleName:"vault/components/clients/page-header.hbs",isStrictMode:!1})
let M=e.default=(f=class extends a.default{constructor(){super(...arguments),T(this,"download",m,this),T(this,"flags",h,this),T(this,"namespace",b,this),T(this,"router",y,this),T(this,"store",g,this),T(this,"version",v,this),T(this,"canDownload",w,this),T(this,"showEditModal",k,this),T(this,"showExportModal",x,this),T(this,"exportFormat",P,this),T(this,"downloadError",_,this),O(this,"exportChartData",(0,n.buildTask)((()=>({context:this,generator:function*(e){try{const t=yield this.getExportData()
this.download.download(e,t,this.exportFormat),this.showExportModal=!1}catch(t){this.downloadError=t.message}}})),{drop:!0},"exportChartData",null)),O(this,"parseAPITimestamp",((e,t)=>(0,s.parseAPITimestamp)(e,t))),this.getExportCapabilities()}get showExportButton(){return!0!==this.args.noData&&this.canDownload}async getExportCapabilities(){const e=this.namespace.path
try{const t=e?`${(0,u.sanitizePath)(e)}/sys/internal/counters/activity/export`:"sys/internal/counters/activity/export",n=await this.store.findRecord("capabilities",t)
this.canDownload=n.canSudo}catch(t){this.canDownload=!0}}get formattedStartDate(){return this.args.startTimestamp?(0,s.parseAPITimestamp)(this.args.startTimestamp,"MMMM yyyy"):null}get formattedEndDate(){return this.args.endTimestamp?(0,s.parseAPITimestamp)(this.args.endTimestamp,"MMMM yyyy"):null}get showEndDate(){if(!this.args.endTimestamp)return!1
const e=(0,s.parseAPITimestamp)(this.args.startTimestamp),t=(0,s.parseAPITimestamp)(this.args.endTimestamp)
return!(0,c.isSameMonth)(e,t)}get formattedCsvFileName(){const e=this.showEndDate?`-${this.formattedEndDate}`:"",t=this.formattedStartDate?`_${this.formattedStartDate+e}`:""
return`clients_export${this.namespace.path?`_${this.namespace.path}`:""}${t}`}async getExportData(){const e=this.store.adapterFor("clients/activity"),{startTimestamp:t,endTimestamp:n}=this.args
return e.exportData({format:"jsonl"===this.exportFormat?"json":"csv",start_time:t,end_time:n,namespace:this.namespace.path})}refreshRoute(){this.router.refresh(this.router.currentRoute.parent.name)}resetModal(){this.showExportModal=!1,this.downloadError=""}setEditModalVisible(e){this.showEditModal=e}setExportFormat(e){const{value:t}=e.target
this.exportFormat=t}},m=j(f.prototype,"download",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=j(f.prototype,"flags",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=j(f.prototype,"namespace",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=j(f.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=j(f.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=j(f.prototype,"version",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=j(f.prototype,"canDownload",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),k=j(f.prototype,"showEditModal",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),x=j(f.prototype,"showExportModal",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),P=j(f.prototype,"exportFormat",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"csv"}}),_=j(f.prototype,"downloadError",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),j(f.prototype,"getExportCapabilities",[l.waitFor],Object.getOwnPropertyDescriptor(f.prototype,"getExportCapabilities"),f.prototype),j(f.prototype,"refreshRoute",[i.action],Object.getOwnPropertyDescriptor(f.prototype,"refreshRoute"),f.prototype),j(f.prototype,"resetModal",[i.action],Object.getOwnPropertyDescriptor(f.prototype,"resetModal"),f.prototype),j(f.prototype,"setEditModalVisible",[i.action],Object.getOwnPropertyDescriptor(f.prototype,"setEditModalVisible"),f.prototype),j(f.prototype,"setExportFormat",[i.action],Object.getOwnPropertyDescriptor(f.prototype,"setExportFormat"),f.prototype),f);(0,t.setComponentTemplate)(z,M)})),define("vault/components/clients/page/client-list",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","core/utils/client-count-utils","@ember/service","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d
function p(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function f(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function m(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h=(0,o.createTemplateFactory)({id:"zEBB9bh5",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-top-margin-l has-bottom-margin-m"]],[["@tag","@size","@color"],["p","100","faint"]],[["default"],[[[[1,"The client list data below\\n  comes from the\\n  "],[8,[39,1],null,[["@icon","@iconPosition","@isHrefExternal","@href"],["docs-link","trailing",true,[28,[37,2],["/vault/api-docs/system/internal-counters#activity-export"],null]]],[["default"],[[[[1,"\\n    Activity Export API\\n  "]],[]]]]],[1,". It may take up to ten minutes for new client IDs to appear in the export data.\\n"]],[]]]]],[1,"\\n\\n"],[8,[39,3],null,null,[["subheader","table"],[[[[1,"\\n    "],[8,[39,5],null,[["@dataset","@onFilter","@filterQueryParams","@isExportData"],[[30,1],[30,0,["handleFilter"]],[30,2],true]],null],[1,"\\n  "]],[]],[[[1,"\\n    "],[8,[39,7],null,[["@onClickTab","@selectedTabIndex"],[[30,0,["onClickTab"]],[30,0,["selectedTabIndex"]]]],[["default"],[[[[1,"\\n"],[42,[28,[37,9],[[30,0,["exportDataByTab"]]],null],null,[[[44,[[28,[30,0,["filterData"]],[[30,4]],null]],[[[1,"          "],[8,[30,3,["Tab"]],null,[["@count"],[[28,[37,11],[[30,6,["length"]],"0"],null]]],[["default"],[[[[1,[30,5]]],[]]]]],[1,"\\n          "],[8,[30,3,["Panel"]],null,null,[["default"],[[[[1,"\\n            "],[10,0],[14,0,"has-top-margin-xs"],[12],[1,"\\n"],[41,[30,0,["filtersAreApplied"]],[[[1,"                "],[8,[39,0],[[24,0,"has-bottom-margin-xs"]],[["@tag","@color"],["p","faint"]],[["default"],[[[[1,"\\n                  Summary:\\n                  "],[1,[28,[35,14],[[30,6,["length"]],"client"],null]],[1,"\\n                  "],[1,[52,[28,[37,15],[[30,6,["length"]],1],null],"matches","match"]],[1,"\\n                  the filter criteria.\\n                "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,15],[[30,5],[30,0,["selectedTab"]]],null],[[[1,"                "],[8,[39,16],null,[["@data","@columns","@setPageSize","@showPaginationSizeSelector"],[[30,6],[28,[30,0,["tableColumns"]],[[30,5]],null],50,true]],[["emptyState"],[[[[1,"\\n"],[41,[28,[37,18],[[28,[37,15],[[30,5],"Secret sync"],null],[28,[37,19],[[30,0,["flags","secretsSyncIsActivated"]]],null]],null],[[[1,"                      "],[8,[39,20],null,null,[["default"],[[[[1,"\\n                        "],[8,[30,7,["Header"]],null,[["@title"],["No secret sync clients"]],null],[1,"\\n                        "],[8,[30,7,["Body"]],null,[["@text"],["No data is available because Secrets Sync has not been activated."]],null],[1,"\\n                        "],[8,[30,7,["Body"]],null,null,[["default"],[[[[1,"\\n                          "],[8,[39,21],null,[["@icon","@iconPosition","@text","@route"],["chevron-right","trailing","Activate Secrets Sync","vault.cluster.sync.secrets.overview"]],null],[1,"\\n                        "]],[]]]]],[1,"\\n                      "]],[7]]]]],[1,"\\n"]],[]],[[[1,"                      "],[8,[39,20],null,null,[["default"],[[[[1,"\\n                        "],[8,[30,8,["Header"]],null,[["@title"],["No data found"]],null],[1,"\\n                        "],[8,[30,8,["Body"]],null,[["@text"],[[29,["Select another client type ",[52,[30,0,["filtersAreApplied"]],"or update filters",""]," to view client count data."]]]],null],[1,"\\n                      "]],[8]]]]],[1,"\\n"]],[]]],[1,"                  "]],[]]]]],[1,"\\n"]],[]],null],[1,"            "],[13],[1,"\\n          "]],[]]]]],[1,"\\n"]],[6]]]],[4,5]],null],[1,"    "]],[3]]]]],[1,"\\n  "]],[]]]]]],["@exportData","@filterQueryParams","T","exportData","tabName","tableData","A","A"],false,["hds/text/body","hds/link/inline","doc-link","clients/counts-card",":subheader","clients/filter-toolbar",":table","hds/tabs","each","-each-in","let","or","div","if","pluralize","eq","clients/table",":emptyState","and","not","hds/application-state","hds/link/standalone"]]',moduleName:"vault/components/clients/page/client-list.hbs",isStrictMode:!1}),b={entity:"Entity","non-entity-token":"Non-entity","pki-acme":"ACME","secret-sync":"Secret sync"}
let y=e.default=(s=class extends n.default{constructor(e,t){super(e,t),p(this,"flags",u,this),p(this,"selectedTab",c,this),p(this,"exportDataByTab",d,this),f(this,"filterData",(e=>(0,l.filterTableData)(e,this.args.filterQueryParams))),this.args.exportData.forEach((e=>{const t=b[e.client_type]
this.exportDataByTab[t].push(e)}))
const n=Object.keys(this.exportDataByTab)[0]
this.selectedTab=n}get selectedTabIndex(){return Object.keys(this.exportDataByTab).indexOf(this.selectedTab)}get tabs(){return Object.keys(this.exportDataByTab)}handleFilter(e){this.args.onFilterChange(e)}onClickTab(e,t){const n=this.tabs[t]
this.selectedTab=n??this.tabs[0]}get filtersAreApplied(){return Object.keys(this.args.filterQueryParams).every((e=>(0,l.filterIsSupported)(e)))&&Object.values(this.args.filterQueryParams).some((e=>!!e))}tableColumns(e){const t=[{key:"client_id",label:"Client ID"},{key:"client_type",label:"Client type"},{key:"namespace_path",label:"Namespace path"},{key:"namespace_id",label:"Namespace ID"},{key:"client_first_used_time",label:"Initial usage",tooltip:"First usage date in the billing period. Vault only provides this data for clients initially used after upgrading to version 1.21."},{key:"mount_path",label:"Mount path"},{key:"mount_type",label:"Mount type"},{key:"mount_accessor",label:"Mount accessor"}]
return"Entity"===e?[...t,{key:"entity_name",label:"Entity name",tooltip:"Entity name will be empty in the case of a deleted entity."},{key:"entity_alias_name",label:"Entity alias name"},{key:"local_entity_alias",label:"Local entity alias"},{key:"policies",label:"Policies"},{key:"entity_metadata",label:"Entity metadata"},{key:"entity_alias_metadata",label:"Entity alias metadata"},{key:"entity_alias_custom_metadata",label:"Entity alias custom metadata"},{key:"entity_group_ids",label:"Entity group IDs"}]:t}},u=m(s.prototype,"flags",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"selectedTab",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"Entity"}}),d=m(s.prototype,"exportDataByTab",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return{Entity:[],"Non-entity":[],ACME:[],"Secret sync":[]}}}),m(s.prototype,"handleFilter",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"handleFilter"),s.prototype),m(s.prototype,"onClickTab",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"onClickTab"),s.prototype),s);(0,t.setComponentTemplate)(h,y)})),define("vault/components/clients/page/counts",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","core/utils/date-formatters","core/utils/client-count-utils","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,o.createTemplateFactory)({id:"EGUFd65L",block:'[[[10,0],[14,0,"has-border-bottom-light"],[12],[1,"\\n  "],[8,[39,1],null,[["@billingStartTime","@retentionMonths","@activityTimestamp","@startTimestamp","@endTimestamp","@upgradesDuringActivity","@noData","@onChange"],[[30,0,["formattedBillingStartDate"]],[30,1,["retentionMonths"]],[30,2,["responseTimestamp"]],[30,3],[30,4],[30,0,["upgradesDuringActivity"]],[28,[37,2],[[30,2,["total","clients"]]],null],[30,0,["onDateChange"]]]],null],[1,"\\n"],[13],[1,"\\n\\n"],[10,0],[14,0,"has-top-bottom-margin"],[12],[1,"\\n  "],[8,[39,3],[[24,0,"has-bottom-margin-s"]],[["@tag","@size"],["p","100"]],[["default"],[[[[1,"\\n    This is the dashboard for your overall client count usage. Review Vault\'s\\n    "],[8,[39,4],null,[["@href","@isHrefExternal"],[[28,[37,5],["/vault/docs/concepts/client-count"],null],true]],[["default"],[[[[1,"\\n      client counting documentation"]],[]]]]],[1,"\\n    for more information.\\n  "]],[]]]]],[1,"\\n\\n"],[41,[28,[37,7],[[30,2,["id"]],"no-data"],null],[[[1,"    "],[8,[39,8],null,[["@config"],[[30,1]]],null],[1,"\\n"]],[]],[[[41,[30,5],[[[1,"    "],[8,[39,9],null,[["@error"],[[30,5]]],null],[1,"\\n"]],[]],[[[41,[28,[37,7],[[30,1,["enabled"]],"Off"],null],[[[1,"      "],[8,[39,10],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n        "],[8,[30,6,["Title"]],null,null,[["default"],[[[[1,"Tracking is disabled"]],[]]]]],[1,"\\n        "],[8,[30,6,["Description"]],null,null,[["default"],[[[[1,"\\n          Tracking is currently disabled and data is not being collected. Historical data can be searched, but you will need\\n          to\\n          "],[8,[39,4],null,[["@route"],["vault.cluster.clients.edit"]],[["default"],[[[[1,"edit the configuration"]],[]]]]],[1,"\\n          to enable tracking again.\\n        "]],[]]]]],[1,"\\n      "]],[6]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,2,["total"]],[[[41,[30,0,["upgradeExplanations"]],[[[1,"        "],[8,[39,10],[[24,0,"has-bottom-margin-m"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n          "],[8,[30,7,["Title"]],null,null,[["default"],[[[[1,"\\n            Client count data contains\\n            "],[1,[28,[35,11],[[30,0,["upgradeExplanations","length"]],"upgrade"],null]],[1,"\\n          "]],[]]]]],[1,"\\n          "],[8,[30,7,["Description"]],null,null,[["default"],[[[[1,"\\n            Vault was upgraded during this time period. Keep this in mind while looking at the data. Visit our\\n            "],[8,[39,4],null,[["@isHrefExternal","@href"],[true,[28,[37,5],["/vault/docs/concepts/client-count/faq#q-which-vault-version-reflects-the-most-accurate-client-counts"],null]]],[["default"],[[[[1,"\\n              Client count FAQ\\n            "]],[]]]]],[1,"\\n            for more information.\\n          "]],[]]]]],[1,"\\n          "],[8,[30,7,["Description"]],null,null,[["default"],[[[[1,"\\n            "],[10,"ul"],[14,0,"bullet"],[12],[1,"\\n"],[42,[28,[37,14],[[28,[37,14],[[30,0,["upgradeExplanations"]]],null]],null],null,[[[1,"                "],[10,"li"],[12],[1,[30,8]],[13],[1,"\\n"]],[8]],null],[1,"            "],[13],[1,"\\n          "]],[]]]]],[1,"\\n        "]],[7]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,16],[[30,0,["version","isEnterprise"]],[28,[37,2],[[30,0,["flags","isHvdManaged"]]],null]],null],[[[1,"        "],[8,[39,17],null,null,null],[1,"\\n"]],[]],null],[1,"\\n"],[1,"      "],[18,9,null],[1,"\\n"]],[]],[[[41,[28,[37,16],[[30,0,["version","isCommunity"]],[28,[37,19],[[28,[37,2],[[30,3]],null],[28,[37,2],[[30,4]],null]],null]],null],[[[1,"      "],[8,[39,20],null,[["@title","@message"],["Input the start and end dates to view client attribution by path.","Only historical data may be queried. No data is available for the current month."]],null],[1,"\\n"]],[]],[[[1,"      "],[8,[39,20],null,[["@title","@message"],["No data received",[52,[30,0,["version","isCommunity"]],"Select a start and end date above to query client count data.","Select a different date range to view client count data."]]],null],[1,"\\n    "]],[]]]],[]]],[1,"  "]],[]]]],[]]],[13]],["@config","@activity","@startTimestamp","@endTimestamp","@activityError","A","A","info","&default"],false,["div","clients/page-header","not","hds/text/body","hds/link/inline","doc-link","if","eq","clients/no-data","clients/counts/error","hds/alert","pluralize","ul","each","-track-array","li","and","clients/counts/nav-bar","yield","or","empty-state"]]',moduleName:"vault/components/clients/page/counts.hbs",isStrictMode:!1})
let m=e.default=(s=class extends n.default{constructor(...e){super(...e),d(this,"flags",u,this),d(this,"version",c,this)}get formattedStartDate(){return this.args.startTimestamp?(0,l.parseAPITimestamp)(this.args.startTimestamp,"MMMM yyyy"):null}get formattedEndDate(){return this.args.endTimestamp?(0,l.parseAPITimestamp)(this.args.endTimestamp,"MMMM yyyy"):null}get formattedBillingStartDate(){return this.args.config?.billingStartTimestamp?this.args.config.billingStartTimestamp.toISOString():null}get upgradesDuringActivity(){const{versionHistory:e,activity:t}=this.args
return(0,a.filterVersionHistory)(e,t?.startTime,t?.endTime)}get upgradeExplanations(){return this.upgradesDuringActivity.length?this.upgradesDuringActivity.map((e=>{let t
const n=(0,l.parseAPITimestamp)(e.timestampInstalled,"MMM d, yyyy"),i=e.version||""
switch(!0){case i.includes("1.9"):t="- We introduced changes to non-entity token and local auth mount logic for client counting in 1.9."
break
case i.includes("1.10"):t="- We added monthly breakdowns and mount level attribution starting in 1.10."
break
case i.includes("1.17"):t="- We separated ACME clients from non-entity clients starting in 1.17."
break
default:t=""}return`${i} (upgraded on ${n}) ${t}`})):null}get versionText(){return this.version.isEnterprise?{title:"No billing start date found",message:"In order to get the most from this data, please enter your billing period start month. This will ensure that the resulting data is accurate."}:{title:"No start date found",message:"In order to get the most from this data, please enter a start month above. Vault will calculate new clients starting from that month."}}get hasSecretsSyncClients(){return this.args.activity?.total?.secret_syncs>0}onDateChange(e){this.args.onFilterChange(e)}},u=p(s.prototype,"flags",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(s.prototype,"version",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p(s.prototype,"onDateChange",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"onDateChange"),s.prototype),s);(0,t.setComponentTemplate)(f,m)})),define("vault/components/clients/page/overview",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","core/utils/client-count-utils","@ember/service","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,o.createTemplateFactory)({id:"njA3VkZD",block:'[[[1,"\\n"],[8,[39,0],null,[["@byMonthClients","@runningTotals"],[[30,0,["byMonthClients"]],[30,1,["total"]]]],null],[1,"\\n\\n"],[41,[30,1,["byNamespace"]],[[[1,"  "],[8,[39,2],null,[["@title"],["Client attribution"]],[["subheader","table"],[[[[1,"\\n      "],[8,[39,4],null,[["@dataset","@onFilter","@filterQueryParams","@dropdownMonths"],[[30,0,["activityData"]],[30,0,["handleFilter"]],[30,2],[30,0,["months"]]]],null],[1,"\\n    "]],[]],[[[1,"\\n      "],[8,[39,6],null,[["@data","@columns","@initiallySortBy","@setPageSize","@showPaginationSizeSelector"],[[30,0,["tableData"]],[30,0,["tableColumns"]],[28,[37,7],null,[["column","direction"],["clients","desc"]]],10,true]],[["emptyState"],[[[[1,"\\n          "],[8,[39,9],null,null,[["default"],[[[[1,"\\n            "],[8,[30,3,["Header"]],null,[["@title"],["No data found"]],null],[1,"\\n            "],[8,[30,3,["Body"]],null,[["@text"],["Clear or change filters to view client count data."]],null],[1,"\\n            "],[8,[30,3,["Footer"]],null,null,[["default"],[[[[1,"\\n              "],[8,[30,4,["LinkStandalone"]],null,[["@icon","@text","@href","@iconPosition"],["file-text","Client count documentation","https://developer.hashicorp.com/vault/docs/concepts/client-count","trailing"]],null],[1,"\\n            "]],[4]]]]],[1,"\\n          "]],[3]]]]],[1,"\\n        "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null]],["@activity","@filterQueryParams","A","F"],false,["clients/running-total","if","clients/counts-card",":subheader","clients/filter-toolbar",":table","clients/table","hash",":emptyState","hds/application-state"]]',moduleName:"vault/components/clients/page/overview.hbs",isStrictMode:!1})
let m=e.default=(s=class extends n.default{constructor(...e){super(...e),d(this,"flags",u,this),d(this,"selectedMonth",c,this)}get byMonthClients(){return this.flags.isHvdManaged?this.args.activity.byMonth||[]:this.args.activity.byMonth?.map((e=>e?.new_clients))||[]}get activityData(){const e=this.args.filterQueryParams.month,t=e?this.byMonthClients.find((t=>t.timestamp===e))?.namespaces:this.args.activity.byNamespace
return(0,l.flattenMounts)(t||[])}get months(){return this.byMonthClients.map((e=>e.timestamp)).reverse()}get tableData(){if(this.activityData?.length){const e={...this.args.filterQueryParams}
return e.month="",(0,l.filterTableData)(this.activityData,e)}return null}get tableColumns(){return[{key:"namespace_path",label:"Namespace",isSortable:!0},{key:"mount_path",label:"Mount path",isSortable:!0},{key:"mount_type",label:"Mount type",isSortable:!0},{key:"clients",label:"Client count",isSortable:!0}]}handleFilter(e){this.args.onFilterChange(e)}},u=p(s.prototype,"flags",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(s.prototype,"selectedMonth",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p(s.prototype,"byMonthClients",[i.cached],Object.getOwnPropertyDescriptor(s.prototype,"byMonthClients"),s.prototype),p(s.prototype,"activityData",[i.cached],Object.getOwnPropertyDescriptor(s.prototype,"activityData"),s.prototype),p(s.prototype,"months",[i.cached],Object.getOwnPropertyDescriptor(s.prototype,"months"),s.prototype),p(s.prototype,"tableData",[i.cached],Object.getOwnPropertyDescriptor(s.prototype,"tableData"),s.prototype),p(s.prototype,"handleFilter",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"handleFilter"),s.prototype),s);(0,t.setComponentTemplate)(f,m)})),define("vault/components/clients/running-total",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/service","core/helpers/to-label","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,a.createTemplateFactory)({id:"QDQooRQ8",block:'[[[1,"\\n"],[41,[30,1,["length"]],[[[1,"  "],[8,[39,1],null,[["@title","@description","@legend"],["Client usage trends",[30,0,["chartContainerText"]],[30,0,["chartLegend"]]]],[["dataLeft","dataRight"],[[[[1,"\\n      "],[8,[39,3],null,[["@tag"],["p"]],[["default"],[[[[1,"Client count and type distribution"]],[]]]]],[1,"\\n      "],[8,[39,4],[[24,0,"donut-chart"]],[["@data","@title"],[[30,0,["donutChartData"]],[52,[30,0,["flags","isHvdManaged"]],"Total unique clients","Total clients"]]],null],[1,"\\n    "]],[]],[[[1,"\\n      "],[10,0],[14,0,"flex space-between has-bottom-margin-xl left-padding-16"],[12],[1,"\\n        "],[8,[39,3],null,[["@tag"],["p"]],[["default"],[[[[1,"Client usage by month"]],[]]]]],[1,"\\n        "],[8,[39,7],[[4,[38,8],["change",[28,[37,9],[[28,[37,10],[[30,0,["showStacked"]]],null],[28,[37,11],[[30,0,["showStacked"]]],null]],null]],null]],null,[["default"],[[[[1,"\\n          "],[8,[30,2,["Label"]],null,null,[["default"],[[[[1,"Split by client type"]],[]]]]],[1,"\\n        "]],[2]]]]],[1,"\\n      "],[13],[1,"\\n"],[41,[30,0,["showStacked"]],[[[1,"        "],[8,[39,12],null,[["@chartTitle","@data","@chartLegend","@chartHeight"],["Client usage by month",[30,0,["runningTotalData"]],[30,0,["chartLegend"]],200]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,13],null,[["@chartTitle","@data","@dataKey","@chartHeight"],["Client usage by month",[30,0,["runningTotalData"]],[30,0,["dataKey"]],200]],null],[1,"\\n"]],[]]],[1,"    "]],[]]]]],[1,"\\n"]],[]],[[[1,"  "],[8,[39,14],null,[["@title","@description"],["Client usage","Total client usage for the selected date range."]],[["default"],[[[[1,"\\n    "],[8,[39,15],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Total clients",[30,3,["clients"]],"l","The number of clients which interacted with Vault during this month. This is Vault’s primary billing metric."]],null],[1,"\\n    "],[8,[39,15],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Entity",[30,3,["entity_clients"]],"l","Representations of a particular user, client, or application that created a token via login."]],null],[1,"\\n    "],[8,[39,15],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Non-entity",[30,3,["non_entity_clients"]],"l","Clients created with a shared set of permissions, but not associated with an entity."]],null],[1,"\\n    "],[8,[39,15],[[24,0,"column"]],[["@label","@value","@size","@subText"],["ACME",[30,3,["acme_clients"]],"l","Each ACME request counts as one client."]],null],[1,"\\n"],[41,[30,0,["flags","secretsSyncIsActivated"]],[[[1,"      "],[8,[39,15],[[24,0,"column"]],[["@label","@value","@size","@subText"],["Secret sync",[30,3,["secret_syncs"]],"l","A secret with a configured sync destination qualifies as a unique and active client."]],null],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"]],[]]]],["@byMonthClients","F","@runningTotals"],false,["if","clients/counts-card",":dataLeft","hds/text/body","vault-reporting/donut-chart",":dataRight","div","hds/form/toggle/field","on","fn","mut","not","clients/charts/vertical-bar-stacked","clients/charts/vertical-bar-basic","clients/usage-stats","stat-text"]]',moduleName:"vault/components/clients/running-total.hbs",isStrictMode:!1})
let m=e.default=(o=class extends n.default{constructor(...e){super(...e),d(this,"flags",s,this),d(this,"version",u,this),d(this,"showStacked",c,this)}get chartContainerText(){const e=this.version.isEnterprise?"billing period":"date range"
return this.flags.isHvdManaged?"Number of total unique clients in the data period by client type, and total number of unique clients per month. The monthly total is the relevant billing metric.":`Number of clients in the ${e} by client type, and a breakdown of new clients per month during the ${e}. `}get dataKey(){return this.flags.isHvdManaged?"clients":"new_clients"}get runningTotalData(){return this.args.byMonthClients.map((e=>({...e,[this.dataKey]:e.clients})))}get donutChartData(){return[{value:this.args.runningTotals.entity_clients,label:"Entity clients"},{value:this.args.runningTotals.non_entity_clients,label:"Non-entity clients"},{value:this.args.runningTotals.acme_clients,label:"ACME clients"},...this.flags.secretsSyncIsActivated?[{value:this.args.runningTotals.secret_syncs,label:"Secret sync clients"}]:[]]}get chartLegend(){return this.showStacked?[{key:"entity_clients",label:"Entity clients"},{key:"non_entity_clients",label:"Non-entity clients"},{key:"acme_clients",label:"ACME clients"},...this.flags.secretsSyncIsActivated?[{key:"secret_syncs",label:"Secret sync clients"}]:[]]:[{key:this.dataKey,label:(0,l.toLabel)([this.dataKey])}]}},s=p(o.prototype,"flags",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"version",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(o.prototype,"showStacked",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),o);(0,t.setComponentTemplate)(f,m)})),define("vault/components/clients/table",["exports","@ember/component","@glimmer/component","@ember/object","@glimmer/tracking","core/utils/paginate-list","@ember/runloop","@ember/service","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d,p,f,m,h,b
function y(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function g(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function v(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const w=(0,s.createTemplateFactory)({id:"wB/zPWVx",block:'[[[1,"\\n"],[41,[30,1],[[[1,"  "],[8,[39,1],[[17,2],[4,[38,2],[[30,0,["resetPagination"]],[30,1]],null]],[["@model","@columns","@sortBy","@sortOrder","@onSort"],[[30,0,["paginatedTableData"]],[30,3],[30,0,["sortColumn"]],[30,0,["sortDirection"]],[30,0,["updateSort"]]]],[["body"],[[[[1,"\\n      "],[8,[30,4,["Tr"]],null,null,[["default"],[[[[1,"\\n"],[42,[28,[37,5],[[28,[37,5],[[30,0,["columnKeys"]]],null]],null],null,[[[44,[[28,[37,7],[[30,4,["data"]],[30,5]],null]],[[[41,[28,[37,8],[[28,[37,9],[[30,5],"mount_type"],null],[28,[37,9],[[30,6],"deleted mount"],null]],null],[[[1,"              "],[8,[30,4,["Td"]],null,null,[["default"],[[[[8,[39,10],null,[["@text","@type"],["Deleted","outlined"]],null]],[]]]]],[1,"\\n"]],[]],[[[41,[28,[37,9],[[30,5],"client_id"],null],[[[1,"              "],[8,[30,4,["Td"]],[[24,0,"white-space-nowrap"]],null,[["default"],[[[[1,"\\n                "],[8,[39,11],null,[["@textToCopy","@color"],[[30,6],"secondary"]],null],[1,"\\n              "]],[]]]]],[1,"\\n"]],[]],[[[41,[28,[37,8],[[28,[37,9],[[30,5],"clients"],null],[30,0,["version","isEnterprise"]],[28,[37,12],[[30,0,["flags","isHvdManaged"]]],null]],null],[[[1,"              "],[8,[30,4,["Td"]],[[24,0,"white-space-nowrap"]],null,[["default"],[[[[1,"\\n                "],[8,[39,13],null,[["@route","@query"],["vault.cluster.clients.counts.client-list",[28,[30,0,["generateQueryParams"]],[[30,4,["data"]]],null]]],[["default"],[[[[1,[30,6]]],[]]]]],[1,"\\n              "]],[]]]]],[1,"\\n"]],[]],[[[1,"              "],[8,[30,4,["Td"]],[[24,0,"white-space-nowrap"]],null,[["default"],[[[[1,"\\n"],[1,"                "],[1,[52,[28,[30,0,["isObject"]],[[30,6]],null],[28,[37,14],[[30,6]],null],[30,6]]],[1,"\\n              "]],[]]]]],[1,"\\n            "]],[]]]],[]]]],[]]]],[6]]]],[5]],null],[1,"      "]],[]]]]],[1,"\\n    "]],[4]]]]],[1,"\\n\\n"],[41,[30,0,["renderPagination"]],[[[1,"    "],[8,[39,15],[[24,0,"has-top-margin-m"]],[["@currentPage","@currentPageSize","@onPageChange","@onPageSizeChange","@pageSizes","@showSizeSelector","@totalItems"],[[30,0,["currentPage"]],[30,0,["pageSize"]],[28,[37,16],[[30,0,["handlePaginationChange"]],"currentPage"],null],[28,[37,16],[[30,0,["handlePaginationChange"]],"pageSize"],null],[28,[37,17],[5,10,50,100],null],[28,[37,18],[[30,7],false],null],[30,1,["length"]]]],null],[1,"\\n"]],[]],null],[1,"\\n"]],[]],[[[1,"  "],[8,[39,19],[[24,0,"has-padding-l"]],[["@level","@hasBorder"],["mid",true]],[["default"],[[[[1,"\\n"],[41,[48,[30,9]],[[[1,"      "],[18,9,null],[1,"\\n"]],[]],[[[1,"      "],[8,[39,22],null,null,[["default"],[[[[1,"\\n        "],[8,[30,8,["Header"]],null,[["@title"],["No data to display"]],null],[1,"\\n      "]],[8]]]]],[1,"\\n"]],[]]],[1,"  "]],[]]]]],[1,"\\n"]],[]]]],["@data","&attrs","@columns","B","key","value","@showPaginationSizeSelector","A","&emptyState"],false,["if","hds/advanced-table","did-update",":body","each","-track-array","let","get","and","eq","hds/badge","hds/copy/snippet","not","hds/link/inline","stringify","hds/pagination/numbered","fn","array","or","hds/card/container","has-block","yield","hds/application-state"]]',moduleName:"vault/components/clients/table.hbs",isStrictMode:!1})
let k=e.default=(u=class extends n.default{constructor(e,t){super(e,t),y(this,"flags",c,this),y(this,"version",d,this),y(this,"currentPage",p,this),y(this,"pageSize",f,this),y(this,"sortColumn",m,this),y(this,"sortDirection",h,this),y(this,"renderPagination",b,this),g(this,"isObject",(e=>"object"==typeof e)),g(this,"generateQueryParams",(e=>{const{namespace_path:t="",mount_path:n="",mount_type:i=""}=e
return{namespace_path:t,mount_path:n,mount_type:i}}))
const{column:n,direction:i}=this.args.initiallySortBy||{}
n&&(this.sortColumn=n),i&&(this.sortDirection=i),this.args.setPageSize&&(this.pageSize=this.args.setPageSize)}get columnKeys(){return this.args.columns.map((e=>e.key))}get paginatedTableData(){const e=this.sortTableData(this.args.data)
return(0,l.paginate)(e,{page:this.currentPage,pageSize:this.pageSize})}sortTableData(e){return this.sortColumn?[...e].sort(((e,t)=>{const n=e[this.sortColumn],i=t[this.sortColumn]
return n<i?"asc"===this.sortDirection?-1:1:n>i?"asc"===this.sortDirection?1:-1:0})):e}handlePaginationChange(e,t){this[e]=t}async resetPagination(){this.renderPagination=!1,this.currentPage=1,(0,a.next)((()=>{this.renderPagination=!0}))}updateSort(e,t){this.sortColumn=e,this.sortDirection=t}},c=v(u.prototype,"flags",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=v(u.prototype,"version",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=v(u.prototype,"currentPage",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 1}}),f=v(u.prototype,"pageSize",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 5}}),m=v(u.prototype,"sortColumn",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),h=v(u.prototype,"sortDirection",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"asc"}}),b=v(u.prototype,"renderPagination",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!0}}),v(u.prototype,"columnKeys",[r.cached],Object.getOwnPropertyDescriptor(u.prototype,"columnKeys"),u.prototype),v(u.prototype,"paginatedTableData",[r.cached],Object.getOwnPropertyDescriptor(u.prototype,"paginatedTableData"),u.prototype),v(u.prototype,"handlePaginationChange",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"handlePaginationChange"),u.prototype),v(u.prototype,"resetPagination",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"resetPagination"),u.prototype),v(u.prototype,"updateSort",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"updateSort"),u.prototype),u);(0,t.setComponentTemplate)(w,k)})),define("vault/components/clients/usage-stats",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"0H6ngbl5",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-padding-m has-bottom-margin-m"]],[["@level","@hasBorder"],["base",true]],[["default"],[[[[1,"\\n  "],[10,0],[14,0,"flex row-wrap space-between"],[12],[1,"\\n    "],[8,[39,2],null,[["@tag","@weight","@size"],["h3","semibold","400"]],[["default"],[[[[1,"\\n      "],[1,[30,1]],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[39,3],[[24,0,"has-bottom-margin-s"]],[["@href","@text","@icon","@iconPosition"],[[28,[37,4],["/vault/docs/concepts/client-count/client-usage"],null],"Client usage tutorial","learn-link","trailing"]],null],[1,"\\n  "],[13],[1,"\\n"],[41,[30,2],[[[1,"    "],[8,[39,6],null,[["@tag"],["p"]],[["default"],[[[[1,"\\n      "],[1,[30,2]],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n  "],[10,"hr"],[14,0,"has-background-gray-100 has-bottom-margin-m"],[12],[13],[1,"\\n\\n  "],[10,0],[14,0,"columns"],[12],[1,"\\n    "],[18,3,null],[1,"\\n  "],[13],[1,"\\n"]],[]]]]]],["@title","@description","&default"],false,["hds/card/container","div","hds/text/display","hds/link/standalone","doc-link","if","hds/text/body","hr","yield"]]',moduleName:"vault/components/clients/usage-stats.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/confirm-action",["exports","core/components/confirm-action"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/confirm-modal",["exports","core/components/confirm-modal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/confirmation-modal",["exports","core/components/confirmation-modal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/console/command-input",["exports","@ember/component","core/utils/keys","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"hNbrBmJW",block:'[[[1,"\\n"],[10,0],[14,0,"console-ui-input"],[12],[1,"\\n"],[41,[30,0,["isRunning"]],[[[1,"    "],[10,0],[14,0,"control console-spinner is-loading"],[12],[13],[1,"\\n"]],[]],[[[1,"    "],[8,[39,2],null,null,null],[1,"\\n"]],[]]],[1,"  "],[10,"input"],[14,"aria-label","web R.E.P.L."],[14,"aria-describedby","namespace-reminder"],[15,"onkeyup",[28,[37,4],[[30,0],"handleKeyUp"],null]],[15,2,[30,0,["value"]]],[14,"autocomplete","off"],[14,"spellcheck","false"],[14,1,"console-input"],[12],[13],[1,"\\n  "],[8,[39,5],[[24,0,"hds-side-nav__icon-button"],[4,[38,6],["click",[28,[37,4],[[30,0],"fullscreen"],null]],null]],[["@icon","@text","@isIconOnly"],[[52,[30,0,["isFullscreen"]],"minimize","maximize"],[52,[30,0,["isFullscreen"]],"Minimize window","Maximize window"],true]],null],[1,"\\n"],[13],[1,"\\n"],[8,[39,7],null,[["@class","@mode","@noun"],["console-reminder","execute","command"]],null]],[],false,["div","if","chevron","input","action","hds/button","on","namespace-reminder"]]',moduleName:"vault/components/console/command-input.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,t.default.extend({onExecuteCommand(){},onFullscreen(){},onValueUpdate(){},onShiftCommand(){},value:null,isFullscreen:null,actions:{handleKeyUp(e){const t=e.target.value
switch(e.key){case n.default.ENTER:this.onExecuteCommand(t)
break
case n.default.UP:case n.default.DOWN:this.onShiftCommand(e.key)
break
default:this.onValueUpdate(t)}},fullscreen(){this.onFullscreen()}}}))})),define("vault/components/console/log-command",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"BKA+GVYQ",block:'[[[1,"\\n"],[10,0],[14,0,"is-flex-center"],[12],[1,"\\n  "],[8,[39,1],null,[["@name"],["chevron-right"]],null],[1,"\\n  "],[10,"pre"],[14,0,"console-ui-command"],[12],[1,[30,1]],[13],[1,"\\n"],[13]],["@content"],false,["div","icon","pre"]]',moduleName:"vault/components/console/log-command.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/console/log-error-with-html",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"KvqLntMQ",block:'[[[1,"\\n"],[10,0],[14,0,"console-ui-alert console-ui-alert--error"],[12],[1,"\\n  "],[8,[39,1],null,[["@name"],["x-circle-fill"]],null],[1,"\\n  "],[10,"pre"],[12],[2,[30,1]],[13],[1,"\\n"],[13]],["@content"],false,["div","icon","pre"]]',moduleName:"vault/components/console/log-error-with-html.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/console/log-error",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"vM4NzhiK",block:'[[[1,"\\n"],[10,0],[14,0,"console-ui-alert console-ui-alert--error"],[12],[1,"\\n  "],[8,[39,1],null,[["@name"],["x-circle-fill"]],null],[1,"\\n  "],[10,"pre"],[12],[1,[30,1]],[13],[1,"\\n"],[13]],["@content"],false,["div","icon","pre"]]',moduleName:"vault/components/console/log-error.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())}))
define("vault/components/console/log-help",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"DM6g8bfa",block:'[[[1,"\\n"],[10,0],[14,0,"console-ui-alert"],[12],[1,"\\n"],[8,[39,1],null,[["@name"],["info"]],null],[1,"\\n"],[10,"pre"],[12],[1,"Usage: vault <command> [args]\\n\\nCommands:\\n  read        Read data and retrieves secrets\\n  kv-get      Read data for kv v2 secret engines. Use -metadata flag to read metadata\\n  write       Write data, configuration, and secrets\\n  delete      Delete secrets and configuration\\n  list        List data or secrets\\n\\nWeb REPL Commands:\\n  api         Navigate to the Vault API explorer. Use \'api [filter]\' to prefilter the list.\\n  clear       Clear output from the log\\n  clearall    Clear output and command history\\n  fullscreen  Toggle fullscreen display\\n  refresh     Refresh the data on the current screen under the CLI window\\n\\n"],[13],[1,"\\n  "],[10,2],[14,0,"console-ui-panel-intro is-font-mono has-bottom-margin-s"],[12],[1,"\\n    For more detailed documentation, see the "],[8,[39,4],null,[["@href"],[[28,[37,5],["/vault/docs/ui/web-cli"],null]]],[["default"],[[[[1,"HashiCorp Developer site"]],[]]]]],[1,".\\n  "],[13],[1,"\\n"],[13]],[],false,["div","icon","pre","p","hds/link/inline","doc-link"]]',moduleName:"vault/components/console/log-help.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/console/log-json",["exports","@ember/component","@ember/template-factory"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,n.createTemplateFactory)({id:"wuFjICcN",block:'[[[1,"\\n"],[10,0],[14,0,"console-ui-output"],[12],[1,"\\n  "],[8,[39,1],null,[["@value","@readOnly"],[[28,[37,2],[[30,0,["content"]]],null],true]],null],[1,"\\n  "],[8,[39,3],[[24,0,"transparent icon-grey-500 top-right-absolute"]],[["@text","@isIconOnly","@textToCopy","@onError"],["Copy",true,[28,[37,2],[[30,0,["content"]]],null],[28,[37,4],[[28,[37,5],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n"],[13]],[],false,["div","json-editor","stringify","hds/copy/button","fn","set-flash-message"]]',moduleName:"vault/components/console/log-json.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,t.default.extend({attributeBindings:["data-test-component"]}))})),define("vault/components/console/log-list",["exports","@ember/component","@ember/object/computed","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"DVJTzVN7",block:'[[[1,"\\n"],[10,0],[14,0,"console-ui-output"],[12],[1,"\\n  "],[10,"pre"],[12],[1,"    Keys\\n"],[42,[28,[37,3],[[28,[37,3],[[30,0,["list"]]],null]],null],null,[[[1,"      "],[1,[30,1]],[1,"\\n"]],[1]],null],[1,"  "],[13],[1,"\\n  "],[8,[39,4],[[24,0,"transparent icon-grey-500 top-right-absolute"]],[["@text","@isIconOnly","@textToCopy","@onError"],["Copy",true,[28,[37,5],[[30,0,["list"]]],null],[28,[37,6],[[28,[37,7],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n"],[13]],["item"],false,["div","pre","each","-track-array","hds/copy/button","multi-line-join","fn","set-flash-message"]]',moduleName:"vault/components/console/log-list.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,t.default.extend({content:null,list:(0,n.reads)("content.keys")}))})),define("vault/components/console/log-object",["exports","@ember/component","@ember/string","@ember/object","columnify","@ember/template-factory"],(function(e,t,n,i,r,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0,e.stringifyObjectValues=o
const a=(0,l.createTemplateFactory)({id:"t0DZkyje",block:'[[[1,"\\n"],[10,0],[14,0,"console-ui-output"],[12],[1,"\\n  "],[10,"pre"],[12],[1,[30,0,["columns"]]],[13],[1,"\\n  "],[8,[39,2],[[24,0,"transparent icon-grey-500 top-right-absolute"]],[["@text","@isIconOnly","@textToCopy","@onError"],["Copy",true,[30,0,["columns"]],[28,[37,3],[[28,[37,4],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n"],[13]],[],false,["div","pre","hds/copy/button","fn","set-flash-message"]]',moduleName:"vault/components/console/log-object.hbs",isStrictMode:!1})
function o(e){Object.keys(e).forEach((t=>{let n=e[t]
"string"!=typeof n&&(n=JSON.stringify(n)),e[t]=n}))}e.default=(0,t.setComponentTemplate)(a,t.default.extend({content:null,columns:(0,i.computed)("content",(function(){const e=this.content
return o(e),(0,r.default)(e,{preserveNewLines:!0,headingTransform:function(e){return(0,n.capitalize)(e)}})}))}))})),define("vault/components/console/log-success",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"fEEb4Gmz",block:'[[[1,"\\n"],[10,0],[14,0,"console-ui-alert console-ui-alert--success"],[12],[1,"\\n  "],[8,[39,1],null,[["@name"],["check-circle-fill"]],null],[1,"\\n  "],[10,"pre"],[12],[1,[30,1]],[13],[1,"\\n"],[13]],["@content"],false,["div","icon","pre"]]',moduleName:"vault/components/console/log-success.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/console/log-text",["exports","@ember/component","@ember/template-factory"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,n.createTemplateFactory)({id:"jV5KoKlO",block:'[[[1,"\\n"],[10,0],[14,0,"console-ui-output"],[12],[1,"\\n  "],[10,"pre"],[12],[1,[30,1]],[13],[1,"\\n  "],[8,[39,2],[[24,0,"transparent icon-grey-500 top-right-absolute"]],[["@text","@isIconOnly","@textToCopy","@onError"],["Copy",true,[30,1],[28,[37,3],[[28,[37,4],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n"],[13]],["@content"],false,["div","pre","hds/copy/button","fn","set-flash-message"]]',moduleName:"vault/components/console/log-text.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,t.default.extend({attributeBindings:["data-test-component"]}))})),define("vault/components/console/output-log",["exports","@ember/component","@ember/template-factory"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,n.createTemplateFactory)({id:"Oo0FekKC",block:'[[[1,"\\n"],[42,[28,[37,1],[[28,[37,1],[[30,0,["outputLog"]]],null]],null],null,[[[41,[51,[30,1,["hidden"]]],[[[1,"    "],[46,[28,[37,4],["console/log-",[30,1,["type"]]],null],null,[["content"],[[30,1,["content"]]]],null],[1,"\\n"]],[]],null]],[1]],null]],["message"],false,["each","-track-array","unless","component","concat"]]',moduleName:"vault/components/console/output-log.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,t.default.extend({attributeBindings:["data-test-component"],log:null}))})),define("vault/components/console/ui-panel",["exports","@ember/component","@ember/service","@ember/object/computed","@ember/owner","@ember/runloop","@ember/string","ember-concurrency","@ember/test-waiters","vault/lib/control-group-error","vault/lib/console-helpers","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c,d){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,d.createTemplateFactory)({id:"CgqdjwYg",block:'[[[1,"\\n"],[10,0],[14,0,"console-ui-panel-content"],[12],[1,"\\n  "],[10,0],[14,0,"content has-bottom-margin-s"],[12],[1,"\\n    "],[10,0],[14,0,"console-close-button"],[12],[1,"\\n      "],[8,[39,1],[[24,0,"hds-side-nav__icon-button"],[4,[38,2],["click",[28,[37,3],[[30,0],"closeConsole"],null]],null]],[["@text","@icon","@isIconOnly"],["Close console","x",true]],null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"content has-bottom-margin-l"],[12],[1,"\\n    "],[10,2],[14,0,"console-ui-panel-intro is-font-mono has-bottom-margin-s"],[12],[1,"\\n      The Vault Web REPL provides an easy way to execute common Vault CLI commands, such as write, read, delete, and list. It\\n      does not include KV version 2 write or put commands. For guidance, type `help`. For more detailed documentation, see\\n      the\\n      "],[8,[39,5],null,[["@href"],[[28,[37,6],["/vault/docs/command/web"],null]]],[["default"],[[[[1,"HashiCorp Developer site"]],[]]]]],[1,".\\n    "],[13],[1,"\\n    "],[10,2],[14,0,"console-ui-panel-intro is-font-mono has-bottom-margin-s"],[12],[1,"Examples:"],[13],[1,"\\n    "],[10,2],[14,0,"console-ui-panel-intro is-font-mono"],[12],[1,"\\n      "],[10,1],[14,"aria-hidden","true"],[12],[1,"→ "],[13],[1,"Write secrets to kv v1: write <mount>/my-secret foo=bar"],[13],[1,"\\n    "],[10,2],[14,0,"console-ui-panel-intro is-font-mono"],[12],[1,"\\n      "],[10,1],[14,"aria-hidden","true"],[12],[1,"→ "],[13],[1,"List kv v1 secret keys: list <mount>/"],[13],[1,"\\n    "],[10,2],[14,0,"console-ui-panel-intro is-font-mono"],[12],[1,"\\n      "],[10,1],[14,"aria-hidden","true"],[12],[1,"→ "],[13],[1,"Read a kv v1 secret: read <mount>/my-secret"],[13],[1,"\\n    "],[10,2],[14,0,"console-ui-panel-intro is-font-mono"],[12],[1,"\\n      "],[10,1],[14,"aria-hidden","true"],[12],[1,"→ "],[13],[1,"Mount a kv v2 secret engine: write sys/mounts/<mount> type=kv options=version=2"],[13],[1,"\\n    "],[10,2],[14,0,"console-ui-panel-intro is-font-mono"],[12],[1,"\\n      "],[10,1],[14,"aria-hidden","true"],[12],[1,"→ "],[13],[1,"Read a kv v2 secret: kv-get <mount>/secret-path"],[13],[1,"\\n    "],[10,2],[14,0,"console-ui-panel-intro is-font-mono"],[12],[1,"\\n      "],[10,1],[14,"aria-hidden","true"],[12],[1,"→ "],[13],[1,"Read a kv v2 secret\'s metadata: kv-get <mount>/secret-path -metadata"],[13],[1,"\\n  "],[13],[1,"\\n  "],[8,[39,8],null,[["@outputLog"],[[30,0,["cliLog"]]]],null],[1,"\\n  "],[8,[39,9],null,[["@isFullscreen","@isRunning","@value","@onValueUpdate","@onFullscreen","@onExecuteCommand","@onShiftCommand"],[[30,0,["isFullscreen"]],[30,0,["isRunning"]],[30,0,["inputValue"]],[28,[37,3],[[30,0],[28,[37,10],[[30,0,["inputValue"]]],null]],null],[28,[37,3],[[30,0],"toggleFullscreen"],null],[28,[37,3],[[30,0],"executeCommand"],null],[28,[37,3],[[30,0],"shiftCommandIndex"],null]]],null],[1,"\\n"],[13]],[],false,["div","hds/button","on","action","p","hds/link/inline","doc-link","span","console/output-log","console/command-input","mut"]]',moduleName:"vault/components/console/ui-panel.hbs",isStrictMode:!1}),f=(0,s.buildWaiter)("web-repl")
e.default=(0,t.setComponentTemplate)(p,t.default.extend({console:(0,n.service)(),router:(0,n.service)(),controlGroup:(0,n.service)(),pagination:(0,n.service)(),attributeBindings:["data-test-component"],classNames:"console-ui-panel",classNameBindings:["isFullscreen:fullscreen"],isFullscreen:!1,inputValue:null,cliLog:(0,i.alias)("console.log"),didRender(){this._super(...arguments),this.scrollToBottom()},logAndOutput(e,t){this.console.logAndOutput(e,t),(0,l.schedule)("afterRender",(()=>this.scrollToBottom()))},isRunning:(0,i.or)("executeCommand.isRunning","refreshRoute.isRunning"),executeCommand:(0,o.task)((function*(e,t=!1){this.set("inputValue","")
const n=f.beginAsync(),i=this.console
let r
if((0,c.executeUICommand)(e,(e=>this.logAndOutput(e)),{api:()=>this.routeToExplore.perform(e),clearall:()=>i.clearLog(!0),clear:()=>i.clearLog(),fullscreen:()=>this.toggleProperty("isFullscreen"),refresh:()=>this.refreshRoute.perform()}))return void f.endAsync(n)
try{r=(0,c.parseCommand)(e)}catch(b){return t&&this.logAndOutput(e,{type:"help"}),void f.endAsync(n)}const{method:l,flagArray:o,path:s,dataArray:d}=r,p=(0,c.extractFlagsFromStrings)(o,l),m=(0,c.extractDataFromStrings)(d),h=(0,c.formattedErrorFromInput)(s,l,p,d)
if(h)return this.logAndOutput(e,h),void f.endAsync(n)
try{const t=yield i[(0,a.camelize)(l)].call(i,s,m,p)
this.logAndOutput(e,(0,c.logFromResponse)(t,s,l,p))}catch(y){if(y instanceof u.default)return f.endAsync(n),this.logAndOutput(e,this.controlGroup.logFromError(y))
this.logAndOutput(e,(0,c.logFromError)(y,s,l))}f.endAsync(n)})),refreshRoute:(0,o.task)((function*(){const e=(0,r.getOwner)(this).lookup("router:main").currentRouteName
try{this.pagination.clearDataset(),yield this.router.transitionTo(e),this.logAndOutput(null,{type:"success",content:"The current screen has been refreshed!"})}catch(t){this.logAndOutput(null,{type:"error",content:"The was a problem refreshing the current screen."})}})),routeToExplore:(0,o.task)((function*(e){const t=e.replace("api","").trim()
let n="Welcome to the Vault API explorer! \nYou can search for endpoints, see what parameters they accept, and even execute requests with your current token."
t&&(n=`Welcome to the Vault API explorer! \nWe've filtered the list of endpoints for '${t}'.`)
try{yield this.router.transitionTo("vault.cluster.tools.open-api-explorer",{queryParams:{filter:t}}),this.logAndOutput(null,{type:"success",content:n})}catch(i){"TransitionAborted"===i.message?this.logAndOutput(null,{type:"success",content:n}):this.logAndOutput(null,{type:"error",content:"There was a problem navigating to the api explorer."})}})),shiftCommandIndex(e){this.console.shiftCommandIndex(e,(e=>{this.set("inputValue",e)}))},scrollToBottom(){this.element.scrollTop=this.element.scrollHeight},actions:{closeConsole(){this.set("console.isOpen",!1)},toggleFullscreen(){this.toggleProperty("isFullscreen")},executeCommand(e){this.executeCommand.perform(e,!0)},shiftCommandIndex(e){this.shiftCommandIndex(e)}}}))})),define("vault/components/control-group-inline-error",["exports","core/components/control-group-inline-error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/control-group-success",["exports","@ember/component","@ember/service","ember-concurrency","@ember/template-factory"],(function(e,t,n,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const l=(0,r.createTemplateFactory)({id:"SOf0nhMk",block:'[[[1,"\\n"],[41,[28,[37,1],[[30,0,["controlGroupResponse","token"]],[30,0,["controlGroupResponse","uiParams","url"]]],null],[[[1,"  "],[10,0],[14,0,"control-group-success"],[12],[1,"\\n    You have been granted access to\\n    "],[10,"code"],[12],[1,[30,0,["model","requestPath"]]],[13],[1,". Be careful, you can only access this data once. If you need access again in the\\n    future you will need to get authorized again.\\n    "],[10,0],[14,0,"box is-shadowless is-fullwidth is-marginless has-slim-padding"],[12],[1,"\\n      "],[8,[39,4],[[4,[38,5],["click",[28,[37,6],[[30,0],[28,[37,7],[[30,0,["markAndNavigate"]]],null]],null]],null]],[["@text"],["Visit"]],null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[41,[30,0,["unwrapData"]],[[[1,"    "],[10,0],[14,0,"control-group-success is-editor"],[12],[1,"\\n      "],[10,0],[14,0,"is-relative"],[12],[1,"\\n        "],[8,[39,8],null,[["@value","@readOnly"],[[28,[37,9],[[30,0,["unwrapData"]]],null],true]],null],[1,"\\n        "],[8,[39,10],[[24,0,"transparent top-right-absolute"]],[["@text","@isIconOnly","@textToCopy","@onError"],["Copy",true,[28,[37,9],[[30,0,["unwrapData"]]],null],[28,[37,11],[[28,[37,12],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,4],null,[["@text","@color","@route","@icon","@iconPosition"],["Back","secondary","vault.cluster.access.control-groups","chevron-left","leading"]],null],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[1,"    "],[10,0],[14,0,"control-group-success"],[12],[1,"\\n      "],[11,"form"],[4,[38,6],[[30,0],[28,[37,7],[[30,0,["unwrap"]],[30,0,["token"]]],null]],[["on"],["submit"]]],[12],[1,"\\n        "],[8,[39,14],null,[["@errorMessage"],[[30,0,["error"]]]],null],[1,"\\n        "],[10,2],[12],[1,"\\n          If you have the token, you can now can access\\n          "],[10,"code"],[12],[1,[30,0,["model","requestPath"]]],[13],[1,"\\n        "],[13],[1,"\\n        "],[10,"label"],[14,"for","token"],[14,0,"is-label"],[12],[1,"\\n          Token to access data\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,17],[[24,0,"input"],[24,"autocomplete","off"],[24,"spellcheck","false"],[24,3,"token"],[24,1,"token"]],[["@value"],[[30,0,["token"]]]],null],[1,"\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n          "],[8,[39,4],[[16,"disabled",[28,[37,18],[[30,0,["token"]]],null]],[24,4,"submit"]],[["@text"],["Access"]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]]]],[]]]],[],false,["if","and","div","code","hds/button","on","action","perform","json-editor","stringify","hds/copy/button","fn","set-flash-message","form","message-error","p","label","input","not"]]',moduleName:"vault/components/control-group-success.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(l,t.default.extend({router:(0,n.service)(),controlGroup:(0,n.service)(),api:(0,n.service)(),model:null,controlGroupResponse:null,error:null,unwrapData:null,unwrap:(0,i.task)((function*(e){this.set("error",null)
try{const t=yield this.api.sys.unwrap({},this.api.buildHeaders({token:e}))
this.set("unwrapData",t.auth||t.data),this.controlGroup.deleteControlGroupToken(this.model.id)}catch(t){const{message:e}=yield this.api.parseError(t)
this.error=`Token unwrap failed: ${e}`}})).drop(),markAndNavigate:(0,i.task)((function*(){this.controlGroup.markTokenForUnwrap(this.model.id)
const{url:e}=this.controlGroupResponse.uiParams
yield this.router.transitionTo(e)})).drop()}))})),define("vault/components/control-group",["exports","@ember/component","@ember/service","@ember/object/computed","@ember/object","ember-concurrency","@ember/template-factory"],(function(e,t,n,i,r,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,a.createTemplateFactory)({id:"TGo/0k31",block:'[[[1,"\\n"],[10,0],[14,0,"box is-fullwidth is-bottomless is-sideless"],[12],[1,"\\n  "],[8,[39,1],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n  "],[10,0],[15,0,[29,["control-group-header ",[52,[30,0,["isSuccess"]],"is-success"]]]],[12],[1,"\\n    "],[10,2],[12],[1,"\\n      "],[8,[39,4],null,[["@name"],[[52,[30,0,["isSuccess"]],"check-circle-fill","lock-fill"]]],null],[1,"\\n      "],[10,"strong"],[12],[1,[30,0,["bannerPrefix"]]],[13],[1,"\\n      "],[10,1],[12],[1,[30,0,["bannerText"]]],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[41,[28,[37,7],[[30,0,["model","approved"]],[28,[37,8],[[30,0,["currentUserHasAuthorized"]]],null],[28,[37,9],[[28,[37,8],[[30,0,["model","requestEntity"]]],null],[30,0,["currentUserIsRequesting"]]],null]],null],[[[1,"    "],[8,[39,10],null,[["@model","@controlGroupResponse"],[[30,0,["model"]],[30,0,["controlGroupResponse"]]]],null],[1,"\\n"]],[]],[[[1,"    "],[10,0],[14,0,"control-group"],[12],[1,"\\n      "],[10,0],[12],[1,"\\n"],[41,[30,0,["model","requestEntity","canRead"]],[[[1,"          "],[8,[39,11],null,[["@route","@models"],["vault.cluster.access.identity.show",[28,[37,12],["entities",[30,0,["model","requestEntity","id"]],"details"],null]]],[["default"],[[[[1,"\\n            "],[1,[30,0,["requestorName"]]],[1,"\\n          "]],[]]]]],[1,"\\n"]],[]],[[[1,"          "],[1,[30,0,["requestorName"]]],[1,"\\n"]],[]]],[1,"        "],[41,[30,0,["currentUserIsRequesting"]],[[[1,"are"]],[]],[[[1,"is"]],[]]],[1,"\\n"],[41,[30,0,["model","approved"]],[[[1,"          authorized to access\\n          "],[10,"code"],[12],[1,[30,0,["model","requestPath"]]],[13],[1,"\\n"]],[]],[[[1,"          requesting access to\\n          "],[10,"code"],[12],[1,[30,0,["model","requestPath"]]],[13],[1,"\\n"]],[]]],[1,"      "],[13],[1,"\\n\\n"],[41,[28,[37,9],[[28,[37,8],[[30,0,["model","requestEntity"]]],null],[30,0,["currentUserIsRequesting"]]],null],[[[1,"        "],[8,[39,14],null,[["@type","@color","@icon"],["inline",[52,[30,0,["isSuccess"]],"success","warning"],false]],[["default"],[[[[1,"\\n          "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Accessor"]],[]]]]],[1,"\\n          "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n            "],[8,[39,15],null,[["@textToCopy","@color","@onError"],[[30,0,["model","id"]],"secondary",[28,[37,16],[[28,[37,17],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n          "]],[]]]]],[1,"\\n        "]],[1]]]]],[1,"\\n"]],[]],null],[1,"\\n      "],[10,0],[14,0,"authorizations"],[12],[1,"\\n"],[41,[28,[37,18],[[30,0,["model","authorizations","length"]],0],null],[[[1,"          "],[10,1],[14,0,"has-text-success"],[12],[1,"\\n            "],[8,[39,4],null,[["@name"],["check-circle"]],null],[1,"\\n          "],[13],[1,"\\n          Already approved by\\n"],[42,[28,[37,20],[[28,[37,20],[[30,0,["model","authorizations"]]],null]],null],null,[[[41,[30,2,["canRead"]],[[[8,[39,11],null,[["@route","@models"],["vault.cluster.access.identity.show",[28,[37,12],["entities",[30,2,["id"]],"details"],null]]],[["default"],[[[[1,"\\n                "],[1,[30,2,["name"]]],[1,"\\n              "]],[]]]]]],[]],[[[1,[30,2,["name"]]]],[]]],[41,[28,[37,21],[[28,[37,22],[[30,3]],null],[30,0,["model","authorizations","length"]]],null],[[[1,","]],[]],null],[1,"\\n"]],[2,3]],null]],[]],[[[1,"          "],[10,1],[14,0,"has-text-grey"],[12],[1,"\\n            "],[8,[39,4],null,[["@name"],["check-circle"]],null],[1,"\\n          "],[13],[1,"\\n          Awaiting authorization.\\n"]],[]]],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]]],[1,"\\n"],[41,[30,0,["controlGroupResponse","token"]],[[[1,"    "],[10,0],[14,0,"has-bottom-margin-m has-top-margin-m"],[12],[1,"\\n      "],[10,2],[14,0,"has-text-grey has-padding-xxs"],[12],[1,"\\n        We’ve saved your request token, but you may want to copy it just in case:\\n      "],[13],[1,"\\n      "],[8,[39,15],null,[["@textToCopy","@color","@onError"],[[30,0,["controlGroupResponse","token"]],"secondary",[28,[37,16],[[28,[37,17],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n    "],[13],[1,"\\n"]],[]],null],[41,[51,[28,[37,7],[[30,0,["model","approved"]],[28,[37,9],[[28,[37,8],[[30,0,["model","requestEntity"]]],null],[30,0,["currentUserIsRequesting"]]],null]],null]],[[[1,"    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n"],[41,[30,0,["model","canAuthorize"]],[[[41,[28,[37,9],[[30,0,["model","approved"]],[30,0,["currentUserHasAuthorized"]]],null],[[[1,"          "],[8,[39,24],null,[["@text","@color","@route","@icon","@iconPosition"],["Back","secondary","vault.cluster.access.control-groups","chevron-left","leading"]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,24],[[4,[38,25],["click",[28,[37,26],[[30,0],[28,[37,27],[[30,0,["authorize"]]],null]],null]],null]],[["@text","@icon"],["Authorize",[52,[30,0,["authorize","isRunning"]],"loading"]]],null],[1,"\\n"]],[]]]],[]],[[[1,"        "],[8,[39,24],[[4,[38,25],["click",[28,[37,26],[[30,0],[28,[37,27],[[30,0,["refresh"]]],null]],null]],null]],[["@text","@icon"],["Refresh",[52,[30,0,["refresh","isRunning"]],"loading"]]],null],[1,"\\n"]],[]]],[1,"    "],[13],[1,"\\n"]],[]],null],[13]],["A","authorization","index"],false,["div","message-error","if","p","icon","strong","span","and","not","or","control-group-success","link-to","array","code","hds/alert","hds/copy/snippet","fn","set-flash-message","gt","each","-track-array","lt","inc","unless","hds/button","on","action","perform"]]',moduleName:"vault/components/control-group.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(o,t.default.extend({tagName:"",auth:(0,n.service)(),controlGroup:(0,n.service)(),model:null,didReceiveAttrs(){this._super(...arguments)
const e=this.model.id,t=this.controlGroup.wrapInfoForAccessor(e)
this.set("controlGroupResponse",t)},currentUserEntityId:(0,i.alias)("auth.authData.entityId"),currentUserIsRequesting:(0,r.computed)("currentUserEntityId","model.requestEntity.id",(function(){return!!this.model.requestEntity&&this.currentUserEntityId===this.model.requestEntity.id})),currentUserHasAuthorized:(0,r.computed)("currentUserEntityId","model.authorizations.@each.id",(function(){const e=this.model.authorizations||[]
return Boolean(e.find((e=>e.id===this.currentUserEntityId)))})),isSuccess:(0,i.or)("currentUserHasAuthorized","model.approved"),requestorName:(0,r.computed)("currentUserIsRequesting","model.requestEntity",(function(){const e=this.model.requestEntity
return this.currentUserIsRequesting?"You":e&&e.name?e.name:"Someone"})),bannerPrefix:(0,r.computed)("model.approved","currentUserHasAuthorized",(function(){return this.currentUserHasAuthorized?"Thanks!":this.model.approved?"Success!":"Locked"})),bannerText:(0,r.computed)("model.approved","currentUserIsRequesting","currentUserHasAuthorized",(function(){const e=this.model.approved,{currentUserHasAuthorized:t,currentUserIsRequesting:n}=this
return t?"You have given authorization":n&&e?"You have been given authorization":e?"This Control Group has been authorized":n?"The path you requested is locked by a Control Group":"Someone is requesting access to a path locked by a Control Group"})),refresh:(0,l.task)((function*(){try{yield this.model.reload()}catch(e){this.set("errors",e)}})).drop(),authorize:(0,l.task)((function*(){try{yield this.model.save(),yield this.refresh.perform()}catch(e){this.set("errors",e)}})).drop()}))})),define("vault/components/copy-secret-dropdown",["exports","core/components/copy-secret-dropdown"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/dashboard/client-count-card",["exports","@ember/component","@glimmer/component","core/utils/timestamp","ember-concurrency","@ember/test-waiters","@glimmer/tracking","@ember/service","core/utils/date-formatters","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f,m
function h(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function b(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,u.createTemplateFactory)({id:"Wu5diWJz",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n  "],[10,0],[14,0,"is-flex-between"],[12],[1,"\\n    "],[10,"h2"],[14,0,"title is-4 has-bottom-margin-xxs"],[12],[1,"\\n      Client count\\n    "],[13],[1,"\\n\\n    "],[8,[39,3],null,[["@route"],["vault.cluster.clients"]],[["default"],[[[[1,"Details"]],[]]]]],[1,"\\n  "],[13],[1,"\\n\\n  "],[10,"hr"],[14,0,"has-background-gray-100"],[12],[13],[1,"\\n\\n"],[41,[30,0,["fetchClientActivity","isRunning"]],[[[1,"    "],[8,[39,6],null,null,null],[1,"\\n"]],[]],[[[41,[30,0,["activityData"]],[[[1,"      "],[10,0],[14,0,"is-grid grid-2-columns grid-gap-2 has-top-margin-m grid-align-items-start is-flex-v-centered"],[12],[1,"\\n        "],[8,[39,7],null,[["@label","@value","@size","@subText"],["Total",[30,0,["activityData","total","clients"]],"l",[30,0,["statSubText","total"]]]],null],[1,"\\n        "],[8,[39,7],null,[["@label","@value","@size","@subText"],["New",[30,0,["currentMonthActivityTotalCount"]],"l",[30,0,["statSubText","new"]]]],null],[1,"\\n      "],[13],[1,"\\n\\n      "],[10,0],[14,0,"has-top-margin-l is-flex-center"],[12],[1,"\\n        "],[8,[39,8],[[16,"disabled",[30,0,["fetchClientActivity","isRunning"]]],[24,0,"has-padding-xxs"],[4,[38,9],["click",[28,[37,10],[[30,0,["fetchClientActivity"]]],null]],null]],[["@text","@isIconOnly","@color","@icon"],["Refresh",true,"tertiary","sync"]],null],[1,"\\n        "],[10,"small"],[14,0,"has-left-margin-xs has-text-grey"],[12],[1,"\\n          Updated\\n          "],[1,[28,[35,12],[[30,0,["updatedAt"]],"MMM d yyyy, h:mm:ss aaa"],[["withTimeZone"],[true]]]],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[1,"      "],[8,[39,13],null,[["@config"],[[30,0,["activityConfig"]]]],null],[1,"\\n"]],[]]]],[]]]],[]]]]]],[],false,["hds/card/container","div","h2","link-to","hr","if","vault-logo-spinner","stat-text","hds/button","on","perform","small","date-format","clients/no-data"]]',moduleName:"vault/components/dashboard/client-count-card.hbs",isStrictMode:!1})
let g=e.default=(c=class extends n.default{constructor(){super(...arguments),h(this,"store",d,this),h(this,"activityData",p,this),h(this,"activityConfig",f,this),h(this,"updatedAt",m,this),this.fetchClientActivity.perform()}get currentMonthActivityTotalCount(){return this.activityData?.byMonth?.lastObject?.new_clients.clients}get statSubText(){const e=e=>(0,s.parseAPITimestamp)(e,"MMM yyyy"),{startTime:t,endTime:n}=this.activityData
return t&&n?{total:`The number of clients in this billing period (${e(t)} - ${e(n)}).`,new:"The number of clients new to Vault in the current month."}:{total:"No total client data available.",new:"No new client data available."}}*fetchClientActivity(e){e&&e.preventDefault(),this.updatedAt=i.default.now().toISOString()
try{this.activityData=yield this.store.findRecord("clients/activity","clients/activity")}catch(t){this.activityConfig=yield this.store.queryRecord("clients/config",{}).catch((()=>null)),this.error=t}}},d=b(c.prototype,"store",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(c.prototype,"activityData",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f=b(c.prototype,"activityConfig",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=b(c.prototype,"updatedAt",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b(c.prototype,"fetchClientActivity",[r.task,l.waitFor],Object.getOwnPropertyDescriptor(c.prototype,"fetchClientActivity"),c.prototype),c);(0,t.setComponentTemplate)(y,g)})),define("vault/components/dashboard/learn-more-card",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"maLCp2e7",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n  "],[10,"h2"],[14,0,"title is-4 has-bottom-margin-xxs"],[12],[1,"Learn more"],[13],[1,"\\n  "],[10,0],[14,0,"sub-text"],[12],[1,"\\n    Explore the features of Vault and learn advance practices with the following tutorials and documentation.\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"has-top-margin-xs"],[12],[1,"\\n"],[42,[28,[37,4],[[28,[37,4],[[30,0,["learnMoreLinks"]]],null]],null],null,[[[41,[28,[37,6],[[28,[37,7],[[30,1,["requiredFeature"]],[30,2],[28,[37,8],[[30,1,["requiredFeature"]]],null]],null],[28,[37,9],[[30,1,["requiredFeature"]]],null]],null],[[[1,"        "],[8,[39,10],[[24,0,"is-size-8 has-font-weight-normal is-block has-bottom-margin-xxs"]],[["@path"],[[30,1,["link"]]]],[["default"],[[[[1,"\\n          "],[8,[39,11],null,[["@name"],[[30,1,["icon"]]]],null],[1,"\\n          "],[1,[30,1,["title"]]],[1,"\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"]],[1]],null],[1,"  "],[13],[1,"\\n"]],[]]]]]],["learnMoreLink","@isEnterprise"],false,["hds/card/container","h2","div","each","-track-array","if","or","and","has-feature","not","doc-link","icon"]]',moduleName:"vault/components/dashboard/learn-more-card.hbs",isStrictMode:!1})
class l extends n.default{get learnMoreLinks(){return[{link:"/vault/tutorials/secrets-management",icon:"docs-link",title:"Secrets Management"},{link:"/vault/tutorials/monitoring",icon:"docs-link",title:"Monitor & Troubleshooting"},{link:"/vault/tutorials/adp/transform",icon:"learn-link",title:"Advanced Data Protection: Transform engine",requiredFeature:"Transform Secrets Engine"},{link:"/vault/tutorials/secrets-management/pki-engine",icon:"learn-link",title:"Build your own Certificate Authority (CA)"}]}}e.default=l,(0,t.setComponentTemplate)(r,l)})),define("vault/components/dashboard/overview",["exports","@ember/component","@glimmer/component","@ember/service","@ember/template-factory"],(function(e,t,n,i,r){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,r.createTemplateFactory)({id:"Rt8J6Hbe",block:'[[[1,"\\n"],[8,[39,0],null,[["@version"],[[30,1]]],null],[1,"\\n\\n"],[10,0],[14,0,"has-bottom-margin-xl"],[12],[1,"\\n  "],[10,0],[14,0,"is-flex-row gap-24"],[12],[1,"\\n"],[41,[30,1,["isEnterprise"]],[[[1,"      "],[10,0],[14,0,"is-flex-column is-flex-1 gap-24"],[12],[1,"\\n"],[41,[28,[37,3],[[28,[37,4],["clients"],[["routeParams"],["activity"]]],[30,0,["shouldShowClientCount"]]],null],[[[1,"          "],[8,[39,5],null,null,null],[1,"\\n"]],[]],null],[41,[28,[37,3],[[28,[37,4],["status"],[["routeParams"],["replication"]]],[28,[37,6],[[28,[37,7],[[30,2]],null]],null],[30,3]],null],[[[1,"          "],[8,[39,8],null,[["@replication","@version","@refresh","@updatedAt"],[[30,2],[30,1],[30,4],[30,5]]],null],[1,"\\n"]],[]],null],[1,"        "],[8,[39,9],null,[["@secretsEngines"],[[30,6]]],null],[1,"\\n      "],[13],[1,"\\n\\n      "],[10,0],[14,0,"is-flex-column is-flex-1 gap-24"],[12],[1,"\\n        "],[8,[39,10],null,[["@secretsEngines"],[[30,6]]],null],[1,"\\n"],[41,[30,7],[[[1,"          "],[8,[39,11],null,[["@vaultConfiguration"],[[30,7]]],null],[1,"\\n"]],[]],null],[1,"        "],[10,0],[12],[1,"\\n          "],[8,[39,12],null,[["@isEnterprise"],[[30,1,["isEnterprise"]]]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[1,"      "],[10,0],[14,0,"is-flex-column is-flex-1 gap-24"],[12],[1,"\\n        "],[8,[39,9],null,[["@secretsEngines"],[[30,6]]],null],[1,"\\n        "],[10,0],[12],[1,"\\n          "],[8,[39,12],null,[["@isEnterprise"],[[30,1,["isEnterprise"]]]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"is-flex-column is-flex-1 gap-24"],[12],[1,"\\n        "],[8,[39,10],null,[["@secretsEngines"],[[30,6]]],null],[1,"\\n"],[41,[30,7],[[[1,"          "],[8,[39,11],null,[["@vaultConfiguration"],[[30,7]]],null],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n"]],[]]],[1,"  "],[13],[1,"\\n"],[13]],["@version","@replication","@isRootNamespace","@refreshModel","@replicationUpdatedAt","@secretsEngines","@vaultConfiguration"],false,["dashboard/vault-version-title","div","if","and","has-permission","dashboard/client-count-card","not","is-empty-value","dashboard/replication-card","dashboard/secrets-engines-card","dashboard/quick-actions-card","dashboard/vault-configuration-details-card","dashboard/learn-more-card"]]',moduleName:"vault/components/dashboard/overview.hbs",isStrictMode:!1})
let s=e.default=(l=class extends n.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="namespace",r=this,(i=a)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}get shouldShowClientCount(){const{version:e,isRootNamespace:t}=this.args,{namespace:n}=this
return!!e.isEnterprise&&(!!n.inHvdAdminNamespace||!!t)}},u=l.prototype,c="namespace",d=[i.service],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},m={},Object.keys(p).forEach((function(e){m[e]=p[e]})),m.enumerable=!!m.enumerable,m.configurable=!!m.configurable,("value"in m||m.initializer)&&(m.writable=!0),m=d.slice().reverse().reduce((function(e,t){return t(u,c,e)||e}),m),f&&void 0!==m.initializer&&(m.value=m.initializer?m.initializer.call(f):void 0,m.initializer=void 0),a=void 0===m.initializer?(Object.defineProperty(u,c,m),null):m,l)
var u,c,d,p,f,m;(0,t.setComponentTemplate)(o,s)})),define("vault/components/dashboard/quick-actions-card",["exports","@ember/component","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","kv/utils/kv-breadcrumbs","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p
function f(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function m(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h=(0,o.createTemplateFactory)({id:"3wNTv4mm",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n  "],[10,"h2"],[14,0,"title is-4"],[12],[1,"Quick actions"],[13],[1,"\\n"],[41,[30,0,["filteredSecretEngines"]],[[[1,"    "],[10,0],[14,0,"has-top-margin-m has-bottom-margin-m"],[12],[1,"\\n      "],[10,"h3"],[14,0,"title is-marginless is-6"],[12],[1,"Secrets engines"],[13],[1,"\\n      "],[10,2],[14,0,"is-size-8 has-top-margin-xxs has-bottom-margin-s has-text-grey"],[12],[1,"Supported engines include databases, KV\\n        version 2, and PKI."],[13],[1,"\\n      "],[8,[39,6],[[24,0,"is-marginless"]],[["@id","@options","@selectLimit","@disallowNewItems","@fallbackComponent","@onChange","@placeholder","@displayInherit","@shouldRenderName","@passObject","@objectKeys"],["type-to-select-a-mount",[30,0,["mountOptions"]],"1",true,"input-search",[30,0,["handleSearchEngineSelect"]],"Type to select a mount",true,true,true,[28,[37,7],["type","version"],null]]],null],[1,"\\n    "],[13],[1,"\\n\\n"],[41,[30,0,["selectedEngine"]],[[[1,"      "],[10,"h3"],[14,1,"action-select-title"],[14,0,"title is-6"],[12],[1,"Action"],[13],[1,"\\n      "],[8,[39,8],null,[["@name","@options","@isFullwidth","@selectedValue","@onChange","@noDefault","@ariaLabel"],["action-select",[30,0,["actionOptions"]],true,[30,0,["selectedAction"]],[30,0,["setSelectedAction"]],true,"Action"]],null],[1,"\\n\\n"],[41,[30,0,["selectedAction"]],[[[41,[30,0,["searchSelectParams","isKV"]],[[[1,"          "],[8,[39,9],null,[["@label","@value","@mountPath","@onChange"],["Secret Path",[30,0,["paramValue"]],[30,0,["selectedEngine","id"]],[28,[37,10],[[28,[37,11],[[30,0,["paramValue"]]],null]],null]]],null],[1,"\\n"]],[]],[[[41,[30,0,["searchSelectParams","model"]],[[[1,"          "],[10,"h3"],[14,0,"title is-6"],[12],[1,[30,0,["searchSelectParams","title"]]],[13],[1,"\\n\\n          "],[8,[39,6],[[24,0,"is-flex-grow-1"]],[["@ariaLabel","@selectLimit","@models","@placeholder","@disallowNewItems","@onChange","@fallbackComponent","@disabled","@nameKey","@queryObject","@objectKeys","@passObject","@shouldRenderName"],[[30,0,["searchSelectParams","title"]],"1",[28,[37,7],[[30,0,["searchSelectParams","model"]]],null],[30,0,["searchSelectParams","placeholder"]],true,[30,0,["handleActionSelect"]],"input-search",[28,[37,12],[[30,0,["searchSelectParams","model"]]],null],[30,0,["searchSelectParams","nameKey"]],[30,0,["searchSelectParams","queryObject"]],[30,0,["searchSelectParams","objectKeys"]],true,[30,0,["searchSelectParams","nameKey"]]]],null],[1,"\\n        "]],[]],null]],[]]],[1,"        "],[10,0],[12],[1,"\\n          "],[8,[39,13],[[24,0,"has-top-margin-m"],[16,"disabled",[28,[37,12],[[28,[37,14],[[30,0,["selectedAction"]],[30,0,["selectedEngine"]],[30,0,["paramValue"]]],null]],null]],[4,[38,15],["click",[30,0,["navigateToPage"]]],null]],[["@text"],[[30,0,["searchSelectParams","buttonText"]]]],null],[1,"\\n        "],[13],[1,"\\n"]],[]],null]],[]],[[[1,"      "],[8,[39,16],null,[["@title","@message"],["No mount selected","Select a mount above to get started."]],null],[1,"\\n"]],[]]]],[]],[[[1,"\\n    "],[8,[39,16],null,[["@title","@message"],["Welcome to quick actions","Access secret engine actions easily. Enable a compatible secret engine (such as database, KV version 2, or PKI) to get started."]],[["default"],[[[[1,"\\n      "],[8,[39,17],null,[["@icon","@iconPosition","@text","@route"],["chevron-right","trailing","Enable a secrets engine","vault.cluster.secrets.mounts"]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]]],[]]]]]],[],false,["hds/card/container","h2","if","div","h3","p","search-select","array","select","kv-suggestion-input","fn","mut","not","hds/button","and","on","empty-state","hds/link/standalone"]]',moduleName:"vault/components/dashboard/quick-actions-card.hbs",isStrictMode:!1}),b=["pki","database"]
let y=e.default=(s=class extends n.default{constructor(...e){super(...e),f(this,"router",u,this),f(this,"selectedEngine",c,this),f(this,"selectedAction",d,this),f(this,"paramValue",p,this)}get actionOptions(){switch(this.selectedEngine.type){case"kv":return["Find KV secrets"]
case"database":return["Generate credentials for database"]
case"pki":return["Issue certificate","View certificate","View issuer"]
default:return[]}}get searchSelectParams(){switch(this.selectedAction){case"Find KV secrets":return{isKV:!0,buttonText:"Read secrets",route:"vault.cluster.secrets.backend.kv.secret.index"}
case"Generate credentials for database":return{title:"Role to use",buttonText:"Generate credentials",model:"database/role",route:"vault.cluster.secrets.backend.credentials",queryObject:{backend:this.selectedEngine.id}}
case"Issue certificate":return{title:"Role to use",placeholder:"Type to find a role",buttonText:"Issue leaf certificate",model:"pki/role",route:"vault.cluster.secrets.backend.pki.roles.role.generate",queryObject:{backend:this.selectedEngine.id}}
case"View certificate":return{title:"Certificate serial number",placeholder:"33:a3:...",buttonText:"View certificate",model:"pki/certificate/base",route:"vault.cluster.secrets.backend.pki.certificates.certificate.details",queryObject:{backend:this.selectedEngine.id}}
case"View issuer":return{title:"Issuer",placeholder:"Type issuer name or ID",buttonText:"View issuer",model:"pki/issuer",route:"vault.cluster.secrets.backend.pki.issuers.issuer.details",nameKey:"issuerName",queryObject:{backend:this.selectedEngine.id},objectKeys:["id","issuerName"]}
default:return{placeholder:"Please select an action above",buttonText:"Select an action",model:""}}}get filteredSecretEngines(){return this.args.secretsEngines?.filter((e=>"kv"===e.type&&2==e.version||b.includes(e.type)))}get mountOptions(){return this.filteredSecretEngines?.map((e=>{const{id:t,type:n}=e
return{name:t,type:n,id:t}}))}handleSearchEngineSelect([e]){this.selectedEngine=e,this.selectedAction=null,this.paramValue=null}setSelectedAction(e){this.selectedAction=e,this.paramValue=null}handleActionSelect(e){Array.isArray(e)?this.paramValue=e[0]:this.paramValue=e}navigateToPage(){let e=this.searchSelectParams.route,t=this.paramValue.id||this.paramValue
if("kv"===this.selectedEngine.type){const n=this.paramValue.path||this.paramValue
e=(0,a.pathIsDirectory)(n)?"vault.cluster.secrets.backend.kv.list-directory":"vault.cluster.secrets.backend.kv.secret.index",t=n}this.router.transitionTo(e,this.selectedEngine.id,t)}},u=m(s.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"selectedEngine",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(s.prototype,"selectedAction",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(s.prototype,"paramValue",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m(s.prototype,"handleSearchEngineSelect",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"handleSearchEngineSelect"),s.prototype),m(s.prototype,"setSelectedAction",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"setSelectedAction"),s.prototype),m(s.prototype,"handleActionSelect",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"handleActionSelect"),s.prototype),m(s.prototype,"navigateToPage",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"navigateToPage"),s.prototype),s);(0,t.setComponentTemplate)(h,y)})),define("vault/components/dashboard/replication-card",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"dABs3Bg3",block:'[[[8,[39,0],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n\\n  "],[10,0],[14,0,"is-flex-between"],[12],[1,"\\n    "],[10,"h2"],[14,0,"title is-4 has-bottom-margin-xxs"],[12],[1,"\\n      Cluster replication status\\n    "],[13],[1,"\\n\\n"],[41,[28,[37,4],[[30,1,["dr","clusterId"]],[30,1,["performance","clusterId"]]],null],[[[1,"      "],[8,[39,5],null,[["@route"],["vault.cluster.replication.index"]],[["default"],[[[[1,"\\n        Details\\n      "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n\\n"],[41,[28,[37,4],[[30,1,["dr","clusterId"]],[30,1,["performance","clusterId"]]],null],[[[1,"    "],[10,"hr"],[14,0,"has-background-gray-100"],[12],[13],[1,"\\n"],[41,[28,[37,7],[[30,2,["hasPerfReplication"]],[30,2,["hasDRReplication"]]],null],[[[1,"      "],[10,0],[14,0,"is-grid grid-2-columns grid-gap-2 has-top-margin-m has-bottom-margin-xs grid-align-items-start"],[12],[1,"\\n        "],[8,[39,8],null,[["@title","@name","@state","@clusterStates"],["DR primary","dr",[30,1,["dr","state"]],[28,[37,9],[[30,1,["dr","state"]]],null]]],null],[1,"\\n        "],[8,[39,8],null,[["@title","@name","@state","@clusterStates"],[[29,["Performance ",[52,[30,1,["performance","isPrimary"]],"primary","secondary"]]],"performance",[52,[30,1,["performance","clusterId"]],[30,1,["performance","state"]],"not set up"],[52,[30,1,["performance","clusterId"]],[28,[37,9],[[30,1,["performance","state"]]],null]]]],null],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[41,[30,2,["hasDRReplication"]],[[[1,"      "],[8,[39,5],[[24,0,"title is-5 has-text-weight-semibold is-marginless"]],[["@route","@model"],["vault.cluster.replication.mode.index","dr"]],[["default"],[[[[1,"\\n        DR Primary\\n      "]],[]]]]],[1,"\\n\\n      "],[10,0],[14,0,"is-grid grid-2-columns grid-gap-2 has-top-margin-m has-bottom-margin-m grid-align-items-start"],[12],[1,"\\n        "],[8,[39,8],null,[["@title","@state","@clusterStates","@subText"],["state",[30,1,["dr","state"]],[28,[37,9],[[30,1,["dr","state"]]],null],"The current operating state of the cluster."]],null],[1,"\\n        "],[8,[39,10],null,[["@label","@value","@size","@subText"],["known secondaries",[30,1,["dr","knownSecondaries","length"]],"l","Number of secondaries connected to this primary."]],null],[1,"\\n      "],[13],[1,"\\n    "]],[]],null]],[]]],[1,"    "],[10,0],[14,0,"has-top-margin-s is-flex-center"],[12],[1,"\\n      "],[8,[39,11],[[24,0,"has-padding-xxs"],[4,[38,12],["click",[30,3]],null]],[["@text","@isIconOnly","@color","@icon"],["Refresh",true,"tertiary","sync"]],null],[1,"\\n      "],[10,"small"],[14,0,"has-left-margin-xs has-text-grey"],[12],[1,"\\n        Updated\\n        "],[1,[28,[35,14],[[30,4],"MMM d yyyy, h:mm:ss aaa"],[["withTimeZone"],[true]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[1,"    "],[8,[39,15],[[24,0,"has-top-margin-m"]],[["@title","@message"],["Replication not set up","Data will be listed here. Enable a primary replication cluster to get started."]],[["default"],[[[[1,"\\n      "],[8,[39,16],null,[["@icon","@iconPosition","@text","@route"],["chevron-right","trailing","Enable replication","vault.cluster.replication"]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]]],[]]]]]],["@replication","@version","@refresh","@updatedAt"],false,["hds/card/container","div","h2","if","or","link-to","hr","and","dashboard/replication-state-text","cluster-states","stat-text","hds/button","on","small","date-format","empty-state","hds/link/standalone"]]',moduleName:"vault/components/dashboard/replication-card.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/dashboard/replication-state-text",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"AhT7iRo0",block:'[[[1,"\\n"],[11,0],[17,1],[12],[1,"\\n  "],[10,"h2"],[14,0,"is-size-5 has-text-weight-semibold has-bottom-margin-xs"],[12],[1,"\\n    "],[1,[30,2]],[1,"\\n  "],[13],[1,"\\n\\n"],[41,[30,3],[[[1,"    "],[10,0],[14,0,"title is-8 has-font-weight-normal has-text-grey-dark"],[12],[1,"\\n      "],[1,[30,3]],[1,"\\n    "],[13],[1,"\\n"]],[]],null],[1,"\\n  "],[8,[39,3],[[24,"aria-label","The cluster\'s current operating state"]],[["@text"],["The cluster\'s current operating state"]],[["default"],[[[[1,"\\n    "],[10,0],[14,0,"is-flex-v-centered"],[12],[1,"\\n      "],[8,[39,4],[[24,0,"title is-4 has-text-weight-semibold has-top-margin-xxs has-bottom-margin-xxs has-right-padding-sm"]],null,[["default"],[[[[1,"\\n        "],[1,[28,[35,5],[[30,4],"not set up"],null]],[1,"\\n      "]],[]]]]],[1,"\\n\\n"],[44,[[28,[37,5],[[30,5,["glyph"]],"x-circle"],null]],[[[1,"        "],[8,[39,7],[[16,0,[52,[30,5,["isOk"]],"has-text-success","has-text-danger"]]],[["@isInline","@name"],[true,[30,6]]],null],[1,"\\n"]],[6]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"],[13]],["&attrs","@title","@subText","@state","@clusterStates","icon"],false,["div","h2","if","hds/tooltip-button","hds/text/display","or","let","hds/icon"]]',moduleName:"vault/components/dashboard/replication-state-text.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/dashboard/secrets-engines-card",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"8L3eaRoj",block:'[[[1,"\\n"],[8,[39,0],[[16,0,[29,["has-padding-l ",[52,[30,0,["filteredSecretsEngines"]],"secrets-engines-card"]]]]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n  "],[10,0],[14,0,"is-flex-between"],[12],[1,"\\n    "],[10,"h2"],[14,0,"title is-4 has-left-margin-xxs"],[12],[1,"Secrets engines"],[13],[1,"\\n\\n"],[41,[30,0,["filteredSecretsEngines"]],[[[1,"      "],[8,[39,4],[[24,0,"has-right-margin-4"]],[["@route"],["vault.cluster.secrets.backends"]],[["default"],[[[[1,"\\n        Details\\n      "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n\\n"],[41,[30,0,["filteredSecretsEngines"]],[[[1,"    "],[8,[39,5],[[24,0,"is-border-spacing-revert"]],[["@caption"],["Five secrets engines"]],[["body"],[[[[1,"\\n"],[42,[28,[37,8],[[28,[37,8],[[30,0,["firstFiveSecretsEngines"]]],null]],null],null,[[[1,"          "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n            "],[8,[30,1,["Td"]],[[24,0,"is-flex-between is-flex-center gap-16"]],null,[["default"],[[[[1,"\\n              "],[10,0],[12],[1,"\\n                "],[10,0],[14,0,"is-grid align-items-center linked-block-title"],[12],[1,"\\n"],[41,[30,2,["icon"]],[[[1,"                    "],[8,[39,9],null,[["@name","@title"],[[30,2,["icon"]],[29,[[28,[37,10],[[30,2,["engineType"]],[30,2,["path"]]],null]," type backend"]]]],null],[1,"\\n"]],[]],null],[41,[30,2,["path"]],[[[41,[30,2,["isSupportedBackend"]],[[[1,"                      "],[8,[39,4],[[24,0,"has-text-black has-text-weight-semibold truncate-first-line"]],[["@route","@model"],[[30,2,["backendLink"]],[30,2,["id"]]]],[["default"],[[[[1,"\\n                        "],[1,[30,2,["path"]]],[1,"\\n                      "]],[]]]]],[1,"\\n"]],[]],[[[1,"                      "],[10,1],[14,0,"has-text-grey"],[12],[1,[30,2,["path"]]],[13],[1,"\\n"]],[]]]],[]],null],[1,"                "],[13],[1,"\\n"],[41,[30,2,["accessor"]],[[[1,"                  "],[10,"code"],[14,0,"has-text-grey is-size-8"],[12],[1,"\\n                    "],[1,[30,2,["accessor"]]],[1,"\\n                  "],[13],[1,"\\n"]],[]],null],[41,[30,2,["description"]],[[[1,"                  "],[10,0],[14,0,"truncate-first-line overflow-wrap word-break"],[12],[1,"\\n                    "],[1,[30,2,["description"]]],[1,"\\n                  "],[13],[1,"\\n"]],[]],null],[1,"              "],[13],[1,"\\n"],[41,[30,2,["isSupportedBackend"]],[[[1,"                "],[8,[39,4],[[24,0,"has-text-weight-semibold"]],[["@route","@model"],[[30,2,["backendLink"]],[30,2,["id"]]]],[["default"],[[[[1,"\\n                  View\\n                "]],[]]]]],[1,"\\n"]],[]],null],[1,"            "]],[]]]]],[1,"\\n          "]],[]]]]],[1,"\\n"]],[2]],null],[1,"      "]],[1]]]]],[1,"\\n\\n"],[41,[28,[37,13],[[30,0,["filteredSecretsEngines","length"]],5],null],[[[1,"      "],[10,2],[14,0,"is-size-9 has-top-margin-xs has-text-grey"],[12],[1,"\\n        Showing 5 out of\\n        "],[1,[30,0,["filteredSecretsEngines","length"]]],[1,"\\n        secret engines. Navigate to\\n        "],[8,[39,15],null,[["@route"],["vault.cluster.secrets.backends"]],[["default"],[[[[1,"details"]],[]]]]],[1,"\\n        to view more.\\n      "],[13],[1,"\\n"]],[]],null],[1,"\\n"]],[]],[[[1,"    "],[8,[39,16],[[24,0,"has-top-margin-m"]],[["@title","@message"],["No secrets engines enabled","Secret engines will be listed here. Enable a secret engine to get started."]],[["default"],[[[[1,"\\n      "],[8,[39,17],null,[["@icon","@iconPosition","@text","@route"],["chevron-right","trailing","Enable a secrets engine","vault.cluster.secrets.mounts"]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]]],[]]]]]],["B","backend"],false,["hds/card/container","if","div","h2","link-to","hds/table",":body","each","-track-array","hds/icon","or","span","code","gt","p","hds/link/inline","empty-state","hds/link/standalone"]]',moduleName:"vault/components/dashboard/secrets-engines-card.hbs",isStrictMode:!1})
class l extends n.default{get filteredSecretsEngines(){return this.args.secretsEngines?.filter((e=>e.shouldIncludeInList))}get firstFiveSecretsEngines(){return this.filteredSecretsEngines?.slice(0,5)}}e.default=l,(0,t.setComponentTemplate)(r,l)})),define("vault/components/dashboard/vault-configuration-details-card",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"GxzeI2Mw",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n  "],[10,"h2"],[14,0,"title is-4"],[12],[1,"Configuration details"],[13],[1,"\\n\\n  "],[8,[39,2],[[24,0,"is-border-spacing-revert"]],[["@caption"],["Vault configuration details"]],[["body"],[[[[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"API_ADDR"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[28,[35,4],[[30,2,["api_addr"]],"None"],null]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"Default lease TTL"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[28,[35,5],[[30,2,["default_lease_ttl"]]],null]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"Max lease TTL"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[28,[35,5],[[30,2,["max_lease_ttl"]]],null]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"TLS"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[30,0,["tls"]]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"Log format"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[28,[35,4],[[30,2,["log_format"]],"None"],null]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"Log level"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[30,2,["log_level"]]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,1,["Tr"]],null,null,[["default"],[[[[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,"Storage type"]],[]]]]],[1,"\\n        "],[8,[30,1,["Td"]],null,null,[["default"],[[[[1,[30,2,["storage","type"]]]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[1]]]]],[1,"\\n"]],[]]]]]],["B","@vaultConfiguration"],false,["hds/card/container","h2","hds/table",":body","or","format-duration"]]',moduleName:"vault/components/dashboard/vault-configuration-details-card.hbs",isStrictMode:!1})
class l extends n.default{get tls(){const e=this.args.vaultConfiguration?.listeners.find((e=>{const{tls_disable:t,tls_cert_file:n,tls_key_file:i}=e.config||{}
return!t&&n&&i}))
return e?"Enabled":"Disabled"}}e.default=l,(0,t.setComponentTemplate)(r,l)})),define("vault/components/dashboard/vault-version-title",["exports","@ember/component","@glimmer/component","@ember/service","@ember/template-factory"],(function(e,t,n,i,r){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,r.createTemplateFactory)({id:"AlEU3jFF",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Vault\\n      "],[1,[30,2,["versionDisplay"]]],[1,"\\n"],[41,[30,2,["isEnterprise"]],[[[1,"        "],[8,[39,3],null,[["@text","@icon"],[[30,0,["namespace","currentNamespace"]],"org"]],null],[1,"\\n"]],[]],null],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n"],[10,"hr"],[14,0,"has-top-margin-xxs has-bottom-margin-l has-background-gray-200"],[12],[13]],["p","@version"],false,["page-header","h1","if","hds/badge","hr"]]',moduleName:"vault/components/dashboard/vault-version-title.hbs",isStrictMode:!1})
let s=e.default=(l=class extends n.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="namespace",r=this,(i=a)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}},u=l.prototype,c="namespace",d=[i.service],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},m={},Object.keys(p).forEach((function(e){m[e]=p[e]})),m.enumerable=!!m.enumerable,m.configurable=!!m.configurable,("value"in m||m.initializer)&&(m.writable=!0),m=d.slice().reverse().reduce((function(e,t){return t(u,c,e)||e}),m),f&&void 0!==m.initializer&&(m.value=m.initializer?m.initializer.call(f):void 0,m.initializer=void 0),a=void 0===m.initializer?(Object.defineProperty(u,c,m),null):m,l)
var u,c,d,p,f,m;(0,t.setComponentTemplate)(o,s)})),define("vault/components/database-connection",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object","@ember/test-waiters","ember-concurrency","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f,m,h
function b(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function y(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function g(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const v=(0,u.createTemplateFactory)({id:"inc06gRP",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@path","@mode","@root","@showCurrent"],["vault.cluster.secrets.backend.show",[30,0,["mode"]],[30,2],true]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n"],[41,[28,[37,4],[[30,3],"create"],null],[[[1,"        Create Connection\\n"]],[]],[[[41,[28,[37,4],[[30,3],"edit"],null],[[[1,"        Edit Connection\\n"]],[]],[[[1,"        "],[1,[30,4,["id"]]],[1,"\\n      "]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,4,["isAvailablePlugin"]],[[[41,[28,[37,4],[[30,3],"show"],null],[[[1,"    "],[8,[39,5],null,null,[["default"],[[[[1,"\\n      "],[8,[39,6],null,null,[["default"],[[[[1,"\\n"],[41,[30,4,["canDelete"]],[[[1,"          "],[8,[39,7],[[24,0,"toolbar-button"],[4,[38,8],["click",[28,[37,9],[[30,0],[28,[37,10],[[30,0,["isDeleteModalActive"]]],null],true],null]],null]],[["@text","@color"],["Delete connection","secondary"]],null],[1,"\\n"]],[]],null],[41,[30,4,["canReset"]],[[[1,"          "],[8,[39,11],[[24,0,"toolbar-button"]],[["@buttonText","@buttonColor","@onConfirmAction","@confirmTitle","@confirmMessage"],["Reset connection","secondary",[28,[37,9],[[30,0],"reset"],null],"Reset connection?","This will close the connection and its underlying plugin and restart it with the configuration stored in the barrier."]],null],[1,"\\n"]],[]],null],[41,[28,[37,12],[[30,4,["canReset"]],[30,4,["canDelete"]]],null],[[[1,"          "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n"]],[]],null],[41,[30,4,["canRotateRoot"]],[[[1,"          "],[8,[39,11],[[24,0,"toolbar-button"]],[["@buttonText","@buttonColor","@onConfirmAction","@confirmTitle","@confirmMessage","@modalColor"],["Rotate root credentials","secondary",[30,0,["rotate"]],"Rotate credentials?","This will rotate the \\"root\\" user credentials stored for the database connection. The password will not be accessible once rotated.","warning"]],null],[1,"\\n"]],[]],null],[41,[30,4,["canAddRole"]],[[[1,"          "],[8,[39,14],null,[["@secret","@mode","@backend","@type","@queryParams"],["","create",[30,4,["backend"]],"add",[28,[37,15],null,[["initialKey","itemType"],[[30,4,["name"]],"role"]]]]],[["default"],[[[[1,"\\n            Add role\\n          "]],[]]]]],[1,"\\n"]],[]],null],[41,[30,4,["canEdit"]],[[[1,"          "],[8,[39,14],null,[["@secret","@mode","@backend","@replace"],[[30,4,["id"]],"edit",[30,4,["backend"]],true]],[["default"],[[[[1,"\\n            Edit configuration\\n          "]],[]]]]],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null]],[]],null],[1,"\\n"],[41,[28,[37,4],[[30,3],"create"],null],[[[1,"\\n"],[41,[28,[37,4],[[30,4,["plugin_name"]],"vault-plugin-database-oracle"],null],[[[1,"    "],[8,[39,16],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n      "],[8,[30,5,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n      "],[8,[30,5,["Description"]],null,null,[["default"],[[[[1,"\\n        Please ensure that your Oracle plugin has the default name of\\n        "],[10,"strong"],[12],[1,"vault-plugin-database-oracle"],[13],[1,". Custom naming is not supported in the UI at this time. If the plugin\\n        is already named vault-plugin-database-oracle, disregard this warning.\\n      "]],[]]]]],[1,"\\n    "]],[5]]]]],[1,"\\n"]],[]],null],[1,"\\n  "],[11,"form"],[24,"aria-label","create connection form"],[4,[38,8],["submit",[28,[37,19],[[30,0,["handleCreateConnection"]]],null]],null],[12],[1,"\\n"],[42,[28,[37,21],[[28,[37,21],[[30,4,["fieldAttrs"]]],null]],null],null,[[[41,[28,[37,22],[[30,6,["options","readOnly"]],true],null],[[[1,"        "],[8,[39,23],null,[["@attr","@model"],[[30,6],[30,4]]],null],[1,"\\n"]],[]],null]],[6]],null],[1,"\\n"],[1,"    "],[10,0],[14,0,"form-section box is-shadowless is-fullwidth"],[12],[1,"\\n      "],[10,"fieldset"],[14,0,"form-fieldset"],[12],[1,"\\n        "],[10,"legend"],[14,0,"title is-5"],[12],[1,"Plugin config"],[13],[1,"\\n"],[41,[30,4,["pluginFieldGroups"]],[[[42,[28,[37,21],[[28,[37,21],[[30,4,["pluginFieldGroups"]]],null]],null],null,[[[42,[28,[37,26],[[30,7]],null],null,[[[41,[28,[37,4],[[30,9],"default"],null],[[[1,"                "],[10,0],[14,0,"columns is-desktop is-multiline"],[12],[1,"\\n"],[42,[28,[37,21],[[28,[37,21],[[30,8]],null]],null],null,[[[41,[28,[37,27],[[30,10,["name"]],[28,[37,28],["max_open_connections","max_idle_connections","max_connection_lifetime"],null]],null],[[[1,"                      "],[10,0],[14,0,"column is-one-third"],[12],[1,"\\n                        "],[8,[39,23],null,[["@attr","@model"],[[30,10],[30,4]]],null],[1,"\\n                      "],[13],[1,"\\n"]],[]],[[[1,"                      "],[10,0],[14,0,"column is-full"],[12],[1,"\\n                        "],[8,[39,23],null,[["@attr","@model"],[[30,10],[30,4]]],null],[1,"\\n                      "],[13],[1,"\\n"]],[]]]],[10]],null],[1,"                "],[13],[1,"\\n"]],[]],[[[44,[[28,[37,30],[[28,[37,31],["show",[30,9]],null]],null]],[[[1,"                  "],[8,[39,32],[[24,0,"is-block"]],[["@isOpen","@openLabel","@closedLabel","@onClick"],[[28,[37,33],[[30,0],[30,11]],null],[28,[37,31],["Hide ",[30,9]],null],[30,9],[28,[37,34],[[28,[37,10],[[28,[37,33],[[30,0],[30,11]],null]],null]],null]]],null],[1,"\\n"],[41,[28,[37,33],[[30,0],[30,11]],null],[[[1,"                    "],[10,0],[14,0,"box is-marginless"],[12],[1,"\\n"],[42,[28,[37,21],[[28,[37,21],[[30,8]],null]],null],null,[[[1,"                        "],[8,[39,23],null,[["@attr","@model"],[[30,12],[30,4]]],null],[1,"\\n"]],[12]],null],[1,"                    "],[13],[1,"\\n"]],[]],null]],[11]]]],[]]]],[8,9]],null]],[7]],null]],[]],[[[1,"          "],[8,[39,35],null,[["@title","@message"],["No plugin selected","Select a plugin type to be able to configure it."]],null],[1,"\\n"]],[]]],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n\\n"],[41,[51,[28,[37,37],[[30,4,["plugin_name"]],[28,[37,38],[[30,4,["statementFields"]]],null]],null]],[[[1,"      "],[10,0],[14,0,"form-section box is-shadowless is-fullwidth"],[12],[1,"\\n        "],[10,"h3"],[14,0,"title is-5"],[12],[1,"Statements"],[13],[1,"\\n"],[41,[28,[37,4],[[30,4,["statementFields"]],null],null],[[[1,"          "],[8,[39,35],null,[["@title","@message"],["No plugin selected","Select a plugin type to be able to configure it."]],null],[1,"\\n"]],[]],[[[42,[28,[37,21],[[28,[37,21],[[30,4,["statementFields"]]],null]],null],null,[[[1,"            "],[8,[39,23],null,[["@attr","@model"],[[30,13],[30,4]]],null],[1,"\\n"]],[13]],null]],[]]],[1,"      "],[13],[1,"\\n"]],[]],null],[1,"\\n    "],[10,0],[14,0,"field is-grouped is-grouped-split is-fullwidth box is-bottomless"],[12],[1,"\\n      "],[10,0],[14,0,"field is-grouped"],[12],[1,"\\n        "],[8,[39,40],null,null,[["default"],[[[[1,"\\n          "],[8,[39,7],[[24,4,"submit"]],[["@icon","@text"],[[52,[30,0,["handleCreateConnection","isRunning"]],"loading"],"Create database"]],null],[1,"\\n          "],[8,[39,7],null,[["@text","@color","@route","@model"],["Cancel","secondary","vault.cluster.secrets.backend.list-root",[30,4,["backend"]]]],null],[1,"\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[41,[28,[37,37],[[28,[37,4],[[30,3],"edit"],null],[30,4,["isAvailablePlugin"]]],null],[[[1,"  "],[11,"form"],[24,"aria-label","plugin config form"],[4,[38,8],["submit",[30,0,["handleUpdateConnection"]]],null],[12],[1,"\\n"],[42,[28,[37,21],[[28,[37,21],[[30,4,["fieldAttrs"]]],null]],null],null,[[[41,[28,[37,12],[[28,[37,4],[[30,14,["name"]],"name"],null],[28,[37,4],[[30,14,["name"]],"plugin_name"],null]],null],[[[1,"        "],[8,[39,41],null,[["@attr","@value"],[[30,14],[28,[37,33],[[30,4],[30,14,["name"]]],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,22],[[30,14,["options","readOnly"]],true],null],[[[1,"        "],[8,[39,23],null,[["@attr","@model"],[[30,14],[30,4]]],null],[1,"\\n      "]],[]],null]],[]]]],[14]],null],[1,"\\n"],[1,"    "],[10,0],[14,0,"form-section box is-shadowless is-fullwidth"],[12],[1,"\\n      "],[10,"fieldset"],[14,0,"form-fieldset"],[12],[1,"\\n        "],[10,"legend"],[14,0,"title is-5"],[12],[1,"Plugin config"],[13],[1,"\\n"],[42,[28,[37,21],[[28,[37,21],[[30,4,["pluginFieldGroups"]]],null]],null],null,[[[42,[28,[37,26],[[30,15]],null],null,[[[41,[28,[37,4],[[30,17],"default"],null],[[[1,"              "],[10,0],[14,0,"columns is-desktop is-multiline"],[12],[1,"\\n"],[42,[28,[37,21],[[28,[37,21],[[30,16]],null]],null],null,[[[41,[28,[37,27],[[30,18,["name"]],[28,[37,28],["max_open_connections","max_idle_connections","max_connection_lifetime"],null]],null],[[[1,"                    "],[10,0],[14,0,"column is-one-third"],[12],[1,"\\n                      "],[8,[39,23],null,[["@attr","@model"],[[30,18],[30,4]]],null],[1,"\\n                    "],[13],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,18,["name"]],"password"],null],[[[1,"                    "],[10,0],[14,0,"column is-full"],[12],[1,"\\n                      "],[10,"label"],[15,"for",[30,18,["name"]]],[14,0,"is-label"],[12],[1,"\\n                        "],[1,[28,[35,43],[[28,[37,12],[[30,18,["options","label"]],[30,18,["name"]]],null]],null]],[1,"\\n                      "],[13],[1,"\\n                      "],[10,0],[14,0,"field"],[12],[1,"\\n                        "],[8,[39,44],null,[["@name","@onChange","@checked"],[[29,["show-",[30,18,["name"]]]],[28,[37,34],[[30,0,["updateShowPassword"]],[28,[37,38],[[30,0,["showPasswordField"]]],null]],null],[30,0,["showPasswordField"]]]],[["default"],[[[[1,"\\n                          "],[10,1],[14,0,"ttl-picker-label has-text-grey"],[12],[1,"Update password"],[13],[10,"br"],[12],[13],[1,"\\n                          "],[10,0],[14,0,"description has-text-grey"],[12],[1,"\\n                            "],[10,1],[12],[1,"\\n                              "],[1,[52,[30,0,["showPasswordField"]],"The new password that will be used when connecting to the database","Vault will use the existing password"]],[1,"\\n                            "],[13],[1,"\\n                          "],[13],[1,"\\n"],[41,[30,0,["showPasswordField"]],[[[1,"                            "],[8,[39,47],[[16,3,[30,18,["name"]]],[24,0,"input"],[24,"autocomplete","new-password"],[24,"spellcheck","false"],[4,[38,8],["change",[28,[37,34],[[30,0,["updatePassword"]],[30,18,["name"]]],null]],null]],[["@type","@value"],["password",[28,[37,33],[[30,4],[30,18,["name"]]],null]]],null],[1,"\\n"]],[]],null],[1,"                        "]],[]]]]],[1,"\\n                      "],[13],[1,"\\n                    "],[13],[1,"\\n"]],[]],[[[1,"                    "],[10,0],[14,0,"column is-full"],[12],[1,"\\n                      "],[8,[39,23],null,[["@attr","@model"],[[30,18],[30,4]]],null],[1,"\\n                    "],[13],[1,"\\n                  "]],[]]]],[]]]],[18]],null],[1,"              "],[13],[1,"\\n"]],[]],[[[44,[[28,[37,30],[[28,[37,31],["show",[30,17]],null]],null]],[[[1,"                "],[8,[39,32],[[24,0,"is-block"]],[["@isOpen","@openLabel","@closedLabel","@onClick"],[[28,[37,33],[[30,0],[30,19]],null],[28,[37,31],["Hide ",[30,17]],null],[30,17],[28,[37,34],[[28,[37,10],[[28,[37,33],[[30,0],[30,19]],null]],null]],null]]],null],[1,"\\n"],[41,[28,[37,33],[[30,0],[30,19]],null],[[[1,"                  "],[10,0],[14,0,"box is-marginless"],[12],[1,"\\n"],[42,[28,[37,21],[[28,[37,21],[[30,16]],null]],null],null,[[[1,"                      "],[8,[39,23],null,[["@attr","@model"],[[30,20],[30,4]]],null],[1,"\\n"]],[20]],null],[1,"                  "],[13],[1,"\\n"]],[]],null]],[19]]]],[]]]],[16,17]],null]],[15]],null],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n\\n"],[41,[28,[37,38],[[28,[37,37],[[30,4,["plugin_name"]],[28,[37,38],[[30,4,["statementFields"]]],null]],null]],null],[[[1,"      "],[10,0],[14,0,"form-section box is-shadowless is-fullwidth"],[12],[1,"\\n        "],[10,"fieldset"],[14,0,"form-fieldset"],[12],[1,"\\n          "],[10,"legend"],[14,0,"title is-5"],[12],[1,"Statements"],[13],[1,"\\n"],[42,[28,[37,21],[[28,[37,21],[[30,4,["statementFields"]]],null]],null],null,[[[1,"            "],[8,[39,23],null,[["@attr","@model"],[[30,21],[30,4]]],null],[1,"\\n"]],[21]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"\\n    "],[10,0],[14,0,"field is-grouped is-grouped-split is-fullwidth box is-bottomless"],[12],[1,"\\n      "],[10,0],[14,0,"field is-grouped"],[12],[1,"\\n        "],[8,[39,40],null,null,[["default"],[[[[1,"\\n          "],[8,[39,7],[[24,4,"submit"]],[["@text"],["Save"]],null],[1,"\\n          "],[8,[39,7],null,[["@text","@color","@route","@model"],["Cancel","secondary","vault.cluster.secrets.backend.list-root",[30,4,["backend"]]]],null],[1,"\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,4,["isAvailablePlugin"]],false],null],[[[1,"  "],[8,[39,35],null,[["@title","@subTitle","@icon","@message","@bottomBorder"],["Database type unavailable","Not supported in the UI","skip","This database type cannot be viewed in the UI. You will have to use the API or CLI to perform actions here.",true]],[["default"],[[[[1,"\\n    "],[8,[39,48],null,[["@icon","@text","@route"],["chevron-left","Go back","vault.cluster.secrets.backend.list-root"]],null],[1,"\\n    "],[8,[39,48],null,[["@icon","@iconPosition","@text","@href"],["docs-link","trailing","Database API docs",[28,[37,49],["/vault/api-docs/secret/databases"],null]]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],[[[42,[28,[37,21],[[28,[37,21],[[30,4,["showAttrs"]]],null]],null],null,[[[44,[[30,22,["options","defaultShown"]]],[[[41,[28,[37,4],[[30,22,["type"]],"object"],null],[[[1,"        "],[8,[39,50],null,[["@alwaysRender","@defaultShown","@label","@value"],[[28,[37,38],[[28,[37,51],[[28,[37,33],[[30,4],[30,22,["name"]]],null]],[["hasDefault"],[[30,23]]]]],null],[30,23],[28,[37,43],[[28,[37,12],[[30,22,["options","label"]],[28,[37,52],[[28,[37,53],[[30,22,["name"]]],null]],null]],null]],null],[28,[37,54],[[28,[37,33],[[30,4],[30,22,["name"]]],null]],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,22,["type"]],"array"],null],[[[1,"        "],[8,[39,50],null,[["@alwaysRender","@defaultShown","@label","@value","@isLink","@queryParam","@type"],[[28,[37,38],[[28,[37,51],[[28,[37,33],[[30,4],[30,22,["name"]]],null]],[["hasDefault"],[[30,23]]]]],null],[30,23],[28,[37,43],[[28,[37,12],[[30,22,["options","label"]],[28,[37,52],[[28,[37,53],[[30,22,["name"]]],null]],null]],null]],null],[28,[37,33],[[30,4],[30,22,["name"]]],null],true,"role",[30,22,["type"]]]],null],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,22,["name"]],"skip_static_role_rotation_import"],null],[[[1,"        "],[8,[39,50],null,[["@alwaysRender","@defaultShown","@label","@value"],[[28,[37,38],[[28,[37,51],[[28,[37,33],[[30,4],[30,22,["name"]]],null]],[["hasDefault"],[[30,23]]]]],null],[30,23],[28,[37,43],[[28,[37,12],[[30,22,["options","label"]],[28,[37,52],[[28,[37,53],[[30,22,["name"]]],null]],null]],null]],null],[28,[37,38],[[28,[37,33],[[30,4],[30,22,["name"]]],null]],null]]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,50],null,[["@alwaysRender","@defaultShown","@label","@value"],[[28,[37,38],[[28,[37,51],[[28,[37,33],[[30,4],[30,22,["name"]]],null]],[["hasDefault"],[[30,23]]]]],null],[30,23],[28,[37,43],[[28,[37,12],[[30,22,["options","label"]],[28,[37,52],[[28,[37,53],[[30,22,["name"]]],null]],null]],null]],null],[28,[37,33],[[30,4],[30,22,["name"]]],null]]],null],[1,"\\n      "]],[]]]],[]]]],[]]]],[23]]]],[22]],null]],[]]]],[]]]],[]]],[1,"\\n"],[41,[30,0,["showSaveModal"]],[[[1,"  "],[8,[39,55],[[24,1,"rotate-credentials-modal"]],[["@onClose"],[[30,0,["continueWithoutRotate"]]]],[["default"],[[[[1,"\\n    "],[8,[30,24,["Header"]],null,[["@icon"],["info"]],[["default"],[[[[1,"\\n      Rotate your root credentials?\\n    "]],[]]]]],[1,"\\n    "],[8,[30,24,["Body"]],null,null,[["default"],[[[[1,"\\n      "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n        It’s best practice to rotate the root credential immediately after the initial configuration of each database. Once\\n        rotated,\\n        "],[10,"strong"],[12],[1,"only Vault knows the new root password"],[13],[1,".\\n      "],[13],[1,"\\n      "],[10,2],[12],[1,"Would you like to rotate your new credentials? You can also do this later."],[13],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,24,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,40],null,null,[["default"],[[[[1,"\\n        "],[8,[39,7],[[4,[38,8],["click",[28,[37,19],[[30,0,["continueWithRotate"]]],null]],null]],[["@icon","@text"],[[52,[30,0,["continueWithRotate","isRunning"]],"loading"],"Rotate and enable"]],null],[1,"\\n        "],[8,[39,7],[[4,[38,8],["click",[30,0,["continueWithoutRotate"]]],null]],[["@text","@color"],["Enable without rotating","secondary"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[24]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[8,[39,57],null,[["@title","@onClose","@isActive","@confirmText","@toConfirmMsg","@onConfirm"],["Delete connection?",[28,[37,9],[[30,0],[28,[37,10],[[30,0,["isDeleteModalActive"]]],null],false],null],[30,0,["isDeleteModalActive"]],[30,4,["name"]],"deleting the connection",[28,[37,9],[[30,0],"delete"],null]]],[["default"],[[[[1,"\\n  "],[10,2],[12],[1,"\\n    Deleting the connection means that any associated roles won\'t be able to generate credentials until the connection is\\n    reconfigured.\\n  "],[13],[1,"\\n  "],[8,[39,58],null,[["@model","@errorMessage"],[[30,0,["model"]],[30,0,["error"]]]],null],[1,"\\n"]],[]]]]]],["p","@root","@mode","@model","A","attr","fieldGroup","fields","group","attr","prop","attr","attr","attr","fieldGroup","fields","group","attr","prop","attr","attr","attr","defaultDisplay","M"],false,["page-header","key-value-header","h1","if","eq","toolbar","toolbar-actions","hds/button","on","action","mut","confirm-action","or","div","toolbar-secret-link","hash","hds/alert","strong","form","perform","each","-track-array","not-eq","form-field","fieldset","legend","-each-in","includes","array","let","camelize","concat","toggle-button","get","fn","empty-state","unless","and","not","h3","hds/button-set","readonly-form-field","label","capitalize","toggle","span","br","input","hds/link/standalone","doc-link","info-table-row","is-empty-value","humanize","dasherize","stringify","hds/modal","p","confirmation-modal","message-error"]]',moduleName:"vault/components/database-connection.hbs",isStrictMode:!1}),w="vault.cluster.secrets.backend.show",k=e=>{let t=e?.join(". ")||"Something went wrong. Check the Vault logs for more information."
return t.indexOf("failed to verify")>=0&&(t="There was a verification error for this connection. Check the Vault logs for more information."),t}
let x=e.default=(c=class extends i.default{constructor(...e){super(...e),b(this,"store",d,this),b(this,"router",p,this),b(this,"flashMessages",f,this),b(this,"showPasswordField",m,this),b(this,"showSaveModal",h,this),y(this,"handleCreateConnection",(0,n.buildTask)((()=>({context:this,generator:(0,o.waitFor)((function*(e){e.preventDefault()
try{const e=this.args.model
yield e.save(),this.showSaveModal=!0}catch(t){const e=k(t.errors)
this.flashMessages.danger(e)}}))})),null,"handleCreateConnection",null)),y(this,"continueWithRotate",(0,n.buildTask)((()=>({context:this,generator:(0,o.waitFor)((function*(){const{backend:e,name:t}=this.args.model
try{yield this.rotateCredentials(e,t),this.flashMessages.success(`Successfully rotated root credentials for connection "${t}"`),this.transitionToRoute(w,t)}catch(n){this.flashMessages.danger(`Error rotating root credentials: ${n.errors}`),this.transitionToRoute(w,t)}finally{this.showSaveModal=!1}}))})),null,"continueWithRotate",null))}rotateCredentials(e,t){return this.store.adapterFor("database/connection").rotateRootCredentials(e,t)}transitionToRoute(){return this.router.transitionTo(...arguments)}updateShowPassword(e){this.showPasswordField=e,e||(this.args.model.password=void 0)}updatePassword(e,t){const n=t.target.value
this.args.model[e]=n}continueWithoutRotate(){if(this.continueWithRotate.isRunning)return
this.showSaveModal=!1
const{name:e}=this.args.model
this.transitionToRoute(w,e)}handleUpdateConnection(e){e.preventDefault()
const t=this.args.model,n=t.name
t.save().then((()=>{this.transitionToRoute(w,n)})).catch((e=>{const t=k(e.errors)
this.flashMessages.danger(t)}))}delete(e){e.preventDefault()
const t=this.args.model,n=t.backend
t.destroyRecord().then((()=>{this.transitionToRoute("vault.cluster.secrets.backend.list-root",n)}))}reset(){const{name:e,backend:t}=this.args.model
this.store.adapterFor("database/connection").resetConnection(t,e).then((()=>{this.flashMessages.success("Successfully reset connection")})).catch((e=>{const t=k(e.errors)
this.flashMessages.danger(t)}))}rotate(){const{name:e,backend:t}=this.args.model
this.rotateCredentials(t,e).then((()=>{this.flashMessages.success("Successfully rotated credentials")})).catch((e=>{const t=k(e.errors)
this.flashMessages.danger(t)}))}},d=g(c.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=g(c.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=g(c.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=g(c.prototype,"showPasswordField",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),h=g(c.prototype,"showSaveModal",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),g(c.prototype,"updateShowPassword",[a.action],Object.getOwnPropertyDescriptor(c.prototype,"updateShowPassword"),c.prototype),g(c.prototype,"updatePassword",[a.action],Object.getOwnPropertyDescriptor(c.prototype,"updatePassword"),c.prototype),g(c.prototype,"continueWithoutRotate",[a.action],Object.getOwnPropertyDescriptor(c.prototype,"continueWithoutRotate"),c.prototype),g(c.prototype,"handleUpdateConnection",[a.action],Object.getOwnPropertyDescriptor(c.prototype,"handleUpdateConnection"),c.prototype),g(c.prototype,"delete",[a.action],Object.getOwnPropertyDescriptor(c.prototype,"delete"),c.prototype),g(c.prototype,"reset",[a.action],Object.getOwnPropertyDescriptor(c.prototype,"reset"),c.prototype),g(c.prototype,"rotate",[a.action],Object.getOwnPropertyDescriptor(c.prototype,"rotate"),c.prototype),c);(0,t.setComponentTemplate)(v,x)})),define("vault/components/database-role-edit",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","@ember/test-waiters","ember-concurrency","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c){var d,p,f,m,h,b,y,g
function v(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function w(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function k(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const x=(0,c.createTemplateFactory)({id:"ZcjDG2yv",block:'[[[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@path","@mode","@root","@showCurrent"],["vault.cluster.secrets.backend.show",[30,2],[30,3],true]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n"],[41,[28,[37,4],[[30,2],"create"],null],[[[1,"        Create Role\\n"]],[]],[[[41,[28,[37,4],[[30,2],"edit"],null],[[[1,"        Edit Role\\n"]],[]],[[[1,"        "],[1,[30,4,["id"]]],[1,"\\n      "]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n"],[41,[28,[37,4],[[30,2],"show"],null],[[[1,"  "],[8,[39,5],null,null,[["default"],[[[[1,"\\n    "],[8,[39,6],null,null,[["default"],[[[[1,"\\n"],[41,[30,4,["canDelete"]],[[[1,"        "],[8,[39,7],[[24,0,"toolbar-button"]],[["@buttonText","@buttonColor","@onConfirmAction","@confirmTitle","@confirmMessage"],["Delete role","secondary",[30,0,["delete"]],"Delete role?","This role will be permanently deleted. You will need to recreate it to use it again."]],null],[1,"\\n        "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n"]],[]],null],[41,[28,[37,9],[[30,4,["canRotateRoleCredentials"]],[28,[37,4],[[30,4,["type"]],"static"],null]],null],[[[1,"        "],[8,[39,10],[[24,0,"toolbar-button"],[4,[38,11],["click",[28,[37,12],[[30,0,["rotateRoleCred"]],[30,4,["id"]]],null]],null]],[["@text","@color"],["Rotate credentials","secondary"]],null],[1,"\\n"]],[]],null],[41,[28,[37,13],[[28,[37,9],[[28,[37,4],[[30,4,["type"]],"static"],null],[30,4,["canGetCredentials"]]],null],[28,[37,9],[[28,[37,4],[[30,4,["type"]],"dynamic"],null],[30,4,["canGenerateCredentials"]]],null]],null],[[[1,"        "],[8,[39,10],[[24,0,"toolbar-button"],[4,[38,11],["click",[28,[37,12],[[30,0,["generateCreds"]],[30,4,["id"]],[30,4,["type"]]],null]],null]],[["@text","@color"],[[52,[28,[37,4],[[30,4,["type"]],"static"],null],"Get credentials","Generate credentials"],"secondary"]],null],[1,"\\n"]],[]],null],[41,[30,4,["canEditRole"]],[[[1,"        "],[8,[39,14],null,[["@secret","@mode","@backend","@replace","@queryParams"],[[28,[37,15],["role/",[30,4,["id"]]],null],"edit",[30,4,["backend"]],true,[28,[37,16],null,[["itemType"],["role"]]]]],[["default"],[[[[1,"\\n          Edit role\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"],[42,[28,[37,18],[[28,[37,18],[[30,4,["showFields"]]],null]],null],null,[[[44,[[30,5,["options","defaultShown"]]],[[[41,[28,[37,4],[[30,5,["type"]],"object"],null],[[[1,"        "],[8,[39,20],null,[["@alwaysRender","@defaultShown","@label","@value"],[true,[30,6],[28,[37,21],[[28,[37,13],[[30,5,["options","label"]],[28,[37,22],[[28,[37,23],[[30,5,["name"]]],null]],null]],null]],null],[28,[37,24],[[28,[37,25],[[30,4],[30,5,["name"]]],null]],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,5,["options","editType"]],"ttl"],null],[[[1,"        "],[8,[39,20],null,[["@alwaysRender","@defaultShown","@label","@value","@isLink"],[true,[30,6],[28,[37,21],[[28,[37,13],[[30,5,["options","label"]],[28,[37,22],[[28,[37,23],[[30,5,["name"]]],null]],null]],null]],null],[28,[37,26],[[28,[37,25],[[30,4],[30,5,["name"]]],null]],null],[28,[37,4],[[30,5,["name"]],"database"],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,5,["name"]],"skip_import_rotation"],null],[[[1,"        "],[8,[39,20],null,[["@alwaysRender","@defaultShown","@label","@value","@isLink"],[true,[30,6],[28,[37,21],[[28,[37,13],[[30,5,["options","label"]],[28,[37,22],[[28,[37,23],[[30,5,["name"]]],null]],null]],null]],null],[28,[37,27],[[28,[37,25],[[30,4],[30,5,["name"]]],null]],null],[28,[37,4],[[30,5,["name"]],"database"],null]]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,20],null,[["@alwaysRender","@defaultShown","@label","@value","@isLink"],[true,[30,6],[28,[37,21],[[28,[37,13],[[30,5,["options","label"]],[28,[37,22],[[28,[37,23],[[30,5,["name"]]],null]],null]],null]],null],[28,[37,25],[[30,4],[30,5,["name"]]],null],[28,[37,4],[[30,5,["name"]],"database"],null]]],null],[1,"\\n      "]],[]]]],[]]]],[]]]],[6]]]],[5]],null]],[]],[[[1,"  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[11,"form"],[4,[38,11],["submit",[30,0,["handleCreateEditRole"]]],null],[12],[1,"\\n      "],[8,[39,29],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n"],[42,[28,[37,18],[[28,[37,18],[[30,4,["fieldAttrs"]]],null]],null],null,[[[41,[28,[37,4],[[30,2],"edit"],null],[[[1,"          "],[8,[39,30],null,[["@attr","@value"],[[30,7],[28,[37,25],[[30,4],[30,7,["name"]]],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,31],[[30,7,["options","readOnly"]],true],null],[[[41,[28,[37,4],[[30,7,["name"]],"type"],null],[[[41,[30,4,["database"]],[[[1,"              "],[8,[39,32],null,[["@attr","@model","@modelValidations"],[[30,7],[30,4],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[]],null]],[]],[[[1,"            "],[8,[39,32],null,[["@attr","@model","@modelValidations"],[[30,7],[30,4],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[]]],[41,[28,[37,25],[[30,0,["warningMessages"]],[30,7,["name"]]],null],[[[1,"            "],[8,[39,33],[[24,0,"has-top-margin-negative-s has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n              "],[8,[30,8,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n              "],[8,[30,8,["Description"]],null,null,[["default"],[[[[1,[28,[35,25],[[30,0,["warningMessages"]],[30,7,["name"]]],null]]],[]]]]],[1,"\\n            "]],[8]]]]],[1,"\\n"]],[]],null],[1,"        "]],[]],null]],[]]]],[7]],null],[41,[30,4,["database"]],[[[1,"        "],[8,[39,34],null,[["@attrs","@roleType","@model","@mode","@dbParams","@modelValidations"],[[30,4,["roleSettingAttrs"]],[30,4,["type"]],[30,4],[30,2],[28,[37,35],[[30,0,["databaseParams"]]],null],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,36],null,[["@title","@message"],["No database connection selected","Choose a connection to be able to configure a role type."]],null],[1,"\\n"]],[]]],[1,"      "],[10,0],[14,0,"field is-fullwidth box is-bottomless"],[12],[1,"\\n        "],[8,[39,37],null,null,[["default"],[[[[1,"\\n          "],[8,[39,10],[[16,"disabled",[30,0,["handleCreateEditRole","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[28,[37,4],[[30,2],"create"],null],"Create role","Save"],[52,[30,0,["handleCreateEditRole","isRunning"]],"loading"]]],null],[1,"\\n          "],[8,[39,10],null,[["@text","@color","@route","@model","@query"],["Cancel","secondary","vault.cluster.secrets.backend.list-root",[30,4,["backend"]],[28,[37,16],null,[["tab"],["role"]]]]],null],[1,"\\n        "]],[]]]]],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"          "],[8,[39,38],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n"]],[]],null],[41,[28,[37,27],[[28,[37,39],[[30,0,["warningMessages"]]],null]],null],[[[1,"          "],[8,[39,33],[[24,0,"has-left-margin-s"]],[["@type","@color"],["compact","warning"]],[["default"],[[[[1,"\\n            "],[8,[30,9,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n            "],[8,[30,9,["Description"]],null,null,[["default"],[[[[1,"\\n              You don\'t have permissions required to\\n              "],[1,[52,[28,[37,4],[[30,2],"create"],null],"create","update"]],[1,"\\n              this role. See form for details.\\n            "]],[]]]]],[1,"\\n          "]],[9]]]]],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]],[1,"\\n"],[41,[30,0,["saveIssuerWarning"]],[[[1,"  "],[8,[39,40],null,[["@color","@onClose"],["warning",[28,[37,12],[[28,[37,41],[[30,0,["saveIssuerWarning"]]],null],""],null]]],[["default"],[[[[1,"\\n    "],[8,[30,10,["Header"]],null,[["@icon"],["alert-circle"]],[["default"],[[[[1,"\\n      Are you sure?\\n    "]],[]]]]],[1,"\\n    "],[8,[30,10,["Body"]],null,null,[["default"],[[[[1,"\\n      "],[10,2],[12],[1,"\\n        "],[1,[30,0,["saveIssuerWarning"]]],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,10,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,37],null,null,[["default"],[[[[1,"\\n        "],[8,[39,10],[[4,[38,11],["click",[30,0,["continueSubmitForm"]]],null]],[["@text"],["Continue"]],null],[1,"\\n        "],[8,[39,10],[[4,[38,11],["click",[30,11,["close"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[11]]]]],[1,"\\n  "]],[10]]]]],[1,"\\n"]],[]],null]],["p","@mode","@root","@model","attr","defaultDisplay","attr","A","A","M","F"],false,["page-header","key-value-header","h1","if","eq","toolbar","toolbar-actions","confirm-action","div","and","hds/button","on","fn","or","toolbar-secret-link","concat","hash","each","-track-array","let","info-table-row","capitalize","humanize","dasherize","stringify","get","format-duration","not","form","message-error","readonly-form-field","not-eq","form-field","hds/alert","database-role-setting-form","await","empty-state","hds/button-set","alert-inline","is-empty-value","hds/modal","mut","p"]]',moduleName:"vault/components/database-role-edit.hbs",isStrictMode:!1})
let P=e.default=(d=class extends i.default{constructor(){super(...arguments),v(this,"router",p,this),v(this,"flashMessages",f,this),v(this,"store",m,this),v(this,"modelValidations",h,this),v(this,"invalidFormAlert",b,this),v(this,"errorMessage",y,this),v(this,"saveIssuerWarning",g,this),w(this,"saveRole",(0,n.buildTask)((()=>({context:this,generator:(0,o.waitFor)((function*(){const{mode:e,model:t}=this.args
if("create"===e){t.id=t.name
const e="static"===t.type?"static-roles":"roles"
t.path=e}try{yield t.save(),this.router.transitionTo("vault.cluster.secrets.backend.show",`role/${t.name}`)}catch(n){this.errorMessage=(0,u.default)(n),this.flashMessages.danger(this.errorMessage||"Could not save the role. Please check Vault logs for more information.")}}))})),null,"saveRole",null)),this.args.initialKey&&(this.args.model.database=[this.args.initialKey])}isValid(){const{isValid:e,state:t}=this.args.model.validate()
return this.modelValidations=e?null:t,this.invalidFormAlert=e?"":"There was an error submitting this form.",e}resetErrors(){this.flashMessages.clearMessages(),this.errorMessage=this.invalidFormAlert="",this.modelValidations=null}get warningMessages(){const e={},{canCreateDynamic:t,canCreateStatic:n,type:i}=this.args.model
return("dynamic"===i&&!1===t||"static"===i&&!1===n)&&(e.type="You don't have permissions to create this type of role."),e}get databaseParams(){const e=this.args.model?.backend,t=this.args.model?.database||[]
return e&&0!==t.length?this.store.queryRecord("database/connection",{id:t[0],backend:e}).then((({plugin_name:e,skip_static_role_rotation_import:t})=>({plugin_name:e,skip_static_role_rotation_import:t}))).catch((()=>null)):null}continueSubmitForm(){this.saveIssuerWarning="",this.saveRole.perform()}generateCreds(e,t=""){this.router.transitionTo("vault.cluster.secrets.backend.credentials",e,{queryParams:{roleType:t}})}delete(){const e=this.args.model,t=e.backend
return e.destroyRecord().then((()=>{try{this.router.transitionTo("vault.cluster.secrets.backend.list-root",t,{queryParams:{tab:"role"}})}catch(e){console.debug(e)}})).catch((e=>{this.flashMessages.danger(e.errors?.join(". "))}))}async handleCreateEditRole(e){e.preventDefault(),this.resetErrors()
const{mode:t,model:n}=this.args
this.isValid()&&(n.skip_import_rotation||"static"!==n.type||"create"!==t?await this.saveRole.perform():this.saveIssuerWarning="You have enabled 'Rotate immediately' for this static role. Vault will update the password immediately after you save. NOTE: This will disrupt any active use of this role outside of Vault.")}rotateRoleCred(e){const t=this.args.model?.backend
return this.store.adapterFor("database/credential").rotateRoleCredentials(t,e).then((()=>{this.flashMessages.success(`Success: Credentials for ${e} role were rotated`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}},p=k(d.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=k(d.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=k(d.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=k(d.prototype,"modelValidations",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=k(d.prototype,"invalidFormAlert",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=k(d.prototype,"errorMessage",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),g=k(d.prototype,"saveIssuerWarning",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),k(d.prototype,"continueSubmitForm",[l.action],Object.getOwnPropertyDescriptor(d.prototype,"continueSubmitForm"),d.prototype),k(d.prototype,"generateCreds",[l.action],Object.getOwnPropertyDescriptor(d.prototype,"generateCreds"),d.prototype),k(d.prototype,"delete",[l.action],Object.getOwnPropertyDescriptor(d.prototype,"delete"),d.prototype),k(d.prototype,"handleCreateEditRole",[l.action],Object.getOwnPropertyDescriptor(d.prototype,"handleCreateEditRole"),d.prototype),k(d.prototype,"rotateRoleCred",[l.action],Object.getOwnPropertyDescriptor(d.prototype,"rotateRoleCred"),d.prototype),d);(0,t.setComponentTemplate)(x,P)})),define("vault/components/database-role-setting-form",["exports","@ember/component","@glimmer/component","vault/utils/model-helpers/database-helpers","@ember/template-factory"],(function(e,t,n,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const l=(0,r.createTemplateFactory)({id:"KTuKhdMx",block:'[[[1,"\\n"],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n  "],[10,"h3"],[14,0,"title is-5"],[12],[1,"Role settings"],[13],[1,"\\n"],[41,[30,0,["settingFields"]],[[[1,"    "],[10,0],[14,0,"form-section"],[12],[1,"\\n"],[42,[28,[37,4],[[28,[37,4],[[30,0,["settingFields"]]],null]],null],null,[[[41,[28,[37,5],[[28,[37,6],[[30,2],"edit"],null],[28,[37,7],[[30,1,["name"]],[28,[37,8],["skip_import_rotation","username"],null]],null]],null],[[[41,[28,[37,6],[[30,1,["name"]],"skip_import_rotation"],null],[[[1,"            "],[8,[39,9],null,[["@attr","@value"],[[30,1],[28,[37,10],[[28,[37,11],[[30,3],[30,1,["name"]]],null]],null]]],null],[1,"\\n"]],[]],[[[1,"            "],[8,[39,9],null,[["@attr","@value"],[[30,1],[28,[37,11],[[30,3],[30,1,["name"]]],null]]],null],[1,"\\n"]],[]]]],[]],[[[41,[28,[37,5],[[28,[37,6],[[30,2],"edit"],null],[28,[37,6],[[30,1,["name"]],"password"],null]],null],[[[1,"          "],[8,[39,12],[[24,0,"field"]],[["@attr","@disabled"],[[30,1],[28,[37,10],[[28,[37,6],[[28,[37,11],[[30,3],"last_vault_rotation"],null],[27]],null]],null]]],[["default"],[[[[1,"\\n            "],[8,[39,13],null,[["@attr","@model"],[[30,1],[30,3]]],null],[1,"\\n          "]],[]]]]],[1,"\\n"]],[]],[[[1,"          "],[8,[39,13],null,[["@attr","@model","@modelValidations"],[[30,1],[30,3],[30,4]]],null],[1,"\\n"],[41,[28,[37,5],[[28,[37,6],[[30,1,["name"]],"skip_import_rotation"],null],[30,0,["isOverridden"]]],null],[[[1,"            "],[8,[39,14],[[24,0,"has-top-margin-negative-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n              "],[8,[30,5,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n              "],[8,[30,5,["Description"]],null,null,[["default"],[[[[1,"This will override the connection default for this role."]],[]]]]],[1,"\\n            "]],[5]]]]],[1,"\\n"]],[]],null],[1,"        "]],[]]]],[]]],[1,"\\n"]],[1]],null],[1,"    "],[13],[1,"\\n"]],[]],[[[1,"    "],[8,[39,15],null,[["@title","@message"],["No role type selected","Select a type of role to be able to configure it"]],null],[1,"\\n"]],[]]],[13],[1,"\\n"],[41,[51,[28,[37,5],[[30,6],[28,[37,10],[[30,0,["statementFields"]]],null]],null]],[[[1,"  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[10,"h3"],[14,0,"title is-5"],[12],[1,"Statements"],[13],[1,"\\n"],[41,[30,0,["statementFields"]],[[[1,"      "],[10,0],[14,0,"form-section"],[12],[1,"\\n"],[42,[28,[37,4],[[28,[37,4],[[30,0,["statementFields"]]],null]],null],null,[[[1,"          "],[8,[39,13],null,[["@attr","@model"],[[30,7],[30,3]]],null],[1,"\\n"]],[7]],null],[1,"      "],[13],[1,"\\n"]],[]],[[[1,"      "],[8,[39,15],null,[["@title","@message"],["No role type selected","Select a type of role to be able to add statements for creation, revocation, and/or rotation."]],null],[1,"\\n"]],[]]],[1,"  "],[13],[1,"\\n"]],[]],null]],["attr","@mode","@model","@modelValidations","A","@roleType","attr"],false,["div","h3","if","each","-track-array","and","eq","includes","array","readonly-form-field","not","get","enable-input","form-field","hds/alert","empty-state","unless"]]',moduleName:"vault/components/database-role-setting-form.hbs",isStrictMode:!1})
class a extends n.default{get dbConfig(){return this.args.dbParams}get settingFields(){const e=this.args.dbParams
if(!this.args.roleType)return null
const t=(0,i.getRoleFields)(this.args.roleType)
return this.args.attrs.filter((n=>("skip_import_rotation"===n.name&&"create"===this.args.mode&&(n.options.defaultValue=e?.skip_static_role_rotation_import),t.includes(n.name))))}get statementFields(){const e=this.args.roleType
if(!e)return null
const t=(0,i.getStatementFields)(e,this.dbConfig?this.dbConfig.plugin_name:null)
return this.args.attrs.filter((e=>t.includes(e.name)))}get isOverridden(){if("create"!==this.args.mode||!this.dbConfig)return null
const e=this.dbConfig.skip_static_role_rotation_import,t=this.args.model.get("skip_import_rotation")
return"create"===this.args.mode&&e!==t}}e.default=a,(0,t.setComponentTemplate)(l,a)})),define("vault/components/disabled-plugin-card",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"qaWxud05",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"selectable-engine-card has-top-padding-l has-bottom-padding-s has-side-padding-8 has-text-centered small-card overflow-wrap"],[24,"tabindex","0"],[4,[38,1],["click",[28,[37,2],[[30,2],[30,1]],null]],null],[4,[38,1],["keydown",[28,[37,2],[[30,3],[30,1]],null]],null]],[["@level","@background","@hasBorder","@ariaLabel"],["base","neutral-secondary",false,[29,[[30,1,["displayName"]]," - disabled engine type"]]]],[["default"],[[[[1,"\\n"],[41,[30,1,["glyph"]],[[[1,"    "],[8,[39,4],[[24,0,"has-bottom-margin-xs disabled-icon"]],[["@name","@size"],[[30,1,["glyph"]],"24"]],null],[1,"\\n"]],[]],null],[1,"  "],[8,[39,5],null,[["@tag","@size"],["h3","300"]],[["default"],[[[[1,"\\n    "],[1,[30,1,["displayName"]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]]]],["@type","@handleDisabledPluginClick","@handleDisabledPluginKeyDown"],false,["hds/card/container","on","fn","if","icon","hds/text/body"]]',moduleName:"vault/components/disabled-plugin-card.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/doc-link",["exports","core/components/doc-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-demo",["exports","@docfy/ember/components/docfy-demo"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-demo/description",["exports","@docfy/ember/components/docfy-demo/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-demo/example",["exports","@docfy/ember/components/docfy-demo/example"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-demo/snippet",["exports","@docfy/ember/components/docfy-demo/snippet"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/docfy-demo/snippets",["exports","@docfy/ember/components/docfy-demo/snippets"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-link",["exports","@docfy/ember/components/docfy-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-output",["exports","@docfy/ember/components/docfy-output"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/docfy-previous-and-next-page",["exports","@docfy/ember/components/docfy-previous-and-next-page"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/download-button",["exports","core/components/download-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/edit-form",["exports","core/components/edit-form"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog-positioned-container",["exports","ember-modal-dialog/components/positioned-container"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-basic-dialog",["exports","ember-modal-dialog/components/basic-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-in-place-dialog",["exports","ember-modal-dialog/components/in-place-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-liquid-dialog",["exports","ember-modal-dialog/components/liquid-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-liquid-tether-dialog",["exports","ember-modal-dialog/components/liquid-tether-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/-tether-dialog",["exports","ember-modal-dialog/components/tether-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-modal-dialog/overlay",["exports","ember-modal-dialog/components/overlay"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-tether",["exports","ember-tether/components/ember-tether"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/ember-wormhole",["exports","ember-wormhole/components/ember-wormhole"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/empty-state",["exports","core/components/empty-state"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/enable-input",["exports","core/components/enable-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/enabled-plugin-card",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","core/utils/keys","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s
function u(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const c=(0,a.createTemplateFactory)({id:"x+Y/tcRm",block:'[[[1,"\\n"],[44,[[30,0,["isDisabled"]]],[[[1,"  "],[8,[39,1],[[16,0,[29,["selectable-engine-card\\n      ",[52,[30,1],"disabled"],"\\n      has-top-padding-l has-bottom-padding-s has-side-padding-8 has-text-centered small-card overflow-wrap"]]],[24,"tabindex","0"],[4,[38,3],["click",[30,0,["handleSelection"]]],null],[4,[38,3],["keydown",[30,0,["handleKeyDown"]]],null]],[["@level","@background","@hasBorder","@ariaLabel"],[[52,[30,1],"base","mid"],[52,[30,1],"neutral-secondary","neutral-primary"],true,[29,[[30,2,["displayName"]]," - ",[52,[30,1],"disabled","enabled"]," engine type"]]]],[["default"],[[[[1,"\\n"],[41,[30,2,["glyph"]],[[[1,"      "],[8,[39,4],[[24,0,"has-bottom-margin-xs"]],[["@name","@size"],[[30,2,["glyph"]],"24"]],null],[1,"\\n"]],[]],null],[1,"    "],[8,[39,5],null,[["@tag","@size"],["h3","300"]],[["default"],[[[[1,"\\n      "],[1,[30,2,["displayName"]]],[1,"\\n    "]],[]]]]],[1,"\\n"],[41,[30,0,["showDeprecationBadge"]],[[[1,"      "],[8,[39,6],null,[["@text","@size"],[[28,[37,7],[[30,2,["deprecationStatus"]]],null],"small"]],null],[1,"\\n"]],[]],null],[41,[30,0,["showEnterpriseBadge"]],[[[1,"      "],[8,[39,6],null,[["@text","@size"],["Enterprise","small"]],null],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"]],[1]]]],["isDisabled","@type"],false,["let","hds/card/container","if","on","icon","hds/text/body","hds/badge","capitalize"]]',moduleName:"vault/components/enabled-plugin-card.hbs",isStrictMode:!1})
let d=e.default=(o=class extends n.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="version",r=this,(i=s)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}get isDisabled(){const{type:e}=this.args
return e.requiresEnterprise&&!this.version.isEnterprise||e.requiredFeature&&!this.hasFeature(e.requiredFeature)}get showEnterpriseBadge(){const{type:e}=this.args
return e.requiresEnterprise&&!this.version.isEnterprise||e.requiredFeature&&!this.hasFeature(e.requiredFeature)}get showDeprecationBadge(){const{type:e}=this.args
return e.deprecationStatus&&"supported"!==e.deprecationStatus}hasFeature(e){return this.version.features?.includes(e)||!1}handleSelection(){this.isDisabled||this.args.setMountType(this.args.type.type)}handleKeyDown(e){e.key!==l.default.ENTER&&e.key!==l.default.SPACE||(e.preventDefault(),this.handleSelection())}},s=u(o.prototype,"version",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u(o.prototype,"handleSelection",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"handleSelection"),o.prototype),u(o.prototype,"handleKeyDown",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"handleKeyDown"),o.prototype),o);(0,t.setComponentTemplate)(c,d)})),define("vault/components/external-link",["exports","core/components/external-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/field-group-show",["exports","core/components/field-group-show"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/file-to-array-buffer",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","filesize","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,a.createTemplateFactory)({id:"pUIVhHC9",block:'[[[10,0],[14,0,"box is-fullwidth is-marginless is-shadowless"],[12],[1,"\\n  "],[8,[39,1],[[4,[38,2],["change",[30,0,["pickedFile"]]],null]],null,[["default"],[[[[1,"\\n    "],[8,[30,1,["Label"]],null,null,[["default"],[[[[1,[30,2]]],[]]]]],[1,"\\n"],[41,[30,3],[[[1,"      "],[8,[30,1,["HelperText"]],null,null,[["default"],[[[[1,"\\n        "],[1,[30,3]],[1,"\\n      "]],[]]]]],[1,"\\n"]],[]],null],[41,[30,4],[[[1,"      "],[8,[30,1,["Error"]],null,null,[["default"],[[[[1,[30,4]]],[]]]]],[1,"\\n"]],[]],null],[1,"  "]],[1]]]]],[1,"\\n"],[41,[30,0,["filename"]],[[[1,"    "],[10,2],[14,0,"help has-text-grey"],[12],[1,"\\n      This file is\\n      "],[1,[30,0,["fileSize"]]],[1,"\\n      and was created on\\n      "],[1,[28,[35,5],[[30,0,["fileLastModified"]],"MMM dd, yyyy hh:mm:ss a"],null]],[1,".\\n    "],[13],[1,"\\n"]],[]],null],[13]],["F","@label","@fileHelpText","@error"],false,["div","hds/form/file-input/field","on","if","p","date-format"]]',moduleName:"vault/components/file-to-array-buffer.hbs",isStrictMode:!1})
let m=e.default=(o=class extends n.default{constructor(...e){super(...e),d(this,"filename",s,this),d(this,"fileSize",u,this),d(this,"fileLastModified",c,this)}readFile(e){const t=new FileReader
t.onload=()=>{this.isDestroyed||this.isDestroying||this.fileChange(t.result,e)},t.readAsArrayBuffer(e)}pickedFile(e){const{files:t}=e.target
if(t.length)for(let n=0,i=t.length;n<i;n++)this.readFile(t[n])}fileChange(e,t){const{name:n,size:i,lastModifiedDate:r}=t||{}
this.filename=n,this.fileSize=i?(0,l.default)(i):null,this.fileLastModified=r,this.args.onChange(e,n)}},s=p(o.prototype,"filename",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),u=p(o.prototype,"fileSize",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),c=p(o.prototype,"fileLastModified",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),p(o.prototype,"pickedFile",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"pickedFile"),o.prototype),p(o.prototype,"fileChange",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"fileChange"),o.prototype),o);(0,t.setComponentTemplate)(f,m)})),define("vault/components/filter-input-explicit",["exports","core/components/filter-input-explicit"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/filter-input",["exports","core/components/filter-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/flash-message",["exports","ember-cli-flash/components/flash-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
class n extends t.default{get alertType(){return`is-${this.args.flash.type||""}`}}e.default=n})),define("vault/components/flash-toast",["exports","@ember/component","@ember/string","@glimmer/component","@ember/template-factory"],(function(e,t,n,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const l=(0,r.createTemplateFactory)({id:"hc3pr45P",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-bottom-margin-m"]],[["@color","@onDismiss"],[[30,0,["color"]],[30,1]]],[["default"],[[[[1,"\\n  "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,[30,0,["title"]]]],[]]]]],[1,"\\n  "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,"\\n    "],[10,2],[14,0,"is-word-break"],[12],[1,[30,3,["message"]]],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[2]]]]]],["@close","T","@flash"],false,["hds/toast","p"]]',moduleName:"vault/components/flash-toast.hbs",isStrictMode:!1})
class a extends i.default{get color(){switch(this.args.flash.type){case"info":return"highlight"
case"danger":return"critical"
case"warning":case"success":return this.args.flash.type
default:return"neutral"}}get title(){return this.args.flash.title?this.args.flash.title:"danger"===this.args.flash.type?"Error":(0,n.capitalize)(this.args.flash.type)}}e.default=a,(0,t.setComponentTemplate)(l,a)})),define("vault/components/form-field-from-model",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"BSWVICnG",block:'[[[1,"\\n"],[10,0],[14,0,"field"],[12],[1,"\\n"],[41,[51,[28,[37,2],[[28,[37,3],[[30,1,["options","editType"]],[28,[37,4],["boolean","searchSelect","mountAccessor","kv","file","ttl","stringArray","json"],null]],null],[28,[37,5],[[30,1,["type"]],"boolean"],null]],null]],[[[41,[51,[28,[37,5],[[30,1,["type"]],"object"],null]],[[[1,"      "],[10,"label"],[15,"for",[30,1,["name"]]],[14,0,"is-label"],[12],[1,"\\n        "],[1,[28,[35,7],[[28,[37,2],[[30,1,["options","label"]],[28,[37,8],[[28,[37,9],[[30,1,["name"]]],null]],null]],null]],null]],[1,"\\n"],[41,[30,1,["options","helpText"]],[[[1,"          "],[8,[39,11],null,null,[["default"],[[[[1,[30,1,["options","helpText"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n"]],[]],null]],[]],null],[41,[30,1,["options","possibleValues"]],[[[1,"    "],[10,0],[14,0,"control is-expanded"],[12],[1,"\\n      "],[10,0],[14,0,"select is-fullwidth"],[12],[1,"\\n        "],[10,"select"],[15,3,[30,1,["name"]]],[15,1,[30,1,["name"]]],[15,"onchange",[28,[37,13],[[30,0],[28,[37,14],[[28,[37,15],[[30,2],[30,1,["name"]]],null]],null]],[["value"],["target.value"]]]],[12],[1,"\\n"],[42,[28,[37,17],[[28,[37,17],[[30,1,["options","possibleValues"]]],null]],null],null,[[[1,"            "],[10,"option"],[15,"selected",[28,[37,5],[[28,[37,15],[[30,2],[30,1,["name"]]],null],[30,3]],null]],[15,2,[30,3]],[12],[1,"\\n              "],[1,[30,3]],[1,"\\n            "],[13],[1,"\\n"]],[3]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[41,[28,[37,5],[[30,1,["options","editType"]],"ttl"],null],[[[1,"    "],[8,[39,19],null,[["@initialValue","@initialEnabled","@label","@helperTextDisabled","@helperTextEnabled","@onChange"],[[28,[37,2],[[28,[37,15],[[30,2],[30,1,["name"]]],null],[30,1,["options","defaultValue"]]],null],[28,[37,2],[[28,[37,15],[[30,2],[30,1,["name"]]],null],false],null],[28,[37,2],[[30,1,["options","label"]],[28,[37,8],[[28,[37,9],[[30,1,["name"]]],null]],null]],null],"If this is not set, the engine default will be used.","Disable lease after",[30,4]]],null],[1,"\\n"]],[]],[[[41,[28,[37,2],[[28,[37,5],[[30,1,["type"]],"number"],null],[28,[37,5],[[30,1,["type"]],"string"],null]],null],[[[1,"    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[8,[39,20],[[16,1,[30,1,["name"]]],[24,0,"input"]],[["@value"],[[28,[37,15],[[30,2],[28,[37,2],[[30,1,["options","fieldValue"]],[30,1,["name"]]],null]],null]]],null],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[41,[28,[37,5],[[30,1,["type"]],"boolean"],null],[[[1,"    "],[10,0],[14,0,"b-checkbox"],[12],[1,"\\n      "],[10,"input"],[15,1,[30,1,["name"]]],[14,0,"styled"],[15,"checked",[28,[37,15],[[30,0,["model"]],[30,1,["name"]]],null]],[15,"onchange",[28,[37,13],[[30,0],[28,[37,14],[[28,[37,15],[[30,0,["model"]],[30,1,["name"]]],null]],null]],[["value"],["target.checked"]]]],[14,4,"checkbox"],[12],[13],[1,"\\n\\n      "],[10,"label"],[15,"for",[30,1,["name"]]],[14,0,"is-label"],[12],[1,"\\n        "],[1,[28,[35,7],[[28,[37,2],[[30,1,["options","label"]],[28,[37,8],[[28,[37,9],[[30,1,["name"]]],null]],null]],null]],null]],[1,"\\n"],[41,[30,1,["options","helpText"]],[[[1,"          "],[8,[39,11],null,null,[["default"],[[[[1,[30,1,["options","helpText"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[41,[28,[37,5],[[30,1,["type"]],"object"],null],[[[1,"    "],[8,[39,21],null,[["@title","@helpText","@value","@valueUpdated"],[[28,[37,7],[[28,[37,2],[[30,1,["options","label"]],[28,[37,8],[[28,[37,9],[[30,1,["name"]]],null]],null]],null]],null],[30,1,["options","helpText"]],[52,[28,[37,15],[[30,2],[30,1,["name"]]],null],[28,[37,22],[[28,[37,15],[[30,2],[30,1,["name"]]],null]],null],[30,5]],[30,6]]],null],[1,"\\n  "]],[]],null]],[]]]],[]]]],[]]]],[]]],[13]],["@attr","@model","val","@updateTtl","@emptyData","@editorUpdated"],false,["div","unless","or","includes","array","eq","label","capitalize","humanize","dasherize","if","info-tooltip","select","action","mut","get","each","-track-array","option","ttl-picker","input","json-editor","stringify"]]',moduleName:"vault/components/form-field-from-model.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/form-field-groups-loop",["exports","core/components/form-field-groups-loop"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field-groups",["exports","core/components/form-field-groups"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field-label",["exports","core/components/form-field-label"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/form-field",["exports","core/components/form-field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/form-save-buttons",["exports","core/components/form-save-buttons"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/generate-credentials-database",["exports","@ember/component","@glimmer/component","@ember/object","@ember/template-factory"],(function(e,t,n,i,r){var l
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=(0,r.createTemplateFactory)({id:"mUop228i",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@text","@route","@model"],[[30,2],"vault.cluster.secrets.backend.overview",[30,2]]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@current"],[[30,3],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      "],[1,[30,3]],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[10,0],[15,0,[52,[30,4],"box is-fullwidth is-sideless is-marginless"]],[12],[1,"\\n"],[41,[51,[30,4]],[[[1,"    "],[8,[39,7],null,[["@title","@subTitle","@icon","@bottomBorder","@message"],[[30,0,["errorTitle"]],[29,["Error ",[30,5,["errorHttpStatus"]]]],"alert-circle",true,[30,5,["errorMessage"]]]],[["default"],[[[[1,"\\n      "],[8,[39,8],null,[["@iconPosition","@icon","@text","@href"],["trailing","docs-link","Database documentation",[28,[37,9],["/vault/api-docs/secret/databases"],null]]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null],[41,[28,[37,10],[[28,[37,11],[[30,5,["errorMessage"]]],null],[28,[37,12],[[30,4],"dynamic"],null]],null],[[[1,"    "],[8,[39,13],[[24,0,"has-top-bottom-margin"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n      "],[8,[30,6,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n      "],[8,[30,6,["Description"]],null,null,[["default"],[[[[1,"\\n        You will not be able to access these credentials later, so please copy them now.\\n      "]],[]]]]],[1,"\\n    "]],[6]]]]],[1,"\\n"]],[]],null],[41,[28,[37,10],[[28,[37,12],[[30,4],"dynamic"],null],[30,5,["username"]]],null],[[[1,"    "],[8,[39,14],null,[["@label","@value"],["Username",[30,5,["username"]]]],[["default"],[[[[1,"\\n      "],[8,[39,15],null,[["@value","@name","@displayOnly","@allowCopy"],[[30,5,["username"]],"Username",true,true]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[39,14],null,[["@label","@value"],["Password",[30,5,["password"]]]],[["default"],[[[[1,"\\n      "],[8,[39,15],null,[["@value","@name","@displayOnly","@allowCopy"],[[30,5,["password"]],"Password",true,true]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[39,14],null,[["@label","@value"],["Lease ID",[30,5,["leaseId"]]]],null],[1,"\\n    "],[8,[39,14],null,[["@label","@value"],["Lease Duration",[28,[37,16],[[30,5,["leaseDuration"]]],null]]],null],[1,"\\n"]],[]],null],[41,[28,[37,10],[[28,[37,12],[[30,4],"static"],null],[30,5,["username"]]],null],[[[1,"    "],[8,[39,14],null,[["@label","@value","@tooltipText","@isTooltipCopyable"],["Last Vault rotation",[28,[37,17],[[30,5,["lastVaultRotation"]],"MMMM d yyyy, h:mm:ss a"],null],[30,5,["lastVaultRotation"]],true]],null],[1,"\\n    "],[8,[39,14],null,[["@label","@value"],["Password",[30,5,["password"]]]],[["default"],[[[[1,"\\n      "],[8,[39,15],null,[["@value","@name","@displayOnly","@allowCopy"],[[30,5,["password"]],"Password",true,true]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[39,14],null,[["@label","@value"],["Username",[30,5,["username"]]]],null],[1,"\\n    "],[8,[39,14],null,[["@label","@value"],["Rotation Period",[28,[37,16],[[30,5,["rotationPeriod"]]],null]]],null],[1,"\\n    "],[8,[39,14],null,[["@label","@value"],["Time Remaining",[28,[37,16],[[30,5,["ttl"]]],null]]],null],[1,"\\n"]],[]],null],[13],[1,"\\n"],[10,0],[14,0,"has-top-bottom-margin"],[12],[1,"\\n  "],[8,[39,18],[[4,[38,19],["click",[28,[37,20],[[30,0],"redirectPreviousPage"],null]],null]],[["@text"],["Back"]],null],[1,"\\n"],[13]],["p","@backendPath","@roleName","@roleType","@model","A"],false,["page-header","hds/breadcrumb","hds/breadcrumb/item","h1","div","if","unless","empty-state","hds/link/standalone","doc-link","and","not","eq","hds/alert","info-table-row","masked-input","format-duration","date-format","hds/button","on","action"]]',moduleName:"vault/components/generate-credentials-database.hbs",isStrictMode:!1})
let o=e.default=(l=class extends n.default{get errorTitle(){return this.args.model.errorTitle||"Something went wrong"}redirectPreviousPage(){window.history.back()}},s=l.prototype,u="redirectPreviousPage",c=[i.action],d=Object.getOwnPropertyDescriptor(l.prototype,"redirectPreviousPage"),p=l.prototype,f={},Object.keys(d).forEach((function(e){f[e]=d[e]})),f.enumerable=!!f.enumerable,f.configurable=!!f.configurable,("value"in f||f.initializer)&&(f.writable=!0),f=c.slice().reverse().reduce((function(e,t){return t(s,u,e)||e}),f),p&&void 0!==f.initializer&&(f.value=f.initializer?f.initializer.call(p):void 0,f.initializer=void 0),void 0===f.initializer&&Object.defineProperty(s,u,f),l)
var s,u,c,d,p,f;(0,t.setComponentTemplate)(a,o)})),define("vault/components/generate-credentials-totp",["exports","@ember/component","@glimmer/component","@glimmer/tracking","ember-concurrency","@ember/service","@ember/object","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p,f
function m(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function h(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function b(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,o.createTemplateFactory)({id:"wT9Bvnfw",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@text","@route","@model"],[[30,2],"vault.cluster.secrets.backend",[30,2]]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@route","@model"],[[30,3],"vault.cluster.secrets.backend.show",[30,3]]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@current"],[[30,0,["title"]],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      "],[1,[30,0,["title"]]],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[10,0],[14,0,"box is-fullwidth is-sideless is-paddingless is-marginless"],[12],[1,"\\n  "],[8,[39,5],null,[["@label"],["Code"]],[["default"],[[[[1,"\\n    "],[8,[39,6],null,[["@name","@value","@displayOnly","@allowCopy"],["code",[30,0,["totpCode"]],true,true]],null],[1,"\\n    "],[10,"label"],[14,0,"has-left-padding-s"],[12],[1,"\\n      "],[10,0],[12],[1,"Valid for "],[1,[30,0,["remainingTime"]]],[1," seconds"],[13],[1,"\\n      "],[10,"progress"],[14,1,"code-validity"],[15,2,[30,0,["remainingTime"]]],[15,"max",[30,4]],[12],[13],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"],[13],[1,"\\n"],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n  "],[10,0],[14,0,"control"],[12],[1,"\\n    "],[8,[39,9],[[4,[38,10],["click",[30,0,["redirectPreviousPage"]]],null]],[["@text","@color"],["Back","secondary"]],null],[1,"\\n  "],[13],[1,"\\n"],[13]],["p","@backendPath","@keyName","@totpCodePeriod"],false,["page-header","hds/breadcrumb","hds/breadcrumb/item","h1","div","info-table-row","masked-input","label","progress","hds/button","on"]]',moduleName:"vault/components/generate-credentials-totp.hbs",isStrictMode:!1})
let g=e.default=(s=(0,r.task)({restartable:!0}),u=class extends n.default{constructor(){super(...arguments),m(this,"elapsedTime",c,this),m(this,"totpCode",d,this),m(this,"store",p,this),m(this,"router",f,this),h(this,"title","Generate TOTP code"),this.startTimer.perform()}get remainingTime(){const{totpCodePeriod:e}=this.args
return e-this.elapsedTime}*startTimer(){const{backendPath:e,keyName:t,totpCodePeriod:n}=this.args
for(this.generateTotpCode(e,t);this.elapsedTime<=n;)yield(0,r.timeout)(1e3),this.elapsedTime+=1
this.elapsedTime>n&&(this.elapsedTime=0,this.generateTotpCode(e,t),this.startTimer.perform())}async generateTotpCode(e,t){try{const n=await this.store.adapterFor("totp-key").generateCode(e,t)
this.totpCode=n.code}catch(n){return}}redirectPreviousPage(){const{backRoute:e,keyName:t}=this.args
"vault.cluster.secrets.backend.show"===e?this.router.transitionTo(this.args.backRoute,t):this.router.transitionTo(this.args.backRoute)}},c=b(u.prototype,"elapsedTime",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 0}}),d=b(u.prototype,"totpCode",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),p=b(u.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=b(u.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b(u.prototype,"startTimer",[s],Object.getOwnPropertyDescriptor(u.prototype,"startTimer"),u.prototype),b(u.prototype,"redirectPreviousPage",[a.action],Object.getOwnPropertyDescriptor(u.prototype,"redirectPreviousPage"),u.prototype),u);(0,t.setComponentTemplate)(y,g)})),define("vault/components/generate-credentials",["exports","@ember/component","@ember/service","@ember/object","@glimmer/component","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u,c,d,p,f
function m(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function h(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function b(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,a.createTemplateFactory)({id:"PJzyjqjo",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@text","@route","@model"],[[30,2],"vault.cluster.secrets.backend",[30,2]]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@route","@model"],["Credentials","vault.cluster.secrets.backend",[30,2]]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@route","@model"],[[30,3],"vault.cluster.secrets.backend.show",[30,3]]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@current"],[[30,0,["options","title"]],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      "],[1,[30,0,["options","title"]]],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["hasGenerated"]],[[[1,"  "],[10,0],[14,0,"box is-fullwidth is-sideless is-paddingless is-marginless"],[12],[1,"\\n    "],[8,[39,6],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n"],[41,[51,[30,0,["model","isError"]]],[[[1,"      "],[8,[39,8],[[24,0,"has-top-bottom-margin"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n        "],[8,[30,4,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n        "],[8,[30,4,["Description"]],null,null,[["default"],[[[[1,"\\n          You will not be able to access this information later, so please copy the information below.\\n        "]],[]]]]],[1,"\\n      "]],[4]]]]],[1,"\\n"]],[]],null],[42,[28,[37,10],[[28,[37,10],[[30,0,["displayFields"]]],null]],null],null,[[[44,[[28,[37,12],[[30,0,["model","allByKey"]],[30,5]],null]],[[[41,[28,[37,13],[[30,6,["type"]],"object"],null],[[[1,"          "],[8,[39,14],null,[["@label","@value"],[[28,[37,15],[[28,[37,16],[[30,6,["options","label"]],[28,[37,17],[[28,[37,18],[[30,6,["name"]]],null]],null]],null]],null],[28,[37,19],[[28,[37,12],[[30,0,["model"]],[30,6,["name"]]],null]],null]]],null],[1,"\\n"]],[]],[[[41,[30,6,["options","masked"]],[[[41,[28,[37,12],[[30,0,["model"]],[30,6,["name"]]],null],[[[1,"              "],[8,[39,14],null,[["@label","@value"],[[28,[37,15],[[28,[37,16],[[30,6,["options","label"]],[28,[37,17],[[28,[37,18],[[30,6,["name"]]],null]],null]],null]],null],[28,[37,12],[[30,0,["model"]],[30,6,["name"]]],null]]],[["default"],[[[[1,"\\n                "],[8,[39,20],null,[["@value","@name","@displayOnly","@allowCopy"],[[28,[37,12],[[30,0,["model"]],[30,6,["name"]]],null],[30,6,["name"]],true,true]],null],[1,"\\n              "]],[]]]]],[1,"\\n"]],[]],null]],[]],[[[41,[28,[37,21],[[28,[37,12],[[30,0,["model"]],[30,6,["name"]]],null],[28,[37,16],[[28,[37,13],[[30,6,["name"]],"issueDate"],null],[28,[37,13],[[30,6,["name"]],"expiryDate"],null]],null]],null],[[[1,"            "],[8,[39,14],null,[["@label","@value"],[[28,[37,15],[[28,[37,16],[[30,6,["options","label"]],[28,[37,17],[[28,[37,18],[[30,6,["name"]]],null]],null]],null]],null],[28,[37,22],[[28,[37,12],[[30,0,["model"]],[30,6,["name"]]],null],"MMM dd, yyyy hh:mm:ss a"],null]]],null],[1,"\\n"]],[]],[[[1,"            "],[8,[39,14],null,[["@label","@value"],[[28,[37,15],[[28,[37,16],[[30,6,["options","label"]],[28,[37,17],[[28,[37,18],[[30,6,["name"]]],null]],null]],null]],null],[28,[37,12],[[30,0,["model"]],[30,6,["name"]]],null]]],null],[1,"\\n          "]],[]]]],[]]]],[]]]],[6]]]],[5]],null],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[8,[39,23],[[24,0,"primary"]],[["@text","@textToCopy","@onError"],["Copy credentials",[30,0,["model","toCreds"]],[28,[37,24],[[28,[37,25],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n    "],[13],[1,"\\n"],[41,[30,0,["model","leaseId"]],[[[1,"      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,23],[[24,0,"secondary"]],[["@text","@textToCopy","@onError"],["Copy Lease ID",[30,0,["model","leaseId"]],[28,[37,24],[[28,[37,25],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"    "],[10,0],[14,0,"control"],[12],[1,"\\n"],[41,[30,0,["options","backIsListLink"]],[[[1,"        "],[8,[39,26],null,[["@text","@color","@route","@model"],["Back","secondary","vault.cluster.secrets.backend.list-root",[30,2]]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,26],[[4,[38,27],["click",[30,0,["reset"]]],null]],[["@text","@color"],["Back","secondary"]],null],[1,"\\n"]],[]]],[1,"    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[4,[38,27],["submit",[30,0,["create"]]],null],[12],[1,"\\n    "],[10,0],[15,0,[29,["box is-sideless is-fullwidth is-marginless ",[52,[30,0,["helpText"]],"no-padding-top"]]]],[12],[1,"\\n      "],[8,[39,29],null,[["@mode","@noun"],["generate","credential"]],null],[1,"\\n      "],[8,[39,6],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n"],[41,[30,0,["helpText"]],[[[1,"        "],[10,2],[14,0,"is-hint"],[12],[1,[30,0,["helpText"]]],[13],[1,"\\n"]],[]],null],[42,[28,[37,10],[[28,[37,10],[[30,0,["formFields"]]],null]],null],null,[[[1,"        "],[8,[39,31],null,[["@attr","@model"],[[28,[37,12],[[30,0,["model","allByKey"]],[30,7]],null],[30,0,["model"]]]],null],[1,"\\n"]],[7]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,32],null,null,[["default"],[[[[1,"\\n        "],[8,[39,26],[[16,"disabled",[30,0,["loading"]]],[24,4,"submit"]],[["@text","@icon"],["Generate",[52,[30,0,["loading"]],"loading"]]],null],[1,"\\n        "],[8,[39,26],null,[["@text","@route","@color","@model"],["Cancel","vault.cluster.secrets.backend.list-root","secondary",[30,2]]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["p","@backendPath","@roleName","A","key","attr","key"],false,["page-header","hds/breadcrumb","hds/breadcrumb/item","h1","if","div","message-error","unless","hds/alert","each","-track-array","let","get","eq","info-table-row","capitalize","or","humanize","dasherize","stringify","masked-input","and","date-format","hds/copy/button","fn","set-flash-message","hds/button","on","form","namespace-reminder","p","form-field","hds/button-set"]]',moduleName:"vault/components/generate-credentials.hbs",isStrictMode:!1}),g={ssh:{model:"ssh-otp-credential",title:"Generate SSH Credentials",formFields:["username","ip"],displayFields:["username","ip","key","keyType","port"]},aws:{model:"aws-credential",title:"Generate AWS Credentials",backIsListLink:!0,displayFields:["accessKey","secretKey","securityToken","leaseId","renewable","leaseDuration"],formFields:e=>({iam_user:["credentialType"],assumed_role:["credentialType","ttl","roleArn"],federation_token:["credentialType","ttl"],session_token:["credentialType","ttl"]}[e.credentialType])}}
let v=e.default=(o=class extends r.default{constructor(){super(...arguments),m(this,"controlGroup",s,this),m(this,"store",u,this),m(this,"router",c,this),m(this,"model",d,this),m(this,"loading",p,this),m(this,"hasGenerated",f,this),h(this,"emptyData","{\n}")
const e=this.modelForType()
this.model=this.generateNewModel(e)}willDestroy(){!(this.store&&!this.store.isDestroying)||this.model.isDestroyed||this.model.isDestroying||this.model.unloadRecord(),super.willDestroy()}modelForType(){const e=this.options
if(e)return e.model
this.router.transitionTo("vault.cluster.secrets.backend.list-root",this.args.backendPath)}get helpText(){return"aws-credential"===this.options?.model?"For Vault roles of credential type iam_user, there are no inputs, just submit the form. Choose a type to change the input options.":""}get options(){return g[this.args.backendType]}get formFields(){const e=this.options
return"function"==typeof e.formFields?e.formFields(this.model):e.formFields}get displayFields(){return this.options.displayFields}generateNewModel(e){if(!e)return
const{roleName:t,backendPath:n,awsRoleType:i}=this.args,r={role:{backend:n,name:t},id:`${n}-${t}`}
return i&&(r.credentialType=i),this.store.createRecord(e,r)}replaceModel(){const e=this.modelForType()
e&&(this.model&&this.model.unloadRecord(),this.model=this.generateNewModel(e))}create(e){e.preventDefault(),this.loading=!0,this.model.save().then((()=>{this.hasGenerated=!0})).catch((e=>{if("Control Group encountered"===e.message){this.controlGroup.saveTokenFromError(e)
const t=this.controlGroup.logFromError(e)
e.errors=[t.content]}throw e})).finally((()=>{this.loading=!1}))}editorUpdated(e,t){try{this.model[e]=JSON.parse(t)}catch{}}reset(){this.hasGenerated=!1,this.replaceModel()}},s=b(o.prototype,"controlGroup",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=b(o.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=b(o.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=b(o.prototype,"model",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(o.prototype,"loading",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),f=b(o.prototype,"hasGenerated",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),b(o.prototype,"create",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"create"),o.prototype),b(o.prototype,"editorUpdated",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"editorUpdated"),o.prototype),b(o.prototype,"reset",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"reset"),o.prototype),o);(0,t.setComponentTemplate)(y,v)})),define("vault/components/generated-item-list",["exports","@ember/component","@ember/service","@glimmer/component","@ember/object","@ember/owner","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d
function p(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function f(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m=(0,o.createTemplateFactory)({id:"Wf4JSpkS",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@text","@route"],["Auth Methods","vault.cluster.access.methods"]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@current"],[[30,2,["id"]],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      "],[1,[30,2,["id"]]],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n"],[44,[[28,[37,5],[[30,2],"authConfig",[30,3]],null]],[[[41,[30,4,["length"]],[[[1,"    "],[10,0],[14,0,"tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[12],[1,"\\n      "],[10,"nav"],[14,0,"tabs"],[15,"aria-label",[29,["navigation to manage ",[30,2,["id"]]]]],[12],[1,"\\n        "],[10,"ul"],[12],[1,"\\n"],[42,[28,[37,11],[[28,[37,11],[[30,4]],null]],null],null,[[[1,"            "],[10,"li"],[12],[1,"\\n              "],[8,[39,13],null,[["@route","@models"],[[30,5,["route"]],[30,5,["routeParams"]]]],[["default"],[[[[1,"\\n                "],[1,[30,5,["label"]]],[1,"\\n              "]],[]]]]],[1,"\\n            "],[13],[1,"\\n"]],[5]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],null]],[4]]],[8,[39,14],null,null,[["default"],[[[[1,"\\n  "],[8,[39,15],null,null,[["default"],[[[[1,"\\n    "],[8,[39,16],null,[["@route","@models","@type"],["vault.cluster.access.method.item.create",[28,[37,17],[[30,2,["id"]],[30,6]],null],"add"]],[["default"],[[[[1,"\\n      Create\\n      "],[1,[28,[35,18],[[30,6]],null]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]]],[1,"\\n"],[8,[39,19],null,[["@items","@itemNoun","@paginationRouteName","@paginationRouteParams"],[[30,7],[30,6],"vault.cluster.access.method.item.list",[28,[37,17],[[30,2,["id"]],[30,6]],null]]],[["default"],[[[[1,"\\n"],[41,[30,8,["empty"]],[[[1,"    "],[8,[30,8,["empty"]],null,[["@title","@message"],[[29,["No ",[28,[37,20],[[30,6]],null]," yet"]],[29,["A list of ",[28,[37,20],[[30,6]],null]," will be listed here. Create your first ",[30,6]," to get started."]]]],[["default"],[[[[1,"\\n      "],[8,[39,21],null,[["@icon","@text","@route","@models"],["plus",[29,["Create ",[28,[37,18],[[30,6]],null]]],"vault.cluster.access.method.item.create",[28,[37,17],[[30,2,["id"]],[30,6]],null]]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],[[[41,[30,8,["item"]],[[[1,"    "],[8,[39,22],null,[["@linkParams"],[[28,[37,17],["vault.cluster.access.method.item.show",[30,2,["id"]],[30,6],[30,8,["item","id"]]],null]]],[["default"],[[[[1,"\\n      "],[8,[30,9,["content"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,23],[[24,0,"has-text-grey-light"]],[["@name"],["folder"]],null],[1,[30,8,["item","id"]]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,9,["menu"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,24],null,[["@isInline","@listPosition"],[true,"bottom-right"]],[["default"],[[[[1,"\\n          "],[8,[30,10,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal","Overflow options",false]],null],[1,"\\n          "],[8,[30,10,["Interactive"]],null,[["@route","@models"],["vault.cluster.access.method.item.show",[28,[37,17],[[30,2,["id"]],[30,6],[30,8,["item","id"]]],null]]],[["default"],[[[[1,"View "],[1,[28,[35,18],[[30,6]],null]]],[]]]]],[1,"\\n          "],[8,[30,10,["Interactive"]],null,[["@route","@models"],["vault.cluster.access.method.item.edit",[28,[37,17],[[30,2,["id"]],[30,6],[30,8,["item","id"]]],null]]],[["default"],[[[[1,"Edit "],[1,[28,[35,18],[[30,6]],null]]],[]]]]],[1,"\\n          "],[8,[30,10,["Interactive"]],[[4,[38,25],["click",[28,[37,26],[[28,[37,27],[[30,0,["itemToDelete"]]],null],[30,8,["item"]]],null]],null]],[["@color"],["critical"]],[["default"],[[[[1,"\\n            Delete\\n            "],[1,[28,[35,18],[[30,6]],null]],[1,"\\n          "]],[]]]]],[1,"\\n        "]],[10]]]]],[1,"\\n      "]],[]]]]],[1,"\\n"],[41,[28,[37,28],[[30,8,["item"]],[30,0,["itemToDelete"]]],null],[[[1,"        "],[8,[39,29],null,[["@color","@onClose","@onConfirm","@confirmTitle","@confirmMessage"],["critical",[28,[37,26],[[28,[37,27],[[30,0,["itemToDelete"]]],null],null],null],[28,[37,30],[[30,0],[28,[37,31],[[30,9,["callMethod"]],"destroyRecord",[30,0,["itemToDelete"]],[28,[37,32],["Successfully deleted ",[28,[37,18],[[30,6]],null]," ",[30,0,["itemToDelete","id"]],"."],null],[28,[37,32],["There was an error deleting this ",[28,[37,18],[[30,6]],null]],null],[28,[37,30],[[30,0],"refreshItemList"],null]],null]],null],[29,["Delete ",[28,[37,18],[[30,6]],null],"?"]],[29,["Are you sure you want to delete ",[28,[37,18],[[30,6]],null]," ",[30,0,["itemToDelete","id"]],"?"]]]],null],[1,"\\n"]],[]],null],[1,"    "]],[9]]]]],[1,"\\n  "]],[]],null]],[]]]],[8]]]]]],["p","@methodModel","@paths","tabs","tab","@itemType","@model","list","Item","dd"],false,["page-header","hds/breadcrumb","hds/breadcrumb/item","h1","let","tabs-for-auth-section","if","div","nav","ul","each","-track-array","li","link-to","toolbar","toolbar-actions","toolbar-link","array","singularize","list-view","pluralize","hds/link/standalone","list-item","icon","hds/dropdown","on","fn","mut","eq","confirm-modal","action","perform","concat"]]',moduleName:"vault/components/generated-item-list.hbs",isStrictMode:!1})
let h=e.default=(s=class extends i.default{constructor(...e){super(...e),p(this,"router",u,this),p(this,"pagination",c,this),p(this,"itemToDelete",d,this)}refreshItemList(){const e=(0,l.getOwner)(this).lookup(`route:${this.router.currentRouteName}`)
this.pagination.clearDataset(),e.refresh()}},u=f(s.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(s.prototype,"pagination",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=f(s.prototype,"itemToDelete",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f(s.prototype,"refreshItemList",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"refreshItemList"),s.prototype),s);(0,t.setComponentTemplate)(m,h)})),define("vault/components/generated-item",["exports","@ember/component","@ember-data/adapter/error","@ember/service","@ember/object","ember-concurrency","@ember/test-waiters","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=(0,o.createTemplateFactory)({id:"EZtLGI8q",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@text","@route","@models"],[[28,[37,3],[[30,0,["itemType"]]],null],"vault.cluster.access.method.item.list",[28,[37,4],[[30,0,["mountPath"]],[30,0,["itemType"]]],null]]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@current"],[[52,[28,[37,6],[[30,0,["mode"]],"show"],null],[30,0,["model","id"]],[28,[37,7],[[30,0,["mode"]]],null]],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n"],[41,[28,[37,6],[[30,0,["mode"]],"show"],null],[[[1,"      "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n        "],[1,[30,0,["model","id"]]],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[1,"      "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n        "],[1,[28,[35,7],[[30,0,["mode"]]],null]],[1,"\\n        "],[1,[28,[35,9],[[30,0,["itemType"]]],null]],[1,"\\n"],[41,[28,[37,6],[[30,0,["mode"]],"edit"],null],[[[1,"          "],[1,[30,0,["model","id"]]],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n"]],[]]],[1,"  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n"],[41,[28,[37,6],[[30,0,["mode"]],"show"],null],[[[1,"  "],[8,[39,10],null,null,[["default"],[[[[1,"\\n    "],[8,[39,11],null,null,[["default"],[[[[1,"\\n      "],[8,[39,12],[[24,0,"toolbar-button"]],[["@buttonText","@buttonColor","@onConfirmAction","@confirmMessage"],[[29,["Delete ",[30,0,["itemType"]]]],"secondary",[28,[37,13],[[30,0],"deleteItem"],null],[29,["Are you sure you want to delete ",[30,0,["itemType"]]," ",[30,0,["model","id"]],"?"]]]],null],[1,"\\n      "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n      "],[8,[39,15],null,[["@route","@models"],["vault.cluster.access.method.item.edit",[28,[37,4],[[30,0,["mountPath"]],[30,0,["itemType"]],[30,0,["model","id"]]],null]]],[["default"],[[[[1,"\\n        Edit\\n        "],[1,[28,[35,9],[[30,0,["itemType"]]],null]],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],null],[41,[28,[37,6],[[30,0,["mode"]],"show"],null],[[[1,"  "],[8,[39,16],null,[["@model","@showAllFields"],[[30,0,["model"]],true]],null],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[4,[38,13],[[30,0],[28,[37,18],[[30,0,["saveModel"]]],null]],[["on"],["submit"]]],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,19],null,[["@mode","@noun"],["save",[30,0,["itemType"]]]],null],[1,"\\n      "],[8,[39,20],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n      "],[8,[39,21],null,[["@model","@mode","@modelValidations"],[[30,0,["model"]],[30,0,["mode"]],[30,0,["modelValidations"]]]],null],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped-split box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,22],null,null,[["default"],[[[[1,"\\n        "],[8,[39,23],[[16,"disabled",[30,0,["saveModel","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Save",[52,[30,0,["saveModel","isRunning"]],"loading"]]],null],[1,"\\n"],[41,[28,[37,6],[[30,0,["mode"]],"create"],null],[[[1,"          "],[8,[39,23],null,[["@text","@color","@route","@models"],["Cancel","secondary","vault.cluster.access.method.item.list",[28,[37,4],[[30,0,["mountPath"]],[30,0,["itemType"]]],null]]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,23],null,[["@text","@color","@route","@models"],["Cancel","secondary","vault.cluster.access.method.item.show",[28,[37,4],[[30,0,["mountPath"]],[30,0,["itemType"]],[30,0,["model","id"]]],null]]],null],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["p"],false,["page-header","hds/breadcrumb","hds/breadcrumb/item","pluralize","array","if","eq","capitalize","h1","singularize","toolbar","toolbar-actions","confirm-action","action","div","toolbar-link","field-group-show","form","perform","namespace-reminder","message-error","form-field-groups","hds/button-set","hds/button"]]',moduleName:"vault/components/generated-item.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(s,t.default.extend({model:null,itemType:null,flashMessages:(0,i.service)(),router:(0,i.service)(),modelValidations:null,isFormInvalid:!1,props:(0,r.computed)("model",(function(){return this.model.serialize()})),validateForm(){if(this.model.validate&&this.model.isNew){const{isValid:e,state:t}=this.model.validate()
return this.setProperties({modelValidations:t,isFormInvalid:!e}),e}return this.set("isFormInvalid",!1),!0},saveModel:(0,l.task)((0,a.waitFor)((function*(){if(this.validateForm()){try{yield this.model.save()}catch(e){if(e instanceof n.default==!1)throw e
return}this.router.transitionTo("vault.cluster.access.method.item.list").followRedirects(),this.flashMessages.success(`Successfully saved ${this.itemType} ${this.model.id}.`)}}))),init(){this._super(...arguments),"edit"===this.mode&&this.model.fieldGroups.forEach((e=>{e.default&&e.default.forEach((e=>{const t=e.options&&e.options.fieldValue
t&&(this.model[e.name]=this.model[t])}))}))},actions:{onKeyUp(e,t){this.model.set(e,t)},deleteItem(){this.model.destroyRecord().then((()=>{this.router.transitionTo("vault.cluster.access.method.item.list").followRedirects(),this.flashMessages.success(`Successfully deleted ${this.itemType} ${this.model.id}.`)}))}}}))})),define("vault/components/get-credentials-card",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u
function c(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function d(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,a.createTemplateFactory)({id:"Xs/toj0S",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-padding-l"],[17,1]],[["@level","@hasBorder"],["mid",true]],[["default"],[[[[1,"\\n  "],[11,"form"],[4,[38,2],["submit",[30,0,["transitionToCredential"]]],null],[12],[1,"\\n    "],[10,0],[14,0,"is-flex-between is-fullwidth"],[12],[1,"\\n      "],[10,"h3"],[14,0,"title is-5"],[12],[1,[30,2]],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,2],[14,0,"has-top-margin-s has-bottom-margin-xs has-text-weight-semibold"],[12],[1,[30,3]],[13],[1,"\\n    "],[8,[39,6],null,[["@id","@models","@selectLimit","@backend","@fallbackComponent","@onChange","@placeholder"],["search-input-role",[30,4],"1",[30,5],"input-search",[30,0,["handleInput"]],[30,6]]],null],[1,"\\n    "],[8,[39,7],[[16,"disabled",[28,[37,8],[[30,0,["role"]]],null]],[24,4,"submit"]],[["@text","@color"],["Get credentials","secondary"]],null],[1,"\\n  "],[13],[1,"\\n"]],[]]]]]],["&attrs","@title","@searchLabel","@models","@backend","@placeholder"],false,["hds/card/container","form","on","div","h3","p","search-select","hds/button","not"]]',moduleName:"vault/components/get-credentials-card.hbs",isStrictMode:!1})
let f=e.default=(o=class extends n.default{constructor(...e){super(...e),c(this,"router",s,this),c(this,"role",u,this)}transitionToCredential(e){e.preventDefault()
const t=this.role
t&&this.router.transitionTo("vault.cluster.secrets.backend.credentials",t)}handleInput(e){Array.isArray(e)?this.role=e[0]:this.role=e}},s=d(o.prototype,"router",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(o.prototype,"role",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),d(o.prototype,"transitionToCredential",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"transitionToCredential"),o.prototype),d(o.prototype,"handleInput",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"handleInput"),o.prototype),o);(0,t.setComponentTemplate)(p,f)})),define("vault/components/hds/accordion/index",["exports","@hashicorp/design-system-components/components/hds/accordion/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/accordion/item/button",["exports","@hashicorp/design-system-components/components/hds/accordion/item/button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/accordion/item/index",["exports","@hashicorp/design-system-components/components/hds/accordion/item/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/expandable-tr-group",["exports","@hashicorp/design-system-components/components/hds/advanced-table/expandable-tr-group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/index",["exports","@hashicorp/design-system-components/components/hds/advanced-table/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/models/row",["exports","@hashicorp/design-system-components/components/hds/advanced-table/models/row"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/models/table",["exports","@hashicorp/design-system-components/components/hds/advanced-table/models/table"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/td",["exports","@hashicorp/design-system-components/components/hds/advanced-table/td"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/th-button-expand",["exports","@hashicorp/design-system-components/components/hds/advanced-table/th-button-expand"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/th-button-sort",["exports","@hashicorp/design-system-components/components/hds/advanced-table/th-button-sort"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/th-button-tooltip",["exports","@hashicorp/design-system-components/components/hds/advanced-table/th-button-tooltip"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/th-selectable",["exports","@hashicorp/design-system-components/components/hds/advanced-table/th-selectable"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/th-sort",["exports","@hashicorp/design-system-components/components/hds/advanced-table/th-sort"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/th",["exports","@hashicorp/design-system-components/components/hds/advanced-table/th"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/advanced-table/tr",["exports","@hashicorp/design-system-components/components/hds/advanced-table/tr"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/alert/description",["exports","@hashicorp/design-system-components/components/hds/alert/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/alert/index",["exports","@hashicorp/design-system-components/components/hds/alert/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/alert/title",["exports","@hashicorp/design-system-components/components/hds/alert/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-footer/copyright",["exports","@hashicorp/design-system-components/components/hds/app-footer/copyright"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-footer/index",["exports","@hashicorp/design-system-components/components/hds/app-footer/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-footer/item",["exports","@hashicorp/design-system-components/components/hds/app-footer/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-footer/legal-links",["exports","@hashicorp/design-system-components/components/hds/app-footer/legal-links"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-footer/link",["exports","@hashicorp/design-system-components/components/hds/app-footer/link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/app-footer/status-link",["exports","@hashicorp/design-system-components/components/hds/app-footer/status-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/index",["exports","@hashicorp/design-system-components/components/hds/app-frame/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/footer",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/header",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/main",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/main"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/modals",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/modals"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-frame/parts/sidebar",["exports","@hashicorp/design-system-components/components/hds/app-frame/parts/sidebar"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-header/home-link",["exports","@hashicorp/design-system-components/components/hds/app-header/home-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-header/index",["exports","@hashicorp/design-system-components/components/hds/app-header/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-header/menu-button",["exports","@hashicorp/design-system-components/components/hds/app-header/menu-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-side-nav/index",["exports","@hashicorp/design-system-components/components/hds/app-side-nav/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-side-nav/list/back-link",["exports","@hashicorp/design-system-components/components/hds/app-side-nav/list/back-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-side-nav/list/index",["exports","@hashicorp/design-system-components/components/hds/app-side-nav/list/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-side-nav/list/item",["exports","@hashicorp/design-system-components/components/hds/app-side-nav/list/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-side-nav/list/link",["exports","@hashicorp/design-system-components/components/hds/app-side-nav/list/link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-side-nav/list/title",["exports","@hashicorp/design-system-components/components/hds/app-side-nav/list/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-side-nav/portal/index",["exports","@hashicorp/design-system-components/components/hds/app-side-nav/portal/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-side-nav/portal/target",["exports","@hashicorp/design-system-components/components/hds/app-side-nav/portal/target"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/app-side-nav/toggle-button",["exports","@hashicorp/design-system-components/components/hds/app-side-nav/toggle-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/body",["exports","@hashicorp/design-system-components/components/hds/application-state/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/footer",["exports","@hashicorp/design-system-components/components/hds/application-state/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/header",["exports","@hashicorp/design-system-components/components/hds/application-state/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/index",["exports","@hashicorp/design-system-components/components/hds/application-state/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/application-state/media",["exports","@hashicorp/design-system-components/components/hds/application-state/media"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/badge-count/index",["exports","@hashicorp/design-system-components/components/hds/badge-count/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/badge/index",["exports","@hashicorp/design-system-components/components/hds/badge/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/breadcrumb/index",["exports","@hashicorp/design-system-components/components/hds/breadcrumb/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/breadcrumb/item",["exports","@hashicorp/design-system-components/components/hds/breadcrumb/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/breadcrumb/truncation",["exports","@hashicorp/design-system-components/components/hds/breadcrumb/truncation"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/button-set/index",["exports","@hashicorp/design-system-components/components/hds/button-set/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/button/index",["exports","@hashicorp/design-system-components/components/hds/button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/card/container",["exports","@hashicorp/design-system-components/components/hds/card/container"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-block/copy-button",["exports","@hashicorp/design-system-components/components/hds/code-block/copy-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-block/description",["exports","@hashicorp/design-system-components/components/hds/code-block/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-block/index",["exports","@hashicorp/design-system-components/components/hds/code-block/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-block/title",["exports","@hashicorp/design-system-components/components/hds/code-block/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-editor/description",["exports","@hashicorp/design-system-components/components/hds/code-editor/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-editor/full-screen-button",["exports","@hashicorp/design-system-components/components/hds/code-editor/full-screen-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-editor/generic",["exports","@hashicorp/design-system-components/components/hds/code-editor/generic"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-editor/index",["exports","@hashicorp/design-system-components/components/hds/code-editor/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/code-editor/title",["exports","@hashicorp/design-system-components/components/hds/code-editor/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/copy/button/index",["exports","@hashicorp/design-system-components/components/hds/copy/button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/copy/snippet/index",["exports","@hashicorp/design-system-components/components/hds/copy/snippet/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/body",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/description",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/footer",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/header",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/overlay",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/overlay"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dialog-primitive/wrapper",["exports","@hashicorp/design-system-components/components/hds/dialog-primitive/wrapper"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/disclosure-primitive/index",["exports","@hashicorp/design-system-components/components/hds/disclosure-primitive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dismiss-button/index",["exports","@hashicorp/design-system-components/components/hds/dismiss-button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/footer",["exports","@hashicorp/design-system-components/components/hds/dropdown/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/header",["exports","@hashicorp/design-system-components/components/hds/dropdown/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/index",["exports","@hashicorp/design-system-components/components/hds/dropdown/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/checkbox",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/checkbox"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/checkmark",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/checkmark"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/copy-item",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/copy-item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/description",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/generic",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/generic"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/interactive",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/interactive"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/dropdown/list-item/radio",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/radio"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/separator",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/separator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/list-item/title",["exports","@hashicorp/design-system-components/components/hds/dropdown/list-item/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/toggle/button",["exports","@hashicorp/design-system-components/components/hds/dropdown/toggle/button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/toggle/chevron",["exports","@hashicorp/design-system-components/components/hds/dropdown/toggle/chevron"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/dropdown/toggle/icon",["exports","@hashicorp/design-system-components/components/hds/dropdown/toggle/icon"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/body",["exports","@hashicorp/design-system-components/components/hds/flyout/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/description",["exports","@hashicorp/design-system-components/components/hds/flyout/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/footer",["exports","@hashicorp/design-system-components/components/hds/flyout/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/header",["exports","@hashicorp/design-system-components/components/hds/flyout/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/flyout/index",["exports","@hashicorp/design-system-components/components/hds/flyout/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/character-count/index",["exports","@hashicorp/design-system-components/components/hds/form/character-count/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/checkbox/base",["exports","@hashicorp/design-system-components/components/hds/form/checkbox/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/checkbox/field",["exports","@hashicorp/design-system-components/components/hds/form/checkbox/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/checkbox/group",["exports","@hashicorp/design-system-components/components/hds/form/checkbox/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/error/index",["exports","@hashicorp/design-system-components/components/hds/form/error/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/error/message",["exports","@hashicorp/design-system-components/components/hds/form/error/message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/field/index",["exports","@hashicorp/design-system-components/components/hds/form/field/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/fieldset/index",["exports","@hashicorp/design-system-components/components/hds/form/fieldset/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/file-input/base",["exports","@hashicorp/design-system-components/components/hds/form/file-input/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/file-input/field",["exports","@hashicorp/design-system-components/components/hds/form/file-input/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/helper-text/index",["exports","@hashicorp/design-system-components/components/hds/form/helper-text/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/indicator/index",["exports","@hashicorp/design-system-components/components/hds/form/indicator/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/label/index",["exports","@hashicorp/design-system-components/components/hds/form/label/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/legend/index",["exports","@hashicorp/design-system-components/components/hds/form/legend/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/masked-input/base",["exports","@hashicorp/design-system-components/components/hds/form/masked-input/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/masked-input/field",["exports","@hashicorp/design-system-components/components/hds/form/masked-input/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/description",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/group",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio-card/index",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/form/radio-card/label",["exports","@hashicorp/design-system-components/components/hds/form/radio-card/label"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio/base",["exports","@hashicorp/design-system-components/components/hds/form/radio/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio/field",["exports","@hashicorp/design-system-components/components/hds/form/radio/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/radio/group",["exports","@hashicorp/design-system-components/components/hds/form/radio/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/select/base",["exports","@hashicorp/design-system-components/components/hds/form/select/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/select/field",["exports","@hashicorp/design-system-components/components/hds/form/select/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/after-options",["exports","@hashicorp/design-system-components/components/hds/form/super-select/after-options"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/multiple/base",["exports","@hashicorp/design-system-components/components/hds/form/super-select/multiple/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/multiple/field",["exports","@hashicorp/design-system-components/components/hds/form/super-select/multiple/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/option-group",["exports","@hashicorp/design-system-components/components/hds/form/super-select/option-group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/placeholder",["exports","@hashicorp/design-system-components/components/hds/form/super-select/placeholder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/single/base",["exports","@hashicorp/design-system-components/components/hds/form/super-select/single/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/super-select/single/field",["exports","@hashicorp/design-system-components/components/hds/form/super-select/single/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/text-input/base",["exports","@hashicorp/design-system-components/components/hds/form/text-input/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/text-input/field",["exports","@hashicorp/design-system-components/components/hds/form/text-input/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/textarea/base",["exports","@hashicorp/design-system-components/components/hds/form/textarea/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/textarea/field",["exports","@hashicorp/design-system-components/components/hds/form/textarea/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/toggle/base",["exports","@hashicorp/design-system-components/components/hds/form/toggle/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/toggle/field",["exports","@hashicorp/design-system-components/components/hds/form/toggle/field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/toggle/group",["exports","@hashicorp/design-system-components/components/hds/form/toggle/group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/form/visibility-toggle/index",["exports","@hashicorp/design-system-components/components/hds/form/visibility-toggle/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/icon-tile/index",["exports","@hashicorp/design-system-components/components/hds/icon-tile/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/icon/index",["exports","@hashicorp/design-system-components/components/hds/icon/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/interactive/index",["exports","@hashicorp/design-system-components/components/hds/interactive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/layout/flex/index",["exports","@hashicorp/design-system-components/components/hds/layout/flex/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/layout/flex/item",["exports","@hashicorp/design-system-components/components/hds/layout/flex/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/layout/grid/index",["exports","@hashicorp/design-system-components/components/hds/layout/grid/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/layout/grid/item",["exports","@hashicorp/design-system-components/components/hds/layout/grid/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/link/inline",["exports","@hashicorp/design-system-components/components/hds/link/inline"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/link/standalone",["exports","@hashicorp/design-system-components/components/hds/link/standalone"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/menu-primitive/index",["exports","@hashicorp/design-system-components/components/hds/menu-primitive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/body",["exports","@hashicorp/design-system-components/components/hds/modal/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/footer",["exports","@hashicorp/design-system-components/components/hds/modal/footer"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/header",["exports","@hashicorp/design-system-components/components/hds/modal/header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/modal/index",["exports","@hashicorp/design-system-components/components/hds/modal/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/actions",["exports","@hashicorp/design-system-components/components/hds/page-header/actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/badges",["exports","@hashicorp/design-system-components/components/hds/page-header/badges"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/description",["exports","@hashicorp/design-system-components/components/hds/page-header/description"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/index",["exports","@hashicorp/design-system-components/components/hds/page-header/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/subtitle",["exports","@hashicorp/design-system-components/components/hds/page-header/subtitle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/page-header/title",["exports","@hashicorp/design-system-components/components/hds/page-header/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/compact/index",["exports","@hashicorp/design-system-components/components/hds/pagination/compact/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/info/index",["exports","@hashicorp/design-system-components/components/hds/pagination/info/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/nav/arrow",["exports","@hashicorp/design-system-components/components/hds/pagination/nav/arrow"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/nav/ellipsis",["exports","@hashicorp/design-system-components/components/hds/pagination/nav/ellipsis"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/nav/number",["exports","@hashicorp/design-system-components/components/hds/pagination/nav/number"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/numbered/index",["exports","@hashicorp/design-system-components/components/hds/pagination/numbered/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/pagination/size-selector/index",["exports","@hashicorp/design-system-components/components/hds/pagination/size-selector/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/popover-primitive/index",["exports","@hashicorp/design-system-components/components/hds/popover-primitive/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/reveal/index",["exports","@hashicorp/design-system-components/components/hds/reveal/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/reveal/toggle/button",["exports","@hashicorp/design-system-components/components/hds/reveal/toggle/button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/rich-tooltip/bubble",["exports","@hashicorp/design-system-components/components/hds/rich-tooltip/bubble"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/rich-tooltip/index",["exports","@hashicorp/design-system-components/components/hds/rich-tooltip/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/rich-tooltip/toggle",["exports","@hashicorp/design-system-components/components/hds/rich-tooltip/toggle"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/segmented-group/index",["exports","@hashicorp/design-system-components/components/hds/segmented-group/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/separator/index",["exports","@hashicorp/design-system-components/components/hds/separator/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/base",["exports","@hashicorp/design-system-components/components/hds/side-nav/base"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/header/home-link",["exports","@hashicorp/design-system-components/components/hds/side-nav/header/home-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/header/icon-button",["exports","@hashicorp/design-system-components/components/hds/side-nav/header/icon-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/header/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/header/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/side-nav/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/back-link",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/back-link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/item",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/link",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/link"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/list/title",["exports","@hashicorp/design-system-components/components/hds/side-nav/list/title"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/portal/index",["exports","@hashicorp/design-system-components/components/hds/side-nav/portal/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/portal/target",["exports","@hashicorp/design-system-components/components/hds/side-nav/portal/target"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/side-nav/toggle-button",["exports","@hashicorp/design-system-components/components/hds/side-nav/toggle-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/list/index",["exports","@hashicorp/design-system-components/components/hds/stepper/list/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/list/step",["exports","@hashicorp/design-system-components/components/hds/stepper/list/step"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/nav/index",["exports","@hashicorp/design-system-components/components/hds/stepper/nav/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/nav/panel",["exports","@hashicorp/design-system-components/components/hds/stepper/nav/panel"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/nav/step",["exports","@hashicorp/design-system-components/components/hds/stepper/nav/step"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/step/indicator",["exports","@hashicorp/design-system-components/components/hds/stepper/step/indicator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/stepper/task/indicator",["exports","@hashicorp/design-system-components/components/hds/stepper/task/indicator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/index",["exports","@hashicorp/design-system-components/components/hds/table/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/td",["exports","@hashicorp/design-system-components/components/hds/table/td"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th-button-sort",["exports","@hashicorp/design-system-components/components/hds/table/th-button-sort"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th-button-tooltip",["exports","@hashicorp/design-system-components/components/hds/table/th-button-tooltip"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th-selectable",["exports","@hashicorp/design-system-components/components/hds/table/th-selectable"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th-sort",["exports","@hashicorp/design-system-components/components/hds/table/th-sort"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/th",["exports","@hashicorp/design-system-components/components/hds/table/th"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/table/tr",["exports","@hashicorp/design-system-components/components/hds/table/tr"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tabs/index",["exports","@hashicorp/design-system-components/components/hds/tabs/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tabs/panel",["exports","@hashicorp/design-system-components/components/hds/tabs/panel"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tabs/tab",["exports","@hashicorp/design-system-components/components/hds/tabs/tab"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tag/index",["exports","@hashicorp/design-system-components/components/hds/tag/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/text/body",["exports","@hashicorp/design-system-components/components/hds/text/body"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/text/code",["exports","@hashicorp/design-system-components/components/hds/text/code"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/hds/text/display",["exports","@hashicorp/design-system-components/components/hds/text/display"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/text/index",["exports","@hashicorp/design-system-components/components/hds/text/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/time/index",["exports","@hashicorp/design-system-components/components/hds/time/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/time/range",["exports","@hashicorp/design-system-components/components/hds/time/range"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/time/single",["exports","@hashicorp/design-system-components/components/hds/time/single"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/toast/index",["exports","@hashicorp/design-system-components/components/hds/toast/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/tooltip-button/index",["exports","@hashicorp/design-system-components/components/hds/tooltip-button/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/hds/yield/index",["exports","@hashicorp/design-system-components/components/hds/yield/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/icon",["exports","core/components/icon"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/identity/edit-form",["exports","@ember/component","@ember/service","@ember/object","ember-concurrency","vault/helpers/humanize","@ember/test-waiters","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=(0,o.createTemplateFactory)({id:"zR2d5082",block:'[[[1,"\\n"],[41,[28,[37,1],[[28,[37,2],[[30,0,["mode"]],"edit"],null],[30,0,["model","canDelete"]]],null],[[[1,"  "],[8,[39,3],null,null,[["default"],[[[[1,"\\n    "],[8,[39,4],null,null,[["default"],[[[[1,"\\n      "],[8,[39,5],[[24,0,"toolbar-button"]],[["@buttonColor","@buttonText","@confirmTitle","@onConfirmAction"],["secondary",[29,["Delete ",[30,0,["model","identityType"]]]],[29,["Delete this ",[30,0,["model","identityType"]],"?"]],[28,[37,6],[[30,0],"deleteItem",[30,0,["model"]]],null]]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[11,"form"],[4,[38,6],[[30,0],[28,[37,8],[[30,0,["save"]]],null]],[["on"],["submit"]]],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,10],null,[["@mode","@noun"],[[30,0,["mode"]],[28,[37,11],[[28,[37,12],[[30,0,["model","identityType"]]],null]],null]]],null],[1,"\\n    "],[8,[39,13],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n"],[41,[28,[37,2],[[30,0,["mode"]],"merge"],null],[[[1,"      "],[8,[39,14],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n        "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n        "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"Metadata on merged entities is not preserved, you will need to recreate it on the entity you merge to."]],[]]]]],[1,"\\n      "]],[1]]]]],[1,"\\n"]],[]],null],[42,[28,[37,16],[[28,[37,16],[[30,0,["model","fields"]]],null]],null],null,[[[1,"      "],[8,[39,17],null,[["@attr","@model"],[[30,2],[30,3]]],[["default"],[[[[1,"\\n        "],[10,0],[14,0,"form-section"],[12],[1,"\\n"],[41,[30,0,["model","canCreatePolicies"]],[[[1,"            "],[8,[39,18],null,[["@id","@label","@labelClass","@models","@inputValue","@onChange","@fallbackComponent","@modalFormTemplate","@excludeOptions"],["policies","Policies","title is-4",[28,[37,19],["policy/acl","policy/rgp"],null],[30,3,["policies"]],[28,[37,6],[[30,0],[28,[37,20],[[30,0,["model","policies"]]],null]],null],"string-list","modal-form/policy-template",[28,[37,19],["root"],null]]],null],[1,"\\n"]],[]],[[[1,"            "],[8,[39,21],null,[["@id","@label","@labelClass","@models","@inputValue","@onChange","@fallbackComponent","@disallowNewItems"],["policies","Policies","title is-4",[28,[37,19],["policy/acl","policy/rgp"],null],[30,3,["policies"]],[28,[37,6],[[30,0],[28,[37,20],[[30,0,["model","policies"]]],null]],null],"string-list",true]],null],[1,"\\n"]],[]]],[1,"        "],[13],[1,"\\n      "]],[]]]]],[1,"\\n"]],[2]],null],[1,"  "],[13],[1,"\\n\\n  "],[10,0],[14,0,"field is-grouped is-grouped-split is-fullwidth box is-bottomless"],[12],[1,"\\n    "],[10,0],[14,0,"field is-grouped"],[12],[1,"\\n      "],[8,[39,22],null,null,[["default"],[[[[1,"\\n        "],[8,[39,23],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[28,[37,2],[[30,0,["mode"]],"create"],null],"Create","Save"],[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n"],[41,[28,[37,24],[[28,[37,2],[[30,0,["mode"]],"merge"],null],[28,[37,2],[[30,0,["mode"]],"create"],null]],null],[[[1,"          "],[8,[39,23],null,[["@text","@color","@route"],["Cancel","secondary",[30,0,["cancelLink"]]]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,23],null,[["@text","@color","@route","@models"],["Cancel","secondary",[30,0,["cancelLink"]],[28,[37,19],[[30,0,["model","id"]],"details"],null]]],null],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],["A","attr","@model"],false,["if","and","eq","toolbar","toolbar-actions","confirm-action","action","form","perform","div","namespace-reminder","lowercase","humanize","message-error","hds/alert","each","-track-array","form-field","search-select-with-modal","array","mut","search-select","hds/button-set","hds/button","or"]]',moduleName:"vault/components/identity/edit-form.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(s,t.default.extend({flashMessages:(0,n.service)(),store:(0,n.service)(),attributeBindings:["data-test-component"],model:null,mode:"create",onSave:()=>{},cancelLink:(0,i.computed)("mode","model.identityType",(function(){const{model:e,mode:t}=this
return{"create-entity":"vault.cluster.access.identity","edit-entity":"vault.cluster.access.identity.show","merge-entity-merge":"vault.cluster.access.identity","create-entity-alias":"vault.cluster.access.identity.aliases","edit-entity-alias":"vault.cluster.access.identity.aliases.show","create-group":"vault.cluster.access.identity","edit-group":"vault.cluster.access.identity.show","create-group-alias":"vault.cluster.access.identity.aliases","edit-group-alias":"vault.cluster.access.identity.aliases.show"}[e?`${t}-${e.identityType}`:"merge-entity-alias"]})),getMessage(e,t=!1){const n=this.mode,i=(0,l.humanize)([e.identityType]),r=t?"deleted":"saved"
return"merge"===n?"Successfully merged entities":e.id?`Successfully ${r} ${i} ${e.id}.`:`Successfully ${r} ${i}.`},save:(0,r.task)((0,a.waitFor)((function*(){const e=this.model,t=this.getMessage(e)
try{yield e.save()}catch(n){return}this.flashMessages.success(t),yield this.onSave({saveType:"save",model:e})}))).drop(),willDestroy(){const e=this.store&&!this.store.isDestroying,t=this.model
e&&t&&t.isDirty&&!t.isDestroyed&&!t.isDestroying&&t.rollbackAttributes(),this._super(...arguments)},actions:{deleteItem(e){const t=this.getMessage(e,!0),n=this.flashMessages
e.destroyRecord().then((()=>(n.success(t),this.onSave({saveType:"delete",model:e}))))}}}))})),define("vault/components/identity/entity-nav",["exports","@ember/component","@ember/template-factory"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,n.createTemplateFactory)({id:"znRBeNEo",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      "],[1,[28,[35,2],[[28,[37,3],[[30,0,["identityType"]]],null]],null]],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n"],[10,0],[14,0,"tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[12],[1,"\\n  "],[10,"nav"],[14,0,"tabs"],[14,"aria-label","navigation for entities"],[12],[1,"\\n    "],[10,"ul"],[12],[1,"\\n      "],[10,"li"],[12],[1,"\\n        "],[8,[39,8],null,[["@route","@model"],["vault.cluster.access.identity.index",[28,[37,3],[[30,0,["identityType"]]],null]]],[["default"],[[[[1,"\\n          "],[1,[28,[35,9],[[28,[37,3],[[30,0,["identityType"]]],null]],null]],[1,"\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n      "],[10,"li"],[12],[1,"\\n        "],[8,[39,8],null,[["@route","@model"],["vault.cluster.access.identity.aliases.index",[28,[37,3],[[30,0,["identityType"]]],null]]],[["default"],[[[[1,"\\n          Aliases\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13],[1,"\\n"],[8,[39,10],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["model","meta","total"]],[[[1,"    "],[8,[39,12],null,null,[["default"],[[[[1,"\\n      "],[8,[39,13],null,[["@type"],[[30,0,["identityType"]]]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "],[8,[39,14],null,null,[["default"],[[[[1,"\\n"],[41,[28,[37,15],[[30,0,["identityType"]],"entity"],null],[[[1,"      "],[8,[39,16],null,[["@route","@model"],["vault.cluster.access.identity.merge",[28,[37,3],[[30,0,["identityType"]]],null]]],[["default"],[[[[1,"\\n        Merge\\n        "],[1,[28,[35,3],[[30,0,["identityType"]]],null]],[1,"\\n      "]],[]]]]],[1,"\\n"]],[]],null],[1,"    "],[8,[39,16],null,[["@route","@model","@type"],["vault.cluster.access.identity.create",[28,[37,3],[[30,0,["identityType"]]],null],"add"]],[["default"],[[[[1,"\\n      Create\\n      "],[1,[30,0,["identityType"]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]]]],["p"],false,["page-header","h1","titleize","pluralize","div","nav","ul","li","link-to","capitalize","toolbar","if","toolbar-filters","identity/lookup-input","toolbar-actions","eq","toolbar-link"]]',moduleName:"vault/components/identity/entity-nav.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,t.default.extend({}))})),define("vault/components/identity/item-alias/alias-details",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"InH+XfH/",block:'[[[1,"\\n"],[8,[39,0],null,[["@label","@value"],["Name",[30,1,["name"]]]],null],[1,"\\n"],[8,[39,0],null,[["@label","@value","@addCopyButton"],["ID",[30,1,["id"]],true]],null],[1,"\\n"],[8,[39,0],null,[["@label","@value"],[[52,[28,[37,2],[[30,1,["identityType"]],"entity-alias"],null],"Entity ID","Group ID"],[30,0,["model","canonicalId"]]]],[["default"],[[[[1,"\\n  "],[8,[39,3],null,[["@route","@models"],["vault.cluster.access.identity.show",[28,[37,4],[[52,[28,[37,2],[[30,1,["identityType"]],"entity-alias"],null],"entities","groups"],[30,1,["canonicalId"]],"details"],null]]],[["default"],[[[[1,"\\n    "],[1,[30,1,["canonicalId"]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]]],[1,"\\n"],[8,[39,0],null,[["@label","@value"],["Merged from Entity ID",[30,1,["mergedFromCanonicalIds"]]]],null],[1,"\\n"],[8,[39,0],null,[["@label","@value"],["Mount",[30,1,["mountAccessor"]]]],[["default"],[[[[1,"\\n  "],[10,0],[12],[1,"\\n    "],[1,[30,1,["mountPath"]]],[1,"\\n    "],[10,0],[12],[1,"\\n      "],[8,[39,6],[[24,0,"has-right-margin-8"]],[["@text"],[[30,1,["mountType"]]]],null],[1,"\\n      "],[10,"code"],[14,0,"has-text-grey is-size-8"],[12],[1,[30,1,["mountAccessor"]]],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]]],[1,"\\n"],[8,[39,0],null,[["@label","@value"],["Created",[30,1,["creationTime"]]]],[["default"],[[[[1,"\\n  "],[10,"time"],[15,"datetime",[30,1,["creationTime"]]],[15,"title",[30,1,["creationTime"]]],[12],[1,"\\n    "],[1,[28,[35,9],[[30,1,["creationTime"]],"MMM dd, yyyy h:mm a"],null]],[1,"\\n  "],[13],[1,"\\n"]],[]]]]],[1,"\\n"],[8,[39,0],null,[["@label","@value"],["Last Updated",[30,1,["lastUpdateTime"]]]],[["default"],[[[[1,"\\n  "],[10,"time"],[15,"datetime",[30,1,["lastUpdateTime"]]],[15,"title",[30,1,["lastUpdateTime"]]],[12],[1,"\\n    "],[1,[28,[35,9],[[30,1,["lastUpdateTime"]],"MMM dd, yyyy h:mm a"],null]],[1,"\\n  "],[13],[1,"\\n"]],[]]]]]],["@model"],false,["info-table-row","if","eq","link-to","array","div","hds/badge","code","time","date-format"]]',moduleName:"vault/components/identity/item-alias/alias-details.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/identity/item-alias/alias-metadata",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"XholHnON",block:'[[[1,"\\n"],[42,[28,[37,1],[[30,1,["metadata"]]],null],null,[[[1,"  "],[10,0],[14,0,"info-table-row is-mobile"],[12],[1,"\\n    "],[10,0],[14,0,"is-flex is-fullwidth"],[12],[1,"\\n      "],[10,0],[14,0,"column is-one-quarter"],[12],[1,"\\n        "],[10,1],[14,0,"is-label has-text-grey-dark"],[12],[1,"\\n          "],[1,[30,3]],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"column is-flex"],[12],[1,"\\n        "],[1,[30,2]],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"column has-text-right"],[12],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[2,3]],[[[1,"  "],[8,[39,4],null,[["@title"],[[29,["No metadata associated with ",[30,1,["name"]]," yet"]]]],null],[1,"\\n"]],[]]]],["@model","value","key"],false,["each","-each-in","div","span","empty-state"]]',moduleName:"vault/components/identity/item-alias/alias-metadata.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/identity/item-aliases",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"1rs+jvAP",block:'[[[1,"\\n"],[42,[28,[37,1],[[28,[37,1],[[52,[30,1,["alias","id"]],[28,[37,3],[[30,1,["alias"]]],null],[30,1,["aliases"]]]],null]],null],null,[[[1,"  "],[8,[39,4],[[24,0,"list-item-row"]],[["@params"],[[28,[37,3],["vault.cluster.access.identity.aliases.show",[30,2,["id"]],"details"],null]]],[["default"],[[[[1,"\\n    "],[10,0],[14,0,"columns is-mobile"],[12],[1,"\\n      "],[10,0],[14,0,"column is-10"],[12],[1,"\\n        "],[8,[39,6],[[24,0,"has-text-black has-text-weight-semibold"]],[["@route","@models"],["vault.cluster.access.identity.aliases.show",[28,[37,3],[[30,2,["id"]],"details"],null]]],[["default"],[[[[1,"\\n          "],[8,[39,7],[[24,0,"has-text-grey-light"]],[["@name"],["user"]],null],[1,"\\n          "],[10,1],[14,0,"has-text-weight-semibold"],[12],[1,[30,2,["name"]]],[13],[1,"\\n        "]],[]]]]],[1,"\\n        "],[10,0],[14,0,"has-text-grey"],[12],[1,"\\n          "],[1,[30,2,["id"]]],[1,"\\n        "],[13],[1,"\\n        "],[8,[39,9],null,[["@text"],[[30,2,["mountType"]]]],null],[1,"\\n        "],[10,1],[14,0,"has-text-grey is-size-8"],[12],[1,"\\n          "],[1,[30,2,["mountAccessor"]]],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"column has-text-right"],[12],[1,"\\n        "],[8,[39,10],null,[["@item"],[[30,2]]],null],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[2]],[[[1,"  "],[8,[39,11],null,[["@title"],[[29,["No ",[30,1,["identityType"]]," aliases for ",[30,1,["name"]]," yet"]]]],null],[1,"\\n"]],[]]]],["@model","item"],false,["each","-track-array","if","array","linked-block","div","link-to","icon","span","hds/badge","identity/popup-alias","empty-state"]]',moduleName:"vault/components/identity/item-aliases.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/identity/item-details",["exports","@ember/component","@ember/service","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"DRMYo7UP",block:'[[[1,"\\n"],[10,0],[14,0,"box is-shadowless is-marginless is-fullwidth"],[12],[1,"\\n"],[41,[30,1,["disabled"]],[[[1,"    "],[8,[39,2],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n      "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,"Attention"]],[]]]]],[1,"\\n      "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,"\\n        This\\n        "],[1,[30,1,["identityType"]]],[1,"\\n        is disabled. All associated tokens cannot be used, but are not revoked.\\n      "]],[]]]]],[1,"\\n"],[41,[30,1,["canEdit"]],[[[1,"        "],[8,[30,2,["Button"]],[[4,[38,3],["click",[28,[37,4],[[30,0],"enable",[30,1]],null]],null]],[["@text","@color"],["Enable","secondary"]],null],[1,"\\n"]],[]],null],[1,"    "]],[2]]]]],[1,"\\n"]],[]],null],[1,"  "],[8,[39,5],null,[["@label","@value"],["Name",[30,1,["name"]]]],null],[1,"\\n  "],[8,[39,5],null,[["@label","@value"],["Type",[30,1,["type"]]]],null],[1,"\\n  "],[8,[39,5],null,[["@label","@value","@addCopyButton"],["ID",[30,1,["id"]],true]],null],[1,"\\n  "],[8,[39,5],null,[["@label","@value"],["Merged Ids",[30,1,["mergedEntityIds"]]]],[["default"],[[[[1,"\\n    "],[10,0],[12],[1,"\\n"],[42,[28,[37,7],[[28,[37,7],[[30,1,["mergedEntityIds"]]],null]],null],null,[[[1,"        "],[10,0],[12],[1,"\\n          "],[10,"code"],[14,0,"has-text-black"],[12],[1,[30,3]],[13],[1,"\\n        "],[13],[1,"\\n"]],[3]],null],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[39,5],null,[["@label","@value"],["Created",[30,1,["creationTime"]]]],[["default"],[[[[1,"\\n    "],[10,"time"],[15,"datetime",[30,1,["creationTime"]]],[15,"title",[30,1,["creationTime"]]],[12],[1,"\\n      "],[1,[28,[35,10],[[30,1,["creationTime"]],"MMM dd, yyyy h:mm a"],null]],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[39,5],null,[["@label","@value"],["Last Updated",[30,0,["model","lastUpdateTime"]]]],[["default"],[[[[1,"\\n    "],[10,"time"],[15,"datetime",[30,0,["model","lastUpdateTime"]]],[15,"title",[30,0,["model","lastUpdateTime"]]],[12],[1,"\\n      "],[1,[28,[35,10],[[30,0,["model","lastUpdateTime"]],"MMM dd, yyyy h:mm a"],null]],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"],[13]],["@model","A","id"],false,["div","if","hds/alert","on","action","info-table-row","each","-track-array","code","time","date-format"]]',moduleName:"vault/components/identity/item-details.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,t.default.extend({flashMessages:(0,n.service)(),actions:{enable(e){e.set("disabled",!1),e.save().then((()=>{this.flashMessages.success(`Successfully enabled entity: ${e.id}`)})).catch((t=>{this.flashMessages.success(`There was a problem enabling the entity: ${e.id} - ${t.errors.join(" ")||t.message}`)}))}}}))})),define("vault/components/identity/item-groups",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"BwG6SmUA",block:'[[[1,"\\n"],[41,[30,1,["groupIds"]],[[[42,[28,[37,2],[[28,[37,2],[[30,1,["directGroupIds"]]],null]],null],null,[[[1,"    "],[8,[39,3],[[24,0,"list-item-row"]],[["@route","@models"],["vault.cluster.access.identity.show",[28,[37,4],["groups",[30,2],"details"],null]]],[["default"],[[[[1,"\\n      "],[8,[39,5],[[24,0,"has-text-grey-light"]],[["@name"],["folder"]],null],[1,[30,2]],[1,"\\n    "]],[]]]]],[1,"\\n"]],[2]],null],[42,[28,[37,2],[[28,[37,2],[[30,1,["inheritedGroupIds"]]],null]],null],null,[[[1,"    "],[8,[39,6],[[24,0,"list-item-row"]],[["@params"],[[28,[37,4],["vault.cluster.access.identity.show","groups",[30,3],"details"],null]]],[["default"],[[[[1,"\\n      "],[8,[39,3],[[24,0,"has-text-black"]],[["@route","@models"],["vault.cluster.access.identity.show",[28,[37,4],["groups",[30,3],"details"],null]]],[["default"],[[[[1,"\\n        "],[8,[39,5],[[24,0,"has-text-grey-light"]],[["@name"],["folder"]],null],[1,[30,3]],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[39,7],null,[["@text"],["inherited"]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[3]],null]],[]],[[[1,"  "],[8,[39,8],null,[["@title"],[[29,[[30,1,["name"]]," is not a member of any groups."]]]],null],[1,"\\n"]],[]]]],["@model","gid","gid"],false,["if","each","-track-array","link-to","array","icon","linked-block","hds/badge","empty-state"]]',moduleName:"vault/components/identity/item-groups.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/identity/item-members",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"mufdDJ+D",block:'[[[1,"\\n"],[41,[30,1,["hasMembers"]],[[[42,[28,[37,2],[[28,[37,2],[[30,1,["memberGroupIds"]]],null]],null],null,[[[1,"    "],[8,[39,3],[[24,0,"list-item-row"]],[["@params"],[[28,[37,4],["vault.cluster.access.identity.show","groups",[30,2],[30,0,["details"]]],null]]],[["default"],[[[[1,"\\n      "],[10,0],[14,0,"columns is-mobile"],[12],[1,"\\n        "],[10,0],[14,0,"column is-10"],[12],[1,"\\n          "],[8,[39,6],[[24,0,"is-block has-text-black has-text-weight-semibold"]],[["@route","@models"],["vault.cluster.access.identity.show",[28,[37,4],["groups",[30,2],"details"],null]]],[["default"],[[[[1,"\\n            "],[8,[39,7],[[24,0,"has-text-grey-light"]],[["@name"],["folder"]],null],[1,[30,2]],[1,"\\n          "]],[]]]]],[1,"\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"column has-text-right"],[12],[1,"\\n"],[41,[30,1,["canEdit"]],[[[1,"            "],[8,[39,8],null,[["@model","@groupArray","@memberId"],[[30,1],"memberGroupIds",[30,2]]],null],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n"]],[2]],null],[42,[28,[37,2],[[28,[37,2],[[30,1,["memberEntityIds"]]],null]],null],null,[[[1,"    "],[8,[39,3],[[24,0,"list-item-row"]],[["@params"],[[28,[37,4],["vault.cluster.access.identity.show","groups",[30,3],[30,0,["details"]]],null]]],[["default"],[[[[1,"\\n      "],[10,0],[14,0,"columns"],[12],[1,"\\n        "],[10,0],[14,0,"column is-10"],[12],[1,"\\n          "],[8,[39,6],[[24,0,"is-block has-text-black has-text-weight-semibold"]],[["@route","@models"],["vault.cluster.access.identity.show",[28,[37,4],["entities",[30,3],"details"],null]]],[["default"],[[[[1,"\\n            "],[8,[39,7],[[24,0,"has-text-grey-light"]],[["@name"],["user"]],null],[1,[30,3]],[1,"\\n          "]],[]]]]],[1,"\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"column has-text-right"],[12],[1,"\\n"],[41,[30,1,["canEdit"]],[[[1,"            "],[8,[39,8],null,[["@model","@groupArray","@memberId"],[[30,1],"memberEntityIds",[30,3]]],null],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n"]],[3]],null]],[]],[[[1,"  "],[8,[39,9],null,[["@title"],["No members in this group yet"]],null],[1,"\\n"]],[]]]],["@model","gid","gid"],false,["if","each","-track-array","linked-block","array","div","link-to","icon","identity/popup-members","empty-state"]]',moduleName:"vault/components/identity/item-members.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/identity/item-metadata",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"bsvQ+32S",block:'[[[1,"\\n"],[42,[28,[37,1],[[30,1,["metadata"]]],null],null,[[[1,"  "],[10,0],[14,0,"info-table-row is-mobile"],[12],[1,"\\n    "],[10,0],[14,0,"is-flex is-fullwidth"],[12],[1,"\\n      "],[10,0],[14,0,"column is-one-quarter"],[12],[1,"\\n        "],[10,1],[14,0,"is-label has-text-grey-dark"],[12],[1,"\\n          "],[1,[30,3]],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"column is-5"],[12],[1,"\\n        "],[1,[30,2]],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"column has-text-right"],[12],[1,"\\n"],[41,[30,1,["canEdit"]],[[[1,"          "],[8,[39,5],null,[["@key","@model"],[[30,3],[30,1]]],null],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[2,3]],[[[1,"  "],[8,[39,6],null,[["@title","@message"],[[29,["No metadata for ",[30,1,["name"]]]],[29,["You can store custom data that you want to associate with this ",[28,[37,7],[[28,[37,8],[[30,1,["identityType"]]],null]],null],". Click \\"Edit ",[28,[37,7],[[28,[37,8],[[30,1,["identityType"]]],null]],null],"\\" to get started."]]]],[["default"],[[[[1,"\\n    "],[8,[39,9],null,[["@text","@href","@icon","@iconPosition"],["Identity: entities and groups tutorial",[28,[37,10],["/vault/tutorials/auth-methods/identity"],null],"learn-link","trailing"]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]],["@model","value","key"],false,["each","-each-in","div","span","if","identity/popup-metadata","empty-state","lowercase","humanize","hds/link/standalone","doc-link"]]',moduleName:"vault/components/identity/item-metadata.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/identity/item-parent-groups",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"WMz+wQP8",block:'[[[1,"\\n"],[41,[30,1,["parentGroupIds","length"]],[[[42,[28,[37,2],[[28,[37,2],[[30,1,["parentGroupIds"]]],null]],null],null,[[[1,"    "],[8,[39,3],[[24,0,"list-item-row"]],[["@params"],[[28,[37,4],["vault.cluster.access.identity.show","groups",[30,2],[30,0,["details"]]],null]]],[["default"],[[[[1,"\\n      "],[10,0],[14,0,"columns is-mobile"],[12],[1,"\\n        "],[10,0],[14,0,"column is-10"],[12],[1,"\\n          "],[8,[39,6],[[24,0,"is-block has-text-black has-text-weight-semibold"]],[["@route","@models"],["vault.cluster.access.identity.show",[28,[37,4],["groups",[30,2],"details"],null]]],[["default"],[[[[1,"\\n            "],[8,[39,7],[[24,0,"has-text-grey-light"]],[["@name"],["folder"]],null],[1,[30,2]],[1,"\\n          "]],[]]]]],[1,"\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"column has-text-right"],[12],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n"]],[2]],null]],[]],[[[1,"  "],[8,[39,8],null,[["@title"],["This group has no parent groups yet"]],null],[1,"\\n"]],[]]]],["@model","gid"],false,["if","each","-track-array","linked-block","array","div","link-to","icon","empty-state"]]',moduleName:"vault/components/identity/item-parent-groups.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/identity/item-policies",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"OOdsmBDR",block:'[[[1,"\\n"],[42,[28,[37,1],[[28,[37,1],[[30,1,["policies"]]],null]],null],null,[[[1,"  "],[8,[39,2],[[24,0,"list-item-row"]],[["@params"],[[28,[37,3],["vault.cluster.policy.show","acl",[30,2]],null]]],[["default"],[[[[1,"\\n    "],[10,0],[14,0,"columns is-mobile"],[12],[1,"\\n      "],[10,0],[14,0,"column is-10"],[12],[1,"\\n        "],[8,[39,5],[[24,0,"is-block has-text-black has-text-weight-semibold"]],[["@route","@models"],["vault.cluster.policy.show",[28,[37,3],["acl",[30,2]],null]]],[["default"],[[[[1,"\\n          "],[10,1],[14,0,"is-underline"],[12],[1,[30,2]],[13],[1,"\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"column has-text-right"],[12],[1,"\\n"],[41,[30,1,["canEdit"]],[[[1,"          "],[8,[39,8],null,[["@model","@policyName"],[[30,1],[30,2]]],null],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[2]],[[[1,"  "],[8,[39,9],null,[["@title"],[[29,["No policies associated with ",[30,1,["name"]]," yet"]]]],null],[1,"\\n"]],[]]]],["@model","policyName"],false,["each","-track-array","linked-block","array","div","link-to","span","if","identity/popup-policy","empty-state"]]',moduleName:"vault/components/identity/item-policies.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/identity/lookup-input",["exports","@ember/component","@ember/service","ember-concurrency","vault/helpers/underscore","vault/resources/auth/method","@ember/template-factory"],(function(e,t,n,i,r,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,a.createTemplateFactory)({id:"Ede5Wqq6",block:'[[[1,"\\n"],[11,"form"],[4,[38,1],[[30,0],[28,[37,2],[[30,0,["lookup"]]],null]],[["on"],["submit"]]],[12],[1,"\\n  "],[10,0],[14,0,"field is-flex"],[12],[1,"\\n    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[10,0],[14,0,"select is-fullwidth"],[12],[1,"\\n        "],[10,"select"],[14,3,"param"],[14,1,"param"],[15,"onchange",[28,[37,1],[[30,0],[28,[37,5],[[30,0,["param"]]],null]],[["value"],["target.value"]]]],[14,"aria-label","lookup by alias name"],[12],[1,"\\n"],[42,[28,[37,7],[[28,[37,7],[[28,[37,8],["alias name","name","id","alias id"],null]],null]],null],null,[[[1,"            "],[10,"option"],[15,"selected",[28,[37,10],[[30,0,["param"]],[30,1]],null]],[15,2,[30,1]],[12],[1,"\\n              Lookup by\\n              "],[1,[30,1]],[1,"\\n            "],[13],[1,"\\n"]],[1]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"control"],[12],[1,"\\n"],[41,[28,[37,10],[[30,0,["param"]],"alias name"],null],[[[1,"        "],[8,[39,12],null,[["@value","@onChange"],[[30,0,["aliasMountAccessor"]],[28,[37,1],[[30,0],[28,[37,5],[[30,0,["aliasMountAccessor"]]],null]],null]]],null],[1,"\\n"]],[]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"control is-expanded"],[12],[1,"\\n      "],[8,[39,13],[[24,0,"input"],[16,"placeholder",[28,[37,14],[[30,0,["param"]]],null]]],[["@value"],[[30,0,["paramValue"]]]],null],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[8,[39,15],[[24,0,"is-hidden"],[24,4,"submit"]],[["@text","@color"],["Lookup","secondary"]],null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],["paramOption"],false,["form","action","perform","div","select","mut","each","-track-array","array","option","eq","if","mount-accessor-select","input","capitalize","hds/button"]]',moduleName:"vault/components/identity/lookup-input.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(o,t.default.extend({store:(0,n.service)(),flashMessages:(0,n.service)(),router:(0,n.service)(),api:(0,n.service)(),type:"entity",param:"alias name",paramValue:null,aliasMountAccessor:null,authMethods:null,init(){this._super(...arguments),this.api.sys.authListEnabledMethods().then((({data:e})=>{const t=this.api.responseObjectToArray(e,"path").map((e=>new l.default(e,this)))
this.set("authMethods",t),this.set("aliasMountAccessor",t[0].accessor)}))},adapter(){const e=this.type
return this.store.adapterFor(`identity/${e}`)},data(){const{param:e,paramValue:t,aliasMountAccessor:n}=this,i={}
return i[(0,r.underscore)([e])]=t,"alias name"===e&&(i.alias_mount_accessor=n),i},lookup:(0,i.task)((function*(){const e=this.flashMessages,t=this.type,n=this.store,{param:i,paramValue:r}=this
let l
try{l=yield this.adapter().lookup(n,this.data())}catch(a){return void e.danger(`We encountered an error attempting the ${t} lookup: ${a.message||a.errors.join("")}.`)}if(l)return this.router.transitionTo("vault.cluster.access.identity.show",l.id,"details")
e.danger(`We were unable to find an identity ${t} with a "${i}" of "${r}".`)}))}))})),define("vault/components/identity/popup-alias",["exports","@ember/component","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,o.createTemplateFactory)({id:"sj+igoGd",block:'[[[1,"\\n"],[10,0],[14,0,"has-text-right"],[12],[1,"\\n  "],[8,[39,1],null,[["@isInline","@listPosition"],[true,"bottom-right"]],[["default"],[[[[1,"\\n    "],[8,[30,1,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal","Alias management options",false]],null],[1,"\\n    "],[8,[30,1,["Interactive"]],null,[["@route","@models"],["vault.cluster.access.identity.aliases.show",[28,[37,2],[[28,[37,3],[[30,2,["parentType"]]],null],[30,2,["id"]],"details"],null]]],[["default"],[[[[1,"Details"]],[]]]]],[1,"\\n"],[41,[30,2,["updatePath","isPending"]],[[[1,"      "],[8,[30,1,["Generic"]],[[24,0,"has-text-center"]],null,[["default"],[[[[1,"\\n        "],[8,[39,5],null,null,null],[1,"\\n      "]],[]]]]],[1,"\\n"]],[]],[[[41,[30,2,["canEdit"]],[[[1,"        "],[8,[30,1,["Interactive"]],null,[["@route","@models"],["vault.cluster.access.identity.aliases.edit",[28,[37,2],[[28,[37,3],[[30,2,["parentType"]]],null],[30,2,["id"]]],null]]],[["default"],[[[[1,"Edit"]],[]]]]],[1,"\\n"]],[]],null],[41,[30,2,["canDelete"]],[[[1,"        "],[8,[30,1,["Interactive"]],[[4,[38,6],["click",[28,[37,7],[[28,[37,8],[[30,0,["showConfirmModal"]]],null],true],null]],null]],[["@color"],["critical"]],[["default"],[[[[1,"Remove"]],[]]]]],[1,"\\n"]],[]],null]],[]]],[1,"  "]],[1]]]]],[1,"\\n"],[13],[1,"\\n\\n"],[41,[30,0,["showConfirmModal"]],[[[1,"  "],[8,[39,9],null,[["@color","@onClose","@onConfirm"],["critical",[28,[37,7],[[28,[37,8],[[30,0,["showConfirmModal"]]],null],false],null],[30,0,["deleteAlias"]]]],null],[1,"\\n"]],[]],null]],["dd","@item"],false,["div","hds/dropdown","array","pluralize","if","loading-dropdown-option","on","fn","mut","confirm-modal"]]',moduleName:"vault/components/identity/popup-alias.hbs",isStrictMode:!1})
let m=e.default=(s=class extends n.default{constructor(...e){super(...e),d(this,"flashMessages",u,this),d(this,"showConfirmModal",c,this)}onSuccess(e,t){this.args.onSuccess&&this.args.onSuccess(),this.flashMessages.success(`Successfully deleted ${e}: ${t}`)}onError(e,t,n){this.args.onError&&this.args.onError()
const i=(0,a.default)(e)
this.flashMessages.danger(`There was a problem deleting ${t}: ${n} - ${i}`)}async deleteAlias(){const{identityType:e,id:t}=this.args.item
try{await this.args.item.destroyRecord(),this.onSuccess(e,t)}catch(n){this.onError(n,e,t)}}},u=p(s.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(s.prototype,"showConfirmModal",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),p(s.prototype,"deleteAlias",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"deleteAlias"),s.prototype),s);(0,t.setComponentTemplate)(f,m)})),define("vault/components/identity/popup-members",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,o.createTemplateFactory)({id:"azo79oUj",block:'[[[1,"\\n"],[10,0],[14,0,"has-text-right"],[12],[1,"\\n  "],[8,[39,1],null,[["@isInline","@listPosition"],[true,"bottom-right"]],[["default"],[[[[1,"\\n    "],[8,[30,1,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal","Identity member options",false]],null],[1,"\\n    "],[8,[30,1,["Interactive"]],[[4,[38,2],["click",[28,[37,3],[[28,[37,4],[[30,0,["showConfirmModal"]]],null],true],null]],null]],[["@color"],["critical"]],[["default"],[[[[1,"Remove"]],[]]]]],[1,"\\n  "]],[1]]]]],[1,"\\n"],[13],[1,"\\n\\n"],[41,[30,0,["showConfirmModal"]],[[[1,"  "],[8,[39,6],null,[["@color","@onClose","@onConfirm","@confirmTitle","@confirmMessage"],["critical",[28,[37,3],[[28,[37,4],[[30,0,["showConfirmModal"]]],null],false],null],[30,0,["removeGroup"]],"Remove this group?","This may affect permissions for this group."]],null],[1,"\\n"]],[]],null]],["dd"],false,["div","hds/dropdown","on","fn","mut","if","confirm-modal"]]',moduleName:"vault/components/identity/popup-members.hbs",isStrictMode:!1})
let m=e.default=(s=class extends n.default{constructor(...e){super(...e),d(this,"flashMessages",u,this),d(this,"showConfirmModal",c,this)}onSuccess(e){this.args.onSuccess&&this.args.onSuccess(),this.flashMessages.success(`Successfully removed '${e}' from the group`)}onError(e,t){this.args.onError&&this.args.onError()
const n=(0,a.default)(e)
this.flashMessages.danger(`There was a problem removing '${t}' from the group - ${n}`)}transaction(){const e=this.args.model[this.args.groupArray]
return this.args.model[this.args.groupArray]=e.without(this.args.memberId),this.args.model.save()}async removeGroup(){const e=this.args.memberId
try{await this.transaction(),this.onSuccess(e)}catch(t){this.onError(t,e)}}},u=p(s.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(s.prototype,"showConfirmModal",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),p(s.prototype,"removeGroup",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"removeGroup"),s.prototype),s);(0,t.setComponentTemplate)(f,m)})),define("vault/components/identity/popup-metadata",["exports","@ember/component","@ember/object","@ember/service","@glimmer/component","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,o.createTemplateFactory)({id:"lZqpEOkQ",block:'[[[1,"\\n"],[10,0],[14,0,"has-text-right"],[12],[1,"\\n  "],[8,[39,1],null,[["@isInline","@listPosition"],[true,"bottom-right"]],[["default"],[[[[1,"\\n    "],[8,[30,1,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal","Metadata options",false]],null],[1,"\\n    "],[8,[30,1,["Interactive"]],[[4,[38,2],["click",[28,[37,3],[[28,[37,4],[[30,0,["showConfirmModal"]]],null],true],null]],null]],[["@color"],["critical"]],[["default"],[[[[1,"Remove"]],[]]]]],[1,"\\n  "]],[1]]]]],[1,"\\n"],[13],[1,"\\n\\n"],[41,[30,0,["showConfirmModal"]],[[[1,"  "],[8,[39,6],null,[["@color","@onClose","@onConfirm","@confirmTitle","@confirmMessage"],["critical",[28,[37,3],[[28,[37,4],[[30,0,["showConfirmModal"]]],null],false],null],[30,0,["removeMetadata"]],"Remove metadata?","This data may be used outside of Vault."]],null],[1,"\\n"]],[]],null]],["dd"],false,["div","hds/dropdown","on","fn","mut","if","confirm-modal"]]',moduleName:"vault/components/identity/popup-metadata.hbs",isStrictMode:!1})
let m=e.default=(s=class extends r.default{constructor(...e){super(...e),d(this,"flashMessages",u,this),d(this,"showConfirmModal",c,this)}onSuccess(e){this.args.onSuccess&&this.args.onSuccess(),this.flashMessages.success(`Successfully removed '${e}' from metadata`)}onError(e,t){this.args.onError&&this.args.onError()
const n=(0,a.default)(e)
this.flashMessages.danger(`There was a problem removing '${t}' from the metadata - ${n}`)}transaction(){const e=this.args.model.metadata
return delete e[this.args.key],this.args.model.metadata={...e},this.args.model.save()}async removeMetadata(){const e=this.args.key
try{await this.transaction(),this.onSuccess(e)}catch(t){this.onError(t,e)}}},u=p(s.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(s.prototype,"showConfirmModal",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),p(s.prototype,"removeMetadata",[n.action],Object.getOwnPropertyDescriptor(s.prototype,"removeMetadata"),s.prototype),s);(0,t.setComponentTemplate)(f,m)})),define("vault/components/identity/popup-policy",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","vault/utils/error-message","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,o.createTemplateFactory)({id:"9WEc0HaV",block:'[[[1,"\\n"],[10,0],[14,0,"has-text-right"],[12],[1,"\\n  "],[8,[39,1],null,[["@isInline","@listPosition"],[true,"bottom-right"]],[["default"],[[[[1,"\\n    "],[8,[30,1,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal","Identity policy management options",false]],null],[1,"\\n    "],[8,[30,1,["Interactive"]],null,[["@route","@models"],["vault.cluster.policy.show",[28,[37,2],["acl",[30,2]],null]]],[["default"],[[[[1,"View policy"]],[]]]]],[1,"\\n    "],[8,[30,1,["Interactive"]],null,[["@route","@models"],["vault.cluster.policy.edit",[28,[37,2],["acl",[30,2]],null]]],[["default"],[[[[1,"Edit policy"]],[]]]]],[1,"\\n    "],[8,[30,1,["Interactive"]],[[4,[38,3],["click",[28,[37,4],[[28,[37,5],[[30,0,["showConfirmModal"]]],null],true],null]],null]],[["@color"],["critical"]],[["default"],[[[[1,"\\n      Remove from\\n      "],[1,[30,3,["identityType"]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[1]]]]],[1,"\\n"],[13],[1,"\\n\\n"],[41,[30,0,["showConfirmModal"]],[[[1,"  "],[8,[39,7],null,[["@color","@onClose","@onConfirm","@confirmTitle","@confirmMessage"],["critical",[28,[37,4],[[28,[37,5],[[30,0,["showConfirmModal"]]],null],false],null],[30,0,["removePolicy"]],"Remove this policy?","This policy may affect permissions to access Vault data."]],null],[1,"\\n"]],[]],null]],["dd","@policyName","@model"],false,["div","hds/dropdown","array","on","fn","mut","if","confirm-modal"]]',moduleName:"vault/components/identity/popup-policy.hbs",isStrictMode:!1})
let m=e.default=(s=class extends n.default{constructor(...e){super(...e),d(this,"flashMessages",u,this),d(this,"showConfirmModal",c,this)}onSuccess(e,t){this.args.onSuccess&&this.args.onSuccess(),this.flashMessages.success(`Successfully removed '${e}' policy from ${t}`)}onError(e,t){this.args.onError&&this.args.onError()
const n=(0,l.default)(e)
this.flashMessages.danger(`There was a problem removing '${t}' policy - ${n}`)}transaction(){const e=this.args.model.policies
return this.args.model.policies=e.without(this.args.policyName),this.args.model.save()}async removePolicy(){const{policyName:e,model:{id:t}}=this.args
try{await this.transaction(),this.onSuccess(e,t)}catch(n){this.onError(n,e)}}},u=p(s.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(s.prototype,"showConfirmModal",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),p(s.prototype,"removePolicy",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"removePolicy"),s.prototype),s);(0,t.setComponentTemplate)(f,m)})),define("vault/components/info-table-item-array",["exports","core/components/info-table-item-array"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/info-table-row",["exports","core/components/info-table-row"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/info-tooltip",["exports","core/components/info-tooltip"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/input-search",["exports","core/components/input-search"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/json-editor",["exports","core/components/json-editor"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/key-value-header",["exports","core/components/key-value-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/key-version-select",["exports","@ember/component","@ember/template-factory"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,n.createTemplateFactory)({id:"JsTH6ec4",block:'[[[1,"\\n"],[41,[28,[37,1],[[30,0,["key","keysForEncryption","length"]],1],null],[[[1,"  "],[10,0],[14,0,"field"],[12],[1,"\\n    "],[10,"label"],[14,"for","key_version"],[14,0,"is-label"],[12],[1,"Key version"],[13],[1,"\\n    "],[10,0],[14,0,"control is-expanded"],[12],[1,"\\n      "],[10,0],[14,0,"select is-fullwidth"],[12],[1,"\\n        "],[10,"select"],[14,3,"key_version"],[14,1,"key_version"],[15,"onchange",[28,[37,5],[[30,0],[30,0,["onVersionChange"]]],[["value"],["target.value"]]]],[12],[1,"\\n"],[42,[28,[37,7],[[28,[37,7],[[30,0,["key","keysForEncryption"]]],null]],null],null,[[[41,[28,[37,8],[[30,1],[30,0,["key","latestVersion"]]],null],[[[1,"              "],[10,"option"],[15,"selected",[52,[30,0,["key_version"]],[28,[37,8],[[30,1],[30,0,["key_version"]]],null],[28,[37,8],[[30,1],[30,0,["key","latestVersion"]]],null]]],[15,2,0],[12],[1,"\\n                "],[1,[30,1]],[1,"\\n                (latest)\\n              "],[13],[1,"\\n"]],[]],[[[1,"              "],[10,"option"],[15,"selected",[52,[30,0,["key_version"]],[28,[37,8],[[30,1],[30,0,["key_version"]]],null],[28,[37,8],[[30,1],[30,0,["key","latestVersion"]]],null]]],[15,2,[30,1]],[12],[1,"\\n                "],[1,[30,1]],[1,"\\n              "],[13],[1,"\\n"]],[]]]],[1]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],null]],["version"],false,["if","gt","div","label","select","action","each","-track-array","eq","option"]]',moduleName:"vault/components/key-version-select.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,t.default.extend({tagName:""}))})),define("vault/components/keymgmt/distribute",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","vault/models/keymgmt/key","ember-concurrency","@ember/test-waiters","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f,m,h,b,y,g,v,w,k,x,P,_
function T(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function O(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const j=(0,u.createTemplateFactory)({id:"HoMyXgnw",block:'[[[1,"\\n"],[41,[30,1],[[[41,[30,0,["formErrors"]],[[[1,"    "],[8,[39,1],null,[["@type","@color"],["inline","critical"]],[["default"],[[[[1,"\\n      "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,"Error"]],[]]]]],[1,"\\n      "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,[30,0,["formErrors"]]]],[]]]]],[1,"\\n    "]],[2]]]]],[1,"\\n"]],[]],null],[1,"  "],[11,"form"],[24,0,"form-section"],[4,[38,3],["submit",[28,[37,4],[[30,0,["createDistribution"]]],null]],null],[12],[1,"\\n"],[41,[51,[30,3]],[[[1,"      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[8,[39,7],null,[["@id","@models","@onChange","@passObject","@inputValue","@subText","@wildcardLabel","@label","@fallbackComponent","@selectLimit","@backend","@disallowNewItems"],["key",[28,[37,8],["keymgmt/key"],null],[30,0,["handleKeySelect"]],true,[30,0,["formData","key"]],"Type to use the name of an existing key that you’d like to add to this provider, or to create one.","key","Key name","string-list","1",[30,1],false]],[["default"],[[[[1,"\\n"],[41,[28,[37,9],[[30,0,["validMatchError","key"]],[28,[37,10],[[30,0,["isNewKey"]]],null]],null],[[[1,"            "],[8,[39,1],[[24,0,"has-top-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n              "],[8,[30,4,["Description"]],null,null,[["default"],[[[[1,"\\n                "],[1,[30,0,["validMatchError","key"]]],[1,"\\n                To check compatibility,\\n                "],[8,[39,11],null,[["@icon","@iconPosition","@isHrefExternal","@href"],["docs-link","trailing",true,[28,[37,12],["/vault/docs/secrets/key-management#compatibility"],null]]],[["default"],[[[[1,"\\n                  refer to this table\\n                "]],[]]]]],[1,".\\n              "]],[]]]]],[1,"\\n            "]],[4]]]]],[1,"\\n"]],[]],null],[1,"        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,0,["isNewKey"]],[[[1,"      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[10,"label"],[14,0,"is-label"],[14,"for","keyType"],[12],[1,"Key Type"],[13],[1,"\\n        "],[10,2],[14,0,"sub-text"],[12],[1,"The type of cryptographic key that will be created."],[13],[1,"\\n        "],[10,0],[14,0,"control is-expanded"],[12],[1,"\\n          "],[10,0],[14,0,"select is-fullwidth"],[12],[1,"\\n            "],[11,"select"],[24,3,"keyType"],[24,1,"keyType"],[16,0,[52,[30,0,["validMatchError","key"]],"has-error-border"]],[4,[38,3],["change",[30,0,["handleKeyType"]]],null],[12],[1,"\\n              "],[10,"option"],[14,2,""],[12],[1,"\\n                Select one\\n              "],[13],[1,"\\n"],[42,[28,[37,18],[[28,[37,18],[[30,0,["keyTypes"]]],null]],null],null,[[[1,"                "],[10,"option"],[15,"selected",[28,[37,19],[[30,0,["keyType"]],[30,5]],null]],[15,2,[30,5]],[12],[1,"\\n                  "],[1,[30,5]],[1,"\\n                "],[13],[1,"\\n"]],[5]],null],[1,"            "],[13],[1,"\\n          "],[13],[1,"\\n"],[41,[30,0,["validMatchError","key"]],[[[1,"            "],[8,[39,1],[[24,0,"has-top-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n              "],[8,[30,6,["Description"]],null,null,[["default"],[[[[1,"\\n                "],[1,[30,0,["validMatchError","key"]]],[1,"\\n                To check compatibility,\\n                "],[8,[39,11],null,[["@icon","@iconPosition","@isHrefExternal","@href"],["docs-link","trailing",true,[28,[37,12],["/vault/docs/secrets/key-management#compatibility"],null]]],[["default"],[[[[1,"\\n                  refer to this table\\n                "]],[]]]]],[1,".\\n              "]],[]]]]],[1,"\\n            "]],[6]]]]],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[41,[51,[30,7]],[[[1,"      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[8,[39,7],null,[["@id","@models","@onChange","@passObject","@inputValue","@subText","@label","@fallbackComponent","@selectLimit","@backend","@disallowNewItems"],["provider",[28,[37,8],["keymgmt/provider"],null],[30,0,["handleProvider"]],false,[30,0,["formData","provider"]],"Select a provider in Vault. If it doesn’t exist yet, you’ll need to add it first.","Provider","input-search","1",[30,1],true]],[["default"],[[[[1,"\\n"],[41,[30,0,["validMatchError","provider"]],[[[1,"            "],[8,[39,1],[[24,0,"has-top-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n              "],[8,[30,8,["Description"]],null,null,[["default"],[[[[1,"\\n                "],[1,[30,0,["validMatchError","provider"]]],[1,"\\n                To check compatibility,\\n                "],[8,[39,11],null,[["@icon","@iconPosition","@isHrefExternal","@href"],["docs-link","trailing",true,[28,[37,12],["/vault/docs/secrets/key-management#compatibility"],null]]],[["default"],[[[[1,"\\n                  refer to this table\\n                "]],[]]]]],[1,".\\n              "]],[]]]]],[1,"\\n            "]],[8]]]]],[1,"\\n"]],[]],null],[1,"        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"\\n    "],[10,"fieldset"],[14,0,"field form-fieldset"],[14,1,"operations"],[15,"disabled",[30,0,["disableOperations"]]],[12],[1,"\\n      "],[10,"legend"],[14,0,"is-label"],[12],[1,"Operations"],[13],[1,"\\n      "],[10,2],[14,0,"sub-text"],[12],[1,"The types of operations this key can perform in the provider."],[13],[1,"\\n"],[42,[28,[37,18],[[28,[37,18],[[30,0,["operations"]]],null]],null],null,[[[1,"        "],[10,0],[14,0,"b-checkbox"],[12],[1,"\\n          "],[8,[39,22],[[16,1,[30,9]],[24,0,"styled"],[4,[38,3],["input",[30,0,["handleOperation"]]],null]],[["@type","@checked"],["checkbox",false]],null],[1,"\\n          "],[10,"label"],[15,"for",[30,9]],[12],[1,[28,[35,23],[[30,9]],null]],[13],[1,"\\n        "],[13],[1,"\\n"]],[9]],null],[1,"    "],[13],[1,"\\n\\n    "],[10,"fieldset"],[14,0,"field form-fieldset"],[14,1,"protection"],[12],[1,"\\n      "],[10,"legend"],[14,0,"is-label"],[12],[1,"Protection"],[13],[1,"\\n      "],[10,2],[14,0,"sub-text"],[12],[1,"Specifies the protection of the key."],[13],[1,"\\n      "],[10,0],[12],[1,"\\n        "],[8,[39,24],[[24,1,"protection-hsm"],[24,3,"hsm"],[24,0,"radio"]],[["@value","@groupValue","@onChange"],["hsm",[30,0,["formData","protection"]],[28,[37,25],[[28,[37,26],[[30,0,["formData","protection"]]],null]],null]]],null],[1,"\\n        "],[10,"label"],[14,"for","protection-hsm"],[12],[1,"HSM"],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[12],[1,"\\n        "],[8,[39,24],[[24,1,"protection-software"],[24,3,"software"],[24,0,"radio"]],[["@value","@groupValue","@onChange"],["software",[30,0,["formData","protection"]],[28,[37,25],[[28,[37,26],[[30,0,["formData","protection"]]],null]],null]]],null],[1,"\\n        "],[10,"label"],[14,"for","protection-software"],[12],[1,"Software"],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n\\n    "],[10,"hr"],[14,0,"has-background-gray-100"],[12],[13],[1,"\\n    "],[8,[39,28],null,null,[["default"],[[[[1,"\\n      "],[8,[39,29],[[16,"disabled",[30,0,["createDistribution","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[28,[37,30],[[28,[37,10],[[30,3]],null],[30,0,["isNewKey"]]],null],"Add key","Distribute key"],[52,[30,0,["createDistribution","isRunning"]],"loading"]]],null],[1,"\\n      "],[8,[39,29],[[4,[38,3],["click",[30,10]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],null]],["@backend","A","@key","A","val","A","@provider","A","op","@onClose"],false,["if","hds/alert","form","on","perform","unless","div","search-select","array","and","not","hds/link/inline","doc-link","label","p","select","option","each","-track-array","eq","fieldset","legend","input","capitalize","radio-button","fn","mut","hr","hds/button-set","hds/button","or"]]',moduleName:"vault/components/keymgmt/distribute.hbs",isStrictMode:!1})
let z=(d=O((c=class{constructor(){T(this,"key",d,this),T(this,"provider",p,this),T(this,"operations",f,this),T(this,"protection",m,this)}}).prototype,"key",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=O(c.prototype,"provider",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=O(c.prototype,"operations",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=O(c.prototype,"protection",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c)
const M={gcpckms:["aes256-gcm96","rsa-2048","rsa-3072","rsa-4096","ecdsa-p256","ecdsa-p384","ecdsa-p521"],awskms:["aes256-gcm96"],azurekeyvault:["rsa-2048","rsa-3072","rsa-4096"]}
let S=e.default=(h=class extends n.default{constructor(){super(...arguments),T(this,"pagination",b,this),T(this,"store",y,this),T(this,"flashMessages",g,this),T(this,"router",v,this),T(this,"keyModel",w,this),T(this,"isNewKey",k,this),T(this,"providerType",x,this),T(this,"formData",P,this),T(this,"formErrors",_,this),this.formData=new z,this.formData.key=this.args.key||"",this.formData.provider=this.args.provider||"",this.args.provider&&this.getProviderType(this.args.provider),this.args.key&&this.getKeyInfo(this.args.key),this.formData.operations=[]}get keyTypes(){return a.KEY_TYPES}get validMatchError(){if(!this.providerType||!this.keyModel?.type)return null
const e=M[this.providerType]?.includes(this.keyModel.type)
if(e)return null
if(this.args.provider)return{key:`This key type is incompatible with the ${this.providerType} provider. To distribute to this provider, change the key type or choose another key.`}
const t=`This provider is incompatible with the ${this.keyModel.type} key type. Please choose another provider`
return{provider:this.args.key?`${t}.`:`${t} or change the key type.`}}get operations(){const e=this.providerType
if("awskms"===e)return["encrypt","decrypt"]
if("gcpckms"===e){switch(this.keyModel?.type||""){case"aes256-gcm96":return["encrypt","decrypt"]
case"rsa-2048":case"rsa-3072":case"rsa-4096":return["decrypt","sign"]
case"ecdsa-p256":case"ecdsa-p384":return["sign"]
default:return["encrypt","decrypt","sign","verify","wrap","unwrap"]}}return["encrypt","decrypt","sign","verify","wrap","unwrap"]}get disableOperations(){return this.validMatchError||!this.formData.provider||!this.formData.key||this.isNewKey&&!this.keyModel.type}async getKeyInfo(e,t=!1){let n
t?(this.isNewKey=!0,n=this.store.createRecord("keymgmt/key",{backend:this.args.backend,id:e,name:e})):n=await this.store.queryRecord("keymgmt/key",{backend:this.args.backend,id:e,recordOnly:!0}).catch((()=>{})),this.keyModel=n}async getProviderType(e){if(!e)return void(this.providerType="")
const t=await this.store.queryRecord("keymgmt/provider",{backend:this.args.backend,id:e}).catch((()=>{}))
this.providerType=t?.provider}destroyKey(){this.isNewKey&&this.keyModel.destroyRecord().finally((()=>{this.keyModel=null})),this.isNewKey=!1,this.keyModel=null}formatData(e){const{key:t,provider:n,operations:i,protection:r}=e
return t&&n&&i&&0!==i.length?{key:t,provider:n,purpose:i.join(","),protection:r}:null}distributeKey(e,t){const n=this.store.adapterFor("keymgmt/key"),{key:i,provider:r,purpose:l,protection:a}=t
return n.distribute(e,r,i,{purpose:l,protection:a}).then((()=>{this.flashMessages.success(`Successfully distributed key ${i} to ${r}`),this.pagination.clearDataset("keymgmt/key")
const e=this.store.peekRecord("keymgmt/provider",r)
e.fetchKeys(e.keys?.meta?.currentPage||1),this.args.onClose()})).catch((e=>{this.formErrors=`${e.errors}`}))}handleProvider(e){let t=e[0]
"string"==typeof e&&(t=e),this.formData.provider=t,t&&this.getProviderType(t)}handleKeyType(e){this.keyModel.set("type",e.target.value)}handleOperation(e){const t=[...this.formData.operations]
if(e.target.checked)t.push(e.target.id)
else{const n=t.indexOf(e.target.id)
t.splice(n,1)}this.formData.operations=t}async handleKeySelect(e){const t=e[0]||null
return t?(this.formData.key=t.id,this.getKeyInfo(t.id,t.isNew)):(this.formData.key=null,this.destroyKey())}*createDistribution(e){e.preventDefault()
const{backend:t}=this.args,n=this.formatData(this.formData)
if(n){if(this.isNewKey)try{yield this.keyModel.save(),this.flashMessages.success(`Successfully created key ${this.keyModel.name}`)}catch(i){return void this.flashMessages.danger(`Error creating new key ${this.keyModel.name}: ${i.errors}`)}yield this.distributeKey(t,n),yield this.store.queryRecord("keymgmt/key",{backend:this.args.backend,id:this.keyModel.name})}else this.flashMessages.danger("Key, provider, and operations are all required")}},b=O(h.prototype,"pagination",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=O(h.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=O(h.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=O(h.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=O(h.prototype,"keyModel",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=O(h.prototype,"isNewKey",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),x=O(h.prototype,"providerType",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=O(h.prototype,"formData",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=O(h.prototype,"formErrors",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),O(h.prototype,"handleProvider",[i.action],Object.getOwnPropertyDescriptor(h.prototype,"handleProvider"),h.prototype),O(h.prototype,"handleKeyType",[i.action],Object.getOwnPropertyDescriptor(h.prototype,"handleKeyType"),h.prototype),O(h.prototype,"handleOperation",[i.action],Object.getOwnPropertyDescriptor(h.prototype,"handleOperation"),h.prototype),O(h.prototype,"handleKeySelect",[i.action],Object.getOwnPropertyDescriptor(h.prototype,"handleKeySelect"),h.prototype),O(h.prototype,"createDistribution",[o.task,s.waitFor],Object.getOwnPropertyDescriptor(h.prototype,"createDistribution"),h.prototype),h);(0,t.setComponentTemplate)(j,S)})),define("vault/components/keymgmt/key-edit",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","ember-concurrency","@ember/test-waiters","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d,p,f
function m(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function h(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,s.createTemplateFactory)({id:"dcCEmGXI",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@path","@mode","@root","@showCurrent"],["vault.cluster.secrets.backend.show",[30,0,["mode"]],[30,2],true]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n"],[41,[30,0,["isDistributing"]],[[[1,"        Distribute Key\\n"]],[]],[[[41,[28,[37,4],[[30,3],"create"],null],[[[1,"        Create Key\\n"]],[]],[[[41,[28,[37,4],[[30,3],"edit"],null],[[[1,"        Edit Key\\n"]],[]],[[[1,"        "],[1,[30,4,["id"]]],[1,"\\n      "]],[]]]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["isDistributing"]],[[[1,"  "],[8,[39,5],null,[["@backend","@key","@onClose"],[[30,4,["backend"]],[30,4,["id"]],[28,[37,6],[[28,[37,7],[[30,0,["isDistributing"]]],null],false],null]]],null],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,0,["mode"]],"show"],null],[[[1,"    "],[10,0],[14,0,"tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[12],[1,"\\n      "],[10,"nav"],[14,0,"tabs"],[14,"aria-label","navigation for managing keys"],[12],[1,"\\n        "],[10,"ul"],[12],[1,"\\n          "],[10,"li"],[15,0,[52,[28,[37,12],[[30,5],"versions"],null],"active"]],[12],[1,"\\n            "],[8,[39,13],null,[["@route","@model","@query"],["vault.cluster.secrets.backend.show",[30,4,["id"]],[28,[37,14],null,[["tab"],[""]]]]],[["default"],[[[[1,"\\n              Details\\n            "]],[]]]]],[1,"\\n          "],[13],[1,"\\n          "],[10,"li"],[15,0,[52,[28,[37,4],[[30,5],"versions"],null],"active"]],[12],[1,"\\n            "],[8,[39,13],null,[["@route","@model","@query"],["vault.cluster.secrets.backend.show",[30,4,["id"]],[28,[37,14],null,[["tab"],["versions"]]]]],[["default"],[[[[1,"\\n              Versions\\n            "]],[]]]]],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[8,[39,15],null,null,[["default"],[[[[1,"\\n      "],[8,[39,16],null,null,[["default"],[[[[1,"\\n"],[41,[51,[30,4,["distribution"]]],[[[1,"          "],[8,[39,18],[[24,0,"toolbar-button"],[4,[38,19],["click",[28,[37,6],[[28,[37,7],[[30,0,["isDistributing"]]],null],true],null]],null]],[["@text","@color"],["Distribute key","secondary"]],null],[1,"\\n"]],[]],null],[41,[30,4,["canDelete"]],[[[1,"          "],[8,[39,18],[[24,0,"toolbar-button"],[16,"disabled",[28,[37,20],[[30,4,["deletionAllowed"]]],null]],[4,[38,19],["click",[28,[37,6],[[28,[37,7],[[30,0,["isDeleteModalOpen"]]],null],true],null]],null]],[["@text","@color"],["Destroy key","secondary"]],null],[1,"\\n"]],[]],null],[41,[30,4,["provider"]],[[[1,"          "],[8,[39,21],[[24,0,"toolbar-button"]],[["@buttonText","@buttonColor","@onConfirmAction","@confirmTitle","@confirmMessage","@isRunning"],["Remove key","secondary",[28,[37,22],[[30,0,["removeKey"]]],null],"Remove this key?","This will remove all versions of the key from the KMS provider. The key will stay in Vault.",[30,0,["removeKey","isRunning"]]]],null],[1,"\\n"]],[]],null],[41,[28,[37,23],[[30,4,["canDelete"]],[30,4,["provider"]]],null],[[[1,"          "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n"]],[]],null],[1,"        "],[8,[39,21],[[24,0,"toolbar-button"]],[["@buttonText","@buttonColor","@modalColor","@onConfirmAction","@confirmTitle","@confirmMessage","@color","@isRunning"],["Rotate key","secondary","warning",[28,[37,22],[[30,0,["rotateKey"]]],null],"Rotate this key?","After rotation, all key actions will default to using the newest version of the key.","warning",[30,0,["rotateKey","isRunning"]]]],null],[1,"\\n"],[41,[30,4,["canEdit"]],[[[1,"          "],[8,[39,24],null,[["@secret","@mode","@replace","@queryParams"],[[30,4,["id"]],"edit",true,[28,[37,14],null,[["itemType"],["key"]]]]],[["default"],[[[[1,"\\n            Edit key\\n          "]],[]]]]],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,0,["isMutable"]],[[[1,"    "],[11,"form"],[4,[38,19],["submit",[28,[37,22],[[30,0,["saveKey"]]],null]],null],[12],[1,"\\n      "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n"],[44,[[52,[28,[37,4],[[30,3],"create"],null],"createFields","updateFields"]],[[[42,[28,[37,28],[[28,[37,28],[[28,[37,29],[[30,4],[30,6]],null]],null]],null],null,[[[1,"            "],[8,[39,30],null,[["@attr","@model"],[[30,7],[30,4]]],null],[1,"\\n"]],[7]],null],[1,"          "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n            "],[8,[39,31],null,null,[["default"],[[[[1,"\\n              "],[8,[39,18],[[16,"disabled",[30,0,["saveTask","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[30,0,["isCreating"]],"Create key","Update"],[52,[30,0,["saveTask","isRunning"]],"loading"]]],null],[1,"\\n              "],[8,[39,18],[[16,"disabled",[30,0,["savekey","isRunning"]]]],[["@text","@color","@route","@model","@query"],["Cancel","secondary",[52,[30,0,["isCreating"]],[30,2,["path"]],"vault.cluster.secrets.backend.show"],[52,[30,0,["isCreating"]],[30,2,["model"]],[30,4,["id"]]],[52,[51,[30,0,["isCreating"]]],[28,[37,14],null,[["itemType"],["key"]]],[28,[37,14],null,[["itemType"],[""]]]]]],null],[1,"\\n            "]],[]]]]],[1,"\\n          "],[13],[1,"\\n"]],[6]]],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[41,[28,[37,4],[[30,5],"versions"],null],[[[42,[28,[37,28],[[28,[37,28],[[30,4,["versions"]]],null]],null],null,[[[1,"      "],[10,0],[14,0,"list-item-row"],[12],[1,"\\n        "],[10,0],[14,0,"columns is-mobile"],[12],[1,"\\n          "],[10,0],[14,0,"column is-3 has-text-weight-bold"],[12],[1,"\\n            "],[8,[39,32],[[24,0,"has-text-grey-light"]],[["@name"],["history"]],null],[1,"\\n            "],[10,1],[12],[1,"Version "],[1,[30,8,["id"]]],[13],[1,"\\n          "],[13],[1,"\\n          "],[10,0],[14,0,"column is-3 has-text-grey"],[12],[1,"\\n            "],[1,[28,[35,34],[[30,8,["creation_time"]]],[["addSuffix"],[true]]]],[1,"\\n          "],[13],[1,"\\n          "],[10,0],[14,0,"column is-6 is-flex-center"],[12],[1,"\\n"],[41,[28,[37,4],[[30,4,["minEnabledVersion"]],[30,8,["id"]]],null],[[[1,"              "],[8,[39,32],[[24,0,"has-text-success"]],[["@name"],["check-circle-fill"]],null],[1,"\\n              "],[10,1],[12],[1,"Current mininum enabled version"],[13],[1,"\\n"]],[]],null],[1,"          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[8]],null]],[]],[[[1,"    "],[10,0],[14,0,"has-top-margin-xl has-bottom-margin-s"],[12],[1,"\\n      "],[10,"h2"],[14,0,"title is-5 has-border-bottom-light has-bottom-padding-s"],[12],[1,"Key details"],[13],[1,"\\n"],[42,[28,[37,28],[[28,[37,28],[[30,4,["showFields"]]],null]],null],null,[[[1,"        "],[8,[39,36],null,[["@alwaysRender","@label","@value","@defaultShown","@formatDate"],[true,[28,[37,37],[[28,[37,23],[[30,9,["options","label"]],[28,[37,38],[[28,[37,39],[[30,9,["name"]]],null]],null]],null]],null],[28,[37,29],[[30,4],[30,9,["name"]]],null],[30,9,["options","defaultShown"]],[52,[28,[37,4],[[30,9,["type"]],"date"],null],"MMM d yyyy, h:mm:ss aaa"]]],null],[1,"\\n"]],[9]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"has-top-margin-xl has-bottom-margin-s"],[12],[1,"\\n      "],[10,"h2"],[15,0,[29,["title is-5 ",[52,[30,4,["distribution"]],"has-border-bottom-light","is-borderless"]]]],[12],[1,"\\n        Distribution details\\n      "],[13],[1,"\\n"],[41,[30,4,["provider","permissionsError"]],[[[1,"        "],[8,[39,40],null,[["@title","@subTitle","@message","@icon"],["You are not authorized","Error 403",[28,[37,41],["You must be granted permissions to see whether this key is distributed. Ask your administrator if you think you should have access to LIST /",[30,4,["backend"]],"/key/",[30,4,["name"]],"/kms."],null],"minus-circle"]],null],[1,"\\n"]],[]],[[[41,[28,[37,42],[[30,4,["provider"]]],null],[[[1,"        "],[8,[39,40],null,[["@title","@message"],["Key not distributed","When this key is distributed to a destination, those details will appear here."]],[["default"],[[[[1,"\\n"],[41,[30,4,["canListProviders"]],[[[1,"            "],[8,[39,18],[[4,[38,19],["click",[28,[37,6],[[28,[37,7],[[30,0,["isDistributing"]]],null],true],null]],null]],[["@text","@icon","@iconPosition","@color"],["Distribute key","chevron-right","trailing","tertiary"]],null],[1,"\\n"]],[]],null],[1,"        "]],[]]]]],[1,"\\n"]],[]],[[[1,"        "],[8,[39,36],null,[["@label","@value"],["Distributed",[30,4,["provider"]]]],[["default"],[[[[1,"\\n          "],[8,[39,13],null,[["@route","@model","@query"],["vault.cluster.secrets.backend.show",[30,4,["provider"]],[28,[37,14],null,[["itemType"],["provider"]]]]],[["default"],[[[[1,"\\n            "],[8,[39,32],[[24,0,"has-text-success"]],[["@name"],["check-circle-fill"]],null],[1,[30,4,["provider"]]],[1,"\\n          "]],[]]]]],[1,"\\n        "]],[]]]]],[1,"\\n"],[41,[30,4,["distribution"]],[[[42,[28,[37,28],[[28,[37,28],[[30,4,["distFields"]]],null]],null],null,[[[1,"            "],[8,[39,36],null,[["@alwaysRender","@label","@value","@defaultShown","@helperText","@formatDate"],[true,[28,[37,37],[[28,[37,23],[[30,10,["label"]],[28,[37,38],[[28,[37,39],[[30,10,["name"]]],null]],null]],null]],null],[52,[28,[37,4],[[30,10,["name"]],"protection"],null],[28,[37,43],[[28,[37,29],[[30,4,["distribution"]],[30,10,["name"]]],null]],null],[28,[37,29],[[30,4,["distribution"]],[30,10,["name"]]],null]],[30,10,["defaultShown"]],[30,10,["subText"]],[52,[28,[37,4],[[30,10,["type"]],"date"],null],"MMM d yyyy, h:mm:ss aaa"]]],null],[1,"\\n"]],[10]],null]],[]],[[[1,"          "],[8,[39,40],null,[["@title","@subTitle","@message","@icon"],["You are not authorized","Error 403",[28,[37,41],["You must be granted permissions to view distribution details for this key. Ask your administrator if you think you should have access to GET /",[30,4,["backend"]],"/key/",[30,4,["name"]],"/kms."],null],"minus-circle"]],null],[1,"\\n"]],[]]],[1,"      "]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]],[]]]],[]]],[1,"\\n"],[8,[39,44],null,[["@title","@onClose","@isActive","@confirmText","@toConfirmMsg","@onConfirm"],["Destroy key?",[28,[37,6],[[28,[37,7],[[30,0,["isDeleteModalOpen"]]],null],false],null],[30,0,["isDeleteModalOpen"]],[30,4,["name"]],"deleting the key",[28,[37,6],[[30,0,["deleteKey"]],[30,4,["id"]]],null]]],[["default"],[[[[1,"\\n  "],[10,2],[12],[1,"\\n    Destroying the\\n    "],[10,"strong"],[12],[1,[30,4,["name"]]],[13],[1,"\\n    key means that the underlying data will be lost and the key will become unusable for cryptographic operations. It is\\n    unrecoverable.\\n  "],[13],[1,"\\n  "],[8,[39,47],null,[["@model","@errorMessage"],[[30,0,["model"]],[30,0,["error"]]]],null],[1,"\\n"]],[]]]]]],["p","@root","@mode","@model","@tab","fieldsKey","attr","version","attr","attr"],false,["page-header","key-value-header","h1","if","eq","keymgmt/distribute","fn","mut","div","nav","ul","li","not-eq","link-to","hash","toolbar","toolbar-actions","unless","hds/button","on","not","confirm-action","perform","or","toolbar-secret-link","form","let","each","-track-array","get","form-field","hds/button-set","icon","span","date-from-now","h2","info-table-row","capitalize","humanize","dasherize","empty-state","concat","is-empty-value","uppercase","confirmation-modal","p","strong","message-error"]]',moduleName:"vault/components/keymgmt/key-edit.hbs",isStrictMode:!1}),y="vault.cluster.secrets.backend.show"
let g=e.default=(u=class extends n.default{constructor(...e){super(...e),m(this,"store",c,this),m(this,"router",d,this),m(this,"flashMessages",p,this),m(this,"isDeleteModalOpen",f,this)}get mode(){return this.args.mode||"show"}get keyAdapter(){return this.store.adapterFor("keymgmt/key")}get isMutable(){return["create","edit"].includes(this.args.mode)}get isCreating(){return"create"===this.args.mode}*saveKey(e){e.preventDefault()
const{model:t}=this.args
try{yield t.save(),this.router.transitionTo(y,t.name)}catch(n){let e=n
n.errors&&(e=n.errors.join(". ")),this.flashMessages.danger(e),n.errors||this.router.transitionTo(y,t.name)}}*removeKey(){try{yield this.keyAdapter.removeFromProvider(this.args.model),yield this.args.model.reload(),this.flashMessages.success("Key has been successfully removed from provider")}catch(e){this.flashMessages.danger(e.errors?.join(". "))}}deleteKey(){const e=this.args.model,t=e.backend
e.destroyRecord().then((()=>{this.router.transitionTo("vault.cluster.secrets.backend.list-root",t)})).catch((e=>{this.flashMessages.danger(e.errors?.join(". "))}))}*rotateKey(){const e=this.args.model.name,t=this.args.model.backend,n=this.keyAdapter
yield n.rotateKey(t,e).then((()=>{this.flashMessages.success(`Success: ${e} connection was rotated`)})).catch((e=>{this.flashMessages.danger(e.errors)}))}},c=h(u.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(u.prototype,"router",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=h(u.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=h(u.prototype,"isDeleteModalOpen",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),h(u.prototype,"saveKey",[a.task,o.waitFor],Object.getOwnPropertyDescriptor(u.prototype,"saveKey"),u.prototype),h(u.prototype,"removeKey",[a.task,o.waitFor],Object.getOwnPropertyDescriptor(u.prototype,"removeKey"),u.prototype),h(u.prototype,"deleteKey",[r.action],Object.getOwnPropertyDescriptor(u.prototype,"deleteKey"),u.prototype),h(u.prototype,"rotateKey",[a.task,o.waitFor],Object.getOwnPropertyDescriptor(u.prototype,"rotateKey"),u.prototype),u);(0,t.setComponentTemplate)(b,g)})),define("vault/components/keymgmt/provider-edit",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","ember-concurrency","@ember/test-waiters","vault/helpers/remove-from-array","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f
function m(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function h(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,u.createTemplateFactory)({id:"P6QYJGFo",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@path","@mode","@root","@showCurrent"],["vault.cluster.secrets.backend.show",[30,2],[30,3],true]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n"],[41,[30,0,["isDistributing"]],[[[1,"        Distribute Key to Provider\\n"]],[]],[[[41,[30,0,["isShowing"]],[[[1,"        Provider\\n        "],[10,1],[14,0,"has-font-weight-normal"],[12],[1,[30,4,["id"]]],[13],[1,"\\n"]],[]],[[[1,"        "],[1,[52,[30,0,["isCreating"]],"Create Provider","Update Credentials"]],[1,"\\n      "]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,0,["isDistributing"]],[[[1,"  "],[8,[39,5],null,[["@backend","@provider","@onClose"],[[30,4,["backend"]],[30,4,["id"]],[28,[37,6],[[28,[37,7],[[30,0,["isDistributing"]]],null],false],null]]],null],[1,"\\n"]],[]],[[[41,[30,0,["isShowing"]],[[[1,"    "],[10,0],[14,0,"tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[12],[1,"\\n      "],[10,"nav"],[14,0,"tabs"],[14,"aria-label","navigation for managing providers"],[12],[1,"\\n        "],[10,"ul"],[12],[1,"\\n          "],[10,"li"],[15,0,[52,[51,[30,0,["viewingKeys"]]],"active"]],[12],[1,"\\n            "],[8,[39,13],null,[["@route","@model","@query"],["vault.cluster.secrets.backend.show",[30,4,["id"]],[28,[37,14],null,[["tab"],[""]]]]],[["default"],[[[[1,"\\n              Details\\n            "]],[]]]]],[1,"\\n          "],[13],[1,"\\n"],[41,[30,4,["canListKeys"]],[[[1,"            "],[10,"li"],[15,0,[52,[30,0,["viewingKeys"]],"active"]],[12],[1,"\\n              "],[8,[39,13],null,[["@route","@model","@query"],["vault.cluster.secrets.backend.show",[30,4,["id"]],[28,[37,14],null,[["tab"],["keys"]]]]],[["default"],[[[[1,"\\n                Keys\\n              "]],[]]]]],[1,"\\n            "],[13],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"],[41,[51,[30,0,["viewingKeys"]]],[[[1,"      "],[8,[39,15],[[16,"aria-label",[29,["options for managing for key/management provider ",[30,4,["id"]]]]]],null,[["default"],[[[[1,"\\n        "],[8,[39,16],null,null,[["default"],[[[[1,"\\n"],[41,[30,4,["canDelete"]],[[[1,"            "],[8,[39,17],[[24,0,"toolbar-button"]],[["@buttonText","@buttonColor","@confirmTitle","@onConfirmAction","@disabledMessage"],["Delete provider","secondary","Delete this provider?",[30,0,["onDelete"]],[52,[30,4,["keys","length"]],[28,[37,18],["This provider cannot be deleted until all ",[30,4,["keys","length"]]," key(s) distributed to it are revoked. This can be done from the Keys tab."],null]]]],null],[1,"\\n"]],[]],null],[41,[28,[37,19],[[30,4,["canDelete"]],[28,[37,20],[[30,4,["canListKeys"]],[30,4,["canEdit"]]],null]],null],[[[1,"            "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n"]],[]],null],[41,[28,[37,20],[[30,4,["canListKeys"]],[30,4,["canCreateKeys"]]],null],[[[1,"            "],[8,[39,21],[[24,0,"toolbar-button"],[4,[38,22],["click",[28,[37,6],[[28,[37,7],[[30,0,["isDistributing"]]],null],true],null]],null]],[["@text","@icon","@iconPosition","@color"],["Distribute key","chevron-right","trailing","secondary"]],null],[1,"\\n"]],[]],null],[41,[30,4,["canEdit"]],[[[1,"            "],[8,[39,23],[[16,"disabled",[28,[37,24],[[30,4,["canEdit"]]],null]]],[["@secret","@mode","@replace","@queryParams"],[[30,4,["id"]],"edit",true,[28,[37,14],null,[["itemType"],["provider"]]]]],[["default"],[[[[1,"\\n              Update credentials\\n            "]],[]]]]],[1,"\\n"]],[]],null],[1,"        "]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n"]],[]],null]],[]],[[[1,"    "],[11,"form"],[24,"aria-label","update credentials"],[4,[38,22],["submit",[30,0,["onSave"]]],null],[12],[1,"\\n      "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n"],[41,[30,0,["isCreating"]],[[[42,[28,[37,27],[[28,[37,27],[[30,4,["createFields"]]],null]],null],null,[[[41,[28,[37,28],[[30,6],2],null],[[[1,"              "],[10,0],[14,0,"has-border-top-light"],[12],[1,"\\n                "],[10,"h2"],[14,0,"title is-5 has-top-margin-l has-bottom-margin-m"],[12],[1,"\\n                  Provider configuration\\n                "],[13],[1,"\\n              "],[13],[1,"\\n"],[41,[30,4,["provider"]],[[[1,"                "],[8,[39,30],null,[["@attr","@model","@modelValidations"],[[30,5],[30,4],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[]],[[[1,"                "],[8,[39,31],null,[["@title","@message"],["No provider selected","Select a provider in order to configure it."]],null],[1,"\\n"]],[]]]],[]],[[[1,"              "],[8,[39,30],null,[["@attr","@model","@modelValidations"],[[30,5],[30,4],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[]]]],[5,6]],null]],[]],null],[41,[51,[30,0,["isCreating"]]],[[[1,"          "],[10,"h2"],[14,0,"title is-5"],[12],[1,"\\n            New credentials\\n          "],[13],[1,"\\n          "],[10,2],[14,0,"sub-text has-bottom-margin-m"],[12],[1,"\\n            Old credentials cannot be read and will be lost as soon as new ones are added. Do this carefully.\\n          "],[13],[1,"\\n"]],[]],null],[42,[28,[37,27],[[28,[37,27],[[30,4,["credentialFields"]]],null]],null],null,[[[1,"          "],[8,[39,30],null,[["@attr","@model","@modelValidations"],[[30,7],[30,4],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[7]],null],[1,"      "],[13],[1,"\\n      "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n        "],[8,[39,33],null,null,[["default"],[[[[1,"\\n          "],[8,[39,21],[[16,"disabled",[30,0,["saveTask","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[30,0,["isCreating"]],"Create provider","Update"],[52,[30,0,["saveTask","isRunning"]],"loading"]]],null],[1,"\\n          "],[8,[39,21],[[16,"disabled",[30,0,["saveTask","isRunning"]]]],[["@text","@color","@route","@model","@query"],["Cancel","secondary",[52,[30,0,["isCreating"]],[30,3,["path"]],"vault.cluster.secrets.backend.show"],[52,[30,0,["isCreating"]],[30,3,["model"]],[30,4,["id"]]],[52,[30,0,["isCreating"]],[28,[37,14],null,[["tab"],["provider"]]],[28,[37,14],null,[["itemType"],["provider"]]]]]],null],[1,"\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]]],[1,"\\n"],[41,[30,0,["isShowing"]],[[[1,"    "],[10,0],[14,0,"has-bottom-margin-s"],[12],[1,"\\n"],[41,[30,0,["viewingKeys"]],[[[44,[[28,[37,35],["keymgmt","key"],null]],[[[41,[30,4,["keys","meta","total"]],[[[42,[28,[37,27],[[28,[37,27],[[30,4,["keys"]]],null]],null],null,[[[1,"              "],[8,[39,36],null,[["@item","@backendModel","@backendType","@delete","@itemPath","@itemType","@modelType","@options"],[[30,9],[30,3],"keymgmt",[28,[37,6],[[30,0,["onDeleteKey"]],[30,9]],null],[28,[37,18],[[30,8,["modelPrefix"]],[30,9,["id"]]],null],[30,8,["item"]],[30,10],[30,8]]],null],[1,"\\n"]],[9]],null],[1,"            "],[8,[39,37],null,[["@currentPage","@currentPageSize","@route","@showSizeSelector","@totalItems","@onPageChange"],[[30,4,["keys","meta","currentPage"]],[30,4,["keys","meta","pageSize"]],"vault.cluster.secrets.backend.show",false,[30,4,["keys","meta","total"]],[28,[37,38],[[30,0,["fetchKeys"]]],null]]],null],[1,"\\n\\n"]],[]],[[[1,"            "],[8,[39,31],null,[["@title","@message"],["No keys for this provider","Keys for this provider will be listed here. Add a key to get started."]],[["default"],[[[[1,"\\n              "],[8,[39,39],null,[["@icon","@text","@route","@query"],["plus","Create key","vault.cluster.secrets.backend.create-root",[28,[37,14],null,[["itemType"],["key"]]]]],null],[1,"\\n            "]],[]]]]],[1,"\\n"]],[]]]],[8]]]],[]],[[[42,[28,[37,27],[[28,[37,27],[[30,4,["showFields"]]],null]],null],null,[[[41,[30,11,["hasBlock"]],[[[1,"            "],[8,[39,40],null,[["@label","@value"],[[30,11,["label"]],[30,11,["value"]]]],[["default"],[[[[1,"\\n"],[41,[30,11,["icon"]],[[[1,"                "],[8,[39,41],[[24,0,"icon"]],[["@name"],[[30,11,["icon"]]]],null],[1,"\\n"]],[]],null],[41,[30,11,["isLink"]],[[[1,"                "],[8,[39,13],null,[["@route","@model","@query"],["vault.cluster.secrets.backend.show",[30,4,["id"]],[28,[37,14],null,[["tab"],["keys"]]]]],[["default"],[[[[1,"\\n                  "],[1,[30,11,["value"]]],[1,"\\n                "]],[]]]]],[1,"\\n"]],[]],[[[1,"                "],[1,[30,11,["value"]]],[1,"\\n"]],[]]],[1,"            "]],[]]]]],[1,"\\n"]],[]],[[[1,"            "],[8,[39,40],null,[["@alwaysRender","@label","@value","@defaultShown","@formatDate"],[true,[28,[37,42],[[28,[37,20],[[30,11,["options","label"]],[28,[37,43],[[28,[37,44],[[30,11,["name"]]],null]],null]],null]],null],[28,[37,45],[[30,4],[30,11,["name"]]],null],[30,11,["options","defaultShown"]],[52,[28,[37,28],[[30,11,["type"]],"date"],null],"MMM d yyyy, h:mm:ss aaa"]]],null],[1,"\\n"]],[]]]],[11]],null]],[]]],[1,"    "],[13],[1,"\\n"]],[]],null]],[]]]],["p","@mode","@root","@model","attr","index","cred","options","key","@modelType","attr"],false,["page-header","key-value-header","h1","if","span","keymgmt/distribute","fn","mut","div","nav","ul","li","unless","link-to","hash","toolbar","toolbar-actions","confirm-action","concat","and","or","hds/button","on","toolbar-secret-link","not","form","each","-track-array","eq","h2","form-field","empty-state","p","hds/button-set","let","options-for-backend","secret-list/item","hds/pagination/numbered","perform","hds/link/standalone","info-table-row","icon","capitalize","humanize","dasherize","get"]]',moduleName:"vault/components/keymgmt/provider-edit.hbs",isStrictMode:!1})
let y=e.default=(c=class extends n.default{constructor(){super(...arguments),m(this,"router",d,this),m(this,"flashMessages",p,this),m(this,"modelValidations",f,this),"show"===this.args.mode&&this.fetchKeys.perform()}get isShowing(){return"show"===this.args.mode}get isCreating(){return"create"===this.args.mode}get viewingKeys(){return"keys"===this.args.tab}*saveTask(){const{model:e}=this.args
try{yield e.save(),this.router.transitionTo("vault.cluster.secrets.backend.show",e.id,{queryParams:{itemType:"provider"}})}catch(t){this.flashMessages.danger(t.errors.join(". "))}}*fetchKeys(e){try{yield this.args.model.fetchKeys(e)}catch(t){this.flashMessages.danger(t.errors.join(". "))}}async onSave(e){e.preventDefault()
const{isValid:t,state:n}=await this.args.model.validate()
t?(this.modelValidations=null,this.saveTask.perform()):this.modelValidations=n}async onDelete(){try{const{model:e,root:t}=this.args
await e.destroyRecord(),this.router.transitionTo(t.path,t.model,{queryParams:{tab:"provider"}})}catch(e){this.flashMessages.danger(e.errors.join(". "))}}async onDeleteKey(e){try{const t=(0,s.removeFromArray)(this.args.model.keys,e)
await e.destroyRecord(),this.args.model.keys=t}catch(t){this.flashMessages.danger(t.errors.join(". "))}}},d=h(c.prototype,"router",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=h(c.prototype,"flashMessages",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=h(c.prototype,"modelValidations",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h(c.prototype,"saveTask",[a.task,o.waitFor],Object.getOwnPropertyDescriptor(c.prototype,"saveTask"),c.prototype),h(c.prototype,"fetchKeys",[a.task,o.waitFor],Object.getOwnPropertyDescriptor(c.prototype,"fetchKeys"),c.prototype),h(c.prototype,"onSave",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"onSave"),c.prototype),h(c.prototype,"onDelete",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"onDelete"),c.prototype),h(c.prototype,"onDeleteKey",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"onDeleteKey"),c.prototype),c);(0,t.setComponentTemplate)(b,y)})),define("vault/components/kv-object-editor",["exports","core/components/kv-object-editor"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/kv-suggestion-input",["exports","core/components/kv-suggestion-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/layout-loading",["exports","core/components/layout-loading"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/license-banners",["exports","@ember/component","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","date-fns/isAfter","date-fns/differenceInDays","vault/lib/local-storage","core/utils/timestamp","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c){var d,p,f,m
function h(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function b(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,c.createTemplateFactory)({id:"yS6Qlu8+",block:'[[[1,"\\n"],[41,[28,[37,1],[[30,0,["licenseExpired"]],[28,[37,2],[[30,0,["expiredDismissed"]]],null]],null],[[[1,"  "],[8,[39,3],null,[["@type","@color","@onDismiss"],["inline","critical",[28,[37,4],[[30,0,["dismissBanner"]],"expired"],null]]],[["default"],[[[[1,"\\n    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"License expired"]],[]]]]],[1,"\\n    "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n      Your Vault license expired on\\n      "],[1,[28,[35,5],[[30,2],"MMM d, yyyy"],null]],[1,". Add a new license to your configuration and restart Vault.\\n    "]],[]]]]],[1,"\\n    "],[8,[30,1,["Description"]],[[24,0,"has-top-margin-xs"]],null,[["default"],[[[[1,"\\n      "],[8,[39,6],null,[["@path"],["/vault/tutorials/enterprise/hashicorp-enterprise-license"]],[["default"],[[[[1,"\\n        Read documentation\\n        "],[8,[39,7],null,[["@name"],["learn-link"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[1]]]]],[1,"\\n"]],[]],[[[41,[28,[37,1],[[28,[37,8],[[30,0,["licenseExpiringInDays"]],30],null],[28,[37,2],[[30,0,["warningDismissed"]]],null]],null],[[[1,"  "],[8,[39,3],null,[["@type","@color","@onDismiss"],["inline","warning",[28,[37,4],[[30,0,["dismissBanner"]],"warning"],null]]],[["default"],[[[[1,"\\n    "],[8,[30,3,["Title"]],null,null,[["default"],[[[[1,"Vault license expiring"]],[]]]]],[1,"\\n    "],[8,[30,3,["Description"]],null,null,[["default"],[[[[1,"\\n      Your Vault license will expire in\\n      "],[1,[30,0,["licenseExpiringInDays"]]],[1,"\\n      days at\\n      "],[1,[28,[35,5],[[30,2],"hh:mm:ss a"],null]],[1,"\\n      on\\n      "],[1,[28,[35,5],[[30,2],"MMM d, yyyy"],null]],[1,".\\n      "],[1,[52,[30,4],"Add a new license to your configuration.","Keep in mind that your next license will need to be autoloaded."]],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,3,["Description"]],[[24,0,"has-top-margin-xs"]],null,[["default"],[[[[1,"\\n      "],[8,[39,6],null,[["@path"],["/vault/tutorials/enterprise/hashicorp-enterprise-license"]],[["default"],[[[[1,"\\n        Read documentation\\n        "],[8,[39,7],null,[["@name"],["learn-link"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[3]]]]],[1,"\\n"]],[]],null]],[]]]],["A","@expiry","A","@autoloaded"],false,["if","and","not","hds/alert","fn","date-format","doc-link","icon","lte"]]',moduleName:"vault/components/license-banners.hbs",isStrictMode:!1})
let g=e.default=(d=class extends n.default{constructor(){super(...arguments),h(this,"version",p,this),h(this,"warningDismissed",f,this),h(this,"expiredDismissed",m,this)
const e=s.default.getItem(this.dismissedBannerKey)
this.updateDismissType(e)}get currentVersion(){return this.version.version}get dismissedBannerKey(){return`dismiss-license-banner-${this.currentVersion}-${this.args.expiry}`}get licenseExpired(){return!!this.args.expiry&&(0,a.default)(u.default.now(),new Date(this.args.expiry))}get licenseExpiringInDays(){return this.args.expiry?(0,o.default)(new Date(this.args.expiry),u.default.now()):99}dismissBanner(e){s.default.cleanupStorage("dismiss-license-banner",this.dismissedBannerKey),s.default.setItem(this.dismissedBannerKey,e),this.updateDismissType(e)}updateDismissType(e){"warning"===e?this.warningDismissed=!0:"expired"===e&&(this.expiredDismissed=!0)}},p=b(d.prototype,"version",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=b(d.prototype,"warningDismissed",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=b(d.prototype,"expiredDismissed",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b(d.prototype,"dismissBanner",[i.action],Object.getOwnPropertyDescriptor(d.prototype,"dismissBanner"),d.prototype),d);(0,t.setComponentTemplate)(y,g)})),define("vault/components/license-info",["exports","@ember/component","@glimmer/component","vault/helpers/all-features","@ember/template-factory"],(function(e,t,n,i,r){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const l=(0,r.createTemplateFactory)(
/*
    {{!
    Copyright IBM Corp. 2016, 2025
    SPDX-License-Identifier: BUSL-1.1
  }}
  
  <PageHeader as |p|>
    <p.levelLeft>
      <h1 class="title is-3">License</h1>
    </p.levelLeft>
  </PageHeader>
  
  <section class="box is-sideless is-marginless is-shadowless is-fullwidth">
    <span class="title is-5">Details</span>
    <div class="field box is-fullwidth is-shadowless is-paddingless is-marginless">
      <InfoTableRow @label="License ID" @value={{@licenseId}} data-test-detail-row />
      <InfoTableRow @label="Valid from" @value={{@startTime}} data-test-detail-row>
        {{date-format @startTime "MMM dd, yyyy hh:mm:ss a"}}
        to
        {{date-format @expirationTime "MMM dd, yyyy hh:mm:ss a"}}
      </InfoTableRow>
      <InfoTableRow @label="License state" @value={{"Autoloaded"}} data-test-detail-row />
    </div>
  </section>
  
  <section class="box is-sideless is-marginless is-shadowless is-fullwidth">
    <span class="title is-5">Features</span>
    <div class="field box is-fullwidth is-shadowless is-paddingless is-marginless">
      {{#each this.featuresInfo as |info|}}
        <InfoTableRow @label={{info.name}} @value={{if info.active "Active" "Not Active"}} data-test-feature-row>
          {{#if info.active}}
            <Icon @name="check-circle" class="icon-true" />
            <span data-test-feature-status>
              Active
              {{#if info.count}}&mdash; {{info.count}} standby nodes allotted{{/if}}
            </span>
          {{else}}
            <Icon @name="x-circle" class="icon-false" />
            <span data-test-feature-status>Not Active</span>
          {{/if}}
        </InfoTableRow>
      {{/each}}
    </div>
  </section>
  */
{id:"LLJnHKiw",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"License"],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[10,"section"],[14,0,"box is-sideless is-marginless is-shadowless is-fullwidth"],[12],[1,"\\n  "],[10,1],[14,0,"title is-5"],[12],[1,"Details"],[13],[1,"\\n  "],[10,0],[14,0,"field box is-fullwidth is-shadowless is-paddingless is-marginless"],[12],[1,"\\n    "],[8,[39,5],null,[["@label","@value"],["License ID",[30,2]]],null],[1,"\\n    "],[8,[39,5],null,[["@label","@value"],["Valid from",[30,3]]],[["default"],[[[[1,"\\n      "],[1,[28,[35,6],[[30,3],"MMM dd, yyyy hh:mm:ss a"],null]],[1,"\\n      to\\n      "],[1,[28,[35,6],[[30,4],"MMM dd, yyyy hh:mm:ss a"],null]],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[39,5],null,[["@label","@value"],["License state","Autoloaded"]],null],[1,"\\n  "],[13],[1,"\\n"],[13],[1,"\\n\\n"],[10,"section"],[14,0,"box is-sideless is-marginless is-shadowless is-fullwidth"],[12],[1,"\\n  "],[10,1],[14,0,"title is-5"],[12],[1,"Features"],[13],[1,"\\n  "],[10,0],[14,0,"field box is-fullwidth is-shadowless is-paddingless is-marginless"],[12],[1,"\\n"],[42,[28,[37,8],[[28,[37,8],[[30,0,["featuresInfo"]]],null]],null],null,[[[1,"      "],[8,[39,5],null,[["@label","@value"],[[30,5,["name"]],[52,[30,5,["active"]],"Active","Not Active"]]],[["default"],[[[[1,"\\n"],[41,[30,5,["active"]],[[[1,"          "],[8,[39,10],[[24,0,"icon-true"]],[["@name"],["check-circle"]],null],[1,"\\n          "],[10,1],[12],[1,"\\n            Active\\n            "],[41,[30,5,["count"]],[[[1,"— "],[1,[30,5,["count"]]],[1," standby nodes allotted"]],[]],null],[1,"\\n          "],[13],[1,"\\n"]],[]],[[[1,"          "],[8,[39,10],[[24,0,"icon-false"]],[["@name"],["x-circle"]],null],[1,"\\n          "],[10,1],[12],[1,"Not Active"],[13],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n"]],[5]],null],[1,"  "],[13],[1,"\\n"],[13]],["p","@licenseId","@startTime","@expirationTime","info"],false,["page-header","h1","section","span","div","info-table-row","date-format","each","-track-array","if","icon"]]',moduleName:"vault/components/license-info.hbs",isStrictMode:!1})

;/**
   * @module LicenseInfo
   *
   * @example
   * ```js
   * <LicenseInfo
   *   @startTime="2020-03-12T23:20:50.52Z"
   *   @expirationTime="2021-05-12T23:20:50.52Z"
   *   @licenseId="some-license-id"
   *   @features={{array 'Namespaces' 'DR Replication'}}
   *   @autoloaded={{true}}
   *   @performanceStandbyCount=1
   * />
   *
   * @param {string} startTime - RFC3339 formatted timestamp of when the license became active
   * @param {string} expirationTime - RFC3339 formatted timestamp of when the license will expire
   * @param {string} licenseId - unique ID of the license
   * @param {Array<string>} features - Array of feature names active on license
   * @param {boolean} autoloaded - Whether the license is autoloaded
   * @param {number} performanceStandbyCount - Number of performance standbys active
   */class a extends n.default{get featuresInfo(){const e=this.args.features.filter((e=>!(0,i.allFeatures)().includes(e)))
return[...(0,i.allFeatures)(),...e].map((e=>{const t=this.args.features.includes(e)
if(t&&"Performance Standby"===e){const n=this.args.performanceStandbyCount
return{name:e,active:!!n&&t,count:n}}return{name:e,active:t}}))}}e.default=a,(0,t.setComponentTemplate)(l,a)})),define("vault/components/lineal/arc/index",["exports","@lineal-viz/lineal/components/lineal/arc/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/arcs/index",["exports","@lineal-viz/lineal/components/lineal/arcs/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/area/index",["exports","@lineal-viz/lineal/components/lineal/area/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/axis/index",["exports","@lineal-viz/lineal/components/lineal/axis/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/bars/index",["exports","@lineal-viz/lineal/components/lineal/bars/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/fluid/index",["exports","@lineal-viz/lineal/components/lineal/fluid/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/gridlines/index",["exports","@lineal-viz/lineal/components/lineal/gridlines/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/h-bars/index",["exports","@lineal-viz/lineal/components/lineal/h-bars/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/line/index",["exports","@lineal-viz/lineal/components/lineal/line/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/points/index",["exports","@lineal-viz/lineal/components/lineal/points/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/lineal/v-bars/index",["exports","@lineal-viz/lineal/components/lineal/v-bars/index"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/link-status",["exports","@ember/component","@glimmer/component","@ember/service","@ember/template-factory"],(function(e,t,n,i,r){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,r.createTemplateFactory)({id:"kmBxRrjs",block:'[[[1,"\\n"],[41,[28,[37,1],[[30,0,["state"]],[30,0,["version","isEnterprise"]]],null],[[[1,"  "],[8,[39,2],null,[["@type","@color"],["page",[52,[28,[37,3],[[30,0,["state"]],"connected"],null],"neutral","warning"]]],[["default"],[[[[1,"\\n    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"\\n"],[41,[28,[37,3],[[30,0,["state"]],"connected"],null],[[[1,"        This self-managed Vault is linked to\\n        "],[8,[39,4],null,[["@href"],["https://portal.cloud.hashicorp.com/sign-in"]],[["default"],[[[[1,"HCP."]],[]]]]],[1,"\\n"]],[]],[[[1,"        Error connecting to HCP\\n"]],[]]],[1,"    "]],[]]]]],[1,"\\n"],[41,[30,0,["error"]],[[[1,"      "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n        Since\\n        "],[1,[30,0,["timestamp"]]],[1,",\\n        "],[1,[30,0,["error"]]],[1,". Check the logs for more information.\\n      "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "]],[1]]]]],[1,"\\n"]],[]],null]],["A"],false,["if","and","hds/alert","eq","hds/link/inline"]]',moduleName:"vault/components/link-status.hbs",isStrictMode:!1})
let s=e.default=(l=class extends n.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="version",r=this,(i=a)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}get state(){return this.args.status?"connected"===this.args.status?this.args.status:this.args.status.split(" ",1).toString():null}get timestamp(){try{return"connected"!==this.state?this.args.status.split("since")[1].split(";")[0].trim():null}catch{return null}}get error(){const e=this.args.status
return e&&"connected"!==e?e.split("error:")[1]:null}},u=l.prototype,c="version",d=[i.service],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},m={},Object.keys(p).forEach((function(e){m[e]=p[e]})),m.enumerable=!!m.enumerable,m.configurable=!!m.configurable,("value"in m||m.initializer)&&(m.writable=!0),m=d.slice().reverse().reduce((function(e,t){return t(u,c,e)||e}),m),f&&void 0!==m.initializer&&(m.value=m.initializer?m.initializer.call(f):void 0,m.initializer=void 0),a=void 0===m.initializer?(Object.defineProperty(u,c,m),null):m,l)
var u,c,d,p,f,m;(0,t.setComponentTemplate)(o,s)})),define("vault/components/link-to-external",["exports","ember-engines/components/link-to-external"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/linked-block",["exports","core/components/linked-block"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-item",["exports","core/components/list-item"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-item/content",["exports","core/components/list-item/content"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-item/popup-menu",["exports","core/components/list-item/popup-menu"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-table",["exports","core/components/list-table"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/list-view",["exports","core/components/list-view"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/loading-dropdown-option",["exports","core/components/loading-dropdown-option"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/logo-edition",["exports","@ember/component","@ember/service","@ember/template-factory"],(function(e,t,n,i){var r,l
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=(0,i.createTemplateFactory)({id:"qkNrhPms",block:'[[[1,"\\n"],[10,"svg"],[14,"width","146"],[14,"height","51"],[14,"viewBox","0 0 146 51"],[14,"xmlns","http://www.w3.org/2000/svg","http://www.w3.org/2000/xmlns/"],[12],[1,"\\n  "],[10,"g"],[14,1,"vault-logo-v"],[14,"fill-rule","nonzero"],[12],[1,"\\n    "],[10,"path"],[14,"d","M0,0 L25.4070312,51 L51,0 L0,0 Z M28.5,10.5 L31.5,10.5 L31.5,13.5 L28.5,13.5 L28.5,10.5 Z M22.5,22.5 L19.5,22.5 L19.5,19.5 L22.5,19.5 L22.5,22.5 Z M22.5,18 L19.5,18 L19.5,15 L22.5,15 L22.5,18 Z M22.5,13.5 L19.5,13.5 L19.5,10.5 L22.5,10.5 L22.5,13.5 Z M26.991018,27 L24,27 L24,24 L27,24 L26.991018,27 Z M26.991018,22.5 L24,22.5 L24,19.5 L27,19.5 L26.991018,22.5 Z M26.991018,18 L24,18 L24,15 L27,15 L26.991018,18 Z M26.991018,13.5 L24,13.5 L24,10.5 L27,10.5 L26.991018,13.5 Z M28.5,15 L31.5,15 L31.5,18 L28.5089552,18 L28.5,15 Z M28.5,22.5 L28.5,19.5 L31.5,19.5 L31.5,22.4601182 L28.5,22.5 Z"],[12],[13],[1,"\\n  "],[13],[1,"\\n\\n  "],[10,"path"],[14,1,"vault-logo-name"],[14,"d","M69.7218638,30.2482468 L63.2587814,8.45301543 L58,8.45301543 L65.9885305,34.6072931 L73.4551971,34.6072931 L81.4437276,8.45301543 L76.1849462,8.45301543 L69.7218638,30.2482468 Z M97.6329749,22.0014025 C97.6329749,17.2103787 95.8265233,15.0897616 89.6845878,15.0897616 C87.5168459,15.0897616 84.8272401,15.4431978 82.9806452,15.9929874 L83.5827957,19.6451613 C85.3089606,19.2917251 87.2358423,19.056101 89.0021505,19.056101 C92.1333333,19.056101 92.7354839,19.802244 92.7354839,21.9228612 L92.7354839,23.9256662 L88.0387097,23.9256662 C84.0645161,23.9256662 82.3383513,25.4179523 82.3383513,29.3057504 C82.3383513,32.6044881 83.8637993,35 87.4365591,35 C89.4035842,35 91.4910394,34.4502104 93.2573477,33.3113604 L93.618638,34.6072931 L97.6329749,34.6072931 L97.6329749,22.0014025 Z M92.7354839,30.2089762 C91.8121864,30.7194951 90.4874552,31.1907433 89.0422939,31.1907433 C87.5168459,31.1907433 87.0752688,30.601683 87.0752688,29.2664797 C87.0752688,27.8134642 87.5168459,27.3814867 89.1225806,27.3814867 L92.7354839,27.3814867 L92.7354839,30.2089762 Z M102.421505,15.4824684 L102.421505,29.345021 C102.421505,32.7615708 103.585663,35 106.837276,35 C109.125448,35 112.216487,34.1753156 114.665233,32.997195 L115.146953,34.6072931 L118.880287,34.6072931 L118.880287,15.4824684 L113.982796,15.4824684 L113.982796,28.7559607 C112.216487,29.6591865 110.088889,30.3660589 108.884588,30.3660589 C107.760573,30.3660589 107.318996,29.85554 107.318996,28.8345021 L107.318996,15.4824684 L102.421505,15.4824684 Z M129.168459,34.6072931 L129.168459,7 L124.270968,7.66760168 L124.270968,34.6072931 L129.168459,34.6072931 Z M144.394265,30.601683 C143.551254,30.8373072 142.6681,30.9943899 141.94552,30.9943899 C140.660932,30.9943899 140.179211,30.3267882 140.179211,29.3057504 L140.179211,19.2917251 L144.875986,19.2917251 L145.197133,15.4824684 L140.179211,15.4824684 L140.179211,10.0631136 L135.28172,10.7307153 L135.28172,15.4824684 L132.351254,15.4824684 L132.351254,19.2917251 L135.28172,19.2917251 L135.28172,29.9340813 C135.28172,33.3506311 137.088172,35 140.660932,35 C141.905376,35 143.912545,34.6858345 144.956272,34.2538569 L144.394265,30.601683 Z"],[12],[13],[1,"\\n\\n"],[41,[30,0,["version","isEnterprise"]],[[[1,"    "],[10,"g"],[14,1,"vault-logo-edition-enterprise"],[14,"transform","translate(65.000000, 40.000000)"],[14,"fill-rule","nonzero"],[12],[1,"\\n      "],[10,"polygon"],[14,"points","0.435816733 0.579322709 4.39438247 0.579322709 4.39438247 1.35454183 1.30175299 1.35454183 1.30175299 3.46577689 4.17171315 3.46577689 4.17171315 4.24099602 1.30175299 4.24099602 1.30175299 6.52541833 4.40262948 6.52541833 4.40262948 7.30063745 0.435816733 7.30063745"],[12],[13],[1,"\\n      "],[10,"polygon"],[14,"points","7.3138247 1.58545817 7.3138247 7.31713147 6.48912351 7.31713147 6.48912351 0.579322709 7.68494024 0.579322709 10.6126295 6.35223108 10.6126295 0.579322709 11.4373307 0.579322709 11.4373307 7.31713147 10.249761 7.31713147"],[12],[13],[1,"\\n      "],[10,"polygon"],[14,"points","15.107251 1.36278884 13.1032271 1.36278884 13.1032271 0.587569721 17.9937052 0.587569721 17.9937052 1.36278884 15.9814343 1.36278884 15.9814343 7.31713147 15.107251 7.31713147"],[12],[13],[1,"\\n      "],[10,"polygon"],[14,"points","19.6513546 0.579322709 23.6099203 0.579322709 23.6099203 1.35454183 20.5172908 1.35454183 20.5172908 3.46577689 23.387251 3.46577689 23.387251 4.24099602 20.5172908 4.24099602 20.5172908 6.52541833 23.6181673 6.52541833 23.6181673 7.30063745 19.6431076 7.30063745"],[12],[13],[1,"\\n      "],[10,"path"],[14,"d","M28.22,4.87601594 L26.5705976,4.87601594 L26.5705976,7.35011952 L25.7046614,7.35011952 L25.7046614,0.579322709 L28.2694821,0.579322709 C29.7127092,0.579322709 30.2240239,1.20609562 30.2240239,2.2287251 L30.2240239,3.20187251 C30.3204128,3.92160892 29.8576792,4.59791178 29.1519124,4.76880478 L30.9002789,7.30888446 L29.9023904,7.30888446 L28.22,4.87601594 Z M28.22,1.35454183 L26.5705976,1.35454183 L26.5705976,4.10079681 L28.22,4.10079681 C29.0447012,4.10079681 29.3333466,3.86988048 29.3333466,3.21011952 L29.3333466,2.25346614 C29.3580876,1.58545817 29.0694422,1.36278884 28.244741,1.36278884 L28.22,1.35454183 Z"],[12],[13],[1,"\\n      "],[10,"path"],[14,"d","M32.6898805,0.579322709 L35.1639841,0.579322709 C36.6072112,0.579322709 37.1185259,1.20609562 37.1185259,2.2287251 L37.1185259,3.22661355 C37.1185259,4.26573705 36.6154582,4.87601594 35.1639841,4.87601594 L33.5970518,4.87601594 L33.5970518,7.31713147 L32.7311155,7.31713147 L32.6898805,0.579322709 Z M35.098008,1.35454183 L33.5640637,1.35454183 L33.5640637,4.12553785 L35.098008,4.12553785 C35.9227092,4.12553785 36.2113546,3.89462151 36.2113546,3.23486056 L36.2113546,2.24521912 C36.2113546,1.58545817 35.9309562,1.36278884 35.098008,1.36278884 L35.098008,1.35454183 Z"],[12],[13],[1,"\\n      "],[10,"path"],[14,"d","M41.4399602,4.87601594 L39.7905578,4.87601594 L39.7905578,7.35011952 L38.9246215,7.35011952 L38.9246215,0.579322709 L41.4894422,0.579322709 C42.9326693,0.579322709 43.4439841,1.20609562 43.4439841,2.2287251 L43.4439841,3.20187251 C43.5403729,3.92160892 43.0776394,4.59791178 42.3718725,4.76880478 L44.120239,7.30888446 L43.1223506,7.30888446 L41.4399602,4.87601594 Z M41.4399602,1.35454183 L39.7905578,1.35454183 L39.7905578,4.10079681 L41.4399602,4.10079681 C42.2646614,4.10079681 42.5533068,3.86988048 42.5533068,3.21011952 L42.5533068,2.25346614 C42.5698008,1.58545817 42.2894024,1.36278884 41.4564542,1.36278884 L41.4399602,1.35454183 Z"],[12],[13],[1,"\\n      "],[10,"polygon"],[14,"points","46.8087649 7.31713147 45.9840637 7.31713147 45.9840637 0.579322709 46.8087649 0.579322709"],[12],[13],[1,"\\n      "],[10,"path"],[14,"d","M50.9322709,7.41609562 C50.2485334,7.41749872 49.5699834,7.29742608 48.928247,7.0614741 L49.0684462,6.35223108 C49.6711823,6.54568134 50.2993133,6.64851694 50.9322709,6.65737052 C52.0126295,6.65737052 52.2352988,6.37697211 52.2352988,5.61 C52.2352988,4.70282869 52.2352988,4.62035857 50.8415538,4.30697211 C49.1921514,3.94410359 49.0189641,3.63071713 49.0189641,2.23697211 C49.0189641,1.06589641 49.5055378,0.49685259 51.1714343,0.49685259 C51.7856888,0.497823804 52.3976026,0.572582499 52.9940239,0.719521912 L52.9198008,1.45350598 C52.3508265,1.32930718 51.7702971,1.26572539 51.1879283,1.2638247 C50.0828287,1.2638247 49.8849004,1.48649402 49.8849004,2.26171315 C49.8849004,3.1936255 49.8849004,3.23486056 51.2209163,3.56474104 C53.0105179,4.01007968 53.1012351,4.27398406 53.1012351,5.58525896 C53.1342231,6.74808765 52.7878486,7.41609562 50.9322709,7.41609562 Z"],[12],[13],[1,"\\n      "],[10,"polygon"],[14,"points","55.2454582 0.579322709 59.1792829 0.579322709 59.1792829 1.35454183 56.0866534 1.35454183 56.0866534 3.46577689 58.9566135 3.46577689 58.9566135 4.24099602 56.0866534 4.24099602 56.0866534 6.52541833 59.1875299 6.52541833 59.1875299 7.30063745 55.2124701 7.30063745"],[12],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],null],[13]],[],false,["svg","g","path","if","polygon"]]',moduleName:"vault/components/logo-edition.hbs",isStrictMode:!1})
let o=e.default=(r=class extends t.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="version",r=this,(i=l)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}},s=r.prototype,u="version",c=[n.service],d={configurable:!0,enumerable:!0,writable:!0,initializer:null},f={},Object.keys(d).forEach((function(e){f[e]=d[e]})),f.enumerable=!!f.enumerable,f.configurable=!!f.configurable,("value"in f||f.initializer)&&(f.writable=!0),f=c.slice().reverse().reduce((function(e,t){return t(s,u,e)||e}),f),p&&void 0!==f.initializer&&(f.value=f.initializer?f.initializer.call(p):void 0,f.initializer=void 0),l=void 0===f.initializer?(Object.defineProperty(s,u,f),null):f,r)
var s,u,c,d,p,f;(0,t.setComponentTemplate)(a,o)})),define("vault/components/logo-splash",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"xgMci76e",block:'[[[1,"\\n"],[10,0],[14,0,"is-flex-v-centered is-flex-grow-1"],[12],[1,"\\n  "],[10,0],[14,0,"columns is-centered"],[12],[1,"\\n    "],[10,0],[14,0,"column is-narrow has-text-centered has-text-grey-dark has-current-color-fill"],[12],[1,"\\n      "],[8,[39,1],null,null,null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],[],false,["div","logo-edition"]]',moduleName:"vault/components/logo-splash.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/masked-input",["exports","core/components/masked-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/message-error",["exports","core/components/message-error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/mfa/form/choose-method",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,i){function r(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const l=(0,i.createTemplateFactory)({id:"WhcLpbTi",block:'[[[1,"\\n"],[8,[39,0],null,[["@header","@subheader","@description","@renderLogo"],["Verify your identity","Multi-factor authentication is enabled for your account.",[30,0,["description"]],true]],[["additionalContent","actions"],[[[[1,"\\n"],[41,[30,0,["singleConstraint"]],[[[42,[28,[37,4],[[28,[37,4],[[30,0,["nonSelfEnrollMethods"]]],null]],null],null,[[[1,"        "],[8,[39,5],[[24,0,"has-top-margin-s has-bottom-margin-xs"],[4,[38,6],["click",[28,[37,7],[[30,2],[30,0,["singleConstraint"]],[30,1,["id"]]],null]],null]],[["@color","@icon","@isFullWidth","@text"],["secondary",[28,[30,0,["displayIcon"]],[[30,1,["type"]]],null],true,[29,["Verify with ",[28,[30,0,["displayLabel"]],[[30,1,["type"]]],null]]]]],null],[1,"\\n"]],[1]],null],[1,"\\n"],[41,[28,[37,8],[[30,0,["nonSelfEnrollMethods"]],[30,0,["singleConstraint","hasSelfEnrollMethods"]]],null],[[[1,"        "],[8,[39,9],null,[["@gap","@justify","@align"],["16","center","center"]],[["default"],[[[[1,"\\n          "],[10,"hr"],[14,0,"has-background-gray-300 is-flex-1"],[12],[13],[1,"\\n          "],[8,[39,11],null,[["@color"],["faint"]],[["default"],[[[[1,"\\n            Or\\n          "]],[]]]]],[1,"\\n          "],[10,"hr"],[14,0,"has-background-gray-300 is-flex-1"],[12],[13],[1,"\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[42,[28,[37,4],[[28,[37,4],[[30,0,["singleConstraint","selfEnrollMethods"]]],null]],null],null,[[[1,"        "],[8,[39,5],[[24,0,"has-top-margin-xxs has-bottom-margin-xs"],[4,[38,6],["click",[28,[37,7],[[30,2],[30,0,["singleConstraint"]],[30,3,["id"]]],null]],null]],[["@color","@icon","@isFullWidth","@text"],["secondary",[28,[30,0,["displayIcon"]],[[30,3,["type"]]],null],true,[29,["Setup to verify with ",[28,[30,0,["displayLabel"]],[[30,3,["type"]]],null]]]]],null],[1,"\\n"]],[3]],null],[1,"\\n"]],[]],[[[42,[28,[37,4],[[28,[37,4],[[30,0,["selfEnrollConstraints"]]],null]],null],null,[[[41,[30,5],[[[1,"          "],[10,"hr"],[14,0,"has-background-gray-300"],[12],[13],[1,"\\n"]],[]],null],[1,"        "],[8,[39,12],null,[["@fieldType","@constraint","@index","@onSelect"],["select",[30,4],[30,5],[30,2]]],null],[1,"\\n"]],[4,5]],null]],[]]],[1,"  "]],[]],[[[1,"\\n    "],[8,[39,5],[[4,[38,6],["click",[30,6]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n  "]],[]]]]]],["method","@onSelect","method","constraint","index","@onCancel"],false,["mfa/splash-card",":additionalContent","if","each","-track-array","hds/button","on","fn","and","hds/layout/flex","hr","hds/text/body","mfa/form/mfa-field",":actions"]]',moduleName:"vault/components/mfa/form/choose-method.hbs",isStrictMode:!1}),a={totp:{label:"TOTP",icon:"history"},duo:{label:"Duo",icon:"duo-color"},okta:{label:"Okta",icon:"okta-color"},pingid:{label:"PingID",icon:"ping-identity-color"}}
class o extends n.default{constructor(...e){super(...e),r(this,"displayIcon",(e=>a[e].icon)),r(this,"displayLabel",(e=>a[e].label))}get description(){return this.singleConstraint?"Choose one of the following methods to continue:":"Select a method for each enforcement to continue. Choosing a self-enroll method will redirect you to setup your device."}get nonSelfEnrollMethods(){return this.singleConstraint?.methods.filter((e=>!e.self_enrollment_enabled))}get selfEnrollConstraints(){return this.args.constraints.filter((e=>e.hasSelfEnrollMethods))}get singleConstraint(){return 1===this.selfEnrollConstraints?.length?this.selfEnrollConstraints[0]:1===this.args.constraints.length?this.args.constraints[0]:null}}e.default=o,(0,t.setComponentTemplate)(l,o)})),define("vault/components/mfa/form/mfa-field",["exports","@ember/component","@ember/object","@glimmer/component","@ember/template-factory"],(function(e,t,n,i,r){var l
function a(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,r.createTemplateFactory)({id:"GE8DRSkN",block:'[[[1,"\\n"],[41,[28,[37,1],[[30,1],"passcode"],null],[[[1,"  "],[8,[39,2],[[24,"autocomplete","off"],[16,"disabled",[30,2]],[24,3,"passcode"],[24,"placeholder","Enter passcode"],[4,[38,3],["input",[28,[37,4],[[30,0,["setPasscode"]],[30,4]],null]],null]],[["@isInvalid","@value"],[[30,3],[30,4,["passcode"]]]],[["default"],[[[[1,"\\n    "],[8,[30,5,["Label"]],null,null,[["default"],[[[[1,"\\n      "],[1,[30,6]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[5]]]]],[1,"\\n\\n"]],[]],[[[41,[28,[37,1],[[30,1],"select"],null],[[[41,[28,[37,5],[[30,4,["methods","length"]],1],null],[[[1,"    "],[8,[39,6],[[24,0,"has-bottom-margin-m"],[16,3,[30,4,["name"]]],[16,"disabled",[30,2]],[4,[38,3],["change",[28,[37,4],[[30,0,["handleSelect"]],[30,4]],null]],null]],null,[["default"],[[[[1,"\\n      "],[8,[30,7,["Label"]],null,null,[["default"],[[[[1,"Multi-factor Login Enforcement"]],[]]]]],[1,"\\n      "],[8,[30,7,["HelperText"]],null,null,[["default"],[[[[1,"Select which method you would like to verify with."]],[]]]]],[1,"\\n      "],[8,[30,7,["Options"]],null,null,[["default"],[[[[1,"\\n        "],[10,"option"],[14,2,""],[12],[1,"Select one"],[13],[1,"\\n"],[42,[28,[37,9],[[28,[37,9],[[30,4,["methods"]]],null]],null],null,[[[1,"          "],[10,"option"],[15,"selected",[28,[37,1],[[30,8,["id"]],[30,4,["selectedMethod","id"]]],null]],[15,2,[30,8,["id"]]],[12],[1,"\\n            "],[1,[30,8,["label"]]],[1,"\\n"],[41,[30,8,["self_enrollment_enabled"]],[[[1,"              (supports self-enrollment)\\n"]],[]],null],[1,"          "],[13],[1,"\\n"]],[8]],null],[1,"      "]],[]]]]],[1,"\\n    "]],[7]]]]],[1,"\\n"]],[]],null],[1,"\\n"]],[]],[[[41,[28,[37,1],[[30,1],"verified"],null],[[[1,"  "],[8,[39,10],[[24,0,"has-top-bottom-margin-xxs"]],[["@tag","@weight"],["p","semibold"]],[["default"],[[[[1,"\\n    "],[1,[30,6]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[39,10],[[24,0,"has-top-bottom-margin-xxs"]],[["@tag","@color","@size"],["p","faint","100"]],[["default"],[[[[1,"\\n    Your recently enrolled device will be verified along with any other MFA methods.\\n  "]],[]]]]],[1,"\\n  "],[8,[39,11],null,[["@text"],["Verification pending"]],null],[1,"\\n\\n"]],[]],[[[41,[28,[37,1],[[30,1],"push"],null],[[[1,"  "],[8,[39,10],[[24,0,"has-top-bottom-margin-xxs"]],[["@tag","@weight"],["p","semibold"]],[["default"],[[[[1,"\\n    "],[1,[30,6]],[1,"\\n  "]],[]]]]],[1,"\\n\\n"],[41,[51,[30,3]],[[[1,"    "],[8,[39,10],[[24,0,"has-top-bottom-margin-xxs"]],[["@tag","@color","@size"],["p","faint","100"]],[["default"],[[[[1,"\\n      Check device for push notification\\n    "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"]],[]],null]],[]]]],[]]]],[]]],[1,"\\n"],[41,[30,3],[[[1,"  "],[8,[39,13],[[24,0,"has-top-margin-xs"]],[["@type","@color"],["compact","critical"]],[["default"],[[[[1,"\\n    "],[8,[30,9,["Description"]],null,null,[["default"],[[[[1,"Validation failed."]],[]]]]],[1,"\\n  "]],[9]]]]],[1,"\\n"]],[]],null]],["@fieldType","@disabled","@isInvalid","@constraint","F","@label","F","method","A"],false,["if","eq","hds/form/text-input/field","on","fn","gt","hds/form/select/field","option","each","-track-array","hds/text/body","hds/badge","unless","hds/alert"]]',moduleName:"vault/components/mfa/form/mfa-field.hbs",isStrictMode:!1})
let s=e.default=(a((l=class extends i.default{setPasscode(e,t){const{value:n}=t.target
e.setPasscode(n)}handleSelect(e,t){const{value:n}=t.target
this.args.onSelect(e,n)}}).prototype,"setPasscode",[n.action],Object.getOwnPropertyDescriptor(l.prototype,"setPasscode"),l.prototype),a(l.prototype,"handleSelect",[n.action],Object.getOwnPropertyDescriptor(l.prototype,"handleSelect"),l.prototype),l);(0,t.setComponentTemplate)(o,s)})),define("vault/components/mfa/form/self-enroll",["exports","@ember/component","@ember/object","@glimmer/component","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l){var a,o
function s(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function u(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const c=(0,l.createTemplateFactory)({id:"QMQR0sY2",block:'[[[1,"\\n"],[8,[39,0],null,[["@header","@subheader","@subtitle","@description","@renderLogo"],["Set up MFA TOTP to continue","Your organization has enforced MFA TOTP to protect your accounts. Set up to continue.",[52,[51,[30,0,["hasScannedQrCode"]]],"Scan the QR code to continue"],[30,0,["description"]],true]],[["qrCode","additionalContent","actions"],[[[[1,"\\n"],[41,[51,[30,0,["hasScannedQrCode"]]],[[[1,"      "],[8,[39,3],null,[["@qrCode"],[[30,0,["selfEnrollConstraint","qrCode"]]]],null],[1,"\\n"]],[]],null],[1,"  "]],[]],[[[1,"\\n"],[41,[30,0,["hasScannedQrCode"]],[[[1,"      "],[11,"form"],[24,1,"mfa-enroll-form"],[4,[38,7],["submit",[30,0,["handleSubmit"]]],null],[12],[1,"\\n        "],[8,[39,8],null,[["@fieldType","@constraint","@label"],["passcode",[30,0,["selfEnrollConstraint"]],"Enter your one-time code"]],null],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"  "]],[]],[[[1,"\\n"],[41,[30,0,["hasScannedQrCode"]],[[[1,"      "],[8,[39,10],[[24,"form","mfa-enroll-form"],[24,1,"validate"],[24,4,"submit"]],[["@text"],["Verify"]],null],[1,"\\n"]],[]],[[[1,"      "],[8,[39,10],[[4,[38,7],["click",[28,[37,11],[[28,[37,12],[[30,0,["hasScannedQrCode"]]],null],true],null]],null]],[["@text"],["Continue"]],null],[1,"\\n"]],[]]],[1,"    "],[8,[39,10],[[4,[38,7],["click",[30,1]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n  "]],[]]]]]],["@onCancel"],false,["mfa/splash-card","unless",":qrCode","mfa/qr-code-card",":additionalContent","if","form","on","mfa/form/mfa-field",":actions","hds/button","fn","mut"]]',moduleName:"vault/components/mfa/form/self-enroll.hbs",isStrictMode:!1})
let d=e.default=(a=class extends i.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="hasScannedQrCode",r=this,(i=o)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0}),s(this,"findConstraint",(()=>this.args.constraints.find((e=>e.name===this.selfEnrollConstraint?.name))))}get description(){return this.hasScannedQrCode?"To verify your device, enter the code generated from your authenticator.":"Scan the QR code with your authenticator app. If you currently do not have a device on hand, you can copy the MFA secret below and enter it manually."}get selfEnrollConstraint(){return this.args.constraints.find((e=>!!e.qrCode))}handleSubmit(e){e.preventDefault()
const t=this.findConstraint()
t&&(t.qrCode=""),this.args.onVerify()}},o=u(a.prototype,"hasScannedQrCode",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),u(a.prototype,"handleSubmit",[n.action],Object.getOwnPropertyDescriptor(a.prototype,"handleSubmit"),a.prototype),a);(0,t.setComponentTemplate)(c,d)})),define("vault/components/mfa/form/verify",["exports","@ember/component","@glimmer/component","@ember/object","vault/helpers/number-to-word","@ember/template-factory"],(function(e,t,n,i,r,l){var a
function o(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=(0,l.createTemplateFactory)({id:"utmIaXGt",block:'[[[1,"\\n"],[8,[39,0],null,[["@header","@subheader","@description","@renderLogo"],["Verify your identity","Multi-factor authentication is enabled for your account.",[30,0,["description"]],true]],[["alerts","additionalContent","actions"],[[[[1,"\\n    "],[8,[39,2],null,[["@errorMessage"],[[30,1]]],null],[1,"\\n  "]],[]],[[[1,"\\n    "],[11,"form"],[24,1,"mfa-form"],[4,[38,5],["submit",[30,0,["handleSubmit"]]],null],[12],[1,"\\n"],[42,[28,[37,7],[[28,[37,7],[[28,[30,0,["sortConstraints"]],[[30,2]],null]],null]],null],null,[[[41,[30,4],[[[1,"          "],[10,"hr"],[14,0,"has-background-gray-300"],[12],[13],[1,"\\n"]],[]],null],[41,[28,[37,10],[[30,2,["length"]],1],null],[[[1,"          "],[8,[39,11],null,[["@fieldType","@constraint","@index","@onSelect","@disabled"],["select",[30,3],[30,4],[30,5],[28,[30,6],[[30,3,["selectedMethod","id"]]],null]]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,3,["selectedMethod","uses_passcode"]],[[[41,[28,[37,12],[[28,[30,6],[[30,3,["selectedMethod","id"]]],null],[28,[37,13],[[30,1]],null]],null],[[[1,"            "],[8,[39,11],null,[["@fieldType","@label","@isInvalid"],["verified",[30,3,["selectedMethod","label"]],[28,[30,0,["hasValidationError"]],[[30,3,["selectedMethod","id"]]],null]]],null],[1,"\\n"]],[]],[[[1,"            "],[8,[39,11],null,[["@fieldType","@constraint","@disabled","@index","@isInvalid","@label"],["passcode",[30,3],[28,[37,14],[[30,7],[30,8]],null],[30,4],[28,[30,0,["hasValidationError"]],[[30,3,["selectedMethod","id"]]],null],[30,3,["selectedMethod","label"]]]],null],[1,"\\n"]],[]]]],[]],[[[41,[28,[37,14],[[28,[37,15],[[30,3,["methods","length"]],1],null],[30,7]],null],[[[1,"          "],[8,[39,11],null,[["@fieldType","@label","@isInvalid"],["push",[30,3,["selectedMethod","label"]],[28,[30,0,["hasValidationError"]],[[30,3,["selectedMethod","id"]]],null]]],null],[1,"\\n        "]],[]],null]],[]]],[1,"\\n"]],[3,4]],null],[1,"    "],[13],[1,"\\n\\n"],[41,[30,8],[[[1,"      "],[8,[39,16],[[24,0,"has-top-padding-m"]],[["@type","@message"],["danger",[30,9]]],null],[1,"\\n"]],[]],null],[1,"  "]],[]],[[[1,"\\n    "],[8,[39,18],[[16,"disabled",[28,[37,14],[[30,7],[30,8]],null]],[24,"form","mfa-form"],[24,1,"validate"],[24,4,"submit"]],[["@icon","@text"],[[52,[30,7],"loading"],"Verify"]],null],[1,"\\n\\n"],[41,[28,[37,12],[[28,[37,10],[[30,0,["singleConstraint","methods","length"]],1],null],[28,[37,13],[[30,7]],null]],null],[[[1,"      "],[8,[39,18],[[16,"disabled",[30,8]],[4,[38,5],["click",[28,[37,19],[[30,5],[30,0,["singleConstraint"]],""],null]],null]],[["@color","@icon","@iconPosition","@text"],["tertiary","arrow-right","trailing","Try another method"]],null],[1,"\\n"]],[]],[[[1,"      "],[8,[39,18],[[16,"disabled",[30,8]],[4,[38,5],["click",[30,10]],null]],[["@color","@text"],["secondary","Cancel"]],null],[1,"\\n"]],[]]],[1,"\\n"],[41,[30,8],[[[1,"      "],[8,[39,20],[[24,0,"align-self-center"]],[["@type","@icon"],["compact","delay"]],[["default"],[[[[1,"\\n        "],[8,[30,11,["Description"]],null,null,[["default"],[[[[1,[30,8]]],[]]]]],[1,"\\n      "]],[11]]]]],[1,"\\n"]],[]],null],[1,"  "]],[]]]]]],["@error","@constraints","constraint","index","@onSelect","@methodAlreadyEnrolled","@isLoading","@countdown","@codeDelayMessage","@onCancel","A"],false,["mfa/splash-card",":alerts","message-error",":additionalContent","form","on","each","-track-array","if","hr","gt","mfa/form/mfa-field","and","not","or","eq","alert-inline",":actions","hds/button","fn","hds/alert"]]',moduleName:"vault/components/mfa/form/verify.hbs",isStrictMode:!1})
let u=e.default=(a=class extends n.default{constructor(...e){super(...e),o(this,"sortConstraints",(e=>[...e.filter((e=>!e.selectedMethod)),...e.filter((e=>e.selectedMethod))])),o(this,"hasValidationError",(e=>this.args.error?.includes(e)))}get description(){if(this.args.constraints.length>1){return`${(0,r.numberToWord)(this.args.constraints.length,!0)} methods are required for successful authentication.`}return this.singleConstraint?.selectedMethod?.uses_passcode?"Enter your authentication code to log in.":""}get singleConstraint(){return 1===this.args.constraints.length?this.args.constraints[0]:null}handleSubmit(e){e.preventDefault(),this.args.onVerify()}},c=a.prototype,d="handleSubmit",p=[i.action],f=Object.getOwnPropertyDescriptor(a.prototype,"handleSubmit"),m=a.prototype,h={},Object.keys(f).forEach((function(e){h[e]=f[e]})),h.enumerable=!!h.enumerable,h.configurable=!!h.configurable,("value"in h||h.initializer)&&(h.writable=!0),h=p.slice().reverse().reduce((function(e,t){return t(c,d,e)||e}),h),m&&void 0!==h.initializer&&(h.value=h.initializer?h.initializer.call(m):void 0,h.initializer=void 0),void 0===h.initializer&&Object.defineProperty(c,d,h),a)
var c,d,p,f,m,h;(0,t.setComponentTemplate)(s,u)})),define("vault/components/mfa/login-enforcement-list-item",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"YqQvXuAU",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"list-item-row"]],[["@params"],[[28,[37,1],["vault.cluster.access.mfa.enforcements.enforcement",[30,1,["id"]]],null]]],[["default"],[[[[1,"\\n  "],[10,0],[14,0,"level is-mobile"],[12],[1,"\\n    "],[10,0],[14,0,"level-left"],[12],[1,"\\n      "],[10,0],[12],[1,"\\n        "],[8,[39,3],null,[["@name"],["lock"]],null],[1,"\\n        "],[10,1],[14,0,"has-text-weight-semibold has-text-black"],[12],[1,"\\n          "],[1,[30,1,["name"]]],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"level-right is-flex is-paddingless is-marginless"],[12],[1,"\\n      "],[10,0],[14,0,"level-item"],[12],[1,"\\n        "],[8,[39,5],null,[["@isInline","@listPosition"],[true,"bottom-right"]],[["default"],[[[[1,"\\n          "],[8,[30,2,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal","Manage M-F-A enforcement",false]],null],[1,"\\n          "],[8,[30,2,["Interactive"]],null,[["@route","@model"],["vault.cluster.access.mfa.enforcements.enforcement",[30,1,["name"]]]],[["default"],[[[[1,"Details"]],[]]]]],[1,"\\n          "],[8,[30,2,["Interactive"]],null,[["@route","@model"],["vault.cluster.access.mfa.enforcements.enforcement.edit",[30,1,["name"]]]],[["default"],[[[[1,"Edit"]],[]]]]],[1,"\\n        "]],[2]]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]]]],["@model","dd"],false,["linked-block","array","div","icon","span","hds/dropdown"]]',moduleName:"vault/components/mfa/login-enforcement-list-item.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/mfa/method-form",["exports","@ember/component","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","ember-concurrency","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p
function f(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function m(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h=(0,o.createTemplateFactory)({id:"1/XywGF3",block:'[[[1,"\\n"],[11,0],[24,0,"box is-sideless is-fullwidth is-marginless"],[17,1],[12],[1,"\\n"],[42,[28,[37,2],[[28,[37,2],[[30,2,["attrs"]]],null]],null],null,[[[1,"    "],[8,[39,3],null,[["@attr","@model","@modelValidations"],[[30,3],[30,2],[28,[37,4],[[30,4],[30,0,["editValidations"]]],null]]],null],[1,"\\n"]],[3]],null],[13],[1,"\\n"],[41,[30,5],[[[1,"  "],[10,0],[14,0,"field is-grouped-split box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,6],null,null,[["default"],[[[[1,"\\n      "],[8,[39,7],[[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,8],["click",[30,0,["initSave"]]],null]],[["@text","@icon"],["Save",[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n      "],[8,[39,7],[[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,8],["click",[30,0,["cancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[8,[39,9],null,[["@title","@onClose","@isActive","@confirmText","@onConfirm"],[[29,["Edit ",[30,2,["type"]]," configuration?"]],[28,[37,10],[[30,0],[28,[37,11],[[30,0,["isEditModalActive"]]],null],false],null],[30,0,["isEditModalActive"]],[30,2,["type"]],[28,[37,12],[[30,0,["save"]]],null]]],[["default"],[[[[1,"\\n  "],[10,2],[12],[1,"\\n    Editing this configuration will have an impact on all authentication types, methods, groups and entities which make use\\n    of this MFA method. Please make sure you want to make these changes before doing so.\\n  "],[13],[1,"\\n"]],[]]]]]],["&attrs","@model","attr","@validations","@hasActions"],false,["div","each","-track-array","form-field","or","if","hds/button-set","hds/button","on","confirmation-modal","action","mut","perform","p"]]',moduleName:"vault/components/mfa/method-form.hbs",isStrictMode:!1})
let b=e.default=(s=class extends n.default{constructor(...e){super(...e),f(this,"store",u,this),f(this,"flashMessages",c,this),f(this,"editValidations",d,this),f(this,"isEditModalActive",p,this)}*save(){try{yield this.args.model.save(),this.args.onSave()}catch(e){this.flashMessages.danger(e.errors?.join(". ")||e.message)}}async initSave(e){e.preventDefault()
const{isValid:t,state:n}=await this.args.model.validate()
t?this.isEditModalActive=!0:this.editValidations=n}cancel(){this.args.model.rollbackAttributes(),this.args.onClose()}},u=m(s.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(s.prototype,"editValidations",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(s.prototype,"isEditModalActive",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),m(s.prototype,"save",[a.task],Object.getOwnPropertyDescriptor(s.prototype,"save"),s.prototype),m(s.prototype,"initSave",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"initSave"),s.prototype),m(s.prototype,"cancel",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"cancel"),s.prototype),s);(0,t.setComponentTemplate)(h,b)})),define("vault/components/mfa/method-list-item",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"AirvNxoU",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"list-item-row"]],[["@params"],[[28,[37,1],["vault.cluster.access.mfa.methods.method",[30,1,["id"]]],null]]],[["default"],[[[[1,"\\n  "],[10,0],[14,0,"level is-mobile"],[12],[1,"\\n    "],[10,0],[14,0,"level-left"],[12],[1,"\\n      "],[10,0],[14,0,"is-flex-row"],[12],[1,"\\n        "],[8,[39,3],[[24,0,"has-text-grey"]],[["@size","@name"],["24",[30,1,["icon"]]]],null],[1,"\\n        "],[10,0],[12],[1,"\\n          "],[10,1],[14,0,"has-text-weight-semibold has-text-black"],[12],[1,"\\n            "],[1,[30,1,["name"]]],[1,"\\n          "],[13],[1,"\\n          "],[8,[39,5],[[24,0,"has-left-margin-xs"]],[["@text"],[[30,1,["id"]]]],null],[1,"\\n"],[41,[30,1,["namespace_path"]],[[[1,"            "],[10,0],[14,0,"has-top-margin-xs"],[12],[1,"\\n              "],[10,"code"],[14,0,"is-size-9"],[12],[1,"\\n                Namespace:\\n                "],[1,[30,1,["namespace_path"]]],[1,"\\n              "],[13],[1,"\\n            "],[13],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"level-right is-flex is-paddingless is-marginless"],[12],[1,"\\n      "],[10,0],[14,0,"level-item"],[12],[1,"\\n        "],[8,[39,8],null,[["@isInline","@listPosition"],[true,"bottom-right"]],[["default"],[[[[1,"\\n          "],[8,[30,2,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal","Manage M-F-A method",false]],null],[1,"\\n          "],[8,[30,2,["Interactive"]],null,[["@route","@model"],["vault.cluster.access.mfa.methods.method",[30,1,["id"]]]],[["default"],[[[[1,"Details"]],[]]]]],[1,"\\n          "],[8,[30,2,["Interactive"]],null,[["@route","@model"],["vault.cluster.access.mfa.methods.method.edit",[30,1,["id"]]]],[["default"],[[[[1,"Edit"]],[]]]]],[1,"\\n        "]],[2]]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]]]],["@model","dd"],false,["linked-block","array","div","hds/icon","span","hds/badge","if","code","hds/dropdown"]]',moduleName:"vault/components/mfa/method-list-item.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/mfa/mfa-form",["exports","@ember/component","ember-concurrency/async-arrow-runtime","ember","@glimmer/component","@ember/service","@glimmer/tracking","@ember/object","ember-concurrency","vault/utils/error-message","vault/resources/mfa/constraint","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c,d){var p,f,m,h,b,y,g,v,w
function k(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function x(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function P(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=e.TOTP_VALIDATION_ERROR=void 0
const _=(0,d.createTemplateFactory)({id:"c33rOTvq",block:'[[[1,"\\n"],[41,[30,0,["fetchQrCode","isRunning"]],[[[1,"  "],[8,[39,1],null,[["@header","@isLoading"],["Redirecting...",true]],null],[1,"\\n"]],[]],[[[41,[30,0,["currentSelfEnrollConstraint","qrCode"]],[[[1,"  "],[8,[39,2],null,[["@constraints","@onCancel","@onVerify"],[[30,0,["constraints"]],[30,1],[30,0,["checkStateAndValidate"]]]],null],[1,"\\n"]],[]],[[[41,[28,[37,3],[[28,[37,4],[[30,0,["validate","isRunning"]]],null],[30,0,["needsToChoose"]]],null],[[[1,"  "],[8,[39,5],null,[["@constraints","@onCancel","@onSelect"],[[30,0,["constraints"]],[30,1],[30,0,["onSelect"]]]],null],[1,"\\n"]],[]],[[[1,"  "],[8,[39,6],null,[["@codeDelayMessage","@constraints","@countdown","@error","@isLoading","@methodAlreadyEnrolled","@onCancel","@onSelect","@onVerify"],[[30,0,["codeDelayMessage"]],[30,0,["constraints"]],[30,0,["countdown"]],[30,0,["error"]],[28,[37,7],[[30,0,["validate","isRunning"]],[30,2,["isRunning"]]],null],[30,0,["methodAlreadyEnrolled"]],[30,1],[30,0,["onSelect"]],[30,0,["checkStateAndValidate"]]]],null],[1,"\\n"]],[]]]],[]]]],[]]]],["@onCancel","@loginAndTransition"],false,["if","mfa/splash-card","mfa/form/self-enroll","and","not","mfa/form/choose-method","mfa/form/verify","or"]]',moduleName:"vault/components/mfa/mfa-form.hbs",isStrictMode:!1}),T=e.TOTP_VALIDATION_ERROR="The passcode failed to validate. If you entered the correct passcode, please wait for a new code and try again. If the problem persists contact your administrator."
let O=e.default=(p=class extends r.default{constructor(e,t){super(e,t),k(this,"auth",f,this),k(this,"store",m,this),k(this,"version",h,this),k(this,"constraints",b,this),k(this,"codeDelayMessage",y,this),k(this,"countdown",g,this),k(this,"error",v,this),k(this,"enrolledMethods",w,this),x(this,"validate",(0,n.buildTask)((()=>({context:this,generator:function*(){const{authMethodType:e,authMountPath:t,mfaRequirement:n}=this.args.authData,i={mfa_request_id:n.mfa_request_id,mfa_constraints:this.constraints.map((e=>e.validateData))}
try{this.error=""
const n=yield this.auth.totpValidate({clusterId:this.args.clusterId,authMethodType:e,authMountPath:t,mfaRequirement:i})
yield this.args.loginAndTransition.unlinked().perform(n)}catch(r){this.enrolledMethods=new Set
const e=(0,u.default)(r),t=e.includes("code already used"),n=e.includes("maximum TOTP validation attempts"),i=t||n?e:null
if(i){const e=t?"This code has already been used":"Maximum validation attempts exceeded"
this.codeDelayMessage=`${e}. Please wait until a new code is available.`,this.newCodeDelay.perform(i)}else this.singleLoginEnforcement?.selectedMethod?.uses_passcode?this.error=T:this.error=e}}})),null,"validate",null)),x(this,"fetchQrCode",(0,n.buildTask)((()=>({context:this,generator:function*(e,t){if(this.version.isCommunity)return
const n=this.store.adapterFor("application"),{mfaRequirement:i}=this.args.authData
try{const{data:r}=yield n.ajax("/v1/identity/mfa/method/totp/self-enroll","POST",{unauthenticated:!0,data:{mfa_method_id:e,mfa_request_id:i.mfa_request_id}})
if(r?.url)return t.qrCode=r.url,void this.enrolledMethods.add(e)
this.error="There was a problem generating the QR code. Please try again."}catch(r){this.error=(0,u.default)(r)}}})),null,"fetchQrCode",null)),x(this,"newCodeDelay",(0,n.buildTask)((()=>({context:this,generator:function*(e){let t
const n=e.match(/(\d+\w seconds)/)
if(t=n&&n.length?n[0].split(" ")[0]:30,this.countdown=parseInt(t),!i.default.testing)for(;this.countdown>0;)yield(0,s.timeout)(1e3),this.countdown--}})),null,"newCodeDelay",null)),x(this,"methodAlreadyEnrolled",(e=>this.enrolledMethods.has(e)))
const{mfa_constraints:r=[]}=this.args.authData.mfaRequirement
this.constraints=r.map((e=>new c.default(e))),this.checkStateAndValidate()
const l=this.constraints.filter((e=>e.hasSelfEnrollMethods&&1===e.methods.length))
if(1===l.length&&l[0]){const[e]=l,t=e.selfEnrollMethods[0]
t&&this.fetchQrCode.perform(t.id,e)}}get everyConstraintSatisfied(){return this.constraints.every((e=>e.isSatisfied))}get currentSelfEnrollConstraint(){return this.constraints.find((e=>""!==e.qrCode))}get needsToChoose(){const e=this.constraints.filter((e=>e.hasSelfEnrollMethods)).some((e=>!e.selectedMethod)),t=1===this.constraints.length&&!this.constraints.some((e=>e.selectedMethod))
return e||t}get singleLoginEnforcement(){if(1===this.constraints.length){const e=this.constraints[0]
return 1===e?.methods.length?e:null}return null}async onSelect(e,t){e.setSelectedMethod(t)
const n=e.selectedMethod
n?.self_enrollment_enabled&&!this.methodAlreadyEnrolled(n.id)&&await this.fetchQrCode.perform(n.id,e),this.checkStateAndValidate()}checkStateAndValidate(){this.everyConstraintSatisfied&&this.validate.perform()}},f=P(p.prototype,"auth",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=P(p.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=P(p.prototype,"version",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=P(p.prototype,"constraints",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),y=P(p.prototype,"codeDelayMessage",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),g=P(p.prototype,"countdown",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 0}}),v=P(p.prototype,"error",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),w=P(p.prototype,"enrolledMethods",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return new Set}}),P(p.prototype,"onSelect",[o.action],Object.getOwnPropertyDescriptor(p.prototype,"onSelect"),p.prototype),P(p.prototype,"checkStateAndValidate",[o.action],Object.getOwnPropertyDescriptor(p.prototype,"checkStateAndValidate"),p.prototype),p);(0,t.setComponentTemplate)(_,O)})),define("vault/components/mfa/mfa-login-enforcement-form",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","@ember/service","ember-concurrency","vault/helpers/add-to-array","vault/helpers/remove-from-array","vault/resources/auth/method","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c){var d,p,f,m,h,b,y,g,v,w,k
function x(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function P(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function _(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const T=(0,c.createTemplateFactory)({id:"xYKvAAsS",block:'[[[1,"\\n"],[11,0],[17,1],[12],[1,"\\n  "],[8,[39,1],[[24,"for","name"]],[["@label","@subText"],["Name","The name for this enforcement. Giving it a name means that you can refer to it again later. This name will not be editable later."]],null],[1,"\\n  "],[11,"input"],[24,"autocomplete","off"],[24,"spellcheck","false"],[16,2,[30,2,["name"]]],[16,"disabled",[28,[37,3],[[30,2,["isNew"]]],null]],[16,0,[29,["input field ",[52,[30,0,["errors","name","errors"]],"has-error-border"]]]],[24,1,"name"],[4,[38,5],["input",[28,[37,6],[[28,[37,7],["target.value"],null],[28,[37,8],[[28,[37,9],[[30,2,["name"]]],null]],null]],null]],null],[12],[13],[1,"\\n"],[41,[30,0,["errors","name","errors"]],[[[1,"    "],[8,[39,10],null,[["@type","@message"],["danger",[28,[37,11],[", ",[30,0,["errors","name","errors"]]],null]]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[51,[30,3]],[[[1,"    "],[10,0],[14,0,"field"],[12],[1,"\\n      "],[8,[39,1],[[24,"for","methods"]],[["@label","@subText"],["MFA methods","The MFA method(s) that this enforcement will apply to."]],null],[1,"\\n"],[41,[30,2,["mfa_methods","isFulfilled"]],[[[1,"        "],[8,[39,13],null,[["@id","@placeholder","@inputValue","@shouldRenderName","@disallowNewItems","@models","@onChange"],["methods","Type to search for existing MFA methods",[28,[37,14],["id",[30,0,["mfaMethods"]]],null],true,true,[28,[37,15],["mfa-method"],null],[30,0,["onMethodChange"]]]],null],[1,"\\n"]],[]],null],[41,[30,0,["errors","mfa_methods","errors"]],[[[1,"        "],[8,[39,10],null,[["@type","@message"],["danger",[28,[37,11],[", ",[30,0,["errors","mfa_methods","errors"]]],null]]],null],[1,"\\n"]],[]],null],[1,"    "],[13],[1,"\\n"]],[]],null],[1,"\\n  "],[10,0],[12],[1,"\\n    "],[8,[39,1],[[24,"for","targets"]],[["@label","@subText"],["Targets","The list of authentication types, authentication mounts, groups, and/or entities that will require this MFA configuration."]],null],[1,"\\n"],[42,[28,[37,17],[[28,[37,17],[[30,0,["targets"]]],null]],null],null,[[[1,"      "],[10,0],[14,0,"is-flex-center has-border-top-light"],[12],[1,"\\n        "],[8,[39,18],[[24,0,"is-flex-grow-1 has-no-shadow"]],[["@label"],[[30,4,["label"]]]],[["default"],[[[[1,"\\n"],[41,[30,4,["value","id"]],[[[1,"            "],[1,[30,4,["value","name"]]],[1,"\\n            "],[8,[39,19],[[24,0,"has-left-margin-s"]],[["@text"],[[30,4,["value","id"]]]],null],[1,"\\n"]],[]],[[[1,"            "],[1,[30,4,["value"]]],[1,"\\n"]],[]]],[1,"        "]],[]]]]],[1,"\\n        "],[8,[39,20],[[4,[38,5],["click",[28,[37,8],[[30,0,["removeTarget"]],[30,4]],null]],null]],[["@text","@icon","@isIconOnly","@color"],["Remove target","trash",true,"secondary"]],null],[1,"\\n      "],[13],[1,"\\n"]],[4]],null],[1,"    "],[10,0],[15,0,[29,["is-flex-row ",[52,[30,0,["targets"]],"has-top-padding-s has-border-top-light"]]]],[12],[1,"\\n      "],[8,[39,21],[[24,0,"is-marginless"],[24,"aria-label","Target type"]],[["@options","@labelAttribute","@valueAttribute","@selectedValue","@onChange","@name"],[[30,0,["targetTypes"]],"label","type",[30,0,["selectedTargetType"]],[30,0,["onTargetSelect"]],"target-type"]],null],[1,"\\n      "],[10,0],[14,0,"has-left-margin-s is-flex-grow-1"],[12],[1,"\\n"],[41,[28,[37,22],[[30,0,["selectedTargetType"]],"accessor"],null],[[[1,"          "],[8,[39,23],null,[["@value","@showAccessor","@noDefault","@onChange","@filterToken"],[[30,0,["selectedTargetValue"]],true,true,[30,0,["setTargetValue"]],true]],null],[1,"\\n"]],[]],[[[41,[28,[37,22],[[30,0,["selectedTargetType"]],"method"],null],[[[1,"          "],[8,[39,21],[[24,"aria-label","Auth method"]],[["@options","@labelAttribute","@valueAttribute","@isFullwidth","@noDefault","@selectedValue","@onChange","@name"],[[30,0,["authMethods"]],"displayName","value",true,true,[30,0,["selectedTargetValue"]],[30,0,["setTargetValue"]],"Auth method"]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,13],null,[["@id","@placeholder","@options","@parentManageSelected","@shouldRenderName","@selectLimit","@onChange"],["existing-targets","Search for an existing target",[30,0,["searchSelect","options"]],[30,0,["searchSelect","selected"]],true,1,[30,0,["setTargetValue"]]]],null],[1,"\\n        "]],[]]]],[]]],[1,"      "],[13],[1,"\\n      "],[8,[39,20],[[24,0,"has-left-margin-s"],[16,"disabled",[28,[37,3],[[30,0,["selectedTargetValue"]]],null]],[4,[38,5],["click",[30,0,["addTarget"]]],null]],[["@text","@color"],["Add","secondary"]],null],[1,"\\n    "],[13],[1,"\\n"],[41,[30,0,["errors","targets","errors"]],[[[1,"      "],[8,[39,10],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[28,[37,11],[", ",[30,0,["errors","targets","errors"]]],null]]],null],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n"],[41,[51,[30,3]],[[[1,"    "],[10,"hr"],[12],[13],[1,"\\n    "],[10,0],[14,0,"has-top-padding-s"],[12],[1,"\\n      "],[8,[39,25],null,null,[["default"],[[[[1,"\\n        "],[8,[39,20],[[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,5],["click",[28,[37,26],[[30,0,["save"]]],null]],null]],[["@text","@icon"],[[52,[30,2,["isNew"]],"Create","Update"],[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n        "],[8,[39,20],[[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,5],["click",[30,0,["cancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n"]],[]],null],[13]],["&attrs","@model","@isInline","target"],false,["div","form-field-label","input","not","if","on","pipe","pick","fn","mut","alert-inline","join","unless","search-select","map-by","array","each","-track-array","info-table-row","hds/badge","hds/button","select","eq","mount-accessor-select","hr","hds/button-set","perform"]]',moduleName:"vault/components/mfa/mfa-login-enforcement-form.hbs",isStrictMode:!1})
let O=e.default=(d=class extends n.default{constructor(){super(...arguments),x(this,"store",p,this),x(this,"flashMessages",f,this),x(this,"api",m,this),P(this,"targetTypes",[{label:"Authentication mount",type:"accessor",key:"auth_method_accessors"},{label:"Authentication method",type:"method",key:"auth_method_types"},{label:"Group",type:"identity/group",key:"identity_groups"},{label:"Entity",type:"identity/entity",key:"identity_entities"}]),P(this,"searchSelectOptions",null),x(this,"name",h,this),x(this,"targets",b,this),x(this,"selectedTargetType",y,this),x(this,"selectedTargetValue",g,this),x(this,"searchSelect",v,this),x(this,"authMethods",w,this),x(this,"modelErrors",k,this),P(this,"mfaMethods",[]),this.flattenTargets(),this.resetTargetState(),this.fetchAuthMethods(),this.fetchMfaMethods()}async flattenTargets(){for(const{label:e,key:t}of this.targetTypes){const n=(await this.args.model[t]).map((n=>({label:e,key:t,value:n})))
this.targets=(0,o.addManyToArray)(this.targets,n)}}async resetTargetState(){this.selectedTargetValue=null
const e=this.searchSelectOptions||{}
if(!this.searchSelectOptions){const n=["identity/group","identity/entity"]
for(const i of n)try{e[i]=await this.store.query(i,{})}catch(t){e[i]=[]}this.searchSelectOptions=e}this.selectedTargetType.includes("identity")&&(this.searchSelect={selected:[],options:[...e[this.selectedTargetType]]})}async fetchAuthMethods(){const{data:e}=await this.api.sys.authListEnabledMethods()
this.authMethods=this.api.responseObjectToArray(e,"path").map((e=>new u.default(e,this).methodType)).uniq()}async fetchMfaMethods(){this.mfaMethods=await this.args.model.mfa_methods}get selectedTarget(){return this.targetTypes.find((e=>e.type===this.selectedTargetType))}get errors(){return this.args.modelErrors||this.modelErrors}updateModelForKey(e){const t=this.targets.filter((t=>t.key===e)).map((e=>e.value))
this.args.model[e]=t}*save(){this.modelErrors={}
const{isValid:e,state:t}=this.args.model.validate()
if(e)try{yield this.args.model.save(),this.args.onSave()}catch(n){const e=n.errors?n.errors.join(". "):n.message
this.flashMessages.danger(e)}else this.modelErrors=t}async onMethodChange(e){const t=(await this.args.model.mfa_methods).filter((t=>e.includes(t.id))),n=t.map((e=>e.id)),i=e.filter((e=>!n.includes(e))).map((e=>this.store.peekRecord("mfa-method",e)))
this.args.model.mfa_methods=(0,o.addManyToArray)(t,i)}onTargetSelect(e){this.selectedTargetType=e,this.resetTargetState()}setTargetValue(e){const{type:t}=this.selectedTarget
t.includes("identity")?this.selectedTargetValue=this.store.peekRecord(t,e[0]):this.selectedTargetValue=e}addTarget(){const{label:e,key:t}=this.selectedTarget,n=this.selectedTargetValue
this.targets=(0,o.addToArray)(this.targets,{label:e,value:n,key:t}),this.updateModelForKey(t),this.selectedTargetValue=null,this.resetTargetState()}removeTarget(e){this.targets=(0,s.removeFromArray)(this.targets,e),this.updateModelForKey(e.key)}cancel(){this.args.model.rollbackAttributes(),this.args.onClose()}},p=_(d.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=_(d.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=_(d.prototype,"api",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=_(d.prototype,"name",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=_(d.prototype,"targets",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),y=_(d.prototype,"selectedTargetType",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"accessor"}}),g=_(d.prototype,"selectedTargetValue",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),v=_(d.prototype,"searchSelect",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return{options:[],selected:[]}}}),w=_(d.prototype,"authMethods",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),k=_(d.prototype,"modelErrors",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_(d.prototype,"save",[a.task],Object.getOwnPropertyDescriptor(d.prototype,"save"),d.prototype),_(d.prototype,"onMethodChange",[r.action],Object.getOwnPropertyDescriptor(d.prototype,"onMethodChange"),d.prototype),_(d.prototype,"onTargetSelect",[r.action],Object.getOwnPropertyDescriptor(d.prototype,"onTargetSelect"),d.prototype),_(d.prototype,"setTargetValue",[r.action],Object.getOwnPropertyDescriptor(d.prototype,"setTargetValue"),d.prototype),_(d.prototype,"addTarget",[r.action],Object.getOwnPropertyDescriptor(d.prototype,"addTarget"),d.prototype),_(d.prototype,"removeTarget",[r.action],Object.getOwnPropertyDescriptor(d.prototype,"removeTarget"),d.prototype),_(d.prototype,"cancel",[r.action],Object.getOwnPropertyDescriptor(d.prototype,"cancel"),d.prototype),d);(0,t.setComponentTemplate)(T,O)})),define("vault/components/mfa/mfa-login-enforcement-header",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/service","@ember/object","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u
function c(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function d(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,a.createTemplateFactory)({id:"+JVMBCug",block:'[[[1,"\\n"],[41,[30,1],[[[1,"  "],[10,"h3"],[14,0,"title is-5"],[12],[1,"Enforcement"],[13],[1,"\\n"]],[]],[[[1,"  "],[8,[39,2],null,null,[["default"],[[[[1,"\\n    "],[8,[30,2,["top"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,3],null,null,[["default"],[[[[1,"\\n        "],[8,[39,4],null,[["@text","@route"],["Enforcements","vault.cluster.access.mfa.enforcements.index"]],null],[1,"\\n        "],[8,[39,4],null,[["@text","@current"],[[30,3],true]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,2,["levelLeft"]],null,null,[["default"],[[[[1,"\\n      "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n        "],[8,[39,6],null,[["@name","@size"],["lock","24"]],null],[1,"\\n        "],[1,[30,3]],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[2]]]]],[1,"\\n"]],[]]],[10,0],[14,0,"has-border-top-light"],[12],[1,"\\n  "],[10,2],[14,0,"has-top-margin-m"],[12],[1,"\\n"],[41,[30,1],[[[1,"      An enforcement includes the authentication types, authentication methods, groups, and entities that will require this\\n      MFA method. This is optional and can be added later.\\n"]],[]],[[[1,"      An enforcement will define which auth types, auth mounts, groups, and/or entities will require this MFA method. Keep in\\n      mind that only one of these conditions needs to be satisfied. For example, if an authentication method is added here,\\n      all entities and groups which make use of that authentication method will be subject to an MFA request.\\n      "],[8,[39,9],null,[["@path"],["/vault/docs/auth/login-mfa"]],[["default"],[[[[1,"Learn more here."]],[]]]]],[1,"\\n"]],[]]],[1,"  "],[13],[1,"\\n"],[41,[30,1],[[[1,"    "],[10,0],[14,0,"is-flex-row"],[12],[1,"\\n      "],[8,[39,10],null,[["@title","@description","@icon","@value","@groupValue","@onChange"],["Create new","Create a new enforcement for this MFA method.","plus-circle","new",[30,4],[30,5]]],null],[1,"\\n      "],[8,[39,10],null,[["@title","@description","@icon","@value","@groupValue","@disabled","@onChange"],["Use existing","Use an existing enforcement configuration.","list","existing",[30,4],[28,[37,11],[[30,0,["enforcements","length"]]],null],[30,5]]],null],[1,"\\n      "],[8,[39,10],null,[["@title","@description","@icon","@value","@groupValue","@onChange"],["Skip this step","Create MFA without enforcement for now. ","build","skip",[30,4],[30,5]]],null],[1,"\\n    "],[13],[1,"\\n"],[41,[28,[37,12],[[30,4],"existing"],null],[[[1,"      "],[8,[39,13],null,[["@label","@subText","@placeholder","@options","@shouldRenderName","@selectLimit","@onChange"],["Enforcement","Choose the existing enforcement(s) to add to this MFA method.","Search for an existing enforcement",[30,0,["enforcements"]],true,1,[30,0,["onEnforcementSelect"]]]],null],[1,"\\n"]],[]],null]],[]],null],[13]],["@isInline","p","@heading","@radioCardGroupValue","@onRadioCardSelect"],false,["if","h3","page-header","hds/breadcrumb","hds/breadcrumb/item","h1","icon","div","p","doc-link","radio-card","not","eq","search-select"]]',moduleName:"vault/components/mfa/mfa-login-enforcement-header.hbs",isStrictMode:!1})
let f=e.default=(o=class extends n.default{constructor(){super(...arguments),c(this,"store",s,this),c(this,"enforcements",u,this),this.args.isInline&&this.fetchEnforcements()}async fetchEnforcements(){try{this._enforcements=await this.store.query("mfa-login-enforcement",{}),this.enforcements=[...this._enforcements]}catch(e){this.enforcements=[]}}onEnforcementSelect([e]){this.args.onEnforcementSelect(this._enforcements.find((t=>t.name===e)))}},s=d(o.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(o.prototype,"enforcements",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),d(o.prototype,"onEnforcementSelect",[l.action],Object.getOwnPropertyDescriptor(o.prototype,"onEnforcementSelect"),o.prototype),o);(0,t.setComponentTemplate)(p,f)})),define("vault/components/mfa/mfa-setup-step-one",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u,c,d
function p(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function f(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m=(0,a.createTemplateFactory)({id:"E5sGMRZQ",block:'[[[1,"\\n"],[8,[39,0],null,[["@header","@description"],[[30,1],[30,2]]],[["alerts","additionalContent","actions"],[[[[1,"\\n    "],[8,[39,2],null,[["@errorMessage"],[[30,0,["error"]]]],null],[1,"\\n  "]],[]],[[[1,"\\n    "],[11,"form"],[24,1,"mfa-setup-step-one"],[4,[38,5],["submit",[30,0,["verifyUUID"]]],null],[12],[1,"\\n      "],[10,"label"],[14,0,"is-label"],[12],[1,"\\n        Method ID\\n      "],[13],[1,"\\n\\n      "],[10,2],[14,0,"sub-text"],[12],[1,"Enter the UUID for your multi-factor authentication method. This can be provided to you by your\\n        administrator."],[13],[1,"\\n      "],[8,[39,8],[[24,1,"uuid"],[24,3,"uuid"],[24,0,"input"],[24,"autocomplete","off"],[24,"spellcheck","false"]],[["@value"],[[30,0,["UUID"]]]],null],[1,"\\n    "],[13],[1,"\\n  "]],[]],[[[1,"\\n    "],[8,[39,10],[[24,1,"continue"],[24,"form","mfa-setup-step-one"],[16,"disabled",[28,[37,11],[[30,0,["UUID"]]],null]],[24,4,"submit"]],[["@text"],["Verify"]],null],[1,"\\n    "],[8,[39,10],[[24,1,"cancel"],[4,[38,5],["click",[30,0,["redirectPreviousPage"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n  "]],[]]]]]],["@header","@description"],false,["mfa/splash-card",":alerts","message-error",":additionalContent","form","on","label","p","input",":actions","hds/button","is-empty-value"]]',moduleName:"vault/components/mfa/mfa-setup-step-one.hbs",isStrictMode:!1})
let h=e.default=(o=class extends n.default{constructor(...e){super(...e),p(this,"store",s,this),p(this,"error",u,this),p(this,"warning",c,this),p(this,"qrCode",d,this)}redirectPreviousPage(){this.args.restartFlow(),window.history.back()}async verifyUUID(e){e.preventDefault()
const t=await this.postCurrentTokenGenerate()
"stop_progress"===t?this.args.isUUIDVerified(!1):"reset_method"===t?this.args.showWarning(this.warning):this.args.isUUIDVerified(!0)}async postCurrentTokenGenerate(){this.error="",this.warning=""
const e=this.store.adapterFor("mfa-setup")
let t
try{t=await e.currentTokenGenerate({method_id:this.UUID}),this.args.saveUUIDandQrCode(this.UUID,t.data?.url)
const n=t.warnings||[]
if(n.length>0){this.UUID=""
return n.find((e=>e.includes("Entity already has a secret for MFA method")))?(this.warning="A QR code has already been generated, scanned, and MFA set up for this entity. If a new code is required, contact your administrator.","reset_method"):(this.warning=n,"reset_method")}}catch(n){return this.UUID="",this.error=n.errors,"stop_progress"}return t}},s=f(o.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=f(o.prototype,"error",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),c=f(o.prototype,"warning",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),d=f(o.prototype,"qrCode",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f(o.prototype,"redirectPreviousPage",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"redirectPreviousPage"),o.prototype),f(o.prototype,"verifyUUID",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"verifyUUID"),o.prototype),o);(0,t.setComponentTemplate)(m,h)})),define("vault/components/mfa/mfa-setup-step-two",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@ember/template-factory"],(function(e,t,n,i,r,l){var a,o
function s(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u=(0,l.createTemplateFactory)({id:"qHJ9p3cP",block:'[[[1,"\\n"],[8,[39,0],null,[["@header","@description"],[[30,1],[30,2]]],[["alerts","qrCode","actions"],[[[[1,"\\n    "],[8,[39,2],null,[["@errorMessage"],[[30,0,["error"]]]],null],[1,"\\n"],[41,[30,3],[[[1,"      "],[8,[39,4],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","highlight"]],[["default"],[[[[1,"\\n        "],[8,[30,4,["Title"]],null,null,[["default"],[[[[1,"MFA enabled"]],[]]]]],[1,"\\n        "],[8,[30,4,["Description"]],null,null,[["default"],[[[[1,[30,3]]],[]]]]],[1,"\\n      "]],[4]]]]],[1,"\\n"]],[]],null],[1,"  "]],[]],[[[1,"\\n"],[41,[30,5],[[[1,"      "],[8,[39,6],null,[["@qrCode"],[[30,5]]],null],[1,"\\n"]],[]],null],[1,"  "]],[]],[[[1,"\\n    "],[8,[39,8],[[24,1,"restart"],[4,[38,9],["click",[30,0,["restartSetup"]]],null]],[["@text","@color"],["Restart setup","critical"]],null],[1,"\\n    "],[8,[39,8],[[24,1,"cancel"],[4,[38,9],["click",[30,0,["redirectPreviousPage"]]],null]],[["@text"],["Done"]],null],[1,"\\n  "]],[]]]]]],["@header","@description","@warning","A","@qrCode"],false,["mfa/splash-card",":alerts","message-error","if","hds/alert",":qrCode","mfa/qr-code-card",":actions","hds/button","on"]]',moduleName:"vault/components/mfa/mfa-setup-step-two.hbs",isStrictMode:!1})
let c=e.default=(a=class extends n.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="store",r=this,(i=o)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}redirectPreviousPage(){this.args.restartFlow(),window.history.back()}async restartSetup(){this.error=null
const e=this.store.adapterFor("mfa-setup")
try{await e.adminDestroy({entity_id:this.args.entityId,method_id:this.args.uuid})}catch(t){return this.error=t.errors,"stop_progress"}this.args.restartFlow()}},o=s(a.prototype,"store",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),s(a.prototype,"redirectPreviousPage",[r.action],Object.getOwnPropertyDescriptor(a.prototype,"redirectPreviousPage"),a.prototype),s(a.prototype,"restartSetup",[r.action],Object.getOwnPropertyDescriptor(a.prototype,"restartSetup"),a.prototype),a);(0,t.setComponentTemplate)(u,c)})),define("vault/components/mfa/nav",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"tAO5D8hW",block:'[[[1,"\\n"],[10,0],[14,0,"tabs-container box is-sideless is-fullwidth is-paddingless is-marginless"],[12],[1,"\\n  "],[10,"nav"],[14,0,"tabs"],[14,"aria-label","navigation for managing MFA"],[12],[1,"\\n    "],[10,"ul"],[12],[1,"\\n      "],[8,[39,3],null,[["@route"],["vault.cluster.access.mfa.methods"]],[["default"],[[[[1,"\\n        Methods\\n      "]],[]]]]],[1,"\\n      "],[8,[39,3],null,[["@route"],["vault.cluster.access.mfa.enforcements"]],[["default"],[[[[1,"\\n        Enforcements\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],[],false,["div","nav","ul","link-to"]]',moduleName:"vault/components/mfa/nav.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/mfa/qr-code-card",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"dINSVUh3",block:'[[[1,"\\n"],[8,[39,0],null,[["@justify","@align"],["space-between","center"]],[["default"],[[[[1,"\\n  "],[8,[39,1],[[24,0,"has-padding-l"]],[["@hasBorder"],[true]],[["default"],[[[[1,"\\n    "],[8,[39,2],null,[["@text","@colorLight","@width","@height","@correctLevel"],[[30,1],"#F7F7F7",175,175,"L"]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[39,3],null,[["@tag","@weight"],["p","semibold"]],[["default"],[[[[1,"\\n    Or\\n  "]],[]]]]],[1,"\\n  "],[8,[39,4],null,[["@text","@textToCopy"],["Copy TOTP setup URL",[30,1]]],null],[1,"\\n"]],[]]]]],[1,"\\n\\n"],[8,[39,5],[[24,0,"has-top-padding-s"]],[["@color","@type"],["warning","compact"]],[["default"],[[[[1,"\\n  "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,"\\n    For your security, this code is only shown once. Please scan or copy the setup URL into your authenticator app now.\\n  "]],[]]]]],[1,"\\n"]],[2]]]]]],["@qrCode","A"],false,["hds/layout/flex","hds/card/container","qr-code","hds/text/body","hds/copy/button","hds/alert"]]',moduleName:"vault/components/mfa/qr-code-card.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/mfa/splash-card",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"AoN4D6S9",block:'[[[1,"\\n"],[1,"\\n"],[8,[39,0],[[24,0,"wide-content"],[17,1]],null,[["header","content","footer"],[[[[1,"\\n"],[41,[30,2],[[[1,"      "],[10,0],[14,0,"is-flex-v-centered has-bottom-margin-xxl"],[12],[1,"\\n        "],[10,0],[14,0,"brand-icon-large"],[12],[1,"\\n          "],[8,[39,4],null,[["@name","@size","@stretched"],["vault","24",true]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"    "],[10,"h1"],[14,0,"title is-4"],[12],[1,[30,3]],[13],[1,"\\n"],[41,[30,4],[[[1,"      "],[8,[39,6],[[24,0,"has-top-bottom-margin-xxs"]],[["@tag"],["h2"]],[["default"],[[[[1,"\\n        "],[1,[30,4]],[1,"\\n      "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "]],[]],[[[1,"\\n    "],[10,0],[14,0,"has-padding-l"],[12],[1,"\\n\\n"],[41,[30,5],[[[1,"        "],[8,[39,8],[[24,0,"is-medium-height"]],[["@justify","@align"],["center","center"]],[["default"],[[[[1,"\\n          "],[8,[39,9],null,null,null],[1,"\\n        "]],[]]]]],[1,"\\n"]],[]],[[[41,[30,6],[[[1,"          "],[8,[39,6],[[24,0,"has-top-bottom-margin-xxs"]],[["@tag","@weight"],["p","semibold"]],[["default"],[[[[1,"\\n            "],[1,[30,6]],[1,"\\n          "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,7],[[[1,"          "],[8,[39,6],[[24,0,"has-bottom-margin-l"]],[["@tag"],["p"]],[["default"],[[[[1,"\\n            "],[1,[30,7]],[1,"\\n          "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[48,[30,8]],[[[1,"          "],[18,8,null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[48,[30,9]],[[[1,"          "],[18,9,null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[48,[30,10]],[[[1,"          "],[18,10,null],[1,"\\n"]],[]],null]],[]]],[1,"    "],[13],[1,"\\n  "]],[]],[[[1,"\\n    "],[8,[39,13],[[24,0,"has-top-padding-m"]],null,[["default"],[[[[1,"\\n      "],[18,11,null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]]],["&attrs","@renderLogo","@header","@subheader","@isLoading","@subtitle","@description","&alerts","&qrCode","&additionalContent","&actions"],false,["splash-page",":header","if","div","icon","h1","hds/text/body",":content","hds/layout/flex","vault-logo-spinner","has-block","yield",":footer","hds/button-set"]]',moduleName:"vault/components/mfa/splash-card.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/modal-dialog",["exports","ember-modal-dialog/components/modal-dialog"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/modal-form/oidc-assignment-template",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u
function c(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function d(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,a.createTemplateFactory)({id:"f4Sr8TRY",block:'[[[1,"\\n"],[8,[39,0],null,[["@onSave","@model","@onCancel"],[[30,0,["onSave"]],[30,0,["assignment"]],[30,1]]],null]],["@onCancel"],false,["oidc/assignment-form"]]',moduleName:"vault/components/modal-form/oidc-assignment-template.hbs",isStrictMode:!1})
let f=e.default=(o=class extends n.default{constructor(){super(...arguments),c(this,"store",s,this),c(this,"assignment",u,this),this.assignment=this.store.createRecord("oidc/assignment",{name:this.args.nameInput})}onSave(e){this.args.onSave(e),this.assignment=null}},s=d(o.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(o.prototype,"assignment",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d(o.prototype,"onSave",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"onSave"),o.prototype),o);(0,t.setComponentTemplate)(p,f)})),define("vault/components/modal-form/oidc-key-template",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u
function c(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function d(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const p=(0,a.createTemplateFactory)({id:"3LNR6v5b",block:'[[[1,"\\n"],[8,[39,0],null,[["@onSave","@model","@onCancel","@isModalForm"],[[30,0,["onSave"]],[30,0,["key"]],[30,1],true]],null]],["@onCancel"],false,["oidc/key-form"]]',moduleName:"vault/components/modal-form/oidc-key-template.hbs",isStrictMode:!1})
let f=e.default=(o=class extends n.default{constructor(){super(...arguments),c(this,"store",s,this),c(this,"key",u,this),this.key=this.store.createRecord("oidc/key",{name:this.args.nameInput})}onSave(e){this.args.onSave(e),this.key=null}},s=d(o.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=d(o.prototype,"key",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),d(o.prototype,"onSave",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"onSave"),o.prototype),o);(0,t.setComponentTemplate)(p,f)})),define("vault/components/modal-form/policy-template",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,a.createTemplateFactory)({id:"pVVggGRk",block:'[[[1,"\\n"],[41,[30,0,["policy","policyType"]],[[[1,"  "],[8,[39,1],null,null,[["default"],[[[[1,"\\n    "],[8,[30,1,["Tab"]],null,null,[["default"],[[[[1,"\\n      Your Policy\\n    "]],[]]]]],[1,"\\n    "],[8,[30,1,["Tab"]],[[24,"Tab",""]],null,[["default"],[[[[1,"\\n      Example Policy\\n    "]],[]]]]],[1,"\\n\\n    "],[8,[30,1,["Panel"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@onSave","@model","@onCancel"],[[30,0,["onSave"]],[30,0,["policy"]],[30,2]]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,1,["Panel"]],[[24,0,"has-top-padding-m"]],null,[["default"],[[[[1,"\\n      "],[8,[39,3],null,[["@policyType"],[[30,0,["policy","policyType"]]]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[1]]]]],[1,"\\n"]],[]],[[[1,"  "],[8,[39,4],null,[["@name","@label","@options","@isFullwidth","@selectedValue","@onChange","@noDefault"],["policyType","Type",[30,0,["policyOptions"]],true,[30,0,["policy","policyType"]],[30,0,["setPolicyType"]],true]],null],[1,"\\n  "],[8,[39,5],null,[["@title","@message"],["No policy type selected","Select a policy type to continue creating."]],null],[1,"\\n"]],[]]]],["T","@onCancel"],false,["if","hds/tabs","policy-form","policy-example","select","empty-state"]]',moduleName:"vault/components/modal-form/policy-template.hbs",isStrictMode:!1})
let m=e.default=(o=class extends n.default{constructor(...e){super(...e),d(this,"store",s,this),d(this,"version",u,this),d(this,"policy",c,this)}get policyOptions(){return[{label:"ACL Policy",value:"acl",isDisabled:!1},{label:"Role Governing Policy",value:"rgp",isDisabled:!this.version.hasSentinel}]}setPolicyType(e){this.policy&&this.policy.unloadRecord(),this.policy=this.store.createRecord(`policy/${e}`,{name:this.args.nameInput})}onSave(e){this.args.onSave(e),this.policy=null}},s=p(o.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"version",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(o.prototype,"policy",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),p(o.prototype,"setPolicyType",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"setPolicyType"),o.prototype),p(o.prototype,"onSave",[i.action],Object.getOwnPropertyDescriptor(o.prototype,"onSave"),o.prototype),o);(0,t.setComponentTemplate)(f,m)})),define("vault/components/mount-accessor-select",["exports","@ember/component","@glimmer/component","@ember/service","ember-concurrency","@ember/object","vault/resources/auth/method","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u
function c(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d=(0,o.createTemplateFactory)({id:"0JfeL/IX",block:'[[[1,"\\n"],[11,0],[17,1],[12],[1,"\\n"],[41,[30,2],[[[1,"    "],[10,"label"],[15,"for",[30,3]],[14,0,"is-label"],[12],[1,"\\n      "],[1,[30,2]],[1,"\\n"],[41,[30,4],[[[1,"        "],[8,[39,3],null,null,[["default"],[[[[1,"\\n          "],[10,1],[12],[1,[30,4]],[13],[1,"\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"    "],[13],[1,"\\n"]],[]],null],[41,[30,0,["authMethods","isRunning"]],[[[1,"    "],[10,0],[12],[1,"\\n      "],[10,1],[14,0,"loader is-inline-block"],[12],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[41,[30,0,["authMethods","last","value"]],[[[1,"    "],[10,0],[14,0,"control is-expanded"],[12],[1,"\\n      "],[10,0],[14,0,"select is-fullwidth"],[12],[1,"\\n        "],[11,"select"],[16,"aria-label",[28,[37,6],[[30,2],"Select a mount accessor"],null]],[16,3,[30,3]],[16,1,[30,3]],[4,[38,7],["change",[30,0,["change"]]],null],[12],[1,"\\n"],[41,[30,0,["noDefault"]],[[[1,"            "],[10,"option"],[14,2,""],[12],[1,"Select one"],[13],[1,"\\n"]],[]],null],[42,[28,[37,10],[[28,[37,10],[[30,0,["authMethods","last","value"]]],null]],null],null,[[[41,[30,0,["filterToken"]],[[[41,[28,[37,11],[[30,5,["id"]],"token"],null],[[[1,"                "],[10,"option"],[15,"selected",[28,[37,12],[[30,6],[30,5,["accessor"]]],null]],[15,2,[30,5,["accessor"]]],[12],[1,"\\n                  "],[1,[30,5,["path"]]],[1,"\\n                  ("],[1,[52,[30,7],[30,5,["accessor"]],[30,5,["type"]]]],[1,")\\n                "],[13],[1,"\\n"]],[]],null]],[]],[[[1,"              "],[10,"option"],[15,"selected",[28,[37,12],[[30,6],[30,5,["accessor"]]],null]],[15,2,[30,5,["accessor"]]],[12],[1,"\\n                "],[1,[30,5,["path"]]],[1,"\\n                ("],[1,[52,[30,7],[30,5,["accessor"]],[30,5,["type"]]]],[1,")\\n              "],[13],[1,"\\n"]],[]]]],[5]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[1,"    "],[11,"input"],[16,3,[30,3]],[16,1,[30,3]],[24,0,"input"],[16,2,[30,6]],[24,"placeholder","Mount accessor"],[4,[38,7],["change",[30,0,["change"]]],null],[12],[13],[1,"\\n  "]],[]]]],[]]],[13]],["&attrs","@label","@name","@helpText","method","@value","@showAccessor"],false,["div","if","label","info-tooltip","span","select","or","on","option","each","-track-array","not-eq","eq","input"]]',moduleName:"vault/components/mount-accessor-select.hbs",isStrictMode:!1})
let p=e.default=(s=class extends n.default{get filterToken(){return this.args.filterToken||!1}get noDefault(){return this.args.noDefault||!1}constructor(){var e,t,n,i
super(...arguments),e=this,t="api",i=this,(n=u)&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0}),this.authMethods.perform()}*authMethods(){const{data:e}=yield this.api.sys.authListEnabledMethods(),t=this.api.responseObjectToArray(e,"path").map((e=>new a.default(e,this)))
if(!this.args.value&&!this.args.noDefault){const e=t[0].accessor
this.args.onChange(e)}return t}change(e){this.args.onChange(e.target.value)}},u=c(s.prototype,"api",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c(s.prototype,"authMethods",[r.task],Object.getOwnPropertyDescriptor(s.prototype,"authMethods"),s.prototype),c(s.prototype,"change",[l.action],Object.getOwnPropertyDescriptor(s.prototype,"change"),s.prototype),s);(0,t.setComponentTemplate)(d,p)})),define("vault/components/mount-backend-form",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/service","@ember/object","ember-concurrency","@ember/test-waiters","vault/utils/all-engines-metadata","vault/utils/plugin-catalog-helpers","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c){var d,p,f,m,h,b,y,g
function v(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function w(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const k=(0,c.createTemplateFactory)({id:"NlT3muqf",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3 title-with-icon"],[12],[1,"\\n"],[41,[30,0,["showEnable"]],[[[44,[[28,[37,4],["type",[30,0,["mountForm","type"]],[30,2]],null]],[[[41,[30,3,["glyph"]],[[[1,"            "],[8,[39,5],[[24,0,"has-text-grey-light"]],[["@name","@size"],[[30,3,["glyph"]],"24"]],null],[1,"\\n"]],[]],null],[41,[28,[37,6],[[30,4],"secret"],null],[[[1,"            "],[1,[28,[35,7],["Enable ",[28,[37,8],[[30,3,["displayName"]],[30,0,["mountForm","type"]]],null]," Secrets Engine"],null]],[1,"\\n"]],[]],[[[1,"            "],[1,[28,[35,7],["Enable ",[28,[37,8],[[30,3,["displayName"]],[30,0,["mountForm","type"]]],null]," Authentication Method"],null]],[1,"\\n"]],[]]]],[3]]]],[]],[[[41,[28,[37,6],[[30,4],"secret"],null],[[[1,"        Enable a Secrets Engine\\n"]],[]],[[[1,"        Enable an Authentication Method\\n      "]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[10,0],[14,0,"box is-sideless is-bottomless is-fullwidth is-marginless"],[12],[1,"\\n  "],[8,[39,10],null,[["@mode","@noun"],["enable",[52,[28,[37,6],[[30,4],"secret"],null],"Secret Engine","Auth Method"]]],null],[1,"\\n  "],[8,[39,11],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n"],[41,[30,0,["mountForm","type"]],[[[1,"    "],[11,"form"],[4,[38,13],["submit",[28,[37,14],[[30,0,["mountBackend"]]],null]],null],[12],[1,"\\n      "],[8,[39,15],null,[["@model","@groupName","@renderGroup","@modelValidations","@onKeyUp"],[[30,0,["mountForm"]],"formFieldGroups","default",[30,0,["modelValidations"]],[30,0,["onKeyUp"]]]],null],[1,"\\n\\n      "],[8,[39,15],null,[["@model","@renderGroup","@groupName"],[[30,0,["mountForm"]],"Method Options","formFieldGroups"]],[["identityTokenKey"],[[[[1,"\\n          "],[8,[39,17],null,[["@id","@fallbackComponent","@inputValue","@onChange","@models","@selectLimit","@modalFormTemplate","@placeholder","@fallbackComponentPlaceholder","@modalSubtext"],["key","input-search",[30,0,["mountForm","data","config","identity_token_key"]],[30,0,["handleIdentityTokenKeyChange"]],[28,[37,18],["oidc/key"],null],"1","modal-form/oidc-key-template","Search for an existing OIDC key, or type a new key name to create it.","Input a key name","This key will be created in the OIDC key path."]],null],[1,"\\n        "]],[]]]]],[1,"\\n\\n      "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,19],[[16,"disabled",[30,0,["mountBackend","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[28,[37,6],[[30,4],"secret"],null],"Enable engine","Enable method"],[52,[30,0,["mountBackend","isRunning"]],"loading"]]],null],[1,"\\n        "],[13],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,19],[[4,[38,13],["click",[28,[37,20],[[30,0,["setMountType"]],""],null]],null]],[["@text","@color"],["Back","secondary"]],null],[1,"\\n        "],[13],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"          "],[10,0],[14,0,"control"],[12],[1,"\\n            "],[8,[39,21],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n          "],[13],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[1,"    "],[8,[39,22],null,[["@setMountType","@mountCategory","@pluginCatalogData","@pluginCatalogError"],[[30,0,["setMountType"]],[30,4],[30,5,["pluginCatalogData"]],[30,5,["pluginCatalogError"]]]],null],[1,"\\n"]],[]]],[13]],["p","@mountTypes","typeInfo","@mountCategory","@mountModel"],false,["page-header","h1","if","let","find-by","icon","eq","concat","or","div","namespace-reminder","message-error","form","on","perform","form-field-groups",":identityTokenKey","search-select-with-modal","array","hds/button","fn","alert-inline","mount-backend/type-form"]]',moduleName:"vault/components/mount-backend-form.hbs",isStrictMode:!1}),x=u.MOUNT_CATEGORIES.AUTH
let P=e.default=(d=class extends n.default{get mountForm(){return this.args.mountModel}get showEnable(){return!!this.mountForm.type}constructor(e,t){super(e,t),v(this,"store",p,this),v(this,"flashMessages",f,this),v(this,"capabilities",m,this),v(this,"api",h,this),v(this,"modelValidations",b,this),v(this,"invalidFormAlert",y,this),v(this,"errorMessage",g,this)}checkPathChange(e){if(!e)return
const{data:t}=this.mountForm,n=(0,s.filterEnginesByMountCategory)({mountCategory:x,isEnterprise:!0}).map((e=>e.type))
t.path&&!n.includes(t.path)||(t.path=e)}checkModelWarnings(){const e=this.mountForm,{state:t}=e.toJSON()
for(const n in t)t[n]&&(t[n].errors=[])
this.modelValidations=t,this.invalidFormAlert=null}async onMountError(e,t,n){403===e?this.flashMessages.danger("You do not have access to the sys/auth endpoint. The auth method was not mounted."):this.errorMessage=t?t.map((e=>"object"==typeof e?e.title||e.message||JSON.stringify(e):e)):n||"An error occurred, check the vault logs."}*mountBackend(e){e.preventDefault()
const t=this.mountForm,{type:n}=t,{path:i}=t.data,{isValid:r,state:l,invalidFormMessage:a,data:o}=t.toJSON()
if(!r)return this.modelValidations=l,void(this.invalidFormAlert=a)
try{yield this.api.sys.authEnableMethod(i,o),this.flashMessages.success(`Successfully mounted the ${t.type} auth method at ${i}.`),this.args.onMountSuccess(n,i,!1)}catch(s){const{status:e,response:t,message:n}=yield this.api.parseError(s)
this.onMountError(e,t.errors,n)}}onKeyUp(e,t){(0,l.set)(this.mountForm.data,e,t),this.checkModelWarnings()}setMountType(e){this.mountForm.type=e,this.checkPathChange(e)}handleIdentityTokenKeyChange(e){const{config:t}=this.mountForm.data
t.identity_token_key=Array.isArray(e)?e[0]:e}},p=w(d.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=w(d.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=w(d.prototype,"capabilities",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=w(d.prototype,"api",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=w(d.prototype,"modelValidations",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),y=w(d.prototype,"invalidFormAlert",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),g=w(d.prototype,"errorMessage",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),w(d.prototype,"mountBackend",[a.task,o.waitFor],Object.getOwnPropertyDescriptor(d.prototype,"mountBackend"),d.prototype),w(d.prototype,"onKeyUp",[l.action],Object.getOwnPropertyDescriptor(d.prototype,"onKeyUp"),d.prototype),w(d.prototype,"setMountType",[l.action],Object.getOwnPropertyDescriptor(d.prototype,"setMountType"),d.prototype),w(d.prototype,"handleIdentityTokenKeyChange",[l.action],Object.getOwnPropertyDescriptor(d.prototype,"handleIdentityTokenKeyChange"),d.prototype),d);(0,t.setComponentTemplate)(k,P)})),define("vault/components/mount-backend/type-form",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","core/utils/keys","vault/utils/all-engines-metadata","vault/utils/plugin-catalog-helpers","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f,m
function h(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function b(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,u.createTemplateFactory)({id:"gU5e6KPM",block:'[[[1,"\\n"],[41,[28,[37,1],[[30,1],[28,[37,2],[[30,2],[30,0,["secretMountCategory"]]],null]],null],[[[1,"  "],[10,0],[14,0,"has-bottom-padding-m"],[12],[1,"\\n    "],[8,[39,4],null,[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n      "],[8,[30,3,["Title"]],null,null,[["default"],[[[[1,"Plugin information unavailable"]],[]]]]],[1,"\\n      "],[8,[30,3,["Description"]],null,null,[["default"],[[[[1,"\\n        Unable to fetch current plugin information. Using static plugin data instead. Some plugins may not show current\\n        details.\\n      "]],[]]]]],[1,"\\n    "]],[3]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[42,[28,[37,6],[[28,[37,6],[[30,0,["pluginCategoriesList"]]],null]],null],null,[[[44,[[28,[30,0,["getMountTypesByCategory"]],[[30,4]],null]],[[[41,[28,[37,8],[[30,5,["enabled","length"]],[30,5,["disabled","length"]]],null],[[[1,"      "],[10,0],[14,0,"has-top-padding-m has-bottom-padding-s"],[12],[1,"\\n        "],[8,[39,9],[[24,"size","400"],[24,0,"is-flex align-items-center"]],[["@tag"],["h2"]],[["default"],[[[[1,"\\n          "],[1,[28,[35,10],[[30,4]],null]],[1,"\\n"],[41,[28,[37,2],[[30,4],"external"],null],[[[1,"            "],[8,[39,11],[[24,0,"has-left-margin-xs"],[4,[38,12],["click",[30,0,["openExternalPluginsHelp"]]],null]],[["@text","@color","@icon","@size","@isIconOnly","@ariaLabel"],["","tertiary","info","small",true,"Information about external plugins"]],null],[1,"\\n"]],[]],null],[1,"        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"flex row-wrap row-gap-16 column-gap-16 has-bottom-padding-m"],[12],[1,"\\n"],[42,[28,[37,6],[[28,[37,6],[[30,5,["enabled"]]],null]],null],null,[[[1,"          "],[8,[39,13],null,[["@type","@setMountType"],[[30,6],[30,7]]],null],[1,"\\n"]],[6]],null],[1,"\\n"],[41,[28,[37,1],[[30,5,["enabled","length"]],[30,5,["disabled","length"]]],null],[[[1,"          "],[10,0],[14,0,"selectable-engines-vertical-divider has-top-bottom-margin-12"],[12],[13],[1,"\\n"]],[]],null],[1,"\\n"],[42,[28,[37,6],[[28,[37,6],[[30,5,["disabled"]]],null]],null],null,[[[1,"          "],[8,[39,14],null,[["@type","@handleDisabledPluginClick","@handleDisabledPluginKeyDown"],[[30,8],[30,0,["handleDisabledPluginClick"]],[30,0,["handleDisabledPluginKeyDown"]]]],null],[1,"\\n"]],[8]],null],[1,"      "],[13],[1,"\\n"]],[]],null]],[5]]]],[4]],null],[1,"\\n"],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n  "],[8,[39,11],null,[["@text","@color","@route"],["Cancel","secondary",[52,[28,[37,2],[[30,2],"secret"],null],"vault.cluster.secrets.backends","vault.cluster.access.methods"]]],null],[1,"\\n"],[13],[1,"\\n\\n"],[8,[39,15],null,[["@isOpen","@plugin","@pluginType","@onClose"],[[30,0,["showFlyout"]],[30,0,["flyoutPlugin"]],[30,0,["flyoutPluginType"]],[30,0,["closeFlyout"]]]],null]],["@pluginCatalogError","@mountCategory","A","category","categorized","type","@setMountType","type"],false,["if","and","eq","div","hds/alert","each","-track-array","let","or","hds/text/display","capitalize","hds/button","on","enabled-plugin-card","disabled-plugin-card","plugin-documentation-flyout"]]',moduleName:"vault/components/mount-backend/type-form.hbs",isStrictMode:!1})
let g=e.default=(c=class extends n.default{constructor(...e){super(...e),h(this,"version",d,this),h(this,"showFlyout",p,this),h(this,"flyoutPlugin",f,this),h(this,"flyoutPluginType",m,this)}get secretEngines(){const e=(0,o.filterEnginesByMountCategory)({mountCategory:s.MOUNT_CATEGORIES.SECRET,isEnterprise:!!this.version?.isEnterprise})
if(this.args.pluginCatalogData){const t=this.args.pluginCatalogData?.detailed?.filter((e=>e?.type===s.PLUGIN_TYPES.SECRET))||[],n=this.args.pluginCatalogData?.detailed?.filter((e=>e?.type===s.PLUGIN_TYPES.DATABASE))||[]
return(0,s.enhanceEnginesWithCatalogData)(e,t,n)}return e}get authMethods(){return(0,o.filterEnginesByMountCategory)({mountCategory:s.MOUNT_CATEGORIES.AUTH,isEnterprise:!!this.version?.isEnterprise})}get mountTypes(){return this.args.mountCategory===s.MOUNT_CATEGORIES.SECRET?this.secretEngines||[]:this.authMethods||[]}get pluginCategoriesList(){return[s.PLUGIN_CATEGORIES.GENERIC,s.PLUGIN_CATEGORIES.CLOUD,s.PLUGIN_CATEGORIES.INFRA]}get secretMountCategory(){return s.MOUNT_CATEGORIES.SECRET}getMountTypesByCategory(e){try{if(!this.args)return{enabled:[],disabled:[]}
const t=this.mountTypes
if(!t||!Array.isArray(t))return{enabled:[],disabled:[]}
const n=t.filter((t=>t?.pluginCategory===e))
return(0,s.categorizeEnginesByStatus)(n)}catch(t){return{enabled:[],disabled:[]}}}handleDisabledPluginKeyDown(e,t){t.key!==a.default.ENTER&&t.key!==a.default.SPACE||(t.preventDefault(),this.handleDisabledPluginClick(e))}handleDisabledPluginClick(e){this.showFlyout=!0,this.flyoutPlugin=e,this.flyoutPluginType=this.args?.mountCategory}openExternalPluginsHelp(){this.showFlyout=!0,this.flyoutPlugin=null,this.flyoutPluginType="secret"}closeFlyout(){this.showFlyout=!1,this.flyoutPlugin=null,this.flyoutPluginType=null}},d=b(c.prototype,"version",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(c.prototype,"showFlyout",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),f=b(c.prototype,"flyoutPlugin",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),m=b(c.prototype,"flyoutPluginType",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b(c.prototype,"getMountTypesByCategory",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"getMountTypesByCategory"),c.prototype),b(c.prototype,"handleDisabledPluginKeyDown",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"handleDisabledPluginKeyDown"),c.prototype),b(c.prototype,"handleDisabledPluginClick",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"handleDisabledPluginClick"),c.prototype),b(c.prototype,"openExternalPluginsHelp",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"openExternalPluginsHelp"),c.prototype),b(c.prototype,"closeFlyout",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"closeFlyout"),c.prototype),c);(0,t.setComponentTemplate)(y,g)})),define("vault/components/mount/secrets-engine-form",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","@ember/service","ember-concurrency","vault/utils/all-engines-metadata","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d,p,f,m,h,b
function y(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function g(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const v=(0,s.createTemplateFactory)({id:"Dp6elOR0",block:'[[[1,"\\n"],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless is-bottomless"],[12],[1,"\\n\\n  "],[8,[39,1],[[24,0,"page-header"]],null,[["default"],[[[[1,"\\n    "],[8,[30,1,["Breadcrumb"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,null,[["default"],[[[[1,"\\n        "],[8,[39,3],null,[["@text","@route"],["Secrets","vault.cluster.secrets.backends"]],null],[1,"\\n        "],[8,[39,3],null,[["@text","@route"],["Enable secret engine","vault.cluster.secrets.mounts"]],null],[1,"\\n        "],[8,[39,3],null,[["@text","@current"],[[28,[37,4],[[30,2,["type"]]],null],true]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[1]]]]],[1,"\\n\\n  "],[8,[39,5],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n\\n  "],[11,"form"],[4,[38,7],["submit",[28,[37,8],[[30,0,["mountBackend"]]],null]],null],[12],[1,"\\n    "],[8,[39,9],null,[["@model","@groupName","@renderGroup","@modelValidations","@onKeyUp"],[[30,2],"formFieldGroups","default",[30,0,["modelValidations"]],[30,0,["onKeyUp"]]]],null],[1,"\\n\\n    "],[8,[39,9],null,[["@model","@renderGroup","@groupName"],[[30,2],"Method Options","formFieldGroups"]],[["identityTokenKey"],[[[[1,"\\n        "],[8,[39,11],null,[["@id","@fallbackComponent","@inputValue","@onChange","@models","@selectLimit","@modalFormTemplate","@placeholder","@fallbackComponentPlaceholder","@modalSubtext"],["key","input-search",[30,2,["data","config","identity_token_key"]],[30,0,["handleIdentityTokenKeyChange"]],[28,[37,12],["oidc/key"],null],"1","modal-form/oidc-key-template","Search for an existing OIDC key, or type a new key name to create it.","Input a key name","This key will be created in the OIDC key path."]],null],[1,"\\n      "]],[]]]]],[1,"\\n\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,13],[[16,"disabled",[30,0,["mountBackend","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Enable engine",[52,[30,0,["mountBackend","isRunning"]],"loading"]]],null],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,13],[[4,[38,7],["click",[30,0,["goBack"]]],null]],[["@text","@color"],["Back","secondary"]],null],[1,"\\n      "],[13],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,15],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n        "],[13],[1,"\\n"]],[]],null],[1,"    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],["PH","@model"],false,["div","hds/page-header","hds/breadcrumb","hds/breadcrumb/item","capitalize","message-error","form","on","perform","form-field-groups",":identityTokenKey","search-select-with-modal","array","hds/button","if","alert-inline"]]',moduleName:"vault/components/mount/secrets-engine-form.hbs",isStrictMode:!1})
let w=e.default=(u=class extends n.default{constructor(...e){super(...e),y(this,"flashMessages",c,this),y(this,"api",d,this),y(this,"capabilities",p,this),y(this,"router",f,this),y(this,"modelValidations",m,this),y(this,"invalidFormAlert",h,this),y(this,"errorMessage",b,this)}get mountForm(){return this.args.model}onKeyUp(e,t){(0,r.set)(this.mountForm.data,e,t)}async saveKvConfig(e,t){const{options:n,kv_config:i={}}=t,{max_versions:r,cas_required:l,delete_version_after:a}=i
if(2===n?.version&&["kv","generic"].includes(this.mountForm.normalizedType)&&(r||l||a))try{const{canUpdate:t}=await this.capabilities.for("kvConfig",{path:e})
t?await this.api.secrets.kvV2Configure(e,i):this.flashMessages.warning("You do not have access to the config endpoint. The secret engine was mounted, but the configuration settings were not saved.")}catch(o){const{message:e}=await this.api.parseError(o)
this.flashMessages.warning(`The secret engine was mounted, but the configuration settings were not saved. ${e}`)}}async onMountError(e,t,n){403===e?this.flashMessages.danger("You do not have access to the sys/mounts endpoint. The secret engine was not mounted."):this.errorMessage=t?t.map((e=>{if("object"==typeof e&&null!==e){const t=e
return t.title||t.message||JSON.stringify(e)}return String(e)})):n||"An error occurred, check the vault logs."}*mountBackend(e){e.preventDefault()
const t=this.mountForm,{type:n}=t,{path:i}=t.data,{isValid:r,state:l,invalidFormMessage:a,data:s}=t.toJSON()
if(!r)return this.modelValidations=l,void(this.invalidFormAlert=a)
this.errorMessage="",this.modelValidations=null,this.invalidFormAlert=null
try{yield this.api.sys.mountsEnableSecretsEngine(i,s),yield this.saveKvConfig(i,s),this.flashMessages.success(`Successfully mounted the ${t.type} secrets engine at ${i}.`)
const e=s.options?.version,r=(0,o.isAddonEngine)(t.normalizedType,Number(e))
this.args.onMountSuccess?this.args.onMountSuccess(n,i,r):r?this.router.transitionTo("vault.cluster.secrets.backend.index",i):this.router.transitionTo("vault.cluster.secrets.backend.list-root",i)}catch(u){const{status:e,response:t,message:n}=yield this.api.parseError(u)
this.onMountError(e,t.errors,n)}}handleIdentityTokenKeyChange(e){const{config:t}=this.mountForm.data
t.identity_token_key=Array.isArray(e)?e[0]:e}goBack(){this.router.transitionTo("vault.cluster.secrets.mounts")}},c=g(u.prototype,"flashMessages",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=g(u.prototype,"api",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=g(u.prototype,"capabilities",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=g(u.prototype,"router",[l.inject],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=g(u.prototype,"modelValidations",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=g(u.prototype,"invalidFormAlert",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b=g(u.prototype,"errorMessage",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),g(u.prototype,"onKeyUp",[r.action],Object.getOwnPropertyDescriptor(u.prototype,"onKeyUp"),u.prototype),g(u.prototype,"mountBackend",[a.task],Object.getOwnPropertyDescriptor(u.prototype,"mountBackend"),u.prototype),g(u.prototype,"handleIdentityTokenKeyChange",[r.action],Object.getOwnPropertyDescriptor(u.prototype,"handleIdentityTokenKeyChange"),u.prototype),g(u.prototype,"goBack",[r.action],Object.getOwnPropertyDescriptor(u.prototype,"goBack"),u.prototype),u);(0,t.setComponentTemplate)(v,w)})),define("vault/components/namespace-picker",["exports","@ember/component","@glimmer/component","@ember/object","@glimmer/tracking","@ember/service","core/utils/keys","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d,p,f,m,h,b,y,g,v,w
function k(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function x(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const P=(0,s.createTemplateFactory)({id:"f6Q/U/m1",block:'[[[1,"\\n"],[11,0],[24,0,"namespace-picker side-padding-4"],[17,1],[12],[1,"\\n  "],[8,[39,1],null,[["@enableCollisionDetection"],[true]],[["default"],[[[[1,"\\n\\n    "],[8,[30,2,["ToggleButton"]],[[4,[38,2],["click",[30,0,["toggleNamespacePicker"]]],null]],[["@icon","@text","@isFullWidth"],["org",[30,0,["namespace","currentNamespace"]],true]],null],[1,"\\n\\n"],[41,[30,0,["errorLoadingNamespaces"]],[[[1,"\\n      "],[8,[30,2,["Header"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,4],null,[["@errorMessage"],[[30,0,["errorLoadingNamespaces"]]]],null],[1,"\\n      "]],[]]]]],[1,"\\n\\n"]],[]],[[[1,"\\n      "],[8,[30,2,["Header"]],[[24,0,"is-paddingless"]],[["@hasDivider"],[true]],[["default"],[[[[1,"\\n        "],[10,0],[14,0,"has-padding-8"],[12],[1,"\\n          "],[8,[39,5],[[24,"aria-label","Search namespaces"],[24,"placeholder","Search"],[4,[38,2],["keydown",[30,0,["onKeyDown"]]],null],[4,[38,2],["input",[30,0,["onSearchInput"]]],null],[4,[38,6],[[30,0,["focusSearchInput"]]],null]],[["@value","@type"],[[30,0,["searchInput"]],"search"]],null],[1,"\\n        "],[13],[1,"\\n      "]],[]]]]],[1,"\\n\\n      "],[8,[30,2,["Header"]],[[24,0,"is-paddingless"]],null,[["default"],[[[[1,"\\n"],[41,[28,[37,7],[[30,0,["hasSearchInput"]],[28,[37,8],[[30,0,["showNoNamespacesMessage"]]],null]],null],[[[1,"          "],[11,0],[24,0,"sub-text is-marginless has-top-padding-xs left-padding-16"],[4,[38,6],[[30,0,["adjustElementWidth"]]],null],[12],[1,"\\n            "],[1,[30,0,["searchInputHelpText"]]],[1,"\\n          "],[13],[1,"\\n"]],[]],null],[1,"\\n        "],[10,0],[14,0,"is-size-8 has-text-black has-text-weight-semibold left-padding-16 top-padding-10"],[12],[1,"\\n          "],[1,[30,0,["namespaceLabel"]]],[1,"\\n          "],[8,[39,9],null,[["@text"],[[28,[37,10],[[30,0,["namespaceCount"]],0],null]]],null],[1,"\\n        "],[13],[1,"\\n      "]],[]]]]],[1,"\\n\\n"],[41,[30,0,["showNoNamespacesMessage"]],[[[1,"        "],[8,[30,2,["Generic"]],[[24,0,"sub-text is-marginless"],[4,[38,6],[[30,0,["adjustElementWidth"]]],null]],null,[["default"],[[[[1,"\\n          "],[1,[30,0,["noNamespacesMessage"]]],[1,"\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n      "],[11,0],[24,0,"is-overflow-y-auto is-max-drawer-height"],[4,[38,6],[[30,0,["setupScrollListener"]]],null],[12],[1,"\\n"],[42,[28,[37,12],[[28,[37,12],[[30,0,["visibleNamespaceOptions"]]],null]],null],null,[[[1,"          "],[8,[30,2,["Checkmark"]],[[4,[38,2],["click",[28,[37,14],[[30,0,["onChange"]],[30,3]],null]],null]],[["@selected"],[[28,[37,13],[[30,3,["path"]],[30,0,["selectedNamespace","path"]]],null]]],[["default"],[[[[1,"\\n            "],[10,1],[14,0,"is-fullwidth is-word-break right-padding-4"],[12],[1,[30,3,["label"]]],[13],[1,"\\n          "]],[]]]]],[1,"\\n"]],[3]],null],[1,"      "],[13],[1,"\\n\\n"]],[]]],[1,"\\n    "],[8,[30,2,["Footer"]],[[24,0,"is-flex-center"]],[["@hasDivider"],[true]],[["default"],[[[[1,"\\n      "],[8,[39,16],[[24,0,"is-fullwidth"]],null,[["default"],[[[[1,"\\n        "],[8,[39,17],[[4,[38,2],["click",[30,0,["refreshList"]]],null]],[["@color","@text","@isFullWidth","@icon","@size"],["secondary","Refresh list",[28,[37,8],[[30,0,["canManageNamespaces"]]],null],"reload","small"]],null],[1,"\\n"],[41,[30,0,["canManageNamespaces"]],[[[1,"          "],[8,[39,17],null,[["@color","@text","@icon","@size","@route"],["tertiary","Manage","settings","small","vault.cluster.access.namespaces"]],null],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n\\n    "]],[]]]]],[1,"\\n\\n  "]],[2]]]]],[1,"\\n"],[13]],["&attrs","D","option"],false,["div","hds/dropdown","on","if","message-error","hds/form/text-input/field","did-insert","and","not","hds/badge-count","or","each","-track-array","eq","fn","span","hds/button-set","hds/button"]]',moduleName:"vault/components/namespace-picker.hbs",isStrictMode:!1})
let _=e.default=(u=class extends n.default{constructor(e,t){super(e,t),k(this,"auth",c,this),k(this,"capabilities",d,this),k(this,"namespace",p,this),k(this,"router",f,this),k(this,"store",m,this),k(this,"batchSize",h,this),k(this,"canManageNamespaces",b,this),k(this,"errorLoadingNamespaces",y,this),k(this,"hasNamespaces",g,this),k(this,"searchInput",v,this),k(this,"searchInputHelpText",w,this),this.loadOptions(),this.fetchManageCapability()}get allNamespaces(){return this.getOptions(this.namespace?.accessibleNamespaces)}get selectedNamespace(){return this.getSelected(this.allNamespaces,this.namespace?.path)??null}matchesPath(e,t){return e?.path===t}getSelected(e,t){return e.find((e=>this.matchesPath(e,t)))}getOptions(e){const t=(e||[]).map((e=>({path:e,label:e}))),n=this.auth.authData?.userRootNamespace
if(!t?.find((e=>e.path===n))){const e=""===n?"root":n
t.unshift({path:n,label:e})}return 0===t.length&&t.push({path:this.namespace.path,label:this.namespace.path}),t}get hasSearchInput(){return this.searchInput?.trim().length>0}get namespaceCount(){return this.namespaceOptions.length}get namespaceLabel(){return""===this.searchInput?"All namespaces":"Matching namespaces"}get namespaceOptions(){if(""===this.searchInput.trim())return this.allNamespaces||[]
return this.allNamespaces.filter((e=>e.label.toLowerCase().includes(this.searchInput.toLowerCase())))||[]}get noNamespacesMessage(){return this.hasSearchInput?"No matching namespaces found. Try searching for a different namespace.":"No namespaces found."}get showNoNamespacesMessage(){const e=""!==this.errorLoadingNamespaces
return 0===this.namespaceCount&&!e}get visibleNamespaceOptions(){return this.namespaceOptions.slice(0,this.batchSize)}adjustElementWidth(e){e.style.display="none"
let t=240
this.visibleNamespaceOptions.forEach((e=>{const n=document.querySelector(`[data-test-button="${e.label}"]`).offsetWidth
n>t&&(t=n)})),e.style.width=`${t}px`,e.style.display=""}async fetchManageCapability(){const{canList:e}=await this.capabilities.fetchPathCapabilities("sys/namespaces")
this.canManageNamespaces=e}focusSearchInput(e){e.focus()}async loadOptions(){try{await(this.namespace?.findNamespacesForUser?.perform()),this.errorLoadingNamespaces=""}catch(e){this.errorLoadingNamespaces=(0,o.default)(e)}}loadMore(){this.batchSize+=200}setupScrollListener(e){e.addEventListener("scroll",this.onScroll)}onScroll(e){const t=e.target
t.scrollTop+t.clientHeight>=t.scrollHeight&&this.loadMore()}async onChange(e){this.searchInput="",this.router.transitionTo("vault.cluster.dashboard",{queryParams:{namespace:e.path}})}async onKeyDown(e){if(e.key===a.default.ENTER&&this.searchInput?.trim()){const e=this.allNamespaces.find((e=>e.label===this.searchInput.trim()))
e&&(this.searchInput="",this.router.transitionTo("vault.cluster.dashboard",{queryParams:{namespace:e.path}}))}}onSearchInput(e){const t=e.target
this.searchInput=t.value}async refreshList(){this.searchInput="",await this.loadOptions()}toggleNamespacePicker(){this.searchInput=""}},c=x(u.prototype,"auth",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=x(u.prototype,"capabilities",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=x(u.prototype,"namespace",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=x(u.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=x(u.prototype,"store",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=x(u.prototype,"batchSize",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 200}}),b=x(u.prototype,"canManageNamespaces",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),y=x(u.prototype,"errorLoadingNamespaces",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),g=x(u.prototype,"hasNamespaces",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),v=x(u.prototype,"searchInput",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),w=x(u.prototype,"searchInputHelpText",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"Enter a full path in the search bar and hit the 'Enter' ↵ key to navigate faster."}}),x(u.prototype,"adjustElementWidth",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"adjustElementWidth"),u.prototype),x(u.prototype,"fetchManageCapability",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"fetchManageCapability"),u.prototype),x(u.prototype,"focusSearchInput",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"focusSearchInput"),u.prototype),x(u.prototype,"loadOptions",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"loadOptions"),u.prototype),x(u.prototype,"loadMore",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"loadMore"),u.prototype),x(u.prototype,"setupScrollListener",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"setupScrollListener"),u.prototype),x(u.prototype,"onScroll",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"onScroll"),u.prototype),x(u.prototype,"onChange",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"onChange"),u.prototype),x(u.prototype,"onKeyDown",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"onKeyDown"),u.prototype),x(u.prototype,"onSearchInput",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"onSearchInput"),u.prototype),x(u.prototype,"refreshList",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"refreshList"),u.prototype),x(u.prototype,"toggleNamespacePicker",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"toggleNamespacePicker"),u.prototype),u);(0,t.setComponentTemplate)(P,_)})),define("vault/components/namespace-reminder",["exports","core/components/namespace-reminder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/navigate-input",["exports","core/components/navigate-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/navigation-narrator",["exports","ember-a11y-refocus/components/navigation-narrator"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/not-found",["exports","@ember/component","@ember/service","@glimmer/component","@ember/template-factory"],(function(e,t,n,i,r){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,r.createTemplateFactory)({id:"VN+gFUBS",block:'[[[1,"\\n"],[10,0],[14,0,"box is-shadowless"],[12],[1,"\\n  "],[8,[39,1],null,null,[["default"],[[[[1,"\\n    "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n      "],[10,"h1"],[14,0,"title is-3 has-text-grey"],[12],[1,"\\n        404 Not Found\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[1]]]]],[1,"\\n  "],[10,0],[14,0,"box is-sideless has-background-white-bis has-text-grey has-text-centered"],[12],[1,"\\n    "],[10,2],[12],[1,"Sorry, we were unable to find any content at "],[10,"code"],[12],[1,[28,[35,5],[[30,2,["path"]],[30,0,["path"]]],null]],[13],[1,"."],[13],[1,"\\n    "],[10,2],[12],[1,"\\n      Double check the url or\\n      "],[8,[39,6],null,[["@href","@sameTab"],["/",true]],[["default"],[[[[1,"go back home"]],[]]]]],[1,".\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],["p","@model"],false,["div","page-header","h1","p","code","or","external-link"]]',moduleName:"vault/components/not-found.hbs",isStrictMode:!1})
let s=e.default=(l=class extends i.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="router",r=this,(i=a)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}get path(){return this.router.currentURL}},u=l.prototype,c="router",d=[n.service],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},m={},Object.keys(p).forEach((function(e){m[e]=p[e]})),m.enumerable=!!m.enumerable,m.configurable=!!m.configurable,("value"in m||m.initializer)&&(m.writable=!0),m=d.slice().reverse().reduce((function(e,t){return t(u,c,e)||e}),m),f&&void 0!==m.initializer&&(m.value=m.initializer?m.initializer.call(f):void 0,m.initializer=void 0),a=void 0===m.initializer?(Object.defineProperty(u,c,m),null):m,l)
var u,c,d,p,f,m;(0,t.setComponentTemplate)(o,s)})),define("vault/components/object-list-input",["exports","core/components/object-list-input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/oidc-callback-splash",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"ba0djgvC",block:'[[[1,"\\n"],[10,0],[14,0,"splash-page-container section is-flex-v-centered-tablet is-flex-grow-1 is-fullwidth"],[12],[1,"\\n  "],[10,0],[14,0,"columns is-centered is-gapless is-fullwidth"],[12],[1,"\\n    "],[10,0],[14,0,"column is-4-desktop is-6-tablet"],[12],[1,"\\n      "],[10,0],[14,0,"has-text-grey has-bottom-margin-m has-current-color-fill"],[12],[1,"\\n        "],[8,[39,1],null,null,null],[1,"\\n      "],[13],[1,"\\n      "],[8,[39,2],null,[["@type","@color"],["inline","success"]],[["default"],[[[[1,"\\n        "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Signing in with your OIDC provider..."]],[]]]]],[1,"\\n        "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"This window will close automatically"]],[]]]]],[1,"\\n      "]],[1]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13]],["A"],false,["div","logo-edition","hds/alert"]]',moduleName:"vault/components/oidc-callback-splash.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/oidc-consent-block",["exports","@ember/component","ember","@glimmer/component","@ember/object","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s
function u(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const c=(0,a.createTemplateFactory)({id:"+KfOOlmO",block:'[[[1,"\\n"],[41,[30,0,["didCancel"]],[[[1,"  "],[10,"h3"],[14,0,"title is-3"],[12],[1,"\\n    Consent Not Given\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"box"],[12],[1,"\\n    "],[10,2],[14,0,"has-bottom-margin-l has-top-margin-l"],[12],[1,"Login attempt has been terminated."],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[10,"h3"],[14,0,"title is-3"],[12],[1,"\\n    Consent\\n  "],[13],[1,"\\n  "],[11,"form"],[24,0,"box"],[4,[38,5],["submit",[30,0,["handleSubmit"]]],null],[12],[1,"\\n    "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n      In order to complete the login process, you must consent to Vault sharing your profile, email, address, and phone with\\n      the client.\\n    "],[13],[1,"\\n    "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"Do you want to continue?"],[13],[1,"\\n    "],[8,[39,6],null,[["@saveButtonText","@isSaving","@cancelButtonText","@onCancel","@includeBox"],["Yes",false,"No",[30,0,["handleCancel"]],false]],null],[1,"\\n  "],[13],[1,"\\n"]],[]]]],[],false,["if","h3","div","p","form","on","form-save-buttons"]]',moduleName:"vault/components/oidc-consent-block.hbs",isStrictMode:!1}),d=["code","state"]
let p=e.default=(o=class extends i.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="didCancel",r=this,(i=s)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}get win(){return this.window||window}buildUrl(e,t){try{const n=new URL(e)
return Object.keys(t).forEach((e=>{t[e]&&d.includes(e)&&n.searchParams.append(e,t[e])})),n}catch(n){throw console.debug("DEBUG: parsing url failed for",e),new Error("Invalid URL")}}handleSubmit(e){e.preventDefault()
const{redirect:t,...i}=this.args,r=this.buildUrl(t,i)
n.default.testing?this.args.testRedirect(r.toString()):this.win.location.replace(r)}handleCancel(e){e.preventDefault(),this.didCancel=!0}},s=u(o.prototype,"didCancel",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),u(o.prototype,"handleSubmit",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"handleSubmit"),o.prototype),u(o.prototype,"handleCancel",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"handleCancel"),o.prototype),o);(0,t.setComponentTemplate)(c,p)})),define("vault/components/oidc/assignment-form",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","ember-concurrency","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p
function f(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function m(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const h=(0,o.createTemplateFactory)({id:"/R8hEoOD",block:'[[[1,"\\n"],[11,"form"],[4,[38,1],["submit",[28,[37,2],[[30,0,["save"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,4],null,[["@errorMessage"],[[30,0,["errorBanner"]]]],null],[1,"\\n    "],[8,[39,5],[[24,"for","name"]],[["@label"],["Name"]],null],[1,"\\n    "],[11,"input"],[24,"autocomplete","off"],[24,"spellcheck","false"],[16,2,[30,1,["name"]]],[16,"disabled",[28,[37,7],[[30,1,["isNew"]]],null]],[16,0,[29,["input field ",[52,[30,0,["modelValidations","name","errors"]],"has-error-border"]]]],[24,1,"name"],[4,[38,1],["input",[30,0,["handleOperation"]]],null],[12],[13],[1,"\\n"],[41,[30,0,["modelValidations","name","errors"]],[[[1,"      "],[8,[39,9],null,[["@type","@message"],["danger",[28,[37,10],[", ",[30,0,["modelValidations","name","errors"]]],null]]],null],[1,"\\n"]],[]],null],[1,"    "],[8,[39,11],null,[["@id","@label","@placeholder","@models","@inputValue","@shouldRenderName","@onChange","@disallowNewItems","@fallbackComponent"],["entities","Entities","Search",[28,[37,12],["identity/entity"],null],[30,1,["entityIds"]],true,[30,0,["onEntitiesSelect"]],true,"string-list"]],null],[1,"\\n    "],[8,[39,11],null,[["@id","@label","@placeholder","@models","@inputValue","@shouldRenderName","@onChange","@disallowNewItems","@fallbackComponent"],["groups","Groups","Search",[28,[37,12],["identity/group"],null],[30,1,["groupIds"]],true,[30,0,["onGroupsSelect"]],true,"string-list"]],null],[1,"\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"has-top-padding-s"],[12],[1,"\\n    "],[8,[39,13],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[30,1,["isNew"]],"Create","Update"],[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n    "],[8,[39,13],[[24,0,"has-left-margin-s"],[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,1],["click",[30,0,["cancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n"],[41,[30,0,["modelValidations","targets","errors"]],[[[1,"      "],[8,[39,9],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[28,[37,10],[", ",[30,0,["modelValidations","targets","errors"]]],null]]],null],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n"],[13]],["@model"],false,["form","on","perform","div","message-error","form-field-label","input","not","if","alert-inline","join","search-select","array","hds/button"]]',moduleName:"vault/components/oidc/assignment-form.hbs",isStrictMode:!1})
let b=e.default=(s=class extends n.default{constructor(...e){super(...e),f(this,"store",u,this),f(this,"flashMessages",c,this),f(this,"modelValidations",d,this),f(this,"errorBanner",p,this)}*save(e){e.preventDefault()
try{const{isValid:e,state:t}=this.args.model.validate()
if(this.modelValidations=e?null:t,e){const{isNew:e,name:t}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the assignment ${t}.`),this.args.onSave(this.args.model)}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e}}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}handleOperation({target:e}){this.args.model.name=e.value}onEntitiesSelect(e){this.args.model.entityIds=e}onGroupsSelect(e){this.args.model.groupIds=e}},u=m(s.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=m(s.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=m(s.prototype,"modelValidations",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=m(s.prototype,"errorBanner",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m(s.prototype,"save",[l.task],Object.getOwnPropertyDescriptor(s.prototype,"save"),s.prototype),m(s.prototype,"cancel",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"cancel"),s.prototype),m(s.prototype,"handleOperation",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"handleOperation"),s.prototype),m(s.prototype,"onEntitiesSelect",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"onEntitiesSelect"),s.prototype),m(s.prototype,"onGroupsSelect",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"onGroupsSelect"),s.prototype),s);(0,t.setComponentTemplate)(h,b)})),define("vault/components/oidc/client-form",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p,f
function m(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function h(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,o.createTemplateFactory)({id:"1eLgb5L4",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n"],[41,[30,2,["isNew"]],[[[1,"        "],[8,[39,3],null,[["@text","@route"],["Applications","vault.cluster.access.oidc.clients"]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,3],null,[["@text","@route","@model"],["Details","vault.cluster.access.oidc.clients.client.details",[30,2,["name"]]]],null],[1,"\\n"]],[]]],[1,"      "],[8,[39,3],null,[["@text","@current"],[[29,[[52,[30,2,["isNew"]],"Create","Edit"]," Application"]],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      "],[1,[52,[30,2,["isNew"]],"Create","Edit"]],[1,"\\n      Application\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n"],[11,"form"],[4,[38,6],["submit",[28,[37,7],[[30,0,["save"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,9],null,[["@errorMessage"],[[30,0,["errorBanner"]]]],null],[1,"\\n"],[42,[28,[37,11],[[28,[37,11],[[30,2,["formFields"]]],null]],null],null,[[[1,"      "],[8,[39,12],null,[["@attr","@model","@modelValidations"],[[30,3],[30,2],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[3]],null],[1,"\\n"],[1,"    "],[8,[39,13],null,[["@renderGroup","@model","@modelValidations"],["More options",[30,2],[30,0,["modelValidations"]]]],null],[1,"\\n  "],[13],[1,"\\n"],[1,"  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless has-top-padding-xxl"],[12],[1,"\\n    "],[8,[39,14],null,[["@tag","@size"],["h2","400"]],[["default"],[[[[1,"Assign access"]],[]]]]],[1,"\\n    "],[10,0],[14,0,"is-flex-row"],[12],[1,"\\n      "],[8,[39,15],null,[["@title","@description","@icon","@value","@groupValue","@onChange"],["Allow everyone to access existing","All Vault entities can authenticate through this application.","org","allow_all",[30,0,["radioCardGroupValue"]],[30,0,["handleAssignmentSelection"]]]],null],[1,"\\n      "],[8,[39,15],null,[["@title","@description","@icon","@value","@groupValue","@onChange"],["Limit access to selected users","Choose or create an assignment to give access to selected entities.","users","limited",[30,0,["radioCardGroupValue"]],[30,0,["handleAssignmentSelection"]]]],null],[1,"\\n    "],[13],[1,"\\n"],[41,[28,[37,16],[[30,0,["radioCardGroupValue"]],"limited"],null],[[[1,"      "],[8,[39,17],null,[["@id","@label","@subText","@models","@inputValue","@onChange","@excludeOptions","@fallbackComponent","@modalFormTemplate","@modalSubtext"],["assignments","Assignment name","Search for an existing assignment, or type a new name to create it.",[28,[37,18],["oidc/assignment"],null],[30,0,["modelAssignments"]],[30,0,["handleAssignmentSelection"]],[28,[37,18],["allow_all"],null],"string-list","modal-form/oidc-assignment-template","Use assignment to specify which Vault entities and groups are allowed to authenticate."]],null],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"field box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[8,[39,19],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[30,2,["isNew"]],"Create","Update"],[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n      "],[8,[39,19],[[24,0,"has-left-margin-s"],[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,6],["click",[30,0,["cancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n    "],[13],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,20],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n"],[13]],["p","@model","attr"],false,["page-header","hds/breadcrumb","if","hds/breadcrumb/item","h1","form","on","perform","div","message-error","each","-track-array","form-field","form-field-groups","hds/text/display","radio-card","eq","search-select-with-modal","array","hds/button","alert-inline"]]',moduleName:"vault/components/oidc/client-form.hbs",isStrictMode:!1})
let y=e.default=(s=class extends n.default{constructor(...e){super(...e),m(this,"flashMessages",u,this),m(this,"modelValidations",c,this),m(this,"errorBanner",d,this),m(this,"invalidFormAlert",p,this),m(this,"radioCardGroupValue",f,this)}get modelAssignments(){const{assignments:e}=this.args.model
return e.includes("allow_all")&&1===e.length?[]:e}handleAssignmentSelection(e){Array.isArray(e)?this.args.model.assignments=e:(this.radioCardGroupValue=e,this.args.model.assignments=[])}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){"allow_all"===this.radioCardGroupValue&&(this.args.model.assignments=["allow_all"])
const{idTokenTtl:e,accessTokenTtl:t}=this.args.model
0===Number(e)&&(this.args.model.idTokenTtl="24h"),0===Number(t)&&(this.args.model.accessTokenTtl="24h")
const{isNew:n,name:i}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`Successfully ${n?"created":"updated"} the application ${i}.`),this.args.onSave()}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}},u=h(s.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=h(s.prototype,"modelValidations",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(s.prototype,"errorBanner",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=h(s.prototype,"invalidFormAlert",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=h(s.prototype,"radioCardGroupValue",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!this.args.model.assignments||this.args.model.assignments.includes("allow_all")?"allow_all":"limited"}}),h(s.prototype,"handleAssignmentSelection",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"handleAssignmentSelection"),s.prototype),h(s.prototype,"cancel",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"cancel"),s.prototype),h(s.prototype,"save",[a.task],Object.getOwnPropertyDescriptor(s.prototype,"save"),s.prototype),s);(0,t.setComponentTemplate)(b,y)})),define("vault/components/oidc/client-list",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"B5y29gnU",block:'[[[1,"\\n"],[42,[28,[37,1],[[28,[37,1],[[30,1]],null]],null],null,[[[1,"  "],[8,[39,2],[[24,0,"list-item-row"]],[["@params"],[[28,[37,3],["vault.cluster.access.oidc.clients.client.details",[30,2,["name"]]],null]]],[["default"],[[[[1,"\\n    "],[10,0],[14,0,"level is-mobile"],[12],[1,"\\n      "],[10,0],[14,0,"level-left"],[12],[1,"\\n        "],[10,0],[12],[1,"\\n          "],[8,[39,5],[[24,0,"has-text-grey-light"]],[["@name"],["code"]],null],[1,"\\n          "],[10,1],[14,0,"has-text-weight-semibold is-underline"],[12],[1,"\\n            "],[1,[30,2,["name"]]],[1,"\\n          "],[13],[1,"\\n          "],[10,0],[14,0,"has-text-grey is-size-8"],[12],[1,"\\n            Client ID:\\n            "],[1,[30,2,["clientId"]]],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"level-right is-flex is-paddingless is-marginless"],[12],[1,"\\n        "],[10,0],[14,0,"level-item"],[12],[1,"\\n"],[41,[28,[37,8],[[30,2,["canRead"]],[30,2,["canEdit"]]],null],[[[1,"            "],[8,[39,9],null,[["@isInline","@listPosition"],[true,"bottom-right"]],[["default"],[[[[1,"\\n              "],[8,[30,3,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal","Application nav options",false]],null],[1,"\\n"],[41,[30,2,["canRead"]],[[[1,"                "],[8,[30,3,["Interactive"]],null,[["@route","@model"],["vault.cluster.access.oidc.clients.client.details",[30,2,["name"]]]],[["default"],[[[[1,"Details"]],[]]]]],[1,"\\n"]],[]],null],[41,[30,2,["canEdit"]],[[[1,"                "],[8,[30,3,["Interactive"]],null,[["@route","@model"],["vault.cluster.access.oidc.clients.client.edit",[30,2,["name"]]]],[["default"],[[[[1,"Edit"]],[]]]]],[1,"\\n"]],[]],null],[1,"            "]],[3]]]]],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[2]],null]],["@model","client","dd"],false,["each","-track-array","linked-block","array","div","icon","span","if","or","hds/dropdown"]]',moduleName:"vault/components/oidc/client-list.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/oidc/key-form",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p,f,m
function h(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function b(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const y=(0,o.createTemplateFactory)({id:"DQHezWPH",block:'[[[1,"\\n"],[11,"form"],[4,[38,1],["submit",[28,[37,2],[[30,0,["save"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,4],null,[["@errorMessage"],[[30,0,["errorBanner"]]]],null],[1,"\\n"],[42,[28,[37,6],[[28,[37,6],[[30,1,["formFields"]]],null]],null],null,[[[1,"      "],[8,[39,7],null,[["@attr","@model","@modelValidations"],[[30,2],[30,1],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[2]],null],[1,"  "],[13],[1,"\\n"],[41,[51,[30,3]],[[[1,"    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless has-top-padding-xxl"],[12],[1,"\\n      "],[8,[39,9],null,[["@tag","@size"],["h2","400"]],[["default"],[[[[1,"Allowed applications"]],[]]]]],[1,"\\n      "],[10,0],[14,0,"is-flex-row"],[12],[1,"\\n        "],[8,[39,10],null,[["@title","@description","@icon","@value","@groupValue","@onChange"],["Allow every application to use","All applications can use this key for authentication requests.","globe","allow_all",[30,0,["radioCardGroupValue"]],[30,0,["handleClientSelection"]]]],null],[1,"\\n        "],[8,[39,10],null,[["@title","@description","@icon","@value","@groupValue","@onChange","@disabled","@disabledTooltipMessage"],["Limit access to selected application","Only selected applications can use this key for authentication requests.","globe-private","limited",[30,0,["radioCardGroupValue"]],[30,0,["handleClientSelection"]],[30,1,["isNew"]],"This option has been disabled for now. To limit access, you must first create an application that references this key."]],null],[1,"\\n      "],[13],[1,"\\n"],[41,[28,[37,12],[[30,0,["radioCardGroupValue"]],"limited"],null],[[[1,"        "],[8,[39,13],null,[["@id","@label","@subText","@models","@inputValue","@onChange","@disallowNewItems","@fallbackComponent","@passObject","@objectKeys","@queryObject"],["allowedClientIds","Application name","Select which applications are allowed to use this key. Only applications that currently reference this key will appear in the dropdown.",[28,[37,14],["oidc/client"],null],[30,1,["allowedClientIds"]],[30,0,["handleClientSelection"]],true,"string-list",true,[28,[37,14],["clientId"],null],[30,0,["filterDropdownOptions"]]]],null],[1,"\\n"]],[]],null],[1,"    "],[13],[1,"\\n"]],[]],null],[1,"  "],[10,0],[14,0,"field box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[8,[39,15],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[30,1,["isNew"]],"Create","Update"],[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n      "],[8,[39,15],[[24,0,"has-left-margin-s"],[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,1],["click",[30,0,["cancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n    "],[13],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,16],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n"],[13]],["@model","attr","@isModalForm"],false,["form","on","perform","div","message-error","each","-track-array","form-field","unless","hds/text/display","radio-card","if","eq","search-select","array","hds/button","alert-inline"]]',moduleName:"vault/components/oidc/key-form.hbs",isStrictMode:!1})
let g=e.default=(s=class extends n.default{constructor(...e){super(...e),h(this,"store",u,this),h(this,"flashMessages",c,this),h(this,"errorBanner",d,this),h(this,"invalidFormAlert",p,this),h(this,"modelValidations",f,this),h(this,"radioCardGroupValue",m,this)}get filterDropdownOptions(){return{paramKey:"key",filterFor:[this.args.model.name]}}handleClientSelection(e){Array.isArray(e)?this.args.model.allowedClientIds=e.map((e=>e.clientId)):(this.radioCardGroupValue=e,this.args.model.allowedClientIds=[])}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){const{isNew:e,name:t}=this.args.model
"allow_all"===this.radioCardGroupValue&&(this.args.model.allowedClientIds=["*"])
const{rotationPeriod:n,verificationTtl:i}=this.args.model
0===Number(n)&&(this.args.model.rotationPeriod="24h"),0===Number(i)&&(this.args.model.verificationTtl="24h"),yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the key\n          ${t}.`),this.args.onSave(this.args.model)}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}},u=b(s.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=b(s.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=b(s.prototype,"errorBanner",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=b(s.prototype,"invalidFormAlert",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=b(s.prototype,"modelValidations",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=b(s.prototype,"radioCardGroupValue",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!this.args.model.allowedClientIds||this.args.model.allowedClientIds.includes("*")?"allow_all":"limited"}}),b(s.prototype,"handleClientSelection",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"handleClientSelection"),s.prototype),b(s.prototype,"cancel",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"cancel"),s.prototype),b(s.prototype,"save",[a.task],Object.getOwnPropertyDescriptor(s.prototype,"save"),s.prototype),s);(0,t.setComponentTemplate)(y,g)})),define("vault/components/oidc/provider-form",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","core/utils/parse-url","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d,p,f,m,h
function b(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function y(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const g=(0,s.createTemplateFactory)({id:"nbzzEHeG",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n"],[41,[30,2,["isNew"]],[[[1,"        "],[8,[39,3],null,[["@text","@route"],["Providers","vault.cluster.access.oidc.providers"]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,3],null,[["@text","@route","@model"],["Details","vault.cluster.access.oidc.providers.provider.details",[30,2,["name"]]]],null],[1,"\\n"]],[]]],[1,"      "],[8,[39,3],null,[["@text","@current"],[[29,[[52,[30,2,["isNew"]],"Create","Edit"]," Provider"]],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      "],[1,[52,[30,2,["isNew"]],"Create","Edit"]],[1,"\\n      Provider\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[11,"form"],[4,[38,6],["submit",[28,[37,7],[[30,0,["save"]]],null]],null],[4,[38,8],[[30,0,["setIssuer"]],[30,2]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,10],null,[["@errorMessage"],[[30,0,["errorBanner"]]]],null],[1,"\\n"],[1,"    "],[8,[39,11],null,[["@attr","@model","@modelValidations"],[[28,[37,12],[[30,2,["formFields"]],"0"],null],[30,2],[30,0,["modelValidations"]]]],null],[1,"\\n"],[44,[[28,[37,12],[[30,2,["formFields"]],"1"],null]],[[[1,"      "],[8,[39,14],[[16,"for",[30,3,["name"]]]],[["@label","@helpText","@subText","@docLink"],["Issuer",[30,3,["options","helpText"]],[30,3,["options","subText"]],[30,3,["options","docLink"]]]],null],[1,"\\n      "],[8,[39,15],[[16,1,[30,3,["name"]]],[24,"autocomplete","off"],[24,"spellcheck","false"],[16,0,[29,["input ",[52,[30,0,["validationError"]],"has-error-border"]]]],[16,"placeholder",[30,3,["options","placeholderText"]]]],[["@value"],[[30,2,["issuer"]]]],null],[1,"\\n"]],[3]]],[1,"    "],[8,[39,11],null,[["@attr","@model","@modelValidations"],[[28,[37,12],[[30,2,["formFields"]],"2"],null],[30,2],[30,0,["modelValidations"]]]],null],[1,"\\n  "],[13],[1,"\\n"],[1,"  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless has-top-padding-xxl"],[12],[1,"\\n    "],[8,[39,16],null,[["@tag","@size"],["h2","400"]],[["default"],[[[[1,"Allowed applications"]],[]]]]],[1,"\\n    "],[10,0],[14,0,"is-flex-row"],[12],[1,"\\n      "],[8,[39,17],null,[["@title","@description","@icon","@value","@groupValue","@onChange"],["Allow every application to use","All applications can use this provider for authentication requests.","globe","allow_all",[30,0,["radioCardGroupValue"]],[30,0,["handleClientSelection"]]]],null],[1,"\\n      "],[8,[39,17],null,[["@title","@description","@icon","@value","@groupValue","@onChange"],["Limit access to selected application","Only selected applications can use this provider for authentication requests.","globe-private","limited",[30,0,["radioCardGroupValue"]],[30,0,["handleClientSelection"]]]],null],[1,"\\n    "],[13],[1,"\\n"],[41,[28,[37,18],[[30,0,["radioCardGroupValue"]],"limited"],null],[[[1,"      "],[8,[39,19],null,[["@id","@label","@models","@inputValue","@onChange","@disallowNewItems","@fallbackComponent","@passObject","@objectKeys","@renderInfoTooltip"],["allowedClientIds","Application name",[28,[37,20],["oidc/client"],null],[30,2,["allowedClientIds"]],[30,0,["handleClientSelection"]],true,"string-list",true,[28,[37,20],["clientId"],null],[30,0,["renderInfoTooltip"]]]],null],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"field box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[8,[39,21],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[30,2,["isNew"]],"Create","Update"],[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n      "],[8,[39,21],[[24,0,"has-left-margin-s"],[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,6],["click",[30,0,["cancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n    "],[13],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,22],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n"],[13]],["p","@model","attr"],false,["page-header","hds/breadcrumb","if","hds/breadcrumb/item","h1","form","on","perform","did-insert","div","message-error","form-field","get","let","form-field-label","input","hds/text/display","radio-card","eq","search-select","array","hds/button","alert-inline"]]',moduleName:"vault/components/oidc/provider-form.hbs",isStrictMode:!1})
let v=e.default=(u=class extends n.default{constructor(...e){super(...e),b(this,"store",c,this),b(this,"flashMessages",d,this),b(this,"modelValidations",p,this),b(this,"errorBanner",f,this),b(this,"invalidFormAlert",m,this),b(this,"radioCardGroupValue",h,this)}renderInfoTooltip(e,t){return!!!t.find((t=>t.clientId===e))&&"The application associated with this client_id no longer exists"}setIssuer(e,[t]){t.issuer=t.isNew?"":(0,o.default)(t.issuer).origin}handleClientSelection(e){Array.isArray(e)?this.args.model.allowedClientIds=e.map((e=>e.clientId)):(this.radioCardGroupValue=e,this.args.model.allowedClientIds=[])}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){const{isNew:e,name:t}=this.args.model
"allow_all"===this.radioCardGroupValue&&(this.args.model.allowedClientIds=["*"]),yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the OIDC provider\n          ${t}.`),this.args.onSave()}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}},c=y(u.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=y(u.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=y(u.prototype,"modelValidations",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=y(u.prototype,"errorBanner",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=y(u.prototype,"invalidFormAlert",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=y(u.prototype,"radioCardGroupValue",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!this.args.model.allowedClientIds||this.args.model.allowedClientIds.includes("*")?"allow_all":"limited"}}),y(u.prototype,"setIssuer",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"setIssuer"),u.prototype),y(u.prototype,"handleClientSelection",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"handleClientSelection"),u.prototype),y(u.prototype,"cancel",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"cancel"),u.prototype),y(u.prototype,"save",[a.task],Object.getOwnPropertyDescriptor(u.prototype,"save"),u.prototype),u);(0,t.setComponentTemplate)(g,v)})),define("vault/components/oidc/provider-list",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"7Zx/h9M0",block:'[[[1,"\\n"],[42,[28,[37,1],[[28,[37,1],[[30,1]],null]],null],null,[[[1,"  "],[8,[39,2],[[24,0,"list-item-row"]],[["@params"],[[28,[37,3],["vault.cluster.access.oidc.providers.provider.details",[30,2,["name"]]],null]]],[["default"],[[[[1,"\\n    "],[10,0],[14,0,"level is-mobile"],[12],[1,"\\n      "],[10,0],[14,0,"level-left"],[12],[1,"\\n        "],[10,0],[12],[1,"\\n          "],[8,[39,5],[[24,0,"has-text-grey-light"]],[["@name"],["provider"]],null],[1,"\\n          "],[10,1],[14,0,"has-text-weight-semibold is-underline"],[12],[1,"\\n            "],[1,[30,2,["name"]]],[1,"\\n          "],[13],[1,"\\n          "],[10,0],[14,0,"has-text-grey is-size-8"],[12],[1,"\\n            Issuer:\\n            "],[1,[30,2,["issuer"]]],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"level-right is-flex is-paddingless is-marginless"],[12],[1,"\\n        "],[10,0],[14,0,"level-item"],[12],[1,"\\n"],[41,[28,[37,8],[[30,2,["canRead"]],[30,2,["canEdit"]]],null],[[[1,"            "],[8,[39,9],null,[["@isInline","@listPosition"],[true,"bottom-right"]],[["default"],[[[[1,"\\n              "],[8,[30,3,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal","Provider nav options",false]],null],[1,"\\n"],[41,[30,2,["canRead"]],[[[1,"                "],[8,[30,3,["Interactive"]],null,[["@route","@model"],["vault.cluster.access.oidc.providers.provider.details",[30,2,["name"]]]],[["default"],[[[[1,"Details"]],[]]]]],[1,"\\n"]],[]],null],[41,[30,2,["canEdit"]],[[[1,"                "],[8,[30,3,["Interactive"]],null,[["@route","@model"],["vault.cluster.access.oidc.providers.provider.edit",[30,2,["name"]]]],[["default"],[[[[1,"Edit"]],[]]]]],[1,"\\n"]],[]],null],[1,"            "]],[3]]]]],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[2]],null]],["@model","provider","dd"],false,["each","-track-array","linked-block","array","div","icon","span","if","or","hds/dropdown"]]',moduleName:"vault/components/oidc/provider-list.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/oidc/scope-form",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","ember-concurrency","@ember/service","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p
function f(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function m(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function h(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,o.createTemplateFactory)({id:"vwcONW2c",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n"],[41,[30,2,["isNew"]],[[[1,"        "],[8,[39,3],null,[["@text","@route"],["Scopes","vault.cluster.access.oidc.scopes"]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,3],null,[["@text","@route","@model"],["Details","vault.cluster.access.oidc.scopes.scope.details",[30,2,["name"]]]],null],[1,"\\n"]],[]]],[1,"      "],[8,[39,3],null,[["@text","@current"],[[29,[[52,[30,2,["isNew"]],"Create","Edit"]," Scope"]],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      "],[1,[52,[30,2,["isNew"]],"Create","Edit"]],[1,"\\n      Scope\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelRight"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,5],[[4,[38,6],["click",[28,[37,7],[[28,[37,8],[[30,0,["showTemplateModal"]]],null]],null]],null]],[["@text","@icon","@color"],["How to write JSON template for scopes","bulb","tertiary"]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[11,"form"],[4,[38,6],["submit",[28,[37,10],[[30,0,["save"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[10,2],[14,0,"has-bottom-margin-l"],[12],[1,"\\n      Providers may reference a set of scopes to make specific identity information available as claims\\n    "],[13],[1,"\\n    "],[8,[39,13],null,[["@errorMessage"],[[30,0,["errorBanner"]]]],null],[1,"\\n"],[42,[28,[37,15],[[28,[37,15],[[30,2,["formFields"]]],null]],null],null,[[[1,"      "],[8,[39,16],null,[["@attr","@model","@modelValidations"],[[30,3],[30,2],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[3]],null],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"has-top-margin-l has-bottom-margin-l"],[12],[1,"\\n    "],[8,[39,5],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[30,2,["isNew"]],"Create","Update"],[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n    "],[8,[39,5],[[24,0,"has-left-margin-s"],[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,6],["click",[30,0,["cancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n  "],[13],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[8,[39,17],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n    "],[13],[1,"\\n"]],[]],null],[13],[1,"\\n\\n"],[41,[30,0,["showTemplateModal"]],[[[1,"  "],[8,[39,18],[[24,1,"scope-template-modal"]],[["@size","@onClose"],["large",[28,[37,7],[[28,[37,8],[[30,0,["showTemplateModal"]]],null],false],null]]],[["default"],[[[[1,"\\n    "],[8,[30,4,["Header"]],null,null,[["default"],[[[[1,"\\n      Scope template\\n    "]],[]]]]],[1,"\\n    "],[8,[30,4,["Body"]],null,null,[["default"],[[[[1,"\\n      "],[10,2],[12],[1,"\\n        Example of a JSON template for scopes:\\n      "],[13],[1,"\\n      "],[8,[39,19],null,[["@value","@language","@hasCopyButton"],[[30,0,["exampleTemplate"]],"ruby",true]],null],[1,"\\n      "],[10,2],[14,0,"has-top-margin-m"],[12],[1,"\\n        The full list of template parameters can be found\\n        "],[8,[39,20],null,[["@path"],["/vault/docs/concepts/oidc-provider#scopes"]],[["default"],[[[[1,"\\n          here.\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,4,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,5],[[4,[38,6],["click",[30,5,["close"]]],null]],[["@text"],["Close"]],null],[1,"\\n    "]],[5]]]]],[1,"\\n  "]],[4]]]]],[1,"\\n"]],[]],null]],["p","@model","field","M","F"],false,["page-header","hds/breadcrumb","if","hds/breadcrumb/item","h1","hds/button","on","fn","mut","form","perform","div","p","message-error","each","-track-array","form-field","alert-inline","hds/modal","hds/code-block","doc-link"]]',moduleName:"vault/components/oidc/scope-form.hbs",isStrictMode:!1})
let y=e.default=(s=class extends n.default{constructor(...e){super(...e),f(this,"flashMessages",u,this),f(this,"errorBanner",c,this),f(this,"invalidFormAlert",d,this),f(this,"modelValidations",p,this),m(this,"exampleTemplate",'{\n  "username": {{identity.entity.aliases.$MOUNT_ACCESSOR.name}},\n  "contact": {\n    "email": {{identity.entity.metadata.email}},\n    "phone_number": {{identity.entity.metadata.phone_number}}\n  },\n  "groups": {{identity.entity.groups.names}}\n}')}*save(e){e.preventDefault()
try{const{isValid:e,state:t,invalidFormMessage:n}=this.args.model.validate()
if(this.modelValidations=e?null:t,this.invalidFormAlert=n,e){const{isNew:e,name:t}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`Successfully ${e?"created":"updated"} the scope ${t}.`),this.args.onSave()}}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e,this.invalidFormAlert="There was an error submitting this form."}}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}},u=h(s.prototype,"flashMessages",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=h(s.prototype,"errorBanner",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(s.prototype,"invalidFormAlert",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=h(s.prototype,"modelValidations",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h(s.prototype,"save",[l.task],Object.getOwnPropertyDescriptor(s.prototype,"save"),s.prototype),h(s.prototype,"cancel",[r.action],Object.getOwnPropertyDescriptor(s.prototype,"cancel"),s.prototype),s);(0,t.setComponentTemplate)(b,y)})),define("vault/components/okta-number-challenge",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"DBCTek8e",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"overflow-auto"]],[["@level","@hasBorder"],["high",true]],[["default"],[[[[1,"\\n  "],[10,0],[14,0,"has-padding-l"],[12],[1,"\\n    "],[10,2],[12],[1,"\\n      To finish signing in, you will need to complete an additional MFA step.\\n    "],[13],[1,"\\n"],[41,[30,1],[[[1,"      "],[8,[39,4],[[24,0,"has-top-margin-s"]],[["@errorMessage"],[[30,1]]],null],[1,"\\n"]],[]],[[[41,[30,2],[[[1,"      "],[10,2],[14,0,"has-top-margin-s has-text-black has-text-weight-semibold"],[12],[1,"\\n        Okta verification\\n      "],[13],[1,"\\n      "],[10,2],[12],[1,"Select the following number to complete verification:"],[13],[1,"\\n      "],[10,"h1"],[14,0,"title has-font-weight-normal has-top-margin-m has-bottom-margin-s"],[12],[1,"\\n        "],[1,[30,2]],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[1,"      "],[10,0],[14,0,"has-top-margin-l has-bottom-margin-m is-flex-row"],[12],[1,"\\n        "],[8,[39,6],null,[["@name","@isInline"],["loading",true]],null],[1,"\\n        "],[10,2],[14,0,"has-left-margin-xs"],[12],[1,"Please wait..."],[13],[1,"\\n      "],[13],[1,"\\n    "]],[]]]],[]]],[1,"  "],[13],[1,"\\n  "],[8,[39,7],[[24,0,"has-bottom-margin-s has-left-margin-s"],[4,[38,8],["click",[30,3]],null]],[["@text","@icon","@color"],["Back to login","arrow-left","tertiary"]],null],[1,"\\n"]],[]]]]]],["@hasError","@correctAnswer","@onReturnToLogin"],false,["hds/card/container","div","p","if","message-error","h1","hds/icon","hds/button","on"]]',moduleName:"vault/components/okta-number-challenge.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/overview-card",["exports","core/components/overview-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page-header-level",["exports","core/components/page-header-level"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page-header",["exports","core/components/page-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page/breadcrumbs",["exports","core/components/page/breadcrumbs"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page/error",["exports","core/components/page/error"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/page/userpass-reset-password",["exports","@ember/component","@ember/service","@glimmer/component","@glimmer/tracking","ember-concurrency","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u,c,d
function p(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function f(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const m=(0,a.createTemplateFactory)({id:"C/tct/q0",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Reset password\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[11,"form"],[4,[38,3],["submit",[28,[37,4],[[30,0,["updatePassword"]]],null]],[["on"],["submit"]]],[12],[1,"\\n  "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,6],[[24,0,"has-bottom-margin-m"]],[["@type"],["inline"]],[["default"],[[[[1,"\\n      "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,"Current user"]],[]]]]],[1,"\\n      "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,"You are updating the password for\\n        "],[10,"strong"],[12],[1,[30,3]],[13],[1,"\\n        on the\\n        "],[10,"strong"],[12],[1,[30,4]],[13],[1,"\\n        auth mount."]],[]]]]],[1,"\\n    "]],[2]]]]],[1,"\\n    "],[8,[39,8],[[24,"for","reset-password"]],[["@label"],["New password"]],null],[1,"\\n    "],[8,[39,9],[[24,1,"reset-password"]],[["@name","@value","@onChange"],["reset-password",[30,0,["newPassword"]],[28,[37,10],[[28,[37,11],[[30,0,["newPassword"]]],null]],null]]],null],[1,"\\n  "],[13],[1,"\\n\\n  "],[8,[39,12],[[24,0,"has-top-margin-m"]],null,[["default"],[[[[1,"\\n    "],[8,[39,13],[[16,"disabled",[30,0,["updatePassword","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Save",[52,[30,0,["updatePassword","isRunning"]],"loading"]]],null],[1,"\\n"],[41,[30,0,["error"]],[[[1,"      "],[8,[39,6],[[24,0,"has-left-margin-s"]],[["@type","@color"],["compact","critical"]],[["default"],[[[[1,"\\n        "],[8,[30,5,["Title"]],null,null,[["default"],[[[[1,"Error"]],[]]]]],[1,"\\n        "],[8,[30,5,["Description"]],null,null,[["default"],[[[[1,"\\n          "],[1,[30,0,["error"]]],[1,"\\n        "]],[]]]]],[1,"\\n      "]],[5]]]]],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n"],[13]],["p","A","@username","@backend","A"],false,["page-header","h1","form","on","perform","div","hds/alert","strong","form-field-label","masked-input","fn","mut","hds/button-set","hds/button","if"]]',moduleName:"vault/components/page/userpass-reset-password.hbs",isStrictMode:!1})
let h=e.default=(o=class extends i.default{constructor(...e){super(...e),p(this,"flashMessages",s,this),p(this,"api",u,this),p(this,"newPassword",c,this),p(this,"error",d,this)}onSuccess(){this.error="",this.newPassword="",this.flashMessages.success("Successfully reset password")}*updatePassword(e){e.preventDefault(),this.error=""
const{backend:t,username:n}=this.args
if(t&&n)if(this.newPassword)try{yield this.api.auth.userpassResetPassword(n,t,{password:this.newPassword}),this.onSuccess()}catch(i){const{message:e}=yield this.api.parseError(i,"Check Vault logs for details")
this.error=e}else this.error="Please provide a new password."}},s=f(o.prototype,"flashMessages",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=f(o.prototype,"api",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=f(o.prototype,"newPassword",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),d=f(o.prototype,"error",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f(o.prototype,"updatePassword",[l.task],Object.getOwnPropertyDescriptor(o.prototype,"updatePassword"),o.prototype),o);(0,t.setComponentTemplate)(m,h)})),define("vault/components/pgp-file",["exports","@ember/component","@ember/object","ember-concurrency","@ember/test-waiters","@ember/template-factory"],(function(e,t,n,i,r,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=(0,l.createTemplateFactory)({id:"Lpq6Ko0K",block:'[[[1,"\\n"],[10,0],[14,0,"level is-mobile"],[12],[1,"\\n  "],[10,0],[14,0,"level-left"],[12],[1,"\\n    "],[10,"label"],[14,0,"has-text-weight-bold"],[12],[1,"\\n"],[41,[30,0,["label"]],[[[1,"        "],[1,[30,0,["label"]]],[1,"\\n"]],[]],[[[1,"        PGP KEY\\n        "],[1,[52,[28,[37,3],[[30,0,["index"]],""],null],[28,[37,4],[[30,0,["index"]]],null]]],[1,"\\n"]],[]]],[1,"    "],[13],[1,"\\n  "],[13],[1,"\\n  "],[10,0],[14,0,"level-right"],[12],[1,"\\n    "],[10,0],[14,0,"control is-flex"],[12],[1,"\\n      "],[10,"input"],[15,1,[28,[37,6],["useText-",[30,0,["elementId"]]],null]],[15,3,[28,[37,6],["useText-",[30,0,["elementId"]]],null]],[14,0,"toggle is-success is-small"],[15,"checked",[30,0,["key","enterAsText"]]],[15,"onchange",[28,[37,7],[[30,0],"handleToggle"],null]],[14,4,"checkbox"],[12],[13],[1,"\\n      "],[10,"label"],[15,"for",[28,[37,6],["useText-",[30,0,["elementId"]]],null]],[14,0,"has-text-weight-bold is-size-8"],[12],[1,"\\n        Enter as text\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"],[13],[1,"\\n"],[10,0],[14,0,"field"],[12],[1,"\\n"],[41,[30,0,["key","enterAsText"]],[[[1,"    "],[10,0],[14,0,"control"],[12],[1,"\\n      "],[10,"textarea"],[14,0,"textarea"],[15,"oninput",[28,[37,7],[[30,0],"updateData"],null]],[15,"aria-labelledby",[28,[37,6],["pgpFileTextarea-",[30,0,["elementId"]]],null]],[12],[1,[30,0,["key","value"]]],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,2],[14,0,"help has-text-grey"],[15,1,[28,[37,6],["pgpFileTextarea-",[30,0,["elementId"]]],null]],[12],[1,"\\n"],[41,[30,0,["textareaHelpText"]],[[[1,"        "],[1,[30,0,["textareaHelpText"]]],[1,"\\n"]],[]],[[[1,"        Enter a base64-encoded key\\n"]],[]]],[1,"    "],[13],[1,"\\n"]],[]],[[[1,"    "],[10,0],[14,0,"control is-expanded"],[12],[1,"\\n      "],[10,0],[14,0,"file"],[12],[1,"\\n        "],[10,0],[14,0,"file-label is-fullwidth"],[12],[1,"\\n          "],[10,"input"],[14,1,"file-input"],[14,0,"file-input"],[15,"onchange",[28,[37,7],[[30,0],"pickedFile"],null]],[14,4,"file"],[12],[13],[1,"\\n          "],[10,1],[14,0,"file-cta is-fullwidth"],[12],[1,"\\n            "],[10,1],[14,0,"file-icon has-text-grey-dark"],[12],[1,"\\n              "],[8,[39,11],null,[["@name"],["file"]],null],[1,"\\n            "],[13],[1,"\\n            "],[10,"label"],[14,"for","file-input"],[14,0,"file-label has-text-grey-dark"],[12],[1,"\\n"],[41,[30,0,["key","filename"]],[[[1,"                "],[1,[30,0,["key","filename"]]],[1,"\\n"]],[]],[[[1,"                Choose a file…\\n"]],[]]],[1,"            "],[13],[1,"\\n"],[41,[30,0,["key","filename"]],[[[1,"              "],[8,[39,12],[[24,0,"file-delete-button"],[4,[38,13],["click",[28,[37,7],[[30,0],"clearKey"],null]],null]],[["@text","@icon","@isIconOnly","@color"],["Clear key","x",true,"secondary"]],null],[1,"\\n"]],[]],null],[1,"          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,2],[14,0,"help has-text-grey"],[12],[1,"\\n"],[41,[30,0,["fileHelpText"]],[[[1,"        "],[1,[30,0,["fileHelpText"]]],[1,"\\n"]],[]],[[[1,"        Select a PGP key from your computer\\n"]],[]]],[1,"    "],[13],[1,"\\n"]],[]]],[13]],[],false,["div","label","if","not-eq","inc","input","concat","action","textarea","p","span","icon","hds/button","on"]]',moduleName:"vault/components/pgp-file.hbs",isStrictMode:!1}),o=/^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/gi
e.default=(0,t.setComponentTemplate)(a,t.default.extend({attributeBindings:["data-test-pgp-file"],classNames:["box","is-fullwidth","is-marginless","is-shadowless"],key:null,index:null,onChange:()=>{},label:null,fileHelpText:null,textareaHelpText:null,readFile(e){const t=new FileReader
t.onload=()=>this.setPGPKey.perform(t.result,e.name),t.readAsDataURL(e)},setPGPKey:(0,i.task)((0,r.waitFor)((function*(e,t){const n=e.split(",")[1].trim(),i=atob(n).trim(),r=i.match(o)?i:n
yield this.onChange(this.index,{value:r,filename:t})}))),actions:{handleToggle(e){(0,n.set)(this.key,"enterAsText",e.target.checked)},pickedFile(e){const{files:t}=e.target
if(t.length)for(let n=0,i=t.length;n<i;n++)this.readFile(t[n])},updateData(e){const t=this.key;(0,n.set)(t,"value",e.target.value),this.onChange(this.index,this.key)},clearKey(){this.onChange(this.index,{value:""})}}}))})),define("vault/components/pgp-list",["exports","@ember/component","@ember/template-factory"],(function(e,t,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const i=(0,n.createTemplateFactory)({id:"8k7/sGUG",block:'[[[1,"\\n"],[42,[28,[37,1],[[28,[37,1],[[30,0,["listData"]]],null]],null],null,[[[1,"  "],[8,[39,2],null,[["@key","@index","@onChange"],[[30,1],[30,2],[28,[37,3],[[30,0],"setKey"],null]]],null],[1,"\\n"]],[1,2]],[[[1,"  "],[10,2],[14,0,"has-text-grey"],[12],[1,"\\n    Enter a number of Key Shares to enter PGP keys.\\n  "],[13],[1,"\\n"]],[]]]],["key","index"],false,["each","-track-array","pgp-file","action","p"]]',moduleName:"vault/components/pgp-list.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(i,t.default.extend({onDataUpdate:()=>{},listLength:0,listData:null,init(){this._super(...arguments)
let e=this.listLength
e&&(e=parseInt(e,10))
const t=this.newList(e)
this.set("listData",t)},didReceiveAttrs(){let e
this._super(...arguments),this.listLength?this.listData.length!==this.listLength&&(this.listLength<this.listData.length?e=this.listData.slice(0,this.listLength):this.listLength>this.listData.length&&(e=[...this.listData,...this.newList(this.listLength-this.listData.length)]),this.set("listData",e||this.listData),this.onDataUpdate((e||this.listData).compact().map((e=>e.value)))):this.set("listData",[])},newList:e=>Array(e||0).fill(null).map((()=>({value:""}))),actions:{setKey(e,t){const{listData:n}=this
n.splice(e,1,t),this.onDataUpdate(n.compact().map((e=>e.value)))}}}))})),define("vault/components/plugin-documentation-flyout",["exports","@ember/component","@glimmer/component","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"eoOrw8Fv",block:'[[[1,"\\n"],[41,[30,1],[[[1,"  "],[8,[39,1],null,[["@onClose"],[[30,2]]],[["default"],[[[[1,"\\n    "],[8,[30,3,["Header"]],null,[["@icon"],["info"]],[["default"],[[[[1,"\\n"],[41,[30,0,["hasPlugin"]],[[[1,"        "],[1,[30,0,["displayName"]]],[1,"\\n        plugin information\\n"]],[]],[[[1,"        External plugins information\\n"]],[]]],[1,"    "]],[]]]]],[1,"\\n\\n    "],[8,[30,3,["Body"]],null,null,[["default"],[[[[1,"\\n      "],[10,0],[14,0,"has-bottom-margin-m"],[12],[1,"\\n"],[41,[30,0,["hasPlugin"]],[[[1,"          "],[8,[39,3],null,null,[["default"],[[[[1,"\\n            The\\n            "],[10,"strong"],[12],[1,[30,0,["displayName"]]],[13],[1,"\\n            "],[1,[30,0,["pluginTypeDisplay"]]],[1,"\\n            is not currently enabled in this Vault instance. To use this plugin, it needs to be enabled by a Vault\\n            administrator.\\n          "]],[]]]]],[1,"\\n"]],[]],[[[1,"          "],[8,[39,3],null,null,[["default"],[[[[1,"\\n            External plugins are plugins found in the plugin catalog that are not part of Vault\'s built-in engines. These may\\n            be custom plugins or third-party plugins that have been registered with your Vault instance.\\n          "]],[]]]]],[1,"\\n          "],[8,[39,3],[[24,0,"has-top-margin-s"]],null,[["default"],[[[[1,"\\n            External plugins appear in the catalog when they have been registered using the\\n            "],[10,"code"],[14,"aria-label","vault plugin register command"],[12],[1,"vault plugin register"],[13],[1,"\\n            command or through the Vault API. They provide additional functionality beyond Vault\'s built-in secrets engines\\n            and authentication methods.\\n          "]],[]]]]],[1,"\\n"]],[]]],[1,"      "],[13],[1,"\\n\\n      "],[10,0],[12],[1,"\\n        "],[8,[39,6],[[24,0,"has-bottom-margin-xs"]],[["@tag","@size"],["h3","300"]],[["default"],[[[[1,"\\n          Documentation\\n        "]],[]]]]],[1,"\\n"],[41,[30,0,["hasPlugin"]],[[[1,"          "],[8,[39,3],null,null,[["default"],[[[[1,"\\n            For more information about configuring and using the\\n            "],[1,[30,0,["displayName"]]],[1,"\\n            "],[1,[30,0,["pluginTypeDisplay"]]],[1,", visit the official documentation:\\n          "]],[]]]]],[1,"\\n"]],[]],[[[1,"          "],[8,[39,3],null,null,[["default"],[[[[1,"\\n            For more information about registering and managing external plugins, visit the official documentation:\\n          "]],[]]]]],[1,"\\n"]],[]]],[1,"        "],[10,0],[14,0,"has-top-margin-xs"],[12],[1,"\\n          "],[8,[39,7],[[24,"target","_blank"],[24,"rel","noopener noreferrer"]],[["@text","@href","@icon","@iconPosition"],["Register and enable external plugins","https://developer.hashicorp.com/vault/docs/plugins/register","external-link","trailing"]],null],[1,"\\n"],[41,[51,[30,0,["hasPlugin"]]],[[[1,"            "],[10,0],[14,0,"has-top-margin-xs"],[12],[1,"\\n              "],[8,[39,7],[[24,"target","_blank"],[24,"rel","noopener noreferrer"]],[["@text","@href","@icon","@iconPosition"],["Plugin development guide","https://developer.hashicorp.com/vault/docs/plugins/plugin-development","external-link","trailing"]],null],[1,"\\n            "],[13],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n\\n    "],[8,[30,3,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,9],null,null,[["default"],[[[[1,"\\n        "],[8,[39,10],[[4,[38,11],["click",[30,2]],null]],[["@text","@color"],["Close","primary"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[3]]]]],[1,"\\n"]],[]],null]],["@isOpen","@onClose","F"],false,["if","hds/flyout","div","hds/text/body","strong","code","hds/text/display","hds/link/standalone","unless","hds/button-set","hds/button","on"]]',moduleName:"vault/components/plugin-documentation-flyout.hbs",isStrictMode:!1})
class l extends n.default{get displayName(){return this.args.displayName||this.args.plugin?.displayName||this.args.pluginName||this.args.plugin?.type||"Plugin"}get pluginTypeDisplay(){return"secret"===this.args.pluginType?"secrets engine":"auth method"}get hasPlugin(){return!!(this.args.plugin||this.args.pluginName||this.args.displayName)}}e.default=l,(0,t.setComponentTemplate)(r,l)})),define("vault/components/policy-example",["exports","core/components/policy-example"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/policy-form",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","ember-concurrency","vault/utils/trim-right","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d,p,f
function m(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function h(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,s.createTemplateFactory)({id:"lH558EJz",block:'[[[1,"\\n"],[11,"form"],[4,[38,1],["submit",[28,[37,2],[[30,0,["save"]]],null]],null],[12],[1,"\\n  "],[10,0],[14,0,"box is-shadowless is-fullwidth is-marginless"],[12],[1,"\\n    "],[8,[39,4],null,[["@errorMessage"],[[30,0,["errorBanner"]]]],null],[1,"\\n    "],[8,[39,5],null,[["@mode","@noun"],[[52,[30,1,["isNew"]],"create","edit"],"policy"]],null],[1,"\\n"],[41,[30,1,["isNew"]],[[[1,"      "],[10,0],[14,0,"field"],[12],[1,"\\n        "],[10,"label"],[14,"for","policy-name"],[14,0,"is-label"],[12],[1,"Name"],[13],[1,"\\n        "],[10,0],[14,0,"control"],[12],[1,"\\n          "],[8,[39,8],[[24,1,"policy-name"],[24,0,"input"],[4,[38,1],["input",[30,0,["setModelName"]]],null]],[["@type","@value"],["text",[28,[37,9],[[30,1,["name"]]],null]]],null],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"    "],[10,0],[14,0,"field"],[12],[1,"\\n      "],[8,[39,10],[[16,"aria-label",[29,["toolbar for managing ",[28,[37,11],[[30,1,["name"]],"new"],null]," policy"]]]],null,[["default"],[[[[1,"\\n"],[41,[30,2],[[[1,"          "],[8,[39,12],[[16,"aria-label",[29,["help tools for managing ",[28,[37,11],[[30,1,["name"]],"new"],null]," policy"]]]],null,[["default"],[[[[1,"\\n            "],[8,[39,13],[[4,[38,1],["click",[28,[37,14],[[28,[37,15],[[30,0,["showTemplateModal"]]],null]],null]],null]],[["@text","@icon","@size","@color"],["How to write a policy","bulb","small","tertiary"]],null],[1,"\\n          "]],[]]]]],[1,"\\n"]],[]],null],[41,[30,1,["isNew"]],[[[1,"          "],[8,[39,16],[[16,"aria-label",[29,["actions for managing ",[28,[37,11],[[30,1,["name"]],"new"],null]," policy"]]]],null,[["default"],[[[[1,"\\n            "],[10,0],[14,0,"control is-flex"],[12],[1,"\\n              "],[8,[39,8],[[24,1,"fileUploadToggle"],[24,3,"fileUploadToggle"],[24,0,"toggle is-success is-small"],[4,[38,1],["change",[28,[37,14],[[28,[37,15],[[30,0,["showFileUpload"]]],null],[28,[37,17],[[30,0,["showFileUpload"]]],null]],null]],null]],[["@type","@checked"],["checkbox",[30,0,["showFileUpload"]]]],null],[1,"\\n              "],[10,"label"],[14,"for","fileUploadToggle"],[14,0,"has-text-weight-bold is-size-8"],[12],[1,"Upload file"],[13],[1,"\\n            "],[13],[1,"\\n          "]],[]]]]],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n"],[41,[30,0,["showFileUpload"]],[[[1,"        "],[10,0],[14,0,"has-top-margin-xs"],[12],[1,"\\n          "],[8,[39,18],null,[["@uploadOnly","@onChange"],[true,[30,0,["setPolicyFromFile"]]]],null],[1,"\\n        "],[13],[1,"\\n"]],[]],[[[1,"        "],[8,[39,19],null,[["@title","@value","@valueUpdated","@mode","@extraKeys"],["Policy",[30,1,["policy"]],[28,[37,20],[[30,0],[28,[37,15],[[30,1,["policy"]]],null]],null],"ruby",[28,[37,21],null,[["Shift-Enter"],[[28,[37,2],[[30,0,["save"]]],null]]]]]],null],[1,"\\n"]],[]]],[1,"    "],[13],[1,"\\n"],[42,[28,[37,23],[[28,[37,23],[[30,1,["additionalAttrs"]]],null]],null],null,[[[1,"      "],[8,[39,24],null,[["@attr","@model"],[[30,3],[30,1]]],null],[1,"\\n"]],[3]],null],[1,"  "],[13],[1,"\\n  "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n    "],[8,[39,25],null,null,[["default"],[[[[1,"\\n      "],[8,[39,13],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],[[52,[30,1,["isNew"]],"Create policy","Save"],[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n      "],[8,[39,13],[[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,1],["click",[30,0,["cancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "],[13],[1,"\\n"],[13],[1,"\\n\\n"],[41,[30,0,["showTemplateModal"]],[[[1,"  "],[8,[39,26],[[24,1,"policy-example-modal"]],[["@size","@onClose"],["large",[28,[37,14],[[28,[37,15],[[30,0,["showTemplateModal"]]],null],false],null]]],[["default"],[[[[1,"\\n    "],[8,[30,4,["Header"]],null,null,[["default"],[[[[1,"\\n      Example\\n      "],[1,[28,[35,27],[[30,1,["policyType"]]],null]],[1,"\\n      Policy\\n    "]],[]]]]],[1,"\\n    "],[8,[30,4,["Body"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,28],null,[["@policyType"],[[30,1,["policyType"]]]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,4,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,13],[[4,[38,1],["click",[30,5,["close"]]],null]],[["@text"],["Close"]],null],[1,"\\n    "]],[5]]]]],[1,"\\n  "]],[4]]]]],[1,"\\n"]],[]],null]],["@model","@renderPolicyExampleModal","attr","M","F"],false,["form","on","perform","div","message-error","namespace-reminder","if","label","input","lowercase","toolbar","or","toolbar-filters","hds/button","fn","mut","toolbar-actions","not","text-file","json-editor","action","hash","each","-track-array","form-field","hds/button-set","hds/modal","uppercase","policy-example"]]',moduleName:"vault/components/policy-form.hbs",isStrictMode:!1})
let y=e.default=(u=class extends n.default{constructor(...e){super(...e),m(this,"flashMessages",c,this),m(this,"errorBanner",d,this),m(this,"showFileUpload",p,this),m(this,"showTemplateModal",f,this)}*save(e){e.preventDefault()
try{const{name:e,policyType:t,isNew:n}=this.args.model
yield this.args.model.save(),this.flashMessages.success(`${t.toUpperCase()} policy "${e}" was successfully ${n?"created":"updated"}.`),this.args.onSave(this.args.model)}catch(t){const e=t.errors?t.errors.join(". "):t.message
this.errorBanner=e}}setModelName({target:e}){this.args.model.name=e.value.toLowerCase()}setPolicyFromFile(e){const{value:t,filename:n}=e
if(this.args.model.policy=t,!this.args.model.name){const e=(0,a.default)(n,[".json",".txt",".hcl",".policy"])
this.args.model.name=e.toLowerCase()}this.showFileUpload=!1}cancel(){const e=this.args.model.isNew?"unloadRecord":"rollbackAttributes"
this.args.model[e](),this.args.onCancel()}},c=h(u.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(u.prototype,"errorBanner",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p=h(u.prototype,"showFileUpload",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),f=h(u.prototype,"showTemplateModal",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),h(u.prototype,"save",[l.task],Object.getOwnPropertyDescriptor(u.prototype,"save"),u.prototype),h(u.prototype,"setModelName",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"setModelName"),u.prototype),h(u.prototype,"setPolicyFromFile",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"setPolicyFromFile"),u.prototype),h(u.prototype,"cancel",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"cancel"),u.prototype),u);(0,t.setComponentTemplate)(b,y)})),define("vault/components/portal-target",["exports","ember-stargate/components/portal-target"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/portal",["exports","ember-stargate/components/portal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select-multiple",["exports","ember-power-select/components/power-select-multiple"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select-multiple/input",["exports","ember-power-select/components/power-select-multiple/input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select-multiple/trigger",["exports","ember-power-select/components/power-select-multiple/trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select",["exports","ember-power-select/components/power-select"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/power-select/before-options",["exports","ember-power-select/components/power-select/before-options"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/input",["exports","ember-power-select/components/power-select/input"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/label",["exports","ember-power-select/components/power-select/label"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/no-matches-message",["exports","ember-power-select/components/power-select/no-matches-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/options",["exports","ember-power-select/components/power-select/options"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/placeholder",["exports","ember-power-select/components/power-select/placeholder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/power-select-group",["exports","ember-power-select/components/power-select/power-select-group"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/search-message",["exports","ember-power-select/components/power-select/search-message"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/power-select/trigger",["exports","ember-power-select/components/power-select/trigger"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/qr-code",["exports","ember-qrcode-shim/components/qr-code"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/radial-progress",["exports","@ember/component","@ember/object","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"7fvlBqMs",block:'[[[1,"\\n"],[10,"circle"],[14,0,"path"],[15,"cx",[30,0,["centerValue"]]],[15,"cy",[30,0,["centerValue"]]],[15,"r",[30,0,["r"]]],[14,"fill","none"],[15,"stroke-width",[30,0,["strokeWidth"]]],[12],[13],[1,"\\n"],[10,"circle"],[14,0,"progress-fill"],[15,"cx",[30,0,["centerValue"]]],[15,"cy",[30,0,["centerValue"]]],[15,"r",[30,0,["r"]]],[14,"fill","none"],[15,"stroke-width",[30,0,["strokeWidth"]]],[15,"stroke-dasharray",[30,0,["c"]]],[15,"stroke-dashoffset",[30,0,["dashArrayOffset"]]],[12],[13]],[],false,["circle"]]',moduleName:"vault/components/radial-progress.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,t.default.extend({tagName:"svg",classNames:"radial-progress",attributeBindings:["size:width","size:height","viewBox","data-test-radial-progress"],progressDecimal:null,size:20,strokeWidth:1,viewBox:(0,n.computed)("size",(function(){const e=this.size
return`0 0 ${e} ${e}`})),centerValue:(0,n.computed)("size",(function(){return this.size/2})),r:(0,n.computed)("size","strokeWidth",(function(){return(this.size-this.strokeWidth)/2})),c:(0,n.computed)("r",(function(){return 2*Math.PI*this.r})),dashArrayOffset:(0,n.computed)("c","progressDecimal",(function(){return this.c*(1-this.progressDecimal)}))}))})),define("vault/components/radio-button",["exports","core/components/radio-button"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/radio-card",["exports","core/components/radio-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/raft-join",["exports","@ember/component","@ember/service","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"Nnu0n1Bx",block:'[[[1,"\\n"],[8,[39,0],null,[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n  "],[8,[30,1,["Title"]],[[24,0,"alert-title"]],null,[["default"],[[[[1,"Vault is sealed"]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n"],[41,[30,0,["showJoinForm"]],[[[1,"  "],[10,0],[14,0,"box is-marginless is-shadowless"],[12],[1,"\\n    "],[10,"h2"],[14,0,"title is-5"],[12],[1,"\\n      Join an existing Raft cluster\\n    "],[13],[1,"\\n    "],[8,[39,4],null,[["@model","@saveButtonText","@cancelButtonText","@onCancel","@onSave","@flashEnabled","@includeBox"],[[28,[37,5],[[28,[37,6],[[30,0],"newModel"],null]],null],"Join","Back",[28,[37,6],[[30,0],[28,[37,7],[[30,0,["showJoinForm"]]],null],false],null],[28,[37,8],["vault.cluster.unseal"],null],false,false]],null],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[10,"form"],[15,"onsubmit",[28,[37,6],[[30,0],"advanceFirstScreen"],null]],[12],[1,"\\n    "],[10,0],[14,0,"box is-marginless is-shadowless"],[12],[1,"\\n      "],[10,"h2"],[14,0,"title is-6"],[12],[1,"\\n        This server is configured to use Raft Storage.\\n        "],[10,"br"],[12],[13],[1,"\\n        "],[10,"br"],[12],[13],[1,"\\n        How do you want to get started?\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"has-bottom-margin-s"],[12],[1,"\\n        "],[8,[39,11],[[24,1,"join"],[24,3,"setup-pref"]],[["@value","@groupValue","@onChange"],["join",[30,0,["preference"]],[28,[37,12],[[28,[37,7],[[30,0,["preference"]]],null]],null]]],null],[1,"\\n        "],[10,"label"],[14,"for","join"],[12],[1,"Join an existing Raft cluster"],[13],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[12],[1,"\\n        "],[8,[39,11],[[24,1,"init"],[24,3,"setup-pref"]],[["@value","@groupValue","@onChange"],["init",[30,0,["preference"]],[28,[37,12],[[28,[37,7],[[30,0,["preference"]]],null]],null]]],null],[1,"\\n        "],[10,"label"],[14,"for","init"],[12],[1,"Create a new Raft cluster"],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"box is-marginless is-shadowless"],[12],[1,"\\n      "],[8,[39,14],[[24,4,"submit"]],[["@text"],["Next"]],null],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]]],["A"],false,["hds/alert","if","div","h2","edit-form","compute","action","mut","transition-to","form","br","radio-button","fn","label","hds/button"]]',moduleName:"vault/components/raft-join.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,t.default.extend({classNames:"raft-join",store:(0,n.service)(),onDismiss(){},preference:"join",showJoinForm:!1,actions:{advanceFirstScreen(e){e.preventDefault(),"join"===this.preference?this.set("showJoinForm",!0):this.onDismiss()},newModel(){return this.store.createRecord("raft-join")}}}))})),define("vault/components/raft-storage-overview",["exports","@ember/component","@ember/owner","vault/config/environment","@ember/service","@ember/template-factory"],(function(e,t,n,i,r,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=(0,l.createTemplateFactory)({id:"YAR3WAB+",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-top-margin-xl has-bottom-margin-m"]],null,[["default"],[[[[1,"\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Raft Storage"]],[]]]]],[1,"\\n  "],[8,[30,1,["Actions"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[30,2,["ToggleButton"]],null,[["@text","@color"],["Snapshots","secondary"]],null],[1,"\\n"],[41,[30,0,["useServiceWorker"]],[[[1,"        "],[8,[30,2,["Interactive"]],[[4,[38,3],["click",[28,[37,4],[[30,0],"downloadViaServiceWorker"],null]],null]],[["@href","@isHrefExternal"],["/v1/sys/storage/raft/snapshot",false]],[["default"],[[[[1,"Download"]],[]]]]],[1,"\\n"]],[]],[[[1,"        "],[8,[30,2,["Interactive"]],[[4,[38,3],["click",[28,[37,4],[[30,0],"downloadSnapshot"],null]],null]],null,[["default"],[[[[1,"Download"]],[]]]]],[1,"\\n"]],[]]],[1,"      "],[8,[30,2,["Interactive"]],null,[["@route"],["vault.cluster.storage-restore"]],[["default"],[[[[1,"Restore"]],[]]]]],[1,"\\n    "]],[2]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[8,[39,5],null,[["@caption"],["Raft servers"]],[["head","body"],[[[[1,"\\n    "],[8,[30,3,["Tr"]],null,null,[["default"],[[[[1,"\\n      "],[8,[30,3,["Th"]],null,null,[["default"],[[[[1,"Address"]],[]]]]],[1,"\\n      "],[8,[30,3,["Th"]],null,null,[["default"],[[[[1,"Leader"]],[]]]]],[1,"\\n      "],[8,[30,3,["Th"]],null,null,[["default"],[[[[1,"Voter"]],[]]]]],[1,"\\n      "],[8,[30,3,["Th"]],null,[["@align"],["right"]],[["default"],[[[[1,"Actions"]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[3]],[[[1,"\\n"],[42,[28,[37,9],[[28,[37,9],[[30,5]],null]],null],null,[[[1,"      "],[8,[30,4,["Tr"]],[[24,"data-raft-row",""]],null,[["default"],[[[[1,"\\n        "],[8,[30,4,["Td"]],null,null,[["default"],[[[[1,[30,6,["address"]]]],[]]]]],[1,"\\n        "],[8,[30,4,["Td"]],null,null,[["default"],[[[[41,[30,6,["leader"]],[[[1,"\\n            "],[8,[39,10],null,[["@text","@type","@color","@icon"],["Yes","outlined","success","check-circle"]],null],[1,"\\n"]],[]],[[[1,"            "],[8,[39,10],null,[["@text","@type","@icon"],["No","outlined","x-square"]],null],[1,"\\n"]],[]]],[1,"        "]],[]]]]],[1,"\\n        "],[8,[30,4,["Td"]],null,null,[["default"],[[[[1,"\\n"],[41,[30,6,["voter"]],[[[1,"            "],[8,[39,10],null,[["@text","@type","@color","@icon"],["Yes","outlined","success","check-circle"]],null],[1,"\\n"]],[]],[[[1,"            "],[8,[39,10],null,[["@text","@type","@icon"],["No","outlined","x-square"]],null],[1,"\\n"]],[]]],[1,"        "]],[]]]]],[1,"\\n        "],[8,[30,4,["Td"]],null,[["@align"],["right"]],[["default"],[[[[1,"\\n          "],[8,[39,1],null,[["@isInline"],[true]],[["default"],[[[[1,"\\n            "],[8,[30,7,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal","Raft server actions",false]],null],[1,"\\n            "],[8,[30,7,["Generic"]],null,null,[["default"],[[[[1,"\\n              "],[8,[39,11],null,[["@isInDropdown","@onConfirmAction","@buttonText","@confirmTitle","@confirmMessage"],[true,[28,[37,4],[[30,0],"removePeer",[30,6]],null],"Remove Peer",[29,["Remove ",[30,6,["nodeId"]],"?"]],"This will remove the server from the raft cluster."]],null],[1,"\\n            "]],[]]]]],[1,"\\n          "]],[7]]]]],[1,"\\n        "]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n"]],[6]],null],[1,"  "]],[4]]]]]],["PH","dd","H","B","@model","server","dd"],false,["hds/page-header","hds/dropdown","if","on","action","hds/table",":head",":body","each","-track-array","hds/badge","confirm-action"]]',moduleName:"vault/components/raft-storage-overview.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(a,t.default.extend({flashMessages:(0,r.service)(),auth:(0,r.service)(),useServiceWorker:null,async init(){if(this._super(...arguments),!1!==this.useServiceWorker&&"serviceWorker"in navigator){await navigator.serviceWorker.getRegistration(i.default.serviceWorkerScope)&&(navigator.serviceWorker.addEventListener("message",this.serviceWorkerGetToken.bind(this)),this.set("useServiceWorker",!0))}},willDestroy(){this.useServiceWorker&&navigator.serviceWorker.removeEventListener("message",this.serviceWorkerGetToken),this._super(...arguments)},serviceWorkerGetToken(e){const{action:t}=e.data,[n]=e.ports
"getToken"===t?n.postMessage({token:this.auth.currentToken}):(console.error("Unknown event",e),n.postMessage({error:"Unknown request"}))},actions:{async removePeer(e){const{nodeId:t}=e
try{await e.destroyRecord()}catch(n){const e=n.errors?n.errors.join(" "):n.message||n
return void this.flashMessages.danger(`There was an issue removing the peer ${t}: ${e}`)}this.flashMessages.success(`Successfully removed the peer: ${t}.`)},downloadViaServiceWorker(){this.flashMessages.success("The snapshot download will begin shortly.")},async downloadSnapshot(){const e=(0,n.getOwner)(this).lookup("adapter:application")
let t,i
this.flashMessages.success("The snapshot download has begun.")
try{t=await e.rawRequest("/v1/sys/storage/raft/snapshot","GET"),i=await t.blob()}catch(s){const e=s.errors?s.errors.join(" "):s.message||s
this.flashMessages.danger(`There was an error trying to download the snapshot: ${e}`)}const r="snapshot.gz",l=new Blob([i],{type:"application/x-gzip"})
if(l.name=r,"msSaveOrOpenBlob"in navigator)return void navigator.msSaveOrOpenBlob(l,r)
const a=document.createElement("a"),o=window.URL.createObjectURL(l)
a.href=o,a.download=r,document.body.appendChild(a),a.click(),a.remove(),window.URL.revokeObjectURL(o)}}}))})),define("vault/components/raft-storage-restore",["exports","@ember/component","ember-concurrency","@ember/owner","@ember/service","@ember/object/computed","@ember/template-factory"],(function(e,t,n,i,r,l,a){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,a.createTemplateFactory)({id:"B67dS2mb",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@text","@route"],["Raft Storage","vault.cluster.storage"]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@current"],["Restore Snapshot",true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n      Restore Snapshot\\n    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[11,"form"],[4,[38,5],[[30,0],[28,[37,6],[[30,0,["restore"]],[30,0,["file"]]],null]],[["on"],["submit"]]],[12],[1,"\\n  "],[8,[39,7],null,[["@errors"],[[30,0,["errors"]]]],null],[1,"\\n\\n"],[41,[30,0,["isUploading"]],[[[1,"    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,10],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n        "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,"Uploading your file..."]],[]]]]],[1,"\\n        "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,"Raft snapshots can be very large files. Uploading the snapshot may take some time."]],[]]]]],[1,"\\n      "]],[2]]]]],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"box is-fullwidth is-shadowless"],[12],[1,"\\n      "],[8,[39,11],[[4,[38,12],["click",[28,[37,5],[[30,0],"cancelUpload"],null]],null]],[["@text","@color"],["Cancel upload","secondary"]],null],[1,"\\n    "],[13],[1,"\\n"]],[]],[[[1,"    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,10],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n        "],[8,[30,3,["Title"]],null,null,[["default"],[[[[1,"This might take a while"]],[]]]]],[1,"\\n        "],[8,[30,3,["Description"]],null,null,[["default"],[[[[1,"Raft snapshots can be very large files. Uploading the snapshot may take some time."]],[]]]]],[1,"\\n      "]],[3]]]]],[1,"\\n      "],[8,[39,13],null,[["@label","@onChange"],["Choose a file...",[28,[37,5],[[30,0],[28,[37,14],[[30,0,["file"]]],null]],null]]],null],[1,"\\n      "],[10,0],[14,0,"b-checkbox"],[12],[1,"\\n        "],[10,"input"],[14,1,"force-restore"],[14,0,"styled"],[15,"checked",[30,0,["forceRestore"]]],[15,"onchange",[28,[37,5],[[30,0],[28,[37,14],[[30,0,["forceRestore"]]],null]],[["value"],["target.checked"]]]],[14,4,"checkbox"],[12],[13],[1,"\\n        "],[10,"label"],[14,"for","force-restore"],[14,0,"is-label"],[12],[1,"\\n          Force restore\\n        "],[13],[1,"\\n        "],[10,2],[14,0,"checkbox-help-text"],[12],[1,"\\n          Bypass checks to ensure the AutoUnseal or Shamir keys are consistent with the snapshot data.\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[8,[39,18],null,[["@saveButtonText","@isSaving","@cancelLinkParams"],["Restore",[30,0,["restore","isRunning"]],[28,[37,19],["vault.cluster.storage"],null]]],null],[1,"\\n"]],[]]],[13]],["p","A","A"],false,["page-header","hds/breadcrumb","hds/breadcrumb/item","h1","form","action","perform","message-error","if","div","hds/alert","hds/button","on","file-to-array-buffer","mut","input","label","p","form-save-buttons","array"]]',moduleName:"vault/components/raft-storage-restore.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(o,t.default.extend({file:null,errors:null,forceRestore:!1,flashMessages:(0,r.service)(),isUploading:(0,l.alias)("restore.isRunning"),abortController:null,restore:(0,n.task)((function*(){this.set("errors",null)
const e=(0,i.getOwner)(this).lookup("adapter:application")
try{let t="/v1/sys/storage/raft/snapshot"
this.forceRestore&&(t=`${t}-force`)
const n=new Blob([this.file],{type:"application/gzip"}),i=new AbortController
this.set("abortController",i),yield e.rawRequest(t,"POST",{body:n,signal:i.signal}),this.flashMessages.success("The snapshot was successfully uploaded!")}catch(t){if("AbortError"===t.name)return
let e
t.json&&(e=yield t.json())
const n=e?e.errors:[t]
this.set("errors",n)}})),actions:{cancelUpload(){this.abortController.abort()}}}))})),define("vault/components/read-more",["exports","core/components/read-more"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/readonly-form-field",["exports","core/components/readonly-form-field"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/recovery/page/header",["exports","@ember/component","@glimmer/component","@ember/service","@ember/template-factory"],(function(e,t,n,i,r){var l,a
Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,r.createTemplateFactory)({id:"myBvle/G",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"has-top-padding-l has-bottom-padding-m"]],null,[["default"],[[[[1,"\\n"],[41,[30,2],[[[1,"    "],[8,[30,1,["Breadcrumb"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@breadcrumbs"],[[30,2]]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"\\n    "],[1,[30,3]],[1,"\\n"],[41,[30,0,["version","isCommunity"]],[[[1,"      "],[8,[39,3],null,[["@text","@color"],["Enterprise","highlight"]],null],[1,"\\n"]],[]],null],[1,"  "]],[]]]]],[1,"\\n\\n  "],[8,[30,1,["Subtitle"]],null,null,[["default"],[[[[1,"\\n    "],[1,[30,4]],[1,"\\n  "]],[]]]]],[1,"\\n\\n"],[41,[30,5],[[[1,"    "],[8,[30,1,["Actions"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,4],null,[["@text","@icon","@iconPosition","@color","@route","@models"],[[30,5,["text"]],[30,5,["icon"]],[30,5,["iconPosition"]],[30,5,["color"]],[30,5,["route"]],[30,5,["models"]]]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null]],[1]]]]]],["PH","@breadcrumbs","@title","@subtitle","@action"],false,["hds/page-header","if","page/breadcrumbs","hds/badge","hds/button"]]',moduleName:"vault/components/recovery/page/header.hbs",isStrictMode:!1})
let s=e.default=(l=class extends n.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="version",r=this,(i=a)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}},u=l.prototype,c="version",d=[i.service],p={configurable:!0,enumerable:!0,writable:!0,initializer:null},m={},Object.keys(p).forEach((function(e){m[e]=p[e]})),m.enumerable=!!m.enumerable,m.configurable=!!m.configurable,("value"in m||m.initializer)&&(m.writable=!0),m=d.slice().reverse().reduce((function(e,t){return t(u,c,e)||e}),m),f&&void 0!==m.initializer&&(m.value=m.initializer?m.initializer.call(f):void 0,m.initializer=void 0),a=void 0===m.initializer?(Object.defineProperty(u,c,m),null):m,l)
var u,c,d,p,f,m;(0,t.setComponentTemplate)(o,s)})),define("vault/components/recovery/page/snapshots",["exports","@ember/component","@glimmer/component","@ember/service","@ember/template-factory"],(function(e,t,n,i,r){var l,a
function o(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const s=(0,r.createTemplateFactory)({id:"rarLUmAZ",block:'[[[1,"\\n"],[8,[39,0],null,[["@title","@subtitle"],["Secrets Recovery","Recover lost or deleted data from a raft snapshot. Supported data includes KV v1 and Cubbyhole secrets or Database static roles."]],null],[1,"\\n\\n"],[41,[30,1,["showCommunityMessage"]],[[[1,"  "],[8,[39,2],null,[["@title","@icon","@message"],["Secrets Recovery is an enterprise feature","sync-reverse","Secrets Recovery allows you to restore accidentally deleted or lost secrets from a snapshot. The snapshots can be provided via upload or loaded from external storage."]],[["default"],[[[[1,"\\n    "],[8,[39,3],null,[["@text","@color","@icon","@iconPosition","@href","@isHrefExternal"],["Learn more about upgrading","tertiary","docs-link","trailing",[28,[37,4],["/vault/docs/enterprise"],null],true]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],[[[41,[28,[37,5],[[30,1,["snapshots"]]],null],[[[44,[[28,[37,7],[[30,0,["emptyStateDetails"]],[30,0,["state"]]],null]],[[[1,"    "],[8,[39,2],null,[["@title","@icon","@message"],[[30,2,["title"]],[30,2,["icon"]],[30,2,["message"]]]],[["default"],[[[[1,"\\n\\n"],[41,[28,[37,8],[[30,0,["state"]],[30,0,["viewState","ALLOW_UPLOAD"]]],null],[[[1,"        "],[8,[39,3],null,[["@text","@color","@route"],[[30,2,["buttonText"]],[30,2,["buttonColor"]],"vault.cluster.recovery.snapshots.load"]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,3],null,[["@text","@color","@icon","@iconPosition","@route","@query","@href","@isHrefExternal"],[[30,2,["buttonText"]],[30,2,["buttonColor"]],[30,2,["buttonIcon"]],"trailing",[30,2,["buttonRoute"]],[52,[30,2,["buttonRoute"]],[28,[37,9],null,[["namespace"],[""]]]],[28,[37,4],[[30,2,["buttonHref"]]],null],[52,[30,2,["buttonHref"]],true]]],null],[1,"\\n"]],[]]],[1,"    "]],[]]]]],[1,"\\n"]],[2]]]],[]],null]],[]]]],["@model","d"],false,["recovery/page/header","if","empty-state","hds/button","doc-link","not","let","get","eq","hash"]]',moduleName:"vault/components/recovery/page/snapshots.hbs",isStrictMode:!1})
var u=function(e){return e.NON_ROOT_NAMESPACE="non-root-namespace",e.ALLOW_UPLOAD="default",e.CANNOT_UPLOAD="cannot-upload",e}(u||{})
let c=e.default=(l=class extends n.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="namespace",r=this,(i=a)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0}),o(this,"viewState",u),o(this,"emptyStateDetails",{[this.viewState.NON_ROOT_NAMESPACE]:{title:"Snapshot upload is restricted",icon:"sync-reverse",message:"Snapshot uploading is only available in root namespace. Please navigate to root and upload your snapshot.",buttonText:"Take me to root namespace",buttonRoute:"vault.cluster.dashboard",buttonIcon:"arrow-right",buttonColor:"tertiary"},[this.viewState.CANNOT_UPLOAD]:{title:"No snapshot available",icon:"skip",message:"Ready to restore secrets? Please contact your admin to either upload a snapshot or grant you uploading permissions to get started.",buttonText:"Learn more about Secrets Recovery",buttonHref:"/vault/docs/sysadmin/snapshots/restore",buttonIcon:"docs-link",buttonColor:"tertiary"},[this.viewState.ALLOW_UPLOAD]:{title:"Upload a snapshot to get started",icon:"sync-reverse",message:"Secrets Recovery allows you to restore accidentally deleted or lost secrets from a snapshot. The snapshots can be provided via upload or loaded from external storage.",buttonText:"Upload snapshot",buttonColor:"primary"}})}get state(){const{canLoadSnapshot:e}=this.args.model
return this.namespace.inRootNamespace?e?this.viewState.ALLOW_UPLOAD:this.viewState.CANNOT_UPLOAD:this.viewState.NON_ROOT_NAMESPACE}},d=l.prototype,p="namespace",f=[i.service],m={configurable:!0,enumerable:!0,writable:!0,initializer:null},b={},Object.keys(m).forEach((function(e){b[e]=m[e]})),b.enumerable=!!b.enumerable,b.configurable=!!b.configurable,("value"in b||b.initializer)&&(b.writable=!0),b=f.slice().reverse().reduce((function(e,t){return t(d,p,e)||e}),b),h&&void 0!==b.initializer&&(b.value=b.initializer?b.initializer.call(h):void 0,b.initializer=void 0),a=void 0===b.initializer?(Object.defineProperty(d,p,b),null):b,l)
var d,p,f,m,h,b;(0,t.setComponentTemplate)(s,c)})),define("vault/components/recovery/page/snapshots/load",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","@ember/service","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u,c,d,p,f,m,h,b,y
function g(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function v(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function w(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const k=(0,a.createTemplateFactory)({id:"e7f0KBKJ",block:'[[[1,"\\n"],[8,[39,0],null,[["@title","@breadcrumbs"],["Upload Snapshot",[30,1]]],null],[1,"\\n\\n"],[41,[30,0,["bannerError"]],[[[1,"  "],[10,0],[14,0,"has-top-padding-m has-bottom-padding-m"],[12],[1,"\\n    "],[8,[39,3],null,[["@type","@color"],["inline","critical"]],[["default"],[[[[1,"\\n      "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,"Error"]],[]]]]],[1,"\\n      "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,[30,0,["bannerError"]]]],[]]]]],[1,"\\n    "]],[2]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[11,"form"],[24,0,"has-top-margin-xl"],[4,[38,5],["submit",[30,0,["loadSnapshot"]]],null],[12],[1,"\\n  "],[8,[39,6],null,[["@name"],["snapshot-load-method"]],[["default"],[[[[1,"\\n    "],[8,[30,3,["Legend"]],null,null,[["default"],[[[[1,"Choose how to provide the snapshot"]],[]]]]],[1,"\\n    "],[8,[30,3,["RadioField"]],[[16,3,[30,0,["loadMethods","AUTOMATED"]]],[16,"checked",[28,[37,7],[[30,0,["selectedLoadMethod"]],[30,0,["loadMethods","AUTOMATED"]]],null]],[16,"disabled",[28,[37,7],[[30,4,["configError","status"]],404],null]],[4,[38,5],["change",[30,0,["selectLoadMethod"]]],null]],[["@value"],[[30,0,["loadMethods","AUTOMATED"]]]],[["default"],[[[[1,"\\n      "],[8,[30,5,["Label"]],null,null,[["default"],[[[[1,"\\n        Load from automated snapshots\\n"],[41,[28,[37,7],[[30,4,["configError","status"]],404],null],[[[1,"          "],[8,[39,8],[[24,0,"has-left-margin-xs"]],[["@text","@size","@icon","@color"],["No snapshots available","small","alert-triangle","warning"]],null],[1,"\\n"]],[]],null],[1,"      "]],[]]]]],[1,"\\n      "],[8,[30,5,["HelperText"]],null,null,[["default"],[[[[1,"\\n        Provide the snapshot URL from a configured cloud storage\\n      "]],[]]]]],[1,"\\n    "]],[5]]]]],[1,"\\n    "],[8,[30,3,["RadioField"]],[[16,3,[30,0,["loadMethods","MANUAL"]]],[16,"checked",[28,[37,7],[[30,0,["selectedLoadMethod"]],[30,0,["loadMethods","MANUAL"]]],null]],[4,[38,5],["change",[30,0,["selectLoadMethod"]]],null]],[["@value"],[[30,0,["loadMethods","MANUAL"]]]],[["default"],[[[[1,"\\n      "],[8,[30,6,["Label"]],null,null,[["default"],[[[[1,"Manually upload snapshots"]],[]]]]],[1,"\\n      "],[8,[30,6,["HelperText"]],null,null,[["default"],[[[[1,"\\n        Upload a new snapshot to the disk\\n      "]],[]]]]],[1,"\\n    "]],[6]]]]],[1,"\\n\\n  "]],[3]]]]],[1,"\\n\\n  "],[10,0],[14,0,"has-top-margin-l has-left-padding-l"],[12],[1,"\\n\\n"],[41,[28,[37,7],[[30,0,["selectedLoadMethod"]],[30,0,["loadMethods","AUTOMATED"]]],null],[[[1,"      "],[10,0],[14,0,"has-bottom-padding-m"],[12],[1,"\\n"],[41,[30,0,["automatedConfigs"]],[[[1,"          "],[8,[39,9],null,[["@onChange","@selected","@options","@isInvalid","@searchEnabled"],[[28,[37,10],[[28,[37,11],[[30,0,["selectedConfig"]]],null]],null],[30,0,["selectedConfig"]],[30,0,["automatedConfigs"]],[30,0,["configError"]],true]],[["default"],[[[[1,"\\n            "],[8,[30,7,["Label"]],null,null,[["default"],[[[[1,"Snapshot configuration name"]],[]]]]],[1,"\\n            "],[8,[30,7,["HelperText"]],null,null,[["default"],[[[[1,"\\n              Name of the configuration that created the snapshot. Existing automated snapshots should be configured via the\\n              "],[8,[39,12],null,[["@href","@isHrefExternal"],[[28,[37,13],["/vault/api-docs/system/storage/raftautosnapshots#create-update-an-automated-snapshots-config"],null],true]],[["default"],[[[[1,"automated snapshots config"]],[]]]]],[1,"\\n              endpoint.\\n            "]],[]]]]],[1,"\\n            "],[8,[30,7,["Options"]],null,null,[["default"],[[[[1,[30,7,["options"]]]],[]]]]],[1,"\\n"],[41,[30,0,["configError"]],[[[1,"              "],[8,[30,7,["Error"]],null,null,[["default"],[[[[1,[30,0,["configError"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"          "]],[7]]]]],[1,"\\n"]],[]],[[[1,"          "],[8,[39,14],[[4,[38,5],["input",[28,[37,15],[[28,[37,16],["target.value"],null],[28,[37,10],[[28,[37,11],[[30,0,["selectedConfig"]]],null]],null]],null]],null]],[["@isInvalid","@value"],[[30,0,["configError"]],[30,0,["selectedConfig"]]]],[["default"],[[[[1,"\\n            "],[8,[30,8,["Label"]],null,null,[["default"],[[[[1,"Snapshot configuration name"]],[]]]]],[1,"\\n            "],[8,[30,8,["HelperText"]],null,null,[["default"],[[[[1,"\\n              Name of the configuration that created the snapshot. Existing automated snapshots should be configured via the\\n              "],[8,[39,12],null,[["@href","@isHrefExternal"],[[28,[37,13],["/vault/api-docs/system/storage/raftautosnapshots#create-update-an-automated-snapshots-config"],null],true]],[["default"],[[[[1,"automated snapshots config"]],[]]]]],[1,"\\n              endpoint.\\n            "]],[]]]]],[1,"\\n"],[41,[30,0,["configError"]],[[[1,"              "],[8,[30,8,["Error"]],null,null,[["default"],[[[[1,[30,0,["configError"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"          "]],[8]]]]],[1,"\\n"]],[]]],[1,"      "],[13],[1,"\\n      "],[10,0],[14,0,"has-bottom-padding-m"],[12],[1,"\\n        "],[8,[39,14],[[24,3,"url"],[4,[38,5],["input",[30,0,["updateUrl"]]],null]],[["@isInvalid","@value"],[[30,0,["urlError"]],[30,0,["url"]]]],[["default"],[[[[1,"\\n          "],[8,[30,9,["Label"]],null,null,[["default"],[[[[1,"URL"]],[]]]]],[1,"\\n          "],[8,[30,9,["HelperText"]],null,null,[["default"],[[[[1,"\\n            The URL to the cloud storage bucket\\n          "]],[]]]]],[1,"\\n"],[41,[30,0,["urlError"]],[[[1,"            "],[8,[30,9,["Error"]],null,null,[["default"],[[[[1,[30,0,["urlError"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"        "]],[9]]]]],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[1,"      "],[8,[39,17],[[24,0,"has-left-padding-l"]],[["@error","@label","@onChange"],[[30,0,["fileError"]],"Please choose a snapshot file",[28,[37,10],[[28,[37,11],[[30,0,["file"]]],null]],null]]],null],[1,"\\n"]],[]]],[1,"  "],[13],[1,"\\n\\n  "],[10,"hr"],[14,0,"has-background-gray-300"],[12],[13],[1,"\\n\\n  "],[8,[39,19],[[24,0,"has-top-padding-m"]],null,[["default"],[[[[1,"\\n    "],[8,[39,20],[[24,4,"submit"]],[["@text"],["Load snapshot"]],null],[1,"\\n    "],[8,[39,20],null,[["@text","@color","@route"],["Cancel","secondary","vault.cluster.recovery.snapshots"]],null],[1,"\\n  "]],[]]]]],[1,"\\n"],[13]],["@breadcrumbs","A","G","@model","F","F","F","F","F"],false,["recovery/page/header","if","div","hds/alert","form","on","hds/form/radio/group","eq","hds/badge","hds/form/super-select/single/field","fn","mut","hds/link/inline","doc-link","hds/form/text-input/field","pipe","pick","file-to-array-buffer","hr","hds/button-set","hds/button"]]',moduleName:"vault/components/recovery/page/snapshots/load.hbs",isStrictMode:!1})
var x=function(e){return e.AUTOMATED="automated",e.MANUAL="manual",e}(x||{})
let P=e.default=(o=class extends n.default{constructor(e,t){super(e,t),g(this,"api",s,this),g(this,"router",u,this),g(this,"selectedLoadMethod",c,this),g(this,"selectedConfig",d,this),g(this,"url",p,this),g(this,"file",f,this),g(this,"urlError",m,this),g(this,"configError",h,this),g(this,"fileError",b,this),g(this,"bannerError",y,this),v(this,"loadMethods",x),v(this,"automatedConfigs",void 0)
const{configError:n}=this.args.model
n&&!this.isExpectedError&&(this.bannerError=n.message),this.selectedLoadMethod=404===n?.status?x.MANUAL:x.AUTOMATED,this.automatedConfigs=this.args.model.configs}get isExpectedError(){const e=this.args.model.configError?.status
return 403===e||404===e}validateFields(){let e=!1
switch(this.fileError="",this.urlError="",this.configError="",this.selectedLoadMethod){case x.MANUAL:this.file||(this.fileError="Please upload a snapshot file",e=!0)
break
case x.AUTOMATED:this.url||(this.urlError="Please enter a url",e=!0),this.selectedConfig||(this.configError="Please select a config",e=!0)}return!e}selectLoadMethod(e){this.selectedLoadMethod=e.target.value
const{configError:t}=this.args.model
this.selectedLoadMethod===x.AUTOMATED&&t&&!this.isExpectedError?this.bannerError=t.message:this.bannerError=""}updateUrl(e){this.url=e.target.value.trim()}async loadSnapshot(e){e.preventDefault()
if(this.validateFields())try{switch(this.selectedLoadMethod){case x.AUTOMATED:await this.api.sys.systemWriteStorageRaftSnapshotAutoSnapshotLoadName(this.selectedConfig,{url:this.url})
break
case x.MANUAL:await this.api.sys.systemWriteStorageRaftSnapshotLoad({body:this.file})
break
default:throw new Error("Unsupported load method")}this.router.transitionTo("vault.cluster.recovery.snapshots")}catch(t){const e=await this.api.parseError(t)
this.bannerError=`Snapshot load error: ${e.message}`}}},s=w(o.prototype,"api",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=w(o.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=w(o.prototype,"selectedLoadMethod",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=w(o.prototype,"selectedConfig",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),p=w(o.prototype,"url",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),f=w(o.prototype,"file",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=w(o.prototype,"urlError",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),h=w(o.prototype,"configError",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),b=w(o.prototype,"fileError",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y=w(o.prototype,"bannerError",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),w(o.prototype,"selectLoadMethod",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"selectLoadMethod"),o.prototype),w(o.prototype,"updateUrl",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"updateUrl"),o.prototype),w(o.prototype,"loadSnapshot",[r.action],Object.getOwnPropertyDescriptor(o.prototype,"loadSnapshot"),o.prototype),o);(0,t.setComponentTemplate)(k,P)})),define("vault/components/recovery/page/snapshots/snapshot-details",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","vault/components/recovery/page/snapshots/snapshot-utils","core/helpers/date-format","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d,p,f,m
function h(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function b(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function y(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const g=(0,s.createTemplateFactory)({id:"nHN35KaZ",block:'[[[1,"\\n"],[8,[39,0],null,[["@title","@subtitle","@action"],["Secrets Recovery","Recover lost or deleted data from a raft snapshot. Supported data includes KV v1 and Cubbyhole secrets or Database static roles.",[28,[37,1],null,[["text","icon","iconPosition","color","route","models"],["Recover secrets","reload","leading","primary","vault.cluster.recovery.snapshots.snapshot.manage",[28,[37,2],[[30,1,["snapshot","snapshot_id"]]],null]]]]]],null],[1,"\\n\\n"],[8,[39,3],null,null,[["head","body"],[[[[1,"\\n    "],[8,[30,2,["Tr"]],null,null,[["default"],[[[[1,"\\n"],[42,[28,[37,6],[[28,[37,6],[[30,0,["tableColumns"]]],null]],null],null,[[[1,"        "],[8,[30,2,["Th"]],null,null,[["default"],[[[[1,[30,3,["label"]]]],[]]]]],[1,"\\n"]],[3]],null],[1,"      "],[8,[30,2,["Th"]],null,null,[["default"],[[[[1,"Status"]],[]]]]],[1,"\\n      "],[8,[30,2,["Th"]],null,null,[["default"],[[[[1,"Actions"]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[2]],[[[1,"\\n    "],[8,[30,4,["Tr"]],null,null,[["default"],[[[[1,"\\n"],[42,[28,[37,6],[[28,[37,6],[[30,0,["tableColumns"]]],null]],null],null,[[[1,"        "],[8,[30,4,["Td"]],null,null,[["default"],[[[[1,[30,5,["value"]]]],[]]]]],[1,"\\n"]],[5]],null],[1,"      "],[8,[30,4,["Td"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,8],null,[["@text","@color"],[[30,0,["badge","status"]],[30,0,["badge","color"]]]],null],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,4,["Td"]],null,[["@align"],["right"]],[["default"],[[[[1,"\\n        "],[8,[39,9],null,[["@isInline"],[true]],[["default"],[[[[1,"\\n          "],[8,[30,6,["ToggleIcon"]],null,[["@icon","@text","@hasChevron","@size"],["more-horizontal","Overflow Options",false,"small"]],null],[1,"\\n          "],[8,[30,6,["Interactive"]],null,[["@icon","@route","@models"],["key","vault.cluster.recovery.snapshots.snapshot.manage",[28,[37,2],[[30,1,["snapshot","snapshot_id"]]],null]]],[["default"],[[[[1,"Manage secrets"]],[]]]]],[1,"\\n"],[41,[30,0,["namespace","inRootNamespace"]],[[[1,"            "],[8,[30,6,["Interactive"]],[[4,[38,11],["click",[30,0,["unloadSnapshot"]]],null]],[["@color","@icon"],["critical","trash"]],[["default"],[[[[1,"Unload snapshot"]],[]]]]],[1,"\\n"]],[]],null],[1,"        "]],[6]]]]],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[4]]]]]],["@model","H","col","B","item","dd"],false,["recovery/page/header","hash","array","hds/table",":head","each","-track-array",":body","hds/badge","hds/dropdown","if","on"]]',moduleName:"vault/components/recovery/page/snapshots/snapshot-details.hbs",isStrictMode:!1})
let v=e.default=(u=class extends n.default{constructor(e,t){super(e,t),h(this,"api",c,this),h(this,"flashMessages",d,this),h(this,"namespace",p,this),h(this,"router",f,this),h(this,"snapshotStatus",m,this),b(this,"pollingController",null),b(this,"onPollError",(async()=>{this.snapshotStatus="error",this.args.model.snapshot.status="error"})),b(this,"onPollSuccess",(async e=>{this.snapshotStatus=e,this.args.model.snapshot.status=e})),this.pollingController=(0,l.createPollingTask)(this.args.model.snapshot.snapshot_id,this.api,this.onPollSuccess,this.onPollError),this.pollingController.start()}willDestroy(){super.willDestroy(),this.pollingController&&this.pollingController.cancel()}get badge(){const e=this.snapshotStatus||this.args.model.snapshot?.status
return(0,l.getSnapshotStatusBadge)(e)}get tableColumns(){const e=this.args.model.snapshot,t=[{label:"Snapshot ID",key:"snapshot_id",value:e.snapshot_id},{label:"Expiring at",key:"expires_at",value:(0,a.dateFormat)([e.expires_at,"MMM d, yyyy hh:mm aaa"],{withTimeZone:!0})}]
if(this.args.model.snapshot.auto_snapshot_config){const n=[{label:"Auto config name",key:"auto_config_name",value:e.auto_snapshot_config},{label:"URL",key:"url",value:e.url}]
t.splice(1,0,...n)}return t}async unloadSnapshot(){try{const{snapshot_id:e}=this.args.model.snapshot
await this.api.sys.systemDeleteStorageRaftSnapshotLoadId(e),this.router.transitionTo("vault.cluster.recovery.snapshots")}catch(e){const{message:t}=await this.api.parseError(e)
this.flashMessages.danger(`Snapshot was not unloaded: ${t}`)}}},c=y(u.prototype,"api",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=y(u.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=y(u.prototype,"namespace",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=y(u.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=y(u.prototype,"snapshotStatus",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y(u.prototype,"unloadSnapshot",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"unloadSnapshot"),u.prototype),u);(0,t.setComponentTemplate)(g,v)})),define("vault/components/recovery/page/snapshots/snapshot-manage",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","core/utils/sanitize-path","vault/resources/secrets/engine","vault/helpers/supported-secret-backends","vault/services/namespace","vault/components/recovery/page/snapshots/snapshot-utils","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c,d,p,f){var m,h,b,y,g,v,w,k,x,P,_,T,O,j,z,M,S,C,E
function D(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function A(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function R(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const F=(0,f.createTemplateFactory)({id:"DhCUCmGs",block:'[[[1,"\\n"],[8,[39,0],null,[["@title","@subtitle"],["Secrets Recovery","Recover lost or deleted data from a raft snapshot. Supported data includes KV v1 and Cubbyhole secrets or Database static roles."]],null],[1,"\\n\\n"],[44,[[30,1,["snapshot"]]],[[[1,"  "],[8,[39,2],[[24,0,"has-padding-m has-top-margin-s has-bottom-margin-m one-half-width"]],[["@level","@hasBorder"],["mid",true]],[["default"],[[[[1,"\\n    "],[10,0],[14,0,"flex space-between"],[12],[1,"\\n      "],[8,[39,4],null,[["@tag"],["h2"]],[["default"],[[[[1,"Snapshot"]],[]]]]],[1,"\\n      "],[8,[39,5],null,[["@text","@color"],[[30,0,["badge","status"]],[30,0,["badge","color"]]]],null],[1,"\\n    "],[13],[1,"\\n    "],[8,[39,6],null,[["@tag"],["p"]],[["default"],[[[[1,"Expiring at\\n      "],[1,[28,[35,7],[[30,2,["expires_at"]],"MMM d, yyyy, h:mm:ss aaa"],[["withTimeZone"],[true]]]]],[]]]]],[1,"\\n    "],[8,[39,8],null,[["@iconPosition","@icon","@text","@route","@model"],["trailing","arrow-right","View details","vault.cluster.recovery.snapshots.snapshot.details",[30,2,["snapshot_id"]]]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[2]]],[1,"\\n"],[10,"hr"],[14,0,"has-background-gray-300"],[12],[13],[1,"\\n\\n"],[8,[39,4],[[24,0,"has-top-padding-m has-bottom-margin-l"]],[["@tag"],["h3"]],[["default"],[[[[1,"Recover or read data"]],[]]]]],[1,"\\n"],[41,[30,0,["recoveryData"]],[[[1,"  "],[8,[39,11],[[24,0,"has-top-margin-m has-bottom-margin-m"]],[["@type","@color"],["inline","success"]],[["default"],[[[[1,"\\n    "],[8,[30,3,["Title"]],null,null,[["default"],[[[[1,"Success"]],[]]]]],[1,"\\n"],[44,[[30,0,["recoveryData","query","namespace"]],[28,[37,12],[[30,0,["recoveryData","models"]],0],null],[28,[37,12],[[30,0,["recoveryData","models"]],1],null]],[[[1,"      "],[8,[30,3,["Description"]],null,null,[["default"],[[[[1,"Secret at\\n        "],[8,[39,13],null,[["@route","@models","@query"],["vault.cluster.secrets.backend.show",[30,0,["recoveryData","models"]],[30,0,["recoveryData","query"]]]],[["default"],[[[[1,"\\n          "],[1,[30,5]],[1,"/"],[1,[30,6]]],[]]]]],[1,"\\n        has been successfully recovered"],[41,[30,4],[[[1," in namespace "],[10,"strong"],[12],[1,[30,4]],[13]],[]],null],[1,".\\n      "]],[]]]]],[1,"\\n"]],[4,5,6]]],[1,"  "]],[3]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,0,["bannerError"]],[[[1,"  "],[10,0],[14,0,"has-top-padding-m has-bottom-padding-m"],[12],[1,"\\n    "],[8,[39,11],null,[["@type","@color"],["inline","critical"]],[["default"],[[[[1,"\\n      "],[8,[30,7,["Title"]],null,null,[["default"],[[[[1,"Error"]],[]]]]],[1,"\\n      "],[8,[30,7,["Description"]],null,null,[["default"],[[[[1,[30,0,["bannerError"]]]],[]]]]],[1,"\\n    "]],[7]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[8,[39,15],[[24,0,"has-bottom-padding-m"]],[["@gap","@align"],["24","start"]],[["default"],[[[[1,"\\n"],[41,[30,0,["namespace","inRootNamespace"]],[[[1,"    "],[8,[39,16],null,[["@onChange","@selected","@options","@searchEnabled"],[[30,0,["handleSelectNamespace"]],[30,0,["selectedNamespace"]],[30,0,["namespaceOptions"]],true]],[["default"],[[[[1,"\\n      "],[8,[30,8,["Label"]],null,null,[["default"],[[[[1,"Namespace"]],[]]]]],[1,"\\n      "],[8,[30,8,["Options"]],null,null,[["default"],[[[[1,"\\n"],[44,[[30,8,["options"]]],[[[1,"          "],[10,0],[12],[1,"\\n            "],[1,[30,8,["options"]]],[1,"\\n          "],[13],[1,"\\n"]],[9]]],[1,"      "]],[]]]]],[1,"\\n    "]],[8]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,17],[[30,0,["mountOptions"]],[30,0,["fetchMounts","isRunning"]]],null],[[[1,"    "],[8,[39,16],null,[["@onChange","@selected","@options","@searchEnabled","@searchField","@isInvalid","@selectedItemComponent","@placeholder"],[[30,0,["handleSelectMount"]],[30,0,["selectedMount"]],[30,0,["mountOptions"]],true,"path",[30,0,["mountError"]],[50,"recovery/snapshot-mount-selected-item",0,null,null],"Select a mount here"]],[["default"],[[[[1,"\\n      "],[8,[30,10,["Label"]],null,null,[["default"],[[[[1,"Secret mount"]],[]]]]],[1,"\\n      "],[8,[30,10,["Options"]],null,null,[["default"],[[[[1,"\\n"],[44,[[30,10,["options"]]],[[[1,"          "],[10,0],[12],[1,"\\n            "],[10,"strong"],[12],[1,[30,11,["path"]]],[13],[1,"\\n          "],[13],[1,"\\n          "],[1,[30,11,["type"]]],[1,"\\n"]],[11]]],[1,"      "]],[]]]]],[1,"\\n"],[41,[30,0,["mountError"]],[[[1,"        "],[8,[30,10,["Error"]],null,null,[["default"],[[[[1,[30,0,["mountError"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[10]]]]],[1,"\\n"]],[]],[[[1,"    "],[8,[39,19],null,[["@layout"],["vertical"]],[["default"],[[[[1,"\\n      "],[8,[30,12,["Label"]],null,null,[["default"],[[[[1,"Mount Path"]],[]]]]],[1,"\\n      "],[8,[30,12,["Control"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,20],null,null,[["default"],[[[[1,"\\n          "],[8,[30,13,["Dropdown"]],null,[["@listPosition"],["bottom-left"]],[["default"],[[[[1,"\\n            "],[8,[30,14,["ToggleButton"]],[[24,0,"white-space-nowrap"]],[["@color","@text"],["secondary",[28,[37,17],[[28,[37,12],[[30,0,["recoverySupportedEngines"]],[30,0,["selectedMount","type"]]],null],"Type"],null]]],null],[1,"\\n"],[42,[28,[37,22],[[30,0,["recoverySupportedEngines"]]],null],null,[[[1,"              "],[8,[30,14,["Radio"]],[[16,3,[30,16]],[16,"checked",[28,[37,23],[[30,0,["selectedMount","type"]],[30,16]],null]],[4,[38,24],["change",[28,[37,25],[[30,0,["handleSelectRadio"]],[30,14,["close"]]],null]],null]],null,[["default"],[[[[1,"\\n                "],[1,[30,15]],[1,"\\n              "]],[]]]]],[1,"\\n"]],[15,16]],null],[1,"          "]],[14]]]]],[1,"\\n          "],[8,[30,13,["TextInput"]],[[16,1,[30,12,["id"]]],[16,"aria-describedby",[30,12,["ariaDescribedBy"]]],[24,"size","32"],[16,"placeholder",[52,[30,0,["selectedMount"]],"Enter mount path...","Select a type to enter a path"]],[16,"disabled",[28,[37,26],[[30,0,["selectedMount","type"]]],null]],[16,"readonly",[28,[37,23],[[30,0,["selectedMount","type"]],"cubbyhole"],null]],[4,[38,24],["input",[30,0,["handlePathInput"]]],null]],[["@isInvalid","@value"],[[30,0,["mountError"]],[30,0,["selectedMount","path"]]]],null],[1,"\\n        "]],[13]]]]],[1,"\\n      "]],[]]]]],[1,"\\n"],[41,[30,0,["mountError"]],[[[1,"        "],[8,[30,12,["Error"]],null,null,[["default"],[[[[1,[30,0,["mountError"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[12]]]]],[1,"\\n"]],[]]],[1,"\\n  "],[8,[39,27],[[24,"placeholder","Enter the resource path..."],[24,"autocomplete","off"],[4,[38,24],["input",[30,0,["updateResourcePath"]]],null]],[["@value","@isInvalid"],[[30,0,["resourcePath"]],[30,0,["resourcePathError"]]]],[["default"],[[[[1,"\\n    "],[8,[30,17,["Label"]],null,null,[["default"],[[[[1,"Resource Path"]],[]]]]],[1,"\\n"],[41,[30,0,["resourcePathError"]],[[[1,"      "],[8,[30,17,["Error"]],null,null,[["default"],[[[[1,[30,0,["resourcePathError"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"  "]],[17]]]]],[1,"\\n\\n  "],[10,0],[15,0,[52,[30,0,["resourcePathError"]],"align-self-center","align-self-end"]],[12],[1,"\\n    "],[8,[39,28],[[4,[38,24],["click",[30,0,["clearSelections"]]],null]],[["@text","@icon","@color"],["Clear","trash","secondary"]],null],[1,"\\n  "],[13],[1,"\\n"]],[]]]]],[1,"\\n\\n"],[8,[39,15],[[24,0,"has-bottom-padding-m"]],[["@align"],["start"]],[["default"],[[[[1,"\\n  "],[8,[39,29],null,[["@name"],["recover-method"]],[["default"],[[[[1,"\\n    "],[8,[30,18,["Legend"]],null,null,[["default"],[[[[1,"Recover options"]],[]]]]],[1,"\\n"],[42,[28,[37,30],[[28,[37,30],[[30,0,["recoverMethods"]]],null]],null],null,[[[1,"      "],[8,[30,18,["RadioField"]],[[16,"checked",[28,[37,23],[[30,0,["recoverMethod"]],[30,19,["value"]]],null]],[4,[38,24],["change",[30,0,["handleSelectRecoverMethod"]]],null]],[["@value"],[[30,19,["value"]]]],[["default"],[[[[1,"\\n        "],[8,[30,20,["Label"]],null,null,[["default"],[[[[1,[30,19,["label"]]]],[]]]]],[1,"\\n      "]],[20]]]]],[1,"\\n"]],[19]],null],[1,"  "]],[18]]]]],[1,"\\n"]],[]]]]],[1,"\\n\\n"],[41,[28,[37,23],[[30,0,["recoverMethod"]],"copy"],null],[[[1,"  "],[8,[39,15],[[24,0,"has-bottom-padding-m"]],[["@align"],["start"]],[["default"],[[[[1,"\\n    "],[8,[39,27],[[24,"placeholder","Enter new path"],[24,"autocomplete","off"],[4,[38,24],["input",[30,0,["updateCopyPath"]]],null]],[["@value","@isInvalid"],[[30,0,["copyPath"]],[30,0,["copyPathError"]]]],[["default"],[[[[1,"\\n      "],[8,[30,21,["Label"]],null,null,[["default"],[[[[1,"Copy Path"]],[]]]]],[1,"\\n      "],[8,[30,21,["HelperText"]],null,null,[["default"],[[[[1,"Recover to the new path below. The original resource path will not be affected."]],[]]]]],[1,"\\n"],[41,[30,0,["copyPathError"]],[[[1,"        "],[8,[30,21,["Error"]],null,null,[["default"],[[[[1,[30,0,["copyPathError"]]]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[21]]]]],[1,"\\n\\n  "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[10,"hr"],[14,0,"has-background-gray-300"],[12],[13],[1,"\\n\\n"],[8,[39,31],[[24,0,"has-top-padding-m"]],null,[["default"],[[[[1,"\\n  "],[8,[39,28],[[16,"disabled",[28,[37,26],[[28,[37,23],[[30,0,["badge","status"]],"Ready"],null]],null]],[24,4,"submit"],[4,[38,24],["click",[30,0,["recover"]]],null]],[["@text"],["Recover"]],null],[1,"\\n  "],[8,[39,28],[[16,"disabled",[28,[37,26],[[28,[37,23],[[30,0,["badge","status"]],"Ready"],null]],null]],[4,[38,24],["click",[30,0,["readResource"]]],null]],[["@text","@color"],["Read","secondary"]],null],[1,"\\n"]],[]]]]],[1,"\\n\\n"],[41,[30,0,["showReadModal"]],[[[1,"  "],[8,[39,32],null,[["@onClose"],[[30,0,["closeReadModal"]]]],[["default"],[[[[1,"\\n    "],[8,[30,22,["Header"]],null,null,[["default"],[[[[1,"\\n      Read secrets\\n    "]],[]]]]],[1,"\\n    "],[8,[30,22,["Body"]],null,null,[["default"],[[[[1,"\\n      "],[10,0],[14,0,"has-bottom-padding-m"],[12],[1,"\\n        "],[8,[39,33],[[16,"checked",[30,0,["showJson"]]],[4,[38,24],["change",[30,0,["toggleJson"]]],null]],null,[["default"],[[[[1,"\\n          "],[8,[30,23,["Label"]],null,null,[["default"],[[[[1,"JSON"]],[]]]]],[1,"\\n          "],[8,[30,23,["HelperText"]],null,null,[["default"],[[[[1,"Please use the toggle to see your secret value in JSON."]],[]]]]],[1,"\\n        "]],[23]]]]],[1,"\\n      "],[13],[1,"\\n\\n      "],[8,[39,34],null,[["@showAdvancedMode","@modelForData"],[[30,0,["showJson"]],[30,0,["modelForData"]]]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,22,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,28],[[24,4,"button"],[4,[38,24],["click",[30,24,["close"]]],null]],[["@text"],["Close"]],null],[1,"\\n    "]],[24]]]]],[1,"\\n  "]],[22]]]]],[1,"\\n"]],[]],null]],["@model","snapshot","A","ns","mount","resource","A","F","option","F","option","F","SG","D","displayName","type","F","G","method","F","F","M","F","F"],false,["recovery/page/header","let","hds/card/container","div","hds/text/display","hds/badge","hds/text/body","date-format","hds/link/standalone","hr","if","hds/alert","get","hds/link/inline","strong","hds/layout/flex","hds/form/super-select/single/field","or","component","hds/form/field","hds/segmented-group","each","-each-in","eq","on","fn","not","hds/form/text-input/field","hds/button","hds/form/radio/group","-track-array","hds/button-set","hds/modal","hds/form/toggle/field","secret-form-show"]]',moduleName:"vault/components/recovery/page/snapshots/snapshot-manage.hbs",isStrictMode:!1})
let N=e.default=(m=class extends i.default{constructor(e,t){super(e,t),D(this,"api",h,this),D(this,"currentCluster",b,this),D(this,"namespace",y,this),D(this,"selectedNamespace",g,this),D(this,"selectedMount",v,this),D(this,"resourcePath",w,this),D(this,"copyPath",k,this),D(this,"mountOptions",x,this),D(this,"secretData",P,this),D(this,"mountError",_,this),D(this,"resourcePathError",T,this),D(this,"copyPathError",O,this),D(this,"bannerError",j,this),D(this,"showReadModal",z,this),D(this,"showJson",M,this),D(this,"recoveryData",S,this),D(this,"recoverMethod",C,this),D(this,"snapshotStatus",E,this),A(this,"pollingController",null),A(this,"recoverySupportedEngines",{[c.SupportedSecretBackendsEnum.DATABASE]:"Database",[c.SupportedSecretBackendsEnum.CUBBYHOLE]:"Cubbyhole",[c.SupportedSecretBackendsEnum.KV]:"KV v1"}),A(this,"recoverMethods",[{label:"Recover to original path (recover in place)",value:"original"},{label:"Recover to a new path (copy)",value:"copy"}]),A(this,"onPollError",(async e=>{const t=await this.api.parseError(e)
this.bannerError=`Snapshot load error: ${t.message}`,this.snapshotStatus="error",this.args.model.snapshot.status="error"})),A(this,"onPollSuccess",(async e=>{this.snapshotStatus=e,this.args.model.snapshot.status=e})),A(this,"fetchMounts",(0,n.buildTask)((()=>({context:this,generator:function*(){try{const e="root"===this.selectedNamespace?d.ROOT_NAMESPACE:this.selectedNamespace,t=this.api.buildHeaders({namespace:e}),{secret:n}=yield this.api.sys.internalUiListEnabledVisibleMounts(t),i=this.api.responseObjectToArray(n,"path").flatMap((e=>{const t=new u.default(e)
return this.currentCluster?.performance?.isSecondary&&!t.local?[]:t.supportsRecovery?[{path:(0,s.sanitizePath)(t.path),type:t.engineType}]:[]})),r=i.filter((e=>e.type===c.SupportedSecretBackendsEnum.DATABASE)),l=i.filter((e=>e.type!==c.SupportedSecretBackendsEnum.DATABASE))
this.mountOptions=i.length?[...r.length?[{groupName:"Databases",options:r}]:[],{groupName:"Secret Engines",options:l}]:[]}catch{this.mountOptions=[]}}})),null,"fetchMounts","restartable")),this.selectedNamespace=this.namespace.inRootNamespace?"root":this.namespace.path,this.fetchMounts.perform(),this.pollingController=(0,p.createPollingTask)(this.args.model.snapshot.snapshot_id,this.api,this.onPollSuccess,this.onPollError),this.pollingController.start()}willDestroy(){super.willDestroy(),this.pollingController&&this.pollingController.cancel()}get hasValidationErrors(){return!(!this.mountError&&!this.resourcePathError)}get modelForData(){return{secretData:this.secretData,secretKeyAndValue:this.secretKeyAndValue}}get namespaceOptions(){const{namespaces:e}=this.args.model
return["root",...e.map((e=>(0,s.sanitizePath)(e)))]}get recoverToCopy(){return"copy"===this.recoverMethod}get secretKeyAndValue(){return this.secretData&&"object"==typeof this.secretData?Object.entries(this.secretData).map((([e,t])=>({key:e,value:"string"==typeof t?t:JSON.stringify(t)}))):[]}get badge(){const e=this.snapshotStatus||this.args.model.snapshot?.status
return(0,p.getSnapshotStatusBadge)(e)}clearSelections(){this.selectedNamespace=this.namespace.inRootNamespace?"root":this.namespace.path,this.selectedMount=void 0,this.resourcePath="",this.copyPath="",this.mountError="",this.resourcePathError="",this.secretData=void 0,this.namespace.inRootNamespace&&this.fetchMounts.perform()}handlePathInput({target:e}){if(this.selectedMount){const{type:t}=this.selectedMount
this.selectedMount={type:t,path:e.value}}}handleSelectNamespace(e){this.selectedMount=void 0,this.selectedNamespace=e,this.fetchMounts.perform()}handleSelectMount(e){this.mountError="",this.selectedMount=e,this.selectedMount.type===c.SupportedSecretBackendsEnum.CUBBYHOLE&&(this.selectedMount.path="cubbyhole")}handleSelectRadio(e,{target:t}){const n={type:t.name,path:""}
this.handleSelectMount(n),e()}handleSelectRecoverMethod({target:e}){this.recoverMethod=e.value,this.recoverToCopy&&this.resourcePath&&(this.copyPath=this.resourcePath+"-copy")}updateCopyPath({target:e}){this.copyPath=e.value.trim()}updateResourcePath({target:e}){this.resourcePath=e.value.trim(),this.resourcePathError=""}async readResource(){if(this.validateFields())try{this.bannerError="",this.recoveryData=void 0
const{snapshot_id:e}=this.args.model.snapshot,t=this.selectedMount?.type,n=this.selectedMount?.path,i="root"===this.selectedNamespace?d.ROOT_NAMESPACE:this.selectedNamespace,r=this.api.buildHeaders({namespace:i})
switch(t){case c.SupportedSecretBackendsEnum.KV:{const{data:t}=await this.api.secrets.kvV1Read(this.resourcePath,n,e,r)
this.secretData=t
break}case c.SupportedSecretBackendsEnum.CUBBYHOLE:{const{data:t}=await this.api.secrets.cubbyholeRead(this.resourcePath,e,r)
this.secretData=t
break}case c.SupportedSecretBackendsEnum.DATABASE:{const{data:t}=await this.api.secrets.databaseReadStaticRole(this.resourcePath,n,e,r)
this.secretData=t
break}default:throw new Error("Unsupported recovery engine")}this.showReadModal=!0}catch(e){const t=await this.api.parseError(e)
this.bannerError=`Snapshot read error: ${t.message}`}}async recover(){if(this.validateFields(!0))try{this.bannerError=""
const{snapshot_id:e}=this.args.model.snapshot,t="root"===this.selectedNamespace?d.ROOT_NAMESPACE:this.selectedNamespace,n=this.selectedMount?.type,i=this.selectedMount?.path,r=this.recoverToCopy?this.copyPath:this.resourcePath,l=n===c.SupportedSecretBackendsEnum.DATABASE?i+"/static-roles/"+this.resourcePath:i+"/"+this.resourcePath,a=this.api.buildHeaders({namespace:t,recoverSnapshotId:e,...this.recoverToCopy&&{recoverSourcePath:l}})
let o={}
t&&t!==this.namespace.path&&(o={namespace:t})
let s=""
switch(n){case c.SupportedSecretBackendsEnum.KV:await this.recoverKvv1(r,i,a)
break
case c.SupportedSecretBackendsEnum.CUBBYHOLE:await this.recoverCubbyhole(r,a)
break
case c.SupportedSecretBackendsEnum.DATABASE:await this.recoverDatabaseStaticRoles(r,i,a),s="role/",o={...o,type:"static"}
break
default:throw new Error("Unsupported recovery engine")}this.recoveryData={models:[i,s+r],query:o}}catch(e){const t=await this.api.parseError(e)
this.bannerError=`Snapshot recovery error: ${t.message}`,this.recoveryData=void 0}}closeReadModal(){this.showReadModal=!1}toggleJson(e){this.showJson=e.target.checked}validateFields(e=!1){this.mountError="",this.resourcePathError="",this.copyPathError=""
let t=!1
return this.selectedMount||(this.mountError="Please select a secret mount",t=!0),this.resourcePath||(this.resourcePathError="Please enter a resource path",t=!0),e&&this.recoverToCopy&&!this.copyPath&&(this.copyPathError="Please enter a copy path",t=!0),!t}async recoverCubbyhole(e,t){await this.api.secrets.cubbyholeWrite(e,{},void 0,void 0,void 0,t)}async recoverKvv1(e,t,n){await this.api.secrets.kvV1Write(e,t,{},void 0,void 0,void 0,n)}async recoverDatabaseStaticRoles(e,t,n){await this.api.secrets.databaseWriteStaticRole(e,t,{},void 0,void 0,void 0,n)}},h=R(m.prototype,"api",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=R(m.prototype,"currentCluster",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=R(m.prototype,"namespace",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),g=R(m.prototype,"selectedNamespace",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),v=R(m.prototype,"selectedMount",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=R(m.prototype,"resourcePath",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),k=R(m.prototype,"copyPath",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),x=R(m.prototype,"mountOptions",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),P=R(m.prototype,"secretData",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),_=R(m.prototype,"mountError",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),T=R(m.prototype,"resourcePathError",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),O=R(m.prototype,"copyPathError",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),j=R(m.prototype,"bannerError",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),z=R(m.prototype,"showReadModal",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),M=R(m.prototype,"showJson",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),S=R(m.prototype,"recoveryData",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),C=R(m.prototype,"recoverMethod",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"original"}}),E=R(m.prototype,"snapshotStatus",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),R(m.prototype,"clearSelections",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"clearSelections"),m.prototype),R(m.prototype,"handlePathInput",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"handlePathInput"),m.prototype),R(m.prototype,"handleSelectNamespace",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"handleSelectNamespace"),m.prototype),R(m.prototype,"handleSelectMount",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"handleSelectMount"),m.prototype),R(m.prototype,"handleSelectRadio",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"handleSelectRadio"),m.prototype),R(m.prototype,"handleSelectRecoverMethod",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"handleSelectRecoverMethod"),m.prototype),R(m.prototype,"updateCopyPath",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"updateCopyPath"),m.prototype),R(m.prototype,"updateResourcePath",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"updateResourcePath"),m.prototype),R(m.prototype,"readResource",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"readResource"),m.prototype),R(m.prototype,"recover",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"recover"),m.prototype),R(m.prototype,"closeReadModal",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"closeReadModal"),m.prototype),R(m.prototype,"toggleJson",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"toggleJson"),m.prototype),R(m.prototype,"validateFields",[r.action],Object.getOwnPropertyDescriptor(m.prototype,"validateFields"),m.prototype),m);(0,t.setComponentTemplate)(F,N)})),define("vault/components/recovery/page/snapshots/snapshot-utils",["exports","ember","ember-concurrency","vault/services/namespace"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.createPollingTask=function(e,r,l,a){let o=!1
return{start:async()=>{if(!e||o)return
let s=t.default.testing?0:5e3
for(;!o&&(await(0,n.timeout)(s),!o);)try{const n=(await r.sys.systemReadStorageRaftSnapshotLoadId(e,r.buildHeaders({namespace:i.ROOT_NAMESPACE}))).status??""
if(l(n),"error"===n)break
if(t.default.testing)return
s=3e4}catch(u){a(u)
break}},cancel:()=>{o=!0}}},e.getSnapshotStatusBadge=function(e){switch(e){case"error":return{status:"Error",color:"critical"}
case"loading":return{status:"Loading",color:"highlight"}
case"ready":return{status:"Ready",color:"success"}
default:return{status:e||"Unknown",color:"warning"}}}})),define("vault/components/recovery/snapshot-mount-selected-item",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"5L+AG0zo",block:'[[[1,"\\n"],[1,[30,1,["path"]]]],["@option"],false,[]]',moduleName:"vault/components/recovery/snapshot-mount-selected-item.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/regex-validator",["exports","@ember/component","@glimmer/component","@glimmer/tracking","@ember/object","@ember/template-factory"],(function(e,t,n,i,r,l){var a,o,s
function u(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function c(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const d=(0,l.createTemplateFactory)({id:"pq24MwOi",block:'[[[1,"\\n"],[41,[30,1],[[[1,"  "],[10,0],[14,0,"field"],[12],[1,"\\n    "],[10,0],[14,0,"regex-label-wrapper"],[12],[1,"\\n      "],[10,0],[14,0,"regex-label"],[12],[1,"\\n        "],[10,"label"],[15,"for",[30,1,["name"]]],[14,0,"is-label"],[12],[1,"\\n          "],[1,[30,2]],[1,"\\n"],[41,[30,1,["options","helpText"]],[[[1,"            "],[8,[39,3],null,null,[["default"],[[[[1,"\\n              "],[10,1],[12],[1,"\\n                "],[1,[30,1,["options","helpText"]]],[1,"\\n              "],[13],[1,"\\n            "]],[]]]]],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n"],[41,[30,1,["options","subText"]],[[[1,"          "],[10,2],[14,0,"sub-text"],[12],[1,"\\n            "],[1,[30,1,["options","subText"]]],[1,"\\n"],[41,[30,1,["options","docLink"]],[[[1,"              "],[8,[39,6],null,[["@path"],[[30,1,["options","docLink"]]]],[["default"],[[[[1,"\\n                See our documentation\\n              "]],[]]]]],[1,"\\n              for help.\\n"]],[]],null],[1,"          "],[13],[1,"\\n"]],[]],null],[1,"      "],[13],[1,"\\n      "],[10,0],[12],[1,"\\n        "],[8,[39,7],null,[["@name","@checked","@onChange"],[[28,[37,8],[[30,1,["name"]],"-validation-toggle"],null],[30,0,["showTestValue"]],[30,0,["toggleTestValue"]]]],[["default"],[[[[1,"\\n          "],[10,1],[14,0,"has-text-grey"],[12],[1,"Validation"],[13],[1,"\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[11,"input"],[16,1,[30,1,["name"]]],[24,"autocomplete","off"],[24,"spellcheck","false"],[16,2,[30,3]],[24,0,"input"],[4,[38,10],["change",[30,4]],null],[12],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],null],[41,[30,0,["showTestValue"]],[[[1,"  "],[10,0],[12],[1,"\\n    "],[10,"label"],[14,"for","regex-test-val"],[14,0,"is-label"],[12],[1,"\\n      "],[1,[30,0,["testInputLabel"]]],[1,"\\n    "],[13],[1,"\\n"],[41,[30,5],[[[1,"      "],[10,2],[14,0,"sub-text"],[12],[1,[30,5]],[13],[1,"\\n"]],[]],null],[1,"    "],[11,"input"],[24,1,"regex-test-val"],[24,"autocomplete","off"],[24,"spellcheck","false"],[16,2,[30,0,["testValue"]]],[16,0,[29,["input ",[52,[30,0,["regexError"]],"has-error"]]]],[4,[38,10],["change",[30,0,["updateTestValue"]]],null],[12],[13],[1,"\\n\\n"],[41,[30,0,["testValue"]],[[[1,"      "],[10,0],[12],[1,"\\n"],[41,[28,[37,11],[[30,3]],null],[[[1,"          "],[8,[39,12],null,[["@type","@message"],["warning",[28,[37,8],["A pattern has not been entered. Enter a pattern to check this ",[28,[37,13],[[30,0,["testInputLabel"]]],null]," against it."],null]]],null],[1,"\\n"]],[]],[[[41,[30,0,["regexError"]],[[[1,"          "],[8,[39,12],null,[["@type","@message"],["danger","This test string does not match the pattern regex."]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,12],null,[["@type","@message"],["success","This test string matches the pattern regex."]],null],[1,"\\n        "]],[]]]],[]]],[1,"      "],[13],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n"]],[]],null],[41,[30,6],[[[1,"  "],[10,0],[14,0,"has-top-margin-l"],[12],[1,"\\n    "],[10,"label"],[14,0,"is-label"],[12],[1,"Groups"],[13],[1,"\\n"],[41,[28,[37,14],[[30,3],[30,0,["testValue"]],[28,[37,11],[[30,0,["regexError"]]],null]],null],[[[1,"      "],[10,0],[14,0,"regex-group"],[12],[1,"\\n"],[42,[28,[37,16],[[28,[37,16],[[30,0,["captureGroups"]]],null]],null],null,[[[1,"          "],[10,1],[14,0,"regex-group-position"],[12],[1,"\\n            "],[10,1],[12],[1,[30,7,["position"]]],[13],[1,"\\n          "],[13],[1,"\\n          "],[10,1],[14,0,"regex-group-value"],[12],[1,"\\n            "],[1,[30,7,["value"]]],[1,"\\n          "],[13],[1,"\\n"]],[7]],null],[1,"      "],[13],[1,"\\n"]],[]],[[[1,"      "],[10,2],[14,0,"sub-text"],[12],[1,"\\n        Enter pattern and test string to show groupings.\\n      "],[13],[1,"\\n"]],[]]],[1,"  "],[13],[1,"\\n"]],[]],null]],["@attr","@labelString","@value","@onChange","@testInputSubText","@showGroups","group"],false,["if","div","label","info-tooltip","span","p","doc-link","toggle","concat","input","on","not","alert-inline","lowercase","and","each","-track-array"]]',moduleName:"vault/components/regex-validator.hbs",isStrictMode:!1})
let p=e.default=(a=class extends n.default{constructor(){super(...arguments),u(this,"testValue",o,this),u(this,"showTestValue",s,this),this.showTestValue=!this.args.attr}get testInputLabel(){return this.args.testInputLabel||"Test string"}get regex(){return new RegExp(this.args.value,"g")}get regexError(){const e=this.testValue
if(!e||!this.args.value)return!1
const t=e.toString().match(this.regex)
return this.args.onValidate&&this.args.onValidate(this.testValue,this.captureGroups),e!==t?.join("")}get captureGroups(){const e=this.regex.exec(this.testValue)
if(e){const[t,...n]=e,i=n.map(((e,t)=>({position:`$${t+1}`,value:e})))
if(e.groups)for(const r in e.groups)i.push({position:`$${r}`,value:e.groups[r]})
return i}return[]}updateTestValue(e){this.testValue=e.target.value}toggleTestValue(){this.showTestValue=!this.showTestValue}},o=c(a.prototype,"testValue",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),s=c(a.prototype,"showTestValue",[i.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),c(a.prototype,"updateTestValue",[r.action],Object.getOwnPropertyDescriptor(a.prototype,"updateTestValue"),a.prototype),c(a.prototype,"toggleTestValue",[r.action],Object.getOwnPropertyDescriptor(a.prototype,"toggleTestValue"),a.prototype),a);(0,t.setComponentTemplate)(d,p)})),define("vault/components/replication-action-demote",["exports","core/components/replication-action-demote"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-disable",["exports","core/components/replication-action-disable"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-generate-token",["exports","core/components/replication-action-generate-token"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-promote",["exports","core/components/replication-action-promote"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})}))
define("vault/components/replication-action-recover",["exports","core/components/replication-action-recover"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-reindex",["exports","core/components/replication-action-reindex"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-action-update-primary",["exports","core/components/replication-action-update-primary"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-actions-single",["exports","core/components/replication-actions-single"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-actions",["exports","core/components/replication-actions"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-dashboard",["exports","core/components/replication-dashboard"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-header",["exports","core/components/replication-header"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-page",["exports","core/components/replication-page"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-secondary-card",["exports","core/components/replication-secondary-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-summary-card",["exports","core/components/replication-summary-card"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/replication-table-rows",["exports","core/components/replication-table-rows"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/resultant-acl-banner",["exports","@ember/component","@ember/service","@glimmer/component","@glimmer/tracking","vault/services/permissions","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s,u,c
function d(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function p(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const f=(0,a.createTemplateFactory)({id:"ObjQXy4u",block:'[[[1,"\\n"],[41,[51,[30,0,["hideBanner"]]],[[[1,"  "],[8,[39,1],null,[["@type","@color","@onDismiss"],["inline","critical",[28,[37,2],[[28,[37,3],[[30,0,["hideBanner"]]],null],true],null]]],[["default"],[[[[1,"\\n    "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,[30,0,["title"]]]],[]]]]],[1,"\\n    "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n      "],[1,[30,0,["message"]]],[1,"\\n    "]],[]]]]],[1,"\\n"],[41,[30,2],[[[1,"      "],[8,[30,1,["LinkStandalone"]],null,[["@icon","@iconPosition","@text","@route","@query"],["arrow-right","trailing",[28,[37,5],["Log into ",[30,0,["ns"]]," namespace"],null],"vault.cluster.logout",[30,0,["queryParams"]]]],null],[1,"\\n"]],[]],null],[1,"  "]],[1]]]]],[1,"\\n"]],[]],null]],["A","@isEnterprise"],false,["unless","hds/alert","fn","mut","if","concat"]]',moduleName:"vault/components/resultant-acl-banner.hbs",isStrictMode:!1})
let m=e.default=(o=class extends i.default{constructor(...e){super(...e),d(this,"namespace",s,this),d(this,"router",u,this),d(this,"hideBanner",c,this)}get ns(){return this.namespace.path||"root"}get queryParams(){return{redirect_to:this.router.currentURL}}get title(){return this.args.failType===l.PERMISSIONS_BANNER_STATES.noAccess?"You do not have access to this namespace":"Resultant ACL check failed"}get message(){return this.args.failType===l.PERMISSIONS_BANNER_STATES.noAccess?"Log into the namespace directly, or contact your administrator if you think you should have access.":"Links might be shown that you don't have access to. Contact your administrator to update your policy."}},s=p(o.prototype,"namespace",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u=p(o.prototype,"router",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=p(o.prototype,"hideBanner",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),o);(0,t.setComponentTemplate)(f,m)})),define("vault/components/role-aws-edit",["exports","@ember/component","@ember/utils","@ember/object","vault/components/role-edit","@ember/template-factory"],(function(e,t,n,i,r,l){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=(0,l.createTemplateFactory)({id:"9oRbx+0G",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@baseKey","@path","@mode","@root","@showCurrent"],[[30,0,["model"]],"vault.cluster.secrets.backend.list",[30,0,["mode"]],[30,0,["root"]],true]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n"],[41,[28,[37,4],[[30,0,["mode"]],"create"],null],[[[1,"        Create an AWS Role\\n"]],[]],[[[41,[28,[37,4],[[30,0,["mode"]],"edit"],null],[[[1,"        Edit AWS Role\\n        "],[10,"code"],[12],[1,[30,0,["model","id"]]],[13],[1,"\\n"]],[]],[[[1,"        AWS Role\\n        "],[10,"code"],[12],[1,[30,0,["model","id"]]],[13],[1,"\\n      "]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[28,[37,4],[[30,0,["mode"]],"show"],null],[[[1,"  "],[8,[39,6],null,null,[["default"],[[[[1,"\\n    "],[8,[39,7],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["model","canDelete"]],[[[1,"        "],[8,[39,8],[[24,0,"toolbar-button"]],[["@buttonText","@buttonColor","@onConfirmAction"],["Delete role","secondary",[28,[37,9],[[30,0],"delete"],null]]],null],[1,"\\n        "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n"]],[]],null],[41,[30,0,["model","canGenerate"]],[[[1,"        "],[8,[39,11],null,[["@secret","@mode"],[[30,0,["model","id"]],"credentials"]],[["default"],[[[[1,"\\n          Generate credentials\\n        "]],[]]]]],[1,"\\n"]],[]],null],[41,[30,0,["model","canEdit"]],[[[1,"        "],[8,[39,11],null,[["@secret","@mode","@replace"],[[30,0,["model","id"]],"edit",true]],[["default"],[[[[1,"\\n          Edit role\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,12],[[28,[37,4],[[30,0,["mode"]],"edit"],null],[28,[37,4],[[30,0,["mode"]],"create"],null]],null],[[[1,"  "],[10,"form"],[15,"onsubmit",[28,[37,9],[[30,0],"createOrUpdate","create"],null]],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,14],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n      "],[8,[39,15],null,[["@mode","@noun"],[[30,0,["mode"]],"AWS role"]],null],[1,"\\n"],[41,[28,[37,16],[[30,0,["model","credentialTypes","length"]],1],null],[[[1,"        "],[8,[39,17],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n          "],[8,[30,2,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n          "],[8,[30,2,["Description"]],null,null,[["default"],[[[[1,"\\n            This role has more than one\\n            "],[10,"code"],[12],[1,"credential_type"],[13],[1,", currently:\\n            "],[1,[28,[35,18],[", ",[30,0,["model","credentialTypes"]]],null]],[1,". Multiple credential types is deprecated and you must choose one in\\n            order to save this role.\\n          "]],[]]]]],[1,"\\n        "]],[2]]]]],[1,"\\n"]],[]],null],[42,[28,[37,20],[[28,[37,20],[[52,[28,[37,4],[[30,0,["mode"]],"edit"],null],[28,[37,21],[1,[28,[37,12],[[30,0,["model","fields"]],[28,[37,22],null,null]],null]],null],[30,0,["model","fields"]]]],null]],null],null,[[[1,"        "],[8,[39,23],null,[["@attr","@model"],[[30,3],[30,4]]],null],[1,"\\n"]],[3]],null],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped-split box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,24],null,null,[["default"],[[[[1,"\\n        "],[8,[39,25],[[24,4,"submit"]],[["@text"],[[52,[28,[37,4],[[30,0,["mode"]],"create"],null],"Create role","Save"]]],null],[1,"\\n"],[41,[28,[37,4],[[30,0,["mode"]],"create"],null],[[[1,"          "],[8,[39,25],null,[["@text","@color","@route","@model"],["Cancel","secondary","vault.cluster.secrets.backend.list-root",[30,0,["model","backend"]]]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,25],null,[["@text","@color","@route","@models"],["Cancel","secondary","vault.cluster.secrets.backend.show",[28,[37,22],[[30,0,["model","backend"]],[30,0,["model","id"]]],null]]],null],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[10,0],[14,0,"box is-fullwidth is-sideless is-paddingless is-marginless"],[12],[1,"\\n"],[41,[28,[37,16],[[30,0,["model","credentialTypes","length"]],1],null],[[[1,"      "],[8,[39,17],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n        "],[8,[30,5,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n        "],[8,[30,5,["Description"]],null,null,[["default"],[[[[1,"\\n          This role has more than one\\n          "],[10,"code"],[12],[1,"credential_type"],[13],[1,", currently:\\n          "],[1,[28,[35,18],[", ",[30,0,["model","credentialTypes"]]],null]],[1,". When you next edit this role, you will have to choose a single credential\\n          type.\\n        "]],[]]]]],[1,"\\n      "]],[5]]]]],[1,"\\n"]],[]],null],[42,[28,[37,20],[[28,[37,20],[[30,0,["model","fields"]]],null]],null],null,[[[41,[28,[37,4],[[30,6,["name"]],"policyDocument"],null],[[[1,"        "],[8,[39,26],null,[["@label","@value"],[[28,[37,27],[[28,[37,12],[[30,6,["options","label"]],[28,[37,28],[[28,[37,29],[[30,6,["name"]]],null]],null]],null]],null],[30,0,["model","policyDocument"]]]],[["default"],[[[[1,"\\n          "],[10,"pre"],[12],[10,"code"],[14,0,"is-paddingless"],[12],[1,[28,[35,31],[[28,[37,32],[[30,0,["model","policyDocument"]]],null]],null]],[13],[13],[1,"\\n        "]],[]]]]],[1,"\\n"]],[]],[[[1,"        "],[8,[39,26],null,[["@label","@value"],[[28,[37,27],[[28,[37,12],[[30,6,["options","label"]],[28,[37,28],[[28,[37,29],[[30,6,["name"]]],null]],null]],null]],null],[28,[37,33],[[30,0,["model"]],[30,6,["name"]]],null]]],null],[1,"\\n"]],[]]]],[6]],null],[1,"  "],[13],[1,"\\n"]],[]]]],["p","A","attr","@model","A","attr"],false,["page-header","key-value-header","h1","if","eq","code","toolbar","toolbar-actions","confirm-action","action","div","toolbar-secret-link","or","form","message-error","namespace-reminder","gt","hds/alert","join","each","-track-array","drop","array","form-field","hds/button-set","hds/button","info-table-row","capitalize","humanize","dasherize","pre","stringify","jsonify","get"]]',moduleName:"vault/components/role-aws-edit.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(a,r.default.extend({actions:{createOrUpdate(e,t){t.preventDefault()
const r=this.model.id||this.model.name
if("create"!==e||!(0,n.isBlank)(r)){var l=this.model.credential_type
"iam_user"==l&&(0,i.set)(this,"model.role_arns",[]),"assumed_role"==l&&(0,i.set)(this,"model.policy_arns",[]),"federation_token"==l&&((0,i.set)(this,"model.role_arns",[]),(0,i.set)(this,"model.policy_arns",[])),"{}"==this.model.policy_document&&(0,i.set)(this,"model.policy_document",""),this.persist("save",(()=>{this.hasDataChanges(),this.transitionToRoute("vault.cluster.secrets.backend.show",r)}))}},editorUpdated(e,t){try{(0,i.set)(this.model,e,JSON.parse(t))}catch{}}}}))})),define("vault/components/role-edit",["exports","@ember/service","@ember/object/computed","@ember/utils","ember-concurrency","@ember/component","@ember/object","vault/mixins/focus-on-insert","core/utils/keys"],(function(e,t,n,i,r,l,a,o,s){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const u="vault.cluster.secrets.backend.list-root"
e.default=l.default.extend(o.default,{router:(0,t.service)(),mode:null,emptyData:"{\n}",onDataChange(){},onRefresh(){},model:null,requestInFlight:(0,n.or)("model.isLoading","model.isReloading","model.isSaving"),willDestroyElement(){this.model&&this.model.isError&&!this.model.isDestroyed&&!this.model.isDestroying&&this.model.rollbackAttributes(),this._super(...arguments)},waitForKeyUp:(0,r.task)((function*(){for(;;){const e=yield(0,r.waitForEvent)(document.body,"keyup")
this.onEscape(e)}})).on("didInsertElement").cancelOn("willDestroyElement"),transitionToRoute(){this.router.transitionTo(...arguments)},onEscape(e){s.default.ESC.includes(e.key)||"show"!==this.mode||this.transitionToRoute(u)},hasDataChanges(){this.onDataChange(this.model.hasDirtyAttributes)},persist(e,t){const n=this.model
return n[e]().then((()=>{n.isError||t(n)}))},actions:{createOrUpdate(e,t){t.preventDefault()
const n=this.model.id||this.model.name
"create"===e&&(0,i.isBlank)(n)||this.persist("save",(()=>{this.hasDataChanges(),this.transitionToRoute("vault.cluster.secrets.backend.show",n)}))},setValue(e,t){(0,a.set)(this.model,e,t.target.checked)},refresh(){this.onRefresh()},delete(){this.persist("destroyRecord",(()=>{this.hasDataChanges(),this.transitionToRoute(u)}))},editorUpdated(e,t){try{(0,a.set)(this.model,e,JSON.parse(t))}catch{}}}})})),define("vault/components/role-ssh-edit",["exports","@ember/component","vault/components/role-edit","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"4nN4JCrE",block:'[[[1,"\\n"],[8,[39,0],null,null,[["default"],[[[[1,"\\n  "],[8,[30,1,["top"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,[["@baseKey","@path","@mode","@root","@showCurrent"],[[30,0,["model"]],"vault.cluster.secrets.backend.list",[30,0,["mode"]],[30,0,["root"]],true]],null],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["levelLeft"]],null,null,[["default"],[[[[1,"\\n    "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n"],[41,[28,[37,4],[[30,0,["mode"]],"create"],null],[[[1,"        Create an SSH Role\\n"]],[]],[[[41,[28,[37,4],[[30,0,["mode"]],"edit"],null],[[[1,"        Edit SSH Role\\n"]],[]],[[[1,"        SSH Role\\n        "],[10,"code"],[12],[1,[30,0,["model","id"]]],[13],[1,"\\n      "]],[]]]],[]]],[1,"    "],[13],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[28,[37,4],[[30,0,["mode"]],"show"],null],[[[1,"  "],[8,[39,6],null,null,[["default"],[[[[1,"\\n    "],[8,[39,7],null,null,[["default"],[[[[1,"\\n"],[41,[30,0,["model","canDelete"]],[[[1,"        "],[8,[39,8],[[24,0,"toolbar-button"]],[["@buttonText","@buttonColor","@onConfirmAction"],["Delete role","secondary",[28,[37,9],[[30,0],"delete"],null]]],null],[1,"\\n        "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n"]],[]],null],[41,[28,[37,4],[[30,0,["model","keyType"]],"otp"],null],[[[1,"        "],[8,[39,11],null,[["@secret","@mode","@replace"],[[30,0,["model","id"]],"credentials",true]],[["default"],[[[[1,"\\n          Generate Credential\\n        "]],[]]]]],[1,"\\n"]],[]],[[[1,"        "],[8,[39,11],null,[["@secret","@mode","@replace"],[[30,0,["model","id"]],"sign",true]],[["default"],[[[[1,"\\n          Sign Keys\\n        "]],[]]]]],[1,"\\n"]],[]]],[41,[28,[37,12],[[30,0,["model","canUpdate"]],[30,0,["model","canDelete"]]],null],[[[1,"        "],[8,[39,11],null,[["@secret","@mode","@replace"],[[30,0,["model","id"]],"edit",true]],[["default"],[[[[1,"\\n          Edit role\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,12],[[28,[37,4],[[30,0,["mode"]],"edit"],null],[28,[37,4],[[30,0,["mode"]],"create"],null]],null],[[[1,"  "],[10,"form"],[15,"onsubmit",[28,[37,9],[[30,0],"createOrUpdate","create"],null]],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n      "],[8,[39,14],null,[["@model"],[[30,0,["model"]]]],null],[1,"\\n      "],[8,[39,15],null,[["@mode","@noun"],[[30,0,["mode"]],"SSH role"]],null],[1,"\\n      "],[8,[39,16],null,[["@model","@mode"],[[30,0,["model"]],[30,0,["mode"]]]],null],[1,"\\n    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped-split box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,17],null,null,[["default"],[[[[1,"\\n        "],[8,[39,18],[[24,4,"submit"]],[["@text"],[[52,[28,[37,4],[[30,0,["mode"]],"create"],null],"Create role","Save"]]],null],[1,"\\n"],[41,[28,[37,4],[[30,0,["mode"]],"create"],null],[[[1,"          "],[8,[39,18],null,[["@text","@color","@route","@model","@query"],["Cancel","secondary","vault.cluster.secrets.backend.list-root",[30,0,["model","backend"]],[28,[37,19],null,[["tab"],["role"]]]]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,18],null,[["@text","@color","@route","@models"],["Cancel","secondary","vault.cluster.secrets.backend.show",[28,[37,20],[[30,0,["model","backend"]],[30,0,["model","id"]]],null]]],null],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],[[[1,"  "],[10,0],[14,0,"box is-fullwidth is-sideless is-paddingless is-marginless"],[12],[1,"\\n"],[42,[28,[37,22],[[28,[37,22],[[30,0,["model","showFields"]]],null]],null],null,[[[41,[28,[37,4],[[30,2,["type"]],"object"],null],[[[1,"        "],[8,[39,23],null,[["@label","@value"],[[28,[37,24],[[28,[37,12],[[30,2,["options","label"]],[28,[37,25],[[28,[37,26],[[30,2,["name"]]],null]],null]],null]],null],[28,[37,27],[[28,[37,28],[[30,0,["model"]],[30,2,["name"]]],null]],null]]],null],[1,"\\n"]],[]],[[[1,"        "],[8,[39,23],null,[["@label","@value"],[[28,[37,24],[[28,[37,12],[[30,2,["options","label"]],[28,[37,25],[[28,[37,26],[[30,2,["name"]]],null]],null]],null]],null],[28,[37,28],[[30,0,["model"]],[30,2,["name"]]],null]]],null],[1,"\\n"]],[]]]],[2]],null],[1,"  "],[13],[1,"\\n"]],[]]]],["p","attr"],false,["page-header","key-value-header","h1","if","eq","code","toolbar","toolbar-actions","confirm-action","action","div","toolbar-secret-link","or","form","message-error","namespace-reminder","form-field-groups-loop","hds/button-set","hds/button","hash","array","each","-track-array","info-table-row","capitalize","humanize","dasherize","stringify","get"]]',moduleName:"vault/components/role-ssh-edit.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,n.default.extend({init(){this._super(...arguments),this.set("backendType","ssh")},actions:{updateTtl(e,t){const n=this.model,i=!0===t.enabled?`${t.seconds}s`:void 0
n.set(e,i)}}}))})),define("vault/components/seal-action",["exports","@ember/component","@ember/object","@glimmer/component","@glimmer/tracking","vault/utils/error-message","@ember/template-factory"],(function(e,t,n,i,r,l,a){var o,s
function u(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const c=(0,a.createTemplateFactory)({id:"yxL7XIPU",block:'[[[1,"\\n"],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless"],[12],[1,"\\n"],[41,[30,0,["error"]],[[[1,"    "],[8,[39,2],[[24,0,"has-bottom-margin-m"]],[["@type","@color"],["inline","critical"]],[["default"],[[[[1,"\\n      "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Error"]],[]]]]],[1,"\\n      "],[8,[30,1,["Description"]],null,null,[["default"],[[[[1,"\\n        "],[1,[30,0,["error"]]],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[1]]]]],[1,"\\n"]],[]],null],[1,"  "],[10,2],[12],[1,"\\n    Sealing a vault tells the Vault server to stop responding to any access operations until it is unsealed again. A sealed\\n    vault throws away its root key to unlock the data, so it physically is blocked from responding to operations again until\\n    the Vault is unsealed again with the \\"unseal\\" command or via the API.\\n  "],[13],[1,"\\n"],[13],[1,"\\n\\n"],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n  "],[8,[39,4],null,[["@buttonText","@confirmTitle","@confirmMessage","@onConfirmAction"],["Seal","Seal this cluster?","You will not be able to read or write any data until the cluster is unsealed again.",[30,0,["handleSeal"]]]],null],[1,"\\n"],[13]],["A"],false,["div","if","hds/alert","p","confirm-action"]]',moduleName:"vault/components/seal-action.hbs",isStrictMode:!1})
let d=e.default=(o=class extends i.default{constructor(...e){var t,n,i,r
super(...e),t=this,n="error",r=this,(i=s)&&Object.defineProperty(t,n,{enumerable:i.enumerable,configurable:i.configurable,writable:i.writable,value:i.initializer?i.initializer.call(r):void 0})}async handleSeal(){try{await this.args.onSeal()}catch(e){this.error=(0,l.default)(e,"Seal attempt failed. Check Vault logs for details.")}}},s=u(o.prototype,"error",[r.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),u(o.prototype,"handleSeal",[n.action],Object.getOwnPropertyDescriptor(o.prototype,"handleSeal"),o.prototype),o);(0,t.setComponentTemplate)(c,d)})),define("vault/components/search-select-placeholder",["exports","core/components/search-select-placeholder"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/search-select-with-modal",["exports","core/components/search-select-with-modal"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/search-select",["exports","core/components/search-select"],(function(e,t){Object.defineProperty(e,"__esModule",{value:!0}),Object.defineProperty(e,"default",{enumerable:!0,get:function(){return t.default}})})),define("vault/components/secret-create-or-update",["exports","@ember/component","@glimmer/component","ember","core/utils/keys","@ember/object","@ember/service","@glimmer/tracking","@ember/utils","ember-concurrency","vault/utils/forms/validators","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c,d){var p,f,m,h,b,y,g,v,w,k,x,P,_
function T(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function O(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function j(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const z=(0,d.createTemplateFactory)({id:"C6zUg+xb",block:'[[[1,"\\n"],[41,[28,[37,1],[[30,1],"create"],null],[[[1,"  "],[11,"form"],[16,0,[52,[30,2],"advanced-edit","simple-edit"]],[24,"aria-label","secret create form"],[4,[38,3],["submit",[28,[37,4],[[30,0,["createOrUpdateKey"]],[30,1]],null]],null],[4,[38,5],[[30,0,["setup"]],[30,3],[30,1]],null],[12],[1,"\\n    "],[10,0],[14,0,"field box is-fullwidth is-sideless is-marginless"],[12],[1,"\\n      "],[8,[39,7],null,[["@mode","@noun"],["create","secret"]],null],[1,"\\n      "],[8,[39,8],null,[["@model","@errorMessage"],[[30,4],[30,0,["error"]]]],null],[1,"\\n      "],[10,"label"],[14,0,"is-label"],[14,"for","kv-key"],[12],[1,"Path for this secret"],[13],[1,"\\n      "],[10,2],[14,0,"control is-expanded"],[12],[1,"\\n        "],[8,[39,11],[[24,"autocomplete","off"],[24,"spellcheck","false"],[24,1,"kv-key"],[16,0,[29,["input ",[52,[28,[37,12],[[30,0,["validationMessages"]],"path"],null],"has-error-border"]]]],[4,[38,3],["keyup",[28,[37,13],[[30,0,["waitForKeyUp"]],"path"],[["value"],["target.value"]]]],null]],[["@value"],[[28,[37,12],[[30,4],[30,4,["pathAttr"]]],null]]],null],[1,"\\n      "],[13],[1,"\\n"],[41,[28,[37,12],[[30,0,["validationMessages"]],"path"],null],[[[1,"        "],[8,[39,14],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[28,[37,15],[[28,[37,12],[[30,0,["validationMessages"]],"path"],null]],null]]],null],[1,"\\n"]],[]],null],[41,[30,4,["isFolder"]],[[[1,"        "],[10,2],[14,0,"help has-text-danger"],[12],[1,"\\n          The secret path may not end in\\n          "],[10,"code"],[12],[1,"/"],[13],[1,"\\n        "],[13],[1,"\\n"]],[]],null],[41,[30,0,["pathWhiteSpaceWarning"]],[[[1,"        "],[8,[39,17],[[24,0,"has-top-margin-m has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n          "],[8,[30,5,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n          "],[8,[30,5,["Description"]],null,null,[["default"],[[[[1,"\\n            "],[1,[30,0,["whitespaceWarning"]]],[1,"\\n          "]],[]]]]],[1,"\\n        "]],[5]]]]],[1,"\\n"]],[]],null],[1,"    "],[13],[1,"\\n"],[41,[30,2],[[[1,"      "],[10,0],[14,0,"form-section"],[12],[1,"\\n        "],[8,[39,18],null,[["@title","@value","@valueUpdated","@onBlur"],["Secret Data",[30,0,["editorString"]],[30,0,["editorUpdated"]],[30,0,["formatJSON"]]]],null],[1,"\\n      "],[13],[1,"\\n"]],[]],[[[1,"      "],[10,0],[14,0,"form-section"],[12],[1,"\\n        "],[10,"label"],[14,0,"title is-5"],[12],[1,"\\n          Secret data\\n        "],[13],[1,"\\n"],[42,[28,[37,20],[[28,[37,20],[[30,3]],null]],null],null,[[[1,"          "],[10,0],[14,0,"info-table-row"],[12],[1,"\\n            "],[10,0],[14,0,"column is-one-quarter info-table-row-edit"],[12],[1,"\\n              "],[8,[39,11],[[24,"placeholder","key"],[24,0,"input"],[24,"autocomplete","off"],[24,"spellcheck","false"],[4,[38,3],["change",[30,0,["handleChange"]]],null]],[["@value"],[[30,6,["name"]]]],null],[1,"\\n            "],[13],[1,"\\n            "],[10,0],[14,0,"column info-table-row-edit"],[12],[1,"\\n              "],[8,[39,21],null,[["@name","@onChange","@value"],[[30,6,["name"]],[28,[37,4],[[30,0,["handleMaskedInputChange"]],[30,6],[30,7]],null],[30,6,["value"]]]],null],[1,"\\n            "],[13],[1,"\\n            "],[10,0],[14,0,"column is-narrow info-table-row-edit"],[12],[1,"\\n"],[41,[28,[37,1],[[30,3,["length"]],[28,[37,22],[[30,7]],null]],null],[[[1,"                "],[8,[39,23],[[4,[38,3],["click",[30,0,["addRow"]]],null]],[["@text","@color"],["Add","secondary"]],null],[1,"\\n"]],[]],[[[1,"                "],[8,[39,23],[[4,[38,3],["click",[28,[37,4],[[30,0,["deleteRow"]],[30,6,["name"]]],null]],null]],[["@text","@icon","@isIconOnly","@color"],["Delete row","trash",true,"secondary"]],null],[1,"\\n"]],[]]],[1,"            "],[13],[1,"\\n          "],[13],[1,"\\n"],[41,[30,0,["validationMessages","key"]],[[[1,"            "],[8,[39,14],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["validationMessages","key"]]]],null],[1,"\\n"]],[]],null]],[6,7]],null],[1,"      "],[13],[1,"\\n"]],[]]],[1,"\\n    "],[10,0],[14,0,"field is-grouped box is-fullwidth is-bottomless"],[12],[1,"\\n      "],[8,[39,24],null,null,[["default"],[[[[1,"\\n        "],[8,[39,23],[[16,"disabled",[30,8]],[24,4,"submit"]],[["@text"],["Save"]],null],[1,"\\n"],[41,[30,9,["path"]],[[[1,"          "],[8,[39,23],null,[["@text","@color","@route","@model"],["Cancel","secondary","vault.cluster.secrets.backend.list",[30,9,["path"]]]],null],[1,"\\n"]],[]],[[[1,"          "],[8,[39,23],null,[["@text","@color","@route"],["Cancel","secondary","vault.cluster.secrets.backend.list-root"]],null],[1,"\\n"]],[]]],[1,"      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,1],[[30,1],"edit"],null],[[[1,"  "],[11,"form"],[24,"aria-label","secret edit form"],[4,[38,3],["submit",[28,[37,4],[[30,0,["createOrUpdateKey"]],"edit"],null]],null],[4,[38,5],[[30,0,["setup"]],[30,3],[30,1]],null],[12],[1,"\\n    "],[10,0],[14,0,"box is-sideless is-fullwidth is-marginless padding-top"],[12],[1,"\\n      "],[8,[39,8],null,[["@model","@errorMessage"],[[30,4],[30,0,["error"]]]],null],[1,"\\n      "],[8,[39,7],null,[["@mode","@noun"],["edit","secret"]],null],[1,"\\n"],[41,[28,[37,1],[[30,10],false],null],[[[1,"        "],[8,[39,17],[[24,0,"has-bottom-margin-s"]],[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n          "],[8,[30,11,["Title"]],null,null,[["default"],[[[[1,"Warning"]],[]]]]],[1,"\\n          "],[8,[30,11,["Description"]],null,null,[["default"],[[[[1,"\\n            You do not have read permissions. If a secret exists at this path creating a new secret will overwrite it.\\n          "]],[]]]]],[1,"\\n        "]],[11]]]]],[1,"\\n"]],[]],null],[41,[30,2],[[[1,"        "],[10,0],[14,0,"form-section"],[12],[1,"\\n          "],[8,[39,18],null,[["@title","@value","@valueUpdated","@onBlur"],["Secret Data",[30,0,["editorString"]],[30,0,["editorUpdated"]],[30,0,["formatJSON"]]]],null],[1,"\\n        "],[13],[1,"\\n"]],[]],[[[1,"        "],[10,0],[14,0,"form-section"],[12],[1,"\\n          "],[10,"label"],[14,0,"title is-5"],[12],[1,"\\n            Secret data\\n          "],[13],[1,"\\n"],[42,[28,[37,20],[[28,[37,20],[[30,3]],null]],null],null,[[[1,"            "],[10,0],[14,0,"columns is-variable has-no-shadow"],[12],[1,"\\n              "],[10,0],[14,0,"column is-one-quarter"],[12],[1,"\\n                "],[8,[39,11],[[24,"placeholder","key"],[24,0,"input"],[24,"autocomplete","off"],[24,"spellcheck","false"],[4,[38,3],["change",[30,0,["handleChange"]]],null]],[["@value"],[[30,12,["name"]]]],null],[1,"\\n              "],[13],[1,"\\n              "],[10,0],[14,0,"column"],[12],[1,"\\n                "],[8,[39,21],null,[["@name","@onChange","@value"],[[30,12,["name"]],[28,[37,4],[[30,0,["handleMaskedInputChange"]],[30,12],[30,13]],null],[30,12,["value"]]]],null],[1,"\\n              "],[13],[1,"\\n              "],[10,0],[14,0,"column is-narrow"],[12],[1,"\\n"],[41,[28,[37,1],[[30,3,["length"]],[28,[37,22],[[30,13]],null]],null],[[[1,"                  "],[8,[39,23],[[4,[38,3],["click",[30,0,["addRow"]]],null]],[["@text","@color"],["Add","secondary"]],null],[1,"\\n"]],[]],[[[1,"                  "],[8,[39,23],[[4,[38,3],["click",[28,[37,4],[[30,0,["deleteRow"]],[30,12,["name"]]],null]],null]],[["@text","@icon","@isIconOnly","@color"],["Delete row","trash",true,"secondary"]],null],[1,"\\n"]],[]]],[1,"              "],[13],[1,"\\n            "],[13],[1,"\\n"]],[12,13]],null],[1,"        "],[13],[1,"\\n"]],[]]],[1,"    "],[13],[1,"\\n    "],[10,0],[14,0,"field is-grouped is-grouped-split is-fullwidth box is-bottomless"],[12],[1,"\\n      "],[10,0],[14,0,"field is-grouped"],[12],[1,"\\n        "],[8,[39,24],null,null,[["default"],[[[[1,"\\n          "],[8,[39,23],[[16,"disabled",[28,[37,25],[[30,8],[30,0,["validationErrorCount"]]],null]],[24,4,"submit"]],[["@text"],["Save"]],null],[1,"\\n          "],[8,[39,23],null,[["@text","@color","@route","@model","@query"],["Cancel","secondary","vault.cluster.secrets.backend.show",[30,9,["id"]],[28,[37,26],null,[["version"],[[30,4,["version"]]]]]]],null],[1,"\\n        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]],null]],["@mode","@showAdvancedMode","@secretData","@modelForData","A","secret","index","@buttonDisabled","@model","@canReadSecret","A","secret","index"],false,["if","eq","form","on","fn","did-insert","div","namespace-reminder","message-error","label","p","input","get","perform","alert-inline","capitalize","code","hds/alert","json-editor","each","-track-array","masked-input","inc","hds/button","hds/button-set","or","hash"]]',moduleName:"vault/components/secret-create-or-update.hbs",isStrictMode:!1})
let M=e.default=(p=(0,u.task)((function*(e,t){for(this.checkValidation(e,t);;){const e=yield(0,u.waitForEvent)(document.body,"keyup")
this.onEscape(e)}})).on("didInsertElement").cancelOn("willDestroyElement"),f=class extends n.default{constructor(...e){super(...e),T(this,"editorString",m,this),T(this,"error",h,this),T(this,"secretPaths",b,this),T(this,"pathWhiteSpaceWarning",y,this),T(this,"validationErrorCount",g,this),T(this,"validationMessages",v,this),T(this,"controlGroup",w,this),T(this,"flashMessages",k,this),T(this,"router",x,this),T(this,"store",P,this),O(this,"whitespaceWarning",(0,c.WHITESPACE_WARNING)("path")),T(this,"waitForKeyUp",_,this)}setup(e,[t,n]){this.editorString=t.toJSONString(),this.validationMessages={path:""},i.default.testing&&(this.secretPaths=["beep","bop","boop"]),this.checkRows(),"edit"===n&&this.addRow()}checkRows(){0===this.args.secretData.length&&this.addRow()}checkValidation(e,t){"path"===e&&(this.pathHasWhiteSpace(t),t?(0,l.set)(this.validationMessages,e,""):(0,l.set)(this.validationMessages,e,`${e} can't be blank.`))
const n=Object.values(this.validationMessages)
this.validationErrorCount=n.filter(Boolean).length}onEscape(e){if(r.default.ESC.includes(e.key)||"show"!==this.args.mode)return
const t=this.args.model.parentKey
t?this.transitionToRoute("vault.cluster.secrets.backend.list",t):this.transitionToRoute("vault.cluster.secrets.backend.list-root")}pathHasWhiteSpace(e){const t=new RegExp("\\s","g")
this.pathWhiteSpaceWarning=t.test(e)}persistKey(e){const t=this.args.model,n=this.args.modelForData
let i=n?.path||t.id
return i.startsWith("/")&&(i=i.replace(/^\/+/g,""),n.set(n.pathAttr,i)),n.save().then((()=>{n.isError||this.saveComplete(e,i)})).catch((e=>{if(e.isControlGroupError){this.controlGroup.saveTokenFromError(e)
const t=this.controlGroup.logFromError(e)
this.error=t.content}throw e}))}saveComplete(e,t){e(t)}transitionToRoute(){return this.router.transitionTo(...arguments)}addRow(){const e=this.args.secretData;(0,s.isNone)(e.find((e=>""===e.name)))&&(e.pushObject({name:"",value:""}),this.handleChange()),this.checkRows()}editorUpdated(e){try{this.args.secretData.fromJSONString(e),(0,l.set)(this.args.modelForData,"secretData",this.args.secretData.toJSON())}catch(t){this.error=t.message}this.editorString=e}createOrUpdateKey(e,t){if(t.preventDefault(),"create"===e&&(0,s.isBlank)(this.args.modelForData.path||this.args.modelForData.id))return void this.checkValidation("path","")
const n="create"===e?this.args.modelForData.path:this.args.model.id
this.persistKey((()=>{this.flashMessages.success(`Secret ${n} ${"create"===e?"created":"updated"} successfully.`),this.transitionToRoute("vault.cluster.secrets.backend.show",n)}))}deleteRow(e){const t=this.args.secretData,n=t.find((t=>t.name===e));(0,s.isBlank)(n.name)||(t.removeObject(n),this.checkRows(),this.handleChange())}formatJSON(){this.editorString=this.args.secretData.toJSONString(!0)}handleMaskedInputChange(e,t,n){const i={...e,value:n};(0,l.set)(this.args.secretData,t,i),this.handleChange()}handleChange(){this.editorString=this.args.secretData.toJSONString(!0),(0,l.set)(this.args.modelForData,"secretData",this.args.secretData.toJSON())}updateValidationErrorCount(e){this.validationErrorCount=e}},m=j(f.prototype,"editorString",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=j(f.prototype,"error",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b=j(f.prototype,"secretPaths",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),y=j(f.prototype,"pathWhiteSpaceWarning",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),g=j(f.prototype,"validationErrorCount",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return 0}}),v=j(f.prototype,"validationMessages",[o.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),w=j(f.prototype,"controlGroup",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=j(f.prototype,"flashMessages",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=j(f.prototype,"router",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=j(f.prototype,"store",[a.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j(f.prototype,"setup",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"setup"),f.prototype),_=j(f.prototype,"waitForKeyUp",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),j(f.prototype,"addRow",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"addRow"),f.prototype),j(f.prototype,"editorUpdated",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"editorUpdated"),f.prototype),j(f.prototype,"createOrUpdateKey",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"createOrUpdateKey"),f.prototype),j(f.prototype,"deleteRow",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"deleteRow"),f.prototype),j(f.prototype,"formatJSON",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"formatJSON"),f.prototype),j(f.prototype,"handleMaskedInputChange",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"handleMaskedInputChange"),f.prototype),j(f.prototype,"handleChange",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"handleChange"),f.prototype),j(f.prototype,"updateValidationErrorCount",[l.action],Object.getOwnPropertyDescriptor(f.prototype,"updateValidationErrorCount"),f.prototype),f);(0,t.setComponentTemplate)(z,M)})),define("vault/components/secret-edit-toolbar",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","@ember/test-waiters","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d,p,f
function m(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function h(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,s.createTemplateFactory)({id:"Xuu5Wof9",block:'[[[1,"\\n"],[8,[39,0],[[24,"aria-label","manage secret"]],null,[["default"],[[[[1,"\\n"],[41,[51,[28,[37,2],[[28,[37,3],[[30,1],"show"],null],[30,2]],null]],[[[1,"    "],[8,[39,4],[[24,"aria-label","manage view"]],null,[["default"],[[[[1,"\\n      "],[8,[39,5],null,[["@name","@disabled","@checked","@onChange"],["json",[28,[37,2],[[28,[37,3],[[30,1],"show"],null],[30,3]],null],[30,4],[28,[37,6],[[30,0],[30,5,["toggleAdvanced"]]],null]]],[["default"],[[[[1,"\\n        "],[10,1],[14,0,"has-text-grey"],[12],[1,"JSON"],[13],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null],[1,"  "],[8,[39,8],[[16,"aria-label",[29,["actions for ",[30,6,["id"]]]]]],null,[["default"],[[[[1,"\\n"],[41,[28,[37,2],[[28,[37,3],[[30,1],"show"],null],[30,6,["canDelete"]]],null],[[[1,"      "],[8,[39,10],[[24,0,"toolbar-button"]],[["@buttonText","@buttonColor","@confirmTitle","@confirmMessage","@onConfirmAction"],["Delete","secondary","Delete secret?","You will not be able to recover this secret data later.",[30,0,["handleDelete"]]]],null],[1,"\\n      "],[10,0],[14,0,"toolbar-separator"],[12],[13],[1,"\\n"]],[]],null],[41,[28,[37,2],[[28,[37,3],[[30,1],"show"],null],[30,7]],null],[[[41,[51,[28,[37,12],[[30,2],[30,8,["deleted"]]],null]],[[[1,"        "],[8,[39,13],null,[["@clipboardText","@onWrap","@isWrapping","@wrappedData","@onClose"],[[28,[37,14],[[30,8,["secretData"]]],null],[28,[37,15],[[30,0,["wrapSecret"]]],null],[30,0,["wrapSecret","isRunning"]],[30,0,["wrappedData"]],[30,0,["clearWrappedData"]]]],null],[1,"\\n"]],[]],null]],[]],null],[1,"\\n"],[41,[28,[37,2],[[28,[37,3],[[30,1],"show"],null],[30,7]],null],[[[44,[[28,[37,17],["vault.cluster.secrets.backend.",[52,[28,[37,3],[[30,1],"show"],null],"edit","show"]],null]],[[[1,"        "],[8,[39,18],null,[["@route","@model","@replace"],[[30,9],[30,6,["id"]],true]],[["default"],[[[[1,"\\n          Edit secret\\n        "]],[]]]]],[1,"\\n"]],[9]]]],[]],null],[1,"  "]],[]]]]],[1,"\\n"]],[]]]]]],["@mode","@isWriteWithoutRead","@secretDataIsAdvanced","@showAdvancedMode","@editActions","@model","@canUpdateSecret","@modelForData","targetRoute"],false,["toolbar","unless","and","eq","toolbar-filters","toggle","action","span","toolbar-actions","if","confirm-action","div","or","copy-secret-dropdown","stringify","perform","let","concat","toolbar-link"]]',moduleName:"vault/components/secret-edit-toolbar.hbs",isStrictMode:!1})
let y=e.default=(u=class extends n.default{constructor(...e){super(...e),m(this,"store",c,this),m(this,"router",d,this),m(this,"flashMessages",p,this),m(this,"wrappedData",f,this)}clearWrappedData(){this.wrappedData=null}handleDelete(){this.args.model.destroyRecord().then((()=>{this.router.transitionTo("vault.cluster.secrets.backend.list-root")}))}*wrapSecret(){const{id:e}=this.args.modelForData,{backend:t}=this.args.model,n={wrapTTL:1800}
try{const i=yield this.store.adapterFor("secret").queryRecord(null,null,{backend:t,id:e,...n})
this.wrappedData=i.wrap_info.token,this.flashMessages.success("Secret successfully wrapped!")}catch(i){this.flashMessages.danger("Could not wrap secret.")}}},c=h(u.prototype,"store",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(u.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=h(u.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=h(u.prototype,"wrappedData",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h(u.prototype,"clearWrappedData",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"clearWrappedData"),u.prototype),h(u.prototype,"handleDelete",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"handleDelete"),u.prototype),h(u.prototype,"wrapSecret",[a.task,o.waitFor],Object.getOwnPropertyDescriptor(u.prototype,"wrapSecret"),u.prototype),u);(0,t.setComponentTemplate)(b,y)})),define("vault/components/secret-edit",["exports","@ember/component","@ember/service","@glimmer/component","@ember/object","@glimmer/tracking","vault/lib/kv-object","vault/macros/maybe-query-record","@ember/object/computed","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f,m,h,b,y,g,v,w,k,x,P
function _(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function T(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const O=(0,u.createTemplateFactory)({id:"Nkt6wz8i",block:'[[[1,"\\n"],[11,0],[4,[38,1],[[30,0,["createKvData"]],[30,1]],null],[12],[1,"\\n  "],[8,[39,2],null,null,[["default"],[[[[1,"\\n    "],[8,[30,2,["top"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,3],null,[["@baseKey","@path","@mode","@root","@showCurrent"],[[30,3],"vault.cluster.secrets.backend.list",[30,4],[30,5],true]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,2,["levelLeft"]],null,null,[["default"],[[[[1,"\\n      "],[10,"h1"],[14,0,"title is-3"],[12],[1,"\\n"],[41,[28,[37,6],[[30,4],"create"],null],[[[1,"          Create Secret\\n"]],[]],[[[41,[28,[37,6],[[30,4],"edit"],null],[[[1,"          Edit Secret\\n"]],[]],[[[1,"          "],[1,[30,6,["id"]]],[1,"\\n          "],[8,[39,7],null,[["@isIconOnly","@text","@textToCopy"],[true,"Copy your secret path",[30,6,["id"]]]],null],[1,"\\n        "]],[]]]],[]]],[1,"      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[2]]]]],[1,"\\n"],[41,[28,[37,6],[[30,4],"show"],null],[[[1,"    "],[10,0],[14,0,"tabs-container box is-bottomless is-marginless is-fullwidth is-paddingless"],[12],[1,"\\n      "],[10,"nav"],[14,0,"tabs"],[14,"aria-label","navigation for secret management"],[12],[1,"\\n        "],[10,"ul"],[12],[1,"\\n          "],[10,"li"],[12],[1,"\\n            "],[8,[39,11],null,[["@route","@model"],["vault.cluster.secrets.backend.show",[30,6,["id"]]]],[["default"],[[[[1,"\\n              Secret\\n            "]],[]]]]],[1,"\\n          "],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[41,[28,[37,12],[[30,1],[28,[37,13],[[30,0,["secretData"]],null],null]],null],[[[1,"    "],[8,[39,14],null,[["@mode","@model","@isWriteWithoutRead","@secretDataIsAdvanced","@showAdvancedMode","@modelForData","@canUpdateSecret","@editorString","@editActions"],[[30,4],[30,1],[30,0,["isWriteWithoutRead"]],[30,0,["secretDataIsAdvanced"]],[30,0,["showAdvancedMode"]],[30,0,["modelForData"]],[30,0,["canUpdateSecret"]],[30,0,["editorString"]],[28,[37,15],null,[["toggleAdvanced","refresh"],[[28,[37,16],[[30,0],"toggleAdvanced"],null],[28,[37,16],[[30,0],"refresh"],null]]]]]],null],[1,"\\n\\n"],[41,[28,[37,17],[[28,[37,6],[[30,4],"create"],null],[28,[37,6],[[30,4],"edit"],null]],null],[[[1,"      "],[8,[39,18],null,[["@mode","@model","@showAdvancedMode","@modelForData","@error","@secretData","@buttonDisabled","@canReadSecret"],[[30,4],[30,1],[30,0,["showAdvancedMode"]],[30,0,["modelForData"]],[30,0,["error"]],[30,0,["secretData"]],[30,0,["buttonDisabled"]],[30,0,["canReadSecret"]]]],null],[1,"\\n"]],[]],[[[41,[28,[37,6],[[30,4],"show"],null],[[[1,"      "],[8,[39,19],null,[["@modelForData","@isWriteWithoutRead","@showAdvancedMode"],[[30,0,["modelForData"]],[30,0,["isWriteWithoutRead"]],[30,0,["showAdvancedMode"]]]],null],[1,"\\n"]],[]],[[[1,"      "],[8,[39,20],null,[["@title"],["No secret view was selected"]],null],[1,"\\n    "]],[]]]],[]]]],[]],null],[13]],["@model","p","@baseKey","@mode","@root","@key"],false,["div","did-insert","page-header","key-value-header","h1","if","eq","hds/copy/button","nav","ul","li","link-to","and","not-eq","secret-edit-toolbar","hash","action","or","secret-create-or-update","secret-form-show","empty-state"]]',moduleName:"vault/components/secret-edit.hbs",isStrictMode:!1})
let j=e.default=(c=(0,o.maybeQueryRecord)("capabilities",(e=>{if(!e.args.model||"create"===e.args.mode)return
return{id:`${e.args.model.backend}/${e.args.model.id}`}}),"model","model.id","mode"),d=(0,s.alias)("checkSecretCapabilities.canUpdate"),p=(0,s.alias)("checkSecretCapabilities.canRead"),f=(0,s.or)("model.isLoading","model.isReloading","model.isSaving"),m=(0,s.or)("requestInFlight","model.isFolder","model.flagsIsInvalid"),h=class extends i.default{constructor(...e){super(...e),_(this,"store",b,this),_(this,"secretData",y,this),_(this,"editorString",g,this),_(this,"checkSecretCapabilities",v,this),_(this,"canUpdateSecret",w,this),_(this,"canReadSecret",k,this),_(this,"requestInFlight",x,this),_(this,"buttonDisabled",P,this)}createKvData(e,[t]){this.secretData=a.default.create({content:[]}).fromJSON(t.secretData),this.editorString=this.secretData.toJSONString()}get modelForData(){const{model:e}=this.args
return e||null}get basicModeDisabled(){return this.secretDataIsAdvanced||!1===this.showAdvancedMode}get secretDataAsJSON(){return this.secretData.toJSON()}get secretDataIsAdvanced(){return this.secretData.isAdvanced()}get showAdvancedMode(){return this.secretDataIsAdvanced||this.args.preferAdvancedEdit}get isWriteWithoutRead(){return!!this.args.model&&!!this.args.model.failedServerRead}refresh(){this.args.onRefresh()}toggleAdvanced(e){this.args.onToggleAdvancedEdit(e)}},b=T(h.prototype,"store",[n.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=T(h.prototype,"secretData",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),g=T(h.prototype,"editorString",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),T(h.prototype,"createKvData",[r.action],Object.getOwnPropertyDescriptor(h.prototype,"createKvData"),h.prototype),v=T(h.prototype,"checkSecretCapabilities",[c],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),w=T(h.prototype,"canUpdateSecret",[d],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),k=T(h.prototype,"canReadSecret",[p],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),x=T(h.prototype,"requestInFlight",[f],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),P=T(h.prototype,"buttonDisabled",[m],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),T(h.prototype,"refresh",[r.action],Object.getOwnPropertyDescriptor(h.prototype,"refresh"),h.prototype),T(h.prototype,"toggleAdvanced",[r.action],Object.getOwnPropertyDescriptor(h.prototype,"toggleAdvanced"),h.prototype),h);(0,t.setComponentTemplate)(O,j)})),define("vault/components/secret-engine/card/metadata",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"kdDY0I2N",block:'[[[8,[39,0],[[24,0,"has-padding-m has-top-bottom-margin-12"],[17,1]],[["@level","@hasBorder"],["mid",true]],[["default"],[[[[1,"\\n  "],[8,[39,1],[[24,0,"has-bottom-margin-s hds-foreground-strong"]],[["@size","@tag"],["300","h2"]],[["default"],[[[[1,"Metadata"]],[]]]]],[1,"\\n\\n  "],[10,0],[14,0,"flex gap-16 is-flex-column has-top-padding-s"],[12],[1,"\\n    "],[8,[39,3],null,[["@layout"],["vertical"]],[["default"],[[[[1,"\\n      "],[8,[30,2,["Legend"]],null,null,[["default"],[[[[1,"Path"]],[]]]]],[1,"\\n      "],[8,[30,2,["HelperText"]],null,null,[["default"],[[[[1,"The mount path where this secrets engine is accessible."]],[]]]]],[1,"\\n      "],[8,[30,2,["Control"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,4],null,[["@gap"],["8"]],[["default"],[[[[1,"\\n          "],[8,[39,5],null,[["@textToCopy","@color"],[[30,3,["secretsEngine","path"]],"secondary"]],null],[1,"\\n        "]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[2]]]]],[1,"\\n\\n    "],[8,[39,3],null,[["@layout"],["vertical"]],[["default"],[[[[1,"\\n      "],[8,[30,4,["Legend"]],null,null,[["default"],[[[[1,"Accessor"]],[]]]]],[1,"\\n      "],[8,[30,4,["HelperText"]],null,null,[["default"],[[[[1,"Internal identifier used by Vault to reference this engine."]],[]]]]],[1,"\\n      "],[8,[30,4,["Control"]],null,null,[["default"],[[[[1,"\\n        "],[8,[39,4],null,[["@gap"],["8"]],[["default"],[[[[1,"\\n          "],[8,[39,5],null,[["@textToCopy","@color"],[[30,3,["secretsEngine","accessor"]],"secondary"]],null],[1,"\\n        "]],[]]]]],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[4]]]]],[1,"\\n    "],[8,[39,6],[[24,3,"description"]],[["@value","@isInvalid"],[[30,3,["secretsEngine","description"]],[28,[37,7],[[30,3,["secretsEngine","description","length"]],500],null]]],[["default"],[[[[1,"\\n      "],[8,[30,5,["Label"]],null,null,[["default"],[[[[1,"Description"]],[]]]]],[1,"\\n      "],[8,[30,5,["HelperText"]],null,null,[["default"],[[[[1,"A short description of the secrets engine\'s purpose."]],[]]]]],[1,"\\n      "],[8,[30,5,["CharacterCount"]],null,[["@maxLength"],[500]],null],[1,"\\n"],[41,[28,[37,7],[[30,3,["secretsEngine","description","length"]],500],null],[[[1,"        "],[8,[30,5,["Error"]],null,null,[["default"],[[[[1,"Description exceeds character limit."]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[5]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]]]]]],["&attrs","F","@model","F","F"],false,["hds/card/container","hds/text/display","div","hds/form/fieldset","hds/layout/flex","hds/copy/snippet","hds/form/textarea/field","gt","if"]]',moduleName:"vault/components/secret-engine/card/metadata.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/secret-engine/card/secrets-duration",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"YQf7vr/C",block:'[[[8,[39,0],[[24,0,"has-padding-m has-top-bottom-margin"],[17,1]],[["@level","@hasBorder"],["mid",true]],[["default"],[[[[1,"\\n  "],[8,[39,1],[[24,0,"has-bottom-margin-s hds-foreground-strong"]],[["@size","@tag"],["300","h2"]],[["default"],[[[[1,"Secrets duration"]],[]]]]],[1,"\\n\\n  "],[8,[39,2],[[24,0,"has-bottom-margin-m"]],[["@align","@gap"],["start","16"]],[["default"],[[[[1,"\\n    "],[8,[39,2],null,[["@direction","@gap"],["column","4"]],[["default"],[[[[1,"\\n      "],[8,[39,3],null,[["@size","@tag"],["200","p"]],[["default"],[[[[1,"Time-to-live defines how long secrets issued by this engine remain valid before\\n        expiring."]],[]]]]],[1,"\\n      "],[8,[39,4],null,[["@icon","@iconPosition","@text","@href"],["external-link","trailing","TTL in Vault docs","https://developer.hashicorp.com/vault/docs/troubleshoot/tune-lease-ttl"]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n\\n  "],[8,[39,2],[[24,0,"has-top-padding-s has-bottom-padding-s"]],[["@direction","@gap","@isInline"],["column","24","true"]],[["default"],[[[[1,"\\n    "],[8,[39,5],null,[["@model","@initialUnit","@ttlKey"],[[30,2],[30,3],"default_lease_ttl"]],null],[1,"\\n    "],[8,[39,5],null,[["@model","@initialUnit","@ttlKey"],[[30,2],[30,4],"max_lease_ttl"]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]]]],["&attrs","@model","@defaultLeaseUnit","@maxLeaseUnit"],false,["hds/card/container","hds/text/display","hds/layout/flex","hds/text/body","hds/link/standalone","secret-engine/ttl-picker-v2"]]',moduleName:"vault/components/secret-engine/card/secrets-duration.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/secret-engine/card/security",["exports","@ember/component","@ember/object","@glimmer/component","@ember/template-factory"],(function(e,t,n,i,r){var l
function a(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,r.createTemplateFactory)({id:"rjWn8luo",block:'[[[8,[39,0],[[24,0,"has-padding-m has-top-bottom-margin"],[17,1]],[["@level","@hasBorder"],["mid",true]],[["default"],[[[[1,"\\n  "],[8,[39,1],null,null,[["default"],[[[[1,"\\n    "],[8,[30,2,["Legend"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],[[24,0,"has-bottom-margin-s hds-foreground-strong"]],[["@size","@tag"],["300","h2"]],[["default"],[[[[1,"Security"]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n"],[1,"    "],[8,[30,2,["ToggleField"]],[[24,3,"local"],[16,"checked",[30,3,["secretsEngine","local"]]],[24,"disabled",""]],null,[["default"],[[[[1,"\\n      "],[8,[30,4,["Label"]],null,null,[["default"],[[[[1,"Local"]],[]]]]],[1,"\\n      "],[8,[30,4,["HelperText"]],null,null,[["default"],[[[[1,"Secrets stay in one cluster and are not replicated."]],[]]]]],[1,"\\n    "]],[4]]]]],[1,"\\n    "],[8,[30,2,["ToggleField"]],[[24,3,"seal-wrap"],[16,"checked",[30,3,["secretsEngine","seal_wrap"]]],[24,"disabled",""]],null,[["default"],[[[[1,"\\n      "],[8,[30,5,["Label"]],null,null,[["default"],[[[[1,"Seal wrap"]],[]]]]],[1,"\\n      "],[8,[30,5,["HelperText"]],null,null,[["default"],[[[[1,"Wrap secrets with an additional encryption layer using a seal."]],[]]]]],[1,"\\n    "]],[5]]]]],[1,"\\n  "]],[2]]]]],[1,"\\n"]],[]]]]]],["&attrs","G","@model","F","F"],false,["hds/card/container","hds/form/toggle/group","hds/text/display"]]',moduleName:"vault/components/secret-engine/card/security.hbs",isStrictMode:!1})
let s=e.default=(a((l=class extends i.default{constructor(e,t){super(e,t)}toggleSealWrap(){this.args.model.seal_wrap=!this.args.model.seal_wrap}toggleLocal(){this.args.model.local=!this.args.model.local}}).prototype,"toggleSealWrap",[n.action],Object.getOwnPropertyDescriptor(l.prototype,"toggleSealWrap"),l.prototype),a(l.prototype,"toggleLocal",[n.action],Object.getOwnPropertyDescriptor(l.prototype,"toggleLocal"),l.prototype),l);(0,t.setComponentTemplate)(o,s)})),define("vault/components/secret-engine/card/version",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"BWs3xsAQ",block:'[[[8,[39,0],[[24,0,"has-padding-m has-top-bottom-margin"],[17,1]],[["@level","@hasBorder"],["mid",true]],[["default"],[[[[1,"\\n  "],[8,[39,1],[[24,0,"has-bottom-margin-s hds-foreground-strong"]],[["@size","@tag"],["300","h2"]],[["default"],[[[[1,"Version"]],[]]]]],[1,"\\n\\n  "],[8,[39,2],[[4,[38,3],null,[["height","grid-template-rows"],["100%","min-content"]]]],[["@columnMinWidth","@gap"],["10%","12"]],[["default"],[[[[1,"\\n    "],[8,[30,2,["Item"]],null,[["@colspan"],[2]],[["default"],[[[[1,"\\n      "],[8,[39,4],[[24,0,"hds-font-weight-semibold has-bottom-margin-s hds-foreground-strong"]],[["@tag"],["h3"]],[["default"],[[[[1,"Engine type"]],[]]]]],[1,"\\n      "],[8,[39,4],[[24,0,"hds-font-weight-semibold has-bottom-margin-s hds-foreground-strong"]],[["@tag"],["h3"]],[["default"],[[[[1,"Current version"]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n\\n    "],[8,[30,2,["Item"]],null,[["@colspan"],[3]],[["default"],[[[[1,"\\n      "],[8,[39,4],[[24,0,"hds-border-strong has-side-padding-8 border-radius-4 is-inline-block has-bottom-margin-s"]],[["@tag"],["p"]],[["default"],[[[[1,[30,3,["secretsEngine","type"]]]],[]]]]],[1,"\\n"],[1,"      "],[8,[39,4],null,[["@tag"],["p"]],[["default"],[[[[1,[30,3,["secretsEngine","running_plugin_version"]]]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[2]]]]],[1,"\\n\\n"],[41,[28,[37,6],[[30,3,["versions","length"]],1],null],[[[1,"    "],[8,[39,7],null,null,null],[1,"\\n\\n    "],[8,[39,8],null,[["@isInline"],["true"]],[["default"],[[[[1,"\\n      "],[8,[39,9],[[24,3,"plugin-version"]],null,[["default"],[[[[1,"\\n        "],[8,[30,4,["Label"]],null,null,[["default"],[[[[1,"Update version to:"]],[]]]]],[1,"\\n        "],[8,[30,4,["Options"]],null,null,[["default"],[[[[1,"\\n          "],[10,"option"],[14,2,""],[12],[1,"Select version"],[13],[1,"\\n"],[42,[28,[37,12],[[28,[37,12],[[30,3,["versions"]]],null]],null],null,[[[1,"            "],[10,"option"],[15,2,[30,5]],[12],[1,[30,5]],[13],[1,"\\n"]],[5]],null],[1,"        "]],[]]]]],[1,"\\n      "]],[4]]]]],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]],null]],[]]]]]],["&attrs","LG","@model","F","version"],false,["hds/card/container","hds/text/display","hds/layout/grid","style","hds/text/body","if","gt","hds/separator","hds/layout/flex","hds/form/select/field","option","each","-track-array"]]',moduleName:"vault/components/secret-engine/card/version.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/secret-engine/configuration-details",["exports","@ember/component","@glimmer/component","core/helpers/to-label","@ember/template-factory"],(function(e,t,n,i,r){function l(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const a=(0,r.createTemplateFactory)({id:"ow+Eu93p",block:'[[[1,"\\n"],[41,[30,1],[[[42,[28,[37,2],[[28,[37,2],[[30,0,["displayFields"]]],null]],null],null,[[[41,[28,[37,3],[[30,2],"public_key"],null],[[[1,"      "],[8,[39,4],null,[["@label","@value"],["Public key",[30,1,["public_key"]]]],[["default"],[[[[1,"\\n        "],[8,[39,5],null,[["@value","@name","@displayOnly","@allowCopy"],[[30,1,["public_key"]],[30,2],true,true]],null],[1,"\\n      "]],[]]]]],[1,"\\n"]],[]],[[[1,"      "],[8,[39,4],null,[["@alwaysRender","@label","@value","@formatTtl"],[[28,[37,6],[[28,[37,7],[[28,[37,8],[[30,1],[30,2]],null]],null]],null],[28,[30,0,["label"]],[[30,2]],null],[28,[37,8],[[30,1],[30,2]],null],[28,[30,0,["isDuration"]],[[30,2]],null]]],null],[1,"\\n"]],[]]]],[2]],null]],[]],[[[1,"  "],[8,[39,9],null,[["@title","@message"],[[29,[[30,3]," not configured"]],[29,["Get started by configuring your ",[30,3]," secrets engine."]]]],[["default"],[[[[1,"\\n    "],[8,[39,10],null,[["@icon","@iconPosition","@text","@route","@model"],["chevron-right","trailing",[29,["Configure ",[30,3]]],"vault.cluster.secrets.backend.configuration.edit",[30,4]]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]]]],["@config","field","@typeDisplay","@id"],false,["if","each","-track-array","eq","info-table-row","masked-input","not","is-empty-value","get","empty-state","hds/link/standalone"]]',moduleName:"vault/components/secret-engine/configuration-details.hbs",isStrictMode:!1})
class o extends n.default{constructor(...e){super(...e),l(this,"awsFields",["role_arn","identity_token_audience","identity_token_ttl","access_key","region","iam_endpoint","sts_endpoint","max_retries","lease","lease_max","issuer"]),l(this,"azureFields",["subscription_id","tenant_id","client_id","identity_token_audience","identity_token_ttl","root_password_ttl","environment","issuer"]),l(this,"gcpFields",["service_account_email","ttl","max_ttl","identity_token_audience","identity_token_ttl","issuer"]),l(this,"sshFields",["public_key","generate_signing_key"]),l(this,"label",(e=>{const t=(0,i.toLabel)([e]).split(" ").map((e=>["id","ttl","arn","iam","sts"].includes(e.toLowerCase())?e.toUpperCase():e)).join(" ")
return{lease:"Default Lease TTL",lease_max:"Max Lease TTL",ttl:"Config TTL"}[e]||t})),l(this,"isDuration",(e=>["identity_token_ttl","root_password_ttl","lease","lease_max","ttl","max_ttl"].includes(e)))}get displayFields(){switch(this.args.typeDisplay){case"AWS":return this.awsFields
case"Azure":return this.azureFields
case"Google Cloud":return this.gcpFields
case"SSH":return this.sshFields
default:return[]}}}e.default=o,(0,t.setComponentTemplate)(a,o)})),define("vault/components/secret-engine/configure-ssh",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@glimmer/component","@ember/object","ember-concurrency","@ember/test-waiters","@ember/service","@glimmer/tracking","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f,m,h,b
function y(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function g(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function v(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const w=(0,u.createTemplateFactory)({id:"5DsXwQh2",block:'[[[1,"\\n"],[11,"form"],[24,"aria-label","save ssh creds"],[24,0,"has-top-padding-m"],[4,[38,1],["submit",[28,[37,2],[[30,0,["save"]]],null]],null],[12],[1,"\\n  "],[8,[39,3],null,[["@mode","@noun"],["save","configuration"]],null],[1,"\\n  "],[8,[39,4],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n"],[41,[30,1,["isNew"]],[[[42,[28,[37,7],[[28,[37,7],[[30,1,["formFields"]]],null]],null],null,[[[1,"      "],[8,[39,8],null,[["@attr","@model","@modelValidations"],[[30,2],[30,1],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[2]],null],[1,"    "],[10,"hr"],[14,0,"has-background-gray-300"],[12],[13],[1,"\\n    "],[8,[39,10],null,null,[["default"],[[[[1,"\\n      "],[8,[39,11],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Save",[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n      "],[8,[39,11],[[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,1],["click",[30,0,["onCancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n    "]],[]]]]],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"      "],[8,[39,12],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n"]],[]],null]],[]],[[[1,"    "],[10,2],[14,0,"has-text-grey-dark has-top-bottom-margin"],[12],[1,"\\n      NOTE: You must delete your existing certificate and key before saving new values.\\n    "],[13],[1,"\\n\\n    "],[10,0],[14,0,"box is-fullwidth is-sideless"],[12],[1,"\\n      "],[10,"label"],[14,"for","publicKey"],[14,0,"is-label"],[12],[1,"\\n        Public key\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"control"],[12],[1,"\\n        "],[8,[39,16],null,[["@name","@id","@value","@displayOnly","@allowCopy"],["publicKey","publicKey",[30,1,["public_key"]],true,true]],null],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n    "],[8,[39,10],null,null,[["default"],[[[[1,"\\n      "],[8,[39,17],[[24,0,"primary"]],[["@text","@textToCopy","@onError"],["Copy",[30,1,["public_key"]],[28,[37,18],[[28,[37,19],["Clipboard copy failed. The Clipboard API requires a secure context.","danger"],null]],null]]],null],[1,"\\n      "],[8,[39,20],null,[["@buttonText","@buttonColor","@confirmMessage","@onConfirmAction"],["Delete","secondary","Confirming will remove the CA certificate information.",[30,0,["deleteCaConfig"]]]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]],[13]],["@configForm","attr"],false,["form","on","perform","namespace-reminder","message-error","if","each","-track-array","form-field","hr","hds/button-set","hds/button","alert-inline","p","div","label","masked-input","hds/copy/button","fn","set-flash-message","confirm-action"]]',moduleName:"vault/components/secret-engine/configure-ssh.hbs",isStrictMode:!1})
let k=e.default=(c=class extends i.default{constructor(...e){super(...e),y(this,"router",d,this),y(this,"api",p,this),y(this,"flashMessages",f,this),y(this,"errorMessage",m,this),y(this,"invalidFormAlert",h,this),y(this,"modelValidations",b,this),g(this,"save",(0,n.buildTask)((()=>({context:this,generator:(0,a.waitFor)((function*(e){e.preventDefault(),this.resetErrors()
const{id:t,configForm:n}=this.args,{isValid:i,state:r,invalidFormMessage:l,data:a}=n.toJSON()
if(this.modelValidations=i?null:r,this.invalidFormAlert=i?"":l,i)try{yield this.api.secrets.sshConfigureCa(t,a),this.flashMessages.success(`Successfully saved ${t}'s root configuration.`),this.transition()}catch(o){const{message:e}=yield this.api.parseError(o)
this.errorMessage=e,this.invalidFormAlert="There was an error submitting this form."}}))})),null,"save",null))}resetErrors(){this.flashMessages.clearMessages(),this.errorMessage=null,this.invalidFormAlert=null}transition(e=!1){const{id:t}=this.args
e?this.router.transitionTo("vault.cluster.secrets.backend.configuration.edit",t):this.router.transitionTo("vault.cluster.secrets.backend.configuration",t)}onCancel(){this.resetErrors(),this.transition()}async deleteCaConfig(){try{await this.api.secrets.sshDeleteCaConfiguration(this.args.id),this.flashMessages.success("CA information deleted successfully."),this.transition(!0)}catch(e){const{message:t}=await this.api.parseError(e)
this.flashMessages.danger(t)}}},d=v(c.prototype,"router",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=v(c.prototype,"api",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=v(c.prototype,"flashMessages",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=v(c.prototype,"errorMessage",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h=v(c.prototype,"invalidFormAlert",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b=v(c.prototype,"modelValidations",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),v(c.prototype,"onCancel",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"onCancel"),c.prototype),v(c.prototype,"deleteCaConfig",[r.action],Object.getOwnPropertyDescriptor(c.prototype,"deleteCaConfig"),c.prototype),c);(0,t.setComponentTemplate)(w,k)})),define("vault/components/secret-engine/configure-wif",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@glimmer/component","@ember/object","ember-concurrency","@ember/test-waiters","@ember/service","@glimmer/tracking","@ember/debug","@ember/runloop","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u,c,d){var p,f,m,h,b,y,g,v,w
function k(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function x(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function P(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const _=(0,d.createTemplateFactory)({id:"BEVimg7I",block:'[[[1,"\\n"],[11,"form"],[16,"aria-label",[29,["configure ",[30,1]," credentials"]]],[4,[38,1],["submit",[28,[37,2],[[30,0,["submitForm"]]],null]],null],[12],[1,"\\n  "],[8,[39,3],null,[["@mode","@noun"],["save","configuration"]],null],[1,"\\n  "],[8,[39,4],null,[["@errorMessage"],[[30,0,["errorMessage"]]]],null],[1,"\\n"],[41,[28,[37,6],[[30,1],"aws"],null],[[[1,"    "],[10,2],[14,0,"has-text-grey-dark has-top-bottom-margin"],[12],[1,"\\n      Note: the client uses the official AWS SDK and will use the specified credentials, environment credentials, shared file\\n      credentials, or IAM role/ECS task credentials in that order.\\n    "],[13],[1,"\\n    "],[10,"h2"],[14,0,"title is-5 has-bottom-padding-s has-top-margin-l"],[12],[1,"\\n      Access to AWS\\n    "],[13],[1,"\\n"]],[]],null],[1,"  "],[10,0],[14,0,"box is-fullwidth is-sideless"],[12],[1,"\\n"],[41,[30,0,["version","isEnterprise"]],[[[1,"      "],[10,"fieldset"],[14,0,"field form-fieldset"],[14,1,"protection"],[12],[1,"\\n        "],[10,"legend"],[14,0,"is-label"],[12],[1,"Access Type"],[13],[1,"\\n        "],[10,2],[14,0,"sub-text"],[12],[1,"\\n"],[41,[30,0,["disableAccessType"]],[[[1,"            You cannot edit Access Type if you have already saved access credentials.\\n"]],[]],[[[1,"            Choose the way to configure access to\\n            "],[1,[30,2]],[1,". Access can be configured either using\\n            "],[1,[52,[28,[37,6],[[30,1],"aws"],null],"IAM access keys",[28,[37,12],[[30,2]," account credentials"],null]]],[1,"\\n            or with the Plugin Workload Identity Federation (WIF).\\n"]],[]]],[1,"        "],[13],[1,"\\n        "],[10,0],[12],[1,"\\n          "],[8,[39,13],[[16,1,[29,["access-type-",[30,1]]]],[24,3,"account"],[24,0,"radio"]],[["@value","@groupValue","@onChange","@disabled"],["account",[30,3,["accessType"]],[30,0,["onChangeAccessType"]],[30,0,["disableAccessType"]]]],null],[1,"\\n          "],[10,"label"],[15,"for",[29,["access-type-",[30,1]]]],[12],[1,[30,2]],[1," account credentials"],[13],[1,"\\n          "],[8,[39,13],[[24,1,"access-type-wif"],[24,3,"wif"],[24,0,"radio has-left-margin-m"]],[["@value","@groupValue","@onChange","@disabled"],["wif",[30,3,["accessType"]],[30,0,["onChangeAccessType"]],[30,0,["disableAccessType"]]]],null],[1,"\\n          "],[10,"label"],[14,"for","access-type-wif"],[12],[1,"Workload Identity Federation"],[13],[1,"\\n        "],[13],[1,"\\n      "],[13],[1,"\\n"]],[]],null],[1,"\\n    "],[8,[39,15],null,[["@model","@mode","@useEnableInput","@groupName"],[[30,3],[52,[30,3,["isNew"]],"create","edit"],true,"formFieldGroups"]],null],[1,"\\n"],[41,[30,3,["formFields"]],[[[1,"      "],[10,"h2"],[14,0,"title is-5 has-bottom-padding-s has-top-margin-l"],[12],[1,"\\n        "],[1,[52,[28,[37,6],[[30,1],"aws"],null],"Lease","Additional"]],[1,"\\n        Configuration\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"box is-fullwidth is-sideless is-bottomless"],[12],[1,"\\n"],[42,[28,[37,17],[[28,[37,17],[[30,3,["formFields"]]],null]],null],null,[[[1,"          "],[8,[39,18],null,[["@attr","@model","@modelValidations"],[[30,4],[30,3],[30,0,["modelValidations"]]]],null],[1,"\\n"]],[4]],null],[1,"      "],[13],[1,"\\n"]],[]],null],[1,"  "],[13],[1,"\\n\\n  "],[8,[39,19],null,null,[["default"],[[[[1,"\\n    "],[8,[39,20],[[16,"disabled",[30,0,["save","isRunning"]]],[24,4,"submit"]],[["@text","@icon"],["Save",[52,[30,0,["save","isRunning"]],"loading"]]],null],[1,"\\n    "],[8,[39,20],[[24,0,"has-left-margin-s"],[16,"disabled",[30,0,["save","isRunning"]]],[4,[38,1],["click",[30,0,["onCancel"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n  "]],[]]]]],[1,"\\n"],[41,[30,0,["invalidFormAlert"]],[[[1,"    "],[8,[39,21],[[24,0,"has-top-padding-s"]],[["@type","@message"],["danger",[30,0,["invalidFormAlert"]]]],null],[1,"\\n"]],[]],null],[13],[1,"\\n\\n"],[41,[30,0,["saveIssuerWarning"]],[[[1,"  "],[8,[39,22],null,[["@color","@onClose"],["warning",[28,[37,23],[[30,0],[28,[37,24],[[30,0,["saveIssuerWarning"]]],null],""],null]]],[["default"],[[[[1,"\\n    "],[8,[30,5,["Header"]],null,[["@icon"],["alert-circle"]],[["default"],[[[[1,"\\n      Are you sure?\\n    "]],[]]]]],[1,"\\n    "],[8,[30,5,["Body"]],null,null,[["default"],[[[[1,"\\n      "],[10,2],[14,0,"has-bottom-margin-s"],[12],[1,"\\n        "],[1,[30,0,["saveIssuerWarning"]]],[1,"\\n      "],[13],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,5,["Footer"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,19],null,null,[["default"],[[[[1,"\\n        "],[8,[39,20],[[4,[38,1],["click",[30,0,["continueSubmitForm"]]],null]],[["@text"],["Continue"]],null],[1,"\\n        "],[8,[39,20],[[4,[38,1],["click",[30,6,["close"]]],null]],[["@text","@color"],["Cancel","secondary"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[6]]]]],[1,"\\n  "]],[5]]]]],[1,"\\n"]],[]],null]],["@type","@displayName","@configForm","field","M","F"],false,["form","on","perform","namespace-reminder","message-error","if","eq","p","h2","div","fieldset","legend","concat","radio-button","label","form-field-groups","each","-track-array","form-field","hds/button-set","hds/button","alert-inline","hds/modal","action","mut"]]',moduleName:"vault/components/secret-engine/configure-wif.hbs",isStrictMode:!1})
let T=e.default=(p=class extends i.default{constructor(e,t){super(e,t),k(this,"router",f,this),k(this,"api",m,this),k(this,"version",h,this),k(this,"flashMessages",b,this),k(this,"errorMessage",y,this),k(this,"invalidFormAlert",g,this),k(this,"saveIssuerWarning",v,this),k(this,"modelValidations",w,this),x(this,"disableAccessType",!1),x(this,"originalIssuer",void 0),x(this,"submitForm",(0,n.buildTask)((()=>({context:this,generator:(0,a.waitFor)((function*(e){e?.preventDefault(),this.resetErrors()
const{isValid:t,state:n,invalidFormMessage:i,data:r}=this.args.configForm.toJSON()
if(!t)return this.modelValidations=t?null:n,void(this.invalidFormAlert=t?"":i)
this.originalIssuer===r.issuer?yield this.save.perform():this.saveIssuerWarning=`You are updating the global issuer config. This will overwrite Vault's current issuer ${this.originalIssuer?"":"if it exists "}and may affect other configurations using this value. Continue?`}))})),null,"submitForm",null)),x(this,"save",(0,n.buildTask)((()=>({context:this,generator:(0,a.waitFor)((function*(){try{const{data:e}=this.args.configForm.toJSON(),{issuer:t}=e
yield this.saveConfig(e),this.originalIssuer!==t&&(yield this.updateIssuer(t)),this.flashMessages.success(`Successfully saved ${this.args.backendPath}'s configuration.`),this.transition()}catch(e){const{message:t}=yield this.api.parseError(e)
this.errorMessage=t,this.invalidFormAlert="There was an error submitting this form."}}))})),null,"save",null))
const{isNew:i,data:r,isWifPluginConfigured:l,isAccountPluginConfigured:o}=this.args.configForm
this.version.isEnterprise&&!i&&((0,c.next)((()=>{this.args.configForm.accessType=l?"wif":"account"})),this.disableAccessType=l||o),this.originalIssuer=r.issuer}continueSubmitForm(){this.saveIssuerWarning="",this.save.perform()}async updateIssuer(e){try{await this.api.identity.oidcConfigure({issuer:e})}catch(t){const{message:e}=await this.api.parseError(t,"Check Vault logs for details.")
this.flashMessages.danger(`Issuer was not saved: ${e}`)}}async saveConfig(e){const{backendPath:t,type:n}=this.args
if("aws"===n){await this.api.secrets.awsConfigureRootIamCredentials(t,e)
try{const{lease:n,lease_max:i}=e
await this.api.secrets.awsConfigureLease(t,{lease:n,lease_max:i})}catch(i){const{message:e}=await this.api.parseError(i)
this.flashMessages.danger(`Error saving lease configuration: ${e}`)}}else"azure"===n?await this.api.secrets.azureConfigure(t,e):"gcp"===n&&await this.api.secrets.googleCloudConfigure(t,e)}resetErrors(){this.flashMessages.clearMessages(),this.errorMessage=this.invalidFormAlert="",this.modelValidations=null}transition(){this.router.transitionTo("vault.cluster.secrets.backend.configuration",this.args.backendPath)}onChangeAccessType(e){const{configForm:t,type:n}=this.args
t.accessType=e,"account"===e?t.data.identity_token_audience=t.data.identity_token_ttl=void 0:"wif"===e&&("azure"===n?t.data.client_secret=void 0:"aws"===n&&(t.data.access_key=void 0))}onCancel(){this.resetErrors(),this.transition()}},f=P(p.prototype,"router",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=P(p.prototype,"api",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=P(p.prototype,"version",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),b=P(p.prototype,"flashMessages",[o.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),y=P(p.prototype,"errorMessage",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),g=P(p.prototype,"invalidFormAlert",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),v=P(p.prototype,"saveIssuerWarning",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),w=P(p.prototype,"modelValidations",[s.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),P(p.prototype,"continueSubmitForm",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"continueSubmitForm"),p.prototype),P(p.prototype,"onChangeAccessType",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"onChangeAccessType"),p.prototype),P(p.prototype,"onCancel",[r.action],Object.getOwnPropertyDescriptor(p.prototype,"onCancel"),p.prototype),p);(0,t.setComponentTemplate)(_,T)})),define("vault/components/secret-engine/list",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","ember-concurrency","vault/helpers/engines-display-data","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d,p,f,m,h,b,y,g,v,w,k,x
function P(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function _(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function T(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const O=(0,s.createTemplateFactory)({id:"Wvn1WfPK",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"page-header"]],null,[["default"],[[[[1,"\\n  "],[8,[30,1,["Breadcrumb"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@text","@route","@icon"],["Vault","vault.cluster.dashboard","vault"]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@current"],["Secrets engines",true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n  "],[8,[30,1,["IconTile"]],null,[["@icon"],["key"]],null],[1,"\\n\\n  "],[8,[30,1,["Title"]],null,null,[["default"],[[[[1,"Secrets engines"]],[]]]]],[1,"\\n  "],[8,[30,1,["Subtitle"]],null,null,[["default"],[[[[1,"Secrets engines available in "],[1,[30,0,["clusterName"]]],[1," Vault cluster."]],[]]]]],[1,"\\n\\n  "],[8,[30,1,["Actions"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,3],null,[["@text","@icon","@route"],["Enable new engine","plus","vault.cluster.secrets.mounts"]],null],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[8,[39,4],[[24,0,"has-top-margin-m"]],null,[["default"],[[[[1,"\\n  "],[8,[30,2,["TextInput"]],[[24,"placeholder","Search by path"],[24,"aria-label","Search"],[4,[38,5],["input",[28,[37,6],[[30,0,["setSearchText"]],"path"],null]],null]],[["@width","@type"],["300px","search"]],null],[1,"\\n  "],[8,[30,2,["Dropdown"]],null,[["@width"],["175px"]],[["default"],[[[[1,"\\n    "],[8,[30,3,["Header"]],null,[["@hasDivider"],[true]],[["default"],[[[[1,"\\n      "],[8,[30,2,["TextInput"]],[[24,"placeholder","Search"],[24,"aria-label","Search"],[4,[38,5],["input",[28,[37,6],[[30,0,["setSearchText"]],"type"],null]],null]],[["@type"],["search"]],null],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,3,["ToggleButton"]],null,[["@color","@text"],["secondary","Engine type"]],null],[1,"\\n"],[42,[28,[37,8],[[28,[37,8],[[30,0,["secretEngineArrayByType"]]],null]],null],null,[[[1,"      "],[8,[30,3,["Checkbox"]],[[16,2,[30,4,["name"]]],[16,"checked",[28,[37,9],[[30,4,["name"]],[30,0,["engineTypeFilters"]]],null]],[4,[38,5],["click",[28,[37,6],[[30,0,["filterByEngineType"]],[30,4,["name"]]],null]],null]],null,[["default"],[[[[8,[39,10],null,[["@name","@isInline"],[[30,4,["icon"]],true]],null],[1," "],[1,[30,4,["name"]]]],[]]]]],[1,"\\n"]],[4]],null],[1,"  "]],[3]]]]],[1,"\\n  "],[8,[30,2,["Dropdown"]],null,[["@width"],["250px"]],[["default"],[[[[1,"\\n    "],[8,[30,5,["ToggleButton"]],null,[["@color","@text"],["secondary","Version"]],null],[1,"\\n"],[41,[30,0,["engineTypeFilters","length"]],[[[1,"      "],[8,[30,5,["Header"]],null,[["@hasDivider"],[true]],[["default"],[[[[1,"\\n        "],[8,[30,2,["TextInput"]],[[24,"placeholder","Search"],[24,"aria-label","Search"],[4,[38,5],["input",[28,[37,6],[[30,0,["setSearchText"]],"version"],null]],null]],[["@type"],["search"]],null],[1,"\\n      "]],[]]]]],[1,"\\n"],[42,[28,[37,8],[[28,[37,8],[[30,0,["secretEngineArrayByVersions"]]],null]],null],null,[[[1,"        "],[8,[30,5,["Checkbox"]],[[16,2,[30,6,["version"]]],[16,"checked",[28,[37,9],[[30,6,["version"]],[30,0,["engineVersionFilters"]]],null]],[4,[38,5],["click",[28,[37,6],[[30,0,["filterByEngineVersion"]],[30,6,["version"]]],null]],null]],null,[["default"],[[[[1,"\\n          "],[1,[30,6,["version"]]],[1,"\\n        "]],[]]]]],[1,"\\n"]],[6]],null]],[]],[[[1,"      "],[8,[30,5,["Description"]],[[24,0,"has-top-padding-s"]],[["@text"],["Select an engine type first to filter by versions."]],null],[1,"\\n"]],[]]],[1,"  "]],[5]]]]],[1,"\\n"]],[2]]]]],[1,"\\n\\n"],[8,[39,12],[[24,0,"has-top-margin-xs has-bottom-margin-xs"]],[["@gap","@align"],["8","center"]],[["default"],[[[[1,"\\n"],[41,[28,[37,13],[[28,[37,14],[[30,0,["engineTypeFilters"]]],null],[28,[37,14],[[30,0,["engineVersionFilters"]]],null]],null],[[[1,"    "],[8,[39,15],[[24,0,"has-top-padding-xs"]],null,[["default"],[[[[1,"No filters applied."]],[]]]]],[1,"\\n"]],[]],[[[1,"    "],[8,[39,15],null,null,[["default"],[[[[1,"Filters applied:"]],[]]]]],[1,"\\n"],[42,[28,[37,8],[[28,[37,8],[[30,0,["engineTypeFilters"]]],null]],null],null,[[[1,"      "],[8,[39,16],null,[["@text","@onDismiss"],[[30,7],[28,[37,6],[[30,0,["filterByEngineType"]],[30,7]],null]]],null],[1,"\\n"]],[7]],null],[42,[28,[37,8],[[28,[37,8],[[30,0,["engineVersionFilters"]]],null]],null],null,[[[1,"      "],[8,[39,16],null,[["@text","@onDismiss"],[[30,8],[28,[37,6],[[30,0,["filterByEngineVersion"]],[30,8]],null]]],null],[1,"\\n"]],[8]],null],[1,"    "],[8,[39,3],[[4,[38,5],["click",[30,0,["clearAllFilters"]]],null]],[["@text","@color","@icon","@size"],["Clear all","tertiary","x","small"]],null],[1,"\\n"]],[]]]],[]]]]],[1,"\\n"],[1,"\\n"],[41,[30,0,["sortedDisplayableBackends"]],[[[1,"  "],[8,[39,17],[[24,0,"has-top-margin-xs"]],[["@columns","@selectionKey","@data","@onSelectionChange"],[[30,0,["tableColumns"]],"path",[30,0,["sortedDisplayableBackends"]],[30,0,["updateSelectedItems"]]]],[["selectedItems","customTableItem","popupMenu"],[[[[1,"\\n"],[41,[30,0,["selectedItems"]],[[[1,"        "],[8,[39,12],[[24,0,"has-bottom-margin-s has-top-margin-negative-xxl"]],[["@gap","@direction","@justify","@align","@isInline"],["8","row","end","center","true"]],[["default"],[[[[1,"\\n          "],[8,[39,15],[[24,"role","status"]],[["@tag","@size","@color"],["p","200","foreground-primary"]],[["default"],[[[[1,"\\n            "],[1,[30,0,["selectedItems","length"]]],[1,"\\n            selected out of\\n            "],[1,[30,0,["sortedDisplayableBackends","length"]]],[1,"\\n          "]],[]]]]],[1,"\\n          "],[8,[39,3],[[4,[38,5],["click",[28,[37,6],[[28,[37,19],[[30,0,["enginesToDisable"]]],null],[30,0,["selectedItems"]]],null]],null]],[["@text","@color","@icon"],["Disable engines","critical","trash"]],null],[1,"\\n        "]],[]]]]],[1,"\\n"]],[]],null],[1,"    "]],[]],[[[1,"\\n"],[44,[[28,[30,0,["getEngineResourceData"]],[[30,9,["path"]]],null]],[[[1,"        "],[8,[39,22],[[24,"aria-label","Type of backend"],[16,"isInline",true],[24,0,"is-v-centered"]],[["@text"],[[28,[30,0,["generateToolTipText"]],[[30,10]],null]]],[["default"],[[[[1,"\\n          "],[8,[39,10],null,[["@name"],[[52,[30,10,["icon"]],[30,10,["icon"]],"lock"]]],null],[1,"\\n        "]],[]]]]],[1,"\\n"],[41,[30,10,["isSupportedBackend"]],[[[1,"          "],[8,[39,23],[[24,0,"has-text-weight-semibold"]],[["@route","@model","@color"],[[30,10,["backendLink"]],[30,10,["id"]],"secondary"]],[["default"],[[[[1,[30,10,["path"]]]],[]]]]],[1,"\\n"]],[]],[[[1,"          "],[1,[30,10,["path"]]],[1,"\\n"]],[]]]],[10]]],[1,"    "]],[9]],[[[1,"\\n"],[44,[[28,[30,0,["getEngineResourceData"]],[[30,11,["path"]]],null]],[[[1,"        "],[8,[39,25],null,[["@isInline"],[true]],[["default"],[[[[1,"\\n          "],[8,[30,13,["ToggleIcon"]],null,[["@icon","@text","@hasChevron"],["more-horizontal",[29,[[52,[30,12,["isSupportedBackend"]],"supported","unsupported"]," secrets engine menu"]],false]],null],[1,"\\n          "],[8,[30,13,["Interactive"]],null,[["@route","@model","@icon"],[[30,12,["backendConfigurationLink"]],[30,12,["id"]],"settings"]],[["default"],[[[[1,"View configuration"]],[]]]]],[1,"\\n"],[41,[28,[37,26],[[30,12,["type"]],"cubbyhole"],null],[[[1,"            "],[8,[30,13,["Interactive"]],[[4,[38,5],["click",[28,[37,6],[[28,[37,19],[[30,0,["engineToDisable"]]],null],[30,12]],null]],null]],[["@color","@icon"],["critical","trash"]],[["default"],[[[[1,"Disable"]],[]]]]],[1,"\\n"]],[]],null],[1,"        "]],[13]]]]],[1,"\\n"]],[12]]],[1,"    "]],[11]]]]],[1,"\\n"]],[]],[[[1,"  "],[8,[39,27],null,[["@title"],["No Secrets engines found"]],null],[1,"\\n"]],[]]],[1,"\\n"],[41,[30,0,["engineToDisable"]],[[[1,"  "],[8,[39,28],null,[["@color","@confirmMessage","@confirmTitle","@onClose","@onConfirm"],["critical","Any data in this engine will be permanently deleted.","Disable engine?",[28,[37,6],[[28,[37,19],[[30,0,["engineToDisable"]]],null],null],null],[28,[37,29],[[30,0,["disableEngine"]],[30,0,["engineToDisable"]]],null]]],null],[1,"\\n"]],[]],null],[1,"\\n"],[41,[30,0,["enginesToDisable"]],[[[1,"  "],[8,[39,28],null,[["@color","@confirmMessage","@confirmTitle","@onClose","@onConfirm"],["critical","Any data in these engines will be permanently deleted.","Disable engines?",[28,[37,6],[[28,[37,19],[[30,0,["enginesToDisable"]]],null],null],null],[28,[37,29],[[30,0,["disableMultipleEngines"]],[30,0,["enginesToDisable"]]],null]]],null],[1,"\\n"]],[]],null]],["PH","SG","D","type","D","backend","type","version","itemData","backendData","rowData","backendData","dd"],false,["hds/page-header","hds/breadcrumb","hds/breadcrumb/item","hds/button","hds/segmented-group","on","fn","each","-track-array","includes","hds/icon","if","hds/layout/flex","and","not","hds/text/body","hds/tag","list-table",":selectedItems","mut",":customTableItem","let","hds/tooltip-button","hds/link/inline",":popupMenu","hds/dropdown","not-eq","empty-state","confirm-modal","perform"]]',moduleName:"vault/components/secret-engine/list.hbs",isStrictMode:!1})
let j=e.default=(u=class extends n.default{constructor(...e){super(...e),P(this,"flashMessages",c,this),P(this,"api",d,this),P(this,"router",p,this),P(this,"version",f,this),P(this,"secretEngineOptions",m,this),P(this,"engineToDisable",h,this),P(this,"enginesToDisable",b,this),P(this,"engineTypeFilters",y,this),P(this,"engineVersionFilters",g,this),P(this,"searchText",v,this),P(this,"typeSearchText",w,this),P(this,"versionSearchText",k,this),P(this,"selectedItems",x,this),_(this,"tableColumns",[{key:"path",label:"Engine path",isSortable:!0,width:"250px",customTableItem:!0},{key:"accessor",label:"Accessor",width:"150px"},{key:"description",label:"Description",width:"300px"},{key:"running_plugin_version",label:"Version",isSortable:!0,width:"170px"},{key:"popupMenu",label:"Action",width:"75px"}]),_(this,"getEngineResourceData",(e=>this.displayableBackends.find((t=>t.path===e)))),_(this,"generateToolTipText",(e=>{const t=(0,o.default)(e.type)
return t?e.isSupportedBackend?"kv"===e.type?`${t.displayName} version ${e.version}`:`${t.displayName}`:"unknown"===t.type?"This engine's type is not recognized by the UI. Please use the CLI to manage this engine.":"The UI only supports configuration views for these secret engines. The CLI must be used to manage other engine resources.":void 0}))}get clusterName(){return this.version.clusterName}get displayableBackends(){return this.args.secretEngines.filter((e=>e.shouldIncludeInList))}get sortedDisplayableBackends(){let e=this.displayableBackends.slice().sort(((e,t)=>Number(t.isSupportedBackend)-Number(e.isSupportedBackend)||e.id.localeCompare(t.id)))
return this.engineTypeFilters.length>0&&(e=e.filter((e=>this.engineTypeFilters.includes(e.engineType)))),this.engineVersionFilters.length>0&&(e=e.filter((e=>this.engineVersionFilters.includes(e.running_plugin_version)))),""!==this.searchText.trim()&&(e=e.filter((e=>e.path.toLowerCase().includes(this.searchText.toLowerCase())))),e}get typeFilterOptions(){return""!==this.typeSearchText.trim()?this.displayableBackends.filter((e=>e.engineType.toLowerCase().includes(this.typeSearchText.toLowerCase()))):this.displayableBackends}get versionFilterOptions(){return""!==this.versionSearchText.trim()?this.sortedDisplayableBackends.filter((e=>e.running_plugin_version.toLowerCase().includes(this.versionSearchText.toLowerCase()))):this.sortedDisplayableBackends}get secretEngineArrayByType(){const e=this.typeFilterOptions.map((e=>e.engineType))
return[...new Set(e)].map((e=>({name:e,id:e,icon:(0,o.default)(e)?.glyph??"lock"})))}get secretEngineArrayByVersions(){const e=this.versionFilterOptions.map((e=>e.running_plugin_version))
return[...new Set(e)].map((e=>({version:e,id:e})))}setSearchText(e,t){const n=t.target
"type"===e?this.typeSearchText=n.value:"version"===e?this.versionSearchText=n.value:this.searchText=n.value}filterByEngineType(e){this.engineTypeFilters.includes(e)?this.engineTypeFilters=this.engineTypeFilters.filter((t=>t!==e)):this.engineTypeFilters=[...this.engineTypeFilters,e]}filterByEngineVersion(e){this.engineVersionFilters.includes(e)?this.engineVersionFilters=this.engineVersionFilters.filter((t=>t!==e)):this.engineVersionFilters=[...this.engineVersionFilters,e]}clearAllFilters(){this.engineTypeFilters=[],this.engineVersionFilters=[]}updateSelectedItems(e){this.selectedItems=e.selectedRowsKeys}async disableSingleEngine(e){const{engineType:t,id:n,path:i}=e
try{await this.api.sys.mountsDisableSecretsEngine(n),this.flashMessages.success(`The ${t} Secrets Engine at ${i} has been disabled.`)}catch(r){const{message:e}=await this.api.parseError(r)
this.flashMessages.danger(`There was an error disabling the ${t} Secrets Engine at ${i}: ${e}.`)}}*disableMultipleEngines(e){const t=this.displayableBackends.filter((t=>e.includes(t.path)))
try{for(const e of t)yield this.disableSingleEngine(e)
this.router.transitionTo("vault.cluster.secrets.backends")}finally{this.enginesToDisable=null}}*disableEngine(e){try{yield this.disableSingleEngine(e),this.router.transitionTo("vault.cluster.secrets.backends")}finally{this.engineToDisable=void 0}}},c=T(u.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=T(u.prototype,"api",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=T(u.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=T(u.prototype,"version",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=T(u.prototype,"secretEngineOptions",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),h=T(u.prototype,"engineToDisable",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){}}),b=T(u.prototype,"enginesToDisable",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),y=T(u.prototype,"engineTypeFilters",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),g=T(u.prototype,"engineVersionFilters",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),v=T(u.prototype,"searchText",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),w=T(u.prototype,"typeSearchText",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),k=T(u.prototype,"versionSearchText",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),x=T(u.prototype,"selectedItems",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return Array()}}),T(u.prototype,"setSearchText",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"setSearchText"),u.prototype),T(u.prototype,"filterByEngineType",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"filterByEngineType"),u.prototype),T(u.prototype,"filterByEngineVersion",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"filterByEngineVersion"),u.prototype),T(u.prototype,"clearAllFilters",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"clearAllFilters"),u.prototype),T(u.prototype,"updateSelectedItems",[i.action],Object.getOwnPropertyDescriptor(u.prototype,"updateSelectedItems"),u.prototype),T(u.prototype,"disableMultipleEngines",[a.dropTask],Object.getOwnPropertyDescriptor(u.prototype,"disableMultipleEngines"),u.prototype),T(u.prototype,"disableEngine",[a.dropTask],Object.getOwnPropertyDescriptor(u.prototype,"disableEngine"),u.prototype),u);(0,t.setComponentTemplate)(O,j)}))
define("vault/components/secret-engine/page-header",["exports","@ember/component","@ember/component/template-only","@ember/template-factory"],(function(e,t,n,i){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const r=(0,i.createTemplateFactory)({id:"xyRG1Gz1",block:'[[[1,"\\n"],[44,[[28,[37,1],[[30,1,["secretsEngine","type"]]],null]],[[[1,"  "],[8,[39,2],[[24,0,"page-header"]],null,[["default"],[[[[1,"\\n    "],[8,[30,3,["Title"]],null,null,[["default"],[[[[1,[30,1,["secretsEngine","id"]]],[1," configuration"]],[]]]]],[1,"\\n    "],[8,[30,3,["Description"]],null,null,[["default"],[[[[1,[28,[35,3],[[30,2],"displayName"],null]]],[]]]]],[1,"\\n    "],[8,[30,3,["Breadcrumb"]],null,null,[["default"],[[[[1,"\\n      "],[8,[39,4],null,null,[["default"],[[[[1,"\\n        "],[8,[39,5],null,[["@text","@route"],["Secrets","vault.cluster.secrets"]],null],[1,"\\n        "],[8,[39,5],null,[["@text","@route","@model"],[[30,1,["secretsEngine","id"]],"vault.cluster.secrets.backend.list-root",[30,1,["secretsEngine","id"]]]],null],[1,"\\n        "],[8,[39,5],null,[["@text","@current"],["Configuration",true]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[]]]]],[1,"\\n    "],[8,[30,3,["IconTile"]],null,[["@icon"],[[28,[37,3],[[30,2],"glyph"],null]]],null],[1,"\\n    "],[8,[30,3,["Subtitle"]],null,null,[["default"],[[[[1,[28,[35,3],[[30,2],"typeDisplay"],null]]],[]]]]],[1,"\\n  "]],[3]]]]],[1,"\\n\\n  "],[10,0],[14,0,"has-top-margin-l"],[12],[1,"\\n    "],[10,0],[14,0,"tabs-container box is-marginless is-fullwidth is-paddingless"],[12],[1,"\\n      "],[10,"nav"],[14,0,"tabs"],[15,"aria-label",[30,1,["secretsEngine","id"]]],[12],[1,"\\n        "],[10,"ul"],[12],[1,"\\n          "],[10,"li"],[12],[1,"\\n            "],[8,[39,10],null,[["@route","@model"],["vault.cluster.secrets.backend.configuration.general-settings",[30,1,["secretsEngine","id"]]]],[["default"],[[[[1,"\\n              General settings\\n            "]],[]]]]],[1,"\\n          "],[13],[1,"\\n"],[41,[28,[37,3],[[28,[37,1],[[30,1,["secretsEngine","type"]]],null],"isConfigurable"],null],[[[1,"            "],[10,"li"],[12],[1,"\\n              "],[8,[39,10],null,[["@route","@model"],["vault.cluster.secrets.backend.configuration.plugin-settings",[30,1,["secretsEngine","id"]]]],[["default"],[[[[1,"\\n                "],[1,[28,[35,3],[[28,[37,1],[[30,1,["secretsEngine","type"]]],null],"displayName"],null]],[1,"\\n                settings\\n              "]],[]]]]],[1,"\\n            "],[13],[1,"\\n"]],[]],null],[1,"        "],[13],[1,"\\n      "],[13],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[2]]]],["@model","engineData","PH"],false,["let","engines-display-data","hds/page-header","get","hds/breadcrumb","hds/breadcrumb/item","div","nav","ul","li","link-to","if"]]',moduleName:"vault/components/secret-engine/page-header.hbs",isStrictMode:!1})
e.default=(0,t.setComponentTemplate)(r,(0,n.default)())})),define("vault/components/secret-engine/page/general-settings",["exports","@ember/component","ember-concurrency/async-arrow-runtime","@glimmer/component","ember-concurrency","@ember/service","@glimmer/tracking","core/utils/duration-utils","@ember/object","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s,u){var c,d,p,f,m,h,b,y,g,v,w
function k(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function x(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function P(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const _=(0,u.createTemplateFactory)({id:"NPteaRaB",block:'[[[8,[39,0],null,[["@model"],[[30,1]]],null],[1,"\\n\\n"],[41,[30,0,["saveGeneralSettings","isRunning"]],[[[1,"  "],[8,[39,2],null,[["@gap","@direction","@justify","@align"],["24","column","center","center"]],[["default"],[[[[1,"\\n    "],[10,0],[14,0,"one-fourth-width"],[12],[1,"\\n      "],[8,[39,4],null,[["@name","@size","@stretched"],["loading-static","24",true]],null],[1,"\\n    "],[13],[1,"\\n    "],[8,[39,5],null,[["@tag"],["h2"]],[["default"],[[[[1,"Saving configuration..."]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[]],[[[1,"  "],[11,"form"],[24,"method","POST"],[24,"aria-label","general settings form"],[24,1,"general-settings-form"],[4,[38,7],["submit",[28,[37,8],[[30,0,["saveGeneralSettings"]]],null]],null],[12],[1,"\\n    "],[8,[39,9],[[24,0,"has-top-bottom-margin-xxs"]],null,[["default"],[[[[1,"\\n      Mount parameters that you can tune to fit required engine behavior.\\n    "]],[]]]]],[1,"\\n\\n    "],[8,[39,10],null,[["@errorMessage","@errors"],[[30,0,["errorMessage"]],[30,0,["errors"]]]],null],[1,"\\n\\n    "],[8,[39,11],null,[["@columnMinWidth","@gap"],["32%","32"]],[["default"],[[[[1,"\\n      "],[8,[30,2,["Item"]],null,[["@colspan"],[1]],[["default"],[[[[1,"\\n        "],[8,[39,12],[[24,0,"is-fullwidth"]],[["@model"],[[30,1]]],null],[1,"\\n        "],[8,[39,13],[[24,0,"is-fullwidth"]],[["@model"],[[30,1]]],null],[1,"\\n      "]],[]]]]],[1,"\\n      "],[8,[30,2,["Item"]],null,[["@colspan"],[1]],[["default"],[[[[1,"\\n        "],[8,[39,14],[[24,0,"is-fullwidth"]],[["@model","@defaultLeaseUnit","@maxLeaseUnit"],[[30,1],[30,0,["defaultLeaseUnit"]],[30,0,["maxLeaseUnit"]]]],null],[1,"\\n        "],[8,[39,15],[[24,0,"is-fullwidth"]],[["@model"],[[30,1]]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "]],[2]]]]],[1,"\\n    "],[10,0],[14,0,"field is-grouped has-top-bottom-margin"],[12],[1,"\\n      "],[8,[39,16],null,null,[["default"],[[[[1,"\\n        "],[8,[39,17],[[16,"disabled",[30,0,["saveGeneralSettings","isRunning"]]],[24,4,"submit"]],[["@text"],["Save changes"]],null],[1,"\\n        "],[8,[39,17],[[4,[38,7],["click",[30,0,["discardChanges"]]],null]],[["@text","@color"],["Discard","secondary"]],null],[1,"\\n      "]],[]]]]],[1,"\\n    "],[13],[1,"\\n  "],[13],[1,"\\n"]],[]]],[1,"\\n"],[8,[39,18],null,[["@onSave","@onDiscard","@changedFields"],[[30,0,["saveGeneralSettings"]],[30,0,["discardChanges"]],[30,0,["modalChangedFields"]]]],null]],["@model","LG"],false,["secret-engine/page-header","if","hds/layout/flex","div","hds/icon","hds/text/display","form","on","perform","hds/text/body","message-error","hds/layout/grid","secret-engine/card/version","secret-engine/card/metadata","secret-engine/card/secrets-duration","secret-engine/card/security","hds/button-set","hds/button","unsaved-changes-modal"]]',moduleName:"vault/components/secret-engine/page/general-settings.hbs",isStrictMode:!1})
let T=e.default=(c=class extends i.default{constructor(...e){super(...e),k(this,"router",d,this),k(this,"api",p,this),k(this,"flashMessages",f,this),k(this,"unsavedChanges",m,this),k(this,"errorMessage",h,this),k(this,"errors",b,this),k(this,"invalidFormAlert",y,this),k(this,"showUnsavedChangesModal",g,this),k(this,"defaultLeaseUnit",v,this),k(this,"maxLeaseUnit",w,this),x(this,"originalModel",JSON.parse(JSON.stringify(this.args.model))),x(this,"saveGeneralSettings",(0,n.buildTask)((()=>({context:this,generator:function*(e){if(e&&e.preventDefault(),this.validateForm())try{const{defaultLeaseTtl:e,maxLeaseTtl:t,pluginVersion:n,pluginDescription:i}=this.formatTuneParams()
yield this.api.sys.mountsTuneConfigurationParameters(this.args?.model?.secretsEngine?.id,{description:i,default_lease_ttl:e,max_lease_ttl:t,plugin_version:n}),this.flashMessages.success("Engine settings successfully updated.",{title:"Configuration saved"}),this.unsavedChanges.showModal=!1,this.router.transitionTo(this.router.currentRouteName)}catch(t){const{message:e}=yield this.api.parseError(t)
this.errorMessage=e}}})),null,"saveGeneralSettings",null))}get modalChangedFields(){const e=[...this.unsavedChanges.changedFields],t=this.unsavedChanges.changedFields.indexOf("config")
return-1===t?this.unsavedChanges.changedFields:(e[t]="Secrets duration",e)}validateTtl(e){return!isNaN(Number(e))}validateDescription(e){return e?.toString().length<=500}validateForm(){const{defaultLeaseTime:e,maxLeaseTime:t,description:n}=this.formData,i=[]
if(this.validateTtl(e)&&this.validateTtl(t)||i.push("TTL should only contain numbers."),n&&!this.validateDescription(n)){const e=n?.toString().length-500
i.push(`Engine description exceeds character limit by ${e}.`)}return this.errors=i,!i.length}hasTtlValueChanged(e,t,n){return(0,o.convertToSeconds)(e,t)!==this?.originalModel?.secretsEngine?.config[n]}get formData(){const e=document.getElementById("general-settings-form"),t=new FormData(e)
return{defaultLeaseTime:Number(t.get("default_lease_ttl-time")),defaultLeaseUnit:t.get("default_lease_ttl-unit")?.toString()||"s",maxLeaseTime:Number(t.get("max_lease_ttl-time")),maxLeaseUnit:t.get("max_lease_ttl-unit")?.toString()||"s",description:t.get("description"),version:t.get("plugin-version")}}formatTuneParams(){const{defaultLeaseTime:e,defaultLeaseUnit:t,maxLeaseTime:n,maxLeaseUnit:i,description:r,version:l}=this.formData,a=this.hasTtlValueChanged(e,t,"default_lease_ttl"),o=this.hasTtlValueChanged(n,i,"max_lease_ttl"),s=r!==this?.originalModel?.secretsEngine?.description
return{defaultLeaseTtl:a?`${e}${t}`:void 0,maxLeaseTtl:o?`${n}${i}`:void 0,pluginVersion:l&&l!==this?.originalModel?.secretsEngine?.running_plugin_version?l:void 0,pluginDescription:s?r:void 0}}discardChanges(){const e=this.router.currentRouteName
this.router.transitionTo(e)}},d=P(c.prototype,"router",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=P(c.prototype,"api",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),f=P(c.prototype,"flashMessages",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),m=P(c.prototype,"unsavedChanges",[l.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),h=P(c.prototype,"errorMessage",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),b=P(c.prototype,"errors",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return[]}}),y=P(c.prototype,"invalidFormAlert",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),g=P(c.prototype,"showUnsavedChangesModal",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),v=P(c.prototype,"defaultLeaseUnit",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),w=P(c.prototype,"maxLeaseUnit",[a.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),P(c.prototype,"discardChanges",[s.action],Object.getOwnPropertyDescriptor(c.prototype,"discardChanges"),c.prototype),c);(0,t.setComponentTemplate)(_,T)})),define("vault/components/secret-engine/page/plugin-settings",["exports","@ember/component","@glimmer/component","core/helpers/to-label","vault/helpers/engines-display-data","@ember/template-factory"],(function(e,t,n,i,r,l){function a(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const o=(0,l.createTemplateFactory)({id:"ltLiSbUd",block:'[[[1,"\\n"],[8,[39,0],null,[["@model"],[[30,1]]],null],[1,"\\n\\n"],[41,[30,1,["config"]],[[[42,[28,[37,3],[[28,[37,3],[[30,0,["displayFields"]]],null]],null],null,[[[41,[28,[37,4],[[30,2],"public_key"],null],[[[1,"      "],[8,[39,5],null,[["@label","@value"],["Public key",[30,1,["config","public_key"]]]],[["default"],[[[[1,"\\n        "],[8,[39,6],null,[["@value","@name","@displayOnly","@allowCopy"],[[30,1,["config","public_key"]],[30,2],true,true]],null],[1,"\\n      "]],[]]]]],[1,"\\n"]],[]],[[[1,"      "],[8,[39,5],null,[["@alwaysRender","@label","@value","@formatTtl"],[[28,[37,7],[[28,[37,8],[[28,[37,9],[[30,1,["config"]],[30,2]],null]],null]],null],[28,[30,0,["label"]],[[30,2]],null],[28,[37,9],[[30,1,["config"]],[30,2]],null],[28,[30,0,["isDuration"]],[[30,2]],null]]],null],[1,"\\n"]],[]]]],[2]],null]],[]],[[[41,[28,[37,9],[[28,[37,10],[[30,1,["secretsEngine","type"]]],null],"isConfigurable"],null],[[[1,"    "],[8,[39,11],null,[["@title","@message"],[[29,[[28,[37,9],[[28,[37,10],[[30,1,["secretsEngine","type"]]],null],"displayName"],null]," not configured"]],[29,["Get started by configuring your ",[28,[37,9],[[28,[37,10],[[30,1,["secretsEngine","type"]]],null],"displayName"],null]," secrets engine."]]]],[["default"],[[[[1,"\\n      "],[8,[39,12],null,[["@icon","@iconPosition","@text","@route","@model"],["chevron-right","trailing",[29,["Configure ",[28,[37,9],[[28,[37,10],[[30,1,["secretsEngine","type"]]],null],"displayName"],null]]],"vault.cluster.secrets.backend.configuration.edit",[30,3]]],null],[1,"\\n    "]],[]]]]],[1,"\\n\\n"]],[]],[[[1,"    "],[8,[39,11],null,[["@title","@message"],["No configuration details available",[29,[[28,[37,9],[[28,[37,10],[[30,1,["secretsEngine","type"]]],null],"displayName"],null]," does not have any plugin specific configuration. All configurable parameters for this engine are under \'General Settings\'."]]]],[["default"],[[[[1,"\\n      "],[8,[39,12],null,[["@icon","@iconPosition","@text","@route","@model"],["chevron-right","trailing","Back to general settings","vault.cluster.secrets.backend.configuration.general-settings",[30,3]]],null],[1,"\\n    "]],[]]]]],[1,"\\n"]],[]]]],[]]]],["@model","field","@id"],false,["secret-engine/page-header","if","each","-track-array","eq","info-table-row","masked-input","not","is-empty-value","get","engines-display-data","empty-state","hds/link/standalone"]]',moduleName:"vault/components/secret-engine/page/plugin-settings.hbs",isStrictMode:!1})
class s extends n.default{constructor(...e){super(...e),a(this,"awsFields",["role_arn","identity_token_audience","identity_token_ttl","access_key","region","iam_endpoint","sts_endpoint","max_retries","lease","lease_max","issuer"]),a(this,"azureFields",["subscription_id","tenant_id","client_id","identity_token_audience","identity_token_ttl","root_password_ttl","environment","issuer"]),a(this,"gcpFields",["service_account_email","ttl","max_ttl","identity_token_audience","identity_token_ttl","issuer"]),a(this,"sshFields",["public_key","generate_signing_key"]),a(this,"label",(e=>{const t=(0,i.toLabel)([e]).split(" ").map((e=>["id","ttl","arn","iam","sts"].includes(e.toLowerCase())?e.toUpperCase():e)).join(" ")
return{lease:"Default Lease TTL",lease_max:"Max Lease TTL",ttl:"Config TTL"}[e]||t})),a(this,"isDuration",(e=>["identity_token_ttl","root_password_ttl","lease","lease_max","ttl","max_ttl"].includes(e)))}get displayFields(){switch((0,r.default)(this.args.model.secretsEngine.type)?.displayName){case"AWS":return this.awsFields
case"Azure":return this.azureFields
case"Google Cloud":return this.gcpFields
case"SSH":return this.sshFields
default:return[]}}}e.default=s,(0,t.setComponentTemplate)(o,s)})),define("vault/components/secret-engine/ttl-picker-v2",["exports","@ember/component","@glimmer/component","@ember/object","@ember/service","@glimmer/tracking","core/utils/duration-utils","@ember/template-factory"],(function(e,t,n,i,r,l,a,o){var s,u,c,d,p,f,m
function h(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function b(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e
var n=e[Symbol.toPrimitive]
if(void 0!==n){var i=n.call(e,t||"default")
if("object"!=typeof i)return i
throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string")
return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}function y(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const g=(0,o.createTemplateFactory)({id:"ogWpv57S",block:'[[[1,"\\n"],[8,[39,0],null,[["@layout","@isInvalid"],["vertical",[30,0,["errorMessage"]]]],[["default"],[[[[1,"\\n  "],[8,[30,1,["Label"]],null,null,[["default"],[[[[1,[30,0,["formField","label"]]]],[]]]]],[1,"\\n  "],[8,[30,1,["HelperText"]],null,null,[["default"],[[[[1,[30,0,["formField","helperText"]]]],[]]]]],[1,"\\n  "],[8,[30,1,["Control"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[30,2,["TextInput"]],[[24,"size","32"],[16,3,[29,[[30,3],"-time"]]],[16,"aria-label",[28,[37,2],[[30,0,["formField","label"]],"time"],null]],[24,"autocomplete","off"],[4,[38,3],["input",[30,0,["setTtlTime"]]],null]],[["@width","@value"],["100px",[30,0,["time"]]]],null],[1,"\\n      "],[8,[30,2,["Select"]],[[16,3,[29,[[30,3],"-unit"]]],[16,"aria-label",[28,[37,2],[[30,0,["formField","label"]],"unit"],null]],[4,[38,3],["input",[30,0,["setUnit"]]],null]],[["@width"],["100px"]],[["default"],[[[[1,"\\n        "],[8,[30,4,["Options"]],null,null,[["default"],[[[[1,"\\n"],[42,[28,[37,5],[[28,[37,5],[[30,0,["unitOptions"]]],null]],null],null,[[[1,"            "],[10,"option"],[15,2,[30,5,["value"]]],[15,"selected",[28,[37,7],[[30,5,["value"]],[30,0,["selectedUnit"]]],null]],[12],[1,[30,5,["label"]]],[13],[1,"\\n"]],[5]],null],[1,"        "]],[]]]]],[1,"\\n      "]],[4]]]]],[1,"\\n    "]],[2]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"],[41,[30,0,["errorMessage"]],[[[1,"    "],[8,[30,1,["Error"]],null,null,[["default"],[[[[1,[30,0,["errorMessage"]]]],[]]]]],[1,"\\n"]],[]],null]],[1]]]]]],["F","SG","@ttlKey","S","unit"],false,["hds/form/field","hds/segmented-group","concat","on","each","-track-array","option","eq","if"]]',moduleName:"vault/components/secret-engine/ttl-picker-v2.hbs",isStrictMode:!1})
let v=e.default=(s=class extends n.default{constructor(e,t){super(e,t),b(this,"systemDefaultTtl",0),h(this,"flashMessages",u,this),h(this,"api",c,this),h(this,"router",d,this),h(this,"selectedUnit",p,this),h(this,"time",f,this),h(this,"errorMessage",m,this),this.initializeTtl()}initializeTtl(){const e=this.args?.model?.secretsEngine?.config[this.args.ttlKey]
let t=0
if("number"==typeof e)t=e
else{const n=(0,a.durationToSeconds)(e||"")
if(null===n)return this.time=e||"",void(this.selectedUnit=this.args.initialUnit)
t=n}const n=(0,a.largestUnitFromSeconds)(t),i=(0,a.convertFromSeconds)(t,n)
this.time=i.toString()||"",this.selectedUnit=n}get unitOptions(){return[{label:"seconds",value:"s"},{label:"minutes",value:"m"},{label:"hours",value:"h"},{label:"days",value:"d"}]}get formField(){return{label:"default_lease_ttl"===this.args?.ttlKey?"Default time-to-live (TTL)":"Maximum time-to-live (TTL)",helperText:"default_lease_ttl"===this.args?.ttlKey?"How long secrets in this engine stay valid.":"Maximum extension for the secrets life beyond default."}}setTtlTime(e){this.errorMessage="",isNaN(Number(e.target.value))?this.errorMessage="Only use numbers for this setting.":(this.time=e.target.value,this.args.model.secretsEngine.config[this.args.ttlKey]=e.target.value)}setUnit(e){this.selectedUnit=e.target.value}},u=y(s.prototype,"flashMessages",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),c=y(s.prototype,"api",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=y(s.prototype,"router",[r.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),p=y(s.prototype,"selectedUnit",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return"s"}}),f=y(s.prototype,"time",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),m=y(s.prototype,"errorMessage",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return""}}),y(s.prototype,"setTtlTime",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"setTtlTime"),s.prototype),y(s.prototype,"setUnit",[i.action],Object.getOwnPropertyDescriptor(s.prototype,"setUnit"),s.prototype),s);(0,t.setComponentTemplate)(g,v)})),define("vault/components/secret-engines/catalog",["exports","@ember/component","@glimmer/component","@ember/service","@ember/object","@glimmer/tracking","vault/utils/all-engines-metadata","vault/utils/plugin-catalog-helpers","@ember/template-factory"],(function(e,t,n,i,r,l,a,o,s){var u,c,d,p,f
function m(e,t,n,i){n&&Object.defineProperty(e,t,{enumerable:n.enumerable,configurable:n.configurable,writable:n.writable,value:n.initializer?n.initializer.call(i):void 0})}function h(e,t,n,i,r){var l={}
return Object.keys(i).forEach((function(e){l[e]=i[e]})),l.enumerable=!!l.enumerable,l.configurable=!!l.configurable,("value"in l||l.initializer)&&(l.writable=!0),l=n.slice().reverse().reduce((function(n,i){return i(e,t,n)||n}),l),r&&void 0!==l.initializer&&(l.value=l.initializer?l.initializer.call(r):void 0,l.initializer=void 0),void 0===l.initializer?(Object.defineProperty(e,t,l),null):l}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0
const b=(0,s.createTemplateFactory)({id:"eGgZ7OZq",block:'[[[1,"\\n"],[8,[39,0],[[24,0,"page-header"]],null,[["default"],[[[[1,"\\n  "],[8,[30,1,["Breadcrumb"]],null,null,[["default"],[[[[1,"\\n    "],[8,[39,1],null,null,[["default"],[[[[1,"\\n      "],[8,[39,2],null,[["@text","@route"],["Secrets","vault.cluster.secrets.backends"]],null],[1,"\\n      "],[8,[39,2],null,[["@text","@current"],["Enable secret engine",true]],null],[1,"\\n    "]],[]]]]],[1,"\\n  "]],[]]]]],[1,"\\n"]],[1]]]]],[1,"\\n\\n"],[41,[30,2],[[[1,"  "],[10,0],[14,0,"has-bottom-padding-m"],[12],[1,"\\n    "],[8,[39,5],null,[["@type","@color"],["inline","warning"]],[["default"],[[[[1,"\\n      "],[8,[30,3,["Title"]],null,null,[["default"],[[[[1,"Plugin information unavailable"]],[]]]]],[1,"\\n      "],[8,[30,3,["Description"]],null,null,[["default"],[[[[1,"\\n        Unable to fetch current plugin information. Using static plugin data instead. Some plugins may not show current\\n        details.\\n      "]],[]]]]],[1,"\\n    "]],[3]]]]],[1,"\\n  "],[13],[1,"\\n"]],[]],null],[1,"\\n"],[42,[28,[37,7],[[28,[37,7],[[30,0,["pluginCategoriesList"]]],null]],null],null,[[[44,[[28,[30,0,["getMountTypesByCategory"]],[[30,4]],null]],[[[41,[28,[37,9],[[30,5,["enabled","length"]],[30,5,["disabled","length"]]],null],[[[1,"      "],[10,0],[14,0,"has-top-padding-m has-bottom-padding-s"],[12],[1,"\\n        "],[8,[39,10],[[24,"size","400"],[24,0,"is-flex align-items-center"]],[["@tag"],["h2"]],[["default"],[[[[1,"\\n          "],[1,[28,[35,11],[[30,4]],null]],[1,"\\n"],[41,[28,[37,12],[[30,4],"external"],null],[[[1,"            "],[8,[39,13],[[24,0,"has-left-margin-xs"],[4,[38,14],["click",[30,0,["openExternalPluginsHelp"]]],null]],[["@text","@color","@icon","@size","@isIconOnly","@ariaLabel"],["","tertiary","info","small",true,"Information about external plugins"]],null],[1,"\\n"]],[]],null],[1,"        "]],[]]]]],[1,"\\n      "],[13],[1,"\\n      "],[10,0],[14,0,"flex row-wrap row-gap-16 column-gap-16 has-bottom-padding-m"],[12],[1,"\\n"],[42,[28,[37,7],[[28,[37,7],[[30,5,["enabled"]]],null]],null],null,[[[1,"          "],[8,[39,15],null,[["@type","@setMountType"],[[30,6],[30,7]]],null],[1,"\\n"]],[6]],null],[1,"\\n"],[41,[28,[37,16],[[30,5,["enabled","length"]],[30,5,["disabled","length"]]],null],[[[1,"          "],[10,0],[14,0,"selectable-engines-vertical-divider has-top-bottom-margin-12"],[12],[13],[1,"\\n"]],[]],null],[1,"\\n"],[42,[28,[37,7],[[28,[37,7],[[30,5,["disabled"]]],null]],null],null,[[[1,"          "],[8,[39,17],null,[["@type","@handleDisabledPluginClick","@handleDisabledPluginKeyDown"],[[30,8],[30,0,["handleDisabledPluginClick"]],[30,0,["handleDisabledPluginKeyDown"]]]],null],[1,"\\n"]],[8]],null],[1,"      "],[13],[1,"\\n"]],[]],null]],[5]]]],[4]],null],[1,"\\n"],[8,[39,18],null,[["@isOpen","@plugin","@pluginType","@onClose"],[[30,0,["showFlyout"]],[30,0,["flyoutPlugin"]],[30,0,["flyoutPluginType"]],[30,0,["closeFlyout"]]]],null]],["PH","@pluginCatalogError","A","category","categorized","type","@setMountType","type"],false,["hds/page-header","hds/breadcrumb","hds/breadcrumb/item","if","div","hds/alert","each","-track-array","let","or","hds/text/display","capitalize","eq","hds/button","on","enabled-plugin-card","and","disabled-plugin-card","plugin-documentation-flyout"]]',moduleName:"vault/components/secret-engines/catalog.hbs",isStrictMode:!1})
let y=e.default=(u=class extends n.default{constructor(...e){super(...e),m(this,"version",c,this),m(this,"showFlyout",d,this),m(this,"flyoutPlugin",p,this),m(this,"flyoutPluginType",f,this)}get secretEngines(){const e=(0,a.filterEnginesByMountCategory)({mountCategory:o.MOUNT_CATEGORIES.SECRET,isEnterprise:!!this.version?.isEnterprise})
if(this.args.pluginCatalogData){const t=this.args.pluginCatalogData.detailed?.filter((e=>e?.type===o.PLUGIN_TYPES.SECRET))||[],n=this.args.pluginCatalogData.detailed?.filter((e=>e?.type===o.PLUGIN_TYPES.DATABASE))||[]
return(0,o.enhanceEnginesWithCatalogData)(e,t,n)}return e}get pluginCategoriesList(){return[o.PLUGIN_CATEGORIES.GENERIC,o.PLUGIN_CATEGORIES.CLOUD,o.PLUGIN_CATEGORIES.INFRA]}get secretMountCategory(){return o.MOUNT_CATEGORIES.SECRET}getMountTypesByCategory(e){try{const t=this.secretEngines
if(!t||!Array.isArray(t))return{enabled:[],disabled:[]}
const n=t.filter((t=>{const n=t
return n?.pluginCategory===e}))
return(0,o.categorizeEnginesByStatus)(n)}catch(t){return{enabled:[],disabled:[]}}}handleDisabledPluginClick(e){this.showFlyout=!0,this.flyoutPlugin=e,this.flyoutPluginType="secret"}handleDisabledPluginKeyDown(e,t){"Enter"!==t.key&&" "!==t.key||(t.preventDefault(),this.handleDisabledPluginClick(e))}openExternalPluginsHelp(){this.showFlyout=!0,this.flyoutPlugin=null,this.flyoutPluginType="secret"}closeFlyout(){this.showFlyout=!1,this.flyoutPlugin=null,this.flyoutPluginType=null}},c=h(u.prototype,"version",[i.service],{configurable:!0,enumerable:!0,writable:!0,initializer:null}),d=h(u.prototype,"showFlyout",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return!1}}),p=h(u.prototype,"flyoutPlugin",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),f=h(u.prototype,"flyoutPluginType",[l.tracked],{configurable:!0,enumerable:!0,writable:!0,initializer:function(){return null}}),h(u.prototype,"getMount