/* tslint:disable */
/* eslint-disable */
/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
/**
 * 
 * @export
 * @interface OktaConfigureRequest
 */
export interface OktaConfigureRequest {
    /**
     * Okta API key.
     * @type {string}
     * @memberof OktaConfigureRequest
     */
    apiToken?: string;
    /**
     * The base domain to use for the Okta API. When not specified in the configuration, "okta.com" is used.
     * @type {string}
     * @memberof OktaConfigureRequest
     */
    baseUrl?: string;
    /**
     * When set true, requests by Okta for a MFA check will be bypassed. This also disallows certain status checks on the account, such as whether the password is expired.
     * @type {boolean}
     * @memberof OktaConfigureRequest
     */
    bypassOktaMfa?: boolean;
    /**
     * Use "token_max_ttl" instead. If this and "token_max_ttl" are both specified, only "token_max_ttl" will be used.
     * @type {string}
     * @memberof OktaConfigureRequest
     * @deprecated
     */
    maxTtl?: string;
    /**
     * Name of the organization to be used in the Okta API.
     * @type {string}
     * @memberof OktaConfigureRequest
     */
    orgName?: string;
    /**
     * Use org_name instead.
     * @type {string}
     * @memberof OktaConfigureRequest
     * @deprecated
     */
    organization?: string;
    /**
     * Use base_url instead.
     * @type {boolean}
     * @memberof OktaConfigureRequest
     * @deprecated
     */
    production?: boolean;
    /**
     * Use api_token instead.
     * @type {string}
     * @memberof OktaConfigureRequest
     * @deprecated
     */
    token?: string;
    /**
     * Comma separated string or JSON list of CIDR blocks. If set, specifies the blocks of IP addresses which are allowed to use the generated token.
     * @type {Array<string>}
     * @memberof OktaConfigureRequest
     */
    tokenBoundCidrs?: Array<string>;
    /**
     * If set, tokens created via this role carry an explicit maximum TTL. During renewal, the current maximum TTL values of the role and the mount are not checked for changes, and any updates to these values will have no effect on the token being renewed.
     * @type {string}
     * @memberof OktaConfigureRequest
     */
    tokenExplicitMaxTtl?: string;
    /**
     * The maximum lifetime of the generated token
     * @type {string}
     * @memberof OktaConfigureRequest
     */
    tokenMaxTtl?: string;
    /**
     * If true, the 'default' policy will not automatically be added to generated tokens
     * @type {boolean}
     * @memberof OktaConfigureRequest
     */
    tokenNoDefaultPolicy?: boolean;
    /**
     * The maximum number of times a token may be used, a value of zero means unlimited
     * @type {number}
     * @memberof OktaConfigureRequest
     */
    tokenNumUses?: number;
    /**
     * If set, tokens created via this role will have no max lifetime; instead, their renewal period will be fixed to this value. This takes an integer number of seconds, or a string duration (e.g. "24h").
     * @type {string}
     * @memberof OktaConfigureRequest
     */
    tokenPeriod?: string;
    /**
     * Comma-separated list of policies. This will apply to all tokens generated by this auth method, in addition to any configured for specific users/groups.
     * @type {Array<string>}
     * @memberof OktaConfigureRequest
     */
    tokenPolicies?: Array<string>;
    /**
     * The initial ttl of the token to generate
     * @type {string}
     * @memberof OktaConfigureRequest
     */
    tokenTtl?: string;
    /**
     * The type of token to generate, service or batch
     * @type {string}
     * @memberof OktaConfigureRequest
     */
    tokenType?: string;
    /**
     * Use "token_ttl" instead. If this and "token_ttl" are both specified, only "token_ttl" will be used.
     * @type {string}
     * @memberof OktaConfigureRequest
     * @deprecated
     */
    ttl?: string;
}

/**
 * Check if a given object implements the OktaConfigureRequest interface.
 */
export function instanceOfOktaConfigureRequest(value: object): value is OktaConfigureRequest {
    return true;
}

export function OktaConfigureRequestFromJSON(json: any): OktaConfigureRequest {
    return OktaConfigureRequestFromJSONTyped(json, false);
}

export function OktaConfigureRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): OktaConfigureRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'apiToken': json['api_token'] == null ? undefined : json['api_token'],
        'baseUrl': json['base_url'] == null ? undefined : json['base_url'],
        'bypassOktaMfa': json['bypass_okta_mfa'] == null ? undefined : json['bypass_okta_mfa'],
        'maxTtl': json['max_ttl'] == null ? undefined : json['max_ttl'],
        'orgName': json['org_name'] == null ? undefined : json['org_name'],
        'organization': json['organization'] == null ? undefined : json['organization'],
        'production': json['production'] == null ? undefined : json['production'],
        'token': json['token'] == null ? undefined : json['token'],
        'tokenBoundCidrs': json['token_bound_cidrs'] == null ? undefined : json['token_bound_cidrs'],
        'tokenExplicitMaxTtl': json['token_explicit_max_ttl'] == null ? undefined : json['token_explicit_max_ttl'],
        'tokenMaxTtl': json['token_max_ttl'] == null ? undefined : json['token_max_ttl'],
        'tokenNoDefaultPolicy': json['token_no_default_policy'] == null ? undefined : json['token_no_default_policy'],
        'tokenNumUses': json['token_num_uses'] == null ? undefined : json['token_num_uses'],
        'tokenPeriod': json['token_period'] == null ? undefined : json['token_period'],
        'tokenPolicies': json['token_policies'] == null ? undefined : json['token_policies'],
        'tokenTtl': json['token_ttl'] == null ? undefined : json['token_ttl'],
        'tokenType': json['token_type'] == null ? undefined : json['token_type'],
        'ttl': json['ttl'] == null ? undefined : json['ttl'],
    };
}

export function OktaConfigureRequestToJSON(json: any): OktaConfigureRequest {
    return OktaConfigureRequestToJSONTyped(json, false);
}

export function OktaConfigureRequestToJSONTyped(value?: OktaConfigureRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'api_token': value['apiToken'],
        'base_url': value['baseUrl'],
        'bypass_okta_mfa': value['bypassOktaMfa'],
        'max_ttl': value['maxTtl'],
        'org_name': value['orgName'],
        'organization': value['organization'],
        'production': value['production'],
        'token': value['token'],
        'token_bound_cidrs': value['tokenBoundCidrs'],
        'token_explicit_max_ttl': value['tokenExplicitMaxTtl'],
        'token_max_ttl': value['tokenMaxTtl'],
        'token_no_default_policy': value['tokenNoDefaultPolicy'],
        'token_num_uses': value['tokenNumUses'],
        'token_period': value['tokenPeriod'],
        'token_policies': value['tokenPolicies'],
        'token_ttl': value['tokenTtl'],
        'token_type': value['tokenType'],
        'ttl': value['ttl'],
    };
}

