/* tslint:disable */
/* eslint-disable */
/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { mapValues } from '../runtime';
/**
 * 
 * @export
 * @interface GoogleCloudKmsWriteKeyRequest
 */
export interface GoogleCloudKmsWriteKeyRequest {
    /**
     * Algorithm to use for encryption, decryption, or signing. The value depends on the key purpose. The value cannot be changed after creation. For a key purpose of "encrypt_decrypt", the valid values are: - symmetric_encryption (default) For a key purpose of "asymmetric_sign", valid values are: - rsa_sign_pss_2048_sha256 - rsa_sign_pss_3072_sha256 - rsa_sign_pss_4096_sha256 - rsa_sign_pkcs1_2048_sha256 - rsa_sign_pkcs1_3072_sha256 - rsa_sign_pkcs1_4096_sha256 - ec_sign_p256_sha256 - ec_sign_p384_sha384 For a key purpose of "asymmetric_decrypt", valid values are: - rsa_decrypt_oaep_2048_sha256 - rsa_decrypt_oaep_3072_sha256 - rsa_decrypt_oaep_4096_sha256
     * @type {string}
     * @memberof GoogleCloudKmsWriteKeyRequest
     */
    algorithm?: string;
    /**
     * Name of the crypto key to use. If the given crypto key does not exist, Vault will try to create it. This defaults to the name of the key given to Vault as the parameter if unspecified.
     * @type {string}
     * @memberof GoogleCloudKmsWriteKeyRequest
     */
    cryptoKey?: string;
    /**
     * Full Google Cloud resource ID of the key ring with the project and location (e.g. projects/my-project/locations/global/keyRings/my-keyring). If the given key ring does not exist, Vault will try to create it during a create operation.
     * @type {string}
     * @memberof GoogleCloudKmsWriteKeyRequest
     */
    keyRing?: string;
    /**
     * Arbitrary key=value label to apply to the crypto key. To specify multiple labels, specify this argument multiple times (e.g. labels="a=b" labels="c=d").
     * @type {object}
     * @memberof GoogleCloudKmsWriteKeyRequest
     */
    labels?: object;
    /**
     * Level of protection to use for the key management. Valid values are "software" and "hsm". The default value is "software". The value cannot be changed after creation.
     * @type {string}
     * @memberof GoogleCloudKmsWriteKeyRequest
     */
    protectionLevel?: string;
    /**
     * Purpose of the key. Valid options are "asymmetric_decrypt", "asymmetric_sign", and "encrypt_decrypt". The default value is "encrypt_decrypt". The value cannot be changed after creation.
     * @type {string}
     * @memberof GoogleCloudKmsWriteKeyRequest
     */
    purpose?: string;
    /**
     * Amount of time between crypto key version rotations. This is specified as a time duration value like 72h (72 hours). The smallest possible value is 24h. This value only applies to keys with a purpose of "encrypt_decrypt".
     * @type {string}
     * @memberof GoogleCloudKmsWriteKeyRequest
     */
    rotationPeriod?: string;
}

/**
 * Check if a given object implements the GoogleCloudKmsWriteKeyRequest interface.
 */
export function instanceOfGoogleCloudKmsWriteKeyRequest(value: object): value is GoogleCloudKmsWriteKeyRequest {
    return true;
}

export function GoogleCloudKmsWriteKeyRequestFromJSON(json: any): GoogleCloudKmsWriteKeyRequest {
    return GoogleCloudKmsWriteKeyRequestFromJSONTyped(json, false);
}

export function GoogleCloudKmsWriteKeyRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): GoogleCloudKmsWriteKeyRequest {
    if (json == null) {
        return json;
    }
    return {
        
        'algorithm': json['algorithm'] == null ? undefined : json['algorithm'],
        'cryptoKey': json['crypto_key'] == null ? undefined : json['crypto_key'],
        'keyRing': json['key_ring'] == null ? undefined : json['key_ring'],
        'labels': json['labels'] == null ? undefined : json['labels'],
        'protectionLevel': json['protection_level'] == null ? undefined : json['protection_level'],
        'purpose': json['purpose'] == null ? undefined : json['purpose'],
        'rotationPeriod': json['rotation_period'] == null ? undefined : json['rotation_period'],
    };
}

export function GoogleCloudKmsWriteKeyRequestToJSON(json: any): GoogleCloudKmsWriteKeyRequest {
    return GoogleCloudKmsWriteKeyRequestToJSONTyped(json, false);
}

export function GoogleCloudKmsWriteKeyRequestToJSONTyped(value?: GoogleCloudKmsWriteKeyRequest | null, ignoreDiscriminator: boolean = false): any {
    if (value == null) {
        return value;
    }

    return {
        
        'algorithm': value['algorithm'],
        'crypto_key': value['cryptoKey'],
        'key_ring': value['keyRing'],
        'labels': value['labels'],
        'protection_level': value['protectionLevel'],
        'purpose': value['purpose'],
        'rotation_period': value['rotationPeriod'],
    };
}

