/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface TransitGenerateHmacWithAlgorithmRequest
 */
export interface TransitGenerateHmacWithAlgorithmRequest {
    /**
     * Algorithm to use (POST body parameter). Valid values are: * sha2-224 * sha2-256 * sha2-384 * sha2-512 * sha3-224 * sha3-256 * sha3-384 * sha3-512 Defaults to "sha2-256".
     * @type {string}
     * @memberof TransitGenerateHmacWithAlgorithmRequest
     */
    algorithm?: string;
    /**
     * Specifies a list of items to be processed in a single batch. When this parameter is set, if the parameter 'input' is also set, it will be ignored. Any batch output will preserve the order of the batch input.
     * @type {Array<object>}
     * @memberof TransitGenerateHmacWithAlgorithmRequest
     */
    batchInput?: Array<object>;
    /**
     * The base64-encoded input data
     * @type {string}
     * @memberof TransitGenerateHmacWithAlgorithmRequest
     */
    input?: string;
    /**
     * The version of the key to use for generating the HMAC. Must be 0 (for latest) or a value greater than or equal to the min_encryption_version configured on the key.
     * @type {number}
     * @memberof TransitGenerateHmacWithAlgorithmRequest
     */
    keyVersion?: number;
}
/**
 * Check if a given object implements the TransitGenerateHmacWithAlgorithmRequest interface.
 */
export declare function instanceOfTransitGenerateHmacWithAlgorithmRequest(value: object): value is TransitGenerateHmacWithAlgorithmRequest;
export declare function TransitGenerateHmacWithAlgorithmRequestFromJSON(json: any): TransitGenerateHmacWithAlgorithmRequest;
export declare function TransitGenerateHmacWithAlgorithmRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): TransitGenerateHmacWithAlgorithmRequest;
export declare function TransitGenerateHmacWithAlgorithmRequestToJSON(json: any): TransitGenerateHmacWithAlgorithmRequest;
export declare function TransitGenerateHmacWithAlgorithmRequestToJSONTyped(value?: TransitGenerateHmacWithAlgorithmRequest | null, ignoreDiscriminator?: boolean): any;
