/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface TokenCreateRequest
 */
export interface TokenCreateRequest {
    /**
     * Name to associate with this token
     * @type {string}
     * @memberof TokenCreateRequest
     */
    displayName?: string;
    /**
     * Name of the entity alias to associate with this token
     * @type {string}
     * @memberof TokenCreateRequest
     */
    entityAlias?: string;
    /**
     * Explicit Max TTL of this token
     * @type {string}
     * @memberof TokenCreateRequest
     */
    explicitMaxTtl?: string;
    /**
     * Value for the token
     * @type {string}
     * @memberof TokenCreateRequest
     */
    id?: string;
    /**
     * Use 'ttl' instead
     * @type {string}
     * @memberof TokenCreateRequest
     * @deprecated
     */
    lease?: string;
    /**
     * Arbitrary key=value metadata to associate with the token
     * @type {object}
     * @memberof TokenCreateRequest
     */
    meta?: object;
    /**
     * Do not include default policy for this token
     * @type {boolean}
     * @memberof TokenCreateRequest
     */
    noDefaultPolicy?: boolean;
    /**
     * Create the token with no parent
     * @type {boolean}
     * @memberof TokenCreateRequest
     */
    noParent?: boolean;
    /**
     * Max number of uses for this token
     * @type {number}
     * @memberof TokenCreateRequest
     */
    numUses?: number;
    /**
     * Renew period
     * @type {string}
     * @memberof TokenCreateRequest
     */
    period?: string;
    /**
     * List of policies for the token
     * @type {Array<string>}
     * @memberof TokenCreateRequest
     */
    policies?: Array<string>;
    /**
     * Allow token to be renewed past its initial TTL up to system/mount maximum TTL
     * @type {boolean}
     * @memberof TokenCreateRequest
     */
    renewable?: boolean;
    /**
     * Time to live for this token
     * @type {string}
     * @memberof TokenCreateRequest
     */
    ttl?: string;
    /**
     * Token type
     * @type {string}
     * @memberof TokenCreateRequest
     */
    type?: string;
}
/**
 * Check if a given object implements the TokenCreateRequest interface.
 */
export declare function instanceOfTokenCreateRequest(value: object): value is TokenCreateRequest;
export declare function TokenCreateRequestFromJSON(json: any): TokenCreateRequest;
export declare function TokenCreateRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): TokenCreateRequest;
export declare function TokenCreateRequestToJSON(json: any): TokenCreateRequest;
export declare function TokenCreateRequestToJSONTyped(value?: TokenCreateRequest | null, ignoreDiscriminator?: boolean): any;
