/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface SystemWriteSyncDestinationsAzureKvNameRequest
 */
export interface SystemWriteSyncDestinationsAzureKvNameRequest {
    /**
     * Sets which IPv4 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    allowedIpv4Addresses?: Array<string>;
    /**
     * Sets which IPv6 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    allowedIpv6Addresses?: Array<string>;
    /**
     * Sets which port numbers Vault is allowed to connect through for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    allowedPorts?: Array<string>;
    /**
     * OAuth2 client id of an Azure app registration with access to the key vault.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    clientId?: string;
    /**
     * OAuth2 client secret of an Azure app registration with access to the key vault.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    clientSecret?: string;
    /**
     * Azure environment name. If not provided, AzurePublicCloud is used.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    cloud?: string;
    /**
     * Custom tags to set on the secret managed at the destination. Custom tags are merged with system tags.
     * @type {object}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    customTags?: object;
    /**
     * Allows all IP addresses and ports to be connected to for syncing secrets.
     * @type {boolean}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    disableStrictNetworking?: boolean;
    /**
     * Determines what level of information is synced as a distinct resource at the destination. Supports `secret-path` and `secret-key`.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    granularity?: string;
    /**
     * URI of the Azure Key Vault to access.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    keyVaultUri?: string;
    /**
     * Asynchronously unsyncs all associated secrets with the destination then deletes the destination config.
     * @type {boolean}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    purge?: boolean;
    /**
     * Template describing how to generate external secret names. Supports a subset of the Go Template syntax.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    secretNameTemplate?: string;
    /**
     * List of custom tags to remove for patch requests. This field is ignored on create and update requests.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    tagsToRemove?: Array<string>;
    /**
     * Tenant id for the Azure Active Directory.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAzureKvNameRequest
     */
    tenantId?: string;
}
/**
 * Check if a given object implements the SystemWriteSyncDestinationsAzureKvNameRequest interface.
 */
export declare function instanceOfSystemWriteSyncDestinationsAzureKvNameRequest(value: object): value is SystemWriteSyncDestinationsAzureKvNameRequest;
export declare function SystemWriteSyncDestinationsAzureKvNameRequestFromJSON(json: any): SystemWriteSyncDestinationsAzureKvNameRequest;
export declare function SystemWriteSyncDestinationsAzureKvNameRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SystemWriteSyncDestinationsAzureKvNameRequest;
export declare function SystemWriteSyncDestinationsAzureKvNameRequestToJSON(json: any): SystemWriteSyncDestinationsAzureKvNameRequest;
export declare function SystemWriteSyncDestinationsAzureKvNameRequestToJSONTyped(value?: SystemWriteSyncDestinationsAzureKvNameRequest | null, ignoreDiscriminator?: boolean): any;
