/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface SystemWriteManagedKeysTypeNameRequest
 */
export interface SystemWriteManagedKeysTypeNameRequest {
    /**
     * Access key for authenticating to AWS
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    accessKey?: string;
    /**
     * The signature algorithm to use with this key
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    algorithm?: string;
    /**
     * If true, allows users of the key to trigger key generation. If false and generation is needed, it will fail.
     * @type {boolean}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    allowGenerateKey?: boolean;
    /**
     * If true, allows users of the key to provide key material which may replace keys that were previously present. allow_store_key being false overrides this behavior.
     * @type {boolean}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    allowReplaceKey?: boolean;
    /**
     * If true, allows users of the key to provide key material where none was present.
     * @type {boolean}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    allowStoreKey?: boolean;
    /**
     * If true, this key may be accessed by any mount without the mount's allowed_manage_keys field being set.
     * @type {boolean}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    anyMount?: boolean;
    /**
     * The client ID for credentials to invoke the Azure APIs.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    clientId?: string;
    /**
     * The client secret for credentials to invoke the Azure APIs.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    clientSecret?: string;
    /**
     * The path for the GCP credential file
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    credentials?: string;
    /**
     * The name of the key in GCP Cloud KMS
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    cryptoKey?: string;
    /**
     * The key version of an existing key in GCP Cloud KMS
     * @type {number}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    cryptoKeyVersion?: number;
    /**
     * For ECDSA keys, the desired elliptic curve if the key is to be generated, either P256, P384, or P521.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    curve?: string;
    /**
     * The AWS endpoint to use
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    endpoint?: string;
    /**
     * The Azure Cloud environment API endpoints to use.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    environment?: string;
    /**
     * If true, forces read/write sessions on the HSM, to work around some buggy HSMs.
     * @type {boolean}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    forceRwSession?: boolean;
    /**
     * The desired key length in bits if the RSA key is to be generated, either 2048, 3072, or 4096.
     * @type {number}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    keyBitsDashed?: number;
    /**
     * For RSA keys, the desired key length in bits if the key is to be generated, either 2048, 3072, or 4096.
     * @type {number}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    keyBits?: number;
    /**
     * The id of a PKCS#11 key to use. As key ids are created by the HSM, it is an error if the key does not yet exist. This value or key_label must be specified.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    keyId?: string;
    /**
     * The label of a PKCS#11 key to use. If the key does not exist and generation is enabled, this is the label that will be given to the generated key. This value or key_id must be specified.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    keyLabel?: string;
    /**
     * The name of the Azure Key Vault Key.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    keyName?: string;
    /**
     * The name of the key ring in GCP Cloud KMS
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    keyRing?: string;
    /**
     * The type of the Azure Key Vault Key. Currently only `RSA-HSM` is supported.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    keyType?: string;
    /**
     * An identifier for the AWS KMS key. If the key already exists, this can be either the AWS-generated key ID or an alias. If the key is to be generated and the field is non-empty, the provided value will be used to create an alias for the key.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    kmsKey?: string;
    /**
     * The name of a managed key access library, as defined in the Vault server configuration.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    library?: string;
    /**
     * The maximum number of concurrent operations that may be submitted to the HSM at a time.
     * @type {number}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    maxParallel?: number;
    /**
     * The mechanism for the given key, specified as a decimal or hexadecimal (prefixed by 0x) string.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    mechanism?: string;
    /**
     * The access PIN for the slot.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    pin?: string;
    /**
     * The name of the GCP project
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    project?: string;
    /**
     * The GCP region used for the key ring
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    region?: string;
    /**
     * The Azure Key Vault resource's DNS Suffix to connect to. Needs to be changed to connect to Azure's Managed HSM KeyVault instance type.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    resource?: string;
    /**
     * Secret key ID for authenticating to AWS
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    secretKey?: string;
    /**
     * The slot number to use, specified as a string (e.g. "0").
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    slot?: string;
    /**
     * The tenant ID for the Azure Active Directory organization.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    tenantId?: string;
    /**
     * The slot token label to use.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    tokenLabel?: string;
    /**
     * A comma-delimited list of the allowed usages of this key. Valid values are encrypt, decrypt, sign, verify, wrap, unwrap, mac, and random.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    usages?: string;
    /**
     * The name of an existing Azure Key Vault instance.
     * @type {string}
     * @memberof SystemWriteManagedKeysTypeNameRequest
     */
    vaultName?: string;
}
/**
 * Check if a given object implements the SystemWriteManagedKeysTypeNameRequest interface.
 */
export declare function instanceOfSystemWriteManagedKeysTypeNameRequest(value: object): value is SystemWriteManagedKeysTypeNameRequest;
export declare function SystemWriteManagedKeysTypeNameRequestFromJSON(json: any): SystemWriteManagedKeysTypeNameRequest;
export declare function SystemWriteManagedKeysTypeNameRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SystemWriteManagedKeysTypeNameRequest;
export declare function SystemWriteManagedKeysTypeNameRequestToJSON(json: any): SystemWriteManagedKeysTypeNameRequest;
export declare function SystemWriteManagedKeysTypeNameRequestToJSONTyped(value?: SystemWriteManagedKeysTypeNameRequest | null, ignoreDiscriminator?: boolean): any;
