/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface SshSignCertificateRequest
 */
export interface SshSignCertificateRequest {
    /**
     * Type of certificate to be created; either "user" or "host".
     * @type {string}
     * @memberof SshSignCertificateRequest
     */
    certType?: string;
    /**
     * Critical options that the certificate should be signed for.
     * @type {object}
     * @memberof SshSignCertificateRequest
     */
    criticalOptions?: object;
    /**
     * Extensions that the certificate should be signed for.
     * @type {object}
     * @memberof SshSignCertificateRequest
     */
    extensions?: object;
    /**
     * Key id that the created certificate should have. If not specified, the display name of the token will be used.
     * @type {string}
     * @memberof SshSignCertificateRequest
     */
    keyId?: string;
    /**
     * SSH public key that should be signed.
     * @type {string}
     * @memberof SshSignCertificateRequest
     */
    publicKey?: string;
    /**
     * The requested Time To Live for the SSH certificate; sets the expiration date. If not specified the role default, backend default, or system default TTL is used, in that order. Cannot be later than the role max TTL.
     * @type {string}
     * @memberof SshSignCertificateRequest
     */
    ttl?: string;
    /**
     * Valid principals, either usernames or hostnames, that the certificate should be signed for.
     * @type {string}
     * @memberof SshSignCertificateRequest
     */
    validPrincipals?: string;
}
/**
 * Check if a given object implements the SshSignCertificateRequest interface.
 */
export declare function instanceOfSshSignCertificateRequest(value: object): value is SshSignCertificateRequest;
export declare function SshSignCertificateRequestFromJSON(json: any): SshSignCertificateRequest;
export declare function SshSignCertificateRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SshSignCertificateRequest;
export declare function SshSignCertificateRequestToJSON(json: any): SshSignCertificateRequest;
export declare function SshSignCertificateRequestToJSONTyped(value?: SshSignCertificateRequest | null, ignoreDiscriminator?: boolean): any;
