/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiReadIssuerResponse
 */
export interface PkiReadIssuerResponse {
    /**
     * CA Chain
     * @type {Array<string>}
     * @memberof PkiReadIssuerResponse
     */
    caChain?: Array<string>;
    /**
     * Certificate
     * @type {string}
     * @memberof PkiReadIssuerResponse
     */
    certificate?: string;
    /**
     * CRL Distribution Points
     * @type {Array<string>}
     * @memberof PkiReadIssuerResponse
     */
    crlDistributionPoints?: Array<string>;
    /**
     * Delta CRL Distribution Points
     * @type {Array<string>}
     * @memberof PkiReadIssuerResponse
     */
    deltaCrlDistributionPoints?: Array<string>;
    /**
     * Whether critical extension checks should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiReadIssuerResponse
     */
    disableCriticalExtensionChecks?: boolean;
    /**
     * Whether the issuer name check should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiReadIssuerResponse
     */
    disableNameChecks?: boolean;
    /**
     * Whether name contraint checks shoul be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiReadIssuerResponse
     */
    disableNameConstraintChecks?: boolean;
    /**
     * Whether max path length checks should be performed when issuing certificates. (Enterprise only)
     * @type {boolean}
     * @memberof PkiReadIssuerResponse
     */
    disablePathLengthChecks?: boolean;
    /**
     * Whether or not templating is enabled for AIA fields
     * @type {boolean}
     * @memberof PkiReadIssuerResponse
     */
    enableAiaUrlTemplating?: boolean;
    /**
     * Issuer Id
     * @type {string}
     * @memberof PkiReadIssuerResponse
     */
    issuerId?: string;
    /**
     * Issuer Name
     * @type {string}
     * @memberof PkiReadIssuerResponse
     */
    issuerName?: string;
    /**
     * Issuing Certificates
     * @type {Array<string>}
     * @memberof PkiReadIssuerResponse
     */
    issuingCertificates?: Array<string>;
    /**
     * Key Id
     * @type {string}
     * @memberof PkiReadIssuerResponse
     */
    keyId?: string;
    /**
     * Leaf Not After Behavior
     * @type {string}
     * @memberof PkiReadIssuerResponse
     */
    leafNotAfterBehavior?: string;
    /**
     * Manual Chain
     * @type {Array<string>}
     * @memberof PkiReadIssuerResponse
     */
    manualChain?: Array<string>;
    /**
     * OCSP Servers
     * @type {Array<string>}
     * @memberof PkiReadIssuerResponse
     */
    ocspServers?: Array<string>;
    /**
     * Revocation Signature Alogrithm
     * @type {string}
     * @memberof PkiReadIssuerResponse
     */
    revocationSignatureAlgorithm?: string;
    /**
     * Revocation time
     * @type {number}
     * @memberof PkiReadIssuerResponse
     */
    revocationTime?: number;
    /**
     * Revocation time RFC 3339 formatted
     * @type {string}
     * @memberof PkiReadIssuerResponse
     */
    revocationTimeRfc3339?: string;
    /**
     * Revoked
     * @type {boolean}
     * @memberof PkiReadIssuerResponse
     */
    revoked?: boolean;
    /**
     * Usage
     * @type {string}
     * @memberof PkiReadIssuerResponse
     */
    usage?: string;
}
/**
 * Check if a given object implements the PkiReadIssuerResponse interface.
 */
export declare function instanceOfPkiReadIssuerResponse(value: object): value is PkiReadIssuerResponse;
export declare function PkiReadIssuerResponseFromJSON(json: any): PkiReadIssuerResponse;
export declare function PkiReadIssuerResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiReadIssuerResponse;
export declare function PkiReadIssuerResponseToJSON(json: any): PkiReadIssuerResponse;
export declare function PkiReadIssuerResponseToJSONTyped(value?: PkiReadIssuerResponse | null, ignoreDiscriminator?: boolean): any;
