/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiIssuerSignIntermediateRequest
 */
export interface PkiIssuerSignIntermediateRequest {
    /**
     * The requested Subject Alternative Names, if any, in a comma-delimited list. May contain both DNS names and email addresses.
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    altNames?: string;
    /**
     * The requested common name; if you want more than one, specify the alternative names in the alt_names map. If not specified when signing, the common name will be taken from the CSR; other names must still be specified in alt_names or ip_sans.
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    commonName?: string;
    /**
     * If set, Country will be set to this value.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    country?: Array<string>;
    /**
     * PEM-format CSR to be signed.
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    csr?: string;
    /**
     * Do not truncate the NotAfter field, use the issuer's configured leaf_not_after_behavior
     * @type {boolean}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    enforceLeafNotAfterBehavior?: boolean;
    /**
     * If true, the Common Name will not be included in DNS or Email Subject Alternate Names. Defaults to false (CN is included).
     * @type {boolean}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    excludeCnFromSans?: boolean;
    /**
     * Domains for which this certificate is not allowed to sign or issue child certificates (see https://tools.ietf.org/html/rfc5280#section-4.2.1.10).
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    excludedDnsDomains?: Array<string>;
    /**
     * Email addresses for which this certificate is not allowed to sign or issue child certificates (see https://tools.ietf.org/html/rfc5280#section-4.2.1.10).
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    excludedEmailAddresses?: Array<string>;
    /**
     * IP ranges for which this certificate is not allowed to sign or issue child certificates (see https://tools.ietf.org/html/rfc5280#section-4.2.1.10). Ranges must be specified in the notation of IP address and prefix length, like "192.0.2.0/24" or "2001:db8::/32", as defined in RFC 4632 and RFC 4291.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    excludedIpRanges?: Array<string>;
    /**
     * URI domains for which this certificate is not allowed to sign or issue child certificates (see https://tools.ietf.org/html/rfc5280#section-4.2.1.10).
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    excludedUriDomains?: Array<string>;
    /**
     * Format for returned data. Can be "pem", "der", or "pem_bundle". If "pem_bundle", any private key and issuing cert will be appended to the certificate pem. If "der", the value will be base64 encoded. Defaults to "pem".
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    format?: PkiIssuerSignIntermediateRequestFormatEnum;
    /**
     * The requested IP SANs, if any, in a comma-delimited list
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    ipSans?: Array<string>;
    /**
     * Provide a name to the generated or existing issuer, the name must be unique across all issuers and not be the reserved value 'default'
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    issuerName?: string;
    /**
     * This list of key usages (not extended key usages) will be added to the existing set of key usages, CRL,CertSign, on the generated certificate. Valid values can be found at https://golang.org/pkg/crypto/x509/#KeyUsage -- simply drop the "KeyUsage" part of the name. To use the issuer for CMPv2, DigitalSignature must be set.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    keyUsage?: Array<string>;
    /**
     * If set, Locality will be set to this value.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    locality?: Array<string>;
    /**
     * The maximum allowable path length
     * @type {number}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    maxPathLength?: number;
    /**
     * Set the not after field of the certificate with specified date value. The value format should be given in UTC format YYYY-MM-ddTHH:MM:SSZ
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    notAfter?: string;
    /**
     * The duration before now which the certificate needs to be backdated by.
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    notBeforeDuration?: string;
    /**
     * If set, O (Organization) will be set to this value.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    organization?: Array<string>;
    /**
     * Requested other SANs, in an array with the format <oid>;UTF8:<utf8 string value> for each entry.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    otherSans?: Array<string>;
    /**
     * If set, OU (OrganizationalUnit) will be set to this value.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    ou?: Array<string>;
    /**
     * Domains for which this certificate is allowed to sign or issue child certificates. If set, all DNS names (subject and alt) on child certs must be exact matches or subsets of the given domains (see https://tools.ietf.org/html/rfc5280#section-4.2.1.10).
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    permittedDnsDomains?: Array<string>;
    /**
     * Email addresses for which this certificate is allowed to sign or issue child certificates (see https://tools.ietf.org/html/rfc5280#section-4.2.1.10).
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    permittedEmailAddresses?: Array<string>;
    /**
     * IP ranges for which this certificate is allowed to sign or issue child certificates (see https://tools.ietf.org/html/rfc5280#section-4.2.1.10). Ranges must be specified in the notation of IP address and prefix length, like "192.0.2.0/24" or "2001:db8::/32", as defined in RFC 4632 and RFC 4291.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    permittedIpRanges?: Array<string>;
    /**
     * URI domains for which this certificate is allowed to sign or issue child certificates (see https://tools.ietf.org/html/rfc5280#section-4.2.1.10).
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    permittedUriDomains?: Array<string>;
    /**
     * If set, Postal Code will be set to this value.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    postalCode?: Array<string>;
    /**
     * Format for the returned private key. Generally the default will be controlled by the "format" parameter as either base64-encoded DER or PEM-encoded DER. However, this can be set to "pkcs8" to have the returned private key contain base64-encoded pkcs8 or PEM-encoded pkcs8 instead. Defaults to "der".
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    privateKeyFormat?: PkiIssuerSignIntermediateRequestPrivateKeyFormatEnum;
    /**
     * If set, Province will be set to this value.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    province?: Array<string>;
    /**
     * The Subject's requested serial number, if any. See RFC 4519 Section 2.31 'serialNumber' for a description of this field. If you want more than one, specify alternative names in the alt_names map using OID 2.5.4.5. This has no impact on the final certificate's Serial Number field.
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    serialNumber?: string;
    /**
     * The number of bits to use in the signature algorithm; accepts 256 for SHA-2-256, 384 for SHA-2-384, and 512 for SHA-2-512. Defaults to 0 to automatically detect based on key length (SHA-2-256 for RSA keys, and matching the curve size for NIST P-Curves).
     * @type {number}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    signatureBits?: number;
    /**
     * Value for the Subject Key Identifier field (RFC 5280 Section 4.2.1.2). This value should ONLY be used when cross-signing to mimic the existing certificate's SKID value; this is necessary to allow certain TLS implementations (such as OpenSSL) which use SKID/AKID matches in chain building to restrict possible valid chains. Specified as a string in hex format. Default is empty, allowing Vault to automatically calculate the SKID according to method one in the above RFC section.
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    skid?: string;
    /**
     * If set, Street Address will be set to this value.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    streetAddress?: Array<string>;
    /**
     * The requested Time To Live for the certificate; sets the expiration date. If not specified the role default, backend default, or system default TTL is used, in that order. Cannot be larger than the mount max TTL. Note: this only has an effect when generating a CA cert or signing a CA cert, not when generating a CSR for an intermediate CA.
     * @type {string}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    ttl?: string;
    /**
     * The requested URI SANs, if any, in a comma-delimited list.
     * @type {Array<string>}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    uriSans?: Array<string>;
    /**
     * If true, then: 1) Subject information, including names and alternate names, will be preserved from the CSR rather than using values provided in the other parameters to this path; 2) Any key usages requested in the CSR will be added to the basic set of key usages used for CA certs signed by this path; for instance, the non-repudiation flag; 3) Extensions requested in the CSR will be copied into the issued certificate.
     * @type {boolean}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    useCsrValues?: boolean;
    /**
     * Whether or not to use PSS signatures when using a RSA key-type issuer. Defaults to false.
     * @type {boolean}
     * @memberof PkiIssuerSignIntermediateRequest
     */
    usePss?: boolean;
}
/**
* @export
* @enum {string}
*/
export declare enum PkiIssuerSignIntermediateRequestFormatEnum {
    PEM = "pem",
    DER = "der",
    PEM_BUNDLE = "pem_bundle"
}
/**
* @export
* @enum {string}
*/
export declare enum PkiIssuerSignIntermediateRequestPrivateKeyFormatEnum {
    EMPTY = "",
    DER = "der",
    PEM = "pem",
    PKCS8 = "pkcs8"
}
/**
 * Check if a given object implements the PkiIssuerSignIntermediateRequest interface.
 */
export declare function instanceOfPkiIssuerSignIntermediateRequest(value: object): value is PkiIssuerSignIntermediateRequest;
export declare function PkiIssuerSignIntermediateRequestFromJSON(json: any): PkiIssuerSignIntermediateRequest;
export declare function PkiIssuerSignIntermediateRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiIssuerSignIntermediateRequest;
export declare function PkiIssuerSignIntermediateRequestToJSON(json: any): PkiIssuerSignIntermediateRequest;
export declare function PkiIssuerSignIntermediateRequestToJSONTyped(value?: PkiIssuerSignIntermediateRequest | null, ignoreDiscriminator?: boolean): any;
