/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiConfigureUrlsRequest
 */
export interface PkiConfigureUrlsRequest {
    /**
     * Comma-separated list of URLs to be used for the CRL distribution points attribute. See also RFC 5280 Section 4.2.1.13.
     * @type {Array<string>}
     * @memberof PkiConfigureUrlsRequest
     */
    crlDistributionPoints?: Array<string>;
    /**
     * Comma-separated list of URLs to be used for the Delta CRL distribution points attribute. See also RFC 5280 Section 4.2.1.15.
     * @type {Array<string>}
     * @memberof PkiConfigureUrlsRequest
     */
    deltaCrlDistributionPoints?: Array<string>;
    /**
     * Whether or not to enabling templating of the above AIA fields. When templating is enabled the special values '{{issuer_id}}', '{{cluster_path}}', and '{{cluster_aia_path}}' are available, but the addresses are not checked for URI validity until issuance time. Using '{{cluster_path}}' requires /config/cluster's 'path' member to be set on all PR Secondary clusters and using '{{cluster_aia_path}}' requires /config/cluster's 'aia_path' member to be set on all PR secondary clusters.
     * @type {boolean}
     * @memberof PkiConfigureUrlsRequest
     */
    enableTemplating?: boolean;
    /**
     * Comma-separated list of URLs to be used for the issuing certificate attribute. See also RFC 5280 Section 4.2.2.1.
     * @type {Array<string>}
     * @memberof PkiConfigureUrlsRequest
     */
    issuingCertificates?: Array<string>;
    /**
     * Comma-separated list of URLs to be used for the OCSP servers attribute. See also RFC 5280 Section 4.2.2.1.
     * @type {Array<string>}
     * @memberof PkiConfigureUrlsRequest
     */
    ocspServers?: Array<string>;
}
/**
 * Check if a given object implements the PkiConfigureUrlsRequest interface.
 */
export declare function instanceOfPkiConfigureUrlsRequest(value: object): value is PkiConfigureUrlsRequest;
export declare function PkiConfigureUrlsRequestFromJSON(json: any): PkiConfigureUrlsRequest;
export declare function PkiConfigureUrlsRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiConfigureUrlsRequest;
export declare function PkiConfigureUrlsRequestToJSON(json: any): PkiConfigureUrlsRequest;
export declare function PkiConfigureUrlsRequestToJSONTyped(value?: PkiConfigureUrlsRequest | null, ignoreDiscriminator?: boolean): any;
