/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface GroupCreateRequest
 */
export interface GroupCreateRequest {
    /**
     * ID of the group. If set, updates the corresponding existing group.
     * @type {string}
     * @memberof GroupCreateRequest
     */
    id?: string;
    /**
     * Entity IDs to be assigned as group members.
     * @type {Array<string>}
     * @memberof GroupCreateRequest
     */
    memberEntityIds?: Array<string>;
    /**
     * Group IDs to be assigned as group members.
     * @type {Array<string>}
     * @memberof GroupCreateRequest
     */
    memberGroupIds?: Array<string>;
    /**
     * Metadata to be associated with the group. In CLI, this parameter can be repeated multiple times, and it all gets merged together. For example: vault <command> <path> metadata=key1=value1 metadata=key2=value2
     * @type {object}
     * @memberof GroupCreateRequest
     */
    metadata?: object;
    /**
     * Name of the group.
     * @type {string}
     * @memberof GroupCreateRequest
     */
    name?: string;
    /**
     * Policies to be tied to the group.
     * @type {Array<string>}
     * @memberof GroupCreateRequest
     */
    policies?: Array<string>;
    /**
     * Type of the group, 'internal' or 'external'. Defaults to 'internal'
     * @type {string}
     * @memberof GroupCreateRequest
     */
    type?: string;
}
/**
 * Check if a given object implements the GroupCreateRequest interface.
 */
export declare function instanceOfGroupCreateRequest(value: object): value is GroupCreateRequest;
export declare function GroupCreateRequestFromJSON(json: any): GroupCreateRequest;
export declare function GroupCreateRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): GroupCreateRequest;
export declare function GroupCreateRequestToJSON(json: any): GroupCreateRequest;
export declare function GroupCreateRequestToJSONTyped(value?: GroupCreateRequest | null, ignoreDiscriminator?: boolean): any;
