/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface AzureConfigureRequest
 */
export interface AzureConfigureRequest {
    /**
     * The OAuth2 client id to connect to Azure. This value can also be provided with the AZURE_CLIENT_ID environment variable.
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    clientId?: string;
    /**
     * The OAuth2 client secret to connect to Azure. This value can also be provided with the AZURE_CLIENT_SECRET environment variable.
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    clientSecret?: string;
    /**
     * If set to true, will deregister all registered rotation jobs from the RotationManager for the plugin.
     * @type {boolean}
     * @memberof AzureConfigureRequest
     */
    disableAutomatedRotation?: boolean;
    /**
     * The Azure environment name. If not provided, AzurePublicCloud is used. This value can also be provided with the AZURE_ENVIRONMENT environment variable.
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    environment?: string;
    /**
     * Audience of plugin identity tokens
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    identityTokenAudience?: string;
    /**
     * Time-to-live of plugin identity tokens
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    identityTokenTtl?: string;
    /**
     * The TTL of the root password in Azure. This can be either a number of seconds or a time formatted duration (ex: 24h, 48ds)
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    rootPasswordTtl?: string;
    /**
     * TTL for automatic credential rotation of the given username. Mutually exclusive with rotation_schedule
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    rotationPeriod?: string;
    /**
     * CRON-style string that will define the schedule on which rotations should occur. Mutually exclusive with rotation_period
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    rotationSchedule?: string;
    /**
     * Specifies the amount of time in which the rotation is allowed to occur starting from a given rotation_schedule
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    rotationWindow?: string;
    /**
     * The subscription id for the Azure Active Directory. This value can also be provided with the AZURE_SUBSCRIPTION_ID environment variable.
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    subscriptionId?: string;
    /**
     * The tenant id for the Azure Active Directory. This value can also be provided with the AZURE_TENANT_ID environment variable.
     * @type {string}
     * @memberof AzureConfigureRequest
     */
    tenantId?: string;
}
/**
 * Check if a given object implements the AzureConfigureRequest interface.
 */
export declare function instanceOfAzureConfigureRequest(value: object): value is AzureConfigureRequest;
export declare function AzureConfigureRequestFromJSON(json: any): AzureConfigureRequest;
export declare function AzureConfigureRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): AzureConfigureRequest;
export declare function AzureConfigureRequestToJSON(json: any): AzureConfigureRequest;
export declare function AzureConfigureRequestToJSONTyped(value?: AzureConfigureRequest | null, ignoreDiscriminator?: boolean): any;
