/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface AliCloudWriteAuthRoleRequest
 */
export interface AliCloudWriteAuthRoleRequest {
    /**
     * ARN of the RAM to bind to this role.
     * @type {string}
     * @memberof AliCloudWriteAuthRoleRequest
     */
    arn?: string;
    /**
     * Use "token_bound_cidrs" instead. If this and "token_bound_cidrs" are both specified, only "token_bound_cidrs" will be used.
     * @type {Array<string>}
     * @memberof AliCloudWriteAuthRoleRequest
     * @deprecated
     */
    boundCidrs?: Array<string>;
    /**
     * Use "token_max_ttl" instead. If this and "token_max_ttl" are both specified, only "token_max_ttl" will be used.
     * @type {string}
     * @memberof AliCloudWriteAuthRoleRequest
     * @deprecated
     */
    maxTtl?: string;
    /**
     * Use "token_period" instead. If this and "token_period" are both specified, only "token_period" will be used.
     * @type {string}
     * @memberof AliCloudWriteAuthRoleRequest
     * @deprecated
     */
    period?: string;
    /**
     * Use "token_policies" instead. If this and "token_policies" are both specified, only "token_policies" will be used.
     * @type {Array<string>}
     * @memberof AliCloudWriteAuthRoleRequest
     * @deprecated
     */
    policies?: Array<string>;
    /**
     * Comma separated string or JSON list of CIDR blocks. If set, specifies the blocks of IP addresses which are allowed to use the generated token.
     * @type {Array<string>}
     * @memberof AliCloudWriteAuthRoleRequest
     */
    tokenBoundCidrs?: Array<string>;
    /**
     * If set, tokens created via this role carry an explicit maximum TTL. During renewal, the current maximum TTL values of the role and the mount are not checked for changes, and any updates to these values will have no effect on the token being renewed.
     * @type {string}
     * @memberof AliCloudWriteAuthRoleRequest
     */
    tokenExplicitMaxTtl?: string;
    /**
     * The maximum lifetime of the generated token
     * @type {string}
     * @memberof AliCloudWriteAuthRoleRequest
     */
    tokenMaxTtl?: string;
    /**
     * If true, the 'default' policy will not automatically be added to generated tokens
     * @type {boolean}
     * @memberof AliCloudWriteAuthRoleRequest
     */
    tokenNoDefaultPolicy?: boolean;
    /**
     * The maximum number of times a token may be used, a value of zero means unlimited
     * @type {number}
     * @memberof AliCloudWriteAuthRoleRequest
     */
    tokenNumUses?: number;
    /**
     * If set, tokens created via this role will have no max lifetime; instead, their renewal period will be fixed to this value. This takes an integer number of seconds, or a string duration (e.g. "24h").
     * @type {string}
     * @memberof AliCloudWriteAuthRoleRequest
     */
    tokenPeriod?: string;
    /**
     * Comma-separated list of policies
     * @type {Array<string>}
     * @memberof AliCloudWriteAuthRoleRequest
     */
    tokenPolicies?: Array<string>;
    /**
     * The initial ttl of the token to generate
     * @type {string}
     * @memberof AliCloudWriteAuthRoleRequest
     */
    tokenTtl?: string;
    /**
     * The type of token to generate, service or batch
     * @type {string}
     * @memberof AliCloudWriteAuthRoleRequest
     */
    tokenType?: string;
    /**
     * Use "token_ttl" instead. If this and "token_ttl" are both specified, only "token_ttl" will be used.
     * @type {string}
     * @memberof AliCloudWriteAuthRoleRequest
     * @deprecated
     */
    ttl?: string;
}
/**
 * Check if a given object implements the AliCloudWriteAuthRoleRequest interface.
 */
export declare function instanceOfAliCloudWriteAuthRoleRequest(value: object): value is AliCloudWriteAuthRoleRequest;
export declare function AliCloudWriteAuthRoleRequestFromJSON(json: any): AliCloudWriteAuthRoleRequest;
export declare function AliCloudWriteAuthRoleRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): AliCloudWriteAuthRoleRequest;
export declare function AliCloudWriteAuthRoleRequestToJSON(json: any): AliCloudWriteAuthRoleRequest;
export declare function AliCloudWriteAuthRoleRequestToJSONTyped(value?: AliCloudWriteAuthRoleRequest | null, ignoreDiscriminator?: boolean): any;
