/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface TransitImportKeyRequest
 */
export interface TransitImportKeyRequest {
    /**
     * Enables taking a backup of the named key in plaintext format. Once set, this cannot be disabled.
     * @type {boolean}
     * @memberof TransitImportKeyRequest
     */
    allowPlaintextBackup?: boolean;
    /**
     * True if the imported key may be rotated within Vault; false otherwise.
     * @type {boolean}
     * @memberof TransitImportKeyRequest
     */
    allowRotation?: boolean;
    /**
     * Amount of time the key should live before being automatically rotated. A value of 0 (default) disables automatic rotation for the key.
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    autoRotatePeriod?: string;
    /**
     * The base64-encoded ciphertext of the keys. The AES key should be encrypted using OAEP with the wrapping key and then concatenated with the import key, wrapped by the AES key.
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    ciphertext?: string;
    /**
     * Base64 encoded context for key derivation. When reading a key with key derivation enabled, if the key type supports public keys, this will return the public key for the given context.
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    context?: string;
    /**
     * Enables key derivation mode. This allows for per-transaction unique keys for encryption operations.
     * @type {boolean}
     * @memberof TransitImportKeyRequest
     */
    derived?: boolean;
    /**
     * Enables keys to be exportable. This allows for all the valid keys in the key ring to be exported.
     * @type {boolean}
     * @memberof TransitImportKeyRequest
     */
    exportable?: boolean;
    /**
     * The hash function used as a random oracle in the OAEP wrapping of the user-generated, ephemeral AES key. Can be one of "SHA1", "SHA224", "SHA256" (default), "SHA384", or "SHA512"
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    hashFunction?: string;
    /**
     * The plaintext PEM public key to be imported. If "ciphertext" is set, this field is ignored.
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    publicKey?: string;
    /**
     * The type of key being imported. Currently, "aes128-gcm96" (symmetric), "aes256-gcm96" (symmetric), "ecdsa-p256" (asymmetric), "ecdsa-p384" (asymmetric), "ecdsa-p521" (asymmetric), "ed25519" (asymmetric), "rsa-2048" (asymmetric), "rsa-3072" (asymmetric), "rsa-4096" (asymmetric), "ml-dsa-44 (asymmetric)", "ml-dsa-65 (asymmetric)", "ml-dsa-87 (asymmetric)", "hmac", "aes128-cmac", "aes256-cmac" are supported. Defaults to "aes256-gcm96".
     * @type {string}
     * @memberof TransitImportKeyRequest
     */
    type?: string;
}
/**
 * Check if a given object implements the TransitImportKeyRequest interface.
 */
export declare function instanceOfTransitImportKeyRequest(value: object): value is TransitImportKeyRequest;
export declare function TransitImportKeyRequestFromJSON(json: any): TransitImportKeyRequest;
export declare function TransitImportKeyRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): TransitImportKeyRequest;
export declare function TransitImportKeyRequestToJSON(json: any): TransitImportKeyRequest;
export declare function TransitImportKeyRequestToJSONTyped(value?: TransitImportKeyRequest | null, ignoreDiscriminator?: boolean): any;
