/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface TotpCreateKeyRequest
 */
export interface TotpCreateKeyRequest {
    /**
     * The name of the account associated with the key. Required if generate is true.
     * @type {string}
     * @memberof TotpCreateKeyRequest
     */
    accountName?: string;
    /**
     * The hashing algorithm used to generate the TOTP token. Options include SHA1, SHA256 and SHA512.
     * @type {string}
     * @memberof TotpCreateKeyRequest
     */
    algorithm?: string;
    /**
     * The number of digits in the generated TOTP token. This value can either be 6 or 8.
     * @type {number}
     * @memberof TotpCreateKeyRequest
     */
    digits?: number;
    /**
     * Determines if a QR code and url are returned upon generating a key. Only used if generate is true.
     * @type {boolean}
     * @memberof TotpCreateKeyRequest
     */
    exported?: boolean;
    /**
     * Determines if a key should be generated by Vault or if a key is being passed from another service.
     * @type {boolean}
     * @memberof TotpCreateKeyRequest
     */
    generate?: boolean;
    /**
     * The name of the key's issuing organization. Required if generate is true.
     * @type {string}
     * @memberof TotpCreateKeyRequest
     */
    issuer?: string;
    /**
     * The shared master key used to generate a TOTP token. Only used if generate is false.
     * @type {string}
     * @memberof TotpCreateKeyRequest
     */
    key?: string;
    /**
     * Determines the size in bytes of the generated key. Only used if generate is true.
     * @type {number}
     * @memberof TotpCreateKeyRequest
     */
    keySize?: number;
    /**
     * The length of time used to generate a counter for the TOTP token calculation.
     * @type {string}
     * @memberof TotpCreateKeyRequest
     */
    period?: string;
    /**
     * The pixel size of the generated square QR code. Only used if generate is true and exported is true. If this value is 0, a QR code will not be returned.
     * @type {number}
     * @memberof TotpCreateKeyRequest
     */
    qrSize?: number;
    /**
     * The number of delay periods that are allowed when validating a TOTP token. This value can either be 0 or 1. Only used if generate is true.
     * @type {number}
     * @memberof TotpCreateKeyRequest
     */
    skew?: number;
    /**
     * A TOTP url string containing all of the parameters for key setup. Only used if generate is false.
     * @type {string}
     * @memberof TotpCreateKeyRequest
     */
    url?: string;
}
/**
 * Check if a given object implements the TotpCreateKeyRequest interface.
 */
export declare function instanceOfTotpCreateKeyRequest(value: object): value is TotpCreateKeyRequest;
export declare function TotpCreateKeyRequestFromJSON(json: any): TotpCreateKeyRequest;
export declare function TotpCreateKeyRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): TotpCreateKeyRequest;
export declare function TotpCreateKeyRequestToJSON(json: any): TotpCreateKeyRequest;
export declare function TotpCreateKeyRequestToJSONTyped(value?: TotpCreateKeyRequest | null, ignoreDiscriminator?: boolean): any;
