/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface SystemWriteSyncDestinationsGcpSmNameRequest
 */
export interface SystemWriteSyncDestinationsGcpSmNameRequest {
    /**
     * Sets which IPv4 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    allowedIpv4Addresses?: Array<string>;
    /**
     * Sets which IPv6 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    allowedIpv6Addresses?: Array<string>;
    /**
     * Sets which port numbers Vault is allowed to connect through for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    allowedPorts?: Array<string>;
    /**
     * GCP IAM service account credentials JSON string to access the secret manager
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    credentials?: string;
    /**
     * Custom tags to set on the secret managed at the destination. Custom tags are merged with system tags.
     * @type {object}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    customTags?: object;
    /**
     * Allows all IP addresses and ports to be connected to for syncing secrets.
     * @type {boolean}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    disableStrictNetworking?: boolean;
    /**
     * The encryption key resource name when using global, automatic replications. Mutually exclusive with locational_kms_keys.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    globalKmsKey?: string;
    /**
     * Determines what level of information is synced as a distinct resource at the destination. Supports `secret-path` and `secret-key`.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    granularity?: string;
    /**
     * A list of pairs of replication locations and user-managed encryption keys. For each pair, the key is the location name and the value is the encryption key resource name. When specifying 'replication_locations', the encryption key resource must be located within the same region. When using multiple 'replication_locations', a key name is required for each one.
     * @type {object}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    locationalKmsKeys?: object;
    /**
     * The target project to manage secrets in. If set, overrides the project derived from the service account JSON credentials or application default credentials. The credentials must be authorized to perform actions in the target project.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    projectId?: string;
    /**
     * Asynchronously unsyncs all associated secrets with the destination then deletes the destination config.
     * @type {boolean}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    purge?: boolean;
    /**
     * The names of the allowed locations for secrets to be replicated into. Secrets are still globally accessible regardless of their selected locations.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    replicationLocations?: Array<string>;
    /**
     * Template describing how to generate external secret names. Supports a subset of the Go Template syntax.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    secretNameTemplate?: string;
    /**
     * List of custom tags to remove for patch requests. This field is ignored on create and update requests.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsGcpSmNameRequest
     */
    tagsToRemove?: Array<string>;
}
/**
 * Check if a given object implements the SystemWriteSyncDestinationsGcpSmNameRequest interface.
 */
export declare function instanceOfSystemWriteSyncDestinationsGcpSmNameRequest(value: object): value is SystemWriteSyncDestinationsGcpSmNameRequest;
export declare function SystemWriteSyncDestinationsGcpSmNameRequestFromJSON(json: any): SystemWriteSyncDestinationsGcpSmNameRequest;
export declare function SystemWriteSyncDestinationsGcpSmNameRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SystemWriteSyncDestinationsGcpSmNameRequest;
export declare function SystemWriteSyncDestinationsGcpSmNameRequestToJSON(json: any): SystemWriteSyncDestinationsGcpSmNameRequest;
export declare function SystemWriteSyncDestinationsGcpSmNameRequestToJSONTyped(value?: SystemWriteSyncDestinationsGcpSmNameRequest | null, ignoreDiscriminator?: boolean): any;
