/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface SystemWriteSyncDestinationsAwsSmNameRequest
 */
export interface SystemWriteSyncDestinationsAwsSmNameRequest {
    /**
     * AWS access key ID to access the secrets manager.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    accessKeyId?: string;
    /**
     * Sets which IPv4 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    allowedIpv4Addresses?: Array<string>;
    /**
     * Sets which IPv6 addresses Vault is allowed to connect to for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    allowedIpv6Addresses?: Array<string>;
    /**
     * Sets which port numbers Vault is allowed to connect through for syncing secrets.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    allowedPorts?: Array<string>;
    /**
     * Custom tags to set on the secret managed at the destination. Custom tags are merged with system tags.
     * @type {object}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    customTags?: object;
    /**
     * Allows all IP addresses and ports to be connected to for syncing secrets.
     * @type {boolean}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    disableStrictNetworking?: boolean;
    /**
     * Unique string used as a condition for extra security when assuming the AWS IAM role. Optional. Ignored if the role ARN is not set.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    externalId?: string;
    /**
     * Determines what level of information is synced as a distinct resource at the destination. Supports `secret-path` and `secret-key`.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    granularity?: string;
    /**
     * Asynchronously unsyncs all associated secrets with the destination then deletes the destination config.
     * @type {boolean}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    purge?: boolean;
    /**
     * AWS region where to manage secrets.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    region?: string;
    /**
     * AWS IAM role identifier Vault will assume when connecting to the Secrets Manager. Optional. Supports cross-account access.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    roleArn?: string;
    /**
     * AWS secret access key to access the secrets manager.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    secretAccessKey?: string;
    /**
     * Template describing how to generate external secret names. Supports a subset of the Go Template syntax.
     * @type {string}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    secretNameTemplate?: string;
    /**
     * List of custom tags to remove for patch requests. This field is ignored on create and update requests.
     * @type {Array<string>}
     * @memberof SystemWriteSyncDestinationsAwsSmNameRequest
     */
    tagsToRemove?: Array<string>;
}
/**
 * Check if a given object implements the SystemWriteSyncDestinationsAwsSmNameRequest interface.
 */
export declare function instanceOfSystemWriteSyncDestinationsAwsSmNameRequest(value: object): value is SystemWriteSyncDestinationsAwsSmNameRequest;
export declare function SystemWriteSyncDestinationsAwsSmNameRequestFromJSON(json: any): SystemWriteSyncDestinationsAwsSmNameRequest;
export declare function SystemWriteSyncDestinationsAwsSmNameRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): SystemWriteSyncDestinationsAwsSmNameRequest;
export declare function SystemWriteSyncDestinationsAwsSmNameRequestToJSON(json: any): SystemWriteSyncDestinationsAwsSmNameRequest;
export declare function SystemWriteSyncDestinationsAwsSmNameRequestToJSONTyped(value?: SystemWriteSyncDestinationsAwsSmNameRequest | null, ignoreDiscriminator?: boolean): any;
