/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface RadiusConfigureRequest
 */
export interface RadiusConfigureRequest {
    /**
     * Number of seconds before connect times out (default: 10)
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    dialTimeout?: string;
    /**
     * RADIUS server host
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    host?: string;
    /**
     * RADIUS NAS Identifier field (optional)
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    nasIdentifier?: string;
    /**
     * RADIUS NAS port field (default: 10)
     * @type {number}
     * @memberof RadiusConfigureRequest
     */
    nasPort?: number;
    /**
     * RADIUS server port (default: 1812)
     * @type {number}
     * @memberof RadiusConfigureRequest
     */
    port?: number;
    /**
     * Number of seconds before response times out (default: 10)
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    readTimeout?: string;
    /**
     * Secret shared with the RADIUS server
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    secret?: string;
    /**
     * Comma separated string or JSON list of CIDR blocks. If set, specifies the blocks of IP addresses which are allowed to use the generated token.
     * @type {Array<string>}
     * @memberof RadiusConfigureRequest
     */
    tokenBoundCidrs?: Array<string>;
    /**
     * If set, tokens created via this role carry an explicit maximum TTL. During renewal, the current maximum TTL values of the role and the mount are not checked for changes, and any updates to these values will have no effect on the token being renewed.
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    tokenExplicitMaxTtl?: string;
    /**
     * The maximum lifetime of the generated token
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    tokenMaxTtl?: string;
    /**
     * If true, the 'default' policy will not automatically be added to generated tokens
     * @type {boolean}
     * @memberof RadiusConfigureRequest
     */
    tokenNoDefaultPolicy?: boolean;
    /**
     * The maximum number of times a token may be used, a value of zero means unlimited
     * @type {number}
     * @memberof RadiusConfigureRequest
     */
    tokenNumUses?: number;
    /**
     * If set, tokens created via this role will have no max lifetime; instead, their renewal period will be fixed to this value. This takes an integer number of seconds, or a string duration (e.g. "24h").
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    tokenPeriod?: string;
    /**
     * Comma-separated list of policies. This will apply to all tokens generated by this auth method, in addition to any configured for specific users.
     * @type {Array<string>}
     * @memberof RadiusConfigureRequest
     */
    tokenPolicies?: Array<string>;
    /**
     * The initial ttl of the token to generate
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    tokenTtl?: string;
    /**
     * The type of token to generate, service or batch
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    tokenType?: string;
    /**
     * Comma-separated list of policies to grant upon successful RADIUS authentication of an unregistered user (default: empty)
     * @type {string}
     * @memberof RadiusConfigureRequest
     */
    unregisteredUserPolicies?: string;
}
/**
 * Check if a given object implements the RadiusConfigureRequest interface.
 */
export declare function instanceOfRadiusConfigureRequest(value: object): value is RadiusConfigureRequest;
export declare function RadiusConfigureRequestFromJSON(json: any): RadiusConfigureRequest;
export declare function RadiusConfigureRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): RadiusConfigureRequest;
export declare function RadiusConfigureRequestToJSON(json: any): RadiusConfigureRequest;
export declare function RadiusConfigureRequestToJSONTyped(value?: RadiusConfigureRequest | null, ignoreDiscriminator?: boolean): any;
