/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface PkiConfigureExternalPolicyResponse
 */
export interface PkiConfigureExternalPolicyResponse {
    /**
     * Whether the external validation engine is enabled at all for this mount
     * @type {boolean}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    enabled?: boolean;
    /**
     * A JMESPath search string that will extract the entity meta data to be sent to the CIEPS service. If blank, none of the entity metadata will be sent to the service.
     * @type {string}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    entityJmespath?: string;
    /**
     * Timestamp of the last update of the external policy engine configuration, (empty if never configured)
     * @type {string}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    externalServiceLastUpdated?: string;
    /**
     * The URL where the external policy service is accessible to vault
     * @type {string}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    externalServiceUrl?: string;
    /**
     * Has the current user configuration been successfully used since the last update
     * @type {boolean}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    externalServiceValidated?: boolean;
    /**
     * A JMESPath search string that will extract the entity group information to be sent to the CIEPS service. If blank, none of the group entity metadata will be sent to the service.
     * @type {string}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    groupJmespath?: string;
    /**
     * Timestamp of the last successful request with the policy engine (empty if no request has succeeded on this mount)
     * @type {string}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    lastSuccessfulRequest?: string;
    /**
     * This is how long any particular request should wait for a timeout
     * @type {string}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    timeout?: string;
    /**
     * If this is set, vault will trust any leaf-certificate issued by this certificate to be the external policy service
     * @type {string}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    trustedCa?: string;
    /**
     * This is the PEM of the leaf certificate(s) that vault will expect to do certificate pinning
     * @type {string}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    trustedLeafCertificateBundle?: string;
    /**
     * The vault client certificate used to authenticate vault to the external policy engine
     * @type {string}
     * @memberof PkiConfigureExternalPolicyResponse
     */
    vaultClientCertBundleNoKeys?: string;
}
/**
 * Check if a given object implements the PkiConfigureExternalPolicyResponse interface.
 */
export declare function instanceOfPkiConfigureExternalPolicyResponse(value: object): value is PkiConfigureExternalPolicyResponse;
export declare function PkiConfigureExternalPolicyResponseFromJSON(json: any): PkiConfigureExternalPolicyResponse;
export declare function PkiConfigureExternalPolicyResponseFromJSONTyped(json: any, ignoreDiscriminator: boolean): PkiConfigureExternalPolicyResponse;
export declare function PkiConfigureExternalPolicyResponseToJSON(json: any): PkiConfigureExternalPolicyResponse;
export declare function PkiConfigureExternalPolicyResponseToJSONTyped(value?: PkiConfigureExternalPolicyResponse | null, ignoreDiscriminator?: boolean): any;
