/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface OidcProviderAuthorizeWithParametersRequest
 */
export interface OidcProviderAuthorizeWithParametersRequest {
    /**
     * The ID of the requesting client.
     * @type {string}
     * @memberof OidcProviderAuthorizeWithParametersRequest
     */
    clientId: string;
    /**
     * The code challenge derived from the code verifier.
     * @type {string}
     * @memberof OidcProviderAuthorizeWithParametersRequest
     */
    codeChallenge?: string;
    /**
     * The method that was used to derive the code challenge. The following methods are supported: 'S256', 'plain'. Defaults to 'plain'.
     * @type {string}
     * @memberof OidcProviderAuthorizeWithParametersRequest
     */
    codeChallengeMethod?: string;
    /**
     * The allowable elapsed time in seconds since the last time the end-user was actively authenticated.
     * @type {number}
     * @memberof OidcProviderAuthorizeWithParametersRequest
     */
    maxAge?: number;
    /**
     * The value that will be returned in the ID token nonce claim after a token exchange.
     * @type {string}
     * @memberof OidcProviderAuthorizeWithParametersRequest
     */
    nonce?: string;
    /**
     * The redirection URI to which the response will be sent.
     * @type {string}
     * @memberof OidcProviderAuthorizeWithParametersRequest
     */
    redirectUri: string;
    /**
     * The OIDC authentication flow to be used. The following response types are supported: 'code'
     * @type {string}
     * @memberof OidcProviderAuthorizeWithParametersRequest
     */
    responseType: string;
    /**
     * A space-delimited, case-sensitive list of scopes to be requested. The 'openid' scope is required.
     * @type {string}
     * @memberof OidcProviderAuthorizeWithParametersRequest
     */
    scope: string;
    /**
     * The value used to maintain state between the authentication request and client.
     * @type {string}
     * @memberof OidcProviderAuthorizeWithParametersRequest
     */
    state?: string;
}
/**
 * Check if a given object implements the OidcProviderAuthorizeWithParametersRequest interface.
 */
export declare function instanceOfOidcProviderAuthorizeWithParametersRequest(value: object): value is OidcProviderAuthorizeWithParametersRequest;
export declare function OidcProviderAuthorizeWithParametersRequestFromJSON(json: any): OidcProviderAuthorizeWithParametersRequest;
export declare function OidcProviderAuthorizeWithParametersRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): OidcProviderAuthorizeWithParametersRequest;
export declare function OidcProviderAuthorizeWithParametersRequestToJSON(json: any): OidcProviderAuthorizeWithParametersRequest;
export declare function OidcProviderAuthorizeWithParametersRequestToJSONTyped(value?: OidcProviderAuthorizeWithParametersRequest | null, ignoreDiscriminator?: boolean): any;
