/**
 * HashiCorp Vault API
 * HTTP API that gives you full access to Vault. All API routes are prefixed with `/v1/`.
 *
 * The version of the OpenAPI document: 1.20.0
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
/**
 *
 * @export
 * @interface JwtWriteRoleRequest
 */
export interface JwtWriteRoleRequest {
    /**
     * Comma-separated list of allowed values for redirect_uri
     * @type {Array<string>}
     * @memberof JwtWriteRoleRequest
     */
    allowedRedirectUris?: Array<string>;
    /**
     * Comma-separated list of 'aud' claims that are valid for login; any match is sufficient
     * @type {Array<string>}
     * @memberof JwtWriteRoleRequest
     */
    boundAudiences?: Array<string>;
    /**
     * Use "token_bound_cidrs" instead. If this and "token_bound_cidrs" are both specified, only "token_bound_cidrs" will be used.
     * @type {Array<string>}
     * @memberof JwtWriteRoleRequest
     * @deprecated
     */
    boundCidrs?: Array<string>;
    /**
     * Map of claims/values which must match for login
     * @type {object}
     * @memberof JwtWriteRoleRequest
     */
    boundClaims?: object;
    /**
     * How to interpret values in the map of claims/values (which must match for login): allowed values are 'string' or 'glob'
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    boundClaimsType?: string;
    /**
     * The 'sub' claim that is valid for login. Optional.
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    boundSubject?: string;
    /**
     * Mappings of claims (key) that will be copied to a metadata field (value)
     * @type {object}
     * @memberof JwtWriteRoleRequest
     */
    claimMappings?: object;
    /**
     * Duration in seconds of leeway when validating all claims to account for clock skew. Defaults to 60 (1 minute) if set to 0 and can be disabled if set to -1.
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    clockSkewLeeway?: string;
    /**
     * Duration in seconds of leeway when validating expiration of a token to account for clock skew. Defaults to 150 (2.5 minutes) if set to 0 and can be disabled if set to -1.
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    expirationLeeway?: string;
    /**
     * The claim to use for the Identity group alias names
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    groupsClaim?: string;
    /**
     * Specifies the allowable elapsed time in seconds since the last time the user was actively authenticated.
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    maxAge?: string;
    /**
     * Use "token_max_ttl" instead. If this and "token_max_ttl" are both specified, only "token_max_ttl" will be used.
     * @type {string}
     * @memberof JwtWriteRoleRequest
     * @deprecated
     */
    maxTtl?: string;
    /**
     * Duration in seconds of leeway when validating not before values of a token to account for clock skew. Defaults to 150 (2.5 minutes) if set to 0 and can be disabled if set to -1.
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    notBeforeLeeway?: string;
    /**
     * Use "token_num_uses" instead. If this and "token_num_uses" are both specified, only "token_num_uses" will be used.
     * @type {number}
     * @memberof JwtWriteRoleRequest
     * @deprecated
     */
    numUses?: number;
    /**
     * Comma-separated list of OIDC scopes
     * @type {Array<string>}
     * @memberof JwtWriteRoleRequest
     */
    oidcScopes?: Array<string>;
    /**
     * Use "token_period" instead. If this and "token_period" are both specified, only "token_period" will be used.
     * @type {string}
     * @memberof JwtWriteRoleRequest
     * @deprecated
     */
    period?: string;
    /**
     * Use "token_policies" instead. If this and "token_policies" are both specified, only "token_policies" will be used.
     * @type {Array<string>}
     * @memberof JwtWriteRoleRequest
     * @deprecated
     */
    policies?: Array<string>;
    /**
     * Type of the role, either 'jwt' or 'oidc'.
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    roleType?: string;
    /**
     * Comma separated string or JSON list of CIDR blocks. If set, specifies the blocks of IP addresses which are allowed to use the generated token.
     * @type {Array<string>}
     * @memberof JwtWriteRoleRequest
     */
    tokenBoundCidrs?: Array<string>;
    /**
     * If set, tokens created via this role carry an explicit maximum TTL. During renewal, the current maximum TTL values of the role and the mount are not checked for changes, and any updates to these values will have no effect on the token being renewed.
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    tokenExplicitMaxTtl?: string;
    /**
     * The maximum lifetime of the generated token
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    tokenMaxTtl?: string;
    /**
     * If true, the 'default' policy will not automatically be added to generated tokens
     * @type {boolean}
     * @memberof JwtWriteRoleRequest
     */
    tokenNoDefaultPolicy?: boolean;
    /**
     * The maximum number of times a token may be used, a value of zero means unlimited
     * @type {number}
     * @memberof JwtWriteRoleRequest
     */
    tokenNumUses?: number;
    /**
     * If set, tokens created via this role will have no max lifetime; instead, their renewal period will be fixed to this value. This takes an integer number of seconds, or a string duration (e.g. "24h").
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    tokenPeriod?: string;
    /**
     * Comma-separated list of policies
     * @type {Array<string>}
     * @memberof JwtWriteRoleRequest
     */
    tokenPolicies?: Array<string>;
    /**
     * The initial ttl of the token to generate
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    tokenTtl?: string;
    /**
     * The type of token to generate, service or batch
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    tokenType?: string;
    /**
     * Use "token_ttl" instead. If this and "token_ttl" are both specified, only "token_ttl" will be used.
     * @type {string}
     * @memberof JwtWriteRoleRequest
     * @deprecated
     */
    ttl?: string;
    /**
     * The claim to use for the Identity entity alias name
     * @type {string}
     * @memberof JwtWriteRoleRequest
     */
    userClaim?: string;
    /**
     * If true, the user_claim value will use JSON pointer syntax for referencing claims.
     * @type {boolean}
     * @memberof JwtWriteRoleRequest
     */
    userClaimJsonPointer?: boolean;
    /**
     * Log received OIDC tokens and claims when debug-level logging is active. Not recommended in production since sensitive information may be present in OIDC responses.
     * @type {boolean}
     * @memberof JwtWriteRoleRequest
     */
    verboseOidcLogging?: boolean;
}
/**
 * Check if a given object implements the JwtWriteRoleRequest interface.
 */
export declare function instanceOfJwtWriteRoleRequest(value: object): value is JwtWriteRoleRequest;
export declare function JwtWriteRoleRequestFromJSON(json: any): JwtWriteRoleRequest;
export declare function JwtWriteRoleRequestFromJSONTyped(json: any, ignoreDiscriminator: boolean): JwtWriteRoleRequest;
export declare function JwtWriteRoleRequestToJSON(json: any): JwtWriteRoleRequest;
export declare function JwtWriteRoleRequestToJSONTyped(value?: JwtWriteRoleRequest | null, ignoreDiscriminator?: boolean): any;
